# HTML Server Example

In this subdirectory, you will find an example HTML server. There are several
configurations you can run to see how they work.

## Normal mode

If you just run with `dub`, you will get the standard diet-ng build for the
templates. This build uses the diet-ng compiler to build the dynamically
generated code. Changing the view template during runtime does not alter the
produced page, as the view file is not reprocessed.

## Live Mode

Using `dub --config=dietLive` will build this project in "live" mode. In live
mode, changes to the template only related to HTML will be rendered without a
recompile. Any string interpolations or D code escapes must remain the same, as
changing these items would require a recompile of the server.

Note that live mode is intended for development purposes to avoid a full
compile cycle for front-end changes. It will not perform as well as the normal
build, and it requires access to the views directory to display any templates.

## Cached mode

Using `dub --config=dietCache` will build this project in "cached" mode. On the
first execution of this build, the mixin generated by the compiler is cached
inside the views directory. Upon supsequent builds, as long as the template
source has not changed, the cached version is used.

This is much faster as the library does not need to build the DOM of the diet
file at compile time and process it.

Please see the main README file inside the diet-ng project for more information
about these features.
