/*
 * dhcpcd-qt
 * Copyright 2014-2017 Roy Marples <roy@marples.name>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/stat.h>
#include <sys/file.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <string>

#include "dhcpcd.h"
#include "dhcpcd-singleton.h"

using namespace std;

DhcpcdSingleton::DhcpcdSingleton()
{

	fd = -1;
}

DhcpcdSingleton::~DhcpcdSingleton()
{

}

bool DhcpcdSingleton::lock()
{
	string file;
	const char *display;

	file = DHCPCD_TMP_DIR;
	file += "-";
	file += getlogin();
	if (mkdir(file.c_str(), DHCPCD_TMP_DIR_PERM) == -1 &&
	    errno != EEXIST)
	{
		fprintf(stderr, "dhcpcd-qt: mkdir: %s: %s\n",
		    file.c_str(), strerror(errno));
		return false;
	}

	file += "/dhcpcd-qt";
	display = getenv("DISPLAY");
	if (display && *display != '\0' && strchr(display, '/') == NULL) {
		file += '.';
		file += display;
	}
	file += ".lock";
	fd = open(file.c_str(), O_WRONLY | O_CREAT | O_NONBLOCK, 0664);
	if (fd == -1) {
		fprintf(stderr, "dhcpcd-qt: open: %s: %s\n",
		    file.c_str(), strerror(errno));
		return false;
	}
	if (flock(fd, LOCK_EX | LOCK_NB) == -1) {
		if (errno == EAGAIN)
			fprintf(stderr, "dhcpcd-qt: already running\n");
		else
			fprintf(stderr, "dhcpcd-qt: flock: %s: %s\n",
			    file.c_str(), strerror(errno));
		return false;
	}
	return true;
}
