#!/bin/bash
set -e

pkg_name="deepnano"
test_required_pkg="deepnano-data"

if [ "$AUTOPKGTEST_TMP" = "" ] ; then
  AUTOPKGTEST_TMP=$(mktemp -d /tmp/${pkg}-test.XXXXXX)
  trap "rm -rf $AUTOPKGTEST_TMP" 0 INT QUIT ABRT PIPE TERM
fi

cp -a /usr/share/${test_required_pkg}/* $AUTOPKGTEST_TMP
mkdir -p $AUTOPKGTEST_TMP/test_data/
cp -a /usr/share/poretools/data/* $AUTOPKGTEST_TMP/test_data/

cd $AUTOPKGTEST_TMP
find . -name "*gz" -exec gunzip \{\} \;
#echo '!!!!!!!!!!'
#ls -R
echo -e "\n#1 - deepnano_basecall"
OMP_NUM_THREADS=`nproc` deepnano_basecall test_data/*
cat output.fasta

echo -e "\n#2 - deepnano_basecall_no_metrichor"
OMP_NUM_THREADS=`nproc` deepnano_basecall_no_metrichor test_data/*

echo "PASS"
