#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "transformation.hpp"

#include "control_file.hpp"

#include "transformations.hpp"

namespace {

class per_pkg_build_depends_transformation :
	public transformation
{
public:
	virtual ~per_pkg_build_depends_transformation(void) throw() { }
	virtual void operator()(control_file &) const;
};

void per_pkg_build_depends_transformation::operator()(control_file &control) const
{
	source_section &source = control.source();
	for(control_file::binary_iterator i = control.binaries_begin();
			i != control.binaries_end(); ++i)
	{
		if(!(i->optional || i->bootstrap))
		{
			source.build_depends += i->build_depends;
			source.build_depends_tools += i->build_depends_tools;
			source.build_depends_indep += i->build_depends_indep;
		}
		i->build_depends.clear();
		i->build_depends_tools.clear();
		i->build_depends_indep.clear();
	}
	return;
}

}

transformation const &transform_per_pkg_build_depends = per_pkg_build_depends_transformation();
