//
// C++ Implementation: transferlistmodel
//
// Description: 
//
//
// Author: Rikard Björklind <olof@linux.nu>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtCore>
#include "transferlistmodel.h"
#include <iostream>
#include "util.h"
#include "log.h"
using namespace std;

QVariant TransferListModel::data ( const QModelIndex & index, int role ) const
{
	if(!index.isValid()) return QVariant();
	if(index.row() < 0 || index.row() >= transfers.size()) return QVariant();
	if(index.column() < 0 || index.column() >= NUM_COLUMNS) return QVariant();
	if(role == Qt::DisplayRole) {
		int i = index.row();
		switch(index.column()) {
			/*
			case 0:                return transfers[i].pos;
			case 1:                return transfers[i].startpos;
			case 2:                return transfers[i].actual;
			case 3:                return transfers[i].size;
			case 4:                return transfers[i].averageSpeed;
			case 5:                return transfers[i].secondsLeft;
			case 6:                return transfers[i].bytesLeft;
			case 7:                return transfers[i].filename;
			case 8:                return transfers[i].localfilename;
			*/
			case COL_USER:         return transfers[i].userid;
			case COL_FILE_NAME:    return transfers[i].filename;
			case COL_SIZE_LEFT:    return Util::bytesToStr(transfers[i].bytesLeft);
			case COL_SIZE_TOTAL:   return Util::bytesToStr(transfers[i].size);
			case COL_AVG_SPEED:    return Util::bytesToStr(transfers[i].averageSpeed);
			case COL_STATUS:          return transfers[i].status;
			case COL_PROGRESS_BAR: {
				QList<QVariant> pdata;
				// Data position in the QList must match its index in the eProgressData enum.
				// This silly-looking loop populates the QList in the correct order.
				for (int ii=0; ii<PDATA_MAX_INDEX; ii++) {
					switch (ii) {
					case PDATA_IS_DOWNLOAD:
						pdata.append( transfers[i].type == FileTransfer::DOWNLOAD ); break;
					case PDATA_START_POS:
						pdata.append( static_cast<qlonglong>(transfers[i].startpos) ); break;
					case PDATA_POS:
						pdata.append( static_cast<qlonglong>(transfers[i].pos) ); break;
					case PDATA_ACTUAL:
						pdata.append( static_cast<qlonglong>(transfers[i].actual) ); break;
					case PDATA_SIZE:
						pdata.append( static_cast<qlonglong>(transfers[i].size) ); break;
					case PDATA_SECONDS_LEFT:
						pdata.append( transfers[i].secondsLeft); break;
					default:
						break;
					}
				}
				return pdata;
			}
			default:
				break;
		}
	}
	return QVariant();
}

QVariant TransferListModel::headerData ( int section, Qt::Orientation orientation, int role ) const
{
    if (role != Qt::DisplayRole)
        return QVariant();

    if(orientation==Qt::Horizontal) {
		switch(section) {
		case COL_USER:         return tr("User");
		case COL_FILE_NAME:    return tr("File");
		case COL_PROGRESS_BAR: return tr("Progress");
		case COL_SIZE_LEFT:    return tr("Size left");
		case COL_SIZE_TOTAL:   return tr("Total size");
		case COL_AVG_SPEED:    return tr("Avg. Speed");
		case COL_STATUS:          return tr("Status");
		default:
			break;
		}
		/*
		if(section==0) return "Position";
		if(section==1) return "StartPos";
		if(section==2) return "Actual";
		if(section==3) return "Size";
		if(section==4) return "AvgSpeed";
		if(section==5) return "TimeLeft";
		if(section==6) return "BytesLeft";
		if(section==7) return "Filename";
		if(section==8) return "Localname";
		*/
    }
    return QVariant();
}

void TransferListModel::onTransferStart( const FileTransfer& f )
{
	logger->debug(f.toString());
	if( !transfers.contains(f) ) transfers.append(f);
	emit layoutChanged();
}

void TransferListModel::onTransferTick( const QList<FileTransfer>& fl)
{
	//logger->debug("TransferListModel::onTransferTick");
	int minIndex=2000000000;
	int maxIndex=0;
	bool newItems = false;
	
	for(int i=0;i < fl.size();i++) {
		if( !transfers.contains( fl[i] ) ) {
			transfers.append(fl[i]);
			newItems=true;
		}
		else {
			int ind = transfers.indexOf(fl[i]);
			transfers[ind] = fl[i];
			if(ind < minIndex) minIndex=ind;
			if(ind > maxIndex) maxIndex=ind;
		}
    }
	if(newItems) emit layoutChanged();
	if(maxIndex>=minIndex) emit dataChanged(createIndex(minIndex,0),createIndex(maxIndex,NUM_COLUMNS-1));
}

void TransferListModel::onTransferComplete( const FileTransfer& f)
{
	logger->info(QString("Transfer complete: ") + f.toString());
	transfers.removeAll( f );
	emit layoutChanged();
}

void TransferListModel::onTransferFailed( const FileTransfer& f, const QString& errorMsg)
{
	logger->error("Transfer failed: " + errorMsg);
	logger->info(f.toString());
	//transfers.removeAll( f );
	
	// Mark as failed, update status message field.
	int i = transfers.indexOf( f );
	if( i != -1 ) {
		transfers[i].status = errorMsg;
	}
	
	emit layoutChanged();
}

