#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "ui_mainwindow.h"
#include "backendconnection.h"
#include "settingsdialog.h"
#include "commandhandlers.h"
#include "sessionmanager.h"
#include "searchmanager.h"
#include "globalusermodel.h"
#include "queuemodel.h"
#include "finishedmodel.h"
#include "transferlistmodel.h"
#include "userfilemodel.h"

#include <QMainWindow>
#include <QPointer>
#include <boost/shared_ptr.hpp>
#include <rpcdriver.h>

class ConnectDialog;
class QLabel;

using namespace ui_cmd_handlers;

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    MainWindow();
    virtual ~MainWindow();

    /**
    * Connects to the backend. TODO add code for connecting to another instance when already connected 
    */
    bool connectToBackend(const char* hostname,int port);

	public slots:
	/**
	* Connects to the backend using local settings.
	*/
	void connectToBackend();
	
protected:
    virtual void closeEvent(QCloseEvent*);

private:
    Ui::MainWindow ui;
	QLabel *shareStatusLbl;
	boost::shared_ptr<BackendConnection> backendConnection;
	QPointer<SettingsDialog> settingsDialog;
	QPointer<SessionManager> sessionManager;
	QPointer<SearchManager> searchManager;
	QPointer<ConnectDialog> connectDialog;
	QPointer<QueueModel> queueModel;
	QPointer<FinishedModel> finishedModel;
	QPointer<TransferListModel> transferModel;
				
    boost::shared_ptr< rpc::RpcClientDriver > driver;
	boost::shared_ptr< GlobalUserModel > userModel;
	
	int backendRetriesLeft;
	
	//! Registers the command handlers	
	void registerCommandHandlers();

	QString password;
	
private slots:
    void on_actionConnect_triggered();
	void on_actionSettings_triggered();
	void on_actionSearch_triggered();
	void on_actionForceAttempt_triggered();
	void on_actionCancelDownload_triggered();
	void userFileListing( const UserFileModelPtr& model );
	void onDisconnectPressed();
	void updateTotalShareStatus(qint64);
	void onQueueContextMenu(const QPoint&);
};

#endif
