/*
 *  commandhandlers.cpp
 *  backend
 *
 *  Created by Mikael Gransell on 2/28/06.
 *  Copyright 2006 __MyCompanyName__. All rights reserved.
 *
 */

#include "commandhandlers.h"

#include "SessionManager.h"
#include "ShareManager.h"
#include "TransferManager.h"
#include "QueueManager.h"
#include "RpcArgumentFactory.h"
#include "SettingsMapper.h"
#include "log.h"

#include <iostream>
#include <boost/thread/recursive_mutex.hpp>

using namespace std;

namespace dcqt_backend
{
	

void AuthenticateCmdHandler::handleCommand(int clientId, const std::list<boost::any>& params)
{
	cout << "authenticate" << endl;
	// Check if clientid is allowed to authenticate
	time_t currt = time(NULL);
	if( clientAccessMap.find(clientId)==clientAccessMap.end() ) clientAccessMap[clientId] = currt;
	else {
		time_t lastAttempt = clientAccessMap[clientId];
		if( currt - lastAttempt < 2 ) {
			logger->warn( boost::format("Authenticate: client rejected (too many tries in too short time)"));
			return;
		}
	}
	
	try{
		string p = boost::any_cast<string>(params.front());
	
		if(p==password) {
			// register clientId as an authenticated client.
			driver->setClientAuthenticated(clientId,true);
			logger->info( boost::format("Authenticate: login success" ));
		}
		else {
			// Wrong password, do something clever here maybe.
			logger->warn( boost::format("Authenticate: wrong password"));
		}
	}
	catch(const boost::bad_any_cast& e) {}
}
	
void TestBoolHandler::handleCommand(int cid,const list<boost::any>& params) {
	bool b = boost::any_cast<bool>(params.front());
	cout << "bool: " << b << endl;
}

void CreateSessionCmdHandler::handleCommand(int clientId,
											const list<boost::any>& params)
{
	try {
		// Params inly include the url that we should connect to
		string url = boost::any_cast<string>(params.front());
		SessionManager::instance()->createSession(url);
	}
	catch( const boost::bad_any_cast& e ) {
		cout << "Invalid params to createSession. " << e.what() << endl;
	}
}


void CloseSessionCmdHandler::handleCommand(int clientId,
										   const list<boost::any>& params)
{
	try {
		int sessionId = boost::any_cast<int>(params.front());
		SessionManager::instance()->closeSession(sessionId);
	}
	catch( const boost::bad_any_cast& e ) {
		cout << "Invalid param to closeSession. " << e.what() << endl;
	}
}

void RequestRunningSessionsCmdHandler::handleCommand(int clientId,
													 const list<boost::any>& params)
{
	try {
		// Will contain the shares
		rpc::CmdPtr cmd( new list<boost::any> );
		cmd->push_back( string("runningSessions") );
		
		list< boost::any > sessionList;
				
		//SessionManager::instance()->aquireLock();
		boost::recursive_mutex::scoped_lock sl(SessionManager::instance()->sessionLock);
		map<int,Session*> *sm = SessionManager::instance()->getSessionMap();
		
		map<int,Session*>::iterator it = sm->begin();
		int index = 0;
		while(it != sm->end() ) {
			Session *session = it->second;
			
			list<boost::any> sessionInfo;
			
			sessionInfo.push_back(session->getId());
			sessionInfo.push_back(session->getHubName());
			sessionInfo.push_back(session->getUrl());
			
			list<boost::any> userList;
			hash_set<int>* users = session->getUsers();
            hash_set<int>::iterator userit= users->begin();
            while(userit!=users->end()) {
				int userId = (*userit);
				dcqt_backend::User& u = SessionManager::instance()->getUserPtrMap()[SessionManager::instance()->getUserIdMap()[userId]];
				userList.push_back(rpc_argument::createUser(u));
				userit++;
            }
			
            sessionInfo.push_back(userList);
			
            sessionList.push_back(sessionInfo);
			
            index++;
            it++;
		} // end building session list
		//SessionManager::instance()->releaseLock();
		
		// Build the queue list
		list<boost::any> queueList;
		QueueItem::StringMap& queue = QueueManager::getInstance()->lockQueue();
		for(QueueItem::StringMap::iterator it=queue.begin();it!=queue.end();it++) {
			QueueItem* item = it->second;
			int itemId = TransferManager::getInstance()->queueItemIds.getId(item);
			queueList.push_back( rpc_argument::createQueueItem( item, itemId ));
		}
		QueueManager::getInstance()->unlockQueue();
		
		// Add the two lists
		cmd->push_back( sessionList );
		cmd->push_back( queueList );
		
		// Send the info back to the client that requested it
		cmdSenderMethod( clientId, cmd );
	}
	catch( const boost::bad_any_cast& ce ) {
		cout << "Invalid params to search. " << ce.what() << endl;
	}
	catch( const boost::bad_function_call& fe ) {
		cout << "Invalid sender method set" << fe.what() << endl;
	}	
}


void SendPasswordCmdHandler::handleCommand(int clientId,
										   const list<boost::any>& params)
{
	try {
		list<boost::any>::const_iterator it = params.begin();
		
		int sessionId = boost::any_cast<int>(*it);
		++it;
		string pass = boost::any_cast<string>(*it);
		
		Session* session = SessionManager::instance()->getSession(sessionId);
		if( session != NULL ) {
			session->password(pass);
		}
		else {
			cout << "Invalid session id(" << sessionId << ")" << endl;
		}
	}
	catch( const boost::bad_any_cast& e ) {
		cout << "Invalid param to sendChat. " << e.what() << endl;
	}	
}


void SendChatCmdHandler::handleCommand(int clientId,
									   const list<boost::any>& params)
{
	try {
		
		list<boost::any>::const_iterator it = params.begin();
		
		int sessionId = boost::any_cast<int>(*it);
		++it;
		string msg = boost::any_cast<string>(*it);
		
		Session* s = SessionManager::instance()->getSession(sessionId);
		if( s != NULL ) {
			s->sendChat(msg);
		}
		else {
			cout << "Invalid session id(" << sessionId << ")" << endl;
		}
	}
	catch( const boost::bad_any_cast& e ) {
		cout << "Invalid param to sendChat. " << e.what() << endl;
	}
}

void SearchCmdHandler::handleCommand(int clientId,
									 const list<boost::any>& params)
{
	try {
		list<boost::any>::const_iterator it = params.begin();
		
		int sessionId = boost::any_cast<int>(*it);
		++it;
		string searchString = boost::any_cast<string>(*it);
		++it;
		int64_t size = boost::any_cast<int64_t>(*it);
		++it;
		int sizeMode = boost::any_cast<int>(*it);
		++it;
		int typeMode = boost::any_cast<int>(*it);
		
		Session* session = SessionManager::instance()->getSession(sessionId);
		if( session != NULL ) {
			// We dont send the token at the moment. Need to find
			// out what it means first
			session->search( sizeMode, size, typeMode, searchString, "" );
		}
		else {
		  //cout << "Invalid session id(" << sessionId << ")"
		  //<< endl;
		  
		  // Since we search all hubs anyway at the moment, we
		  // might as well just search here.
		  map<int,Session*>* arne = SessionManager::instance()->getSessionMap();
		  map<int,Session*>::iterator sit = arne->begin();
		  Session* session = sit->second;
		  session->search(sizeMode, size, typeMode, searchString, "");

		}
	}
	catch( const boost::bad_any_cast& e ) {
		cout << "Invalid params to search. " << e.what() << endl;
	}
}

void GetSharedDirectoriesCmdHandler::handleCommand(int clientId,
												   const list<boost::any>& params)
{
	try {
		// Will contain the shares
		rpc::CmdPtr cmd( new list<boost::any> );
		cmd->push_back( string("sharedDirs") );
		
		list< boost::any > shares;
		
		StringPairList dirs = ShareManager::getInstance()->getDirectories();
		for(StringPairList::iterator it = dirs.begin(); it != dirs.end(); it++) {
			string vdir = it->first;
			string sdir = it->second;
			int64_t size = ShareManager::getInstance()->getShareSize(it->second);
			
			list<boost::any> share;
			share.push_back( vdir );
			share.push_back( sdir );
			share.push_back( size );
			
			shares.push_back(share);
		}
		
		cmd->push_back( shares );
		
		// Send the info back to the client that requested it
		cmdSenderMethod( clientId, cmd );
	}
	catch( const boost::bad_any_cast& ce ) {
		cout << "Invalid params to search. " << ce.what() << endl;
	}
	catch( const boost::bad_function_call& fe ) {
		cout << "Invalid sender method set" << fe.what() << endl;
	}
}

void AddShareCmdHandler::handleCommand(int clientId,
									   const list<boost::any>& params)
{
	try {
		list<boost::any>::const_iterator it = params.begin();
		string name = boost::any_cast<string>(*it);
		++it;
		string dir = boost::any_cast<string>(*it);
		
		ShareManager::getInstance()->addDirectory(dir,name);
	}
	catch( const ShareException& se ) {
		cout << "Could not add share. " << se.getError() << endl;
	}
	catch( const boost::bad_any_cast& ce ) {
		cout << "Invalid params to addShare. " << ce.what() << endl;
	}
}

void RemoveShareCmdHandler::handleCommand(int clientId,
										  const list<boost::any>& params)
{
	try {
		string name = boost::any_cast<string>(params.front());
		
		ShareManager::getInstance()->removeDirectory(name);
	}
	catch( const boost::bad_any_cast& ce ) {
		cout << "Invalid params to removeShare. " << ce.what() << endl;
	}	
}

void DownloadFileCmdHandler::handleCommand(int clientId,
										   const list<boost::any>& params)
{
	try {
		list<boost::any>::const_iterator it = params.begin();
		string file = boost::any_cast<string>(*it);
		++it;
		int64_t size = boost::any_cast<int64_t>(*it);
		++it;
		int userid = boost::any_cast<int>(*it);
		++it;
		string dir = boost::any_cast<string>(*it);
		++it;
		string tth = boost::any_cast<string>(*it);
		
		//SessionManager::instance()->aquireLock();
		boost::recursive_mutex::scoped_lock sl(SessionManager::instance()->sessionLock);
		TransferManager::getInstance()->downloadFile(file,size,userid,dir,tth);
		//SessionManager::instance()->releaseLock();
	}
	catch( const boost::bad_any_cast& ce ) {
		cout << "Invalid params to downloadFile. " << ce.what() << endl;
	}	
}

void GetUserFileListCmdHandler::handleCommand(int clientId,
											  const list<boost::any>& params)
{
	try {
		int userId = boost::any_cast<int>(params.front());
		//SessionManager::instance()->aquireLock();
		boost::recursive_mutex::scoped_lock sl(SessionManager::instance()->sessionLock);
		TransferManager::getInstance()->getUserFileList( userId );
		//SessionManager::instance()->releaseLock();
	}
	catch( const boost::bad_any_cast& ce ) {
		cout << "Invalid params to getUserFileList. " << ce.what() << endl;
	}
}

void GetHubListCmdHandler::handleCommand(int clientId,
										 const list<boost::any>& params)
{
	try {
		bool refresh = boost::any_cast<bool>(params.front());
		if( !refresh ) {
			
			rpc::CmdPtr cmd( new list<boost::any> );
			cmd->push_back( string("newHubList") );
						
			cmd->push_back( rpc_argument::createHubList(SessionManager::instance()->getPublicHubs()) );
			
			// Send the info back to the client that requested it
			cmdSenderMethod( clientId, cmd );
		}
		else {
			SessionManager::instance()->refreshHublist();				
		}
	}
	catch( const boost::bad_function_call& fe ) {
		cout << "Invalid sender method set" << fe.what() << endl;
	}
	catch( const boost::bad_any_cast& ce ) {
		cout << "Invalid params to getHubList. " << ce.what() << endl;
	}	
}


void ConnectToUserCmdHandler::handleCommand(int clientId,
											const list<boost::any>& params)
{
	try {
		int userId = boost::any_cast<int>(params.front());
		TransferManager::getInstance()->forceConnect(userId);
	}
	catch( const boost::bad_any_cast& ce ) {
		cout << "Invalid params to connectToUser. " << ce.what() << endl;
	}
}

void RemoveQueueItemCmdHandler::handleCommand(int clientId,
											  const list<boost::any>& params)
{
	try {
		int qid = boost::any_cast<int>(params.front());
		TransferManager::getInstance()->removeQueueItem(qid);
	}
	catch( const boost::bad_any_cast& ce ) {
		cout << "Invalid params to removeQueueItem. " << ce.what() << endl;
	}	
}

void AddFavoriteHubCmdHandler::handleCommand(int clientId,
											 const list<boost::any>& params)
{
	try {
		list<boost::any>::const_iterator it = params.begin();
		
		FavoriteHubEntry he;
		he.setNick(boost::any_cast<string>(*it));
		++it;
		he.setUserDescription(boost::any_cast<string>(*it));
		++it;
		he.setName(boost::any_cast<string>(*it));
		++it;
		he.setServer(boost::any_cast<string>(*it));
		++it;
		he.setDescription(boost::any_cast<string>(*it));
		++it;
		he.setPassword(boost::any_cast<string>(*it));
		++it;
		he.setConnect(boost::any_cast<bool>(*it));
		SessionManager::instance()->addFavouriteHub(he);
	}
	catch( const boost::bad_any_cast& ce ) {
		cout << "Invalid params to addFavouriteHub. " << ce.what() << endl;
	}	
}

void RemoveFavoriteHubCmdHandler::handleCommand(int clientId,
												const list<boost::any>& params)
{
	try {
		string server = boost::any_cast<string>(params.front());
		SessionManager::instance()->removeFavouriteHub(server);
	}
	catch( const boost::bad_any_cast& ce ) {
		cout << "Invalid params to removeFavouriteHub. " << ce.what() << endl;
	}	
}


void GetSettingsHandler::handleCommand(int clientId,const list<boost::any>& params)
{
	try {
	list<boost::any> settings = boost::any_cast< list<boost::any> >(params.front());
	list<boost::any>::const_iterator it = settings.begin();
	list<boost::any> result;

	// Put all requested settings in a result list
	while(it!=settings.end()) {
		result.push_back(SettingsMapper::instance()->getSetting( boost::any_cast<string>(*it) ));
		it++;
	}

	// Send the result back together with the original key list (easier handling on client side)
	rpc::CmdPtr cmd( new list<boost::any> );
	cmd->push_back( string("settingsInfo") );
	cmd->push_back( settings );
	cmd->push_back( result );
	cmdSenderMethod( clientId, cmd );
	}
	catch( const boost::bad_function_call& fe ) {
		cout << "Invalid sender method set" << fe.what() << endl;
	}
	catch( const boost::bad_any_cast& ce ) {
		cout << "Invalid params to getHubList. " << ce.what() << endl;
	}	
}

void SetSettingsHandler::handleCommand( int clientId, const list<boost::any>& params)
{
	try {
	list<boost::any>::const_iterator it = params.begin();
	list<boost::any> keys = boost::any_cast< list<boost::any> >(*it);
	it++;
	list<boost::any> values = boost::any_cast< list<boost::any> >(*it);
	
	it = keys.begin();
	list<boost::any>::const_iterator vit = values.begin();

	while(it!=keys.end()) {
		SettingsMapper::instance()->setSetting(boost::any_cast<string>(*it),*vit);
		it++;
		vit++;
	}
	}
	catch( const boost::bad_any_cast& ce ) {
		cout << "Invalid params to getHubList. " << ce.what() << endl;
	}	
}	

void GetFavHubsHandler::handleCommand( int clientId, const list<boost::any>& params)
{
	try {
	    FavoriteHubEntry::List& favHubs = SessionManager::instance()->getFavouriteHubs();
		list<boost::any> result;    

        for(FavoriteHubEntry::List::iterator it=favHubs.begin();it!=favHubs.end(); it++) 
        {
       		list<boost::any> favStruct;
			favStruct.push_back((*it)->getNick());
            favStruct.push_back((*it)->getUserDescription());
            favStruct.push_back((*it)->getName());
            favStruct.push_back((*it)->getServer());
            favStruct.push_back( (*it)->getDescription());
            favStruct.push_back((*it)->getPassword());
            favStruct.push_back((*it)->getConnect());
			result.push_back(favStruct);
        }
		rpc::CmdPtr cmd( new list<boost::any> );
		cmd->push_back( string("favouriteHubList") );
		cmd->push_back( result );
		cmdSenderMethod( clientId, cmd );
       
	}
	catch( const boost::bad_function_call& fe ) {
		cout << "Invalid sender method set" << fe.what() << endl;
	}
	catch( const boost::bad_any_cast& ce ) {
		cout << "Invalid params to getHubList. " << ce.what() << endl;
	}	

}

void RemoveSourceHandler::handleCommand( int clientId, const list<boost::any>& params)
{
	try {
		list<boost::any>::const_iterator it = params.begin();
		int qid = boost::any_cast<int>(*it);
		it++;
		int uid = boost::any_cast<int>(*it);
		TransferManager::getInstance()->removeSource(qid,uid);
	}
	catch( const boost::bad_any_cast& ce ) {
		cout << "Invalid params to removeSource. " << ce.what() << endl;
	}	

}


void DieCmdHandler::handleCommand( int clientId, const list<boost::any>& params)
{
	cout << "die" << endl;
	driver->stopSender();
}

}