'%B %d, %Y'# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
sys.path.insert(0, os.path.abspath('../src'))

# -- Project information -----------------------------------------------------

project = 'BusKill'
copyright = '2020, Michael Altfield and the BusKill team'
author = 'Michael Altfield and the BusKill Team'

# The short X.Y version
version = ''
# The full version, including alpha/beta/rc tags
release = 'version'


# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
sys.path.insert(0, os.path.abspath('_extensions'))
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.autosummary',
#    'sphinx.ext.intersphinx',
    'sphinx.ext.todo',
    'sphinx.ext.viewcode',
    'sphinx.ext.githubpages',
    'sphinx_rtd_theme',
    'sphinxemoji.sphinxemoji',
    'sphinx.ext.ifconfig',
    'affiliatelinks',
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = 'en'
locale_dirs = ['locale/']
gettext_compact = True

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'
html_logo = '_static/buskill_202007_200px.png'
html_favicon = '_static/favico_150b.202002.png'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = {
	'logo_only': True,
	'display_version': True,
}

# replace "view page source" with "edit on github" in Read The Docs theme
#  * https://github.com/readthedocs/sphinx_rtd_theme/issues/529
html_context = {
	'display_github': True,
	'github_user': 'buskill',
	'github_repo': 'buskill-app',
	'github_version': 'master/docs/',
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}

# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'BusKilldoc'


# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'BusKill.tex', 'BusKill Documentation',
     'BusKill Team', 'manual'),
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'buskill', 'BusKill Documentation',
     [author], 1)
]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'BusKill', 'BusKill Documentation',
     author, 'BusKill', 'One line description of project.',
     'Miscellaneous'),
]


# -- Options for Epub output -------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ['search.html']


# -- Extension configuration -------------------------------------------------

# -- Options for intersphinx extension ---------------------------------------

# Example configuration for intersphinx: refer to the Python standard library.
#intersphinx_mapping = {'https://docs.python.org/': None}

# -- Options for todo extension ----------------------------------------------

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True

# prevent "failed to import module...No module named..." errors on modules that
# we don't need just to build our documentation from the code
autodoc_mock_imports = [ "kivy", "usb1" ]
autodoc_default_flags = ['members']
autodoc_member_order = 'bysource'
autodoc_default_options = {
	'undoc-members': True,
}

############################
# SETUP THE RTD LOWER-LEFT #
############################
html_context['display_lower_left'] = True

from git import Repo
repo = Repo( search_parent_directories=True )

if 'current_version' in os.environ:
	# get the current_version env var set by updatePages.sh
	current_version = os.environ['current_version']
else:
	# the user is probably doing `make html`
	# set this build's current version by looking at the branch
	current_version = repo.active_branch.name

# rename the 'master' bracnh to be version = 'stable'
if current_version == 'master':
	current_version = 'stable'

# tell the theme which version we're currently on ('current_version' affects
# the lower-left rtd menu and 'version' affects the logo-area version)
html_context['current_version'] = current_version
html_context['version'] = current_version

if 'current_language' in os.environ:
	# get the current_language env var set by updatePages.sh
	current_language = os.environ['current_language']
else:
	# the user is probably doing `make html`
	# set this build's current language to english
	current_language = 'en'

html_context['current_language'] = current_language

# POPULATE LINKS TO OTHER LANGUAGES
html_context['languages'] = [ ('en', '/buskill-app/en/' +current_version+ '/') ]

languages = [lang.name for lang in os.scandir('locale') if lang.is_dir()]
for lang in languages:
	html_context['languages'].append( (lang, '/buskill-app/' +lang+ '/' +current_version+ '/') )

# POPULATE LINKS TO OTHER VERSIONS
html_context['versions'] = list()

# get list of remote branches, excluding HEAD and gh-pages
remote_refs = repo.remote().refs
versions = list()
for ref in remote_refs:
	ref = ref.name.split('/')[-1]
	if ref != 'HEAD' and ref != 'gh-pages':
		versions.append( ref )

for version in versions:

	# special override to rename 'master' branch to 'stable'
	if version == 'master':
		version = 'stable'

	html_context['versions'].append( (version, '/buskill-app/' +current_language+ '/' +version+ '/') )

# DOWNLOADS

# settings for creating PDF with rinoh
rinoh_documents = [(
 master_doc,
 'target',
 project+ ' Documentation',
 '© ' +copyright,
)]
rinoh_logo = '_static/buskill_202007_200px.png'
today_fmt = "%B %d, %Y"

# settings for EPUB
epub_basename = 'target'

html_context['downloads'] = list()
html_context['downloads'].append( ('pdf', '/buskill-app/' +current_language+ '/' +current_version+ '/buskill-docs_' +current_language+ '_' +current_version+ '.pdf') )

html_context['downloads'].append( ('epub', '/buskill-app/' +current_language+ '/' +current_version+ '/buskill-docs_' +current_language+ '_' +current_version+ '.epub') )

def setup(app):

	# get the buidername from sys.argv since it's not accessible to conf.py
	# and extensions https://stackoverflow.com/a/63132102/1174102
	if '-b' in sys.argv:
		buildername = ( sys.argv[sys.argv.index('-b')+1] )
	else:
		buildername = ''

	app.add_config_value('buildername', buildername, 'env')
