/*
 * buffy - Mailbox watcher
 *
 * Copyright (C) 2003--2008  Enrico Zini <enrico@enricozini.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#define APPNAME PACKAGE_NAME
#else
#warning No config.h found: using fallback values
#define APPNAME __FILE__
#define PACKAGE_VERSION "unknown"
#endif

#include "Environment.h"
#include "BuffyWindow.h"
#include <wibble/exception.h>
#include <wibble/commandline/parser.h>

#include <gtkmm/main.h>

using namespace std;
using namespace wibble;
using namespace wibble::commandline;

struct Options : public StandardParserWithManpage
{
	BoolOption* verbose;
	BoolOption* debug;

	Options() : StandardParserWithManpage("buffy", PACKAGE_VERSION, 1, PACKAGE_BUGREPORT)
	{
		usage = "";
		description =
			"Mail folder monitor.\n"
			"Monitor new and unread messages in a collection of mail folders.";
		longDescription =
			"Buffy is a program that displays a compact summary of your mail folders, and "
			"allows to invoke a command (usually a mail reader) on them.  It is written "
			"with the intent of being a handy everyday tool for people handling large "
			"volumes of mail.  For mutt users, this can be a nice front-end to supplement "
			"the simple built-in folder browser when one has many folders to keep track of.";
		verbose = add<BoolOption>("verbose", 0, "verbose", "", "enable verbose output");
		debug = add<BoolOption>("debug", 0, "debug", "", "enable debugging output (includes verbose output)");
	}
};

int main(int argc, char* argv[])
{
	Options opts;
	try {
		if (opts.parse(argc, (const char**)argv))
			return 0;

		Environment::init();
		
		if (opts.verbose->boolValue())
			Environment::get().verbose(true);
		if (opts.debug->boolValue())
			Environment::get().debug(true);

		Gtk::Main app(argc, argv);

		// Connect the SIGCHLD pipe to the right signal
		//app.input.connect(Environment::get().signal_child_exit(), Environment::get().get_SIGCHLD_pipe(), Gdk::GTK_INPUT_READ);
		
		BuffyWindow buffyWindow;

		//buffyWindow.rescanFolders();

		Gtk::Main::run(buffyWindow);

		Environment::get().config().save();
		
		return 0;
	} catch (wibble::exception::BadOption& e) {
		cerr << e.desc() << endl;
		opts.outputHelp(cerr);
		return 1;
	} catch (std::exception& e) {
		cerr << e.what() << endl;
		return 1;
	}
}

// vim:set ts=4 sw=4:
