# -----------------------------------------------------------------------------
# source directories
# -----------------------------------------------------------------------------

set(TOOL_DIR ${CMAKE_SOURCE_DIR}/devtools)
set(WRAP_DIR ${CMAKE_SOURCE_DIR}/Wrap)
set(SWIG_DIR ${WRAP_DIR}/Swig)

set(GUI_PROJECTS_DIR            ${CMAKE_SOURCE_DIR}/Tests/GUIprojects)
set(REFERENCE_DIR               ${CMAKE_SOURCE_DIR}/Tests/ReferenceData)
set(REFERENCE_DIR_CORESPECIAL   ${REFERENCE_DIR}/CoreSpecial)
set(REFERENCE_DIR_PY_CORE       ${REFERENCE_DIR}/PyCore)
set(REFERENCE_DIR_MINIEXAMPLES  ${REFERENCE_DIR}/MiniExamples)
set(REFERENCE_DIR_SUITE         ${REFERENCE_DIR}/Suite)

# -----------------------------------------------------------------------------
# auto directories (refreshed when CONFIGURE options are set)
# -----------------------------------------------------------------------------

set(AUTO_WRAP_DIR ${CMAKE_SOURCE_DIR}/auto/Wrap)
set(EXAMPLES_SRC_DIR ${CMAKE_SOURCE_DIR}/rawEx)
set(EXAMPLES_DATA_DIR ${CMAKE_SOURCE_DIR}/testdata)
set(EXAMPLES_PUBL_DIR ${CMAKE_SOURCE_DIR}/auto/Examples)
set(EXAMPLES_TEST_DIR ${CMAKE_SOURCE_DIR}/auto/MiniExamples)

file(MAKE_DIRECTORY ${AUTO_WRAP_DIR})
file(MAKE_DIRECTORY ${EXAMPLES_PUBL_DIR})
file(MAKE_DIRECTORY ${EXAMPLES_TEST_DIR})

# -----------------------------------------------------------------------------
# output directories
# -----------------------------------------------------------------------------

set(CMAKE_LIBRARY_OUTPUT_DIRECTORY         ${CMAKE_BINARY_DIR}/lib)
set(CMAKE_RUNTIME_OUTPUT_DIRECTORY         ${CMAKE_BINARY_DIR}/bin)
set(CMAKE_RUNTIME_OUTPUT_DIRECTORY_DEBUG   ${CMAKE_RUNTIME_OUTPUT_DIRECTORY})
set(CMAKE_RUNTIME_OUTPUT_DIRECTORY_RELEASE ${CMAKE_RUNTIME_OUTPUT_DIRECTORY})

set(BUILD_VAR_DIR ${CMAKE_BINARY_DIR}/var)
set(BUILD_INC_DIR ${CMAKE_BINARY_DIR}/inc)
set(BUILD_SRC_DIR ${CMAKE_BINARY_DIR}/src)

set(TEST_OUTPUT_DIR             ${CMAKE_BINARY_DIR}/test_output)
set(TEST_OUTPUT_DIR_CORE        ${TEST_OUTPUT_DIR}/Core)
set(TEST_OUTPUT_DIR_PY_CORE     ${TEST_OUTPUT_DIR}/PyCore)
set(TEST_OUTPUT_DIR_PY_FIT      ${TEST_OUTPUT_DIR}/PyFit)
set(TEST_OUTPUT_DIR_PY_PERSIST  ${TEST_OUTPUT_DIR}/PyPersist)
set(TEST_OUTPUT_DIR_SUITE       ${TEST_OUTPUT_DIR}/Suite)

configure_file("${CONFIGURABLES_DIR}/auto_README.in.md" "${CMAKE_SOURCE_DIR}/auto/README.md" @ONLY)

file(MAKE_DIRECTORY ${CMAKE_LIBRARY_OUTPUT_DIRECTORY})
file(MAKE_DIRECTORY ${CMAKE_RUNTIME_OUTPUT_DIRECTORY})
file(MAKE_DIRECTORY ${BUILD_VAR_DIR})
file(MAKE_DIRECTORY ${BUILD_INC_DIR})
file(MAKE_DIRECTORY ${BUILD_SRC_DIR})
file(MAKE_DIRECTORY ${TEST_OUTPUT_DIR})

# -----------------------------------------------------------------------------
# file extensions
# -----------------------------------------------------------------------------
set(libprefix _lib)

if(WIN32)
    # under Windows, .pyd files are needed as the Python extension; see
    # <https://docs.python.org/3/faq/windows.html#is-a-pyd-file-the-same-as-a-dll>
    set(libsuffix .pyd)
elseif(APPLE)
    set(libsuffix .so)
else()
    set(libsuffix .so)
endif()

# -----------------------------------------------------------------------------
# destinations
# -----------------------------------------------------------------------------
set(destination_suffix ${CMAKE_PROJECT_NAME}_${CMAKE_PROJECT_VERSION_MAJOR}.${CMAKE_PROJECT_VERSION_MINOR})

set(dstIds "")

if(APPLE AND BA_APPLE_BUNDLE)
    set(destination_bundle BornAgain.app)
    set(destination_root ${destination_bundle}/Contents/)
    list(APPEND dstIds "bundle")
endif()

set(destination_bin ${destination_root}bin/)
set(destination_lib ${destination_root}lib/)
if(WIN32)
    # on Window, the libraries must be in the same folder as the executable
    set(destination_lib ${destination_bin})
endif()
set(destination_include ${destination_root}include/${destination_suffix}/)
set(destination_share ${destination_root}share/${destination_suffix}/)
set(destination_examples ${destination_share}Examples/)
set(destination_images ${destination_share}Images/)
set(destination_man ${destination_share}man/man1)

list(APPEND dstIds bin lib include share examples images man)

message(STATUS "Destination directories:")
foreach(dstId IN LISTS dstIds)
    message("     ${dstId} -> ${destination_${dstId}}")
endforeach()
