//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Resample/Specular/TransitionMagneticTanh.h
//! @brief     Defines namespace TransitionMagneticTanh.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2020
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG
#ifndef BORNAGAIN_RESAMPLE_SPECULAR_TRANSITIONMAGNETICTANH_H
#define BORNAGAIN_RESAMPLE_SPECULAR_TRANSITIONMAGNETICTANH_H

#include <utility> // pair

class MatrixFlux;
class SpinMatrix;

namespace Compute {

std::pair<SpinMatrix, SpinMatrix>
refractionMatrixBlocksTanh(const MatrixFlux& coeff_i, const MatrixFlux& coeff_i1, double sigma);
}

#endif // BORNAGAIN_RESAMPLE_SPECULAR_TRANSITIONMAGNETICTANH_H
