//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/SampleDesigner/ParticleLayoutForm.h
//! @brief     Defines class ParticleLayoutForm
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_PARTICLELAYOUTFORM_H
#define BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_PARTICLELAYOUTFORM_H

#include <QFormLayout>
#include <QGroupBox>
#include <QList>

class DoubleSpinBox;
class GroupBoxCollapser;
class ItemWithParticles;
class LayerForm;
class LayerItem;
class ParticleLayoutItem;
class SampleEditorController;

//! Form for editing a particle layout
class ParticleLayoutForm : public QGroupBox {
    Q_OBJECT
public:
    ParticleLayoutForm(LayerForm* form, ParticleLayoutItem* pLayoutItem,
                       SampleEditorController* ec);

    void enableStructureEditing(bool b);
    ParticleLayoutItem* layoutItem() const;
    void onParticleAdded(ItemWithParticles* item);
    void onAboutToRemoveParticle(ItemWithParticles* item);

    //! Disable/enable total density property depending on type of interference function.
    //!
    //! E.g. 2-dimensional interference calculates density automatically, so
    //! the property shown in the particle layout shall be disabled.
    void updateDensityEnabling();

    //! Update the shown density value.
    //!
    //! This does not update any internal values, it only refreshes the shown value.
    void updateDensityValue();

    void updateTitle(const LayerItem* layerItem);

private:
    QFormLayout* m_layout;
    ParticleLayoutItem* m_layoutItem;
    QAction* m_removeAction;
    QAction* m_duplicateAction;
    SampleEditorController* m_ec;
    QList<QWidget*> m_structureEditingWidgets;
    DoubleSpinBox* m_totalDensitySpinBox;
    GroupBoxCollapser* m_collapser;
};

#endif // BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_PARTICLELAYOUTFORM_H
