//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/SampleDesigner/LayerForm.h
//! @brief     Defines class LayerForm
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_LAYERFORM_H
#define BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_LAYERFORM_H

#include "GUI/View/SampleDesigner/FormLayouter.h"
#include <QGroupBox>
#include <memory>

class GroupBoxCollapser;
class WidgetMoverButton;

//! Form for editing a layer
class LayerForm : public QGroupBox {
    Q_OBJECT
public:
    LayerForm(QWidget* parent, LayerItem* layerItem, SampleEditorController* ec);

    void enableStructureEditing(bool b);
    void updateLayerPositionDependentElements();
    void onLayoutAdded(ParticleLayoutItem* layoutItem);
    void onAboutToRemoveLayout(ParticleLayoutItem* layoutItem);
    LayerItem* layerItem() const;
    void updateTitle();
    void expand();

private:
    void updateColor();

    GroupBoxCollapser* m_collapser;
    std::unique_ptr<FormLayouter> m_layouter;
    LayerItem* m_layer;
    QAction* m_duplicateAction;
    QAction* m_removeAction;
    int m_roughnessRow = -1;
    int m_thicknessRow = -1;
    SampleEditorController* m_ec;
    QList<QWidget*> m_structureEditingWidgets;
    WidgetMoverButton* m_moveButton;
};

#endif // BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_LAYERFORM_H
