//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/PlotComparison/FitComparisonWidget.h
//! @brief     Defines class FitComparisonWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PLOTCOMPARISON_FITCOMPARISONWIDGET_H
#define BORNAGAIN_GUI_VIEW_PLOTCOMPARISON_FITCOMPARISONWIDGET_H

#include "GUI/View/Common/DataAccessWidget.h"

class ColorMapCanvas;
class FitFlowWidget;
class IntensityDataPropertyWidget;
class PlotStatusLabel;
class QAction;

//! Plots realdata, simulated data and relative difference map during the course of the fit.

class FitComparisonWidget : public DataAccessWidget {
    Q_OBJECT
public:
    explicit FitComparisonWidget(QWidget* parent = nullptr);

    void setJobOrRealItem(QObject* job_item) override;

    QList<QAction*> actionList() override;

private:
    void onResetViewAction();
    void connectItems();
    void updateDiffData();

    ColorMapCanvas* m_realCanvas;
    ColorMapCanvas* m_simuCanvas;
    ColorMapCanvas* m_diffCanvas;
    FitFlowWidget* m_fitFlowWidget;
    PlotStatusLabel* m_statusLabel;
    IntensityDataPropertyWidget* m_propertyWidget;

    QAction* m_resetViewAction;
    QAction* m_togglePropertiesAction;
};

#endif // BORNAGAIN_GUI_VIEW_PLOTCOMPARISON_FITCOMPARISONWIDGET_H
