//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Mask/MaskContainerView.h
//! @brief     Defines MaskContainerView class
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_MASK_MASKCONTAINERVIEW_H
#define BORNAGAIN_GUI_VIEW_MASK_MASKCONTAINERVIEW_H

#include "GUI/View/Mask/IShape2DView.h"
#include "GUI/View/Mask/SizeHandleElement.h"
#include <QMap>

class MaskContainerItem;
class ProjectionContainerItem;

//! The MaskContainerView is nothing more than just transparent rectangle to cover axes area
//! of ColorMapPlot inside MaskGraphicsScene. The goal of this rectangle is to hide all MaskViews
//! if they are going outside of ColorMapPlot.
//!
//! The size of the rectangle always matches axes viewport at any zoom level.
//! All MasksViews are added to MaskContainerView as children.

class MaskContainerView : public IShape2DView {
    Q_OBJECT

public:
    int type() const override { return MaskEditorHelper::MASKCONTAINER; }

    explicit MaskContainerView(MaskContainerItem* item);
    explicit MaskContainerView(ProjectionContainerItem* item);

    MaskItemObject* parameterizedItem() const override;

protected slots:
    void update_view() override;

protected:
    void paint(QPainter* painter, const QStyleOptionGraphicsItem*, QWidget*) override;

private:
    MaskContainerItem* m_item;
};

#endif // BORNAGAIN_GUI_VIEW_MASK_MASKCONTAINERVIEW_H
