//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Instrument/GISASInstrumentEditor.h
//! @brief     Defines class GISASInstrumentEditor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_INSTRUMENT_GISASINSTRUMENTEDITOR_H
#define BORNAGAIN_GUI_VIEW_INSTRUMENT_GISASINSTRUMENTEDITOR_H

#include <QWidget>

class GISASInstrumentItem;

/// Editor for GISAS instruments

class GISASInstrumentEditor : public QWidget {
    Q_OBJECT

public:
    GISASInstrumentEditor(QWidget* parent, GISASInstrumentItem* instrument);

signals:
    void dataChanged();
};

#endif // BORNAGAIN_GUI_VIEW_INSTRUMENT_GISASINSTRUMENTEDITOR_H
