//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Import/RealDataSelectorWidget.h
//! @brief     Defines class RealDataSelectorWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_IMPORT_REALDATASELECTORWIDGET_H
#define BORNAGAIN_GUI_VIEW_IMPORT_REALDATASELECTORWIDGET_H

#include <QModelIndex>
#include <QWidget>

class RealDataPropertiesWidget;
class InstrumentModel;
class RealItem;
class RealTreeModel;
class ProjectDocument;

//! The RealDataSelectorWidget represents left panel of ImportDataView. Contains a tree to
//! select data set (m_itemTree & m_treeModel) and properties of currently selected data
//! (RealDataPropertiesWidget).

class RealDataSelectorWidget : public QWidget {
    Q_OBJECT

public:
    RealDataSelectorWidget(QWidget* parent, ProjectDocument* document);

    QSize sizeHint() const override;
    QSize minimumSizeHint() const override;

    RealItem* currentItem();
    void setCurrentItem(RealItem* item);

    void restoreSelection();
signals:
    void selectionChanged(RealItem*);

private:
    void onSelectionChanged();
    void renameCurrentItem();
    void removeCurrentItem();
    void updateActionEnabling();
    void updateActionEnabling(const RealItem* item) const;
    void updateFunctionalities();
    void onContextMenuRequest(const QPoint& point);
    void importData1D();
    void importData2D();
    QModelIndex currentIndex();

    QList<QAction*> getOverlayActions(const QModelIndex& index, bool asHover);

private:
    class QTreeView* m_itemTree;
    RealTreeModel* m_treeModel;
    RealDataPropertiesWidget* m_propertiesWidget;

    ProjectDocument* m_document;

public:
    QAction* m_import1dDataAction;
    QAction* m_import2dDataAction;
    QAction* m_renameDataAction;
    QAction* m_removeDataAction;
};

#endif // BORNAGAIN_GUI_VIEW_IMPORT_REALDATASELECTORWIDGET_H
