//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Util/MessageService.cpp
//! @brief     Implements MessageService class
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Support/Util/MessageService.h"
#include <QObject>

QStringList MessageService::descriptions(const Messages& messages, bool includeSenders) const
{
    QStringList result;

    for (const auto& message : messages)
        if (includeSenders)
            result.push_back(message.first + ": " + message.second);
        else
            result.push_back(message.second);

    return result;
}

void MessageService::addError(QObject* sender, const QString& description)
{
    m_errors.append(qMakePair(sender->objectName(), description));
}

void MessageService::addWarning(QObject* sender, const QString& description)
{
    m_warnings.append(qMakePair(sender->objectName(), description));
}

QStringList MessageService::errors(bool includeSenders /*= false*/) const
{
    return descriptions(m_errors, includeSenders);
}

QStringList MessageService::warnings(bool includeSenders /*= false*/) const
{
    return descriptions(m_warnings, includeSenders);
}
