//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Type/VariantUtil.cpp
//! @brief     Implements namespace SessionItemUtils
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Support/Type/VariantUtil.h"

int GUI::Util::Variant::VariantType(const QVariant& variant)
{
    int result = static_cast<int>(variant.type());
    if (result == QVariant::UserType)
        result = variant.userType();
    return result;
}

bool GUI::Util::Variant::CompatibleVariantTypes(const QVariant& oldValue, const QVariant& newValue)
{
    // if olfValue is undefined then it is compatible with any value, otherwise newValue
    // should have same variant type as oldValue

    if (oldValue.isValid())
        return GUI::Util::Variant::VariantType(oldValue)
               == GUI::Util::Variant::VariantType(newValue);
    return true;
}

// For custom variants (based on e.g. ComboProperty) will always return false, i.e.
// we will rely here on our custom editors.
// This is done to not to register custom comparators in main.cpp.
bool GUI::Util::Variant::IsTheSame(const QVariant& var1, const QVariant& var2)
{
    // variants of different type are always reported as not the same
    if (VariantType(var1) != VariantType(var2))
        return false;

    // custom type variants are always reported as not the same
    if (var1.type() == QVariant::UserType)
        return false;

    // standard variants (based on double, int, etc) are compared by value they are holding
    return var1 == var2;
}
