//  Copyright (c) 2007 John Maddock
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const std::array<std::array<typename table_type<T>::type, 3>, 896> bessel_j_prime_int_data = {{
      {{ SC_(0.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(-8.6532770637826959996036352233123749969269387214742e-07) }}, 
      {{ SC_(0.0), SC_(0.216575062950141727924346923828125e-5), SC_(-1.082875314750073739565916601264494477250584335342e-06) }}, 
      {{ SC_(0.0), SC_(0.72700195232755504548549652099609375e-5), SC_(-3.6350097616137599975154414859780356083927094699044e-06) }}, 
      {{ SC_(0.0), SC_(0.14000004739500582218170166015625e-4), SC_(-7.0000023695787909349097782319695161608515974031987e-06) }}, 
      {{ SC_(0.0), SC_(0.17196454791701398789882659912109375e-4), SC_(-8.5982273955328680071189358596754762829168944805573e-06) }}, 
      {{ SC_(0.0), SC_(0.60085076256655156612396240234375e-4), SC_(-3.0042538114770070369352805041883730188463833118739e-05) }}, 
      {{ SC_(0.0), SC_(0.116783194243907928466796875e-3), SC_(-5.8391597022408593884593798440128797224531413316046e-05) }}, 
      {{ SC_(0.0), SC_(0.149052008055150508880615234375e-3), SC_(-7.4526003820611873275618570638597471453507592073022e-05) }}, 
      {{ SC_(0.0), SC_(0.3985252114944159984588623046875e-3), SC_(-0.00019926260179128875596958527588421993087864972378482) }}, 
      {{ SC_(0.0), SC_(0.63875340856611728668212890625e-3), SC_(-0.00031937668799461078462095468191142199676107353268414) }}, 
      {{ SC_(0.0), SC_(0.10718167759478092193603515625e-2), SC_(-0.00053590831101805319884851555459274406344951933890925) }}, 
      {{ SC_(0.0), SC_(0.302191521041095256805419921875e-2), SC_(-0.0015109558804534016451881641704527805135072146502315) }}, 
      {{ SC_(0.0), SC_(0.499413348734378814697265625e-2), SC_(-0.0024970589586470101824905275711945163368773628504049) }}, 
      {{ SC_(0.0), SC_(0.928423367440700531005859375e-2), SC_(-0.004642066820317960809690683300142997074645281491313) }}, 
      {{ SC_(0.0), SC_(0.241700224578380584716796875e-1), SC_(-0.012084128757582752071806633114629290747504060716828) }}, 
      {{ SC_(0.0), SC_(0.6227754056453704833984375e-1), SC_(-0.031123676287555626763445621624465166512983390930896) }}, 
      {{ SC_(0.0), SC_(0.12234418094158172607421875e0), SC_(-0.061057708094690239849216568742821152478027199712044) }}, 
      {{ SC_(0.0), SC_(0.249557673931121826171875e0), SC_(-0.12380996625346937610523536079167598077197103196986) }}, 
      {{ SC_(0.0), SC_(0.4912221431732177734375e0), SC_(-0.23827696230364644118075077312728350231461010203119) }}, 
      {{ SC_(0.0), SC_(0.98384749889373779296875e0), SC_(-0.43475639303623813062429779786150299582527673276141) }}, 
      {{ SC_(0.0), SC_(0.11576130390167236328125e1), SC_(-0.48711647358966534000543577089846185147646818027478) }}, 
      {{ SC_(0.0), SC_(0.3451677799224853515625e1), SC_(-0.15762889603997323748106344455034261827540551786683) }}, 
      {{ SC_(0.0), SC_(0.788237094879150390625e1), SC_(-0.21620542081836905819230529903303065520772215849306) }}, 
      {{ SC_(0.0), SC_(0.15848876953125e2), SC_(-0.11667862705625529027948213610287110911446401203924) }}, 
      {{ SC_(0.1e1), SC_(0.553809732082299888134002685546875e-4), SC_(0.49999999942492771384298052799916741838663312550992) }}, 
      {{ SC_(0.1e1), SC_(0.69304020144045352935791015625e-4), SC_(0.49999999909942864877671026019948448559391073505058) }}, 
      {{ SC_(0.1e1), SC_(0.23264062474481761455535888671875e-3), SC_(0.499999989852188735328956350002167598643264662455) }}, 
      {{ SC_(0.1e1), SC_(0.4480001516640186309814453125e-3), SC_(0.4999999623679750449477176449410603200324160738515) }}, 
      {{ SC_(0.1e1), SC_(0.5502865533344447612762451171875e-3), SC_(0.49999994322213417259089023157928440742853321097516) }}, 
      {{ SC_(0.1e1), SC_(0.19227224402129650115966796875e-2), SC_(0.4999993068386313094492273235957592720832822921268) }}, 
      {{ SC_(0.1e1), SC_(0.37370622158050537109375e-2), SC_(0.49999738144616366882434596041523913440331476865703) }}, 
      {{ SC_(0.1e1), SC_(0.47696642577648162841796875e-2), SC_(0.49999573443852669879893351364977629482653254035205) }}, 
      {{ SC_(0.1e1), SC_(0.1275280676782131195068359375e-1), SC_(0.4999695064543116179615005455933450595992743509876) }}, 
      {{ SC_(0.1e1), SC_(0.20440109074115753173828125e-1), SC_(0.49992166513677137770546149801804198933612439686551) }}, 
      {{ SC_(0.1e1), SC_(0.3429813683032989501953125e-1), SC_(0.49977945010734455539681970982311210571822507220364) }}, 
      {{ SC_(0.1e1), SC_(0.96701286733150482177734375e-1), SC_(0.49824779974515275629596562012328757837777712137835) }}, 
      {{ SC_(0.1e1), SC_(0.159812271595001220703125e0), SC_(0.49521974412723318199543819892405982808588375931292) }}, 
      {{ SC_(0.1e1), SC_(0.297095477581024169921875e0), SC_(0.48355135938900797260459530698530771097335947319244) }}, 
      {{ SC_(0.1e1), SC_(0.77344071865081787109375e0), SC_(0.39241458162493758561769226797080928696562197564917) }}, 
      {{ SC_(0.1e1), SC_(0.1992881298065185546875e1), SC_(-0.061619737135234892338595043962987165709230453576274) }}, 
      {{ SC_(0.1e1), SC_(0.3915013790130615234375e1), SC_(-0.39290319605920753947168196339228416669899384044269) }}, 
      {{ SC_(0.1e1), SC_(0.79858455657958984375e1), SC_(0.14583141931584640909010319204905863507861999460925) }}, 
      {{ SC_(0.1e1), SC_(0.1571910858154296875e2), SC_(-0.15145963497536240984673974355792878883841231288619) }}, 
      {{ SC_(0.1e1), SC_(0.31483119964599609375e2), SC_(0.10962844908422735210769459538120509525793203962829) }}, 
      {{ SC_(0.4e1), SC_(0.553809732082299888134002685546875e-4), SC_(1.7693368262174888896238964738107003669524226043035e-15) }}, 
      {{ SC_(0.4e1), SC_(0.69304020144045352935791015625e-4), SC_(3.4674008369257558740171674373495893574096907864769e-15) }}, 
      {{ SC_(0.4e1), SC_(0.23264062474481761455535888671875e-3), SC_(1.3115517509420754127960426519126947677168206400723e-13) }}, 
      {{ SC_(0.4e1), SC_(0.4480001516640186309814453125e-3), SC_(9.3661960380495629622137357856869182270416388742532e-13) }}, 
      {{ SC_(0.4e1), SC_(0.5502865533344447612762451171875e-3), SC_(1.7357831132937968817392795017011916501489255871193e-12) }}, 
      {{ SC_(0.4e1), SC_(0.19227224402129650115966796875e-2), SC_(7.4042049494318174815042257132143269722982060199314e-11) }}, 
      {{ SC_(0.4e1), SC_(0.37370622158050537109375e-2), SC_(5.4364988014235539823907985771899239309234261379898e-10) }}, 
      {{ SC_(0.4e1), SC_(0.47696642577648162841796875e-2), SC_(1.1302940848397100770820867105606709545842201552472e-09) }}, 
      {{ SC_(0.4e1), SC_(0.1275280676782131195068359375e-1), SC_(2.1604330248107663969856437007044251758680877766477e-08) }}, 
      {{ SC_(0.4e1), SC_(0.20440109074115753173828125e-1), SC_(8.8953857340211285658972412983716399290248998578182e-08) }}, 
      {{ SC_(0.4e1), SC_(0.3429813683032989501953125e-1), SC_(4.2024449758229269593374321819654716690052660413216e-07) }}, 
      {{ SC_(0.4e1), SC_(0.96701286733150482177734375e-1), SC_(9.4128451032217689955820303821981246359400931484752e-06) }}, 
      {{ SC_(0.4e1), SC_(0.159812271595001220703125e0), SC_(4.2435277297319406236849305446892646307888302002941e-05) }}, 
      {{ SC_(0.4e1), SC_(0.297095477581024169921875e0), SC_(0.00027135599414622583849557151099906031568896387896581) }}, 
      {{ SC_(0.4e1), SC_(0.77344071865081787109375e0), SC_(0.0046069141899053437359811541838758520302589287908814) }}, 
      {{ SC_(0.4e1), SC_(0.1992881298065185546875e1), SC_(0.060443414038447440668824241142946879836025954896153) }}, 
      {{ SC_(0.4e1), SC_(0.3915013790130615234375e1), SC_(0.15177123109875292536846632004847563063080968171939) }}, 
      {{ SC_(0.4e1), SC_(0.79858455657958984375e1), SC_(-0.23997697042213897502842907045349243873435595877447) }}, 
      {{ SC_(0.4e1), SC_(0.1571910858154296875e2), SC_(-0.046434244536118374752598151975883899662991537841961) }}, 
      {{ SC_(0.4e1), SC_(0.31483119964599609375e2), SC_(0.061817833121773152256991292145985522766508528770086) }}, 
      {{ SC_(0.7e1), SC_(0.553809732082299888134002685546875e-4), SC_(3.1305528056638344867972886298683398144497717978537e-31) }}, 
      {{ SC_(0.7e1), SC_(0.69304020144045352935791015625e-4), SC_(1.2022868570255225005663082021429250451610589556921e-30) }}, 
      {{ SC_(0.7e1), SC_(0.23264062474481761455535888671875e-3), SC_(1.7201680056234174117633627993073749000743861640337e-27) }}, 
      {{ SC_(0.7e1), SC_(0.4480001516640186309814453125e-3), SC_(8.7725630156789872544507544600717786563934226961732e-26) }}, 
      {{ SC_(0.7e1), SC_(0.5502865533344447612762451171875e-3), SC_(3.0129431165931594932219997462581141884973596779344e-25) }}, 
      {{ SC_(0.7e1), SC_(0.19227224402129650115966796875e-2), SC_(5.4822273190735084858521264396327901581626026123867e-22) }}, 
      {{ SC_(0.7e1), SC_(0.37370622158050537109375e-2), SC_(2.9555564547986828192440474980580778563804193216626e-20) }}, 
      {{ SC_(0.7e1), SC_(0.47696642577648162841796875e-2), SC_(1.2775679101016136207768793882190641810024614271416e-19) }}, 
      {{ SC_(0.7e1), SC_(0.1275280676782131195068359375e-1), SC_(4.6675542199316705962508761747036734647552595402352e-17) }}, 
      {{ SC_(0.7e1), SC_(0.20440109074115753173828125e-1), SC_(7.9131518097810249614823319782757539044033658685656e-16) }}, 
      {{ SC_(0.7e1), SC_(0.3429813683032989501953125e-1), SC_(1.7662825516489034788084007541693872543504519440663e-14) }}, 
      {{ SC_(0.7e1), SC_(0.96701286733150482177734375e-1), SC_(8.8692699965065814288047066394789611051021386707718e-12) }}, 
      {{ SC_(0.7e1), SC_(0.159812271595001220703125e0), SC_(1.8058122351886366377394875534915789879166056857918e-10) }}, 
      {{ SC_(0.7e1), SC_(0.297095477581024169921875e0), SC_(7.4352089564512688127753904684835081691106045906159e-09) }}, 
      {{ SC_(0.7e1), SC_(0.77344071865081787109375e0), SC_(2.2675758396516885792509849125117055620920179094187e-06) }}, 
      {{ SC_(0.7e1), SC_(0.1992881298065185546875e1), SC_(0.00057831078063158310356878944089232211326153287190001) }}, 
      {{ SC_(0.7e1), SC_(0.3915013790130615234375e1), SC_(0.02041383080666513330673794768788259570924578070728) }}, 
      {{ SC_(0.7e1), SC_(0.79858455657958984375e1), SC_(0.058218571837795162498597237894980109783789726930136) }}, 
      {{ SC_(0.7e1), SC_(0.1571910858154296875e2), SC_(0.12685804245807057661668756481071566358164782614053) }}, 
      {{ SC_(0.7e1), SC_(0.31483119964599609375e2), SC_(-0.14003757925102874842499033050664135459313874273098) }}, 
      {{ SC_(0.1e2), SC_(0.553809732082299888134002685546875e-4), SC_(1.3188100873744963459319007199937751301543239180136e-47) }}, 
      {{ SC_(0.1e2), SC_(0.69304020144045352935791015625e-4), SC_(9.9257391810363605974902541167749060462829253560831e-47) }}, 
      {{ SC_(0.1e2), SC_(0.23264062474481761455535888671875e-3), SC_(5.3716413581512494979533716301487868688806543328621e-42) }}, 
      {{ SC_(0.1e2), SC_(0.4480001516640186309814453125e-3), SC_(1.956322533586782024166087072125245785074691389279e-39) }}, 
      {{ SC_(0.1e2), SC_(0.5502865533344447612762451171875e-3), SC_(1.2451942672168763628696126390467461044008454052638e-38) }}, 
      {{ SC_(0.1e2), SC_(0.19227224402129650115966796875e-2), SC_(9.6646542478716484782923334506270056239127171552634e-34) }}, 
      {{ SC_(0.1e2), SC_(0.37370622158050537109375e-2), SC_(3.8256902023746264329913659088962640909312860291508e-31) }}, 
      {{ SC_(0.1e2), SC_(0.47696642577648162841796875e-2), SC_(3.4381674751993345896927555146196987111289718779677e-30) }}, 
      {{ SC_(0.1e2), SC_(0.1275280676782131195068359375e-1), SC_(2.4009720114206249912516932040726579855824809221431e-26) }}, 
      {{ SC_(0.1e2), SC_(0.20440109074115753173828125e-1), SC_(1.6760267381655761330373404298478901501611023208878e-24) }}, 
      {{ SC_(0.1e2), SC_(0.3429813683032989501953125e-1), SC_(1.7674935377289799535780547690266397443950184066763e-22) }}, 
      {{ SC_(0.1e2), SC_(0.96701286733150482177734375e-1), SC_(1.9893744092640228148907222276440233981950920601486e-18) }}, 
      {{ SC_(0.1e2), SC_(0.159812271595001220703125e0), SC_(1.8286290537911967361002045729606766750322137799336e-16) }}, 
      {{ SC_(0.1e2), SC_(0.297095477581024169921875e0), SC_(4.8412308070674532774125152283321995279577461389754e-14) }}, 
      {{ SC_(0.1e2), SC_(0.77344071865081787109375e0), SC_(2.6223373246818731084792674469888003633557213743021e-10) }}, 
      {{ SC_(0.1e2), SC_(0.1992881298065185546875e1), SC_(1.1965962205338207406958051169038464279159357115114e-06) }}, 
      {{ SC_(0.1e2), SC_(0.3915013790130615234375e1), SC_(0.00037897494764987250758743729715466646906940633334082) }}, 
      {{ SC_(0.1e2), SC_(0.79858455657958984375e1), SC_(0.049967594379099753800075924865486763413481109926599) }}, 
      {{ SC_(0.1e2), SC_(0.1571910858154296875e2), SC_(-0.095219427072112411409532063707164797795149921454385) }}, 
      {{ SC_(0.1e2), SC_(0.31483119964599609375e2), SC_(0.10827196177426450326870338063493299139382686828124) }}, 
      {{ SC_(0.13e2), SC_(0.553809732082299888134002685546875e-4), SC_(2.121290231784798046752709655350864786529832117079e-64) }}, 
      {{ SC_(0.13e2), SC_(0.69304020144045352935791015625e-4), SC_(3.1287742142665779825494951799930785776769478364188e-63) }}, 
      {{ SC_(0.13e2), SC_(0.23264062474481761455535888671875e-3), SC_(6.4047142362327644859103125557956770544745144098238e-57) }}, 
      {{ SC_(0.13e2), SC_(0.4480001516640186309814453125e-3), SC_(1.6657546057789064172662940915913489418437432496399e-53) }}, 
      {{ SC_(0.13e2), SC_(0.5502865533344447612762451171875e-3), SC_(1.9648974865975549363172523443020646242481295483577e-52) }}, 
      {{ SC_(0.13e2), SC_(0.19227224402129650115966796875e-2), SC_(6.5053729474100903943626156527590913198118862808397e-46) }}, 
      {{ SC_(0.13e2), SC_(0.37370622158050537109375e-2), SC_(1.8907621746740377638542092734353671551811946804999e-42) }}, 
      {{ SC_(0.13e2), SC_(0.47696642577648162841796875e-2), SC_(3.5328614364457558638310880096009890316651219791696e-41) }}, 
      {{ SC_(0.13e2), SC_(0.1275280676782131195068359375e-1), SC_(4.7156437468577964105054800545225766621773238117231e-36) }}, 
      {{ SC_(0.13e2), SC_(0.20440109074115753173828125e-1), SC_(1.355401186540478059654562132900988044653696693691e-33) }}, 
      {{ SC_(0.13e2), SC_(0.3429813683032989501953125e-1), SC_(6.753189071873066495943722964871713531830224871692e-31) }}, 
      {{ SC_(0.13e2), SC_(0.96701286733150482177734375e-1), SC_(1.7036345914826787093581881206307044168487995341273e-25) }}, 
      {{ SC_(0.13e2), SC_(0.159812271595001220703125e0), SC_(7.069131202324893987734087462646174032528027700782e-23) }}, 
      {{ SC_(0.13e2), SC_(0.297095477581024169921875e0), SC_(1.2029170744316206314629194819414371536976847699644e-19) }}, 
      {{ SC_(0.13e2), SC_(0.77344071865081787109375e0), SC_(1.1535640591136223328357848970006202726033258192981e-14) }}, 
      {{ SC_(0.13e2), SC_(0.1992881298065185546875e1), SC_(9.2127434442702321702847274180477102959755364382342e-10) }}, 
      {{ SC_(0.13e2), SC_(0.3915013790130615234375e1), SC_(2.3991135775288520979528432073060764051878051022235e-06) }}, 
      {{ SC_(0.13e2), SC_(0.79858455657958984375e1), SC_(0.0042342826820396933200038545046343548491508178374386) }}, 
      {{ SC_(0.13e2), SC_(0.1571910858154296875e2), SC_(-0.058490262146413647893191406661344489661196205397623) }}, 
      {{ SC_(0.13e2), SC_(0.31483119964599609375e2), SC_(-0.059097648193164216098210463032489463414593572019457) }}, 
      {{ SC_(0.16e2), SC_(0.553809732082299888134002685546875e-4), SC_(1.6497920558691771603953986155514430866353697121094e-81) }}, 
      {{ SC_(0.16e2), SC_(0.69304020144045352935791015625e-4), SC_(4.7686656409754908602662635451757319359119984054894e-80) }}, 
      {{ SC_(0.16e2), SC_(0.23264062474481761455535888671875e-3), SC_(3.6923578930803277096665518608315320605775565624668e-72) }}, 
      {{ SC_(0.16e2), SC_(0.4480001516640186309814453125e-3), SC_(6.8579272248677032057965374868591344221506789627996e-68) }}, 
      {{ SC_(0.16e2), SC_(0.5502865533344447612762451171875e-3), SC_(1.4991806409856435889015399058356557932935067059821e-66) }}, 
      {{ SC_(0.16e2), SC_(0.19227224402129650115966796875e-2), SC_(2.1172364243145048425603461734762959570357477662163e-58) }}, 
      {{ SC_(0.16e2), SC_(0.37370622158050537109375e-2), SC_(4.5183022619165098820319926866996271352809918685639e-54) }}, 
      {{ SC_(0.16e2), SC_(0.47696642577648162841796875e-2), SC_(1.7552437654023408020905996298040901675895850526703e-52) }}, 
      {{ SC_(0.16e2), SC_(0.1275280676782131195068359375e-1), SC_(4.4782257050907379866484176984876638878165530645323e-46) }}, 
      {{ SC_(0.16e2), SC_(0.20440109074115753173828125e-1), SC_(5.2998745662595064619974948597257970126133808529003e-43) }}, 
      {{ SC_(0.16e2), SC_(0.3429813683032989501953125e-1), SC_(1.2475843986262124339235306283717294826464634108433e-39) }}, 
      {{ SC_(0.16e2), SC_(0.96701286733150482177734375e-1), SC_(7.0540261318386039902152203020917754619698703552759e-33) }}, 
      {{ SC_(0.16e2), SC_(0.159812271595001220703125e0), SC_(1.3212616225830805084503539652166207775243567623655e-29) }}, 
      {{ SC_(0.16e2), SC_(0.297095477581024169921875e0), SC_(1.4448636024084894614189736694086641099230493637962e-25) }}, 
      {{ SC_(0.16e2), SC_(0.77344071865081787109375e0), SC_(2.4497758956163486420863474162497805991759722182409e-19) }}, 
      {{ SC_(0.16e2), SC_(0.1992881298065185546875e1), SC_(3.3934597637763479137712991858718948154389747094123e-13) }}, 
      {{ SC_(0.16e2), SC_(0.3915013790130615234375e1), SC_(7.0296331875596016656863138719018927793503037114006e-09) }}, 
      {{ SC_(0.16e2), SC_(0.79858455657958984375e1), SC_(0.00013355037420606492302283167918418607145088475631566) }}, 
      {{ SC_(0.16e2), SC_(0.1571910858154296875e2), SC_(0.062767884761297570375151930067797758657655329107579) }}, 
      {{ SC_(0.16e2), SC_(0.31483119964599609375e2), SC_(0.041362073838342465337754331496614962917297662356378) }}, 
      {{ SC_(0.19e2), SC_(0.553809732082299888134002685546875e-4), SC_(7.1545045116330525143798300310341880608073323935543e-99) }}, 
      {{ SC_(0.19e2), SC_(0.69304020144045352935791015625e-4), SC_(4.0526655001741482482843185377135170530908983859137e-97) }}, 
      {{ SC_(0.19e2), SC_(0.23264062474481761455535888671875e-3), SC_(1.1869408039574944577387278869542556954775523781992e-87) }}, 
      {{ SC_(0.19e2), SC_(0.4480001516640186309814453125e-3), SC_(1.5743306814912646766492372606735466579398702957499e-82) }}, 
      {{ SC_(0.19e2), SC_(0.5502865533344447612762451171875e-3), SC_(6.3780698569850885024529096580624392972212435197808e-81) }}, 
      {{ SC_(0.19e2), SC_(0.19227224402129650115966796875e-2), SC_(3.8422688521249578183663683213517853106566207134909e-71) }}, 
      {{ SC_(0.19e2), SC_(0.37370622158050537109375e-2), SC_(6.0205322294031717930078004891271586607311617710025e-66) }}, 
      {{ SC_(0.19e2), SC_(0.47696642577648162841796875e-2), SC_(4.8626106707985934651262006146770209583452376471811e-64) }}, 
      {{ SC_(0.19e2), SC_(0.1275280676782131195068359375e-1), SC_(2.3713306396943905826551084027604850444122101979773e-56) }}, 
      {{ SC_(0.19e2), SC_(0.20440109074115753173828125e-1), SC_(1.1555382265435883720858940826914569162124121466451e-52) }}, 
      {{ SC_(0.19e2), SC_(0.3429813683032989501953125e-1), SC_(1.2851431884544343032155179779619591210654154347326e-48) }}, 
      {{ SC_(0.19e2), SC_(0.96701286733150482177734375e-1), SC_(1.6285965379144607001611281835346188219396556475167e-40) }}, 
      {{ SC_(0.19e2), SC_(0.159812271595001220703125e0), SC_(1.3769496559321795537210807315973069916510620427275e-36) }}, 
      {{ SC_(0.19e2), SC_(0.297095477581024169921875e0), SC_(9.6758288218279007718777871939617181794816724765861e-32) }}, 
      {{ SC_(0.19e2), SC_(0.77344071865081787109375e0), SC_(2.8985812066397683998166208757403762606414549048065e-24) }}, 
      {{ SC_(0.19e2), SC_(0.1992881298065185546875e1), SC_(6.9324694474892737027863159799017284927750160040651e-17) }}, 
      {{ SC_(0.19e2), SC_(0.3915013790130615234375e1), SC_(1.1239990774017179889685349151957195044522263040433e-11) }}, 
      {{ SC_(0.19e2), SC_(0.79858455657958984375e1), SC_(2.104023721890745372689589784178907665525692293693e-06) }}, 
      {{ SC_(0.19e2), SC_(0.1571910858154296875e2), SC_(0.021244763464654277297827339047906115004983991014952) }}, 
      {{ SC_(0.19e2), SC_(0.31483119964599609375e2), SC_(-0.063272920892309919192083854195447158441556046134454) }}, 
      {{ SC_(0.22e2), SC_(0.553809732082299888134002685546875e-4), SC_(1.9035681667307408240818117493421808122179114533803e-116) }}, 
      {{ SC_(0.22e2), SC_(0.69304020144045352935791015625e-4), SC_(2.1131151507185181299411994393137714082719644503812e-114) }}, 
      {{ SC_(0.22e2), SC_(0.23264062474481761455535888671875e-3), SC_(2.3409538288406003625807872734059247657544265202434e-103) }}, 
      {{ SC_(0.22e2), SC_(0.4480001516640186309814453125e-3), SC_(2.2173669201983938045529251847298026623331932741347e-97) }}, 
      {{ SC_(0.22e2), SC_(0.5502865533344447612762451171875e-3), SC_(1.6648039415279934728907273221501705153180287189341e-95) }}, 
      {{ SC_(0.22e2), SC_(0.19227224402129650115966796875e-2), SC_(4.2780382174096195604820395121390049161926815108261e-84) }}, 
      {{ SC_(0.22e2), SC_(0.37370622158050537109375e-2), SC_(4.9219024702162495221248160085917969960558847994543e-78) }}, 
      {{ SC_(0.22e2), SC_(0.47696642577648162841796875e-2), SC_(8.264946918280605486433241538819273573581906974194e-76) }}, 
      {{ SC_(0.22e2), SC_(0.1275280676782131195068359375e-1), SC_(7.7040077413676921900756284880421464366458035190456e-67) }}, 
      {{ SC_(0.22e2), SC_(0.20440109074115753173828125e-1), SC_(1.5457577083965510182234851435618245329350191548425e-62) }}, 
      {{ SC_(0.22e2), SC_(0.3429813683032989501953125e-1), SC_(8.1221541286672274116913338029491943053437408876584e-58) }}, 
      {{ SC_(0.22e2), SC_(0.96701286733150482177734375e-1), SC_(2.3068817850771988969387713725220732278280901967308e-48) }}, 
      {{ SC_(0.22e2), SC_(0.159812271595001220703125e0), SC_(8.803944110328227745216720645521920724989731533248e-44) }}, 
      {{ SC_(0.22e2), SC_(0.297095477581024169921875e0), SC_(3.9751954583075231790412843358629172269308694575879e-38) }}, 
      {{ SC_(0.22e2), SC_(0.77344071865081787109375e0), SC_(2.1032103293890930938101953339750564368326119482839e-29) }}, 
      {{ SC_(0.22e2), SC_(0.1992881298065185546875e1), SC_(8.6622424360129128301190072784366785975187300317628e-21) }}, 
      {{ SC_(0.22e2), SC_(0.3915013790130615234375e1), SC_(1.0892133786820843749711727772520509114630158766754e-14) }}, 
      {{ SC_(0.22e2), SC_(0.79858455657958984375e1), SC_(1.9186919007554470056181379178317907302967644104051e-08) }}, 
      {{ SC_(0.22e2), SC_(0.1571910858154296875e2), SC_(0.0025597903578414996542822772651876380525001444130937) }}, 
      {{ SC_(0.22e2), SC_(0.31483119964599609375e2), SC_(0.10666700109890475981720058713755007214565326567011) }}, 
      {{ SC_(0.25e2), SC_(0.553809732082299888134002685546875e-4), SC_(3.3281158689742879080180666156521740867978413942661e-134) }}, 
      {{ SC_(0.25e2), SC_(0.69304020144045352935791015625e-4), SC_(7.2401356174042750284915044002456144769904907688185e-132) }}, 
      {{ SC_(0.25e2), SC_(0.23264062474481761455535888671875e-3), SC_(3.0338755986145100625015373546247987397196577465905e-119) }}, 
      {{ SC_(0.25e2), SC_(0.4480001516640186309814453125e-3), SC_(2.052202923085553454618326397905478856649080672558e-112) }}, 
      {{ SC_(0.25e2), SC_(0.5502865533344447612762451171875e-3), SC_(2.8554729600469981676028557851420541084963942790186e-110) }}, 
      {{ SC_(0.25e2), SC_(0.19227224402129650115966796875e-2), SC_(3.1299882112836753595393036301852267981429923924488e-97) }}, 
      {{ SC_(0.25e2), SC_(0.37370622158050537109375e-2), SC_(2.644065756660133916858116831193271968664376920546e-90) }}, 
      {{ SC_(0.25e2), SC_(0.47696642577648162841796875e-2), SC_(9.2310640964431565146231354866176953462667207480456e-88) }}, 
      {{ SC_(0.25e2), SC_(0.1275280676782131195068359375e-1), SC_(1.6446837700568964011997833280972551117278339427599e-77) }}, 
      {{ SC_(0.25e2), SC_(0.20440109074115753173828125e-1), SC_(1.3587500391895882598746751422575758526295512303884e-72) }}, 
      {{ SC_(0.25e2), SC_(0.3429813683032989501953125e-1), SC_(3.3731202155681122998271788538729692783826275793045e-67) }}, 
      {{ SC_(0.25e2), SC_(0.96701286733150482177734375e-1), SC_(2.1472189718116944745478372576927875771253482103465e-56) }}, 
      {{ SC_(0.25e2), SC_(0.159812271595001220703125e0), SC_(3.6988970592032628613277151793125432668892732716608e-51) }}, 
      {{ SC_(0.25e2), SC_(0.297095477581024169921875e0), SC_(1.0731275320372300174089462072603423679962323287136e-44) }}, 
      {{ SC_(0.25e2), SC_(0.77344071865081787109375e0), SC_(1.0025243718994360282575314511776041814069821556008e-34) }}, 
      {{ SC_(0.25e2), SC_(0.1992881298065185546875e1), SC_(7.0985786065820965982310357503133213314625189875694e-25) }}, 
      {{ SC_(0.25e2), SC_(0.3915013790130615234375e1), SC_(6.8830770092576509793284560688319437075197953464972e-18) }}, 
      {{ SC_(0.25e2), SC_(0.79858455657958984375e1), SC_(1.1102957609871580659127905177902300708298926547175e-10) }}, 
      {{ SC_(0.25e2), SC_(0.1571910858154296875e2), SC_(0.00016213997696282163490095607452554920691747266822031) }}, 
      {{ SC_(0.25e2), SC_(0.31483119964599609375e2), SC_(-0.098371432418424956699345249788494000389492920716489) }}, 
      {{ SC_(0.28e2), SC_(0.553809732082299888134002685546875e-4), SC_(4.0263644241164455831757467751808844878560987722426e-152) }}, 
      {{ SC_(0.28e2), SC_(0.69304020144045352935791015625e-4), SC_(1.716543747584638675334827517370945122269348595147e-149) }}, 
      {{ SC_(0.28e2), SC_(0.23264062474481761455535888671875e-3), SC_(2.7207417913860929199999874234343281878283854690374e-135) }}, 
      {{ SC_(0.28e2), SC_(0.4480001516640186309814453125e-3), SC_(1.3142793286319407144276981270404335502434285614685e-127) }}, 
      {{ SC_(0.28e2), SC_(0.5502865533344447612762451171875e-3), SC_(3.3890474248254996327151084925561729199754804280468e-125) }}, 
      {{ SC_(0.28e2), SC_(0.19227224402129650115966796875e-2), SC_(1.5846209045913117563690584777510326762478064618504e-110) }}, 
      {{ SC_(0.28e2), SC_(0.37370622158050537109375e-2), SC_(9.8287012674213475085751778447619765586738314670302e-103) }}, 
      {{ SC_(0.28e2), SC_(0.47696642577648162841796875e-2), SC_(7.1342463042761638479621914173663707222530213287231e-100) }}, 
      {{ SC_(0.28e2), SC_(0.1275280676782131195068359375e-1), SC_(2.429588469572142240566660573755205083906899187173e-88) }}, 
      {{ SC_(0.28e2), SC_(0.20440109074115753173828125e-1), SC_(8.2646087195479884834751053044047766276233401313221e-83) }}, 
      {{ SC_(0.28e2), SC_(0.3429813683032989501953125e-1), SC_(9.6934167323599723375550530190686059345268090063894e-77) }}, 
      {{ SC_(0.28e2), SC_(0.96701286733150482177734375e-1), SC_(1.3829632821676867764296795343744777696903912067403e-64) }}, 
      {{ SC_(0.28e2), SC_(0.159812271595001220703125e0), SC_(1.0753460562158684392951992246815136406008646385717e-58) }}, 
      {{ SC_(0.28e2), SC_(0.297095477581024169921875e0), SC_(2.0045475725123002142901050443842530482907334222436e-51) }}, 
      {{ SC_(0.28e2), SC_(0.77344071865081787109375e0), SC_(3.3060340756185361079992123698919448202181277586582e-40) }}, 
      {{ SC_(0.28e2), SC_(0.1992881298065185546875e1), SC_(4.0200700795397043427434898814337959480274381568252e-29) }}, 
      {{ SC_(0.28e2), SC_(0.3915013790130615234375e1), SC_(2.9945269706906671388876521983898372768110871060356e-21) }}, 
      {{ SC_(0.28e2), SC_(0.79858455657958984375e1), SC_(4.3461131808442452576611812536250778441599549912967e-13) }}, 
      {{ SC_(0.28e2), SC_(0.1571910858154296875e2), SC_(6.2830436864843404153634864362763782379989319422095e-06) }}, 
      {{ SC_(0.28e2), SC_(0.31483119964599609375e2), SC_(-0.038367367337169753016085766030182628326676691691779) }},
      {{ SC_(0.0), SC_(-0.1730655412757187150418758392333984375e-5), SC_(8.6532770637826959996036352233123749969269387214742e-07) }}, 
      {{ SC_(0.0), SC_(-0.216575062950141727924346923828125e-5), SC_(1.082875314750073739565916601264494477250584335342e-06) }}, 
      {{ SC_(0.0), SC_(-0.72700195232755504548549652099609375e-5), SC_(3.6350097616137599975154414859780356083927094699044e-06) }}, 
      {{ SC_(0.0), SC_(-0.14000004739500582218170166015625e-4), SC_(7.0000023695787909349097782319695161608515974031987e-06) }}, 
      {{ SC_(0.0), SC_(-0.17196454791701398789882659912109375e-4), SC_(8.5982273955328680071189358596754762829168944805573e-06) }}, 
      {{ SC_(0.0), SC_(-0.60085076256655156612396240234375e-4), SC_(3.0042538114770070369352805041883730188463833118739e-05) }}, 
      {{ SC_(0.0), SC_(-0.116783194243907928466796875e-3), SC_(5.8391597022408593884593798440128797224531413316046e-05) }}, 
      {{ SC_(0.0), SC_(-0.149052008055150508880615234375e-3), SC_(7.4526003820611873275618570638597471453507592073022e-05) }}, 
      {{ SC_(0.0), SC_(-0.3985252114944159984588623046875e-3), SC_(0.00019926260179128875596958527588421993087864972378482) }}, 
      {{ SC_(0.0), SC_(-0.63875340856611728668212890625e-3), SC_(0.00031937668799461078462095468191142199676107353268414) }}, 
      {{ SC_(0.0), SC_(-0.10718167759478092193603515625e-2), SC_(0.00053590831101805319884851555459274406344951933890925) }}, 
      {{ SC_(0.0), SC_(-0.302191521041095256805419921875e-2), SC_(0.0015109558804534016451881641704527805135072146502315) }}, 
      {{ SC_(0.0), SC_(-0.499413348734378814697265625e-2), SC_(0.0024970589586470101824905275711945163368773628504049) }}, 
      {{ SC_(0.0), SC_(-0.928423367440700531005859375e-2), SC_(0.004642066820317960809690683300142997074645281491313) }}, 
      {{ SC_(0.0), SC_(-0.241700224578380584716796875e-1), SC_(0.012084128757582752071806633114629290747504060716828) }}, 
      {{ SC_(0.0), SC_(-0.6227754056453704833984375e-1), SC_(0.031123676287555626763445621624465166512983390930896) }}, 
      {{ SC_(0.0), SC_(-0.12234418094158172607421875e0), SC_(0.061057708094690239849216568742821152478027199712044) }}, 
      {{ SC_(0.0), SC_(-0.249557673931121826171875e0), SC_(0.12380996625346937610523536079167598077197103196986) }}, 
      {{ SC_(0.0), SC_(-0.4912221431732177734375e0), SC_(0.23827696230364644118075077312728350231461010203119) }}, 
      {{ SC_(0.0), SC_(-0.98384749889373779296875e0), SC_(0.43475639303623813062429779786150299582527673276141) }}, 
      {{ SC_(0.0), SC_(-0.11576130390167236328125e1), SC_(0.48711647358966534000543577089846185147646818027478) }}, 
      {{ SC_(0.0), SC_(-0.3451677799224853515625e1), SC_(0.15762889603997323748106344455034261827540551786683) }}, 
      {{ SC_(0.0), SC_(-0.788237094879150390625e1), SC_(0.21620542081836905819230529903303065520772215849306) }}, 
      {{ SC_(0.0), SC_(-0.15848876953125e2), SC_(0.11667862705625529027948213610287110911446401203924) }}, 
      {{ SC_(0.1e1), SC_(-0.553809732082299888134002685546875e-4), SC_(0.49999999942492771384298052799916741838663312550992) }}, 
      {{ SC_(0.1e1), SC_(-0.69304020144045352935791015625e-4), SC_(0.49999999909942864877671026019948448559391073505058) }}, 
      {{ SC_(0.1e1), SC_(-0.23264062474481761455535888671875e-3), SC_(0.499999989852188735328956350002167598643264662455) }}, 
      {{ SC_(0.1e1), SC_(-0.4480001516640186309814453125e-3), SC_(0.4999999623679750449477176449410603200324160738515) }}, 
      {{ SC_(0.1e1), SC_(-0.5502865533344447612762451171875e-3), SC_(0.49999994322213417259089023157928440742853321097516) }}, 
      {{ SC_(0.1e1), SC_(-0.19227224402129650115966796875e-2), SC_(0.4999993068386313094492273235957592720832822921268) }}, 
      {{ SC_(0.1e1), SC_(-0.37370622158050537109375e-2), SC_(0.49999738144616366882434596041523913440331476865703) }}, 
      {{ SC_(0.1e1), SC_(-0.47696642577648162841796875e-2), SC_(0.49999573443852669879893351364977629482653254035205) }}, 
      {{ SC_(0.1e1), SC_(-0.1275280676782131195068359375e-1), SC_(0.4999695064543116179615005455933450595992743509876) }}, 
      {{ SC_(0.1e1), SC_(-0.20440109074115753173828125e-1), SC_(0.49992166513677137770546149801804198933612439686551) }}, 
      {{ SC_(0.1e1), SC_(-0.3429813683032989501953125e-1), SC_(0.49977945010734455539681970982311210571822507220364) }}, 
      {{ SC_(0.1e1), SC_(-0.96701286733150482177734375e-1), SC_(0.49824779974515275629596562012328757837777712137835) }}, 
      {{ SC_(0.1e1), SC_(-0.159812271595001220703125e0), SC_(0.49521974412723318199543819892405982808588375931292) }}, 
      {{ SC_(0.1e1), SC_(-0.297095477581024169921875e0), SC_(0.48355135938900797260459530698530771097335947319244) }}, 
      {{ SC_(0.1e1), SC_(-0.77344071865081787109375e0), SC_(0.39241458162493758561769226797080928696562197564917) }}, 
      {{ SC_(0.1e1), SC_(-0.1992881298065185546875e1), SC_(-0.061619737135234892338595043962987165709230453576274) }}, 
      {{ SC_(0.1e1), SC_(-0.3915013790130615234375e1), SC_(-0.39290319605920753947168196339228416669899384044269) }}, 
      {{ SC_(0.1e1), SC_(-0.79858455657958984375e1), SC_(0.14583141931584640909010319204905863507861999460925) }}, 
      {{ SC_(0.1e1), SC_(-0.1571910858154296875e2), SC_(-0.15145963497536240984673974355792878883841231288619) }}, 
      {{ SC_(0.1e1), SC_(-0.31483119964599609375e2), SC_(0.10962844908422735210769459538120509525793203962829) }}, 
      {{ SC_(0.4e1), SC_(-0.553809732082299888134002685546875e-4), SC_(-1.7693368262174888896238964738107003669524226043035e-15) }}, 
      {{ SC_(0.4e1), SC_(-0.69304020144045352935791015625e-4), SC_(-3.4674008369257558740171674373495893574096907864769e-15) }}, 
      {{ SC_(0.4e1), SC_(-0.23264062474481761455535888671875e-3), SC_(-1.3115517509420754127960426519126947677168206400723e-13) }}, 
      {{ SC_(0.4e1), SC_(-0.4480001516640186309814453125e-3), SC_(-9.3661960380495629622137357856869182270416388742532e-13) }}, 
      {{ SC_(0.4e1), SC_(-0.5502865533344447612762451171875e-3), SC_(-1.7357831132937968817392795017011916501489255871193e-12) }}, 
      {{ SC_(0.4e1), SC_(-0.19227224402129650115966796875e-2), SC_(-7.4042049494318174815042257132143269722982060199314e-11) }}, 
      {{ SC_(0.4e1), SC_(-0.37370622158050537109375e-2), SC_(-5.4364988014235539823907985771899239309234261379898e-10) }}, 
      {{ SC_(0.4e1), SC_(-0.47696642577648162841796875e-2), SC_(-1.1302940848397100770820867105606709545842201552472e-09) }}, 
      {{ SC_(0.4e1), SC_(-0.1275280676782131195068359375e-1), SC_(-2.1604330248107663969856437007044251758680877766477e-08) }}, 
      {{ SC_(0.4e1), SC_(-0.20440109074115753173828125e-1), SC_(-8.8953857340211285658972412983716399290248998578182e-08) }}, 
      {{ SC_(0.4e1), SC_(-0.3429813683032989501953125e-1), SC_(-4.2024449758229269593374321819654716690052660413216e-07) }}, 
      {{ SC_(0.4e1), SC_(-0.96701286733150482177734375e-1), SC_(-9.4128451032217689955820303821981246359400931484752e-06) }}, 
      {{ SC_(0.4e1), SC_(-0.159812271595001220703125e0), SC_(-4.2435277297319406236849305446892646307888302002941e-05) }}, 
      {{ SC_(0.4e1), SC_(-0.297095477581024169921875e0), SC_(-0.00027135599414622583849557151099906031568896387896581) }}, 
      {{ SC_(0.4e1), SC_(-0.77344071865081787109375e0), SC_(-0.0046069141899053437359811541838758520302589287908814) }}, 
      {{ SC_(0.4e1), SC_(-0.1992881298065185546875e1), SC_(-0.060443414038447440668824241142946879836025954896153) }}, 
      {{ SC_(0.4e1), SC_(-0.3915013790130615234375e1), SC_(-0.15177123109875292536846632004847563063080968171939) }}, 
      {{ SC_(0.4e1), SC_(-0.79858455657958984375e1), SC_(0.23997697042213897502842907045349243873435595877447) }}, 
      {{ SC_(0.4e1), SC_(-0.1571910858154296875e2), SC_(0.046434244536118374752598151975883899662991537841961) }}, 
      {{ SC_(0.4e1), SC_(-0.31483119964599609375e2), SC_(-0.061817833121773152256991292145985522766508528770086) }}, 
      {{ SC_(0.7e1), SC_(-0.553809732082299888134002685546875e-4), SC_(3.1305528056638344867972886298683398144497717978537e-31) }}, 
      {{ SC_(0.7e1), SC_(-0.69304020144045352935791015625e-4), SC_(1.2022868570255225005663082021429250451610589556921e-30) }}, 
      {{ SC_(0.7e1), SC_(-0.23264062474481761455535888671875e-3), SC_(1.7201680056234174117633627993073749000743861640337e-27) }}, 
      {{ SC_(0.7e1), SC_(-0.4480001516640186309814453125e-3), SC_(8.7725630156789872544507544600717786563934226961732e-26) }}, 
      {{ SC_(0.7e1), SC_(-0.5502865533344447612762451171875e-3), SC_(3.0129431165931594932219997462581141884973596779344e-25) }}, 
      {{ SC_(0.7e1), SC_(-0.19227224402129650115966796875e-2), SC_(5.4822273190735084858521264396327901581626026123867e-22) }}, 
      {{ SC_(0.7e1), SC_(-0.37370622158050537109375e-2), SC_(2.9555564547986828192440474980580778563804193216626e-20) }}, 
      {{ SC_(0.7e1), SC_(-0.47696642577648162841796875e-2), SC_(1.2775679101016136207768793882190641810024614271416e-19) }}, 
      {{ SC_(0.7e1), SC_(-0.1275280676782131195068359375e-1), SC_(4.6675542199316705962508761747036734647552595402352e-17) }}, 
      {{ SC_(0.7e1), SC_(-0.20440109074115753173828125e-1), SC_(7.9131518097810249614823319782757539044033658685656e-16) }}, 
      {{ SC_(0.7e1), SC_(-0.3429813683032989501953125e-1), SC_(1.7662825516489034788084007541693872543504519440663e-14) }}, 
      {{ SC_(0.7e1), SC_(-0.96701286733150482177734375e-1), SC_(8.8692699965065814288047066394789611051021386707718e-12) }}, 
      {{ SC_(0.7e1), SC_(-0.159812271595001220703125e0), SC_(1.8058122351886366377394875534915789879166056857918e-10) }}, 
      {{ SC_(0.7e1), SC_(-0.297095477581024169921875e0), SC_(7.4352089564512688127753904684835081691106045906159e-09) }}, 
      {{ SC_(0.7e1), SC_(-0.77344071865081787109375e0), SC_(2.2675758396516885792509849125117055620920179094187e-06) }}, 
      {{ SC_(0.7e1), SC_(-0.1992881298065185546875e1), SC_(0.00057831078063158310356878944089232211326153287190001) }}, 
      {{ SC_(0.7e1), SC_(-0.3915013790130615234375e1), SC_(0.02041383080666513330673794768788259570924578070728) }}, 
      {{ SC_(0.7e1), SC_(-0.79858455657958984375e1), SC_(0.058218571837795162498597237894980109783789726930136) }}, 
      {{ SC_(0.7e1), SC_(-0.1571910858154296875e2), SC_(0.12685804245807057661668756481071566358164782614053) }}, 
      {{ SC_(0.7e1), SC_(-0.31483119964599609375e2), SC_(-0.14003757925102874842499033050664135459313874273098) }}, 
      {{ SC_(0.1e2), SC_(-0.553809732082299888134002685546875e-4), SC_(-1.3188100873744963459319007199937751301543239180136e-47) }}, 
      {{ SC_(0.1e2), SC_(-0.69304020144045352935791015625e-4), SC_(-9.9257391810363605974902541167749060462829253560831e-47) }}, 
      {{ SC_(0.1e2), SC_(-0.23264062474481761455535888671875e-3), SC_(-5.3716413581512494979533716301487868688806543328621e-42) }}, 
      {{ SC_(0.1e2), SC_(-0.4480001516640186309814453125e-3), SC_(-1.956322533586782024166087072125245785074691389279e-39) }}, 
      {{ SC_(0.1e2), SC_(-0.5502865533344447612762451171875e-3), SC_(-1.2451942672168763628696126390467461044008454052638e-38) }}, 
      {{ SC_(0.1e2), SC_(-0.19227224402129650115966796875e-2), SC_(-9.6646542478716484782923334506270056239127171552634e-34) }}, 
      {{ SC_(0.1e2), SC_(-0.37370622158050537109375e-2), SC_(-3.8256902023746264329913659088962640909312860291508e-31) }}, 
      {{ SC_(0.1e2), SC_(-0.47696642577648162841796875e-2), SC_(-3.4381674751993345896927555146196987111289718779677e-30) }}, 
      {{ SC_(0.1e2), SC_(-0.1275280676782131195068359375e-1), SC_(-2.4009720114206249912516932040726579855824809221431e-26) }}, 
      {{ SC_(0.1e2), SC_(-0.20440109074115753173828125e-1), SC_(-1.6760267381655761330373404298478901501611023208878e-24) }}, 
      {{ SC_(0.1e2), SC_(-0.3429813683032989501953125e-1), SC_(-1.7674935377289799535780547690266397443950184066763e-22) }}, 
      {{ SC_(0.1e2), SC_(-0.96701286733150482177734375e-1), SC_(-1.9893744092640228148907222276440233981950920601486e-18) }}, 
      {{ SC_(0.1e2), SC_(-0.159812271595001220703125e0), SC_(-1.8286290537911967361002045729606766750322137799336e-16) }}, 
      {{ SC_(0.1e2), SC_(-0.297095477581024169921875e0), SC_(-4.8412308070674532774125152283321995279577461389754e-14) }}, 
      {{ SC_(0.1e2), SC_(-0.77344071865081787109375e0), SC_(-2.6223373246818731084792674469888003633557213743021e-10) }}, 
      {{ SC_(0.1e2), SC_(-0.1992881298065185546875e1), SC_(-1.1965962205338207406958051169038464279159357115114e-06) }}, 
      {{ SC_(0.1e2), SC_(-0.3915013790130615234375e1), SC_(-0.00037897494764987250758743729715466646906940633334082) }}, 
      {{ SC_(0.1e2), SC_(-0.79858455657958984375e1), SC_(-0.049967594379099753800075924865486763413481109926599) }}, 
      {{ SC_(0.1e2), SC_(-0.1571910858154296875e2), SC_(0.095219427072112411409532063707164797795149921454385) }}, 
      {{ SC_(0.1e2), SC_(-0.31483119964599609375e2), SC_(-0.10827196177426450326870338063493299139382686828124) }}, 
      {{ SC_(0.13e2), SC_(-0.553809732082299888134002685546875e-4), SC_(2.121290231784798046752709655350864786529832117079e-64) }}, 
      {{ SC_(0.13e2), SC_(-0.69304020144045352935791015625e-4), SC_(3.1287742142665779825494951799930785776769478364188e-63) }}, 
      {{ SC_(0.13e2), SC_(-0.23264062474481761455535888671875e-3), SC_(6.4047142362327644859103125557956770544745144098238e-57) }}, 
      {{ SC_(0.13e2), SC_(-0.4480001516640186309814453125e-3), SC_(1.6657546057789064172662940915913489418437432496399e-53) }}, 
      {{ SC_(0.13e2), SC_(-0.5502865533344447612762451171875e-3), SC_(1.9648974865975549363172523443020646242481295483577e-52) }}, 
      {{ SC_(0.13e2), SC_(-0.19227224402129650115966796875e-2), SC_(6.5053729474100903943626156527590913198118862808397e-46) }}, 
      {{ SC_(0.13e2), SC_(-0.37370622158050537109375e-2), SC_(1.8907621746740377638542092734353671551811946804999e-42) }}, 
      {{ SC_(0.13e2), SC_(-0.47696642577648162841796875e-2), SC_(3.5328614364457558638310880096009890316651219791696e-41) }}, 
      {{ SC_(0.13e2), SC_(-0.1275280676782131195068359375e-1), SC_(4.7156437468577964105054800545225766621773238117231e-36) }}, 
      {{ SC_(0.13e2), SC_(-0.20440109074115753173828125e-1), SC_(1.355401186540478059654562132900988044653696693691e-33) }}, 
      {{ SC_(0.13e2), SC_(-0.3429813683032989501953125e-1), SC_(6.753189071873066495943722964871713531830224871692e-31) }}, 
      {{ SC_(0.13e2), SC_(-0.96701286733150482177734375e-1), SC_(1.7036345914826787093581881206307044168487995341273e-25) }}, 
      {{ SC_(0.13e2), SC_(-0.159812271595001220703125e0), SC_(7.069131202324893987734087462646174032528027700782e-23) }}, 
      {{ SC_(0.13e2), SC_(-0.297095477581024169921875e0), SC_(1.2029170744316206314629194819414371536976847699644e-19) }}, 
      {{ SC_(0.13e2), SC_(-0.77344071865081787109375e0), SC_(1.1535640591136223328357848970006202726033258192981e-14) }}, 
      {{ SC_(0.13e2), SC_(-0.1992881298065185546875e1), SC_(9.2127434442702321702847274180477102959755364382342e-10) }}, 
      {{ SC_(0.13e2), SC_(-0.3915013790130615234375e1), SC_(2.3991135775288520979528432073060764051878051022235e-06) }}, 
      {{ SC_(0.13e2), SC_(-0.79858455657958984375e1), SC_(0.0042342826820396933200038545046343548491508178374386) }}, 
      {{ SC_(0.13e2), SC_(-0.1571910858154296875e2), SC_(-0.058490262146413647893191406661344489661196205397623) }}, 
      {{ SC_(0.13e2), SC_(-0.31483119964599609375e2), SC_(-0.059097648193164216098210463032489463414593572019457) }}, 
      {{ SC_(0.16e2), SC_(-0.553809732082299888134002685546875e-4), SC_(-1.6497920558691771603953986155514430866353697121094e-81) }}, 
      {{ SC_(0.16e2), SC_(-0.69304020144045352935791015625e-4), SC_(-4.7686656409754908602662635451757319359119984054894e-80) }}, 
      {{ SC_(0.16e2), SC_(-0.23264062474481761455535888671875e-3), SC_(-3.6923578930803277096665518608315320605775565624668e-72) }}, 
      {{ SC_(0.16e2), SC_(-0.4480001516640186309814453125e-3), SC_(-6.8579272248677032057965374868591344221506789627996e-68) }}, 
      {{ SC_(0.16e2), SC_(-0.5502865533344447612762451171875e-3), SC_(-1.4991806409856435889015399058356557932935067059821e-66) }}, 
      {{ SC_(0.16e2), SC_(-0.19227224402129650115966796875e-2), SC_(-2.1172364243145048425603461734762959570357477662163e-58) }}, 
      {{ SC_(0.16e2), SC_(-0.37370622158050537109375e-2), SC_(-4.5183022619165098820319926866996271352809918685639e-54) }}, 
      {{ SC_(0.16e2), SC_(-0.47696642577648162841796875e-2), SC_(-1.7552437654023408020905996298040901675895850526703e-52) }}, 
      {{ SC_(0.16e2), SC_(-0.1275280676782131195068359375e-1), SC_(-4.4782257050907379866484176984876638878165530645323e-46) }}, 
      {{ SC_(0.16e2), SC_(-0.20440109074115753173828125e-1), SC_(-5.2998745662595064619974948597257970126133808529003e-43) }}, 
      {{ SC_(0.16e2), SC_(-0.3429813683032989501953125e-1), SC_(-1.2475843986262124339235306283717294826464634108433e-39) }}, 
      {{ SC_(0.16e2), SC_(-0.96701286733150482177734375e-1), SC_(-7.0540261318386039902152203020917754619698703552759e-33) }}, 
      {{ SC_(0.16e2), SC_(-0.159812271595001220703125e0), SC_(-1.3212616225830805084503539652166207775243567623655e-29) }}, 
      {{ SC_(0.16e2), SC_(-0.297095477581024169921875e0), SC_(-1.4448636024084894614189736694086641099230493637962e-25) }}, 
      {{ SC_(0.16e2), SC_(-0.77344071865081787109375e0), SC_(-2.4497758956163486420863474162497805991759722182409e-19) }}, 
      {{ SC_(0.16e2), SC_(-0.1992881298065185546875e1), SC_(-3.3934597637763479137712991858718948154389747094123e-13) }}, 
      {{ SC_(0.16e2), SC_(-0.3915013790130615234375e1), SC_(-7.0296331875596016656863138719018927793503037114006e-09) }}, 
      {{ SC_(0.16e2), SC_(-0.79858455657958984375e1), SC_(-0.00013355037420606492302283167918418607145088475631566) }}, 
      {{ SC_(0.16e2), SC_(-0.1571910858154296875e2), SC_(-0.062767884761297570375151930067797758657655329107579) }}, 
      {{ SC_(0.16e2), SC_(-0.31483119964599609375e2), SC_(-0.041362073838342465337754331496614962917297662356378) }}, 
      {{ SC_(0.19e2), SC_(-0.553809732082299888134002685546875e-4), SC_(7.1545045116330525143798300310341880608073323935543e-99) }}, 
      {{ SC_(0.19e2), SC_(-0.69304020144045352935791015625e-4), SC_(4.0526655001741482482843185377135170530908983859137e-97) }}, 
      {{ SC_(0.19e2), SC_(-0.23264062474481761455535888671875e-3), SC_(1.1869408039574944577387278869542556954775523781992e-87) }}, 
      {{ SC_(0.19e2), SC_(-0.4480001516640186309814453125e-3), SC_(1.5743306814912646766492372606735466579398702957499e-82) }}, 
      {{ SC_(0.19e2), SC_(-0.5502865533344447612762451171875e-3), SC_(6.3780698569850885024529096580624392972212435197808e-81) }}, 
      {{ SC_(0.19e2), SC_(-0.19227224402129650115966796875e-2), SC_(3.8422688521249578183663683213517853106566207134909e-71) }}, 
      {{ SC_(0.19e2), SC_(-0.37370622158050537109375e-2), SC_(6.0205322294031717930078004891271586607311617710025e-66) }}, 
      {{ SC_(0.19e2), SC_(-0.47696642577648162841796875e-2), SC_(4.8626106707985934651262006146770209583452376471811e-64) }}, 
      {{ SC_(0.19e2), SC_(-0.1275280676782131195068359375e-1), SC_(2.3713306396943905826551084027604850444122101979773e-56) }}, 
      {{ SC_(0.19e2), SC_(-0.20440109074115753173828125e-1), SC_(1.1555382265435883720858940826914569162124121466451e-52) }}, 
      {{ SC_(0.19e2), SC_(-0.3429813683032989501953125e-1), SC_(1.2851431884544343032155179779619591210654154347326e-48) }}, 
      {{ SC_(0.19e2), SC_(-0.96701286733150482177734375e-1), SC_(1.6285965379144607001611281835346188219396556475167e-40) }}, 
      {{ SC_(0.19e2), SC_(-0.159812271595001220703125e0), SC_(1.3769496559321795537210807315973069916510620427275e-36) }}, 
      {{ SC_(0.19e2), SC_(-0.297095477581024169921875e0), SC_(9.6758288218279007718777871939617181794816724765861e-32) }}, 
      {{ SC_(0.19e2), SC_(-0.77344071865081787109375e0), SC_(2.8985812066397683998166208757403762606414549048065e-24) }}, 
      {{ SC_(0.19e2), SC_(-0.1992881298065185546875e1), SC_(6.9324694474892737027863159799017284927750160040651e-17) }}, 
      {{ SC_(0.19e2), SC_(-0.3915013790130615234375e1), SC_(1.1239990774017179889685349151957195044522263040433e-11) }}, 
      {{ SC_(0.19e2), SC_(-0.79858455657958984375e1), SC_(2.104023721890745372689589784178907665525692293693e-06) }}, 
      {{ SC_(0.19e2), SC_(-0.1571910858154296875e2), SC_(0.021244763464654277297827339047906115004983991014952) }}, 
      {{ SC_(0.19e2), SC_(-0.31483119964599609375e2), SC_(-0.063272920892309919192083854195447158441556046134454) }}, 
      {{ SC_(0.22e2), SC_(-0.553809732082299888134002685546875e-4), SC_(-1.9035681667307408240818117493421808122179114533803e-116) }}, 
      {{ SC_(0.22e2), SC_(-0.69304020144045352935791015625e-4), SC_(-2.1131151507185181299411994393137714082719644503812e-114) }}, 
      {{ SC_(0.22e2), SC_(-0.23264062474481761455535888671875e-3), SC_(-2.3409538288406003625807872734059247657544265202434e-103) }}, 
      {{ SC_(0.22e2), SC_(-0.4480001516640186309814453125e-3), SC_(-2.2173669201983938045529251847298026623331932741347e-97) }}, 
      {{ SC_(0.22e2), SC_(-0.5502865533344447612762451171875e-3), SC_(-1.6648039415279934728907273221501705153180287189341e-95) }}, 
      {{ SC_(0.22e2), SC_(-0.19227224402129650115966796875e-2), SC_(-4.2780382174096195604820395121390049161926815108261e-84) }}, 
      {{ SC_(0.22e2), SC_(-0.37370622158050537109375e-2), SC_(-4.9219024702162495221248160085917969960558847994543e-78) }}, 
      {{ SC_(0.22e2), SC_(-0.47696642577648162841796875e-2), SC_(-8.264946918280605486433241538819273573581906974194e-76) }}, 
      {{ SC_(0.22e2), SC_(-0.1275280676782131195068359375e-1), SC_(-7.7040077413676921900756284880421464366458035190456e-67) }}, 
      {{ SC_(0.22e2), SC_(-0.20440109074115753173828125e-1), SC_(-1.5457577083965510182234851435618245329350191548425e-62) }}, 
      {{ SC_(0.22e2), SC_(-0.3429813683032989501953125e-1), SC_(-8.1221541286672274116913338029491943053437408876584e-58) }}, 
      {{ SC_(0.22e2), SC_(-0.96701286733150482177734375e-1), SC_(-2.3068817850771988969387713725220732278280901967308e-48) }}, 
      {{ SC_(0.22e2), SC_(-0.159812271595001220703125e0), SC_(-8.803944110328227745216720645521920724989731533248e-44) }}, 
      {{ SC_(0.22e2), SC_(-0.297095477581024169921875e0), SC_(-3.9751954583075231790412843358629172269308694575879e-38) }}, 
      {{ SC_(0.22e2), SC_(-0.77344071865081787109375e0), SC_(-2.1032103293890930938101953339750564368326119482839e-29) }}, 
      {{ SC_(0.22e2), SC_(-0.1992881298065185546875e1), SC_(-8.6622424360129128301190072784366785975187300317628e-21) }}, 
      {{ SC_(0.22e2), SC_(-0.3915013790130615234375e1), SC_(-1.0892133786820843749711727772520509114630158766754e-14) }}, 
      {{ SC_(0.22e2), SC_(-0.79858455657958984375e1), SC_(-1.9186919007554470056181379178317907302967644104051e-08) }}, 
      {{ SC_(0.22e2), SC_(-0.1571910858154296875e2), SC_(-0.0025597903578414996542822772651876380525001444130937) }}, 
      {{ SC_(0.22e2), SC_(-0.31483119964599609375e2), SC_(-0.10666700109890475981720058713755007214565326567011) }}, 
      {{ SC_(0.25e2), SC_(-0.553809732082299888134002685546875e-4), SC_(3.3281158689742879080180666156521740867978413942661e-134) }}, 
      {{ SC_(0.25e2), SC_(-0.69304020144045352935791015625e-4), SC_(7.2401356174042750284915044002456144769904907688185e-132) }}, 
      {{ SC_(0.25e2), SC_(-0.23264062474481761455535888671875e-3), SC_(3.0338755986145100625015373546247987397196577465905e-119) }}, 
      {{ SC_(0.25e2), SC_(-0.4480001516640186309814453125e-3), SC_(2.052202923085553454618326397905478856649080672558e-112) }}, 
      {{ SC_(0.25e2), SC_(-0.5502865533344447612762451171875e-3), SC_(2.8554729600469981676028557851420541084963942790186e-110) }}, 
      {{ SC_(0.25e2), SC_(-0.19227224402129650115966796875e-2), SC_(3.1299882112836753595393036301852267981429923924488e-97) }}, 
      {{ SC_(0.25e2), SC_(-0.37370622158050537109375e-2), SC_(2.644065756660133916858116831193271968664376920546e-90) }}, 
      {{ SC_(0.25e2), SC_(-0.47696642577648162841796875e-2), SC_(9.2310640964431565146231354866176953462667207480456e-88) }}, 
      {{ SC_(0.25e2), SC_(-0.1275280676782131195068359375e-1), SC_(1.6446837700568964011997833280972551117278339427599e-77) }}, 
      {{ SC_(0.25e2), SC_(-0.20440109074115753173828125e-1), SC_(1.3587500391895882598746751422575758526295512303884e-72) }}, 
      {{ SC_(0.25e2), SC_(-0.3429813683032989501953125e-1), SC_(3.3731202155681122998271788538729692783826275793045e-67) }}, 
      {{ SC_(0.25e2), SC_(-0.96701286733150482177734375e-1), SC_(2.1472189718116944745478372576927875771253482103465e-56) }}, 
      {{ SC_(0.25e2), SC_(-0.159812271595001220703125e0), SC_(3.6988970592032628613277151793125432668892732716608e-51) }}, 
      {{ SC_(0.25e2), SC_(-0.297095477581024169921875e0), SC_(1.0731275320372300174089462072603423679962323287136e-44) }}, 
      {{ SC_(0.25e2), SC_(-0.77344071865081787109375e0), SC_(1.0025243718994360282575314511776041814069821556008e-34) }}, 
      {{ SC_(0.25e2), SC_(-0.1992881298065185546875e1), SC_(7.0985786065820965982310357503133213314625189875694e-25) }}, 
      {{ SC_(0.25e2), SC_(-0.3915013790130615234375e1), SC_(6.8830770092576509793284560688319437075197953464972e-18) }}, 
      {{ SC_(0.25e2), SC_(-0.79858455657958984375e1), SC_(1.1102957609871580659127905177902300708298926547175e-10) }}, 
      {{ SC_(0.25e2), SC_(-0.1571910858154296875e2), SC_(0.00016213997696282163490095607452554920691747266822031) }}, 
      {{ SC_(0.25e2), SC_(-0.31483119964599609375e2), SC_(-0.098371432418424956699345249788494000389492920716489) }}, 
      {{ SC_(0.28e2), SC_(-0.553809732082299888134002685546875e-4), SC_(-4.0263644241164455831757467751808844878560987722426e-152) }}, 
      {{ SC_(0.28e2), SC_(-0.69304020144045352935791015625e-4), SC_(-1.716543747584638675334827517370945122269348595147e-149) }}, 
      {{ SC_(0.28e2), SC_(-0.23264062474481761455535888671875e-3), SC_(-2.7207417913860929199999874234343281878283854690374e-135) }}, 
      {{ SC_(0.28e2), SC_(-0.4480001516640186309814453125e-3), SC_(-1.3142793286319407144276981270404335502434285614685e-127) }}, 
      {{ SC_(0.28e2), SC_(-0.5502865533344447612762451171875e-3), SC_(-3.3890474248254996327151084925561729199754804280468e-125) }}, 
      {{ SC_(0.28e2), SC_(-0.19227224402129650115966796875e-2), SC_(-1.5846209045913117563690584777510326762478064618504e-110) }}, 
      {{ SC_(0.28e2), SC_(-0.37370622158050537109375e-2), SC_(-9.8287012674213475085751778447619765586738314670302e-103) }}, 
      {{ SC_(0.28e2), SC_(-0.47696642577648162841796875e-2), SC_(-7.1342463042761638479621914173663707222530213287231e-100) }}, 
      {{ SC_(0.28e2), SC_(-0.1275280676782131195068359375e-1), SC_(-2.429588469572142240566660573755205083906899187173e-88) }}, 
      {{ SC_(0.28e2), SC_(-0.20440109074115753173828125e-1), SC_(-8.2646087195479884834751053044047766276233401313221e-83) }}, 
      {{ SC_(0.28e2), SC_(-0.3429813683032989501953125e-1), SC_(-9.6934167323599723375550530190686059345268090063894e-77) }}, 
      {{ SC_(0.28e2), SC_(-0.96701286733150482177734375e-1), SC_(-1.3829632821676867764296795343744777696903912067403e-64) }}, 
      {{ SC_(0.28e2), SC_(-0.159812271595001220703125e0), SC_(-1.0753460562158684392951992246815136406008646385717e-58) }}, 
      {{ SC_(0.28e2), SC_(-0.297095477581024169921875e0), SC_(-2.0045475725123002142901050443842530482907334222436e-51) }}, 
      {{ SC_(0.28e2), SC_(-0.77344071865081787109375e0), SC_(-3.3060340756185361079992123698919448202181277586582e-40) }}, 
      {{ SC_(0.28e2), SC_(-0.1992881298065185546875e1), SC_(-4.0200700795397043427434898814337959480274381568252e-29) }}, 
      {{ SC_(0.28e2), SC_(-0.3915013790130615234375e1), SC_(-2.9945269706906671388876521983898372768110871060356e-21) }}, 
      {{ SC_(0.28e2), SC_(-0.79858455657958984375e1), SC_(-4.3461131808442452576611812536250778441599549912967e-13) }}, 
      {{ SC_(0.28e2), SC_(-0.1571910858154296875e2), SC_(-6.2830436864843404153634864362763782379989319422095e-06) }}, 
      {{ SC_(0.28e2), SC_(-0.31483119964599609375e2), SC_(0.038367367337169753016085766030182628326676691691779) }},
      {{ SC_(-0.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(-8.6532770637826959996036352233123749969269387214742e-07) }}, 
      {{ SC_(-0.0), SC_(0.216575062950141727924346923828125e-5), SC_(-1.082875314750073739565916601264494477250584335342e-06) }}, 
      {{ SC_(-0.0), SC_(0.72700195232755504548549652099609375e-5), SC_(-3.6350097616137599975154414859780356083927094699044e-06) }}, 
      {{ SC_(-0.0), SC_(0.14000004739500582218170166015625e-4), SC_(-7.0000023695787909349097782319695161608515974031987e-06) }}, 
      {{ SC_(-0.0), SC_(0.17196454791701398789882659912109375e-4), SC_(-8.5982273955328680071189358596754762829168944805573e-06) }}, 
      {{ SC_(-0.0), SC_(0.60085076256655156612396240234375e-4), SC_(-3.0042538114770070369352805041883730188463833118739e-05) }}, 
      {{ SC_(-0.0), SC_(0.116783194243907928466796875e-3), SC_(-5.8391597022408593884593798440128797224531413316046e-05) }}, 
      {{ SC_(-0.0), SC_(0.149052008055150508880615234375e-3), SC_(-7.4526003820611873275618570638597471453507592073022e-05) }}, 
      {{ SC_(-0.0), SC_(0.3985252114944159984588623046875e-3), SC_(-0.00019926260179128875596958527588421993087864972378482) }}, 
      {{ SC_(-0.0), SC_(0.63875340856611728668212890625e-3), SC_(-0.00031937668799461078462095468191142199676107353268414) }}, 
      {{ SC_(-0.0), SC_(0.10718167759478092193603515625e-2), SC_(-0.00053590831101805319884851555459274406344951933890925) }}, 
      {{ SC_(-0.0), SC_(0.302191521041095256805419921875e-2), SC_(-0.0015109558804534016451881641704527805135072146502315) }}, 
      {{ SC_(-0.0), SC_(0.499413348734378814697265625e-2), SC_(-0.0024970589586470101824905275711945163368773628504049) }}, 
      {{ SC_(-0.0), SC_(0.928423367440700531005859375e-2), SC_(-0.004642066820317960809690683300142997074645281491313) }}, 
      {{ SC_(-0.0), SC_(0.241700224578380584716796875e-1), SC_(-0.012084128757582752071806633114629290747504060716828) }}, 
      {{ SC_(-0.0), SC_(0.6227754056453704833984375e-1), SC_(-0.031123676287555626763445621624465166512983390930896) }}, 
      {{ SC_(-0.0), SC_(0.12234418094158172607421875e0), SC_(-0.061057708094690239849216568742821152478027199712044) }}, 
      {{ SC_(-0.0), SC_(0.249557673931121826171875e0), SC_(-0.12380996625346937610523536079167598077197103196986) }}, 
      {{ SC_(-0.0), SC_(0.4912221431732177734375e0), SC_(-0.23827696230364644118075077312728350231461010203119) }}, 
      {{ SC_(-0.0), SC_(0.98384749889373779296875e0), SC_(-0.43475639303623813062429779786150299582527673276141) }}, 
      {{ SC_(-0.0), SC_(0.11576130390167236328125e1), SC_(-0.48711647358966534000543577089846185147646818027478) }}, 
      {{ SC_(-0.0), SC_(0.3451677799224853515625e1), SC_(-0.15762889603997323748106344455034261827540551786683) }}, 
      {{ SC_(-0.0), SC_(0.788237094879150390625e1), SC_(-0.21620542081836905819230529903303065520772215849306) }}, 
      {{ SC_(-0.0), SC_(0.15848876953125e2), SC_(-0.11667862705625529027948213610287110911446401203924) }}, 
      {{ SC_(-0.1e1), SC_(0.553809732082299888134002685546875e-4), SC_(-0.49999999942492771384298052799916741838663312550992) }}, 
      {{ SC_(-0.1e1), SC_(0.69304020144045352935791015625e-4), SC_(-0.49999999909942864877671026019948448559391073505058) }}, 
      {{ SC_(-0.1e1), SC_(0.23264062474481761455535888671875e-3), SC_(-0.499999989852188735328956350002167598643264662455) }}, 
      {{ SC_(-0.1e1), SC_(0.4480001516640186309814453125e-3), SC_(-0.4999999623679750449477176449410603200324160738515) }}, 
      {{ SC_(-0.1e1), SC_(0.5502865533344447612762451171875e-3), SC_(-0.49999994322213417259089023157928440742853321097516) }}, 
      {{ SC_(-0.1e1), SC_(0.19227224402129650115966796875e-2), SC_(-0.4999993068386313094492273235957592720832822921268) }}, 
      {{ SC_(-0.1e1), SC_(0.37370622158050537109375e-2), SC_(-0.49999738144616366882434596041523913440331476865703) }}, 
      {{ SC_(-0.1e1), SC_(0.47696642577648162841796875e-2), SC_(-0.49999573443852669879893351364977629482653254035205) }}, 
      {{ SC_(-0.1e1), SC_(0.1275280676782131195068359375e-1), SC_(-0.4999695064543116179615005455933450595992743509876) }}, 
      {{ SC_(-0.1e1), SC_(0.20440109074115753173828125e-1), SC_(-0.49992166513677137770546149801804198933612439686551) }}, 
      {{ SC_(-0.1e1), SC_(0.3429813683032989501953125e-1), SC_(-0.49977945010734455539681970982311210571822507220364) }}, 
      {{ SC_(-0.1e1), SC_(0.96701286733150482177734375e-1), SC_(-0.49824779974515275629596562012328757837777712137835) }}, 
      {{ SC_(-0.1e1), SC_(0.159812271595001220703125e0), SC_(-0.49521974412723318199543819892405982808588375931292) }}, 
      {{ SC_(-0.1e1), SC_(0.297095477581024169921875e0), SC_(-0.48355135938900797260459530698530771097335947319244) }}, 
      {{ SC_(-0.1e1), SC_(0.77344071865081787109375e0), SC_(-0.39241458162493758561769226797080928696562197564917) }}, 
      {{ SC_(-0.1e1), SC_(0.1992881298065185546875e1), SC_(0.061619737135234892338595043962987165709230453576274) }}, 
      {{ SC_(-0.1e1), SC_(0.3915013790130615234375e1), SC_(0.39290319605920753947168196339228416669899384044269) }}, 
      {{ SC_(-0.1e1), SC_(0.79858455657958984375e1), SC_(-0.14583141931584640909010319204905863507861999460925) }}, 
      {{ SC_(-0.1e1), SC_(0.1571910858154296875e2), SC_(0.15145963497536240984673974355792878883841231288619) }}, 
      {{ SC_(-0.1e1), SC_(0.31483119964599609375e2), SC_(-0.10962844908422735210769459538120509525793203962829) }}, 
      {{ SC_(-0.4e1), SC_(0.553809732082299888134002685546875e-4), SC_(1.7693368262174888896238964738107003669524226043035e-15) }}, 
      {{ SC_(-0.4e1), SC_(0.69304020144045352935791015625e-4), SC_(3.4674008369257558740171674373495893574096907864769e-15) }}, 
      {{ SC_(-0.4e1), SC_(0.23264062474481761455535888671875e-3), SC_(1.3115517509420754127960426519126947677168206400723e-13) }}, 
      {{ SC_(-0.4e1), SC_(0.4480001516640186309814453125e-3), SC_(9.3661960380495629622137357856869182270416388742532e-13) }}, 
      {{ SC_(-0.4e1), SC_(0.5502865533344447612762451171875e-3), SC_(1.7357831132937968817392795017011916501489255871193e-12) }}, 
      {{ SC_(-0.4e1), SC_(0.19227224402129650115966796875e-2), SC_(7.4042049494318174815042257132143269722982060199314e-11) }}, 
      {{ SC_(-0.4e1), SC_(0.37370622158050537109375e-2), SC_(5.4364988014235539823907985771899239309234261379898e-10) }}, 
      {{ SC_(-0.4e1), SC_(0.47696642577648162841796875e-2), SC_(1.1302940848397100770820867105606709545842201552472e-09) }}, 
      {{ SC_(-0.4e1), SC_(0.1275280676782131195068359375e-1), SC_(2.1604330248107663969856437007044251758680877766477e-08) }}, 
      {{ SC_(-0.4e1), SC_(0.20440109074115753173828125e-1), SC_(8.8953857340211285658972412983716399290248998578182e-08) }}, 
      {{ SC_(-0.4e1), SC_(0.3429813683032989501953125e-1), SC_(4.2024449758229269593374321819654716690052660413216e-07) }}, 
      {{ SC_(-0.4e1), SC_(0.96701286733150482177734375e-1), SC_(9.4128451032217689955820303821981246359400931484752e-06) }}, 
      {{ SC_(-0.4e1), SC_(0.159812271595001220703125e0), SC_(4.2435277297319406236849305446892646307888302002941e-05) }}, 
      {{ SC_(-0.4e1), SC_(0.297095477581024169921875e0), SC_(0.00027135599414622583849557151099906031568896387896581) }}, 
      {{ SC_(-0.4e1), SC_(0.77344071865081787109375e0), SC_(0.0046069141899053437359811541838758520302589287908814) }}, 
      {{ SC_(-0.4e1), SC_(0.1992881298065185546875e1), SC_(0.060443414038447440668824241142946879836025954896153) }}, 
      {{ SC_(-0.4e1), SC_(0.3915013790130615234375e1), SC_(0.15177123109875292536846632004847563063080968171939) }}, 
      {{ SC_(-0.4e1), SC_(0.79858455657958984375e1), SC_(-0.23997697042213897502842907045349243873435595877447) }}, 
      {{ SC_(-0.4e1), SC_(0.1571910858154296875e2), SC_(-0.046434244536118374752598151975883899662991537841961) }}, 
      {{ SC_(-0.4e1), SC_(0.31483119964599609375e2), SC_(0.061817833121773152256991292145985522766508528770086) }}, 
      {{ SC_(-0.7e1), SC_(0.553809732082299888134002685546875e-4), SC_(-3.1305528056638344867972886298683398144497717978537e-31) }}, 
      {{ SC_(-0.7e1), SC_(0.69304020144045352935791015625e-4), SC_(-1.2022868570255225005663082021429250451610589556921e-30) }}, 
      {{ SC_(-0.7e1), SC_(0.23264062474481761455535888671875e-3), SC_(-1.7201680056234174117633627993073749000743861640337e-27) }}, 
      {{ SC_(-0.7e1), SC_(0.4480001516640186309814453125e-3), SC_(-8.7725630156789872544507544600717786563934226961732e-26) }}, 
      {{ SC_(-0.7e1), SC_(0.5502865533344447612762451171875e-3), SC_(-3.0129431165931594932219997462581141884973596779344e-25) }}, 
      {{ SC_(-0.7e1), SC_(0.19227224402129650115966796875e-2), SC_(-5.4822273190735084858521264396327901581626026123867e-22) }}, 
      {{ SC_(-0.7e1), SC_(0.37370622158050537109375e-2), SC_(-2.9555564547986828192440474980580778563804193216626e-20) }}, 
      {{ SC_(-0.7e1), SC_(0.47696642577648162841796875e-2), SC_(-1.2775679101016136207768793882190641810024614271416e-19) }}, 
      {{ SC_(-0.7e1), SC_(0.1275280676782131195068359375e-1), SC_(-4.6675542199316705962508761747036734647552595402352e-17) }}, 
      {{ SC_(-0.7e1), SC_(0.20440109074115753173828125e-1), SC_(-7.9131518097810249614823319782757539044033658685656e-16) }}, 
      {{ SC_(-0.7e1), SC_(0.3429813683032989501953125e-1), SC_(-1.7662825516489034788084007541693872543504519440663e-14) }}, 
      {{ SC_(-0.7e1), SC_(0.96701286733150482177734375e-1), SC_(-8.8692699965065814288047066394789611051021386707718e-12) }}, 
      {{ SC_(-0.7e1), SC_(0.159812271595001220703125e0), SC_(-1.8058122351886366377394875534915789879166056857918e-10) }}, 
      {{ SC_(-0.7e1), SC_(0.297095477581024169921875e0), SC_(-7.4352089564512688127753904684835081691106045906159e-09) }}, 
      {{ SC_(-0.7e1), SC_(0.77344071865081787109375e0), SC_(-2.2675758396516885792509849125117055620920179094187e-06) }}, 
      {{ SC_(-0.7e1), SC_(0.1992881298065185546875e1), SC_(-0.00057831078063158310356878944089232211326153287190001) }}, 
      {{ SC_(-0.7e1), SC_(0.3915013790130615234375e1), SC_(-0.02041383080666513330673794768788259570924578070728) }}, 
      {{ SC_(-0.7e1), SC_(0.79858455657958984375e1), SC_(-0.058218571837795162498597237894980109783789726930136) }}, 
      {{ SC_(-0.7e1), SC_(0.1571910858154296875e2), SC_(-0.12685804245807057661668756481071566358164782614053) }}, 
      {{ SC_(-0.7e1), SC_(0.31483119964599609375e2), SC_(0.14003757925102874842499033050664135459313874273098) }}, 
      {{ SC_(-0.1e2), SC_(0.553809732082299888134002685546875e-4), SC_(1.3188100873744963459319007199937751301543239180136e-47) }}, 
      {{ SC_(-0.1e2), SC_(0.69304020144045352935791015625e-4), SC_(9.9257391810363605974902541167749060462829253560831e-47) }}, 
      {{ SC_(-0.1e2), SC_(0.23264062474481761455535888671875e-3), SC_(5.3716413581512494979533716301487868688806543328621e-42) }}, 
      {{ SC_(-0.1e2), SC_(0.4480001516640186309814453125e-3), SC_(1.956322533586782024166087072125245785074691389279e-39) }}, 
      {{ SC_(-0.1e2), SC_(0.5502865533344447612762451171875e-3), SC_(1.2451942672168763628696126390467461044008454052638e-38) }}, 
      {{ SC_(-0.1e2), SC_(0.19227224402129650115966796875e-2), SC_(9.6646542478716484782923334506270056239127171552634e-34) }}, 
      {{ SC_(-0.1e2), SC_(0.37370622158050537109375e-2), SC_(3.8256902023746264329913659088962640909312860291508e-31) }}, 
      {{ SC_(-0.1e2), SC_(0.47696642577648162841796875e-2), SC_(3.4381674751993345896927555146196987111289718779677e-30) }}, 
      {{ SC_(-0.1e2), SC_(0.1275280676782131195068359375e-1), SC_(2.4009720114206249912516932040726579855824809221431e-26) }}, 
      {{ SC_(-0.1e2), SC_(0.20440109074115753173828125e-1), SC_(1.6760267381655761330373404298478901501611023208878e-24) }}, 
      {{ SC_(-0.1e2), SC_(0.3429813683032989501953125e-1), SC_(1.7674935377289799535780547690266397443950184066763e-22) }}, 
      {{ SC_(-0.1e2), SC_(0.96701286733150482177734375e-1), SC_(1.9893744092640228148907222276440233981950920601486e-18) }}, 
      {{ SC_(-0.1e2), SC_(0.159812271595001220703125e0), SC_(1.8286290537911967361002045729606766750322137799336e-16) }}, 
      {{ SC_(-0.1e2), SC_(0.297095477581024169921875e0), SC_(4.8412308070674532774125152283321995279577461389754e-14) }}, 
      {{ SC_(-0.1e2), SC_(0.77344071865081787109375e0), SC_(2.6223373246818731084792674469888003633557213743021e-10) }}, 
      {{ SC_(-0.1e2), SC_(0.1992881298065185546875e1), SC_(1.1965962205338207406958051169038464279159357115114e-06) }}, 
      {{ SC_(-0.1e2), SC_(0.3915013790130615234375e1), SC_(0.00037897494764987250758743729715466646906940633334082) }}, 
      {{ SC_(-0.1e2), SC_(0.79858455657958984375e1), SC_(0.049967594379099753800075924865486763413481109926599) }}, 
      {{ SC_(-0.1e2), SC_(0.1571910858154296875e2), SC_(-0.095219427072112411409532063707164797795149921454385) }}, 
      {{ SC_(-0.1e2), SC_(0.31483119964599609375e2), SC_(0.10827196177426450326870338063493299139382686828124) }}, 
      {{ SC_(-0.13e2), SC_(0.553809732082299888134002685546875e-4), SC_(-2.121290231784798046752709655350864786529832117079e-64) }}, 
      {{ SC_(-0.13e2), SC_(0.69304020144045352935791015625e-4), SC_(-3.1287742142665779825494951799930785776769478364188e-63) }}, 
      {{ SC_(-0.13e2), SC_(0.23264062474481761455535888671875e-3), SC_(-6.4047142362327644859103125557956770544745144098238e-57) }}, 
      {{ SC_(-0.13e2), SC_(0.4480001516640186309814453125e-3), SC_(-1.6657546057789064172662940915913489418437432496399e-53) }}, 
      {{ SC_(-0.13e2), SC_(0.5502865533344447612762451171875e-3), SC_(-1.9648974865975549363172523443020646242481295483577e-52) }}, 
      {{ SC_(-0.13e2), SC_(0.19227224402129650115966796875e-2), SC_(-6.5053729474100903943626156527590913198118862808397e-46) }}, 
      {{ SC_(-0.13e2), SC_(0.37370622158050537109375e-2), SC_(-1.8907621746740377638542092734353671551811946804999e-42) }}, 
      {{ SC_(-0.13e2), SC_(0.47696642577648162841796875e-2), SC_(-3.5328614364457558638310880096009890316651219791696e-41) }}, 
      {{ SC_(-0.13e2), SC_(0.1275280676782131195068359375e-1), SC_(-4.7156437468577964105054800545225766621773238117231e-36) }}, 
      {{ SC_(-0.13e2), SC_(0.20440109074115753173828125e-1), SC_(-1.355401186540478059654562132900988044653696693691e-33) }}, 
      {{ SC_(-0.13e2), SC_(0.3429813683032989501953125e-1), SC_(-6.753189071873066495943722964871713531830224871692e-31) }}, 
      {{ SC_(-0.13e2), SC_(0.96701286733150482177734375e-1), SC_(-1.7036345914826787093581881206307044168487995341273e-25) }}, 
      {{ SC_(-0.13e2), SC_(0.159812271595001220703125e0), SC_(-7.069131202324893987734087462646174032528027700782e-23) }}, 
      {{ SC_(-0.13e2), SC_(0.297095477581024169921875e0), SC_(-1.2029170744316206314629194819414371536976847699644e-19) }}, 
      {{ SC_(-0.13e2), SC_(0.77344071865081787109375e0), SC_(-1.1535640591136223328357848970006202726033258192981e-14) }}, 
      {{ SC_(-0.13e2), SC_(0.1992881298065185546875e1), SC_(-9.2127434442702321702847274180477102959755364382342e-10) }}, 
      {{ SC_(-0.13e2), SC_(0.3915013790130615234375e1), SC_(-2.3991135775288520979528432073060764051878051022235e-06) }}, 
      {{ SC_(-0.13e2), SC_(0.79858455657958984375e1), SC_(-0.0042342826820396933200038545046343548491508178374386) }}, 
      {{ SC_(-0.13e2), SC_(0.1571910858154296875e2), SC_(0.058490262146413647893191406661344489661196205397623) }}, 
      {{ SC_(-0.13e2), SC_(0.31483119964599609375e2), SC_(0.059097648193164216098210463032489463414593572019457) }}, 
      {{ SC_(-0.16e2), SC_(0.553809732082299888134002685546875e-4), SC_(1.6497920558691771603953986155514430866353697121094e-81) }}, 
      {{ SC_(-0.16e2), SC_(0.69304020144045352935791015625e-4), SC_(4.7686656409754908602662635451757319359119984054894e-80) }}, 
      {{ SC_(-0.16e2), SC_(0.23264062474481761455535888671875e-3), SC_(3.6923578930803277096665518608315320605775565624668e-72) }}, 
      {{ SC_(-0.16e2), SC_(0.4480001516640186309814453125e-3), SC_(6.8579272248677032057965374868591344221506789627996e-68) }}, 
      {{ SC_(-0.16e2), SC_(0.5502865533344447612762451171875e-3), SC_(1.4991806409856435889015399058356557932935067059821e-66) }}, 
      {{ SC_(-0.16e2), SC_(0.19227224402129650115966796875e-2), SC_(2.1172364243145048425603461734762959570357477662163e-58) }}, 
      {{ SC_(-0.16e2), SC_(0.37370622158050537109375e-2), SC_(4.5183022619165098820319926866996271352809918685639e-54) }}, 
      {{ SC_(-0.16e2), SC_(0.47696642577648162841796875e-2), SC_(1.7552437654023408020905996298040901675895850526703e-52) }}, 
      {{ SC_(-0.16e2), SC_(0.1275280676782131195068359375e-1), SC_(4.4782257050907379866484176984876638878165530645323e-46) }}, 
      {{ SC_(-0.16e2), SC_(0.20440109074115753173828125e-1), SC_(5.2998745662595064619974948597257970126133808529003e-43) }}, 
      {{ SC_(-0.16e2), SC_(0.3429813683032989501953125e-1), SC_(1.2475843986262124339235306283717294826464634108433e-39) }}, 
      {{ SC_(-0.16e2), SC_(0.96701286733150482177734375e-1), SC_(7.0540261318386039902152203020917754619698703552759e-33) }}, 
      {{ SC_(-0.16e2), SC_(0.159812271595001220703125e0), SC_(1.3212616225830805084503539652166207775243567623655e-29) }}, 
      {{ SC_(-0.16e2), SC_(0.297095477581024169921875e0), SC_(1.4448636024084894614189736694086641099230493637962e-25) }}, 
      {{ SC_(-0.16e2), SC_(0.77344071865081787109375e0), SC_(2.4497758956163486420863474162497805991759722182409e-19) }}, 
      {{ SC_(-0.16e2), SC_(0.1992881298065185546875e1), SC_(3.3934597637763479137712991858718948154389747094123e-13) }}, 
      {{ SC_(-0.16e2), SC_(0.3915013790130615234375e1), SC_(7.0296331875596016656863138719018927793503037114006e-09) }}, 
      {{ SC_(-0.16e2), SC_(0.79858455657958984375e1), SC_(0.00013355037420606492302283167918418607145088475631566) }}, 
      {{ SC_(-0.16e2), SC_(0.1571910858154296875e2), SC_(0.062767884761297570375151930067797758657655329107579) }}, 
      {{ SC_(-0.16e2), SC_(0.31483119964599609375e2), SC_(0.041362073838342465337754331496614962917297662356378) }}, 
      {{ SC_(-0.19e2), SC_(0.553809732082299888134002685546875e-4), SC_(-7.1545045116330525143798300310341880608073323935543e-99) }}, 
      {{ SC_(-0.19e2), SC_(0.69304020144045352935791015625e-4), SC_(-4.0526655001741482482843185377135170530908983859137e-97) }}, 
      {{ SC_(-0.19e2), SC_(0.23264062474481761455535888671875e-3), SC_(-1.1869408039574944577387278869542556954775523781992e-87) }}, 
      {{ SC_(-0.19e2), SC_(0.4480001516640186309814453125e-3), SC_(-1.5743306814912646766492372606735466579398702957499e-82) }}, 
      {{ SC_(-0.19e2), SC_(0.5502865533344447612762451171875e-3), SC_(-6.3780698569850885024529096580624392972212435197808e-81) }}, 
      {{ SC_(-0.19e2), SC_(0.19227224402129650115966796875e-2), SC_(-3.8422688521249578183663683213517853106566207134909e-71) }}, 
      {{ SC_(-0.19e2), SC_(0.37370622158050537109375e-2), SC_(-6.0205322294031717930078004891271586607311617710025e-66) }}, 
      {{ SC_(-0.19e2), SC_(0.47696642577648162841796875e-2), SC_(-4.8626106707985934651262006146770209583452376471811e-64) }}, 
      {{ SC_(-0.19e2), SC_(0.1275280676782131195068359375e-1), SC_(-2.3713306396943905826551084027604850444122101979773e-56) }}, 
      {{ SC_(-0.19e2), SC_(0.20440109074115753173828125e-1), SC_(-1.1555382265435883720858940826914569162124121466451e-52) }}, 
      {{ SC_(-0.19e2), SC_(0.3429813683032989501953125e-1), SC_(-1.2851431884544343032155179779619591210654154347326e-48) }}, 
      {{ SC_(-0.19e2), SC_(0.96701286733150482177734375e-1), SC_(-1.6285965379144607001611281835346188219396556475167e-40) }}, 
      {{ SC_(-0.19e2), SC_(0.159812271595001220703125e0), SC_(-1.3769496559321795537210807315973069916510620427275e-36) }}, 
      {{ SC_(-0.19e2), SC_(0.297095477581024169921875e0), SC_(-9.6758288218279007718777871939617181794816724765861e-32) }}, 
      {{ SC_(-0.19e2), SC_(0.77344071865081787109375e0), SC_(-2.8985812066397683998166208757403762606414549048065e-24) }}, 
      {{ SC_(-0.19e2), SC_(0.1992881298065185546875e1), SC_(-6.9324694474892737027863159799017284927750160040651e-17) }}, 
      {{ SC_(-0.19e2), SC_(0.3915013790130615234375e1), SC_(-1.1239990774017179889685349151957195044522263040433e-11) }}, 
      {{ SC_(-0.19e2), SC_(0.79858455657958984375e1), SC_(-2.104023721890745372689589784178907665525692293693e-06) }}, 
      {{ SC_(-0.19e2), SC_(0.1571910858154296875e2), SC_(-0.021244763464654277297827339047906115004983991014952) }}, 
      {{ SC_(-0.19e2), SC_(0.31483119964599609375e2), SC_(0.063272920892309919192083854195447158441556046134454) }}, 
      {{ SC_(-0.22e2), SC_(0.553809732082299888134002685546875e-4), SC_(1.9035681667307408240818117493421808122179114533803e-116) }}, 
      {{ SC_(-0.22e2), SC_(0.69304020144045352935791015625e-4), SC_(2.1131151507185181299411994393137714082719644503812e-114) }}, 
      {{ SC_(-0.22e2), SC_(0.23264062474481761455535888671875e-3), SC_(2.3409538288406003625807872734059247657544265202434e-103) }}, 
      {{ SC_(-0.22e2), SC_(0.4480001516640186309814453125e-3), SC_(2.2173669201983938045529251847298026623331932741347e-97) }}, 
      {{ SC_(-0.22e2), SC_(0.5502865533344447612762451171875e-3), SC_(1.6648039415279934728907273221501705153180287189341e-95) }}, 
      {{ SC_(-0.22e2), SC_(0.19227224402129650115966796875e-2), SC_(4.2780382174096195604820395121390049161926815108261e-84) }}, 
      {{ SC_(-0.22e2), SC_(0.37370622158050537109375e-2), SC_(4.9219024702162495221248160085917969960558847994543e-78) }}, 
      {{ SC_(-0.22e2), SC_(0.47696642577648162841796875e-2), SC_(8.264946918280605486433241538819273573581906974194e-76) }}, 
      {{ SC_(-0.22e2), SC_(0.1275280676782131195068359375e-1), SC_(7.7040077413676921900756284880421464366458035190456e-67) }}, 
      {{ SC_(-0.22e2), SC_(0.20440109074115753173828125e-1), SC_(1.5457577083965510182234851435618245329350191548425e-62) }}, 
      {{ SC_(-0.22e2), SC_(0.3429813683032989501953125e-1), SC_(8.1221541286672274116913338029491943053437408876584e-58) }}, 
      {{ SC_(-0.22e2), SC_(0.96701286733150482177734375e-1), SC_(2.3068817850771988969387713725220732278280901967308e-48) }}, 
      {{ SC_(-0.22e2), SC_(0.159812271595001220703125e0), SC_(8.803944110328227745216720645521920724989731533248e-44) }}, 
      {{ SC_(-0.22e2), SC_(0.297095477581024169921875e0), SC_(3.9751954583075231790412843358629172269308694575879e-38) }}, 
      {{ SC_(-0.22e2), SC_(0.77344071865081787109375e0), SC_(2.1032103293890930938101953339750564368326119482839e-29) }}, 
      {{ SC_(-0.22e2), SC_(0.1992881298065185546875e1), SC_(8.6622424360129128301190072784366785975187300317628e-21) }}, 
      {{ SC_(-0.22e2), SC_(0.3915013790130615234375e1), SC_(1.0892133786820843749711727772520509114630158766754e-14) }}, 
      {{ SC_(-0.22e2), SC_(0.79858455657958984375e1), SC_(1.9186919007554470056181379178317907302967644104051e-08) }}, 
      {{ SC_(-0.22e2), SC_(0.1571910858154296875e2), SC_(0.0025597903578414996542822772651876380525001444130937) }}, 
      {{ SC_(-0.22e2), SC_(0.31483119964599609375e2), SC_(0.10666700109890475981720058713755007214565326567011) }}, 
      {{ SC_(-0.25e2), SC_(0.553809732082299888134002685546875e-4), SC_(-3.3281158689742879080180666156521740867978413942661e-134) }}, 
      {{ SC_(-0.25e2), SC_(0.69304020144045352935791015625e-4), SC_(-7.2401356174042750284915044002456144769904907688185e-132) }}, 
      {{ SC_(-0.25e2), SC_(0.23264062474481761455535888671875e-3), SC_(-3.0338755986145100625015373546247987397196577465905e-119) }}, 
      {{ SC_(-0.25e2), SC_(0.4480001516640186309814453125e-3), SC_(-2.052202923085553454618326397905478856649080672558e-112) }}, 
      {{ SC_(-0.25e2), SC_(0.5502865533344447612762451171875e-3), SC_(-2.8554729600469981676028557851420541084963942790186e-110) }}, 
      {{ SC_(-0.25e2), SC_(0.19227224402129650115966796875e-2), SC_(-3.1299882112836753595393036301852267981429923924488e-97) }}, 
      {{ SC_(-0.25e2), SC_(0.37370622158050537109375e-2), SC_(-2.644065756660133916858116831193271968664376920546e-90) }}, 
      {{ SC_(-0.25e2), SC_(0.47696642577648162841796875e-2), SC_(-9.2310640964431565146231354866176953462667207480456e-88) }}, 
      {{ SC_(-0.25e2), SC_(0.1275280676782131195068359375e-1), SC_(-1.6446837700568964011997833280972551117278339427599e-77) }}, 
      {{ SC_(-0.25e2), SC_(0.20440109074115753173828125e-1), SC_(-1.3587500391895882598746751422575758526295512303884e-72) }}, 
      {{ SC_(-0.25e2), SC_(0.3429813683032989501953125e-1), SC_(-3.3731202155681122998271788538729692783826275793045e-67) }}, 
      {{ SC_(-0.25e2), SC_(0.96701286733150482177734375e-1), SC_(-2.1472189718116944745478372576927875771253482103465e-56) }}, 
      {{ SC_(-0.25e2), SC_(0.159812271595001220703125e0), SC_(-3.6988970592032628613277151793125432668892732716608e-51) }}, 
      {{ SC_(-0.25e2), SC_(0.297095477581024169921875e0), SC_(-1.0731275320372300174089462072603423679962323287136e-44) }}, 
      {{ SC_(-0.25e2), SC_(0.77344071865081787109375e0), SC_(-1.0025243718994360282575314511776041814069821556008e-34) }}, 
      {{ SC_(-0.25e2), SC_(0.1992881298065185546875e1), SC_(-7.0985786065820965982310357503133213314625189875694e-25) }}, 
      {{ SC_(-0.25e2), SC_(0.3915013790130615234375e1), SC_(-6.8830770092576509793284560688319437075197953464972e-18) }}, 
      {{ SC_(-0.25e2), SC_(0.79858455657958984375e1), SC_(-1.1102957609871580659127905177902300708298926547175e-10) }}, 
      {{ SC_(-0.25e2), SC_(0.1571910858154296875e2), SC_(-0.00016213997696282163490095607452554920691747266822031) }}, 
      {{ SC_(-0.25e2), SC_(0.31483119964599609375e2), SC_(0.098371432418424956699345249788494000389492920716489) }}, 
      {{ SC_(-0.28e2), SC_(0.553809732082299888134002685546875e-4), SC_(4.0263644241164455831757467751808844878560987722426e-152) }}, 
      {{ SC_(-0.28e2), SC_(0.69304020144045352935791015625e-4), SC_(1.716543747584638675334827517370945122269348595147e-149) }}, 
      {{ SC_(-0.28e2), SC_(0.23264062474481761455535888671875e-3), SC_(2.7207417913860929199999874234343281878283854690374e-135) }}, 
      {{ SC_(-0.28e2), SC_(0.4480001516640186309814453125e-3), SC_(1.3142793286319407144276981270404335502434285614685e-127) }}, 
      {{ SC_(-0.28e2), SC_(0.5502865533344447612762451171875e-3), SC_(3.3890474248254996327151084925561729199754804280468e-125) }}, 
      {{ SC_(-0.28e2), SC_(0.19227224402129650115966796875e-2), SC_(1.5846209045913117563690584777510326762478064618504e-110) }}, 
      {{ SC_(-0.28e2), SC_(0.37370622158050537109375e-2), SC_(9.8287012674213475085751778447619765586738314670302e-103) }}, 
      {{ SC_(-0.28e2), SC_(0.47696642577648162841796875e-2), SC_(7.1342463042761638479621914173663707222530213287231e-100) }}, 
      {{ SC_(-0.28e2), SC_(0.1275280676782131195068359375e-1), SC_(2.429588469572142240566660573755205083906899187173e-88) }}, 
      {{ SC_(-0.28e2), SC_(0.20440109074115753173828125e-1), SC_(8.2646087195479884834751053044047766276233401313221e-83) }}, 
      {{ SC_(-0.28e2), SC_(0.3429813683032989501953125e-1), SC_(9.6934167323599723375550530190686059345268090063894e-77) }}, 
      {{ SC_(-0.28e2), SC_(0.96701286733150482177734375e-1), SC_(1.3829632821676867764296795343744777696903912067403e-64) }}, 
      {{ SC_(-0.28e2), SC_(0.159812271595001220703125e0), SC_(1.0753460562158684392951992246815136406008646385717e-58) }}, 
      {{ SC_(-0.28e2), SC_(0.297095477581024169921875e0), SC_(2.0045475725123002142901050443842530482907334222436e-51) }}, 
      {{ SC_(-0.28e2), SC_(0.77344071865081787109375e0), SC_(3.3060340756185361079992123698919448202181277586582e-40) }}, 
      {{ SC_(-0.28e2), SC_(0.1992881298065185546875e1), SC_(4.0200700795397043427434898814337959480274381568252e-29) }}, 
      {{ SC_(-0.28e2), SC_(0.3915013790130615234375e1), SC_(2.9945269706906671388876521983898372768110871060356e-21) }}, 
      {{ SC_(-0.28e2), SC_(0.79858455657958984375e1), SC_(4.3461131808442452576611812536250778441599549912967e-13) }}, 
      {{ SC_(-0.28e2), SC_(0.1571910858154296875e2), SC_(6.2830436864843404153634864362763782379989319422095e-06) }}, 
      {{ SC_(-0.28e2), SC_(0.31483119964599609375e2), SC_(-0.038367367337169753016085766030182628326676691691779) }},
      {{ SC_(-0.0), SC_(-0.1730655412757187150418758392333984375e-5), SC_(8.6532770637826959996036352233123749969269387214742e-07) }}, 
      {{ SC_(-0.0), SC_(-0.216575062950141727924346923828125e-5), SC_(1.082875314750073739565916601264494477250584335342e-06) }}, 
      {{ SC_(-0.0), SC_(-0.72700195232755504548549652099609375e-5), SC_(3.6350097616137599975154414859780356083927094699044e-06) }}, 
      {{ SC_(-0.0), SC_(-0.14000004739500582218170166015625e-4), SC_(7.0000023695787909349097782319695161608515974031987e-06) }}, 
      {{ SC_(-0.0), SC_(-0.17196454791701398789882659912109375e-4), SC_(8.5982273955328680071189358596754762829168944805573e-06) }}, 
      {{ SC_(-0.0), SC_(-0.60085076256655156612396240234375e-4), SC_(3.0042538114770070369352805041883730188463833118739e-05) }}, 
      {{ SC_(-0.0), SC_(-0.116783194243907928466796875e-3), SC_(5.8391597022408593884593798440128797224531413316046e-05) }}, 
      {{ SC_(-0.0), SC_(-0.149052008055150508880615234375e-3), SC_(7.4526003820611873275618570638597471453507592073022e-05) }}, 
      {{ SC_(-0.0), SC_(-0.3985252114944159984588623046875e-3), SC_(0.00019926260179128875596958527588421993087864972378482) }}, 
      {{ SC_(-0.0), SC_(-0.63875340856611728668212890625e-3), SC_(0.00031937668799461078462095468191142199676107353268414) }}, 
      {{ SC_(-0.0), SC_(-0.10718167759478092193603515625e-2), SC_(0.00053590831101805319884851555459274406344951933890925) }}, 
      {{ SC_(-0.0), SC_(-0.302191521041095256805419921875e-2), SC_(0.0015109558804534016451881641704527805135072146502315) }}, 
      {{ SC_(-0.0), SC_(-0.499413348734378814697265625e-2), SC_(0.0024970589586470101824905275711945163368773628504049) }}, 
      {{ SC_(-0.0), SC_(-0.928423367440700531005859375e-2), SC_(0.004642066820317960809690683300142997074645281491313) }}, 
      {{ SC_(-0.0), SC_(-0.241700224578380584716796875e-1), SC_(0.012084128757582752071806633114629290747504060716828) }}, 
      {{ SC_(-0.0), SC_(-0.6227754056453704833984375e-1), SC_(0.031123676287555626763445621624465166512983390930896) }}, 
      {{ SC_(-0.0), SC_(-0.12234418094158172607421875e0), SC_(0.061057708094690239849216568742821152478027199712044) }}, 
      {{ SC_(-0.0), SC_(-0.249557673931121826171875e0), SC_(0.12380996625346937610523536079167598077197103196986) }}, 
      {{ SC_(-0.0), SC_(-0.4912221431732177734375e0), SC_(0.23827696230364644118075077312728350231461010203119) }}, 
      {{ SC_(-0.0), SC_(-0.98384749889373779296875e0), SC_(0.43475639303623813062429779786150299582527673276141) }}, 
      {{ SC_(-0.0), SC_(-0.11576130390167236328125e1), SC_(0.48711647358966534000543577089846185147646818027478) }}, 
      {{ SC_(-0.0), SC_(-0.3451677799224853515625e1), SC_(0.15762889603997323748106344455034261827540551786683) }}, 
      {{ SC_(-0.0), SC_(-0.788237094879150390625e1), SC_(0.21620542081836905819230529903303065520772215849306) }}, 
      {{ SC_(-0.0), SC_(-0.15848876953125e2), SC_(0.11667862705625529027948213610287110911446401203924) }}, 
      {{ SC_(-0.1e1), SC_(-0.553809732082299888134002685546875e-4), SC_(-0.49999999942492771384298052799916741838663312550992) }}, 
      {{ SC_(-0.1e1), SC_(-0.69304020144045352935791015625e-4), SC_(-0.49999999909942864877671026019948448559391073505058) }}, 
      {{ SC_(-0.1e1), SC_(-0.23264062474481761455535888671875e-3), SC_(-0.499999989852188735328956350002167598643264662455) }}, 
      {{ SC_(-0.1e1), SC_(-0.4480001516640186309814453125e-3), SC_(-0.4999999623679750449477176449410603200324160738515) }}, 
      {{ SC_(-0.1e1), SC_(-0.5502865533344447612762451171875e-3), SC_(-0.49999994322213417259089023157928440742853321097516) }}, 
      {{ SC_(-0.1e1), SC_(-0.19227224402129650115966796875e-2), SC_(-0.4999993068386313094492273235957592720832822921268) }}, 
      {{ SC_(-0.1e1), SC_(-0.37370622158050537109375e-2), SC_(-0.49999738144616366882434596041523913440331476865703) }}, 
      {{ SC_(-0.1e1), SC_(-0.47696642577648162841796875e-2), SC_(-0.49999573443852669879893351364977629482653254035205) }}, 
      {{ SC_(-0.1e1), SC_(-0.1275280676782131195068359375e-1), SC_(-0.4999695064543116179615005455933450595992743509876) }}, 
      {{ SC_(-0.1e1), SC_(-0.20440109074115753173828125e-1), SC_(-0.49992166513677137770546149801804198933612439686551) }}, 
      {{ SC_(-0.1e1), SC_(-0.3429813683032989501953125e-1), SC_(-0.49977945010734455539681970982311210571822507220364) }}, 
      {{ SC_(-0.1e1), SC_(-0.96701286733150482177734375e-1), SC_(-0.49824779974515275629596562012328757837777712137835) }}, 
      {{ SC_(-0.1e1), SC_(-0.159812271595001220703125e0), SC_(-0.49521974412723318199543819892405982808588375931292) }}, 
      {{ SC_(-0.1e1), SC_(-0.297095477581024169921875e0), SC_(-0.48355135938900797260459530698530771097335947319244) }}, 
      {{ SC_(-0.1e1), SC_(-0.77344071865081787109375e0), SC_(-0.39241458162493758561769226797080928696562197564917) }}, 
      {{ SC_(-0.1e1), SC_(-0.1992881298065185546875e1), SC_(0.061619737135234892338595043962987165709230453576274) }}, 
      {{ SC_(-0.1e1), SC_(-0.3915013790130615234375e1), SC_(0.39290319605920753947168196339228416669899384044269) }}, 
      {{ SC_(-0.1e1), SC_(-0.79858455657958984375e1), SC_(-0.14583141931584640909010319204905863507861999460925) }}, 
      {{ SC_(-0.1e1), SC_(-0.1571910858154296875e2), SC_(0.15145963497536240984673974355792878883841231288619) }}, 
      {{ SC_(-0.1e1), SC_(-0.31483119964599609375e2), SC_(-0.10962844908422735210769459538120509525793203962829) }}, 
      {{ SC_(-0.4e1), SC_(-0.553809732082299888134002685546875e-4), SC_(-1.7693368262174888896238964738107003669524226043035e-15) }}, 
      {{ SC_(-0.4e1), SC_(-0.69304020144045352935791015625e-4), SC_(-3.4674008369257558740171674373495893574096907864769e-15) }}, 
      {{ SC_(-0.4e1), SC_(-0.23264062474481761455535888671875e-3), SC_(-1.3115517509420754127960426519126947677168206400723e-13) }}, 
      {{ SC_(-0.4e1), SC_(-0.4480001516640186309814453125e-3), SC_(-9.3661960380495629622137357856869182270416388742532e-13) }}, 
      {{ SC_(-0.4e1), SC_(-0.5502865533344447612762451171875e-3), SC_(-1.7357831132937968817392795017011916501489255871193e-12) }}, 
      {{ SC_(-0.4e1), SC_(-0.19227224402129650115966796875e-2), SC_(-7.4042049494318174815042257132143269722982060199314e-11) }}, 
      {{ SC_(-0.4e1), SC_(-0.37370622158050537109375e-2), SC_(-5.4364988014235539823907985771899239309234261379898e-10) }}, 
      {{ SC_(-0.4e1), SC_(-0.47696642577648162841796875e-2), SC_(-1.1302940848397100770820867105606709545842201552472e-09) }}, 
      {{ SC_(-0.4e1), SC_(-0.1275280676782131195068359375e-1), SC_(-2.1604330248107663969856437007044251758680877766477e-08) }}, 
      {{ SC_(-0.4e1), SC_(-0.20440109074115753173828125e-1), SC_(-8.8953857340211285658972412983716399290248998578182e-08) }}, 
      {{ SC_(-0.4e1), SC_(-0.3429813683032989501953125e-1), SC_(-4.2024449758229269593374321819654716690052660413216e-07) }}, 
      {{ SC_(-0.4e1), SC_(-0.96701286733150482177734375e-1), SC_(-9.4128451032217689955820303821981246359400931484752e-06) }}, 
      {{ SC_(-0.4e1), SC_(-0.159812271595001220703125e0), SC_(-4.2435277297319406236849305446892646307888302002941e-05) }}, 
      {{ SC_(-0.4e1), SC_(-0.297095477581024169921875e0), SC_(-0.00027135599414622583849557151099906031568896387896581) }}, 
      {{ SC_(-0.4e1), SC_(-0.77344071865081787109375e0), SC_(-0.0046069141899053437359811541838758520302589287908814) }}, 
      {{ SC_(-0.4e1), SC_(-0.1992881298065185546875e1), SC_(-0.060443414038447440668824241142946879836025954896153) }}, 
      {{ SC_(-0.4e1), SC_(-0.3915013790130615234375e1), SC_(-0.15177123109875292536846632004847563063080968171939) }}, 
      {{ SC_(-0.4e1), SC_(-0.79858455657958984375e1), SC_(0.23997697042213897502842907045349243873435595877447) }}, 
      {{ SC_(-0.4e1), SC_(-0.1571910858154296875e2), SC_(0.046434244536118374752598151975883899662991537841961) }}, 
      {{ SC_(-0.4e1), SC_(-0.31483119964599609375e2), SC_(-0.061817833121773152256991292145985522766508528770086) }}, 
      {{ SC_(-0.7e1), SC_(-0.553809732082299888134002685546875e-4), SC_(-3.1305528056638344867972886298683398144497717978537e-31) }}, 
      {{ SC_(-0.7e1), SC_(-0.69304020144045352935791015625e-4), SC_(-1.2022868570255225005663082021429250451610589556921e-30) }}, 
      {{ SC_(-0.7e1), SC_(-0.23264062474481761455535888671875e-3), SC_(-1.7201680056234174117633627993073749000743861640337e-27) }}, 
      {{ SC_(-0.7e1), SC_(-0.4480001516640186309814453125e-3), SC_(-8.7725630156789872544507544600717786563934226961732e-26) }}, 
      {{ SC_(-0.7e1), SC_(-0.5502865533344447612762451171875e-3), SC_(-3.0129431165931594932219997462581141884973596779344e-25) }}, 
      {{ SC_(-0.7e1), SC_(-0.19227224402129650115966796875e-2), SC_(-5.4822273190735084858521264396327901581626026123867e-22) }}, 
      {{ SC_(-0.7e1), SC_(-0.37370622158050537109375e-2), SC_(-2.9555564547986828192440474980580778563804193216626e-20) }}, 
      {{ SC_(-0.7e1), SC_(-0.47696642577648162841796875e-2), SC_(-1.2775679101016136207768793882190641810024614271416e-19) }}, 
      {{ SC_(-0.7e1), SC_(-0.1275280676782131195068359375e-1), SC_(-4.6675542199316705962508761747036734647552595402352e-17) }}, 
      {{ SC_(-0.7e1), SC_(-0.20440109074115753173828125e-1), SC_(-7.9131518097810249614823319782757539044033658685656e-16) }}, 
      {{ SC_(-0.7e1), SC_(-0.3429813683032989501953125e-1), SC_(-1.7662825516489034788084007541693872543504519440663e-14) }}, 
      {{ SC_(-0.7e1), SC_(-0.96701286733150482177734375e-1), SC_(-8.8692699965065814288047066394789611051021386707718e-12) }}, 
      {{ SC_(-0.7e1), SC_(-0.159812271595001220703125e0), SC_(-1.8058122351886366377394875534915789879166056857918e-10) }}, 
      {{ SC_(-0.7e1), SC_(-0.297095477581024169921875e0), SC_(-7.4352089564512688127753904684835081691106045906159e-09) }}, 
      {{ SC_(-0.7e1), SC_(-0.77344071865081787109375e0), SC_(-2.2675758396516885792509849125117055620920179094187e-06) }}, 
      {{ SC_(-0.7e1), SC_(-0.1992881298065185546875e1), SC_(-0.00057831078063158310356878944089232211326153287190001) }}, 
      {{ SC_(-0.7e1), SC_(-0.3915013790130615234375e1), SC_(-0.02041383080666513330673794768788259570924578070728) }}, 
      {{ SC_(-0.7e1), SC_(-0.79858455657958984375e1), SC_(-0.058218571837795162498597237894980109783789726930136) }}, 
      {{ SC_(-0.7e1), SC_(-0.1571910858154296875e2), SC_(-0.12685804245807057661668756481071566358164782614053) }}, 
      {{ SC_(-0.7e1), SC_(-0.31483119964599609375e2), SC_(0.14003757925102874842499033050664135459313874273098) }}, 
      {{ SC_(-0.1e2), SC_(-0.553809732082299888134002685546875e-4), SC_(-1.3188100873744963459319007199937751301543239180136e-47) }}, 
      {{ SC_(-0.1e2), SC_(-0.69304020144045352935791015625e-4), SC_(-9.9257391810363605974902541167749060462829253560831e-47) }}, 
      {{ SC_(-0.1e2), SC_(-0.23264062474481761455535888671875e-3), SC_(-5.3716413581512494979533716301487868688806543328621e-42) }}, 
      {{ SC_(-0.1e2), SC_(-0.4480001516640186309814453125e-3), SC_(-1.956322533586782024166087072125245785074691389279e-39) }}, 
      {{ SC_(-0.1e2), SC_(-0.5502865533344447612762451171875e-3), SC_(-1.2451942672168763628696126390467461044008454052638e-38) }}, 
      {{ SC_(-0.1e2), SC_(-0.19227224402129650115966796875e-2), SC_(-9.6646542478716484782923334506270056239127171552634e-34) }}, 
      {{ SC_(-0.1e2), SC_(-0.37370622158050537109375e-2), SC_(-3.8256902023746264329913659088962640909312860291508e-31) }}, 
      {{ SC_(-0.1e2), SC_(-0.47696642577648162841796875e-2), SC_(-3.4381674751993345896927555146196987111289718779677e-30) }}, 
      {{ SC_(-0.1e2), SC_(-0.1275280676782131195068359375e-1), SC_(-2.4009720114206249912516932040726579855824809221431e-26) }}, 
      {{ SC_(-0.1e2), SC_(-0.20440109074115753173828125e-1), SC_(-1.6760267381655761330373404298478901501611023208878e-24) }}, 
      {{ SC_(-0.1e2), SC_(-0.3429813683032989501953125e-1), SC_(-1.7674935377289799535780547690266397443950184066763e-22) }}, 
      {{ SC_(-0.1e2), SC_(-0.96701286733150482177734375e-1), SC_(-1.9893744092640228148907222276440233981950920601486e-18) }}, 
      {{ SC_(-0.1e2), SC_(-0.159812271595001220703125e0), SC_(-1.8286290537911967361002045729606766750322137799336e-16) }}, 
      {{ SC_(-0.1e2), SC_(-0.297095477581024169921875e0), SC_(-4.8412308070674532774125152283321995279577461389754e-14) }}, 
      {{ SC_(-0.1e2), SC_(-0.77344071865081787109375e0), SC_(-2.6223373246818731084792674469888003633557213743021e-10) }}, 
      {{ SC_(-0.1e2), SC_(-0.1992881298065185546875e1), SC_(-1.1965962205338207406958051169038464279159357115114e-06) }}, 
      {{ SC_(-0.1e2), SC_(-0.3915013790130615234375e1), SC_(-0.00037897494764987250758743729715466646906940633334082) }}, 
      {{ SC_(-0.1e2), SC_(-0.79858455657958984375e1), SC_(-0.049967594379099753800075924865486763413481109926599) }}, 
      {{ SC_(-0.1e2), SC_(-0.1571910858154296875e2), SC_(0.095219427072112411409532063707164797795149921454385) }}, 
      {{ SC_(-0.1e2), SC_(-0.31483119964599609375e2), SC_(-0.10827196177426450326870338063493299139382686828124) }}, 
      {{ SC_(-0.13e2), SC_(-0.553809732082299888134002685546875e-4), SC_(-2.121290231784798046752709655350864786529832117079e-64) }}, 
      {{ SC_(-0.13e2), SC_(-0.69304020144045352935791015625e-4), SC_(-3.1287742142665779825494951799930785776769478364188e-63) }}, 
      {{ SC_(-0.13e2), SC_(-0.23264062474481761455535888671875e-3), SC_(-6.4047142362327644859103125557956770544745144098238e-57) }}, 
      {{ SC_(-0.13e2), SC_(-0.4480001516640186309814453125e-3), SC_(-1.6657546057789064172662940915913489418437432496399e-53) }}, 
      {{ SC_(-0.13e2), SC_(-0.5502865533344447612762451171875e-3), SC_(-1.9648974865975549363172523443020646242481295483577e-52) }}, 
      {{ SC_(-0.13e2), SC_(-0.19227224402129650115966796875e-2), SC_(-6.5053729474100903943626156527590913198118862808397e-46) }}, 
      {{ SC_(-0.13e2), SC_(-0.37370622158050537109375e-2), SC_(-1.8907621746740377638542092734353671551811946804999e-42) }}, 
      {{ SC_(-0.13e2), SC_(-0.47696642577648162841796875e-2), SC_(-3.5328614364457558638310880096009890316651219791696e-41) }}, 
      {{ SC_(-0.13e2), SC_(-0.1275280676782131195068359375e-1), SC_(-4.7156437468577964105054800545225766621773238117231e-36) }}, 
      {{ SC_(-0.13e2), SC_(-0.20440109074115753173828125e-1), SC_(-1.355401186540478059654562132900988044653696693691e-33) }}, 
      {{ SC_(-0.13e2), SC_(-0.3429813683032989501953125e-1), SC_(-6.753189071873066495943722964871713531830224871692e-31) }}, 
      {{ SC_(-0.13e2), SC_(-0.96701286733150482177734375e-1), SC_(-1.7036345914826787093581881206307044168487995341273e-25) }}, 
      {{ SC_(-0.13e2), SC_(-0.159812271595001220703125e0), SC_(-7.069131202324893987734087462646174032528027700782e-23) }}, 
      {{ SC_(-0.13e2), SC_(-0.297095477581024169921875e0), SC_(-1.2029170744316206314629194819414371536976847699644e-19) }}, 
      {{ SC_(-0.13e2), SC_(-0.77344071865081787109375e0), SC_(-1.1535640591136223328357848970006202726033258192981e-14) }}, 
      {{ SC_(-0.13e2), SC_(-0.1992881298065185546875e1), SC_(-9.2127434442702321702847274180477102959755364382342e-10) }}, 
      {{ SC_(-0.13e2), SC_(-0.3915013790130615234375e1), SC_(-2.3991135775288520979528432073060764051878051022235e-06) }}, 
      {{ SC_(-0.13e2), SC_(-0.79858455657958984375e1), SC_(-0.0042342826820396933200038545046343548491508178374386) }}, 
      {{ SC_(-0.13e2), SC_(-0.1571910858154296875e2), SC_(0.058490262146413647893191406661344489661196205397623) }}, 
      {{ SC_(-0.13e2), SC_(-0.31483119964599609375e2), SC_(0.059097648193164216098210463032489463414593572019457) }}, 
      {{ SC_(-0.16e2), SC_(-0.553809732082299888134002685546875e-4), SC_(-1.6497920558691771603953986155514430866353697121094e-81) }}, 
      {{ SC_(-0.16e2), SC_(-0.69304020144045352935791015625e-4), SC_(-4.7686656409754908602662635451757319359119984054894e-80) }}, 
      {{ SC_(-0.16e2), SC_(-0.23264062474481761455535888671875e-3), SC_(-3.6923578930803277096665518608315320605775565624668e-72) }}, 
      {{ SC_(-0.16e2), SC_(-0.4480001516640186309814453125e-3), SC_(-6.8579272248677032057965374868591344221506789627996e-68) }}, 
      {{ SC_(-0.16e2), SC_(-0.5502865533344447612762451171875e-3), SC_(-1.4991806409856435889015399058356557932935067059821e-66) }}, 
      {{ SC_(-0.16e2), SC_(-0.19227224402129650115966796875e-2), SC_(-2.1172364243145048425603461734762959570357477662163e-58) }}, 
      {{ SC_(-0.16e2), SC_(-0.37370622158050537109375e-2), SC_(-4.5183022619165098820319926866996271352809918685639e-54) }}, 
      {{ SC_(-0.16e2), SC_(-0.47696642577648162841796875e-2), SC_(-1.7552437654023408020905996298040901675895850526703e-52) }}, 
      {{ SC_(-0.16e2), SC_(-0.1275280676782131195068359375e-1), SC_(-4.4782257050907379866484176984876638878165530645323e-46) }}, 
      {{ SC_(-0.16e2), SC_(-0.20440109074115753173828125e-1), SC_(-5.2998745662595064619974948597257970126133808529003e-43) }}, 
      {{ SC_(-0.16e2), SC_(-0.3429813683032989501953125e-1), SC_(-1.2475843986262124339235306283717294826464634108433e-39) }}, 
      {{ SC_(-0.16e2), SC_(-0.96701286733150482177734375e-1), SC_(-7.0540261318386039902152203020917754619698703552759e-33) }}, 
      {{ SC_(-0.16e2), SC_(-0.159812271595001220703125e0), SC_(-1.3212616225830805084503539652166207775243567623655e-29) }}, 
      {{ SC_(-0.16e2), SC_(-0.297095477581024169921875e0), SC_(-1.4448636024084894614189736694086641099230493637962e-25) }}, 
      {{ SC_(-0.16e2), SC_(-0.77344071865081787109375e0), SC_(-2.4497758956163486420863474162497805991759722182409e-19) }}, 
      {{ SC_(-0.16e2), SC_(-0.1992881298065185546875e1), SC_(-3.3934597637763479137712991858718948154389747094123e-13) }}, 
      {{ SC_(-0.16e2), SC_(-0.3915013790130615234375e1), SC_(-7.0296331875596016656863138719018927793503037114006e-09) }}, 
      {{ SC_(-0.16e2), SC_(-0.79858455657958984375e1), SC_(-0.00013355037420606492302283167918418607145088475631566) }}, 
      {{ SC_(-0.16e2), SC_(-0.1571910858154296875e2), SC_(-0.062767884761297570375151930067797758657655329107579) }}, 
      {{ SC_(-0.16e2), SC_(-0.31483119964599609375e2), SC_(-0.041362073838342465337754331496614962917297662356378) }}, 
      {{ SC_(-0.19e2), SC_(-0.553809732082299888134002685546875e-4), SC_(-7.1545045116330525143798300310341880608073323935543e-99) }}, 
      {{ SC_(-0.19e2), SC_(-0.69304020144045352935791015625e-4), SC_(-4.0526655001741482482843185377135170530908983859137e-97) }}, 
      {{ SC_(-0.19e2), SC_(-0.23264062474481761455535888671875e-3), SC_(-1.1869408039574944577387278869542556954775523781992e-87) }}, 
      {{ SC_(-0.19e2), SC_(-0.4480001516640186309814453125e-3), SC_(-1.5743306814912646766492372606735466579398702957499e-82) }}, 
      {{ SC_(-0.19e2), SC_(-0.5502865533344447612762451171875e-3), SC_(-6.3780698569850885024529096580624392972212435197808e-81) }}, 
      {{ SC_(-0.19e2), SC_(-0.19227224402129650115966796875e-2), SC_(-3.8422688521249578183663683213517853106566207134909e-71) }}, 
      {{ SC_(-0.19e2), SC_(-0.37370622158050537109375e-2), SC_(-6.0205322294031717930078004891271586607311617710025e-66) }}, 
      {{ SC_(-0.19e2), SC_(-0.47696642577648162841796875e-2), SC_(-4.8626106707985934651262006146770209583452376471811e-64) }}, 
      {{ SC_(-0.19e2), SC_(-0.1275280676782131195068359375e-1), SC_(-2.3713306396943905826551084027604850444122101979773e-56) }}, 
      {{ SC_(-0.19e2), SC_(-0.20440109074115753173828125e-1), SC_(-1.1555382265435883720858940826914569162124121466451e-52) }}, 
      {{ SC_(-0.19e2), SC_(-0.3429813683032989501953125e-1), SC_(-1.2851431884544343032155179779619591210654154347326e-48) }}, 
      {{ SC_(-0.19e2), SC_(-0.96701286733150482177734375e-1), SC_(-1.6285965379144607001611281835346188219396556475167e-40) }}, 
      {{ SC_(-0.19e2), SC_(-0.159812271595001220703125e0), SC_(-1.3769496559321795537210807315973069916510620427275e-36) }}, 
      {{ SC_(-0.19e2), SC_(-0.297095477581024169921875e0), SC_(-9.6758288218279007718777871939617181794816724765861e-32) }}, 
      {{ SC_(-0.19e2), SC_(-0.77344071865081787109375e0), SC_(-2.8985812066397683998166208757403762606414549048065e-24) }}, 
      {{ SC_(-0.19e2), SC_(-0.1992881298065185546875e1), SC_(-6.9324694474892737027863159799017284927750160040651e-17) }}, 
      {{ SC_(-0.19e2), SC_(-0.3915013790130615234375e1), SC_(-1.1239990774017179889685349151957195044522263040433e-11) }}, 
      {{ SC_(-0.19e2), SC_(-0.79858455657958984375e1), SC_(-2.104023721890745372689589784178907665525692293693e-06) }}, 
      {{ SC_(-0.19e2), SC_(-0.1571910858154296875e2), SC_(-0.021244763464654277297827339047906115004983991014952) }}, 
      {{ SC_(-0.19e2), SC_(-0.31483119964599609375e2), SC_(0.063272920892309919192083854195447158441556046134454) }}, 
      {{ SC_(-0.22e2), SC_(-0.553809732082299888134002685546875e-4), SC_(-1.9035681667307408240818117493421808122179114533803e-116) }}, 
      {{ SC_(-0.22e2), SC_(-0.69304020144045352935791015625e-4), SC_(-2.1131151507185181299411994393137714082719644503812e-114) }}, 
      {{ SC_(-0.22e2), SC_(-0.23264062474481761455535888671875e-3), SC_(-2.3409538288406003625807872734059247657544265202434e-103) }}, 
      {{ SC_(-0.22e2), SC_(-0.4480001516640186309814453125e-3), SC_(-2.2173669201983938045529251847298026623331932741347e-97) }}, 
      {{ SC_(-0.22e2), SC_(-0.5502865533344447612762451171875e-3), SC_(-1.6648039415279934728907273221501705153180287189341e-95) }}, 
      {{ SC_(-0.22e2), SC_(-0.19227224402129650115966796875e-2), SC_(-4.2780382174096195604820395121390049161926815108261e-84) }}, 
      {{ SC_(-0.22e2), SC_(-0.37370622158050537109375e-2), SC_(-4.9219024702162495221248160085917969960558847994543e-78) }}, 
      {{ SC_(-0.22e2), SC_(-0.47696642577648162841796875e-2), SC_(-8.264946918280605486433241538819273573581906974194e-76) }}, 
      {{ SC_(-0.22e2), SC_(-0.1275280676782131195068359375e-1), SC_(-7.7040077413676921900756284880421464366458035190456e-67) }}, 
      {{ SC_(-0.22e2), SC_(-0.20440109074115753173828125e-1), SC_(-1.5457577083965510182234851435618245329350191548425e-62) }}, 
      {{ SC_(-0.22e2), SC_(-0.3429813683032989501953125e-1), SC_(-8.1221541286672274116913338029491943053437408876584e-58) }}, 
      {{ SC_(-0.22e2), SC_(-0.96701286733150482177734375e-1), SC_(-2.3068817850771988969387713725220732278280901967308e-48) }}, 
      {{ SC_(-0.22e2), SC_(-0.159812271595001220703125e0), SC_(-8.803944110328227745216720645521920724989731533248e-44) }}, 
      {{ SC_(-0.22e2), SC_(-0.297095477581024169921875e0), SC_(-3.9751954583075231790412843358629172269308694575879e-38) }}, 
      {{ SC_(-0.22e2), SC_(-0.77344071865081787109375e0), SC_(-2.1032103293890930938101953339750564368326119482839e-29) }}, 
      {{ SC_(-0.22e2), SC_(-0.1992881298065185546875e1), SC_(-8.6622424360129128301190072784366785975187300317628e-21) }}, 
      {{ SC_(-0.22e2), SC_(-0.3915013790130615234375e1), SC_(-1.0892133786820843749711727772520509114630158766754e-14) }}, 
      {{ SC_(-0.22e2), SC_(-0.79858455657958984375e1), SC_(-1.9186919007554470056181379178317907302967644104051e-08) }}, 
      {{ SC_(-0.22e2), SC_(-0.1571910858154296875e2), SC_(-0.0025597903578414996542822772651876380525001444130937) }}, 
      {{ SC_(-0.22e2), SC_(-0.31483119964599609375e2), SC_(-0.10666700109890475981720058713755007214565326567011) }}, 
      {{ SC_(-0.25e2), SC_(-0.553809732082299888134002685546875e-4), SC_(-3.3281158689742879080180666156521740867978413942661e-134) }}, 
      {{ SC_(-0.25e2), SC_(-0.69304020144045352935791015625e-4), SC_(-7.2401356174042750284915044002456144769904907688185e-132) }}, 
      {{ SC_(-0.25e2), SC_(-0.23264062474481761455535888671875e-3), SC_(-3.0338755986145100625015373546247987397196577465905e-119) }}, 
      {{ SC_(-0.25e2), SC_(-0.4480001516640186309814453125e-3), SC_(-2.052202923085553454618326397905478856649080672558e-112) }}, 
      {{ SC_(-0.25e2), SC_(-0.5502865533344447612762451171875e-3), SC_(-2.8554729600469981676028557851420541084963942790186e-110) }}, 
      {{ SC_(-0.25e2), SC_(-0.19227224402129650115966796875e-2), SC_(-3.1299882112836753595393036301852267981429923924488e-97) }}, 
      {{ SC_(-0.25e2), SC_(-0.37370622158050537109375e-2), SC_(-2.644065756660133916858116831193271968664376920546e-90) }}, 
      {{ SC_(-0.25e2), SC_(-0.47696642577648162841796875e-2), SC_(-9.2310640964431565146231354866176953462667207480456e-88) }}, 
      {{ SC_(-0.25e2), SC_(-0.1275280676782131195068359375e-1), SC_(-1.6446837700568964011997833280972551117278339427599e-77) }}, 
      {{ SC_(-0.25e2), SC_(-0.20440109074115753173828125e-1), SC_(-1.3587500391895882598746751422575758526295512303884e-72) }}, 
      {{ SC_(-0.25e2), SC_(-0.3429813683032989501953125e-1), SC_(-3.3731202155681122998271788538729692783826275793045e-67) }}, 
      {{ SC_(-0.25e2), SC_(-0.96701286733150482177734375e-1), SC_(-2.1472189718116944745478372576927875771253482103465e-56) }}, 
      {{ SC_(-0.25e2), SC_(-0.159812271595001220703125e0), SC_(-3.6988970592032628613277151793125432668892732716608e-51) }}, 
      {{ SC_(-0.25e2), SC_(-0.297095477581024169921875e0), SC_(-1.0731275320372300174089462072603423679962323287136e-44) }}, 
      {{ SC_(-0.25e2), SC_(-0.77344071865081787109375e0), SC_(-1.0025243718994360282575314511776041814069821556008e-34) }}, 
      {{ SC_(-0.25e2), SC_(-0.1992881298065185546875e1), SC_(-7.0985786065820965982310357503133213314625189875694e-25) }}, 
      {{ SC_(-0.25e2), SC_(-0.3915013790130615234375e1), SC_(-6.8830770092576509793284560688319437075197953464972e-18) }}, 
      {{ SC_(-0.25e2), SC_(-0.79858455657958984375e1), SC_(-1.1102957609871580659127905177902300708298926547175e-10) }}, 
      {{ SC_(-0.25e2), SC_(-0.1571910858154296875e2), SC_(-0.00016213997696282163490095607452554920691747266822031) }}, 
      {{ SC_(-0.25e2), SC_(-0.31483119964599609375e2), SC_(0.098371432418424956699345249788494000389492920716489) }}, 
      {{ SC_(-0.28e2), SC_(-0.553809732082299888134002685546875e-4), SC_(-4.0263644241164455831757467751808844878560987722426e-152) }}, 
      {{ SC_(-0.28e2), SC_(-0.69304020144045352935791015625e-4), SC_(-1.716543747584638675334827517370945122269348595147e-149) }}, 
      {{ SC_(-0.28e2), SC_(-0.23264062474481761455535888671875e-3), SC_(-2.7207417913860929199999874234343281878283854690374e-135) }}, 
      {{ SC_(-0.28e2), SC_(-0.4480001516640186309814453125e-3), SC_(-1.3142793286319407144276981270404335502434285614685e-127) }}, 
      {{ SC_(-0.28e2), SC_(-0.5502865533344447612762451171875e-3), SC_(-3.3890474248254996327151084925561729199754804280468e-125) }}, 
      {{ SC_(-0.28e2), SC_(-0.19227224402129650115966796875e-2), SC_(-1.5846209045913117563690584777510326762478064618504e-110) }}, 
      {{ SC_(-0.28e2), SC_(-0.37370622158050537109375e-2), SC_(-9.8287012674213475085751778447619765586738314670302e-103) }}, 
      {{ SC_(-0.28e2), SC_(-0.47696642577648162841796875e-2), SC_(-7.1342463042761638479621914173663707222530213287231e-100) }}, 
      {{ SC_(-0.28e2), SC_(-0.1275280676782131195068359375e-1), SC_(-2.429588469572142240566660573755205083906899187173e-88) }}, 
      {{ SC_(-0.28e2), SC_(-0.20440109074115753173828125e-1), SC_(-8.2646087195479884834751053044047766276233401313221e-83) }}, 
      {{ SC_(-0.28e2), SC_(-0.3429813683032989501953125e-1), SC_(-9.6934167323599723375550530190686059345268090063894e-77) }}, 
      {{ SC_(-0.28e2), SC_(-0.96701286733150482177734375e-1), SC_(-1.3829632821676867764296795343744777696903912067403e-64) }}, 
      {{ SC_(-0.28e2), SC_(-0.159812271595001220703125e0), SC_(-1.0753460562158684392951992246815136406008646385717e-58) }}, 
      {{ SC_(-0.28e2), SC_(-0.297095477581024169921875e0), SC_(-2.0045475725123002142901050443842530482907334222436e-51) }}, 
      {{ SC_(-0.28e2), SC_(-0.77344071865081787109375e0), SC_(-3.3060340756185361079992123698919448202181277586582e-40) }}, 
      {{ SC_(-0.28e2), SC_(-0.1992881298065185546875e1), SC_(-4.0200700795397043427434898814337959480274381568252e-29) }}, 
      {{ SC_(-0.28e2), SC_(-0.3915013790130615234375e1), SC_(-2.9945269706906671388876521983898372768110871060356e-21) }}, 
      {{ SC_(-0.28e2), SC_(-0.79858455657958984375e1), SC_(-4.3461131808442452576611812536250778441599549912967e-13) }}, 
      {{ SC_(-0.28e2), SC_(-0.1571910858154296875e2), SC_(-6.2830436864843404153634864362763782379989319422095e-06) }}, 
      {{ SC_(-0.28e2), SC_(-0.31483119964599609375e2), SC_(0.038367367337169753016085766030182628326676691691779) }},
   }};
