//  (C) Copyright John Maddock 2006-7.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const boost::array<boost::array<typename table_type<T>::type, 3>, 420> hermite = {{
      {{ SC_(0.8e1), SC_(-0.804919189453125e3), SC_(0.45107507538695517471998224862706929168983312035236e26) }}, 
      {{ SC_(0.8e1), SC_(-0.7460263671875e3), SC_(0.24561928260207418635049717146784087504133748838575e26) }}, 
      {{ SC_(0.8e1), SC_(-0.72904595947265625e3), SC_(0.20429972623973894937590136235800300689033201111301e26) }}, 
      {{ SC_(0.8e1), SC_(-0.623236083984375e3), SC_(0.5827000192786290015079053630015377969828881322477e25) }}, 
      {{ SC_(0.8e1), SC_(-0.557931884765625e3), SC_(0.24036425469465274704663172230600209480309473246511e25) }}, 
      {{ SC_(0.8e1), SC_(-0.4430035400390625e3), SC_(0.3797226972301982762616920977628718931846209669113e24) }}, 
      {{ SC_(0.8e1), SC_(-0.383665924072265625e3), SC_(0.12017786536547968144293561686294350272042177165962e24) }}, 
      {{ SC_(0.8e1), SC_(0.9376299285888671875e2), SC_(0.15268620781186000127986962828387837477310566397968e19) }}, 
      {{ SC_(0.8e1), SC_(0.944411773681640625e2), SC_(0.1617518154852919675909314869798309833011143307635e19) }}, 
      {{ SC_(0.8e1), SC_(0.264718536376953125e3), SC_(0.61720298828736019075790614156102805167876087211952e22) }}, 
      {{ SC_(0.8e1), SC_(0.62944732666015625e3), SC_(0.63081173846769146140441083274224793875281883735246e25) }}, 
      {{ SC_(0.8e1), SC_(0.67001715087890625e3), SC_(0.10397137311210792549517430287956468909599308482363e26) }}, 
      {{ SC_(0.8e1), SC_(0.8115838623046875e3), SC_(0.48183457131767562763518406277181444679084105960509e26) }}, 
      {{ SC_(0.8e1), SC_(0.826751708984375e3), SC_(0.55876845531601243780899074396489049059605490708721e26) }}, 
      {{ SC_(0.8e1), SC_(0.915013671875e3), SC_(0.12579210047506473419699887821873790018411396965251e27) }}, 
      {{ SC_(0.8e1), SC_(0.92977703857421875e3), SC_(0.14297610657915447015410284337196030534976367717228e27) }}, 
      {{ SC_(0.8e1), SC_(0.935389892578125e3), SC_(0.15002871812830612180035463350811490994647498745898e27) }}, 
      {{ SC_(0.8e1), SC_(0.93773553466796875e3), SC_(0.15306505051932713956696576348429859356902240309652e27) }}, 
      {{ SC_(0.8e1), SC_(0.9857625732421875e3), SC_(0.2282508005179494438672517847212865156472291867269e27) }}, 
      {{ SC_(0.8e1), SC_(0.99292266845703125e3), SC_(0.24185618845978155462978780829055436870571431239936e27) }}, 
      {{ SC_(0.9e1), SC_(-0.804919189453125e3), SC_(-0.72615348491801522758107817154280636761854800448258e29) }}, 
      {{ SC_(0.9e1), SC_(-0.7460263671875e3), SC_(-0.36647428831123627780613206119656435975372881269689e29) }}, 
      {{ SC_(0.9e1), SC_(-0.72904595947265625e3), SC_(-0.29788553802717105399309090578189082490491064795881e29) }}, 
      {{ SC_(0.9e1), SC_(-0.623236083984375e3), SC_(-0.72631187656840434630386580888842027480654740183583e28) }}, 
      {{ SC_(0.9e1), SC_(-0.557931884765625e3), SC_(-0.26821031676217242168707855784900940170157970241264e28) }}, 
      {{ SC_(0.9e1), SC_(-0.4430035400390625e3), SC_(-0.33643014085005895416146465835311020646005187659932e27) }}, 
      {{ SC_(0.9e1), SC_(-0.383665924072265625e3), SC_(-0.92213797591750116970480652180852706466705815198925e26) }}, 
      {{ SC_(0.9e1), SC_(0.9376299285888671875e2), SC_(0.28619599017630076419048218930351610672808471971911e21) }}, 
      {{ SC_(0.9e1), SC_(0.944411773681640625e2), SC_(0.30538356606793385774776392717760624059016600770529e21) }}, 
      {{ SC_(0.9e1), SC_(0.264718536376953125e3), SC_(0.32675149012792009950839328597362709432321349932704e25) }}, 
      {{ SC_(0.9e1), SC_(0.62944732666015625e3), SC_(0.79411750739676620994218584143838991056650844543993e28) }}, 
      {{ SC_(0.9e1), SC_(0.67001715087890625e3), SC_(0.13932396494395279118751516299633800114577839547729e29) }}, 
      {{ SC_(0.9e1), SC_(0.8115838623046875e3), SC_(0.78209357516588915667750630886227046953282003885816e29) }}, 
      {{ SC_(0.9e1), SC_(0.826751708984375e3), SC_(0.9239201438100206122484942895031603534508035207534e29) }}, 
      {{ SC_(0.9e1), SC_(0.915013671875e3), SC_(0.23020188368730794526744784417674030233447879296414e30) }}, 
      {{ SC_(0.9e1), SC_(0.92977703857421875e3), SC_(0.26587057172217180147109231631091242505401497841279e30) }}, 
      {{ SC_(0.9e1), SC_(0.935389892578125e3), SC_(0.28066940992909396296554569662089642014388342016689e30) }}, 
      {{ SC_(0.9e1), SC_(0.93773553466796875e3), SC_(0.2870677681432185184539265574407337379961356759468e30) }}, 
      {{ SC_(0.9e1), SC_(0.9857625732421875e3), SC_(0.4500003405401322163412586784924678900107709701962e30) }}, 
      {{ SC_(0.9e1), SC_(0.99292266845703125e3), SC_(0.48028703540906417924253986480733367446328052415498e30) }}, 
      {{ SC_(0.1e2), SC_(-0.804919189453125e3), SC_(0.11689816296461847274622300874825539661285328959095e33) }}, 
      {{ SC_(0.1e2), SC_(-0.7460263671875e3), SC_(0.54679454280582535200198215910160226619047153251183e32) }}, 
      {{ SC_(0.1e2), SC_(-0.72904595947265625e3), SC_(0.43434081837302238559608884831319578537002297874261e32) }}, 
      {{ SC_(0.1e2), SC_(-0.623236083984375e3), SC_(0.90531705080732310437321262346769305582516409498699e31) }}, 
      {{ SC_(0.1e2), SC_(-0.557931884765625e3), SC_(0.29928184853282382212205807781073913971873952893684e31) }}, 
      {{ SC_(0.1e2), SC_(-0.4430035400390625e3), SC_(0.29807265173628291298939129580674147768362711153657e30) }}, 
      {{ SC_(0.1e2), SC_(-0.383665924072265625e3), SC_(0.70756420528926763608091741538465186246363823788564e29) }}, 
      {{ SC_(0.1e2), SC_(0.9376299285888671875e2), SC_(0.53641701648878869328402154187886529569000541972093e23) }}, 
      {{ SC_(0.1e2), SC_(0.944411773681640625e2), SC_(0.57652451729901027022147781233362208672090049328676e23) }}, 
      {{ SC_(0.1e2), SC_(0.264718536376953125e3), SC_(0.17298324279751374105449100095978732528697456059849e28) }}, 
      {{ SC_(0.1e2), SC_(0.62944732666015625e3), SC_(0.99969892955855027682901459214621192921416240033293e31) }}, 
      {{ SC_(0.1e2), SC_(0.67001715087890625e3), SC_(0.18669702059708370695739115280703586121887901490207e32) }}, 
      {{ SC_(0.1e2), SC_(0.8115838623046875e3), SC_(0.12694603758113437790859235888888381018069026780075e33) }}, 
      {{ SC_(0.1e2), SC_(0.826751708984375e3), SC_(0.15276950578878524322853942670808003516571872263785e33) }}, 
      {{ SC_(0.1e2), SC_(0.915013671875e3), SC_(0.42127347747272206350084241564061602373253483547743e33) }}, 
      {{ SC_(0.1e2), SC_(0.92977703857421875e3), SC_(0.49439813206983222292955141736901537001605526567434e33) }}, 
      {{ SC_(0.1e2), SC_(0.935389892578125e3), SC_(0.52506795789015555507271006606207920041267992294258e33) }}, 
      {{ SC_(0.1e2), SC_(0.93773553466796875e3), SC_(0.5383845389205336603774821335902360432595407417418e33) }}, 
      {{ SC_(0.1e2), SC_(0.9857625732421875e3), SC_(0.88718287878699347854064053369680200599130466268723e33) }}, 
      {{ SC_(0.1e2), SC_(0.99292266845703125e3), SC_(0.95377141623597704470908019348004898122546466610927e33) }}, 
      {{ SC_(0.11e2), SC_(-0.804919189453125e3), SC_(-0.18818569685711019771084718279949279407835364975145e36) }}, 
      {{ SC_(0.11e2), SC_(-0.7460263671875e3), SC_(-0.81583896324899347640769823826628802342599459007862e35) }}, 
      {{ SC_(0.11e2), SC_(-0.72904595947265625e3), SC_(-0.63330287962703711111790462420108580900426293742353e35) }}, 
      {{ SC_(0.11e2), SC_(-0.623236083984375e3), SC_(-0.11284379807813476542599136955709023783640757794916e35) }}, 
      {{ SC_(0.11e2), SC_(-0.557931884765625e3), SC_(-0.33395240744978214895073421867397301877129142707028e34) }}, 
      {{ SC_(0.11e2), SC_(-0.4430035400390625e3), SC_(-0.26408775121319087852943852625927639373812809780785e33) }}, 
      {{ SC_(0.11e2), SC_(-0.383665924072265625e3), SC_(-0.54291810656601189878288220477937246911188498521391e32) }}, 
      {{ SC_(0.11e2), SC_(0.9376299285888671875e2), SC_(0.10053489057481196687076296855379756797368225593143e26) }}, 
      {{ SC_(0.11e2), SC_(0.944411773681640625e2), SC_(0.10883423167744841177736957439483334412283561854401e26) }}, 
      {{ SC_(0.11e2), SC_(0.264718536376953125e3), SC_(0.91577206672391353431978833974641874893100570036399e30) }}, 
      {{ SC_(0.11e2), SC_(0.62944732666015625e3), SC_(0.12584997550011507219817405571418069606411457160603e35) }}, 
      {{ SC_(0.11e2), SC_(0.67001715087890625e3), SC_(0.25017762515677812475654023661074854439693249674989e35) }}, 
      {{ SC_(0.11e2), SC_(0.8115838623046875e3), SC_(0.20605314678159576340073614574689144722841355692387e36) }}, 
      {{ SC_(0.11e2), SC_(0.826751708984375e3), SC_(0.25260305214286551864922726137009996295874170160231e36) }}, 
      {{ SC_(0.11e2), SC_(0.915013671875e3), SC_(0.77093737893405727479156012282524646171889099584724e36) }}, 
      {{ SC_(0.11e2), SC_(0.92977703857421875e3), SC_(0.91935474481359373814770652069446021505623126342922e36) }}, 
      {{ SC_(0.11e2), SC_(0.935389892578125e3), SC_(0.98228090806597754947655769132113085309480225491242e36) }}, 
      {{ SC_(0.11e2), SC_(0.93773553466796875e3), SC_(0.10097188855678660617518870586147923895925111174325e37) }}, 
      {{ SC_(0.11e2), SC_(0.9857625732421875e3), SC_(0.17490943550521460249490073361246584037466880560676e37) }}, 
      {{ SC_(0.11e2), SC_(0.99292266845703125e3), SC_(0.18940329136734281935082032957044303460975085779168e37) }}, 
      {{ SC_(0.12e2), SC_(-0.804919189453125e3), SC_(0.30294598540220804462044524153306777663509970628739e39) }}, 
      {{ SC_(0.12e2), SC_(-0.7460263671875e3), SC_(0.12172627264453841222828991650975850694842130932071e39) }}, 
      {{ SC_(0.12e2), SC_(-0.72904595947265625e3), SC_(0.92340425553097458791203508279141174969141820492299e38) }}, 
      {{ SC_(0.12e2), SC_(-0.623236083984375e3), SC_(0.14065466193476872965593557347378160930420069772452e38) }}, 
      {{ SC_(0.12e2), SC_(-0.557931884765625e3), SC_(0.37263880802028208129069576191917543233991535476065e37) }}, 
      {{ SC_(0.12e2), SC_(-0.4430035400390625e3), SC_(0.23397705973845936510794729346708943708034608906903e36) }}, 
      {{ SC_(0.12e2), SC_(-0.383665924072265625e3), SC_(0.41658278768991111298468308002249529032249010160273e35) }}, 
      {{ SC_(0.12e2), SC_(0.9376299285888671875e2), SC_(0.1884110327970735092254408128261723357492772304494e28) }}, 
      {{ SC_(0.12e2), SC_(0.944411773681640625e2), SC_(0.20544182415774952250997210456061363935901042940234e28) }}, 
      {{ SC_(0.12e2), SC_(0.264718536376953125e3), SC_(0.48480562600268824564698370021815193972032016354896e33) }}, 
      {{ SC_(0.12e2), SC_(0.62944732666015625e3), SC_(0.15842966193994215674176186033328108010563621242497e38) }}, 
      {{ SC_(0.12e2), SC_(0.67001715087890625e3), SC_(0.3352424919079377855427890512067629280453469707889e38) }}, 
      {{ SC_(0.12e2), SC_(0.8115838623046875e3), SC_(0.33445602459725757173093631890694210384349814179179e39) }}, 
      {{ SC_(0.12e2), SC_(0.826751708984375e3), SC_(0.4176766491784391607460244444090637220753635269242e39) }}, 
      {{ SC_(0.12e2), SC_(0.915013671875e3), SC_(0.14108272157517756411117655879591654342259860325597e40) }}, 
      {{ SC_(0.12e2), SC_(0.92977703857421875e3), SC_(0.17095789873049740244186014591319864325495552151212e40) }}, 
      {{ SC_(0.12e2), SC_(0.935389892578125e3), SC_(0.18376197146596820542876788527941003168360783639003e40) }}, 
      {{ SC_(0.12e2), SC_(0.93773553466796875e3), SC_(0.1893686713584800621262558335100385915682586408288e40) }}, 
      {{ SC_(0.12e2), SC_(0.9857625732421875e3), SC_(0.34483639865358422938227666676511723324380657223673e40) }}, 
      {{ SC_(0.12e2), SC_(0.99292266845703125e3), SC_(0.37612354466089752738688053508788073512368471136832e40) }}, 
      {{ SC_(0.14e2), SC_(-0.804919189453125e3), SC_(0.78509349018738235160733032424141654678585448892725e45) }}, 
      {{ SC_(0.14e2), SC_(-0.7460263671875e3), SC_(0.27098354215438353455074292442751387993705409786796e45) }}, 
      {{ SC_(0.14e2), SC_(-0.72904595947265625e3), SC_(0.1963140866469160283587538139069049517916547423808e45) }}, 
      {{ SC_(0.14e2), SC_(-0.623236083984375e3), SC_(0.21852711196938088461903329630489320958358132401565e44) }}, 
      {{ SC_(0.14e2), SC_(-0.557931884765625e3), SC_(0.46397330715580958030299464092581443527478590612547e43) }}, 
      {{ SC_(0.14e2), SC_(-0.4430035400390625e3), SC_(0.18366229244023923479459711102721222723014222612589e42) }}, 
      {{ SC_(0.14e2), SC_(-0.383665924072265625e3), SC_(0.2452623515231201706730966354471863727561067188341e41) }}, 
      {{ SC_(0.14e2), SC_(0.9376299285888671875e2), SC_(0.66162381135477581005495154141263686720850602513354e32) }}, 
      {{ SC_(0.14e2), SC_(0.944411773681640625e2), SC_(0.73191791295179938803853550797406604736335227799687e32) }}, 
      {{ SC_(0.14e2), SC_(0.264718536376953125e3), SC_(0.13586852786445215715633994918623748387323846205265e39) }}, 
      {{ SC_(0.14e2), SC_(0.62944732666015625e3), SC_(0.25107390168196177586150383676878149652976320263345e44) }}, 
      {{ SC_(0.14e2), SC_(0.67001715087890625e3), SC_(0.60197547505130410182245724063086619757439720128054e44) }}, 
      {{ SC_(0.14e2), SC_(0.8115838623046875e3), SC_(0.88116568941558811789182895851999922671272237353138e45) }}, 
      {{ SC_(0.14e2), SC_(0.826751708984375e3), SC_(0.11419377964091862944071723561627426135352077966224e46) }}, 
      {{ SC_(0.14e2), SC_(0.915013671875e3), SC_(0.47247899152452010973538576496340454153898147781107e46) }}, 
      {{ SC_(0.14e2), SC_(0.92977703857421875e3), SC_(0.59115384191612534464910943588501923979781137151048e46) }}, 
      {{ SC_(0.14e2), SC_(0.935389892578125e3), SC_(0.64312408439979544841727996206027907691861399699817e46) }}, 
      {{ SC_(0.14e2), SC_(0.93773553466796875e3), SC_(0.6660743304582574572302805211733148811292236266788e46) }}, 
      {{ SC_(0.14e2), SC_(0.9857625732421875e3), SC_(0.13403312883052399458307052679768402305161676649702e47) }}, 
      {{ SC_(0.14e2), SC_(0.99292266845703125e3), SC_(0.14832551222424115425011658642924351861903344306679e47) }}, 
      {{ SC_(0.17e2), SC_(-0.804919189453125e3), SC_(-0.32753153797495918082003912931285726506061176743964e55) }}, 
      {{ SC_(0.17e2), SC_(-0.7460263671875e3), SC_(-0.90007329480895899941888933327554774003263936965797e54) }}, 
      {{ SC_(0.17e2), SC_(-0.72904595947265625e3), SC_(-0.60853811902080657743899477322061605680407388628644e54) }}, 
      {{ SC_(0.17e2), SC_(-0.623236083984375e3), SC_(-0.42318271990511870201518687815721495653054465600729e53) }}, 
      {{ SC_(0.17e2), SC_(-0.557931884765625e3), SC_(-0.64460717395845550169248667399141161290740045059411e52) }}, 
      {{ SC_(0.17e2), SC_(-0.4430035400390625e3), SC_(-0.12772672712006258369520322740190661939797693301752e51) }}, 
      {{ SC_(0.17e2), SC_(-0.383665924072265625e3), SC_(-0.11079347177294102521393365342021901838709200618124e50) }}, 
      {{ SC_(0.17e2), SC_(0.9376299285888671875e2), SC_(0.43519374656033098836731300879764665651147065558436e39) }}, 
      {{ SC_(0.17e2), SC_(0.944411773681640625e2), SC_(0.49197114845678675190660148652415003678458303172232e39) }}, 
      {{ SC_(0.17e2), SC_(0.264718536376953125e3), SC_(0.20156840106065232860196226242061773336707200599203e47) }}, 
      {{ SC_(0.17e2), SC_(0.62944732666015625e3), SC_(0.50089312969909253100985667585549457957806648188064e53) }}, 
      {{ SC_(0.17e2), SC_(0.67001715087890625e3), SC_(0.14484542322921469021252847142515217054546111055271e54) }}, 
      {{ SC_(0.17e2), SC_(0.8115838623046875e3), SC_(0.37681912627369123156565537575498454914328631548362e55) }}, 
      {{ SC_(0.17e2), SC_(0.826751708984375e3), SC_(0.51623024126169573452382726948052946601408108701071e55) }}, 
      {{ SC_(0.17e2), SC_(0.915013671875e3), SC_(0.2895633337669055248580356708103410190763367894877e56) }}, 
      {{ SC_(0.17e2), SC_(0.92977703857421875e3), SC_(0.3801155621913868324726680029836865596398523401522e56) }}, 
      {{ SC_(0.17e2), SC_(0.935389892578125e3), SC_(0.42106739248936301791031860672266726247277487691351e56) }}, 
      {{ SC_(0.17e2), SC_(0.93773553466796875e3), SC_(0.43938243566475239425230868516223819196786547076179e56) }}, 
      {{ SC_(0.17e2), SC_(0.9857625732421875e3), SC_(0.10270913273877421296093041084504926541868918478653e57) }}, 
      {{ SC_(0.17e2), SC_(0.99292266845703125e3), SC_(0.11615615017858235461324853323128928576441231619921e57) }}, 
      {{ SC_(0.2e2), SC_(-0.804919189453125e3), SC_(0.13664125939696571321627792173825499772854104679616e65) }}, 
      {{ SC_(0.2e2), SC_(-0.7460263671875e3), SC_(0.29895741233874127495469956809930073866421954487847e64) }}, 
      {{ SC_(0.2e2), SC_(-0.72904595947265625e3), SC_(0.18863420002234182908461277048750351649649333505681e64) }}, 
      {{ SC_(0.2e2), SC_(-0.623236083984375e3), SC_(0.81949346219444618862653173904393894590758063374518e62) }}, 
      {{ SC_(0.2e2), SC_(-0.557931884765625e3), SC_(0.89555238442343089813862532910106267260245516404963e61) }}, 
      {{ SC_(0.2e2), SC_(-0.4430035400390625e3), SC_(0.88824671000905057725316145231689664346646310142073e59) }}, 
      {{ SC_(0.2e2), SC_(-0.383665924072265625e3), SC_(0.50047706031281686934185500483975552431695853442504e58) }}, 
      {{ SC_(0.2e2), SC_(0.9376299285888671875e2), SC_(0.28610882481879508349420844543142088727411910854846e46) }}, 
      {{ SC_(0.2e2), SC_(0.944411773681640625e2), SC_(0.33051957004017694649388986947888165210283009384182e46) }}, 
      {{ SC_(0.2e2), SC_(0.264718536376953125e3), SC_(0.29901855151764422494131549882514663732738129348024e55) }}, 
      {{ SC_(0.2e2), SC_(0.62944732666015625e3), SC_(0.99927183168358678754808761757157327216365777144205e62) }}, 
      {{ SC_(0.2e2), SC_(0.67001715087890625e3), SC_(0.34851895441504948247886064678376700332663758737157e63) }}, 
      {{ SC_(0.2e2), SC_(0.8115838623046875e3), SC_(0.16114073154440198981224756860557734867221327596599e65) }}, 
      {{ SC_(0.2e2), SC_(0.826751708984375e3), SC_(0.23336814692664616992187268964892147104007886493032e65) }}, 
      {{ SC_(0.2e2), SC_(0.915013671875e3), SC_(0.17746074449684933227630214006061794066505116427473e66) }}, 
      {{ SC_(0.2e2), SC_(0.92977703857421875e3), SC_(0.24441537589311671035327934989081469154090156736707e66) }}, 
      {{ SC_(0.2e2), SC_(0.935389892578125e3), SC_(0.27568060570403931616024471137057240588227997804305e66) }}, 
      {{ SC_(0.2e2), SC_(0.93773553466796875e3), SC_(0.28984143054751801100983111641098309458943114392562e66) }}, 
      {{ SC_(0.2e2), SC_(0.9857625732421875e3), SC_(0.78705296119546518418045335867325054394580461944723e66) }}, 
      {{ SC_(0.2e2), SC_(0.99292266845703125e3), SC_(0.90963378024910425574275540598584493435224094886741e66) }}, 
      {{ SC_(0.22e2), SC_(-0.804919189453125e3), SC_(0.35410549655517756288894933463443046263916370592399e71) }}, 
      {{ SC_(0.22e2), SC_(-0.7460263671875e3), SC_(0.66552086301142184824540948129935000740737930656653e70) }}, 
      {{ SC_(0.22e2), SC_(-0.72904595947265625e3), SC_(0.40102688572019492592353384325508110499649827819955e70) }}, 
      {{ SC_(0.22e2), SC_(-0.623236083984375e3), SC_(0.12731739462867210769929335621987129698264939626685e69) }}, 
      {{ SC_(0.22e2), SC_(-0.557931884765625e3), SC_(0.1115025363330833283360185086189456351576853382243e68) }}, 
      {{ SC_(0.22e2), SC_(-0.4430035400390625e3), SC_(0.69720842031752011420182341799620826445874423052258e65) }}, 
      {{ SC_(0.22e2), SC_(-0.383665924072265625e3), SC_(0.29463893441421178372847408123132239351850425649941e64) }}, 
      {{ SC_(0.22e2), SC_(0.9376299285888671875e2), SC_(0.1003782827805175100803910479602251404487037389062e51) }}, 
      {{ SC_(0.22e2), SC_(0.944411773681640625e2), SC_(0.11764679244687611821884729264491504501235806639058e51) }}, 
      {{ SC_(0.22e2), SC_(0.264718536376953125e3), SC_(0.8379145950216427011587973312320388548685225349241e60) }}, 
      {{ SC_(0.22e2), SC_(0.62944732666015625e3), SC_(0.15835797942946616484814881691459128287509909270475e69) }}, 
      {{ SC_(0.22e2), SC_(0.67001715087890625e3), SC_(0.62580409500666544589877458136886479113620166141142e69) }}, 
      {{ SC_(0.22e2), SC_(0.8115838623046875e3), SC_(0.42453999544876314526549365053968053544637180614368e71) }}, 
      {{ SC_(0.22e2), SC_(0.826751708984375e3), SC_(0.6380265423616569077424242322963862669375481451879e71) }}, 
      {{ SC_(0.22e2), SC_(0.915013671875e3), SC_(0.594301495455158980571773071367338948278658208606e72) }}, 
      {{ SC_(0.22e2), SC_(0.92977703857421875e3), SC_(0.84515399657972606106321594496701903669902755274213e72) }}, 
      {{ SC_(0.22e2), SC_(0.935389892578125e3), SC_(0.9648090657380372010046820149407771514227791651662e72) }}, 
      {{ SC_(0.22e2), SC_(0.93773553466796875e3), SC_(0.10194620842520108674666279682528872594917790291927e73) }}, 
      {{ SC_(0.22e2), SC_(0.9857625732421875e3), SC_(0.30591405911583021039789993837589816130948550568976e73) }}, 
      {{ SC_(0.22e2), SC_(0.99292266845703125e3), SC_(0.35871405411212380910164537165449077790291815793521e73) }}, 
      {{ SC_(0.35e2), SC_(-0.804919189453125e3), SC_(-0.17265543966226158832481036557708311109606127124495e113) }}, 
      {{ SC_(0.35e2), SC_(-0.7460263671875e3), SC_(-0.12084088507285694356128802551712858887746829960818e112) }}, 
      {{ SC_(0.35e2), SC_(-0.72904595947265625e3), SC_(-0.53979456945200833403000362177034133652140735259381e111) }}, 
      {{ SC_(0.35e2), SC_(-0.623236083984375e3), SC_(-0.22312994224945418486163982657597306470379988285216e109) }}, 
      {{ SC_(0.35e2), SC_(-0.557931884765625e3), SC_(-0.46342142799869242843524507994236576566424214389636e107) }}, 
      {{ SC_(0.35e2), SC_(-0.4430035400390625e3), SC_(-0.1444253157985643701034355053467664611143806193583e104) }}, 
      {{ SC_(0.35e2), SC_(-0.383665924072265625e3), SC_(-0.94088165704338497803214561361931665277258781819532e101) }}, 
      {{ SC_(0.35e2), SC_(0.9376299285888671875e2), SC_(0.34867964417713495790031091331083903141212636834345e80) }}, 
      {{ SC_(0.35e2), SC_(0.944411773681640625e2), SC_(0.44893689818357762545156808608435299085345232424014e80) }}, 
      {{ SC_(0.35e2), SC_(0.264718536376953125e3), SC_(0.21461397992635311594884111369449328695745329042721e96) }}, 
      {{ SC_(0.35e2), SC_(0.62944732666015625e3), SC_(0.31572029620004155645503713456510960829037485118449e109) }}, 
      {{ SC_(0.35e2), SC_(0.67001715087890625e3), SC_(0.28104070338817673160656082690105330768586005825238e110) }}, 
      {{ SC_(0.35e2), SC_(0.8115838623046875e3), SC_(0.23042138656363759346410653632368259132774527275621e113) }}, 
      {{ SC_(0.35e2), SC_(0.826751708984375e3), SC_(0.44054407432627688965463512998107242753350860065516e113) }}, 
      {{ SC_(0.35e2), SC_(0.915013671875e3), SC_(0.15341256810349040686982753469585076844343659132652e115) }}, 
      {{ SC_(0.35e2), SC_(0.92977703857421875e3), SC_(0.26863276202949674855940307716119052117849681722704e115) }}, 
      {{ SC_(0.35e2), SC_(0.935389892578125e3), SC_(0.33162382598046564424135108685347435914117320370668e115) }}, 
      {{ SC_(0.35e2), SC_(0.93773553466796875e3), SC_(0.36200618356985329660106920606060260999032636548302e115) }}, 
      {{ SC_(0.35e2), SC_(0.9857625732421875e3), SC_(0.2079448954791745442630733208937099187119527807451e116) }}, 
      {{ SC_(0.35e2), SC_(0.99292266845703125e3), SC_(0.26789135369462534563475801989659335410281343329047e116) }}, 
      {{ SC_(0.39e2), SC_(-0.804919189453125e3), SC_(-0.11594724610269376675133295994667648916340009156091e126) }}, 
      {{ SC_(0.39e2), SC_(-0.7460263671875e3), SC_(-0.59881631251408557205127311170851509987384503796021e124) }}, 
      {{ SC_(0.39e2), SC_(-0.72904595947265625e3), SC_(-0.24395429686140560929684017855836946012576141303362e124) }}, 
      {{ SC_(0.39e2), SC_(-0.623236083984375e3), SC_(-0.53852586791768825082912263464229497587060927002143e121) }}, 
      {{ SC_(0.39e2), SC_(-0.557931884765625e3), SC_(-0.718321662571676714076170854773512025550058778984e119) }}, 
      {{ SC_(0.39e2), SC_(-0.4430035400390625e3), SC_(-0.88967324101112965016069832261671747302656341584146e115) }}, 
      {{ SC_(0.39e2), SC_(-0.383665924072265625e3), SC_(-0.32602618395821624277606519061217455907925511708347e113) }}, 
      {{ SC_(0.39e2), SC_(0.9376299285888671875e2), SC_(0.42761721847707811157055723429059908203980837805154e89) }}, 
      {{ SC_(0.39e2), SC_(0.944411773681640625e2), SC_(0.56674218278399498664458556235088519034392334042743e89) }}, 
      {{ SC_(0.39e2), SC_(0.264718536376953125e3), SC_(0.16844681844036883180732006970124952352016202896335e107) }}, 
      {{ SC_(0.39e2), SC_(0.62944732666015625e3), SC_(0.79282992531231013164557766874391393793620400228182e121) }}, 
      {{ SC_(0.39e2), SC_(0.67001715087890625e3), SC_(0.90607106164123497973412471364934371536090344651122e122) }}, 
      {{ SC_(0.39e2), SC_(0.8115838623046875e3), SC_(0.15992937684273997816389764191323771941192143088137e126) }}, 
      {{ SC_(0.39e2), SC_(0.826751708984375e3), SC_(0.32927849440442967893014023065851364647504023336502e126) }}, 
      {{ SC_(0.39e2), SC_(0.915013671875e3), SC_(0.17204948941327849876886583966673548861348150480047e128) }}, 
      {{ SC_(0.39e2), SC_(0.92977703857421875e3), SC_(0.32118669970741829532274318795611234943703447184318e128) }}, 
      {{ SC_(0.39e2), SC_(0.935389892578125e3), SC_(0.40616281816935655137092990493617134292648729550904e128) }}, 
      {{ SC_(0.39e2), SC_(0.93773553466796875e3), SC_(0.44783848423962576280686207253637725919398807964991e128) }}, 
      {{ SC_(0.39e2), SC_(0.9857625732421875e3), SC_(0.31414121592483655223358586186570433075795817612805e129) }}, 
      {{ SC_(0.39e2), SC_(0.99292266845703125e3), SC_(0.41658940895066107629573195609678148243112628749343e129) }}, 
      {{ SC_(0.45e2), SC_(-0.804919189453125e3), SC_(-0.20177652617081516828796062978793212005967378239278e145) }}, 
      {{ SC_(0.45e2), SC_(-0.7460263671875e3), SC_(-0.66054362280026053027757226707948088361626920155376e143) }}, 
      {{ SC_(0.45e2), SC_(-0.72904595947265625e3), SC_(-0.23437762835351403192537934629393907610069449299426e143) }}, 
      {{ SC_(0.45e2), SC_(-0.623236083984375e3), SC_(-0.20191234366700387819456850806321219529162264687134e140) }}, 
      {{ SC_(0.45e2), SC_(-0.557931884765625e3), SC_(-0.13861566456362123983928798104717105733858371444012e138) }}, 
      {{ SC_(0.45e2), SC_(-0.4430035400390625e3), SC_(-0.4301086017862310895138269448383055939513087622341e133) }}, 
      {{ SC_(0.45e2), SC_(-0.383665924072265625e3), SC_(-0.66494301129444185596750408117972477105468841816721e130) }}, 
      {{ SC_(0.45e2), SC_(0.9376299285888671875e2), SC_(0.18333784965891816055634592173380010722775781361257e103) }}, 
      {{ SC_(0.45e2), SC_(0.944411773681640625e2), SC_(0.25377609054299635959133533485034878034770237870855e103) }}, 
      {{ SC_(0.45e2), SC_(0.264718536376953125e3), SC_(0.37031983921392566542882397192210777179841273988766e123) }}, 
      {{ SC_(0.45e2), SC_(0.62944732666015625e3), SC_(0.31548585244541078317730225584275069164749251087912e140) }}, 
      {{ SC_(0.45e2), SC_(0.67001715087890625e3), SC_(0.52449010750697955051865066615853016859407067184864e141) }}, 
      {{ SC_(0.45e2), SC_(0.8115838623046875e3), SC_(0.29243310998128485711320487541829024461612289350623e145) }}, 
      {{ SC_(0.45e2), SC_(0.826751708984375e3), SC_(0.67284470764543020205762565613634748045278625515089e145) }}, 
      {{ SC_(0.45e2), SC_(0.915013671875e3), SC_(0.64615138415071315639177660571353142846045239347149e147) }}, 
      {{ SC_(0.45e2), SC_(0.92977703857421875e3), SC_(0.13278465208846749403260592878660521765302807431305e148) }}, 
      {{ SC_(0.45e2), SC_(0.935389892578125e3), SC_(0.17409022045455533776480508364766372898141301944389e148) }}, 
      {{ SC_(0.45e2), SC_(0.93773553466796875e3), SC_(0.19485974768216439208285778668083407454632111197255e148) }}, 
      {{ SC_(0.45e2), SC_(0.9857625732421875e3), SC_(0.18445192865916870046874911219161320468109838186066e149) }}, 
      {{ SC_(0.45e2), SC_(0.99292266845703125e3), SC_(0.25546176490459737663363913718086950038159915308274e149) }}, 
      {{ SC_(0.51e2), SC_(-0.804919189453125e3), SC_(-0.35113067934471903608940090834892095681626290434468e164) }}, 
      {{ SC_(0.51e2), SC_(-0.7460263671875e3), SC_(-0.72861035303836242811895086171124040853873378556859e162) }}, 
      {{ SC_(0.51e2), SC_(-0.72904595947265625e3), SC_(-0.22516927484966890282733144933534878130289199412883e162) }}, 
      {{ SC_(0.51e2), SC_(-0.623236083984375e3), SC_(-0.75700551095940008948839545651408145857924835535314e158) }}, 
      {{ SC_(0.51e2), SC_(-0.557931884765625e3), SC_(-0.26747336473574897356349179458053032541482550593711e156) }}, 
      {{ SC_(0.51e2), SC_(-0.4430035400390625e3), SC_(-0.20791502822466935421380862320061247482854365500361e151) }}, 
      {{ SC_(0.51e2), SC_(-0.383665924072265625e3), SC_(-0.13560110864020767509838384997192616330691476967023e148) }}, 
      {{ SC_(0.51e2), SC_(0.9376299285888671875e2), SC_(0.7844280896526308516074269853664693048016422885788e116) }}, 
      {{ SC_(0.51e2), SC_(0.944411773681640625e2), SC_(0.11340516612470737945168942456374532537814010961263e117) }}, 
      {{ SC_(0.51e2), SC_(0.264718536376953125e3), SC_(0.8139158117208128107600789052906528734475559194321e139) }}, 
      {{ SC_(0.51e2), SC_(0.62944732666015625e3), SC_(0.12553360744823564136379193666030734806903596181629e159) }}, 
      {{ SC_(0.51e2), SC_(0.67001715087890625e3), SC_(0.30359521798851670232517253916274343728895102603204e160) }}, 
      {{ SC_(0.51e2), SC_(0.8115838623046875e3), SC_(0.53470343158952394904110199377387174554239573865167e164) }}, 
      {{ SC_(0.51e2), SC_(0.826751708984375e3), SC_(0.13748486014792215950745539075543408808157303622984e165) }}, 
      {{ SC_(0.51e2), SC_(0.915013671875e3), SC_(0.24266426827928055351392414540851775403703580214217e167) }}, 
      {{ SC_(0.51e2), SC_(0.92977703857421875e3), SC_(0.54894541709901192178430511542775801375289469157154e167) }}, 
      {{ SC_(0.51e2), SC_(0.935389892578125e3), SC_(0.74617320843153667181219888046018738983602740835413e167) }}, 
      {{ SC_(0.51e2), SC_(0.93773553466796875e3), SC_(0.84784013234216460630444016007134974974311144452262e167) }}, 
      {{ SC_(0.51e2), SC_(0.9857625732421875e3), SC_(0.10830124161130178144242398936552356375378307471608e169) }}, 
      {{ SC_(0.51e2), SC_(0.99292266845703125e3), SC_(0.15665189838824983265666665985359283999947248743347e169) }}, 
      {{ SC_(0.56e2), SC_(-0.804919189453125e3), SC_(0.37956952705673899523586509921906408164373807674842e180) }}, 
      {{ SC_(0.56e2), SC_(-0.7460263671875e3), SC_(0.53865761270243895218660088472139211384451502688444e178) }}, 
      {{ SC_(0.56e2), SC_(-0.72904595947265625e3), SC_(0.14836291945588844494615487801685475362266135705863e178) }}, 
      {{ SC_(0.56e2), SC_(-0.623236083984375e3), SC_(0.2277004071341410372485292551385366645114538651319e174) }}, 
      {{ SC_(0.56e2), SC_(-0.557931884765625e3), SC_(0.46254239457392849536097636343005820458364173895835e171) }}, 
      {{ SC_(0.56e2), SC_(-0.4430035400390625e3), SC_(0.11344322644944075407583022851137024031178340092676e166) }}, 
      {{ SC_(0.56e2), SC_(-0.383665924072265625e3), SC_(0.3604029445291060010597333365239904139445634244682e162) }}, 
      {{ SC_(0.56e2), SC_(0.9376299285888671875e2), SC_(0.17917836479447994128429607949378029035674025577673e128) }}, 
      {{ SC_(0.56e2), SC_(0.944411773681640625e2), SC_(0.26860211927393157242420521317036063000474023936209e128) }}, 
      {{ SC_(0.56e2), SC_(0.264718536376953125e3), SC_(0.33793221965866674010877371813884434555285225328484e153) }}, 
      {{ SC_(0.56e2), SC_(0.62944732666015625e3), SC_(0.3967908983994242852488795641829100505059948945886e174) }}, 
      {{ SC_(0.56e2), SC_(0.67001715087890625e3), SC_(0.13114336111849403294532365713586373376802346102155e176) }}, 
      {{ SC_(0.56e2), SC_(0.8115838623046875e3), SC_(0.60234123418783718853851595976503029458229189410396e180) }}, 
      {{ SC_(0.56e2), SC_(0.826751708984375e3), SC_(0.16990109127454550637210380678211174380489674917725e181) }}, 
      {{ SC_(0.56e2), SC_(0.915013671875e3), SC_(0.49799501294713322660639045532203723491746004194747e183) }}, 
      {{ SC_(0.56e2), SC_(0.92977703857421875e3), SC_(0.12204125317946036746710422027579851417765551382392e184) }}, 
      {{ SC_(0.56e2), SC_(0.935389892578125e3), SC_(0.17095713176585659186454296245218656651525776780725e184) }}, 
      {{ SC_(0.56e2), SC_(0.93773553466796875e3), SC_(0.19669819452346534508628039944949105246308228599223e184) }}, 
      {{ SC_(0.56e2), SC_(0.9857625732421875e3), SC_(0.32254166162174546082031232457620847112857288236855e185) }}, 
      {{ SC_(0.56e2), SC_(0.99292266845703125e3), SC_(0.48373153428656361382291434304002503158410721745942e185) }}, 
      {{ SC_(0.57e2), SC_(-0.804919189453125e3), SC_(-0.61101918351066762254837696533065612479073827625339e183) }}, 
      {{ SC_(0.57e2), SC_(-0.7460263671875e3), SC_(-0.80366512793162060755260340674092236229261177996538e181) }}, 
      {{ SC_(0.57e2), SC_(-0.72904595947265625e3), SC_(-0.21631537718132322785026887852553957902317657529606e181) }}, 
      {{ SC_(0.57e2), SC_(-0.623236083984375e3), SC_(-0.28380175897994405792364081835185957992965246876733e177) }}, 
      {{ SC_(0.57e2), SC_(-0.557931884765625e3), SC_(-0.51608787018272790263523340429339097513443327878663e174) }}, 
      {{ SC_(0.57e2), SC_(-0.4430035400390625e3), SC_(-0.10049715947268959326175464756561482222757046735464e169) }}, 
      {{ SC_(0.57e2), SC_(-0.383665924072265625e3), SC_(-0.27649604314284126019945358499982753402436545672245e165) }}, 
      {{ SC_(0.57e2), SC_(0.9376299285888671875e2), SC_(0.33493248264114118064961943143309153369336052283655e130) }}, 
      {{ SC_(0.57e2), SC_(0.944411773681640625e2), SC_(0.50574435912900833357638094070860620693483455185529e130) }}, 
      {{ SC_(0.57e2), SC_(0.264718536376953125e3), SC_(0.17884232906826524447185414852294643372537962801178e156) }}, 
      {{ SC_(0.57e2), SC_(0.62944732666015625e3), SC_(0.49948263676019952928838146649270004499157772826431e177) }}, 
      {{ SC_(0.57e2), SC_(0.67001715087890625e3), SC_(0.17572564071949802842269744081820746771877926177782e179) }}, 
      {{ SC_(0.57e2), SC_(0.8115838623046875e3), SC_(0.97765928672497151482926812987129698670202679297201e183) }}, 
      {{ SC_(0.57e2), SC_(0.826751708984375e3), SC_(0.28092052643116613825516813603329050857884446218931e184) }}, 
      {{ SC_(0.57e2), SC_(0.915013671875e3), SC_(0.91131401181535063754738627124893068439463063019439e186) }}, 
      {{ SC_(0.57e2), SC_(0.92977703857421875e3), SC_(0.22693495921347868926954075794146960262148934686144e187) }}, 
      {{ SC_(0.57e2), SC_(0.935389892578125e3), SC_(0.31981291103834949752057837490286659313504601339537e187) }}, 
      {{ SC_(0.57e2), SC_(0.93773553466796875e3), SC_(0.3688900263643316286828693487885916009055229488776e187) }}, 
      {{ SC_(0.57e2), SC_(0.9857625732421875e3), SC_(0.63588067294915941815083020546700816691123140834824e188) }}, 
      {{ SC_(0.57e2), SC_(0.99292266845703125e3), SC_(0.96058872887019210683457681330939837205699369069038e188) }}, 
      {{ SC_(0.58e2), SC_(-0.804919189453125e3), SC_(0.98359886093734917799148104471362134113448742301714e186) }}, 
      {{ SC_(0.58e2), SC_(-0.7460263671875e3), SC_(0.11990493446843606374834114171768752791672975254446e185) }}, 
      {{ SC_(0.58e2), SC_(-0.72904595947265625e3), SC_(0.31539079003887667778314531807612639455207724902675e184) }}, 
      {{ SC_(0.58e2), SC_(-0.623236083984375e3), SC_(0.35372503594266224135242856515913702867323328261754e180) }}, 
      {{ SC_(0.58e2), SC_(-0.557931884765625e3), SC_(0.57583102639847172932211962567906075469963542052781e177) }}, 
      {{ SC_(0.58e2), SC_(-0.4430035400390625e3), SC_(0.89028262292728150610074140793563782680236919953946e171) }}, 
      {{ SC_(0.58e2), SC_(-0.383665924072265625e3), SC_(0.21212313385377011281086353425598128241401586598077e168) }}, 
      {{ SC_(0.58e2), SC_(0.9376299285888671875e2), SC_(0.62604280620315333688059710381693364286527097504684e132) }}, 
      {{ SC_(0.58e2), SC_(0.944411773681640625e2), SC_(0.95219979030929997425749816310432879664361450597778e132) }}, 
      {{ SC_(0.58e2), SC_(0.264718536376953125e3), SC_(0.94647234913352100793292091066282848088891601986906e158) }}, 
      {{ SC_(0.58e2), SC_(0.62944732666015625e3), SC_(0.62875078668132942835299336264682658691294193188921e180) }}, 
      {{ SC_(0.58e2), SC_(0.67001715087890625e3), SC_(0.23546343591932925637627633040847742798191272458582e182) }}, 
      {{ SC_(0.58e2), SC_(0.8115838623046875e3), SC_(0.1586836332975899142098791524978601596019926315731e187) }}, 
      {{ SC_(0.58e2), SC_(0.826751708984375e3), SC_(0.4644836819071084866920807074412876527322435540979e187) }}, 
      {{ SC_(0.58e2), SC_(0.915013671875e3), SC_(0.16676727889331262695178791842169909031457948784922e190) }}, 
      {{ SC_(0.58e2), SC_(0.92977703857421875e3), SC_(0.4219839159500762095101501614050659421526810441788e190) }}, 
      {{ SC_(0.58e2), SC_(0.935389892578125e3), SC_(0.59828003988949705942467519636630498279885402269671e190) }}, 
      {{ SC_(0.58e2), SC_(0.93773553466796875e3), SC_(0.6918201486186995412987998601049879246333891924841e190) }}, 
      {{ SC_(0.58e2), SC_(0.9857625732421875e3), SC_(0.12536179671332495944243061484163599674602312949226e192) }}, 
      {{ SC_(0.58e2), SC_(0.99292266845703125e3), SC_(0.19075255025241690115123922486625852876773950080745e192) }}, 
      {{ SC_(0.63e2), SC_(-0.804919189453125e3), SC_(-0.10632339781549610479619041406969505999094943001127e203) }}, 
      {{ SC_(0.63e2), SC_(-0.7460263671875e3), SC_(-0.88642268599629660190193212265296202307985906354271e200) }}, 
      {{ SC_(0.63e2), SC_(-0.72904595947265625e3), SC_(-0.20780258561878800838820505487610226573992568239933e200) }}, 
      {{ SC_(0.63e2), SC_(-0.623236083984375e3), SC_(-0.10639249520755456192441242211860915411315791499976e196) }}, 
      {{ SC_(0.63e2), SC_(-0.557931884765625e3), SC_(-0.99573011685276296405964197038004635064052319284641e192) }}, 
      {{ SC_(0.63e2), SC_(-0.4430035400390625e3), SC_(-0.48571536473640903389946459864193429311269021644027e186) }}, 
      {{ SC_(0.63e2), SC_(-0.383665924072265625e3), SC_(-0.56371743060385144846172065591557429748970112940914e182) }}, 
      {{ SC_(0.63e2), SC_(0.9376299285888671875e2), SC_(0.14271302095518395281543621141977089654954772619788e144) }}, 
      {{ SC_(0.63e2), SC_(0.944411773681640625e2), SC_(0.22508389703746523206446686216061289081224009447363e144) }}, 
      {{ SC_(0.63e2), SC_(0.264718536376953125e3), SC_(0.39287053618749596805247838834868920108072746443261e172) }}, 
      {{ SC_(0.63e2), SC_(0.62944732666015625e3), SC_(0.19872890857509752124510053434485063729806672066544e196) }}, 
      {{ SC_(0.63e2), SC_(0.67001715087890625e3), SC_(0.10170865885145417099920546695659459436546383064557e198) }}, 
      {{ SC_(0.63e2), SC_(0.8115838623046875e3), SC_(0.17875171562625846347044457253137830450493155571305e203) }}, 
      {{ SC_(0.63e2), SC_(0.826751708984375e3), SC_(0.57398511841594632428896306873234439485078800626987e203) }}, 
      {{ SC_(0.63e2), SC_(0.915013671875e3), SC_(0.34223224444163024879350378835610921837107268568578e206) }}, 
      {{ SC_(0.63e2), SC_(0.92977703857421875e3), SC_(0.93813340474969400259457231849952645213403537063766e206) }}, 
      {{ SC_(0.63e2), SC_(0.935389892578125e3), SC_(0.13707031097909198997249615373069943591630589477967e207) }}, 
      {{ SC_(0.63e2), SC_(0.93773553466796875e3), SC_(0.16049849565534916612881402821512234443315362144539e207) }}, 
      {{ SC_(0.63e2), SC_(0.9857625732421875e3), SC_(0.37334450988860541714846867055901320093308859706429e208) }}, 
      {{ SC_(0.63e2), SC_(0.99292266845703125e3), SC_(0.58902181682496407079087992188679937502927943188616e208) }}, 
      {{ SC_(0.64e2), SC_(-0.804919189453125e3), SC_(0.17115516418393134930956957812660695576555555762758e206) }}, 
      {{ SC_(0.64e2), SC_(-0.7460263671875e3), SC_(0.13225145321763463912506947704427473546594227919316e204) }}, 
      {{ SC_(0.64e2), SC_(-0.72904595947265625e3), SC_(0.30297731266319142519300755555505275478042104969272e203) }}, 
      {{ SC_(0.64e2), SC_(-0.623236083984375e3), SC_(0.13260452858231441701364025090498088686052853448746e199) }}, 
      {{ SC_(0.64e2), SC_(-0.557931884765625e3), SC_(0.11109867155607531886714022377600211420414450985886e196) }}, 
      {{ SC_(0.64e2), SC_(-0.4430035400390625e3), SC_(0.43027816705124422567335810872343924647776816168804e189) }}, 
      {{ SC_(0.64e2), SC_(-0.383665924072265625e3), SC_(0.43246575293235977119550453324173254248977085615388e185) }}, 
      {{ SC_(0.64e2), SC_(0.9376299285888671875e2), SC_(0.26666169562221769162394467872454407158823797408949e146) }}, 
      {{ SC_(0.64e2), SC_(0.944411773681640625e2), SC_(0.42363701592310910625385021135765655947792198743379e146) }}, 
      {{ SC_(0.64e2), SC_(0.264718536376953125e3), SC_(0.20790668653430943824657625408670573026507147506956e175) }}, 
      {{ SC_(0.64e2), SC_(0.62944732666015625e3), SC_(0.25015886856901675365191238194104964033185766836862e199) }}, 
      {{ SC_(0.64e2), SC_(0.67001715087890625e3), SC_(0.13628352758104430128024379960258832981315670559497e201) }}, 
      {{ SC_(0.64e2), SC_(0.8115838623046875e3), SC_(0.29013013909125825894222647618781410860190657751511e206) }}, 
      {{ SC_(0.64e2), SC_(0.826751708984375e3), SC_(0.94904261445892845427164871048618979106779458453012e206) }}, 
      {{ SC_(0.64e2), SC_(0.915013671875e3), SC_(0.62627080118909857764651282371070544817106870626377e209) }}, 
      {{ SC_(0.64e2), SC_(0.92977703857421875e3), SC_(0.17444462292196609464011437538057068543663586540673e210) }}, 
      {{ SC_(0.64e2), SC_(0.935389892578125e3), SC_(0.2564191346937588459943377158334215703301569930735e210) }}, 
      {{ SC_(0.64e2), SC_(0.93773553466796875e3), SC_(0.30099950210351799644573209378329679609266360231058e210) }}, 
      {{ SC_(0.64e2), SC_(0.9857625732421875e3), SC_(0.7360342283709939198893572318455103257992843130489e211) }}, 
      {{ SC_(0.64e2), SC_(0.99292266845703125e3), SC_(0.11696688542326119628103847394518779891392342956315e212) }}, 
      {{ SC_(0.67e2), SC_(-0.804919189453125e3), SC_(-0.71395604865066606122013699661891426203463873068701e215) }}, 
      {{ SC_(0.67e2), SC_(-0.7460263671875e3), SC_(-0.439214716391687364187564024021732580606512402522e213) }}, 
      {{ SC_(0.67e2), SC_(-0.72904595947265625e3), SC_(-0.93904227402788407947934394389327512970670916128791e212) }}, 
      {{ SC_(0.67e2), SC_(-0.623236083984375e3), SC_(-0.25674209768421442693190102856604340847503916248831e208) }}, 
      {{ SC_(0.67e2), SC_(-0.557931884765625e3), SC_(-0.15431436217922364421260050431856648098623138071202e205) }}, 
      {{ SC_(0.67e2), SC_(-0.4430035400390625e3), SC_(-0.29911973822576646623652589847208017875520526334749e198) }}, 
      {{ SC_(0.67e2), SC_(-0.383665924072265625e3), SC_(-0.19526015822885353474843208279944006332888244454282e194) }}, 
      {{ SC_(0.67e2), SC_(0.9376299285888671875e2), SC_(0.17390093432109562491103911511920483031011929481849e153) }}, 
      {{ SC_(0.67e2), SC_(0.944411773681640625e2), SC_(0.28235446461762290115209086851319733390024540548019e153) }}, 
      {{ SC_(0.67e2), SC_(0.264718536376953125e3), SC_(0.30811073596496146740945598370500903220318751173999e183) }}, 
      {{ SC_(0.67e2), SC_(0.62944732666015625e3), SC_(0.498973159123135317026153053869666153823987778347e208) }}, 
      {{ SC_(0.67e2), SC_(0.67001715087890625e3), SC_(0.3278662999965262740459597303725252570646839606698e210) }}, 
      {{ SC_(0.67e2), SC_(0.8115838623046875e3), SC_(0.12405627888491721174744514866737147152869324775397e216) }}, 
      {{ SC_(0.67e2), SC_(0.826751708984375e3), SC_(0.42898198132773354897094247581039524281956225063702e216) }}, 
      {{ SC_(0.67e2), SC_(0.915013671875e3), SC_(0.3837817535891570776096316064925826289234604649913e219) }}, 
      {{ SC_(0.67e2), SC_(0.92977703857421875e3), SC_(0.11215923554489890999502780719902857630724401847727e220) }}, 
      {{ SC_(0.67e2), SC_(0.935389892578125e3), SC_(0.16786882000412698244055579620069098918136636351948e220) }}, 
      {{ SC_(0.67e2), SC_(0.93773553466796875e3), SC_(0.19854032506834645795880992848204146407286886570974e220) }}, 
      {{ SC_(0.67e2), SC_(0.9857625732421875e3), SC_(0.56397700344853850069466092015119332034498084181404e221) }}, 
      {{ SC_(0.67e2), SC_(0.99292266845703125e3), SC_(0.91591725002034144260314292567223030779705284774582e221) }}, 
      {{ SC_(0.68e2), SC_(-0.804919189453125e3), SC_(0.11492944165481977844160639042749889711435705439192e219) }}, 
      {{ SC_(0.68e2), SC_(-0.7460263671875e3), SC_(0.65529207072689878516628373246771524546998394796728e216) }}, 
      {{ SC_(0.68e2), SC_(-0.72904595947265625e3), SC_(0.13691236470932295418206009271231802321826433996401e216) }}, 
      {{ SC_(0.68e2), SC_(-0.623236083984375e3), SC_(0.31999427611473638064153349246682256767532212572302e211) }}, 
      {{ SC_(0.68e2), SC_(-0.557931884765625e3), SC_(0.1721752728616940687565723581862597609692534907115e208) }}, 
      {{ SC_(0.68e2), SC_(-0.4430035400390625e3), SC_(0.26497695928277797274126269348797127034206387419765e201) }}, 
      {{ SC_(0.68e2), SC_(-0.383665924072265625e3), SC_(0.14979523193992880308778135191580896285724901609253e197) }}, 
      {{ SC_(0.68e2), SC_(0.9376299285888671875e2), SC_(0.32486210198364986836850518198819815917013154840805e155) }}, 
      {{ SC_(0.68e2), SC_(0.944411773681640625e2), SC_(0.53130717007794880022412938335190211916976004706358e155) }}, 
      {{ SC_(0.68e2), SC_(0.264718536376953125e3), SC_(0.16304722685276499354792918086631605049027512979648e186) }}, 
      {{ SC_(0.68e2), SC_(0.62944732666015625e3), SC_(0.62810152575355789173710546297818953525375445861782e211) }}, 
      {{ SC_(0.68e2), SC_(0.67001715087890625e3), SC_(0.43931930018461310588579182708322391145380014657504e213) }}, 
      {{ SC_(0.68e2), SC_(0.8115838623046875e3), SC_(0.20135390598861294342717207643575046227436307960836e219) }}, 
      {{ SC_(0.68e2), SC_(0.826751708984375e3), SC_(0.70928840597252373257415593809153908579367912600248e219) }}, 
      {{ SC_(0.68e2), SC_(0.915013671875e3), SC_(0.70230300036076744196859829023426726976063282233909e222) }}, 
      {{ SC_(0.68e2), SC_(0.92977703857421875e3), SC_(0.2085580812121490632054276902743441722437005132514e223) }}, 
      {{ SC_(0.68e2), SC_(0.935389892578125e3), SC_(0.31403357047962017949167805427442757459524063192189e223) }}, 
      {{ SC_(0.68e2), SC_(0.93773553466796875e3), SC_(0.37234244977852621303836114362570239474544522838737e223) }}, 
      {{ SC_(0.68e2), SC_(0.9857625732421875e3), SC_(0.11118565108245626237683701654760798812770117180759e225) }}, 
      {{ SC_(0.68e2), SC_(0.99292266845703125e3), SC_(0.18188081940210288468029442085277750466942046125126e225) }}, 
      {{ SC_(0.69e2), SC_(-0.804919189453125e3), SC_(-0.1850081162399338654500028296297913252183226453783e222) }}, 
      {{ SC_(0.69e2), SC_(-0.7460263671875e3), SC_(-0.97767059274089595678968982337826854278140139586519e219) }}, 
      {{ SC_(0.69e2), SC_(-0.72904595947265625e3), SC_(-0.19961804161143040928554705782175334155063670416805e219) }}, 
      {{ SC_(0.69e2), SC_(-0.623236083984375e3), SC_(-0.39882904216104119883607723276479909045844467958239e214) }}, 
      {{ SC_(0.69e2), SC_(-0.557931884765625e3), SC_(-0.19210316224226509857981603548527956113322666380888e211) }}, 
      {{ SC_(0.69e2), SC_(-0.4430035400390625e3), SC_(-0.23473078169771562662136461616843138538409966193101e204) }}, 
      {{ SC_(0.69e2), SC_(-0.383665924072265625e3), SC_(-0.11491609678618516149736741904351620655468528386497e200) }}, 
      {{ SC_(0.69e2), SC_(0.9376299285888671875e2), SC_(0.60683580626155093065325198848663480816576016092558e157) }}, 
      {{ SC_(0.69e2), SC_(0.944411773681640625e2), SC_(0.99970547300737778074794585861930502873180772144862e157) }}, 
      {{ SC_(0.69e2), SC_(0.264718536376953125e3), SC_(0.86281343445478761898014189584430395982291880632205e188) }}, 
      {{ SC_(0.69e2), SC_(0.62944732666015625e3), SC_(0.79064579216384384919861590442204758056478775930199e214) }}, 
      {{ SC_(0.69e2), SC_(0.67001715087890625e3), SC_(0.58865834185481932389898790561772677853802379658932e216) }}, 
      {{ SC_(0.69e2), SC_(0.8115838623046875e3), SC_(0.32681428977081852902063701892528533163973331914428e222) }}, 
      {{ SC_(0.69e2), SC_(0.826751708984375e3), SC_(0.11727524620517137714481833672797036884220596207432e223) }}, 
      {{ SC_(0.69e2), SC_(0.915013671875e3), SC_(0.1285181499939382408174721290089724705670081991561e226) }}, 
      {{ SC_(0.69e2), SC_(0.92977703857421875e3), SC_(0.38780977658427262634355280276612655888568370486454e226) }}, 
      {{ SC_(0.69e2), SC_(0.935389892578125e3), SC_(0.58746482535419337038893161712202335100520637411516e226) }}, 
      {{ SC_(0.69e2), SC_(0.93773553466796875e3), SC_(0.69829049096108586661576816358605949519674563343367e226) }}, 
      {{ SC_(0.69e2), SC_(0.9857625732421875e3), SC_(0.21919763695005329034056321076749362840532324690225e228) }}, 
      {{ SC_(0.69e2), SC_(0.99292266845703125e3), SC_(0.36117472060917448197562379204160182702204274274195e228) }}
   }};

