/*
 * Common part of SIGCHLD handling for diff.parts of binkd
 * Should be included in chld()
 */
/* 
 * $Id: reapchld.inc,v 2.1 2003/03/10 08:38:07 gul Exp $
 *
 * $Log: reapchld.inc,v $
 * Revision 2.1  2003/03/10 08:38:07  gul
 * Make n_servers/n_clients changes thread-safe
 *
 * Revision 2.0  2001/01/10 12:12:39  gul
 * Binkd is under CVS again
 *
 *
 */
{
  int old_errno = errno;
  int status;
  int pid;
  extern int pidcmgr;

#ifdef HAVE_WAITPID
  while ((pid = waitpid (-1, &status, WNOHANG)) > 0)	/* NO ";" !!! */
#else
  pid = (int) wait (&status);
#endif
  if (pid > 0)
  {
    if (pidcmgr && pid == pidcmgr) {
      Log (0, "client manager (pid=%u) exited, retcode %u", pid, status);
      exit(4);
    }
#ifdef CHILDCOUNT
    threadsafe(CHILDCOUNT--);
#endif
    Log (4, "rc(%i)=%i", pid, status);
  }

#ifdef SYS5SIGNALS
  signal (SIGCHLD, chld);
#endif
#ifdef EMXSIGNALS
  signal (SIGCHLD, SIG_ACK);
#endif
  errno = old_errno;
}
