if (typeof Test === 'undefined') require('../tester');

Test('negated', function () {

    function t(expected, value){
        Test.areEqual(String(expected), new BigNumber(value).negated().toString());
    }

    BigNumber.config({
        DECIMAL_PLACES: 20,
        ROUNDING_MODE: 4,
        RANGE: 1E9,
        EXPONENTIAL_AT: [-7, 21]
    });

    t(-4, 4);
    t(-2147483648, 2147483648);
    t(-0.25, 0.25);
    t(-0.0625, 0.0625);
    t(-1, 1);
    t(1, -1);
    t(0, 0);
    t(NaN, NaN);
    t(-Infinity, Infinity);
    t(-Infinity, +Infinity);
    t(Infinity, -Infinity);
    t(+Infinity, -Infinity);

    t('0', '0');
    t('-238', '238');
    t('1.3e-11', '-0.000000000013');
    t('-33.1', '33.1');
    t('2.61', '-2.61');
    t('-4', '4.0');
    t('-5.8', '5.8');
    t('-3.52e-7', '0.000000352');
    t('190', '-190');
    t('4.47', '-4.47');
    t('6.9525e-12', '-0.0000000000069525');
    t('1.3', '-1.3');
    t('-6.21', '6.21');
    t('2', '-2');
    t('-1', '1');
    t('147.857', '-147.857');
    t('-26.517', '26.517');
    t('-3', '3');
    t('5', '-5');
    t('204', '-204');
    t('2.1e-8', '-0.000000021');
    t('3.7015e-7', '-0.00000037015');
    t('-50.1839', '50.1839');
    t('44768.1', '-44768.1');
    t('3.8e-15', '-0.0000000000000038');
    t('-7.4379', '7.4379');
    t('1.5', '-1.5');
    t('6.0399', '-6.0399');
    t('109.07', '-109.070');
    t('1582', '-1582');
    t('-772', '772');
    t('-6.7824e-14', '0.000000000000067824');
    t('-1.819e-8', '0.00000001819');
    t('-3e-15', '0.0000000000000030');
    t('-424120', '424120');
    t('-1814.54', '1814.54');
    t('-4.295e-17', '0.00000000000000004295');
    t('-5', '5');
    t('2152', '-2152');
    t('4.6', '-4.6');
    t('1.9', '-1.9');
    t('-2', '2.0');
    t('-0.00036', '0.00036');
    t('-0.000006962', '0.000006962');
    t('3.6', '-3.6');
    t('-1.1495e-14', '0.000000000000011495');
    t('-312.4', '312.4');
    t('4.3e-10', '-0.00000000043');
    t('5', '-5');
    t('-1.8911e-8', '0.000000018911');
    t('4963.53', '-4963.53');
    t('-4.3934e-10', '0.00000000043934');
    t('-1.3', '1.30');
    t('-1', '1.0');
    t('-68.32', '68.32');
    t('0.014836', '-0.014836');
    t('8', '-8');
    t('2.1351', '-2.13510');
    t('162224', '-162224');
    t('3e-19', '-0.00000000000000000030');
    t('0.00004985', '-0.00004985');
    t('28.9321', '-28.9321');
    t('-2', '2');
    t('-16688', '16688');
    t('-1', '1');
    t('5', '-5');
    t('-20', '20.0');
    t('-1.9', '1.9');
    t('3', '-3');
    t('185640', '-185640');
    t('-0.0000058', '0.0000058');
    t('9.67e-13', '-0.000000000000967');
    t('-707.98', '707.98');
    t('2.57917', '-2.57917');
    t('-1.3', '1.3');
    t('-4.2655', '4.2655');
    t('-149.6', '149.6');
    t('-1.32383', '1.32383');
    t('-26.925', '26.925');
    t('-0.00013', '0.00013');
    t('-6868', '6868');
    t('7', '-7');
    t('-5e-9', '0.0000000050');
    t('3.2555e-16', '-0.00000000000000032555');
    t('1.42768e-13', '-0.000000000000142768');
    t('11.2962', '-11.2962');
    t('3186.7', '-3186.7');
    t('-6.9', '6.9');
    t('-6.2618e-7', '0.00000062618');
    t('8', '-8');
    t('-8.04', '8.04');
    t('-22', '22');
    t('-750.6', '750.6');
    t('12.803', '-12.803');
    t('-20513.4', '20513.4');
    t('114781', '-114781');
    t('-16.9046', '16.9046');
    t('4.6e-7', '-0.00000046');
    t('-31399', '31399');
    t('1.04', '-1.04');
    t('-51.2544', '51.2544');
    t('1.023e-15', '-0.000000000000001023');
    t('281', '-281');
    t('-128315', '128315');
    t('20.2', '-20.2');
    t('9', '-9');
    t('-10', '10');
    t('-1.92262e-17', '0.0000000000000000192262');
    t('-0.0023', '0.0023');
    t('5', '-5');
    t('7', '-7');
    t('13.72', '-13.72');
    t('98068', '-98068');
    t('3.2', '-3.2');
    t('1.1', '-1.1');
    t('-3.97e-18', '0.000000000000000003970');
    t('0.00334824', '-0.00334824');
    t('-5.4892e-8', '0.000000054892');
    t('-1', '1.0');
    t('-2.8135e-8', '0.000000028135');
    t('-1.816e-13', '0.0000000000001816');
    t('199724', '-199724');
    t('-19.4', '19.40');
    t('-12.74', '12.74');
    t('-2171.8', '2171.8');
    t('-2.7', '2.7');
    t('1', '-1.0');
    t('21779', '-21779');
    t('8.9e-12', '-0.0000000000089');
    t('-4.51', '4.51');
    t('2.6', '-2.6');
    t('-0.00016', '0.000160');
    t('6', '-6');
    t('50.566', '-50.566');
    t('-16.2', '16.2');
    t('-7.9156e-20', '0.000000000000000000079156');
    t('-2262.4', '2262.4');
    t('6468.59', '-6468.59');
    t('0.077', '-0.077');
    t('-465.83', '465.83');
    t('-604.59', '604.59');
    t('-0.0014917', '0.0014917');
    t('-2.8954', '2.8954');
    t('1', '-1');
    t('1942', '-1942');
    t('-182.308', '182.308');
    t('-17.8', '17.8');
    t('39472.5', '-39472.5');
    t('214.21', '-214.21');
    t('-40.11', '40.11');
    t('-3', '3');
    t('141149', '-141149');
    t('-8', '8.0');
    t('-2.9', '2.9');
    t('44.51', '-44.51');
    t('-5.3', '5.3');
    t('0.05498', '-0.054980');
    t('7', '-7');
    t('-922', '922.0');
    t('-1.5146e-14', '0.000000000000015146');
    t('-0.000008117', '0.000008117');
    t('1', '-1');
    t('5452.81', '-5452.81');
    t('751745', '-751745');
    t('-2.7', '2.7');
    t('5.1', '-5.1');
    t('-1', '1');
    t('-524124', '524124');
    t('-183.5', '183.50');
    t('44856.8', '-44856.8');
    t('0.00000387', '-0.00000387');
    t('-3.0544e-14', '0.000000000000030544');
    t('1.3', '-1.3');
    t('-0.0019273', '0.0019273');
    t('75428', '-75428');
    t('-91.7925', '91.7925');
    t('44.5', '-44.5');
    t('-2', '2');
    t('5.3', '-5.3');
    t('-57', '57');
    t('-2.53e-9', '0.00000000253');
    t('18258', '-18258');
    t('0.829', '-0.829');
    t('-4', '4');
    t('-1', '1');
    t('10.289', '-10.289');
    t('319', '-319');
    t('2.4', '-2.4');
    t('89.9207', '-89.9207');
    t('-9.06122e-17', '0.0000000000000000906122');
    t('-102.639', '102.639');
    t('948.5', '-948.50');
    t('-610.7', '610.7');
    t('-1.61', '1.61');
    t('-99.042', '99.042');
    t('3.0232', '-3.0232');
    t('-15', '15');
    t('-3.835', '3.835');
    t('-7', '7');
    t('1', '-1');
    t('21.46', '-21.46');
    t('2', '-2');
    t('-2077.79', '2077.79');
    t('-14.7446', '14.7446');
    t('-9.11e-12', '0.00000000000911');
    t('1.2', '-1.2');
    t('-105851', '105851');
    t('24.561', '-24.561');
    t('780', '-780');
    t('3.82122', '-3.82122');
    t('9564', '-9564');
    t('-13.21', '13.21');
    t('25020.5', '-25020.5');
    t('-5678.6', '5678.6');
    t('1', '-1.0');
    t('2.6', '-2.6');
    t('9.6e-16', '-0.000000000000000960');
    t('12.6', '-12.6');
    t('-5', '5');
    t('-537', '537');
    t('-85', '85');
    t('758.15', '-758.15');
    t('-67.55', '67.55');
    t('-9444', '9444');
    t('21.4', '-21.4');
    t('2.5', '-2.5');
    t('489311', '-489311');
    t('6.8', '-6.8');
    t('4.29', '-4.29');
    t('23982', '-23982.0');
    t('-0.0111781', '0.0111781');
    t('4.96e-20', '-0.0000000000000000000496');
    t('-40.5481', '40.5481');
    t('-32.52', '32.52');
    t('-7.4', '7.4');
    t('1008', '-1008');
    t('1.2', '-1.2');
    t('-5', '5.0');
    t('-2463.4', '2463.4');
    t('7.363', '-7.363');
    t('2.8', '-2.8');
    t('-14498', '14498');
    t('201', '-201');
    t('3.2', '-3.2');
    t('-3.05', '3.05');
    t('1.1', '-1.1');
    t('-380.4', '380.4');
    t('13399', '-13399');
    t('-20.44', '20.44');
    t('1.6', '-1.6');
    t('2.1234e-10', '-0.00000000021234');
    t('4404.1', '-4404.1');
    t('2.4345', '-2.4345');
    t('-117.256', '117.256');
    t('-6.025', '6.025');
    t('18.43', '-18.43');
    t('-47.5', '47.5');
    t('45.1', '-45.1');
    t('-3806.5', '3806.5');
    t('-4.6', '4.6');
    t('-1.3', '1.3');
    t('-74.6', '74.60');
    t('-16.2088', '16.2088');
    t('788.6', '-788.6');
    t('-0.29', '0.29');
    t('1', '-1');
    t('-4.058', '4.058');
    t('5', '-5.0');
    t('0.00612', '-0.00612');
    t('-14317', '14317');
    t('-1.1801', '1.1801');
    t('-32.6', '32.6');
    t('57248', '-57248');
    t('-103', '103');
    t('-1.4', '1.4');
    t('228', '-228');
    t('92.8', '-92.8');
    t('3.46e-17', '-0.0000000000000000346');
    t('-15747', '15747');
    t('16.36', '-16.360');
    t('0.00223', '-0.00223');
    t('244', '-244');
    t('3.8', '-3.8');
    t('-604.2', '604.2');
    t('1.03', '-1.03');
    t('1487', '-1487');
    t('7', '-7');
    t('45', '-45.00');
    t('2.55374e-10', '-0.000000000255374');
    t('3', '-3');
    t('-5.5', '5.5');
    t('-5.4', '5.4');
    t('-9', '9');
    t('-1627.2', '1627.2');
    t('1.0805e-16', '-0.00000000000000010805');
    t('-14.0548', '14.0548');
    t('-207137', '207137');
    t('3.8', '-3.8');
    t('-33.4785', '33.4785');
    t('4.28626', '-4.28626');
    t('-4', '4');
    t('-6', '6');
    t('-1', '1');
    t('-44.951', '44.951');
    t('29.7', '-29.7');
    t('-121.17', '121.17');
    t('480', '-480');
    t('-2.696', '2.696');
    t('-3708.62', '3708.62');
    t('2.8', '-2.8');
    t('17842', '-17842');
    t('-3', '3');
    t('-2', '2');
    t('-1.855', '1.855');
    t('246866', '-246866');
    t('-0.0022', '0.0022');
    t('-1', '1');
    t('1283', '-1283');
    t('2.1', '-2.1');
    t('3.289e-12', '-0.000000000003289');
    t('-1656', '1656');
    t('3.9', '-3.9');
    t('1.12', '-1.12');
    t('3.54e-16', '-0.000000000000000354');
    t('-0.001123', '0.001123');
    t('2.06551e-14', '-0.0000000000000206551');
    t('-19319.3', '19319.3');
    t('3', '-3');
    t('-6', '6');
    t('5.747e-17', '-0.00000000000000005747');
    t('-1.756', '1.756');
    t('2.71004e-15', '-0.00000000000000271004');
    t('1.4', '-1.4');
    t('-0.0000019', '0.00000190');
    t('-6', '6');
    t('-31.4', '31.4');
    t('1', '-1');
    t('-39.954', '39.9540');
    t('8.4', '-8.40');
    t('5.3382e-17', '-0.0000000000000000533820');
    t('8.4', '-8.4');
    t('-106', '106');
    t('905', '-905');
    t('-2030.8', '2030.8');
    t('0.19358', '-0.193580');
    t('50057.4', '-50057.4');
    t('8.0731e-15', '-0.0000000000000080731');
    t('2.4', '-2.4');
    t('-1', '1');
    t('0.026038', '-0.026038');
    t('-22', '22');
    t('-2.8', '2.8');
    t('0.00110001', '-0.00110001');
    t('7', '-7');
    t('-705', '705');
    t('-36046', '36046');
    t('2.42', '-2.42');
    t('-1.225', '1.225');
    t('36.8', '-36.8');
    t('6.8926', '-6.8926');
    t('163575', '-163575');
    t('3.29e-16', '-0.000000000000000329');
    t('-3.9612e-20', '0.000000000000000000039612');
    t('6.3', '-6.3');
    t('1.1', '-1.1');
    t('-53', '53');
    t('-6.3', '6.3');
    t('-3.73', '3.73');
    t('5.99e-13', '-0.000000000000599');
    t('-0.0453', '0.0453');
    t('6.2', '-6.2');
    t('5', '-5');
    t('4.85599e-7', '-0.000000485599');
    t('-6.554e-19', '0.0000000000000000006554');
    t('245.2', '-245.20');
    t('-12.557', '12.557');
    t('8.7', '-8.7');
    t('-38.7', '38.7');
    t('1.1291', '-1.1291');
    t('-3', '3');
    t('40533.9', '-40533.9');
    t('135.1', '-135.1');
    t('-213', '213');
    t('-271352', '271352');
    t('-159.9', '159.9');
    t('-103632', '103632');
    t('-0.00000225418', '0.00000225418');
    t('-2.1e-16', '0.00000000000000021');
    t('14.5', '-14.5');
    t('48016', '-48016');
    t('282', '-282.0');
    t('9.3552e-18', '-0.0000000000000000093552');
    t('237', '-237');
    t('-21.1', '21.1');
    t('2.281', '-2.281');
    t('-4.68312', '4.68312');
    t('7', '-7');
    t('6', '-6');
    t('5.3', '-5.3');
    t('-681.586', '681.586');
    t('-1.59e-16', '0.0000000000000001590');
    t('-2.94', '2.94');
    t('-1', '1');
    t('7.03', '-7.03');
    t('5.73608e-13', '-0.000000000000573608');
    t('2', '-2');
    t('-1.26e-18', '0.00000000000000000126');
    t('-1.5e-14', '0.000000000000015');
    t('2', '-2');
    t('-44', '44');
    t('-1.3928', '1.3928');
    t('18811.4', '-18811.4');
    t('6.6', '-6.6');
    t('1.99', '-1.99');
    t('-6.6496e-14', '0.000000000000066496');
    t('27.184', '-27.184');
    t('0.00007614', '-0.00007614');
    t('5478', '-5478.0');
    t('-30.6432', '30.6432');
    t('-108', '108');
    t('-1', '1');
    t('-61', '61');
    t('4', '-4');
    t('-0.032192', '0.032192');
    t('2.6e-8', '-0.000000026');

    BigNumber.config({EXPONENTIAL_AT: 0});

    t('-5.0600621890668482322956892808849303e+20', '5.0600621890668482322956892808849303e+20');
    t('7e+0', '-7e+0');
    t('-6.1095374220609e+13', '6.1095374220609e+13');
    t('9.01e+2', '-9.01e+2');
    t('-1.016984074247269470395836690098169093010136836967e+39', '1.016984074247269470395836690098169093010136836967e+39');
    t('-1.497639134680472576e+18', '1.497639134680472576e+18');
    t('-4.1717657571404248e+16', '4.1717657571404248e+16');
    t('8.983272e+1', '-8.983272e+1');
    t('-5.308416e+6', '5.308416e+6');
    t('-2.09764e+3', '2.09764e+3');
    t('-3.83432050166120236679168e+23', '3.83432050166120236679168e+23');
    t('-4.096e+3', '4.096e+3');
    t('2.679971527468745095582058350756311201706813294321409e+51', '-2.679971527468745095582058350756311201706813294321409e+51');
    t('-5.067853299870089529116832768e+2', '5.067853299870089529116832768e+2');
    t('-3.48822062687911109850066182676769e+32', '3.48822062687911109850066182676769e+32');
    t('-1e+0', '1e+0');
    t('4.2773e+0', '-4.2773e+0');
    t('5.8169306081172252508071119604378757744768e+12', '-5.8169306081172252508071119604378757744768e+12');
    t('-1e+0', '1e+0');
    t('1.51655708279450944384385164853883404204414169862685507e+46', '-1.51655708279450944384385164853883404204414169862685507e+46');
    t('-8.1e+1', '8.1e+1');
    t('-1.296e+3', '1.296e+3');
    t('-2.9e+0', '2.9e+0');
    t('-1.764e+3', '1.764e+3');
    t('9.3418332730097368870513138581415704704611459349313e+49', '-9.3418332730097368870513138581415704704611459349313e+49');
    t('-Infinity', Infinity);
    t('-Infinity', 'Infinity');
    t('Infinity', -Infinity);
    t('Infinity', '-Infinity');
    t('NaN', NaN);
    t('NaN', 'NaN');

    BigNumber.config({EXPONENTIAL_AT: 1e+9});

    Test.areEqual(-1, new BigNumber(2).negated().s);
    Test.areEqual(1, new BigNumber(-2).negated().s);
    Test.areEqual(null, new BigNumber(NaN).negated().s);
    Test.areEqual(null, new BigNumber('-NaN').negated().s);
    Test.areEqual(-1, new BigNumber(Infinity).negated().s);
    Test.areEqual(1, new BigNumber('-Infinity').negated().s);

    Test.areEqual('-1', new BigNumber(1).negated().valueOf());
    Test.areEqual('-0', new BigNumber(0).negated().valueOf());
    Test.areEqual('-0', new BigNumber(0).negated().valueOf());
    Test.areEqual('-0', new BigNumber('0.00000').negated().valueOf());
    Test.areEqual('-0', new BigNumber('+0.0').negated().valueOf());
    Test.areEqual('0', new BigNumber(-0).negated().valueOf());
    Test.areEqual('0', new BigNumber('-0').negated().valueOf());
});
