# Copyright 2004,2005 Pierre Martineau <pmartino@users.sourceforge.net>
# This file is part of Bibus, a bibliographic database that can
# work together with OpenOffice.org to generate bibliographic indexes.
#
# Bibus is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Bibus is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Bibus; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
#
# generated by wxGlade 0.3.4 on Thu Sep 30 21:55:18 2004

import wx
from bibOOo.CONST import bibOOo_base,bibOOo_regular,bibOOo_italic,bibOOo_bold,bibOOo_caps,bibOOo_smallcaps,bibOOo_underline

# begin wxGlade: dependencies
# end wxGlade

class StyleDialog(wx.Dialog):
	def __init__(self, *args, **kwds):
		self.defaultStyle = kwds["standard"]	# standard style = base style
		del kwds["standard"]
		self.style = kwds["editedStyle"]	# edited style
		del kwds["editedStyle"]
		# begin wxGlade: StyleDialog.__init__
		kwds["style"] = wx.DEFAULT_DIALOG_STYLE
		wx.Dialog.__init__(self, *args, **kwds)
		self.italic = wx.CheckBox(self, -1, _("Italic"))
		self.bold = wx.CheckBox(self, -1, _("Bold"))
		self.caps = wx.CheckBox(self, -1, _("Caps"))
		self.smallcaps = wx.CheckBox(self, -1, _("Small Caps"))
		self.underline = wx.CheckBox(self, -1, _("Underline"))
		self.static_line_1 = wx.StaticLine(self, -1)
		self.Standard = wx.Button(self, -1, _("Standard"))
		self.OK = wx.Button(self, wx.ID_OK, _("OK"))

		self.__set_properties()
		self.__do_layout()
		# end wxGlade
		wx.EVT_BUTTON(self,wx.ID_OK,self.OnOK)
		wx.EVT_BUTTON(self,self.Standard.GetId(),self.onStandard)
		# caps/smallcaps choices
		wx.EVT_CHECKBOX(self,self.caps.GetId(),self.__onCaps)
		wx.EVT_CHECKBOX(self,self.smallcaps.GetId(),self.__onSmallCaps)

	def __onCaps(self,evt):
		if self.caps.GetValue():
			self.smallcaps.SetValue(False)

	def __onSmallCaps(self,evt):
		if self.smallcaps.GetValue():
			self.caps.SetValue(False)

	def __set_properties(self):
		# begin wxGlade: StyleDialog.__set_properties
		self.SetTitle(_("Style"))
		self.OK.SetDefault()
		# end wxGlade
		if self.style != -1:
			self.__setValues(self.style)		# set values according to the edited style
		else:
			self.__setValues(self.defaultStyle)	# set values according to the base/standard style

	def __do_layout(self):
		# begin wxGlade: StyleDialog.__do_layout
		sizer_20 = wx.BoxSizer(wx.VERTICAL)
		sizer_26 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_20.Add(self.italic, 0, 0, 0)
		sizer_20.Add(self.bold, 0, 0, 0)
		sizer_20.Add(self.caps, 0, 0, 0)
		sizer_20.Add(self.smallcaps, 0, 0, 0)
		sizer_20.Add(self.underline, 0, 0, 0)
		sizer_20.Add(self.static_line_1, 0, wx.EXPAND, 0)
		sizer_26.Add(self.Standard, 0, wx.ALL, 5)
		sizer_26.Add(self.OK, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL, 5)
		sizer_20.Add(sizer_26, 1, wx.EXPAND, 0)
		self.SetSizer(sizer_20)
		sizer_20.Fit(self)
		self.Layout()
		self.Centre()
		# end wxGlade

	def __setValues(self,styleValue):
		"""Set the choices according to styleValue"""
		self.italic.SetValue(styleValue & bibOOo_italic)
		self.bold.SetValue(styleValue & bibOOo_bold)
		self.caps.SetValue(styleValue & bibOOo_caps)
		self.smallcaps.SetValue(styleValue & bibOOo_smallcaps)
		self.underline.SetValue(styleValue & bibOOo_underline)

	def onStandard(self,evt):
		"""Set the choices to the values of standard"""
		self.__setValues(self.defaultStyle)

	def OnOK(self,evt):
		self.style = bibOOo_italic*self.italic.GetValue() \
		| bibOOo_bold*self.bold.GetValue() \
		| bibOOo_caps*self.caps.GetValue() \
		| bibOOo_smallcaps*self.smallcaps.GetValue() \
		| bibOOo_underline*self.underline.GetValue()
		if self.style == self.defaultStyle:	# if identical to base => set it to -1
			self.style = bibOOo_base
		self.EndModal(wx.ID_OK)

# end of class StyleDialog


