/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef _DIALOGBOOKDELETE_H
#define _DIALOGBOOKDELETE_H

#include <gtkmm.h>
#include <iostream>
#include <libintl.h>
#include "Book.h"

#define _(String) gettext (String)
#define gettext_noop(String) (String)
#define N_(String) gettext_noop (String)

enum DIALOG_RESPONSES {
  DIALOGBOOKDELETE_RESPONSE_CANCEL,
  DIALOGBOOKDELETE_RESPONSE_DELETE
};

class DialogBookDelete : public Gtk::Dialog {
public:
  DialogBookDelete(Book* book, Gtk::Window &parent);
  
  /* Emitted whenever the "Cancel" button was clicked. */
  SigC::Signal1<void, DialogBookDelete*>        signal_button_cancel_clicked;
  /* Emitted whenever the "Delete" button was clicked. */
  SigC::Signal2<void, DialogBookDelete*, Book*> signal_button_delete_clicked;
  
protected:
  void on_signal_response(int response);
  
  Book* book;
  Gtk::HBox   hbox_main;
  Gtk::VBox   vbox_icon;
  Gtk::Image  image_question;
  Gtk::Fixed  fixed_icon;
  Gtk::Label  label_question;
  Gtk::Button button_cancel;
  Gtk::Button button_delete;
  Gtk::HBox   hbox_delete;
  Gtk::Image  image_delete;
  Gtk::Label  label_delete;
};

#endif /* _DIALOGBOOKDELETE_H */
