/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.jsnappy;

import de.jarnbjo.jsnappy.Buffer;
import de.jarnbjo.jsnappy.FormatViolationException;
import java.util.Arrays;

public class SnappyDecompressor {
    private SnappyDecompressor() {
    }

    public static Buffer decompress(byte[] in) {
        return SnappyDecompressor.decompress(in, 0, in.length, null);
    }

    public static Buffer decompress(byte[] in, Buffer out) {
        return SnappyDecompressor.decompress(in, 0, in.length, out);
    }

    public static Buffer decompress(byte[] in, int offset, int length) {
        return SnappyDecompressor.decompress(in, offset, length, null);
    }

    public static Buffer decompress(Buffer in) {
        return SnappyDecompressor.decompress(in.getData(), 0, in.getLength());
    }

    public static Buffer decompress(Buffer in, Buffer out) {
        return SnappyDecompressor.decompress(in.getData(), 0, in.getLength(), out);
    }

    public static Buffer decompress(byte[] in, int offset, int length, Buffer out) throws FormatViolationException {
        int i = 0;
        int sourceIndex = offset;
        int targetIndex = 0;
        int targetLength = 0;
        i = 0;
        do {
            targetLength += (in[sourceIndex] & 0x7F) << i++ * 7;
        } while ((in[sourceIndex++] & 0x80) == 128);
        if (out == null) {
            out = new Buffer(targetLength);
        } else {
            out.ensureCapacity(targetLength);
        }
        out.setLength(targetLength);
        byte[] outBuffer = out.getData();
        while (sourceIndex < offset + length) {
            if (targetIndex >= targetLength) {
                throw new FormatViolationException("Superfluous input data encountered on offset " + sourceIndex, sourceIndex);
            }
            switch (in[sourceIndex] & 3) {
                case 0: {
                    int l = in[sourceIndex++] >> 2 & 0x3F;
                    switch (l) {
                        case 60: {
                            l = in[sourceIndex++] & 0xFF;
                            ++l;
                            break;
                        }
                        case 61: {
                            l = in[sourceIndex++] & 0xFF;
                            l |= (in[sourceIndex++] & 0xFF) << 8;
                            ++l;
                            break;
                        }
                        case 62: {
                            l = in[sourceIndex++] & 0xFF;
                            l |= (in[sourceIndex++] & 0xFF) << 8;
                            l |= (in[sourceIndex++] & 0xFF) << 16;
                            ++l;
                            break;
                        }
                        case 63: {
                            l = in[sourceIndex++] & 0xFF;
                            l |= (in[sourceIndex++] & 0xFF) << 8;
                            l |= (in[sourceIndex++] & 0xFF) << 16;
                            l |= (in[sourceIndex++] & 0xFF) << 24;
                            ++l;
                            break;
                        }
                        default: {
                            ++l;
                        }
                    }
                    System.arraycopy(in, sourceIndex, outBuffer, targetIndex, l);
                    sourceIndex += l;
                    targetIndex += l;
                    break;
                }
                case 1: {
                    int c;
                    int l = 4 + (in[sourceIndex] >> 2 & 7);
                    int o = (in[sourceIndex++] & 0xE0) << 3;
                    if (l < (o |= in[sourceIndex++] & 0xFF)) {
                        System.arraycopy(outBuffer, targetIndex - o, outBuffer, targetIndex, l);
                        targetIndex += l;
                        break;
                    }
                    if (o == 1) {
                        Arrays.fill(outBuffer, targetIndex, targetIndex + l, outBuffer[targetIndex - 1]);
                        targetIndex += l;
                        break;
                    }
                    while (l > 0) {
                        c = l > o ? o : l;
                        System.arraycopy(outBuffer, targetIndex - o, outBuffer, targetIndex, c);
                        targetIndex += c;
                        l -= c;
                    }
                    break;
                }
                case 2: {
                    int c;
                    int l = (in[sourceIndex++] >> 2 & 0x3F) + 1;
                    int o = in[sourceIndex++] & 0xFF;
                    if (l < (o |= (in[sourceIndex++] & 0xFF) << 8)) {
                        System.arraycopy(outBuffer, targetIndex - o, outBuffer, targetIndex, l);
                        targetIndex += l;
                        break;
                    }
                    while (l > 0) {
                        c = l > o ? o : l;
                        System.arraycopy(outBuffer, targetIndex - o, outBuffer, targetIndex, c);
                        targetIndex += c;
                        l -= c;
                    }
                    break;
                }
                case 3: {
                    int c;
                    int l = (in[sourceIndex++] >> 2 & 0x3F) + 1;
                    int o = in[sourceIndex++] & 0xFF;
                    o |= (in[sourceIndex++] & 0xFF) << 8;
                    o |= (in[sourceIndex++] & 0xFF) << 16;
                    if (l < (o |= (in[sourceIndex++] & 0xFF) << 24)) {
                        System.arraycopy(outBuffer, targetIndex - o, outBuffer, targetIndex, l);
                        targetIndex += l;
                        break;
                    }
                    if (o == 1) {
                        Arrays.fill(outBuffer, targetIndex, targetIndex + l, outBuffer[targetIndex - 1]);
                        targetIndex += l;
                        break;
                    }
                    while (l > 0) {
                        c = l > o ? o : l;
                        System.arraycopy(outBuffer, targetIndex - o, outBuffer, targetIndex, c);
                        targetIndex += c;
                        l -= c;
                    }
                    break;
                }
            }
        }
        return out;
    }
}

