# Contributing to beanstalkd

Greetings. Firstly, if you're thinking of contributing to
beanstalkd, thank you! It's the hard work of people like you that
keeps beanstalkd a high-quality codebase and running smoothly in
the demanding, high-volume production environment of the servers
of many organizations around the world.

Please note that this project is released with a Contributor
Code of Conduct. By participating in this project you agree
to abide by its terms. See CodeOfConduct.txt for details.

## General

This is a mature project, so it rarely takes on new features. We
mostly focus on stability, bug fixing, clarity, and performance,
in that order.

## Issues

When reporting a bug, please describe:

- which version of beanstalkd you're using
- steps to reproduce the bug
- the behavior you saw
- the behavior you expected

If you're not using the latest version, please consider also
testing with the latest. There's a good chance the bug you found
has already been fixed.

## Good commit messages

Please see how to write good commit messages in the Go contributing guide
[here](https://golang.org/doc/contribute.html#commit_messages).


## Pull Requests

When opening a pull request, try to keep the changes focused on
one topic and avoid unrelated changes (even small things, like
editing punctuation or whitespace in comments).

If you're making big changes, consider discussing it on the
mailing list first. You might save yourself a lot of time if it
turns out that the changes you want to make aren't a good fit for
the project. This is especially true if you are adding new
functionality.
