/*
 *  callbacks.c - contains callback functions for bandwidthcalc
 *  Copyright (c) 2007-2008 Christoph Goehre <christoph.goehre@gmx.de>
 *
 *  This file is part of the bandwidthcalc package.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "callbacks.h"
#include "utility.h"

/* This callback calculates the transfer time */
void calculate (void)
{
    double do_bandwidth, do_filesize;
    long lo_erg;
    const char *comboentry, *bandwidth, *filesize;
    extern GtkWidget *en_bandwidth, *en_filesize, *la_transfertime, *combo;
    char transfertime[81];

    comboentry = gtk_combo_box_get_active_text (GTK_COMBO_BOX (combo));
    bandwidth = gtk_entry_get_text (GTK_ENTRY (en_bandwidth));
    filesize = gtk_entry_get_text (GTK_ENTRY (en_filesize));

    if ( strchr (bandwidth, '.') || strchr (bandwidth, ',') || strchr (filesize, '.') || strchr (filesize, ','))
    {
        gtk_label_set_text (GTK_LABEL (la_transfertime), "only int digits!");
        return;
    }

    do_bandwidth = strtod (bandwidth, NULL);
    do_filesize = strtod (filesize, NULL);

    if (do_bandwidth <= 0 || do_filesize <= 0)
    {
        gtk_label_set_text (GTK_LABEL (la_transfertime), "type real numbers!");
        return;
    }

    if ((strcmp (comboentry, "kBit/s")) == 0)
        lo_erg = (do_filesize * 1024) / (do_bandwidth / 8);
    else if ((strcmp (comboentry, "kByte/s")) == 0)
        lo_erg = (do_filesize * 1024) / do_bandwidth;
    else if ((strcmp (comboentry, "MBit/s")) == 0)
        lo_erg = do_filesize / (do_bandwidth / 8);
    else if ((strcmp (comboentry, "MByte/s")) == 0)
        lo_erg = do_filesize / do_bandwidth;
    calc_time (lo_erg, transfertime);
    gtk_label_set_text (GTK_LABEL (la_transfertime), transfertime);
}

/* This callback shows the about dialog */
void about (void)
{
    extern GtkWidget *window;
    extern GdkPixbuf *pixbuf;
    gchar* authors[] = { "Christoph Goehre <christoph.goehre@gmx.de>", NULL };
    gtk_show_about_dialog (GTK_WINDOW (window),
                           "authors", authors,
                           "version", VERSION,
                           "copyright", "Copyright \xc2\xa9 2007-2008 Christoph Goehre, GNU GPL v2.0",
                           "logo", pixbuf,
                           "website", "http://www.debiaan.de/~chris/",
                           NULL);
}


/* This callback quits the program */
gboolean delete_event (GtkWidget *widget, GdkEvent *event, gpointer data)
{
    gtk_main_quit ();
    return FALSE;
}
