//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _spin2root_7.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/spin2rootlist.h>

using namespace std;
using namespace bagel;

void Spin2RootList::spin2root7(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[7] = {1.844325111398341e+00,6.161461916539803e-01,3.748770568452880e+00,6.422473300474675e+00,1.003266860073090e+01,
    1.491198196210708e+01,2.192363426518214e+01};
  constexpr double aw[7] = {3.079292426410160e-01,1.188289213436162e-01,1.938946542956340e-01,4.105323155280411e-02,2.909059203692048e-03,
    5.494928613124585e-05,1.357666749797257e-07};
  constexpr double x[2688] = {  1.372133197197556e-01, -3.774487191838195e-03,  7.214155893379237e-05, -1.084975520681669e-06,  1.220075030578213e-08,
 -6.586842230286832e-11, -1.222621641578356e-12,  4.816744963694561e-14, -9.406877160330040e-16,  1.174739547973289e-17, -4.876123243888516e-20, -2.109433222218614e-21,
  3.889672902073204e-01, -9.321521165744301e-03,  1.278593724530334e-04, -7.059775530095501e-07, -1.409898014873923e-08,  4.239865694769343e-10, -3.997876839047430e-12,
 -4.902725386623082e-14,  2.192277272435060e-15, -2.711238039571499e-17, -2.026746201783898e-19,  1.358205391343160e-20,  7.264354381041465e-01, -1.389985120436126e-02,
  8.780125587279739e-05,  1.435502997526084e-06, -3.103069886848015e-08, -1.198482869555100e-10,  1.033912169154819e-11, -5.442494097727315e-14, -3.071101328421059e-15,
  4.880167204555446e-17,  6.745910499638337e-19, -2.532303134365308e-20,  1.104944140837988e+00, -1.502916246219567e-02, -3.338541469055565e-05,  2.242468070739635e-06,
  1.293385164743032e-08, -5.878755842870940e-10, -5.587887455792538e-12,  1.839051234670639e-13,  2.483263763047256e-15, -6.195902026107464e-17, -1.136198784451939e-18,
  2.152637671127430e-20,  1.471280119515344e+00, -1.195552122133688e-02, -1.283926440270573e-04,  2.719716049609196e-07,  3.205463171105855e-08,  3.587745270799295e-10,
 -4.747295476422047e-12, -1.860194255704826e-13, -1.084459626867381e-15,  5.155377605190349e-17,  1.187471245630589e-18, -1.829337737481133e-21,  1.770466315165820e+00,
 -6.304797061019619e-03, -1.128077116400121e-04, -1.368227855702840e-06, -6.286305537766404e-09,  1.942108213167465e-10,  6.216434341374036e-12,  9.066970677393370e-14,
  2.514317011389611e-16, -2.359633631274426e-17, -6.814201831687506e-19, -9.124486601404407e-21,  1.954821179682551e+00, -1.378284104490274e-03, -3.086323037805689e-05,
 -5.934666443546157e-07, -1.022661329684279e-08, -1.583948244945279e-10, -2.159621101223165e-12, -2.401191469755782e-14, -1.570257832378134e-16,  1.665688791087132e-18,
  9.281927340848258e-20,  2.356976635320353e-21,  1.231917202955683e-01, -3.246223374389626e-03,  6.024560341439686e-05, -9.014945619284536e-07,  1.068321449451100e-08,
 -8.205480601339822e-11, -2.352603791818154e-13,  2.432563174640817e-14, -5.676286492852935e-16,  8.740523664469498e-18, -8.640043527004110e-20,  4.855331717097644e-24,
  3.536686920206332e-01, -8.335759220911178e-03,  1.182961259387219e-04, -8.692726256134992e-07, -6.652910742862225e-09,  3.185595376293272e-10, -4.540478905813016e-12,
  4.938132704909245e-15,  1.187808264974153e-15, -2.615731754815762e-17,  1.825860004439265e-19,  4.367267445000436e-21,  6.723379019708542e-01, -1.313707524705508e-02,
  1.020110689297991e-04,  9.326225797139695e-07, -3.111970891385144e-08,  1.006551167794233e-10,  7.728231705531073e-12, -1.215050995552182e-13, -1.086698248167668e-15,
  5.491636059949960e-17, -3.010158555950123e-19, -1.635003459754937e-20,  1.044467492052041e+00, -1.518602096797098e-02, -5.640639607819144e-06,  2.349946265002189e-06,
  2.890319336514361e-10, -6.535348514337359e-10,  2.887025064385978e-13,  2.211334806108447e-13, -2.828597091489974e-16, -8.290777386224048e-17,  1.736695886842048e-19,
  3.292394299650163e-20,  1.421437388506481e+00, -1.296039275108015e-02, -1.218399558192441e-04,  8.342428005191499e-07,  3.765704638932597e-08,  1.804457064096713e-10,
 -1.010051059364110e-11, -1.824877244834176e-13,  1.534526049054693e-15,  8.932977452375896e-17,  4.852703310296671e-19, -3.098273441196331e-20,  1.743336265073800e+00,
 -7.274291389414613e-03, -1.296731219523484e-04, -1.428761298851764e-06, -7.038839493769352e-10,  3.737876184010591e-10,  8.698247166980930e-12,  7.911879870279950e-14,
 -1.178160350872413e-15, -5.789437285469733e-17, -9.829821956897047e-19, -1.952086912491436e-21,  1.948764859194143e+00, -1.656718214731082e-03, -3.908089485900422e-05,
 -7.854895776899479e-07, -1.396986545329183e-08, -2.187746892786640e-10, -2.886787882356896e-12, -2.711313596033778e-14,  1.751379104178065e-18,  8.251724958157533e-18,
  2.604088182350810e-19,  5.661748886163748e-21,  1.111061795094488e-01, -2.804750156162008e-03,  5.039865887131176e-05, -7.438005347751229e-07,  9.031366381897142e-09,
 -8.131299287126529e-11,  2.341852395959380e-13,  1.054426680980932e-14, -3.129687956479650e-16,  5.510529895857659e-18, -7.141538874098780e-20,  5.282969877296819e-22,
  3.221503642667697e-01, -7.432478637393534e-03,  1.074175365759192e-04, -9.305567602338595e-07, -1.341522702078505e-09,  2.147297695900688e-10, -3.999990963514051e-12,
  2.955043315451282e-14,  4.066204982573903e-16, -1.684150317520380e-17,  2.465737841797615e-19, -6.752414358298898e-22,  6.214809843694312e-01, -1.228447285508042e-02,
  1.103108424295463e-04,  4.596845814684079e-07, -2.754036099026224e-08,  2.430913673468193e-10,  4.113093575932616e-12, -1.281025545774953e-13,  5.421634250733137e-16,
  3.308596551792261e-17, -6.799287384859613e-19, -1.380647065014658e-21,  9.838105707626515e-01, -1.511925071741583e-02,  2.216198183017826e-05,  2.252434145331702e-06,
 -1.222744287121607e-08, -5.759708091626994e-10,  5.930128114089495e-12,  1.683142440274868e-13, -2.824281456777818e-15, -5.078092491992186e-17,  1.291252351871089e-18,
  1.396491509246090e-20,  1.367724484911470e+00, -1.388464540558437e-02, -1.081419580923012e-04,  1.450857125703837e-06,  3.846949250408572e-08, -1.147027120375219e-10,
 -1.403021478705792e-11, -8.129361688735196e-14,  4.705978985914474e-15,  7.473346842797524e-17, -1.322544619118400e-18, -4.503768533706990e-20,  1.712056319392476e+00,
 -8.379803180789434e-03, -1.466005748326575e-04, -1.368225662072408e-06,  9.007716600601111e-09,  6.026744177893332e-10,  1.001910717772836e-11,  6.797926381413151e-16,
 -3.932950175507090e-15, -9.220304679035572e-17, -5.180172533950200e-19,  2.750011827792532e-20,  1.941447159604115e+00, -2.011226937467163e-03, -5.000515765831824e-05,
 -1.048029422475765e-06, -1.909817803578259e-08, -2.968012144493024e-10, -3.582917248807157e-12, -1.971572453479540e-14,  5.604038441118195e-16,  2.523723793732106e-17,
  6.334836484828399e-19,  1.176981270800601e-20,  1.006403366969042e-01, -2.434927967675861e-03,  4.228761626382753e-05, -6.119211899031731e-07,  7.480086415294559e-09,
 -7.311661410036664e-11,  4.153800189933071e-13,  3.199354383748540e-15, -1.601389936680726e-16,  3.145350909013261e-18, -4.649882822834097e-20,  5.822034130553423e-22,
  2.940682822784303e-01, -6.617875980944968e-03,  9.624771296606359e-05, -9.225790979963288e-07,  2.065557957654907e-09,  1.296349485639128e-10, -3.068512500462110e-12,
  3.467004355237538e-14, -3.463557392850231e-17, -8.110793748185176e-18,  1.824834253943674e-19, -1.736841175406189e-21,  5.741329508464132e-01, -1.138701375697060e-02,
  1.133577765073969e-04,  6.212488668272390e-08, -2.196780768956433e-08,  3.016372592324774e-10,  9.110288819048091e-13, -9.686997544795646e-14,  1.257819388187694e-15,
  7.709751519435991e-18, -5.291398179968668e-19,  6.840560039240881e-21,  9.238535670369750e-01, -1.483798197883397e-02,  4.766616125717045e-05,  1.973773272749639e-06,
 -2.200047296350326e-08, -3.886190351386973e-10,  9.178391167446077e-12,  5.935777559199499e-14, -3.650321061196019e-15,  4.923605086389689e-18,  1.304146945574275e-18,
 -1.160993396015925e-20,  1.310580286700477e+00, -1.466997193963550e-02, -8.717488547276635e-05,  2.029280932831487e-06,  3.272068305468761e-08, -4.596956056784594e-10,
 -1.388749135663761e-11,  9.857500498635521e-14,  6.019575099639420e-15, -1.117644230109229e-17, -2.708712676374022e-18, -9.114790871300981e-21,  1.676092284608512e+00,
 -9.614832711664878e-03, -1.617151419093301e-04, -1.114898885153448e-06,  2.338052916638301e-08,  8.260031177306087e-10,  7.766299668815487e-12, -1.791121593994183e-13,
 -7.210416330432966e-15, -7.506755477079939e-17,  1.721913342511184e-18,  7.414056011553063e-20,  1.932514551459054e+00, -2.467250548304074e-03, -6.462635661225988e-05,
 -1.405899142842819e-06, -2.592405780632178e-08, -3.863474259312220e-10, -3.705927727801279e-12,  1.878965620769381e-14,  2.069942980077660e-15,  6.312408239218477e-17,
  1.311705888129596e-18,  1.853895004714133e-20,  9.153345107546609e-02, -2.124072176130151e-03,  3.561620871192151e-05, -5.033755463379075e-07,  6.122110051512165e-09,
 -6.255853490182858e-11,  4.479744531079115e-13, -4.219955892300112e-16, -7.417783298396149e-17,  1.800908108778646e-18, -2.074519965124815e-20,  5.746009636368758e-22,
  2.690676479409012e-01, -5.891443574548627e-03,  8.544854483987797e-05, -8.724651026647169e-07,  3.998825392467293e-09,  6.729156955254841e-11, -2.147941132808558e-12,
  3.015867792270378e-14, -2.121120116143596e-16, -2.155773819611990e-18,  1.214078723416228e-19, -9.352065870355994e-22,  5.303955151210978e-01, -1.048268282593443e-02,
  1.121949760950020e-04, -2.407484934741432e-07, -1.591200408850551e-08,  2.956279486768879e-10, -1.221546155231780e-12, -5.562259504715819e-14,  1.234408337973484e-15,
 -6.700333142656433e-18, -1.837359955989305e-19,  7.929484472529029e-21,  8.654051777415004e-01, -1.436840678344265e-02,  6.902265971123639e-05,  1.571888295342798e-06,
 -2.750172144448188e-08, -1.610987629591099e-10,  9.296468754272653e-12, -4.579009234718017e-14, -2.692069853562999e-15,  4.338030779271806e-17,  5.744816245111487e-19,
 -1.781190244940844e-20,  1.250671328957992e+00, -1.526187569458759e-02, -6.004090697345842e-05,  2.462469200665615e-06,  2.052553181695529e-08, -7.392256308308435e-10,
 -8.639236755058183e-12,  2.641920066948899e-13,  3.741991925165477e-15, -1.086253626684482e-16, -1.698015100249771e-18,  5.333260669139499e-20,  1.634971482793704e+00,
 -1.095439863255327e-02, -1.722772769694764e-04, -6.007228815239065e-07,  4.121520385462998e-08,  9.242865175737171e-10, -7.509232058798269e-13, -4.328843257110959e-13,
 -7.813182968385296e-15,  6.599830353812550e-17,  5.343483191135763e-18,  7.389775633667124e-20,  1.921493912453255e+00, -3.059413008235893e-03, -8.425561962860331e-05,
 -1.886987883149475e-06, -3.444877301536194e-08, -4.589896024804780e-10, -1.829299751057663e-12,  1.331252426599222e-13,  5.483975961659973e-15,  1.316191798812927e-16,
  2.056376298517887e-18,  9.955492283094949e-21,  8.357099542785987e-02, -1.861730649483046e-03,  3.012400731685221e-05, -4.148551151002227e-07,  4.976347088084245e-09,
 -5.216180188297279e-11,  4.118067818952388e-13, -1.871503889608308e-15, -1.859465916961973e-17,  1.425974104757592e-18, -9.128431043559199e-23,  2.814772217181144e-22,
  2.468043921594637e-01, -5.248560407269252e-03,  7.539894028013592e-05, -8.002454525013840e-07,  4.893398899064033e-09,  2.506735685683325e-11, -1.403910669034531e-12,
  2.299880454792653e-14, -2.104120432411512e-16,  2.055831733840052e-18,  9.074147400611899e-20, -7.481293080332785e-22,  4.902360729115863e-01, -9.600570318305027e-03,
  1.079671358905964e-04, -4.500854275909834e-07, -1.039677768481919e-08,  2.518278632304116e-10, -2.268581730031599e-12, -2.075843189105767e-14,  9.382890154804185e-16,
 -7.873397881408409e-18,  9.691866613138132e-20,  4.063124502717449e-21,  8.091445889769762e-01, -1.374842425357441e-02,  8.517652733025121e-05,  1.117616236603404e-06,
 -2.864012153240646e-08,  3.846199469143902e-11,  7.066330280265203e-12, -1.039389965334461e-13, -8.885346422524486e-16,  5.265289897543684e-17, -5.364018011600816e-20,
 -1.036082561545419e-20,  1.188856643725781e+00, -1.561960499539147e-02, -2.903785678294352e-05,  2.664044705495624e-06,  4.320085135591347e-09, -8.482230358333553e-10,
 -2.168265070864652e-13,  3.135071789233636e-13, -7.319037145891344e-16, -1.204604809485890e-16,  1.183951418899777e-18,  6.344685900443974e-20,  1.588369440553712e+00,
 -1.234886483658003e-02, -1.749348259315834e-04,  2.010413369102404e-07,  5.840803628611269e-08,  7.363635676241644e-10, -1.569123797727106e-11, -5.988421621765699e-13,
 -1.057947057741228e-15,  3.147830336060689e-16,  6.058666532123012e-18, -6.766039745957618e-20,  1.907750601404007e+00, -3.834108658672970e-03, -1.105127610634885e-04,
 -2.512306149158555e-06, -4.364250697579923e-08, -4.333786190325881e-10,  5.181942219004190e-12,  4.004007658156929e-13,  1.168571919074103e-14,  2.077958013735806e-16,
  1.199474130873592e-18, -6.777523171217868e-20,  7.657633862686056e-02, -1.639373958424609e-03,  2.559073767680848e-05, -3.430608697866746e-07,  4.027555118287772e-09,
 -4.292670857603103e-11,  3.588691455889287e-13, -1.633630512457360e-15,  3.378859214731368e-17,  1.456567426627084e-18, -4.622114409403705e-21, -5.669889656646947e-22,
  2.269576305017069e-01, -4.682422418619347e-03,  6.627694315338795e-05, -7.195646258181876e-07,  5.106411792965350e-09, -1.568286910517969e-12, -8.385632143208955e-13,
  1.806428049028942e-14, -8.247977093811269e-17,  4.614165673141081e-18,  2.319122565982150e-20, -2.640309260249675e-21,  4.535235464964165e-01, -8.760902440213042e-03,
  1.017242442917098e-04, -5.792392592011830e-07, -5.935217831075966e-09,  1.935712334202371e-10, -2.465305165518385e-12,  5.708206428663037e-15,  7.489313376740967e-16,
 -2.533866875898075e-18,  1.119086964318671e-19, -3.845475740988215e-21,  7.555878037378363e-01, -1.302104331073822e-02,  9.589090913276495e-05,  6.737175234373165e-07,
 -2.641998878693822e-08,  1.716336947022868e-10,  4.035240479894861e-12, -1.032678836802800e-13,  8.699229823681369e-16,  4.246944059822142e-17, -4.515828218198376e-19,
 -9.824931122588296e-21,  1.126116059835991e+00, -1.572413531816907e-02,  2.792601442116704e-06,  2.600057480090661e-06, -1.201447871021414e-08, -7.542951427041400e-10,
  7.674219125635011e-12,  2.344346999962802e-13, -3.681198372769341e-15, -3.339961416238156e-17,  2.655254051262560e-18, -5.648871258627215e-21,  1.536214005790055e+00,
 -1.372184820867880e-02, -1.665108582406963e-04,  1.227305804180105e-06,  6.804131424534448e-08,  1.666639783393106e-10, -3.094872819377949e-11, -4.143639676393606e-13,
  1.332045580367676e-14,  4.320245000429551e-16, -1.753166885080375e-18, -2.750744971789355e-19,  1.890437482527105e+00, -4.851264712579826e-03, -1.451018146496996e-04,
 -3.268507279986215e-06, -4.991000931944482e-08, -1.251785800001756e-10,  2.277014401485981e-11,  8.943234507119563e-13,  1.881692515377283e-14,  1.389044872894690e-16,
 -6.438228970837553e-18, -3.145069458219624e-19,  7.040368627469611e-02, -1.450081758223560e-03,  2.183380087067394e-05, -2.850330537372142e-07,  3.252271999622884e-09,
 -3.469493574121124e-11,  3.355221669300171e-13,  1.841891812547184e-16,  7.418366456069598e-17,  4.811778850506672e-19, -5.054588854486048e-20, -1.421439125330451e-21,
  2.092356347993751e-01, -4.185365680644304e-03,  5.812826730811310e-05, -6.390378652657726e-07,  4.913873233951065e-09, -1.576906964374424e-11, -3.450151008029330e-13,
  1.798726336726450e-14,  6.519849069416066e-17,  2.446994072511442e-18, -1.485723877844995e-19, -4.898494240347359e-21,  4.200615855047252e-01, -7.976252542732334e-03,
  9.432119970458882e-05, -6.463439004006495e-07, -2.628803971941154e-09,  1.389655919529155e-10, -1.980171386236737e-12,  2.859663900217808e-14,  6.748241721692874e-16,
 -3.881964670092398e-18, -2.320167038871545e-19, -1.090988294099315e-20,  7.050793237059801e-01, -1.222847335609678e-02,  1.015670102925531e-04,  2.828112194122930e-07,
 -2.223134436201291e-08,  2.381920861014038e-10,  1.732981719977360e-12, -5.541842688357622e-14,  1.951155088836039e-15,  1.371135295297015e-17, -1.038528767463779e-18,
 -1.658701757972457e-20,  1.063455773606424e+00, -1.558133111888346e-02,  3.237998691534156e-05,  2.299130797345436e-06, -2.479783196188654e-08, -5.050734058243223e-10,
  1.254431218522793e-11,  1.159008683343908e-13, -3.258698180001109e-15,  4.342946987922485e-17,  6.602150790238216e-19, -7.627153026631208e-20,  1.478781827062286e+00,
 -1.497654148016906e-02, -1.452802610833466e-04,  2.299372194317543e-06,  6.331329680359202e-08, -6.538937040249799e-10, -3.448621996795942e-11,  2.221683175251840e-13,
  2.451890978305144e-14,  1.060846891842007e-16, -1.416423115572963e-17, -2.208123444966054e-19,  1.868443272403678e+00, -6.182493087971279e-03, -1.890754072085053e-04,
 -4.047630001207199e-06, -4.455814364191299e-08,  7.918924663135395e-10,  5.644965731963108e-11,  1.493141560450746e-12,  1.484580549206322e-14, -5.053640736821305e-16,
 -2.840316370770233e-17, -6.600746797229455e-19,  6.493222050234455e-02, -1.288258185081378e-03,  1.870415745926127e-05, -2.381037474780373e-07,  2.640709835519748e-09,
 -2.631330755124832e-11,  3.730123009514926e-13,  2.320332699417769e-15,  3.984521886665525e-17, -2.784327976694285e-18, -1.086966781609143e-19, -8.363558661571584e-22,
  1.933775101796844e-01, -3.749702808613752e-03,  5.092015922498489e-05, -5.632128079013850e-07,  4.557863818221893e-09, -1.774011204761287e-11,  1.904394005083489e-13,
  1.991226573551110e-14, -5.471740155483634e-18, -7.701663467246418e-18, -3.443808720595115e-19, -2.811475481760809e-21,  3.896158421371608e-01, -7.253226513610731e-03,
  8.639690506905131e-05, -6.684387424008990e-07, -2.481228806073009e-10,  1.032731191205839e-10, -9.164976813694737e-13,  4.520255750910087e-14,  2.501436645735647e-16,
 -2.279132828110595e-17, -6.857221224455944e-19, -6.900672917426230e-21,  6.578039525266399e-01, -1.140803461997497e-02,  1.029899333119299e-04, -3.291765415449472e-08,
 -1.714003652192545e-08,  2.683521591215733e-10,  1.064088144629142e-12,  5.465152828109132e-15,  1.522171933975210e-15, -4.196040730064292e-17, -1.685554371521296e-18,
 -7.963960021768691e-21,  1.001812867932321e+00, -1.521933470874962e-02,  5.731114926933919e-05,  1.838821851997308e-06, -3.168045248528637e-08, -1.753936343776388e-10,
  1.456119582726927e-11,  3.484345270729043e-14, -2.069519412205149e-15, -2.429292792828145e-19, -2.721109482813193e-18, -5.916613790953391e-20,  1.416748583666267e+00,
 -1.601246156278687e-02, -1.121773236967573e-04,  3.166505813703631e-06,  4.292033316812552e-08, -1.319002715517956e-09, -1.756888515508439e-11,  9.452699731730917e-13,
  1.669497520323697e-14, -5.527429212959277e-16, -1.586128487978290e-17,  1.704731400417724e-19,  1.840365642245843e+00, -7.899747003951319e-03, -2.411229385576945e-04,
 -4.545370144998060e-06, -1.161295016064028e-08,  2.675996847543985e-09,  1.002806221897745e-10,  1.401468714371951e-12, -3.060329523369533e-14, -2.177648539837501e-15,
 -5.080467884250923e-17, -9.353763164516538e-21,  6.006132381841552e-02, -1.149372353134753e-03,  1.608469285058593e-05, -1.995529192389670e-07,  2.209468012196523e-09,
 -1.656091147901539e-11,  4.345793483654838e-13,  1.125811466098099e-15, -1.402898519501168e-16, -7.015853937257751e-18, -7.420833680351251e-20,  3.121718802672935e-21,
  1.791523351493973e-01, -3.368160436872238e-03,  4.458876439542333e-05, -4.926921081743657e-07,  4.292380453914827e-09, -6.853525219892419e-12,  6.841851574591155e-13,
  1.254570437293461e-14, -5.373522944609598e-16, -2.122790893605756e-17, -2.409453722634863e-19,  9.750809154343244e-21,  3.619345897560409e-01, -6.594052448676910e-03,
  7.841729922382388e-05, -6.566451685389072e-07,  1.700636320659286e-09,  9.641323070175601e-11,  2.982300133135878e-13,  3.451137025143212e-14, -1.086272025006156e-15,
 -5.029189481832855e-17, -4.882638301721381e-19,  2.085336354904193e-20,  6.138111193022687e-01, -1.058993979642349e-02,  1.011314172707923e-04, -2.627057767480207e-07,
 -1.148441272196951e-08,  2.993632828001651e-10,  1.578077825174054e-12,  1.690992807397326e-14, -1.190425614833105e-15, -1.050833534715422e-16, -1.091261763724688e-18,
  4.445618836632484e-20,  9.419798978891895e-01, -1.468134130990858e-02,  7.628200032856409e-05,  1.323048216893390e-06, -3.165638084192160e-08,  1.774428716990733e-10,
  1.443695943407813e-11, -5.597597177526790e-14, -4.405177018192578e-15, -1.310097415734402e-16, -2.864911954126220e-18,  7.156268179133583e-20,  1.351158263936174e+00,
 -1.674831912204706e-02, -7.097704539332496e-05,  3.629091261483337e-06,  1.468719811086253e-08, -1.384947495569143e-09,  1.263279518455003e-11,  1.060234708759792e-12,
 -1.178852498908174e-14, -9.277038751901748e-16, -6.209360248251763e-19,  4.809517665256953e-19,  1.804565279509649e+00, -1.004509539045856e-02, -2.945631114499028e-04,
 -4.161961200950515e-06,  6.822472722902574e-08,  5.357285391650896e-09,  1.114433563894836e-10, -1.179345506903757e-12, -1.383911672373898e-13, -3.365572290581785e-15,
  1.890231553176675e-17,  3.714318591165129e-18,  5.570684336325223e-02, -1.029693860663253e-03,  1.389307272166756e-05, -1.662860171264800e-07,  1.981443268000957e-09,
 -6.505043972011846e-12,  3.633390662391441e-13, -7.588816984903743e-15, -3.947458294207237e-16, -5.187481823048131e-18,  2.178610352076097e-19,  1.004455063345574e-20,
  1.663573113889812e-01, -3.033936218242926e-03,  3.908711581735849e-05, -4.241434163186097e-07,  4.334774291112535e-09,  1.109425551144899e-11,  6.732918206987981e-13,
 -1.751874860543379e-14, -1.313379625295470e-15, -1.580729730693100e-17,  6.775074016128238e-19,  3.170409017804828e-20,  3.367640027124180e-01, -5.997620108346763e-03,
  7.076638975530490e-05, -6.133843934151969e-07,  3.751045367512067e-09,  1.094906718968303e-10,  4.933385516085620e-13, -3.035088648429430e-14, -2.897810141931674e-15,
 -3.707139849144046e-17,  1.519276203098009e-18,  6.997094181729776e-20,  5.730457043157708e-01, -9.796153371538286e-03,  9.708084142828779e-05, -3.964636830736151e-07,
 -5.117843592073473e-09,  3.349415631140939e-10,  9.194628596465470e-13, -8.470158562428403e-14, -5.040021136047793e-15, -8.199438179860725e-17,  2.962179728143093e-18,
  1.396487066398389e-19,  8.845639450763846e-01, -1.401580152833363e-02,  8.929538003944004e-05,  8.628813679915531e-07, -2.487262298556225e-08,  4.842618288725487e-10,
  1.008250602365033e-11, -2.847896414781507e-13, -9.877126393357906e-15, -1.217524656307480e-16,  4.881989761042493e-18,  2.790111427104397e-19,  1.283308220734679e+00,
 -1.713989664104122e-02, -2.685380083881308e-05,  3.667906129727873e-06, -7.923681938166448e-09, -7.980985795901256e-10,  3.223768962242393e-11,  1.882087202387302e-13,
 -4.008940249508149e-14, -4.818284518484943e-16,  2.393122850619555e-17,  6.182205832015298e-19,  1.759393585853567e+00, -1.257382700487576e-02, -3.340057658230387e-04,
 -2.089417958921418e-06,  1.964296809777641e-07,  7.037926253007702e-09,  1.493999844059370e-12, -7.002524741102749e-12, -1.951188511073401e-13,  1.820353151587365e-15,
  2.544566277403186e-16,  5.270082619500249e-18,  5.179847049475346e-02, -9.259993329609285e-04,  1.208483796683004e-05, -1.352493068962575e-07,  1.913513891769414e-09,
 -1.852254924032635e-12, -3.685342473683583e-14, -2.062606712992037e-14, -3.144680489134702e-16,  1.242994888146073e-17,  6.177336497345187e-19,  3.309295110167526e-21,
  1.548164179994878e-01, -2.740397740942366e-03,  3.442302802744900e-05, -3.523905361411871e-07,  4.652649283901123e-09,  1.634953941485895e-11, -4.373626901002982e-13,
 -6.057137816365668e-14, -1.045787833165160e-15,  3.952145858120085e-17,  1.949496218611868e-18,  1.088859457854246e-20,  3.138608296811443e-01, -5.459742790475728e-03,
  6.383895796556012e-05, -5.356937478490741e-07,  5.933066970972608e-09,  9.999689846638552e-11, -1.735105557857961e-12, -1.263858040019622e-13, -2.364149746235948e-15,
  8.648776079822789e-17,  4.362055590177434e-18,  2.540425364564883e-20,  5.353829622647671e-01, -9.039417474464375e-03,  9.205386155800951e-05, -4.247182293966974e-07,
  1.507775816613478e-09,  3.087267681297166e-10, -3.917618403338788e-12, -2.576984781554559e-13, -4.307973055370110e-15,  1.625325559937058e-16,  8.702268350271246e-18,
  5.452817467446056e-20,  8.299865513365463e-01, -1.326598023484964e-02,  9.761535406464286e-05,  5.521614438920630e-07, -1.360832757729346e-08,  5.927640471839228e-10,
 -2.559069977486040e-12, -6.077401176469251e-13, -7.601028973126984e-15,  3.303419539375957e-16,  1.672275351846042e-17,  1.249415238456617e-19,  1.214593433852238e+00,
 -1.718176496975287e-02,  1.600814617374791e-05,  3.454523068667991e-06, -1.651068035531606e-08, -1.142361121829362e-10,  1.856074824959635e-11, -1.135502017862769e-12,
 -3.393229971928483e-14,  9.715265500118221e-16,  4.511023557109890e-17,  7.833821998631313e-20,  1.703684479688861e+00, -1.528240352506836e-02, -3.357796767179814e-04,
  2.103651345253840e-06,  3.185593885640627e-07,  4.154505866792347e-09, -2.563070291971295e-10, -9.951717098636958e-12,  8.141341365542170e-14,  1.322946343835177e-14,
  1.930445493287644e-16, -1.118655874684498e-17,  4.827828104706432e-02, -8.352962822468122e-04,  1.064359461841154e-05, -1.051873565168549e-07,  1.817338491802920e-09,
 -1.022257960233404e-11, -6.548861917675582e-13, -1.900455960297421e-14,  5.299860149878288e-16,  3.058209000224279e-17,  1.833843054549287e-20, -3.247790624075677e-20,
  1.443806247852840e-01, -2.480644660304801e-03,  3.064824724861889e-05, -2.765251063668882e-07,  4.725281278108464e-09, -1.643444129910665e-11, -2.283284714174271e-12,
 -5.695636373617465e-14,  1.633978822574658e-15,  9.710820964958713e-17,  6.654548366455098e-20, -1.029139719341544e-19,  2.930050214610518e-01, -4.972999770683416e-03,
  5.803532280740403e-05, -4.283360799088170e-07,  7.202333348021652e-09,  1.140909806431362e-11, -5.630080911111765e-12, -1.200804021499757e-13,  3.575416302109542e-15,
  2.164217562046950e-16,  1.940963229402747e-19, -2.304778921839282e-19,  5.006670155915970e-01, -8.322539872063803e-03,  8.728202194283781e-05, -3.589467639703250e-07,
  6.108803784732823e-09,  1.203334038013395e-10, -1.171283202257946e-11, -2.374568318902039e-13,  7.224117997103389e-15,  4.251028313496079e-16,  5.173617475622640e-19,
 -4.610976639223256e-19,  7.785223386431711e-01, -1.246140590005585e-02,  1.032987073357785e-04,  4.198397030217655e-07, -3.824078941155257e-09,  3.152694230651661e-10,
 -2.028148227884711e-11, -5.356617021907365e-13,  1.532159067749572e-14,  8.403055749136340e-16,  8.007877057473900e-19, -9.270245360265868e-19,  1.146378603114183e+00,
 -1.689245081742135e-02,  5.584669689199219e-05,  3.183793513400470e-06, -1.736904833245131e-08, -1.286978371328374e-10, -2.082507083069188e-11, -1.342195608517489e-12,
  2.877483084419667e-14,  2.203916780897653e-15, -2.315158431470539e-18, -2.399668122208367e-18,  1.637469661471360e+00, -1.777730239752839e-02, -2.785280240281477e-04,
  7.447579227650205e-06,  3.210519130168701e-07, -4.583352264577345e-09, -4.235579445367497e-10,  4.621869202539454e-13,  5.292621661386891e-13,  6.277913242244419e-15,
 -5.836113308957003e-16, -1.591381437862950e-17,  4.510006869842847e-02, -7.547240032801032e-04,  9.545913745865765e-06, -7.873349260321721e-08,  1.426606257403963e-09,
 -2.946317523690446e-11, -8.010947418595254e-13,  1.257522245802652e-14,  1.255641842401731e-15, -7.157794223010292e-19, -1.481689854471404e-18, -1.753496987248705e-20,
  1.349291567920265e-01, -2.247493056427019e-03,  2.776194304204199e-05, -2.069238021310139e-07,  3.762958666549250e-09, -8.145664294908714e-11, -2.674091303911943e-12,
  4.181644651491155e-14,  3.943288328792192e-15, -2.079001304877998e-18, -4.708394025357795e-18, -5.602804413855969e-20,  2.740117570432898e-01, -4.527353062124777e-03,
  5.356809299451350e-05, -3.194370366230527e-07,  5.902767499228541e-09, -1.444243424472013e-10, -6.337211019091180e-12,  9.810309137096626e-14,  8.730590179646783e-15,
 -5.026919328380670e-18, -1.056759852003002e-17, -1.267341650842082e-19,  4.687485397294745e-01, -7.639776575237781e-03,  8.358638745555914e-05, -2.588427999965809e-07,
  5.357862090471994e-09, -2.012501275168547e-10, -1.305443708640938e-11,  1.975780918597037e-13,  1.731810469140744e-14, -1.560393597396288e-17, -2.117103901382780e-17,
 -2.547289002461466e-19,  7.303603244406480e-01, -1.161561676641672e-02,  1.080812998041277e-04,  3.788905683785140e-07, -3.202458679356638e-09, -2.701051323142444e-10,
 -2.434587256896190e-11,  3.539352012376215e-13,  3.486766266107220e-14, -6.015370255349231e-17, -4.294197142204810e-17, -4.954368009642662e-19,  1.079937100778262e+00,
 -1.629800429782800e-02,  9.218343100333137e-05,  2.848123979940385e-06, -2.715659723634997e-08, -9.083651676270157e-10, -3.503442504723531e-11,  6.013326227417410e-13,
  7.823235450898494e-14, -1.932027289300426e-16, -1.073406176350914e-16, -9.217594188184597e-19,  1.562579795844180e+00, -1.957110618408739e-02, -1.630530414212359e-04,
  1.133847956594842e-05,  1.388912823986322e-07, -1.265499779987108e-08, -1.766481411119367e-10,  1.575394536747052e-11,  2.631125322071011e-13, -1.996522658729968e-14,
 -4.109877209356732e-16,  2.510175945342503e-17,  4.222840488670294e-02, -6.817985225905016e-04,  8.715751249630061e-06, -6.146956610231455e-08,  6.954323166186336e-10,
 -4.036728717610239e-11,  2.651204222233325e-14,  4.086121125342140e-14,  2.021111291081281e-16, -5.054398484748952e-17, -4.089390290542281e-19,  6.008168176965872e-20,
  1.263689062445909e-01, -2.034449823951451e-03,  2.557672150894173e-05, -1.625959460399265e-07,  1.655411018581622e-09, -1.187286302809552e-10, -1.215478144789882e-14,
  1.303164340775615e-13,  6.033323852153609e-16, -1.602290461801544e-16, -1.278668639903064e-18,  1.919540100627165e-19,  2.567370749588008e-01, -4.112802111488935e-03,
  5.018328067840287e-05, -2.548941059072803e-07,  1.867361509154140e-09, -2.351460182690138e-10, -2.992796315724868e-13,  2.927236941660216e-13,  1.228785077742943e-15,
 -3.588695109397828e-16, -2.769564787637606e-18,  4.351158119604291e-19,  4.395086749666013e-01, -6.982455379228358e-03,  8.081437934762965e-05, -2.193981513720993e-07,
 -1.052548856054032e-09, -3.920591790836453e-10, -1.034684829355527e-12,  5.791112524943645e-13,  2.144355804126026e-15, -7.183890372853809e-16, -5.110880989050568e-18,
  8.862364952335601e-19,  6.856539538335200e-01, -1.073424202187511e-02,  1.120538144418356e-04,  2.581802636870197e-07, -1.304591064305285e-08, -6.234875977711777e-10,
 -1.530150728872003e-12,  1.106203895870685e-12,  3.476664879913359e-15, -1.447946092850970e-15, -8.278925833371598e-18,  1.838176190825718e-18,  1.016423911399679e+00,
 -1.543284311352025e-02,  1.230335019872131e-04,  2.233034724618701e-06, -5.104159165558180e-08, -1.300123152089075e-09,  1.001242948310358e-11,  2.202791340469570e-12,
  2.080849698421899e-15, -3.349968136380381e-15, -7.129984701501122e-18,  4.615550035266595e-18,  1.482575288952959e+00, -2.031345479918185e-02, -2.232511244495156e-05,
  1.146353497027328e-05, -1.189975697271850e-07, -1.136780276892059e-08,  2.656704378339698e-10,  1.192915654328018e-11, -4.525545694263118e-13, -1.205130987227316e-14,
  6.968459641622055e-16,  1.104867960681931e-17,  3.963617989251448e-02, -6.148931185254029e-04,  8.019394814375538e-06, -5.638629516983921e-08, -1.622328642543019e-11,
 -2.693409214939174e-11,  9.955848347505292e-13,  2.026598803363062e-14, -1.284128516763876e-15, -1.750594951282643e-17,  1.681002996360539e-18,  1.102003545836614e-20,
  1.186283822378294e-01, -1.837364875949535e-03,  2.370941198899774e-05, -1.539103383414349e-07, -4.377998063800710e-10, -7.831754451511991e-11,  3.066654482149851e-12,
  6.406803304606289e-14, -4.084551617003889e-15, -5.410625640906658e-17,  5.355455743250898e-18,  3.324626847954674e-20,  2.410696863242747e-01, -3.723409191817838e-03,
  4.715482979883722e-05, -2.603161448956732e-07, -2.270915025213430e-09, -1.512878797844290e-10,  6.572511466637809e-12,  1.414667552270514e-13, -9.170100397190213e-15,
 -1.155943495545115e-16,  1.208020450139802e-17,  6.711669473305453e-20,  4.128540411569573e-01, -6.347335570953125e-03,  7.783215998003634e-05, -2.949696332578983e-07,
 -7.888917269170465e-09, -2.379504076536462e-10,  1.241652116368710e-11,  2.703104600286707e-13, -1.829178999559668e-14, -2.116885656191701e-16,  2.438625200876838e-17,
  1.058583625015568e-19,  6.445232554068349e-01, -9.829876929531873e-03,  1.135095919212700e-04, -4.215839103257858e-08, -2.350908751114056e-08, -3.224882637309710e-10,
  2.361763478053742e-11,  4.739882259818884e-13, -3.615334195772925e-14, -3.509553391719210e-16,  4.954066869211520e-17,  9.290400968457358e-20,  9.568088090301394e-01,
 -1.435706425085799e-02,  1.441687527480974e-04,  1.241141217477726e-06, -7.005559450889445e-08, -4.161197341178797e-10,  5.627821346498429e-11,  6.517525434521364e-13,
 -8.042474971184836e-14, -3.789223059578125e-16,  1.156163692891672e-16, -5.066116541705072e-19,  1.401770387009955e+00, -1.998876921509506e-02,  9.766518103838754e-05,
  8.168119687435549e-06, -2.649655299739634e-07, -2.820669934355481e-09,  3.714278630930523e-10, -3.998860546277097e-12, -3.919556364606164e-13,  1.240481202823991e-14,
  2.809748777649736e-16, -2.107336598693988e-17,  3.730058354622536e-02, -5.534808135445595e-04,  7.327949632843269e-06, -5.955061392590430e-08, -2.947965100147649e-10,
 -1.000147993328561e-12,  9.828067581300946e-13, -1.862512104110579e-14, -8.297990471976916e-16,  3.410845831100119e-17,  4.615228233618048e-19, -4.694057026906640e-20,
  1.116462861695791e-01, -1.655287506653059e-03,  2.178272882245458e-05, -1.691114674105136e-07, -1.201497637000057e-09,  1.688902121159391e-12,  3.022992260976314e-12,
 -5.883304163776593e-14, -2.597241849235293e-15,  1.087646415986861e-16,  1.406991522757899e-18, -1.495040052975962e-19,  2.269096429209025e-01, -3.359453500634418e-03,
  4.374314223811882e-05, -3.115529887047943e-07, -3.574168528230449e-09,  2.023307684213307e-11,  6.438921534891721e-12, -1.313424356681689e-13, -5.665177390313862e-15,
  2.454357057415290e-16,  2.922073990063981e-18, -3.366938706839418e-19,  3.886842317441216e-01, -5.741231281568304e-03,  7.343468952626450e-05, -4.417152441479001e-07,
 -9.402711971406357e-09,  8.418709244161592e-11,  1.192034778796654e-11, -2.633925425599433e-13, -1.073322924215235e-14,  4.945016601140954e-16,  5.030748092695489e-18,
 -6.759207346768460e-19,  6.070072912166639e-01, -8.930495631513038e-03,  1.106403413585992e-04, -4.369640429068658e-07, -2.389305530281925e-08,  2.741440715898876e-10,
  2.132586848806514e-11, -5.423410740949140e-13, -1.911279633573780e-14,  9.965616526352094e-16,  7.017945298734044e-18, -1.349457468014232e-18,  9.017544568112740e-01,
 -1.316334039009334e-02,  1.523047871879656e-04,  1.281612497852302e-07, -6.484283510613201e-08,  8.789075417152993e-10,  4.202416943112474e-11, -1.395895327865256e-12,
 -3.128097780399838e-14,  2.291351593454778e-15, -9.311786957827926e-20, -2.962115062811165e-18,  1.323894964016701e+00, -1.888886213963295e-02,  1.698002161773584e-04,
  3.903843160620007e-06, -2.467346161419169e-07,  3.780567054765676e-09,  1.567171887275396e-10, -8.869771924760619e-12,  6.291503074813431e-14,  8.853280916816015e-15,
 -3.114602315220736e-16, -2.464747616749022e-18,  3.519927564867477e-02, -4.977900717820998e-04,  6.587951463988759e-06, -6.336206196186058e-08, -1.316977073696923e-10,
  1.449806029716255e-11,  2.782633962264107e-13, -2.554829869460321e-14,  3.091660152699567e-16,  2.063083849176532e-17, -8.032338180973165e-19, -4.353849800194078e-21,
  1.053603775904345e-01, -1.489444956760433e-03,  1.965009842757005e-05, -1.848045029574677e-07, -6.083611094522346e-10,  4.879399841948788e-11,  8.106981581375920e-13,
 -7.977015105156063e-14,  9.989420720766803e-16,  6.426560977453251e-17, -2.560329845466672e-18, -1.205502056556972e-20,  2.141467690349091e-01, -3.025357106971517e-03,
  3.969786841084716e-05, -3.586178018729390e-07, -1.992478266087762e-09,  1.184654857639500e-10,  1.561768839275545e-12, -1.739751857916647e-13,  2.310589877534096e-15,
  1.391063316204355e-16, -5.772198458623484e-18, -2.009372623279215e-20,  3.668573588915093e-01, -5.177299221573096e-03,  6.732929620399469e-05, -5.661365655698710e-07,
 -5.585428659211710e-09,  2.595017424423169e-10,  2.391916679559715e-12, -3.330522743533286e-13,  4.868373778057488e-15,  2.605400762223772e-16, -1.160167382868787e-17,
 -1.675850781256198e-20,  5.730139113876437e-01, -8.072277921063860e-03,  1.033578801357162e-04, -7.535644726163984e-07, -1.473973542856776e-08,  5.671808814349206e-10,
  2.778833947606083e-12, -6.220552266997803e-13,  1.066254828474149e-14,  4.558616638063499e-16, -2.320690031973419e-17,  4.928499335912782e-20,  8.515249358102730e-01,
 -1.195476660533719e-02,  1.483362378549981e-04, -7.282904333318995e-07, -4.062322846961085e-08,  1.376316899319120e-09,  1.356510078465103e-13, -1.272532769681179e-12,
  2.904915763323225e-14,  7.230273355801302e-16, -5.171836384566580e-17,  4.971721683810473e-19,  1.251267034584935e+00, -1.740350567704698e-02,  1.959026112487900e-04,
  6.879173699154455e-07, -1.515152154461545e-07,  4.998103932648034e-09, -3.240097706775763e-11, -4.076864208561914e-12,  1.741895730005589e-13, -1.428502958117865e-15,
 -1.413631806335315e-16,  6.143331943823432e-18,  3.330868717297582e-02, -4.481403682588039e-04,  5.825106507723412e-06, -6.300316042251342e-08,  1.749938716536504e-10,
  1.417828937667481e-11, -2.299448311192722e-13, -9.683499174647718e-15,  5.237457322330024e-16, -5.530168743257635e-18, -3.610831178803108e-19,  1.566214158224164e-20,
  9.970282282407987e-02, -1.341202656896510e-03,  1.740779747433397e-05, -1.863480034053212e-07,  4.063709293354637e-10,  4.650608410136565e-11, -7.638984216810040e-13,
 -2.950710685748638e-14,  1.643272500158137e-15, -1.810326012402731e-17, -1.116032156707227e-18,  4.966694419094370e-20,  2.026527313954914e-01, -2.725343923084830e-03,
  3.528389563811166e-05, -3.709684695262408e-07,  4.142198344567284e-10,  1.089277438275663e-10, -1.826069309561594e-12, -6.163513866515413e-14,  3.609980845755368e-15,
 -4.266435921128396e-17, -2.382384392201405e-18,  1.109410078112438e-19,  3.471807878081236e-01, -4.666958100250934e-03,  6.017311030034164e-05, -6.136375877635659e-07,
 -4.602092376467976e-10,  2.282061425526951e-10, -3.944914918489241e-12, -1.094701223450056e-13,  6.974768783562630e-15, -9.191184768834992e-17, -4.354187131924204e-18,
  2.193565437629761e-19,  5.423167291924634e-01, -7.284735619187748e-03,  9.327196034245251e-05, -9.001217128440796e-07, -3.898470292932431e-09,  4.725941882848502e-10,
 -8.566619235904129e-12, -1.773969193836212e-13,  1.314480754570200e-14, -2.052378968918992e-16, -7.257538768761045e-18,  4.251061253356883e-19,  8.060109959798176e-01,
 -1.081204280661075e-02,  1.365777251320840e-04, -1.167919184034683e-06, -1.535247093735425e-08,  1.068417242879125e-09, -2.102910467114963e-11, -2.564659707394062e-13,
  2.681148593509375e-14, -5.562838627345200e-16, -9.975630618114516e-18,  8.774019026310379e-19,  1.184791040255151e+00, -1.583730396001424e-02,  1.926933603667780e-04,
 -1.007255090508302e-06, -6.562523244925524e-08,  3.405948615296189e-09, -8.127539191232187e-11,  4.647724696335646e-14,  7.574431113528211e-14, -2.879887693179539e-15,
  3.325919086408274e-17,  1.540129271877677e-18,  3.160463191522721e-02, -4.044967964478006e-04,  5.094077871258331e-06, -5.829577961892957e-08,  3.901555167093571e-10,
  7.047139185468479e-12, -3.091147105317555e-13,  2.307825024724506e-15,  2.076306940342897e-16, -8.920005760122465e-18,  1.053342558584304e-19,  4.492090531713451e-21,
  9.460261437682384e-02, -1.210711225193486e-03,  1.523756872394446e-05, -1.735851709602888e-07,  1.113584900708115e-09,  2.338765340320186e-11, -9.908034142181783e-13,
  7.831867804130747e-15,  6.382015005586653e-16, -2.800400867952771e-17,  3.436594768103561e-19,  1.369795616430516e-20,  1.922880597854605e-01, -2.460618514397109e-03,
  3.093513082780761e-05, -3.496685077704575e-07,  2.074480722733098e-09,  5.558613261402386e-11, -2.246755203494328e-12,  1.931670361461074e-14,  1.352399028176595e-15,
 -6.154742115776554e-17,  8.044297345110130e-19,  2.852942941863501e-20,  3.294293229143539e-01, -4.214843040802034e-03,  5.289737389891819e-05, -5.902680642441516e-07,
  3.023227489264851e-09,  1.181306033616121e-10, -4.525273849013728e-12,  4.350426470292653e-14,  2.457033434349827e-15, -1.188244644196399e-16,  1.710080256522806e-18,
  4.982873322927419e-20,  5.146010809800617e-01, -6.582185653181871e-03,  8.236919941385823e-05, -8.989873088233927e-07,  3.307090574821810e-09,  2.468929449567402e-10,
 -8.971305821446911e-12,  9.975681654106177e-14,  4.135669697150526e-15, -2.228172938463620e-16,  3.717154097540034e-18,  7.528219794183619e-20,  7.648553204676188e-01,
 -9.778217070625378e-03,  1.217021667315110e-04, -1.270982333817523e-06,  8.049065073799978e-10,  5.548183888468971e-10, -1.939832621137361e-11,  2.638103907832396e-13,
  6.508881728902192e-15, -4.449785251026807e-16,  9.476453639836263e-18,  6.982907737987656e-20,  1.124429146744460e+00, -1.435744863337286e-02,  1.762215063167825e-04,
 -1.614038678027668e-06, -1.585738614977357e-08,  1.660344810726230e-09, -5.933338277755071e-11,  1.140308518750815e-12,  3.499200460238655e-15, -1.106985747265314e-15,
  4.004113950119798e-17, -6.061240629704331e-19,  3.006388032347213e-02, -3.664280040061364e-04,  4.435413791728777e-06, -5.129681709504636e-08,  4.648931884505129e-10,
  8.932990352712462e-13, -1.925642727143874e-13,  4.845020785058483e-15, -1.483835351919089e-17, -3.334100832454661e-18,  1.283870987110033e-19, -1.819839650710399e-21,
  8.999084262162625e-02, -1.096812212714935e-03,  1.327298134861939e-05, -1.532125532532596e-07,  1.369691202523267e-09,  3.729988019683978e-12, -6.140689999353142e-13,
  1.542767069941322e-14, -5.485871838013009e-17, -1.026068591296937e-17,  4.023618626798798e-19, -5.875350485907209e-21,  1.829148584730970e-01, -2.229290654146676e-03,
  2.696611751973189e-05, -3.102646348733417e-07,  2.708317384851737e-09,  1.125803473711401e-11, -1.380414286994464e-12,  3.465508829344472e-14, -1.506726936169958e-16,
 -2.178149639519577e-17,  8.813749358754016e-19, -1.351440195736859e-20,  3.133728008122895e-01, -3.819030833142591e-03,  4.616465478902499e-05, -5.283679100118021e-07,
  4.429522206736404e-09,  2.960945395932718e-11, -2.741566222149452e-12,  6.898663691075865e-14, -3.815150876597723e-16, -3.965718471826205e-17,  1.690943347395161e-18,
 -2.795015899089750e-20,  4.895235981787966e-01, -5.965179136843607e-03,  7.202694414535961e-05, -8.171349331029542e-07,  6.367947068352590e-09,  7.375250831804856e-11,
 -5.309080766926787e-12,  1.349817868289559e-13, -9.865901078629154e-16, -6.689480087504698e-17,  3.130582881992971e-18, -5.812805017562211e-20,  7.275943226882652e-01,
 -8.864695363521018e-03,  1.068194116120861e-04, -1.191857021399948e-06,  7.912426322980932e-09,  1.892615122281885e-10, -1.098282183390587e-11,  2.880171994886175e-13,
 -2.947766283514984e-15, -1.055089488243506e-16,  6.060311426631246e-18, -1.368453181644437e-19,  1.069692899510744e+00, -1.302738911254984e-02,  1.562053155464462e-04,
 -1.668762925010047e-06,  5.640697853026117e-09,  6.049992959495799e-10, -2.994533814173997e-11,  8.682793100886437e-13, -1.434712179402804e-14, -6.527385390809017e-17,
  1.328820753966772e-17, -4.697277813075986e-19,  2.866541489403109e-02, -3.332805424215313e-04,  3.864379163234366e-06, -4.392264833750047e-08,  4.468998620737831e-10,
 -2.233653736869312e-12, -7.551890382854021e-14,  3.269145666632979e-15, -6.366674979911836e-17,  4.329120769612166e-20,  4.302529884022345e-20, -1.572379700219329e-21,
  8.580484505887068e-02, -9.976088387467620e-04,  1.156617420335349e-05, -1.313615262809595e-07,  1.329791975330744e-09, -6.266075363441658e-12, -2.432207492887091e-13,
  1.031980701977252e-14, -2.022478126033857e-16,  2.443768243203691e-19,  1.322200505215099e-19, -4.913015168604500e-21,  1.744066233675324e-01, -2.027710764251718e-03,
  2.350540176852784e-05, -2.666173489042163e-07,  2.675673733452622e-09, -1.128447102184262e-11, -5.541104661347970e-13,  2.285222773970560e-14, -4.527746063916748e-16,
  9.339013547352153e-19,  2.799286771856385e-19, -1.070495479139778e-20,  2.987968908127735e-01, -3.473845530881634e-03,  4.025914204815223e-05, -4.557139131109070e-07,
  4.508969952022632e-09, -1.530251719061239e-11, -1.116892839162019e-12,  4.449349922809789e-14, -8.975998285380779e-16,  3.004982699601827e-18,  5.071730854015496e-19,
 -2.035138760609545e-20,  4.667557542957935e-01, -5.426380810248866e-03,  6.286220865405223e-05, -7.091705821963012e-07,  6.849820812155819e-09, -1.336492032696158e-11,
 -2.190393198202596e-12,  8.405700103849842e-14, -1.748260390726305e-15,  9.244839466551928e-18,  8.473457265139685e-19, -3.705924698615906e-20,  6.937573866691412e-01,
 -8.064989674728068e-03,  9.336220250637710e-05, -1.046778565547758e-06,  9.650207119459778e-09,  9.671887849496711e-12, -4.541229733588136e-12,  1.686599539976498e-13,
 -3.711815325089184e-15,  3.136184489564897e-17,  1.306599694967423e-18, -6.924924180251802e-20,  1.019958906515560e+00, -1.185560979516398e-02,  1.370148151925977e-04,
 -1.513426808329219e-06,  1.225623731963671e-08,  1.267984847010437e-10, -1.188279834161336e-11,  4.406547391564825e-13, -1.106890641605401e-14,  1.651088843522551e-16,
  6.982014318471734e-19, -1.345953741841821e-19,  2.739095116584019e-02, -3.043561363773481e-04,  3.378491863088471e-06, -3.720102022665507e-08,  3.903666275039441e-10,
 -3.167519371313048e-12, -1.057814573699992e-14,  1.475626815819025e-15, -4.447107805770880e-17,  7.419581698470211e-19,  1.151691711492670e-22, -4.622051581569528e-22,
  8.198998103497128e-02, -9.110342443947533e-04,  1.011257051738958e-05, -1.113191113717113e-07,  1.165860672162062e-09, -9.331792087559634e-12, -3.837676364094302e-14,
  4.656535164668872e-15, -1.397813738563707e-16,  2.354176539591274e-18, -9.018407393519735e-22, -1.416528909513191e-21,  1.666526039298394e-01, -1.851758282702342e-03,
  2.055359556240618e-05, -2.261455520313681e-07,  2.360713428058570e-09, -1.845357570388570e-11, -1.011922238446603e-13,  1.029765162811890e-14, -3.075186538962657e-16,
  5.261263863587218e-18, -6.605232917833688e-21, -2.984543387709960e-21,  2.855127118543238e-01, -3.172451071054846e-03,  3.520964056927242e-05, -3.871076916016677e-07,
  4.019813416151945e-09, -3.020148723144024e-11, -2.376319633991992e-13,  1.997509261496840e-14, -5.934191719519028e-16,  1.040676671668982e-17, -2.673858117595822e-20,
 -5.362397191893207e-21,  4.460047139177971e-01, -4.955695519260263e-03,  5.499359627661201e-05, -6.038759371187559e-07,  6.216733190089785e-09, -4.353918740139569e-11,
 -5.388294135956873e-13,  3.739250371811998e-14, -1.107974244696153e-15,  2.021041667311390e-17, -9.190519047039167e-20, -8.821138307738430e-21,  6.629153532534773e-01,
 -7.365729296253077e-03,  8.171832115502435e-05, -8.953694545186290e-07,  9.072239021937224e-09, -5.478963832625961e-11, -1.268218813649540e-12,  7.333772032729364e-14,
 -2.187916831122231e-15,  4.271066529867744e-17, -3.300558675619661e-19, -1.312215203051614e-20,  9.746185398270857e-01, -1.082869185373546e-02,  1.200736689605079e-04,
 -1.308989102439008e-06,  1.275615585991852e-08, -4.489218746596561e-11, -3.621768024694560e-12,  1.786731954650124e-13, -5.561803169851645e-15,  1.254468368029012e-16,
 -1.751661205500810e-18, -4.751430426003847e-21,  2.622489872510954e-02, -2.790125158928609e-04,  2.967451669608922e-06, -3.146428622965683e-08,  3.270954675512130e-10,
 -3.062439539462335e-12,  1.466672071330462e-14,  4.527646177687489e-16, -2.085012728194339e-17,  5.203692023193279e-19, -7.864652734616148e-21,  1.660199365501137e-24,
  7.849961374163866e-02, -8.351742063737466e-04,  8.882444101125695e-06, -9.417225281262121e-08,  9.782869263831843e-10, -9.117947673080240e-12,  4.155234077890456e-14,
  1.447109072383323e-15, -6.533396128274709e-17,  1.631752414105123e-18, -2.492656807516374e-20,  1.810357467020362e-23,  1.595581102248011e-01, -1.697570884307931e-03,
  1.805409511210752e-05, -1.913784530407636e-07,  1.985683916072857e-09, -1.836583029828148e-11,  7.639143384330774e-14,  3.258287437180869e-15, -1.429501530016018e-16,
  3.576666289148357e-18, -5.561135522156348e-20,  8.684332669401048e-23,  2.733583231652873e-01, -2.908308843635711e-03,  3.092974966892983e-05, -3.277769401938239e-07,
  3.394379292884047e-09, -3.100864183253568e-11,  1.087345323083089e-13,  6.458947054002240e-15, -2.732959082302823e-16,  6.865980204255516e-18, -1.097198082297758e-19,
  3.093056449098313e-22,  4.270182308728103e-01, -4.543111083729500e-03,  4.831369674069176e-05, -5.117849678166484e-07,  5.283445381924732e-09, -4.728053149910923e-11,
  1.130197560521018e-13,  1.236957203049655e-14, -5.020032048034904e-16,  1.272635029772121e-17, -2.122510137064599e-19,  9.987138488461377e-22,  6.346952451439529e-01,
 -6.752583888248634e-03,  7.180490713704539e-05, -7.600607527557734e-07,  7.803149030962513e-09, -6.718640941456711e-11,  1.380378067471076e-14,  2.470577948503939e-14,
 -9.602699787817924e-16,  2.485698399336967e-17, -4.453270841211953e-19,  3.431339761367799e-21,  9.331302464403475e-01, -9.927556077867756e-03,  1.055493472012022e-04,
 -1.115408292014508e-06,  1.130633646012754e-08, -8.819826615113453e-11, -5.267409206541304e-13,  5.975159650351605e-14, -2.252126219943244e-15,  6.179484164406646e-17,
 -1.280423491862562e-18,  1.717194382196753e-20,  2.515405624691492e-02, -2.566987323630708e-04,  2.619331095355680e-06, -2.669846903169256e-08,  2.700696244027450e-10,
 -2.618509613772579e-12,  2.040077790211793e-14,  2.732562458120518e-17, -7.387665977908856e-18,  2.447798621538956e-19, -5.402017382337111e-21,  7.669233478855545e-23,
  7.529423682924813e-02, -7.683822815591280e-04,  7.840479077555556e-06, -7.991419429405331e-08,  8.081674811006678e-10, -7.823116895582207e-12,  6.031035481399825e-14,
  1.133501718283323e-16, -2.321053048573195e-17,  7.643608890547331e-19, -1.691201879246022e-20,  2.427270546766715e-22,  1.530428741081719e-01, -1.561811330933842e-03,
  1.593644595633942e-05, -1.624233330061659e-07,  1.641870127091556e-09, -1.585042404316461e-11,  1.200052193248132e-13,  3.386137687345017e-16, -5.095808092716632e-17,
  1.663459414407621e-18, -3.697439845989951e-20,  5.402727626264147e-22,  2.621962954958839e-01, -2.675726837840195e-03,  2.730241139985446e-05, -2.782401179950020e-07,
  2.810706986065891e-09, -2.701770915160452e-11,  1.985696368490978e-13,  8.765685263277291e-16, -9.774158141949789e-17,  3.156332353923790e-18, -7.070949260998061e-20,
  1.062152874448778e-21,  4.095818459022345e-01, -4.179800530885221e-03,  4.264901398190332e-05, -4.345773796539392e-07,  4.385224821057172e-09, -4.185935428927382e-11,
  2.923915617705457e-13,  2.127980174582339e-15, -1.797397869834950e-16,  5.738084399898167e-18, -1.303285759543692e-19,  2.043115554454718e-21,  6.087788865636948e-01,
 -6.212606149895140e-03,  6.338950874750285e-05, -6.457600174335024e-07,  6.503909096048274e-09, -6.131389396281145e-11,  3.873907269213190e-13,  5.209623507530950e-15,
 -3.417003335412867e-16,  1.081571714691121e-17, -2.522318624336284e-19,  4.242750769859474e-21,  8.950282027472294e-01, -9.133761787996339e-03,  9.319067273676078e-05,
 -9.488600391126975e-07,  9.516934092144908e-09, -8.716908106512104e-11,  4.096896178974993e-13,  1.482872338483605e-14, -7.746895472398941e-16,  2.472315403635455e-17,
 -6.142704954524390e-19,  1.187806479965975e-20,  2.416724020792920e-02, -2.369559588145917e-04,  2.323233861717594e-06, -2.276984353206067e-08,  2.225491685856409e-10,
 -2.139613060314996e-12,  1.892060403150660e-14, -1.034656301269482e-16, -1.697515905820706e-18,  9.059783638445557e-20, -2.507060663850020e-21,  5.058816742041360e-23,
  7.234037719231223e-02, -7.092858886714943e-04,  6.954184257236304e-06, -6.815671569678920e-08,  6.660954647571004e-10, -6.400252549183900e-12,  5.640835454246143e-14,
 -2.997280335126102e-16, -5.450874015468536e-18,  2.827988228870237e-19, -7.812199187020634e-21,  1.581670916988639e-22,  1.470388677470477e-01, -1.441692565833176e-03,
  1.413503330336426e-05, -1.385324662262801e-07,  1.353679807632798e-09, -1.299454930593100e-11,  1.138830840028407e-13, -5.751823438565956e-16, -1.234567494628837e-17,
  6.147809318916190e-19, -1.694522156865825e-20,  3.450580886469185e-22,  2.519101077897037e-01, -2.469937924902900e-03,  2.421637499952077e-05, -2.373295482870917e-07,
  2.318552464617945e-09, -2.222329772854199e-11,  1.930196550298311e-13, -8.929242087113128e-16, -2.461285881692367e-17,  1.163380111148902e-18, -3.199896742540123e-20,
  6.577429166299535e-22,  3.935136033570409e-01, -3.858336440589913e-03,  3.782870678606676e-05, -3.707193110526316e-07,  3.620371345447980e-09, -3.461786062617091e-11,
  2.962917037117002e-13, -1.161244190514776e-15, -4.727999259609302e-17,  2.101750141635257e-18, -5.777551717309958e-20,  1.206247175792911e-21,  5.848959953143289e-01,
 -5.734807242575222e-03,  5.622602378428507e-05, -5.509711797200938e-07,  5.377335291751026e-09, -5.120306700094361e-11,  4.267862598838280e-13, -1.109625764870891e-15,
 -9.396470251370238e-17,  3.902535252090438e-18, -1.077701763863399e-19,  2.314459989325156e-21,  8.599155778325747e-01, -8.431321579833475e-03,  8.266246125506401e-05,
 -8.099020877806165e-07,  7.893979123314090e-09, -7.447956160998204e-11,  5.831192377366550e-13,  4.325208765997003e-16, -2.200791285016552e-16,  8.540142216315526e-18,
 -2.414292902467608e-19,  5.524386397191855e-21,  2.325493897300567e-02, -2.194056041762717e-04,  2.070025350346599e-06, -1.952778529734689e-08,  1.840420542992540e-10,
 -1.724002175098352e-12,  1.563786153355109e-14, -1.211604342285533e-16,  2.113920407181655e-19,  2.577370415755379e-20, -9.364738994685532e-22,  2.293986233854580e-23,
  6.960956421332694e-02, -6.567520247389380e-04,  6.196254510379521e-06, -5.845277844282346e-08,  5.508798255320269e-10, -5.159316029978784e-12,  4.674464151717874e-14,
 -3.597194045848447e-16,  5.178735240868755e-19,  8.098505960781117e-20, -2.913385411544463e-21,  7.137600303316213e-23,  1.414882245003550e-01, -1.334912473438103e-03,
  1.259448520376289e-05, -1.188102712275722e-07,  1.119657435418618e-09, -1.048282278545216e-11,  9.479441312897444e-14, -7.211336044320870e-16,  6.610751996087177e-19,
  1.777339848556805e-19, -6.300614029735796e-21,  1.544508199061866e-22,  2.424006288355202e-01, -2.287000288325869e-03,  2.157712323981338e-05, -2.035464216609349e-07,
  1.918062265012045e-09, -1.794872164376485e-11,  1.618166635546544e-13, -1.208400484605345e-15,  7.076324048401028e-20,  3.403073808608719e-19, -1.183601605837114e-20,
  2.906312799029600e-22,  3.786586661674029e-01, -3.572566745885051e-03,  3.370599851340920e-05, -3.179592363719269e-07,  2.995852968295261e-09, -2.801173327572872e-11,
  2.513206394233403e-13, -1.820073045094067e-15, -2.563317218828233e-18,  6.226539877476716e-19, -2.116961400270988e-20,  5.219993932086256e-22,  5.628164756677285e-01,
 -5.310057318948926e-03,  5.009856206366162e-05, -4.725850471946341e-07,  4.451886850203060e-09, -4.156834814314397e-11,  3.698201206542089e-13, -2.530194948061212e-15,
 -1.082821328703639e-17,  1.168306098317996e-18, -3.875483151555748e-20,  9.655251131097497e-22,  8.274542265570980e-01, -7.806858323269117e-03,  7.365474834581451e-05,
 -6.947618965207513e-07,  6.542201155280193e-09, -6.090739721949987e-11,  5.319414201174970e-13, -3.155006947558434e-15, -3.915835472391751e-17,  2.546866224171254e-18,
 -8.283222284812702e-20,  2.125632167613252e-21,  2.240902022748020e-02, -2.037351692676760e-04,  1.852285077862847e-06, -1.683969191199865e-08,  1.530470924883906e-10,
 -1.387997385908437e-12,  1.243783905592381e-14, -1.051287573301651e-16,  6.601380386480061e-19,  3.397415194525397e-21, -2.866930506362002e-22,  8.513760576061559e-24,
  6.707745545236653e-02, -6.098453456146275e-04,  5.544488718594248e-06, -5.040659994275120e-08,  4.581149902560775e-10, -4.154414955509995e-12,  3.721299131138215e-14,
 -3.138569463085109e-16,  1.942525210753171e-18,  1.134130028201130e-20, -8.938567532683085e-22,  2.643141626289846e-23,  1.363414667006785e-01, -1.239570102488570e-03,
  1.126971229201419e-05, -1.024561532068136e-07,  9.311481552962547e-10, -8.443206597442002e-12,  7.557999410648699e-14, -6.351447408267966e-16,  3.834759085768871e-18,
  2.704100370493715e-20, -1.938806714581959e-21,  5.697509467061982e-23,  2.335830943504600e-01, -2.123657785534593e-03,  1.930750635278561e-05, -1.755295940480486e-07,
  1.595222404404269e-09, -1.446229470144413e-11,  1.293275693955698e-13, -1.080635836118459e-15,  6.263831340378696e-18,  5.712338526501606e-20, -3.653684415254566e-21,
  1.065274327777007e-22,  3.648846271074389e-01, -3.317406463695778e-03,  3.016061612920481e-05, -2.741970222086874e-07,  2.491829201854758e-09, -2.258501339451181e-11,
  2.016373329802540e-13, -1.669509089665625e-15,  9.022757377647463e-18,  1.163382548692072e-19, -6.549039481703335e-21,  1.892643390492221e-22,  5.423435369421463e-01,
 -4.930802163255016e-03,  4.482898303595353e-05, -4.075479325943856e-07,  3.703467665734473e-09, -3.355201332672966e-11,  2.987233764715675e-13, -2.434119364642175e-15,
  1.144655883178547e-17,  2.436902366699420e-19, -1.196533705473723e-20,  3.430541376671810e-22,  7.973548629667011e-01, -7.249277657751530e-03,  6.590761871147361e-05,
 -5.991699009606148e-07,  5.444120796594417e-09, -4.927672298164415e-11,  4.361775853509688e-13, -3.430534000952360e-15,  1.055208969659300e-17,  5.900468408471119e-19,
 -2.511593384760842e-20,  7.201699869151427e-22,  2.162249241049606e-02, -1.896855742214285e-04,  1.664035125559858e-06, -1.459775615514883e-08,  1.280463728973081e-10,
 -1.122376051368677e-12,  9.796137371609129e-15, -8.366565589726051e-17,  6.459239638214714e-19, -2.724314449438479e-21, -6.134258808670363e-23,  2.676997120198539e-24,
  6.472312295819163e-02, -5.677903591384642e-04,  4.980995978720110e-06, -4.369579949552026e-08,  3.832831432955377e-10, -3.359556208730775e-12,  2.931846305491981e-14,
 -2.502170157551321e-16,  1.924207014368687e-18, -7.818499185366396e-21, -1.943328446069475e-22,  8.313640892840353e-24,  1.315560564316824e-01, -1.154089249548431e-03,
  1.012435950529513e-05, -8.881592946011442e-08,  7.790565851654138e-10, -6.828360699165444e-12,  5.957732593494250e-14, -5.078438511703347e-16,  3.879860028944395e-18,
 -1.475208828264530e-20, -4.314312653072518e-22,  1.792381667335698e-23,  2.253846279637302e-01, -1.977210191118904e-03,  1.734526664777951e-05, -1.521612237225197e-07,
  1.334686328429494e-09, -1.169779092566949e-11,  1.020284545091958e-13, -8.680578168445168e-16,  6.563332000536105e-18, -2.220955404323073e-20, -8.375563723458400e-22,
  3.349404801975141e-23,  3.520776457977289e-01, -3.088637911532146e-03,  2.709537113677693e-05, -2.376936941697504e-07,  2.084915029539121e-09, -1.827163942438609e-11,
  1.592813211530103e-13, -1.351125552075957e-15,  1.004611436640577e-17, -2.708329309289867e-20, -1.554698777408119e-21,  5.935937189371243e-23,  5.233079763197971e-01,
 -4.590773836548915e-03,  4.027299686656598e-05, -3.532935884871802e-07,  3.098838749126839e-09, -2.715369876411210e-11,  2.364990865401887e-13, -1.995956042369327e-15,
  1.440764509202152e-17, -2.073086600112333e-20, -2.950655855085225e-21,  1.067781248145890e-22,  7.693687335757616e-01, -6.749367426429799e-03,  5.920944812227281e-05,
 -5.194112466329703e-07,  4.555748007591756e-09, -3.990896611767154e-11,  3.469590616026415e-13, -2.897043824433170e-15,  1.955606261797541e-17,  3.130774277595941e-20,
 -6.410995297667626e-21,  2.187752337187250e-22,  2.088931226663788e-02, -1.770407837058308e-04,  1.500453036238209e-06, -1.271657595764423e-08,  1.077718115476656e-10,
 -9.131475441605956e-13,  7.725839940591272e-15, -6.485769385128280e-17,  5.248079982746594e-19, -3.582587808079590e-21,  4.052674398336533e-24,  6.668600589239862e-25,
  6.252847732376908e-02, -5.299404061396192e-04,  4.491341885220147e-06, -3.806482754178971e-08,  3.225956671479532e-10, -2.733326996766766e-12,  2.312479973214941e-14,
 -1.940831669717541e-16,  1.568475748790002e-18, -1.063219313299768e-20,  9.102792378446565e-24,  2.084794020354472e-24,  1.270952252563624e-01, -1.077155532100427e-03,
  9.129090102517790e-06, -7.737046243487937e-08,  6.557062349201627e-10, -5.555688713046179e-12,  4.699957897658239e-14, -3.943015896452449e-16,  3.179843583839884e-18,
 -2.130145407864482e-20,  8.249217101014229e-24,  4.538661971539651e-24,  2.177422373306349e-01, -1.845405717583335e-03,  1.564015070046925e-05, -1.325526920817342e-07,
  1.123367458009147e-09, -9.517952705791982e-12,  8.051054049819524e-14, -6.750179873460973e-16,  5.425845161808803e-18, -3.566693807712079e-20, -1.338207537309588e-23,
  8.587641214026846e-24,  3.401393209851246e-01, -2.882743627586399e-03,  2.443177856764416e-05, -2.070630372052120e-07,  1.754828108111210e-09, -1.486776332201332e-11,
  1.257424929171911e-13, -1.053221995753464e-15,  8.422149257403332e-18, -5.368027335004929e-20, -8.905685617937878e-23,  1.544083134911746e-23,  5.055635365621743e-01,
 -4.284744430306769e-03,  3.631399016068817e-05, -3.077664449671123e-07,  2.608261707955734e-09, -2.209757741084944e-11,  1.868358471188858e-13, -1.562377390732215e-15,
  1.238381184294337e-17, -7.464292710562908e-20, -3.063842017910271e-22,  2.818517219829298e-23,  7.432808127568685e-01, -6.299442271780009e-03,  5.338891831368415e-05,
 -4.524785869500210e-07,  3.834633080233611e-09, -3.248497888433526e-11,  2.745085641575154e-13, -2.287864106679078e-15,  1.780041316631242e-17, -9.392165518757519e-20,
 -9.959623495569673e-22,  5.821866252221067e-23,  2.020422955392094e-02, -1.656195665921140e-04,  1.357628567043784e-06, -1.112884089392528e-08,  9.122527469730784e-11,
 -7.477387894001552e-13,  6.126028350227195e-15, -5.005395869961841e-17,  4.035862893591555e-19, -3.066635165923727e-21,  1.749774190450284e-23,  6.991463986099609e-26,
  6.047780287770795e-02, -4.957530042764340e-04,  4.063822009466168e-06, -3.331222455663786e-08,  2.730667301905196e-10, -2.238219760544965e-12,  1.833690947870572e-14,
 -1.498135790566258e-16,  1.207443174472228e-18, -9.155516705341539e-21,  5.156219462266776e-23,  2.339584917213749e-25,  1.229270295518697e-01, -1.007666305675043e-03,
  8.260114345300957e-06, -6.771034129112219e-08,  5.550345354020804e-10, -4.549384409579780e-12,  3.727062709157633e-14, -3.044633221875928e-16,  2.452158885992185e-18,
 -1.852898025522788e-20,  1.020583420585026e-22,  5.590202191337127e-25,  2.106011959879904e-01, -1.726355300976732e-03,  1.415140315735491e-05, -1.160027877390841e-07,
  9.508963912315846e-10, -7.794061364004116e-12,  6.385038150103459e-14, -5.214878276623598e-16,  4.195559741656030e-18, -3.153022494901551e-20,  1.675196489583694e-22,
  1.181345227807718e-24,  3.289841634838131e-01, -2.696772692929298e-03,  2.210617790464530e-05, -1.812101630498367e-07,  1.485412146008341e-09, -1.217515526366262e-11,
  9.973600834678089e-14, -8.143233377558261e-16,  6.540527907820205e-18, -4.873148153297777e-20,  2.436948637493597e-22,  2.397749078226142e-24,  4.889831516302893e-01,
 -4.008327927323536e-03,  3.285735196710817e-05, -2.693403365014708e-07,  2.207828035582618e-09, -1.809621478941638e-11,  1.482274767089089e-13, -1.209619419455530e-15,
  9.688214616049649e-18, -7.112848220050913e-20,  3.169443786659273e-22,  4.967624700000133e-24,  7.189042881925014e-01, -5.893054032352990e-03,  4.830696266868022e-05,
 -3.959847594436381e-07,  3.245945409999060e-09, -2.660442722993579e-11,  2.178828856678857e-13, -1.776213567051819e-15,  1.414530237621891e-17, -1.006632099265874e-19,
  3.279274422931322e-22,  1.166348070738590e-23,  1.956266114736841e-02, -1.552689960707083e-04,  1.232371229877585e-06, -9.781337880385267e-09,  7.763435052723802e-11,
 -6.161699766567773e-13,  4.889705759131404e-15, -3.876837613441348e-17,  3.059584544724355e-19, -2.363786005230218e-21,  1.665181465358787e-23, -7.099673858083751e-26,
  5.855738084334166e-02, -4.647703943474240e-04,  3.688886234867615e-06, -2.927871213734031e-08,  2.323847411415897e-10, -1.844395234977704e-12,  1.463640745917114e-14,
 -1.160429045536073e-16,  9.156801071715952e-19, -7.069567095328236e-21,  4.963440471507160e-23, -2.059688262113816e-25,  1.190235845699978e-01, -9.446911309773329e-04,
  7.498020850295742e-06, -5.951183590647348e-08,  4.723445902936866e-10, -3.748909524489509e-12,  2.974970589151424e-14, -2.358571378857952e-16,  1.860697706868836e-18,
 -1.434941368433953e-20,  1.001810139023202e-22, -3.965857636643399e-25,  2.039137312002733e-01, -1.618464895328081e-03,  1.284576844530077e-05, -1.019569389823726e-07,
  8.092306507521759e-10, -6.422701991745483e-12,  5.096725254728731e-14, -4.040455099279618e-16,  3.186437387694961e-18, -2.453034234313927e-20,  1.697587645905666e-22,
 -6.206606462041099e-25,  3.185375466048606e-01, -2.528235023517408e-03,  2.006662099469265e-05, -1.592688847288139e-07,  1.264114404497723e-09, -1.003300347441106e-11,
  7.961554460971228e-14, -6.310952497708484e-16,  4.974338160147060e-18, -3.818993342319816e-20,  2.606204688285386e-22, -8.256257249744946e-25,  4.734559007431477e-01,
 -3.757823223690452e-03,  2.982587201996551e-05, -2.367281083477330e-07,  1.878906274279896e-09, -1.491242586337814e-11,  1.183326374466632e-13, -9.378485378555235e-16,
  7.385595283086410e-18, -5.644429887715802e-20,  3.760344865920325e-22, -8.665455773917204e-25,  6.960760839789989e-01, -5.524761375490211e-03,  4.385007365095915e-05,
 -3.480382531120975e-07,  2.762370835567902e-09, -2.192413548663493e-11,  1.739634885963469e-13, -1.378324887509953e-15,  1.083518627796766e-17, -8.204750834188512e-20,
  5.190843830011831e-22, -1.832765346068367e-25  };
  constexpr double w[2688] = {  1.670205300060603e-03, -1.652419799988172e-04,  1.020567956119498e-05, -4.987376379332512e-07,  2.097836682521255e-08,
 -7.914031193197632e-10,  2.742013592470350e-11, -8.859440345982044e-13,  2.697484980252943e-14, -7.798576494342290e-16,  2.152965077760976e-17, -5.697012909825583e-19,
  1.089895584212271e-02, -1.588794898779405e-03,  1.402479921207832e-04, -9.464107542717225e-06,  5.331113696571569e-07, -2.622939686200559e-08,  1.158269895894816e-09,
 -4.673903189349210e-11,  1.745341606574079e-12, -6.087630050931001e-14,  1.997375539779985e-15, -6.193918162264215e-17,  2.934051270581383e-02, -6.103070382278904e-03,
  7.297111793057914e-04, -6.412310316732612e-05,  4.562012200818263e-06, -2.765121528961285e-07,  1.472999136656352e-08, -7.041354646379729e-10,  3.065507190234336e-11,
 -1.228921858260716e-12,  4.575166406543771e-14, -1.590853481581822e-15,  4.924901345677576e-02, -1.359700417180429e-02,  2.074471018346795e-03, -2.252587408487149e-04,
  1.930093382562747e-05, -1.379415479482086e-06,  8.510631127614248e-08, -4.639573763432274e-09,  2.272489571443759e-10, -1.012710059788561e-11,  4.146332608148529e-13,
 -1.570057595809153e-14,  5.891090641696562e-02, -1.998433714099128e-02,  3.666556010913758e-03, -4.679449820072934e-04,  4.621012368685549e-05, -3.743449381018002e-06,
  2.580835690094086e-07, -1.552833241189438e-08,  8.304054288878973e-10, -4.001833285721221e-11,  1.756830499549088e-12, -7.078119243233849e-14,  5.077614162926550e-02,
 -1.971033998116429e-02,  4.102666406270870e-03, -5.856012679071608e-04,  6.382201177528058e-05, -5.639770038480855e-06,  4.198446684371034e-07, -2.703553989636902e-08,
  1.535322660009569e-09, -7.803461058348443e-11,  3.591201630836642e-12, -1.508437669183402e-13,  2.554243167986650e-02, -1.065094835576473e-02,  2.376367825872814e-03,
 -3.609747383412535e-04,  4.156629266568643e-05, -3.855649684148059e-06,  2.995643958945970e-07, -2.003114793678149e-08,  1.176008298198935e-09, -6.155167802987402e-11,
  2.906940709626880e-12, -1.249163661296377e-13,  1.141342797601231e-03, -1.028362084981314e-04,  5.808803864368294e-06, -2.609139174779817e-07,  1.013413762296598e-08,
 -3.544765880573690e-10,  1.142918232525529e-11, -3.447690308416396e-13,  9.830003731038166e-15, -2.668604131045478e-16,  6.935979233371141e-18, -1.732286071955450e-19,
  6.230750317886042e-03, -8.079615736037199e-04,  6.444871881057063e-05, -3.973461781308302e-06,  2.061803653643778e-07, -9.406106677168162e-09,  3.872681170880017e-10,
 -1.463953397851399e-11,  5.142827954245499e-13, -1.693916304675871e-14,  5.266622140921759e-16, -1.552712470823912e-17,  1.305243604132847e-02, -2.424610939087880e-03,
  2.634584102113441e-04, -2.129591023503970e-05,  1.406427402236734e-06, -7.971143844211928e-08,  3.994752367445457e-09, -1.805844896492536e-10,  7.468522988351555e-12,
 -2.855712688035553e-13,  1.017716909856243e-14, -3.398884060818395e-16,  1.627816844074763e-02, -4.110891226592084e-03,  5.806714106846005e-04, -5.896465410175487e-05,
  4.762531309298630e-06, -3.229440109539065e-07,  1.900761186833975e-08, -9.930980993875658e-10,  4.680695107134134e-11, -2.014280340541649e-12,  7.988815757356866e-14,
 -2.938690759976653e-15,  1.438242574997832e-02, -4.609547764508048e-03,  8.035274762307328e-04, -9.805877598552105e-05,  9.310065955320341e-06, -7.284578702892886e-07,
  4.869608980232888e-08, -2.850352236048114e-09,  1.487116196779717e-10, -7.009295391453705e-12,  3.016142875749135e-13, -1.193432346608270e-14,  9.575416035458018e-03,
 -3.617410185933547e-03,  7.338960818449642e-04, -1.023965425338465e-04,  1.093785926860003e-05, -9.495358809648526e-07,  6.958132088966233e-08, -4.418111130542486e-09,
  2.477650818495138e-10, -1.245152487331576e-11,  5.672237371632434e-13, -2.360777135256487e-14,  4.089451543724110e-03, -1.691197491307070e-03,  3.742192608284698e-04,
 -5.641403789091638e-05,  6.451420749069377e-06, -5.946952795359527e-07,  4.594273764940039e-08, -3.056180240493206e-09,  1.785747624447736e-10, -9.305792172894961e-12,
  4.377245376557270e-13, -1.874002065730233e-14,  8.063952965776785e-04, -6.658917898456015e-05,  3.457392684161322e-06, -1.433204514650504e-07,  5.157654658321043e-09,
 -1.677491696245415e-10,  5.045253250727660e-12, -1.423784450389929e-13,  3.807683115903701e-15, -9.719494426586513e-17,  2.380745553795221e-18, -5.616156141723990e-20,
  3.791849849763032e-03, -4.386106407524599e-04,  3.167472522547290e-05, -1.786479000866351e-06,  8.545958993263656e-08, -3.616399013938492e-09,  1.388223871404084e-10,
 -4.914524697634760e-12,  1.623181706366136e-13, -5.044351075339681e-15,  1.484569827006165e-16, -4.155727175530290e-18,  6.365325595189257e-03, -1.050830411502163e-03,
  1.034420527824413e-04, -7.669917536330780e-06,  4.689375880458133e-07, -2.478485220343857e-08,  1.165323099563477e-09, -4.967862224102536e-11,  1.946327366436393e-12,
 -7.078307520815231e-14,  2.407930618651632e-15, -7.702156345601216e-17,  5.983149713029625e-03, -1.367260645776483e-03,  1.774275440668813e-04, -1.674101689724580e-05,
  1.267435650634043e-06, -8.112766331854862e-08,  4.533791462409505e-09, -2.260362877500341e-10,  1.020983956070429e-11, -4.226620072025037e-13,  1.617996319598004e-14,
 -5.762368731821630e-16,  3.855861194158966e-03, -1.154272001304826e-03,  1.894635560205623e-04, -2.194489701632581e-05,  1.990527363153833e-06, -1.496019340668611e-07,
  9.649646509644620e-09, -5.471060867377115e-10,  2.774026207824879e-11, -1.274325808561512e-12,  5.357854112759761e-14, -2.076115955106878e-15,  1.911968429683587e-03,
 -6.979576654986210e-04,  1.371777815993469e-04, -1.861358507392885e-05,  1.940339431920166e-06, -1.648692345579593e-07,  1.185470180885962e-08, -7.401669087895333e-10,
  4.089037144585077e-11, -2.027566665086329e-12,  9.125817481387731e-14, -3.757209253589755e-15,  6.678825823493822e-04, -2.733593080082527e-04,  5.987485982348412e-05,
 -8.943142443572756e-06,  1.014263282726780e-06, -9.279975592169515e-08,  7.121051211537155e-09, -4.708221723574103e-10,  2.735825389286314e-11, -1.418472658171055e-12,
  6.641265702093449e-14, -2.831183596346041e-15,  5.861555664297684e-04, -4.462462219883899e-05,  2.140092649670381e-06, -8.220234946770434e-08,  2.750114384162645e-09,
 -8.341209696748314e-11,  2.346039815345367e-12, -6.207118673037415e-14,  1.559929606096466e-15, -3.749960662102788e-17,  8.667976472661153e-19, -1.933310301244631e-20,
  2.435241540121864e-03, -2.522354406324448e-04,  1.653425118330464e-05, -8.547583700881928e-07,  3.774921678078237e-08, -1.483211956868210e-09,  5.311653497153891e-11,
 -1.761474000598706e-12,  5.469684294546754e-14, -1.603329741360253e-15,  4.464194571283633e-17, -1.185628986579846e-18,  3.374648747491938e-03, -4.936209653078606e-04,
  4.394321195476273e-05, -2.983955997280653e-06,  1.686090266328182e-07, -8.295157340940336e-09,  3.651937240599340e-10, -1.465126969730776e-11,  5.425816273991265e-13,
 -1.872518755028582e-14,  6.066329707807380e-16, -1.854010184282020e-17,  2.442712648346985e-03, -5.000699992916108e-04,  5.921504934677970e-05, -5.162339113632959e-06,
  3.645124385216506e-07, -2.192343765499103e-08,  1.158305892442953e-09, -5.488163652900327e-11,  2.366553531340151e-12, -9.389947609150984e-14,  3.457427157811012e-15,
 -1.188188327475133e-16,  1.145329197927015e-03, -3.161890021199733e-04,  4.840472812746683e-05, -5.279751845326549e-06,  4.544747086407218e-07, -3.261785744032813e-08,
  2.019577409256818e-09, -1.103971197101115e-10,  5.417129332812255e-12, -2.416186897577825e-13,  9.891785105533137e-15, -3.741847450542552e-16,  4.089595103462600e-04,
 -1.429501901313009e-04,  2.701427041238184e-05, -3.542721916676989e-06,  3.585255338593554e-07, -2.968501511001632e-08,  2.086414265977489e-09, -1.276725885944342e-10,
  6.928239728451846e-12, -3.381023789425837e-13,  1.500167161489490e-14, -6.097749630950242e-16,  1.117946163621775e-04, -4.515826924303428e-05,  9.766263155100281e-06,
 -1.442205795096406e-06,  1.619168977160253e-07, -1.468164894978594e-08,  1.117564221682358e-09, -7.335678489674786e-11,  4.234787873475775e-12, -2.182667641738210e-13,
  1.016411841630565e-14, -4.311657863013302e-16,  4.365619604006514e-04, -3.081104408379547e-05,  1.371132154765089e-06, -4.899056802463397e-08,  1.528758458641551e-09,
 -4.336603589719045e-11,  1.143503839580932e-12, -2.842939298047591e-14,  6.727364368501455e-16, -1.525565018644989e-17,  3.333047854227870e-19, -7.037422165943850e-21,
  1.637889647839365e-03, -1.525973781296262e-04,  9.107986919208843e-06, -4.326110852284525e-07,  1.767169178883225e-08, -6.456246960051510e-10,  2.159304586304891e-11,
 -6.712856437378061e-13,  1.960602997316167e-14, -5.421915112977926e-16,  1.428155092344245e-17, -3.597647039044384e-19,  1.927794175941927e-03, -2.495307602866167e-04,
  2.007924657234837e-05, -1.248004701626248e-06,  6.512302277932253e-08, -2.979318075469144e-09,  1.226673663125866e-10, -4.624909637266991e-12,  1.616438388080189e-13,
 -5.284805968375085e-15,  1.627505347248789e-16, -4.743390569913202e-18,  1.103381985016062e-03, -2.005885605199063e-04,  2.155484348074584e-05, -1.728278930830757e-06,
  1.133417673039161e-07, -6.380252739420278e-09,  3.175038592076206e-10, -1.424538917443053e-11,  5.843844781801890e-13, -2.214895349203081e-14,  7.818634231890027e-16,
 -2.584649600891534e-17,  3.794941094701960e-04, -9.530798464622067e-05,  1.347644892746115e-05, -1.373361033731988e-06,  1.114298613769385e-07, -7.591633455381931e-09,
  4.488024702605182e-10, -2.353945515920509e-11,  1.112950623585667e-12, -4.800519883802280e-14,  1.906650266794337e-15, -7.017302316233570e-17,  9.494427381515653e-05,
 -3.141593411507478e-05,  5.656692997468957e-06, -7.116828567606915e-07,  6.948981072337004e-08, -5.577206875676898e-09,  3.814493596297501e-10, -2.278753503067509e-11,
  1.210534559198414e-12, -5.796626630978276e-14,  2.528812456428265e-15, -1.012444710413452e-16,  1.929984263625710e-05, -7.664113673807663e-06,  1.631010958292008e-06,
 -2.374540287495329e-07,  2.632834226936727e-08, -2.361187369728084e-09,  1.779905844793182e-10, -1.158228572591492e-11,  6.634475912736810e-13, -3.395615885546085e-14,
  1.571249517624235e-15, -6.627050940116135e-17,  3.320435061992616e-04, -2.183512646501783e-05,  9.055680161312068e-07, -3.021045297488376e-08,  8.821119812355173e-10,
 -2.347010369880003e-11,  5.816566587845727e-13, -1.361862113969916e-14,  3.041176653288857e-16, -6.515401340741157e-18,  1.347781745321083e-19, -2.699008656369803e-21,
  1.146038683573567e-03, -9.651777403860423e-05,  5.263405960085153e-06, -2.303193470122593e-07,  8.721145406522504e-09, -2.967921969859951e-10,  9.283386927292402e-12,
 -2.708463650138187e-13,  7.446673376307801e-15, -1.943884198191063e-16,  4.845526493929236e-18, -1.157914882524609e-19,  1.176213011384123e-03, -1.347594215326897e-04,
  9.807655164135393e-06, -5.581609379445800e-07,  2.689846544406032e-08, -1.144026076726594e-09,  4.402854889500141e-11, -1.558839227703952e-12,  5.136928014563025e-14,
 -1.589223989044148e-15,  4.646270777124265e-17, -1.289500666914353e-18,  5.480124567556824e-04, -8.783253828579851e-05,  8.530428565218686e-06, -6.269072673332937e-07,
  3.806267473122522e-08, -1.999168748384462e-09,  9.341771655127267e-11, -3.956963141158482e-12,  1.539641503384017e-13, -5.557690059779314e-15,  1.875377538435089e-16,
 -5.946298660551962e-18,  1.408004461490482e-04, -3.172230005065191e-05,  4.104564209531100e-06, -3.878585295519328e-07,  2.946983510108609e-08, -1.894863089602115e-09,
  1.063970053787101e-10, -5.328748017239292e-12,  2.416845249834323e-13, -1.004000703109168e-14,  3.853966468313881e-16, -1.375207867879565e-17,  2.426481241576024e-05,
 -7.493543365015895e-06,  1.271915350636067e-06, -1.522051996413153e-07,  1.423693812710594e-08, -1.100938527913317e-09,  7.289215390385158e-11, -4.231969983560347e-12,
  2.192101408000167e-13, -1.026411777821793e-14,  4.389130625215690e-16, -1.726142882882468e-17,  3.465382885305147e-06, -1.345456114230204e-06,  2.804530445705685e-07,
 -4.010231598008405e-08,  4.377717880456326e-09, -3.873130042151036e-10,  2.885093899837117e-11, -1.857770395048282e-12,  1.054256602673200e-13, -5.350935238293574e-15,
  2.457504105445791e-16, -1.029507201862307e-17,  2.571932992135518e-04, -1.583206833739446e-05,  6.143799617823585e-07, -1.920571323558995e-08,  5.263032023005869e-10,
 -1.317107109263823e-11,  3.075805711367347e-13, -6.793759750428492e-15,  1.435738181056861e-16, -2.910582776222947e-18,  5.702289721949270e-20, -1.087327273023607e-21,
  8.295174705573791e-04, -6.347726475685457e-05,  3.174097396026359e-06, -1.283276341188867e-07,  4.514940383350296e-09, -1.434077797638833e-10,  4.202136958295121e-12,
 -1.152089886673040e-13,  2.985212559583271e-15, -7.362100125724633e-17,  1.737725998833205e-18, -3.941104974729571e-20,  7.601077856530375e-04, -7.720155553138434e-05,
  5.089133166460703e-06, -2.654845317863846e-07,  1.182418804449430e-08, -4.676971460899665e-10,  1.682591532531517e-11, -5.593155858398369e-13,  1.737060263569402e-14,
 -5.081998942920298e-16,  1.409376826578496e-17, -3.721017410435507e-19,  2.969431815647116e-04, -4.172816075110930e-05,  3.653583513483414e-06, -2.455528955492768e-07,
  1.377243718721289e-08, -6.734242122740439e-10,  2.948042331155043e-11, -1.176098780498249e-12,  4.329898941986981e-14, -1.484904537719115e-15,  4.777745913186413e-17,
 -1.449350400329494e-18,  5.851621439928896e-05, -1.166619787485369e-05,  1.369821336730614e-06, -1.192093930924879e-07,  8.431887472815933e-09, -5.089323574345827e-10,
  2.700824868530282e-11, -1.285732600680312e-12,  5.569953149076440e-14, -2.219518325942202e-15,  8.203132198802705e-17, -2.827862927269394e-18,  6.923025662755973e-06,
 -1.961823069628797e-06,  3.101271994812256e-07, -3.496131806110312e-08,  3.107922539048270e-09, -2.300002142403463e-10,  1.465565027342985e-11, -8.227215042328515e-13,
  4.136770073878778e-14, -1.886529276747488e-15,  7.879669129382300e-17, -3.034530598130814e-18,  6.545313333421194e-07, -2.465182062864319e-07,  5.001294625810796e-08,
 -6.988523973112081e-09,  7.480420298447613e-10, -6.507200268186697e-11,  4.776566112451737e-12, -3.036466786584391e-13,  1.703746629873341e-14, -8.561010276609869e-16,
  3.896682764927779e-17, -1.619359971061965e-18,  2.024141082362892e-04, -1.171344965881935e-05,  4.268861638017848e-07, -1.254758644365839e-08,  3.236158007774302e-10,
 -7.635796542402276e-12,  1.685936720789094e-13, -3.514697944348002e-15,  7.047715085109572e-17, -1.358788899478746e-18,  2.509178113369593e-20, -4.573672827175950e-22,
  6.181264494946436e-04, -4.320328023079370e-05,  1.988111387402493e-06, -7.448407001706801e-08,  2.440909825011127e-09, -7.251380047261390e-11,  1.994284100925346e-12,
 -5.145441435665614e-14,  1.258158919180060e-15, -2.934993430090489e-17,  6.564386178226190e-19, -1.414007534978588e-20,  5.163061266822865e-04, -4.660641533100848e-05,
  2.788599078128207e-06, -1.335664352434141e-07,  5.504803651367471e-09, -2.026760571083779e-10,  6.819634575447647e-12, -2.129077909594041e-13,  6.231769062020808e-15,
 -1.723765379490677e-16,  4.533159567264645e-18, -1.137886189302026e-19,  1.740232031937227e-04, -2.135978147065168e-05,  1.684197444181981e-06, -1.034027939309515e-07,
  5.351108540739124e-09, -2.432467972946796e-10,  9.960330745661485e-12, -3.736190959976356e-13,  1.299097954991749e-14, -4.224391505839819e-16,  1.293430828916948e-17,
 -3.746044904736965e-19,  2.715506375234956e-05, -4.729735605404668e-06,  5.005449226701442e-07, -3.988922154723953e-08,  2.613291602258944e-09, -1.473770666594746e-10,
  7.359329972417509e-12, -3.316171121699508e-13,  1.366733461310599e-14, -5.204269703819159e-16,  1.845226799791431e-17, -6.124093339127794e-19,  2.232586727857678e-06,
 -5.692422521792588e-07,  8.273196834830055e-08, -8.696800286034350e-09,  7.285323995789696e-10, -5.122242759890386e-11,  3.121367109969039e-12, -1.684831543958579e-13,
  8.182913405188149e-15, -3.618579178995992e-16,  1.470482296486352e-17, -5.525840315207713e-19,  1.320367748975270e-07, -4.769434072583205e-08,  9.336045267704405e-09,
 -1.266259000239691e-09,  1.321873996520641e-10, -1.125692063180694e-11,  8.113494278956671e-13, -5.076734514035803e-14,  2.809388373650725e-15, -1.394575387016864e-16,
  6.279499410401926e-18, -2.584672136413018e-19,  1.615474546951387e-04, -8.822948404605324e-06,  3.029732309680984e-07, -8.401007708194567e-09,  2.045387049325580e-10,
 -4.554776880248924e-12,  9.558479400764590e-14, -1.881823611277221e-15,  3.565605014335977e-17, -6.646029037115341e-19,  1.149177319440490e-20, -1.968135808034333e-22,
  4.722729813521175e-04, -3.030516051655798e-05,  1.288029143739987e-06, -4.485010561123176e-08,  1.372507515856021e-09, -3.821139916213881e-11,  9.885082105539546e-13,
 -2.403821369661082e-14,  5.552811591892700e-16, -1.227581418766918e-17,  2.603462311031064e-19, -5.328904863896090e-21,  3.661168921613538e-04, -2.947043517139486e-05,
  1.604602073929506e-06, -7.070923273937817e-08,  2.701130661319195e-09, -9.269638229871921e-11,  2.919523346156630e-12, -8.566901685396415e-14,  2.364422672350452e-15,
 -6.183453820907716e-17,  1.542201950068595e-18, -3.680119413894409e-20,  1.093282091545171e-04, -1.169414499543989e-05,  8.305834739783977e-07, -4.657830385451627e-08,
  2.223258251217543e-09, -9.390457708399335e-11,  3.593248982878113e-12, -1.266040563250876e-13,  4.152554143888583e-15, -1.278515805729479e-16,  3.719550296148763e-18,
 -1.026807436189577e-19,  1.398439375366472e-05, -2.103612210907044e-06,  1.996821087283262e-07, -1.450854150348741e-08,  8.769060056788124e-10, -4.603304927290091e-11,
  2.154980951620780e-12, -9.158631987610179e-14,  3.578496892452003e-15, -1.297637514444642e-16,  4.399091309162380e-18, -1.401065999398075e-19,  8.211440494067643e-07,
 -1.843221070799244e-07,  2.431559092849851e-08, -2.359193426354961e-09,  1.846446276107527e-10, -1.224259913407124e-11,  7.087838605965097e-13, -3.657173401641220e-14,
  1.706695094728064e-15, -7.283757002077909e-17,  2.867444198384709e-18, -1.047390039324219e-19,  2.902551382785274e-08, -9.889579250921663e-09,  1.845842145015643e-09,
 -2.408311943613316e-10,  2.434747197419086e-11, -2.018344666435878e-12,  1.421840765040674e-13, -8.723627022041971e-15,  4.746042570739478e-16, -2.321154264719416e-17,
  1.031587675389331e-18, -4.197287442466388e-20,  1.305350930722420e-04, -6.752970283742913e-06,  2.191505248633884e-07, -5.748360455120934e-09,  1.326984131070793e-10,
 -2.783408417340152e-12,  5.581806302356260e-14, -1.049288685447715e-15,  1.830043218470519e-17, -3.374770402579807e-19,  5.699886599569486e-21, -8.092855928808054e-23,
  3.687119844672479e-04, -2.183112273530024e-05,  8.599960708441482e-07, -2.791211815843194e-08,  7.998765004669066e-10, -2.090253719089565e-11,  5.098211542205821e-13,
 -1.171287061512582e-14,  2.555351883734086e-16, -5.367988453974970e-18,  1.082075924837784e-19, -2.098401706252239e-21,  2.694132232535449e-04, -1.941262308703088e-05,
  9.646440523497653e-07, -3.919996113576547e-08,  1.390380306891563e-09, -4.456113258647167e-11,  1.314918394331991e-12, -3.629300351939668e-14,  9.458961959157010e-16,
 -2.338609577670289e-17,  5.531517857673422e-19, -1.256426885746216e-20,  7.299872654084158e-05, -6.797851656157096e-06,  4.355332130699857e-07, -2.232630710259620e-08,
  9.831035359977057e-10, -3.859929502418492e-11,  1.379621405794931e-12, -4.563337665453770e-14,  1.411380560806246e-15, -4.109817669535960e-17,  1.134847967176506e-18,
 -2.983290062476131e-20,  7.925347568500983e-06, -1.019304497795620e-06,  8.656109874945131e-08, -5.717691308969846e-09,  3.179017439564989e-10, -1.549300469870912e-11,
  6.779672349406648e-13, -2.709728931288713e-14,  1.000868283732669e-15, -3.446019932447127e-17,  1.113724810815269e-18, -3.394084557271385e-20,  3.458657151147131e-07,
 -6.678494239983683e-08,  7.906093076020823e-09, -7.012922545276476e-10,  5.086640309243637e-11, -3.157877980611594e-12,  1.725781394686939e-13, -8.462365253074258e-15,
  3.774302196967486e-16, -1.546945250735260e-17,  5.873288582332203e-19, -2.076746332935861e-20,  7.133934253643995e-09, -2.237846874346689e-09,  3.920732473337744e-10,
 -4.863937688397479e-11,  4.719399471816858e-12, -3.781102336762560e-13,  2.588237796695524e-14, -1.549633102284698e-15,  8.255203574092544e-17, -3.964388784135400e-18,
  1.734021656037779e-19, -6.957288829165729e-21,  1.066386636230624e-04, -5.243396522314472e-06,  1.612832600070657e-07, -4.006672646774829e-09,  8.834639531952599e-11,
 -1.739963913851798e-12,  3.308950352430728e-14, -6.198278693624717e-16,  9.574460700010634e-18, -1.619612688749395e-19,  3.444163576695533e-21, -3.043115013599241e-23,
  2.932962113814928e-04, -1.610131529905133e-05,  5.899274914096657e-07, -1.789060101498801e-08,  4.817317417751231e-10, -1.183095506393649e-11,  2.723432642266478e-13,
 -5.944064032846383e-15,  1.222234902875984e-16, -2.435193656201221e-18,  4.734598901211654e-20, -8.573669757957718e-22,  2.046746471750965e-04, -1.325697426547943e-05,
  6.030499038818870e-07, -2.266162764596315e-08,  7.472820546629614e-10, -2.242548279850462e-11,  6.210664540204625e-13, -1.611166154166170e-14,  3.976802006569239e-16,
 -9.312262561571865e-18,  2.080400912956153e-19, -4.518998132643382e-21,  5.139168643751106e-05, -4.166663837740672e-06,  2.413486368067212e-07, -1.133099130365244e-08,
  4.602701898749296e-10, -1.682512135007764e-11,  5.619604979548326e-13, -1.742998771438614e-14,  5.088057774946166e-16, -1.400949984073293e-17,  3.663954235602497e-19,
 -9.179749654962314e-21,  4.895526787744263e-06, -5.336606438688708e-07,  4.053073478971397e-08, -2.431077148589318e-09,  1.240612574038774e-10, -5.605797544914244e-12,
  2.288476611537706e-13, -8.581035207544549e-15,  2.990325774891770e-16, -9.752390089431015e-18,  2.996981601619947e-19, -8.719889015702779e-21,  1.665802196489733e-07,
 -2.701953446017192e-08,  2.845790748210102e-09, -2.289455111058042e-10,  1.527845271380464e-11, -8.825392520287716e-13,  4.525671455722237e-14, -2.097218841023907e-15,
  8.893792634988561e-17, -3.483814907741335e-18,  1.269879111554026e-19, -4.328443481893128e-21,  2.021008870270334e-09, -5.638526992533781e-10,  9.093667281749199e-11,
 -1.057245836478089e-11,  9.736014586458348e-13, -7.472038013955799e-14,  4.934090707634919e-15, -2.865590427035461e-16,  1.487348623508331e-17, -6.984197193471672e-19,
  2.995911129519548e-20, -1.181748862573182e-21,  8.797186087401730e-05, -4.123811898890498e-06,  1.206610798980885e-07, -2.833713864076432e-09,  6.024216106666656e-11,
 -1.123953908636536e-12,  1.932266802601320e-14, -3.825615789759195e-16,  5.926257954484968e-18, -4.915528247789675e-20,  2.119265586004813e-21, -4.083155049217571e-23,
  2.371339786540524e-04, -1.212554083641255e-05,  4.146909683507209e-07, -1.177026858562045e-08,  2.989765929158101e-10, -6.919511393081572e-12,  1.497211218453143e-13,
 -3.132632652355400e-15,  6.121534880558923e-17, -1.121087726909407e-18,  2.175180137413093e-20, -3.854373401969103e-22,  1.598210907513632e-04, -9.346566173347354e-06,
  3.903075500700899e-07, -1.361430381801246e-08,  4.175863383696011e-10, -1.175608335367619e-11,  3.072375980296272e-13, -7.465371352908001e-15,  1.742517770584476e-16,
 -3.921585870009942e-18,  8.186333733003877e-20, -1.674355720507823e-21,  3.787361174539200e-05, -2.676089535694634e-06,  1.404468362350348e-07, -6.063834092818114e-09,
  2.269520540696523e-10, -7.736207232471570e-12,  2.424078483382502e-13, -7.025760567511625e-15,  1.935166151721984e-16, -5.070914592034215e-18,  1.247687333539717e-19,
 -2.969596898109410e-21,  3.263046979548143e-06, -2.992826841877830e-07,  2.035046900726587e-08, -1.110313080566941e-09,  5.186938333181242e-11, -2.172486667070030e-12,
  8.274013783953818e-14, -2.902291093852660e-15,  9.529602591493252e-17, -2.942501995249705e-18,  8.568307766871744e-20, -2.375895715548480e-21,  9.111827040679898e-08,
 -1.212479568667724e-08,  1.130579090904799e-09, -8.206237368355661e-11,  5.006275424904201e-12, -2.677289085019862e-13,  1.281916635786393e-14, -5.585063435694267e-16,
  2.241667943090629e-17, -8.354757436877407e-19,  2.910621058519047e-20, -9.525295060276999e-22,  6.810470846588777e-10, -1.612358357491641e-10,  2.341780001002163e-11,
 -2.509087427180820e-12,  2.164296781882210e-13, -1.574507745155546e-14,  9.943337155849767e-16, -5.561458703151988e-17,  2.795539902014988e-18, -1.277042782479035e-19,
  5.348918768778338e-21, -2.066657229467473e-22,  7.321289485050956e-05, -3.279716938514241e-06,  9.177051167935226e-08, -2.027747585171224e-09,  4.163849206547162e-11,
 -7.684731198019419e-13,  1.109224392193332e-14, -2.091871533390557e-16,  5.128520860225445e-18, -1.339055510509466e-20, -6.013308673334751e-22, -7.428154096540109e-23,
  1.944747054922798e-04, -9.301046950378562e-06,  2.981422087629017e-07, -7.924793472405013e-09,  1.904198008556384e-10, -4.189451074493831e-12,  8.438873065919100e-14,
 -1.680936697152027e-15,  3.299064294137098e-17, -5.314496412618936e-19,  8.869281356713636e-21, -2.234629348554099e-22,  1.277847510615973e-04, -6.779587199168304e-06,
  2.603928034521176e-07, -8.474465907869121e-09,  2.420453062943044e-10, -6.371589795346088e-12,  1.588462340149430e-13, -3.634950461573439e-15,  7.801016761058310e-17,
 -1.725546646551634e-18,  3.567707978462591e-20, -5.997159403968054e-22,  2.902943304135058e-05, -1.791840806388308e-06,  8.522969476359021e-08, -3.410456346378318e-09,
  1.174797834790712e-10, -3.718958719962522e-12,  1.105689689608766e-13, -2.997877070683608e-15,  7.647117698265048e-17, -1.942889349653375e-18,  4.589190047323608e-20,
 -9.746775115949760e-22,  2.323445463890705e-06, -1.783824282900326e-07,  1.085892285249020e-08, -5.425937202178039e-10,  2.313269270198015e-11, -8.957657218229395e-13,
  3.199267758588408e-14, -1.047568603639739e-15,  3.219895626980813e-17, -9.466881640793124e-19,  2.613192593785963e-20, -6.808126929390542e-22,  5.596795251939211e-08,
 -5.977301081498140e-09,  4.922195279184385e-10, -3.223158964785636e-11,  1.786432325725005e-12, -8.807712926979128e-14,  3.928116837702940e-15, -1.601209454537525e-16,
  6.054582031183721e-18, -2.141162055242024e-19,  7.098194799378966e-21, -2.219369723031810e-22,  2.797604421865214e-10, -5.301183684415619e-11,  6.790538322791827e-12,
 -6.591605794379938e-13,  5.248443916157845e-14, -3.577866529859489e-15,  2.140019241234747e-16, -1.143071534251171e-17,  5.525473409727411e-19, -2.440873929611873e-20,
  9.930736832569331e-22, -3.741622521970405e-23,  6.142280352866614e-05, -2.632641725043974e-06,  7.096984108311321e-08, -1.471689459766954e-09,  2.854960295488075e-11,
 -5.547587564544927e-13,  7.393528442228136e-15, -6.302880013674445e-17,  3.562781592490057e-18, -8.505978485611096e-20, -2.209945750848753e-21,  2.926067959726751e-23,
  1.615040475245609e-04, -7.250229659168477e-06,  2.188773981039629e-07, -5.452408064961968e-09,  1.236207251088628e-10, -2.625286350864653e-12,  4.961420441269614e-14,
 -8.797733988249613e-16,  1.823859220622469e-17, -3.319479818922150e-19,  2.315092377845176e-21, -5.756162915742154e-23,  1.042703120289658e-04, -5.045875356541000e-06,
  1.783175175686242e-07, -5.444237011341784e-09,  1.457390469265169e-10, -3.547205789909130e-12,  8.438458973895277e-14, -1.900360422941673e-15,  3.643690108317935e-17,
 -7.013512425714537e-19,  1.754412312598436e-20, -3.149688017456299e-22,  2.300523799863422e-05, -1.246590750330675e-06,  5.352722077029511e-08, -2.005913900792354e-09,
  6.403313798719037e-11, -1.849810818591049e-12,  5.249068468484431e-14, -1.384001606535133e-15,  3.150912550419527e-17, -7.285749947968185e-19,  1.904792046704948e-20,
 -3.818300829646536e-22,  1.749798994024772e-06, -1.123961903113793e-07,  6.089505493881327e-09, -2.822952286684154e-10,  1.101011252092206e-11, -3.889912534414641e-13,
  1.312171012944666e-14, -4.073583833353874e-16,  1.147545817655072e-17, -3.171451893542772e-19,  8.689589616348424e-21, -2.102016265947443e-22,  3.802842774199055e-08,
 -3.207584877531884e-09,  2.320162538221195e-10, -1.382435930433604e-11,  6.932713812148154e-13, -3.126032402613018e-14,  1.300749414308146e-15, -4.958917553364578e-17,
  1.750250442048800e-18, -5.858309180153130e-20,  1.855762456893062e-21, -5.490388253407277e-23,  1.410139335627058e-10, -2.010041046713257e-11,  2.232613272270110e-12,
 -1.939096698096443e-13,  1.403358767911211e-14, -8.855544603736716e-16,  4.969968517626899e-17, -2.512084292367381e-18,  1.158044887136218e-19, -4.915212469346934e-21,
  1.931398900462606e-22, -7.055516358929500e-24,  5.192583322382967e-05, -2.128541373452935e-06,  5.571424779063081e-08, -1.094425685501198e-09,  1.913863234061749e-11,
 -3.889336638095465e-13,  6.671156365692872e-15, -9.822428877694117e-18, -3.776091681994768e-19, -1.060655049728654e-19,  1.807934447105400e-21,  1.115189453874686e-22,
  1.356334774926836e-04, -5.730908564273812e-06,  1.637726469889809e-07, -3.837149936814493e-09,  8.132319230333914e-11, -1.674658277861182e-12,  3.147105905656219e-14,
 -4.709287885900121e-16,  7.864789681454606e-18, -2.351811330315021e-19,  3.535519419794818e-21,  7.432356837491649e-23,  8.657578549674113e-05, -3.845775516485197e-06,
  1.249486147593483e-07, -3.585905132233053e-09,  9.133466251351820e-11, -2.047885439270500e-12,  4.451485719358271e-14, -1.029272419393170e-15,  2.059559105027652e-17,
 -2.634672430029856e-19,  4.829675970486506e-21, -2.399868898736866e-22,  1.874423200997650e-05, -8.996648742912551e-07,  3.457263005184074e-08, -1.220296173390001e-09,
  3.699848687748606e-11, -9.608487891848819e-13,  2.478666684773442e-14, -6.778225275749115e-16,  1.543987067946451e-17, -2.508721451943252e-19,  5.885511856084386e-21,
 -2.279381159562896e-22,  1.379759920192354e-06, -7.473229366778593e-08,  3.548573079445461e-09, -1.545075102250766e-10,  5.632769532746949e-12, -1.779845994595405e-13,
  5.529958728306607e-15, -1.706156948909237e-16,  4.557245729392579e-18, -1.054488932490511e-19,  2.800451204905694e-21, -8.169173906633574e-23,  2.807475557359776e-08,
 -1.864904869288441e-09,  1.164789123956376e-10, -6.416434215173774e-12,  2.937638685590832e-13, -1.190872394596657e-14,  4.593566849118576e-16, -1.667922876369651e-17,
  5.481678293607603e-19, -1.681958664346265e-20,  5.136949088477429e-22, -1.502296063244323e-23,  8.562628638413156e-11, -8.749100466491516e-12,  8.274773707302780e-13,
 -6.430270670421768e-14,  4.178091621646729e-15, -2.402479657008953e-16,  1.254925211913291e-17, -5.966882433462470e-19,  2.596653262267156e-20, -1.048868216219000e-21,
  3.965977685280874e-23, -1.399356374904281e-24,  4.422655950338089e-05, -1.730689478571337e-06,  4.418953079741427e-08, -8.418944824942100e-10,  1.291920677523434e-11,
 -2.363208662493301e-13,  5.797659397354761e-15, -6.164893982450446e-17, -2.066356180472789e-18,  2.254444937601115e-20,  3.292376119152329e-21, -6.057198562752808e-23,
  1.150667651067090e-04, -4.585090030342931e-06,  1.245503182300429e-07, -2.766946991788756e-09,  5.443280079693906e-11, -1.055855612584588e-12,  2.076136265722114e-14,
 -3.223507350521535e-16,  2.508024228330683e-18, -5.649169454234547e-20,  4.319456135702752e-21, -6.400206112091286e-23,  7.295072282650598e-05, -2.996246238226656e-06,
  8.949853376141284e-08, -2.402726374791365e-09,  5.907724172127201e-11, -1.258762140115600e-12,  2.366152482784480e-14, -5.013695089448220e-16,  1.266178721034407e-17,
 -2.114689982839443e-19, -3.072269168541565e-22,  1.336905750854604e-23,  1.561850388969390e-05, -6.728732484787278e-07,  2.293604824594442e-08, -7.552771690691485e-10,
  2.245066258451395e-11, -5.450328489548840e-13,  1.159344228410454e-14, -2.990990909181422e-16,  8.745040375727292e-18, -1.579876670610265e-19,  3.277303217152231e-22,
 -1.895993647867341e-23,  1.127722103133096e-06, -5.245863910984058e-08,  2.137308130514789e-09, -8.701601162678824e-11,  3.085913459311343e-12, -8.899934553842700e-14,
  2.343156633618342e-15, -6.970879631224141e-17,  2.095475591574006e-18, -4.540806300949497e-20,  6.523800468603151e-22, -1.995797639242013e-23,  2.208417847164234e-08,
 -1.176032963669988e-09,  6.140234014821813e-11, -3.151723646232305e-12,  1.363048741803358e-13, -4.950778307271544e-15,  1.690236387666380e-16, -5.884852805562998e-18,
  1.927350759267370e-19, -5.360233870401550e-21,  1.371536355179593e-22, -4.075194400585833e-24,  6.021165333682989e-11, -4.360849384783712e-12,  3.391358348897089e-13,
 -2.387886127792883e-14,  1.400867980995871e-15, -7.199595382023605e-17,  3.436983170171712e-18, -1.539069829791954e-19,  6.336453851090705e-21, -2.395446018704441e-22,
  8.547843145792740e-24, -2.931168956491646e-25,  3.795139522626916e-05, -1.414383635634137e-06,  3.519366768473277e-08, -6.661424769987968e-10,  9.411743525482974e-12,
 -1.238750738916719e-13,  3.408109872630320e-15, -9.664120002633858e-17,  1.859440497564405e-19,  7.372151191957960e-20, -8.578749748338398e-22, -7.952762673249391e-23,
  9.852791208320010e-05, -3.708138852922477e-06,  9.595531082123318e-08, -2.040805605606357e-09,  3.760999841426125e-11, -6.576887112149366e-13,  1.274851088719610e-14,
 -2.488752723738620e-16,  2.612659379649077e-18,  3.182284721525561e-20, -8.296933272119199e-23, -8.927745497826567e-23,  6.223549754753501e-05, -2.381253347608671e-06,
  6.559513989328181e-08, -1.632077441485088e-09,  3.865038144680151e-11, -8.205954354313676e-13,  1.415534716094841e-14, -2.164234055141353e-16,  5.364897742682407e-18,
 -1.736303527939811e-19,  2.514519650848602e-21,  5.924466223616918e-23,  1.324422437945176e-05, -5.202738738406209e-07,  1.571067915944213e-08, -4.704988665562292e-10,
  1.379555198938724e-11, -3.408196685588403e-13,  6.303252179028454e-15, -1.067636020459597e-16,  3.465234677138835e-18, -1.244132436242544e-19,  1.787680278201504e-21,
  4.196163628321510e-23,  9.464994706764402e-07, -3.881580549521749e-08,  1.338997388422690e-09, -4.937094260854516e-11,  1.743493188228963e-12, -4.996813833677371e-14,
  1.113763186156866e-15, -2.480336938830045e-17,  8.189474963143612e-19, -2.662780516791392e-20,  4.457583828983572e-22,  2.043600867013017e-24,  1.816688991538548e-08,
 -8.053494402404297e-10,  3.398613048184357e-11, -1.588017813553542e-12,  6.746818422489140e-14, -2.322041838081945e-15,  6.754106119001449e-17, -2.009335091343220e-18,
  6.813159182091197e-20, -2.128536832719929e-21,  4.797875297346999e-23, -7.868491741366017e-25,  4.680274575540261e-11, -2.499122879424352e-12,  1.508783895830389e-13,
 -9.638476015329213e-15,  5.283054170403632e-16, -2.442051226722772e-17,  1.025976886401469e-18, -4.208318082457466e-20,  1.674979245633317e-21, -6.110344408338712e-23,
  1.999036695985717e-24, -6.187257969697342e-26,  3.280972937859510e-05, -1.162412974979533e-06,  2.803370070821975e-08, -5.318103459572775e-10,  7.545593756464156e-12,
 -7.179396317618268e-14,  1.108140609954800e-15, -5.953822909905686e-17,  1.707636631505913e-18,  5.397592998056942e-21, -1.723686612614248e-21,  3.015913160368600e-23,
  8.508878723127983e-05, -3.029127826934087e-06,  7.468994071261081e-08, -1.529839012963209e-09,  2.700415011431914e-11, -4.250153249983599e-13,  7.083924884496552e-15,
 -1.531553859137088e-16,  3.074766573877776e-18, -1.448377332884776e-20, -1.379809739806510e-21,  2.253358729836488e-23,  5.364930578983846e-05, -1.925455468376481e-06,
  4.923391077691837e-08, -1.128285764227413e-09,  2.522348465526240e-11, -5.391783966769459e-13,  9.717272497247726e-15, -1.222796760517863e-16,  1.242350199300521e-18,
 -5.498623732160659e-20,  2.621566493857937e-21, -4.479558212383126e-23,  1.138341833508421e-05, -4.138889390048253e-07,  1.118841043205746e-08, -2.969202973619957e-10,
  8.299012882595606e-12, -2.164631471977900e-13,  4.305924985323050e-15, -5.143797800151555e-17,  5.156419258075547e-19, -3.858913958461705e-20,  1.936804520251735e-21,
 -3.140294523583001e-23,  8.094880529894467e-07, -3.006690882489038e-08,  8.851077840765972e-10, -2.821056910503937e-11,  9.671825391350977e-13, -2.937055568192230e-14,
  6.671106619500290e-16, -1.042325249787532e-17,  1.857155878377615e-19, -9.053361155893614e-21,  3.682892840831278e-22, -6.007133453719356e-24,  1.539045846525179e-08,
 -5.943709529298133e-10,  2.011627297682575e-11, -8.074647412419549e-13,  3.369642196607895e-14, -1.188806925983606e-15,  3.259820921732628e-17, -7.396147637676761e-19,
  1.951771285216913e-20, -7.250786582671317e-22,  2.413915206692736e-23, -4.670657379504129e-25,  3.865067619214190e-11, -1.641093396111569e-12,  7.327028582705912e-14,
 -4.068150373357541e-15,  2.150200310184335e-16, -9.468082573443400e-18,  3.530073569993632e-19, -1.229338391944209e-20,  4.446623250175926e-22, -1.645673959309610e-23,
  5.550322853932213e-25, -1.573057629420234e-26,  2.857096166316584e-05, -9.617199705885230e-07,  2.233236576764661e-08, -4.215803493694690e-10,  6.271822371354352e-12,
 -5.924790837267767e-14,  1.586581809428318e-16, -1.189537483725433e-17,  1.061545160860509e-18, -2.983436709272044e-20, -6.034304447728073e-23,  2.946861056422805e-23,
  7.406063277638826e-05, -2.498287911209440e-06,  5.867016090582505e-08, -1.157805056867585e-09,  1.991085830355439e-11, -2.961427410470480e-13,  4.033746527584147e-15,
 -7.110017217335991e-17,  1.897275477751336e-18, -4.078824625836759e-20,  8.160436329097624e-23,  2.717949553370504e-23,  4.665817904926110e-05, -1.579623850524128e-06,
  3.779809961825358e-08, -7.994076626874471e-10,  1.651248255866190e-11, -3.437690514177428e-13,  6.671742465759796e-15, -9.830214327501044e-17,  6.117448298200409e-19,
  5.202705001993688e-21,  4.608816263983625e-22, -3.727682265769818e-23,  9.887107332808476e-06, -3.366713800903556e-07,  8.296110994389807e-09, -1.936231973546504e-10,
  4.892403840469245e-12, -1.293645226840500e-13,  2.976510373847883e-15, -4.533794850686566e-17,  1.317827242076863e-19,  6.401994512840934e-21,  3.487166278652845e-22,
 -2.823791180445310e-23,  7.015572431315271e-07, -2.411652592063927e-08,  6.226151320679174e-10, -1.665514103985759e-11,  5.187561854347175e-13, -1.640403011494646e-14,
  4.264492236541369e-16, -7.422486502811959e-18,  5.430209106967724e-20, -1.781218008576097e-22,  8.449941675119316e-23, -5.012174560569633e-24,  1.328433511235911e-08,
 -4.645951587865112e-10,  1.299789589401363e-11, -4.220456127347641e-13,  1.634993885788567e-14, -6.028090939086794e-16,  1.781222082651319e-17, -3.848669646276415e-19,
  6.122790586384599e-21, -1.352990120056308e-22,  6.761235112353414e-24, -2.781175118217519e-25,  3.301621617458754e-11, -1.203601627427655e-12,  4.007373047720028e-14,
 -1.776243964530326e-15,  8.895068015405548e-17, -3.941199015697640e-18,  1.429881546689680e-19, -4.345310883177892e-21,  1.243084556675451e-22, -3.997229962797666e-24,
  1.449286168537999e-25, -4.866660184099955e-27,  2.505165046413102e-05, -8.016800034372975e-07,  1.783689263084067e-08, -3.305606059577112e-10,  5.113696881674136e-12,
 -5.655670948459021e-14,  1.478694015046665e-16,  6.312603288870945e-18,  1.589236265980827e-19, -1.685397509082235e-20,  4.785752565311540e-22, -1.449737326847800e-24,
  6.492530229999864e-05, -2.079504394103574e-06,  4.650793788768005e-08, -8.819243721284428e-10,  1.482478202863443e-11, -2.176495409812216e-13,  2.687218088265676e-15,
 -3.152036778781630e-17,  6.839198033812135e-19, -2.356310745678157e-20,  5.583921474122137e-22, -2.364237622135778e-24,  4.088941587869401e-05, -1.311589706571937e-06,
  2.958924496076519e-08, -5.824041469991581e-10,  1.102778558576722e-11, -2.142297719188241e-13,  4.232022118605247e-15, -7.462383842149665e-17,  8.494552367771840e-19,
  3.105000961438043e-21, -2.987513607913481e-22, -1.396351969097862e-24,  8.660092869037169e-06, -2.784391856414450e-07,  6.368343977753761e-09, -1.325814694128038e-10,
  2.920202871044558e-12, -7.242585772140895e-14,  1.808616728137497e-15, -3.661124184817696e-17,  3.984458292398527e-19,  4.636495915459435e-21, -2.356694137086278e-22,
 -1.240974773624567e-24,  6.139576602027072e-07, -1.981560743400147e-08,  4.633442826234199e-10, -1.049064640489593e-11,  2.772344813688663e-13, -8.458382145677891e-15,
  2.445999375260042e-16, -5.472311381103428e-18,  6.978790282481265e-20,  3.267219537407184e-22, -2.531571505643686e-23, -4.567790692817510e-25,  1.160708534755005e-08,
 -3.772050904734077e-10,  9.171178612084610e-12, -2.369779160841925e-13,  7.796292583579874e-15, -2.856259866977218e-16,  9.304642275416399e-18, -2.336784954920837e-19,
  3.911601857500507e-21, -3.004000565080743e-23,  2.124349594769048e-25, -4.668796300026978e-26,  2.873556259891346e-11, -9.490335777079992e-13,  2.520423845641805e-14,
 -8.318291278913759e-16,  3.646497502251096e-17, -1.621584731508145e-18,  6.138873572943544e-20, -1.877870224650885e-21,  4.673688377275807e-23, -1.057305276728201e-24,
  2.922673100336743e-26, -1.089277265851305e-27,  2.210705041346718e-05, -6.735452401427009e-07,  1.432455337173999e-08, -2.575332100924151e-10,  4.033417445332257e-12,
 -5.074811219662582e-14,  3.291038263412208e-16,  5.041966295440278e-18, -1.496714745064405e-19, -2.051708821255596e-21,  2.266215062774786e-22, -6.659848046743134e-24,
  5.728966906506703e-05, -1.746050320843246e-06,  3.721499482769314e-08, -6.763118282181928e-10,  1.105522296328176e-11, -1.619130065381799e-13,  2.011995059594771e-15,
 -1.931009502264646e-17,  1.827587143289529e-19, -6.246156419390372e-21,  2.752124708101702e-22, -7.200327778913803e-24,  3.607606874310752e-05, -1.100124664259285e-06,
  2.353374021414082e-08, -4.353724157673863e-10,  7.605647054697369e-12, -1.346401716419184e-13,  2.524120335480724e-15, -4.781665346443994e-17,  7.689253571590709e-19,
 -6.327657641773461e-21, -1.256010008066884e-22,  5.549935827279947e-24,  7.639146977681820e-06, -2.331584340697935e-07,  5.016657451569508e-09, -9.540919907745574e-11,
  1.830586575637281e-12, -3.978910049756068e-14,  9.745479709794682e-16, -2.291338449388171e-17,  4.116205044171496e-19, -2.978553935471605e-21, -1.079392529006976e-22,
  4.201490117083287e-24,  5.414032745685189e-07, -1.654802085115772e-08,  3.593904368785067e-10, -7.136766136541672e-12,  1.556834330973070e-13, -4.170718968321054e-15,
  1.229690591234303e-16, -3.250059287808032e-18,  6.359714593686776e-20, -5.740100080824770e-22, -1.274138180728688e-23,  5.570723834186923e-25,  1.022950191444929e-08,
 -3.134553878387640e-10,  6.921183694773404e-12, -1.477870485325301e-13,  3.855763715245947e-15, -1.276902305865017e-16,  4.349262856918927e-18, -1.263438596224837e-19,
  2.754939609483380e-21, -3.554108140290474e-23, -8.184228121696253e-26,  1.154459838139946e-26,  2.529079000380383e-11, -7.794314894923299e-13,  1.786960715598788e-14,
 -4.430151099302699e-16,  1.525515274575550e-17, -6.391323685100631e-19,  2.522329230913264e-20, -8.330847065035856e-22,  2.200322329835732e-23, -4.526169389315201e-25,
  7.559467601847640e-27, -1.562151926219575e-28,  1.962394066994968e-05, -5.702874693603655e-07,  1.158936615006016e-08, -2.006511799574621e-10,  3.105974012222148e-12,
 -4.171547373961676e-14,  4.015862296946954e-16,  3.114649888484860e-19, -1.209449698334575e-19,  2.288518349685006e-21,  2.143302959344485e-23, -2.556551519013417e-24,
  5.085344914008404e-05, -1.478016243137124e-06,  3.006171218588588e-08, -5.228846714630355e-10,  8.258810841224952e-12, -1.195983790698722e-13,  1.531276629591991e-15,
 -1.548549697887137e-17,  9.044788794767753e-20, -3.619395272755279e-22,  5.168715643907436e-23, -2.870989076196422e-24,  3.202169678716423e-05, -9.308692182238880e-07,
  1.896008292330719e-08, -3.323411769926341e-10,  5.423570000832329e-12, -8.758150122710820e-14,  1.491086629944370e-15, -2.740099393573289e-17,  5.011492558837597e-19,
 -7.432983225410811e-21,  4.242427768161548e-23,  1.892181186865617e-24,  6.780161072740485e-06, -1.971600988669572e-07,  4.024804265373048e-09, -7.140811122480310e-11,
  1.223918838541959e-12, -2.273102673394723e-14,  4.972263912322733e-16, -1.196795229619193e-17,  2.650478374215250e-19, -4.311191970734940e-21,  2.050120422865383e-23,
  1.478781356570661e-24,  4.804716121836844e-07, -1.397855167377792e-08,  2.863864324622421e-10, -5.179867930481941e-12,  9.550876233255779e-14, -2.103017667019243e-15,
  5.690668809826624e-17, -1.600707388774574e-18,  3.890759825321466e-20, -6.829086193696108e-22,  4.477854437768445e-24,  1.920289614712112e-25,  9.076452147427990e-09,
 -2.642934674316818e-10,  5.449100031620020e-12, -1.018925629008804e-13,  2.105698461950382e-15, -5.697804884890349e-17,  1.854647933220962e-18, -5.832762999338611e-20,
  1.531801271815662e-21, -2.978423672012875e-23,  3.059311127576499e-25,  3.758450114742076e-27,  2.243011314363652e-11, -6.543819198569447e-13,  1.368402847639752e-14,
 -2.749766561014417e-16,  6.990712086864791e-18, -2.473545937706113e-19,  9.662080359873060e-21, -3.410534148264377e-22,  1.002780713233522e-23, -2.344618581903959e-25,
  4.078589372389773e-27, -4.622489834778320e-29,  1.751408452714545e-05, -4.864189909176080e-07,  9.453880920645298e-09, -1.571103089466898e-10,  2.366821673970775e-12,
 -3.233239775123426e-14,  3.687033741440318e-16, -2.237459894960017e-18, -4.169317068805437e-20,  1.795028068074733e-21, -2.877827928915869e-23, -1.627664167850478e-25,
  4.538557951324808e-05, -1.260544138120698e-06,  2.450708637581125e-08, -4.080242465621090e-10,  6.200903358426952e-12, -8.772655243164510e-14,  1.137959719439434e-15,
 -1.258746323767955e-17,  9.311223825242323e-20,  1.185453307091174e-22, -9.482761302315446e-24, -3.592643506494032e-25,  2.857824492813927e-05, -7.937873849352955e-07,
  1.544050517757254e-08, -2.578640013249547e-10,  3.976024216283629e-12, -5.942252978357706e-14,  9.111565112625202e-16, -1.520878157830938e-17,  2.762548425737088e-19,
 -4.902259702164782e-21,  6.832423920797096e-23, -2.882453191751386e-25,  6.050919653764117e-06, -1.680871885953290e-07,  3.272227286018129e-09, -5.491244402877450e-11,
  8.658624956762599e-13, -1.399577538499494e-14,  2.591974236579496e-16, -5.724279839359602e-18,  1.343484177708195e-19, -2.813382978957440e-21,  4.254829316940746e-23,
 -1.567025206661583e-25,  4.287789055271351e-07, -1.191289630706207e-08,  2.322130907195485e-10, -3.926988074267443e-12,  6.411181888142969e-14, -1.155584573289842e-15,
  2.613527076061377e-17, -7.036117087414271e-19,  1.874242876302874e-20, -4.230089002037423e-22,  6.855071839176342e-24, -3.746483877660122e-26,  8.099431312261686e-09,
 -2.250920477641773e-10,  4.397461588808265e-12, -7.536685718296675e-14,  1.303712183335109e-15, -2.742699269616573e-17,  7.644242293711265e-19, -2.394338500790168e-20,
  6.956340973093162e-22, -1.675794513577202e-23,  2.988284768634286e-25, -2.654007009973647e-27,  2.001290667212596e-11, -5.565150049618718e-13,  1.092547741637132e-14,
 -1.927866826790222e-16,  3.747110165120183e-18, -1.005654553495112e-19,  3.538757917106355e-21, -1.274718501319691e-22,  4.067834873295570e-24, -1.084034084870235e-25,
  2.299204315839154e-27, -3.513977290468015e-29,  1.570857813570276e-05, -4.177315988276707e-07,  7.775926894233321e-09, -1.239568835905195e-10,  1.803033039095371e-12,
 -2.433434304042911e-14,  2.955041993075431e-16, -2.758435213833834e-18,  2.712317695315170e-21,  7.264623861975590e-22, -2.132678833398758e-23,  3.168373629586769e-25,
  4.070672329120706e-05, -1.082510239046399e-06,  2.015267656467851e-08, -3.214758959013389e-10,  4.692680065098516e-12, -6.430732406286341e-14,  8.272510135275812e-16,
 -9.626901771134321e-18,  8.917862824935291e-20, -3.290576742050507e-22, -9.085157776871633e-24,  1.878891623436292e-25,  2.563196244410467e-05, -6.816425924614378e-07,
  1.269210879854289e-08, -2.026957958651312e-10,  2.976294310477241e-12, -4.181105489282338e-14,  5.860958052144372e-16, -8.701920131323515e-18,  1.441627958969306e-19,
 -2.596272816661535e-21,  4.487243129732807e-23, -6.005535222669214e-25,  5.427060107920739e-06, -1.443289695563137e-07,  2.688128145280775e-09, -4.300681680375972e-11,
  6.373264289051142e-13, -9.294949250687444e-15,  1.460960444949296e-16, -2.739886087652561e-18,  6.072101018491687e-20, -1.380355391651675e-21,  2.748431111342302e-23,
 -3.966808676844294e-25,  3.845668253955944e-07, -1.022781253945991e-08,  1.905759535933100e-10, -3.057653610389347e-12,  4.597391162541713e-14, -7.092616138633492e-16,
  1.289390534227343e-17, -2.990036402329503e-19,  7.883330557507011e-21, -1.983644845110325e-22,  4.199319823967596e-24, -6.452178915657345e-26,  7.264147257818851e-09,
 -1.932115376286924e-10,  3.602814874574412e-12, -5.808803521865252e-14,  8.952457170956598e-16, -1.509149196413811e-17,  3.299564863824619e-19, -9.281302337824513e-21,
  2.760654195217121e-22, -7.441395257641602e-24,  1.666246135326495e-25, -2.793749046401125e-27,  1.794827139150324e-11, -4.774737045342891e-13,  8.917566289692116e-15,
 -1.452982618081900e-16,  2.358797195636349e-18, -4.679839586146449e-20,  1.315449220767022e-21, -4.477807913237220e-23,  1.484642521459880e-24, -4.329638587017647e-26,
  1.061585920569448e-27, -2.086340552523224e-29,  1.415329244278928e-05, -3.610183025343744e-07,  6.446652247420655e-09, -9.864233922809533e-11,  1.381145007681848e-12,
 -1.814032191674414e-14,  2.223965806822203e-16, -2.391146805463182e-18,  1.675914724503438e-20,  1.365484856156581e-22, -8.946355839738868e-24,  2.178026931193896e-25,
  3.667637441026869e-05, -9.355344312130144e-07,  1.670627777617603e-08, -2.556894594333319e-10,  3.584852325554431e-12, -4.737851182509945e-14,  5.954647620025502e-16,
 -7.016355143879339e-18,  7.281005050226191e-20, -5.280109377827297e-22, -1.304907687769376e-24,  1.349317303536753e-25,  2.309412583678231e-05, -5.890845323164087e-07,
  1.052015791014956e-08, -1.610750446037929e-10,  2.263369015226042e-12, -3.022251383082777e-14,  3.951603485888097e-16, -5.286498080140672e-18,  7.710219799665779e-20,
 -1.275952556431685e-21,  2.277342926352406e-23, -3.843866754068481e-25,  4.889713286401506e-06, -1.247279246963960e-07,  2.227649218180216e-09, -3.412893005888409e-11,
  4.812413448925868e-13, -6.528819536451160e-15,  9.043626516436547e-17, -1.411860316551141e-18,  2.692814090174469e-20, -5.931497610452281e-22,  1.300284079140597e-23,
 -2.475390226842101e-25,  3.464887639877044e-07, -8.838448531363551e-09,  1.578772504495541e-10, -2.421147054883903e-12,  3.432819799718004e-14, -4.773368484317607e-16,
  7.180844489708741e-18, -1.337365762352462e-19,  3.142923927020506e-21, -8.018469979514304e-23,  1.907132831188023e-24, -3.820610298140739e-26,  6.544848047436110e-09,
 -1.669542566484948e-10,  2.982931109514377e-12, -4.582164052819482e-14,  6.558136316530424e-16, -9.499893353188575e-18,  1.613705570098477e-19, -3.665502940207299e-21,
  1.019008614456528e-22, -2.860243024580322e-24,  7.193512580792975e-26, -1.513351428686708e-27,  1.617083881926357e-11, -4.125276673139462e-13,  7.374133872915750e-15,
 -1.136754973594784e-16,  1.659550495919855e-18, -2.609188248698477e-20,  5.416476243514592e-22, -1.557533405364698e-23,  5.040858948902308e-25, -1.542538134265412e-26,
  4.151042546240088e-28, -9.475336417672398e-30,  1.280536509835598e-05, -3.138300429911813e-07,  5.384441398635821e-09, -7.917810161710746e-11,  1.066615461065404e-12,
 -1.354313869343838e-14,  1.632951425146064e-16, -1.829068364032194e-18,  1.715967034655477e-20, -7.106013176808122e-23, -2.363828768407967e-24,  9.100307433633580e-26,
  3.318339234010586e-05, -8.132495069541323e-07,  1.395322391064388e-08, -2.051981834653078e-10,  2.765566191193072e-12, -3.519924380968073e-14,  4.287540929490196e-16,
 -4.990945124876948e-18,  5.400407783654346e-20, -4.926942322363382e-22,  2.369231576514749e-24,  3.952086181201336e-26,  2.089468103320621e-05, -5.120820564319018e-07,
  8.786136587889291e-09, -1.292272528116056e-10,  1.743048695337595e-12, -2.227302868333914e-14,  2.758565252238239e-16, -3.407419851601988e-18,  4.409413951696271e-20,
 -6.380618700051172e-22,  1.056712032152037e-23, -1.864399140964390e-25,  4.424022780669911e-06, -1.084232399735213e-07,  1.860341212693636e-09, -2.736766112960768e-11,
  3.695985878540462e-13, -4.751979326476138e-15,  6.036387920572226e-17, -8.099644845584128e-19,  1.272821886877241e-20, -2.460788531602139e-22,  5.336830225475279e-24,
 -1.125293684029309e-25,  3.134892939310748e-07, -7.682978627437943e-09,  1.318312305786676e-10, -1.940004247330598e-12,  2.625064488461193e-14, -3.407811571128227e-16,
  4.498435176601471e-18, -6.746695229480187e-20,  1.291386161600295e-21, -3.031731818896112e-23,  7.428539396960279e-25, -1.673307990787601e-26,  5.921509807178612e-09,
 -1.451250879395808e-10,  2.490359532984276e-12, -3.666749119199640e-14,  4.977948776356654e-16, -6.568294576256693e-18,  9.220692911767778e-20, -1.608260798045098e-21,
  3.749258027120662e-23, -1.013652758852919e-24,  2.680283607856583e-26, -6.323599514559118e-28,  1.463066495164307e-11, -3.585753160402620e-13,  6.154073483975049e-15,
 -9.071215513150399e-17,  1.239985901358179e-18, -1.691911938704314e-20,  2.666659211091983e-22, -5.809156168768384e-24,  1.667136176845678e-25, -5.085570851916862e-27,
  1.442973286264581e-28, -3.611706869391697e-30,  1.163056253546718e-05, -2.742842254448526e-07,  4.528405583832948e-09, -6.408255128392107e-11,  8.311040107520741e-13,
 -1.017942292115698e-14,  1.192921250648532e-16, -1.332771093713585e-18,  1.364689014722869e-20, -1.085724782509201e-22,  2.418550365437125e-26,  2.680402841953810e-26,
  3.013904657524458e-05, -7.107710872483656e-07,  1.173479780871296e-08, -1.660661115227293e-10,  2.154105108981607e-12, -2.640649534055788e-14,  3.106798137898444e-16,
 -3.525970084541056e-18,  3.823579610550466e-20, -3.795839304425783e-22,  2.967923126934055e-24, -4.620324318088462e-27,  1.897773717764971e-05, -4.475534308281069e-07,
  7.389124978776672e-09, -1.045722574489083e-10,  1.356809095075967e-12, -1.665658213372784e-14,  1.972499708227970e-16, -2.296084356333975e-18,  2.709992239880516e-20,
 -3.428109175148462e-22,  4.951511775216253e-24, -8.193103910227631e-26,  4.018148341972577e-06, -9.476037403987977e-08,  1.564510135948904e-09, -2.214266080494572e-11,
  2.874171397635406e-13, -3.536292313976691e-15,  4.230064560150878e-17, -5.113519571763647e-19,  6.746996616177320e-21, -1.074143892012776e-22,  2.089758120166508e-24,
 -4.426805897044068e-26,  2.847286805891691e-07, -6.714791574846772e-09,  1.108637500332370e-10, -1.569222382302891e-12,  2.038213013220699e-14, -2.516525591553829e-16,
  3.057553584066999e-18, -3.907361835885698e-20,  5.926040199960176e-22, -1.159791310209560e-23,  2.685152253945609e-25, -6.291427742989374e-27,  5.378247370600252e-09,
 -1.268361210877400e-10,  2.094155578249387e-12, -2.964670264867245e-14,  3.854918104763736e-16, -4.787622339996842e-18,  5.969280409655616e-20, -8.305888834053238e-22,
  1.497076505749685e-23, -3.524324439746839e-25,  9.170126633902663e-27, -2.285133946976881e-28,  1.328837954402359e-11, -3.133833303119007e-13,  5.174397006521390e-15,
 -7.327799410485029e-17,  9.549492512453880e-19, -1.200414315656494e-20,  1.575970262327377e-22, -2.544324563641299e-24,  5.754220566619975e-26, -1.616269160621954e-27,
  4.632675647788520e-29, -1.224541826375291e-30,  1.060130979389268e-05, -2.409214045705940e-07,  3.832953793352588e-09, -5.226988382471627e-11,  6.533628209986953e-13,
 -7.718434572051813e-15,  8.751256491789469e-17, -9.566874380169411e-19,  9.955449643607166e-21, -9.286328880873382e-23,  5.943497810013491e-25,  3.499499630458302e-27,
  2.747187534823244e-05, -6.243156244219387e-07,  9.932596519116361e-09, -1.354515761042421e-10,  1.693205360584385e-12, -2.000846849478936e-14,  2.271874094536029e-16,
 -2.498870595767584e-18,  2.661202418734954e-20, -2.697198827292060e-22,  2.447175508343178e-24, -1.568290677517991e-26,  1.729829157803669e-05, -3.931145960162349e-07,
  6.254295626493473e-09, -8.529138068710155e-11,  1.066272452796425e-12, -1.260626517319713e-14,  1.434820030367649e-16, -1.594124955586039e-18,  1.761038394047590e-20,
 -2.004192098456227e-22,  2.498135178515646e-24, -3.610268238277644e-26,  3.662559871136499e-06, -8.323400253149605e-08,  1.324222642353977e-09, -1.805910319475136e-11,
  2.257964610285069e-13, -2.671572118124089e-15,  3.052032984758420e-17, -3.443449622598905e-19,  4.011666626375518e-21, -5.262291117043349e-23,  8.495098897618156e-25,
 -1.648449584756440e-26,  2.595314263624982e-07, -5.898018623228093e-09,  9.383565728643294e-11, -1.279723395010198e-12,  1.600394247630379e-14, -1.895803884925894e-16,
  2.178340333302630e-18, -2.516210753222683e-20,  3.160650020482822e-22, -4.881625377920144e-24,  9.677141017130042e-26, -2.186836101960777e-27,  4.902295253910568e-09,
 -1.114078716413141e-10,  1.772475127230216e-12, -2.417407578259149e-14,  3.024197406177579e-16, -3.589548225881782e-18,  4.164495212348248e-20, -4.997511350683204e-22,
  7.001810288177149e-24, -1.300457762066042e-25,  3.044791968202480e-27, -7.575813834226657e-29,  1.211241164247054e-11, -2.752627700252941e-13,  4.379420705650928e-15,
 -5.973502200808513e-17,  7.478056578718086e-19, -8.911831382180527e-21,  1.054293539687670e-22, -1.361295770153299e-24,  2.273737113907638e-26, -5.251349884289666e-28,
  1.424850865876380e-29, -3.835612684894026e-31,  9.695215230490746e-06, -2.126000472929980e-07,  3.263690095265511e-09, -4.294540975036182e-11,  5.180009291789470e-13,
 -5.906501822866913e-15,  6.471639473004649e-17, -6.868800504622198e-19,  7.052940010892439e-21, -6.853864157838119e-23,  5.781541438659363e-25, -2.676937428270383e-27,
  2.512385245741572e-05, -5.509245756591361e-07,  8.457418300044266e-09, -1.112875594253941e-10,  1.342355134400950e-12, -1.530769243544191e-14,  1.678082789515269e-16,
 -1.785117680082616e-18,  1.849602429249633e-20, -1.857245199524950e-22,  1.762140577921749e-24, -1.451357230599929e-26,  1.581980540931548e-05, -3.469022080827913e-07,
  5.325408264510138e-09, -7.007503290963749e-11,  8.452704546985339e-13, -9.640689844823295e-15,  1.057729623497386e-16, -1.129420945742052e-18,  1.187561135350444e-20,
 -1.254485990371914e-22,  1.386869209699919e-24, -1.712508478492173e-26,  3.349520590502464e-06, -7.344945921667985e-08,  1.127547170960683e-09, -1.483705039054027e-11,
  1.789772198390854e-13, -2.041824390655979e-15,  2.243085961859964e-17, -2.409000738899800e-19,  2.589988133733964e-21, -2.937603235119839e-23,  3.858480109056520e-25,
 -6.295228306853196e-27,  2.373492508919122e-07, -5.204677835098503e-09,  7.989882418773222e-11, -1.051373452869205e-12,  1.268337049638241e-14, -1.447514656518582e-16,
  1.593389699054026e-18, -1.726621577535406e-20,  1.919444296494036e-22, -2.396987953460083e-24,  3.774387552101745e-26, -7.496507004414378e-28,  4.483295492984483e-09,
 -9.831129332940238e-11,  1.509213310020127e-12, -1.985973301724555e-14,  2.396052336506746e-16, -2.736289988610072e-18,  3.022106959312102e-20, -3.323541296130521e-22,
  3.894868079603957e-24, -5.546412580136146e-26,  1.052721293021817e-27, -2.420511776461171e-29,  1.107716178310165e-11, -2.429039940910348e-13,  3.728921039417245e-15,
 -4.907021566938468e-17,  5.921475116003560e-19, -6.770929079983880e-21,  7.528386668576348e-23, -8.525348613850236e-25,  1.100450290987742e-26, -1.902568857584547e-28,
  4.413339327559930e-30, -1.147043572038713e-31,  8.893957960603105e-06, -1.884194702495778e-07,  2.794431515082543e-09, -3.552415293820897e-11,  4.139676753561788e-13,
 -4.560723160877231e-15,  4.830288570249178e-17, -4.964585892609981e-19,  4.969560866701013e-21, -4.814803585621781e-23,  4.372909660802947e-25, -3.297764418253374e-27,
  2.304750147430638e-05, -4.882638372811057e-07,  7.241395723667651e-09, -9.205615169286845e-11,  1.072747738351211e-12, -1.181893299818069e-14,  1.251961263477646e-16,
 -1.287803900243380e-18,  1.293455015497176e-20, -1.269263557275124e-22,  1.205747164064170e-24, -1.071335435075198e-26,  1.451238373787919e-05, -3.074464381408006e-07,
  4.559710134708473e-09, -5.796531752320956e-11,  6.754861523381291e-13, -7.442505143421988e-15,  7.885922951440835e-17, -8.122446806527823e-19,  8.203501934912490e-21,
 -8.217436700586692e-23,  8.351741508792025e-25, -9.020733297187557e-27,  3.072700754244143e-06, -6.509550274489096e-08,  9.654256371701465e-10, -1.227299337289693e-11,
  1.430223815499520e-13, -1.575943220448672e-15,  1.670552115977712e-17, -1.724177282272819e-19,  1.756273146116957e-21, -1.814029197833905e-23,  2.019310624751432e-25,
 -2.664997923081182e-27,  2.177336127545985e-07, -4.612710582210062e-09,  6.841071971961692e-11, -8.696747964978445e-13,  1.013487708901167e-14, -1.116881816650605e-16,
  1.184716203575859e-18, -1.226620145348675e-20,  1.265891204904407e-22, -1.367815167204359e-24,  1.711376993646958e-26, -2.737776038313616e-28,  4.112775222306312e-09,
 -8.712959929203022e-11,  1.292212236933496e-12, -1.642737916062779e-14,  1.914445843567237e-16, -2.110169729082297e-18,  2.240778061830402e-20, -2.332195766635714e-22,
  2.458707903059804e-24, -2.846128143925161e-26,  4.134614847814576e-28, -7.932116492796129e-30,  1.016169378014694e-11, -2.152766236481974e-13,  3.192753189675467e-15,
 -4.058850496187200e-17,  4.730460682555805e-19, -5.216091959930512e-21,  5.550912445900283e-23, -5.837607806570070e-25,  6.413539377007684e-27, -8.367936218387676e-29,
  1.488664953274516e-30, -3.418117248857041e-32,  8.182441460482479e-06, -1.676631235587564e-07,  2.405064352678166e-09, -2.957182124199953e-11,  3.333064288059908e-13,
 -3.551781816682216e-15,  3.639030191164018e-17, -3.620642363040471e-19,  3.517625645372486e-21, -3.338397455365816e-23,  3.061358292925801e-25, -2.597280536306219e-27,
  2.120370170495910e-05, -4.344765411322924e-07,  6.232402434455305e-09, -7.663143080940530e-11,  8.637203559094104e-13, -9.204067649035677e-15,  9.430671432521125e-17,
 -9.385566944343749e-19,  9.129531921072438e-21, -8.706010306920997e-23,  8.123407068704327e-25, -7.317663058478043e-27,  1.335139325246385e-05, -2.735780409207248e-07,
  3.924374127571101e-09, -4.825273924071692e-11,  5.438625834424631e-13, -5.795654573602286e-15,  5.938870414928815e-17, -5.913110038576795e-19,  5.763241714775506e-21,
 -5.539187813365506e-23,  5.313593525146306e-25, -5.221609270686691e-27,  2.826884737235061e-06, -5.792456085656278e-08,  8.309060811979431e-10, -1.021653656596246e-11,
  1.151522458858696e-13, -1.227145147551017e-15,  1.257640369093372e-17, -1.253046971171488e-19,  1.225026095268132e-21, -1.191567906831133e-23,  1.190298956495030e-25,
 -1.308107164605576e-27,  2.003149266004211e-07, -4.104572805433551e-09,  5.887855997404221e-11, -7.239510815101026e-13,  8.159813760163921e-15, -8.695997600292813e-17,
  8.913965158852267e-19, -8.890834436110900e-21,  8.733055322697986e-23, -8.650366082084579e-25,  9.157702038924332e-27, -1.152660490181177e-28,  3.783753252476360e-09,
 -7.753137070087009e-11,  1.112158599670228e-12, -1.367474464025006e-14,  1.541324141468458e-16, -1.642701223205597e-18,  1.684452821141306e-20, -1.683011745837202e-22,
  1.665975791906184e-24, -1.699074517489370e-26,  1.959264514974513e-28, -2.899992741746797e-30,  9.348758367490413e-12, -1.915616620340533e-13,  2.747881151549464e-15,
 -3.378713096273220e-17,  3.808317888272816e-19, -4.059259429790026e-21,  4.165206476658518e-23, -4.175894712366513e-25,  4.196721584905725e-27, -4.522020657073786e-29,
  5.999732858509866e-31, -1.087598781430632e-32,  7.548143777917003e-06, -1.497565034481980e-07,  2.080000555006476e-09, -2.476298196104805e-11,  2.702446189570955e-13,
 -2.788379676487916e-15,  2.766335146291826e-17, -2.665751528019594e-19,  2.510860707578929e-21, -2.318604220574843e-23,  2.094334724049255e-25, -1.821550798795666e-27,
  1.956000416938587e-05, -3.880739316852124e-07,  5.390043025123373e-09, -6.416995611596598e-11,  7.003030603950148e-13, -7.225735609892362e-15,  7.168729136726054e-17,
 -6.908683570245907e-19,  6.509947750667711e-21, -6.021879173008419e-23,  5.475126846602968e-25, -4.872260951485626e-27,  1.231640169682111e-05, -2.443595815176264e-07,
  3.393963263199385e-09, -4.040607635441005e-11,  4.409620727794979e-13, -4.549872517241921e-15,  4.514100054490623e-17, -4.350981015363957e-19,  4.102648104303533e-21,
 -3.805854688298228e-23,  3.497392596823104e-25, -3.226277435612039e-27,  2.607746420952418e-06, -5.173814888002621e-08,  7.186023869004176e-10, -8.555162204389789e-12,
  9.336481146691649e-14, -9.633501975351940e-16,  9.558159464837760e-18, -9.214816533984443e-20,  8.697944145409380e-22, -8.103927229776264e-24,  7.568124687104300e-26,
 -7.350703830362390e-28,  1.847866401834323e-07, -3.666199533814324e-09,  5.092064244237867e-11, -6.062245812827119e-13,  6.615903408791028e-15, -6.826445977554151e-17,
  6.773489542348242e-19, -6.532400760848403e-21,  6.175884565318793e-23, -5.792670228166293e-25,  5.542271132464130e-27, -5.783326224945499e-29,  3.490439092110768e-09,
 -6.925092736665449e-11,  9.618412124718017e-13, -1.145099354131026e-14,  1.249682840486728e-16, -1.289474103249341e-18,  1.279603395256806e-20, -1.234743683765383e-22,
  1.170421060649548e-24, -1.109803838176574e-26,  1.103156613571978e-28, -1.274001963012074e-30,  8.624048522169209e-12, -1.711026447498388e-13,  2.376482014656930e-15,
 -2.829270978722126e-17,  3.087685861217523e-19, -3.186103114963327e-21,  3.162341443930440e-23, -3.054755899910403e-25,  2.910441730325416e-27, -2.818315852456182e-29,
  3.003761949112402e-31, -4.057872604153547e-33  };
  int offset = -7;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 7;
    if (std::isnan(t)) {
      fill_n(rr+offset, 7, 0.5);
      fill_n(ww+offset, 7, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 7; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=7; ++j) {
        const int boxof = it*84+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
