//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _spin2root_13.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/spin2rootlist.h>

using namespace std;
using namespace bagel;

void Spin2RootList::spin2root13(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[13] = {1.053778449068499e+00,2.112659899939685e+00,3.550515612603487e-01,3.545908105375702e+00,5.374001965904311e+00,
    7.625586363900259e+00,1.034046177980882e+01,1.357461255808315e+01,1.740919726636485e+01,2.196810077901239e+01,2.745694644965032e+01,3.426952619644752e+01,
    4.341416862518417e+01};
  constexpr double aw[13] = {1.653425933230193e-01,2.308063944231524e-01,3.872617185993039e-02,1.566347172501690e-01,5.873863422879316e-02,
    1.271411385249187e-02,1.591388592740667e-03,1.119406174603468e-04,4.165594768034293e-06,7.382728502267819e-08,5.187459678940759e-10,1.012024448364900e-12,
    2.226575301122807e-16};
  constexpr double x[4992] = {  4.770292489621265e-02, -8.035338537316322e-04,  9.900207753903558e-06, -1.046595321614874e-07,  9.871805952427737e-10,
 -8.323210860456544e-12,  6.089708275874580e-14, -3.493540369866599e-16,  8.767821612031058e-19,  1.432534390861935e-20, -3.163115410601420e-22,  4.131502777535718e-24,
  1.389367662207695e-01, -2.234422232362665e-03,  2.495752387347249e-05, -2.192151420149240e-07,  1.440082978897933e-09, -4.562929762690915e-12, -4.832874178327405e-14,
  1.113013801874982e-15, -1.258872300776392e-17,  8.991507015852257e-20, -1.829109238113246e-22, -6.111221329986177e-24,  2.707047993370168e-01, -4.054418963497051e-03,
  3.851065387533667e-05, -2.311317931705300e-07,  1.485463783288296e-10,  1.631616874232111e-11, -2.181704777974997e-13,  1.273672279624275e-15,  5.042597055013830e-18,
 -2.008458628372861e-19,  2.184421061012100e-21, -7.659474825434871e-24,  4.371390507011302e-01, -5.933941146656518e-03,  4.375321270680725e-05, -8.455476794634467e-08,
 -2.292549296228464e-09,  2.894329227651023e-11, -6.986774281332266e-14, -2.242714149191305e-15,  3.082393838166990e-17, -7.201502181321466e-20, -2.842481857349910e-21,
  3.959939652563757e-23,  6.307045316323068e-01, -7.526223814329206e-03,  3.673963972735671e-05,  1.679398078324318e-07, -3.710405904581410e-09,  8.806791367624423e-12,
  3.102848393951089e-13, -3.062282188019754e-15, -1.409031094946521e-17,  4.660200101763183e-19, -1.625047494189222e-21, -4.737809514800558e-23,  8.424798753305794e-01,
 -8.529830207054709e-03,  1.816662806619815e-05,  3.893163655171641e-07, -2.427054553015045e-09, -2.862653256120425e-11,  3.340076704086060e-13,  2.163755294590931e-15,
 -4.623481490048050e-17, -1.184404385289926e-19,  6.285744899300378e-21, -5.110462130221629e-24,  1.062504578267588e+00, -8.746319364843850e-03, -6.629602822483621e-06,
  4.447397571225963e-07,  8.707665477700439e-10, -4.036657531841918e-11, -1.268807024657061e-13,  4.433842421518523e-15,  1.920011356119468e-17, -5.351428731263852e-19,
 -2.993580294800247e-21,  6.834298914987007e-23,  1.280199968751053e+00, -8.122377837625096e-03, -2.960329206968541e-05,  2.947940344471932e-07,  3.523663332007495e-09,
 -1.088646003006762e-11, -4.155402936569373e-13, -8.124461900962875e-16,  4.509390345073925e-17,  3.297670660676648e-19, -4.084796283157668e-21, -6.479235182972028e-23,
  1.484858266301707e+00, -6.766831075973970e-03, -4.321126244485700e-05,  2.812537123958223e-08,  3.395511750144159e-09,  2.496520499258113e-11, -1.305935127556099e-13,
 -3.831140789571345e-15, -1.884440808059068e-17,  2.907539217575457e-19,  4.989525924675553e-21,  8.811448581519136e-24,  1.666184519973621e+00, -4.936428771545239e-03,
 -4.362255420769684e-05, -1.960609797771477e-07,  9.708245347924924e-10,  2.740210471378253e-11,  2.250457816046558e-13, -1.301853476864227e-16, -2.607028469511018e-17,
 -3.082147795022589e-19, -8.082718827184631e-22,  2.703035057817269e-23,  1.814864992540990e+00, -2.990054074879520e-03, -3.248023223807321e-05, -2.594808193483001e-07,
 -1.252068239998857e-09,  3.222352388375347e-12,  1.545703447354544e-13,  1.934147318732490e-15,  1.315293052460711e-17, -4.016567260542805e-21, -1.485330550040488e-21,
 -2.251157688648788e-23,  1.923124860063621e+00, -1.318227285083841e-03, -1.627632168876898e-05, -1.680449722206334e-07, -1.485827413643334e-09, -1.082496409519211e-11,
 -5.444656882742803e-14,  3.024067526675292e-17,  5.315798831630600e-18,  8.609963293554743e-20,  9.506865216847557e-22,  7.833867814152358e-24,  1.985244104035010e+00,
 -2.614966171916726e-04, -3.452385725545456e-06, -4.009138253587326e-08, -4.309397536705292e-10, -4.373544304468942e-12, -4.228494160442659e-14, -3.901495160403611e-16,
 -3.426603603311658e-18, -2.838872975809044e-20, -2.178025742841937e-22, -1.483044630978812e-24,  4.463960170859698e-02, -7.290994877441118e-04,  8.733817676845537e-06,
 -9.012021007882745e-08,  8.345574589242484e-10, -6.975495996200870e-12,  5.156998051409310e-14, -3.151654386503853e-16,  1.203535578154830e-18,  4.768007076464184e-21,
 -1.735325486730638e-22,  2.482319173878734e-24,  1.303822807148262e-01, -2.044899961305088e-03,  2.246200152365794e-05, -1.969570891581615e-07,  1.339527014039246e-09,
 -5.391438636543466e-12, -2.233015121304302e-14,  7.601172846322282e-16, -9.534885881227667e-18,  7.865313270118382e-20, -3.495263409485789e-22, -1.884846972449381e-24,
  2.550858154145069e-01, -3.757364640463815e-03,  3.576121367430725e-05, -2.264165847936623e-07,  4.254655501959951e-10,  1.152016892064074e-11, -1.812196411964188e-13,
  1.335452254800090e-15, -7.110490974774633e-19, -1.217435426275572e-19,  1.743354757434008e-21, -1.146436203988467e-23,  4.140960881535460e-01, -5.588554343370971e-03,
  4.253722461911383e-05, -1.167151205383180e-07, -1.734974902593958e-09,  2.662127646099821e-11, -1.193815410457084e-13, -1.316463383157749e-15,  2.658904697224547e-17,
 -1.526951766805643e-19, -1.249515536949269e-21,  3.174883995638209e-23,  6.011988300202101e-01, -7.225238948868696e-03,  3.840576014019382e-05,  1.103571352028985e-07,
 -3.466946442775470e-09,  1.518871126247118e-11,  2.206398995205686e-13, -3.260882509641875e-15,  1.087905853141360e-18,  3.674621027027875e-19, -3.100522868480002e-21,
 -1.976646469592256e-23,  8.086798229132224e-01, -8.366510748507389e-03,  2.258799351903313e-05,  3.463563509674865e-07, -2.915390474254534e-09, -2.005274003937936e-11,
  3.735787354149340e-13,  6.634374378503821e-16, -4.612773330293289e-17,  1.176270792797813e-19,  5.273425294054478e-21, -3.847695975429239e-23,  1.027447279770860e+00,
 -8.777834048888300e-03, -1.236192203854385e-06,  4.520911417766527e-07,  4.332037926426282e-11, -4.187098878775490e-11,  2.843296846161877e-15,  4.723102256838018e-15,
 -1.448029927242061e-18, -5.898667572770545e-19,  3.319869776853421e-22,  7.851018418171975e-23,  1.247260535877548e+00, -8.344115718012662e-03, -2.573644607132646e-05,
  3.488842770988205e-07,  3.205246558193430e-09, -2.095964115877005e-11, -4.165579333113763e-13,  7.836494057861006e-16,  5.337843222168523e-17,  1.142218728993314e-19,
 -6.526799399344150e-21, -4.208957234527577e-23,  1.457103051613842e+00, -7.110210923375883e-03, -4.253196576272145e-05,  8.624013716509457e-08,  3.854478305017840e-09,
  2.048661392220174e-11, -2.444577610339715e-13, -4.227942306423710e-15, -4.773596200421788e-18,  4.888482163155896e-19,  4.660521666987698e-21, -2.604106402102977e-23,
  1.645726373481545e+00, -5.294512523678782e-03, -4.586305858640400e-05, -1.758530591454862e-07,  1.572051042540883e-09,  3.265478032900813e-11,  2.080239627536361e-13,
 -1.145485207527687e-15, -3.740095660796427e-17, -3.100671371082817e-19,  8.881189913696202e-22,  5.060114676775234e-23,  1.802364899411930e+00, -3.262685272307055e-03,
 -3.571136860529703e-05, -2.787775124522471e-07, -1.145894084313035e-09,  7.628880754282738e-12,  2.145035092517330e-13,  2.339168461520987e-15,  1.167663891701787e-17,
 -8.582008592888438e-20, -2.667541304614527e-21, -3.105668807324020e-23,  1.917578165529940e+00, -1.456925074564230e-03, -1.844287354111516e-05, -1.936205303131236e-07,
 -1.715212779903489e-09, -1.209915523656528e-11, -5.069598946853365e-14,  2.579856132925898e-16,  9.187842522356473e-18,  1.315493481717212e-19,  1.333606396870439e-21,
  9.433596234953645e-24,  1.984139657729237e+00, -2.911643303854576e-04, -3.977928395998368e-06, -4.774527510136134e-08, -5.295121579365634e-10, -5.532871462582694e-12,
 -5.491064675566332e-14, -5.179686079107764e-16, -4.622176911577714e-18, -3.851972258288322e-20, -2.915700520235632e-22, -1.868922591680582e-24,  4.185640272823186e-02,
 -6.633378972095936e-04,  7.728098670154839e-06, -7.781904331840595e-08,  7.067325452628310e-10, -5.839244466080562e-12,  4.330191808908446e-14, -2.750530554184771e-16,
  1.273398920407163e-18, -3.288469668111700e-22, -8.879626261153089e-23,  1.451052201474943e-24,  1.225476075317705e-01, -1.874301888695054e-03,  2.022347672514327e-05,
 -1.764097570842472e-07,  1.227895503786314e-09, -5.703924277188660e-12, -4.912765889759405e-15,  4.974921159058276e-16, -6.967935844726558e-18,  6.376671149913549e-20,
 -3.791843944779607e-22,  2.716890809203071e-25,  2.406115132187515e-01, -3.482011162381199e-03,  3.309193171173275e-05, -2.179895994618472e-07,  6.153762204872558e-10,
  7.613445164825306e-12, -1.447142248645606e-13,  1.255035425598773e-15, -3.961570475703971e-18, -6.220705236489502e-20,  1.236189327956776e-21, -1.112841076795760e-23,
  3.924129818016620e-01, -5.254291387868508e-03,  4.098712112923097e-05, -1.403818591512268e-07, -1.233712388203321e-09,  2.340457377501727e-11, -1.452108974903085e-13,
 -5.606722884642361e-16,  2.049966812873539e-17, -1.779817176407653e-19, -9.709728550930216e-23,  2.052027215275890e-23,  5.729194548276946e-01, -6.913613931904893e-03,
  3.940809110893160e-05,  5.757307538183440e-08, -3.117545350829331e-09,  1.940367992682786e-11,  1.316329877217442e-13, -3.039599933936133e-15,  1.194222003087639e-17,
  2.333739197388882e-19, -3.436284751936413e-21,  3.172278563861321e-24,  7.756003552133529e-01, -8.170001977538756e-03,  2.645274560350729e-05,  2.969921903824736e-07,
 -3.226122118635437e-09, -1.102545437243918e-11,  3.723954985309107e-13, -7.078823139962307e-16, -3.856119355103024e-17,  2.887375424273339e-19,  3.170305169052327e-21,
 -5.382064217204086e-23,  9.923504564534436e-01, -8.766074826402100e-03,  4.165559497825799e-06,  4.461332379567283e-07, -7.828144668844037e-10, -4.024038801357967e-11,
  1.313058608986852e-13,  4.346183713077868e-15, -2.163486482433339e-17, -5.104076131265751e-19,  3.523662859864398e-21,  6.252906967561992e-23,  1.213499989501540e+00,
 -8.532424350696732e-03, -2.125769516735402e-05,  3.962824511712991e-07,  2.688863992987799e-09, -3.049878833199957e-11, -3.704609646157156e-13,  2.504219331741625e-15,
  5.244945355437019e-17, -1.721385584098423e-19, -7.469431887121002e-21,  1.847187808535324e-24,  1.427989769040289e+00, -7.445249836517419e-03, -4.111467586969682e-05,
  1.508305351386650e-07,  4.195936008697435e-09,  1.319925591786605e-11, -3.620931890988909e-13, -4.066128124448471e-15,  1.579058444300577e-17,  6.397971941404599e-19,
  2.570737185274993e-21, -6.917436867933345e-23,  1.623801820866470e+00, -5.669379008151956e-03, -4.779998348318080e-05, -1.452176813155974e-07,  2.271732985929917e-09,
  3.711727730796224e-11,  1.575928622021651e-13, -2.509279193906162e-15, -4.732320939836589e-17, -2.230396642877677e-19,  3.625250513887375e-21,  7.261970838217659e-23,
  1.788721167026498e+00, -3.562055698272633e-03, -3.916070088298814e-05, -2.955885001131887e-07, -9.363271953403944e-10,  1.360148883014298e-11,  2.846039907091214e-13,
  2.640000269691012e-15,  6.319047429093560e-18, -2.217610179636021e-19, -4.165712492001328e-21, -3.590019899160738e-23,  1.911439980683276e+00, -1.614247191609307e-03,
 -2.093917163454807e-05, -2.230627936374326e-07, -1.968586133270886e-09, -1.319118827305894e-11, -3.856612340881248e-14,  6.388889734796355e-16,  1.498557914194606e-17,
  1.933506608967389e-19,  1.755609753563962e-21,  9.270591700016975e-24,  1.982907509874529e+00, -3.254324589949963e-04, -4.605602736850605e-06, -5.717958153905683e-08,
 -6.546150180029897e-10, -7.042844123876292e-12, -7.170998232651663e-14, -6.904836408847435e-16, -6.239573791740318e-18, -5.192812550776976e-20, -3.810489106633155e-22,
 -2.166197393806213e-24,  3.932104660094152e-02, -6.050647121378719e-04,  6.858438524630092e-06, -6.739167202826946e-08,  5.997399668040771e-10, -4.887844246733363e-12,
  3.616490711031231e-14, -2.350672998010254e-16,  1.211069843859087e-18, -2.812497803604052e-21, -3.995843005948671e-23,  8.209708125347350e-25,  1.153610285184199e-01,
 -1.720656445479124e-03,  1.822066417370406e-05, -1.576781541913647e-07,  1.113644672732953e-09, -5.677851895996477e-12,  6.219856603657727e-15,  3.083654440183551e-16,
 -4.939270364433143e-18,  4.917520999245028e-20, -3.437918690578732e-22,  1.186632329251044e-24,  2.271966223554614e-01, -3.227561422522879e-03,  3.053957821042563e-05,
 -2.071024691781554e-07,  7.356784832955609e-10,  4.545919429924648e-12, -1.116220351274190e-13,  1.101051212479731e-15, -5.424052762888137e-18, -2.199567883631519e-20,
  7.900705251288124e-22, -8.996032328289190e-24,  3.720405127483047e-01, -4.933433994464636e-03,  3.919892453882625e-05, -1.565699603032557e-07, -8.013851254228390e-10,
  1.979934610636718e-11, -1.526851747196881e-13, -6.376925584280878e-18,  1.421081222304650e-17, -1.669861681095667e-19,  5.720796219298996e-22,  1.027889545954316e-23,
  5.458987470928530e-01, -6.596403199153405e-03,  3.981296910884393e-05,  1.094051809129289e-08, -2.704520945534480e-09,  2.159157598303219e-11,  5.295124780633864e-14,
 -2.548984087479968e-15,  1.794746863242004e-17,  1.034347817985595e-19, -2.961843392313818e-21,  1.674909876908725e-23,  7.433649056352339e-01, -7.945015539739399e-03,
  2.970121619502562e-05,  2.440866505155896e-07, -3.359538823630405e-09, -2.454884151568744e-12,  3.370094722148633e-13, -1.755722931207391e-15, -2.645903879064040e-17,
  3.679614437698171e-19,  8.158376055946048e-22, -5.050607563116988e-23,  9.573863326275036e-01, -8.711608734521158e-03,  9.418113355719754e-06,  4.273807285449103e-07,
 -1.546724092246644e-09, -3.572284342111318e-11,  2.407667584735519e-13,  3.391919943001466e-15, -3.689248040894185e-17, -3.237611668893173e-19,  5.553492064245191e-21,
  2.774551040838325e-23,  1.179061254053440e+00, -8.682782348175599e-03, -1.626579568425710e-05,  4.339685467175692e-07,  1.996605594069750e-09, -3.836654364974255e-11,
 -2.781828526765519e-13,  4.026846135619181e-15,  4.103121344060838e-17, -4.542301877226533e-19, -6.265341346487122e-21,  5.226994510180910e-23,  1.397564031599220e+00,
 -7.765769275022499e-03, -3.889482025260833e-05,  2.195678187016680e-07,  4.364184259172821e-09,  3.221730169675027e-12, -4.653045128660990e-13, -3.179122880823474e-15,
  3.983402497305751e-17,  6.702633342634158e-19, -1.300604895588133e-21, -1.035726434075078e-22,  1.600349416804844e+00, -6.058073791359244e-03, -4.929941908476239e-05,
 -1.027527390078817e-07,  3.045298071177577e-09,  3.987900844477478e-11,  6.516214689191891e-14, -4.117607354835225e-15, -5.193628177346988e-17, -1.045596772207921e-20,
  7.054690459012016e-21,  7.928983165683287e-23,  1.773823579192005e+00, -3.889761022829116e-03, -4.278740171401154e-05, -3.079969358903146e-07, -5.899225858579636e-10,
  2.133327179252555e-11,  3.599076964960549e-13,  2.679254556007860e-15, -5.038842354213371e-18, -4.191615477613237e-19, -5.655245812163997e-21, -2.896566502673244e-23,
  1.904630229656456e+00, -1.793023377089615e-03, -2.381375935926911e-05, -2.567139077175760e-07, -2.239907599047750e-09, -1.384098558902350e-11, -1.281625938519742e-14,
  1.244099614243809e-15,  2.330059201518081e-17,  2.707723759565647e-19,  2.080024820821226e-21,  4.315071654815285e-24,  1.981527478453401e+00, -3.652113031024313e-04,
 -5.359570925593519e-06, -6.888078922064674e-08, -8.143726462732572e-10, -9.020285664909378e-12, -9.414195031585830e-14, -9.231904214462197e-16, -8.406524971934875e-18,
 -6.909188706350205e-20, -4.764509746003934e-22, -2.060606929587466e-24,  3.700562187939829e-02, -5.532760088560671e-04,  6.104234352752637e-06, -5.853288894686713e-08,
  5.101517274525511e-10, -4.094592841320679e-12,  3.010853190598526e-14, -1.981786956642636e-16,  1.088585500606585e-18, -3.813872149307379e-21, -1.284605343555478e-23,
  4.438336457744483e-25,  1.087583661673811e-01, -1.582165336440432e-03,  1.643172239396334e-05, -1.407575506901312e-07,  1.002194072486997e-09, -5.441281409787904e-12,
  1.288913698129484e-14,  1.760888098689782e-16, -3.402883194152106e-18,  3.657316016621521e-20, -2.845988374707966e-22,  1.427085161657695e-24,  2.147595606101242e-01,
 -2.992979596096401e-03,  2.812753030471909e-05, -1.947396997057843e-07,  8.022010328965825e-10,  2.216798470038977e-12, -8.330239790707179e-14,  9.201815874448957e-16,
 -5.735669905568175e-18,  2.434815237039886e-21,  4.498678230021673e-22, -6.478215656737462e-24,  3.529217905664469e-01, -4.627547128334027e-03,  3.725557657722589e-05,
 -1.664225340414236e-07, -4.418144700272427e-10,  1.617876796307995e-11, -1.473651375431023e-13,  3.573378116410486e-16,  8.697902294193334e-18, -1.374626490461380e-19,
  8.502279311235764e-22,  2.883766421476414e-24,  5.201499784388274e-01, -6.278076778916682e-03,  3.969903200846135e-05, -2.883117885441814e-08, -2.265415074722848e-09,
  2.207350658802791e-11, -9.974092378178971e-15, -1.936385646236536e-15,  1.973449111850001e-17,  1.589078844853674e-21, -2.098596960699953e-21,  2.117008465903482e-23,
  7.120773220260495e-01, -7.696604411218441e-03,  3.230749411004067e-05,  1.903624305593647e-07, -3.332178254479553e-09,  4.960105855901926e-12,  2.780078059292637e-13,
 -2.388289268939761e-15, -1.312545558998676e-17,  3.601408411668524e-19, -1.092301399225809e-21, -3.492028826729189e-23,  9.227224056606796e-01, -8.616222370468633e-03,
  1.437571869060001e-05,  3.972612164845890e-07, -2.196433476507928e-09, -2.894734991127257e-11,  3.177765434630470e-13,  2.069434891570428e-15, -4.436158461285412e-17,
 -8.887218176242838e-20,  5.906809721783005e-21, -1.102942769019721e-23,  1.144103540624683e+00, -8.791595620152762e-03, -1.089288523237308e-05,  4.594536341999952e-07,
  1.172340500602867e-09, -4.355825593414960e-11, -1.498224469852321e-13,  5.035106837342780e-15,  2.083731271601288e-17, -6.465021375587767e-19, -3.083397162421351e-21,
  8.836409934136072e-23,  1.365897001697139e+00, -8.065200707413497e-03, -3.584095968802933e-05,  2.892760930014576e-07,  4.310572522733831e-09, -8.848013550897754e-12,
 -5.329715850633600e-13, -1.537614013213764e-15,  6.188662931830438e-17,  5.229908459033969e-19, -6.095976075139062e-21, -1.078570756447245e-22,  1.575321771479725e+00,
 -6.456511994578384e-03, -5.021362315702947e-05, -4.760491948970072e-08,  3.848213985570497e-09,  3.987334675872124e-11, -7.302816215907945e-14, -5.724537845478851e-15,
 -4.643118447964800e-17,  3.367090001321433e-19,  1.011300419398898e-20,  5.291236536143901e-23,  1.757556349120711e+00, -4.246968948064157e-03, -4.652432882127050e-05,
 -3.135280697787221e-07, -7.096195130032898e-11,  3.083750651837684e-11,  4.300769936470851e-13,  2.230794919587343e-15, -2.444871430610351e-17, -6.639939664577222e-19,
 -6.363906330268577e-21,  1.788486324667878e-24,  1.897056717822242e+00, -1.996486055902546e-03, -2.711851029396806e-05, -2.947702186910175e-07, -2.516505821897229e-09,
 -1.363671654334270e-11,  3.403832689224908e-14,  2.161920068326222e-15,  3.456144106053073e-17,  3.542575252357125e-19,  1.983169312006981e-21, -1.107882976365294e-23,
  1.979975313309801e+00, -4.116302121156016e-04, -6.270696611882540e-06, -8.348612479595266e-08, -1.019633569851308e-09, -1.162271639872280e-11, -1.241585219055306e-13,
 -1.235839018635633e-15, -1.125668007055814e-17, -8.971704587169656e-20, -5.458412127614859e-22, -8.045450753722497e-25,  3.488592509699053e-02, -5.071189292200869e-04,
  5.448234010243277e-06, -5.098815213140233e-08,  4.350562440170802e-10, -3.434769343280666e-12,  2.502606534963061e-14, -1.656063324910151e-16,  9.460532194106294e-19,
 -4.011106562727265e-21,  1.379249010982088e-24,  2.224862483933452e-25,  1.026822888909575e-01, -1.457203477009721e-03,  1.483530969461934e-05, -1.255747733007216e-07,
  8.968024997441335e-10, -5.083940050204280e-12,  1.647811220942569e-14,  8.618815469568830e-17, -2.276086418908185e-18,  2.643525441220702e-20, -2.229414217584342e-22,
  1.341531352248896e-24,  2.032231941433274e-01, -2.777085954784802e-03,  2.586879946710693e-05, -1.816500326100822e-07,  8.285249641239228e-10,  5.061738804738283e-13,
 -6.007197895974022e-14,  7.409997811156089e-16, -5.386492892862973e-18,  1.541591222940510e-20,  2.153771166239329e-22, -4.258655419348830e-24,  3.349949043816707e-01,
 -4.337587608645141e-03,  3.522615803027474e-05, -1.710912153386645e-07, -1.526522896052239e-10,  1.278918827981504e-11, -1.341591968688030e-13,  5.632107409099295e-16,
  4.378023091257150e-18, -1.024091468799585e-19,  8.705809814328908e-22, -1.502842934295517e-24,  4.956698387697758e-01, -5.962451231425938e-03,  3.915005711080997e-05,
 -6.157622040905656e-08, -1.830363389539278e-09,  2.125438141306137e-11, -5.544821120277414e-14, -1.318351682835716e-15,  1.850385774338147e-17, -6.394525941811062e-20,
 -1.192473830720690e-21,  1.925342772022314e-23,  6.818210250410122e-01, -7.429903635339003e-03,  3.427633828723533e-05,  1.381802771117505e-07, -3.171866676076378e-09,
  1.079397640954713e-11,  2.071287171447968e-13, -2.611962423961125e-15, -1.265585076845430e-18,  2.913924092022808e-19, -2.204054247050083e-21, -1.566191754289560e-23,
  8.885168215858882e-01, -8.482786734221964e-03,  1.891427954380327e-05,  3.579178784069869e-07, -2.695256370548322e-09, -2.078715468094449e-11,  3.556824497227991e-13,
  6.427366325449046e-16, -4.351340489542285e-17,  1.281909773880962e-19,  4.737747846422152e-21, -3.955249481622265e-23,  1.108798152041227e+00, -8.856433286292383e-03,
 -5.296144611375965e-06,  4.710954003660502e-07,  2.769332917572760e-10, -4.540901312278739e-11, -3.127343697378746e-15,  5.313615106235736e-15, -3.677216930984571e-18,
 -6.878797873651379e-19,  1.057216627329658e-21,  9.419443688569695e-23,  1.333086360267787e+00, -8.336888676646481e-03, -3.196395242569912e-05,  3.561241687629922e-07,
  4.003435276512082e-09, -2.191669598078580e-11, -5.458563757812778e-13,  6.880920596761350e-16,  7.525144194510548e-17,  1.925676630734914e-19, -1.013744733026906e-20,
 -6.845310654338378e-23,  1.548690244054210e+00, -6.859399595221537e-03, -5.038960151873176e-05,  2.019366442985834e-08,  4.614361210213222e-09,  3.604341757623015e-11,
 -2.517159077972210e-13, -6.934755198335958e-15, -2.662171735599181e-17,  7.701673971403312e-19,  1.104112206326336e-20, -1.818694668076202e-23,  1.739800295192429e+00,
 -4.634181613071573e-03, -5.027125505970518e-05, -3.091492928895212e-07,  6.535091405363500e-10,  4.179667213939089e-11,  4.776478909717656e-13,  1.017945878663348e-15,
 -5.276842756404173e-17, -9.002665263260024e-19, -4.965593632053229e-21,  6.829861791190424e-23,  1.888613481730432e+00, -2.228287925918154e-03, -3.090613194398026e-05,
 -3.371488145569772e-07, -2.775469936975316e-09, -1.195611811681323e-11,  1.120741915381278e-13,  3.485819644834482e-15,  4.855090127771510e-17,  4.153574254163819e-19,
  8.191335617580960e-22, -4.596416138826423e-23,  1.978221700138912e+00, -4.660992392541697e-04, -7.378644366500723e-06, -1.018343364584654e-07, -1.284912406605704e-09,
 -1.506160283522496e-11, -1.643207630768331e-13, -1.651963483551138e-15, -1.488021855615680e-17, -1.113496963692653e-19, -5.064458503094886e-22,  3.278783532922505e-24,
  3.294090646085714e-02, -4.658671695538171e-04,  4.875976183118065e-06, -4.454569806025886e-08,  3.720086340907429e-10, -2.886499195076498e-12,  2.079138531531222e-14,
 -1.376159024028172e-16,  8.046058272360481e-19, -3.802981526245933e-21,  8.099950464911006e-24,  9.457488497564834e-26,  9.708163061935508e-02, -1.344312242768032e-03,
  1.341122156697169e-05, -1.120171931368301e-07,  7.992349013284752e-10, -4.666915859622093e-12,  1.800314297092395e-14,  2.697105849079013e-17, -1.471232171845883e-18,
  1.863954460422299e-20, -1.684351281544706e-22,  1.124526876243096e-24,  1.925152642810915e-01, -2.578629107744696e-03,  2.376863624976350e-05, -1.683842682465562e-07,
  8.258134566122962e-10, -7.054914659940994e-13, -4.164380850286117e-14,  5.788407167587814e-16, -4.716641843543433e-18,  2.082076791593892e-20,  6.715313667001277e-23,
 -2.571495556776404e-24,  3.181951351561802e-01, -4.064013913560604e-03,  3.316629824758933e-05, -1.716567201559812e-07,  7.227885369154150e-11,  9.771266946363536e-12,
 -1.169352481241666e-13,  6.508642019025610e-16,  1.295178549949989e-18, -6.964762247592726e-20,  7.528226556867683e-22, -3.531460960756015e-24,  4.724410940373115e-01,
 -5.652672512583673e-03,  3.824918979850992e-05, -8.754501516019800e-08, -1.421237650305031e-09,  1.954515154579815e-11, -8.447481500784772e-14, -7.706870845961533e-16,
  1.553544073865875e-17, -9.604446025970251e-20, -4.490715143602426e-22,  1.427021111349780e-23,  6.526591393076770e-01, -7.149904985210729e-03,  3.563793346566073e-05,
  8.940271208626621e-08, -2.912185011938126e-09,  1.489192691747299e-11,  1.348762392494863e-13, -2.502667730176103e-15,  7.519016152790504e-18,  1.945933424478174e-19,
 -2.517612822870837e-21,  5.288873922030371e-25,  8.549144320640241e-01, -8.315054113465925e-03,  2.293834240176482e-05,  3.119349964292283e-07, -3.024968559237581e-09,
 -1.218667908789495e-11,  3.551183824925426e-13, -6.429825816266542e-16, -3.595080130487123e-17,  2.783202505398188e-19,  2.688658661158615e-21, -5.056970587461134e-23,
  1.073323499445933e+00, -8.876183337139531e-03,  3.537396415519530e-07,  4.683068706549204e-07, -6.201103775868868e-10, -4.373438576380175e-11,  1.403874124040206e-13,
  4.815695065189765e-15, -2.672887433590141e-17, -5.684008565887091e-19,  4.722864622302032e-21,  6.779482827157989e-23,  1.299255935395467e+00, -8.574455286826158e-03,
 -2.732287352539309e-05,  4.159721648592391e-07,  3.437079302665964e-09, -3.451045768093814e-11, -4.924212985739499e-13,  3.124089949455683e-15,  7.434199195869737e-17,
 -2.526441855315838e-19, -1.156379218993545e-20,  7.851626703360379e-24,  1.520449787820352e+00, -7.260239685339649e-03, -4.968175724236390e-05,  9.939475978372402e-08,
  5.258711807746827e-09,  2.760448971487360e-11, -4.530572849928992e-13, -7.261099334057593e-15,  8.594304883071585e-18,  1.166129307820382e-18,  7.978658472776543e-21,
 -1.243785963592570e-22,  1.720436073158901e+00, -5.050945454748134e-03, -5.388868895533284e-05, -2.913769639266913e-07,  1.605269127771544e-09,  5.338029898008222e-11,
  4.774065790400251e-13, -1.220020571989280e-15, -8.777776177148145e-17, -1.010730784900475e-18,  1.925581659145970e-22,  1.708480874561224e-22,  1.879179120278155e+00,
 -2.492492097997126e-03, -3.522568180361969e-05, -3.832866458982554e-07, -2.978822246902420e-09, -7.905614679754393e-12,  2.336934085152652e-13,  5.280108534348594e-15,
  6.345819945718652e-17,  3.909349664438929e-19, -2.517993916729507e-21, -1.116948971687446e-22,  1.976230980018939e+00, -5.303903064515896e-04, -8.734688151204956e-06,
 -1.250338091689873e-07, -1.629622378467942e-09, -1.961800207655996e-11, -2.178702934055446e-13, -2.195760359061644e-15, -1.919747515033710e-17, -1.262789940677202e-19,
 -1.642640385459590e-22,  1.379251308207648e-23,  3.115220520949187e-02, -4.289005848786937e-04,  4.375319911464687e-06, -3.902954717524068e-08,  3.189709781645801e-10,
 -2.430959530278756e-12,  1.727850701289110e-14, -1.139899071782587e-16,  6.743018875609885e-19, -3.420583760119212e-21,  1.047771043129983e-23,  1.970340185328638e-26,
  9.191074563363082e-02, -1.242188843886871e-03,  1.214073816827331e-05, -9.995249660020844e-08,  7.102534836807012e-10, -4.230522276252030e-12,  1.819136615722990e-14,
 -1.057991992249878e-17, -9.102264906135308e-19,  1.281800871885614e-20, -1.244907735479456e-22,  8.711534727211230e-25,  1.825685641117731e-01, -2.396339240372248e-03,
  2.182667593261313e-05, -1.553332223727409e-07,  8.029367694870508e-10, -1.526801695616431e-12, -2.743411297736953e-14,  4.402211939311263e-16, -3.942535117768606e-18,
  2.161842803023132e-20, -1.893674556505335e-23, -1.426037824725636e-24,  3.024567404897350e-01, -3.806889497641204e-03,  3.111932854973236e-05, -1.690830865543307e-07,
  2.411309977801164e-10,  7.186077922670521e-12, -9.846814849043537e-14,  6.576849273400069e-16, -7.098530413647385e-19, -4.287800952295661e-20,  5.819246253810244e-22,
 -4.056135679503363e-24,  4.504352300746127e-01, -5.351238771070669e-03,  3.707473607510775e-05, -1.072741166469450e-07, -1.052080083004391e-09,  1.731169108665801e-11,
 -9.963205983852647e-14, -3.312125294912797e-16,  1.189073095515760e-17, -1.031067645859811e-19,  5.523882154743198e-23,  8.700700960611313e-24,  6.246354337706318e-01,
 -6.861278639260246e-03,  3.644153088390567e-05,  4.534307868881119e-08, -2.587486758473383e-09,  1.732103228712957e-11,  6.908595782507514e-14, -2.169150269524315e-15,
  1.274923839158440e-17,  9.776569885905166e-20, -2.251540084747246e-21,  1.044678747161051e-23,  8.220437538802574e-01, -8.117412840517512e-03,  2.638460010547288e-05,
  2.620403701845289e-07, -3.185562220247147e-09, -3.999985730780316e-12,  3.226379897986360e-13, -1.616679062397536e-15, -2.452853422551338e-17,  3.419176985035563e-19,
  5.303797323335274e-22, -4.530835354826415e-23,  1.037859693254112e+00, -8.851108427395339e-03,  5.885740374286591e-06,  4.516145463352526e-07, -1.450757686304528e-09,
 -3.886113874571637e-11,  2.604662678843136e-13,  3.674524097002415e-15, -4.318620379261537e-17, -3.325628224217129e-19,  6.732419146008558e-21,  2.190779012094339e-23,
  1.264553807783520e+00, -8.772193186404114e-03, -2.202601221481793e-05,  4.648360821867947e-07,  2.637116626579655e-09, -4.502160465234537e-11, -3.736339164355479e-13,
  5.270442839950496e-15,  5.723640445942658e-17, -6.828559730631841e-19, -9.332337336422180e-21,  9.155912674904989e-23,  1.490623544380907e+00, -7.651454643805466e-03,
 -4.796806494857904e-05,  1.872920298585916e-07,  5.685931957730279e-09,  1.436315363709194e-11, -6.458391698318988e-13, -6.265443952528122e-15,  5.470687811417783e-17,
  1.343911883164143e-18,  1.737093894685058e-22, -2.244786700062053e-22,  1.699348656060075e+00, -5.495519327155847e-03, -5.719390553806225e-05, -2.565470238494389e-07,
  2.782904093128411e-09,  6.407755907961078e-11,  3.985571560282849e-13, -4.592886724215967e-15, -1.219082574364389e-16, -8.192924257517473e-19,  1.017658395201381e-20,
  2.790784934005151e-22,  1.868615254300478e+00, -2.793515320885721e-03, -4.011517144482175e-05, -4.318534113866422e-07, -3.067635129321730e-09, -2.813497368513717e-13,
  4.118793618855027e-13,  7.505289715268575e-15,  7.428669331426886e-17,  1.641737993956339e-19, -9.573505946987566e-21, -2.149268483793641e-22,  1.973959493665844e+00,
 -6.067444659890120e-04, -1.040546601544373e-05, -1.545529569381993e-07, -2.079627916124207e-09, -2.565829338330605e-11, -2.886360816340183e-13, -2.882574147030860e-15,
 -2.366497939374927e-17, -1.149166297073881e-19,  9.082502015158131e-22,  3.816156022097676e-23,  2.950375953422131e-02, -3.956882376347306e-04,  3.936052247762439e-06,
 -3.429347662140309e-08,  2.742522292654821e-10, -2.052248561435626e-12,  1.437094643461327e-14, -9.430087585108909e-17,  5.587699031598511e-19, -2.999664488015559e-21,
  1.021676414052636e-23, -2.876665126768668e-26,  8.712891013166860e-02, -1.149673746429109e-03,  1.100677683264180e-05, -8.924175768329595e-08,  6.299696504013333e-10,
 -3.800381929604828e-12,  1.755027811139982e-14, -3.321459547702877e-17, -5.298589934409962e-19,  8.529831732262511e-21, -9.176499835063863e-23,  6.178291497822183e-25,
  1.733209336397044e-01, -2.228965962147625e-03,  2.003864647675260e-05, -1.427623528594954e-07,  7.667443155713407e-10, -2.050851171916770e-12, -1.675885785880197e-14,
  3.262577684017176e-16, -3.190872801592840e-18,  1.983661662972728e-20, -6.521144106481919e-23, -7.455342526042826e-25,  2.877143474233481e-01, -3.565975150311844e-03,
  2.911782392855790e-05, -1.641974223650841e-07,  3.626930689361825e-10,  5.039983361059825e-12, -8.057302791177217e-14,  6.144165666743483e-16, -1.877242430796161e-18,
 -2.313595940511549e-20,  4.069395640084566e-22, -3.822019540343975e-24,  4.296149475497440e-01, -5.060050748828232e-03,  3.569744500905737e-05, -1.214698708251940e-07,
 -7.303013754801344e-10,  1.484883347797166e-11, -1.041300481438100e-13, -9.014264980750945e-18,  8.297181012309685e-18, -9.473472671135462e-20,  3.283448360357899e-22,
  3.899901773397938e-24,  5.977758715145847e-01, -6.568246906572446e-03,  3.674891845138533e-05,  6.784958647945911e-09, -2.229155243771398e-09,  1.829901677260481e-11,
  1.447228281380732e-14, -1.721248411105885e-15,  1.477256616529063e-17,  1.836002999106514e-20, -1.693155814051501e-21,  1.398951647268827e-23,  7.900149432590543e-01,
 -7.894628003801182e-03,  2.922194783179049e-05,  2.108352567252062e-07, -3.192205337040979e-09,  3.122854151688844e-12,  2.682403555764909e-13, -2.204226417528239e-15,
 -1.228309617950345e-17,  3.271982125238527e-19, -1.157770532977126e-21, -3.052817797333642e-23,  1.002583122104733e+00, -8.782796312702077e-03,  1.114138259692916e-05,
  4.225563379523469e-07, -2.157981871687582e-09, -3.154064287133560e-11,  3.425829517758914e-13,  2.154013665715998e-15, -5.020845296076133e-17, -5.812925362646937e-20,
  6.653434221564541e-21, -2.393725655971678e-23,  1.229148865147235e+00, -8.925443191579410e-03, -1.622596314540941e-05,  4.993928565396228e-07,  1.659930316262880e-09,
 -5.203605574586335e-11, -2.045773059995557e-13,  6.645708074682309e-15,  2.708284567941426e-17, -9.566864655957222e-19, -3.973665890614160e-21,  1.440641629984302e-22,
  1.459266675908458e+00, -8.024646491719006e-03, -4.516811263183525e-05,  2.796673525116517e-07,  5.805194236338305e-09, -3.000103519107575e-12, -7.895976037675286e-13,
 -3.759816246050168e-15,  1.006712854380844e-16,  1.136897943922514e-18, -1.076271772644858e-20, -2.563855216955998e-22,  1.676433179684726e+00, -5.964527354629957e-03,
 -5.996147559568063e-05, -2.013004020763675e-07,  4.147310676375025e-09,  7.163507677321836e-11,  2.116133326399401e-13, -8.861957768875281e-15, -1.409231503509583e-16,
 -1.468945374413314e-19,  2.373267887213375e-20,  3.170126474170257e-22,  1.856765355730463e+00, -3.135996616644606e-03, -4.559014431185953e-05, -4.803671754701347e-07,
 -2.955988850963162e-09,  1.239647386772127e-11,  6.555517444960836e-13,  9.882458726364407e-15,  7.069484936029552e-17, -4.442567225583716e-19, -2.175274195805151e-20,
 -3.379647279530505e-22,  1.971353429070505e+00, -6.980139834250417e-04, -1.247797823923644e-05, -1.923377394076713e-07, -2.669061381841602e-09, -3.364315457240519e-11,
 -3.804995273451160e-13, -3.695033616111211e-15, -2.663166792812370e-17, -3.224479646791015e-20,  3.606361412524940e-21,  9.088252072267740e-23,  2.798147846367622e-02,
 -3.657743119050075e-04,  3.549562592961748e-06, -3.021592365258011e-08,  2.364524397011574e-10, -1.737107464275159e-12,  1.196516126613389e-14, -7.807232804946013e-17,
  4.577307901927168e-19, -2.627317036571279e-21,  8.158040867900477e-24, -6.171362278870572e-26,  8.269977567930067e-02, -1.065737413984403e-03,  9.993917767670906e-06,
 -7.974776610146079e-08,  5.580899616536189e-10, -3.391991683408400e-12,  1.642429221099501e-14, -4.591642868808719e-17, -2.829518306413420e-19,  5.332368980969427e-21,
 -6.977416743739818e-23,  3.905593079670624e-25,  1.647151283548176e-01, -2.075304073485912e-03,  1.839768935050868e-05, -1.308415268979132e-07,  7.223882176432032e-10,
 -2.354338945649683e-12, -8.949718736218099e-15,  2.350157004203846e-16, -2.530484971514222e-18,  1.669208462493842e-20, -8.950231135163389e-23, -3.959382794589583e-25,
  2.739040015500289e-01, -3.340808375969413e-03,  2.718527511215125e-05, -1.576872848496584e-07,  4.455107417928803e-10,  3.305221277045683e-12, -6.431504780852487e-14,
  5.438393249568776e-16, -2.456405763948822e-18, -1.008015085422442e-20,  2.497151270641632e-22, -3.290907723848275e-24,  4.099364201763800e-01, -4.780478694863504e-03,
  3.417905899063669e-05, -1.309142505036876e-07, -4.581943234755679e-10,  1.237363251067683e-11, -1.011583445460600e-13,  2.047289399224748e-16,  5.153984608510359e-18,
 -7.930319385051736e-20,  4.177482951180155e-22,  4.072806296172609e-25,  5.720905629759067e-01, -6.274508351493952e-03,  3.662843508239787e-05, -2.595023248262127e-08,
 -1.863328296144460e-09,  1.812160298583831e-11, -2.709140113868092e-14, -1.249816476153666e-15,  1.436271830172460e-17, -3.711802188283805e-20, -1.088785058946496e-21,
  1.293223356532417e-23,  7.589187890723470e-01, -7.651593696357679e-03,  3.144865436812467e-05,  1.605877658660961e-07, -3.070554472007379e-09,  8.786091762008244e-12,
  2.027125130522687e-13, -2.420085835714500e-15, -1.615827039011432e-18,  2.590083982625953e-19, -2.129631056473122e-21, -1.383835776396942e-23,  9.676614251490276e-01,
 -8.674014469679466e-03,  1.598557078735847e-05,  3.834460859448872e-07, -2.702629530399341e-09, -2.277661755686882e-11,  3.804384200996585e-13,  5.625203342470811e-16,
 -4.786090257596578e-17,  1.766361681089590e-19,  4.866761210365489e-21, -5.376956760669666e-23,  1.193225962167233e+00, -9.030909046750416e-03, -1.010892728483769e-05,
  5.174238170740535e-07,  5.855512085341686e-10, -5.464762868815765e-11, -1.168735837679551e-14,  6.943310697837039e-15, -8.653539337278379e-18, -9.855664087909542e-19,
  2.503313530096866e-21,  1.405395950496978e-22,  1.426468869430883e+00, -8.370999746171294e-03, -4.126020212796522e-05,  3.710120151765162e-07,  5.549190758626180e-09,
 -2.281540372327910e-11, -8.443355634039765e-13,  1.211233215246952e-17,  1.312557623562772e-16,  4.961251256107723e-19, -2.067624241969510e-20, -1.742230953731760e-22,
  1.651602125653439e+00, -6.452643288178676e-03, -6.193101817406876e-05, -1.232994019510574e-07,  5.608072163517230e-09,  7.322892140916568e-11, -9.899112421360710e-14,
 -1.324677407939418e-14, -1.259564868865077e-16,  1.057080031234189e-18,  3.547886022682530e-20,  1.803881453836358e-22,  1.843454316379158e+00, -3.524554543146126e-03,
 -5.162710703318214e-05, -5.247262957962585e-07, -2.527079388859903e-09,  3.168431849593457e-11,  9.601528704990225e-13,  1.168999534218006e-14,  3.519152875282839e-17,
 -1.639373684869759e-18, -3.848401486381739e-20, -4.010611165968639e-22,  1.968346011194313e+00, -8.078505484051550e-04, -1.506617300978950e-05, -2.409587091558565e-07,
 -3.442122613843794e-09, -4.411283140524680e-11, -4.958149628107850e-13, -4.528667710997324e-15, -2.400028489096665e-17,  2.183801060354998e-19,  9.700159579038474e-21,
  1.979774501179377e-22,  2.657296524725195e-02, -3.387664030404304e-04,  3.208573031723733e-06, -2.669573380999049e-08,  2.044130520529082e-10, -1.474606021383572e-12,
  9.970397453679677e-15, -6.488083966526469e-17,  3.683364313337102e-19, -2.357758545898968e-21,  5.381319939168931e-24, -5.164638480984462e-26,  7.859087555896963e-02,
 -9.894671830647159e-04,  9.088350638368438e-06, -7.134008155068770e-08,  4.940832169277031e-10, -3.014100850142670e-12,  1.503706821911221e-14, -5.240740358738104e-17,
 -1.375108142576955e-19,  2.840848509308139e-21, -5.550689333616363e-23,  2.988193994233169e-25,  1.566986037306828e-01, -1.934210106331838e-03,  1.689535436126314e-05,
 -1.196696004917422e-07,  6.736414958911293e-10, -2.498787369039557e-12, -3.417699348848639e-15,  1.629345159264375e-16, -1.997480983391941e-18,  1.284574725646358e-20,
 -1.004337233898216e-22, -5.731534986197649e-26,  2.609639252582681e-01, -3.130769481721981e-03,  2.533772025799566e-05, -1.501091305241070e-07,  4.973658843365446e-10,
  1.935234609366061e-12, -5.023040577268663e-14,  4.610852547215257e-16, -2.672448884164867e-18, -2.766477191915653e-21,  1.225036997596087e-22, -2.377631014963454e-24,
  3.913512686416006e-01, -4.513436773986474e-03,  3.257184669527257e-05, -1.363952372914088e-07, -2.344498068103329e-10,  1.003073540123415e-11, -9.352315274677077e-14,
  3.271957701808381e-16,  2.597931479949448e-18, -6.289009704961360e-20,  3.906097728785514e-22, -1.257725518066995e-24,  5.475759327545047e-01, -5.983206047312070e-03,
  3.614996829909949e-05, -5.291033835210404e-08, -1.509970593585213e-09,  1.710189810074372e-11, -5.590635844362596e-14, -8.189291160406071e-16,  1.237244241326590e-17,
 -7.008975817486681e-20, -5.798976057531498e-22,  1.024318471469239e-23,  7.288266379652246e-01, -7.393116481672267e-03,  3.308752643186994e-05,  1.131059661428203e-07,
 -2.851666245428744e-09,  1.284020376894253e-11,  1.355051851882163e-13, -2.339966625410323e-15,  6.069003535782310e-18,  1.660625414300571e-19, -2.413592117672555e-21,
  4.771188219630574e-25,  9.332491989291167e-01, -8.528490989631545e-03,  2.031405311400952e-05,  3.370581753966741e-07, -3.066445847790730e-09, -1.362305436215486e-11,
  3.759430233798578e-13, -8.345978212584475e-16, -3.860494308768623e-17,  3.202879804329157e-19,  2.268081283154609e-21, -6.031556781956750e-23,  1.156980022962597e+00,
 -9.086867690841634e-03, -3.879567010327278e-06,  5.180989020808001e-07, -4.947562941023852e-10, -5.265827033345694e-11,  1.737190449376748e-13,  6.129410559818369e-15,
 -4.095471187373986e-17, -7.748198521410787e-19,  7.638647222181780e-21,  8.686792851758235e-23,  1.392354980324349e+00, -8.681805203396046e-03, -3.629393905893107e-05,
  4.550563961387256e-07,  4.892770724701986e-09, -4.259029113491099e-11, -7.837201078232900e-13,  4.326244750106169e-15,  1.328145792973391e-16, -4.354968888884138e-19,
 -2.455159746759813e-20,  1.032331532793166e-23,  1.624793583848619e+00, -6.952374597437840e-03, -6.282468623956622e-05, -2.211645895333304e-08,  7.016681010709852e-09,
  6.599200651737969e-11, -5.185907017935289e-13, -1.638425384312858e-14, -6.124996986296694e-17,  2.543257593478092e-18,  3.616478930172283e-20, -1.837520424917584e-22,
  1.828489289320715e+00, -3.963388773575777e-03, -5.814114702392314e-05, -5.587252668618337e-07, -1.636058556922272e-09,  5.871708768916110e-11,  1.292053352090851e-12,
  1.154139962673893e-14, -5.558331730895606e-17, -3.504637543259514e-18, -5.348852553218525e-20, -2.191589096466701e-22,  1.964853821634064e+00, -9.409536798922816e-04,
 -1.831945137704203e-05, -3.037818179919060e-07, -4.454052282398037e-09, -5.761039233278010e-11, -6.315413094218251e-13, -5.076073309086754e-15, -6.606090416811481e-18,
  8.314801964618064e-19,  2.241703796518651e-20,  3.994898686056647e-22,  2.526728357010666e-02, -3.143257735639598e-04,  2.906915121825754e-06, -2.364865523591283e-08,
  1.771732330582785e-10, -1.255861567208299e-12,  8.306266107502261e-15, -5.441351235145340e-17,  2.870327528055883e-19, -2.157852284800062e-21,  5.733602644189666e-24,
  1.050213556920142e-25,  7.477318243584062e-02, -9.200547677860052e-04,  8.277774476191221e-06, -6.389790467820187e-08,  4.372890138799442e-10, -2.671237483051370e-12,
  1.352053653773516e-14, -5.557157395294426e-17, -7.158561715457796e-20,  9.416995113028148e-22, -3.684986880659925e-23,  6.648121763821240e-25,  1.492232477285720e-01,
 -1.804612001698664e-03,  1.552232903976733e-05, -1.092941728274785e-07,  6.231794197359473e-10, -2.532889377356052e-12,  3.136179479189974e-16,  1.056460814205388e-16,
 -1.606029991829194e-18,  9.004495790652944e-21, -8.395194763829288e-23,  1.016134090592075e-24,  2.488350369179667e-01, -2.935135137314596e-03,  2.358523447146149e-05,
 -1.419029244969658e-07,  5.250107955454814e-10,  8.749031701374512e-13, -3.852655308958290e-14,  3.747431254219094e-16, -2.704544099880047e-18,  5.635720459708235e-22,
  6.059521876732890e-23, -6.732817645848357e-26,  3.738082341491011e-01, -4.259458271710983e-03,  3.091883077138986e-05, -1.386602125664374e-07, -5.549851853045505e-11,
  7.903524827395441e-12, -8.351727176285280e-14,  3.770166755243090e-16,  6.028106286527619e-19, -4.820250502107810e-20,  3.556593686005190e-22,  4.204557395691402e-25,
  5.242169406757605e-01, -5.696931223460083e-03,  3.538111873380449e-05, -7.441348860884717e-08, -1.182986680469554e-09,  1.552725381593576e-11, -7.369979994438695e-14,
 -4.670054614225953e-16,  9.536471598318480e-18, -8.462763367306333e-20, -1.468872288036510e-22,  1.035236014993901e-23,  6.997911005202382e-01, -7.123742280718261e-03,
  3.418002519890981e-05,  6.968862016186128e-08, -2.567513522139328e-09,  1.533290794401982e-11,  7.347228900782876e-14, -2.068467965764659e-15,  1.034962901699361e-17,
  7.380713535438126e-20, -2.100897373911331e-21,  1.409331186701743e-23,  8.994846753783420e-01, -8.350651416780843e-03,  2.405694173771221e-05,  2.862952675710464e-07,
 -3.251247841705597e-09, -5.009287638434409e-12,  3.371082604401073e-13, -1.872974874855164e-15, -2.605220805701171e-17,  3.614614223734299e-19, -7.754982973976982e-23,
 -4.219777107827420e-23,  1.120609561323052e+00, -9.093248344360282e-03,  2.256254889557745e-06,  5.020393873376756e-07, -1.493194150219471e-09, -4.660112638311378e-11,
  3.232591980270006e-13,  4.437780762917646e-15, -6.261424028368684e-17, -4.133288124848222e-19,  9.939441878191586e-21,  1.954150655962245e-23,  1.357083426171163e+00,
 -8.949054313413862e-03, -3.039484354545254e-05,  5.255538849589647e-07,  3.865080162547511e-09, -5.948686806882468e-11, -6.067685746221062e-13,  8.140648953447816e-15,
  1.001524127440539e-16, -1.344429428946014e-18, -1.932407685075988e-20,  2.245683005053968e-22,  1.595980029788526e+00, -7.454030012313681e-03, -6.237555139769589e-05,
  9.987413052135142e-08,  8.174148887719095e-09,  4.791327656295833e-11, -9.891675900139103e-13, -1.662428370564620e-14,  5.312752656134478e-17,  3.688297254158590e-18,
  1.761805426023019e-20, -6.543131808762674e-22,  1.811662516606156e+00, -4.455681049090025e-03, -6.495841298241043e-05, -5.737180146988753e-07, -1.270363762114729e-10,
  9.327163404354560e-11,  1.568332488409450e-12,  7.320964215599976e-15, -2.212124426170335e-16, -5.677422740721213e-18, -5.006045337736347e-20,  4.831406510018123e-22,
  1.960771975434257e+00, -1.103395478830613e-03, -2.243324486538911e-05, -3.851361788243339e-07, -5.769323119829351e-09, -7.446204265794835e-11, -7.706731619772546e-13,
 -4.595995621928514e-15,  4.449158916133712e-17,  2.168337922476903e-18,  4.688493015348182e-20,  7.370803980018561e-22,  2.405475942337232e-02, -2.921592379592813e-04,
  2.639344733979233e-06, -2.100449023139483e-08,  1.539311620039878e-10, -1.073826074691069e-12,  6.899997315957149e-15, -4.641199857086809e-17,  2.155481935007769e-19,
 -1.725849752762367e-21,  1.926771991418627e-23,  5.731602042521296e-25,  7.122071422244902e-02, -8.567846771685683e-04,  7.551272003352783e-06, -5.731158105777088e-08,
  3.869819201644153e-10, -2.365652642804858e-12,  1.193594178154332e-14, -5.753046334304642e-17, -5.453366746981123e-20,  3.579087355113850e-22,  1.727679524680142e-23,
  1.988665610636236e-24,  1.422450848632106e-01, -1.685513827627361e-03,  1.426895631236689e-05, -9.972725055545530e-08,  5.728076879053525e-10, -2.495393668423457e-12,
  2.597008650907588e-15,  5.891724513572412e-17, -1.325547217424306e-18,  7.229853600523580e-21,  1.631844424746872e-23,  3.921135423222800e-24,  2.374612784650330e-01,
 -2.753120778527899e-03,  2.193322443893591e-05, -1.334096138667044e-07,  5.340620049197017e-10,  6.643660843919389e-14, -2.923867197547056e-14,  2.890585034762015e-16,
 -2.629745674266971e-18,  4.255258341789533e-21,  1.637722692599248e-22,  5.408652804737349e-24,  3.572545578362171e-01, -4.018767087630454e-03,  2.925445377077027e-05,
 -1.383889225504188e-07,  8.338773300336681e-11,  6.026464974621061e-12, -7.293138455188237e-14,  3.714175081290335e-16, -8.571377268990522e-19, -3.188359907305158e-20,
  5.152982903797588e-22,  7.991791731739784e-24,  5.019892342956721e-01, -5.417752936057659e-03,  3.438451609534495e-05, -9.095688117719771e-08, -8.910225249307003e-10,
  1.363319663422227e-11, -8.296412930236950e-14, -2.107391332676282e-16,  6.508068425675014e-18, -7.969436259801499e-20,  4.540022887886905e-22,  1.869566170318315e-23,
  6.718473536058915e-01, -6.847631555496821e-03,  3.478018528240701e-05,  3.113848445583797e-08, -2.247711466694965e-09,  1.644057251543769e-11,  2.048408375450937e-14,
 -1.709479231819746e-15,  1.168888026970231e-17,  7.284491058743947e-21, -1.082103583500294e-21,  3.383128854225956e-23,  8.664874841836893e-01, -8.145342902459864e-03,
  2.717843050581275e-05,  2.338940328125710e-07, -3.275211695753742e-09,  2.369709705458990e-12,  2.749274919038153e-13, -2.502056055310729e-15, -1.344675507817446e-17,
  3.321421503259031e-19, -1.073063049782830e-21,  1.052114228648789e-24,  1.084310159927330e+00, -9.051574465846257e-03,  8.108094902796394e-06,  4.711516560205935e-07,
 -2.338787986371204e-09, -3.758920511295913e-11,  4.177813513565953e-13,  2.273584842716746e-15, -7.025973457758332e-17, -1.202246122065621e-20,  9.889410109124281e-21,
 -1.240153182492617e-23,  1.320842192517820e+00, -9.166030324995475e-03, -2.375874746216976e-05,  5.771694360540512e-07,  2.549845506606722e-09, -7.100141917976595e-11,
 -3.421735139499748e-13,  1.044457224054870e-14,  4.071542283987165e-17, -1.866567675026091e-18, -5.611398011341943e-21,  3.847622942444863e-22,  1.565176714750993e+00,
 -7.945953414898144e-03, -6.036531962734015e-05,  2.368835625837292e-07,  8.858836644113727e-09,  1.890563497236110e-11, -1.410274673911525e-12, -1.272660436883025e-14,
  1.906850542123211e-16,  3.716289076783977e-18, -1.798662220147666e-20, -8.904829055196297e-22,  1.792757010446683e+00, -5.002766032977717e-03, -7.178689047897956e-05,
 -5.587292689562098e-07,  2.126418701778975e-09,  1.323702845389563e-10,  1.641075624279546e-12, -3.352303087549989e-15, -4.533269518510530e-16, -6.894447193312806e-18,
 -7.012073166128680e-22,  1.862076199948893e-21,  1.955967818138228e+00, -1.303037143505947e-03, -2.766124458815539e-05, -4.904040286778554e-07, -7.452759124760406e-09,
 -9.425479372041797e-11, -8.647087065655416e-13, -1.490329823468140e-15,  1.652865014749201e-16,  4.821137174401767e-18,  8.906878146643945e-20,  1.188149964213518e-21,
  2.292681267466717e-02, -2.720124022403736e-04,  2.401387488143810e-06, -1.870483470610292e-08,  1.340091859771240e-10, -9.230917862955643e-13,  5.689094830579446e-15,
 -4.029774302293979e-17,  1.753290928402260e-19, -2.314706418774556e-22,  6.132175074345462e-23,  1.370588835035070e-24,  6.791018417000622e-02, -7.990236953537036e-04,
  6.899170877145073e-06, -5.148336129036050e-08,  3.424020786107895e-10, -2.098695884579466e-12,  1.030471738097032e-14, -5.872778361843369e-17, -2.405770727640016e-21,
  3.438928156015222e-21,  1.539877516688981e-22,  4.326228646795981e-24,  1.357239685707468e-01, -1.575997050015026e-03,  1.312558418560081e-05, -9.095772617952850e-08,
  5.236330170881096e-10, -2.417807667029274e-12,  3.695208783294186e-15,  2.120595431505068e-17, -9.998682196458685e-19,  1.268351247894940e-20,  2.925133595671301e-22,
  8.832064128598190e-24,  2.267897927280447e-01, -2.583913513367881e-03,  2.038350648122487e-05, -1.248895360376550e-07,  5.289807057738860e-10, -5.474761434603519e-13,
 -2.228772297364184e-14,  2.092306053938414e-16, -2.279254095331909e-18,  1.802685814689327e-20,  5.903826301345470e-22,  1.432178962772845e-23,  3.416370865286002e-01,
 -3.791342884645545e-03,  2.760547082780352e-05, -1.361821188445287e-07,  1.872359405329627e-10,  4.396911208735443e-12, -6.305485188230769e-14,  3.305055460796057e-16,
 -1.515943995685601e-18, -5.141080513514369e-22,  1.153793510249493e-21,  2.166114992192398e-23,  4.808611463586500e-01, -5.147265084485456e-03,  3.321613829463758e-05,
 -1.031417305583024e-07, -6.386369671917065e-10,  1.159230148875049e-11, -8.634488245709463e-14, -4.299765543016138e-17,  4.206528128262458e-18, -4.031333923395640e-20,
  1.646997689160985e-21,  3.660204911248883e-23,  6.450148468227166e-01, -6.568481717996074e-03,  3.494896146334058e-05, -2.183209175124131e-09, -1.917642295644511e-09,
  1.640009683395216e-11, -2.214568505787787e-14, -1.336209349752502e-15,  1.160331449402265e-17,  1.860288606555218e-21,  1.024527730274714e-21,  6.289166142591812e-23,
  8.343574932622183e-01, -7.917573592602057e-03,  2.967339699273246e-05,  1.822037490443237e-07, -3.167714992415039e-09,  8.089428539731796e-12,  2.005898424343042e-13,
 -2.748197955505043e-15, -2.092460665650542e-18,  3.077784143558402e-19,  3.148141594342670e-22,  6.369509044621027e-23,  1.048268430252464e+00, -8.964784084657050e-03,
  1.351439514119383e-05,  4.282786574959917e-07, -2.986452921869809e-09, -2.705028142552490e-11,  4.504392469805393e-13,  9.381828621065130e-17, -6.366911348770193e-17,
  3.773551043344080e-19,  9.809493368075165e-21,  1.860994213391589e-23,  1.283842629949179e+00, -9.327812933217090e-03, -1.663595903122792e-05,  6.062618202951293e-07,
  1.071878279775546e-09, -7.561976580227745e-11, -4.169529489472284e-14,  1.066382980231033e-14, -2.618924754712336e-17, -1.726230759693899e-18,  1.308834590313978e-20,
  4.476794984983046e-22,  1.532448483090572e+00, -8.415079714442573e-03, -5.666604569270150e-05,  3.797036198176909e-07,  8.873683486326642e-09, -1.841078650410102e-11,
 -1.662503524078328e-12, -4.697207374792191e-15,  3.024987465646975e-16,  2.269083277431414e-18, -5.175182130636301e-20, -5.306714530679801e-22,  1.771555991623547e+00,
 -5.603086958147955e-03, -7.819337376218737e-05, -5.014516710369499e-07,  5.150648212485817e-09,  1.687654760442588e-10,  1.307842086927116e-12, -2.164571079458751e-14,
 -6.778166844834381e-16, -4.794676578915977e-18,  1.173984353512749e-19,  3.443217121619995e-21,  1.950272758945658e+00, -1.550044255997653e-03, -3.432742637400765e-05,
 -6.258576407318962e-07, -9.544897657398375e-09, -1.147232538865469e-10, -8.007667018003553e-13,  7.372952041203989e-15,  4.166552155981530e-16,  9.542862837224895e-18,
  1.490696823923106e-19,  1.454192709594880e-21,  2.187581336617691e-02, -2.536640406621046e-04,  2.189208123082147e-06, -1.670133597247142e-08,  1.168246534170053e-10,
 -7.994471560522228e-13,  4.642179574768245e-15, -3.421543465414169e-17,  2.277256121136939e-19,  3.643172629238331e-21,  1.364418924717666e-22,  1.897540470846069e-24,
  6.482069077037378e-02, -7.462115017990347e-04,  6.312898005232768e-06, -4.632783930721174e-08,  3.027687256776140e-10, -1.870957022709154e-12,  8.688707134973081e-15,
 -5.522229563328043e-17,  2.841700438056939e-19,  1.404123617453119e-20,  3.879679513555209e-22,  5.871805283643373e-24,  1.296232732006269e-01, -1.475219562208292e-03,
  1.208278050530376e-05, -8.296148539161601e-08,  4.761952731381183e-10, -2.325089916605574e-12,  3.930602579195348e-15, -3.810335329073923e-19, -2.263865682359060e-19,
  3.348701669402821e-20,  7.725826609516357e-22,  1.208967787226504e-23,  2.167709849785068e-01, -2.426697288162084e-03,  1.893516382496899e-05, -1.165406509822195e-07,
  5.131173145750367e-10, -1.019525779248476e-12, -1.731241155018352e-14,  1.526219513964655e-16, -1.030462445081041e-18,  5.666408855886933e-20,  1.387418928471513e-21,
  2.034510726618965e-23,  3.269031327379017e-01, -3.576978767217106e-03,  2.599190403594444e-05, -1.325620104340424e-07,  2.607635061546168e-10,  2.989515044883009e-12,
 -5.440711645432179e-14,  2.927124713866953e-16, -4.379987125416791e-19,  6.851332263100803e-20,  2.370707088483775e-21,  3.124920418697298e-23,  4.607954825335968e-01,
 -4.886643602630759e-03,  3.192441409037997e-05, -1.116178952506809e-07, -4.275363818423125e-10,  9.519985672806269e-12, -8.577194338670145e-14,  8.458286618428428e-17,
  4.377948031077129e-18,  6.292840522435422e-20,  3.612493413959864e-21,  4.929621673625580e-23,  6.192992335917233e-01, -6.289491738579573e-03,  3.474936688254399e-05,
 -3.028230953973624e-08, -1.597767251891574e-09,  1.546207964188567e-11, -5.426099424757135e-14, -9.500160947550736e-16,  1.314826205497281e-17,  1.059300839251442e-19,
  4.323498910052758e-21,  8.177081259587904e-23,  8.031746225194815e-01, -7.672288389837544e-03,  3.156185613264432e-05,  1.330500210922112e-07, -2.964012618763339e-09,
  1.198310464702658e-11,  1.244229861032689e-13, -2.628889771694158e-15,  1.005042309798233e-17,  3.935756377851770e-19,  4.325516273668423e-21,  1.103622865516615e-22,
  1.012656877200605e+00, -8.836961175216096e-03,  1.835108189489233e-05,  3.767516773662712e-07, -3.420266888913131e-09, -1.642312514428800e-11,  4.271390123944052e-13,
 -1.647850891027691e-15, -4.266375220463330e-17,  8.036302480332250e-19,  1.190950710083217e-20,  7.192837757269138e-23,  1.246311538987898e+00, -9.431623287817882e-03,
 -9.307730272098141e-06,  6.113574631084279e-07, -4.270552110279793e-10, -7.318496423397000e-11,  2.367593620598920e-13,  8.970787139417629e-15, -7.421213654525249e-17,
 -8.161719200626570e-19,  3.196425616278515e-20,  3.841548425239038e-22,  1.497913717661639e+00, -8.847810872622791e-03, -5.127697517167919e-05,  5.165447061898139e-07,
  8.101732099327578e-09, -5.873498159169947e-11, -1.649270927771105e-12,  5.858486264142205e-15,  3.434548034637527e-16, -2.512451196696475e-20, -5.628539998991563e-20,
  3.728920705273720e-22,  1.747856768028522e+00, -6.251036256693689e-03, -8.360009494820990e-05, -3.905852245933676e-07,  8.777546154550396e-09,  1.903103222653607e-10,
  3.804147564584240e-13, -4.487832657724469e-14, -7.270346438228463e-16,  3.158531976392000e-18,  2.816466885459306e-19,  3.592230553551118e-21,  1.943471874800970e+00,
 -1.857481735347817e-03, -4.283286125443601e-05, -7.978741339862700e-07, -1.200553181643235e-08, -1.295961288939772e-10, -3.471124881973752e-13,  2.747274167309472e-14,
  8.819160178499138e-16,  1.664588789177014e-17,  1.990340701619965e-19,  4.441063083823052e-22,  2.089495853818757e-02, -2.369214408799002e-04,  1.999498381428538e-06,
 -1.495430862353797e-08,  1.018771526435551e-10, -6.985450037297431e-13,  3.814306842714749e-15, -2.362097190536923e-17,  4.758316860566676e-19,  1.057870815520821e-20,
  2.005568677247302e-22,  5.159368059729307e-25,  6.193344281892794e-02, -6.978524737051384e-04,  5.784830224096101e-06, -4.177206284526131e-08,  2.673173526647293e-10,
 -1.679368881227718e-12,  7.369957669909949e-15, -3.456482381799477e-17,  1.126941923847971e-18,  3.414102800349270e-20,  5.874022244767486e-22,  1.687174374665314e-24,
  1.239095926084137e-01, -1.382413445208238e-03,  1.113143946071788e-05, -7.570925169853263e-08,  4.306373090951348e-10, -2.230349894057791e-12,  4.048084601577535e-15,
  1.861973930207203e-17,  1.654968300004058e-18,  7.385024555468085e-20,  1.185378085789416e-21,  3.582123370898110e-24,  2.073584961753280e-01, -2.280672050212226e-03,
  1.758519313027193e-05, -1.085150592994736e-07,  4.889082393134777e-10, -1.385158780850769e-12, -1.310780357669604e-14,  1.646703838225060e-16,  2.210129367272411e-18,
  1.281273475940720e-19,  2.083967040825707e-21,  5.950974852771243e-24,  3.130011189812307e-01, -3.375331486789303e-03,  2.442794409468363e-05, -1.279796245509910e-07,
  3.081640498384905e-10,  1.783510117569788e-12, -4.589103380224240e-14,  3.390346470737409e-16,  4.045426148892863e-18,  1.878687306971340e-19,  3.438729365051530e-21,
  8.841504629335716e-24,  4.417510697835997e-01, -4.636708489777329e-03,  3.054987971016907e-05, -1.170459988136023e-07, -2.574354410608262e-10,  7.508902052755026e-12,
 -8.087916836584912e-14,  2.928613475165857e-16,  9.732368567010846e-18,  2.460610707394432e-19,  5.300864238223567e-21,  1.488487958758845e-23,  5.946943718659249e-01,
 -6.013361945638641e-03,  3.424254675801198e-05, -5.345153974606803e-08, -1.303437371113995e-09,  1.389304140319633e-11, -7.412026737222337e-14, -4.281319324266956e-16,
  2.088976708760082e-17,  3.437474290759650e-19,  7.207510235639355e-21,  3.089830219996146e-23,  7.729994574733841e-01, -7.414194203738075e-03,  3.288227917049829e-05,
  8.768117156670357e-08, -2.700202848776664e-09,  1.413681178079520e-11,  5.773938139523895e-14, -2.037818054468953e-15,  2.847196095772192e-17,  6.581559458966458e-19,
  8.488547618686709e-21,  5.125353794207344e-23,  9.776299410946699e-01, -8.673020184430152e-03,  2.253467264376662e-05,  3.199386091724770e-07, -3.650624744810823e-09,
 -6.849564483563124e-12,  3.669267561215883e-13, -2.452064408635684e-15, -4.409550588379036e-18,  1.339147253575366e-18,  1.440605513606138e-20,  5.253844951892101e-24,
  1.208482277686848e+00, -9.476964962642146e-03, -2.059518866413399e-06,  5.932040386320974e-07, -1.815053994489414e-09, -6.477447522087513e-11,  4.522114636703732e-13,
  6.402230568719714e-15, -7.705963783730945e-17,  7.355127559221238e-19,  4.345457782043859e-20,  8.318842356538745e-23,  1.461744276170303e+00, -9.231131739601545e-03,
 -4.434619816099169e-05,  6.347021351252089e-07,  6.550856299621710e-09, -9.512237253849843e-11, -1.334333362029126e-12,  1.644828088339930e-14,  3.083907136857607e-16,
 -1.691767317355232e-18, -2.188392846829148e-20,  1.062308580809813e-21,  1.721489090218429e+00, -6.935907425994483e-03, -8.731853817785868e-05, -2.196711479614568e-07,
  1.256043310139410e-08,  1.819220287712429e-10, -1.167676749241406e-12, -6.387753917717941e-14, -3.784285332541137e-16,  1.686604518180494e-17,  3.778130593343990e-19,
  2.151505350321464e-23,  1.935291111997203e+00, -2.241906457520275e-03, -5.364601226157696e-05, -1.010824112185237e-06, -1.459942195586270e-08, -1.248983578384971e-10,
  9.182221610250004e-13,  6.680122203760141e-14,  1.620293495039678e-15,  2.394668769215456e-17,  1.298767907751674e-19, -4.595697098691856e-21,  1.997816598177271e-02,
 -2.216165805038411e-04,  1.829381427554138e-06, -1.343125639080984e-08,  8.877870109884913e-11, -6.128105450200282e-13,  3.434311455222504e-15, -7.769571175922373e-19,
  9.956953334709232e-19,  1.779550812362291e-20,  1.202274276906478e-22, -5.001105004955942e-24,  5.923151489240408e-02, -6.535086720918885e-04,  5.308149995401238e-06,
 -3.775431340100653e-08,  2.354468429029803e-10, -1.508730919226613e-12,  7.123964419736926e-15,  2.563548272550717e-17,  2.764141631577049e-18,  5.532364998679687e-20,
  3.509758995175216e-22, -1.494474347030857e-23,  1.185524488958621e-01, -1.296882194655844e-03,  1.026281550887503e-05, -6.917031242385917e-08,  3.870866282013963e-10,
 -2.118171376713050e-12,  5.775542251838889e-15,  1.231523811407562e-16,  5.138135732857463e-18,  1.166452373268570e-19,  7.070918301870437e-22, -3.047734352108011e-23,
  1.985091087555018e-01, -2.145068452891935e-03,  1.632898279758301e-05, -1.009294737605042e-07,  4.584941508529464e-10, -1.631587937506771e-12, -6.699287894060664e-15,
  3.250677960549735e-16,  8.271161070407287e-18,  2.033423601720534e-19,  1.250292665495281e-21, -5.279389565569926e-23,  2.998810351286901e-01, -3.185964795842312e-03,
  2.292276526783887e-05, -1.228198998850034e-07,  3.336949137128741e-10,  8.178662512715872e-13, -3.338076855622998e-14,  6.028640738155691e-16,  1.319743737092743e-17,
  3.121629912267871e-19,  2.104555280003598e-21, -8.364505627638256e-23,  4.236840537538439e-01, -4.397986937334265e-03,  2.912523756376418e-05, -1.200654675482775e-07,
 -1.257822361167353e-10,  5.711045040770862e-12, -6.669633712612098e-14,  7.865082782596571e-16,  2.229264283372749e-17,  4.395329990298231e-19,  3.363503585548722e-21,
 -1.241372076101940e-22,  5.711842690277292e-01, -5.742321305117312e-03,  3.348484711115505e-05, -7.218285450007478e-08, -1.043890171697729e-09,  1.205928497450826e-11,
 -7.448899987780819e-14,  4.941084571613808e-16,  3.838172119221570e-17,  6.127558001743099e-19,  4.762873442258042e-21, -1.729699187245696e-22,  7.438744528554060e-01,
 -7.147639839937801e-03,  3.368476005319446e-05,  4.679786411472426e-08, -2.407597237279980e-09,  1.496508854693817e-11,  1.747399488500293e-14, -6.811539626395432e-16,
  5.826957857189823e-17,  9.784841161245164e-19,  5.448525558615902e-21, -2.351743966598036e-22,  9.433213186627170e-01, -8.478386137662830e-03,  2.602044201377000e-05,
  2.608881339994324e-07, -3.704993981695585e-09,  1.165292782828300e-12,  3.043149345865298e-13, -1.714675550516881e-15,  5.350854882345589e-17,  1.835597000372033e-18,
  7.625078826759902e-21, -3.796258030675934e-22,  1.170585727424982e+00, -9.465555356787100e-03,  4.843998789954955e-06,  5.544453097889174e-07, -2.988785024088692e-09,
 -5.201244084937902e-11,  6.033165032091651e-13,  4.692549305006100e-15, -1.998398412807174e-17,  2.366964642071440e-18,  3.272735192056612e-20, -6.586696851543457e-22,
  1.424160759108923e+00, -9.553808823709610e-03, -3.616883283401943e-05,  7.227321739041132e-07,  4.370983251646374e-09, -1.205646631729023e-10, -7.454558151327829e-13,
  2.526368591938120e-14,  2.426889576114945e-16, -1.689373511714780e-18,  1.754615675100728e-20,  4.422232387458818e-22,  1.692336840445593e+00, -7.641319970807661e-03,
 -8.863535722830993e-05,  8.256117803315301e-09,  1.576943948807838e-08,  1.317297831416760e-10, -3.014266123920573e-12, -6.347063210118722e-14,  4.829245798980162e-16,
  2.996172138594488e-17,  2.206835412391866e-19, -7.632919072750711e-21,  1.925382485064652e+00, -2.723743600414157e-03, -6.725398628762534e-05, -1.262449426784785e-06,
 -1.669176055910747e-08, -7.373741098715640e-11,  3.648141953994898e-12,  1.328716694085851e-13,  2.499017434475145e-15,  2.186086291966851e-17, -3.333247195199248e-19,
 -1.826073632790586e-20,  1.911998188701220e-02, -2.076029837065791e-04,  1.676339310473820e-06, -1.210430333557062e-08,  7.736616053247996e-11, -5.264360804936708e-13,
  3.958293441760112e-15,  4.167513919480129e-17,  1.645431100489607e-18,  1.545747816955109e-20, -3.125801783482861e-22, -1.528786710928339e-23,  5.669962874270663e-02,
 -6.127938685214520e-04,  4.876736613218185e-06, -3.421882312839344e-08,  2.070998080098286e-10, -1.317250432741162e-12,  9.389057477833161e-15,  1.469013014267599e-16,
  4.776387142552365e-18,  4.793570465368370e-20, -9.477454223294248e-22, -4.594427338994049e-23,  1.135240126886416e-01, -1.217997721353260e-03,  9.468562598120241e-06,
 -6.330674483260051e-08,  3.465015773737042e-10, -1.915607048288162e-12,  1.217595715497666e-14,  3.566194163568702e-16,  9.372339756810989e-18,  1.011432479275345e-19,
 -1.948423999809595e-21, -9.404324633743529e-23,  1.901826007709397e-01, -2.019159013754845e-03,  1.516074934993871e-05, -9.385963563490018e-08,  4.251758970076333e-10,
 -1.646273563774724e-12,  7.242871559736568e-15,  7.102898511177656e-16,  1.567083443959449e-17,  1.775536618765564e-19, -3.346464487532463e-21, -1.627844179745078e-22,
  2.874947353382713e-01, -3.008386271066900e-03,  2.148137801930458e-05, -1.173867163944567e-07,  3.437002489305399e-10,  2.777502383110417e-13, -8.837505331542267e-15,
  1.211371651596898e-15,  2.465173931140538e-17,  2.764360592202528e-19, -5.164541876469671e-21, -2.572951386850358e-22,  4.065489473158825e-01, -4.170774232562091e-03,
  2.767588879498311e-05, -1.212420565311939e-07, -2.530368877438382e-11,  4.470421949563400e-12, -3.220443757291308e-14,  1.764326612961861e-15,  3.860297173400668e-17,
  3.953342625689438e-19, -7.485051253675785e-21, -3.847788588880716e-22,  5.487448780237649e-01, -5.478173509896513e-03,  3.252610333980098e-05, -8.704527411100577e-08,
 -8.186541293311649e-10,  1.059758039589852e-11, -3.999524579669743e-14,  2.091298321604443e-15,  6.113100750661044e-17,  5.493269653314106e-19, -1.073172479114399e-20,
 -5.544033851217718e-22,  7.158255119341518e-01, -6.876547448826317e-03,  3.402514819388240e-05,  1.069124140495764e-08, -2.104416081022607e-09,  1.539969871684723e-11,
  2.994393428342777e-14,  1.760516985332987e-15,  9.362759116243987e-17,  8.436337629457429e-19, -1.621279382104756e-20, -7.835110360940271e-22,  9.098425114689059e-01,
 -8.258703444226813e-03,  2.879744023040792e-05,  2.021794559852975e-07, -3.611277903934224e-09,  8.148351339941032e-12,  2.903839591197525e-13,  1.069437695594903e-15,
  1.192499908450247e-16,  1.603233339933513e-18, -2.488836531323951e-20, -1.149191190226162e-21,  1.132841902602732e+00, -9.401076668488443e-03,  1.117876063031978e-05,
  4.991339401408822e-07, -3.873607176514178e-09, -3.594239949523631e-11,  7.399433690972972e-13,  5.592954641362016e-15,  7.880853403749941e-17,  2.760867182401519e-18,
 -2.209305724773253e-20, -1.894437189899874e-21,  1.385423180553886e+00, -9.807467752536679e-03, -2.715846013926069e-05,  7.726611156897146e-07,  1.842394552724992e-09,
 -1.291404265763475e-10,  6.253991317397590e-14,  3.219791542604669e-14,  1.941499869121207e-16, -1.174993301062546e-18, -8.839730808331814e-21, -1.872725999058176e-21,
  1.660360306142227e+00, -8.345545381514269e-03, -8.694975481015158e-05,  2.771537029826726e-07,  1.755007541333620e-08,  4.084604517622653e-11, -4.405332699785096e-12,
 -2.986076968291519e-14,  1.617122685532510e-15,  2.965444970864036e-17, -2.898327433847267e-19, -1.488218734944294e-20,  1.913308990729340e+00, -3.326987426904465e-03,
 -8.403517990078778e-05, -1.535122833433530e-06, -1.694029436574378e-08,  6.808882431885441e-11,  8.577157226550158e-12,  2.209146887149230e-13,  2.794955538719707e-15,
 -1.396610378372255e-17, -1.630105598402710e-18, -4.158014842888918e-20,  1.831550015291238e-02, -1.947529964114079e-04,  1.538185447745380e-06, -1.094500367819678e-08,
  6.791445014058151e-11, -4.110927542294231e-13,  5.920181777894740e-15,  9.930122880237736e-17,  1.784210594150101e-18, -1.379638471539077e-20, -1.222923194389755e-21,
 -2.500785225255882e-23,  5.432395742066928e-02, -5.753680623887255e-04,  4.485167198334686e-06, -3.110201670458284e-08,  1.834360716030838e-10, -1.024059111916673e-12,
  1.582346464056775e-14,  3.154759519239619e-16,  5.240505690882564e-18, -4.034517318310191e-20, -3.685896709485716e-21, -7.526262281514938e-23,  1.087988368635105e-01,
 -1.145196484998812e-03,  8.740943766407553e-06, -5.804929846655756e-08,  3.121072340383866e-10, -1.467066623521683e-12,  2.674719491476113e-14,  6.904055974829219e-16,
  1.042460823465274e-17, -7.995226687506633e-20, -7.557370909765730e-21, -1.542650701371102e-22,  1.823415634650437e-01, -1.902265036657532e-03,  1.407421573309079e-05,
 -8.730293535544103e-08,  3.959129723957319e-10, -1.172526269911263e-12,  3.483639901115778e-14,  1.272014483961194e-15,  1.760004894309906e-17, -1.349066384323209e-19,
 -1.305886977739938e-20, -2.672565241957431e-22,  2.757961034330319e-01, -2.842075911401604e-03,  2.010591422263156e-05, -1.118413614816870e-07,  3.503742116594956e-10,
  5.689695100389485e-13,  3.719151170658453e-14,  2.094012412889389e-15,  2.763945485807696e-17, -2.124679355201114e-19, -2.051927149009501e-20, -4.227309230879687e-22,
  3.902994492228805e-01, -3.955187007221289e-03,  2.622142166178677e-05, -1.209541938884042e-07,  6.114394892741274e-11,  4.440086250183262e-12,  3.600118383033207e-14,
  3.131285417365579e-15,  4.258873482275461e-17, -3.266652435424892e-19, -3.047870876645009e-20, -6.337872103367012e-22,  5.273456927848690e-01, -5.222349645084973e-03,
  3.140985912226971e-05, -9.847620038240721e-08, -6.103533616704475e-10,  1.057540957033697e-11,  4.801650459824130e-14,  4.225801448497781e-15,  6.616344535951315e-17,
 -4.908515534441809e-19, -4.401306496928400e-20, -9.200882810624409e-22,  6.888637602612243e-01, -6.604381714612922e-03,  3.396177055688066e-05, -2.045326517424320e-08,
 -1.783396181020084e-09,  1.707015969553586e-11,  1.244126091940667e-13,  5.039040947074367e-15,  1.023718724509660e-16, -6.723685554194956e-19, -6.355853609332000e-20,
 -1.314549028602229e-21,  8.772824551734830e-01, -8.019586646296470e-03,  3.088356332513218e-05,  1.460999396067091e-07, -3.373772139168017e-09,  1.595182935605103e-11,
  3.804098259927869e-13,  5.502380864254743e-15,  1.445236856569548e-16, -6.566057348966914e-19, -9.376338044564935e-20, -1.905920368015524e-21,  1.095452839032802e+00,
 -9.288789850141753e-03,  1.677606536629799e-05,  4.324297807882786e-07, -4.400357946662951e-09, -1.593829105609390e-11,  9.445172249863011e-13,  9.347892488007669e-15,
  1.386472997266455e-16, -1.740785355387712e-19, -1.331331059415420e-19, -3.029103656017336e-21,  1.345817947690126e+00, -9.987340761205145e-03, -1.779375866117495e-05,
  7.818771046756534e-07, -6.489416166926802e-10, -1.161653869253321e-10,  1.043029302044616e-12,  3.745324386354031e-14,  1.178566771924807e-16, -4.023299732927626e-18,
 -1.532795282282132e-19, -4.519966110022797e-21,  1.625614765126581e+00, -9.023042601005922e-03, -8.193125085849909e-05,  5.585782408185541e-07,  1.727600230791892e-08,
 -6.819396225077927e-11, -4.380106791121504e-12,  3.540014783711602e-14,  2.311496255672156e-15,  4.377768787741878e-18, -9.691153743845345e-19, -1.414099579458983e-20,
  1.898533545287804e+00, -4.077375217992557e-03, -1.039955927949102e-04, -1.781814899076952e-06, -1.297064993429942e-08,  3.572642650669658e-10,  1.582700816438018e-11,
  2.857748483089264e-13,  6.233707471163745e-16, -1.212914546605012e-16, -3.810217523584083e-18, -5.041161825019228e-20,  1.756029263889683e-02, -1.829549698477440e-04,
  1.413121718572023e-06, -9.915375596935468e-09,  6.136864666698393e-11, -2.300418675731538e-13,  9.345361705616352e-15,  1.368371526615414e-16,  1.411833387410320e-19,
 -8.439878867757322e-20, -2.244927593776729e-21, -1.586549063740816e-23,  5.209195266884192e-02, -5.409311333044816e-04,  4.128952786817513e-06, -2.830693942347834e-08,
  1.675560317104826e-10, -5.218681034117139e-13,  2.654537352667291e-14,  4.249422465823340e-16,  3.338538872509902e-19, -2.530767325629771e-19, -6.764218104198886e-21,
 -4.787717840899609e-23,  1.043536115145619e-01, -1.077972376168097e-03,  8.073478666208160e-06, -5.324824137177350e-08,  2.909259283163588e-10, -5.605405697455889e-13,
  4.982231817611150e-14,  9.061959387775144e-16,  4.636896086220623e-19, -5.161761418268898e-19, -1.387463394106608e-20, -9.854763919156520e-23,  1.749512058781329e-01,
 -1.793755586017500e-03,  1.306399707424251e-05, -8.109734819822548e-08,  3.840029929200863e-10,  1.459172109197882e-13,  7.675391829715713e-14,  1.633466735652894e-15,
  4.957599537742831e-19, -8.894948628339999e-19, -2.402098449873617e-20, -1.717509246937017e-22,  2.647411306811115e-01, -2.686500395496821e-03,  1.879804490056278e-05,
 -1.060742614799128e-07,  3.758917527349882e-10,  2.251454408166506e-12,  1.057137033541756e-13,  2.660921030842962e-15,  7.126967974250567e-19, -1.401002950954287e-18,
 -3.789595062555342e-20, -2.738786992346056e-22,  3.748890843762104e-01, -3.751197591663561e-03,  2.477901130995922e-05, -1.191861834732255e-07,  1.664024517606127e-10,
  6.489579486781037e-12,  1.389913332813157e-13,  4.015503190221986e-15,  2.123602908428219e-18, -2.098111408283951e-18, -5.660905874356097e-20, -4.150670719989544e-22,
  5.069511553521239e-01, -4.975946948347389e-03,  3.017685294337983e-05, -1.064429852917220e-07, -3.766205682880064e-10,  1.335645637278435e-11,  1.904359124434504e-13,
  5.640321121510138e-15,  6.971471347485059e-18, -3.055163491150733e-18, -8.210791649602787e-20, -6.109223603788384e-22,  6.629874183164590e-01, -6.334127126353339e-03,
  3.355706325809039e-05, -4.603999411146741e-08, -1.398960258361758e-09,  2.207660156924073e-11,  3.035654597721466e-13,  7.322195279884946e-15,  1.832540195204104e-17,
 -4.366698996175691e-18, -1.182649615003934e-19, -8.864669253731287e-22,  8.457080900559985e-01, -7.766395242594841e-03,  3.232518010993025e-05,  9.522915080122935e-08,
 -2.948457165858999e-09,  2.740121417788123e-11,  5.895434141439414e-13,  8.858614483937624e-15,  3.295490529947554e-17, -6.078838890395410e-18, -1.732598684550874e-19,
 -1.300221532949239e-21,  1.058597250324087e+00, -9.135037342403370e-03,  2.153652262411765e-05,  3.608031025302728e-07, -4.468827057576911e-09,  1.032328060418437e-11,
  1.258571774505205e-12,  1.239266009105117e-14,  4.156319594984239e-18, -8.149485412154956e-18, -2.593754313782423e-19, -2.104675421949272e-21,  1.305642838495613e+00,
 -1.009250318255390e-02, -8.544807237340301e-06,  7.546297007444967e-07, -2.635530131021804e-09, -7.830840733592230e-11,  2.111951900703909e-12,  3.731542391290254e-14,
 -1.878351903215413e-16, -1.434118183866516e-17, -3.578649669991356e-19, -3.760995797103082e-21,  1.588260599999110e+00, -9.647120261063832e-03, -7.363204415625312e-05,
  8.188579883849588e-07,  1.498393678728957e-08, -1.532129552898230e-10, -2.389301168381861e-12,  1.033480037846562e-13,  1.646339081414126e-15, -4.390713718832367e-17,
 -1.349494179535471e-18, -9.997501669718651e-22,  1.880420617548696e+00, -4.997704506076095e-03, -1.263125101674850e-04, -1.908846241271379e-06, -1.388360684534564e-09,
  8.302046876739792e-10,  2.321991980062175e-11,  2.028077210215848e-13, -6.903294278674252e-15, -3.032029732515508e-16, -4.658523181342973e-18,  3.755966528137053e-20,
  1.685035235050984e-02, -1.721095059850631e-04,  1.299919739072109e-06, -8.956827949670007e-09,  5.930943710340659e-11,  3.728591299646656e-14,  1.265513752061235e-14,
  7.474481703235440e-17, -4.569871422204409e-18, -1.749287930543605e-19, -1.831507972760043e-21,  4.630207809170429e-23,  4.999220365589119e-02, -5.092132174686831e-04,
  3.805133419982100e-06, -2.567098618967491e-08,  1.644168205554076e-10,  2.488578822000210e-13,  3.683748377263615e-14,  2.356162153714584e-16, -1.381854713380000e-17,
 -5.260121505506134e-19, -5.529006280400736e-21,  1.390997890747695e-22,  1.001669619774809e-01, -1.015861718428842e-03,  7.462292238086457e-06, -4.860974622747325e-08,
  2.936491201274095e-10,  9.202187284216136e-13,  7.181760834473346e-14,  5.124221053092612e-16, -2.846586751594976e-17, -1.076570785540025e-18, -1.137530488810410e-20,
  2.841031862717669e-22,  1.679791927499885e-01, -1.693030885457193e-03,  1.212815530212674e-05, -7.481472968063966e-08,  4.089057307973319e-10,  2.502193443815497e-12,
  1.165265905716594e-13,  9.441729211765497e-16, -4.945648435032003e-17, -1.861180722582501e-18, -1.977961637673051e-20,  4.892091108581799e-22,  2.542879863069583e-01,
 -2.541100916914367e-03,  1.756323967695508e-05, -9.953723456827016e-08,  4.521032630423412e-10,  5.627786076218485e-12,  1.707895021311168e-13,  1.572271739098519e-15,
 -7.804891185642922e-17, -2.937295426987725e-18, -3.138822177398039e-20,  7.667816376921717e-22,  3.602717786554349e-01, -3.558629948070298e-03,  2.336972447932164e-05,
 -1.152668533533851e-07,  3.383437547120070e-10,  1.109625965426184e-11,  2.377812987872868e-13,  2.419521958438180e-15, -1.157965762773521e-16, -4.399582377773702e-18,
 -4.724063499125180e-20,  1.136355062833945e-21,  4.875219920364609e-01, -4.739721650503954e-03,  2.887314571164955e-05, -1.100309350703597e-07, -5.138103730726999e-11,
  1.972211642094603e-11,  3.302480198960020e-13,  3.442110195067566e-15, -1.646194373958374e-16, -6.404303497692964e-18, -6.913827730590613e-20,  1.630500879918560e-21,
  6.381838344830545e-01, -6.068224585517508e-03,  3.288632456852442e-05, -6.442654487253678e-08, -8.683629113988335e-10,  3.170952305023882e-11,  4.863804908690914e-13,
  4.439441570015834e-15, -2.277639036731342e-16, -9.205987726813311e-18, -1.006041477653274e-19,  2.308139452355796e-21,  8.151658788875763e-01, -7.503977721455645e-03,
  3.320568202506314e-05,  5.329019753613409e-08, -2.239273915111516e-09,  4.439399210825544e-11,  8.095045091221361e-13,  5.012759530244213e-15, -3.163299967004777e-16,
 -1.319381528553433e-17, -1.493848591543906e-19,  3.281194556655269e-21,  1.022427425140812e+00, -8.946615206917826e-03,  2.544959599070303e-05,  2.927088189275389e-07,
 -3.933541787055376e-09,  4.436211137127150e-11,  1.548354545288211e-12,  5.723256706167268e-15, -4.862421504763576e-16, -1.894704390958123e-17, -2.311977865443465e-19,
  4.722326207699907e-21,  1.265192316334980e+00, -1.012545572564442e-02,  2.159014589080690e-07,  7.030217515200390e-07, -3.616113102203271e-09, -1.634469868361964e-11,
  2.973975449314440e-12,  2.006966716687551e-14, -9.836284723005896e-16, -2.980885718378275e-17, -3.390146478762004e-19,  6.841266571727312e-21,  1.548561667134402e+00,
 -1.019304368243578e-02, -6.247560535418700e-05,  1.032039900792060e-06,  1.160386475440904e-08, -1.717061561472189e-10,  9.315029265523237e-13,  1.206284627436941e-13,
 -8.556100643038934e-16, -9.185373103412976e-17, -8.481741843895231e-19,  2.650892395389855e-20,  1.858265114401939e+00, -6.098740934147831e-03, -1.487020427236341e-04,
 -1.766607580823601e-06,  2.107243964087344e-08,  1.419438435620256e-09,  2.394509167267527e-11, -2.217690697688038e-13, -2.019493657956578e-14, -3.902352352410864e-16,
  2.257747929283195e-18,  3.018794900221640e-19,  1.618205531062507e-02, -1.621237777044753e-04,  1.198210631471415e-06, -7.985073107394697e-09,  6.315039416235132e-11,
  3.434082669019944e-13,  1.168567440873341e-14, -1.804658891270965e-16, -1.139578614376650e-17, -1.739211826910968e-19,  2.780003235494520e-21,  1.671905609669706e-22,
  4.801434596196708e-02, -4.799589390511472e-04,  3.513188899388012e-06, -2.295135565336921e-08,  1.784325645290524e-10,  1.143535526747251e-12,  3.419064996841986e-14,
 -5.344357724439153e-16, -3.435979158645889e-17, -5.238042095005638e-19,  8.346062802505503e-21,  5.034475691238473e-22,  9.621933282931051e-02, -9.584147535850628e-04,
  6.908084120505178e-06, -4.366793198606064e-08,  3.297591031634041e-10,  2.674954047719047e-12,  6.716001312743172e-14, -1.069990041675796e-15, -7.055245541073613e-17,
 -1.074520984642594e-18,  1.703423785519121e-20,  1.032143787934931e-21,  1.613955970867966e-01, -1.599480708491980e-03,  1.127179214819719e-05, -6.771500101155665e-08,
  4.878549687014904e-10,  5.371287207440016e-12,  1.099901263484719e-13, -1.800348881164160e-15, -1.223130248675440e-16, -1.863176417607772e-18,  2.931905208421322e-20,
  1.787089246229684e-21,  2.443972164134528e-01, -2.405239764381747e-03,  1.641665633293028e-05, -9.117185609997133e-08,  6.073166110474986e-10,  9.868649625905240e-12,
  1.627642450013855e-13, -2.760768818729800e-15, -1.932046002396438e-16, -2.951129051409911e-18,  4.596056164903637e-20,  2.822424144229551e-21,  3.464025689675272e-01,
 -3.377093973976466e-03,  2.202737165916736e-05, -1.077543615494078e-07,  6.200017845312794e-10,  1.704117189518779e-11,  2.280449585290383e-13, -4.038018377001183e-15,
 -2.885731145647641e-16, -4.439702153900329e-18,  6.816306176207337e-20,  4.224974263015579e-21,  4.690167368669681e-01, -4.513999060626058e-03,  2.756231096623952e-05,
 -1.072476698011837e-07,  4.260925333811310e-10,  2.798200156871403e-11,  3.155708427554100e-13, -5.836795685326249e-15, -4.166569298874119e-16, -6.499266984138206e-18,
  9.784874394310835e-20,  6.139100898895640e-21,  6.144319563693685e-01, -5.808410203427740e-03,  3.205289674260680e-05, -7.258928477784310e-08, -1.130083408884918e-10,
  4.372348520942133e-11,  4.549337492125753e-13, -8.627397500808430e-15, -5.913234550581879e-16, -9.421990948167695e-18,  1.381170265400748e-19,  8.821139687959224e-21,
  7.856845468580010e-01, -7.236308948526147e-03,  3.366298138662763e-05,  2.564163740313526e-08, -1.153637916135067e-09,  6.389209236590147e-11,  7.308723947461159e-13,
 -1.343238799568336e-14, -8.411828287647081e-16, -1.370746145533463e-17,  1.940558264715672e-19,  1.277067270023284e-20,  9.870689988072254e-01, -8.729957678641828e-03,
  2.862035509185624e-05,  2.389034029872108e-07, -2.673663906115357e-09,  8.100738195407741e-11,  1.378932306004333e-12, -2.190671024245244e-14, -1.250390809671040e-15,
 -2.017337699975230e-17,  2.761599350149686e-19,  1.906853763123500e-20,  1.224745988697997e+00, -1.009096605893889e-02,  8.307128925517889e-06,  6.465404668761054e-07,
 -3.206599910378332e-09,  5.715320254578584e-11,  2.920416889538236e-12, -3.024760014062581e-14, -2.172905098412109e-15, -3.109800565144100e-17,  4.482675577015296e-19,
  3.030756902439161e-20,  1.506872445994767e+00, -1.064040212677323e-02, -4.908363216963977e-05,  1.192495254586309e-06,  8.637298235731588e-09, -1.151332601129794e-10,
  3.398575528465253e-12,  3.676653173297655e-14, -4.385439963864012e-15, -9.056253693223242e-17,  1.228005796273985e-18,  6.916259593793874e-20,  1.831367827955410e+00,
 -7.365078687880464e-03, -1.668496770248706e-04, -1.174693411254406e-06,  5.427719846152419e-08,  1.834964270715951e-09,  6.876623282952001e-12, -1.044252105924673e-12,
 -2.866030603706241e-14,  4.440409188053491e-17,  2.075114107279703e-17,  4.611703925763777e-19,  1.555214975275875e-02, -1.529035900396166e-04,  1.108721582074286e-06,
 -6.907006269110640e-09,  7.218034919139497e-11,  5.173916390594292e-13,  8.308703885001599e-16, -6.078036979070845e-16, -1.364651267984532e-17,  1.073800391010890e-19,
  1.143381522362442e-20,  1.811339695011003e-22,  4.614904805735875e-02, -4.529045664517576e-04,  3.255781605710188e-06, -1.987639881724760e-08,  2.075930147914132e-10,
  1.646346897017551e-12,  1.734342895098999e-15, -1.822894335002856e-15, -4.115518331693151e-17,  3.226337930721171e-19,  3.443489291644108e-20,  5.469074413324964e-22,
  9.249301701742640e-02, -9.051518825815584e-04,  6.417735212168501e-06, -3.789138596408512e-08,  3.955045017953827e-10,  3.643521599285155e-12,  1.282332430667348e-15,
 -3.715926921479226e-15, -8.455147877429950e-17,  6.589761433874455e-19,  7.061723189425468e-20,  1.125944335268497e-21,  1.551730757162655e-01, -1.512415018445199e-03,
  1.050998836469513e-05, -5.893226661311885e-08,  6.150891598133160e-10,  6.914128075085378e-12, -2.702644810540296e-15, -6.389352574462846e-15, -1.467485197177429e-16,
  1.134280319307928e-18,  1.223310796261507e-19,  1.960935449728349e-21,  2.350322492952268e-01, -2.278101378786210e-03,  1.538799281372851e-05, -7.970349454938074e-08,
  8.335316773829508e-10,  1.206984620583870e-11, -1.298053613757241e-14, -1.001656852257340e-14, -2.322958760561751e-16,  1.775486961961274e-18,  1.933597112825360e-19,
  3.121144669452309e-21,  3.332387160213788e-01, -3.205851007888476e-03,  2.080589608832837e-05, -9.486921959783192e-08,  1.000478315025789e-09,  1.999499249774529e-11,
 -3.224631390144117e-14, -1.489586834891328e-14, -3.482333644542562e-16,  2.622732046306107e-18,  2.897900056170703e-19,  4.719265907422000e-21,  4.513938093629625e-01,
 -4.298487752179420e-03,  2.633582253028828e-05, -9.562662814342090e-08,  1.039672095609204e-09,  3.191307977753523e-11, -6.091832971002317e-14, -2.156452171873969e-14,
 -5.057363678619318e-16,  3.738291292302986e-18,  4.217149790892775e-19,  6.945285312113565e-21,  5.917056935020799e-01, -5.555432315891775e-03,  3.120143094387489e-05,
 -6.693250673061043e-08,  8.389028387013336e-10,  4.935024427249912e-11, -9.005105798878554e-14, -3.105541799846144e-14, -7.237334655952558e-16,  5.231409098240841e-18,
  6.068152822239754e-19,  1.014039729148610e-20,  7.572795593135642e-01, -6.965985655583685e-03,  3.390469540221844e-05,  1.817154390650212e-08,  2.517847187933565e-10,
  7.350563105530266e-11, -7.849511176106190e-14, -4.550526770088270e-14, -1.038852934858329e-15,  7.348741100670495e-18,  8.787527252113973e-19,  1.497657771580601e-20,
  9.526243991139240e-01, -8.490121289997094e-03,  3.128903143410051e-05,  2.105866979082614e-07, -7.980505398017502e-10,  1.016698298129272e-10,  1.220262528113632e-13,
 -6.954295126003481e-14, -1.543323682695886e-15,  1.088430246841672e-17,  1.311029298844716e-18,  2.294547606772001e-20,  1.184563087493966e+00, -9.994237710186371e-03,
  1.580668539477225e-05,  6.077468151946582e-07, -1.475553965139094e-09,  1.083839982074627e-10,  9.734197211705305e-13, -1.112443054162771e-13, -2.593161230865922e-15,
  1.906149296769705e-17,  2.124157367997800e-18,  3.774246497876294e-20,  1.463619251876648e+00, -1.097362781804641e-02, -3.400594639823685e-05,  1.316733162948582e-06,
  7.140683726856777e-09, -3.958582795162021e-11,  2.078412299271963e-12, -1.396889693167337e-13, -5.940839342101775e-15,  2.796796726504409e-17,  4.758052775578989e-18,
  7.446435333652485e-20,  1.799173165882000e+00, -8.738707255330188e-03, -1.745267467587671e-04, -1.542034068507595e-08,  8.975291193123958e-08,  1.553583495149424e-09,
 -3.361878861763674e-11, -1.742242241964597e-12, -8.294222017540908e-15,  1.146128934571559e-15,  2.879410261855232e-17, -2.987404340775240e-19,  1.495777872939768e-02,
 -1.443449592261157e-04,  1.033094028428076e-06, -5.674849323224233e-09,  8.112175228975523e-11,  2.908052375248555e-13, -2.102066866149012e-14, -8.830753299497336e-16,
 -3.235684712272777e-19,  6.404750127400697e-19,  1.224537952898089e-20, -2.240292014049865e-22,  4.438809460736306e-02, -4.277534945539451e-04,  3.038234305053030e-06,
 -1.630902625035173e-08,  2.361160479143541e-10,  9.478433549096977e-13, -6.389079026036325e-14, -2.654025751298254e-15, -1.041030672751685e-18,  1.929572061766543e-18,
  3.694759301950946e-20, -6.738255019162067e-22,  8.897237245533673e-02, -8.555158575308411e-04,  6.003308283231727e-06, -3.101906628983687e-08,  4.588453279086991e-10,
  2.163368530759743e-12, -1.327522073341261e-13, -5.426351202414396e-15, -2.329267347504009e-18,  3.958916854799019e-18,  7.598660686750421e-20, -1.379075082684384e-21,
  1.492873462142462e-01, -1.430986407480363e-03,  9.866214228884446e-06, -4.805763444950575e-08,  7.357839332190625e-10,  4.246696774800678e-12, -2.337124903736506e-13,
 -9.364416812481372e-15, -4.445986558462467e-18,  6.861640717056905e-18,  1.321518551419053e-19, -2.382360674069270e-21,  2.261603376799236e-01, -2.158578777641083e-03,
  1.451918705263771e-05, -6.456188364329495e-08,  1.045217496061286e-09,  7.670623002715987e-12, -3.760423284094049e-13, -1.473780894158632e-14, -7.724960948183859e-18,
  1.085081906012411e-17,  2.099617213586559e-19, -3.751995887269348e-21,  3.207414192156832e-01, -3.043656101987707e-03,  1.977613400411374e-05, -7.586690958776580e-08,
  1.353036184905221e-09,  1.313232278905449e-11, -5.733438656410094e-13, -2.199234575686795e-14, -1.252357209542833e-17,  1.626729241437834e-17,  3.167401259416272e-19,
 -5.597747566598687e-21,  4.346144250378741e-01, -4.092061611024511e-03,  2.530828266296055e-05, -7.420057887941064e-08,  1.605945582952289e-09,  2.162954141283774e-11,
 -8.451140479484899e-13, -3.189617334776914e-14, -1.905709499420799e-17,  2.367456891992981e-17,  4.647350683876749e-19, -8.102395598963724e-21,  5.699785183367929e-01,
 -5.308732843456404e-03,  3.051005362957942e-05, -4.607015912442354e-08,  1.721744085548297e-09,  3.449675264140712e-11, -1.218101551684160e-12, -4.586512410771400e-14,
 -2.697017044777916e-17,  3.406577436284334e-17,  6.755972537269691e-19, -1.159131152304065e-20,  7.299597130807618e-01, -6.693698715712118e-03,  3.419377309615079e-05,
  3.336357979875529e-08,  1.582446773589630e-09,  5.308903767543797e-11, -1.723925957446836e-12, -6.675999859709528e-14, -3.460233534806318e-17,  4.938278865195447e-17,
  9.908260177279636e-19, -1.670875784392773e-20,  9.191804371827498e-01, -8.229766041517326e-03,  3.380504376959419e-05,  2.134902597137022e-07,  1.081056672332519e-09,
  7.641626084535398e-11, -2.376274754310752e-12, -1.010346152931243e-13, -4.131042012078415e-17,  7.411874136759637e-17,  1.499891619435627e-18, -2.497611359898384e-20,
  1.144884886183676e+00, -9.838846635659764e-03,  2.303036976635878e-05,  6.015354176952796e-07,  6.300326645552286e-10,  8.627916643643592e-11, -3.067798770299672e-12,
 -1.643589956370576e-13, -1.021829727180858e-16,  1.219477803580935e-16,  2.440941193813113e-18, -4.143917303956682e-20,  1.419283392235493e+00, -1.118058058156214e-02,
 -1.754150013950985e-05,  1.425670171105131e-06,  6.429107105111081e-09, -5.574882182675280e-11, -4.052183995475931e-12, -2.722944895401345e-13, -1.003865908081882e-15,
  2.492150866479389e-16,  5.033743271520634e-18, -9.907589611114903e-20,  1.761461855908597e+00, -1.010925460735818e-02, -1.652575621010835e-04,  1.608793155667712e-06,
  1.088370004658122e-07,  1.763219779919982e-10, -7.860155590115584e-11, -1.175961310587819e-12,  4.671922905880085e-14,  1.618710389344886e-15, -1.475525858721564e-17,
 -1.554342050867078e-18,  1.439652856781012e-02, -1.363303114997151e-04,  9.728642965077682e-07, -4.365910444706313e-09,  7.998461708521806e-11, -4.875712745786578e-13,
 -4.191745548255180e-14, -4.602643875685987e-16,  2.751442368418359e-17,  7.540593414607238e-19, -1.040651651379280e-20, -7.259324575251589e-22,  4.272454462859815e-02,
 -4.041654529621068e-04,  2.865481600088781e-06, -1.248725554959261e-08,  2.340034264159762e-10, -1.408722161616587e-12, -1.266932040746341e-13, -1.381876305441604e-15,
  8.286811685137324e-17,  2.273728620582253e-18, -3.134641527829356e-20, -2.190716636712213e-21,  8.564418331800108e-02, -8.088515875532870e-04,  5.675858239027059e-06,
 -2.355446067390759e-08,  4.585237132811019e-10, -2.705906816717092e-12, -2.611502928262580e-13, -2.820992156576667e-15,  1.699592303993641e-16,  4.671239406346365e-18,
 -6.430195222827450e-20, -4.506694554574077e-21,  1.437178956609031e-01, -1.354159284571226e-03,  9.361736207341249e-06, -3.599659336510429e-08,  7.443838906586955e-10,
 -4.267489577330959e-12, -4.552738732082407e-13, -4.858256211541435e-15,  2.944875429912797e-16,  8.111214052523631e-18, -1.114414999351932e-19, -7.841007723723261e-21,
  2.177538347501232e-01, -2.045232159991766e-03,  1.384788604158395e-05, -4.723716504416174e-08,  1.076516788033521e-09, -5.926848390750303e-12, -7.246854651537977e-13,
 -7.626409078862164e-15,  4.656806531968284e-16,  1.285796054830484e-17, -1.762772723551777e-19, -1.246510444315337e-20,  3.088779855904459e-01, -2.888706528398997e-03,
  1.900131067869873e-05, -5.306732292442440e-08,  1.430528127638204e-09, -7.451347829849927e-12, -1.093470975146609e-12, -1.134615709422230e-14,  6.985184350717119e-16,
  1.933531981018218e-17, -2.645286019738555e-19, -1.882101927872161e-20,  4.186461210827129e-01, -3.892695917381828e-03,  2.458194375970016e-05, -4.644048706335928e-08,
  1.766742928270213e-09, -8.548523700803966e-12, -1.599156291666972e-12, -1.640075574663983e-14,  1.018188208139636e-15,  2.824395888940843e-17, -3.858981132063272e-19,
 -2.765409081240250e-20,  5.492289611834960e-01, -5.066355471933458e-03,  3.013895933967995e-05, -1.501349713485517e-08,  2.020183501658207e-09, -8.962374036310285e-12,
 -2.301672941796874e-12, -2.350444458090254e-14,  1.469755512303019e-15,  4.081070541939635e-17, -5.581167511051007e-19, -4.030160693515697e-20,  7.037352461072599e-01,
 -6.418053647551950e-03,  3.477211646002778e-05,  6.431449627171604e-08,  2.086229757222611e-09, -8.978003178607914e-12, -3.299730880841306e-12, -3.412299658824713e-14,
  2.141532349721114e-15,  5.938519518828145e-17, -8.175930621802558e-19, -5.939793990741664e-20,  8.868190161862856e-01, -7.948692756171315e-03,  3.650854709556749e-05,
  2.389856139026885e-07,  1.820880396877439e-09, -1.191104216506985e-11, -4.759419535834017e-12, -5.163657381696232e-14,  3.229845859362573e-15,  8.914340684411561e-17,
 -1.253924740105315e-18, -9.090988125897016e-20,  1.105944075072752e+00, -9.625461051735581e-03,  3.034909735345256e-05,  6.199064273121932e-07,  1.263924380456499e-09,
 -3.834381471686243e-11, -6.953550802411002e-12, -8.446479797777101e-14,  5.249469289590486e-15,  1.444907112681499e-16, -2.160979951242780e-18, -1.517777332586912e-19,
  1.374391055116060e+00, -1.125086349595412e-02,  1.228403737132748e-07,  1.511791998477192e-06,  3.744573342825635e-09, -2.387456194514531e-10, -1.057406917701048e-11,
 -1.354674184757665e-13,  9.797905019518531e-15,  2.832894180782067e-16, -5.017196712591738e-18, -3.174331660855600e-19,  1.718544242178456e+00, -1.132492830769430e-02,
 -1.357412313402515e-04,  3.268367443267917e-06,  9.190792871727802e-08, -1.889875911902955e-09, -8.342936423315657e-11,  1.004103897391813e-12,  7.823269742689301e-14,
 -2.513534573611430e-16, -7.018984651554466e-17, -3.860896477721125e-19,  1.386647061430950e-02, -1.287363147340363e-04,  9.276459956775049e-07, -3.221139217516609e-09,
  5.973435660717615e-11, -1.528061163570499e-12, -3.932428389123137e-14,  7.138647219280189e-16,  3.992172760214845e-17, -2.300839953517837e-19, -3.434715698828228e-20,
 -1.206338465060068e-22,  4.115286712302641e-02, -3.817805945118298e-04,  2.736612858947078e-06, -9.140721676747895e-09,  1.741117034930712e-10, -4.551640152144052e-12,
 -1.187495150055597e-13,  2.155456144647310e-15,  1.202784643263508e-16, -6.945659669069944e-19, -1.036323667788551e-19, -3.644531956202428e-22,  8.249796832215547e-02,
 -7.644570249996560e-04,  5.434291075254407e-06, -1.700562520569474e-08,  3.390717795756268e-10, -9.178631084016996e-12, -2.444542851575098e-13,  4.437116376363277e-15,
  2.468048509801011e-16, -1.429846635341962e-18, -2.131221921788303e-19, -7.507601419589335e-22,  1.384485828186659e-01, -1.280801243732978e-03,  8.996424748694683e-06,
 -2.538699717910330e-08,  5.452328014324591e-10, -1.553900535537366e-11, -4.254391825189748e-13,  7.724599296861616e-15,  4.278713510822667e-16, -2.491253727076002e-18,
 -3.706258366004782e-19, -1.307666395669796e-21,  2.097912757602545e-01, -1.936439011780126e-03,  1.337729802573444e-05, -3.194369957483613e-08,  7.770141793333400e-10,
 -2.384504498254660e-11, -6.758053271139463e-13,  1.228271686517679e-14,  6.769410952751834e-16, -3.971108030154734e-18, -5.887910654354753e-19, -2.078806375674216e-21,
  2.976236696475707e-01, -2.738875086903596e-03,  1.849212698015254e-05, -3.285234341714018e-08,  1.008724153700260e-09, -3.445058440122978e-11, -1.017346397707282e-12,
  1.853290334772134e-14,  1.015660078142955e-15, -6.025575399793087e-18, -8.881382516396044e-19, -3.130059306036571e-21,  4.034657626867721e-01, -3.697815967232939e-03,
  2.418162448085455e-05, -2.170503836192573e-08,  1.197216331420476e-09, -4.798242828802038e-11, -1.484144661340302e-12,  2.716396969031596e-14,  1.479928049531482e-15,
 -8.931933871897176e-18, -1.303104876294776e-18, -4.558940094452251e-21,  5.294453540164168e-01, -4.825448746417185e-03,  3.013674993896346e-05,  1.276112675077634e-08,
  1.267617987509970e-09, -6.566687189184577e-11, -2.130934185099809e-12,  3.936160467886086e-14,  2.132772051020073e-15, -1.322298653055014e-17, -1.895116958112720e-18,
 -6.502266384247577e-21,  6.786250199861643e-01, -6.136264736036648e-03,  3.572380154443438e-05,  9.179139447651951e-08,  1.084519672434861e-09, -9.026865879097108e-11,
 -3.048477433414419e-12,  5.733931830790831e-14,  3.094644826618088e-15, -2.004629248082815e-17, -2.784320241224660e-18, -9.108694340178196e-21,  8.556271675545055e-01,
 -7.644717686896785e-03,  3.952244967310155e-05,  2.597592389678671e-07,  3.943489922629186e-10, -1.293803819467352e-10, -4.389355885110037e-12,  8.579968336413583e-14,
  4.625334385851534e-15, -3.231134064642170e-17, -4.240386154478669e-18, -1.225267755864858e-20,  1.067975260613362e+00, -9.352688586265685e-03,  3.785337520419336e-05,
  6.245173334785042e-07, -1.248076402329137e-09, -2.107359515115750e-10, -6.377713147800556e-12,  1.374758691982608e-13,  7.387220247179795e-15, -5.944185043628582e-17,
 -7.014772421321419e-18, -1.319687015220492e-20,  1.329505305092120e+00, -1.117675216067805e-02,  1.841982307792886e-05,  1.519166904781697e-06, -3.659424609918768e-09,
 -4.952249256321294e-10, -8.871517673086460e-12,  2.769768603148878e-13,  1.335318366209570e-14, -1.492607028141106e-16, -1.410678260237990e-17,  2.016594007000322e-20,
  1.671351761497782e+00, -1.223248981819249e-02, -8.925963235629730e-05,  4.342073463283002e-06,  3.772081809478662e-08, -3.299498798840139e-09, -2.542337758304164e-11,
  2.840443909220118e-12,  2.258078763736039e-14, -2.522013872056964e-15, -2.319107076023700e-17,  2.255865516487320e-18,  1.336614239377779e-02, -1.214561258505994e-04,
  8.935766178358954e-07, -2.551955268362132e-09,  2.203384189557565e-11, -2.104583887164889e-12, -4.530922128814569e-15,  1.606918003491820e-15,  9.219899640911513e-18,
 -1.318543342243581e-18, -1.110144196679380e-20,  1.061071629733403e-21,  3.966889248582796e-02, -3.602868806654944e-04,  2.640206937689274e-06, -7.210275588314997e-09,
  6.151446448183247e-11, -6.293637397869800e-12, -1.380602526320086e-14,  4.844276455756061e-15,  2.764145820358612e-17, -3.977504845935674e-18, -3.340255511418377e-20,
  3.205276644852676e-21,  7.952590598140823e-02, -7.217224903706822e-04,  5.255835575428601e-06, -1.331070997394959e-08,  1.110924641496087e-10, -1.276749230715742e-11,
 -2.876684142114066e-14,  9.948480596292572e-15,  5.627591709981425e-17, -8.177290389708551e-18, -6.838404177945175e-20,  6.604034630305351e-21,  1.334675654887029e-01,
 -1.209926870497963e-03,  8.732333944530237e-06, -1.960496849963966e-08,  1.571433025886553e-10, -2.179012242278462e-11, -5.073774371380780e-14,  1.726434856481889e-14,
  9.646010589408146e-17, -1.421453463593904e-17, -1.181216675595666e-19,  1.151518719666174e-20,  2.022573730443354e-01, -1.830783798540259e-03,  1.305039328424887e-05,
 -2.405023187929079e-08,  1.772831354938904e-10, -3.378105773011335e-11, -8.154471052604063e-14,  2.734239681600307e-14,  1.502008516819655e-16, -2.256940457790243e-17,
 -1.858130595549983e-19,  1.836001512561738e-20,  2.869618553759727e-01, -2.592300466384064e-03,  1.816833243609680e-05, -2.331391284971492e-08,  1.348310747384435e-10,
 -4.940801967968031e-11, -1.234149988892642e-13,  4.105822370045612e-14,  2.204063669370243e-16, -3.402030156322566e-17, -2.762684143114894e-19,  2.782985477560582e-20,
  3.890601049649416e-01, -3.505163026429896e-03,  2.399908234089570e-05, -1.181451225665145e-08, -3.191499738466257e-11, -6.977298131598214e-11, -1.783756815285303e-13,
  5.984192978196732e-14,  3.111781676375972e-16, -4.987174649240172e-17, -3.966733590022516e-19,  4.110156373098104e-20,  5.106270522009303e-01, -4.583512898956582e-03,
  3.036056889812294e-05,  2.026033519534261e-08, -4.317582028697022e-10, -9.682363885610481e-11, -2.458215618664681e-13,  8.615125248276006e-14,  4.279640150103638e-16,
 -7.244469963356745e-17, -5.576192837644229e-19,  6.031101590514773e-20,  6.546587252526791e-01, -5.845932907331524e-03,  3.685890052402635e-05,  9.145671130243176e-08,
 -1.270193186548132e-09, -1.343936099617727e-10, -3.129983303162838e-13,  1.245489092857195e-13,  5.763370948826726e-16, -1.062550506096293e-16, -7.735514347796491e-19,
  8.972258083972451e-20,  8.257002493149485e-01, -7.316191033267284e-03,  4.257638960046593e-05,  2.407368792902614e-07, -2.974412332807439e-09, -1.913848245361987e-10,
 -3.138663670722215e-13,  1.845245302804140e-13,  7.517590895773935e-16, -1.613166585924406e-16, -1.055713735458444e-18,  1.391325765122031e-19,  1.031216664025903e+00,
 -9.020590275804619e-03,  4.506638272451813e-05,  5.642592717782079e-07, -6.558845538698399e-09, -2.947403601908800e-10,  9.283674422915006e-14,  2.896443082195324e-13,
  8.596771268943171e-16, -2.646751350187255e-16, -1.339428451699345e-18,  2.364768823027597e-19,  1.285205997748449e+00, -1.095828054405515e-02,  3.594328259983438e-05,
  1.373217109528510e-06, -1.484986037909453e-08, -5.753987130959647e-10,  3.347276495978762e-12,  5.223305375680823e-13, -2.821378697848586e-16, -5.159564630081547e-16,
 -5.803642828125312e-19,  4.957154558370832e-19,  1.621331413301869e+00, -1.273298151411511e-02, -3.574358490790525e-05,  4.411946837818116e-06, -2.786995821274753e-08,
 -2.958946187941062e-09,  5.045937912547000e-11,  2.130641455831450e-12, -6.063716563252701e-14, -1.498632759172265e-15,  6.462781576010108e-17,  9.827459121707716e-19,
  1.289442545589095e-02, -1.144271745168647e-04,  8.637022311375822e-07, -2.526731061169244e-09, -1.751818013477341e-11, -1.684637069711538e-12,  3.739578686871820e-14,
  1.151422258923864e-15, -3.467006768360859e-17, -8.252746578523154e-19,  3.196364027237781e-20,  5.599766062220230e-22,  3.826945143582988e-02, -3.395040394993389e-04,
  2.555503465780018e-06, -7.204842213021645e-09, -5.674052339328722e-11, -5.031784795482022e-12,  1.125118290121019e-13,  3.465738791581107e-15, -1.046583638191898e-16,
 -2.483585276363798e-18,  9.656984351538066e-20,  1.685620001421112e-21,  7.672211511820579e-02, -6.803036802780048e-04,  5.098483711851312e-06, -1.351872380572528e-08,
 -1.287225352538714e-10, -1.018798152879114e-11,  2.304007766010204e-13,  7.099956131484950e-15, -2.153946478704435e-16, -5.086600199167279e-18,  1.990142658254996e-19,
  3.453428882669905e-21,  1.287661025065388e-01, -1.140999225288469e-03,  8.498014989500273e-06, -2.047879919628625e-08, -2.519211884501668e-10, -1.733816904381347e-11,
  3.984041408059786e-13,  1.227740436503975e-14, -3.749643134818599e-16, -8.793247302720070e-18,  3.471214900739378e-19,  5.971914592150750e-21,  1.951412174174719e-01,
 -1.727537582512245e-03,  1.275688310187193e-05, -2.646473092887968e-08, -4.563311147678349e-10, -2.676940614007940e-11,  6.284492799856691e-13,  1.934836552301994e-14,
 -5.964767057373527e-16, -1.385348839438768e-17,  5.536795362378314e-19,  9.410233249822502e-21,  2.768815287918977e-01, -2.448110398929320e-03,  1.786944897240667e-05,
 -2.883237353573519e-08, -7.905918313554045e-10, -3.892386938752696e-11,  9.400013878484999e-13,  2.885606540219152e-14, -9.012236104860502e-16, -2.065633049963828e-17,
  8.396762383081967e-19,  1.402768366503724e-20,  3.754223897483733e-01, -3.313850875861819e-03,  2.380899889219198e-05, -2.315309433749595e-08, -1.335794453259394e-09,
 -5.449967124302998e-11,  1.366050379829102e-12,  4.165639049329676e-14, -1.324963148826031e-15, -2.981714126259320e-17,  1.240827007437488e-18,  2.022383276593077e-20,
  4.927799520118514e-01, -4.339918468500246e-03,  3.049954175851998e-05, -1.643449143418656e-09, -2.234198302884195e-09, -7.466003645926266e-11,  1.966379319714005e-12,
  5.914472768986014e-14, -1.931466178258050e-15, -4.234301095105778e-17,  1.821868560136488e-18,  2.862187711492015e-20,  6.318709334950567e-01, -5.547218324025081e-03,
  3.774765058711518e-05,  5.039989103400738e-08, -3.755079720215264e-09, -1.015244330091743e-10,  2.860856216110676e-12,  8.370672398223840e-14, -2.845199068004395e-15,
 -5.995775131779164e-17,  2.711634848453978e-18,  4.018747176898205e-20,  7.971334849479872e-01, -6.965118471382029e-03,  4.505681519830554e-05,  1.638518305953037e-07,
 -6.467741398531359e-09, -1.395535984458301e-10,  4.329094419119412e-12,  1.196316947801460e-13, -4.343835478846543e-15, -8.572431443866856e-17,  4.203917020491277e-18,
  5.622688024428720e-20,  9.958951569896760e-01, -8.635192468701281e-03,  5.102113143571987e-05,  4.149813421112384e-07, -1.179546075757726e-08, -2.007496287048390e-10,
  7.199979174487356e-12,  1.745618163119825e-13, -7.191749536382698e-15, -1.245911282501907e-16,  7.122413670148389e-18,  7.645279139468556e-20,  1.242045542011680e+00,
 -1.060968140500435e-02,  5.064375243719450e-05,  1.052661455726352e-06, -2.444521048309452e-08, -3.368808146075253e-10,  1.525872201742527e-11,  2.518112376917541e-13,
 -1.448284780649934e-14, -1.681374995622250e-16,  1.470205525181313e-17,  6.874032560993649e-20,  1.570146906339515e+00, -1.281872445220301e-02,  1.282940233182647e-05,
  3.574280491222409e-06, -7.138235856607930e-08, -1.282237887128977e-09,  7.861496582380259e-11, -1.447594216581730e-13, -6.596065238811516e-14,  1.056119533130633e-15,
  4.414348831241249e-17, -1.528783833013057e-18,  1.245033431241022e-02, -1.076458042125111e-04,  8.307697535441372e-07, -3.019352306835655e-09, -4.035429437138449e-11,
 -5.435292195949100e-13,  5.155145940462165e-14, -1.636406561135528e-16, -3.925275942271065e-17,  5.299017328286238e-19,  2.633706226860941e-20, -6.940517412098712e-22,
  3.695174525746144e-02, -3.194278394018960e-04,  2.460824557717045e-06, -8.745652741416155e-09, -1.247149656435068e-10, -1.599232718804170e-12,  1.550050030501235e-13,
 -4.995113041363834e-16, -1.182234516721275e-16,  1.604891142437562e-18,  7.929896980234788e-20, -2.100336006226790e-21,  7.408138166082573e-02, -6.402129827356686e-04,
  4.918298194618742e-06, -1.685592847603309e-08, -2.656112727832485e-10, -3.161460463339844e-12,  3.170759769742896e-13, -1.046182057046531e-15, -2.424434498044541e-16,
  3.320025741831084e-18,  1.625385412563175e-19, -4.339445824022649e-21,  1.243363908028077e-01, -1.074089117768222e-03,  8.218579123823141e-06, -2.667437713893366e-08,
 -4.830958161904424e-10, -5.196169564893684e-12,  5.473301718966358e-13, -1.867200791798535e-15, -4.198919646273403e-16,  5.821772879995565e-18,  2.812895609270147e-19,
 -7.595780381172728e-21,  1.884329446364661e-01, -1.626911570845853e-03,  1.238088553479822e-05, -3.708853993305597e-08, -8.095142170501857e-10, -7.638488762033498e-12,
  8.610139476385934e-13, -3.072859649712429e-15, -6.632385590624402e-16,  9.352477307540347e-18,  4.438098323944498e-19, -1.217301162940501e-20,  2.673724369127878e-01,
 -2.306803900071968e-03,  1.742643964092408e-05, -4.627418953478643e-08, -1.296876703059757e-09, -1.036480942307880e-11,  1.282358970330587e-12, -4.858027205762636e-15,
 -9.924789664511687e-16,  1.431607996297583e-17,  6.630049093065279e-19, -1.857413988198727e-20,  3.625455649532159e-01, -3.124923250095185e-03,  2.337358146638897e-05,
 -5.116317071731731e-08, -2.031095955021276e-09, -1.313351098405073e-11,  1.850991558610710e-12, -7.584359522307462e-15, -1.439914908511740e-15,  2.141296702145598e-17,
  9.594044104160556e-19, -2.766417304348661e-20,  4.759071620846375e-01, -4.096703307600234e-03,  3.022557487481511e-05, -4.634746150943944e-08, -3.161450538016912e-09,
 -1.545005411604901e-11,  2.635360313314481e-12, -1.197607775541790e-14, -2.060173200610476e-15,  3.194112289804820e-17,  1.366866105555505e-18, -4.102876185206232e-20,
  6.102882419786311e-01, -5.243966246685120e-03,  3.793873144717415e-05, -2.160072921245120e-08, -4.967866089603535e-09, -1.622723397920398e-11,  3.764100445804484e-12,
 -1.964879279930727e-14, -2.952148910783708e-15,  4.855260183043568e-17,  1.944035045038859e-18, -6.185867731068219e-20,  7.700036611891458e-01, -6.598729316834852e-03,
  4.633069063364158e-05,  4.451623915544174e-08, -8.037354762868185e-09, -1.280031925860351e-11,  5.511619296296039e-12, -3.481351518431544e-14, -4.312636838729539e-15,
  7.749421586786482e-17,  2.797608259063245e-18, -9.749518857315170e-20,  9.621974165324243e-01, -8.210550592538213e-03,  5.476979997521215e-05,  2.046835734878412e-07,
 -1.383116318083275e-08,  2.575842668234731e-12,  8.593629353225713e-12, -7.142597701098631e-14, -6.585409718593779e-15,  1.370878237543833e-16,  4.115510166845012e-18,
 -1.685550170075173e-19,  1.200487229280341e+00, -1.016102757205180e-02,  6.077526690162698e-05,  6.289575251577763e-07, -2.722938708027393e-08,  5.996624149233866e-11,
  1.569870302432709e-11, -2.002675675684274e-13, -1.088091988599184e-14,  3.062823786102752e-16,  5.849455365444737e-18, -3.540249924188854e-19,  1.519319755918584e+00,
 -1.256524516098262e-02,  4.834093142390278e-05,  2.324392024696055e-06, -7.953798986292218e-08,  3.612892412347481e-10,  5.236310290350728e-11, -1.443060752776128e-12,
 -1.286041704405553e-14,  1.468299766447707e-15, -1.836347674892784e-17, -8.850782381159792e-19,  1.203279788507476e-02, -1.011559580207989e-04,  7.905127463932976e-07,
 -3.688589709260340e-09, -3.986114815315422e-11,  5.200581138182139e-13,  3.331981265636267e-14, -9.775906563028735e-16, -9.449884977469769e-18,  8.992663020872900e-19,
 -6.904694625939433e-21, -5.829422397276279e-22,  3.571269291943287e-02, -3.001961262907770e-04,  2.343473680629192e-06, -1.080642935240202e-08, -1.225501426436701e-10,
  1.595922612285709e-12,  9.995033286282191e-14, -2.946786934966132e-15, -2.824226064321947e-17,  2.710225712912427e-18, -2.104353235846656e-20, -1.754682795539848e-21,
  7.159783637450909e-02, -6.017501546222100e-04,  4.689719779273670e-06, -2.122203221845395e-08, -2.590461903739038e-10,  3.365349185053342e-12,  2.037006884604766e-13,
 -6.051215098098514e-15, -5.720792367857229e-17,  5.563612136435874e-18, -4.395454280089813e-20, -3.594844940966139e-21,  1.201693140369559e-01, -1.009755706760245e-03,
  7.850884210950109e-06, -3.456356763756827e-08, -4.666938753020611e-10,  6.047659797598807e-12,  3.497670501917211e-13, -1.050160181404336e-14, -9.731973889922303e-17,
  9.649733048699268e-18, -7.811016268608093e-20, -6.216788167070443e-21,  1.821202564544815e-01, -1.529869543898382e-03,  1.185653211402265e-05, -5.020760002330865e-08,
 -7.733288377368302e-10,  1.000043420384727e-11,  5.462402362559977e-13, -1.663744838412067e-14, -1.498931624181520e-16,  1.527235250973889e-17, -1.276932125873770e-19,
 -9.798368415024736e-21,  2.584200218600128e-01, -2.169971650940088e-03,  1.674495961327200e-05, -6.711364792587998e-08, -1.223422746952707e-09,  1.580695365281028e-11,
  8.055756813850443e-13, -2.500559963503131e-14, -2.165063823126669e-16,  2.291421526599711e-17, -1.998634810334926e-19, -1.461523246969051e-20,  3.504151735035764e-01,
 -2.940947870623205e-03,  2.256339009844515e-05, -8.350303231806705e-08, -1.889856010966065e-09,  2.444863495267672e-11,  1.147284114035903e-12, -3.651470188468602e-14,
 -2.986129936458102e-16,  3.336215290548670e-17, -3.074152335450157e-19, -2.110041220218716e-20,  4.599992175389529e-01, -3.857985512377171e-03,  2.936624242467688e-05,
 -9.619763572230856e-08, -2.898045860871048e-09,  3.767104026934987e-11,  1.603160760128396e-12, -5.276331106804331e-14, -3.961131756601088e-16,  4.796217043532456e-17,
 -4.748476955535489e-19, -2.995429269480303e-20,  5.899158530687996e-01, -4.942838889332224e-03,  3.720687738630393e-05, -9.912882168787977e-08, -4.480402129414137e-09,
  5.884587129198462e-11,  2.228322893337597e-12, -7.681677311853329e-14, -5.021538999034187e-16,  6.918815563344756e-17, -7.539506648637639e-19, -4.235085197780903e-20,
  7.443503618233427e-01, -6.228108586509649e-03,  4.610663544810746e-05, -7.951544908063956e-08, -7.117072539852433e-09,  9.531935222262289e-11,  3.127310667618218e-12,
 -1.153512004891671e-13, -5.822300447328451e-16,  1.020685416799301e-16, -1.270849225841626e-18, -6.029174531438726e-20,  9.302418667007413e-01, -7.766257623849298e-03,
  5.593346592977620e-05, -6.038561417708791e-09, -1.197993121793061e-08,  1.663407550370632e-10,  4.526445812777179e-12, -1.860875459886343e-13, -4.702307427291634e-16,
  1.583412446873804e-16, -2.405903023311680e-18, -8.667176833478412e-20,  1.160853141263912e+00, -9.651829575390274e-03,  6.580801733855789e-05,  2.208791075224000e-07,
 -2.287317577901480e-08,  3.411723592744391e-10,  7.026927766116488e-12, -3.556397555258130e-13,  9.106521990280635e-16,  2.700203884818042e-16, -5.804048162512777e-18,
 -1.149063075282989e-19,  1.469979539347005e+00, -1.208765806020899e-02,  6.901931281855941e-05,  1.163861527951971e-06, -6.307405682707769e-08,  1.129024375729874e-09,
  1.282432280855175e-11, -1.199772365967900e-12,  2.144680651364976e-14,  3.895031882637930e-16, -2.642922874431721e-17,  3.434509012429849e-19,  1.164052795737495e-02,
 -9.501872526516825e-05,  7.428808543736670e-07, -4.209275065958813e-09, -2.374031689616469e-11,  9.840966187324253e-13,  5.973718660183655e-15, -8.524793172956112e-16,
  1.375111929808474e-17,  3.269818835086327e-19, -1.657736028469385e-20,  1.017027606227210e-22,  3.454853973588053e-02, -2.819972494832841e-04,  2.203428496146380e-06,
 -1.241036683648169e-08, -7.350324728372018e-11,  2.983814868674541e-12,  1.761552632083448e-14, -2.563589495214071e-15,  4.155572415407602e-17,  9.799745473856798e-19,
 -4.998016222673750e-20,  3.117320047320755e-22,  6.926416748468520e-02, -5.653149668067943e-04,  4.413106992023321e-06, -2.462181881613013e-08, -1.569234834929008e-10,
  6.180862341195232e-12,  3.493486412325539e-14, -5.244765505836408e-15,  8.566990286053980e-17,  1.994034650566765e-18, -1.026603328569147e-19,  6.567412463973333e-22,
  1.162531145477950e-01, -9.487229780550790e-04,  7.396507626474046e-06, -4.070944289553441e-08, -2.861844175566452e-10,  1.085041552849067e-11,  5.764553432958092e-14,
 -9.053759870256216e-15,  1.494915282373947e-16,  3.414891467288068e-18, -1.782012099225797e-19,  1.180586951181765e-21,  1.761863949460110e-01, -1.437618573619497e-03,
  1.118826593962908e-05, -6.043061243433205e-08, -4.807851217309501e-10,  1.743407707236837e-11,  8.509499113092131e-14, -1.423936023656153e-14,  2.385610003946600e-16,
  5.310420149642563e-18, -2.823299104494226e-19,  1.958172164690605e-21,  2.500025229806765e-01, -2.039536556097707e-03,  1.583531806194815e-05, -8.335195173443889e-08,
 -7.717525342533360e-10,  2.663827287721497e-11,  1.158451874617229e-13, -2.119095405608332e-14,  3.619362246706534e-16,  7.777539060070596e-18, -4.241606695330590e-19,
  3.119016350610129e-21,  3.390053834220095e-01, -2.764917813226011e-03,  2.139994194848584e-05, -1.086868494031680e-07, -1.209648069997546e-09,  3.962411684359708e-11,
  1.467264087766299e-13, -3.053149789235711e-14,  5.349363782371712e-16,  1.095057607417353e-17, -6.185672362750507e-19,  4.896830582795715e-21,  4.450288010118661e-01,
 -3.628393018579788e-03,  2.796389971908872e-05, -1.349578259252308e-07, -1.880808478546846e-09,  5.840052778010871e-11,  1.705397207937471e-13, -4.330358981805191e-14,
  7.850626988484733e-16,  1.500551503885989e-17, -8.910101391368851e-19,  7.742724310133320e-21,  5.707306905184301e-01, -4.651056067794949e-03,  3.563344592864753e-05,
 -1.592312928999539e-07, -2.943513568189273e-09,  8.672332875512844e-11,  1.698560615622197e-13, -6.137700510988817e-14,  1.166244182512589e-15,  2.013009591382269e-17,
 -1.288249902186823e-18,  1.261448190800257e-20,  7.201670752403020e-01, -5.864842175738624e-03,  4.454232633191034e-05, -1.751562872393360e-07, -4.719817904628726e-09,
  1.324596566083427e-10,  9.758551060779512e-14, -8.845974734157957e-14,  1.798745427582085e-15,  2.630048933344539e-17, -1.904966991986859e-18,  2.183892414875861e-20,
  9.000670834644741e-01, -7.322055810848049e-03,  5.483505217793526e-05, -1.669427698237293e-07, -7.978108695743529e-09,  2.152217962516604e-10, -1.991129020032547e-13,
 -1.330923562436790e-13,  3.009024894996698e-15,  3.185478077049458e-17, -2.959652022162614e-18,  4.231896681219992e-20,  1.123307493651768e+00, -9.120422849634666e-03,
  6.650870583885182e-05, -8.456940763387630e-08, -1.512104448790247e-08,  4.008546958621471e-10, -1.411283697026701e-12, -2.202371984961430e-13,  6.038685780067861e-15,
  2.141371145259977e-17, -5.026379951151419e-18,  1.023457610753758e-19,  1.422799786618825e+00, -1.149502024689977e-02,  7.770224826984499e-05,  3.421178988178467e-07,
 -3.970484121144854e-08,  1.117764485207412e-09, -1.030235554323126e-11, -4.570703792005590e-13,  2.097900390765744e-14, -2.823448838130075e-16, -6.930029235155468e-18,
  3.952837115342308e-19,  1.127201212028943e-02, -8.928267086833628e-05,  6.907454168725868e-07, -4.430999025839483e-09, -4.270579440924005e-12,  8.973977002966981e-13,
 -1.079545227525079e-14, -3.370935795801409e-16,  1.555927607008342e-17, -1.574044800054546e-19, -6.534741063956269e-21,  2.602067863947234e-22,  3.345484021488614e-02,
 -2.649809364972256e-04,  2.049431984331294e-06, -1.310744986427342e-08, -1.454552684737602e-11,  2.715323071825425e-12, -3.274431762871885e-14, -1.009653697750470e-15,
  4.683693222678136e-17, -4.774343066381944e-19, -1.959107075988564e-20,  7.844685142089963e-22,  6.707159829895697e-02, -5.312251735922067e-04,  4.106685758346844e-06,
 -2.614187081874918e-08, -3.503097911987168e-11,  5.606986958372160e-12, -6.787479196800245e-14, -2.052637822029341e-15,  9.597012636973313e-17, -9.898696598086573e-19,
 -3.988407513977777e-20,  1.611144861257203e-21,  1.125733848340799e-01, -8.915662162245826e-04,  6.887715535897845e-06, -4.355262311851323e-08, -7.276655577691099e-11,
  9.800624340289875e-12, -1.192907087326126e-13, -3.511642752535498e-15,  1.660233873398772e-16, -1.740912963727947e-18, -6.835565874006041e-20,  2.796176405058229e-21,
  1.706101906655930e-01, -1.351117272663810e-03,  1.042847959801807e-05, -6.534125292877151e-08, -1.390321703216940e-10,  1.565948487353264e-11, -1.920314599949882e-13,
 -5.455371048644833e-15,  2.618536804159287e-16, -2.806936624556296e-18, -1.064150461077165e-19,  4.428748473859228e-21,  2.420911642655717e-01, -1.917024248109444e-03,
  1.477858749901866e-05, -9.146276124354426e-08, -2.517796900070384e-10,  2.375842891240361e-11, -2.942813615020714e-13, -7.984618416287142e-15,  3.911105546005001e-16,
 -4.314869461374522e-18, -1.561011732060725e-19,  6.650265291545705e-21,  3.282794659295172e-01, -2.599204089284450e-03,  2.000564182773678e-05, -1.217627870172541e-07,
 -4.402297563205369e-10,  3.502950284721823e-11, -4.397489711112020e-13, -1.124643403303674e-14,  5.661262231818919e-16, -6.483442699071920e-18, -2.203072729715461e-19,
  9.690219754583391e-21,  4.309517889317285e-01, -3.411582986756592e-03,  2.620211883519080e-05, -1.558413213013592e-07, -7.541165358710626e-10,  5.105786079362477e-11,
 -6.527069596111210e-13, -1.545558723255833e-14,  8.077298128793310e-16, -9.713423585446302e-18, -3.030141821564803e-19,  1.393821331934612e-20,  5.526835419537957e-01,
 -4.374301552582738e-03,  3.349664625848993e-05, -1.927333699931664e-07, -1.284032743373664e-09,  7.474328666504180e-11, -9.798301030837975e-13, -2.092163255523053e-14,
  1.153678093472238e-15, -1.480754752286783e-17, -4.091342263404645e-19,  2.010061763850722e-20,  6.974055214576687e-01, -5.517996373293540e-03,  4.207317949121744e-05,
 -2.300712094053319e-07, -2.212236324925428e-09,  1.119898581167678e-10, -1.522319089388269e-12, -2.804701436121242e-14,  1.679776107342300e-15, -2.359315073145164e-17,
 -5.416448321864171e-19,  2.957729631763975e-20,  8.716408922966137e-01, -6.893238712335137e-03,  5.220407003320930e-05, -2.614815888444337e-07, -3.965227807988707e-09,
  1.769511805861234e-10, -2.543613872902198e-12, -3.700710569517273e-14,  2.563014302403438e-15, -4.111417220663817e-17, -6.808301303102312e-19,  4.546945910604893e-20,
  1.087878485243355e+00, -8.595936934664988e-03,  6.429606824965168e-05, -2.659161775360170e-07, -7.830599437539032e-09,  3.143738696856645e-10, -4.979766786078014e-12,
 -4.421527558441761e-14,  4.326950813491382e-15, -8.660826223364446e-17, -6.050049906828001e-19,  7.508370720852255e-20,  1.378075805678044e+00, -1.086618511665374e-02,
  7.868131290383456e-05, -1.308710744739721e-07, -2.051110153150757e-08,  7.822275467714386e-10, -1.544156149408532e-11,  2.655210625128240e-14,  9.162292317005275e-15,
 -3.056663199274780e-16,  3.483802643667124e-18,  9.005459559325242e-20  };
  constexpr double w[4992] = {  1.252722808568783e-04, -6.662780861693856e-06,  2.213102276301004e-07, -5.866562685139340e-09,  1.353890403762193e-10,
 -2.836234134087009e-12,  5.522278626369490e-14, -1.014305089340424e-15,  1.775298801176696e-17, -2.982374728729528e-19,  4.834810573096851e-21, -7.593202153716560e-23,
  9.648925498351180e-04, -6.997900842360860e-05,  3.165176893146724e-06, -1.126458117153782e-07,  3.431883464083881e-09, -9.337670640486872e-11,  2.326487507062703e-12,
 -5.395199431701912e-14,  1.177879630611779e-15, -2.441163949225329e-17,  4.833259011877660e-19, -9.184028693252844e-21,  3.305262873711376e-03, -3.319238105179187e-04,
  2.008895837889871e-05, -9.300233382551564e-07,  3.604330976076579e-08, -1.225011213782207e-09,  3.754671979618341e-11, -1.057134888476160e-12,  2.769837696259125e-14,
 -6.818728382628679e-16,  1.588754524279171e-17, -3.522296552269102e-19,  7.607210808944764e-03, -1.030810133559336e-03,  8.089644405078092e-05, -4.722051852879159e-06,
  2.258993217216900e-07, -9.317450530905845e-09,  3.416945768223440e-10, -1.137177148197970e-11,  3.484704820749441e-13, -9.938553397775122e-15,  2.660032170094476e-16,
 -6.721252685247165e-18,  1.366610376121622e-02, -2.404031866255686e-03,  2.369531303418178e-04, -1.695574601878354e-05,  9.759270914981801e-07, -4.769929777857284e-08,
  2.046536654609634e-09, -7.881349655454946e-11,  2.767823657651273e-12, -8.969377951538628e-14,  2.706621633238087e-15, -7.655520293071393e-17,  2.060485345973502e-02,
 -4.520624563038980e-03,  5.427247839496136e-04, -4.638380549552901e-05,  3.138356514669261e-06, -1.779511993641005e-07,  8.758478362620044e-09, -3.831634130747716e-10,
  1.515464470014488e-11, -5.488306995455621e-13,  1.837974290421015e-14, -5.731921362408065e-16,  2.713508206912940e-02, -7.150028385733835e-03,  1.015590051063969e-03,
 -1.011447016695472e-04,  7.871593895585511e-06, -5.076928974555141e-07,  2.814900445988408e-08, -1.375468474723258e-09,  6.030406480570205e-11, -2.404393383681566e-12,
  8.810067115220643e-14, -2.988771417276117e-15,  3.191501876191823e-02, -9.759420610933390e-03,  1.595743564139122e-03, -1.808969023939093e-04,  1.585981698760864e-05,
 -1.141820550836186e-06,  7.009498046322192e-08, -3.764843553012430e-09,  1.802509346145638e-10, -7.801892766041722e-12,  3.086687181663920e-13, -1.124912382743475e-14,
  3.385865860680767e-02, -1.165216955920664e-02,  2.137449720751896e-03, -2.696762528803306e-04,  2.610502904063256e-05, -2.059931699271691e-06,  1.376844433935423e-07,
 -8.003400319036691e-09,  4.124396262238753e-10, -1.911927965856349e-11,  8.064312245297401e-13, -3.119728928584247e-14,  3.233304560458478e-02, -1.218444454222854e-02,
  2.447611616028507e-03, -3.363420074278839e-04,  3.525173582728393e-05, -2.994832860640287e-06,  2.143864875845265e-07, -1.328297111599125e-08,  7.264019524400743e-10,
 -3.558994564486982e-11,  1.580682175215292e-12, -6.416160067640597e-14,  2.724357292024962e-02, -1.097086865032497e-02,  2.358953086813773e-03, -3.457697941502862e-04,
  3.849433856698889e-05, -3.459432651611838e-06,  2.609480373258808e-07, -1.697478029027762e-08,  9.713683962253185e-10, -4.964645134841559e-11,  2.293592427622144e-12,
 -9.657575801786296e-14,  1.902938158267508e-02, -8.010471969027853e-03,  1.804098947849084e-03, -2.764124667295734e-04,  3.207877068475285e-05, -2.996942658060596e-06,
  2.343872424903143e-07, -1.576938421989698e-08,  9.311577746575575e-10, -4.900334951147364e-11,  2.326422081622471e-12, -1.004720961066775e-13,  8.599811751206386e-03,
 -3.708301030669259e-03,  8.567293219037683e-04, -1.345134131210212e-04,  1.597438537774387e-05, -1.524875046302443e-06,  1.216777922741231e-07, -8.341045693805821e-09,
  5.011901507829529e-10, -2.680781815665594e-11,  1.292110628314800e-12, -5.659379438993099e-14,  1.017631038596470e-04, -5.140955112984715e-06,  1.622463129008857e-07,
 -4.090741353450809e-09,  8.991143890711383e-11, -1.796230560589589e-12,  3.339408358519721e-14, -5.863417924061049e-16,  9.820713151476370e-18, -1.580319935004430e-19,
  2.456205039918435e-21, -3.701565388774573e-23,  7.282110324753835e-04, -4.925561380742578e-05,  2.089847170600042e-06, -7.008843348937370e-08,  2.019339209071997e-09,
 -5.210553368260294e-11,  1.234042177333729e-12, -2.725775632618531e-14,  5.678046447673536e-16, -1.124581674952790e-17,  2.130821430023877e-19, -3.879986435880307e-21,
  2.240042342650426e-03, -2.076369427393960e-04,  1.171520852091285e-05, -5.088859194103593e-07,  1.859194413398146e-08, -5.978756396582540e-10,  1.739106065519940e-11,
 -4.658899850524245e-13,  1.164067341712305e-14, -2.738173201547422e-16,  6.106970513359579e-18, -1.298166357849733e-19,  4.490596438730086e-03, -5.605783241333416e-04,
  4.096275433406277e-05, -2.242086120873906e-06,  1.011027659163598e-07, -3.946967227770628e-09,  1.374685250758536e-10, -4.357660877831820e-12,  1.275119603019562e-13,
 -3.480512320947724e-15,  8.933457420769936e-17, -2.168759517903406e-18,  6.849792502989694e-03, -1.115102259802682e-03,  1.026488759536664e-04, -6.906342533990339e-06,
  3.756997733374583e-07, -1.742802290373644e-08,  7.121814003260320e-10, -2.620071075620143e-11,  8.813240107274037e-13, -2.741955410062789e-14,  7.960510838508986e-16,
 -2.170471222142772e-17,  8.604651901660695e-03, -1.762688367965352e-03,  1.989304740446204e-04, -1.607524711264638e-05,  1.033275733608693e-06, -5.587823121817747e-08,
  2.631768682569788e-09, -1.104935459700891e-10,  4.204737627382180e-12, -1.468448151386163e-13,  4.751996894156565e-15, -1.434770173764064e-16,  9.339337693213138e-03,
 -2.324417260361944e-03,  3.131819607364768e-04, -2.972282433205945e-05,  2.213130042225609e-06, -1.370327701424183e-07,  7.315584893450766e-09, -3.450843144897323e-10,
  1.463890721541672e-11, -5.659135812884771e-13,  2.014257671613020e-14, -6.649293607587488e-16,  9.039752935747582e-03, -2.644117111493844e-03,  4.144349222172665e-04,
 -4.518639324397823e-05,  3.822110321148105e-06, -2.662098721883540e-07,  1.584851188752821e-08, -8.272945019151887e-10,  3.856914545737442e-11, -1.628419234916797e-12,
  6.294285147817755e-14, -2.244405166865214e-15,  7.961100139722972e-03, -2.653209503763640e-03,  4.716591529391717e-04, -5.779575996683061e-05,  5.445754827474495e-06,
 -4.191295456317020e-07,  2.737385935213385e-08, -1.557384898384180e-09,  7.866774255020865e-11, -3.579369313923165e-12,  1.483651528304177e-13, -5.646908629687746e-15,
  6.431685391840619e-03, -2.373259519347574e-03,  4.667713201610671e-04, -6.288185210984117e-05,  6.470271822897400e-06, -5.403767535169880e-07,  3.807503741788323e-08,
 -2.324587641723269e-09,  1.253949677142243e-10, -6.065794817592449e-12,  2.662145144404890e-13, -1.068657182503046e-14,  4.717856623554726e-03, -1.877095438697557e-03,
  3.986385327427595e-04, -5.774880938565398e-05,  6.358987869504395e-06, -5.656708691031449e-07,  4.226606649696996e-08, -2.725256138819520e-09,  1.546732023745385e-10,
 -7.844904211248404e-12,  3.598356697466516e-13, -1.505060098643702e-14,  2.976635645531572e-03, -1.246013092912660e-03,  2.789735794581436e-04, -4.250168047527845e-05,
  4.906332034360126e-06, -4.560951808432132e-07,  3.550494704662122e-08, -2.378362038744381e-09,  1.398670579242676e-10, -7.332600265576077e-12,  3.468671605587455e-13,
 -1.493003075201006e-14,  1.268565174747288e-03, -5.459409993920793e-04,  1.258612878834018e-04, -1.972023607045909e-05,  2.337252802257859e-06, -2.226850732719388e-07,
  1.773712567711504e-08, -1.213795313366418e-09,  7.281423569789081e-11, -3.888638543195035e-12,  1.871498564276523e-13, -8.185464051780958e-15,  8.351557984556756e-05,
 -4.017356972284545e-06,  1.207306107329267e-07, -2.901013652426881e-09,  6.083504428141585e-11, -1.160921741610327e-12,  2.063968554425995e-14, -3.469234074979649e-16,
  5.567954631748356e-18, -8.593220146894361e-20,  1.282018123817666e-21, -1.855996845457840e-23,  5.599821775978432e-04, -3.542171991797051e-05,  1.412835966251562e-06,
 -4.473352771677097e-08,  1.220792122853868e-09, -2.991653477716091e-11,  6.743823800371543e-13, -1.420466631562077e-14,  2.826307169596436e-16, -5.354621942918085e-18,
  9.718072082280685e-20, -1.697064816069552e-21,  1.564365729415899e-03, -1.340655279649153e-04,  7.061745454820343e-06, -2.881769951692932e-07,  9.935891166030144e-09,
 -3.025997251810509e-10,  8.360170749339722e-12, -2.132401390664779e-13,  5.083779655319456e-15, -1.143179197671228e-16,  2.441541351481809e-18, -4.977846373656767e-20,
  2.765453169252769e-03, -3.180079967032850e-04,  2.164306462245079e-05, -1.111159861686328e-06,  4.724123574866656e-08, -1.745879661694176e-09,  5.775545907161713e-11,
 -1.743856647872646e-12,  4.872418664971691e-14, -1.272682327844250e-15,  3.132064229638321e-17, -7.303766420923918e-19,  3.622553179980689e-03, -5.447226972691556e-04,
  4.678045071078285e-05, -2.956880486005967e-06,  1.519124274608650e-07, -6.683445853196041e-09,  2.599362696653470e-10, -9.128846087495173e-12,  2.939015942155124e-13,
 -8.772007221910995e-15,  2.448265420223986e-16, -6.429730027386928e-18,  3.822690746697733e-03, -7.287390678390798e-04,  7.712880615972270e-05, -5.881621830521418e-06,
  3.585349795913649e-07, -1.846290465908120e-08,  8.308790597138236e-10, -3.343071827048004e-11,  1.222348750337580e-12, -4.111182811745208e-14,  1.283926978862204e-15,
 -3.748379978392895e-17,  3.430845415081616e-03, -8.031369457807947e-04,  1.023102092830951e-04, -9.227245052296783e-06,  6.557170329066521e-07, -3.889034573300226e-08,
  1.994950759398393e-09, -9.066900494235472e-11,  3.714839441561442e-12, -1.390001217157896e-13,  4.797974171540012e-15, -1.538804543031868e-16,  2.725554808107101e-03,
 -7.592274175505564e-04,  1.136572385889323e-04, -1.188102775816647e-05,  9.668340413260108e-07, -6.498070824380183e-08,  3.742894509104633e-09, -1.894748042433365e-10,
  8.584332359474193e-12, -3.528733199503940e-13,  1.330204782384711e-14, -4.633176625445043e-16,  1.975662163766066e-03, -6.351614587166846e-04,  1.090474988451890e-04,
 -1.293842809703943e-05,  1.183419130453078e-06, -8.861699307813228e-08,  5.642623494883243e-09, -3.135536341830572e-10,  1.549520007681853e-11, -6.907740644014996e-13,
  2.809150568555841e-14, -1.050306648882462e-15,  1.333024099475408e-03, -4.802223269678447e-04,  9.222201941593323e-05, -1.214969602231698e-05,  1.224592386273211e-06,
 -1.003388246425126e-07,  6.945937448528752e-09, -4.171685425200108e-10,  2.216283025706062e-11, -1.056988020934209e-12,  4.577917200920731e-14, -1.815185145189519e-15,
  8.388896535915093e-04, -3.291659586433207e-04,  6.892043027502391e-05, -9.851391736074078e-06,  1.071351036962657e-06, -9.420802734976125e-08,  6.964009090657394e-09,
 -4.445810400942494e-10,  2.499991159649375e-11, -1.257094348774417e-12,  5.719977411609304e-14, -2.374615477654315e-15,  4.718618919975079e-04, -1.962470044141370e-04,
  4.364218143606535e-05, -6.606118423537375e-06,  7.579983139331454e-07, -7.006684206489703e-08,  5.425713825825186e-09, -3.616680202204036e-10,  2.117155293693832e-11,
 -1.105172027075097e-12,  5.207011066557345e-14, -2.232815717634091e-15,  1.880340459418196e-04, -8.074437308733652e-05,  1.857070083335017e-05, -2.902977615552062e-06,
  3.433024580827766e-07, -3.263993978428728e-08,  2.594626622742206e-09, -1.772207220803386e-10,  1.061216701997932e-11, -5.657735812566329e-13,  2.718490586620474e-14,
 -1.187162623667789e-15,  6.917860074784011e-05, -3.175818394500368e-06,  9.107135922318915e-08, -2.089460176169426e-09,  4.187640794468009e-11, -7.645422667002048e-13,
  1.301749864135584e-14, -2.097494903761467e-16,  3.229923818659040e-18, -4.786738799182506e-20,  6.862742525193288e-22, -9.554714927555197e-24,  4.379162155835650e-04,
 -2.597454971027992e-05,  9.760036299813641e-07, -2.922698998555197e-08,  7.567101903938013e-10, -1.763664301770759e-11,  3.788991393426430e-13, -7.619514008025902e-15,
  1.449656267494599e-16, -2.629795980356555e-18,  4.575751445401433e-20, -7.669643485998786e-22,  1.122477418257484e-03, -8.909950829274365e-05,  4.388219607658881e-06,
 -1.684591793191400e-07,  5.487729842976859e-09, -1.584428547559080e-10,  4.161374381507216e-12, -1.011400883546729e-13,  2.302267097854980e-15, -4.951984289042046e-17,
  1.013276856722722e-18, -1.982245742852182e-20,  1.770433212538641e-03, -1.875851715938004e-04,  1.189722019556435e-05, -5.732275709493340e-07,  2.298791214269417e-08,
 -8.045244719450931e-10,  2.528554436492777e-11, -7.273384905864503e-13,  1.940671055672219e-14, -4.850925420163824e-16,  1.144602932824930e-17, -2.563617105730211e-19,
  2.014694667930059e-03, -2.794108579827227e-04,  2.236994630846717e-05, -1.327630231081316e-06,  6.438643915730710e-08, -2.685308830399721e-09,  9.935049114770510e-11,
 -3.329045490191757e-12,  1.025252339378516e-13, -2.933921830325285e-15,  7.867248059773894e-17, -1.988845722459003e-18,  1.802734243731186e-03, -3.188381670908121e-04,
  3.158241529653072e-05, -2.268975579405540e-06,  1.309802282622793e-07, -6.414037780415481e-09,  2.754535033649400e-10, -1.060820481879905e-11,  3.722377109140456e-13,
 -1.204304853576561e-14,  3.625492125158526e-16, -1.022291708879666e-17,  1.344880946992263e-03, -2.948959949203360e-04,  3.540726481129759e-05, -3.026712809882644e-06,
  2.048063441864194e-07, -1.161097300192093e-08,  5.711948114101274e-10, -2.496739435888175e-11,  9.862936532955951e-13, -3.566189783411442e-14,  1.191913674405919e-15,
 -3.708360711067830e-17,  8.764659989373370e-04, -2.314581730462708e-04,  3.297168019937897e-05, -3.293994063793739e-06,  2.571576788380150e-07, -1.663556724863126e-08,
  9.249242606752238e-10, -4.530899318803963e-11,  1.990857625839262e-12, -7.952774108265629e-14,  2.918539472845885e-15, -9.912930543253170e-17,  5.193480372867096e-04,
 -1.603853722130877e-04,  2.649584429871801e-05, -3.034183033984176e-06,  2.686239245075556e-07, -1.952015229858487e-08,  1.208913334153020e-09, -6.547152680035570e-11,
  3.159005409130478e-12, -1.377238430603679e-13,  5.485399413192189e-15, -2.011447155427678e-16,  2.890592686887249e-04, -1.013272113263578e-04,  1.894194460117173e-05,
 -2.433750868153704e-06,  2.396969618159195e-07, -1.922546854069871e-08,  1.304902810540014e-09, -7.695393970265887e-11,  4.019638863891898e-12, -1.887080398519603e-13,
  8.054065527502248e-15, -3.150175730393998e-16,  1.536819242166198e-04, -5.934296599277707e-05,  1.222493863142894e-05, -1.720940918025945e-06,  1.845229352969948e-07,
 -1.601462709146979e-08,  1.169560587418720e-09, -7.383041809506240e-11,  4.108612004197941e-12, -2.046049506668425e-13,  9.226244537704396e-15, -3.798222840526734e-16,
  7.594843614764735e-05, -3.135119589571872e-05,  6.917936855730722e-06, -1.039448334273467e-06,  1.184462527398909e-07, -1.087853699004407e-08,  8.373659770329989e-10,
 -5.550721627095128e-11,  3.232498524545079e-12, -1.679241113042238e-13,  7.876034649999376e-15, -3.363097013815518e-16,  2.802285596793079e-05, -1.200350246565662e-05,
  2.753381034314750e-06, -4.292963485387271e-07,  5.064294314712513e-08, -4.803700255747204e-09,  3.810134770792675e-10, -2.596989804755374e-11,  1.552022667073421e-12,
 -8.258848164943302e-14,  3.961219289948256e-15, -1.726934810726119e-16,  5.778834611601554e-05, -2.537212171964612e-06,  6.956336908590779e-08, -1.526594963506070e-09,
  2.928828415041699e-11, -5.123400812804175e-13,  8.365957194705414e-15, -1.293900738927832e-16,  1.914076689115032e-18, -2.727119096616268e-20,  3.761548355034391e-22,
 -5.041788891543948e-24,  3.476717024055727e-04, -1.938751405320454e-05,  6.877065008950960e-07, -1.951152031157403e-08,  4.800112136217897e-10, -1.065533285913487e-11,
  2.184469545440799e-13, -4.198948140968169e-15,  7.647133165952053e-17, -1.329649600149187e-18,  2.220070860713211e-20, -3.574721284279982e-22,  8.253169985537964e-04,
 -6.079694519976282e-05,  2.804225511058787e-06, -1.014116534896407e-07,  3.125149194369264e-09, -8.563259717547370e-11,  2.140107145049542e-12, -4.960447317637624e-14,
  1.078922980968294e-15, -2.221228830206377e-17,  4.357012019506448e-19, -8.182453301211402e-21,  1.174331137108378e-03, -1.147081623587355e-04,  6.784872932516216e-06,
 -3.070137405262555e-07,  1.162051329137868e-08, -3.853312083862416e-10,  1.151069968474453e-11, -3.155394599471005e-13,  8.041850012157004e-15, -1.923970688317159e-16,
  4.353020030940599e-18, -9.364496651565702e-20,  1.174309754203328e-03, -1.500384253261394e-04,  1.119394227633026e-05, -6.236321342688609e-07,  2.854326500539431e-08,
 -1.128204397227236e-09,  3.969621675244571e-11, -1.268697264304235e-12,  3.736235969505430e-14, -1.024696670886147e-15,  2.638700234244263e-17, -6.418020997931581e-19,
  9.001282609146923e-04, -1.472970098786709e-04,  1.363191907478874e-05, -9.214166268854136e-07,  5.031016291066676e-08, -2.340230593482952e-09,  9.580656317627949e-11,
 -3.527990625541770e-12,  1.186847317929417e-13, -3.689941035542396e-15,  1.069728564369159e-16, -2.910406760080774e-18,  5.620753726196938e-04, -1.149861178016475e-04,
  1.297496505380741e-05, -1.048746955846830e-06,  6.743061902162627e-08, -3.647135103923988e-09,  1.717598025276306e-10, -7.208521969085079e-12,  2.741194346083770e-13,
 -9.563106022039900e-15,  3.090292158776889e-16, -9.313917073841455e-18,  3.010190801601910e-04, -7.501252637998342e-05,  1.013085139519471e-05, -9.642549858795187e-07,
  7.201893883863981e-08, -4.473076781908147e-09,  2.395113524502023e-10, -1.132965771291889e-11,  4.818495936834879e-13, -1.867005251522377e-14,  6.658460672225391e-16,
 -2.201712275470502e-17,  1.451024061069700e-04, -4.284836507953486e-05,  6.784969365620269e-06, -7.473896620509489e-07,  6.385521798741907e-08, -4.490801810403497e-09,
  2.698465708807515e-10, -1.421087684641838e-11,  6.680756354436501e-13, -2.842909148848589e-14,  1.106974263618868e-15, -3.974327994437371e-17,  6.586407020854196e-05,
 -2.238142354101267e-05,  4.059019288321814e-06, -5.070912817033814e-07,  4.867020972349588e-08, -3.812062641887471e-09,  2.531298749504173e-10, -1.462831449698845e-11,
  7.498796340429448e-13, -3.459517596023219e-14,  1.452732050671032e-15, -5.596819486764935e-17,  2.911747664129198e-05, -1.103686708118695e-05,  2.231687254346760e-06,
 -3.087353381382521e-07,  3.257447405047163e-08, -2.785430330361476e-09,  2.006513150919537e-10, -1.250683348987476e-11,  6.878695935174887e-13, -3.388394545456280e-14,
  1.512528698627713e-15, -6.168414296648140e-17,  1.243956605280503e-05, -5.090445257529356e-06,  1.113193341744666e-06, -1.658437313502084e-07,  1.874883082984907e-08,
 -1.709343944816873e-09,  1.306811157004512e-10, -8.607930679755301e-12,  4.983494501933775e-13, -2.574733590465353e-14,  1.201467536237605e-15, -5.106011161694655e-17,
  4.201824028338325e-06, -1.794761325675276e-06,  4.104466465796283e-07, -6.380897953791303e-08,  7.506574349305324e-09, -7.101721650649044e-10,  5.618975832075875e-11,
 -3.820994407985682e-12,  2.278502660771860e-13, -1.209951929560501e-14,  5.791920653384459e-16, -2.520352429213556e-17,  4.864679247083821e-05, -2.046728891987970e-06,
  5.375000877022752e-08, -1.130165570291520e-09,  2.078812259534356e-11, -3.489240015039627e-13,  5.471388554447649e-15, -8.132794251205432e-17,  1.157127472942137e-18,
 -1.586771313640698e-20,  2.107896406141102e-22, -2.722775323534313e-24,  2.798071569081711e-04, -1.470637744721174e-05,  4.934411616541148e-07, -1.328685016988860e-08,
  3.110701115497890e-10, -6.585717429338008e-12,  1.290038866743072e-13, -2.372981813871727e-15,  4.141340764867972e-17, -6.908675804079164e-19,  1.107939714971496e-20,
 -1.715247770216542e-22,  6.203382750090603e-04, -4.249497949831867e-05,  1.838682441997686e-06, -6.273023251735026e-08,  1.831035347900584e-09, -4.766974349133568e-11,
  1.134767471220747e-12, -2.510609888265151e-14,  5.221945929110596e-16, -1.029729183338817e-17,  1.937488089345676e-19, -3.494945976769992e-21,  8.045203746877707e-04,
 -7.250628501694196e-05,  4.003473786411299e-06, -1.702809029597715e-07,  6.087751769209599e-09, -1.913880272082811e-10,  5.436906514112450e-12, -1.420973148572930e-13,
  3.460448647626322e-15, -7.926257461739128e-17,  1.719945766989248e-18, -3.554403348956220e-20,  7.149235014122697e-04, -8.408744180074026e-05,  5.845595476954102e-06,
 -3.057105881341819e-07,  1.320515524464315e-08, -4.946457285930356e-10,  1.655011976667505e-11, -5.044357961029114e-13,  1.420238679183329e-14, -3.732138890858064e-16,
  9.226664515032771e-18, -2.158442074290916e-19,  4.745035008096683e-04, -7.167084866671238e-05,  6.188720373909999e-06, -3.931489377259507e-07,  2.028523887163495e-08,
 -8.955408605475429e-10,  3.492030857344188e-11, -1.228538379843195e-12,  3.958994528543659e-14, -1.181831709856300e-15,  3.296613420675045e-17, -8.646707050658243e-19,
  2.500998540684071e-04, -4.755385892716331e-05,  5.029710162670436e-06, -3.835862582895430e-07,  2.339105941087154e-08, -1.204961410619564e-09,  5.423824611750487e-11,
 -2.182282857161411e-12,  7.976970894704654e-14, -2.681348117047086e-15,  8.366191166915506e-17, -2.439416060727438e-18,  1.104981831300555e-04, -2.586189137879973e-05,
  3.299517077588250e-06, -2.982938921991408e-07,  2.125792666041961e-08, -1.264615511139560e-09,  6.506853404728324e-11, -2.966081586555776e-12,  1.218655584714157e-13,
 -4.571741881798505e-15,  1.581768890417168e-16, -5.083557178246456e-18,  4.321822772766988e-05, -1.214416556740757e-05,  1.835830143809847e-06, -1.938470942873834e-07,
  1.593390503950908e-08, -1.081533222399775e-09,  6.289586655012901e-11, -3.213432794825279e-12,  1.468763937949707e-13, -6.088405339151328e-15,  2.313373134177706e-16,
 -8.117846334083292e-18,  1.583949303695221e-05, -5.195748989500851e-06,  9.107502931496333e-07, -1.102689855757894e-07,  1.028378398533985e-08, -7.844983038281396e-10,
  5.084218843345414e-11, -2.872968110017247e-12,  1.442463894565308e-13, -6.527602677214445e-15,  2.692361751518478e-16, -1.020104407870372e-17,  5.729757453269280e-06,
 -2.125685730353343e-06,  4.207321638578849e-07, -5.705882677043924e-08,  5.911005301694547e-09, -4.970055820595741e-10,  3.525123227703836e-11, -2.166027434685277e-12,
  1.175644947574097e-13, -5.720591325566369e-15,  2.524704706254737e-16, -1.018823368830194e-17,  2.078779026074242e-06, -8.420434534280280e-07,  1.822278826232831e-07,
 -2.688269156850225e-08,  3.011528814395641e-09, -2.722582708545621e-10,  2.065286994905451e-11, -1.350625849366788e-12,  7.767271970335682e-14, -3.988166835020854e-15,
  1.850327933632511e-16, -7.821535545508504e-18,  6.344036225405805e-07, -2.701044834424667e-07,  6.155933691141074e-08, -9.538624670116221e-09,  1.118639991928227e-09,
 -1.055204453541742e-10,  8.325892338140869e-12, -5.647052188096613e-13,  3.359173659277848e-14, -1.779709541101476e-15,  8.500754942703678e-17, -3.691508325533601e-18,
  4.124132189735716e-05, -1.665809970735592e-06,  4.197455503257143e-08, -8.469539533848036e-10,  1.495790325483232e-11, -2.412276462414250e-13,  3.637097614051242e-15,
 -5.202062923091893e-17,  7.126799993278774e-19, -9.416473267182901e-21,  1.205995783273936e-22, -1.502744115366790e-24,  2.279744101398046e-04, -1.132102541372189e-05,
  3.600042021541439e-07, -9.215385640504607e-09,  2.056212527582642e-10, -4.157447346158933e-12,  7.790851081550855e-14, -1.373002203083847e-15,  2.298626068425707e-17,
 -3.682712977717196e-19,  5.677827555523941e-21, -8.458674451834333e-23,  4.756281772957138e-04, -3.036243619095516e-05,  1.234450376997087e-06, -3.979004224701675e-08,
  1.101522532093192e-09, -2.727837316264979e-11,  6.191550497368795e-13, -1.308768145667325e-14,  2.605332021414153e-16, -4.924577853326509e-18,  8.894060316381978e-20,
 -1.541953828119671e-21,  5.676144211398005e-04, -4.724686422000886e-05,  2.437956911171889e-06, -9.756651665093207e-08,  3.297565796852463e-09, -9.836195301373207e-11,
  2.658976020411991e-12, -6.629327128408672e-14,  1.543339801156205e-15, -3.385771650315719e-17,  7.048460638670358e-19, -1.399620127638954e-20,  4.531002177265382e-04,
 -4.903720675258002e-05,  3.177005045261419e-06, -1.560055350968957e-07,  6.360925981143534e-09, -2.258403741191579e-10,  7.186042067945269e-12, -2.088806799144082e-13,
  5.622302383632258e-15, -1.415476095459485e-16,  3.359038067110560e-18, -7.556242771094378e-20,  2.632677300882698e-04, -3.662914316743216e-05,  2.948063219489150e-06,
 -1.758824856658457e-07,  8.570049161869699e-09, -3.588552093612190e-10,  1.331980782933625e-11, -4.474175367286834e-13,  1.380247708385959e-14, -3.953530921047914e-16,
  1.060373170348811e-17, -2.679403860921244e-19,  1.182488497559340e-04, -2.082342426675176e-05,  2.059669083606600e-06, -1.479330711368147e-07,  8.541783466428896e-09,
 -4.184635952717345e-10,  1.797835226296191e-11, -6.925644157277291e-13,  2.430326511058555e-14, -7.861317747263642e-16,  2.365461314427080e-17, -6.664708426645678e-19,
  4.335648172775553e-05, -9.486306446306470e-06,  1.139362460965375e-06, -9.755651527319382e-08,  6.617030013833962e-09, -3.761784183715600e-10,  1.856063168610442e-11,
 -8.137305507383092e-13,  3.223928072250027e-14, -1.168954538832371e-15,  3.917169449672701e-17, -1.221649713246061e-18,  1.375723417113259e-05, -3.659722265877348e-06,
  5.259811940152000e-07, -5.305122571606739e-08,  4.182409001137591e-09, -2.732284717599869e-10,  1.533898937934569e-11, -7.585322636462645e-13,  3.363531352547978e-14,
 -1.355454671766240e-15,  5.016186184728185e-17, -1.717379386248554e-18,  4.038107570026120e-06, -1.272669761325424e-06,  2.147459449516034e-07, -2.510919304529027e-08,
  2.268270393681097e-09, -1.680570538894168e-10,  1.060313192408274e-11, -5.845075707446304e-13,  2.868258589946679e-14, -1.270695517695690e-15,  5.138595101511394e-17,
 -1.911534953378111e-18,  1.176499963133740e-06, -4.257345407956059e-07,  8.222405463853818e-08, -1.090092798938377e-08,  1.106022601744071e-09, -9.123794988617716e-11,
  6.358785954430570e-12, -3.844616356896998e-13,  2.055868586276805e-14, -9.866804338757701e-16,  4.299335176130835e-17, -1.714563311471706e-18,  3.555147087373547e-07,
 -1.422942366284443e-07,  3.042182648014990e-08, -4.437048283115767e-09,  4.918555749533136e-10, -4.403744431199297e-11,  3.310879335931035e-12, -2.147436697477004e-13,
  1.225596868348939e-14, -6.248726523662981e-16,  2.880234783438378e-17, -1.210152056777029e-18,  9.654219986369776e-08, -4.095129439286403e-08,  9.296645459056060e-09,
 -1.435109118395709e-09,  1.677071793161167e-10, -1.576726543730055e-11,  1.240224118765537e-12, -8.387359981692166e-14,  4.975625745775500e-15, -2.629343733542954e-16,
  1.252864226098052e-17, -5.428266926732990e-19,  3.519060283523391e-05, -1.366936906484348e-06,  3.310196946917204e-08, -6.419337299279406e-10,  1.090037202232250e-11,
 -1.691220667349458e-13,  2.454796750175290e-15, -3.382312298710807e-17,  4.466663859979503e-19, -5.692354424885215e-21,  7.035635250188642e-23, -8.465238213086798e-25,
  1.878213924033234e-04, -8.833119927308630e-06,  2.667119565076287e-07, -6.500762870204715e-09,  1.384391404261341e-10, -2.676699489902924e-12,  4.804411781541191e-14,
 -8.120975595758825e-16,  1.305598641339458e-17, -2.010849723000216e-19,  2.983214215681599e-21, -4.280421579728047e-23,  3.712798417188739e-04, -2.213391507447079e-05,
  8.470238456627981e-07, -2.583236920591122e-08,  6.791230050157663e-10, -1.601621336428190e-11,  3.469884923794679e-13, -7.014284349789287e-15,  1.337539585760389e-16,
 -2.425320152489830e-18,  4.207508335342652e-20, -7.015300595266703e-22,  4.113133564552338e-04, -3.165921751466208e-05,  1.528526906702751e-06, -5.761950505646920e-08,
  1.842813774639755e-09, -5.219820443766961e-11,  1.343725651139738e-12, -3.197881076311526e-14,  7.120949888892058e-16, -1.496918369213521e-17,  2.990867947281021e-19,
 -5.708471277644268e-21,  2.979832656677436e-04, -2.967022921523523e-05,  1.792218432057112e-06, -8.266968414462842e-08,  3.183039046532733e-09, -1.071493495874842e-10,
  3.243112233201364e-12, -8.991781794721302e-14,  2.314004666813966e-15, -5.581605863608732e-17,  1.271412302666398e-18, -2.750031537196599e-20,  1.532449628545831e-04,
 -1.960656588298834e-05,  1.469822808378952e-06, -8.231461331731391e-08,  3.786162715585083e-09, -1.503116828075400e-10,  5.308567901968642e-12, -1.701788467958178e-13,
  5.023350974186224e-15, -1.379945698330860e-16,  3.556862112188035e-18, -8.653671327537265e-20,  5.926681910331764e-05, -9.634552195676037e-06,  8.894091788807646e-07,
 -6.006754260621352e-08,  3.279683243904952e-09, -1.526118180445594e-10,  6.250724232131278e-12, -2.302788231296411e-13,  7.749193099150970e-15, -2.409526421128728e-16,
  6.984467114338070e-18, -1.899526161930612e-19,  1.817345692217846e-05, -3.700228695888860e-06,  4.170177700430712e-07, -3.372817578912072e-08,  2.172314601386868e-09,
 -1.177707403183674e-10,  5.561388290431770e-12, -2.340778699011216e-13,  8.927449628316878e-15, -3.123499651075347e-16,  1.012160653839871e-17, -3.058575030026361e-19,
  4.689264626539270e-06, -1.174693496012929e-06,  1.598433630485901e-07, -1.534595745997176e-08,  1.156800616444755e-09, -7.253416159237114e-11,  3.921124327137670e-12,
 -1.872456991165677e-13,  8.037783547067173e-15, -3.142595064195256e-16,  1.130578417600406e-17, -3.769769414720702e-19,  1.095993981530547e-06, -3.301673535152838e-07,
  5.339609013481648e-08, -6.006715335229283e-09,  5.238678379795143e-10, -3.758535976138470e-11,  2.302379096947396e-12, -1.235152053350704e-13,  5.910553768078653e-15,
 -2.558155640282643e-16,  1.012326373018789e-17, -3.690730560082001e-19,  2.533464144748203e-07, -8.906737755378103e-08,  1.672531882020103e-08, -2.160783416318922e-09,
  2.141182041008678e-10, -1.728567483474800e-11,  1.181109001790805e-12, -7.012469159329367e-14,  3.687545999187545e-15, -1.742608208563049e-16,  7.485255075239099e-18,
 -2.945818185607119e-19,  6.244671290649014e-08, -2.464381002552654e-08,  5.194331444093101e-09, -7.476264750215120e-10,  8.187246315160287e-11, -7.248848504557686e-12,
  5.394291134202157e-13, -3.465879556390581e-14,  1.960940949613763e-15, -9.917941505041294e-17,  4.537659295397474e-18, -1.893480646166948e-19,  1.482516610792645e-08,
 -6.261439761127939e-09,  1.415038650663630e-09, -2.174970622744485e-10,  2.531419819477567e-11, -2.370991498657182e-12,  1.858423492816690e-13, -1.252684578611185e-14,
  7.408468412345069e-16, -3.903701550119622e-17,  1.855062835500741e-18, -8.017045053375268e-20,  3.020757095920552e-05, -1.130206825557132e-06,  2.634313413331178e-08,
 -4.916814387133001e-10,  8.037980186798908e-12, -1.201279605232070e-13,  1.680537117380070e-15, -2.233068864279177e-17,  2.845595219360043e-19, -3.501356922488994e-21,
  4.180321224283355e-23, -4.861334172424571e-25,  1.563105122547480e-04, -6.977502208331082e-06,  2.004100247266076e-07, -4.658319054804568e-09,  9.481223728790683e-11,
 -1.755243233187533e-12,  3.021129018287441e-14, -4.903359843827639e-16,  7.577803225022974e-18, -1.123055002307490e-19,  1.604676701872354e-21, -2.219428404359020e-23,
  2.945653267006331e-04, -1.643466098477599e-05,  5.929626483928724e-07, -1.713552671115032e-08,  4.283627671686480e-10, -9.632034118107058e-12,  1.993922883339449e-13,
 -3.858346991210975e-15,  7.053921519536597e-17, -1.228004762393972e-18,  2.047865784540835e-20, -3.285983924636716e-22,  3.053695677453493e-04, -2.176479359643160e-05,
  9.844952914458070e-07, -3.499774439407024e-08,  1.060276246540488e-09, -2.854483528575869e-11,  7.003210918636082e-13, -1.592028026698948e-14,  3.392951600077294e-16,
 -6.838108370130963e-18,  1.311900365816188e-19, -2.407709684923380e-21,  2.027325779586595e-04, -1.857394302316060e-05,  1.046712031639373e-06, -4.538215911894111e-08,
  1.650942760627783e-09, -5.271619695741603e-11,  1.518316689993331e-12, -4.016509303778547e-14,  9.884747463976604e-16, -2.284724258058485e-17,  4.995923245652012e-19,
 -1.039061920666824e-20,  9.328083210142879e-05, -1.095964253009524e-05,  7.649854742854835e-07, -4.020723665410562e-08,  1.745477848130515e-09, -6.568773784241410e-11,
  2.206882318652528e-12, -6.750057839330939e-14,  1.905936576521414e-15, -5.019597436071631e-17,  1.242911744637630e-18, -2.910354700348544e-20,  3.140310305404738e-05,
 -4.698603607932021e-06,  4.041599929611868e-07, -2.563416852369578e-08,  1.322060788615436e-09, -5.837439839171613e-11,  2.277196979466478e-12, -8.015543942426300e-14,
  2.584242571911768e-15, -7.717105439646657e-17,  2.152974168376217e-18, -5.646743843361549e-20,  8.127852447362631e-06, -1.533160087576425e-06,  1.616503280074610e-07,
 -1.232007589432621e-08,  7.518995889716612e-10, -3.880066283610902e-11,  1.750541425723805e-12, -7.061926120718526e-14,  2.588635436981547e-15, -8.726349164192428e-17,
  2.730504282231761e-18, -7.983564086051694e-20,  1.713675019636980e-06, -4.020474236894874e-07,  5.158262836505748e-08, -4.697716652402301e-09,  3.375873044111327e-10,
 -2.026239858301834e-11,  1.052188489971346e-12, -4.841014562796670e-14,  2.007462604392515e-15, -7.599789371160662e-17,  2.652926307992380e-18, -8.599864547332813e-20,
  3.179451482607026e-07, -9.103809040201071e-08,  1.404617688266586e-08, -1.514230516829473e-09,  1.270565694646789e-10, -8.800120206096384e-12,  5.219342687483519e-13,
 -2.717950844031637e-14,  1.265357318185147e-15, -5.338866248315079e-17,  2.063299874653561e-18, -7.358645816499944e-20,  5.752364470842238e-08, -1.955737867150683e-08,
  3.556303073565900e-09, -4.461347421924801e-10,  4.304175097723732e-11, -3.391037693633860e-12,  2.265969994690232e-13, -1.318121664708682e-14,  6.802282579343170e-16,
 -3.159258687048149e-17,  1.335457464163890e-18, -5.178387711841484e-20,  1.131311744978396e-08, -4.390497215173220e-09,  9.101019708322632e-10, -1.289841741581987e-10,
  1.392678875315958e-11, -1.217231657011139e-12,  8.951735076723518e-14, -5.689605035400867e-15,  3.187211120059077e-16, -1.597303400466094e-17,  7.246432395012908e-19,
 -3.000296863038167e-20,  2.300528536361159e-09, -9.667313976925880e-10,  2.173285336039463e-10, -3.323816213487977e-11,  3.850607453627925e-12, -3.591037335168409e-13,
  2.803449202779439e-14, -1.882649656955876e-15,  1.109549075453502e-16, -5.827539946573173e-18,  2.760888529882175e-19, -1.189795111323648e-20,  2.607372859332619e-05,
 -9.410454730356973e-07,  2.114187775877113e-08, -3.802982708325764e-10,  5.992966410392517e-12, -8.637510111020125e-14,  1.165890755423039e-15, -1.495644435469390e-17,
  1.840881521292547e-19, -2.189156537631848e-21,  2.526902191735149e-23, -2.842787712987702e-25,  1.312862183207358e-04, -5.574465743174475e-06,  1.525696586365148e-07,
 -3.386985510126307e-09,  6.597323476925574e-11, -1.170859692037586e-12,  1.934732082886672e-14, -3.018310963553696e-16,  4.488417311872665e-18, -6.406906388497800e-20,
  8.824681510806297e-22, -1.177520148281108e-23,  2.371588996102929e-04, -1.241006723228494e-05,  4.228538883803392e-07, -1.159545551885317e-08,  2.759889394125836e-10,
 -5.923778564403958e-12,  1.172964187590620e-13, -2.174822228013484e-15,  3.815451811586678e-17, -6.382318281375465e-19,  1.023889782901691e-20, -1.582199195617939e-22,
  2.317590840333287e-04, -1.531845482833654e-05,  6.500607516509678e-07, -2.181936148949913e-08,  6.268419920125662e-10, -1.605524576119746e-11,  3.757254107401711e-13,
 -8.164960024049676e-15,  1.666571706133177e-16, -3.222099985526680e-18,  5.938792912073818e-20, -1.048533085582690e-21,  1.422776374195295e-04, -1.199846671189033e-05,
  6.313285289780610e-07, -2.574838243742503e-08,  8.856071757190485e-10, -2.683915063490735e-11,  7.359438975920707e-13, -1.858272240873011e-14,  4.374889056846015e-16,
 -9.692165625947647e-18,  2.034895144647075e-19, -4.070053035593652e-21,  5.918508969458667e-05, -6.378836722687162e-06,  4.145344381789491e-07, -2.044891512640670e-08,
  8.378915916179402e-10, -2.989080813614221e-11,  9.552668278724445e-13, -2.787484322265399e-14,  7.527720207170367e-16, -1.900341991002918e-17,  4.519241084874807e-19,
 -1.018168994364280e-20,  1.753812077497062e-05, -2.408804213303908e-06,  1.928177445421278e-07, -1.147446187959482e-08,  5.585402635194818e-10, -2.338371330281568e-11,
  8.681787941036184e-13, -2.917646510665556e-14,  9.005551366952979e-16, -2.580788459246592e-17,  6.924513914548346e-19, -1.750085648666962e-20,  3.871562016439853e-06,
 -6.737143377663409e-07,  6.627768479330285e-08, -4.749899233902155e-09,  2.741921087335216e-10, -1.344562211113168e-11,  5.786717428738579e-13, -2.234197152296704e-14,
  7.860317401483728e-16, -2.549526558381652e-17,  7.693050982470717e-19, -2.173586731162003e-20,  6.717689576035308e-07, -1.467892883621962e-07,  1.768632868449053e-08,
 -1.522926087971856e-09,  1.040341440352913e-10, -5.962012062777018e-12,  2.966990160026986e-13, -1.312380307217916e-14,  5.246575865582340e-16, -1.919554414159368e-17,
  6.490031696801675e-19, -2.041808686506670e-20,  9.893010551771372e-08, -2.676177182538669e-08,  3.920262482314192e-09, -4.033555766981664e-10,  3.244684965649843e-11,
 -2.162647442656180e-12,  1.238343498307832e-13, -6.243319615837428e-15,  2.821027882721196e-16, -1.157747264477556e-17,  4.360612530672583e-19, -1.518405752826710e-20,
  1.384948469298782e-08, -4.529661793578544e-09,  7.939783703769283e-10, -9.633752102169794e-11,  9.017790589508842e-12, -6.912272873040113e-13,  4.504714185347460e-14,
 -2.561016456717750e-15,  1.294097675307467e-16, -5.894875048347193e-18,  2.447606236756369e-19, -9.335184321776574e-21,  2.124170246057511e-09, -8.081141051746976e-10,
  1.642572916205298e-10, -2.286287648566509e-11,  2.428330746497470e-12, -2.090912229349871e-13,  1.516875610902178e-14, -9.521718485517674e-16,  5.273368030412672e-17,
 -2.615248116813101e-18,  1.175058152846709e-19, -4.822168062994899e-21,  3.613704752185769e-10, -1.509507351997089e-10,  3.372645225780087e-11, -5.128263478738033e-12,
  5.909157614209392e-13, -5.483481247104554e-14,  4.261202425888548e-15, -2.849440956879771e-16,  1.672709634668180e-17, -8.753128843790758e-19,  4.132752819488203e-20,
 -1.775321437972022e-21,  2.262105391493085e-05, -7.886567551336226e-07,  1.710117831703294e-08, -2.968417808140157e-10,  4.514511761873122e-12, -6.281983169152332e-14,
  8.189951511205857e-16, -1.015356053950637e-17,  1.208178956089701e-19, -1.389981466106637e-21,  1.552463491079759e-23, -1.690603804273877e-25,  1.111952366956042e-04,
 -4.500168022774440e-06,  1.175610153418530e-07, -2.496128918027478e-09,  4.659049343321525e-11, -7.936196563234554e-13,  1.260339710392921e-14, -1.891905246159023e-16,
  2.709724888426921e-18, -3.728897319691296e-20,  4.955292202743155e-22, -6.384113929468221e-24,  1.934982842146539e-04, -9.516852982897119e-06,  3.067379883617276e-07,
 -7.992951244306980e-09,  1.813642571502986e-10, -3.720145923169767e-12,  7.053399265048144e-14, -1.254307088686791e-15,  2.113519259644522e-17, -3.399854440794018e-19,
  5.250978793634049e-21, -7.819853367175873e-23,  1.794400844366936e-04, -1.101636416809916e-05,  4.392068585383069e-07, -1.393689909121173e-08,  3.801059448644416e-10,
 -9.271404347775369e-12,  2.071423904397266e-13, -4.306535698838898e-15,  8.424636326033173e-17, -1.563510332150159e-18,  2.770148965123137e-20, -4.707486750844337e-22,
  1.027213431076977e-04, -7.978211806245197e-06,  3.923381416640399e-07, -1.506534605753170e-08,  4.902925313495553e-10, -1.411216692732594e-11,  3.686220777281205e-13,
 -8.888749563807033e-15,  2.002727985815512e-16, -4.254151958415927e-18,  8.578214575538969e-20, -1.650379542168721e-21,  3.901882133409062e-05, -3.854687017811475e-06,
  2.332694875519723e-07, -1.080292989161494e-08,  4.178977922498246e-10, -1.413445054261905e-11,  4.297443928950711e-13, -1.196416413412807e-14,  3.090172596468191e-16,
 -7.477112786354953e-18,  1.707585939698462e-19, -3.700977065684670e-21,  1.029137535580421e-05, -1.294475731579199e-06,  9.633940203044722e-08, -5.375655354106835e-09,
  2.468357655118612e-10, -9.793337710061967e-12,  3.458742519404384e-13, -1.109175176265908e-14,  3.275767526702535e-16, -9.003757877356127e-18,  2.321937777591269e-19,
 -5.651424653545457e-21,  1.959597474183918e-06, -3.133231253357576e-07,  2.869337760784488e-08, -1.930188141482936e-09,  1.052264483867596e-10, -4.896533975335805e-12,
  2.007642489002122e-13, -7.409111573839792e-15,  2.498758663663698e-16, -7.789013759611227e-18,  2.263814329886743e-19, -6.173641352603102e-21,  2.823990260997653e-07,
 -5.715594748756448e-08,  6.442757716372051e-09, -5.229229803214950e-10,  3.386739964456361e-11, -1.848754608428614e-12,  8.797841892648183e-14, -3.733687444528298e-15,
  1.436243887995807e-16, -5.069141957612005e-18,  1.657110668128172e-19, -5.051281192835223e-21,  3.311176985273504e-08, -8.407957740992950e-09,  1.163613621447836e-09,
 -1.137974162460312e-10,  8.744696520484531e-12, -5.591127941388889e-13,  3.082012772094312e-14, -1.500426262871982e-15,  6.564046220469485e-17, -2.614377685657652e-18,
  9.576513187488885e-20, -3.249344601678719e-21,  3.556028901937326e-09, -1.112130171706020e-09,  1.869654096426156e-10, -2.184705199192788e-11,  1.976712944201665e-12,
 -1.469251033777027e-13,  9.310508390010188e-15, -5.159353257612567e-16,  2.546512926215079e-17, -1.135176645871210e-18,  4.620258233996442e-20, -1.730018157800234e-21,
  4.156911443185930e-10, -1.544275640543165e-10,  3.067082273885517e-11, -4.179786419177575e-12,  4.355326485907323e-13, -3.685701386488644e-14,  2.632067315049090e-15,
 -1.628675393034770e-16,  8.902624750359586e-18, -4.362459318779390e-19,  1.938615916979542e-20, -7.875519538116676e-22,  5.758376856367335e-11, -2.388277390445996e-11,
  5.297332655213355e-12, -8.000153630904610e-13,  9.160674319837565e-14, -8.451869340141473e-15,  6.533169832936470e-16, -4.347376994860119e-17,  2.540538290702790e-18,
 -1.323887102508507e-19,  6.226437086716346e-21, -2.665083705126680e-22,  1.971910164460666e-05, -6.649567844057282e-07,  1.393422201718483e-08, -2.336821507278564e-10,
  3.433721850986721e-12, -4.618095240212013e-14,  5.820764135619748e-16, -6.981324823624656e-18,  8.037207138098306e-20, -8.954188080014235e-22,  9.689463148984566e-24,
 -1.020171363949337e-25,  9.490225978050008e-05, -3.667929277083624e-06,  9.160507446413384e-08, -1.862864790636235e-09,  3.335966491994863e-11, -5.460238437992741e-13,
  8.342605746952354e-15, -1.206208727895025e-16,  1.665496170153950e-18, -2.211518525664529e-20,  2.837954336814739e-22, -3.532383747852317e-24,  1.597940910631492e-04,
 -7.402390877850286e-06,  2.260465746219132e-07, -5.605068001377935e-09,  1.213965002513470e-10, -2.382363046575814e-12,  4.329620500104236e-14, -7.391602086452350e-16,
  1.197308574726360e-17, -1.853702523967770e-19,  2.758416120528240e-21, -3.961640051777514e-23,  1.414721004291056e-04, -8.080812652386138e-06,  3.031099389440800e-07,
 -9.104630692911710e-09,  2.360034365040743e-10, -5.487606100987797e-12,  1.171584928659589e-13, -2.332203028222646e-15,  4.375894376547525e-17, -7.800881370689733e-19,
  1.329394333447851e-20, -2.175609907295835e-22,  7.610440943993886e-05, -5.447984098960966e-06,  2.506617180318695e-07, -9.071125869900945e-09,  2.795771419819489e-10,
 -7.648599822792788e-12,  1.904453195904914e-13, -4.388082252774953e-15,  9.466647814305281e-17, -1.928899908660213e-18,  3.736913482774755e-20, -6.917658725328235e-22,
  2.664749214519490e-05, -2.411740753262346e-06,  1.359700793804512e-07, -5.914263999271067e-09,  2.160814985067473e-10, -6.931567687109673e-12,  2.005494035678607e-13,
 -5.327966887718144e-15,  1.316334941989200e-16, -3.053016255261540e-18,  6.695711771802589e-20, -1.396016969682017e-21,  6.324653487097256e-06, -7.270575917730430e-07,
  5.028066352037928e-08, -2.629769703349452e-09,  1.138733371280775e-10, -4.280365789713301e-12,  1.437548951311036e-13, -4.397555665002642e-15,  1.242203616067462e-16,
 -3.273332448430135e-18,  8.109797834437114e-20, -1.899954830158657e-21,  1.051081570389959e-06, -1.538394614061496e-07,  1.308940647539524e-08, -8.252872772823569e-10,
  4.243692654663285e-11, -1.871761031260404e-12,  7.303378024432226e-14, -2.573578977461008e-15,  8.311639049724678e-17, -2.487365544410161e-18,  6.956265313570564e-20,
 -1.829191303514177e-21,  1.271788738547201e-07, -2.371186077878151e-08,  2.491822276667453e-09, -1.901054403587200e-10,  1.164509942294938e-11, -6.042058573393702e-13,
  2.744052509943368e-14, -1.115227150023869e-15,  4.120600603947581e-17, -1.400605734443065e-18,  4.419774404572201e-20, -1.303328064847420e-21,  1.194598616733275e-08,
 -2.828286426229910e-09,  3.679614915723802e-10, -3.406472997986134e-11,  2.491815660810009e-12, -1.523535437393987e-13,  8.061860197787736e-15, -3.779987705857897e-16,
  1.597220011917808e-17, -6.159910556520860e-19,  2.189790721807371e-20, -7.225656913237766e-22,  9.792363608609928e-10, -2.908678499612691e-10,  4.664112330337325e-11,
 -5.224230754959006e-12,  4.550568155249981e-13, -3.268151854351060e-14,  2.007370259960570e-15, -1.081130317143606e-16,  5.198647003975002e-18, -2.262461856879691e-19,
  9.006754114514713e-21, -3.304306098578437e-22,  8.533255229211340e-11, -3.081021052457023e-11,  5.954255785881871e-12, -7.915991766421688e-13,  8.066623120214507e-14,
 -6.690530303812836e-15,  4.691778483521376e-16, -2.855631459067781e-17,  1.537628776934326e-18, -7.431806982834994e-20,  3.261252992662782e-21, -1.309660028338434e-22,
  9.332946722293588e-12, -3.837661464784557e-12,  8.438493784653521e-13, -1.264164774007543e-13,  1.436903638527793e-14, -1.316816322182059e-15,  1.011621853642720e-16,
 -6.693691852100302e-18,  3.891400987711904e-19, -2.018129271289292e-20,  9.449579181717746e-22, -4.028131694708242e-23,  1.726569405177162e-05, -5.638313528347959e-07,
  1.143148297446227e-08, -1.854341161911697e-10,  2.635352181711257e-12, -3.429353100389146e-14,  4.182465360195462e-16, -4.858335320950321e-18,  5.415475499907519e-20,
 -5.844032660866473e-22,  6.149976495122547e-24, -6.220895674528494e-26,  8.156644458809300e-05, -3.016196931649027e-06,  7.212519236450462e-08, -1.406643876778097e-09,
  2.419611121072817e-11, -3.809717060674922e-13,  5.605698113333379e-15, -7.814376726838800e-17,  1.041109555754004e-18, -1.334984242458142e-20,  1.656239033688605e-22,
 -1.991824238369483e-24,  1.334175525069182e-04, -5.833328108587076e-06,  1.690328358091705e-07, -3.993773826893816e-09,  8.266402384510487e-11, -1.553798671734203e-12,
  2.709458004303326e-14, -4.444945357801566e-16,  6.927563806906288e-18, -1.033112238644228e-19,  1.482338379897733e-21, -2.054558445063745e-23,  1.133874135068915e-04,
 -6.036210794768842e-06,  2.133292867999183e-07, -6.073473443973496e-09,  1.497995804802222e-10, -3.323885110654931e-12,  6.787493926561265e-14, -1.294795836427841e-15,
  2.331918544470805e-17, -3.995966202520603e-19,  6.554113022441112e-21, -1.033567544249113e-22,  5.772749110122787e-05, -3.812256792597787e-06,  1.643030521266626e-07,
 -5.609673773094513e-09,  1.638900190108720e-10, -4.265145929217840e-12,  1.013072710563268e-13, -2.231865766734501e-15,  4.612903186438982e-17, -9.020361818310220e-19,
  1.679695685534529e-20, -2.992927642012744e-22,  1.879752067343116e-05, -1.558148613464022e-06,  8.189453283335199e-08, -3.347793271296270e-09,  1.155860307462266e-10,
 -3.518260480228760e-12,  9.690482757279212e-14, -2.457471464405753e-15,  5.809015761902054e-17, -1.291675098021816e-18,  2.720758657911971e-20, -5.457204056114286e-22,
  4.057515556328673e-06, -4.255352213700608e-07,  2.733985791708906e-08, -1.340184795921394e-09,  5.472308074908863e-11, -1.948622894717466e-12,  6.222549422107568e-14,
 -1.815465575847687e-15,  4.903904513435143e-17, -1.238541222930167e-18,  2.947063770941223e-20, -6.643496742298216e-22,  5.956306821958338e-07, -7.952434515763823e-08,
  6.277126112734935e-09, -3.705333187501089e-10,  1.795426185028203e-11, -7.499554946602381e-13,  2.782380728146850e-14, -9.354062090047735e-16,  2.890521343204840e-17,
 -8.297689969975094e-19,  2.231011194529820e-20, -5.651874281899307e-22,  6.125293608013270e-08, -1.046437484336971e-08,  1.021967059053443e-09, -7.310628890024083e-11,
  4.226605565507608e-12, -2.080427757083618e-13,  9.001303673146392e-15, -3.497538044836790e-16,  1.239297420266298e-17, -4.050554190510854e-19,  1.232030417527784e-20,
 -3.509558055895757e-22,  4.651231558575277e-09, -1.019609204225280e-09,  1.240953632697142e-10, -1.083236221862168e-11,  7.517276179024139e-13, -4.381976417245680e-14,
  2.219785987528747e-15, -9.998733251330442e-17,  4.071143134484188e-18, -1.516989143056734e-19,  5.222740940499049e-21, -1.672659029877122e-22,  2.907363989929694e-10,
 -8.140524381957314e-11,  1.237716084158593e-11, -1.322368673946781e-12,  1.104182794865497e-13, -7.633696610185583e-15,  4.529537622928378e-16, -2.363847569388484e-17,
  1.104325964082507e-18, -4.680216339102602e-20,  1.818146603595657e-21, -6.521360524081368e-23,  1.850805294580389e-11, -6.457827954371975e-12,  1.208381756581292e-12,
 -1.560608150277498e-13,  1.549572937876735e-14, -1.255634229318066e-15,  8.622202675035495e-17, -5.149032911062044e-18,  2.725040410400826e-19, -1.296514293652085e-20,
  5.608091640734176e-22, -2.222645988275272e-23,  1.543640920543705e-12, -6.281091734393614e-13,  1.366738776855915e-13, -2.027876207222461e-14,  2.284894841317620e-15,
 -2.077382218302644e-16,  1.584436527409412e-17, -1.041510792152766e-18,  6.018508234723390e-20, -3.104072199660672e-21,  1.446059129134633e-22, -6.135400270558354e-24,
  1.518012682581601e-05, -4.806123097375767e-07,  9.438281927003857e-09, -1.482530143008933e-10,  2.039777359844945e-12, -2.571005664630179e-14,  3.036216249926260e-16,
 -3.419381496723153e-18,  3.695860885753957e-20, -3.851996883025581e-22,  3.984132660480390e-24, -3.823800485828113e-26,  7.055733847054416e-05, -2.500667978864687e-06,
  5.733864846744384e-08, -1.073833207876354e-09,  1.776254021659452e-11, -2.693288677939644e-13,  3.820052500680825e-15, -5.139266807775739e-17,  6.613212063741457e-19,
 -8.191266521579083e-21,  9.845078981501998e-23, -1.143174518518021e-24,  1.125141333577261e-04, -4.652433499708836e-06,  1.281216707273364e-07, -2.888247123095165e-09,
  5.719887587219577e-11, -1.030896094523536e-12,  1.726554650685109e-14, -2.724357924377331e-16,  4.088891005732214e-18, -5.878168992154192e-20,  8.139135039793362e-22,
 -1.089417086895395e-23,  9.224577335065354e-05, -4.584890586010873e-06,  1.528909378132074e-07, -4.130956320508427e-09,  9.706059397391077e-11, -2.057297042693904e-12,
  4.022009880823388e-14, -7.358750647099821e-16,  1.273112530361650e-17, -2.098576457607150e-19,  3.314905133168496e-21, -5.040457337160926e-23,  4.473632959477319e-05,
 -2.728237885292032e-06,  1.102817476926636e-07, -3.556341851555974e-09,  9.858874497046025e-11, -2.442811285991193e-12,  5.539313710295847e-14, -1.167631998722540e-15,
  2.313466523708949e-17, -4.343994498440656e-19,  7.778600750406952e-21, -1.334672699417902e-22,  1.365904971045367e-05, -1.036876316055715e-06,  5.084865247013396e-08,
 -1.955075344726265e-09,  6.383172231579939e-11, -1.844676442474026e-12,  4.839285775315629e-14, -1.171942951256352e-15,  2.651410510677012e-17, -5.653733847924647e-19,
  1.144012610824867e-20, -2.207823969301853e-22,  2.708639950542640e-06, -2.587697480070837e-07,  1.544725233177757e-08, -7.098037385532997e-10,  2.733451307706854e-11,
 -9.221688493917036e-13,  2.800073583670681e-14, -7.791368512867501e-16,  2.012377901741373e-17, -4.870750045408811e-19,  1.112906211935637e-20, -2.413481653285928e-22,
  3.554491825589068e-07, -4.315122530224868e-08,  3.156422286289863e-09, -1.743017127669296e-10,  7.953499445019334e-12, -3.144257070600913e-13,  1.108509051043020e-14,
 -3.553204697347326e-16,  1.049886498747233e-17, -2.889096110020060e-19,  7.463039733401283e-21, -1.820144304757564e-22,  3.147613427719479e-08, -4.901837275317819e-09,
  4.436831421122194e-10, -2.969741513922374e-11,  1.617586374475241e-12, -7.541274136989406e-14,  3.103740392444873e-15, -1.151333676952861e-16,  3.906828060173280e-18,
 -1.226188036507200e-19,  3.590130892097329e-21, -9.866265144448200e-23,  1.954897085243116e-09, -3.939677614833388e-10,  4.464788087965330e-11, -3.661162781940204e-12,
  2.402714789271452e-13, -1.331544067380330e-14,  6.440713217217159e-16, -2.780404317527674e-17,  1.088438372390473e-18, -3.910290759502956e-20,  1.301197180550273e-21,
 -4.036999695299433e-23,  9.350509276677309e-11, -2.447587828216795e-11,  3.506677815900065e-12, -3.555348210588845e-13,  2.833414733264258e-14, -1.878388117020605e-15,
  1.072996939396641e-16, -5.409055826431360e-18,  2.448076794321457e-19, -1.007701802882922e-20,  3.810823258058327e-22, -1.333371852530011e-23,  4.275369988606664e-12,
 -1.431701329510523e-12,  2.578932407420759e-13, -3.219720348931417e-14,  3.102031780735420e-15, -2.446784001466422e-16,  1.639974080878569e-17, -9.581956495587970e-19,
  4.971643118692928e-20, -2.323165409904314e-21,  9.885034786940736e-23, -3.859347436356644e-24,  2.616339827938774e-13, -1.050880398011341e-13,  2.257706620759385e-14,
 -3.311176600159800e-15,  3.692038575906689e-16, -3.325261170709280e-17,  2.514714727231516e-18, -1.640315307883182e-19,  9.412476893619140e-21, -4.823509857144944e-22,
  2.233916595855561e-23, -9.427259587867280e-25,  1.339815767435045e-05, -4.117040389569937e-07,  7.839294747870738e-09, -1.193645650477517e-10,  1.591330327512757e-12,
 -1.945019706178641e-14,  2.225533919089046e-16, -2.430819272856386e-18,  2.559870056160050e-20, -2.547524024206810e-22,  2.640284577208449e-24, -2.418414765861312e-26,
  6.139679268772703e-05, -2.089050656204286e-06,  4.599499231355713e-08, -8.281933108262667e-10,  1.318751107913429e-11, -1.927717559629620e-13,  2.637897084631363e-15,
 -3.427692174525244e-17,  4.266912419311366e-19, -5.099435870448131e-21,  5.957895203996185e-23, -6.685939400512110e-25,  9.575490751078258e-05, -3.751970466676465e-06,
  9.833983881116940e-08, -2.117844799301291e-09,  4.017566586212454e-11, -6.950278330600261e-13,  1.119094234439926e-14, -1.699964590374850e-16,  2.459257125714158e-18,
 -3.410398632593359e-20,  4.560950542575205e-22, -5.899858235189038e-24,  7.607205226673929e-05, -3.536466554015277e-06,  1.114320263910578e-07, -2.860965826761860e-09,
  6.410982564564861e-11, -1.299395637385527e-12,  2.434348058864904e-14, -4.275501046317340e-16,  7.110994412807915e-18, -1.128457441644542e-19,  1.717665121414580e-21,
 -2.519944035677919e-23,  3.535109717738159e-05, -1.993165614918228e-06,  7.566477556929178e-08, -2.307315916705884e-09,  6.075669865477077e-11, -1.434601873723590e-12,
  3.108252447212842e-14, -6.273471351868034e-16,  1.192315943068075e-17, -2.151133214363944e-19,  3.705901464530769e-21, -6.126058668180735e-23,  1.019780817797021e-05,
 -7.090115446389256e-07,  3.247571695982949e-08, -1.175456923342773e-09,  3.632035231927125e-11, -9.972087069391315e-13,  2.493142932867794e-14, -5.768629329683793e-16,
  1.249625872904575e-17, -2.556272939435722e-19,  4.970302320576205e-21, -9.231495886433432e-23,  1.875679841455097e-06, -1.630239423346295e-07,  9.045850172418528e-09,
 -3.897747475471173e-10,  1.416128048288378e-11, -4.527500775074010e-13,  1.307444144416529e-14, -3.470155406999459e-16,  8.570652864855430e-18, -1.988029050728702e-19,
  4.361609685150167e-21, -9.098434440355785e-23,  2.226248300771352e-07, -2.450138461106056e-08,  1.659808833596322e-09, -8.570405549264682e-11,  3.681380959170258e-12,
 -1.376888976410147e-13,  4.610935205983516e-15, -1.408583665328173e-16,  3.977875150788751e-18, -1.048806754262293e-19,  2.601534886542612e-21, -6.104866308565878e-23,
  1.720827214852546e-08, -2.430762157197457e-09,  2.034601296347148e-10, -1.272064461422627e-11,  6.518406219965867e-13, -2.874491524177416e-14,  1.123948367992196e-15,
 -3.975533878278522e-17,  1.290368778881268e-18, -3.884481603862849e-20,  1.093528430522461e-21, -2.895910063063543e-23,  8.862802882082293e-10, -1.630248195888088e-10,
  1.712923437956791e-11, -1.315015312466002e-12,  8.137730885586224e-14, -4.276402493350621e-15,  1.970450345888136e-16, -8.134293065571445e-18,  3.055166023101781e-19,
 -1.056133162283192e-20,  3.390383739030445e-22, -1.017145778551770e-23,  3.269977807855705e-11, -7.930593360619679e-12,  1.063831851516274e-12, -1.018272729937550e-13,
  7.711043820967573e-15, -4.882952743539184e-16,  2.675944833801022e-17, -1.298922578465113e-18,  5.678747099276660e-20, -2.264304159529331e-21,  8.315079451180247e-23,
 -2.831511691378769e-24,  1.060901516781990e-12, -3.381605449524948e-13,  5.824694471285176e-14, -6.990698576623676e-15,  6.504263259247271e-16, -4.973486422584845e-17,
  3.242076674320249e-18, -1.847415924616623e-19,  9.370732158688517e-21, -4.289649043424175e-22,  1.791357058580733e-23, -6.875390094234722e-25,  4.568350737603280e-14,
 -1.805418191466097e-14,  3.818410808313280e-15, -5.521618461524476e-16,  6.079637296705636e-17, -5.414342175452564e-18,  4.053407727342054e-19, -2.620023919645781e-20,
  1.491093643778209e-21, -7.584294275607862e-23,  3.488645465217047e-24, -1.463093092826805e-25,  1.186827286283332e-05, -3.543141255571966e-07,  6.547731169555160e-09,
 -9.674667952280603e-11,  1.250671027735387e-12, -1.484089989723326e-14,  1.647140099775878e-16, -1.739937554009816e-18,  1.809583000777970e-20, -1.679150758112415e-22,
  1.752334414015260e-24, -1.719000385404692e-26,  5.371827124014752e-05, -1.757529172813572e-06,  3.720575754234159e-08, -6.448973756802299e-10,  9.894740999677769e-12,
 -1.395908586260413e-13,  1.844676640499349e-15, -2.315206069948585e-17,  2.797575154674951e-19, -3.214884690736977e-21,  3.657786093351635e-23, -4.023520805568382e-25,
  8.217365183164025e-05, -3.056949589959256e-06,  7.636705111644642e-08, -1.573117371706096e-09,  2.861694908694739e-11, -4.756914120742552e-13,  7.370660883124046e-15,
 -1.078744934937848e-16,  1.505755529690885e-18, -2.015354547723330e-20,  2.605202385885212e-22, -3.261199908123548e-24,  6.351391646467787e-05, -2.766686156117940e-06,
  8.249010141521613e-08, -2.015019493041507e-09,  4.311319450018506e-11, -8.364238163336624e-13,  1.503039931929363e-14, -2.536373099865758e-16,  4.058072238997524e-18,
 -6.205533499907438e-20,  9.107340792212668e-22, -1.289591531427602e-23,  2.843446971613635e-05, -1.484016806893451e-06,  5.297945017849557e-08, -1.529492636058340e-09,
  3.829744405444629e-11, -8.625452894165560e-13,  1.787123155465104e-14, -3.456511564618453e-16,  6.305230513686495e-18, -1.093834943707412e-19,  1.813901525387663e-21,
 -2.889868754845211e-23,  7.804223708075637e-06, -4.970774477298751e-07,  2.129087881983664e-08, -7.261497076271020e-10,  2.125327235525916e-11, -5.547990926281059e-13,
  1.322769389965830e-14, -2.925964853157871e-16,  6.071680061733598e-18, -1.192096854693521e-19,  2.228013270453301e-21, -3.983629998360900e-23,  1.343347335334892e-06,
 -1.061062726721185e-07,  5.476599601884099e-09, -2.214054556355755e-10,  7.593052565754400e-12, -2.301473801042277e-13,  6.322979217793580e-15, -1.601199120500751e-16,
  3.782285246586527e-18, -8.409021629653491e-20,  1.771564889025083e-21, -3.554769897256499e-23,  1.458426282432887e-07, -1.451133893639958e-08,  9.102486096037373e-10,
 -4.394024711148376e-11,  1.776544864016208e-12, -6.285324100497387e-14,  1.998964857063045e-15, -5.818496435181724e-17,  1.570005267784189e-18, -3.964870053600730e-20,
  9.440218292321275e-22, -2.130615192239270e-23,  9.976569967958804e-09, -1.272129250385832e-09,  9.830203257895225e-11, -5.733285252307248e-12,  2.760849211279173e-13,
 -1.150433759340620e-14,  4.269379523657899e-16, -1.438554734015836e-17,  4.461895936408366e-19, -1.287073956500012e-20,  3.480325852671090e-22, -8.872774303199324e-24,
  4.327012397072249e-10, -7.212478049995168e-11,  6.999178077819424e-12, -5.015455060835327e-13,  2.919223701225201e-14, -1.451352653385433e-15,  6.356997671343445e-17,
 -2.504518749915308e-18,  9.008182275419453e-20, -2.990969689592841e-21,  9.246536282282035e-23, -2.677921572671519e-24,  1.246766712202411e-11, -2.774907533597612e-12,
  3.463008997000765e-13, -3.113409984273241e-14,  2.230630091664958e-15, -1.344116456560200e-16,  7.042461245178111e-18, -3.281366820536407e-19,  1.381773583783518e-20,
 -5.322691593951009e-22,  1.893314350903484e-23, -6.260065226822398e-25,  2.853108316063002e-13, -8.572127080814928e-14,  1.401201185734946e-14, -1.606615726598189e-15,
  1.435988291170797e-16, -1.059621777364916e-17,  6.691174423796499e-19, -3.705392998549745e-20,  1.831628273003629e-21, -8.190764097271794e-23,  3.348405563978057e-24,
 -1.260461828239892e-25,  8.273082299340826e-15, -3.203048001368464e-15,  6.643645993588414e-16, -9.442067806469208e-17,  1.023834941985012e-17, -8.995086440741619e-19,
  6.653225304289648e-20, -4.254224911940447e-21,  2.397708207274183e-22, -1.208902261997206e-23,  5.516608217791993e-25, -2.296909201711292e-26,  1.054887949115813e-05,
 -3.062571746989424e-07,  5.497693619622549e-09, -7.891115402296903e-11,  9.897543331271509e-13, -1.141208556191419e-14,  1.232820984520120e-16, -1.245485315725982e-18,
  1.313844285067937e-20, -1.121174253185489e-22,  1.050227693454880e-24, -1.540640974362527e-26,  4.723797274438433e-05, -1.488344391774160e-06,  3.033198489745140e-08,
 -5.067140832615399e-10,  7.497945833446835e-12, -1.021837512311748e-13,  1.306179554631924e-15, -1.580072053258419e-17,  1.865576128210050e-19, -2.055977503682644e-21,
  2.243417095731263e-23, -2.550819910563230e-25,  7.105827787623631e-05, -2.514404339964447e-06,  5.995145948055177e-08, -1.182682407907200e-09,  2.065295602501627e-11,
 -3.302014310977436e-13,  4.928546144717890e-15, -6.953802872038610e-17,  9.377314503310364e-19, -1.212061219453016e-20,  1.514137372213107e-22, -1.840037367117700e-24,
  5.362889821909753e-05, -2.192914518755803e-06,  6.195416767753121e-08, -1.441611344686226e-09,  2.948467668945392e-11, -5.480801788296829e-13,  9.455090634457337e-15,
 -1.534684804628867e-16,  2.362955654195744e-18, -3.485487715455517e-20,  4.937672740629335e-22, -6.742029852893552e-24,  2.324298254047582e-05, -1.124354429956902e-06,
  3.780020511576968e-08, -1.034359225415071e-09,  2.465573234379054e-11, -5.301680081534378e-13,  1.051284040166166e-14, -1.950418808246084e-16,  3.416193740508888e-18,
 -5.703390811334833e-20,  9.111537256650812e-22, -1.398719427270700e-23,  6.108556065976498e-06, -3.565683273257072e-07,  1.430034290377893e-08, -4.600521655228419e-10,
  1.276696274406769e-11, -3.171174525207404e-13,  7.215225129712444e-15, -1.526933464913160e-16,  3.036468145938082e-18, -5.725244491736002e-20,  1.029083110448227e-21,
 -1.771493435042795e-23,  9.922348508546726e-07, -7.115856297782984e-08,  3.419835958434555e-09, -1.298048704148958e-10,  4.204845895990609e-12, -1.208939862424648e-13,
  3.161247028339809e-15, -7.641213852384610e-17,  1.726710213441632e-18, -3.680470448976539e-20,  7.447034527417571e-22, -1.437456098261396e-23,  9.959643972239317e-08,
 -8.936250377973979e-09,  5.191745037836530e-10, -2.343183022979218e-11,  8.918326949072733e-13, -2.984858780188928e-14,  9.015414007462892e-16, -2.500259545072226e-17,
  6.445237146382617e-19, -1.558754526239287e-20,  3.561671258970939e-22, -7.729117203525863e-24,  6.111965932303328e-09, -7.002637103029349e-10,  4.990265386917261e-11,
 -2.712486781202979e-12,  1.226558469058055e-13, -4.826059979717070e-15,  1.698637342638764e-16, -5.448282131637261e-18,  1.613615393772079e-19, -4.456707612779412e-21,
  1.156658961179899e-22, -2.836443424143348e-24,  2.269308152532285e-10, -3.403108277720519e-11,  3.040324710126452e-12, -2.028358361358895e-13,  1.108038152813898e-14,
 -5.201717968624629e-16,  2.161870396916443e-17, -8.114644977418854e-19,  2.790338003265511e-20, -8.884252828496528e-22,  2.640833427285771e-23, -7.371836240287470e-25,
  5.189684682496545e-12, -1.049361354027683e-12,  1.210880818097223e-13, -1.017576213969293e-14,  6.869378479846101e-16, -3.924571394623902e-17,  1.959512710578494e-18,
 -8.737626007933628e-20,  3.534050987085983e-21, -1.311725045816555e-22,  4.508437552791399e-24, -1.444042417268403e-25,  8.388840526240935e-14, -2.348704601683485e-14,
  3.612777171229245e-15, -3.930641180048119e-16,  3.355682981986451e-17, -2.377808850809372e-18,  1.448237753032702e-19, -7.764193091172570e-21,  3.727373256249601e-22,
 -1.623253806568193e-23,  6.477965372894026e-25, -2.385640032031784e-26,  1.567285402395411e-15, -5.909974295133299e-16,  1.196219937381272e-16, -1.664045270541377e-17,
  1.770891843229708e-18, -1.530455149012226e-19,  1.115659827453193e-20, -7.042161383410046e-22,  3.923415976356431e-23, -1.957728887991430e-24,  8.850489478766208e-26,
 -3.653957890641233e-27,  9.406175086252513e-06, -2.658105054336869e-07,  4.638734515475568e-09, -6.475130598906273e-11,  7.885062196146932e-13, -8.827762197054879e-15,
  9.373784676808052e-17, -8.828597046698209e-19,  9.693879544864262e-21, -8.380463961386087e-23,  3.607365180145850e-25, -1.596051467711190e-26,  4.173408418456185e-05,
 -1.268116301054264e-06,  2.490891113650177e-08, -4.015321972972281e-10,  5.735134936905087e-12, -7.553260106206126e-14,  9.373263750370463e-16, -1.086216993308773e-17,
  1.262461693307346e-19, -1.355676233244235e-21,  1.317308067214607e-23, -1.731489966848318e-25,  6.187731788181956e-05, -2.086407022834837e-06,  4.754316713594034e-08,
 -8.992462953563697e-10,  1.509002013489023e-11, -2.322552637197343e-13,  3.343486810620591e-15, -4.548506778808190e-17,  5.933586095520685e-19, -7.419901035715424e-21,
  8.926984556155126e-23, -1.060009718902545e-24,  4.574926087551981e-05, -1.759218345143322e-06,  4.715991401962297e-08, -1.046540818985748e-09,  2.048392109688100e-11,
 -3.652151802596692e-13,  6.052096854632217e-15, -9.463081591523786e-17,  1.402326221474633e-18, -1.995741315795771e-20,  2.738822341643863e-22, -3.592443651611485e-24,
  1.928026408245488e-05, -8.656208565324241e-07,  2.744475318905123e-08, -7.126422439743085e-10,  1.618971853217372e-11, -3.327135110250277e-13,  6.317407170446294e-15,
 -1.125895962471788e-16,  1.893811729524571e-18, -3.043810728938930e-20,  4.695623980317512e-22, -6.932627885764289e-24,  4.880460354939465e-06, -2.612028568740468e-07,
  9.822980492835307e-09, -2.983888730568635e-10,  7.859548085764328e-12, -1.859311969654591e-13,  4.039190506199050e-15, -8.186738315379115e-17,  1.560639685777831e-18,
 -2.827041682416004e-20,  4.892453331747043e-22, -8.105218193119653e-24,  7.538550123921045e-07, -4.904697199540084e-08,  2.197658020537195e-09, -7.837709719396876e-11,
  2.400096985043837e-12, -6.550043288273447e-14,  1.630876401359668e-15, -3.765165838166238e-17,  8.141515927263677e-19, -1.664199840680281e-20,  3.235530793869356e-22,
 -6.007622044673695e-24,  7.066841747331588e-08, -5.703767565502156e-09,  3.071543283028809e-10, -1.296455665957933e-11,  4.646809575893014e-13, -1.471635290681775e-14,
  4.221799318443693e-16, -1.115739315711141e-17,  2.747745196289431e-19, -6.363695551037300e-21,  1.395364844629925e-22, -2.910948063246127e-24,  3.942175787611527e-09,
 -4.039966061948655e-10,  2.654003773600504e-11, -1.343657639898510e-12,  5.703108405556005e-14, -2.117948958329841e-15,  7.066735558840493e-17, -2.156584824789421e-18,
  6.095599997562615e-20, -1.611053097140988e-21,  4.010630320769840e-23, -9.454230625501605e-25,  1.274400047123129e-10, -1.707035506691007e-11,  1.400575430157116e-12,
 -8.681390380477022e-14,  4.443326891072050e-15, -1.966541061235817e-16,  7.743508568528216e-18, -2.765145379494162e-19,  9.077439826372144e-21, -2.767646024698833e-22,
  7.899237328070707e-24, -2.122474531681904e-25,  2.358223795884538e-12, -4.286571510651871e-13,  4.547918721761458e-14, -3.556496239081092e-15,  2.253721820653901e-16,
 -1.216721888371788e-17,  5.771565015812423e-19, -2.456003569383574e-20,  9.516070346282028e-22, -3.394847466996727e-23,  1.124783437328707e-24, -3.482129792809511e-26,
  2.718485258086625e-14, -6.999833747544515e-15,  1.004072664444592e-15, -1.029124162510425e-16,  8.341528430890551e-18, -5.646493751852855e-19,  3.301923655105684e-20,
 -1.706786046813284e-21,  7.928654054461101e-23, -3.351518487004788e-24,  1.301743794296889e-25, -4.677090783478929e-27,  3.140096364073601e-16, -1.144118399382368e-16,
  2.245234125539029e-17, -3.041061843843630e-18,  3.162541799113191e-19, -2.678848688788804e-20,  1.918744102368993e-21, -1.192463294150312e-22,  6.552569529345873e-24,
 -3.229600797764391e-25,  1.443979935235832e-26, -5.902524646960914e-28,  8.412517765461167e-06, -2.316068816450768e-07,  3.931963543047446e-09, -5.343322344602912e-11,
  6.326153161505261e-13, -6.842363659042087e-15,  7.291902280439125e-17, -6.195053882135234e-19,  6.769435416085042e-21, -8.311294380808494e-23, -3.067941231248118e-25,
 -1.314167849831645e-26,  3.703170545066128e-05, -1.086665951192021e-06,  2.059494150354938e-08, -3.207287202852220e-10,  4.426985881038475e-12, -5.627175969336738e-14,
  6.830509245255056e-16, -7.515313443551242e-18,  8.524967599530411e-20, -9.637861232428935e-22,  6.835116716349710e-24, -1.156858410889783e-25,  5.422940010937885e-05,
 -1.745447727745218e-06,  3.806059126408278e-08, -6.910042606150450e-10,  1.115431584672854e-11, -1.653732406459979e-13,  2.300003757876162e-15, -3.016433332816848e-17,
  3.806508643158290e-19, -4.634712452667414e-21,  5.317061422956578e-23, -6.207516079492760e-25,  3.939460249488501e-05, -1.427109348999582e-06,  3.635014357053936e-08,
 -7.701580475067518e-10,  1.444114020143783e-11, -2.472852588850632e-13,  3.936125676322702e-15, -5.941144471542849e-17,  8.482168188793498e-19, -1.160267758530758e-20,
  1.557153079393453e-22, -1.953209286017379e-24,  1.620834746880012e-05, -6.763231212595277e-07,  2.025169502166496e-08, -4.995634611910540e-10,  1.082779641864244e-11,
 -2.129740693641613e-13,  3.871356793665239e-15, -6.641683090137841e-17,  1.073752129795995e-18, -1.657111173409450e-20,  2.484558162496244e-22, -3.517535807333966e-24,
  3.972823355747452e-06, -1.950557723144940e-07,  6.889268612905038e-09, -1.978066813488239e-10,  4.950270828354425e-12, -1.116755952744157e-13,  2.316438058620115e-15,
 -4.503524153312431e-17,  8.234926444975986e-19, -1.431888171462764e-20,  2.392876974338776e-22, -3.811199423508132e-24,  5.876788326340801e-07, -3.466231264425457e-08,
  1.450334932090895e-09, -4.864073435932800e-11,  1.409258811892912e-12, -3.654197498739501e-14,  8.665083257525346e-16, -1.912556638276898e-17,  3.959010631375605e-19,
 -7.759838466865102e-21,  1.451241264901245e-22, -2.591490630735286e-24,  5.193539517726144e-08, -3.761693711524271e-09,  1.880070846034328e-10, -7.424474424190369e-12,
  2.507314468705471e-13, -7.517909747806986e-15,  2.048697579895992e-16, -5.161656807440803e-18,  1.214575765994579e-19, -2.693591215015903e-21,  5.669114605571005e-23,
 -1.136755001361714e-24,  2.667014151904708e-09, -2.433679186130349e-10,  1.474392664560031e-11, -6.950386859304311e-13,  2.768753988691573e-14, -9.703764746791995e-16,
  3.068360509763628e-17, -8.907291186377546e-19,  2.401899408203464e-20, -6.072196159453053e-22,  1.449396382495784e-23, -3.282650034873398e-25,  7.635122204731401e-11,
 -9.068568811620749e-12,  6.822937225986911e-13, -3.922926641664588e-14,  1.878818607031799e-15, -7.830139503834027e-17,  2.917692236321625e-18, -9.900643611528124e-20,
  3.099298262268842e-21, -9.038313234949380e-23,  2.474066635814221e-24, -6.391155479261839e-26,  1.168121996231396e-12, -1.887904202571677e-13,  1.832831796773040e-14,
 -1.328500595417048e-15,  7.876531023739217e-17, -4.006451978603477e-18,  1.800626121509293e-19, -7.293564902180942e-21,  2.700633901536525e-22, -9.238839824720562e-24,
  2.944221494113140e-25, -8.791148778921284e-27,  9.775116719104178e-15, -2.280464646080494e-15,  3.022060236684600e-16, -2.896574002480608e-17,  2.215411930697224e-18,
 -1.425004988460102e-19,  7.963233423469621e-21, -3.952109444993339e-22,  1.769741054918816e-23, -7.236112883983960e-25,  2.726744180840312e-26, -9.530525648805096e-28,
  6.745533055646869e-17, -2.349140586308817e-17,  4.431983675566276e-18, -5.805815625193416e-19,  5.868083483473929e-20, -4.849944770459978e-21,  3.400341970398799e-22,
 -2.074013915619200e-23,  1.120969114724412e-24, -5.444404241668983e-26,  2.402514278545165e-27, -9.706067686281625e-29,  7.545170687244179e-06, -2.025537069007438e-07,
  3.347272848223828e-09, -4.431656390573874e-11,  5.119779557641004e-13, -5.278856905652781e-15,  5.813317872748748e-17, -4.540780594102208e-19,  3.445615619720681e-21,
 -1.035699234187049e-22, -5.990703910525029e-25,  3.134541964363930e-27,  3.299177940280083e-05, -9.361773378989662e-07,  1.713675035074880e-08, -2.580761229870980e-10,
  3.449901414707793e-12, -4.212581922146599e-14,  5.059219275686395e-16, -5.298544651223879e-18,  5.441927255898119e-20, -7.728962337516608e-22,  3.251863869474929e-24,
 -4.046289230558872e-26,  4.780803710358893e-05, -1.471330441483023e-06,  3.073919427661936e-08, -5.362599616164988e-10,  8.336948093173165e-12, -1.190726488163363e-13,
  1.603494594516023e-15, -2.029069518078104e-17,  2.463042331336564e-19, -2.967899905097176e-21,  3.207405219173515e-23, -3.578276396479471e-25,  3.421432405314476e-05,
 -1.169692923190401e-06,  2.834659181713496e-08, -5.740477046263415e-10,  1.031971784813450e-11, -1.700601250486767e-13,  2.597500880194699e-15, -3.789930351217133e-17,
  5.246573295070082e-19, -6.801574507970072e-21,  9.045406907779428e-23, -1.108599142030272e-24,  1.379288415361373e-05, -5.356372470840720e-07,  1.517061804095333e-08,
 -3.559151953231607e-10,  7.364762084944541e-12, -1.389843236574443e-13,  2.415147517896429e-15, -3.994980949882032e-17,  6.242294061102578e-19, -9.148629250155347e-21,
  1.347248901206571e-22, -1.849375464617720e-24,  3.289494724588287e-06, -1.482419228262354e-07,  4.925838571092538e-09, -1.338304806838788e-10,  3.184149160290386e-12,
 -6.865272537530437e-14,  1.358370828158499e-15, -2.536817324081971e-17,  4.463856016519024e-19, -7.411407612017809e-21,  1.202488818223342e-22, -1.847970841679445e-24,
  4.690144279428885e-07, -2.506008252058615e-08,  9.810354044555115e-10, -3.096865417684506e-11,  8.494376877986451e-13, -2.096335676029830e-14,  4.732190418563907e-16,
 -9.996398224747248e-18,  1.984076858504101e-19, -3.722075979193793e-21,  6.711359226457924e-23, -1.153688529644971e-24,  3.941561154161371e-08, -2.555719852985733e-09,
  1.187696891639225e-10, -4.390735113822934e-12,  1.397750046319464e-13, -3.972235760666565e-15,  1.028112947659307e-16, -2.470917877502069e-18,  5.558935856266550e-20,
 -1.179891366249117e-21,  2.385336556869614e-23, -4.597926617812430e-25,  1.885592493354311e-09, -1.524989175054961e-10,  8.530722650410500e-12, -3.744283166508230e-13,
  1.399965527464433e-14, -4.632036083738408e-16,  1.387680379008705e-17, -3.832021501495874e-19,  9.857565342552225e-21, -2.382791111122337e-22,  5.452683661983631e-24,
 -1.186099849434584e-25,  4.860304330941562e-11, -5.080460995900451e-12,  3.503922559774437e-13, -1.866537116350946e-14,  8.357615958529781e-16, -3.277480358183149e-17,
  1.154636870771304e-18, -3.720066476015074e-20,  1.109488950900574e-21, -3.091787643718083e-23,  8.109256763679194e-25, -2.012018632619958e-26,  6.290369643544199e-13,
 -8.935700874668976e-14,  7.909460063206786e-15, -5.296161985863000e-16,  2.929746828112415e-17, -1.400593341098551e-18,  5.949940507617608e-20, -2.288987948563638e-21,
  8.082299739514288e-23, -2.645899101627059e-24,  8.093889199820758e-26, -2.326381198934424e-27,  3.919044612590955e-15, -8.146016223395293e-16,  9.882518315408059e-17,
 -8.794017192331469e-18,  6.308666786909035e-19, -3.835797423998059e-20,  2.038861236720632e-21, -9.674399201341008e-23,  4.160010923099369e-24, -1.639492710376995e-25,
  5.974329295980038e-27, -2.025240784109325e-28,  1.580203554082559e-17, -5.181865785225528e-18,  9.297425368977659e-19, -1.168090099406742e-19,  1.139727391549447e-20,
 -9.140355714817054e-22,  6.243896633781460e-23, -3.723113010122755e-24,  1.972660456544701e-25, -9.414117491063688e-27,  4.089935709129173e-28, -1.629496405316279e-29,
  6.785330782190215e-06, -1.777710132458134e-07,  2.861374102882818e-09, -3.689787234385346e-11,  4.193721520758826e-13, -4.027365236941336e-15,  4.637341646258989e-17,
 -4.072664512140016e-19, -5.930693621584217e-22, -1.147408757083664e-22,  3.358427717232533e-25,  4.349948607406540e-26,  2.950288972312721e-05, -8.105925980563596e-07,
  1.434523137934409e-08, -2.090053319723226e-10,  2.717700175008015e-12, -3.159208693669996e-14,  3.779278786082821e-16, -3.978742424547646e-18,  2.880976940445705e-20,
 -6.442660423043022e-22,  4.143101665787525e-24,  9.142451437976320e-26,  4.237676547125121e-05, -1.249058019249437e-06,  2.503211514426081e-08, -4.200077858514914e-10,
  6.298528495054769e-12, -8.660638459891204e-14,  1.131241490750270e-15, -1.389814650584914e-17,  1.592875022094403e-19, -1.942556351923414e-21,  2.051358811530855e-23,
 -1.759039903331819e-25,  2.994911786552663e-05, -9.679056625961245e-07,  2.234653490295105e-08, -4.330840371114735e-10,  7.464888464608233e-12, -1.187605826451473e-13,
  1.739027562856156e-15, -2.441610089918242e-17,  3.345068634768735e-19, -4.017545493928641e-21,  5.161343942721378e-23, -7.118730362661394e-25,  1.186858869699322e-05,
 -4.295455476444207e-07,  1.152417554781487e-08, -2.575104149346531e-10,  5.084602768728463e-12, -9.245744884100444e-14,  1.533276256546500e-15, -2.434560897822932e-17,
  3.748820744813361e-19, -5.109922080216658e-21,  7.288217918810878e-23, -1.064074764637631e-24,  2.766267630300178e-06, -1.144869238924963e-07,  3.585381825312723e-09,
 -9.231253961591927e-11,  2.086973831073802e-12, -4.317830130495531e-14,  8.137299812638766e-16, -1.456339715111881e-17,  2.495529054147205e-19, -3.909889822407850e-21,
  6.134136086068205e-23, -9.451691629954788e-25,  3.824057507663889e-07, -1.849552787281565e-08,  6.788885530152388e-10, -2.019839015384865e-11,  5.243140646007117e-13,
 -1.235492699277894e-14,  2.652515362194286e-16, -5.358424075998728e-18,  1.025834674376424e-19, -1.832269585729977e-21,  3.184363116688498e-23, -5.335507677838577e-25,
  3.080603497924610e-08, -1.783569270444329e-09,  7.725532000500850e-11, -2.676178517874243e-12,  8.029442973820184e-14, -2.167508467070202e-15,  5.325863648423697e-17,
 -1.220925976648675e-18,  2.632713465497568e-20, -5.337986201136043e-22,  1.036994777600647e-23, -1.927666111870352e-25,  1.388208184911248e-09, -9.902011395275021e-11,
  5.125831823101988e-12, -2.095463551636512e-13,  7.352262875255066e-15, -2.299115421571290e-16,  6.523585952178749e-18, -1.713610510851480e-19,  4.208044871048152e-21,
 -9.718706332956044e-23,  2.132220248547628e-24, -4.456293856509993e-26,  3.273463960466958e-11, -2.987474190914332e-12,  1.890679471457875e-13, -9.324749354186397e-15,
  3.900729275247492e-16, -1.439216520884777e-17,  4.790153618023295e-19, -1.464467327659579e-20,  4.159210782487458e-22, -1.106617194352275e-23,  2.779220264567655e-25,
 -6.618267663852270e-27,  3.668774676287311e-13, -4.524898751444607e-14,  3.644591441707828e-15, -2.248390328776390e-16,  1.157880913051816e-17, -5.192515688298796e-19,
  2.080940339579750e-20, -7.589245029011912e-22,  2.550758203530406e-23, -7.976347553801491e-25,  2.338046521407595e-26, -6.457513486463481e-28,  1.756135134249088e-15,
 -3.192225647042930e-16,  3.516583908713846e-17, -2.885632376538897e-18,  1.930769901891193e-19, -1.104246915182978e-20,  5.558035120207885e-22, -2.511230739570202e-23,
  1.033032593525553e-24, -3.910494191090069e-26,  1.373532744618958e-27, -4.502174775440260e-29,  4.118523434673975e-18, -1.246065635830906e-18,  2.097552598398619e-19,
 -2.501472378838545e-20,  2.336982538485872e-21, -1.806472974519245e-22,  1.195661213946036e-23, -6.937040611888448e-25,  3.588716948860180e-26, -1.677012159872642e-27,
  7.151468237094453e-29, -2.802611384889669e-30,  6.117377915669662e-06, -1.565427973599820e-07,  2.456386391671211e-09, -3.077578829520149e-11,  3.490041929338958e-13,
 -3.057003716957385e-15,  3.412795496109359e-17, -4.850849920708971e-19, -3.882399542539189e-21, -4.803454655087570e-23,  3.334164804411523e-24,  8.766141998259966e-26,
  2.647514272601457e-05, -7.051687880291635e-07,  1.207871264648376e-08, -1.701203098452945e-10,  2.167989739637742e-12, -2.377453918157175e-14,  2.762306677341639e-16,
 -3.385241211412259e-18,  9.997272406843824e-21, -3.515865318893915e-22,  1.153634331740583e-23,  2.299680535560761e-25,  3.775138303917640e-05, -1.067370947399615e-06,
  2.054396032806614e-08, -3.317359348875973e-10,  4.809099884590125e-12, -6.360966258853770e-14,  8.039957038511274e-16, -9.773955824239487e-18,  1.026631147951441e-19,
 -1.233271564065933e-21,  1.592598052442046e-23, -4.328476755124376e-26,  2.640477115825449e-05, -8.080578217047280e-07,  1.779453321818814e-08, -3.305920857141068e-10,
  5.457399077689586e-12, -8.413899377304599e-14,  1.185997587454126e-15, -1.568503792133329e-17,  2.200475630100142e-19, -2.519993482587278e-21,  2.452014742006689e-23,
 -5.343761249528898e-25,  1.031700479617928e-05, -3.484582352564334e-07,  8.867048124279890e-09, -1.891599483836538e-10,  3.554575142800556e-12, -6.263534964023190e-14,
  9.954114584849160e-16, -1.481382115633942e-17,  2.332775549900592e-19, -3.007738474172124e-21,  3.478727658563256e-23, -7.060305987076070e-25,  2.359393076660192e-06,
 -8.972657911376132e-08,  2.652577285507658e-09, -6.489230544055637e-11,  1.389840637725675e-12, -2.775466806649464e-14,  4.995451030467646e-16, -8.428417210191299e-18,
  1.443049604248228e-19, -2.143073043157080e-21,  2.998825420068144e-23, -5.297898498361336e-25,  3.179299071285083e-07, -1.390808965509120e-08,  4.796833291452593e-10,
 -1.348530644814561e-11,  3.304101188288621e-13, -7.471559176517785e-15,  1.527740901146131e-16, -2.925106614931369e-18,  5.480106950528760e-20, -9.316465054715024e-22,
  1.515114665055640e-23, -2.608711013393608e-25,  2.473144828454932e-08, -1.275038061973456e-09,  5.161577110186352e-11, -1.678932445918273e-12,  4.738316521340997e-14,
 -1.219590934504844e-15,  2.846546793940226e-17, -6.199707005143631e-19,  1.290189957721774e-20, -2.496210667995883e-22,  4.619388292901743e-24, -8.422187194205509e-26,
  1.060638959166045e-09, -6.637318201872384e-11,  3.189028405879365e-12, -1.215831324470593e-13,  3.997840443130954e-15, -1.184335887247011e-16,  3.183051419720229e-18,
 -7.941845813288867e-20,  1.866573702997690e-21, -4.115622744476332e-23,  8.639319756155593e-25, -1.741946618515037e-26,  2.322647722970689e-11, -1.834833236987794e-12,
  1.068177319254815e-13, -4.878111179550001e-15,  1.904297627410622e-16, -6.615910342924430e-18,  2.079359699480295e-19, -6.027557213050911e-21,  1.630661916402570e-22,
 -4.139043196728266e-24,  9.945626300737215e-26, -2.273482779075668e-27,  2.306980731543366e-13, -2.437820157015603e-14,  1.786903547552477e-15, -1.013742415673722e-16,
  4.850616102622746e-18, -2.038210924518098e-19,  7.693553371611855e-21, -2.655847700389195e-22,  8.485223244089500e-24, -2.530518136247141e-25,  7.096874127670128e-27,
 -1.880797229952891e-28,  8.793553169677934e-16, -1.369272780514050e-16,  1.361182170192038e-17, -1.023867516221268e-18,  6.357549924256569e-20, -3.405234939493061e-21,
  1.616408931785361e-22, -6.927963715400761e-24,  2.716793455961203e-25, -9.845216720425678e-27,  3.322721522748656e-28, -1.049980898594988e-29,  1.221177698280736e-18,
 -3.316605575254098e-19,  5.154010304189123e-20, -5.763786180301737e-21,  5.106576201053386e-22, -3.774931165442704e-23,  2.405037157917852e-24, -1.350184214838100e-25,
  6.787589446020597e-27, -3.093185920789403e-28,  1.290170727507559e-29, -4.957991333481206e-31,  5.528298174952779e-06, -1.382783964300608e-07,  2.118694619030286e-09,
 -2.564121947102969e-11,  2.948792765247372e-13, -2.415450388752438e-15,  1.877344993644430e-17, -6.037718149155700e-19, -2.304212711315410e-21,  1.577310581282913e-22,
  6.532884423108220e-24,  2.742574994243151e-26,  2.383558545208378e-05, -6.161491233662523e-07,  1.023078479825980e-08, -1.389078871811833e-10,  1.751266985406281e-12,
 -1.825430936664359e-14,  1.847704883287462e-16, -3.158944316128953e-18,  8.055918736274651e-21,  3.026632533818688e-22,  2.007347289567454e-23,  7.154973866535041e-26,
  3.378711795164899e-05, -9.177248262419549e-07,  1.698597717604213e-08, -2.640063243434717e-10,  3.709458536684141e-12, -4.726328146178665e-14,  5.705046264369091e-16,
 -7.078701184837507e-18,  6.943764714932060e-20, -6.187844612697352e-22,  1.484059442669041e-23, -4.014830239356274e-26,  2.343406624921124e-05, -6.802040937703869e-07,
  1.430044065585327e-08, -2.553254204825737e-10,  4.027462641381918e-12, -6.022766998920527e-14,  8.328586611377119e-16, -9.948435486263649e-18,  1.418338688147740e-19,
 -1.949359936168915e-21,  5.944056832204509e-24, -2.635620342877168e-25,  9.051917742452744e-06, -2.857220986697533e-07,  6.900881813102775e-09, -1.411374353187121e-10,
  2.511134471809224e-12, -4.297124746637456e-14,  6.704422609564424e-16, -8.868560318801212e-18,  1.433365795634424e-19, -2.150112146731572e-21,  1.056849974486875e-23,
 -3.596473825470168e-25,  2.038479147363628e-06, -7.128107296555455e-08,  1.990887834073620e-09, -4.651588597999368e-11,  9.379434817271517e-13, -1.813977711651530e-14,
  3.180098059726973e-16, -4.854380580939746e-18,  8.384854024952796e-20, -1.331439295858200e-21,  1.245621503711484e-23, -2.702183238023042e-25,  2.690609805520501e-07,
 -1.063823368415731e-08,  3.452248152979758e-10, -9.219618350970873e-12,  2.119167850017425e-13, -4.616967322531719e-15,  9.109782965847389e-17, -1.610766488788355e-18,
  2.982532849204605e-20, -5.101967087508022e-22,  6.885833194329911e-24, -1.268058101642987e-25,  2.034557230400206e-08, -9.314512764813232e-10,  3.531835833079569e-11,
 -1.083975267123866e-12,  2.862696366616137e-14, -7.052647231995354e-16,  1.575285637228883e-17, -3.214378647655434e-19,  6.503041264445295e-21, -1.225758160824819e-22,
  2.066847903141528e-24, -3.778544863616557e-26,  8.382581132192742e-10, -4.576589969992339e-11,  2.047294987780307e-12, -7.306644706767518e-14,  2.242815355463366e-15,
 -6.313852541391834e-17,  1.612895815991034e-18, -3.798279438079641e-20,  8.579502773493203e-22, -1.816594120653616e-23,  3.598844785685152e-25, -7.065641387243985e-27,
  1.728727497649230e-11, -1.171185569358111e-12,  6.293885570075264e-14, -2.666933613378658e-15,  9.689516143007079e-17, -3.175462387709666e-18,  9.433454201143630e-20,
 -2.586265710924665e-21,  6.674713187868484e-23, -1.617412032950925e-24,  3.705312533287973e-26, -8.149921589759353e-28,  1.555945500905525e-13, -1.388483144058612e-14,
  9.282662117187677e-16, -4.841103601753662e-17,  2.147180931609871e-18, -8.452630499723157e-20,  3.002382041741351e-21, -9.793864489768212e-23,  2.972490268219307e-24,
 -8.444349822623571e-26,  2.262068175913768e-27, -5.748035308662246e-29,  4.906071986365878e-16, -6.396023832443783e-17,  5.718690548371720e-18, -3.924406919831676e-19,
  2.251329821518516e-20, -1.125363733756553e-21,  5.019994534114053e-23, -2.034086591330053e-24,  7.580297889684162e-26, -2.621589542606055e-27,  8.476340216835435e-29,
 -2.575085447492805e-30,  4.211585814760310e-19, -9.906413313892193e-20,  1.396289652685469e-20, -1.444453259144997e-21,  1.200651516431546e-22, -8.413296944473305e-24,
  5.121336054785916e-25, -2.764426516807523e-26,  1.343117939908934e-27, -5.940757022739765e-29,  2.413647694774062e-30, -9.062719051500859e-32,  5.007243528703903e-06,
 -1.224829521425247e-07,  1.837777614060930e-09, -2.129095539316772e-11,  2.496923187389707e-13, -2.169041928214769e-15,  2.045300912949659e-18, -5.374237235242883e-19,
  7.809516098041687e-21,  3.790764029204744e-22,  2.637556227255685e-24, -2.276432195849634e-25,  2.152476221392665e-05, -5.405204066797737e-07,  8.720663891602861e-09,
 -1.135967298746613e-10,  1.423574660559107e-12, -1.483650926472080e-14,  1.026596291650517e-16, -2.575690907824517e-18,  3.259343122772910e-20,  9.881769709260347e-22,
  8.816989176632199e-24, -6.529392678380361e-25,  3.036926521870215e-05, -7.935676635688232e-07,  1.414505159656764e-08, -2.115362710373945e-10,  2.886284331172295e-12,
 -3.571514918680725e-14,  4.008436205214041e-16, -5.104824447564807e-18,  5.697034181790035e-20, -1.134513592764963e-22,  8.701169902726020e-24, -2.723019115946786e-25,
  2.092408639829425e-05, -5.770456445215146e-07,  1.158670140367184e-08, -1.995226974115472e-10,  3.002612322895143e-12, -4.313247006089247e-14,  6.075328661088577e-16,
 -6.500499108256798e-18,  7.452116208933228e-20, -1.787486666088252e-21,  6.527178382159844e-24,  3.271199834098502e-25,  8.009601858268405e-06, -2.366666331934048e-07,
  5.422562231403467e-09, -1.070364226849952e-10,  1.794885601547600e-12, -2.941136081133600e-14,  4.751502410596149e-16, -5.459949461811664e-18,  7.122731566788997e-20,
 -1.874664084140145e-21,  7.915118322480438e-24,  2.780276227939226e-25,  1.782000809912778e-06, -5.735669963663353e-08,  1.511996479009800e-09, -3.403776607640200e-11,
  6.418505093265970e-13, -1.187675287148694e-14,  2.130208516296534e-16, -2.860230376081476e-18,  4.278753727955829e-20, -9.855191821510147e-22,  7.086303294921832e-24,
  3.560789910227508e-26,  2.314039634333144e-07, -8.267650440823475e-09,  2.522333365457191e-10, -6.462467776824569e-12,  1.382792060773686e-13, -2.879296076035084e-15,
  5.692157095414934e-17, -9.061892602169125e-19,  1.534299867244547e-20, -3.167580700134129e-22,  3.489523686368850e-24, -3.025211382210437e-26,  1.711220965570404e-08,
 -6.941008728072806e-10,  2.465246242038748e-11, -7.209286984180730e-13,  1.767940557192597e-14, -4.152624272260464e-16,  9.099952936197361e-18, -1.707475048910946e-19,
  3.251412978738246e-21, -6.527519782010361e-23,  9.678073503369099e-25, -1.432168522611113e-26,  6.831481611066901e-10, -3.236858231624868e-11,  1.350080571218112e-12,
 -4.549300118021098e-14,  1.294782621126499e-15, -3.460706799233537e-17,  8.521916238684470e-19, -1.872563448121611e-20,  4.024407284669761e-22, -8.478104073458963e-24,
  1.550305348376084e-25, -2.821135836196776e-27,  1.343858775118770e-11, -7.734662756714237e-13,  3.848210666693158e-14, -1.522552518822916e-15,  5.121195172510997e-17,
 -1.584139565196835e-18,  4.476265658843642e-20, -1.153884341225241e-21,  2.835906727612003e-23, -6.629841707021313e-25,  1.434607657342880e-26, -3.013539715498995e-28,
  1.119105766007313e-13, -8.305394217602106e-15,  5.082080381654292e-16, -2.443492932940175e-17,  1.000665818732701e-18, -3.691648474899872e-20,  1.235486994651309e-21,
 -3.797382249138375e-23,  1.094280177141928e-24, -2.964725943518352e-26,  7.560627014331772e-28, -1.840116955784477e-29,  3.032681841635368e-16, -3.228889943509411e-17,
  2.596899822791964e-18, -1.621825031986079e-19,  8.557623267481749e-21, -3.982480557238151e-22,  1.665067066209668e-23, -6.357800567681331e-25,  2.245858268793659e-26,
 -7.393750532582613e-28,  2.283545717876430e-29, -6.653168086996254e-31,  1.719857300003363e-19, -3.350953407521896e-20,  4.213012178286164e-21, -3.975369234422081e-22,
  3.065066218954175e-23, -2.017000120187611e-24,  1.163674904031205e-25, -5.997593249825506e-27,  2.799273868331760e-28, -1.195368235460245e-29,  4.708612598232792e-31,
 -1.720358548178871e-32,  4.545189578417728e-06, -1.087380831604345e-07,  1.604821285714080e-09, -1.764470193806822e-11,  2.057837643476458e-13, -2.259523145051485e-15,
 -7.443092028228820e-18, -7.285322616868728e-20,  2.029192523392315e-20,  2.181325320066072e-22, -1.157179363323976e-23, -3.377195060133215e-25,  1.949409573745839e-05,
 -4.758423196589140e-07,  7.484746887213625e-09, -9.308147666561307e-11,  1.146393359044196e-12, -1.308658877472658e-14,  5.058467896824805e-17, -9.646024529251207e-19,
  6.569737828402803e-20,  5.726820638427759e-22, -3.228206600491906e-23, -9.880349246015137e-25,  2.740627939480009e-05, -6.898270398790571e-07,  1.186169687250131e-08,
 -1.705923671661841e-10,  2.257661327312395e-12, -2.760616356766011e-14,  2.831361044816444e-16, -3.308239359200428e-18,  5.554789762230992e-20, -7.914297570771678e-23,
 -8.150067761205356e-24, -4.182907438098426e-25,  1.878720001272685e-05, -4.931731166751478e-07,  9.454619572559207e-09, -1.576476462905121e-10,  2.272177373510644e-12,
 -3.052315330538256e-14,  4.498019113788269e-16, -5.057125054245237e-18,  1.976426347420367e-20, -1.092960002812182e-21,  3.025295951632491e-23,  5.863984308033552e-25,
  7.142196624180627e-06, -1.979765964753180e-07,  4.292897155806984e-09, -8.245259088991316e-11,  1.309388230815734e-12, -1.964411361382570e-14,  3.446647089349847e-16,
 -4.164559323975507e-18,  1.398732545615142e-20, -1.148038223531736e-21,  3.099945176615768e-23,  6.083697763273923e-25,  1.574403874739849e-06, -4.673633046675303e-08,
  1.158153503541358e-09, -2.541550438775342e-11,  4.496216034657463e-13, -7.601225108744912e-15,  1.472025083711176e-16, -1.995892263340109e-18,  1.353135970321636e-20,
 -5.932110731745287e-22,  1.386244197298017e-23,  2.091718217308778e-25,  2.019258361628013e-07, -6.526303765256368e-09,  1.862771833000029e-10, -4.644216707267795e-12,
  9.254461946801709e-14, -1.771789230471167e-15,  3.689158726070491e-17, -5.719347678781802e-19,  6.338700896389589e-21, -1.819426869349959e-22,  3.663512238675928e-24,
  2.461981441155824e-26,  1.468149988073626e-08, -5.272383570275349e-10,  1.745891789917868e-11, -4.940732423164313e-13,  1.122332883355852e-14, -2.444070332312830e-16,
  5.469909082186462e-18, -9.778242213965092e-20,  1.488060535928102e-21, -3.475673873157525e-23,  6.461684756986854e-25, -2.347283526719740e-27,  5.722536255315116e-10,
 -2.344559400167589e-11,  9.087915007664973e-13, -2.935767289304080e-14,  7.711604206147616e-16, -1.923548958331162e-17,  4.696222400269740e-19, -9.734470413921130e-21,
  1.852367681029862e-22, -4.092517863145068e-24,  7.765134234900994e-26, -9.710457192655768e-28,  1.086163224069266e-11, -5.268388742667024e-13,  2.424524905864164e-14,
 -9.076412365706229e-16,  2.810418178922248e-17, -8.136450356266585e-19,  2.223255885915510e-20, -5.389676819534295e-22,  1.228985683556583e-23, -2.843354146693779e-25,
  5.958833453374398e-27, -1.102532449646065e-28,  8.528484464286753e-14, -5.187615457732530e-15,  2.910662736612429e-16, -1.302101274516943e-17,  4.896440287609154e-19,
 -1.687804059766176e-20,  5.359585217321623e-22, -1.547972527656492e-23,  4.205669828171511e-25, -1.095587321738267e-26,  2.662413632694654e-28, -6.106217433482865e-30,
  2.059721788810382e-16, -1.746010721474933e-17,  1.266128784139892e-18, -7.212200055392682e-20,  3.481309862845734e-21, -1.505125661457155e-22,  5.896971062985850e-24,
 -2.114611720670642e-25,  7.060126169908638e-27, -2.211146843097678e-28,  6.504683260557752e-30, -1.810947623317853e-31,  8.383808762839192e-20, -1.285416823132279e-20,
  1.424181584257996e-21, -1.210454826202865e-22,  8.557436937441309e-24, -5.240524433250333e-25,  2.842531525193738e-26, -1.388596584691222e-27,  6.186205678650115e-29,
 -2.535983636209778e-30,  9.635024972925346e-32, -3.409864957060848e-33,  4.134647804879453e-06, -9.669398078616912e-08,  1.411318791560741e-09, -1.472270817751019e-11,
  1.590380583716116e-13, -2.385821182493516e-15,  9.850625140811850e-21,  5.894602931180260e-19,  1.716387235973100e-20, -4.296307292059666e-22, -1.685494272537488e-23,
  1.927432024425418e-25,  1.770382271185567e-05, -4.201399272037239e-07,  6.469384975595300e-09, -7.677184220291760e-11,  8.958843099324212e-13, -1.195079678422645e-14,
  5.391309813473107e-17,  1.149366476503799e-18,  5.521128144012468e-20, -1.271494052739232e-21, -4.861661906423312e-23,  5.274317544840831e-25,  2.482460783274552e-05,
 -6.025475191682496e-07,  1.001422236765192e-08, -1.385455056468669e-10,  1.767003725549968e-12, -2.172728961351148e-14,  2.143300402916325e-16, -1.669886500513629e-18,
  4.327574124035248e-20, -6.648312212070772e-22, -1.702942890298237e-23,  1.337211445935101e-25,  1.695461609927678e-05, -4.245280344821082e-07,  7.762602242348633e-09,
 -1.256372040739817e-10,  1.758446200729339e-12, -2.138257374007683e-14,  3.130483756299726e-16, -4.781074574255253e-18,  6.642139165600264e-21,  4.184721737075550e-22,
  3.766813815718651e-23, -4.368612853425498e-25,  6.413177075146970e-06, -1.672621236001017e-07,  3.417551065865227e-09, -6.423512706267460e-11,  9.899144829165806e-13,
 -1.274937552354852e-14,  2.300735469523892e-16, -4.096537923223584e-18, -2.191811013133984e-22,  4.249269925716784e-22,  4.007004444582576e-23, -4.068428136191180e-25,
  1.404216311733905e-06, -3.857914784794917e-08,  8.918858320593844e-10, -1.926413519875578e-11,  3.285833880896724e-13, -4.705566632622830e-15,  9.502204657960227e-17,
 -1.782714447671850e-18,  3.841699438162945e-21,  7.805572561263898e-23,  1.697367439828164e-23, -1.563051997672476e-25,  1.784804444951482e-07, -5.236242733323484e-09,
  1.384032826074774e-10, -3.403982079984067e-12,  6.476228308882600e-14, -1.060633445119363e-15,  2.294502861090537e-17, -4.438217251648252e-19,  2.626603024254359e-21,
 -2.228304328514600e-23,  3.881259845630936e-24, -3.398446480769671e-26,  1.281821269284056e-08, -4.085592162296931e-10,  1.246693549717716e-11, -3.473195144589888e-13,
  7.449734850594356e-15, -1.415851575323630e-16,  3.245169273991972e-18, -6.535829551771324e-20,  6.818410996058847e-22, -1.069013692800631e-23,  5.361090805146064e-25,
 -5.086931595972896e-27,  4.910428107638080e-10, -1.740035056474355e-11,  6.195914764179859e-13, -1.956656597156572e-14,  4.800384253166143e-16, -1.068201280904858e-17,
  2.617568651411432e-19, -5.634047563581182e-21,  8.557009270102803e-23, -1.634682768840369e-24,  4.799423769123998e-26, -5.815433039065957e-28,  9.082591085821472e-12,
 -3.698703124665117e-13,  1.559613043787364e-14, -5.636043497937004e-16,  1.613957884418560e-17, -4.247337157912532e-19,  1.138972020911721e-20, -2.713229340667439e-22,
  5.415424830765524e-24, -1.179242974514723e-25,  2.821752894964168e-27, -4.607517296825423e-29,  6.836098915440863e-14, -3.372659455985135e-15,  1.725986329463541e-16,
 -7.312347666931019e-18,  2.521495186886922e-19, -7.997549259758521e-21,  2.437469211106814e-22, -6.704776808164644e-24,  1.674788165790771e-25, -4.174623337838407e-27,
  1.012124457204906e-28, -2.133199918188456e-30,  1.519963718531740e-16, -1.003324635493088e-17,  6.558711701658357e-19, -3.444640625947743e-20,  1.512947911746697e-21,
 -6.038909723065916e-23,  2.226662839032653e-24, -7.497378218471688e-26,  2.346873050222636e-27, -6.995447344671997e-29,  1.969517786587079e-30, -5.191847113510619e-32,
  4.848388379298795e-20, -5.551389428983665e-21,  5.389894894941359e-22, -4.097023607315346e-23,  2.624929465549567e-24, -1.483117441823892e-25,  7.512420458651421e-27,
 -3.452924569466683e-28,  1.458290681355293e-29, -5.707580897470697e-31,  2.080687074740735e-32, -7.095077917846499e-34,  3.769390384588291e-06, -8.607045682708327e-08,
  1.248356884998784e-09, -1.255331343378400e-11,  1.129060528576434e-13, -2.143767744165879e-15,  2.110703926609071e-17,  7.896568456269141e-19, -6.622504969021971e-21,
 -7.484061631731779e-22,  4.224453737466522e-24,  6.252058373823102e-25,  1.612125922915256e-05, -3.718438570908041e-07,  5.626505086671243e-09, -6.426564431331925e-11,
  6.732232784995466e-13, -1.012498021343669e-14,  1.017099582358286e-16,  1.888747540141090e-18, -1.478832719287483e-20, -2.207175333006718e-21,  1.168139963262028e-23,
  1.815063751428530e-24,  2.256475304687086e-05, -5.286345777670650e-07,  8.507836612962160e-09, -1.134837333124084e-10,  1.380809306943735e-12, -1.701423098184593e-14,
  1.825620257150362e-16, -7.738789360570576e-19,  1.060179556713253e-20, -1.005249969851548e-21,  4.313604768693776e-24,  6.971425859772538e-25,  1.537179263084787e-05,
 -3.680095776513302e-07,  6.410853697099818e-09, -1.005598752697541e-10,  1.395299639600113e-12, -1.542888717433087e-14,  1.861590573424107e-16, -4.097343056266393e-18,
  4.078029740923890e-20,  1.183200954151794e-21, -5.717885923069857e-24, -1.257607934755100e-24,  5.794284325844117e-06, -1.427533670418644e-07,  2.734212576386736e-09,
 -5.017511320510620e-11,  7.809456821404485e-13, -8.580977798767762e-15,  1.194517934187341e-16, -3.609126051223755e-18,  3.594787395349162e-20,  1.283478512427687e-21,
 -4.239439500829629e-24, -1.333577779379832e-24,  1.262823478279539e-06, -3.228579543080335e-08,  6.895103019582094e-10, -1.465242902758567e-11,  2.533324184494112e-13,
 -3.003371674348770e-15,  4.805779709716432e-17, -1.506906116576842e-18,  1.577281949800990e-20,  4.667575423194050e-22, -4.382107907127394e-25, -5.346340512609110e-25,
  1.595141867674139e-07, -4.276230329526449e-09,  1.031584442182577e-10, -2.511620669338868e-12,  4.809934170173885e-14, -6.493557976106583e-16,  1.176172981953091e-17,
 -3.474017900947979e-19,  3.983771650783983e-21,  7.379605721707409e-23,  3.457908859903655e-25, -1.090577912011092e-25,  1.135965854095344e-08, -3.236593780273631e-10,
  8.932936736316362e-12, -2.471267419049056e-13,  5.260368044813527e-15, -8.341746865765988e-17,  1.688905873697319e-18, -4.616067389913218e-20,  6.042116184210619e-22,
  3.605941104070881e-24,  1.232125250392756e-25, -1.224068166437724e-26,  4.300332344075710e-10, -1.326650825122682e-11,  4.247974775138169e-13, -1.330238816643878e-14,
  3.178542250709844e-16, -6.025908924670205e-18,  1.358237331329002e-19, -3.521080674764930e-21,  5.446172534229401e-23, -2.994055783039022e-25,  1.699413139742774e-26,
 -7.967600858054260e-28,  7.815267862879632e-12, -2.683249599335422e-13,  1.014375859387605e-14, -3.607502950795565e-16,  9.850175800331485e-18, -2.261976717898913e-19,
  5.714763508546653e-21, -1.477735609369362e-22,  2.765622920005649e-24, -4.024896588186077e-26,  1.151025309271262e-27, -3.279824417182578e-29,  5.715925054622080e-14,
 -2.284647734010435e-15,  1.046564543328960e-16, -4.294187462032971e-18,  1.381207317949455e-19, -3.909720818941608e-21,  1.131096187405865e-22, -3.122127842992354e-24,
  7.187873703231168e-26, -1.540729799145732e-27,  3.907618018949626e-29, -9.215318173671981e-31,  1.202194261752533e-16, -6.104122586059302e-18,  3.556675229120010e-19,
 -1.758422134958578e-20,  7.051830693699614e-22, -2.553066549120739e-23,  8.872842707609455e-25, -2.852547828163382e-26,  8.291090972199326e-28, -2.300263365147079e-29,
  6.318999390193919e-31, -1.615971830492945e-32,  3.256321509729789e-20, -2.667019547587164e-21,  2.260527057244786e-22, -1.544028512356750e-23,  8.874164856343646e-25,
 -4.576366923186258e-26,  2.155937796167531e-27, -9.280898079232708e-29,  3.685381440805219e-30, -1.368219288173932e-31,  4.771305126994140e-33, -1.560334761260852e-34,
  3.444167542890210e-06, -7.665849552611393e-08,  1.107249224102909e-09, -1.105550647953149e-11,  7.666622995735640e-14, -1.418302355590871e-15,  3.672031452152091e-17,
  2.277625354147858e-19, -2.479329316736000e-20, -1.427282538745617e-22,  2.154112520472344e-23,  2.904115494960410e-26,  1.471926310652099e-05, -3.297478966027990e-07,
  4.913738807165424e-09, -5.496529944549277e-11,  4.988533898396179e-13, -7.169354672324011e-15,  1.375063787839454e-16,  3.759395174360170e-19, -6.908515877582485e-20,
 -4.601898633094770e-22,  6.274394507316629e-23,  1.097686307620051e-25,  2.057821339751093e-05, -4.656678740925560e-07,  7.268111897110933e-09, -9.388208321967141e-11,
  1.082649603504690e-12, -1.288525326245291e-14,  1.607694178354546e-16, -9.245476805378654e-19, -1.583984680486264e-20, -3.198886292973953e-22,  2.530745431961211e-23,
  8.398012386266061e-26,  1.399519206976153e-05, -3.211921565880850e-07,  5.328588066458980e-09, -8.049683688439453e-11,  1.123022522369778e-12, -1.215503945306505e-14,
  9.521474869928879e-17, -2.252259256376669e-18,  6.776889578946036e-20,  7.906828628296068e-23, -4.045130590269555e-23, -6.475881987208486e-26,  5.263488717370740e-06,
 -1.230878450082610e-07,  2.201836000634872e-09, -3.892868016715422e-11,  6.306490339443724e-13, -6.757976423042185e-15,  4.059360381360377e-17, -1.857031978453835e-18,
  6.667283511782462e-20,  1.601182691729224e-22, -4.278556063997050e-23, -1.264791888678062e-25,  1.143690569439623e-06, -2.740834756163038e-08,  5.361855241248355e-10,
 -1.103011313148638e-11,  2.017378726819289e-13, -2.284952140679487e-15,  1.518135367436433e-17, -7.792536547018612e-19,  2.719772754296969e-20,  5.823273596909137e-23,
 -1.649872832445125e-23, -7.369218402117528e-26,  1.438861931027862e-07, -3.559340182244066e-09,  7.724929408141599e-11, -1.833608349482856e-12,  3.723162086395811e-14,
 -4.670696219269290e-16,  4.185799009157028e-18, -1.835414793489359e-19,  5.838624830219714e-21,  5.878628347965185e-24, -3.077856428533090e-24, -2.125000143445706e-26,
  1.019103475753374e-08, -2.627416500722611e-10,  6.423387109884821e-12, -1.745037894072886e-13,  3.904505998718377e-15, -5.608025411210070e-17,  6.875183132558383e-19,
 -2.479685331111335e-20,  7.028749354431865e-22, -8.700897916314328e-25, -2.799254117561053e-25, -3.336107064206626e-27,  3.828642229657194e-10, -1.042834776559070e-11,
  2.921961731059617e-13, -9.033824118054173e-15,  2.229352026731687e-16, -3.759203647846804e-18,  6.056533313399199e-20, -1.884659676174853e-21,  4.808518400038881e-23,
 -2.389863861547715e-25, -1.020696807317827e-26, -2.924443344297344e-28,  6.880233586848129e-12, -2.021133676326748e-13,  6.631777731116257e-15, -2.331284981393708e-16,
  6.409560598533967e-18, -1.297819705934360e-19,  2.646325600011627e-21, -7.617395820313808e-23,  1.832612984298993e-24, -1.895984178299979e-26,  4.878705267123150e-29,
 -1.433517468333204e-29,  4.941505535870897e-14, -1.621063337583987e-15,  6.421195254013860e-17, -2.587927349896961e-18,  8.115095819017810e-20, -2.026442348106008e-21,
  5.129707881829993e-23, -1.476557060662300e-24,  3.635862766859335e-26, -6.181536694235738e-28,  1.089966376596821e-29, -3.865293237229638e-31,  1.003848936213668e-16,
 -3.943463402152133e-18,  1.986215458024195e-19, -9.455129962657013e-21,  3.556085778383375e-22, -1.144253958419382e-23,  3.635544749329762e-25, -1.149552153435636e-26,
  3.230253263776596e-28, -7.926378665408178e-30,  1.983720720319394e-31, -5.416161451786012e-33,  2.460619647756032e-20, -1.413231853928200e-21,  1.029216021230407e-22,
 -6.443821394013230e-24,  3.325444079349627e-25, -1.538354863036928e-26,  6.688527916540868e-28, -2.708215547450438e-29,  1.007966084526530e-30, -3.499968740531935e-32,
  1.159471156169473e-33, -3.657547604661049e-35,  3.154436324599528e-06, -6.831215337620405e-08,  9.811641560603661e-10, -1.000734024995509e-11,  5.716721935349093e-14,
 -5.491430009583933e-16,  3.234847073215063e-17, -4.929533601002372e-19, -1.617925111752919e-20,  5.272203205424176e-22,  7.929164135001476e-24, -5.083293109423851e-25,
  1.347489263779151e-05, -2.929503655151084e-07,  4.297893061240475e-09, -4.795237843796322e-11,  3.880259991532435e-13, -3.991224969394245e-15,  1.178968358379708e-16,
 -1.646780217035312e-18, -4.536607948526655e-20,  1.508534591992434e-21,  2.377137507553564e-23, -1.480005770576962e-24,  1.882508822572943e-05, -4.117531099121391e-07,
  6.237609393250677e-09, -7.842158728703692e-11,  8.611162636930780e-13, -9.398498681524054e-15,  1.274075601948360e-16, -1.429521904685909e-18, -1.069563277993459e-20,
  5.065892090062015e-22,  1.097949853793706e-23, -5.860467357358758e-25,  1.278997088221833e-05, -2.821395958594610e-07,  4.462767930927438e-09, -6.436622908388905e-11,
  8.989031894893311e-13, -1.038974658527514e-14,  6.081774459939709e-17, -3.286092602787155e-19,  4.486241189646870e-20, -1.169316334279764e-21, -1.409220406700110e-23,
  9.867210397659190e-25,  4.803637106928916e-06, -1.071801955983751e-07,  1.790907402808744e-09, -2.988002537786631e-11,  5.022465702083490e-13, -6.172796228880503e-15,
  1.706244866452689e-17,  5.717381918207858e-20,  4.469764649506100e-20, -1.197517832091745e-21, -1.629254568955325e-23,  1.046976270081424e-24,  1.041870872882134e-06,
 -2.359681030332858e-08,  4.217310136567842e-10, -8.153771780882431e-12,  1.584150679974413e-13, -2.086630316391912e-15,  4.976665191406417e-18,  2.857534709054872e-21,
  1.841491020920885e-20, -4.779986517426781e-22, -6.670594807577677e-24,  4.112451135357954e-25,  1.307588636891171e-07, -3.019913662537932e-09,  5.852577295086258e-11,
 -1.308548641053824e-12,  2.858538351979607e-14, -4.078216688231749e-16,  1.526185306078406e-18, -1.648915817171301e-20,  3.970342527250840e-21, -9.752904611022878e-23,
 -1.333198011014293e-24,  7.974330672582364e-26,  9.230973133382357e-09, -2.187491167553028e-10,  4.669527994817809e-12, -1.202995029303718e-13,  2.904388548239387e-15,
 -4.547839165619124e-17,  2.876080505269501e-19, -4.993538250534032e-21,  4.736693303185061e-22, -1.083622921885146e-23, -1.336545335618751e-25,  7.924354023416069e-27,
  3.452180260534780e-10, -8.469041262295001e-12,  2.029250394490006e-13, -6.004302540765318e-15,  1.588658296935381e-16, -2.776116451944510e-18,  2.740998958003659e-20,
 -5.726191638940717e-22,  3.127623337218026e-23, -6.638118389560154e-25, -5.976492924250206e-27,  3.800347514999256e-28,  6.162396377404352e-12, -1.586839063956640e-13,
  4.373363397380583e-15, -1.485039192415439e-16,  4.307823706037610e-18, -8.587717401883587e-20,  1.229640343178555e-21, -2.885390797241413e-23,  1.101604464924362e-24,
 -2.225335318317240e-26, -5.425096071931663e-29,  6.923538788339675e-30,  4.378908454744245e-14, -1.212221794279232e-15,  3.979330342502644e-17, -1.558782213150067e-18,
  5.018552919661364e-20, -1.178192037905917e-21,  2.334320228930650e-23, -6.103397570028419e-25,  1.904218672422258e-26, -3.948583831304035e-28,  2.994159672737305e-30,
 -1.709815355679030e-32,  8.718732459542342e-17, -2.726392649594374e-18,  1.130271187561376e-19, -5.213465175145516e-21,  1.930243179880855e-22, -5.630337603398060e-24,
  1.521849071799295e-25, -4.565329047071215e-27,  1.369562359676141e-28, -3.292901203128642e-30,  6.220885555884134e-32, -1.409000664988338e-33,  2.021299579733222e-20,
 -8.274841850728413e-22,  4.961830005844198e-23, -2.916832564689520e-24,  1.388281209137558e-25, -5.693974399317941e-27,  2.219598302910443e-28, -8.456241364489574e-30,
  3.014663843657363e-31, -9.774611165365609e-33,  2.970716772129910e-34, -8.897100759586692e-36,  2.896146944151363e-06, -6.092823036802536e-08,  8.663234926577711e-10,
 -9.143853060865366e-12,  5.260657993538271e-14,  2.175114187040885e-17,  1.434149029811984e-17, -6.876733594745022e-19,  3.470780057817277e-21,  4.462480948217295e-22,
 -9.544754686551184e-24, -1.930113893783349e-25,  1.236835523930777e-05, -2.607685474159791e-07,  3.757530348605649e-09, -4.224676728107964e-11,  3.321408717783425e-13,
 -1.825412704756618e-15,  6.021786902121690e-17, -2.168434444887141e-18,  1.132060009172307e-20,  1.293574468576183e-21, -2.753160810759785e-23, -5.750934180234658e-25,
  1.727223060469295e-05, -3.653955232303626e-07,  5.373514320078199e-09, -6.599541657967054e-11,  7.003606065259505e-13, -6.841069865986018e-15,  8.564702347867118e-17,
 -1.444486416276398e-18,  9.494212634512877e-21,  4.721057572032220e-22, -1.011943609574266e-23, -2.526110429473590e-25,  1.172824995214687e-05, -2.492978123879723e-07,
  3.770064894467945e-09, -5.156756087747984e-11,  7.056250429410586e-13, -8.919044244179180e-15,  6.508736347775364e-17,  4.058159255642741e-19,  2.379963620595530e-21,
 -9.626145772622789e-22,  1.964070539090534e-23,  3.663434825546156e-25,  4.401480650717614e-06, -9.415979197154097e-08,  1.476568113299990e-09, -2.280656283994940e-11,
  3.836723054484662e-13, -5.624594921190958e-15,  3.182043866537604e-17,  7.590197015271480e-19,  3.522301167177951e-22, -1.017519596853634e-21,  2.041534135574776e-23,
  4.164113001367580e-25,  9.536683492076024e-07, -2.057437960007181e-08,  3.377399347511837e-10, -5.945491542208033e-12,  1.181561133935531e-13, -1.916513755903479e-15,
  1.055464181899667e-17,  2.998504887133164e-19,  5.758179290920507e-22, -4.132134134311669e-22,  8.057832212979449e-24,  1.724010696371386e-25,  1.195263476304349e-07,
 -2.607349430489953e-09,  4.530476785738494e-11, -9.143863129987778e-13,  2.081747819059498e-14, -3.658186932681812e-16,  2.281642566098246e-18,  5.087768582985498e-20,
  3.208593340792373e-22, -8.530385272373516e-23,  1.600422257752358e-24,  3.554482831411629e-26,  8.422573409476969e-09, -1.864440934291719e-10,  3.475888119808067e-12,
 -8.075235329270998e-14,  2.059764741027802e-15, -3.892099756448221e-17,  2.979988763048450e-19,  3.577964301374406e-21,  7.086921185868928e-23, -9.479944474641294e-24,
  1.693387637280390e-25,  3.825341373835887e-27,  3.141880439530705e-10, -7.094643256863757e-12,  1.443974375538599e-13, -3.874594166572548e-15,  1.091107106152346e-16,
 -2.220464152771282e-18,  2.166533228144633e-20,  3.390614663612142e-23,  7.253066115009542e-24, -5.647443761032421e-25,  9.545337730104418e-27,  2.063834584994413e-28,
  5.587842142434669e-12, -1.297746808010540e-13,  2.952783743308167e-15, -9.192815520070523e-17,  2.837398139031104e-18, -6.281570384779746e-20,  7.957949405129755e-22,
 -6.148706585570373e-24,  3.470667778024357e-25, -1.734525111457378e-26,  2.813416729618092e-28,  4.825149415612769e-30,  3.947555220187000e-14, -9.566639127577961e-16,
  2.521347798855688e-17, -9.186165901076624e-19,  3.114297648698666e-20, -7.664658042895948e-22,  1.281714944827435e-23, -2.042215846995770e-25,  7.162411325436168e-27,
 -2.553466839492993e-28,  4.261519506960337e-30,  2.616282396363509e-32,  7.775820160734281e-17, -2.027372218105939e-18,  6.582261376199837e-20, -2.863286939858942e-21,
  1.087370632773110e-22, -3.111374527513233e-24,  7.077153110168739e-26, -1.689030235417236e-27,  5.283952354458318e-29, -1.574667583198002e-30,  3.135509236498856e-32,
 -3.265768424996924e-34,  1.751913360791112e-20, -5.398912762424752e-22,  2.494288689758815e-23, -1.381560238197319e-24,  6.354187659981476e-26, -2.376838305689221e-27,
  8.014666013138309e-29, -2.735667151434198e-30,  9.491316181697048e-32, -3.051558497816011e-33,  8.610318005766486e-35, -2.237538557137472e-36,  2.665620625432111e-06,
 -5.442211483127295e-08,  7.617054359763329e-10, -8.286125135962157e-12,  5.504130370153566e-14,  1.593921070721385e-16, -1.524011823396971e-18, -4.016411215402215e-19,
  1.184483631557913e-20,  2.519322199437281e-23, -8.876607109656986e-24,  1.619931498475736e-25,  1.138231518806791e-05, -2.326481694315804e-07,  3.281450659545457e-09,
 -3.716549250422250e-11,  3.055307566742800e-13, -1.033184056171431e-15,  9.891962995856017e-18, -1.299014018131151e-18,  3.556815588858560e-20,  6.928015681128970e-23,
 -2.593531853536765e-23,  4.697348886068209e-25,  1.589186515267774e-05, -3.253944285626464e-07,  4.644614896861659e-09, -5.578549753249746e-11,  5.810510989544704e-13,
 -5.224001257916412e-15,  5.137552104394009e-17, -9.588184025173655e-19,  1.798945839923421e-20,  1.276587730543541e-24, -1.020864592043836e-23,  1.799505794795724e-25,
  1.078771440981623e-05, -2.214335931103895e-07,  3.213392677227864e-09, -4.161606783740141e-11,  5.437154873067744e-13, -7.238108170955934e-15,  7.349063595971143e-17,
  9.462696918545740e-20, -1.664183748562709e-20, -1.090303828985663e-22,  1.792498451119347e-23, -3.236549392568879e-25,  4.046869714237175e-06, -8.334584837138725e-08,
  1.236163051251484e-09, -1.751937180172427e-11,  2.804241470889974e-13, -4.632251236224569e-15,  4.896890783920688e-17,  3.602781038053705e-19, -1.975923368908152e-20,
 -1.108675966978223e-22,  1.929997009624707e-23, -3.406081040131273e-25,  8.763644731295718e-07, -1.812851514991217e-08,  2.765242605869786e-10, -4.345132796611993e-12,
  8.300034709176610e-14, -1.571654985263609e-15,  1.746695438481429e-17,  1.503422342487290e-19, -7.712502696287896e-21, -5.037525268403304e-23,  7.804334213085789e-24,
 -1.345068505298658e-25,  1.097596208971641e-07, -2.283673813237104e-09,  3.610011127580407e-11, -6.363887384796584e-13,  1.415982061782780e-14, -2.951503246047222e-16,
  3.487194734000430e-18,  2.603190174737972e-20, -1.429480050111628e-21, -1.230165364826148e-23,  1.587806149776990e-24, -2.655550974945416e-26,  7.726990412908295e-09,
 -1.620093053498943e-10,  2.680264555199394e-12, -5.359974697910022e-14,  1.361154124429939e-15, -3.057373706529414e-17,  3.891323472123305e-19,  1.876401179729577e-21,
 -1.297459397559135e-22, -1.678092278612200e-24,  1.716712838159614e-25, -2.762377158111971e-27,  2.878630440424690e-10, -6.098954950547592e-12,  1.070044936889934e-13,
 -2.455263012907240e-15,  7.004442739800078e-17, -1.678731451140783e-18,  2.339786590305196e-20,  2.446799428392372e-23, -5.174094809777446e-24, -1.257342531153294e-25,
  9.746044217425339e-27, -1.495844619712880e-28,  5.109973317938525e-12, -1.098821499888742e-13,  2.083819114700159e-15, -5.558510600712596e-17,  1.762473072292700e-18,
 -4.502007809315395e-20,  7.022197743520638e-22, -2.631731529510918e-24, -5.164608971980923e-26, -4.873725645549147e-27,  2.757077191484501e-28, -4.037630861573504e-30,
  3.599304711097501e-14, -7.916433384166260e-16,  1.672367275730402e-17, -5.278251339300395e-19,  1.852879229320877e-20, -5.088629011582533e-22,  9.165976602363527e-24,
 -8.846400852848102e-26,  1.085024708243203e-27, -8.716416106180092e-29,  3.553953628034212e-30, -5.177447759264628e-32,  7.052045669669030e-17, -1.612850266794289e-18,
  4.011039800600747e-20, -1.542260852755947e-21,  6.045862280175298e-23, -1.833681026761848e-24,  4.020283465800404e-26, -6.891466226785102e-28,  1.553970585559231e-29,
 -5.834477080790932e-31,  1.821544997020821e-32, -3.063225886936111e-34,  1.567401596927977e-20, -3.924215871933190e-22,  1.317528630601117e-23, -6.616410884287388e-25,
  3.045230531125210e-26, -1.111025070338683e-27,  3.338185548010830e-29, -9.436014756610570e-31,  2.923171666186657e-32, -9.656163179873768e-34,  2.891887513690856e-35,
 -7.108010646856685e-37,  2.459511127136233e-06, -4.871102063266588e-08,  6.676460488139360e-10, -7.385012272460057e-12,  5.716965233110520e-14,  2.945797764638967e-17,
 -7.727600512434416e-18, -6.132148541557028e-20,  8.255908772158497e-21, -1.725541539894937e-22, -1.202669655704311e-24,  1.418569922593872e-25,  1.050151643856127e-05,
 -2.080989421527548e-07,  2.864127303364963e-09, -3.243949561955498e-11,  2.849468840093553e-13, -1.107395402794188e-15, -1.134211363936435e-17, -2.766118235751559e-19,
  2.490874681769442e-20, -5.095319762213470e-22, -3.529956634714876e-24,  4.158673093741014e-25,  1.466057473228305e-05, -2.907647132370739e-07,  4.027716829485733e-09,
 -4.726550789395636e-11,  4.870540621068708e-13, -4.250453130476103e-15,  3.213278794616675e-17, -4.438391968977298e-19,  1.284729113942813e-20, -2.266373001462293e-22,
 -1.327828884973066e-24,  1.679233236664375e-25,  9.950426565111139e-06, -1.975865116012577e-07,  2.761729663786946e-09, -3.397907110131354e-11,  4.164949232197221e-13,
 -5.502140156053886e-15,  6.890587487602417e-17, -3.927623217559486e-19, -1.142767838460974e-20,  2.956031595156920e-22,  2.709089281930620e-24, -2.805665854962491e-25,
  3.732032394275755e-06, -7.422781281064272e-08,  1.050007134430292e-09, -1.370774694996875e-11,  1.999807231855156e-13, -3.406545872566847e-15,  5.048057652564460e-17,
 -2.192511706883148e-19, -1.386837827254679e-20,  3.273945592415459e-22,  2.970143185839448e-24, -3.046910077026330e-25,  8.079734857699725e-07, -1.610454722913793e-08,
  2.313898825193982e-10, -3.244888400376529e-12,  5.595588736680516e-14, -1.129657696781048e-15,  1.830419011332108e-17, -7.810981557011156e-20, -5.506788328079581e-21,
  1.285081659280308e-22,  1.259859043638953e-24, -1.232687715937923e-25,  1.011590460288798e-07, -2.021986349943170e-09,  2.964316948407969e-11, -4.523549595953003e-13,
  9.125726384749933e-15, -2.079134252459082e-16,  3.581761932887929e-18, -1.710549019956661e-20, -1.048207186239329e-21,  2.456805716472462e-23,  2.746167439185735e-25,
 -2.500111656387805e-26,  7.118229475782142e-09, -1.428128649868914e-10,  2.149231187453633e-12, -3.619652878745358e-14,  8.448168410928733e-16, -2.108824310292135e-17,
  3.823667445546505e-19, -2.186217242817174e-21, -1.001153544099387e-22,  2.379584518448174e-24,  3.260267057913949e-26, -2.680824675189097e-27,  2.650164783852335e-10,
 -5.344073309974437e-12,  8.325622967776378e-14, -1.572772009464336e-15,  4.203499199558932e-17, -1.129520528274057e-18,  2.153664596664699e-20, -1.529947970127690e-22,
 -4.517944625278832e-24,  1.101918451838462e-25,  2.093599900897709e-27, -1.494713878663016e-28,  4.700155245354074e-12, -9.546291395989301e-14,  1.559168472134364e-15,
 -3.370287314915191e-17,  1.023228733839453e-18, -2.933345879549977e-20,  5.919223538927055e-22, -5.359348051302269e-24, -7.800798119965444e-26,  2.006569274616794e-27,
  6.913566688016528e-29, -4.070121645370008e-30,  3.306012604901593e-14, -6.788495453071577e-16,  1.186920820347159e-17, -3.016301188710902e-19,  1.036189459795101e-20,
 -3.167179705074331e-22,  6.870824354000319e-24, -8.140382468696567e-26, -1.010588341417419e-28,  4.391508196654356e-30,  1.058534068904469e-30, -4.843727480466657e-32,
  6.461354495248376e-17, -1.352026647493425e-18,  2.635093788633154e-20, -8.216413970757144e-22,  3.209497528200168e-23, -1.059199615650115e-24,  2.556320141987078e-26,
 -4.131098943892708e-28,  4.507006990650179e-30, -1.100150696364266e-31,  6.163264932463817e-33, -2.121497698317138e-34,  1.427462630622797e-20, -3.119390826311415e-22,
  7.546016063106683e-24, -3.160632986487441e-25,  1.453812042523605e-26, -5.466613207682603e-28,  1.612091752477390e-29, -3.918051349906310e-31,  9.305548589078399e-33,
 -2.711519785674393e-34,  9.000829497991167e-36, -2.629228786361668e-37  };
  int offset = -13;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 13;
    if (std::isnan(t)) {
      fill_n(rr+offset, 13, 0.5);
      fill_n(ww+offset, 13, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 13; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=13; ++j) {
        const int boxof = it*156+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
