//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _r2root_4.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <iostream>
#include <cassert>
#include <src/integral/rys/r2rootlist.h>

using namespace std;
using namespace bagel;

void R2RootList::r2root4(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[4] = {3.225489200896363e-01,1.745767761006858e+00,4.536637603713899e+00,9.395106754304308e+00};
  constexpr double aw[4] = {3.015782026299521e-01,1.787100279351790e-01,1.944402842414519e-02,2.696483811848355e-04};
  constexpr double x[2108] = {  7.601256641479044e-02,  4.546381581422715e-03,  1.951491134091766e-04,  6.990687229315335e-06,  2.132350139706016e-07,
  5.307633605231819e-09,  8.762169228918273e-11, -4.611392846504380e-13, -1.139853179645842e-13, -5.432035368835123e-15, -1.608596597729978e-16, -3.125337895135037e-18,
  6.020979833989247e-01,  2.530448660516902e-02,  4.337475365069487e-04, -6.563242055871253e-06, -5.061905713701103e-07, -3.691607958055575e-09,  5.152169499142259e-10,
  1.637557356023271e-11, -2.971253104424491e-13, -2.768251601871755e-14, -2.025094456026240e-16,  3.059940703840931e-17,  1.321766986273446e+00,  2.583442797220917e-02,
 -3.795438509359732e-04, -7.508472665981883e-06,  4.453890645720052e-07, -1.526294018554294e-09, -4.555169538273696e-10,  1.180085495563875e-11,  3.306215541298644e-13,
 -2.141076182024538e-14, -5.861147099905029e-18,  2.545832460146663e-17,  1.859482243449653e+00,  7.311081058860625e-03, -2.656061407268691e-04,  7.655282351085640e-06,
 -1.687426430124889e-07,  2.053775373574949e-09,  4.165751970903076e-11, -3.776713578366380e-12,  1.515356968567172e-13, -3.595752885608067e-15,  1.202416442489887e-17,
  2.492819186217060e-18,  9.794515112615550e-02,  6.509875893743286e-03,  3.033451977810077e-04,  1.135131944762813e-05,  3.362910848392417e-07,  6.611773962667753e-09,
 -1.612818809754576e-11, -8.736110109732318e-12, -4.555065900159342e-13, -1.407130403446906e-14, -2.251300252169418e-16,  3.944444833379638e-18,  7.095616095906420e-01,
  2.832115553953892e-02,  3.064878512388032e-04, -1.445629016436058e-05, -4.286525576662846e-07,  1.220052972692885e-08,  6.976201626279337e-10, -7.494387713428432e-12,
 -1.045937804176556e-12, -2.878850088061129e-15,  1.371677075233381e-15,  1.940761327348700e-17,  1.418625210176121e+00,  2.255325160141895e-02, -4.294801184123429e-04,
 -1.095362051145502e-06,  3.356025420112730e-07, -7.966727117329608e-09, -8.292003855554046e-11,  1.169181701935442e-11, -2.518542058675718e-13, -7.856116082594997e-15,
  4.675976874408270e-16, -2.813788547891217e-18,  1.884998258050703e+00,  5.511118552865393e-03, -1.884883162158306e-04,  5.310762784351712e-06, -1.238855590152048e-07,
  2.220140532243092e-09, -1.412729317071940e-11, -7.643374855081626e-13,  4.652792436284377e-14, -2.018612666350471e-15,  4.815286087717583e-17, -1.659009795949188e-19,
  1.298424190764277e-01,  9.582329626521745e-03,  4.758279705172877e-04,  1.764955622662661e-05,  4.341736790875917e-07,  1.130781289445894e-09, -5.485400202328445e-10,
 -3.220883760206470e-11, -9.835385733056131e-13, -7.621266459236161e-15,  9.941403346558387e-16,  6.580180629723170e-17,  8.265178995226644e-01,  2.998639495719843e-02,
  1.025071752421012e-04, -1.858971507166015e-05, -5.273602980901477e-08,  2.293810771654496e-08,  8.095037857471316e-11, -3.196764096261642e-11, -2.014525066675872e-13,
  4.217395227947947e-14,  2.657245761397029e-16, -5.902983128096415e-17,  1.501995893552212e+00,  1.914378333956020e-02, -4.157551241001347e-04,  2.984236064775691e-06,
  1.775051705348538e-07, -7.082086839030245e-09,  1.122080072227504e-10,  2.236111392473839e-12, -2.617865919136024e-13,  5.036102597244780e-15,  1.414465110616814e-16,
 -8.113317157076109e-18,  1.904387231051912e+00,  4.227660259238470e-03, -1.352607746981992e-04,  3.660410679673729e-06, -8.397577412016787e-08,  1.738033771752559e-09,
 -2.311140421851667e-11, -9.451572853486955e-14,  4.762891347683701e-15, -4.433184695568513e-16,  2.739649657864177e-17, -6.190135422477605e-19,  1.772873213148867e-01,
  1.434951735041576e-02,  7.267416274088906e-04,  2.369214147052774e-05,  2.341866065189301e-07, -2.621698722245527e-08, -1.835569526445776e-09, -5.289642156745218e-11,
  4.266143297697567e-13,  1.177840120358491e-13,  5.587804768959272e-15,  9.003941021947603e-17,  9.467155238180829e-01,  2.993385135230464e-02, -1.109752655155314e-04,
 -1.595756453711753e-05,  3.550115119842412e-07,  1.476579836853384e-08, -6.896136611170744e-10, -1.680621947487902e-11,  9.502380545443294e-13,  1.082174156940051e-14,
 -1.303397990374318e-15,  8.546797719909784e-18,  1.572200970056389e+00,  1.599949773824240e-02, -3.670816207002446e-04,  4.844164503113082e-06,  6.377513471485037e-08,
 -4.393302504681090e-09,  8.902541049118187e-11, -2.744234242323562e-12, -4.858083834958016e-14,  5.404117072286816e-15, -6.838504167185899e-17, -8.229121529436073e-19,
  1.919382876096841e+00,  3.300874709528122e-03, -9.835003550268414e-05,  2.564031651177130e-06, -5.492636952932492e-08,  1.160361375000657e-09, -2.481208617133969e-11,
 -3.645490469220984e-14,  2.465278200455687e-15,  1.758558570289561e-16,  6.846995097425927e-18, -1.810785912343594e-19,  2.481290042539336e-01,  2.130680667564352e-02,
  1.007304841899012e-03,  2.044096543768908e-05, -8.202214369090486e-07, -8.099016586113578e-08, -2.175144154630988e-09,  7.089202187638718e-11,  8.212164425117938e-12,
  2.420074359053310e-13, -6.398743602429745e-15, -8.470785524611360e-16,  1.063620443058012e+00,  2.839271368524918e-02, -2.618372365438921e-04, -8.910873974928394e-06,
  4.648196944059242e-07, -3.949689924656541e-09, -7.362245988765531e-10,  1.191073980034027e-11,  6.924666679871521e-13, -1.407858217811904e-14,  2.370687093345760e-16,
  3.136717680417778e-17,  1.630710282402905e+00,  1.330665280283482e-02, -3.054271095708919e-04,  5.250560104343843e-06, -9.161521217422726e-09, -3.193036191058731e-09,
  1.608189398878375e-11, -1.669673477531911e-12,  1.045172082851686e-13,  3.570113111845293e-15, -1.030939458655316e-17,  5.073054187132979e-19,  1.931188608654293e+00,
  2.623760754530996e-03, -7.219391929777480e-05,  1.838417802591065e-06, -3.767955376484142e-08,  5.691050279354532e-10, -2.343436325393294e-11,  1.918836753432723e-13,
  1.334900816934067e-14,  4.378680661695699e-16,  6.563987560318875e-18, -2.124830442016631e-19,  3.505331122918765e-01,  2.998755916080111e-02,  1.114503123423918e-03,
 -7.198857438029882e-06, -2.626765539126117e-06, -7.548277343815531e-08,  3.955274275792541e-09,  3.387315599724935e-10,  1.980337614942442e-12, -8.186250342104633e-13,
 -3.535186537823683e-14,  8.491301345874122e-16,  1.172488277308854e+00,  2.598521198560907e-02, -3.294545174326389e-04, -2.912330939948937e-06,  2.474645944764802e-07,
 -1.547985801614859e-08, -1.483445031669643e-10,  2.875077673113848e-11,  4.157908059355195e-13, -8.172685996348662e-15, -8.077164987760031e-16, -7.857336388365563e-17,
  1.679439299841557e+00,  1.110800756114719e-02, -2.453632034208703e-04,  4.606437897687748e-06, -7.051182644452007e-08, -2.877598018855727e-09,  3.394871879931423e-11,
  3.440386152303798e-12,  1.905902121695244e-13, -1.058120243128224e-15, -3.539674245323560e-16, -1.588397921531452e-17,  1.940654706213321e+00,  2.124884398131781e-03,
 -5.346600995449330e-05,  1.298934894455801e-06, -3.117202175912073e-08,  1.346746714855473e-10, -9.639223305623524e-12,  8.653428850074500e-13,  2.555252342229267e-14,
 -1.757022548304272e-16, -5.592621320560367e-17, -2.487733343824745e-18,  4.866690244135678e-01,  3.777743469570216e-02,  7.510536155012048e-04, -5.321005265272584e-05,
 -2.521379441016051e-06,  1.072086728253770e-07,  8.890590403767242e-09, -1.668313746538422e-10, -2.909610776720111e-11, -1.409019064688029e-14,  8.609801843380843e-14,
  1.608570220267011e-15,  1.271000699033417e+00,  2.325375445105123e-02, -3.506907147014011e-04, -1.329331217027955e-06, -2.724777533600348e-08, -8.531077847292813e-09,
  7.179508411699616e-10,  2.518200173595782e-11, -1.109816089383141e-12, -7.967810608535131e-14, -7.847998540610551e-16,  1.859383136507028e-16,  1.720263379341288e+00,
  9.343153161704866e-03, -1.984949506414987e-04,  3.105597322622099e-06, -1.091552351507438e-07, -3.803460166811146e-10,  1.838012309873979e-10,  5.139161820861509e-12,
 -2.121041844305923e-13, -2.075844357307060e-14, -1.746397633856824e-16,  4.459635473960317e-17,  1.948385760602792e+00,  1.751196265746820e-03, -4.079716600051087e-05,
  8.187975115246925e-07, -2.844777284590309e-08,  2.607103995146332e-10,  2.100975944489091e-11,  9.927071030667827e-13, -3.706449067362113e-14, -3.173802957498236e-15,
 -2.299497986456362e-17,  6.863117365507194e-18,  6.450752210462712e-01,  4.076937388562617e-02, -2.964273829804766e-05, -6.805867401127184e-05,  9.183249958875274e-07,
  1.820255394139010e-07, -4.417360545548570e-09, -5.182037125501314e-10,  1.732521559489221e-11,  1.486928220975249e-12, -6.240944347981822e-14, -4.261840351399512e-15,
  1.358284708104128e+00,  2.037090794206044e-02, -3.714460985299597e-04, -2.058659032022599e-06,  3.919322028511916e-10,  1.078851319785360e-08,  5.717756464186380e-10,
 -4.127211375332943e-11, -1.954620266241253e-12,  9.408706614026424e-14,  6.984466657113113e-15, -1.594609406684474e-16,  1.754655576656030e+00,  7.875708217185036e-03,
 -1.710994098572673e-04,  1.564658115972299e-06, -6.768947094898685e-08,  4.369308491152982e-09,  1.384682538684338e-10, -1.011889695388482e-11, -4.904969491778152e-13,
  1.951225450302058e-14,  1.668993261626441e-15, -2.775420762183950e-17,  1.954789882637681e+00,  1.456990314451556e-03, -3.342456616874530e-05,  4.385068175982395e-07,
 -1.704690197632379e-08,  8.702815064624682e-10,  1.794429068444789e-11, -1.471495637224070e-12, -7.867295245680826e-14,  2.966451745332082e-15,  2.511724613860743e-16,
 -4.028628815359908e-18,  8.031536540992238e-01,  3.773609147148373e-02, -6.665230288166485e-04, -3.338861592193079e-05,  2.776871725791766e-06, -8.233650478835494e-09,
 -7.590517146282130e-09,  2.651996348133542e-10,  1.408523666368680e-11, -1.201338467028909e-12, -6.465191232860703e-15,  3.740766818579265e-15,  1.433693838564207e+00,
  1.731958991274986e-02, -3.878398271032365e-04, -4.655498553536738e-08,  2.415272043182715e-07,  7.980752035614694e-09, -7.253739440236137e-10, -2.472012814105771e-11,
  2.676407524431450e-12,  4.477734590699465e-14, -8.611219665077499e-15, -5.154384592742724e-17,  1.783523283538723e+00,  6.570851817366193e-03, -1.556675832934897e-04,
  1.244924064435714e-06,  2.484713724209803e-08,  3.499813211986540e-09, -1.989612678075344e-10, -7.562123124933492e-12,  6.320182663355289e-13,  1.613857374160569e-14,
 -1.900558150355508e-15, -3.246304829398220e-17,  1.960111664470502e+00,  1.207395983626809e-03, -2.919552513388323e-05,  3.110806671099457e-07,  4.711675292914088e-10,
  6.713073916704307e-10, -3.325430238222240e-11, -1.196837750093930e-12,  9.477582345129537e-14,  2.713980713412941e-15, -2.803593000528539e-16, -5.610111799528173e-18,
  9.418826653135719e-01,  3.149430781926874e-02, -8.300540923764197e-04,  2.788268781890242e-06,  1.499222542142325e-06, -8.607034746171443e-08,  6.320340736754079e-10,
  1.886283841585256e-10, -1.067061257695395e-11,  1.584637095463366e-14,  2.691205650623475e-14, -1.286837445593952e-15,  1.496863637816000e+00,  1.428585490072726e-02,
 -3.632350553723106e-04,  4.085041746708592e-06,  2.193867582145952e-07, -8.692838566291115e-09, -3.827252394803672e-10,  3.388109887672450e-11,  9.257975175854371e-14,
 -9.980385939181241e-14,  2.965926899259736e-15,  1.848431714076737e-16,  1.807424827834907e+00,  5.395477636713761e-03, -1.369668438788954e-04,  1.913867514591814e-06,
  4.214249634078683e-08, -1.504693754249630e-09, -1.393443041241337e-10,  8.764870509034560e-12,  1.177472239558377e-13, -2.671600765650764e-14,  4.467989603840975e-16,
  5.820949366773813e-17,  1.964498896244078e+00,  9.896005784513448e-04, -2.513005912483590e-05,  3.778206145980714e-07,  5.071576629737451e-09, -1.731253684173154e-10,
 -2.466231160325727e-11,  1.382818161097000e-12,  2.288172359902750e-14, -4.162256083940018e-15,  5.225224247671436e-17,  9.373274111620821e-18,  1.055208634971025e+00,
  2.527631276031225e-02, -7.034487275000926e-04,  1.498898930046437e-05,  1.787178012352496e-07, -4.075226881692156e-08,  2.102772546142789e-09, -3.611114221898390e-11,
 -2.444017198872532e-12,  2.148754569366138e-13, -6.766810824269582e-15, -8.338723144676993e-17,  1.548570342583207e+00,  1.162078187304482e-02, -2.996846971785410e-04,
  6.001117385313650e-06,  2.180299837535869e-08, -8.472829853349332e-09,  2.688473197128436e-10,  7.523747999780462e-12, -9.498721253328662e-13,  2.488696799635685e-14,
  1.117385394358218e-15, -1.110763339990680e-16,  1.826972905465130e+00,  4.400015097220991e-03, -1.113110986373234e-04,  2.247297217166304e-06, -2.372265233895723e-09,
 -2.165675978451765e-09,  5.564320452490697e-11,  3.153240158309633e-12, -2.689815073374247e-13,  4.246030038217958e-15,  4.381250821313326e-16, -2.854476726321610e-17,
  1.968085349884854e+00,  8.076688759225047e-04, -2.029158679284905e-05,  4.122418035727496e-07, -1.236035578411432e-09, -3.283444253982080e-10,  7.569037023732377e-12,
  5.719073631136366e-13, -4.322904437377461e-14,  5.230750018612924e-16,  7.600325922892233e-17, -4.325286467853906e-18,  1.146204727660905e+00,  2.037058618233853e-02,
 -5.255976319297691e-04,  1.364061596037297e-05, -2.356458068552179e-07, -5.942872548838052e-09,  7.997499785107887e-10, -3.956775468626853e-11,  9.885099620501969e-13,
  1.021755730015160e-14, -2.295054874342986e-15,  1.160120269281364e-16,  1.590709045436230e+00,  9.506833679910124e-03, -2.299614474170355e-04,  5.366789012430524e-06,
 -7.980568231621622e-08, -1.980019786529915e-09,  2.075351947034657e-10, -6.870570272665633e-12, -3.232619397405798e-14,  1.467010100235540e-14, -7.035909932981345e-16,
  8.991981269030275e-18,  1.842958233023868e+00,  3.614017577256734e-03, -8.572016522953127e-05,  1.950473674429265e-06, -2.934125286192665e-08, -5.344450850858309e-10,
  5.838991847246355e-11, -1.638850374612617e-12, -3.258145838186829e-14,  4.823887708999376e-15, -1.809750108664902e-16, -4.743996314267606e-20,  1.971021659297004e+00,
  6.643694532364148e-04, -1.563920095030228e-05,  3.527934114385943e-07, -5.374197843366620e-09, -8.082008425777261e-11,  9.317510166422515e-12, -2.424451606321487e-13,
 -6.757823109613099e-15,  8.141210536767385e-16, -2.763875254298583e-17, -1.703249021362936e-19,  1.220218366098317e+00,  1.675259312484931e-02, -3.859506921662354e-04,
  9.649717890117048e-06, -2.340272527385007e-07,  3.440230333730878e-09,  1.098126233207236e-10, -1.213989861316071e-11,  5.816926718724645e-13, -1.702666267718946e-14,
  1.724559926357140e-16,  1.336548265973880e-17,  1.625432087608728e+00,  7.901472601687668e-03, -1.738251076792646e-04,  3.980760810845075e-06, -8.433508822780505e-08,
  8.961993958684337e-10,  4.778113254408807e-11, -3.751268680990974e-12,  1.321843768521256e-13, -1.458525816308707e-15, -1.232402198808249e-16,  8.883372767949964e-18,
  1.856179203750596e+00,  3.013500128743620e-03, -6.528152788209650e-05,  1.455510993900041e-06, -2.983259840315856e-08,  3.125481230509360e-10,  1.496942457722812e-11,
 -1.124132012820159e-12,  3.521413785143834e-14, -9.995116686043722e-17, -4.987173631015459e-17,  2.797484246807513e-18,  1.973453581026458e+00,  5.546719742261226e-04,
 -1.194234309940700e-05,  2.635510815320837e-07, -5.342569545274978e-09,  5.666559726411586e-11,  2.473995865388567e-12, -1.845784951931245e-13,  5.494343453402386e-15,
  5.628923114403147e-18, -8.989163310402141e-18,  4.637567553649483e-19,  1.281704561722873e+00,  1.407023467340086e-02, -2.901255848415159e-04,  6.514543640823799e-06,
 -1.577036261244168e-07,  3.598031111220176e-09, -4.855348589437255e-11, -1.448000464235010e-12,  1.491077781762553e-13, -6.930760834986192e-15,  2.154577214277595e-16,
 -3.999628044587399e-18,  1.654529057412927e+00,  6.680630925882946e-03, -1.334375007034408e-04,  2.809151886733571e-06, -6.126223970307316e-08,  1.192741016931886e-09,
 -9.375935235890181e-12, -7.660967222131787e-13,  5.300409965064130e-14, -1.931790910585466e-15,  3.787420566521170e-17,  3.688008021304816e-19,  1.867288594804208e+00,
  2.553555583720242e-03, -5.043382828237838e-05,  1.039168605293852e-06, -2.192865755848644e-08,  4.092183567874445e-10, -2.910820194249029e-12, -2.572761403936634e-13,
  1.668032839995451e-14, -5.579396483774383e-16,  8.284644613002581e-18,  2.695109207593575e-19,  1.975499300765211e+00,  4.704302740997478e-04, -9.248739241016012e-06,
  1.889475655777151e-07, -3.936989279548644e-09,  7.241808944487263e-11, -5.101582035825824e-13, -4.395448499811916e-14,  2.796614028395145e-15, -9.024460656359609e-17,
  1.148805272802495e-18,  5.498921991067083e-20,  1.333784683774133e+00,  1.202405266868760e-02, -2.249407048618485e-04,  4.497136580763049e-06, -9.868229267367311e-08,
  2.305915999171981e-09, -4.989989724710942e-11,  6.612503858407374e-13,  1.443898696924510e-14, -1.528890674598390e-15,  6.933228374481077e-17, -2.189881878354140e-18,
  1.679308811683618e+00,  5.733015669798970e-03, -1.048744612557626e-04,  2.003004132482822e-06, -4.063892161419071e-08,  8.482061372153891e-10, -1.545939233923856e-11,
  1.042176228918855e-13,  9.368255921863203e-15, -6.095303663251788e-16,  2.243125790195689e-17, -5.364486038861253e-19,  1.876767210646235e+00,  2.194589304768823e-03,
 -3.981571575918465e-05,  7.484125097953037e-07, -1.478411377589031e-08,  2.972398817959663e-10, -5.146411596318752e-12,  2.755758814828992e-14,  3.311684437514445e-15,
 -1.995178790559090e-16,  6.866749242126963e-18, -1.437431223524150e-19,  1.977246028129346e+00,  4.045432747223875e-04, -7.314460276045753e-06,  1.366061134843186e-07,
 -2.669852630139030e-09,  5.289824928783626e-11, -8.992929653598916e-13,  4.511433921922638e-15,  5.781882752613384e-16, -3.400414655136851e-17,  1.138932576065559e-18,
 -2.237765671698141e-20,  1.378589860637992e+00,  1.041666353323895e-02, -1.791190807467045e-04,  3.228835690984694e-06, -6.292951481104500e-08,  1.347016107346101e-09,
 -3.028346548190791e-11,  6.260329925454779e-13, -8.461616431518345e-15, -1.064553625835240e-16,  1.334849932963721e-17, -5.972782392467223e-19,  1.700701048858529e+00,
  4.980275354367260e-03, -8.424151456485016e-05,  1.469729618452420e-06, -2.704051362715632e-08,  5.309410709642849e-10, -1.065025417035883e-11,  1.852164715300827e-13,
 -1.289774217282074e-15, -9.191879106029212e-17,  5.881657192122512e-18, -2.158340850564204e-19,  1.884960261753032e+00,  1.908376237128341e-03, -3.207851760369900e-05,
  5.531232146984301e-07, -9.972273980794603e-09,  1.899266340826362e-10, -3.660713828201348e-12,  6.010937428914361e-14, -3.090500263477919e-16, -3.410961551993939e-17,
  1.989455814541392e-18, -6.895424579672283e-20,  1.978756623508568e+00,  3.519315966679236e-04, -5.900196723969284e-06,  1.012483063636269e-07, -1.810486176671713e-09,
  3.405860600948445e-11, -6.460637804993921e-13,  1.038229066970512e-14, -4.744150889029272e-17, -6.066960786907348e-18,  3.436570577748588e-19, -1.164655833669699e-20,
  1.417614245626707e+00,  9.123396358208233e-03, -1.456382554021669e-04,  2.403388175086561e-06, -4.200048592267536e-08,  7.990826446142185e-10, -1.661925371502425e-11,
  3.585418299194533e-13, -7.116205599542401e-15,  9.923939759543652e-17,  4.689104867990635e-19, -1.000654717953568e-19,  1.719376562438718e+00,  4.370260358637570e-03,
 -6.889065740628349e-05,  1.109797051901865e-06, -1.859010238643080e-08,  3.310871248090454e-10, -6.303015890072671e-12,  1.218846469358130e-13, -2.053274250702098e-15,
  1.636293569639750e-17,  7.360847947312236e-19, -4.862239997233441e-20,  1.892119063300513e+00,  1.675845949563717e-03, -2.628699619506529e-05,  4.197235097564164e-07,
 -6.924980190590477e-09,  1.204395113013379e-10, -2.219465116664530e-12,  4.121983057210370e-14, -6.543627657358996e-16,  3.932624797681174e-18,  2.890784372799876e-19,
 -1.693531750646991e-20,  1.980077008326553e+00,  3.091442565395127e-04, -4.839015466691634e-06,  7.698136612608454e-08, -1.262288603530283e-09,  2.174201853306098e-11,
 -3.953326928379785e-13,  7.221691753419903e-15, -1.119974923075020e-16,  5.948687509049705e-19,  5.243555968219037e-20, -2.959984202553248e-21,  1.451945590885509e+00,
  8.063317835526346e-03, -1.203641448657831e-04,  1.840554728385894e-06, -2.931330755071250e-08,  4.982326492782730e-10, -9.240301980158382e-12,  1.859170069532897e-13,
 -3.842126370543579e-15,  7.343189314144733e-17, -1.053076622649929e-18,  1.188256920057440e-21,  1.735833161975880e+00,  3.867803950016264e-03, -5.716298217794438e-05,
  8.581452860610231e-07, -1.324023693431771e-08,  2.140102678932991e-10, -3.699255123426353e-12,  6.829536648425967e-14, -1.275537316504787e-15,  2.100993144260460e-17,
 -1.940719008906976e-19, -4.733670720609860e-21,  1.898431314807161e+00,  1.483979161492281e-03, -2.184402259775865e-05,  3.256520334279642e-07, -4.966851633457000e-09,
  7.883823575082818e-11, -1.327703533860431e-12,  2.371763551431967e-14, -4.259575825074230e-16,  6.624383646655007e-18, -4.889663397301993e-20, -2.020156190586312e-21,
  1.981241566704621e+00,  2.738139074244110e-04, -4.023567859863747e-06,  5.980977648785380e-08, -9.079220369121132e-10,  1.430481313131385e-11, -2.383248669418624e-13,
  4.198946137402580e-15, -7.418434880662234e-17,  1.126919995563924e-18, -7.514017339707655e-21, -3.758884101691253e-22,  1.482402571227985e+00,  7.181464985849714e-03,
 -1.007974661312500e-04,  1.440758153197612e-06, -2.120713216485961e-08,  3.272022062164518e-10, -5.413974360586946e-12,  9.760262513011870e-14, -1.892568171705698e-15,
  3.742570385922550e-17, -6.897786810505512e-19,  1.008426406929155e-20,  1.750450297819008e+00,  3.448386597627217e-03, -4.800908525491039e-05,  6.762948734110156e-07,
 -9.714045421801470e-09,  1.442025249700634e-10, -2.256656706100052e-12,  3.789087131715391e-14, -6.778755829321501e-16,  1.223820620201030e-17, -1.979349450272997e-19,
  2.066962733559765e-21,  1.904040714441449e+00,  1.323616898260777e-03, -1.836603485694745e-05,  2.572659463526910e-07, -3.662027828713313e-09,  5.360631297528326e-11,
 -8.218841924128319e-13,  1.343022155182220e-14, -2.326939448276239e-16,  4.049651043903583e-18, -6.212153372060332e-20,  5.479643750750251e-22,  1.982276668493472e+00,
  2.442691837015552e-04, -3.384477962014660e-06,  4.729662143848644e-08, -6.707371381314036e-10,  9.762497113466411e-12, -1.484196678791120e-13,  2.397824154320856e-15,
 -4.098049979394091e-17,  7.020933934063534e-19, -1.053284715928723e-20,  8.601665040082893e-23,  1.509617628817748e+00,  6.438928951526251e-03, -8.534889437194260e-05,
  1.147556860457908e-06, -1.577179185969881e-08,  2.242927164695244e-10, -3.359658993368563e-12,  5.407858283384053e-14, -9.446526691880316e-16,  1.760130561140017e-17,
 -3.328934667721410e-19,  5.918669076838385e-21,  1.763523633951041e+00,  3.094335546936310e-03, -4.073956376561004e-05,  5.413212047507969e-07, -7.296780950822397e-09,
  1.006799234084536e-10, -1.442993190228064e-12,  2.190447001765008e-14, -3.571437478141898e-16,  6.183847620709601e-18, -1.079276400190917e-19,  1.715303135622172e-21,
  1.909059570833162e+00,  1.188116410643174e-03, -1.559817329522831e-05,  2.062930585701893e-07, -2.760529348936175e-09,  3.767105947030570e-11, -5.312879806241374e-13,
  7.889068749436937e-15, -1.251781270542233e-16,  2.102946056839538e-18, -3.549429612180593e-20,  5.382034826246974e-22,  1.983202948667580e+00,  2.192948423761834e-04,
 -2.875436394107329e-06,  3.795372093186660e-08, -5.063463223345755e-10,  6.878560444368013e-12, -9.637159601003916e-14,  1.417954967030413e-15, -2.224016596378691e-17,
  3.687548792485000e-19, -6.133831339165775e-21,  9.114381593673998e-23,  1.534089336742545e+00,  5.807245390282525e-03, -7.295718860254259e-05,  9.271740902622477e-07,
 -1.198507233456853e-08,  1.589203838182184e-10, -2.189114533850446e-12,  3.185955655027889e-14, -4.980954004978821e-16,  8.405772807054380e-18, -1.501915092661612e-19,
  2.715673901987560e-21,  1.775287669088932e+00,  2.792559487926487e-03, -3.488332767606385e-05,  4.389874991744397e-07, -5.585720524326232e-09,  7.229581913447639e-11,
 -9.613674071289986e-13,  1.333584449535512e-14, -1.965141424566692e-16,  3.108156021504674e-18, -5.201506076064402e-20,  8.771470335457168e-22,  1.913577154173692e+00,
  1.072535328684500e-03, -1.336486128733150e-05,  1.675269275077603e-07, -2.118799588732972e-09,  2.717944680750668e-11, -3.568011253712132e-13,  4.862273950642740e-15,
 -7.003389578328892e-17,  1.078873114044569e-18, -1.755992832277119e-20,  2.873860081080639e-22,  1.984036823932045e+00,  1.979851042209321e-04, -2.464434500707207e-06,
  3.083927487348726e-08, -3.890575278140405e-10,  4.972407998005318e-12, -6.493267469031961e-14,  8.783992056183627e-16, -1.253118117624936e-17,  1.908561097672904e-19,
 -3.068492683023299e-21,  4.955747572282814e-23,  1.556217163055978e+00,  5.265056696438621e-03, -6.288526803257181e-05,  7.582597031695589e-07, -9.268050806620330e-09,
  1.155286201539705e-10, -1.481787072417463e-12,  1.980190575047970e-14, -2.799673234044340e-16,  4.243235181745984e-18, -6.901283680029823e-20,  1.180622515924469e-21,
  1.785931127263843e+00,  2.533147278024836e-03, -3.010773368443532e-05,  3.600450481856224e-07, -4.343567182736343e-09,  5.308395668377631e-11, -6.616580045597043e-13,
  8.501273167836583e-15, -1.143134142246206e-16,  1.635166193716092e-18, -2.505562880128450e-20,  4.046552023130687e-22,  1.917665427055009e+00,  9.731199201277241e-04,
 -1.154139518577962e-05,  1.375517260860206e-07, -1.650987649157504e-09,  2.002829271957487e-11, -2.470333611579191e-13,  3.128509147398786e-15, -4.128009111707474e-17,
  5.771334313915897e-19, -8.625713565541435e-21,  1.358519265954061e-22,  1.984791537102445e+00,  1.796511361769988e-04, -2.128684162682539e-06,  2.533288838824377e-08,
 -3.034110176598257e-10,  3.669449983503007e-12, -4.506551551796717e-14,  5.673530502435122e-16, -7.427481246238403e-18,  1.028362116587133e-19, -1.520255669771861e-21,
  2.367525025833675e-23,  1.576325511124728e+00,  4.796014025615527e-03, -5.460541980740555e-05,  6.266951583620573e-07, -7.272891751884947e-09,  8.573113922002406e-11,
 -1.033079465236391e-12,  1.284091510102598e-14, -1.666027383058421e-16,  2.286696272040050e-18, -3.353620636963863e-20,  5.245804872245601e-22,  1.795607787906472e+00,
  2.308461576465950e-03, -2.617173036002360e-05,  2.982527345358247e-07, -3.423333237728375e-09,  3.969548143300714e-11, -4.671869605948635e-13,  5.621617175246796e-15,
 -6.992183007598017e-17,  9.121637811638696e-19, -1.265929764046560e-20,  1.876337364821627e-22,  1.921383102033065e+00,  8.869706607386202e-04, -1.003701867543778e-05,
  1.140456414958668e-07, -1.303312146212944e-09,  1.501847845385135e-11, -1.752201752523664e-13,  2.083474657011577e-15, -2.551150048461417e-17,  3.263766382926835e-19,
 -4.429461654993214e-21,  6.415282073909376e-23,  1.985477898393400e+00,  1.637603344837894e-04, -1.851571796696527e-06,  2.101161672284199e-08, -2.396766548083883e-10,
  2.754696820237705e-12, -3.202384453085208e-14,  3.789321625865829e-16, -4.610027875794089e-18,  5.849619580158070e-20, -7.862709263547730e-22,  1.127125620375826e-23,
  1.594680878023332e+00,  4.387395933305400e-03, -4.773074680659981e-05,  5.228110352963968e-07, -5.779905995730521e-09,  6.471715053825083e-11, -7.374121209889439e-13,
  8.606707104532740e-15, -1.038013751479785e-16,  1.307797676894493e-18, -1.740937246875365e-20,  2.466124942597173e-22,  1.804444314041808e+00,  2.112529345805112e-03,
 -2.289697585289394e-05,  2.492707940961818e-07, -2.729988150850265e-09,  3.014622744626110e-11, -3.367840479002649e-13,  3.825784584171158e-15, -4.452989536113713e-17,
  5.368937289903630e-19, -6.797315801695482e-21,  9.143996434601210e-23,  1.924778587713754e+00,  8.118156370268364e-04, -8.784366396633730e-06,  9.538541962756666e-08,
 -1.040704839932670e-09,  1.143074915594755e-11, -1.267611194257022e-13,  1.425701489824011e-15, -1.637852925760427e-17,  1.942347611957789e-19, -2.411216189492623e-21,
  3.174985935856792e-23,  1.986104824628760e+00,  1.498950582682889e-04, -1.620749338470466e-06,  1.757911313109142e-08, -1.914876380510682e-10,  2.098526327161390e-12,
 -2.320074215056490e-14,  2.598790614632583e-16, -2.969509239454254e-18,  3.497478433096395e-20, -4.305693731561656e-22,  5.616814870984341e-24,  1.611504406251397e+00,
  4.029165257992112e-03, -4.197207811863269e-05,  4.398013947548157e-07, -4.644793078399706e-09,  4.957493842978058e-11, -5.366985096028678e-13,  5.922436394686047e-15,
 -6.704808777462421e-17,  7.851985165995806e-19, -9.605053067028730e-21,  1.238657557347867e-22,  1.812546033102505e+00,  1.940619119151190e-03, -2.014923824467775e-05,
  2.100089499252301e-07, -2.199977541959572e-09,  2.320401333671799e-11, -2.470392083916062e-13,  2.664498906659703e-15, -2.927114807860522e-17,  3.300714625878542e-19,
 -3.861163669369337e-21,  4.743247635167899e-23,  1.927892171692501e+00,  7.458524984236074e-04, -7.732605481591046e-06,  8.041034941442058e-08, -8.395599232779869e-10,
  8.814150111036458e-12, -9.324640311292593e-14,  9.972537187326779e-16, -1.083490543512207e-17,  1.204740198082458e-19, -1.385448978054828e-21,  1.669242492350962e-23,
  1.986679739325711e+00,  1.377237811033530e-04, -1.426889441456367e-06,  1.482311605106545e-08, -1.545468386827261e-10,  1.619345562292666e-12, -1.708637419322780e-14,
  1.821014138048346e-16, -1.969538408500025e-18,  2.177308603755424e-20, -2.486094932030671e-22,  2.970546845531724e-24,  1.626981249280948e+00,  3.713306786560996e-03,
 -3.710976483695266e-05,  3.727691709042029e-07, -3.769820900441841e-09,  3.846537471982481e-11, -3.971315686117175e-13,  4.164415695801250e-15, -4.457162329058670e-17,
  4.899525327836897e-19, -5.573661373048662e-21,  6.616437207900297e-23,  1.820001281665337e+00,  1.788940544742266e-03, -1.782599252240582e-05,  1.782234049152398e-07,
 -1.789647610719985e-09,  1.807450558038187e-11, -1.839515553503106e-13,  1.891753016356057e-15, -1.973486387947711e-17,  2.099953197250101e-19, -2.296852829205720e-21,
  2.607911786887478e-23,  1.930757665516726e+00,  6.876356430072213e-04, -6.842831226330368e-06,  6.827489815902052e-08, -6.835810504020341e-10,  6.875792258840410e-12,
 -6.959406524787384e-14,  7.105102347131695e-16, -7.342292063166899e-18,  7.719575965905565e-20, -8.319764218242174e-22,  9.284781553305694e-24,  1.987208874502628e+00,
  1.269804631682657e-04, -1.262847502782762e-06,  1.258879541354849e-08, -1.258816156473418e-10,  1.263998242351183e-12, -1.276439575877279e-14,  1.299255388583959e-16,
 -1.337432737242136e-18,  1.399247352259128e-20, -1.498855227297631e-22,  1.660579929694656e-24,  1.641267676108759e+00,  3.433351485386803e-03, -3.297462615746663e-05,
  3.181255771271793e-07, -3.087149065422384e-09,  3.018717837650388e-11, -2.981212934105732e-13,  2.982378273872784e-15, -3.033784248092769e-17,  3.153073061420025e-19,
 -3.367817332859647e-21,  3.721610850394513e-23,  1.826884720079373e+00,  1.654426543150095e-03, -1.584791937064531e-05,  1.522579004703273e-07, -1.468356682392679e-09,
  1.423033845620885e-11, -1.388017883087911e-13,  1.365471590537233e-15, -1.358744190602756e-17,  1.373117282951127e-19, -1.417115509331503e-21,  1.504587287227018e-23,
  1.933403662261413e+00,  6.359941476151463e-04, -6.084894772273931e-06,  5.835329462744351e-08, -5.612834369058401e-10,  5.420072839772582e-12, -5.261291671476833e-14,
  5.143153124253881e-16, -5.076144130761442e-18,  5.077036484371604e-20, -5.173237169645917e-22,  5.409683341184597e-24,  1.987697501609088e+00,  1.174495244707281e-04,
 -1.123083088480749e-06,  1.076143997382413e-08, -1.033935935564170e-10,  9.968989066927097e-13, -9.657418158293782e-15,  9.415849735298454e-17, -9.262023441926814e-19,
  9.224458787612072e-21, -9.349976184750153e-23,  9.715598538207413e-25,  1.654496537586808e+00,  3.184028291494531e-03, -2.943474816652235e-05,  2.731989348184829e-07,
 -2.548716168343704e-09,  2.393427678319507e-11, -2.266680505283081e-13,  2.170061115117652e-15, -2.106577507903533e-17,  2.081297641316461e-19, -2.102411271469659e-21,
  2.182746197705514e-23,  1.833259894404461e+00,  1.534572689715304e-03, -1.415294757077795e-05,  1.308722204107375e-07, -1.214201320831790e-09,  1.131296787449328e-11,
 -1.059837560842176e-13,  9.999928244657934e-16, -9.523980799651724e-18,  9.183677376381246e-20, -9.002585335085925e-22,  9.019899957762010e-24,  1.935854510181536e+00,
  5.899710942967872e-04, -5.435170807633593e-06,  5.017595040806754e-08, -4.644307947872780e-10,  4.313374167968055e-12, -4.023743170125369e-14,  3.775493247056731e-16,
 -3.570242603035810e-18,  3.411850577798394e-20, -3.307626964542706e-22,  3.270056594858758e-24,  1.988150110443724e+00,  1.089547235113753e-04, -1.003252121138135e-06,
  9.254892854236869e-09, -8.557593884844958e-11,  7.936919334408296e-13, -7.390697908970173e-15,  6.918708955994520e-17, -6.523388691247865e-19,  6.211040054184198e-21,
 -5.993925995093561e-23,  5.893244850893235e-25,  1.666781524858223e+00,  2.961005161296159e-03, -2.638614519281172e-05,  2.359727571112112e-07, -2.119875538049403e-09,
  1.915359633595204e-11, -1.743231388824762e-13,  1.601307096679979e-15, -1.488229676831648e-17,  1.403601843718654e-19, -1.348232656716442e-21,  1.324428868220744e-23,
  1.839181239632547e+00,  1.427317055662400e-03, -1.269200076822630e-05,  1.131258084852307e-07, -1.011275948883031e-09,  9.073740855404288e-12, -8.179909008237288e-14,
  7.418780161229729e-16, -6.781129597348549e-18,  6.261379964208108e-20, -5.858406275668657e-22,  5.576475558650081e-24,  1.938131075091886e+00,  5.487780806653952e-04,
 -4.874958603302695e-06,  4.338610364144909e-08, -3.870262292740261e-10,  3.462672494222094e-12, -3.109757243046480e-14,  2.806561338468665e-16, -2.549288233105315e-18,
  2.335419318524637e-20, -2.163975258313950e-22,  2.035815605212528e-24,  1.988570549330005e+00,  1.013508116480717e-04, -8.999143756511449e-07,  8.003649787326843e-09,
 -7.133032199979623e-11,  6.373944181754828e-13, -5.715121174830338e-15,  5.147320072103767e-17, -4.663362861738669e-19,  4.258335975796652e-21, -3.930037736457923e-23,
  3.679485077285625e-25,  1.678220523688919e+00,  2.760693794498564e-03, -2.374603568045371e-05,  2.049063391545710e-07, -1.775268977850260e-09,  1.545838890183483e-11,
 -1.354622976515827e-13,  1.196549289102007e-15, -1.067508219608963e-17,  9.642757149657417e-20, -8.844821957271110e-22,  8.265634723927353e-24,  1.844695662425927e+00,
  1.330949153710461e-03, -1.142591211695947e-05,  9.829717252688627e-08, -8.478687744079941e-10,  7.337245323710947e-12, -6.375525969329643e-14,  5.568625841251363e-16,
 -4.896010272805993e-18,  4.341088856124476e-20, -3.890978444161680e-22,  3.536194211756495e-24,  1.940251343425432e+00,  5.117606861071758e-04, -4.389318948136340e-06,
  3.770967573255170e-08, -3.246442175559006e-10,  2.802134170351524e-12, -2.426585996065170e-14,  2.110203761314982e-16, -1.845029515308436e-18,  1.624573603396874e-20,
 -1.443714123738580e-22,  1.298569405338408e-24,  1.988962136052301e+00,  9.451719272168590e-05, -8.103204798269508e-07,  6.957356624548913e-09, -5.984547243049784e-11,
  5.159717683365548e-13, -4.461737319362744e-15,  3.872878146698749e-17, -3.378396138719682e-19,  2.966220123904403e-21, -2.626760173213019e-23,  2.352665955784303e-25,
  1.688898283073230e+00,  2.580100543155799e-03, -2.144792555064368e-05,  1.788094703814471e-07, -1.496085097776010e-09,  1.257371312653173e-11, -1.062643545790262e-13,
  9.043107750404198e-16, -7.762061514770451e-18,  6.733510228903811e-20, -5.917700563039406e-22,  5.283084900055670e-24,  1.849843803504466e+00,  1.244040138314875e-03,
 -1.032315441258964e-05,  8.582709484164288e-08, -7.152479030957092e-10,  5.977864629227096e-12, -5.014135988802491e-14,  4.224699562623603e-16, -3.579691132041279e-18,
  3.054841169215060e-20, -2.630575483017442e-22,  2.291145636675034e-24,  1.942230903706786e+00,  4.783719589027225e-04, -3.966216560201940e-06,  3.293396247149761e-08,
 -2.739790697700475e-10,  2.284487895045972e-12, -1.910328553743354e-14,  1.603249369676289e-16, -1.351748011478885e-18,  1.146450479094599e-20, -9.797664823085866e-23,
  8.455579499897988e-25,  1.989327746462475e+00,  8.835305225519250e-05, -7.322547135711621e-07,  6.076914358829110e-09, -5.051493687163053e-11,  4.207732035176906e-13,
 -3.513967175584698e-15,  2.944225027903346e-17, -2.477238610445485e-19,  2.095653373822957e-21, -1.785392662958961e-23,  1.535048159019526e-25,  1.698888557573566e+00,
  2.416711310740137e-03, -1.943796391856649e-05,  1.567534654344905e-07, -1.268199416793987e-09,  1.030123647904383e-11, -8.408676237056229e-14,  6.905585686422746e-16,
 -5.713671571449573e-18,  4.770931436337236e-20, -4.028383600619549e-22,  3.447236746582743e-24,  1.854661053258941e+00,  1.165388736758475e-03, -9.358149023923834e-06,
  7.527800377058458e-08, -6.068292097644157e-10,  4.904425876007388e-12, -3.976398985474632e-14,  3.236662804513754e-16, -2.647429214145598e-18,  2.178693535379717e-20,
 -1.806670681373980e-22,  1.512453961770967e-24,  1.944083334233695e+00,  4.481518521279577e-04, -3.595879962683102e-06,  2.889234772005959e-08, -2.325342196227060e-10,
  1.875346306526468e-12, -1.516272434206951e-14,  1.229831649069219e-16, -1.001470632359444e-18,  8.196173383454864e-21, -6.750833500166826e-23,  5.605524452718548e-25,
  1.989669885851185e+00,  8.277357750702248e-05, -6.639175789762805e-07,  5.331681889376805e-09, -4.288040049952845e-11,  3.454999074125539e-13, -2.790134129418407e-15,
  2.259651644220166e-17, -1.836643312036246e-19,  1.499698666425724e-21, -1.231804789664440e-23,  1.019405247634729e-25, -2.004040376272190e+00,  2.411953088874316e-03,
 -4.679693773655756e-04,  9.107329528116854e-05, -1.777919813806671e-05,  3.481800001114885e-06, -6.840530193643350e-07,  1.348325177631926e-07, -2.666510331336588e-08,
  5.290998074687537e-09, -1.051914566876800e-09,  2.020449593103173e-10, -2.003816513019577e+00,  2.267531294101270e-03, -4.271433016316528e-04,  8.073423670916401e-05,
 -1.531364434102506e-05,  2.915483617204850e-06, -5.572240675132882e-07,  1.069333923518595e-07, -2.060809792410233e-08,  3.988955202258271e-09, -7.745957208506997e-10,
  1.457069087433926e-10, -2.003699248706943e+00,  2.192392564315618e-03, -4.065287778342201e-04,  7.566856909822325e-05, -1.414138594486367e-05,  2.654139119088548e-06,
 -5.003972582053482e-07,  9.479169539324783e-08, -1.804650065883144e-08,  3.453536514285221e-09, -6.636222349748443e-10,  1.237093818104969e-10, -2.003642292136171e+00,
  2.156023811841836e-03, -3.967053508860053e-04,  7.329190768703557e-05, -1.359979346398536e-05,  2.535209035038229e-06, -4.749174569514311e-07,  8.942577372630189e-08,
 -1.693020909334477e-08,  3.223357652488289e-09, -6.165298968896337e-10,  1.144819925629951e-10, -2.001797816412345e+00,  1.062187495090015e-03, -1.929566598146841e-04,
  3.507496016093289e-05, -6.379915694900363e-06,  1.161220072389297e-06, -2.114937114704235e-07,  3.854474502141475e-08, -7.029406707956751e-09,  1.282757965425622e-09,
 -2.339944156250099e-10,  4.137458515013144e-11, -2.001749937067024e+00,  1.031678140168004e-03, -1.847958755731949e-04,  3.312352590019008e-05, -5.941327355467705e-06,
  1.066447528602796e-06, -1.915627628202399e-07,  3.443537444136467e-08, -6.194792679848922e-09,  1.115244195106600e-09, -2.007349420778240e-10,  3.505424573508007e-11,
 -2.001723613636573e+00,  1.014957066606467e-03, -1.803870198993399e-04,  3.208443988087488e-05, -5.711161267151878e-06,  1.017429863750658e-06, -1.814028158584209e-07,
  3.237072985181854e-08, -5.781479033299373e-09,  1.033474641178212e-09, -1.847298067472703e-10,  3.205281029062394e-11, -2.001710504032316e+00,  1.006643535065510e-03,
 -1.782118196967045e-04,  3.157574433283216e-05, -5.599350264086912e-06,  9.938008829490284e-07, -1.765426615183355e-07,  3.139058456785315e-08, -5.586748386124141e-09,
  9.952378397900250e-10, -1.773008603767564e-10,  3.066920363722569e-11, -2.000851720205764e+00,  5.009717203597852e-04, -8.836149983387572e-05,  1.558754492465539e-05,
 -2.750155640450482e-06,  4.852906067361586e-07, -8.564690956221493e-08,  1.511773873730661e-08, -2.668867826308192e-09,  4.712165362661370e-10, -8.313473627474111e-11,
  1.423881649040396e-11, -2.000840585563179e+00,  4.939149162992855e-04, -8.652042975956368e-05,  1.515837770926932e-05, -2.656164693933766e-06,  4.655069668218496e-07,
 -8.159564392022755e-08,  1.430467687797255e-08, -2.508186134756388e-09,  4.398466248967484e-10, -7.707760196907613e-11,  1.311767804948275e-11, -2.000834325010661e+00,
  4.899531594134650e-04, -8.549408571320031e-05,  1.492082411303985e-05, -2.604508537030077e-06,  4.547115729286780e-07, -7.940072995063955e-08,  1.386731111143989e-08,
 -2.422367218206978e-09,  4.232114311931585e-10, -7.388829545362887e-11,  1.253126400402866e-11, -2.000831169505598e+00,  4.879579508441274e-04, -8.497917683453295e-05,
  1.480210451633854e-05, -2.578792559723314e-06,  4.493580467573901e-07, -7.831644993423582e-08,  1.365208537934607e-08, -2.380298290465592e-09,  4.150879972977462e-10,
 -7.233679049039186e-11,  1.224700380368654e-11, -2.000414924140438e+00,  2.435441482050582e-04, -4.235774683540470e-05,  7.367220164661621e-06, -1.281415903837522e-06,
  2.228908546111091e-07, -3.877127497731490e-08,  6.744404594272373e-09, -1.173255315341107e-09,  2.041013400859118e-10, -3.547647839836895e-11,  5.990804687963773e-12,
 -2.000412236057325e+00,  2.418448649913935e-04, -4.191966823995889e-05,  7.266327479597963e-06, -1.259587495347599e-06,  2.183524344782743e-07, -3.785333433841457e-08,
  6.562460741512028e-09, -1.137746552825533e-09,  1.972558439034145e-10, -3.417129119698677e-11,  5.752076995598625e-12, -2.000410708199441e+00,  2.408797398747233e-04,
 -4.167172273242120e-05,  7.209424488866409e-06, -1.247319808677039e-06,  2.158108321101751e-07, -3.734108865866062e-08,  6.461288565473504e-09, -1.118071366054512e-09,
  1.934762241413822e-10, -3.345319491203020e-11,  5.621165865267966e-12, -2.000409933571602e+00,  2.403906174207761e-04, -4.154630425507110e-05,  7.180696573876187e-06,
 -1.241138323294379e-06,  2.145326343062221e-07, -3.708397275672618e-08,  6.410604415307447e-09, -1.108233726797410e-09,  1.915900493892349e-10, -3.309552478033921e-11,
  5.556078610807495e-12, -2.000204826271316e+00,  1.201033964256118e-04, -2.074600255413360e-05,  3.583582542986712e-06, -6.190193811726234e-07,  1.069288589007032e-07,
 -1.847096010548044e-08,  3.190713819908951e-09, -5.511753274867225e-10,  9.521046331371165e-11, -1.643309016391357e-11,  2.756526299454825e-12, -2.000204165699226e+00,
  1.196863307270503e-04, -2.063910727816492e-05,  3.559108438764986e-06, -6.137556428615364e-07,  1.058409553971462e-07, -1.825223240232059e-08,  3.147619404245397e-09,
 -5.428153531209680e-10,  9.360850067163754e-11, -1.612949018506354e-11,  2.701309432139131e-12, -2.000203788237344e+00,  1.194481001081592e-04, -2.057815380282089e-05,
  3.545177316989333e-06, -6.107646879878184e-07,  1.052238764537903e-07, -1.812838466256413e-08,  3.123261566868119e-09, -5.380984624660325e-10,  9.270623100368634e-11,
 -1.595879470514943e-11,  2.670315534898106e-12, -2.000203596305012e+00,  1.193269887267264e-04, -2.054719585117119e-05,  3.538108573128531e-06, -6.092485213472874e-07,
  1.049113706623369e-07, -1.806572538157095e-08,  3.110949926381353e-09, -5.357166207912352e-10,  9.225106115902735e-11, -1.587276645236187e-11,  2.654709107636919e-12,
 -2.000101765928552e+00,  5.964248917266732e-05, -1.026748430990241e-05,  1.767556436557593e-06, -3.042870606550745e-07,  5.238351480716547e-08, -9.017927505281093e-09,
  1.552457750239210e-09, -2.672597017939813e-10,  4.600843692818742e-11, -7.913763644520232e-12,  1.323170310271370e-12, -2.000101602186937e+00,  5.953917078165581e-05,
 -1.024107974806567e-05,  1.761528576912730e-06, -3.029944112763115e-07,  5.211713387778221e-08, -8.964527677037866e-09,  1.541967694230802e-09, -2.652307105394475e-10,
  4.562078305513344e-11, -7.840512661167033e-12,  1.309884687488778e-12, -2.000101508374869e+00,  5.947998767766682e-05, -1.022596769714179e-05,  1.758081681042584e-06,
 -3.022558868867303e-07,  5.196507718642076e-08, -8.934072569365881e-09,  1.535990247818348e-09, -2.640755682215357e-10,  4.540027886371307e-11, -7.798882782711249e-12,
  1.302340433527422e-12, -2.000101460603989e+00,  5.944985355491402e-05, -1.021827678967815e-05,  1.756328310575896e-06, -3.018803946876981e-07,  5.188780347180500e-08,
 -8.918603065901843e-09,  1.532955505620468e-09, -2.634893876326020e-10,  4.528843745228544e-11, -7.777777961333224e-12,  1.298517500932729e-12, -2.000050722598748e+00,
  2.971991464747180e-05, -5.107691147603991e-06,  8.778128550400651e-07, -1.508618684459362e-07,  2.592729836530462e-08, -4.455898464105398e-09,  7.657967786281408e-10,
 -1.316108550181140e-10,  2.261828041544762e-11, -3.883923797545020e-12,  6.483479750309724e-13, -2.000050681836709e+00,  2.969420225241774e-05, -5.101129380745045e-06,
  8.763170440963917e-07, -1.505415634766945e-07,  2.586138795835956e-08, -4.442705036630381e-09,  7.632087940636515e-10, -1.311110167957428e-10,  2.252292214881973e-11,
 -3.865931162891906e-12,  6.450890878514502e-13, -2.000050658452291e+00,  2.967945288083175e-05, -5.097366987577329e-06,  8.754597484595314e-07, -1.503580671608737e-07,
  2.582364577253761e-08, -4.435153421406653e-09,  7.617281422997191e-10, -1.308251724217126e-10,  2.246841324445453e-11, -3.855650679007766e-12,  6.432278167413794e-13,
 -2.000050646535889e+00,  2.967193716688615e-05, -5.095450272191143e-06,  8.750231122241849e-07, -1.502646316831836e-07,  2.580443226696897e-08, -4.431310031844702e-09,
  7.609747478647677e-10, -1.306797625079207e-10,  2.244069110722390e-11, -3.850423490825063e-12,  6.422816535539874e-13, -2.000025321385597e+00,  1.483474499525810e-05,
 -2.547373283699948e-06,  4.374265640619308e-07, -7.511346149513042e-08,  1.289824014180853e-08, -2.214844290854133e-09,  3.803259782235983e-10, -6.530832305342303e-11,
  1.121426063609273e-11, -1.924052819071327e-12,  3.209292382745533e-13, -2.000025311216646e+00,  1.482833146649579e-05, -2.545737730817426e-06,  4.370539945478264e-07,
 -7.503373915692253e-08,  1.288184725315000e-08, -2.211565272235360e-09,  3.796832425658383e-10, -6.518427658269622e-11,  1.119061247317528e-11, -1.919594007600321e-12,
  3.201221920245659e-13, -2.000025305379081e+00,  1.482464989853593e-05, -2.544799074471420e-06,  4.368402206549411e-07, -7.498800588021091e-08,  1.287244542022605e-08,
 -2.209685065683156e-09,  3.793147755273471e-10, -6.511317894232773e-11,  1.117706143096174e-11, -1.917039546475409e-12,  3.196599287276356e-13, -2.000025302403257e+00,
  1.482277318795875e-05, -2.544320643291463e-06,  4.367312736278506e-07, -7.496470133170721e-08,  1.286765505685996e-08, -2.208727190358419e-09,  3.791270818996249e-10,
 -6.507696685904394e-11,  1.117016032879851e-11, -1.915738799857486e-12,  3.194245681510807e-13, -2.000012650736436e+00,  7.411084349653051e-06, -1.272073592094122e-06,
  2.183447391105657e-07, -3.747772693211122e-08,  6.432855078467370e-09, -1.104165840165894e-09,  1.895242786882666e-10, -3.253082701731985e-11,  5.583607852598091e-12,
 -9.575897330455189e-13,  1.596613517476571e-13, -2.000012648196886e+00,  7.409482783722683e-06, -1.271665312938012e-06,  2.182517689514183e-07, -3.745784038322855e-08,
  6.428767390382814e-09, -1.103348488708793e-09,  1.893641238968776e-10, -3.249992872679332e-11,  5.577719552815455e-12, -9.564799075667475e-13,  1.594605410703156e-13,
 -2.000012646738560e+00,  7.408563112007733e-06, -1.271430890942738e-06,  2.181983940115414e-07, -3.744642459953176e-08,  6.426421128705096e-09, -1.102879394714185e-09,
  1.892722180233275e-10, -3.248219948919062e-11,  5.574341256093921e-12, -9.558432366190031e-13,  1.593453543125594e-13, -2.000012645995013e+00,  7.408094211031290e-06,
 -1.271311376372055e-06,  2.181711836801959e-07, -3.744060522924028e-08,  6.425225158153354e-09, -1.102640295769024e-09,  1.892253760929738e-10, -3.247316392459575e-11,
  5.572619638303030e-12, -9.555188015406304e-13,  1.592866607093926e-13, -2.000006322881880e+00,  3.703971999297958e-06, -6.356341592862862e-07,  1.090804109666113e-07,
 -1.871915784281668e-08,  3.212372141037300e-09, -5.512713200403481e-10,  9.460300712480330e-11, -1.623469672165887e-11,  2.785947792015680e-12, -4.776907279359711e-13,
  7.963083990831019e-14, -2.000006322247328e+00,  3.703571834536986e-06, -6.355321655033117e-07,  1.090571899117129e-07, -1.871419169746689e-08,  3.211351532353084e-09,
 -5.510672817005830e-10,  9.456303435384927e-11, -1.622698626473791e-11,  2.784478673240796e-12, -4.774138786970571e-13,  7.958075556924872e-14, -2.000006321882880e+00,
  3.703342006543396e-06, -6.354735902252762e-07,  1.090438547297933e-07, -1.871133993944464e-08,  3.210765490405524e-09, -5.509501276267229e-10,  9.454008417774743e-11,
 -1.622255958579990e-11,  2.783635278366643e-12, -4.772549531859026e-13,  7.955200609293188e-14, -2.000006321697044e+00,  3.703224815847190e-06, -6.354437232210641e-07,
  1.090370554452445e-07, -1.870988594127706e-08,  3.210466699909481e-09, -5.508903990253144e-10,  9.452838385511601e-11, -1.622030287089165e-11,  2.783205329817106e-12,
 -4.771739380699410e-13,  7.953735094856261e-14, -2.000003160819699e+00,  1.851593688119670e-06, -3.177164985277234e-07,  5.451723793359712e-08, -9.354658168541789e-09,
  1.605173573568289e-09, -2.754330686127586e-10,  4.726178845379906e-11, -8.109683715737016e-12,  1.391512910517969e-12, -2.385699554327860e-13,  3.976558300868897e-14,
 -2.000003160661104e+00,  1.851493675250227e-06, -3.176910095748124e-07,  5.451143535283067e-08, -9.353417317903291e-09,  1.604918585350962e-09, -2.753820964138385e-10,
  4.725180348862105e-11, -8.107757862844829e-12,  1.391145999632758e-12, -2.385008188561062e-13,  3.975307668219924e-14, -2.000003160570008e+00,  1.851436229487530e-06,
 -3.176763695303666e-07,  5.450810262563238e-08, -9.352704651633920e-09,  1.604772140229633e-09, -2.753528228059773e-10,  4.724606922686368e-11, -8.106651895915060e-12,
  1.390935298098706e-12, -2.384611177057263e-13,  3.974589520416353e-14, -2.000003160523555e+00,  1.851406936129746e-06, -3.176689042332112e-07,  5.450640321647598e-08,
 -9.352341257552308e-09,  1.604697467848770e-09, -2.753378964161970e-10,  4.724314541466630e-11, -8.106087988857415e-12,  1.390827867866331e-12, -2.384408756151680e-13,
  3.974223369631338e-14,     0.997469823360959,     0.986305321998864,     0.964410677730838,     0.926290382025254,      0.99873753570116,     0.993166984262814,
     0.982243192958132,     0.963225980851661,      0.99936940251352,      0.99658694166168,      0.99113063531176,     0.981631985163213,     0.999684857436659,
     0.998294317912259,     0.995567528008308,     0.990820603231305,     0.999842467462894,     0.999147368876845,     0.997784310634769,     0.995411437717947,
     0.999921243380653,     0.999573736691158,     0.998892291243009,     0.997706000855833,     0.999960624098049,     0.999786881380562,      0.99944617951218,
     0.998853070676062,     0.999980312650385,     0.999893443945516,     0.999723098217466,     0.999426552868839,     0.999990156475461,     0.999946722786129,
     0.999861551222668,     0.999713280813228,     0.999995078275289,     0.999973361596352,     0.999930776139642,      0.99985664150083,     0.999997539147033,
     0.999986680848991,     0.999965388201876,     0.999928321023908  };
  constexpr double w[2108] = {  3.562355386973560e-01, -1.465520881142391e-01,  3.246538908825118e-02, -4.922956066845695e-03,  5.681601018144121e-04,
 -5.297686924127099e-05,  4.146505322999440e-06, -2.797690899672378e-07,  1.659290692243123e-08, -8.781106073796920e-10,  4.195813793543483e-11, -1.824922069594051e-12,
  3.542461576230532e-01, -1.131525382199826e-01,  2.048633512895393e-02, -2.650367678347351e-03,  2.697978834283717e-04, -2.277104659824228e-05,  1.646578913740803e-06,
 -1.043280136840156e-07,  5.887901473938260e-09, -2.997085120628064e-10,  1.389685694679775e-11, -5.908678870677720e-13,  3.135603061900189e-01, -5.780642147246056e-02,
  7.065751867125904e-03, -6.714540513079501e-04,  5.333473951104461e-05, -3.680179554354904e-06,  2.258574277900206e-07, -1.252517635797069e-08,  6.348065496861771e-10,
 -2.965504266085804e-11,  1.285446036846430e-12, -5.191463089745984e-14,  1.722460108121801e-01, -1.411224875253862e-02,  9.352540016644931e-04, -5.493494578335858e-05,
  2.940262860925794e-06, -1.458311969298454e-07,  6.779472273444658e-09, -2.978267757252961e-10,  1.242808828645212e-11, -4.951069324393135e-13,  1.890087169660380e-14,
 -6.916945694083665e-16,  5.948613146814453e-02, -2.384655130980024e-02,  5.170448864796321e-03, -7.706494265513504e-04,  8.770852791219421e-05, -8.084804025899872e-06,
  6.267589318689434e-07, -4.194651141550410e-08,  2.470622954334500e-09, -1.299666978645362e-10,  6.177812821588340e-12, -2.674763518490283e-13,  9.895882367739649e-02,
 -2.748268544497619e-02,  4.499100505321257e-03, -5.380292070287690e-04,  5.142775983226244e-05, -4.123624676531727e-06,  2.858548002575983e-07, -1.748778515011442e-08,
  9.584286647585184e-10, -4.759840611120996e-11,  2.161547105614321e-12, -9.029682884355261e-14,  1.593084749748259e-01, -2.314303813944050e-02,  2.405253238582720e-03,
 -2.002106157966221e-04,  1.421494547265383e-05, -8.905339300577942e-07,  5.025725979208417e-08, -2.590257679388845e-09,  1.231364963346339e-10, -5.438894512336195e-12,
  2.244471480004809e-13, -8.681692093023520e-15,  1.274812278034398e-01, -8.642965949974855e-03,  4.845117676604899e-04, -2.457938755141626e-05,  1.152762450720932e-06,
 -5.067533646821542e-08,  2.103451852862683e-09, -8.327504070832009e-11,  3.153983791513360e-12, -1.144072841743175e-13,  4.003034475043921e-15, -1.353392420970179e-16,
  1.060686546528511e-02, -4.077440970670947e-03,  8.559643240298725e-04, -1.244365969255563e-04,  1.388689634812433e-05, -1.260020251950931e-06,  9.642689276785233e-08,
 -6.384562014411969e-09,  3.726630674873696e-10, -1.945356715212832e-11,  9.185988292321927e-13, -3.954437221862835e-14,  3.388660030093005e-02, -7.802347432663230e-03,
  1.126094870864806e-03, -1.219916874257309e-04,  1.077125471018744e-05, -8.092709311425678e-07,  5.315849017911993e-08, -3.109191006086356e-09,  1.640909820545863e-10,
 -7.894071716048921e-12,  3.489640129358184e-13, -1.424903126156738e-14,  9.409642328716346e-02, -1.066890226989258e-02,  9.397433721936959e-04, -6.819835304138805e-05,
  4.302445277066675e-06, -2.429480029488611e-07,  1.251312390522088e-08, -5.946770440826520e-10,  2.629336344653956e-11, -1.089121696191931e-12,  4.245987021324833e-14,
 -1.561545425112570e-15,  9.915310127035223e-02, -5.695581097945793e-03,  2.739032515701656e-04, -1.212772680116807e-05,  5.012694632045487e-07, -1.970113474396193e-08,
  7.330637782360769e-10, -2.609870358394261e-11,  9.040042529113693e-13, -2.998267967105913e-14,  9.566477275490980e-16, -2.976077997854227e-17,  2.094570068200177e-03,
 -7.497177557815959e-04,  1.497597789687970e-04, -2.097985179069668e-05,  2.276108398818278e-06, -2.019950222581506e-07,  1.518623470546996e-08, -9.910413491255639e-10,
  5.715635402551966e-11, -2.953752048497636e-12,  1.382897698905451e-13, -5.909856564876853e-15,  1.436652760243783e-02, -2.612072101435884e-03,  3.256760813012148e-04,
 -3.135272288557071e-05,  2.517288302021300e-06, -1.747304023614602e-07,  1.073987724365856e-08, -5.940812187984393e-10,  2.990339810156720e-11, -1.381919083550748e-12,
  5.903560399494020e-14, -2.341316703939288e-15,  6.254489446492920e-02, -5.539960908009184e-03,  4.147348142598316e-04, -2.623518924490322e-05,  1.469526987444666e-06,
 -7.452020521272638e-08,  3.484116220852525e-09, -1.520562854758854e-10,  6.215195982576063e-12, -2.396650860114272e-13,  8.769021356185483e-15, -3.044996281969779e-16,
  7.999108747109793e-02, -3.974908182575974e-03,  1.660253538353123e-04, -6.503934395016096e-06,  2.374436263992716e-07, -8.392997315514749e-09,  2.858773577963878e-10,
 -9.016895064838816e-12,  2.854541802504889e-13, -8.858428987685198e-15,  2.565515259554098e-16, -7.422124976523110e-18,  4.854981797430112e-04, -1.531334838706711e-04,
  2.836677697499206e-05, -3.758583518323078e-06,  3.913486238571265e-07, -3.365039819229030e-08,  2.467824004333711e-09, -1.578820905334186e-10,  8.959152952060190e-12,
 -4.568359984917903e-13,  2.114993408867491e-14, -8.953207456640319e-16,  7.450582458331198e-03, -1.023316877685414e-03,  1.093527037408598e-04, -9.199316699670393e-06,
  6.631097991054732e-07, -4.203708819647660e-08,  2.386611202927440e-09, -1.235404114243933e-10,  5.872936558700110e-12, -2.582203097058295e-13,  1.057920240301638e-14,
 -4.044653778676818e-16,  4.547192296291899e-02, -3.171251934194299e-03,  2.033557478085288e-04, -1.122854779494774e-05,  5.598691309166713e-07, -2.559097549395940e-08,
  1.078103754151839e-09, -4.313633425596205e-11,  1.632666376478501e-12, -5.802443393459683e-14,  1.988610303644106e-15, -6.488501247874974e-17,  6.633052796869790e-02,
 -2.905006974350633e-03,  1.062440159243012e-04, -3.745388323862782e-06,  1.220426994271154e-07, -3.766480652768735e-09,  1.244485596878689e-10, -3.507732158732183e-12,
  9.242079111451615e-14, -3.060531571520389e-15,  7.165813201965453e-17, -1.957394158384943e-18,  1.434510869043053e-04, -3.603538120522228e-05,  6.011971202724868e-06,
 -7.326878473428006e-07,  7.187659626316206e-08, -5.909933399613061e-09,  4.183491425455727e-10, -2.604016656436750e-11,  1.445457241366259e-12, -7.236922444863311e-14,
  3.301583922109338e-15, -1.380364736925624e-16,  4.598035726943723e-03, -4.579709123465986e-04,  4.246932791562880e-05, -3.084312018349240e-06,  1.966645506845707e-07,
 -1.138111699660765e-08,  5.890410399656725e-10, -2.815158820396477e-11,  1.261098873574873e-12, -5.203382936332474e-14,  2.021612010092346e-15, -7.476843709268414e-17,
  3.536039169632935e-02, -1.962535797560820e-03,  1.091132748322156e-04, -5.284044365208012e-06,  2.329113999243936e-07, -9.800444231436348e-09,  3.714915347538097e-10,
 -1.322290093057651e-11,  4.805022616458169e-13, -1.569181929921904e-14,  4.695074864358745e-16, -1.606551191349036e-17,  5.616622152085366e-02, -2.206453972854248e-03,
  7.097597641754486e-05, -2.261577559528116e-06,  6.998214324226265e-08, -1.709221413571295e-09,  5.433264842921399e-11, -1.869319287063121e-12,  2.201363741596697e-14,
 -9.468330418913440e-16,  5.596466844720567e-17,  9.363795367275631e-19,  5.889277559608871e-05, -9.930870720278898e-06,  1.482610365029334e-06, -1.603542946129954e-07,
  1.438629978902870e-08, -1.116556110909958e-09,  7.517201755272612e-11, -4.489509158393617e-12,  2.426156916759800e-13, -1.185050286514586e-14,  5.273531703870795e-16,
 -2.181204255829594e-17,  3.268951475205541e-03, -2.261399582181266e-04,  1.873985842306541e-05, -1.194240691969044e-06,  6.440091007040128e-08, -3.442909048483999e-09,
  1.665596419959472e-10, -6.937126551645885e-12,  2.923848396276289e-13, -1.207683016806945e-14,  4.016247641362866e-16, -1.374275710973454e-17,  2.892760165670213e-02,
 -1.292179207635613e-03,  6.288396080506874e-05, -2.741372563446789e-06,  1.032154256643742e-07, -4.010468732919369e-09,  1.510566381986262e-10, -4.316195634612128e-12,
  1.320412649445590e-13, -5.852821042414623e-15,  1.327163103931882e-16, -7.992364622030145e-19,  4.832806720205510e-02, -1.730387879872514e-03,  4.961102444943231e-05,
 -1.361089006682498e-06,  4.493809479647207e-08, -9.679152228849962e-10,  1.022440007900915e-11, -1.213089272265303e-12,  3.470597030012072e-14,  1.550192014703476e-15,
  3.138054428688824e-17, -4.053540301648039e-18,  3.459428441884555e-05, -3.076314482449075e-06,  4.325549802234197e-07, -4.167148934217942e-08,  3.186544648604762e-09,
 -2.283559065968481e-10,  1.487380120534986e-11, -8.260937351636814e-13,  4.160468961495695e-14, -2.053085445803643e-15,  9.098085092085264e-17, -3.327794103223283e-18,
  2.592749495012591e-03, -1.201154011413140e-04,  8.878646832635052e-06, -5.487560395835968e-07,  2.387421356803861e-08, -1.031859440427433e-09,  5.512878469433036e-11,
 -2.239508843729408e-12,  5.618020705765269e-14, -2.502670269586162e-15,  1.584129718353264e-16, -2.537277497162545e-18,  2.458967763954428e-02, -8.976116381228788e-04,
  3.779101926302038e-05, -1.569253859083084e-06,  5.124682606458770e-08, -1.515349597251505e-09,  6.516639870112892e-11, -2.398878782504270e-12,  2.247060515249889e-14,
 -9.789206842879608e-17,  1.338586064155796e-16, -3.424073463784239e-18,  4.211221867056801e-02, -1.388039244592980e-03,  3.697171230588093e-05, -7.922427807982129e-07,
  2.614678328763812e-08, -9.552524421175878e-10, -6.514436729707625e-13,  5.816645451816260e-13,  5.709113650998543e-14, -1.735234172859383e-15, -1.571880745508941e-16,
  1.511661690353438e-18,  2.693026106430643e-05, -1.000920591037389e-06,  1.340453707687222e-07, -1.366026741658894e-08,  8.762164074290351e-10, -4.732277093540748e-11,
  2.996919611386282e-12, -1.877058103779872e-13,  8.468811490626805e-15, -2.808775899561780e-16,  1.347788691437626e-17, -8.933576840273304e-19,  2.220214592289777e-03,
 -7.012764460390780e-05,  4.086318351317002e-06, -2.783343028354357e-07,  1.222227696195501e-08, -3.047140450342432e-10,  1.105252641122616e-11, -9.692139073232682e-13,
  3.984402377188920e-14,  2.400979638849348e-16, -3.359536954249455e-17, -3.418027299137098e-18,  2.150183126325919e-02, -6.585264674371092e-04,  2.309641089124911e-05,
 -9.279181635807426e-07,  3.164667261540690e-08, -6.529369370886941e-10,  1.237809955367401e-11, -1.153111971767951e-12,  5.785289873702630e-14,  3.664937782477688e-16,
 -9.806692655549718e-17, -1.739969720468222e-18,  3.709956490297135e-02, -1.124599888836071e-03,  2.936340098025087e-05, -5.194265063573063e-07,  8.898791164511648e-09,
 -6.601863357333806e-10,  2.566507721612992e-11,  6.667482152824473e-13, -5.395979524368277e-14, -1.989811566429262e-15,  1.710808994262130e-16,  4.388933758805247e-18,
  2.429818991356707e-05, -3.994319087283651e-07,  3.189827525015792e-08, -4.635530903014243e-09,  3.507231761844993e-10, -1.489486753945987e-11,  4.373433819868274e-13,
 -2.595548146255915e-14,  2.384244044971816e-15, -1.250256114496772e-16,  1.973707708723348e-18,  1.000693450991483e-19,  1.988089010381931e-03, -4.787751970145363e-05,
  1.746220211095176e-06, -1.237778723851171e-07,  7.313788245883741e-09, -2.261418696531468e-10,  4.282064435491201e-13,  7.527725332735334e-14,  1.556037087728405e-14,
 -1.228547049446953e-15,  8.259256276645172e-18,  2.603414775357224e-18,  1.917767355055753e-02, -5.106144443249203e-04,  1.459968976718649e-05, -5.172226014492776e-07,
  1.997908946091462e-08, -5.481921928163013e-10,  2.901453838594464e-12,  2.335876801121462e-13,  1.530985230404122e-14, -1.763074061599070e-15,  2.841156362675641e-17,
  3.180301927160560e-18,  3.303389110828923e-02, -9.129749269749058e-04,  2.366527780796372e-05, -4.467336700197366e-07,  2.256845351564013e-09, -3.271466986703941e-11,
  1.895011898201448e-11, -9.149072005648983e-13, -1.554348500823776e-14,  2.616884355585123e-15, -2.447525944216219e-17, -6.285449317604085e-18,  2.296709113533900e-05,
 -2.910510163690592e-07,  1.553545005704382e-09, -9.753420668236488e-10,  1.283686259853095e-10, -7.946865752722499e-12,  2.470818189668468e-13, -7.769593310833266e-16,
 -1.185843570934405e-16, -1.511703504432920e-17,  1.929718909409753e-18, -8.285801132182336e-20,  1.817478508428017e-03, -3.819383760550153e-05,  8.189279716190582e-07,
 -4.111960173895314e-08,  3.203611615879412e-09, -1.688628431488372e-10,  4.202722646459209e-12,  6.976071244337084e-14, -7.887468368794792e-15,  1.806204186540232e-18,
  2.357110537894682e-17, -1.123520835825373e-18,  1.733612187066973e-02, -4.140051507039155e-04,  9.968522643297190e-06, -2.789012129741009e-07,  1.032192595011159e-08,
 -3.911634196446130e-10,  9.266149387922067e-12,  7.172553669863330e-14, -1.326784514638394e-14,  1.370052753223276e-16,  2.954094526477630e-17, -1.641520708829415e-18,
  2.972763381275452e-02, -7.444151423369224e-04,  1.855549897388838e-05, -3.998989249811681e-07,  4.098764825573989e-09,  1.295101078189065e-10, -2.846853862205106e-12,
 -4.113804473515948e-13,  2.805200783025795e-14, -2.945116265010182e-16, -5.070912752200926e-17,  2.737489232406076e-18,  2.178952875855209e-05, -3.005868474273720e-07,
 -2.073225095606702e-09,  1.116094653210768e-10,  2.402596576237574e-11, -2.840302511877477e-12,  1.591167890373583e-13, -4.659940525349361e-15, -7.752470635412514e-18,
  6.975113389246306e-18, -2.150716942308438e-19, -8.792518418430077e-21,  1.675619264439267e-03, -3.296447732204661e-05,  5.400176978562087e-07, -1.120205010532376e-08,
  8.624413528454337e-10, -6.876309204789637e-11,  3.412543228885521e-12, -8.634706054138003e-14, -1.008770136636659e-15,  1.820056852505734e-16, -5.974035053793576e-18,
 -9.174805490439102e-20,  1.582168015456208e-02, -3.453524682799405e-04,  7.393613366463645e-06, -1.643210050382526e-07,  4.675978032866340e-09, -1.830974838078055e-10,
  6.975565384164603e-12, -1.663733970060713e-13, -1.073082981904135e-15,  2.793319665404614e-16, -9.793967060255858e-18, -7.922494279461811e-20,  2.701825624695950e-02,
 -6.138914657915585e-04,  1.421686883509959e-05, -3.196201491854688e-07,  5.521931365138544e-09,  5.976085355297112e-12, -4.951624014274526e-12,  1.310961488480966e-13,
  4.950815361094774e-15, -5.334477219079849e-16,  1.747405701220478e-17,  1.454532706330267e-19,  2.056746299515457e-05, -3.084634929983949e-07,  2.528502827979209e-10,
  2.065262580010689e-10, -4.559606275122296e-12, -4.486200105868841e-13,  4.996232496785039e-14, -2.676130631803533e-15,  8.418327919002976e-17, -7.219271626579843e-19,
 -8.324016979853141e-20,  5.126799155976297e-21,  1.551775040828445e-03, -2.902718754310525e-05,  4.551504470704074e-07, -4.781619125800961e-09,  1.111457269070865e-10,
 -1.511623850841591e-11,  1.203753488400607e-12, -5.807806878233673e-14,  1.638465220050456e-15, -4.931793113014257e-18, -2.104191748789148e-18,  1.126811672036281e-19,
  1.454757325537086e-02, -2.930461287240442e-04,  5.774986714918570e-06, -1.112656086244322e-07,  2.320580460798688e-09, -6.879041579986051e-11,  2.835079748293417e-12,
 -1.096164183794790e-13,  2.863012836381847e-15, -1.119949901879662e-17, -3.207222214499691e-18,  1.711073862187994e-19,  2.476795706260241e-02, -5.140223250832930e-04,
  1.089834495846439e-05, -2.353804705372557e-07,  4.784816478169399e-09, -6.397808666225210e-11, -1.032099950793913e-12,  1.072381515645030e-13, -3.278138069093114e-15,
 -1.031792441147684e-17,  5.961595217500600e-18, -3.007963379368747e-19,  1.935110433414688e-05, -2.981320605181938e-07,  2.150981254019000e-09,  1.064845571006296e-10,
 -6.193377236952646e-12,  1.176836115357253e-13,  6.292677037232432e-15, -7.045227265994963e-16,  3.681935783052317e-17, -1.236870265687174e-18,  2.185210794367153e-20,
  3.701463457530207e-22,  1.442607672971915e-03, -2.560038081663361e-05,  4.022818449195070e-07, -4.304669639473588e-09, -5.534512460007899e-12, -3.605973408743789e-13,
  2.145843458171231e-13, -1.719748558692538e-14,  8.148061257335635e-16, -2.503225815425811e-17,  3.482623794041965e-19,  1.238699794990534e-20,  1.346011038551705e-02,
 -2.516407896767899e-04,  4.626722659723472e-06, -8.231411236144889e-08,  1.426278076577676e-09, -2.818081345462729e-11,  8.804841754405509e-13, -3.774784073654383e-14,
  1.473606931383338e-15, -4.178518505409673e-17,  5.479721746150156e-19,  1.987717167124061e-20,  2.287005568329332e-02, -4.369341241985144e-04,  8.488827326086708e-06,
 -1.695907274818054e-07,  3.442286092244730e-09, -6.380271227325160e-11,  6.525170144199702e-13,  2.223908071838251e-14, -1.687485269066229e-15,  5.585154854780128e-17,
 -6.839145070761649e-19, -3.714225752089767e-20,  1.819897840967709e-05, -2.772905716094822e-07,  2.924898006674472e-09,  2.964865153284788e-11, -3.390931060479441e-12,
  1.302647675900378e-13, -2.384591698955547e-15, -6.521590919485819e-17,  8.104130423226990e-18, -4.175124139837921e-19,  1.450252956715016e-20, -3.323660786770311e-22,
  1.346314172046743e-03, -2.258961708166254e-05,  3.504220389196542e-07, -4.291410285603435e-09,  1.184059749634222e-11,  1.234457817961667e-12, -1.535516841950459e-14,
 -2.434612385619606e-15,  2.030140913806100e-16, -9.478799439348562e-18,  3.045921843666862e-19, -6.121964724886168e-21,  1.252181775138905e-02, -2.182269650131154e-04,
  3.760209254896738e-06, -6.313405037605020e-08,  1.010634869690879e-09, -1.562005814715953e-11,  2.925174021546670e-13, -9.723227425601071e-15,  4.305651280156703e-16,
 -1.683004800506269e-17,  5.008478610341209e-19, -9.444845613848221e-21,  2.124645330911729e-02, -3.763183295793641e-04,  6.745206136913981e-06, -1.237482186956166e-07,
  2.348781778873561e-09, -4.514764356023702e-11,  7.742235890192265e-13, -6.326190943230678e-15, -3.131758954775388e-16,  2.089803335335430e-17, -7.163172612246087e-19,
  1.405265396848575e-20,  1.713779946331329e-05, -2.532142386985095e-07,  3.030308562621390e-09, -7.110866494315476e-12, -1.400888660697006e-12,  6.988431785837684e-14,
 -2.193045470379922e-15,  3.990693962765161e-17,  4.509676636262102e-19, -7.733587827855215e-20,  3.981885830367640e-21, -1.398132337058781e-22,  1.261243075665635e-03,
 -1.998733474344367e-05,  3.007728221739344e-07, -3.937753754952496e-09,  3.004429433645341e-11,  5.382318795824404e-13, -3.001511638802072e-14,  4.587766242474244e-16,
  2.158645917286953e-17, -2.010386588672360e-18,  9.309855432180715e-20, -3.043409226408766e-21,  1.170463450475881e-02, -1.909224639693170e-04,  3.090349258150836e-06,
 -4.915218196872987e-08,  7.524964903979748e-10, -1.075087013795989e-11,  1.451042985552098e-13, -2.546579464869561e-15,  9.197111607948690e-17, -4.225139210366404e-18,
  1.646877828842434e-19, -5.004672039168540e-21,  1.984051771019868e-02, -3.277201476487167e-04,  5.458985791114507e-06, -9.245514974538009e-08,  1.613766712806812e-09,
 -2.929761022115770e-11,  5.372576633588718e-13, -8.681184753680314e-15,  6.326310170342175e-17,  3.379806146104942e-18, -2.131611477343587e-19,  7.381074222698450e-21,
  1.617246806188098e-05, -2.296045705837335e-07,  2.848407772420010e-09, -2.081825540655726e-11, -4.383248172480497e-13,  3.056872115532894e-14, -1.129695224545961e-15,
  3.109357571865621e-17, -5.651558927723041e-19, -7.959691682077358e-22,  6.178337577610696e-22, -3.254171775872913e-23,  1.185819158363307e-03, -1.776140341411693e-05,
  2.566463478041492e-07, -3.404944569068557e-09,  3.484106965490006e-11,  3.413534615479184e-15, -1.450811600344425e-14,  5.011167311069196e-16, -8.197813587228385e-18,
 -1.375420913390164e-19,  1.689194981486653e-20, -7.858996829228712e-22,  1.098692350983904e-02, -1.683695087461969e-04,  2.566225077215588e-06, -3.866284909063898e-08,
  5.677866244160199e-10, -7.895634185359094e-12,  9.912008897341368e-14, -1.113626945729183e-15,  1.769485823337587e-17, -7.368847469724012e-19,  3.589694391791144e-20,
 -1.397990632312872e-21,  1.861052053225875e-02, -2.880875347391498e-04,  4.487164827689138e-06, -7.069947478336806e-08,  1.138556017813667e-09, -1.902465933808879e-11,
  3.321236326678212e-13, -5.848754720574042e-15,  9.065365708556283e-17, -6.688030729121196e-19, -2.943711469718565e-20,  1.843877187210012e-21,  1.529792462066173e-05,
 -2.078975923604610e-07,  2.572635127805496e-09, -2.415344883022856e-11, -3.778941538300989e-14,  1.194946148597740e-14, -4.949019850637531e-16,  1.528858111920654e-17,
 -3.815542251316453e-19,  6.898705829984645e-21, -3.238486386197134e-23, -4.101465732109798e-24,  1.118634367655207e-03, -1.586228949955425e-05,  2.190844210574971e-07,
 -2.861646345541069e-09,  3.240389493702161e-11, -2.072977211443297e-13, -4.267187120255793e-15,  2.399152917834852e-16, -6.744323833957682e-18,  1.135507837491942e-19,
  3.777462480521667e-22, -1.206527884397289e-22,  1.035176990497431e-02, -1.495522973486878e-04,  2.151959245730672e-06, -3.072199895073374e-08,  4.313918784021520e-10,
 -5.843962634997161e-12,  7.330490913114137e-14, -7.856093276454207e-16,  6.506152097693370e-18, -8.266535175171958e-20,  4.866953820288747e-21, -2.648166439278691e-22,
  1.752499418506935e-02, -2.553004610472184e-04,  3.736780448227180e-06, -5.514355659556790e-08,  8.260878493435973e-10, -1.271835194310568e-11,  2.044313585504323e-13,
 -3.445112680446284e-15,  5.856621645520115e-17, -8.831786287440894e-19,  7.133953259931236e-21,  2.090954768450762e-22,  1.450566567769890e-05, -1.884715536440519e-07,
  2.285306209457093e-09, -2.336799160797279e-11,  1.108888788071592e-13,  4.043724130266572e-15, -2.035098048591917e-16,  6.594752508605432e-18, -1.790130172628425e-19,
  4.125260088586896e-21, -7.373256422086707e-23,  6.251908644877193e-25,  1.058485069303772e-03, -1.423850081616599e-05,  1.877058868634890e-07, -2.380022985698051e-09,
  2.766769975630066e-11, -2.497894364723643e-13,  2.300308294086247e-17,  8.574317596214083e-17, -3.125987674348911e-18,  7.737879178086565e-20, -1.314040409257187e-21,
  4.978530827681942e-24,  9.785811873745604e-03, -1.337022380295171e-04,  1.821142029819231e-06, -2.466625464923811e-08,  3.304374260578023e-10, -4.326921679583638e-12,
  5.394558845874066e-14, -6.034370628838711e-16,  5.217325858335009e-18, -1.934577000954890e-20, -1.970425380256593e-23, -2.435112388324678e-23,  1.655968364802509e-02,
 -2.278461608321901e-04,  3.146750388558199e-06, -4.372385075172062e-08,  6.139487419634498e-10, -8.784915566986265e-12,  1.298787443771692e-13, -2.015327801166092e-15,
  3.286880947949776e-17, -5.413572156481044e-19,  8.015270053821755e-21, -7.243735271387999e-23,  1.378661723843666e-05, -1.712759135421541e-07,  2.017491837636026e-09,
 -2.115944467302846e-11,  1.550456374920889e-13,  8.464318612066271e-16, -8.042145586574789e-17,  2.737216224405210e-18, -7.558761691950385e-20,  1.850858365742402e-21,
 -3.981669501624966e-23,  6.994011532146859e-25,  1.004363606626270e-03, -1.284394536467832e-05,  1.616387521578913e-07, -1.976633650753252e-09,  2.282313838668529e-11,
 -2.295014342205644e-13,  1.374334958115627e-15,  2.095785217009079e-17, -1.178637912799175e-18,  3.452101121276703e-20, -7.785155971460589e-22,  1.316856819364625e-23,
  9.278385318109955e-03, -1.202333501000623e-04,  1.554226166636092e-06, -2.000663212359014e-08,  2.555719819552132e-10, -3.216797260520884e-12,  3.927400319899200e-14,
 -4.488547990277276e-16,  4.394654854169604e-18, -2.689814675878866e-20, -1.537325565576698e-22,  5.933421086743107e-24,  1.569554342899874e-02, -2.046162485471273e-04,
  2.675706085200378e-06, -3.515415329243182e-08,  4.653959301138530e-10, -6.242082436639674e-12,  8.564743221643507e-14, -1.220179326309869e-15,  1.832118867852350e-17,
 -2.896010884000799e-19,  4.631045983670592e-21, -6.762382860036720e-23,  1.313224584822254e-05, -1.561087426864388e-07,  1.778742714303617e-09, -1.862632251094556e-11,
  1.576942330300193e-13, -3.853575564100384e-16, -2.950116855153080e-17,  1.130705345336398e-18, -3.121259007353796e-20,  7.638594646008578e-22, -1.714162625026729e-23,
  3.466034701204869e-25,  9.554321407659123e-04, -1.163984234347368e-05,  1.399648926855243e-07, -1.646255885510624e-09,  1.859263140699439e-11, -1.927778861529059e-13,
  1.583165850810584e-15, -1.854494356472030e-18, -3.726986178916514e-19,  1.319088921749763e-20, -3.342293119879049e-22,  6.989179324822500e-24,  8.820891120113313e-03,
 -1.086949204266163e-04,  1.336713285590425e-06, -1.638495364614425e-08,  1.997220121499808e-10, -2.410069677748540e-12,  2.852382706648920e-14, -3.243939321176329e-16,
  3.377828298700891e-18, -2.804707603066301e-20,  7.575090202791536e-23,  3.470038268380660e-24,  1.491738506844003e-02, -1.847802271137430e-04,  2.294747139317835e-06,
 -2.860540344430366e-08,  3.586480279911304e-10, -4.538763349596540e-12,  5.834702467141120e-14, -7.701988640018548e-16,  1.060097049141220e-17, -1.542448804435041e-19,
  2.364393564251678e-21, -3.673721329043611e-23,  1.253491468440840e-05, -1.427307611008079e-07,  1.570011691855048e-09, -1.619432353078675e-11,  1.449806632241697e-13,
 -8.050018834318749e-16, -8.483745881224737e-18,  4.648902699896005e-19, -1.304946419959330e-20,  3.120613724009537e-22, -6.917478267533489e-24,  1.437170842352888e-25,
  9.109938641627156e-04, -1.059436606763462e-05,  1.218740725943046e-07, -1.377590877234955e-09,  1.510743155595128e-11, -1.563929524098045e-13,  1.420303773671823e-15,
 -8.250878418681506e-18, -7.767930842531695e-20,  4.552307043001776e-21, -1.274369618283797e-22,  2.892837564013803e-24,  8.406325744698620e-03, -9.873680366205757e-05,
  1.157789058956036e-06, -1.354069770449425e-08,  1.576898737996167e-10, -1.823185868709111e-12,  2.080784183492316e-14, -2.316415949663538e-16,  2.449526358109376e-18,
 -2.302556322500047e-20,  1.529713191638781e-22,  4.113861733447196e-25,  1.421293531009463e-02, -1.677041955171620e-04,  1.983144876925423e-06, -2.352385511907571e-08,
  2.803077210981536e-10, -3.363437327148847e-12,  4.080975664790593e-14, -5.043165947618127e-16,  6.421426955294766e-18, -8.554478185144176e-20,  1.206941951002629e-21,
 -1.793746500901226e-23,  1.198793505046734e-05, -1.309098368970322e-07,  1.389041122069009e-09, -1.401080285283620e-11,  1.276929997278914e-13, -8.908562816478978e-16,
  5.676642634626312e-20,  1.840146040629904e-19, -5.569381345861292e-21,  1.304141202103092e-22, -2.790510011206087e-24,  5.678431674576819e-26,  8.704671906536251e-04,
 -9.681614716770414e-06,  1.066958523426069e-07, -1.159124732986172e-09,  1.230081277741869e-11, -1.252372157095527e-13,  1.173336251145766e-15, -8.890839542953079e-18,
  1.896782093358073e-20,  1.350197145026350e-21, -4.562622100865244e-23,  1.093336697581225e-24,  8.028931170659179e-03, -9.008415832693040e-05,  1.009317841627977e-06,
 -1.128429129959698e-08,  1.257373568893539e-10, -1.393495114509122e-12,  1.530313467682800e-14, -1.653310663442571e-16,  1.731002950299863e-18, -1.697175648841517e-20,
  1.420230166839223e-22, -6.651982415654264e-25,  1.357216233924470e-02, -1.528967267885338e-04,  1.725708482404136e-06, -1.952828242146525e-08,  2.217985558921916e-10,
 -2.532780494012390e-12,  2.916122058857714e-14, -3.401286358975499e-16,  4.050715024507472e-18, -4.985366889421052e-20,  6.435572151020498e-22, -8.804084090276104e-24,
  1.148550279831222e-05, -1.204366401841299e-07,  1.232586312438616e-09, -1.210873949029018e-11,  1.102187114882573e-13, -8.441301459321033e-16,  3.290620292335941e-18,
  6.346032343045970e-20, -2.399546702059231e-21,  5.631986692238401e-23, -1.159610599911773e-24,  2.261356612507141e-26,  8.333642564984400e-04, -8.880520897740026e-06,
  9.388930592227102e-08, -9.809025915082695e-10,  1.005801052354583e-11, -9.996154253124349e-14,  9.381493585004971e-16, -7.780660593270444e-18,  4.389518012417222e-20,
  2.322020202614794e-22, -1.526671602100579e-23,  3.977110332939664e-25,  7.683931661563087e-03, -8.251905686044588e-05,  8.851180214321493e-07, -9.476965716779690e-09,
  1.011953272569362e-10, -1.076038687427438e-12,  1.136496077655717e-14, -1.186808950745314e-16,  1.214461287741464e-18, -1.195109109850320e-20,  1.081866633552955e-22,
 -7.886303417809507e-25,  1.298678300609894e-02, -1.399717051252052e-04,  1.511105040440972e-06, -1.634971830626495e-08,  1.774394815396654e-10, -1.934044712582506e-12,
  2.121403543577596e-14, -2.349163853568486e-16,  2.640058107361326e-18, -3.036413130809951e-20,  3.617740916881342e-22, -4.527643408972362e-24,  1.102259802482944e-05,
 -1.111284424502450e-07,  1.097320530153844e-09, -1.047554073146670e-11,  9.423186492306402e-14, -7.509136838500051e-16,  4.243216537028207e-18,  1.180014106359133e-20,
 -1.012927976082304e-21,  2.500873317994160e-23, -5.013738621063156e-25,  9.324530251081033e-27,  7.992735247360108e-04, -8.173898345348669e-06,  8.302183658673366e-08,
 -8.348160759367205e-10,  8.267129113325582e-12, -7.989729329069572e-14,  7.405400555557562e-16, -6.331982674582523e-18,  4.457958399284639e-20, -1.231672949479745e-22,
 -4.344960323172827e-24,  1.406393658837263e-25,  7.367333890503524e-03, -7.586702651451294e-05,  7.804440968309069e-07, -8.016242407019529e-09,  8.215408814646345e-11,
 -8.391342430461667e-13,  8.526866277226103e-15, -8.593259572143559e-17,  8.540761261437527e-19, -8.280290275093427e-21,  7.649445102299588e-23, -6.354784706887760e-25,
  1.244989576222834e-02, -1.286221582117217e-04,  1.330750025992682e-06, -1.379454733131832e-08,  1.433625518284706e-10, -1.495212293614090e-12,  1.567267172837706e-14,
 -1.654759772070541e-16,  1.766131155322728e-18, -1.916279062695590e-20,  2.132111430708349e-22, -2.461629984227828e-24,  1.059487996830451e-05, -1.028281782137976e-07,
  9.801827898153872e-10, -9.082388050557936e-12,  8.024287967481044e-14, -6.480633334054445e-16,  4.231617431411723e-18, -9.398777191108358e-21, -3.928388851917725e-22,
  1.124657242131811e-23, -2.248793021472941e-25,  4.017097431451962e-27,  7.678458567335471e-04, -7.547661622919871e-06,  7.374792603769019e-08, -7.144173552782113e-10,
  6.833364114693266e-12, -6.409571739852898e-14,  5.823694232635444e-16, -5.000044139316864e-18,  3.817952167536072e-20, -2.078030344800128e-22, -5.594874198699694e-25,
  4.680425522035053e-26,  7.075773607418134e-03, -6.998711455536834e-05,  6.916160604685069e-07, -6.825685287919112e-09,  6.723782093356775e-11, -6.605300811689303e-13,
  6.462476434217679e-15, -6.283247298635167e-17,  6.048223687438359e-19, -5.725101148446419e-21,  5.258432766574553e-23, -4.551625905795565e-25,  1.195570295726133e-02,
 -1.186014489865073e-04,  1.178053579749966e-06, -1.172101136327214e-08,  1.168749468430480e-10, -1.168865171876119e-12,  1.173748284768778e-14, -1.185407876791041e-16,
  1.207057257926900e-18, -1.244024581248932e-20,  1.305418517981297e-22, -1.406851411299493e-24,  1.019858947765358e-05, -9.540179419750171e-08,  8.784873055496961e-10,
 -7.896784869801195e-12,  6.826992963431985e-14, -5.507633674111882e-16,  3.842699955072903e-18, -1.693223964085639e-20, -1.147461085656491e-22,  4.996378118794215e-24,
 -1.035572359829499e-25,  1.803803945752323e-27,  7.387833828420159e-04, -6.990204290833744e-06,  6.579095320744762e-08, -6.146246404662324e-10,  5.680562207985368e-12,
 -5.166779139685520e-14,  4.583364680978307e-16, -3.899093421633047e-18,  3.067258187197841e-20, -2.015572767047373e-22,  6.283188366096677e-25,  1.283886698626677e-26,
  6.806396815230592e-03, -6.476448235173468e-05,  6.157524707427366e-07, -5.847699018258547e-09,  5.544625427786605e-11, -5.245321642266142e-13,  4.945824446168858e-15,
 -4.640626074580212e-17,  4.321716542806285e-19, -3.976905409562198e-21,  3.586845743174601e-23, -3.119689151965310e-25,  1.149929787809177e-02, -1.097095214446836e-04,
  1.047896661059569e-06, -1.002377991367005e-08,  9.606671247996268e-11, -9.230111220707769e-13,  8.898319445380128e-15, -8.618179704453895e-17,  8.400795918752176e-19,
 -8.264217786250775e-21,  8.238272197853934e-23, -8.372016374149313e-25,  9.830463094030632e-06, -8.873517743494875e-08,  7.899320738189925e-10, -6.887744038014250e-12,
  5.813697592831815e-14, -4.645016738847905e-16,  3.339322373231326e-18, -1.839212236974187e-20,  6.464164088494270e-24,  2.099568446757441e-24, -4.824747958779330e-26,
  8.371976220035800e-28,  7.118305919269291e-04, -6.491908363487350e-06,  5.892852996148425e-08, -5.314400289225258e-10,  4.748909450275930e-12, -4.187340880644770e-14,
  3.618518831612078e-16, -3.027999343649378e-18,  2.396265301898936e-20, -1.695743147158379e-22,  8.857458261158671e-25,  9.582330278191660e-28,  6.556766790666187e-03,
 -6.010482823012982e-05,  5.505764799195696e-07, -5.038450015237152e-09,  4.604490854373682e-11, -4.199851635120226e-13,  3.820367661354719e-15, -3.461540353460911e-17,
  3.118221483178343e-19, -2.784101057354939e-21,  2.450847695304113e-23, -2.106524986475456e-25,  1.107649946176679e-02, -1.017826908995271e-04,  9.362599881987100e-07,
 -8.623559994059446e-09,  7.956123668781758e-11, -7.356246313851957e-13,  6.821009328999855e-15, -6.348876331253479e-17,  5.940136163188284e-19, -5.597670244521350e-21,
  5.328288101293523e-23, -5.144515350294130e-25,  9.487659257245043e-06, -8.273119791740803e-08,  7.125673535539670e-10, -6.027692110513756e-12,  4.960704036124759e-14,
 -3.904561934387043e-16,  2.836314758229613e-18, -1.728611052513589e-20,  5.473371589528096e-23,  7.520268260340716e-25, -2.230235018068937e-26,  3.972911530464632e-28,
  6.867671688715173e-04, -6.044758260813061e-06,  5.298096176980621e-08, -4.617127057453862e-10,  3.991842992841796e-12, -3.412511844376468e-14,  2.869341911177736e-16,
 -2.352042640957412e-18,  1.849207855436414e-20, -1.347392943900509e-22,  8.296619639806122e-25, -2.733423283982144e-27,  6.324790657687422e-03, -5.593014534527378e-05,
  4.942734839391993e-07, -4.364257721008543e-09,  3.848904338150017e-11, -3.388858353790210e-13,  2.977015864010824e-15, -2.606829018083763e-17,  2.272129622096468e-19,
 -1.966909802263694e-21,  1.685020706280798e-23, -1.419634996823164e-25,  1.068372261405606e-02, -9.468596443076980e-05,  8.399568833079730e-07, -7.459953569202695e-09,
  6.635215480966758e-11, -5.912771956461751e-13,  5.281843208220501e-15, -4.733359227658826e-17,  4.259940102905553e-19, -3.855981870081977e-21,  3.517906558972187e-23,
 -3.244385254818189e-25,  9.167695734552461e-06, -7.730706546106175e-08,  6.447511631226296e-10, -5.292914638197948e-12,  4.244053620841249e-14, -3.279752351874920e-16,
  2.379842108380664e-18, -1.524400667142277e-20,  6.928274147934765e-23,  1.373769906565125e-25, -9.923463716212818e-27,  1.904055092858206e-28,  6.634022084641236e-04,
 -5.642036540983528e-06,  4.780225725387631e-08, -4.029503182508955e-10,  3.373197771724906e-12, -2.796637607135458e-14,  2.286764260649301e-16, -1.831758886931850e-18,
  1.420655721910857e-20, -1.042906361977524e-22,  6.878365492031206e-25, -3.439386842710863e-27,  6.108660899464635e-03, -5.217546388459519e-05,  4.453856054695660e-07,
 -3.799006914959855e-09,  3.237067212733207e-11, -2.754358599044147e-13,  2.339111449130314e-15, -1.981163183915967e-17,  1.671689437204070e-19, -1.402956728164989e-21,
  1.168082336438690e-23, -9.607212675390195e-26,  1.031787545807027e-02, -8.830719547312938e-05,  7.564381469661646e-07, -6.486460374841649e-09,  5.569435062503319e-11,
 -4.789958539878482e-13,  4.128265630101075e-15, -3.567680611133219e-17,  3.094216254130802e-19, -2.696261227315185e-21,  2.364360722569967e-23, -2.090936451529358e-25,
  8.868396894250332e-06, -7.239205129525817e-08,  5.851036821402709e-10, -4.663379363499967e-12,  3.641892556189283e-14, -2.757282892559054e-16,  1.984329908496920e-18,
 -1.301023623477857e-20,  6.877704489841817e-23, -1.266174925629468e-25, -3.995713521537746e-27,  9.078891770970724e-29,  6.415695157945576e-04, -5.278083242950991e-06,
  4.327314302580910e-08, -3.531721367597491e-10,  2.864849602177246e-12, -2.304552849333686e-14,  1.832234475033270e-16, -1.432204187469522e-18,  1.091125184535249e-20,
 -7.975266494537027e-23,  5.413545266239601e-25, -3.135368524149895e-27,  5.906808391324391e-03, -4.878632628968427e-05,  4.027327093499398e-07, -3.322273996122540e-09,
  2.738134602897356e-11, -2.253930477507109e-13,  1.852282696859610e-15, -1.518780939694540e-17,  1.241458869044338e-19, -1.010355693931418e-21,  8.171461972689107e-24,
 -6.547828594633367e-26,  9.976277184357363e-03, -8.255258623933083e-05,  6.836476987075122e-07, -5.666927444443716e-09,  4.702972658940318e-11, -3.908695978930098e-13,
  3.254548147026263e-15, -2.716236619319941e-17,  2.273816206955727e-19, -1.910948094959262e-21,  1.614301882450507e-23, -1.372980296105595e-25,  8.587849383908225e-06,
 -6.792556099254790e-08,  5.324654199826991e-10, -4.122324961048197e-12,  3.135235571941355e-14, -2.322322543354562e-16,  1.649990185193560e-18, -1.090639957103676e-20,
  6.214608548226148e-23, -2.234211936483672e-25, -1.195919333507788e-27,  4.214430702535414e-29,  6.211237678239039e-04, -4.948104664073866e-06,  3.929563121654809e-08,
 -3.107958616092451e-10,  2.444857595667575e-12, -1.909244125656969e-14,  1.476066291394616e-16, -1.125062789233506e-18,  8.398133637477618e-21, -6.069669526804904e-23,
  4.156090037716771e-25, -2.567338624333666e-27,  5.717864398370429e-03, -4.571681363193755e-05,  3.653527187261469e-07, -2.917956891496087e-09,  2.328577217685374e-11,
 -1.856239404229177e-13,  1.477592488976347e-15, -1.173924886024265e-17,  9.302363571196877e-20, -7.344939316939821e-22,  5.770343678528307e-24, -4.500564529940274e-26,
  9.656591825441469e-03, -7.734319285705226e-05,  6.199145237733388e-07, -4.972991589602077e-09,  3.993581684126590e-11, -3.211241709057221e-13,  2.586351460909581e-15,
 -2.087312922289522e-17,  1.688931977525670e-19, -1.371130091881837e-21,  1.117920069747046e-23, -9.165309440161278e-26,  2.000594680248230e+00, -1.898888105950232e-04,
 -1.591337048824199e-04,  6.750580113529529e-05, -1.999088056108763e-05,  5.185457256634876e-06, -1.255791407030679e-06,  2.917656134946906e-07, -6.596211581503360e-08,
  1.463180157098014e-08, -3.195803835464515e-09,  6.620902438441599e-10,  2.002235753744277e+00, -1.251868048029098e-03,  1.450764029460268e-04, -1.053860320261087e-05,
 -1.143802285709279e-06,  8.031378185759265e-07, -2.625890205226761e-07,  7.073077675202394e-08, -1.742483705578243e-08,  4.080470734308309e-09, -9.236564385229761e-10,
  1.958289602190323e-10,  2.003107877426020e+00, -1.813169919751421e-03,  3.021163818613422e-04, -4.990321121843597e-05,  8.150075705459217e-06, -1.311063667676290e-06,
  2.065432447868977e-07, -3.157009453852752e-08,  4.605394913634643e-09, -6.202006476578311e-10,  7.092846310580399e-11, -5.135750050202703e-12,  2.003534557590532e+00,
 -2.087004165203213e-03,  3.777823611337880e-04, -6.864159333217031e-05,  1.252272534396838e-05, -2.294677193977854e-06,  4.224806495833182e-07, -7.818259566322929e-08,
  1.454751499450735e-08, -2.722590671244344e-09,  5.120637124516630e-10, -9.363167935805474e-11,  2.001059281196079e+00, -5.916853903314688e-04,  6.722824034688409e-05,
 -5.039175428133714e-06, -3.644312484298067e-07,  2.948400111654967e-07, -9.446034926937667e-08,  2.448620036151745e-08, -5.762473639043502e-09,  1.282851618762338e-09,
 -2.750670234053550e-10,  5.530812370130654e-11,  2.001401906118844e+00, -8.103382535659427e-04,  1.261124065809766e-04, -1.921478067220575e-05,  2.842753708824243e-06,
 -4.027200977805518e-07,  5.318194319882909e-08, -6.147076243094634e-09,  4.977741611248298e-10,  1.870678438016969e-11, -2.257714759923530e-11,  7.064795626966939e-12,
  2.001591511957006e+00, -9.310235678649914e-04,  1.582310189055791e-04, -2.685607266962107e-05,  4.551427492804252e-06, -7.700720868892935e-07,  1.300487566327016e-07,
 -2.191644264068386e-08,  3.684707427621214e-09, -6.178104975858414e-10,  1.031949782749601e-10, -1.673019167233346e-11,  2.001686265321091e+00, -9.912503300540563e-04,
  1.741573600676118e-04, -3.062105899720547e-05,  5.388042072750337e-06, -9.488269048712782e-07,  1.672250749127946e-07, -2.949766505051428e-08,  5.207856969860218e-09,
 -9.202743508336356e-10,  1.626245835423268e-10, -2.791597406464651e-11,  2.000679731248356e+00, -3.919823362495248e-04,  5.994153746008604e-05, -8.966026844269649e-06,
  1.300725766679169e-06, -1.803604291807795e-07,  2.323447599376902e-08, -2.598049942851341e-09,  1.958377224352034e-10,  1.136761303689928e-11, -1.000357592569185e-11,
  2.993272890617777e-12,  2.000758519881261e+00, -4.419533376859800e-04,  7.302352348595202e-05, -1.202604854683149e-05,  1.973192170451280e-06, -3.223859290428493e-07,
  5.241641490391897e-08, -8.474262696512714e-09,  1.360976839153001e-09, -2.168497619180259e-10,  3.420505932042032e-11, -5.214043889157052e-12,  2.000802958090221e+00,
 -4.701019117024785e-04,  8.034908493013018e-05, -1.372941842201919e-05,  2.345306812689283e-06, -4.005134887672047e-07,  6.837507290405332e-08, -1.166901983554570e-08,
  1.990759732707555e-09, -3.394948776205666e-10,  5.782746288836939e-11, -9.576271957977001e-12,  2.000825394019194e+00, -4.843036774430820e-04,  8.403312224769923e-05,
 -1.458327474783911e-05,  2.531236914264442e-06, -4.394253279414107e-07,  7.629802901474402e-08, -1.325009203353473e-08,  2.301457228862316e-09, -3.998120399546366e-10,
  6.940923905554459e-11, -1.170890139175737e-11,  2.000373371994947e+00, -2.172782454051978e-04,  3.558811114679311e-05, -5.808532115407107e-06,  9.442775792777141e-07,
 -1.528134862950804e-07,  2.460109587294158e-08, -3.936473370988949e-09,  6.253901664654628e-10, -9.850888174784349e-11,  1.534888495547174e-11, -2.310188792120275e-12,
  2.000392289443510e+00, -2.292414173996685e-04,  3.867758699743039e-05, -6.521300917672516e-06,  1.098755629827111e-06, -1.849873371189394e-07,  3.111983888122201e-08,
 -5.230772089492578e-09,  8.784232572550431e-10, -1.473727540645695e-10,  2.468121960357486e-11, -4.019831165747276e-12,  2.000403058226024e+00, -2.360471677825072e-04,
  4.042997048437094e-05, -6.924387460034640e-06,  1.185856014003427e-06, -2.030741096995143e-07,  3.477350509254837e-08, -5.954056871646624e-09,  1.019405721043100e-09,
 -1.745179069344912e-10,  2.985038590909336e-11, -4.964207808888476e-12,  2.000408522576099e+00, -2.394993820875315e-04,  4.131742505737019e-05, -7.128188228895240e-06,
  1.229822088938153e-06, -2.121889662347947e-07,  3.661177988615514e-08, -6.317373850243697e-09,  1.090108821876445e-09, -1.881093361110968e-10,  3.243442006638863e-11,
 -5.435590825099523e-12,  2.000194611234382e+00, -1.136541039000534e-04,  1.909324532827999e-05, -3.205227172314775e-06,  5.376558338273897e-07, -9.011495713330638e-08,
  1.509089879277045e-08, -2.524851293989428e-09,  4.220202549402648e-10, -7.046463332923425e-11,  1.174393170376910e-11, -1.903795088192958e-12,  2.000199247556927e+00,
 -1.165818815977056e-04,  1.984429667375792e-05, -3.377334080640412e-06,  5.747040071926709e-07, -9.777875002932589e-08,  1.663308772538420e-08, -2.828963993035892e-09,
  4.810672150782262e-10, -8.178924070850687e-11,  1.389200072091411e-11, -2.294788697622169e-12,  2.000201898832742e+00, -1.182556019790415e-04,  2.027301482739287e-05,
 -3.475430335020087e-06,  5.957888847984030e-07, -1.021338467171054e-07,  1.750815520393723e-08, -3.001265425583935e-09,  5.144715527940604e-10, -8.818629919939416e-11,
  1.510360506199466e-11, -2.515019900585586e-12,  2.000203247515777e+00, -1.191068634036725e-04,  2.049088549217741e-05, -3.525241098368569e-06,  6.064864491357492e-07,
 -1.043416204215440e-07,  1.795139773476681e-08, -3.088468591122550e-09,  5.313639059995519e-10, -9.141860254894678e-11,  1.571530604094218e-11, -2.626123056724891e-12,
  2.000099233340100e+00, -5.804448788902911e-05,  9.859118066349349e-06, -1.674337286783935e-06,  2.842979344575125e-07, -4.826455794313188e-08,  8.192279322481180e-09,
 -1.390275226782753e-09,  2.358923735651211e-10, -4.001587366440022e-11,  6.781485130639420e-12, -1.117820239895103e-12,  2.000100381053460e+00, -5.876874383018433e-05,
  1.004429312583643e-05, -1.716629208586763e-06,  2.933712566515772e-07, -5.013515471912020e-08,  8.567432271911577e-09, -1.464004113264603e-09,  2.501593277628357e-10,
 -4.274288055633098e-11,  7.297005206919852e-12, -1.211359088009017e-12,  2.000101038857307e+00, -5.918378099540521e-05,  1.015032981612197e-05, -1.740828734015237e-06,
  2.985591428165321e-07, -5.120391063325877e-08,  8.781613206275379e-09, -1.506065559806740e-09,  2.582923499510550e-10, -4.429627332314455e-11,  7.590443322688403e-12,
 -1.264564921683517e-12,  2.000101373892703e+00, -5.939515123562898e-05,  1.020431023408730e-05, -1.753143000153422e-06,  3.011979834434492e-07, -5.174731369364998e-08,
  8.890467390092690e-09, -1.527433827238285e-09,  2.624224247618782e-10, -4.508478517685676e-11,  7.739333255350432e-12, -1.291551084748241e-12,  2.000050092070284e+00,
 -2.932218469653615e-05,  5.006194376167652e-06, -8.546765674988787e-07,  1.459077529138363e-07, -2.490790473585338e-08,  4.251851086274231e-09, -7.257727751378740e-10,
  1.238809568082225e-10, -2.114363320238723e-11,  3.605689866686900e-12, -5.979548713923390e-13,  2.000050377593722e+00, -2.950229909028791e-05,  5.052169331904492e-06,
 -8.651592577676959e-07,  1.481529557118953e-07, -2.537001102444098e-08,  4.344372350985979e-09, -7.439254931611061e-10,  1.273877122880386e-10, -2.181279380521157e-11,
  3.731977937284842e-12, -6.208333138665258e-13,  2.000050541423892e+00, -2.960563863839160e-05,  5.078537432074493e-06, -8.711691697121401e-07,  1.494396879097214e-07,
 -2.563474607086695e-08,  4.397356742844874e-09, -7.543171507210918e-10,  1.293944259206637e-10, -2.219557189436274e-11,  3.804191128555242e-12, -6.339109218945596e-13,
  2.000050624918275e+00, -2.965830232152770e-05,  5.091972351829031e-06, -8.742306753683821e-07,  1.500950261703241e-07, -2.576954891293169e-08,  4.424330767626455e-09,
 -7.596063847730532e-10,  1.304156087755979e-10, -2.239032095251831e-11,  3.840924045319675e-12, -6.405618669582456e-13,  2.000025164079102e+00, -1.473553257816689e-05,
  2.522072941072557e-06, -4.316633880103385e-07,  7.388027905605157e-08, -1.264467151800968e-08,  2.164124597176667e-09, -3.703843425006039e-10,  6.338964293501912e-11,
 -1.084849046573766e-11,  1.855088773426774e-12, -3.084469202816776e-13,  2.000025235285337e+00, -1.478044318511406e-05,  2.533527115916574e-06, -4.342728701600025e-07,
  7.443871712694263e-08, -1.275951293367670e-08,  2.187098513255320e-09, -3.748880654004188e-10,  6.425894719579702e-11, -1.101423259879636e-11,  1.886342552422738e-12,
 -3.141044491223369e-13,  2.000025276165657e+00, -1.480622587422738e-05,  2.540101616815940e-06, -4.357703887345362e-07,  7.475913113924222e-08, -1.282539291446960e-08,
  2.200275263689646e-09, -3.774707018187967e-10,  6.475735141636460e-11, -1.110924080656394e-11,  1.904254770974473e-12, -3.173463320112713e-13,  2.000025297006347e+00,
 -1.481936954422447e-05,  2.543452868112316e-06, -4.365336474344984e-07,  7.492242363056979e-08, -1.285896383628807e-08,  2.206989137412205e-09, -3.787864813948771e-10,
  6.501124784461443e-11, -1.115763475080530e-11,  1.913377703810007e-12, -3.189973066871481e-13,  2.000012611450409e+00, -7.386308678094389e-06,  1.265757706790422e-06,
 -2.169065467478351e-07,  3.717009657505585e-08, -6.369622065834476e-09,  1.091522223534472e-09, -1.870468636733496e-10,  3.205286913080414e-11, -5.492523989315613e-12,
  9.404224097061457e-13, -1.565551383472732e-13,  2.000012629230201e+00, -7.397521624822366e-06,  1.268616322796024e-06, -2.175575244225917e-07,  3.730935001832093e-08,
 -6.398247251663582e-09,  1.097246274292117e-09, -1.881685170144648e-10,  3.226927909925352e-11, -5.533767612670723e-12,  9.481964284006501e-13, -1.579618341440586e-13,
  2.000012639440651e+00, -7.403960789133252e-06,  1.270257764323892e-06, -2.179312864191286e-07,  3.738929556563233e-08, -6.414679457431984e-09,  1.100531840285765e-09,
 -1.888122777960158e-10,  3.239347356674038e-11, -5.557434488137600e-12,  9.526569843066922e-13, -1.587688933892463e-13,  2.000012644646720e+00, -7.407243932044840e-06,
  1.271094645076409e-06, -2.181218373033946e-07,  3.743005120257069e-08, -6.423056038647818e-09,  1.102206623672910e-09, -1.891404112134084e-10,  3.245677385443227e-11,
 -5.569496558223158e-12,  9.549302358224177e-13, -1.591801784096054e-13,  2.000006313065442e+00, -3.697781505755319e-06,  6.340563360786890e-07, -1.087211874393243e-07,
  1.864233322024050e-08, -3.196583729213780e-09,  5.481149410540007e-10, -9.398464939805611e-11,  1.611542051307932e-11, -2.763221488973537e-12,  4.734080698829101e-13,
 -7.885607434864915e-14,  2.000006317507673e+00, -3.700582907047740e-06,  6.347703752256002e-07, -1.088837581198092e-07,  1.867710218085161e-08, -3.203729409278973e-09,
  5.495435327747432e-10, -9.426452990400212e-11,  1.616940892622082e-11, -2.773508504830717e-12,  4.753466682291663e-13, -7.920679206893632e-14,  2.000006320059083e+00,
 -3.702191885674574e-06,  6.351804630702561e-07, -1.089771215549437e-07,  1.869706886513571e-08, -3.207832748432705e-09,  5.503638494815936e-10, -9.442523351860683e-11,
  1.620040688638199e-11, -2.779414614665546e-12,  4.764596283095898e-13, -7.940813220683762e-14,  2.000006321360088e+00, -3.703012325000279e-06,  6.353895669212554e-07,
 -1.090247263596602e-07,  1.870724935563994e-08, -3.209924879705197e-09,  5.507820858798084e-10, -9.450716572664021e-11,  1.621621029863910e-11, -2.782425595645114e-12,
  4.770270094097501e-13, -7.951077184683649e-14,  2.000003158366223e+00, -1.850046492481466e-06,  3.173221861204710e-07, -5.442747258210381e-08,  9.335462371892751e-09,
 -1.601228947563955e-09,  2.746445386914331e-10, -4.710732332534042e-11,  8.079891274458585e-12, -1.385836906886357e-12,  2.375004351375928e-13, -3.957211459645833e-14,
  2.000003159476441e+00, -1.850746613551629e-06,  3.175006191195504e-07, -5.446809355800169e-08,  9.344149068822264e-09, -1.603014042377429e-09,  2.750013844718825e-10,
 -4.717722696301260e-11,  8.093374144846833e-12, -1.388405680751651e-12,  2.379844727981939e-13, -3.965967478246549e-14,  2.000003160114144e+00, -1.851148756717193e-06,
  3.176031070400545e-07, -5.449142479263555e-08,  9.349138279689802e-09, -1.604039288839914e-09,  2.752063294810362e-10, -4.721737333828017e-11,  8.101117313185321e-12,
 -1.389880884449557e-12,  2.382624409820914e-13, -3.970995684239227e-14,  2.000003160439331e+00, -1.851353823274634e-06,  3.176553684713829e-07, -5.450332188285688e-08,
  9.351682351035061e-09, -1.604562070192338e-09,  2.753108312231797e-10, -4.723784376496078e-11,  8.105065463012061e-12, -1.390633063589205e-12,  2.384041699985154e-13,
 -3.973559409507188e-14,   0.00236557393197109,   0.00140156272866512,  0.000152441763999115,  2.11276982745998e-06,     0.001180372276852,  0.000699440296306974,
  7.60945708142681e-05,  1.05512635079642e-06,  0.000589597319328102,  0.000349381776192051,  3.80127462300183e-05,  5.27140270467066e-07,  0.000294653191581159,
  0.000174605966471654,  1.89974081207868e-05,  2.63452507046361e-07,  0.000147290439042951,  8.72817150806627e-05,  9.49642378086976e-06,  1.31695449419359e-07,
  7.36362062119254e-05,  4.36355359802923e-05,   4.7476370748696e-06,    6.583985440821e-08,  3.68158529883847e-05,  2.18164370469998e-05,  2.37367424844841e-06,
  3.29179387949113e-08,  1.84073643644874e-05,  1.09078857193128e-05,   1.1868009793416e-06,  1.64584697110011e-08,  9.20354169968314e-06,   5.4538596501056e-06,
  5.93391444401758e-07,  8.22910961211336e-09,  4.60173573542869e-06,  2.72690902160497e-06,  2.96693459754507e-07,  4.11452345506579e-09,  2.30085908988916e-06,
  1.36344930980819e-06,  1.48346164124643e-07,    2.057253884772e-09  };
  int offset = -4;
  const int ibox0 = static_cast<int>(log(64.0) / log(2.0));
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 4;
    if (std::isnan(t)) {
      fill_n(rr+offset, 4, 0.5);
      fill_n(ww+offset, 4, 0.0);
    } else if (t >= 131072.0) {
      for (int r = 0; r != 4; ++r) {
        ww[offset+r] = aw[4-r-1] / t;
        rr[offset+r] = 1.0 - ax[4-r-1] / t;
      }
    } else {
      assert(t >= 0);
      int it;
      double bigT = 0.0;
      if (t >= 64.0 && t < 131072.0) {
        bigT = t;
        it = static_cast<int>(log(bigT) / log(2.0) + 32 - ibox0);
        t = (t - 1.5 * pow(2.0, it + ibox0 - 32))* 2/pow(2.0, it + ibox0 - 32);
      } else {
        it = static_cast<int>(t*   0.500000000000000);
        t = (t - it *2.000000000000000-   1.000000000000000) *   1.000000000000000;
      }
      const double t2 = t * 2.0;
      for (int j=1; j <=4; ++j) {
        const int boxof = it*48+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
        if (64.0 <= bigT && bigT < 131072.0) {
          const int iref = 2064 + (it - 32) * 4 + 4 - j;
          double rr_infty = x[iref];
          double ww_infty = w[iref];
          double Tref = pow(2.0, it + ibox0 + 1 - 32);
          ww[offset+j-1] = ww[offset+j-1] * ww_infty * Tref / bigT;
          rr[offset+j-1] = 1.0 + rr[offset+j-1] * (1.0 - rr_infty) * Tref /bigT;
        }
      }
    }
  }
}
