//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_33.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot33(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[33] = {1.855222618056198e-02,1.670321941188209e-01,4.643244925475531e-01,9.110979560398486e-01,1.508366233501695e+00,
    2.257500616913155e+00,3.160247754575606e+00,4.218752814451578e+00,5.435588864603597e+00,6.813793487276037e+00,8.356913959982837e+00,1.006906274759950e+01,
    1.195498559144905e+01,1.402014520885833e+01,1.627082460919169e+01,1.871425540902916e+01,2.135877847180310e+01,2.421404698949139e+01,2.729128621874753e+01,
    3.060363022289268e+01,3.416656540478311e+01,3.799852551994479e+01,4.212170716337780e+01,4.656321582263151e+01,5.135672509620531e+01,5.654496614935641e+01,
    6.218362931592237e+01,6.834782121814082e+01,7.514352697150539e+01,8.272995836692951e+01,9.136932782071482e+01,1.015631899531887e+02,1.146016551280458e+02
    };
  constexpr double aw[33] = {2.674182693914649e-01,2.306479519911901e-01,1.715235179844312e-01,1.099070531338047e-01,6.062045914959792e-02,
    2.874185509873280e-02,1.169394485127456e-02,4.074134947858974e-03,1.212359660023294e-03,3.072156112196417e-04,6.606113021988665e-05,1.200527834425012e-05,
    1.835197922109159e-06,2.347099657371962e-07,2.495859186183891e-08,2.191009567643582e-09,1.574798821673825e-10,9.179567058508876e-12,4.291642055815669e-13,
    1.588553267628721e-14,4.584863443711685e-16,1.013236235241152e-17,1.677515186381405e-19,2.025903860076360e-21,1.726654820633059e-23,9.959264561605881e-26,
    3.681349235478935e-28,8.103684036750887e-31,9.581157150898418e-34,5.213309240720354e-37,1.013560915043634e-40,4.356574890965814e-45,1.228776879713511e-50
    };
  constexpr double x[12672] = {  1.099144062344638e-03, -8.198129980245287e-06,  4.583479802665874e-08, -2.276212185937735e-10,  1.058771995132634e-12,
 -4.722690774973654e-15,  2.045412054332527e-17, -8.665150250334849e-20,  3.607447434565098e-22, -1.480506001548603e-24,  6.002591085090272e-27, -2.407921754268054e-29,
  9.878225169354542e-03, -7.335939563803956e-05,  4.065834014962050e-07, -1.989806574577067e-09,  9.052335898564596e-12, -3.912265260471289e-14,  1.622896510981707e-16,
 -6.492436243826585e-19,  2.507990734904774e-21, -9.340679013939495e-24,  3.338343495096877e-26, -1.134349527160025e-28,  2.736145569677046e-02, -2.014374169822094e-04,
  1.096961381689517e-06, -5.209967522915724e-09,  2.262142315533198e-11, -9.122039890796157e-14,  3.420118727000060e-16, -1.178886654847329e-18,  3.619998153685416e-21,
 -9.071997882925634e-24,  1.231219441550400e-26,  4.762901058875926e-29,  5.339952748840136e-02, -3.880176504167360e-04,  2.057121442829599e-06, -9.323045748802488e-09,
  3.749656639544385e-11, -1.335617338519068e-13,  4.049909303500369e-16, -9.057329222853090e-19,  3.419604303069922e-22,  1.157039341294628e-23, -8.902120086560451e-26,
  4.600255480639964e-28,  8.776986489134672e-02, -6.266622207091934e-04,  3.203095245511389e-06, -1.358403080704842e-08,  4.856778307486036e-11, -1.379351000115251e-13,
  2.284846279080074e-16,  5.276899014752391e-19, -7.224880836413528e-21,  4.164615179264045e-23, -1.710252211964403e-25,  4.921412111587340e-28,  1.301782844892736e-01,
 -9.091243992687022e-04,  4.433277671953061e-06, -1.717548920687705e-08,  5.112043712278736e-11, -8.617890129775119e-14, -2.043032739005934e-16,  2.681908040108438e-18,
 -1.432021684393698e-20,  4.955791233571921e-23, -7.965054230704105e-26, -3.698873090878111e-28,  1.802612009213241e-01, -1.225624314730572e-03,  5.636309568707475e-06,
 -1.932715518539100e-08,  4.202521162700142e-11,  2.176756858016071e-14, -7.741979836461447e-16,  4.406883889445480e-18, -1.416387379114447e-20,  1.001457499857798e-23,
  2.033856145382047e-25, -1.531927660175741e-27,  2.375883722184056e-01, -1.565177412917255e-03,  6.699773148951953e-06, -1.943123880652136e-08,  2.061655821317816e-11,
  1.653693745393806e-13, -1.257758966862833e-15,  4.407157030715734e-18, -3.013555489645071e-21, -6.610510868178129e-23,  4.624192996580364e-25, -1.506383789680538e-27,
  3.016661759160314e-01, -1.915965451030176e-03,  7.519048141200827e-06, -1.713748198041970e-08, -1.094440144034232e-11,  3.076942456562128e-13, -1.412120677737169e-15,
  2.009707030188866e-18,  1.585373338427481e-20, -1.277422718462131e-22,  3.927918063858750e-25,  4.631506287690799e-28,  3.719414046922553e-01, -2.265738335314523e-03,
  8.005656987002687e-06, -1.241450036274280e-08, -4.792039869135176e-11,  4.053705936603792e-13, -1.080419189298479e-15, -2.289918162956510e-18,  3.246733764167624e-20,
 -1.160428822136160e-22, -9.789046944641766e-26,  3.037051034486292e-27,  4.478055673797293e-01, -2.602233940287545e-03,  8.094456314957617e-06, -5.568299240571223e-09,
 -8.383044378577685e-11,  4.215158252666324e-13, -2.738523101993392e-16, -6.848760132662040e-18,  3.539018680691872e-20, -1.287888500487962e-23, -7.139876611701876e-25,
  3.544419606892279e-27,  5.285996778720652e-01, -2.913602225624586e-03,  7.749108718991331e-06,  2.785490364076705e-09, -1.117065972578189e-10,  3.377785571043118e-13,
  8.070222167208438e-16, -9.531586088848353e-18,  1.905314278813069e-20,  1.328854744897343e-22, -9.396716135865404e-25,  6.261730497284587e-28,  6.136195106591601e-01,
 -3.188819533996762e-03,  6.965389375011424e-06,  1.179286331933109e-08, -1.255215020236506e-10,  1.617152578009857e-13,  1.826439791019820e-15, -8.726000306504487e-18,
 -1.145847610383226e-20,  2.278900908294642e-22, -4.663171630444794e-25, -3.833563996947613e-27,  7.021212974725355e-01, -3.418078943120136e-03,  5.772038827402574e-06,
  2.046737437579961e-08, -1.214882492375174e-10, -7.303714333897033e-14,  2.427461246911441e-15, -4.221608197558026e-18, -4.172001130764057e-20,  1.961697626466637e-22,
  4.786599876954607e-25, -5.869551212200428e-27,  7.933278348076501e-01, -3.593142983005051e-03,  4.229056017021050e-06,  2.781698597727138e-08, -9.895160243437190e-11,
 -3.142592591842053e-13,  2.364640111113323e-15,  2.517442994363541e-18, -5.533043690968288e-20,  3.792492159492924e-23,  1.228739003266723e-24, -3.076040985215766e-27,
  8.864349669451369e-01, -3.707645929002430e-03,  2.423521559862453e-06,  3.297485535614215e-08, -6.066766175792834e-11, -5.044816525068868e-13,  1.603850980239744e-15,
  8.880719190998390e-18, -4.333721937955665e-20, -1.604050816771407e-22,  1.179080444447281e-24,  2.723893263203870e-27,  9.806184035713590e-01, -3.757334243580095e-03,
  4.632360343737255e-07,  3.531613428962572e-08, -1.239304899727239e-11, -5.964769404688746e-13,  3.480315387374280e-16,  1.223684277779883e-17, -1.005380881240490e-20,
 -2.777104675817523e-22,  2.955893643741570e-25,  6.705053612576624e-27,  1.075040825282026e+00, -3.740235550108358e-03, -1.531363478067753e-06,  3.454436490657907e-08,
  3.815045110930854e-11, -5.664442415141919e-13, -1.024918332593417e-15,  1.113525200222722e-17,  2.856011499705634e-20, -2.386398954807000e-22, -8.123358838693293e-25,
  5.349630991566914e-27,  1.168859224250979e+00, -3.656748747998772e-03, -3.436397787902016e-06,  3.073490276689692e-08,  8.273473324770026e-11, -4.209554315494179e-13,
 -2.091557753893305e-15,  5.998399125214270e-18,  5.338462274545902e-20, -6.614359533612200e-23, -1.349018621249903e-24, -2.237932185599753e-28,  1.261232421298885e+00,
 -3.509650468986062e-03, -5.134136521980925e-06,  2.432852636181204e-08,  1.142109435241257e-10, -1.954831087477036e-13, -2.531811958804141e-15, -1.048923587783949e-18,
  5.265570945947758e-20,  1.327791336560271e-22, -9.551451679745209e-25, -5.233041912124134e-27,  1.351328694670903e+00, -3.304015958101645e-03, -6.522221820807541e-06,
  1.607525510628559e-08,  1.278910227176512e-10,  5.520322003911001e-14, -2.240635274645060e-15, -7.144922301854314e-18,  2.829269907412084e-20,  2.390824134603170e-22,
  2.345418874844762e-26, -5.634019278746389e-27,  1.438333450221649e+00, -3.047055549508292e-03, -7.521772353282428e-06,  6.935453997131845e-09,  1.224316780649346e-10,
  2.720435681734404e-13, -1.359465191992034e-15, -9.985566904586125e-18, -5.699478046257787e-21,  2.000758980946608e-22,  8.407775829929008e-25, -1.676111656710998e-27,
  1.521456857624499e+00, -2.747871088623227e-03, -8.083688857378764e-06, -2.048460219193464e-09,  1.000297336807662e-10,  4.077085036294196e-13, -2.158820605564832e-16,
 -8.818536204102201e-18, -3.164247584494775e-20,  5.871475186289032e-23,  9.564239468118751e-25,  2.739595487685402e-27,  1.599941372901032e+00, -2.417139804859202e-03,
 -8.192614930783323e-06, -9.891917249293303e-09,  6.588476490327274e-11,  4.389105643555907e-13,  8.036867341450500e-16, -4.663091697625643e-18, -3.816475505880937e-20,
 -8.437839823174303e-23,  4.240383787278732e-25,  3.981768485780948e-27,  1.673069064245592e+00, -2.066736130567316e-03, -7.868189353386207e-06, -1.579989872142685e-08,
  2.704469259087978e-11,  3.714045614456703e-13,  1.396931812481687e-15,  3.180613675856842e-19, -2.573059545874222e-20, -1.444222568686128e-22, -2.388553690301273e-25,
  1.840554694212361e-27,  1.740168656047564e+00, -1.709304653607931e-03, -7.163445122564023e-06, -1.927150618708431e-08, -9.113107183114450e-12,  2.363311987766802e-13,
  1.447676332004204e-15,  3.937649016222804e-18, -4.746383260730777e-21, -1.059242763504421e-22, -5.334021220597210e-25, -9.780341248781414e-28,  1.800622205460072e+00,
 -1.357799648057872e-03, -6.160447949516196e-06, -2.016211792234311e-08, -3.643031368704911e-11,  7.924860329676053e-14,  1.048455668534430e-15,  5.002023497803903e-18,
  1.192070679639393e-20, -2.004445510012794e-23, -3.636403711909430e-25, -1.950599054761413e-27,  1.853871327200281e+00, -1.025008324154695e-03, -4.963502945062355e-06,
 -1.869388260265618e-08, -5.120328213124914e-11, -5.453560002846972e-14,  4.391176195475171e-16,  3.722436766479678e-18,  1.680884298493330e-20,  4.461109961258531e-23,
 -1.429227264117096e-26, -9.629369969714805e-28,  1.899422886334760e+00, -7.230759639177582e-04, -3.690471530575748e-06, -1.541282410681089e-08, -5.283361028022799e-11,
 -1.336100588841889e-13, -1.079147208980946e-16,  1.364674309014998e-18,  1.114301651867070e-20,  5.415504131413904e-23,  1.838913986171517e-25,  3.206360461597392e-28,
  1.936854088775075e+00, -4.630513608844110e-04, -2.462911235761484e-06, -1.109875341859959e-08, -4.375499090266585e-11, -1.487818691712910e-13, -4.038266881528962e-16,
 -5.991647679209684e-19,  2.059874441968721e-21,  2.451168184357503e-23,  1.436608219276135e-25,  6.334797331578456e-28,  1.965816932485066e+00, -2.544702842484219e-04,
 -1.395861553180820e-06, -6.641292391022747e-09, -2.866426823489573e-11, -1.135936033468268e-13, -4.109534080041288e-16, -1.321252288046196e-18, -3.491897421136745e-21,
 -5.408284572701127e-24,  1.474248178646031e-26,  1.967649259411565e-28,  1.986042181910475e+00, -1.049919491455246e-04, -5.881315464235854e-07, -2.900466868997430e-09,
 -1.324556422902710e-11, -5.717602908505028e-14, -2.353546237160661e-16, -9.261867752427609e-19, -3.476968526078524e-21, -1.235951482901343e-23, -4.094221354615029e-26,
 -1.220851131210364e-28,  1.997345759214841e+00, -2.008080111419507e-05, -1.137921384887644e-07, -5.721700972198653e-10, -2.691210617642616e-12, -1.211933977120325e-14,
 -5.289374863776598e-17, -2.253111957548120e-19, -9.407898766908461e-22, -3.861171536889720e-24, -1.560282656976498e-26, -6.213984271928709e-29,  1.067067997297048e-03,
 -7.842096437746832e-06,  4.320195273853216e-08, -2.114106270909792e-10,  9.690371814440717e-13, -4.259649974431563e-15,  1.818179838503224e-17, -7.591609641266040e-20,
  3.115248656211863e-22, -1.260307525488302e-24,  5.037570813404703e-27, -1.992461642377258e-29,  9.591145095317156e-03, -7.019983502783598e-05,  3.835495949044507e-07,
 -1.851023220441761e-09,  8.307405461826077e-12, -3.543707967212817e-14,  1.451856400520571e-16, -5.741198978705494e-19,  2.194604422820961e-21, -8.100265253625388e-24,
  2.875411803477520e-26, -9.738433595342402e-29,  2.657286996082087e-02, -1.929057871549524e-04,  1.036554637125666e-06, -4.862185024102597e-09,  2.087649069432549e-11,
 -8.339542824519826e-14,  3.105764071285997e-16, -1.068173472247140e-18,  3.302710254863197e-21, -8.544717495123614e-24,  1.388898558318930e-26,  2.523928256774276e-29,
  5.187967641363656e-02, -3.719981856294362e-04,  1.948758100659193e-06, -8.743951051354022e-09,  3.492048327679876e-11, -1.241446799980693e-13,  3.798415476757837e-16,
 -8.887748503657243e-19,  6.990419125744366e-22,  8.388710977712678e-24, -7.067133239510865e-26,  3.764605662921242e-28,  8.531345152217014e-02, -6.016764894893825e-04,
  3.044659323587650e-06, -1.282871337902561e-08,  4.586498487749613e-11, -1.322989511500444e-13,  2.402394174222542e-16,  3.192034913697364e-19, -5.843607955316915e-21,
  3.523047663178280e-23, -1.499703201334671e-25,  4.631567429067336e-28,  1.266114334532855e-01, -8.744688292158510e-04,  4.232021689947197e-06, -1.637159262755075e-08,
  4.935364817529097e-11, -9.023121489051166e-14, -1.353616505410868e-16,  2.251563021183099e-18, -1.259690509783689e-20,  4.610032250907982e-23, -9.198400011497831e-26,
 -1.988016706540726e-28,  1.754474319249978e-01, -1.181450084039989e-03,  5.408429335606019e-06, -1.865223750567507e-08,  4.228448720853549e-11,  4.616699482485008e-15,
 -6.570859955423174e-16,  3.960851706156731e-18, -1.367238394638844e-20,  1.688631634123902e-23,  1.422413293370691e-25, -1.251950357553884e-27,  2.314333903979593e-01,
 -1.512506078571394e-03,  6.468681417983527e-06, -1.907651315972509e-08,  2.363201379008688e-11,  1.366509925810270e-13, -1.136041703025409e-15,  4.276086977315298e-18,
 -5.076359844000953e-21, -4.893165682758817e-23,  3.964405465231478e-25, -1.481094700123823e-27,  2.941213128325589e-01, -1.856638186082064e-03,  7.312544862944627e-06,
 -1.726518261907967e-08, -5.124588833826242e-12,  2.745317980661581e-13, -1.349415943969205e-15,  2.446510140629571e-18,  1.154137144061918e-20, -1.117706862201071e-22,
  4.023697642455966e-25, -6.299814907506888e-30,  3.630055807600391e-01, -2.202301402874190e-03,  7.852345550687533e-06, -1.311779605091706e-08, -4.007689066667966e-11,
  3.787846416981632e-13, -1.130623485140017e-15, -1.318309876027410e-18,  2.824977211417278e-20, -1.174773282404418e-22,  2.146974557414728e-26,  2.392524661396776e-27,
  4.375256883793973e-01, -2.537767731942538e-03,  8.019865872536518e-06, -6.842563817727320e-09, -7.548072596238085e-11,  4.127695394086213e-13, -4.498700241518478e-16,
 -5.728899877028606e-18,  3.444996169134836e-20, -3.833287504831025e-23, -5.593822462006172e-25,  3.453237833988397e-27,  5.170694241959827e-01, -2.851505516714412e-03,
  7.772036867899719e-06,  1.053192286956027e-09, -1.047785845376492e-10,  3.540175361199522e-13,  5.493414614730213e-16, -8.852527980938549e-18,  2.316949222883564e-20,
  9.610944321910720e-23, -8.931260583500174e-25,  1.450446516740388e-27,  6.009765271535918e-01, -3.132564242540224e-03,  7.094967889034945e-06,  9.812691684478068e-09,
 -1.218688243484090e-10,  2.025838868634951e-13,  1.578184248130651e-15, -8.965316630038124e-18, -3.627770410050798e-21,  2.062002860470866e-22, -6.098396718304557e-25,
 -2.690689589184966e-27,  6.885428430695416e-01, -3.370953333995935e-03,  6.005946380905721e-06,  1.851499903545067e-08, -1.223767275444237e-10, -1.634074826618234e-14,
  2.291650760486954e-15, -5.440460933327617e-18, -3.437490867207865e-20,  2.102210354396802e-22,  2.262072739210341e-25, -5.554372181643332e-27,  7.790250032610089e-01,
 -3.558002691914247e-03,  4.553163128903788e-06,  2.618658273346846e-08, -1.046645918796336e-10, -2.568605167834973e-13,  2.410611726324354e-15,  7.779148655312207e-19,
 -5.311608664630546e-20,  8.404036222852148e-23,  1.069518519592838e-24, -4.107123535224813e-27,  8.716456413733430e-01, -3.686692217886659e-03,  2.813069769458997e-06,
  3.192562878529815e-08, -7.035306042733222e-11, -4.631670196960492e-13,  1.832294051285322e-15,  7.410844465718535e-18, -4.823813919022768e-20, -1.113023147656979e-22,
  1.264660235048383e-24,  1.160892557163871e-27,  9.655991564499398e-01, -3.751937454889660e-03,  8.854480249238953e-07,  3.502297875161206e-08, -2.421153382130147e-11,
 -5.840581009820109e-13,  6.846756305841976e-16,  1.175800996432998e-17, -1.976882082208587e-20, -2.601415369649172e-22,  5.782963172378777e-25,  6.079717774955615e-27,
  1.060058020142007e+00, -3.750818820639555e-03, -1.113546544439960e-06,  3.506291231401676e-08,  2.660133989791214e-11, -5.872057140256003e-13, -7.016698154639690e-16,
  1.190592707254986e-17,  1.944375555971241e-20, -2.661194718321002e-22, -5.546793895584764e-25,  6.304427657875971e-27,  1.154179613651572e+00, -3.682742808396163e-03,
 -3.059922921310304e-06,  3.198863878441778e-08,  7.382824208421407e-11, -4.689468892340793e-13, -1.900118458386935e-15,  7.658203117717704e-18,  5.003412421958577e-20,
 -1.198236440150905e-22, -1.323016308574807e-24,  1.417453499416095e-27,  1.247113565644783e+00, -3.549525045139215e-03, -4.831369687206591e-06,  2.612131617171009e-08,
  1.096922692974014e-10, -2.564044888428195e-13, -2.536928583930150e-15,  7.047274549769379e-19,  5.669436870362318e-20,  9.017218608983497e-23, -1.169448539240076e-24,
 -4.443279184990938e-27,  1.338009546205217e+00, -3.355387269468460e-03, -6.317014432870030e-06,  1.812735611934148e-08,  1.284416924347700e-10, -8.624669948175239e-16,
 -2.426725640600370e-15, -6.102161861146125e-18,  3.685476522578880e-20,  2.348417569532278e-22, -2.404764898527010e-25, -6.317565616127237e-27,  1.426025454304322e+00,
 -3.106863123610581e-03, -7.426619918295189e-06,  8.936019728565621e-09,  1.275235530790839e-10,  2.360475271707866e-13, -1.640486290857979e-15, -1.004638257117295e-17,
  2.087387259902101e-21,  2.318511332132414e-22,  7.383619576030482e-25, -2.996030004789647e-27,  1.510335917790955e+00, -2.812611100022309e-03, -8.098399584132487e-06,
 -3.831186132757534e-10,  1.081115095517454e-10,  3.994521095450532e-13, -4.766051803190083e-16, -9.789666297238995e-18, -2.881260461438523e-20,  9.920977812522358e-23,
  1.063526816696760e-24,  2.080099412905154e-27,  1.590141006244614e+00, -2.483136941955091e-03, -8.304700051948135e-06, -8.766534223249875e-09,  7.484456043517087e-11,
  4.564915623216189e-13,  6.555910644083497e-16, -5.929341448451295e-18, -4.085362471219866e-20, -6.378050489678373e-23,  6.088901404706160e-25,  4.397219550475603e-27,
  1.664675039045740e+00, -2.130432107998891e-03, -8.054940815795793e-06, -1.530593601918179e-08,  3.480826735179477e-11,  4.049398859139295e-13,  1.393516447807551e-15,
 -5.901769584878857e-19, -3.108019165517616e-20, -1.521286271755303e-22, -1.406277586054604e-25,  2.641397912971467e-27,  1.733215354666550e+00, -1.767539353977747e-03,
 -7.395415859941215e-06, -1.937757800922007e-08, -4.030214494808198e-12,  2.723776452132693e-13,  1.555201041672201e-15,  3.720555488639901e-18, -8.953280804657533e-21,
 -1.280313827262253e-22, -5.694623646184054e-25, -6.355533508764520e-28,  1.795090893560741e+00, -1.408060792779670e-03, -6.405833809984524e-06, -2.073090759339725e-08,
 -3.458214810575702e-11,  1.061345531489200e-13,  1.193723314019195e-15,  5.368960980604140e-18,  1.091594168284054e-20, -3.637867136406714e-23, -4.548056414506851e-25,
 -2.188426096047794e-27,  1.849690437355020e+00, -1.065627660366325e-03, -5.192779090540234e-06, -1.952125165332206e-08, -5.217984301703457e-11, -4.268377978538131e-14,
  5.511163518850504e-16,  4.285816924581166e-18,  1.839348382297601e-20,  4.309695006532509e-23, -6.388501561534330e-26, -1.302126890227919e-27,  1.896470343003038e+00,
 -7.533541263955044e-04, -3.880586047620667e-06, -1.627966646131891e-08, -5.552839983760027e-11, -1.356993356376323e-13, -6.440840579661239e-17,  1.753890295878532e-18,
  1.322823187057778e-20,  6.177383970553289e-23,  1.965040041501308e-25,  2.456638758131349e-28,  1.934961616142087e+00, -4.832995218895192e-04, -2.600396672948205e-06,
 -1.182317052131020e-08, -4.682886349318051e-11, -1.586667241505635e-13, -4.195395886530038e-16, -5.179646067429660e-19,  3.052733499215104e-21,  3.084707670436536e-23,
  1.739094371518402e-25,  7.433741490680047e-28,  1.964776201585816e+00, -2.659639315968499e-04, -1.478385574189262e-06, -7.118644350311794e-09, -3.103783172370514e-11,
 -1.239132280015748e-13, -4.495411968865713e-16, -1.435976335466461e-18, -3.673726549374538e-21, -4.626744547402719e-24,  2.482701507366320e-26,  2.644475846748991e-28,
  1.985612578370224e+00, -1.098399156662967e-04, -6.242474779828779e-07, -3.121860012618754e-09, -1.444773727624069e-11, -6.314873422105969e-14, -2.629147405871459e-16,
 -1.044895685212741e-18, -3.952722996889892e-21, -1.410892856562688e-23, -4.663616183424793e-26, -1.368654619609937e-28,  1.997263570792951e+00, -2.101935327647556e-05,
 -1.209247640739469e-07, -6.172397427685881e-10, -2.946821061162430e-12, -1.346802907733120e-14, -5.964572344512330e-17, -2.577665222701581e-19, -1.091717756781300e-21,
 -4.543599095655601e-24, -1.861303361310822e-26, -7.512121744446987e-29,  1.036375139345914e-03, -7.506371271964966e-06,  4.075531628670530e-08, -1.965645700969339e-10,
  8.880412846683396e-13, -3.847708721404889e-15,  1.618915769159475e-17, -6.663599883025400e-20,  2.695792058010047e-22, -1.075289502408335e-24,  4.238037084333532e-27,
 -1.653006677465605e-29,  9.316344991504332e-03, -6.721808042981142e-05,  3.621120373773541e-07, -1.723590669949107e-09,  7.632246215682927e-12, -3.213785462061428e-14,
  1.300511623993472e-16, -5.083444532826387e-19,  1.922703839246595e-21, -7.031582683243101e-24,  2.478052788400255e-26, -8.357866801561455e-29,  2.581747001303516e-02,
 -1.848411807131088e-04,  9.801588035592276e-07, -4.541109407630089e-09,  1.928075837872573e-11, -7.628883851061412e-14,  2.821016955615009e-16, -9.672994210647236e-19,
  3.005320717375439e-21, -7.972073848673925e-24,  1.462645686855961e-26,  9.186282665423548e-30,  5.042221242513178e-02, -3.568185176268829e-04,  1.847102700397504e-06,
 -8.204599566618188e-09,  3.252675008620602e-11, -1.153243231538101e-13,  3.553107138111268e-16, -8.620881003661444e-19,  9.539465871753319e-22,  5.871630360013675e-24,
 -5.569194347382261e-26,  3.065120265181079e-28,  8.295450248078076e-02, -5.779227169124914e-04,  2.895031506471036e-06, -1.211572550770434e-08,  4.327728288823942e-11,
 -1.264459517559368e-13,  2.467418196407733e-16,  1.513822643324497e-19, -4.678472551095698e-21,  2.962878157200928e-23, -1.303840208837448e-25,  4.262086912548831e-28,
  1.231800450120804e-01, -8.413852061451659e-04,  4.040240460909207e-06, -1.559652712795874e-08,  4.752141462896482e-11, -9.276741202204925e-14, -7.771695419172191e-17,
  1.874291082688519e-18, -1.100525852919384e-20,  4.228623909607954e-23, -9.779777525191074e-26, -7.201895896449094e-29,  1.708067651278637e-01, -1.139066453740722e-03,
  5.188662168705258e-06, -1.797576705316342e-08,  4.222785077965194e-11, -9.871359194365114e-15, -5.522087595540858e-16,  3.534056876777292e-18, -1.297464383862752e-20,
  2.155009654335276e-23,  9.276740843665503e-26, -1.002139809211433e-27,  2.254854245080241e-01, -1.461665673665783e-03,  6.242117434796829e-06, -1.867797782034660e-08,
  2.610198041263152e-11,  1.108028794388707e-13, -1.018829207444777e-15,  4.088393070292354e-18, -6.567982547097821e-21, -3.435634925691167e-23,  3.329322483831547e-25,
 -1.398037340542127e-27,  2.868104472202218e-01, -1.798967543857785e-03,  7.105046267385779e-06, -1.730498659603416e-08,  4.793629803923219e-14,  2.430059693946326e-13,
 -1.276325918777437e-15,  2.754553094581354e-18,  7.806246289192654e-21, -9.579177766127152e-23,  3.940557007134171e-25, -3.525525106870156e-28,  3.543210010822785e-01,
 -2.140122627474400e-03,  7.691329808705682e-06, -1.369990585437780e-08, -3.277502600942090e-11,  3.513049801682449e-13, -1.155513730632511e-15, -4.816233979178898e-19,
  2.405975591117092e-20, -1.146948186659506e-22,  1.132526246285450e-25,  1.788344815485561e-27,  4.275023871082085e-01, -2.473957155446287e-03,  7.930779341012838e-06,
 -7.984851253069374e-09, -6.734565927372593e-11,  4.001708973276530e-13, -5.950821797246251e-16, -4.652605641244955e-18,  3.270328635436012e-20, -5.773216625890326e-23,
 -4.123761918792584e-25,  3.207754426888638e-27,  5.057877952414598e-01, -2.789306625967908e-03,  7.774852176660837e-06, -5.659886488049119e-10, -9.758602372723438e-11,
  3.643140164620130e-13,  3.123223781551879e-16, -8.062503585208055e-18,  2.600352339377835e-20,  6.185094357449205e-23, -8.155116181335461e-25,  2.039316983400621e-27,
  5.885604890588980e-01, -3.075366317673822e-03,  7.201160920141163e-06,  7.897176369384473e-09, -1.174587550494852e-10,  2.374415297717223e-13,  1.326611288035576e-15,
 -8.967553623871798e-18,  3.330834432451261e-21,  1.797686725571197e-22, -7.037054650367349e-25, -1.588415015225168e-27,  6.751564850143014e-01, -3.322050335153860e-03,
  6.216376951821669e-06,  1.655729124820124e-08, -1.221664978272377e-10,  3.671361899624563e-14,  2.125065336954508e-15, -6.418093415895619e-18, -2.670159221039611e-20,
  2.145374726294412e-22, -6.089843041997171e-27, -4.965868164851719e-27,  7.648677926035047e-01, -3.520349269663219e-03,  4.857194987368384e-06,  2.447399900725772e-08,
 -1.092224708145902e-10, -1.989334420295640e-13,  2.409108911005498e-15, -8.655035978554072e-19, -4.936625506335477e-20,  1.229786586206652e-22,  8.723825743691827e-25,
 -4.795369153124034e-27,  8.569462800420994e-01, -3.662675053735038e-03,  3.189125655578501e-06,  3.072832977583969e-08, -7.916075836130621e-11, -4.168796991744575e-13,
  2.017654692140150e-15,  5.812949462801114e-18, -5.132633599339303e-20, -6.015234907651488e-23,  1.281634347834545e-24, -3.756503686126892e-28,  9.506082250854614e-01,
 -3.743180234665005e-03,  1.303017178934510e-06,  3.454314827235843e-08, -3.570211206104063e-11, -5.637551596163430e-13,  1.003670376219179e-15,  1.098053833988079e-17,
 -2.865546394738720e-20, -2.319268818859792e-22,  8.252187017023393e-25,  5.090072948255674e-27,  1.045039601927432e+00, -3.758037835569320e-03, -6.906280751743345e-07,
  3.539378035529665e-08,  1.471615279123745e-11, -5.999840811056269e-13, -3.610606187281893e-16,  1.237111530589459e-17,  9.532792006097732e-21, -2.825608379936654e-22,
 -2.632283086979992e-25,  6.874900424393021e-27,  1.139402142178248e+00, -3.705667384345232e-03, -2.669289068782128e-06,  3.309245750752924e-08,  6.401156147949187e-11,
 -5.118000000088935e-13, -1.663993937019818e-15,  9.180214318340759e-18,  4.478739288802223e-20, -1.710074761829956e-22, -1.224137000415025e-24,  3.068267068983000e-27,
  1.232840190350242e+00, -3.586892754342647e-03, -4.507563350955032e-06,  2.783207003986601e-08,  1.039579860099208e-10, -3.168463120160461e-13, -2.491375617204921e-15,
  2.561494386635300e-18,  5.905429358689674e-20,  3.980189431533759e-23, -1.340547445046764e-24, -3.274484136518961e-27,  1.324488351869126e+00, -3.405018357845848e-03,
 -6.087166729422386e-06,  2.017906515766916e-08,  1.278289108436339e-10, -6.101321014378464e-14, -2.579820701498985e-15, -4.789949176052978e-18,  4.506767573519842e-20,
  2.195300081234196e-22, -5.277691549518216e-25, -6.681237817026186e-27,  1.413479904452685e+00, -3.165812123183424e-03, -7.306996819283083e-06,  1.101192958300584e-08,
  1.318280741736273e-10,  1.933157288978408e-13, -1.919556047839446e-15, -9.840621810063801e-18,  1.093019629553599e-20,  2.583442505696975e-22,  5.762330660629695e-25,
 -4.375790790146872e-27,  1.498955912190167e+00, -2.877386677398957e-03, -8.092356936425779e-06,  1.409861357046902e-09,  1.159634401728431e-10,  3.846236687751273e-13,
 -7.630274608756687e-16, -1.064615055279238e-17, -2.445559215556014e-20,  1.433204089206687e-22,  1.134994857766368e-24,  1.117619894126334e-27,  1.580074946681124e+00,
 -2.549974279162740e-03, -8.402409491865428e-06, -7.495186846117277e-09,  8.411751395766049e-11,  4.700838183699739e-13,  4.709576319688274e-16, -7.268310544548501e-18,
 -4.266389028799179e-20, -3.546995065939758e-23,  8.083788160840874e-25,  4.635085669405455e-27,  1.656023282502256e+00, -2.195596224327293e-03, -8.234997328183227e-06,
 -1.468240391993790e-08,  4.323956807330688e-11,  4.380685019185800e-13,  1.362237898289416e-15, -1.673212249470759e-18, -3.662773846644737e-20, -1.551726960800711e-22,
 -5.088452265214404e-27,  3.531459273822546e-27,  1.726025396916002e+00, -1.827633473457090e-03, -7.628147262973546e-06, -1.939641825461520e-08,  1.798838911631377e-12,
  3.109157845729229e-13,  1.654640998571349e-15,  3.355861455934766e-18, -1.397793445608465e-20, -1.512317049927421e-22, -5.868256126985123e-25, -1.232261749988068e-28,
  1.789354568445887e+00, -1.460311781473985e-03, -6.657849354900530e-06, -2.126563201349519e-08, -3.216058825425834e-11,  1.366260152565908e-13,  1.348721540105626e-15,
  5.693613811777272e-18,  9.255078267363000e-21, -5.655800833094933e-23, -5.555765017754802e-25, -2.382188431312993e-27,  1.845343338516517e+00, -1.108121166090106e-03,
 -5.432069104286011e-06, -2.036219787489044e-08, -5.289118070820416e-11, -2.794902897088762e-14,  6.795885487469253e-16,  4.898620218022108e-18,  1.988413286271200e-20,
  3.928089705619629e-23, -1.298826184674104e-25, -1.709252011968401e-27,  1.893393578270613e+00, -7.851955492135430e-04, -4.081362557411176e-06, -1.718989915652016e-08,
 -5.825361061649367e-11, -1.366058873796506e-13, -9.027980682556086e-18,  2.214311728094896e-18,  1.559588857345091e-20,  6.981762537999895e-23,  2.047796814216263e-25,
  1.210643282432455e-28,  1.932985894842044e+00, -5.046831896603853e-04, -2.746876795237994e-06, -1.259837081148829e-08, -5.010400063743480e-11, -1.688975959819910e-13,
 -4.324980759733455e-16, -4.011005903878896e-19,  4.296641499121061e-21,  3.849244142877089e-23,  2.092385872755567e-25,  8.641287976188293e-28,  1.963688138501540e+00,
 -2.781413456348748e-04, -1.566872657763084e-06, -7.635675887483817e-09, -3.362731224616616e-11, -1.351981354330125e-13, -4.914178985224464e-16, -1.555984755728253e-18,
 -3.819393459418892e-21, -3.376907849064881e-24,  3.829757925899045e-26,  3.514028568770987e-28,  1.985162987809202e+00, -1.149877728192459e-04, -6.631395974415033e-07,
 -3.363480658030093e-09, -1.577625722969689e-11, -6.982454847971085e-14, -2.940216335956935e-16, -1.179881643115800e-18, -4.495714713623332e-21, -1.609931841552428e-23,
 -5.299549592277884e-26, -1.522566313340412e-28,  1.997177510514178e+00, -2.201720142124986e-05, -1.286236835320913e-07, -6.666240693703260e-10, -3.231102293425618e-12,
 -1.499024008341594e-14, -6.737792877132093e-17, -2.954690233890494e-19, -1.269525406228264e-21, -5.358677007770292e-24, -2.225671153777793e-26, -9.103861761629393e-29,
  1.006987133877373e-03, -7.189528008249071e-06,  3.847932061202184e-08, -1.829510495598613e-10,  8.148262679029318e-13, -3.480618466958470e-15,  1.443852702107514e-17,
 -5.859748379851290e-20,  2.337527782495625e-22, -9.194556976813159e-25,  3.573895973558220e-27, -1.374888249934183e-29,  9.053138337229698e-03, -6.440188828325362e-05,
  3.421409703983812e-07, -1.606451917807172e-09,  7.019583440313162e-12, -2.918070519522789e-14,  1.166421574416368e-16, -4.506837901597109e-19,  1.686555784772179e-21,
 -6.110289710794400e-24,  2.137041904789019e-26, -7.172575047427474e-29,  2.509344996060886e-02, -1.772127527839272e-04,  9.274672597381025e-07, -4.244464643653849e-09,
  1.782054723324215e-11, -6.983280431353567e-14,  2.563213591058968e-16, -8.756075885345336e-19,  2.728920997632719e-21, -7.382552249086387e-24,  1.476763251969095e-26,
 -2.089958568235748e-30,  4.902388071116814e-02, -3.424268418501414e-04,  1.751695438115459e-06, -7.702168274436015e-09,  3.030360158086633e-11, -1.070828975777562e-13,
  3.316284744721210e-16, -8.285844005656869e-19,  1.128312770347264e-21,  3.895767725085099e-24, -4.352464378263931e-26,  2.483444410112561e-28,  8.068822768981522e-02,
 -5.553324383656357e-04,  2.753715010677057e-06, -1.144319743336855e-08,  4.080784184762160e-11, -1.204892505204379e-13,  2.490379509691239e-16,  1.776673358428896e-20,
 -3.701300695063585e-21,  2.477666369814915e-23, -1.125186271711605e-25,  3.855101106722397e-28,  1.198779807604051e-01, -8.097991315143990e-04,  3.857582683479059e-06,
 -1.485111147768616e-08,  4.565146541567534e-11, -9.404127263724466e-14, -2.994371640056953e-17,  1.545720276673021e-18, -9.553862430598249e-21,  3.834009350012296e-23,
 -9.884653861482476e-26,  1.912557580470952e-29,  1.663321679393230e-01, -1.098408526753360e-03,  4.976998080031741e-06, -1.730238812882421e-08,  4.190566939283659e-11,
 -2.198310223928326e-14, -4.589465521534413e-16,  3.131915060637906e-18, -1.214206650681831e-20,  2.444521883161269e-23,  5.357026441715048e-26, -7.849888437704781e-28,
  2.197372264005733e-01, -1.412618017403807e-03,  6.020556422726657e-06, -1.824390774586243e-08,  2.808266420021125e-11,  8.769987482552117e-14, -9.074649570354935e-16,
  3.860880228770723e-18, -7.579626883682704e-21, -2.223620407846463e-23,  2.739463640996452e-25, -1.278665731731249e-27,  2.797269430980191e-01, -1.742957441348480e-03,
  6.897546095644141e-06, -1.726697629771790e-08,  4.608117546812726e-12,  2.133248260743127e-13, -1.196198169513944e-15,  2.952183894228709e-18,  4.637004401032009e-21,
 -8.041739098772549e-23,  3.729228910783429e-25, -5.918427692280049e-28,  3.458825187625285e-01, -2.079257975115357e-03,  7.524011507487162e-06, -1.416960733195375e-08,
 -2.602690845883536e-11,  3.234940449257597e-13, -1.158834067542580e-15,  2.232428680204672e-19,  2.002974307262812e-20, -1.087552595025003e-22,  1.797864622475249e-25,
  1.247736589056668e-27,  4.177328190417851e-01, -2.410911908590774e-03,  7.828757425893029e-06, -8.999172635957507e-09, -5.949501054292620e-11,  3.844418771124688e-13,
 -7.110376377805963e-16, -3.642267349179448e-18,  3.036116235495898e-20, -7.150118617198150e-23, -2.786207905343329e-25,  2.858907435204733e-27,  4.947548866172064e-01,
 -2.727160963379028e-03,  7.758933615501580e-06, -2.068742556600504e-09, -9.024257790621970e-11,  3.691966178859847e-13,  9.851276251189057e-17, -7.200877246945047e-18,
  2.766576486386448e-20,  3.114844480719428e-23, -7.169434927132327e-25,  2.406305795429803e-27,  5.763747979336421e-01, -3.017409542900862e-03,  7.284813078525622e-06,
  6.057471754706038e-09, -1.124117892517602e-10,  2.662849295156831e-13,  1.077945474952313e-15, -8.762971161400671e-18,  9.281771639307765e-21,  1.505258586146312e-22,
 -7.511558085068370e-25, -5.896335877961564e-28,  6.619689572429898e-01, -3.271557725348609e-03,  6.403369499343327e-06,  1.461120980115028e-08, -1.209372347579444e-10,
  8.546927908499479e-14,  1.934554737213938e-15, -7.149432302426896e-18, -1.903331302763735e-20,  2.101429406605554e-22, -2.079279940946464e-25, -4.183361120852082e-27,
  7.508659283541277e-01, -3.480346948346608e-03,  5.140276468135895e-06,  2.269774020502505e-08, -1.126258208325443e-10, -1.415798245753435e-13,  2.363469874472403e-15,
 -2.368073890563870e-18, -4.436293404848147e-20,  1.535298207940774e-22,  6.527279649221726e-25, -5.131748230961257e-27,  8.423489099794045e-01, -3.635709236689913e-03,
  3.549999705177251e-06,  2.939773988994075e-08, -8.700189784240261e-11, -3.666900800182301e-13,  2.157167761252450e-15,  4.145695123522969e-18, -5.257692651926417e-20,
 -9.643422519426532e-24,  1.233584769413460e-24, -1.778444967317907e-27,  9.356589628728912e-01, -3.731108584984607e-03,  1.713739997470411e-06,  3.388312501404762e-08,
 -4.671199788996413e-11, -5.360887044492276e-13,  1.297080468132329e-15,  9.936761359836033e-18, -3.635991633100867e-20, -1.947957102191212e-22,  1.022076411496834e-24,
  3.819879456193609e-27,  1.029999094908755e+00, -3.761860870368003e-03, -2.648871518299517e-07,  3.553288879614831e-08,  2.658012356692823e-12, -6.044678276456823e-13,
 -1.193895443553658e-17,  1.251197414376163e-17, -7.553007720366852e-22, -2.869672116887082e-22,  4.391474578599288e-26,  7.012731447218585e-27,  1.124539302580114e+00,
 -3.725416639378298e-03, -2.266379039855919e-06,  3.403267487632367e-08,  5.339783530064538e-11, -5.484953704807220e-13, -1.387874385685861e-15,  1.050575231832418e-17,
  3.778652821035278e-20, -2.168087045740606e-22, -1.054741863188681e-24,  4.601637625127925e-27,  1.218422652815064e+00, -3.621589547792790e-03, -4.163818110048685e-06,
  2.944148189283071e-08,  9.703004694696801e-11, -3.755641769472136e-13, -2.393057338308522e-15,  4.463551501748406e-18,  5.949102376616636e-20, -1.628223038797730e-23,
 -1.452744512053702e-24, -1.777344903575283e-27,  1.310772466315262e+00, -3.452712441900394e-03, -5.832797655307908e-06,  2.221115895493263e-08,  1.259794987038693e-10,
 -1.243682226861185e-13, -2.692593251870257e-15, -3.225985480929678e-18,  5.251967248790651e-20,  1.925191843287664e-22, -8.225120458070983e-25, -6.644633798746907e-27,
  1.400700631905827e+00, -3.223703390765932e-03, -7.162078943009327e-06,  1.314951332521564e-08,  1.352116180480748e-10,  1.439882012485824e-13, -2.188769155490582e-15,
 -9.338001432469310e-18,  2.059541394172293e-20,  2.771417487941211e-22,  3.538673515935401e-25, -5.715937359421156e-27,  1.487317040211035e+00, -2.942025739835310e-03,
 -8.064055761909353e-06,  3.325718320817650e-09,  1.234482058401864e-10,  3.626505543897262e-13, -1.071237205064128e-15, -1.133733920212459e-17, -1.847016922755275e-20,
  1.893524931741662e-22,  1.157382768447539e-24, -1.487467017435327e-28,  1.569740074626170e+00, -2.617529725939971e-03, -8.483964403806946e-06, -6.073551065803036e-09,
  9.361493416332997e-11,  4.787894297196285e-13,  2.481863614266951e-16, -8.647344748369310e-18, -4.330943856820256e-20,  9.606446802596481e-25,  1.013051194382739e-24,
  4.620168400300378e-27,  1.647108039281311e+00, -2.262168519862388e-03, -8.406740346787265e-06, -1.391872189012914e-08,  5.232337397916251e-11,  4.700624110181285e-13,
  1.298140494606280e-15, -2.934398314136168e-18, -4.217767529523515e-20, -1.519939340939353e-22,  1.708730483085298e-25,  4.470518155288467e-27,  1.718591339869855e+00,
 -1.889588703588115e-03, -7.860519314912215e-06, -1.931570168219834e-08,  8.421596379503624e-12,  3.516990011807246e-13,  1.741492233638959e-15,  2.816928507293381e-18,
 -1.984435850133297e-20, -1.746193167876604e-22, -5.773840629404302e-25,  5.870908669748048e-28,  1.783405167481136e+00, -1.514603854960470e-03, -6.916028335869021e-06,
 -2.175652775057187e-08, -2.909129726293828e-11,  1.709398130087233e-13,  1.511951130750832e-15,  5.952702258735050e-18,  6.793330218322708e-21, -8.091825126846614e-23,
 -6.632751933698275e-25, -2.496744085578980e-27,  1.840822372860767e+00, -1.152569527311752e-03, -5.681508477337099e-06, -2.121199448259099e-08, -5.327557296857903e-11,
 -9.919799381527050e-15,  8.258625546214925e-16,  5.556380463709551e-18,  2.118538136635836e-20,  3.244610412361804e-23, -2.153311316471007e-25, -2.186193502362443e-27,
  1.890186165197397e+00, -8.186876174229837e-04, -4.293323831821313e-06, -1.814380351569892e-08, -6.098257150278776e-11, -1.360197763033418e-13,  6.034887590391918e-17,
  2.755183498751431e-18,  1.825759589176444e-20,  7.806465099460302e-23,  2.061851495407454e-25, -6.961164647027104e-29,  1.930922234995453e+00, -5.272768145156472e-04,
 -2.902980538045849e-06, -1.342762593651110e-08, -5.358657584599272e-11, -1.793954429013289e-13, -4.415837178107340e-16, -2.397444891045314e-19,  5.842524968238788e-21,
  4.765992208175472e-23,  2.500756794607559e-25,  9.931474120425579e-28,  1.962549909655949e+00, -2.910521957075238e-04, -1.661820337982452e-06, -8.196000456809398e-09,
 -3.645281603638834e-11, -1.475288877793770e-13, -5.367125438874959e-16, -1.679822739524848e-18, -3.909384820793513e-21, -1.505004423048934e-24,  5.610622636025921e-26,
  4.625225267907126e-28,  1.984692164658617e+00, -1.204587364935729e-04, -7.050632435917008e-07, -3.627467637623186e-09, -1.724607570568371e-11, -7.729431490691622e-14,
 -3.291625234180642e-16, -1.333440223768068e-18, -5.115103033932394e-21, -1.835768656365062e-23, -6.003531552332180e-26, -1.676750033314934e-28,  1.997087331794607e+00,
 -2.307909107495953e-05, -1.369435442371950e-07, -7.208109030976316e-10, -3.547772426058903e-12, -1.671136316361673e-14, -7.625008193238733e-17, -3.393604130653213e-19,
 -1.479477255564181e-21, -6.334526089953891e-24, -2.667815259878327e-26, -1.106056896268700e-28,  9.788310927633130e-04, -6.890258631912889e-06,  3.635989363070623e-08,
 -1.704524434121477e-10,  7.485504880412098e-13, -3.152966949815697e-15,  1.289773269031358e-17, -5.162055133868308e-20,  2.030862641108060e-22, -7.878938231093874e-25,
  3.020827724761715e-27, -1.146411223522695e-29,  8.800885587538564e-03, -6.174000427276945e-05,  3.235186493613847e-07, -1.498659577555465e-09,  6.462971980208272e-12,
 -2.652682208803058e-14,  1.047466608226995e-16, -4.000745371642652e-19,  1.481239961240199e-21, -5.315485996649436e-24,  1.844375960251889e-26, -6.156283155018360e-29,
  2.439912255214708e-02, -1.699920058350528e-04,  8.781994272435050e-07, -3.970183054916429e-09,  1.648347236595178e-11, -6.396566957097643e-14,  2.329877598687445e-16,
 -7.924207940717041e-19,  2.473736552431315e-21, -6.796177347341196e-24,  1.449514043890945e-26, -9.789437611456350e-30,  4.768162653146919e-02, -3.287748998380672e-04,
  1.662109269287222e-06, -7.234019282398125e-09,  2.823967682748921e-11, -9.939802048189560e-14,  3.089524030234785e-16, -7.905499675019071e-19,  1.239719833059538e-21,
  2.358492902540276e-24, -3.368921283125210e-26,  2.002490931713137e-28,  7.851010312492702e-02, -5.338410730579522e-04,  2.620235723229894e-06, -1.080922555979795e-08,
  3.845780045736814e-11, -1.145189600551068e-13,  2.480053236438921e-16, -8.723972828316470e-20, -2.886377729995600e-21,  2.060292526693068e-23, -9.647106047213796e-26,
  3.439706952455824e-28,  1.166993942142815e-01, -7.796390493247314e-04,  3.683689731450701e-06, -1.413575957147704e-08,  4.376678593477435e-11, -9.427385845778056e-14,
  9.258392797810143e-18,  1.261320378077510e-18, -8.244397080920632e-21,  3.442342070488285e-23, -9.652886493456209e-26,  8.214204969054012e-29,  1.620168668630940e-01,
 -1.059411695558871e-03,  4.773375998898673e-06, -1.663598414473803e-08,  4.136273994718779e-11, -3.198857542050274e-14, -3.765577045716528e-16,  2.757798817427002e-18,
 -1.123127207401982e-20,  2.595389237451132e-23,  2.320772523367603e-26, -6.003853106603793e-28,  2.141817076467623e-01, -1.365321509312919e-03,  5.804379613547905e-06,
 -1.778170021926296e-08,  2.962748206327024e-11,  6.718989694775969e-14, -8.028618735631536e-16,  3.607531304681320e-18, -8.196085879107348e-21, -1.236361811332180e-23,
  2.206965076928588e-25, -1.139699988319210e-27,  2.728641639643826e-01, -1.688604319777459e-03,  6.690920578445816e-06, -1.716064591401207e-08,  8.594297736256443e-12,
  1.856221978082854e-13, -1.111874646217626e-15,  3.057072534149927e-18,  2.003740459159068e-21, -6.607135242950986e-23,  3.432873362005226e-25, -7.420168543992353e-28,
  3.376847847976308e-01, -2.019752621617504e-03,  7.351686256289941e-06, -1.453578655722656e-08, -1.983428226850489e-11,  2.958258989454543e-13, -1.144188050982394e-15,
  8.030383171745139e-19,  1.625592373426653e-20, -1.006082450250829e-22,  2.241817600858995e-25,  7.833855954892213e-28,  4.082137255056647e-01, -2.348729413949515e-03,
  7.715306471409563e-06, -9.890542027762461e-09, -5.198452566032453e-11,  3.662605085872278e-13, -7.998202314607960e-16, -2.713806681847708e-18,  2.761576874557254e-20,
 -8.024719982879860e-23, -1.616510672910925e-25,  2.451555942914400e-27,  4.839701945644692e-01, -2.665212778398456e-03,  7.725689320277667e-06, -3.453490624755718e-09,
 -8.285081336441403e-11,  3.692423122818203e-13, -9.058720314164034e-17, -6.302954914026228e-18,  2.829702815974220e-20,  4.651761679997944e-24, -6.066484848044044e-25,
  2.577394456341549e-27,  5.644221345176583e-01, -2.958870442161165e-03,  7.346891282756106e-06,  4.302811598729749e-09, -1.068470642189217e-10,  2.892496242972025e-13,
  8.375136031376214e-16, -8.385085309576216e-18,  1.415602879060786e-20,  1.202232972683066e-22, -7.577616568274263e-25,  2.627080306231160e-28,  6.489862444571399e-01,
 -3.219662180251041e-03,  6.567158434946074e-06,  1.269234257711604e-08, -1.187800972203021e-10,  1.294344832366098e-13,  1.726967547577394e-15, -7.639405904271048e-18,
 -1.165989737503559e-20,  1.984024792142675e-22, -3.725655252583621e-25, -3.288068910991768e-27,  7.370284665055186e-01, -3.438166074596377e-03,  5.401753744009015e-06,
  2.087613090143566e-08, -1.148963621078438e-10, -8.580736058530558e-14,  2.278153472646553e-15, -3.694659099249756e-18, -3.842057512453105e-20,  1.750987937549202e-22,
  4.256929173540455e-25, -5.136260242748655e-27,  8.278650731358274e-01, -3.605922350961341e-03,  3.894187597689053e-06,  2.794988810419499e-08, -9.380955943577487e-11,
 -3.137152028563509e-13,  2.249707471534805e-15,  2.467026809738331e-18, -5.205813455901796e-20,  3.776861524087123e-23,  1.128402807529169e-24, -2.960213253810493e-27,
  9.207645044930877e-01, -3.715785784073796e-03,  2.115505058769894e-06,  3.305174240041233e-08, -5.710064203024036e-11, -5.017576887528103e-13,  1.558024347150778e-15,
  8.669236143474821e-18, -4.259993774773125e-20, -1.509679137456355e-22,  1.158765328410095e-24,  2.373458308205771e-27,  1.014950113542319e+00, -3.762274584242570e-03,
  1.613640087905364e-07,  3.547880551588159e-08, -9.405886917977737e-12, -6.005625890674781e-13,  3.365107797574295e-16,  1.232345110211164e-17, -1.098061195628876e-20,
 -2.790976136448976e-22,  3.473367993068833e-25,  6.707230546425659e-27,  1.109603979832644e+00, -3.741900424056716e-03, -1.853228339490976e-06,  3.479757357152269e-08,
  4.211933960820604e-11, -5.781452796536500e-13, -1.078013963424288e-15,  1.158231727281321e-17,  2.927449098104446e-20, -2.545471648974085e-22, -8.227574915809502e-25,
  5.893774001300736e-27,  1.203871947568400e+00, -3.653461100274437e-03, -3.801463298059251e-06,  3.093079818126052e-08,  8.895566098062945e-11, -4.312836260466055e-13,
 -2.241594737435449e-15,  6.346547053299682e-18,  5.784454714594447e-20, -7.545820307591056e-23, -1.493376499101838e-24, -3.859564871926651e-29,  1.296870027931245e+00,
 -3.498274633079040e-03, -5.554263248029072e-06,  2.420339366197515e-08,  1.228396031253976e-10, -1.898783178336859e-13, -2.758398673004921e-15, -1.441380596494996e-18,
  5.878864224302122e-20,  1.538821298670965e-22, -1.105753978552974e-24, -6.151831633924118e-27,  1.387692276628612e+00, -3.280331868226970e-03, -6.991218920337494e-06,
  1.533299573220950e-08,  1.375453232110671e-10,  8.840394997562688e-14, -2.439490040128874e-15, -8.517096669905571e-18,  3.076335132783859e-20,  2.859026130618090e-22,
  7.554677869581767e-26, -6.898663845508074e-27,  1.475420213232867e+00, -3.006344431926314e-03, -8.012061587456023e-06,  5.357407760377858e-09,  1.304180896321828e-10,
  3.330713446442375e-13, -1.395869060468211e-15, -1.181042108924334e-17, -1.082567292445906e-20,  2.350814175865278e-22,  1.117826127911365e-24, -1.690630166505682e-27,
  1.559133787611834e+00, -2.685666778917066e-03, -8.547543165264852e-06, -4.498867312448181e-09,  1.032298671252282e-10,  4.816841089698204e-13, -1.327867856004810e-17,
 -1.002447905098352e-17, -4.249710169842508e-20,  4.547364993542726e-23,  1.210105026181549e-24,  4.276637474068149e-27,  1.637923820581301e+00, -2.330075583987038e-03,
 -8.568426324105253e-06, -1.300467588908632e-08,  6.202871123494939e-11,  5.000743116506348e-13,  1.196270866975543e-15, -4.369911952997340e-18, -4.747650249054894e-20,
 -1.409486520082194e-22,  3.881544023587712e-25,  5.397803606166757e-27,  1.710905752710575e+00, -1.953397171649906e-03, -8.091259714441509e-06, -1.912238794384058e-08,
  1.587952725755535e-11,  3.943635791934994e-13,  1.810499506636306e-15,  2.076936513717104e-18, -2.653783175413766e-20, -1.969408101920068e-22, -5.319196456625996e-25,
  1.516900647795096e-27,  1.777234431299797e+00, -1.570984034891521e-03, -7.179780070828320e-06, -2.219260947706138e-08, -2.529601715490991e-11,  2.092484327192260e-13,
  1.681194521581234e-15,  6.118143879269431e-18,  3.376149269533225e-21, -1.096543171059783e-22, -7.734647428307194e-25, -2.487171188880912e-27,  1.836119558035743e+00,
 -1.199054269634588e-03, -5.941169776878051e-06, -2.206485960503940e-08, -5.326275981179186e-11,  1.184546713026945e-14,  9.910948700451810e-16,  6.251141906074397e-18,
  2.217381409900605e-20,  2.175366744937066e-23, -3.232481988836937e-25, -2.729374766419231e-27,  1.886841318928246e+00, -8.539219040093785e-04, -4.516993244411856e-06,
 -1.914118167809225e-08, -6.368188211866579e-11, -1.335769887351572e-13,  1.461071953572659e-16,  3.385973238324722e-18,  2.121497265007139e-20,  8.617635501988017e-23,
  1.973876682152564e-25, -3.462847324356063e-28,  1.928765638607732e+00, -5.511600368454819e-04, -3.069376632082675e-06, -1.431429212735762e-08, -5.728089236588492e-11,
 -1.900512231649109e-13, -4.454069061497742e-16, -2.331318680935966e-20,  7.749222535859492e-21,  5.857587657241751e-23,  2.966875962306954e-25,  1.125591430817558e-27,
  1.961358474552321e+00, -3.047503104706401e-04, -1.763771494252245e-06, -8.803566255315966e-09, -3.953608785181044e-11, -1.609885791576614e-13, -5.855038001949073e-16,
 -1.805314690817113e-18, -3.917911517273385e-21,  1.185422797741549e-24,  7.944295012079780e-26,  6.037548156643979e-28,  1.984198766232223e+00, -1.262781721619309e-04,
 -7.503009186451761e-07, -3.916214202334765e-09, -1.887408349572588e-11, -8.566137517922027e-14, -3.688931568667302e-16, -1.508175715500019e-18, -5.821023225741355e-21,
 -2.091103032967318e-23, -6.773769238885612e-26, -1.821812971994007e-28,  1.996992768155303e+00, -2.421022941000841e-05, -1.459452218724821e-07, -7.803518398603137e-10,
 -3.901097948636490e-12, -1.866095833655935e-14, -8.645078720208395e-17, -3.905682429836655e-19, -1.727962003760928e-21, -7.505718104372690e-24, -3.205695802632099e-26,
 -1.347210921340690e-28,  9.518391434076274e-04, -6.607362280045724e-06,  3.438429736678323e-08, -1.589637702153456e-10,  6.884732165000411e-13, -2.860056909069080e-15,
  1.153923654355139e-17, -4.555324832568651e-20,  1.767808496108216e-22, -6.765687646439317e-25,  2.559122910817348e-27, -9.582232943895849e-30,  8.558990400426122e-03,
 -5.922207226110375e-05,  3.061381043085286e-07, -1.399363442321989e-09,  5.956694317220215e-12, -2.414214296097247e-14,  9.418038712625394e-17, -3.555993296633915e-19,
  1.302533565936587e-21, -4.629250038587147e-24,  1.593142322663756e-26, -5.285684436771370e-29,  2.373291018963833e-02, -1.631525909900120e-04,  8.320983904987378e-07,
 -3.716385573924313e-09,  1.525832411090498e-11, -5.863149377960541e-14,  2.118722231247233e-16, -7.170648647096181e-19,  2.239391526530764e-21, -6.226636961480409e-24,
  1.394523549356028e-26, -1.483164011794171e-29,  4.639258154305431e-02, -3.158177259218076e-04,  1.577947728827695e-06, -6.797692706969619e-09,  2.632409549552042e-11,
 -9.224423520415089e-14,  2.873834044836753e-16, -7.497640298137105e-19,  1.302380522369135e-21,  1.174927692566799e-24, -2.577706619703496e-26,  1.606825212667072e-28,
  7.641585564406453e-02, -5.133877415498334e-04,  2.494142427714405e-06, -1.021190139692410e-08,  3.622669354718618e-11, -1.086059225496588e-13,  2.443758752008453e-16,
 -1.684524062683692e-19, -2.210593897421936e-21,  1.703474335708479e-23, -8.223276784306979e-26,  3.035229043091823e-28,  1.136387193526483e-01, -7.508362865271234e-04,
  3.518200077953390e-06, -1.345055125510289e-08,  4.188624214586647e-11, -9.365654651477455e-14,  4.106290519365308e-17,  1.016590265673628e-18, -7.073657991233142e-21,
  3.064807540215265e-23, -9.193871298587592e-26,  1.233721830924936e-28,  1.578543455773697e-01, -1.022012015826779e-03,  4.577692379158420e-06, -1.597976397420449e-08,
  4.063864307029632e-11, -4.013908369747903e-14, -3.042294928187013e-16,  2.413477925803659e-18, -1.028615315410705e-20,  2.640129230138664e-23,  2.824922269745914e-28,
 -4.465341040571395e-28,  2.088119517773495e-01, -1.319731839844817e-03,  5.593884495783463e-06, -1.729792324881645e-08,  3.078662033407445e-11,  4.910335272315326e-14,
 -7.055781638203257e-16,  3.339743360428840e-18, -8.493970561348992e-21, -4.495871595079463e-24,  1.737556634318616e-25, -9.936375480394576e-28,  2.662155008659464e-01,
 -1.635898055633918e-03,  6.485935773927200e-06, -1.699485827666435e-08,  1.204685367725204e-11,  1.599695235341878e-13, -1.025718001785397e-15,  3.085719692266680e-18,
 -1.357911353973487e-22, -5.302062119806716e-23,  3.086773428941599e-25, -8.207991339239060e-28,  3.297222895357941e-01, -1.961641804242800e-03,  7.175543161890578e-06,
 -1.480728629067898e-08, -1.419025831134919e-11,  2.686907047950464e-13, -1.114952122278968e-15,  1.267068408379977e-18,  1.280265265045943e-20, -9.107039740047535e-23,
  2.499160508511200e-25,  3.996603686935288e-28,  3.989414818354597e-01, -2.287495298167744e-03,  7.591867739765930e-06, -1.066475979598655e-08, -4.485692264763638e-11,
  3.462501337327723e-13, -8.638769641249205e-16, -1.877368935774181e-18,  2.463533348295178e-20, -8.468161435212058e-23, -6.319613389853767e-26,  2.022747018900936e-27,
  4.734326609386405e-01, -2.603595006617022e-03,  7.676536912463542e-06, -4.720201157192047e-09, -7.550147426983809e-11,  3.650527414181104e-13, -2.543997967809152e-16,
 -5.399231109737150e-18,  2.805517388470698e-20, -1.733298384116429e-23, -4.925309798908980e-25,  2.585914617473667e-27,  5.527044895820622e-01, -2.899917392981401e-03,
  7.388461930397089e-06,  2.640551772943304e-09, -1.008798050827910e-10,  3.065875410704868e-13,  6.096822519526570e-16, -7.868658051780339e-18,  1.794323211259452e-20,
  9.035759323469491e-23, -7.305540047503981e-25,  9.449231992842498e-28,  6.362135895549467e-01, -3.166547777506790e-03,  6.708156177648231e-06,  1.081474910235697e-08,
 -1.157944518074005e-10,  1.682791919301463e-13,  1.508892237924897e-15, -7.901385595573271e-18, -4.818027808597858e-21,  1.808804627041335e-22, -4.967371856793591e-25,
 -2.355726119340840e-27,  7.233637725849126e-01, -3.393981353482714e-03,  5.641190152168684e-06,  1.902699304516057e-08, -1.160748248675956e-10, -3.250608040221032e-14,
  2.158459121333795e-15, -4.820412811992012e-18, -3.186443179008397e-20,  1.876711372541851e-22,  2.050008509998016e-25, -4.852097501014373e-27,  8.135057782976195e-01,
 -3.573453229435669e-03,  4.220383044024800e-06,  2.640169445780468e-08, -9.953930490109220e-11, -2.590799835988565e-13,  2.295727126426994e-15,  8.313601492454403e-19,
 -4.992005398016750e-20,  8.001297056459284e-23,  9.772579851402551e-25, -3.859978483727073e-27,  9.059376984550995e-01, -3.697291540416881e-03,  2.506319945658936e-06,
  3.205996226008778e-08, -6.674302437240874e-11, -4.616109798512285e-13,  1.780925980038840e-15,  7.228204045788161e-18, -4.717933854166040e-20, -1.029721456226500e-22,
  1.230019720561048e-24,  8.644911907603337e-28,  9.999062886076179e-01, -3.759284157333796e-03,  5.858120785303319e-07,  3.523277660805742e-08, -2.130867073241713e-11,
 -5.883945306058935e-13,  6.751600304268640e-16,  1.181455954630426e-17, -2.070854162948493e-20, -2.594855151693107e-22,  6.280109820726165e-25,  5.986447917952135e-27,
  1.094609386102972e+00, -3.755045398139819e-03, -1.431999823822972e-06,  3.537768608787810e-08,  3.032448972477184e-11, -6.000287810451716e-13, -7.420139704062362e-16,
  1.236665622331851e-17,  1.958374165561316e-20, -2.819648220523455e-22, -5.412448143028172e-25,  6.837194246873833e-27,  1.189199663766338e+00, -3.682364606633202e-03,
 -3.422047918052360e-06,  3.228222448331970e-08,  7.980746853928170e-11, -4.827432157627266e-13, -2.038467498062980e-15,  8.142608882530492e-18,  5.405735267523477e-20,
 -1.346834269806378e-22, -1.454300585551263e-24,  1.824272375534785e-27,  1.282789947405268e+00, -3.541513875832018e-03, -5.252166921500694e-06,  2.613483999432439e-08,
  1.183778712465537e-10, -2.563468094478301e-13, -2.771651065451641e-15,  5.194405483191342e-19,  6.346924616903821e-20,  1.044893829416889e-22, -1.356815367904264e-24,
 -5.181731911279963e-27,  1.374460307928705e+00, -3.335488110153966e-03, -6.793970794784603e-06,  1.754460548103115e-08,  1.387092231156875e-10,  2.711520089289881e-14,
 -2.662638829208793e-15, -7.368017800679569e-18,  4.103440882056939e-20,  2.825643160200591e-22, -2.490173712972271e-25, -7.796763214875760e-27,  1.463267100415193e+00,
 -3.070147801451154e-03, -7.935038935473699e-06,  7.495455360038838e-09,  1.367175538989345e-10,  2.955711641985161e-13, -1.730077955974184e-15, -1.201298150810712e-17,
 -1.580398418196374e-21,  2.778028586476220e-22,  1.005456952812256e-24, -3.444954971363432e-27,  1.548254058496437e+00, -2.754234259783924e-03, -8.591301917710533e-06,
 -2.770235471416329e-09,  1.128368403815307e-10,  4.778453817601001e-13, -3.126880055845458e-16, -1.134849402342511e-17, -3.994507474259897e-20,  9.745423072196742e-23,
  1.383539415223058e-24,  3.536526254755032e-27,  1.628465459902474e+00, -2.399229577184629e-03, -8.718192697635994e-06, -1.193068943134487e-08,  7.230648480716750e-11,
  5.271402774159621e-13,  1.051905175908408e-15, -5.966869899206130e-18, -5.221160453597441e-20, -1.204172103507478e-22,  6.444935286788064e-25,  6.230346722467171e-27,
  1.702961257474537e+00, -2.019040189893280e-03, -8.318935957955403e-06, -1.880283848301190e-08,  2.420550495339976e-11,  4.384107629509855e-13,  1.855670509451223e-15,
  1.110331220382053e-18, -3.399167333677302e-20, -2.165582958979636e-22, -4.405158036165859e-25,  2.675404950804985e-27,  1.770833922764736e+00, -1.629494068639124e-03,
 -7.448374437301038e-06, -2.256161530913065e-08, -2.069363904437051e-11,  2.516611394498422e-13,  1.853377814799282e-15,  6.156836710683122e-18, -1.154332028604418e-21,
 -1.427411658066397e-22, -8.795118032400862e-25, -2.298616980618150e-27,  1.831226584893228e+00, -1.247657201878315e-03, -6.211049146591751e-06, -2.291381513782231e-08,
 -5.277339299985106e-11,  3.781293659333684e-14,  1.176159240539193e-15,  6.970493432646075e-18,  2.269370017316858e-20,  6.249327063371497e-24, -4.563239741311946e-25,
 -3.326968661394041e-27,  1.883351879970720e+00, -8.909941497905914e-04, -4.752888337408571e-06, -2.018123993453986e-08, -6.631026795374702e-11, -1.288530954959498e-13,
  2.508958019926737e-16,  4.115977862574639e-18,  2.445482914924399e-20,  9.366229404742753e-23,  1.741002592668001e-25, -7.323873392308055e-28,  1.926510778166558e+00,
 -5.764180089772917e-04, -3.246774417820867e-06, -1.526177510355532e-08, -6.118871396907731e-11, -2.007187681572111e-13, -4.422541089381073e-16,  2.607912444149468e-19,
  1.008385481345977e-20,  7.147221395412334e-23,  3.490616255254046e-25,  1.253406391634247e-27,  1.960110568384662e+00, -3.192940571701966e-04, -1.873318526951972e-06,
 -9.462682771314309e-09, -4.290054776717419e-11, -1.756613605678164e-13, -6.377967326570584e-16, -1.929336883559602e-18, -3.811189002588761e-21,  4.944008013773506e-24,
  1.097853402921970e-25,  7.822456566374681e-28,  1.983681343673259e+00, -1.324738249469203e-04, -7.991655359631987e-07, -4.232401140591667e-09, -2.067937770383378e-11,
 -9.504332147761801e-14, -4.138468860430127e-16, -1.707032058439095e-18, -6.624558362504208e-21, -2.378466584816316e-23, -7.603277437258597e-26, -1.943243466729872e-28,
  1.996893531271009e+00, -2.541633828793911e-05, -1.556966411917338e-07, -8.458717261094662e-10, -4.295984497876949e-12, -2.087351528389295e-14, -9.820327989279407e-17,
 -4.504458842243252e-19, -2.022752362632535e-21, -8.914864942975871e-24, -3.861724839678651e-26, -1.645192264313665e-28,  9.259480205615138e-04, -6.339735149000296e-06,
  3.254098549929715e-08, -1.483911831400541e-10,  6.339413910089086e-13, -2.597803702833083e-15,  1.033941804207516e-17, -4.026700390875336e-20,  1.541697329300924e-22,
 -5.821572513049827e-25,  2.172764066674045e-27, -8.028238140215843e-30,  8.326896209403791e-03, -5.683855256564336e-05,  2.899020406086379e-07, -1.307799567393169e-09,
  5.495671955591109e-12, -2.199673478358374e-14,  8.478293863024772e-17, -3.164661240328547e-19,  1.146811593179771e-21, -4.036228780751570e-24,  1.377390682607959e-26,
 -4.540314371701127e-29,  2.309333669854206e-02, -1.566701274676101e-04,  7.889287425813711e-07, -3.481363829162290e-09,  1.413495825048372e-11, -5.377959988606115e-14,
  1.927647155916381e-16, -6.488845621196020e-19,  2.025106284509957e-21, -5.682909706812448e-24,  1.321870758001039e-26, -1.791826976954450e-29,  4.515405110500197e-02,
 -3.035134109987623e-04,  1.498842842925953e-06, -6.390898561307100e-09,  2.454650682358817e-11, -8.559421250337768e-14,  2.669784951536103e-16, -7.075968735175220e-19,
  1.327730260055914e-21,  2.752314091163533e-25, -1.944360467311089e-26,  1.282806057437517e-28,  7.440144854820413e-02, -4.939150827536967e-04,  2.375006721154076e-06,
 -9.649334322076099e-09,  3.411280426854763e-11, -1.028049504799874e-13,  2.387566756147472e-16, -2.299888007534065e-19, -1.653436523328644e-21,  1.400110942780627e-23,
 -6.972681432251906e-26,  2.653800512846318e-28,  1.106906590630155e-01, -7.233250612697196e-04,  3.360752927630919e-06, -1.279529365161848e-08,  4.002514398163796e-11,
 -9.235404643374098e-14,  6.651930500301088e-17,  8.071878706785155e-19, -6.035137331945093e-21,  2.708740359200889e-23, -8.591558969644320e-26,  1.480556984351515e-28,
  1.538383416517565e-01, -9.861465152308060e-04,  4.389808805535123e-06, -1.533634233535564e-08,  3.976813158242363e-11, -4.666598028879137e-14, -2.411176190541002e-16,
  2.099494289872274e-18, -9.339879954458844e-21,  2.605861549048542e-23, -1.649988299869075e-26, -3.206532581366891e-28,  2.036212238408611e-01, -1.275802621418724e-03,
  5.389294445740290e-06, -1.679836962064900e-08,  3.160676396519675e-11,  3.326081270032916e-14, -6.158858993555309e-16,  3.066605126967207e-18, -8.540863883245222e-21,
  1.622780948685920e-24,  1.332282679356235e-25, -8.493878052036956e-28,  2.597743969423665e-01, -1.584822811286056e-03,  6.283255300009780e-06, -1.677782168488402e-08,
  1.500706052253337e-11,  1.363869220440679e-13, -9.396490554993815e-16,  3.053146148930701e-18, -1.831091413243967e-21, -4.140631511896639e-23,  2.718659206016298e-25,
 -8.446519896109493e-28,  3.219894007332302e-01, -1.904951669412755e-03,  6.996666122792632e-06, -1.499278095119293e-08, -9.080932359161847e-12,  2.424009235941393e-13,
 -1.074217565554399e-15,  1.626254680660240e-18,  9.707418232498986e-21, -8.081734992478850e-23,  2.605166482951772e-25,  9.480268483682371e-29,  3.899121434643876e-01,
 -2.227283946903695e-03,  7.459809188656844e-06, -1.132821333860110e-08, -3.814305993536619e-11,  3.249725418767160e-13, -9.058674688704446e-16, -1.138136190532809e-18,
  2.156159939433379e-20, -8.555485872465906e-23,  1.646088730935694e-26,  1.601146722642707e-27,  4.631407185034662e-01, -2.542429264896774e-03,  7.612886081202067e-06,
 -5.870197628415338e-09, -6.827319947783624e-11,  3.572337451297783e-13, -3.931291828182203e-16, -4.515030570239635e-18,  2.710375634976262e-20, -3.478536094988624e-23,
 -3.809499587523239e-25,  2.468122650533718e-27,  5.412231979655728e-01, -2.840709919548850e-03,  7.410668811669963e-06,  1.076250218066600e-09, -9.461922928706051e-11,
  3.186437349542442e-13,  3.978477201570150e-16, -7.247977290862115e-18,  2.068161977723315e-20,  6.212846284480155e-23, -6.772228121872678e-25,  1.450261233507415e-27,
  6.236555067525020e-01, -3.112394648026336e-03,  6.826934131210484e-06,  8.990854680664386e-09, -1.120847191957857e-10,  2.018261930761516e-13,  1.286445455045309e-15,
 -7.955396656637179e-18,  1.313504176952109e-21,  1.592081171165231e-22, -5.802859957567792e-25, -1.451165725866218e-27,  7.098795076497605e-01, -3.347970140310310e-03,
  5.858358418638227e-06,  1.716736162222888e-08, -1.162184178012015e-10,  1.756834709759907e-14,  2.010236876356993e-15, -5.730803142730612e-18, -2.501090316909325e-20,
  1.917381059074539e-22,  2.097358403834627e-27, -4.338336219206752e-27,  7.992814593196030e-01, -3.538450332766374e-03,  4.527486322497226e-06,  2.477061111380083e-08,
 -1.041689651943952e-10, -2.038807836410832e-13,  2.297125860444570e-15, -7.127940398946887e-19, -4.637871560724078e-20,  1.155108066267423e-22,  7.933662073268840e-25,
 -4.445873409814551e-27,  8.911910434347121e-01, -3.675720942997414e-03,  2.884335202367274e-06,  3.092060414351283e-08, -7.553232314912791e-11, -4.166137646728296e-13,
  1.961690066387272e-15,  5.668697145196535e-18, -4.999554338681134e-20, -5.344747733297607e-23,  1.235568207793302e-24, -5.955459147998524e-28,  9.848811933087683e-01,
 -3.752913171473984e-03,  1.006174580762056e-06,  3.479868617877347e-08, -3.288815047387226e-11, -5.683043256989864e-13,  9.953234019578513e-16,  1.100776893958369e-17,
 -2.953699774258143e-20, -2.293899736328469e-22,  8.689430765685795e-25,  4.913822783277601e-27,  1.079568991652320e+00, -3.764795937277818e-03, -1.004955268533807e-06,
  3.576602461543022e-08,  1.817420401075219e-11, -6.136206189087559e-13, -3.885263972129107e-16,  1.282734592665950e-17,  9.117553181828345e-21, -2.974131653062460e-22,
 -2.274140426890455e-25,  7.352526237599249e-27,  1.174417935679559e+00, -3.708170486211640e-03, -3.027326708143615e-06,  3.347932787691925e-08,  6.968282922630947e-11,
 -5.287399247549871e-13, -1.787064635084217e-15,  9.783829326565086e-18,  4.818601416381517e-20, -1.907000305899974e-22, -1.333049938158401e-24,  3.672669033772891e-27,
  1.268541888392891e+00, -3.582244953190431e-03, -4.927365438736426e-06,  2.798426532664854e-08,  1.125881163573792e-10, -3.224593075872272e-13, -2.728184162988903e-15,
  2.599744359967167e-18,  6.620248862065453e-20,  4.604514338722603e-23, -1.555003229536109e-24, -3.755801324214380e-27,  1.361011038635243e+00, -3.388959988220221e-03,
 -6.570112979516424e-06,  1.976475204756128e-08,  1.385965895823788e-10, -3.910609090616619e-14, -2.849048322938441e-15, -5.894764361656871e-18,  5.094307974316448e-20,
  2.655648549385499e-22, -6.045312090998875e-25, -8.285959353457560e-27,  1.450860171313738e+00, -3.133230709859832e-03, -7.831781129325373e-06,  9.727857241647055e-09,
  1.421865236957533e-10,  2.500167271551749e-13, -2.065592524272373e-15, -1.189610671015062e-17,  9.102946486391114e-21,  3.144441833761676e-22,  8.129994602792034e-25,
 -5.311407914284720e-27,  1.537099494371667e+00, -2.823066231678539e-03, -8.613398650887543e-06, -8.889091003972351e-10,  1.222922331876923e-10,  4.663869650341835e-13,
 -6.477359854091558e-16, -1.255963573896926e-17, -3.540588755169230e-20,  1.555923268405927e-22,  1.514728833793382e-24,  2.350408661812824e-27,  1.618728172611121e+00,
 -2.469527314625578e-03, -8.854067355935286e-06, -1.068813179641834e-08,  8.308722270000209e-11,  5.501885220289069e-13,  8.608289628416660e-16, -7.701477271824557e-18,
 -5.601462674016646e-20, -8.894996157895566e-23,  9.334952753184475e-25,  6.863586733880520e-27,  1.694750574917257e+00, -2.086486947757987e-03, -8.541949078465325e-06,
 -1.834297662174967e-08,  3.342093313779376e-11,  4.831896935206861e-13,  1.870336701078125e-15, -1.052873637049475e-19, -4.207304653497522e-20, -2.314342445600796e-22,
 -2.932470401409930e-25,  4.052576033319797e-27,  1.764195050394524e+00, -1.690169251824969e-03, -7.720926325505668e-06, -2.284997247209799e-08, -1.520168449464420e-11,
  2.982017343907709e-13,  2.024430061811544e-15,  6.030697551166467e-18, -6.949696900743271e-21, -1.798374173160228e-22, -9.721680991575573e-25, -1.867385347984056e-27,
  1.826134817673174e+00, -1.298459744765021e-03, -6.491051064465125e-06, -2.375053780748835e-08, -5.171862247127788e-11,  6.846497921590940e-14,  1.381506827315309e-15,
  7.696471323792713e-18,  2.255317230950249e-20, -1.511519670497620e-23, -6.164838739052292e-25, -3.955410252768050e-27,  1.879710297665482e+00, -9.300041859295779e-04,
 -5.001512874623126e-06, -2.126245273355221e-08, -6.881730943101870e-11, -1.213570371016398e-13,  3.776150225762606e-16,  4.953754550583803e-18,  2.794297573335347e-20,
  9.983895622204497e-23,  1.309335739436052e-25, -1.254486151125056e-27,  1.924151973941648e+00, -6.031417216792340e-04, -3.435924169641591e-06, -1.627348305916139e-08,
 -6.530843994841867e-11, -2.112063011892809e-13, -4.300277320771636e-16,  6.274473092977613e-19,  1.292178565517192e-20,  8.657202771915513e-23,  4.067369838568728e-25,
  1.364039875871720e-27,  1.958802683062905e+00, -3.347467556086970e-04, -1.991107854122317e-06, -1.017804765302988e-08, -4.657129234012218e-11, -1.916303241107184e-13,
 -6.934923706608816e-16, -2.047528652398582e-18, -3.545302824079660e-21,  1.008615601942942e-23,  1.489538653481490e-25,  1.006448141288509e-27,  1.983138331926544e+00,
 -1.390760773345366e-04, -8.520040920546000e-07, -4.579034463882895e-09, -2.268356616961144e-11, -1.055739764933482e-13, -4.647445909758777e-16, -1.933321757579473e-18,
 -7.537635458790812e-21, -2.699964164085519e-23, -8.477172592293997e-26, -2.019229884359796e-28,  1.996789308792784e+00, -2.670371434966893e-05, -1.662737197898675e-07,
 -9.180797213401250e-10, -4.738084301557111e-12, -2.338936565538063e-14, -1.117724154225579e-16, -5.206218118242874e-19, -2.373329217379640e-21, -1.061462488446147e-23,
 -4.663941284413546e-26, -2.014355295955864e-28,  9.010986963391475e-04, -6.086361472667654e-06,  3.081947777460060e-08, -1.386506604296929e-10,  5.843782527967105e-13,
 -2.362648687221816e-15,  9.277975043733601e-18, -3.565278816905523e-20,  1.346949707533552e-22, -5.019152729333107e-25,  1.848698800964520e-27, -6.741800168559174e-30,
  8.104083106167328e-03, -5.458064852865333e-05,  2.747218625298367e-07, -1.223280676550497e-09,  5.075388295438748e-12, -2.006426055737865e-14,  7.641455074691088e-17,
 -2.819904756985789e-19,  1.010961002720360e-21, -3.523277123324854e-24,  1.192012385688537e-26, -3.902341757042489e-29,  2.247901978697197e-02, -1.505220384241461e-04,
  7.484746357588548e-07, -3.263563915968312e-09,  1.310419517048946e-11, -4.936413456711927e-14,  1.754731580051759e-16, -5.872540470602574e-19,  1.829843575007890e-21,
 -5.170507326495659e-24,  1.238933646793762e-26, -1.958252286509548e-29,  4.396350249533973e-02, -2.918228826108954e-04,  1.424453142184320e-06, -6.011508036051300e-09,
  2.289711741543102e-11, -7.941967604374319e-14,  2.477610867192499e-16, -6.650905332904123e-19,  1.324924331846758e-21, -3.978001905597300e-25, -1.440030660808619e-26,
  1.018573978845739e-28,  7.246306787114931e-02, -4.753690726012279e-04,  2.262422689511059e-06, -9.119669198430553e-09,  3.211345625511231e-11, -9.715759828728849e-14,
  2.316483150184359e-16, -2.753502192697704e-19, -1.196882512049632e-21,  1.143499459789664e-23, -5.883492352467233e-26,  2.302368547314747e-28,  1.078501736077936e-01,
 -6.970424648827903e-04,  3.210991165016771e-06, -1.216957395105236e-08,  3.819574934182729e-11, -9.050731340290861e-14,  8.655876728809422e-17,  6.290155739348854e-19,
 -5.120238455450816e-21,  2.378548107716499e-23, -7.909072555261596e-26,  1.604402608834293e-28,  1.499628421446931e-01, -9.517534451650690e-04,  4.209558673288426e-06,
 -1.470781381363683e-08,  3.878153451709456e-11, -5.178028445858705e-14, -1.863760744628122e-16,  1.815474833751539e-18, -8.416760467713712e-21,  2.514790172409802e-23,
 -2.829931651541836e-26, -2.194791362798017e-28,  1.986029775874802e-01, -1.233485945073458e-03,  5.190767688700680e-06, -1.628811414290190e-08,  3.213096340940930e-11,
  1.947913566237899e-14, -5.338315587388049e-16,  2.795190084940079e-18, -8.395152881494139e-21,  6.245331024461374e-24,  9.889349710776256e-26, -7.129335894831554e-28,
  2.535343686937524e-01, -1.535357822915214e-03,  6.083448242986911e-06, -1.651708318145359e-08,  1.751616792885854e-11,  1.148532764903899e-13, -8.551908404110307e-16,
  2.972727389567126e-18, -3.134914870518635e-21, -3.127258664284925e-23,  2.349423771447992e-25, -8.281147004371356e-28,  3.144803982495176e-01, -1.849700104501730e-03,
  6.816036472735100e-06, -1.510067642112078e-08, -4.486867490740457e-12,  2.171986093325981e-13, -1.024756530705559e-15,  1.892356133194052e-18,  6.985894528869158e-21,
 -7.038654627774136e-23,  2.593355101125551e-25, -1.370985429723338e-28,  3.811214896741612e-01, -2.168159116311463e-03,  7.320419524025406e-06, -1.188769741076682e-08,
 -3.186320768949925e-11,  3.029244375336346e-13, -9.285370395695936e-16, -4.971868668018738e-19,  1.850937183851075e-20, -8.360588600532757e-23,  7.811792351301335e-26,
  1.207330528490678e-27,  4.530923359806991e-01, -2.481825976585169e-03,  7.536123482970673e-06, -6.905965296932974e-09, -6.123261442977065e-11,  3.463783446088115e-13,
 -5.076155672579738e-16, -3.670478489042123e-18,  2.560287224867266e-20, -4.790734070968818e-23, -2.766708037619077e-25,  2.259704874559930e-27,  5.299789750919935e-01,
 -2.781398158103364e-03,  7.414712168407671e-06, -3.862232901300204e-10, -8.816691495012980e-11,  3.258334275466244e-13,  2.044694434627371e-16, -6.555475958525480e-18,
  2.244705072588717e-20,  3.642635340166007e-23, -6.054423412991062e-25,  1.785589367842839e-27,  6.113157997886505e-01, -3.057377783696448e-03,  6.924202686983420e-06,
  7.231393305600091e-09, -1.077574448371720e-10,  2.300377532744777e-13,  1.065111844962999e-15, -7.826250241076770e-18,  6.614092919440396e-21,  1.349699020085381e-22,
 -6.256037499059930e-25, -6.250418132536013e-28,  6.965826209711508e-01, -3.300310807555550e-03,  6.053229723537283e-06,  1.531324311909101e-08, -1.153980318363090e-10,
  6.380441236272956e-14,  1.839605197791027e-15, -6.421056926930117e-18, -1.815111677380554e-20,  1.881938311716188e-22, -1.743788365405568e-25, -3.662234486596940e-27,
  7.852019399511420e-01, -3.501070077294774e-03,  4.814608551253714e-06,  2.307427244569852e-08, -1.076977369313825e-10, -1.491529154949117e-13,  2.257056525295505e-15,
 -2.124643080333197e-18, -4.169721304052342e-20,  1.432314208857226e-22,  5.907101861750938e-25, -4.714556350477550e-27,  8.765366291738153e-01, -3.651183233550321e-03,
  3.247864809742758e-06,  2.964803750867893e-08, -8.338187684607689e-11, -3.678107432914551e-13,  2.097793914898763e-15,  4.047517156556491e-18, -5.104002319602342e-20,
 -4.948771610377466e-24,  1.179800035366654e-24, -1.907849992997590e-27,  9.698882703596293e-01, -3.743203238346296e-03,  1.420230957352930e-06,  3.418294775791202e-08,
 -4.399097721260079e-11, -5.408321400015467e-13,  1.289117065881354e-15,  9.937565283312401e-18, -3.712069521057095e-20, -1.906850781885250e-22,  1.056580556868052e-24,
  3.580872961638801e-27,  1.064496452582576e+00, -3.771114802247755e-03, -5.744245454923023e-07,  3.595824852445005e-08,  5.837765947081958e-12, -6.186122353186219e-13,
 -2.689448104631130e-17,  1.294667833212624e-17, -1.674594692207337e-21, -2.999915712625781e-22,  9.882045168361208e-26,  7.397371215779565e-27,  1.159539386616420e+00,
 -3.730763956758983e-03, -2.619241477067391e-06,  3.450742061635511e-08,  5.870219721239056e-11, -5.681745716929616e-13, -1.492633535712512e-15,  1.120599451256425e-17,
  4.040466267365399e-20, -2.402768124454789e-22, -1.133482998129306e-24,  5.360058615192874e-27,  1.254136240095957e+00, -3.620290521107896e-03, -4.580970064612667e-06,
  2.973055321878121e-08,  1.054913043311019e-10, -3.868217301975615e-13, -2.625570722642919e-15,  4.732448101086538e-18,  6.670527388243757e-20, -1.895104985600599e-23,
 -1.681580225259109e-24, -1.941639795559944e-27,  1.347351632107839e+00, -3.440534569528861e-03, -6.319668671859087e-06,  2.197227265466966e-08,  1.371183156867930e-10,
 -1.092710321259792e-13, -2.989879406450463e-15, -4.117003275162376e-18,  5.997991958473548e-20,  2.340592675371292e-22, -9.705651463019527e-25, -8.259638303796223e-27,
  1.438202734371312e+00, -3.195378985046045e-03, -7.701240957893042e-06,  1.204003824180023e-08,  1.466643509435453e-10,  1.964890031098842e-13, -2.392861682544261e-15,
 -1.141790632074308e-17,  2.094696269032357e-20,  3.417407558682815e-22,  5.383887878862216e-25, -7.154131187092107e-27,  1.525669395396657e+00, -2.891982122217194e-03,
 -8.612020758439254e-06,  1.141422096612131e-09,  1.314353924329273e-10,  4.464988343134643e-13, -1.014341144774728e-15, -1.359113339532822e-17, -2.869309435912927e-20,
  2.177974751776183e-22,  1.583501693909529e-24,  6.994824624084712e-28,  1.608707618993704e+00, -2.540849440874144e-03, -8.973982012727563e-06, -9.269660546123529e-09,
  9.427906676994304e-11,  5.680554854760409e-13,  6.196664884621773e-16, -9.537375556447651e-18, -5.847079231607547e-20, -4.545071041724638e-23,  1.243752428278024e-24,
  7.175214179680734e-27,  1.686266575696638e+00, -2.155693162492352e-03, -8.758529592389487e-06, -1.772849626027723e-08,  4.353254982977095e-11,  5.278824914132292e-13,
  1.847273417921270e-15, -1.586819506241319e-18, -5.056878967684349e-20, -2.391503066236872e-22, -8.119476661253458e-26,  5.611345811059277e-27,  1.757309096750208e+00,
 -1.753037125265325e-03, -7.996379836935494e-06, -2.304279040886330e-08, -8.738265220474079e-12,  3.487829859315980e-13,  2.189148464042389e-15,  5.697066175778368e-18,
 -1.414188574712946e-20, -2.201736784547401e-22, -1.039237884458136e-24, -1.123866160547834e-27,  1.820835297128655e+00, -1.351542130420222e-03, -6.780971279826041e-06,
 -2.456520515600303e-08, -4.999988695880101e-11,  1.042880281268840e-13,  1.606994084618986e-15,  8.404355716142294e-18,  2.152152780398362e-20, -4.344011210669388e-23,
 -8.042834350597424e-25, -4.575272697581819e-27,  1.875908614104641e+00, -9.710557859878144e-04, -5.263347136403111e-06, -2.238240537993011e-08, -7.114205103870072e-11,
 -1.105254189246831e-13,  5.293854586609911e-16,  5.906328772536711e-18,  3.161644755602923e-20,  1.037831578023601e-22,  6.127805791471388e-26, -1.941233827401764e-27,
  1.921683169977257e+00, -6.314283307624437e-04, -3.637616770754932e-06, -1.735276501074583e-08, -6.963409545661029e-11, -2.212664243552535e-13, -4.061786450435563e-16,
  1.094068922350631e-18,  1.634593037966140e-20,  1.040672578848524e-22,  4.685720599873887e-25,  1.438792656506559e-27,  1.957431046508259e+00, -3.511771293715924e-04,
 -2.117844729154328e-06, -1.095477321477899e-08, -5.057504546029451e-11, -2.089745516017693e-13, -7.523481597890215e-16, -2.153927591080920e-18, -3.063579971938983e-21,
  1.700792567809458e-23,  1.991705681102252e-25,  1.286159865397140e-27,  1.982568038617980e+00, -1.461182381584071e-04, -9.092018213747066e-07, -4.959488293108770e-09,
 -2.491111393615366e-11, -1.174056208222421e-13, -5.224053496930236e-16, -2.190749753389398e-18, -8.572806491629113e-21, -3.056885475899008e-23, -9.368829734998751e-26,
 -2.017628677314830e-28,  1.996679761914290e+00, -2.807929721756380e-05, -1.777614555711408e-07, -9.977822352702713e-10, -5.233923664034631e-12, -2.625578091349967e-14,
 -1.274731951123216e-16, -6.030605147081682e-19, -2.791287210964296e-21, -1.267024148156559e-23, -5.647512871313619e-26, -2.472906459452133e-28,  8.772360444061803e-04,
 -5.846305445559946e-06,  2.921024909698304e-08, -1.296668645561890e-10,  5.392735806835729e-13, -2.151485765432694e-15,  8.337422446656819e-18, -3.161794061751711e-20,
  1.178886127218649e-22, -4.335714560825615e-25,  1.576262739921940e-27, -5.674262330296671e-30,  7.890065002061660e-03, -5.244024045863067e-05,  2.605168048706641e-07,
 -1.145187721187995e-09,  4.691821429298734e-12, -1.832151849382433e-14,  6.895329711073436e-17, -2.515803652738486e-19,  8.923070204486664e-22, -3.079143722006169e-24,
  1.032629931283897e-26, -3.356321150258347e-29,  2.188866413151451e-02, -1.446874016391113e-04,  7.105380173795832e-07, -3.061571711558801e-09,  1.215772762347658e-11,
 -4.534364803468341e-14,  1.598225038889631e-16, -5.315833209195120e-19,  1.652415566766798e-21, -4.692418851726985e-24,  1.151042357195153e-26, -2.022763242522308e-29,
  4.281855397650261e-02, -2.807097004931754e-04,  1.354461781486941e-06, -5.657544470788736e-09,  2.136670282027546e-11, -7.369210645276855e-14,  2.297292211782428e-16,
 -6.230248959567574e-19,  1.301254290991648e-21, -8.908237215304902e-25, -1.040708803569651e-26,  8.039496250547631e-29,  7.059710938823680e-02, -4.576988460769015e-04,
  2.156006398058461e-06, -8.621099739154720e-09,  3.022525457985985e-11, -9.169451971304461e-14,  2.234610653409479e-16, -3.074988732511337e-19, -8.252303672578172e-22,
  9.274595148906260e-24, -4.941677018269706e-26,  1.984226962052358e-28,  1.051124692060319e-01, -6.719284226778646e-04,  3.068563715920114e-06, -1.157280459404800e-08,
  3.640771137729256e-11, -8.823629882290390e-14,  1.020017909067927e-16,  4.782717131745807e-19, -4.319189847168571e-21,  2.076460866850829e-23, -7.192792815867745e-26,
  1.639101591542325e-28,  1.462220782954102e-01, -9.187724824658184e-04,  4.036753018527362e-06, -1.409582039488534e-08,  3.770516229446168e-11, -5.567291743783268e-14,
 -1.391790468506513e-16,  1.560387851024640e-18, -7.533909205930670e-21,  2.384772558345574e-23, -3.612821382542703e-26, -1.396173481337523e-28,  1.937508605653182e-01,
 -1.192732868205095e-03,  4.998405564198255e-06, -1.577157211602670e-08,  3.239861012725707e-11,  7.576238811314778e-15, -4.592883662038326e-16,  2.530846877218639e-18,
 -8.106332696932636e-21,  9.611392594813765e-24,  7.032003812013500e-26, -5.879581649920157e-28,  2.474890242230757e-01, -1.487478125094918e-03,  5.886997064574829e-06,
 -1.621953505548895e-08,  1.961466703359754e-11,  9.531521971292538e-14, -7.735156410120407e-16,  2.856140240223524e-18, -4.100249541925525e-21, -2.259216828479812e-23,
  1.994046085038035e-25, -7.835053918044701e-28,  3.071895054651503e-01, -1.795897544064687e-03,  6.634536689167102e-06, -1.513903236557536e-08, -3.844241312712977e-13,
  1.932632751379006e-13, -9.690076210399669e-16,  2.077349082935782e-18,  4.636750472242773e-21, -6.018739630991586e-23,  2.494042456805604e-25, -3.044485021733411e-28,
  3.725650648179530e-01, -2.110174583827620e-03,  7.174904285034956e-06, -1.235025520055114e-08, -2.602836126000574e-11,  2.805366666330719e-13, -9.346136787698418e-16,
  4.765654668302682e-20,  1.556762634551308e-20, -7.952583099724348e-23,  1.233152282007085e-25,  8.546386419925732e-28,  4.432850623719209e-01, -2.421884608299007e-03,
  7.447599942448652e-06, -7.830961821826985e-09, -5.443472847771338e-11,  3.330532049893648e-13, -5.991922759721222e-16, -2.880727060334788e-18,  2.370228807117445e-20,
 -5.706085948918574e-23, -1.829488100633436e-25,  1.993285605103344e-27,  5.189719552999909e-01, -2.722122484179678e-03,  7.401829211856968e-06, -1.744554886678490e-09,
 -8.161561751606606e-11,  3.286202712637233e-13,  3.113712140235119e-17, -5.820705061055639e-18,  2.334201684568800e-20,  1.384397046180803e-23, -5.223533617421533e-25,
  1.967669398226113e-27,  5.991975845758027e-01, -3.001666007033853e-03,  7.000790813477288e-06,  5.545395114752223e-09, -1.029186708408873e-10,  2.529990499141997e-13,
  8.496357295876301e-16, -7.541726789822239e-18,  1.101795509959820e-20,  1.096145439490185e-22, -6.369727013608877e-25,  8.742458795360329e-29,  6.834793490572588e-01,
 -3.251181210102357e-03,  6.225960141621358e-06,  1.347941993120283e-08, -1.136953141417992e-10,  1.057380319320762e-13,  1.652691049889649e-15, -6.895141214867351e-18,
 -1.153851274107492e-20,  1.782180208451388e-22, -3.187949197405761e-25, -2.892069795534597e-27,  7.712764053926073e-01, -3.461475145293665e-03,  5.081071869079128e-06,
  2.133016451330769e-08, -1.101446788239186e-10, -9.584329866560939e-14,  2.179691492527058e-15, -3.372299208034343e-18, -3.616571296326411e-20,  1.626986474454470e-22,
  3.828511729705576e-25, -4.687760731233240e-27,  8.619860825942919e-01, -3.623800430264466e-03,  3.595402802953132e-06,  2.825784849643775e-08, -9.022639476620315e-11,
 -3.162881277236044e-13,  2.188295565645549e-15,  2.420309185521748e-18, -5.039206639926079e-20,  4.022598525771979e-23,  1.071017567220955e-24, -2.994467434836597e-27,
  9.549407610435467e-01, -3.730213385424740e-03,  1.825851945164707e-06,  3.339433210115025e-08, -5.447641306136273e-11, -5.066945810824587e-13,  1.549766648483521e-15,
  8.648307855781774e-18, -4.319054682426824e-20, -1.457004116036575e-22,  1.181831627782613e-24,  2.096991217860357e-27,  1.049405536410207e+00, -3.773983554717603e-03,
 -1.427731991169644e-07,  3.595276276758014e-08, -6.511643858840494e-12, -6.149236102434250e-13,  3.332478428754973e-16,  1.272169083052262e-17, -1.232547815035014e-20,
 -2.896212252092196e-22,  4.165864194494901e-25,  6.970965334504185e-27,  1.144577066877468e+00, -3.750046441119284e-03, -2.199898021251496e-06,  3.535391065044978e-08,
  4.700660899019809e-11, -6.000947526367325e-13, -1.162124362879718e-15,  1.235228157266139e-17,  3.099942758296245e-20, -2.804648714681930e-22, -8.658040004464228e-25,
  6.747092682699319e-27,  1.239584081718280e+00, -3.655483131407125e-03, -4.214342520004019e-06,  3.135314824685078e-08,  9.713670815736130e-11, -4.480052167096616e-13,
 -2.463374123822404e-15,  6.842987734297368e-18,  6.479714138921376e-20, -8.732303162419170e-23, -1.721776051566621e-24,  1.488075799660340e-28,  1.333490101426024e+00,
 -3.490000145235069e-03, -6.042922887315055e-06,  2.414474834289520e-08,  1.342071395349541e-10, -1.821870632012653e-13, -3.077075267600416e-15, -2.071023990304186e-18,
  6.762082825479766e-20,  1.881049453447934e-22, -1.322672694989954e-24, -7.644337849945387e-27,  1.425298970305396e+00, -3.256370820312777e-03, -7.542561439408245e-06,
  1.441487861693382e-08,  1.499943885764064e-10,  1.353111508718330e-13, -2.701303403659793e-15, -1.054725085738748e-17,  3.355676224219986e-20,  3.564740120177917e-22,
  1.862022452052852e-25, -8.808683485079964e-27,  1.513963812678090e+00, -2.960787080162216e-03, -8.585415848767664e-06,  3.314374331008803e-09,  1.400905986754876e-10,
  4.174919545227889e-13, -1.406481330107929e-15, -1.437161068921300e-17, -1.971012362609520e-20,  2.811675431307986e-22,  1.569757775933358e-24, -1.392291514215497e-27,
  1.598399970371392e+00, -2.613059728548145e-03, -9.075789872057901e-06, -7.669593170588885e-09,  1.057661678506514e-10,  5.795103393444981e-13,  3.262511145048085e-16,
 -1.142440079235246e-17, -5.913540570452643e-20,  1.060920751780904e-23,  1.558223950338704e-24,  7.033150426938814e-27,  1.677502337001456e+00, -2.226599708255635e-03,
 -8.966736266820329e-06, -1.694512391816244e-08,  5.452896754311729e-11,  5.714930603317310e-13,  1.778891843032319e-15, -3.342886242543864e-18, -5.917273982182312e-20,
 -2.369737430051814e-22,  2.021871487091901e-25,  7.279685383632598e-27,  1.750167252286838e+00, -1.818116045746776e-03, -8.273492605802249e-06, -2.312388950561624e-08,
 -1.224585338217747e-12,  4.031780134725198e-13,  2.341081497468292e-15,  5.109603626055734e-18, -2.282561514460049e-20, -2.624308365786060e-22, -1.065427147028950e-24,
  2.019686095128511e-30,  1.815318747137583e+00, -1.406982457940475e-03, -7.080477890864934e-06, -2.534634035374974e-08, -4.750899151514558e-11,  1.457558946014285e-13,
  1.851675992087054e-15,  9.061409977248369e-18,  1.932852558310790e-20, -7.980748307345850e-23, -1.018111260784041e-24, -5.126720249769843e-27,  1.871938448809658e+00,
 -1.014256432401177e-03, -5.538836189830731e-06, -2.353761361550649e-08, -7.321150580816457e-11, -9.571785161761171e-14,  7.094908422909759e-16,  6.978125862604384e-18,
  3.537398030605575e-20,  1.042819185441698e-22, -4.274692058631944e-26, -2.821309762543099e-27,  1.919097908788557e+00, -6.613814778328866e-04, -3.852682544468203e-06,
 -1.850283129833781e-08, -7.415410482682036e-11, -2.305844036922883e-13, -3.676320156641870e-16,  1.680823291444072e-18,  2.044507367922128e-20,  1.240854727746439e-22,
  5.324301405057202e-25,  1.450756297430638e-27,  1.955991600064586e+00, -3.686597968492995e-04, -2.254298369709350e-06, -1.179841162928778e-08, -5.494003980052840e-11,
 -2.277650814431425e-13, -8.139269379718161e-16, -2.240511606773111e-18, -2.293382070754204e-21,  2.620325962389241e-23,  2.631166918430230e-25,  1.632423847333850e-27,
  1.981968631708242e+00, -1.536368669786812e-04, -9.711869005371136e-07, -5.377553658924540e-09, -2.738973687610444e-11, -1.307114835289964e-13, -5.877576552717140e-16,
 -2.483427723371952e-18, -9.742858433779180e-21, -3.449133120712988e-23, -1.023446224667080e-25, -1.891767571096887e-28,  1.996564522646841e+00, -2.955074705466223e-05,
 -1.902551824643550e-07, -1.085898092168341e-09, -5.791054600951256e-12, -2.952829681829122e-14, -1.456811937740811e-16, -7.001379703095142e-19, -3.290843495797606e-21,
 -1.516276405424613e-23, -6.856660034075748e-26, -3.043990833826417e-28,  8.543085347844548e-04, -5.618703980956424e-06,  2.770463141834340e-08, -1.213721465028076e-10,
  4.981752807203808e-13, -1.961598968580247e-15,  7.502671729998717e-18, -2.808354518295574e-20,  1.033572889145937e-22, -3.752410764525997e-25,  1.346720076554936e-27,
 -4.786274239849225e-30,  7.684387040503010e-03, -5.040982613104879e-05,  2.472131597229686e-07, -1.072962444458236e-09,  4.341385517408627e-12, -1.674804342812502e-14,
  6.229268815820740e-17, -2.247232104087931e-19,  7.885499814325205e-22, -2.694198761197571e-24,  8.954976843369128e-27, -2.888934284039540e-29,  2.132105503316030e-02,
 -1.391468136333396e-04,  6.749370334022208e-07, -2.874099599865444e-09,  1.128803666215471e-11, -4.168069775729352e-14,  1.456536811448918e-16, -4.813217386701055e-19,
  1.491561213446880e-21, -4.249824761087677e-24,  1.061982209849278e-26, -2.015690990057978e-29,  4.171696464920500e-02, -2.701398667275506e-04,  1.288574768890975e-06,
 -5.327174242741340e-09,  1.994660686600687e-11, -6.838326851358578e-14,  2.128621305279558e-16, -5.819716242167348e-19,  1.262494541947619e-21, -1.241741984652674e-24,
 -7.265227037175292e-27,  6.302844719323053e-29,  6.880016632782669e-02, -4.408565239079137e-04,  2.055395243025261e-06, -8.151878373056951e-09,  2.844428327275631e-11,
 -8.643746251537160e-14,  2.145289642428055e-16, -3.289290185163142e-19, -5.248997490889497e-22,  7.463929374422819e-24, -4.132339693294953e-26,  1.700168758698052e-28,
  1.024729868064765e-01, -6.479256379070445e-04,  2.933127407765400e-06, -1.100426172867656e-08,  3.466847269374944e-11, -8.564250352573122e-14,  1.135669025957514e-16,
  3.514768568947285e-19, -3.621717281772937e-21,  1.803128821284934e-23, -6.475866824059011e-26,  1.611177399452748e-28,  1.426105194973094e-01, -8.871448876225747e-04,
  3.871185576782112e-06, -1.350161257961573e-08,  3.656170246945119e-11, -5.851538383637006e-14, -9.873636669267747e-17,  1.332749305519625e-18, -6.702705056030659e-21,
  2.229913634103445e-23, -4.085117478875788e-26, -7.777367081064646e-29,  1.890587173935351e-01, -1.153493838988841e-03,  4.812260090233882e-06, -1.525255749723828e-08,
  3.244549558863196e-11, -2.625292018632257e-15, -3.920006864251871e-16,  2.277474706759889e-18, -7.715616891013900e-21,  1.194063617227428e-23,  4.695470588106727e-26,
 -4.764032145100895e-28,  2.416320787060171e-01, -1.441155212611763e-03,  5.694305366290980e-06, -1.589143169758097e-08,  2.134172578071107e-11,  7.769498282741126e-14,
 -6.954923052316096e-16,  2.713392159631860e-18, -4.778147868639804e-21, -1.528804713750498e-23,  1.662584813744171e-25, -7.208805546054052e-28,  3.001109175389189e-01,
 -1.743547743018194e-03,  6.452954911444549e-06, -1.511550456054918e-08,  3.253069374424450e-12,  1.707199140872069e-13, -9.090767525021474e-16,  2.192954085740757e-18,
  2.646005786120186e-21, -5.051587384565790e-23,  2.333544604000929e-25, -4.168367377750448e-28,  3.642382168891459e-01, -2.053374823007294e-03,  7.024383709943602e-06,
 -1.272304041735934e-08, -2.064154729343030e-11,  2.581756338842555e-13, -9.267282072249152e-16,  5.010336092984706e-19,  1.280169078384239e-20, -7.393435610426402e-23,
  1.540419482451173e-25,  5.503415744768998e-28,  4.337160701426552e-01, -2.362694000138474e-03,  7.348619879504495e-06, -8.649436218716174e-09, -4.792356928974462e-11,
  3.177884291332698e-13, -6.695519229548147e-16, -2.156366823564995e-18,  2.153673129650851e-20, -6.271062968162673e-23, -1.017011341391387e-25,  1.696881907696253e-27,
  5.082017313626526e-01, -2.663013289069667e-03,  7.373276327094963e-06, -2.997838810785479e-09, -7.504850288243243e-11,  3.274965305659829e-13, -1.213382346058702e-16,
 -5.069648019920705e-18,  2.348540331742779e-20, -5.294768980384284e-24, -4.342091247173809e-25,  2.019504222308294e-27,  5.873033156455885e-01, -2.945421104035709e-03,
  7.057625736336388e-06,  3.940213118793296e-09, -9.767166116665365e-11,  2.708995989480377e-13,  6.439616961416964e-16, -7.130913163521838e-18,  1.450804588658624e-20,
  8.439297849380911e-23, -6.198908040864843e-25,  6.660053543584713e-28,  6.705752205851654e-01, -3.200757267543407e-03,  6.376875017706669e-06,  1.167930178178827e-08,
 -1.111997366461942e-10,  1.430499607701727e-13,  1.455403439158175e-15, -7.164415964081028e-18, -5.380721086478543e-21,  1.631566795412054e-22, -4.284328500176832e-25,
 -2.091201107042456e-27,  7.575133805892705e-01, -3.419832809181201e-03,  5.326405811280588e-06,  1.955532265522799e-08, -1.115467197597396e-10, -4.478906284489222e-14,
  2.069964153093788e-15, -4.433331822172781e-18, -3.008204772825727e-20,  1.739534333469774e-22,  1.819408343889747e-25, -4.406799265727914e-27,  8.475505196572672e-01,
 -3.593705834809956e-03,  3.925635799317439e-06,  2.676649340018345e-08, -9.602241211732644e-11, -2.631364009660896e-13,  2.233763657423059e-15,  8.389278347548975e-19,
 -4.820695134166095e-20,  8.017211528907391e-23,  9.203942887631499e-25, -3.803418421242474e-27,  9.400516371848752e-01, -3.714019216155925e-03,  2.221026540582294e-06,
  3.244373871815772e-08, -6.421957283565475e-11, -4.667550435069959e-13,  1.771847334223116e-15,  7.191564290153130e-18, -4.756669040018414e-20, -9.703027060516370e-23,
  1.240597627798595e-24,  5.777837480556070e-28,  1.034310046501628e+00, -3.773402710127840e-03,  2.876307230592672e-07,  3.575074342990368e-08, -1.870155454098202e-11,
 -6.027052471795242e-13,  6.823922835590595e-16,  1.216425691598562e-17, -2.237995920845977e-20, -2.670464956897012e-22,  7.058993021749816e-25,  6.113980474021053e-27,
  1.129544386478127e+00, -3.765936773178384e-03, -1.771539104436045e-06,  3.600860531241343e-08,  3.475435797007839e-11, -6.237328304121360e-13, -8.039348040125355e-16,
  1.317663188619366e-17,  2.035382235771989e-20, -3.088405831083955e-22, -5.459095565313024e-25,  7.716766674849745e-27,  1.224897138928418e+00, -3.687667200763920e-03,
 -3.829085517737070e-06,  3.283251182166558e-08,  8.760211080481302e-11, -5.045960242451265e-13, -2.243308442235880e-15,  8.852957642652026e-18,  6.042131361989473e-20,
 -1.554138916658358e-22, -1.666591762554646e-24,  2.366887154983222e-27,  1.319435300217263e+00, -3.537148379144245e-03, -5.740435305946706e-06,  2.625888489860712e-08,
  1.298214919933916e-10, -2.564823406769045e-13, -3.103828306604688e-15,  1.903401894442777e-19,  7.336203574541481e-20,  1.287888069039456e-22, -1.634168515916710e-24,
 -6.413838263521577e-27,  1.412153959411473e+00, -3.315978416882341e-03, -7.355105808415393e-06,  1.683281804410861e-08,  1.520290551645586e-10,  6.706922405104367e-14,
 -2.979658027915372e-15, -9.267451288702510e-18,  4.642668290448711e-20,  3.557589806501392e-22, -2.313414102231448e-25, -1.009472531953665e-26,  1.501983604211910e+00,
 -3.029272590353607e-03, -8.531925432261034e-06,  5.620650594892776e-09,  1.480699603455178e-10,  3.788460518962487e-13, -1.816109383683984e-15, -1.482842488463349e-17,
 -8.478963492106980e-21,  3.420324518591380e-22,  1.455586853677080e-24, -3.847901839278160e-27,  1.587801977708517e+00, -2.686004536534985e-03, -9.157287889496614e-06,
 -5.884299997778804e-09,  1.174076623532660e-10,  5.832887316127838e-13, -1.997812561922173e-17, -1.329799720753696e-17, -5.755841342093747e-20,  7.896036230766798e-23,
  1.854066966097278e-24,  6.308249485665454e-27,  1.668451204661915e+00, -2.299131248892856e-03, -9.164458369936224e-06, -1.597893764695131e-08,  6.637704211046912e-11,
  6.128414753321191e-13,  1.657514042013190e-15, -5.370693700706918e-18, -6.747651326060006e-20, -2.219852216123299e-22,  5.593778243476337e-25,  8.943816644993425e-27,
  1.742760655169554e+00, -1.885413633477380e-03, -8.550820724758443e-06, -2.307587457479571e-08,  7.411958393235467e-12,  4.609892357000899e-13,  2.472445729552999e-15,
  4.219823837627726e-18, -3.303637260000908e-20, -3.046180020996538e-22, -1.032499958111349e-24,  1.572204708402242e-27,  1.809575585406632e+00, -1.464855590180450e-03,
 -7.389090579273089e-06, -2.608066120414708e-08, -4.412857122005527e-11,  1.933076973118601e-13,  2.113564100062505e-15,  9.625644495412777e-18,  1.566682836199620e-20,
 -1.251752384206595e-22, -1.253190346162344e-24, -5.524989364009563e-27,  1.867790984545329e+00, -1.059716980043960e-03, -5.828375847515661e-06, -2.472331861133128e-08,
 -7.493908292324744e-11, -7.621405810754053e-14,  9.212864359345486e-16,  8.169568750495315e-18,  3.906467015158432e-20,  9.978250490991391e-23, -1.902232970237056e-25,
 -3.919916353097007e-27,  1.916389304800248e+00, -6.931115975253046e-04, -4.081989005653945e-06, -1.972665248646609e-08, -7.884981233913764e-11, -2.387646084449241e-13,
 -3.107079958679212e-16,  2.410773229498834e-18,  2.531074237150342e-20,  1.466421381401576e-22,  5.947649200741173e-25,  1.362321820301086e-27,  1.954479973861757e+00,
 -3.872758044609791e-04, -2.401307374676288e-06, -1.271497750681901e-08, -5.969580425874030e-11, -2.480594848693457e-13, -8.775315561574199e-16, -2.296627999334631e-18,
 -1.142238400246644e-21,  3.828337105748375e-23,  3.439811955990043e-25,  2.057193418893809e-27,  1.981338125769817e+00, -1.616721385479776e-04, -1.038435777609143e-06,
 -5.837494013326434e-09, -3.015084784537643e-11, -1.456885051097137e-13, -6.618508244690597e-16, -2.815872153130384e-18, -1.106017351869016e-20, -3.874392573163459e-23,
 -1.100552347813391e-25, -1.574661534995620e-28,  1.996443190762912e+00, -3.112653294085872e-05, -2.038620235871720e-07, -1.183476347604182e-09, -6.418235647412937e-12,
 -3.327231548612186e-14, -1.668453470540587e-16, -8.147354126379500e-19, -3.889477505984407e-21, -1.819314210538394e-23, -8.347124744383890e-26, -3.757096256269265e-28,
  8.322679561269337e-04, -5.402760208333828e-06,  2.629472680856075e-08, -1.137056751499393e-10,  4.606821289785989e-13, -1.790609298541480e-15,  6.760677531411172e-18,
 -2.498225222497117e-20,  9.076958571156412e-23, -3.253565248175414e-25,  1.152896707838634e-27, -4.045927321765226e-30,  7.486623235569644e-03, -4.848246713343754e-05,
  2.347435870903295e-07, -1.006100822651836e-09,  4.020879586689840e-12, -1.532576172266268e-14,  5.633960650138169e-17, -2.009747493027844e-19,  6.977112856128750e-22,
 -2.360199174677728e-24,  7.774138829031677e-27, -2.488737303282517e-29,  2.077505259219688e-02, -1.338822659439872e-04,  6.415045834135874e-07, -2.699974479441856e-09,
  1.048831523772505e-11, -3.834147850649717e-14,  1.328224663376120e-16, -4.359594211321350e-19,  1.346001231092729e-21, -3.842634280723865e-24,  9.743798621371507e-27,
 -1.959708588220328e-29,  4.065662503805009e-02, -2.600816496293817e-04,  1.226519303467914e-06, -5.018697742413851e-09,  1.862873190675217e-11, -6.346559784755753e-14,
  1.971254325322424e-16, -5.423379696430323e-19,  1.213189275737419e-21, -1.481228648421990e-24, -4.810997394913893e-27,  4.902913142345204e-29,  6.706901776498154e-02,
 -4.247970448636962e-04,  1.960247202556260e-06, -7.710323251407601e-09,  2.676626616670911e-11, -8.140094833293445e-14,  2.051219994625086e-16, -3.417314320239505e-19,
 -2.842180687893946e-22,  5.952989824913823e-24, -3.440624584518763e-26,  1.449339029867499e-28,  9.992739111177822e-02, -6.249795225821102e-04,  2.804348404645992e-06,
 -1.046311775694591e-08,  3.298361062794651e-11, -8.281131550887231e-14,  1.218798260722620e-16,  2.454817517955696e-19, -3.017524723260285e-21,  1.558090934404741e-23,
 -5.781150809739968e-26,  1.541079611339683e-28,  1.391228667149415e-01, -8.568136253476929e-04,  3.712637145686329e-06, -1.292610429263076e-08,  3.537059858609899e-11,
 -6.046075951747031e-14, -6.430379782251503e-17,  1.130785886243857e-18, -5.930037272066619e-21,  2.061143496153782e-23, -4.319277772757239e-26, -3.089488314180548e-29,
  1.845205914544083e-01, -1.115719063057889e-03,  4.632340837384588e-06, -1.473433959862009e-08,  3.230393243622165e-11, -1.129556749070275e-14, -3.316210125056546e-16,
  2.037776059908953e-18, -7.256726028509305e-21,  1.342930078355782e-23,  2.818833634991935e-26, -3.789424113657504e-28,  2.359573673362777e-01, -1.396357641122382e-03,
  5.505705402343259e-06, -1.553841429523126e-08,  2.273476996763497e-11,  6.189712531845960e-14, -6.217318763141009e-16,  2.552908226258083e-18, -5.216266379918403e-21,
 -9.251183955890069e-24,  1.361149947119909e-25, -6.481633783182435e-28,  2.932388266488095e-01, -1.692648511213829e-03,  6.271990043992805e-06, -1.503730467222289e-08,
  6.454305404999866e-12,  1.496468556895634e-13, -8.467493904270365e-16,  2.250293329841986e-18,  9.908169798083991e-22, -4.157124964936412e-23,  2.133881849788662e-25,
 -4.840658726708142e-28,  3.561361333665767e-01, -1.997795689165965e-03,  6.869892132783394e-06, -1.301319995461812e-08, -1.569908408117066e-11,  2.361463793662003e-13,
 -9.073555121006445e-16,  8.693333367939446e-19,  1.025608059707715e-20, -6.736666389396419e-23,  1.724970143382580e-25,  2.969154894463080e-28,  4.243821969299551e-01,
 -2.304332771982137e-03,  7.240432841626596e-06, -9.366259428879186e-09, -4.173299027295950e-11,  3.010704099904836e-13, -7.206259064215014e-16, -1.503957194041308e-18,
  1.922310250950747e-20, -6.537493811343220e-23, -3.372832890755744e-26,  1.393167919476256e-27,  4.976673946279560e-01, -2.604190891375278e-03,  7.330313112065379e-06,
 -4.146420375652642e-09, -6.853875368391748e-11,  3.229656427462605e-13, -2.528184677077184e-16, -4.324343579979916e-18,  2.300350830843527e-20, -2.089473738600690e-23,
 -3.461741208179677e-25,  1.967090194922254e-27,  5.756348157408551e-01, -2.888797117717202e-03,  7.095713144977275e-06,  2.421583293836346e-09, -9.211500887081427e-11,
  2.840137916578731e-13,  4.512187222528855e-16, -6.622765057180105e-18,  1.710821843112201e-20,  6.032249300730418e-23, -5.804455342565239e-25,  1.103775345887366e-27,
  6.578750667433014e-01, -3.149211677818280e-03,  6.506451837914157e-06,  9.924823348279061e-09, -1.080057674694367e-10,  1.755582476530715e-13,  1.253247678330930e-15,
 -7.246094321339069e-18,  1.643914302870689e-22,  1.444112419597842e-22, -5.031716890849286e-25, -1.313751092461929e-27,  7.439207151481764e-01, -3.376313298671146e-03,
  5.550340260925157e-06,  1.776606403445963e-08, -1.119563018821790e-10,  3.297528001477537e-15,  1.933303394389541e-15, -5.294727384358034e-18, -2.373430467384145e-20,
  1.774821184217134e-22, -1.997475781511893e-27, -3.925973380445413e-27,  8.332405033682554e-01, -3.561042455844147e-03,  4.237451348301471e-06,  2.519095069698432e-08,
 -1.007480228467891e-10, -2.094155971960849e-13,  2.236139523591992e-15, -6.507480489499624e-19, -4.470000285737814e-20,  1.134694650440650e-22,  7.407802274774659e-25,
 -4.310505707777328e-27,  9.252335368926587e-01, -3.694711866225981e-03,  2.603885931696623e-06,  3.134392056597680e-08, -7.311402125088033e-11, -4.219892274890406e-13,
  1.951444571120277e-15,  5.623141772086441e-18, -5.016438914320991e-20, -4.733193477710882e-23,  1.233788937013047e-24, -8.664921054421541e-28,  1.019223746427944e+00,
 -3.769391625243685e-03,  7.144497046115931e-07,  3.535608979326415e-08, -3.056475198321615e-11, -5.823302435113829e-13,  1.011561804826919e-15,  1.130023564318676e-17,
 -3.142355156906249e-20, -2.337641032586496e-22,  9.493919312488004e-25,  4.903527831382018e-27,  1.114455043501645e+00, -3.778372174030650e-03, -1.336514136162386e-06,
  3.646395608884450e-08,  2.211697789238271e-11, -6.385367252624408e-13, -4.275681877853086e-16,  1.364652303659613e-17,  8.926010449190528e-21, -3.237095602113880e-22,
 -1.941063826731253e-25,  8.187510220988728e-27,  1.210087732632565e+00, -3.716700882121357e-03, -3.427027842758606e-06,  3.415057309670274e-08,  7.699298036070556e-11,
 -5.552479735363696e-13, -1.969288337295583e-15,  1.068429788376929e-17,  5.365748940785119e-20, -2.193456413295893e-22, -1.514144855348073e-24,  4.540332238097494e-27,
  1.305196904715416e+00, -3.581776539791098e-03, -5.413048196296858e-06,  2.829095083889138e-08,  1.239487455616771e-10, -3.306411687665400e-13, -3.065028585644459e-15,
  2.598968685355435e-18,  7.675824467594075e-20,  5.827189040735875e-23, -1.878451799679284e-24, -4.599466368548471e-27,  1.398773701826426e+00, -3.373969859904210e-03,
 -7.138485756442924e-06,  1.927204347347319e-08,  1.526352206759546e-10, -7.376805076917927e-15, -3.216439990041444e-15, -7.579551590879003e-18,  5.895792352885212e-20,
  3.373589850924917e-22, -6.940610353015154e-25, -1.083401560863718e-26,  1.489730487810859e+00, -3.097217367796579e-03, -8.450020928499982e-06,  8.047875553455313e-09,
  1.551772755230353e-10,  3.302581860615502e-13, -2.233174806704031e-15, -1.489188144930746e-17,  4.834352065583291e-21,  3.960906481579638e-22,  1.227757187357866e-24,
 -6.531162683456299e-27,  1.576911042001801e+00, -2.759512465380666e-03, -9.216243822546649e-06, -3.912607557232538e-09,  1.290374197777375e-10,  5.781361496560740e-13,
 -4.175757915415969e-16, -1.507954972431081e-17, -5.331723855762262e-20,  1.583105372114150e-22,  2.103132733510728e-24,  4.891710260153672e-27,  1.659106860667440e+00,
 -2.373194905014437e-03, -9.349422099416878e-06, -1.481674455047139e-08,  7.901820254345174e-11,  6.505660540370886e-13,  1.475739140053677e-15, -7.652689640373827e-18,
 -7.496617260545279e-20, -1.912796677291087e-22,  9.868520676678149e-25,  1.044429196613517e-26,  1.735080437534213e+00, -1.954925103361899e-03, -8.826704870840413e-06,
 -2.288026300258647e-08,  1.723403923510158e-11,  5.216159206647209e-13,  2.574096027475881e-15,  2.979397730019171e-18, -4.472423067720213e-20, -3.439653368704129e-22,
 -9.198930654120265e-25,  3.628206566122450e-27,  1.803595938931523e+00, -1.525231877331100e-03, -7.706158093072586e-06, -2.675294042596920e-08, -3.973305711351120e-11,
  2.473195819411003e-13,  2.389351685911243e-15,  1.004472775913083e-17,  1.019902601968879e-20, -1.802274257441613e-22, -1.500394831860355e-24, -5.656679014959905e-27,
  1.863456954720353e+00, -1.107551197191620e-03, -6.132296013860455e-06, -2.593325647227931e-08, -7.622298285269635e-11, -5.121369279458627e-14,  1.168062823929971e-15,
  9.475284907737915e-18,  4.247492745687605e-20,  8.834888524867093e-23, -3.911691969818439e-25, -5.253312588736142e-27,  1.913550016600487e+00, -7.267362014725131e-04,
 -4.326437247735717e-06, -2.102683232318941e-08, -8.369371247974340e-11, -2.453150119864406e-13, -2.310401061275493e-16,  3.309888479770207e-18,  3.103203389936748e-20,
  1.715739957425698e-22,  6.500876800126439e-25,  1.122307887269179e-27,  1.952891459957830e+00, -4.071132042311294e-04, -2.559785387801493e-06, -1.371096611461859e-08,
 -6.487282586378314e-11, -2.698946666190536e-13, -9.421216733984492e-16, -2.308287290553569e-18,  5.067494913416213e-22,  5.399767557480812e-23,  4.454866852850236e-25,
  2.572610836929903e-27,  1.980674366716524e+00, -1.702682527019023e-04, -1.111479212248676e-06, -6.344108336584361e-09, -3.323006081661005e-11, -1.625603710018006e-13,
 -7.458660163328953e-16, -3.192976515190555e-18, -1.253572933000895e-20, -4.326941461036583e-23, -1.157811372414452e-25, -9.710783660602309e-29,  1.996315330361460e+00,
 -3.281603378133351e-05, -2.187025766829445e-07, -1.291717272071094e-09, -7.125648001533341e-12, -3.756504830749057e-14, -1.915036744907956e-16, -9.503561347854736e-19,
 -4.608737495120829e-21, -2.188744218317120e-23, -1.018934385204290e-25, -4.649869022790082e-28,  8.110691626755188e-04, -5.197737626340380e-06,  2.497333031018887e-08,
 -1.066126747120270e-10,  4.264374973749943e-13, -1.636429364571484e-15,  6.100139909562991e-18, -2.225646714673442e-20,  7.984567939130138e-23, -2.826109285594143e-25,
  9.888864790233709e-28, -3.427280391210944e-30,  7.296374314661642e-03, -4.665174042412123e-05,  2.230464995139501e-07, -9.441472731676459e-10,  3.727442760384869e-12,
 -1.403869217418433e-14,  5.101253057468313e-17, -1.799495249794758e-19,  6.180871984543156e-22, -2.070086879365024e-24,  6.756434518746900e-27, -2.145923482141289e-29,
  2.024958635576462e-02, -1.288770324039776e-04,  6.100870124564885e-07, -2.538126936082311e-09,  9.752398924869793e-12, -3.529547971296959e-14,  1.211983413591098e-16,
 -3.950271895389018e-19,  1.214476280740071e-21, -3.469887119882972e-24,  8.899987998572020e-27, -1.871639302125776e-29,  3.963554835568046e-02, -2.505054205011724e-04,
  1.168042220266542e-06, -4.730540560772871e-09,  1.740552248957953e-11, -5.891247663109899e-14,  1.824752203616532e-16, -5.044022342864426e-19,  1.156888918937158e-21,
 -1.634013376067913e-24, -2.910059191056806e-27,  3.778719150422883e-29,  6.540061767348855e-02, -4.094780043427824e-04,  1.870240017972521e-06, -7.294822934714412e-09,
  2.518669692825457e-11, -7.659368101431783e-14,  1.954565837866664e-16, -3.476510347906757e-19, -9.320726797264770e-23,  4.697602061865258e-24, -2.852297056456666e-26,
  1.229855440828830e-28,  9.747155990004112e-02, -6.030381182849908e-04,  2.681903283462151e-06, -9.948468718925409e-09,  3.135713797941377e-11, -7.981412653149639e-14,
  1.274826820272895e-16,  1.574623643248664e-19, -2.496626399229351e-21,  1.340136540312858e-23, -5.123630316597723e-26,  1.444308449301299e-28,  1.357540454844791e-01,
 -8.277234527786606e-04,  3.560879324422738e-06, -1.236992190096821e-08,  3.414840715196064e-11, -6.164487597824001e-14, -3.518929001522232e-17,  9.525614471837492e-19,
 -5.219350400730234e-21,  1.886753664102867e-23, -4.375004362791148e-26,  3.755668887309700e-30,  1.801307252244153e-01, -1.079358817874263e-03,  4.458621135756120e-06,
 -1.421969747091378e-08,  3.200292002725778e-11, -1.859556564230119e-14, -2.777402464751123e-16,  1.813482655427326e-18, -6.756759173512642e-21,  1.424895067154995e-23,
  1.340276484548049e-26, -2.953679649732099e-28,  2.304588559864431e-01, -1.353051568996788e-03,  5.321465260206104e-06, -1.516554121331091e-08,  2.382918816454461e-11,
  4.781420391266014e-14, -5.526302254589838e-16,  2.381655386294025e-18, -5.457974979725300e-21, -4.354492237031588e-24,  1.092794010572242e-25, -5.713708662472933e-28,
  2.865674443789419e-01, -1.643192405518964e-03,  6.092257250152642e-06, -1.491117497992597e-08,  9.249139189850485e-12,  1.300832266975912e-13, -7.835107748799345e-16,
  2.259659392721000e-18, -3.573508774942360e-22, -3.347324441510490e-23,  1.912842510969669e-25, -5.154813451944293e-28,  3.482538743159997e-01, -1.943465104553309e-03,
  6.712378669354487e-06, -1.322777615575932e-08, -1.119176783709522e-11,  2.146968363510008e-13, -8.787744197996898e-16,  1.160078081813375e-18,  7.957642956214490e-21,
 -6.026895315963211e-23,  1.809058223960481e-25,  9.328361453195507e-29,  4.152799855018816e-01, -2.246869789619285e-03,  7.124226987789244e-06, -9.986768798842605e-09,
 -3.588759327695503e-11,  2.833373882880461e-13, -7.544797549575769e-16, -9.266196270602231e-19,  1.685929331007262e-20, -6.558575349735544e-23,  2.104635122002338e-26,
  1.099372316928186e-27,  4.873675752697010e-01, -2.545765568630231e-03,  7.274188327719348e-06, -5.191735288078684e-09, -6.214949826690475e-11,  3.155274143324871e-13,
 -3.637256806896744e-16, -3.602771764134491e-18,  2.202261459596464e-20, -3.304423822238177e-23, -2.622529493067563e-25,  1.836772463250614e-27,  5.641933079220757e-01,
 -2.831939796626418e-03,  7.116118289162954e-06,  9.937118361951987e-10, -8.634113331775180e-11,  2.926815040760613e-13,  2.737408803716796e-16, -6.044936292447298e-18,
  1.887452298044909e-20,  3.817416726713504e-23, -5.247808258752603e-25,  1.404646617624696e-27,  6.453830364385709e-01, -3.096712772039177e-03,  6.615302138249892e-06,
  8.226385711376929e-09, -1.042102342729415e-10,  2.032067609379230e-13,  1.051183952933896e-15, -7.161637470086088e-18,  4.988953092282728e-21,  1.233437011222222e-22,
 -5.450182031766511e-25, -6.020256118973798e-28,  7.305055746542415e-01, -3.331088236489272e-03,  5.752795425721443e-06,  1.597775996212457e-08, -1.114387854716377e-10,
  4.783785285588447e-14,  1.775376575705823e-15, -5.952338460092541e-18, -1.738644381261322e-20,  1.741218794817857e-22, -1.614905389616560e-25, -3.305810935893358e-27,
  8.190660081956077e-01, -3.525961382296022e-03,  4.529942153812957e-06,  2.354838270897015e-08, -1.044019558236427e-10, -1.561245655628000e-13,  2.198545670786360e-15,
 -2.010447218203640e-18, -4.012823569754328e-20,  1.392251906339411e-22,  5.454976307298844e-25, -4.518018276603085e-27,  9.104987048403085e-01, -3.672396782237551e-03,
  2.972723900835715e-06,  3.010917288526274e-08, -8.107364873836770e-11, -3.734478127768070e-13,  2.086230093289742e-15,  4.000044769938120e-18, -5.099277778605594e-20,
  8.668806909837867e-25,  1.166861025347842e-24, -2.140964981705358e-27,  1.004160285292649e+00, -3.761988124955820e-03,  1.135408789625283e-06,  3.477530543618609e-08,
 -4.194357233970184e-11, -5.543770124728242e-13,  1.312680098878433e-15,  1.016776062227017e-17, -3.910725577924587e-20, -1.918887612734921e-22,  1.133731822002551e-24,
  3.444133271201413e-27,  1.099322949049524e+00, -3.787308974961010e-03, -8.972463174357919e-07,  3.671523466746591e-08,  9.274698313273125e-12, -6.441916575349148e-13,
 -4.322519798246829e-17,  1.374490676163008e-17, -2.780218578358167e-21, -3.242488411141196e-22,  1.666663343539206e-25,  8.122341423076658e-27,  1.195168720534354e+00,
 -3.742457795406033e-03, -3.010204135308920e-06,  3.529115826251072e-08,  6.544059397694108e-11, -5.987346479457113e-13, -1.647357437415164e-15,  1.226373208755857e-17,
  4.472447209844420e-20, -2.753198159282614e-22, -1.270340742872289e-24,  6.490495541322243e-27,  1.290785386798552e+00, -3.623689774060723e-03, -5.061888796839280e-06,
  3.021726113902668e-08,  1.166076505525053e-10, -4.030496327458463e-13, -2.957659897615810e-15,  5.073937740142094e-18,  7.746061056536699e-20, -2.026643551264180e-23,
 -2.031658194577400e-24, -2.294398235974919e-27,  1.385165129852408e+00, -3.430111209893594e-03, -6.892586896126737e-06,  2.170876429761517e-08,  1.516996972073646e-10,
 -8.689389516687935e-14, -3.400472125675136e-15, -5.504874854108531e-18,  7.048753707911007e-20,  2.999960700689748e-22, -1.174375891598203e-24, -1.087225162967708e-26,
  1.477207089868581e+00, -3.164388546608061e-03, -8.338341252171671e-06,  1.058049992738338e-08,  1.612128499451812e-10,  2.716892991723759e-13, -2.645773971884632e-15,
 -1.450016600445772e-17,  1.990101095193695e-20,  4.386487406447791e-22,  8.803373661682645e-25, -9.247158207644544e-27,  1.565725285584555e+00, -2.833394248442917e-03,
 -9.250428115356469e-06, -1.756198528377683e-09,  1.404647522619071e-10,  5.628606631480329e-13, -8.627145003578997e-16, -1.667789118956115e-17, -4.605715119607906e-20,
  2.461564190396651e-22,  2.273317648522575e-24,  2.716291733519956e-27,  1.649463395883214e+00, -2.448678991616018e-03, -9.519201890434732e-06, -1.344651618652806e-08,
  9.236491781451987e-11,  6.831353443309483e-13,  1.226903413807625e-15, -1.015324424624853e-17, -8.102754927503218e-20, -1.422467451958162e-22,  1.473072676324387e-24,
  1.157709456913393e-26,  1.727117778633661e+00, -2.026631492501650e-03, -9.099258349444391e-06, -2.251767790096740e-08,  2.829001271232348e-11,  5.842218930859049e-13,
  2.635572551888063e-15,  1.343351108007712e-18, -5.772438568954775e-20, -3.768533750707599e-22, -7.059532088095709e-25,  6.175124752724133e-27,  1.797369664933452e+00,
 -1.588175693962141e-03, -8.030834165416747e-06, -2.734588628369823e-08, -3.419027601523366e-11,  3.080695093821052e-13,  2.674112444304225e-15,  1.025521786484482e-17,
  2.570936830981037e-21, -2.451743600031290e-22, -1.744942585469101e-24, -5.378053548021701e-27,  1.858926632908640e+00, -1.157875161754304e-03, -6.450841111818692e-06,
 -2.715940223040125e-08, -7.694462587292862e-11, -1.984008075989535e-14,  1.452853435546070e-15,  1.088187328948872e-17,  4.531411805880294e-20,  6.763430276588144e-23,
 -6.559797450199991e-25, -6.820819717395260e-27,  1.910572218127115e+00, -7.623801267669990e-04, -4.586956624713579e-06, -2.240544979725291e-08, -8.864735071169545e-11,
 -2.496297512310495e-13, -1.234960109646603e-16,  4.406848813501496e-18,  3.768763160940963e-20,  1.984485207323534e-22,  6.903024420765708e-25,  6.628712171059141e-28,
  1.951220983079055e+00, -4.282676774461073e-04, -2.730726942372842e-06, -1.479336491943331e-08, -7.050204603511176e-11, -2.932774140969951e-13, -1.006208606118197e-15,
 -2.257297815398521e-18,  2.800266316903026e-21,  7.425496555028113e-23,  5.718711959430464e-25,  3.189678265676297e-27,  1.979975014791824e+00, -1.794738957416208e-04,
 -1.190909123568762e-06, -6.902802809704513e-09, -3.666775824371964e-11, -1.815807961498405e-13, -8.411259531694897e-16, -3.619943701446184e-18, -1.417758483858463e-20,
 -4.795957393748880e-23, -1.179829027219750e-25,  5.328876932298390e-30,  1.996180466000966e+00, -3.462965376757410e-05, -2.349128734626990e-07, -1.411997125441027e-09,
 -7.925154580617690e-12, -4.249787856300778e-14, -2.203026644473358e-16, -1.111271367024749e-18, -5.475259786653055e-21, -2.640350855434518e-23, -1.247253355156566e-25,
 -5.770462194828258e-28,  7.906698434282794e-04, -5.002954837969253e-06,  2.373386137031471e-08, -1.000437556748125e-10,  3.951239192292217e-13, -1.497224592680078e-15,
  5.511252971010684e-18, -1.985684040536971e-20,  7.034880260636249e-23, -2.459123212024341e-25,  8.498153188610479e-28, -2.909190402515797e-30,  7.113265745503327e-03,
 -4.491169454766963e-05,  2.120655120950915e-07, -8.866895331825891e-10,  3.458515063972020e-12, -1.287268651673563e-14,  4.624000507535594e-17, -1.613127374816415e-19,
  5.482093840791464e-22, -1.817815853268094e-24,  5.878508191084501e-27, -1.852106380823264e-29,  1.974365039616096e-02, -1.241155663854416e-04,  5.805429263570431e-07,
 -2.387581470505581e-09,  9.074703226026798e-12, -3.251517011521454e-14,  1.106633670110686e-16, -3.580954883250003e-19,  1.095772636160455e-21, -3.130051638617462e-24,
  8.099646752821086e-27, -1.763853909287908e-29,  3.865186239569612e-02, -2.413835024084112e-04,  1.112908539296155e-06, -4.461244976863286e-09,  1.626994441219129e-11,
 -5.469842226247170e-14,  1.688612585829195e-16, -4.683423643171009e-19,  1.096344175492227e-21, -1.719957578285589e-24, -1.452593942717642e-27,  2.879521992452136e-29,
  6.379208461012568e-02, -3.948594997012403e-04,  1.785070330386720e-06, -6.903839211214995e-09,  2.370094330892142e-11, -7.201972214458470e-14,  1.857045110462314e-16,
 -3.481378129741764e-19,  5.662073897546872e-23,  3.659099942813716e-24, -2.354092685460461e-26,  1.039251103425974e-28,  9.510157367837620e-02, -5.820520096049086e-04,
  2.565479808961511e-06, -9.459357191888727e-09,  2.979176360132031e-11, -7.671023066382406e-14,  1.308429188046218e-16,  8.490620121169304e-20, -2.049564972219457e-21,
  1.147579611453903e-23, -4.512376750046392e-26,  1.332395644138629e-28,  1.324991986176205e-01, -7.998209800224446e-04,  3.415677698417940e-06, -1.183344771677348e-08,
  3.290912969227502e-11, -6.218761591189919e-14, -1.075613107955991e-17,  7.960729964865660e-19, -4.571505795151770e-21,  1.712878294062022e-23, -4.300716147320572e-26,
  2.856798940236052e-29,  1.758835594430767e-01, -1.044363720006897e-03,  4.291043646307106e-06, -1.371097138337312e-08,  3.156833978644555e-11, -2.467595675530394e-14,
 -2.299120479752412e-16,  1.605553120398866e-18, -6.237080193452865e-21,  1.454679560744519e-23,  2.002624431281281e-27, -2.248953756408084e-28,  2.251306498139528e-01,
 -1.311201243247372e-03,  5.141795651868068e-06, -1.477732224314929e-08,  2.465814007580266e-11,  3.533146279556265e-14, -4.884068773455580e-16,  2.205287819917602e-18,
 -5.541907881567359e-21, -4.634692661096736e-25,  8.582914853619336e-26, -4.948876598762814e-28,  2.800910214276947e-01, -1.595167376955660e-03,  5.914293671828069e-06,
 -1.474337565970759e-08,  1.166787483093887e-11,  1.120358597149820e-13, -7.205712920195272e-16,  2.230375716814464e-18, -1.430158905684189e-21, -2.627841449459309e-23,
  1.684284546965913e-25, -5.195515514690915e-28,  3.405864027688130e-01, -1.890403733663743e-03,  6.552708965108997e-06, -1.337362733272750e-08, -7.105965526308160e-12,
  1.940228566356059e-13, -8.430433964393934e-16,  1.381409334415058e-18,  5.918745387107815e-21, -5.300014723562855e-23,  1.813890182114981e-25, -6.406815412151553e-29,
  4.064057217596526e-01, -2.190364675803247e-03,  7.001124347478575e-06, -1.051662790323347e-08, -3.040371638861047e-11,  2.649773195947663e-13, -7.732254091187662e-16,
 -4.246474781249522e-19,  1.452426831488870e-20, -6.385835089443776e-23,  6.334367960054183e-26,  8.276256504114290e-28,  4.773004821993689e-01, -2.487837693610160e-03,
  7.206127773846486e-06, -6.136150052784402e-09, -5.593400858691732e-11,  3.056659327497321e-13, -4.549295275639272e-16, -2.918951076247414e-18,  2.066321906319579e-20,
 -4.196893151816525e-23, -1.853206864967989e-25,  1.653280188943675e-27,  5.529794495844137e-01, -2.774986190018889e-03,  7.119948254220645e-06, -3.406166031568504e-10,
 -8.043515774251203e-11,  2.972895649320966e-13,  1.131168841059968e-16, -5.422889877715187e-18,  1.988641028416950e-20,  1.847933753047034e-23, -4.586814229816257e-25,
  1.580563437671958e-27,  6.331026157912439e-01, -3.043423516159838e-03,  6.704152955563920e-06,  6.592837985465954e-09, -9.990994740636674e-11,  2.260508570781483e-13,
  8.535304494888820e-16, -6.935192890744730e-18,  9.032264449125935e-21,  1.012022906111816e-22, -5.575604126077092e-25,  1.444215510066542e-29,  7.172744380668251e-01,
 -3.284329164486109e-03,  5.933869336641012e-06,  1.420465081841936e-08, -1.100697384638754e-10,  8.838977616312748e-14,  1.601853842191094e-15, -6.409929671555223e-18,
 -1.126755260706760e-20,  1.649551246135388e-22, -2.917503484386789e-25, -2.606904963098656e-27,  8.050363910380804e-01, -3.488620138816147e-03,  4.802406344557292e-06,
  2.185581669952827e-08, -1.070020856149108e-10, -1.041753113177603e-13,  2.125056955899032e-15, -3.210534951412551e-18, -3.477130374613369e-20,  1.570703044523990e-22,
  3.472517437842039e-25, -4.450916569411973e-27,  8.958589377327192e-01, -3.647192352555368e-03,  3.326013337929868e-06,  2.875499806597893e-08, -8.803378934348389e-11,
 -3.222183194102691e-13,  2.175454333374621e-15,  2.377579391012017e-18, -5.014711121335013e-20,  4.533388599181728e-23,  1.048963161138677e-24, -3.173575977000086e-27,
  9.891331250539516e-01, -3.751247879691630e-03,  1.548325786034596e-06,  3.401731386590601e-08, -5.269376564518652e-11, -5.196037976042372e-13,  1.578882825940316e-15,
  8.814821788206373e-18, -4.516664113702473e-20, -1.439709719112640e-22,  1.250576425579236e-24,  1.856014036519901e-27,  1.084162149837289e+00, -3.792723070407614e-03,
 -4.561981226685104e-07,  3.676063334271492e-08, -3.588432939882256e-12, -6.406315495203201e-13,  3.386450050084830e-16,  1.347115066377033e-17, -1.424822801672067e-20,
 -3.105713919522119e-22,  5.129052284217286e-25,  7.532766559807860e-27,  1.180153432127057e+00, -3.764828576492387e-03, -2.580829736696753e-06,  3.624038160808154e-08,
  5.309914509456433e-11, -6.339983832414741e-13, -1.285492941737915e-15,  1.352711265663933e-17,  3.397168259835074e-20, -3.199290025345740e-22, -9.487328159331377e-25,
  8.051596932534277e-27,  1.276211977931785e+00, -3.662703376052315e-03, -4.688365690546736e-06,  3.201469214711356e-08,  1.078497698805530e-10, -4.720497685972163e-13,
 -2.781109714427978e-15,  7.525167032360881e-18,  7.525077807610024e-20, -1.027919758456549e-22, -2.075338238413365e-24,  3.496253664371698e-28,  1.371336111530546e+00,
 -3.484168783187327e-03, -6.617590399070271e-06,  2.411757451771641e-08,  1.491345793003422e-10, -1.700903492849392e-13, -3.521476641972954e-15, -3.086469070818078e-18,
  8.032795636513618e-20,  2.436190951960864e-22, -1.638869168261885e-24, -1.010221915155400e-26,  1.464416988761244e+00, -3.230543172860418e-03, -8.195731053909478e-06,
  1.319978916730240e-08,  1.659791984458161e-10,  2.034054437589110e-13, -3.040445382399658e-15, -1.360471761632158e-17,  3.622117889937200e-20,  4.649632105311740e-22,
  4.171154388998388e-25, -1.175128853713041e-26,  1.554243623326105e+00, -2.907442917043274e-03, -9.257650478345092e-06,  5.800085754529067e-10,  1.514762649192457e-10,
  5.363940215627879e-13, -1.348870613408598e-15, -1.799219762316656e-17, -3.553721351392931e-20,  3.386687060721473e-22,  2.330896081756694e-24, -2.207117377545474e-28,
  1.639515387600887e+00, -2.525451868000245e-03, -9.671237277715167e-06, -1.185787795097282e-08,  1.062975212016432e-10,  7.088722403871665e-13,  9.056293092254043e-16,
 -1.281567808672268e-17, -8.496307928950189e-20, -7.292867955744746e-23,  1.996684671357342e-24,  1.210209935321799e-26,  1.718863965248874e+00, -2.100497802559469e-03,
 -9.366357898378585e-06, -2.196811653702603e-08,  4.060890209383136e-11,  6.477055525088537e-13,  2.645250796708634e-15, -7.257649541063307e-19, -7.172622167461440e-20,
 -3.988069132838201e-22, -3.699511128835297e-25,  9.162516630624400e-27,  1.790886378041034e+00, -1.653743778176430e-03, -8.362052179067726e-06, -2.784005484814675e-08,
 -2.736382835936134e-11,  3.756946093992787e-13,  2.960984772807333e-15,  1.018234496358443e-17, -7.566945723863889e-21, -3.194999319273374e-22, -1.965087519439402e-24,
 -4.517047846844469e-27,  1.854189825118915e+00, -1.210806488216110e-03, -6.784147290052789e-06, -2.839168956610498e-08, -7.696720690558211e-11,  1.885062061106797e-14,
  1.778172996283253e-15,  1.236520105527627e-17,  4.719971237180837e-20,  3.488411611496346e-23, -9.944506009625801e-25, -8.593771650229106e-27,  1.907447568957974e+00,
 -8.001757336993066e-04, -4.864497324510472e-06, -2.386386471620856e-08, -9.365885702934042e-11, -2.509698828920515e-13,  1.789208697263364e-17,  5.732534065162637e-18,
  4.533404903962928e-20,  2.264440718411730e-22,  7.039063956689372e-25, -1.034492795299151e-28,  1.949463068771077e+00, -4.508432054698473e-04, -2.915213389349888e-06,
 -1.596965541233646e-08, -7.661414052366211e-11, -3.181721120682217e-13, -1.067723432449214e-15, -2.120216913103013e-18,  5.920874458103805e-21,  1.001424407053562e-22,
  7.277924878700991e-25,  3.916002572295085e-27,  1.979237525596370e+00, -1.893427601990193e-04, -1.277386354745629e-06, -7.519672102182035e-09, -4.050972626670893e-11,
 -2.030370140916535e-13, -9.491019711287154e-16, -4.102159028448942e-18, -1.598863905961787e-20, -5.263132340369161e-23, -1.144180414289822e-25,  1.686506850510165e-28,
  1.996038078337297e+00, -3.657895477653237e-05, -2.526466627551455e-07, -1.545897481073243e-09, -8.830611332932106e-12, -4.817924221175205e-14, -2.540212386724738e-16,
 -1.302702944110672e-18, -6.522059877429841e-21, -3.193948329377112e-23, -1.530995201272987e-25, -7.180571271552759e-28,  7.710303113177366e-04, -4.817780803583424e-06,
  2.257030280404133e-08, -9.395432679111242e-11,  3.664583735757474e-13, -1.371379990002461e-15,  4.985492189372394e-18, -1.774100592157196e-20,  6.207820264388478e-23,
 -2.143462922929900e-25,  7.316513447641581e-28, -2.474382651269492e-30,  6.936945929858915e-03, -4.325681001462452e-05,  2.017489503758508e-07, -8.333541258268144e-10,
  3.211803071692586e-12, -1.181520403350226e-14,  4.195932276123304e-17, -1.447732644064863e-19,  4.868112022727436e-22, -1.598204244020460e-24,  5.120417830458958e-27,
 -1.600125398841718e-29,  1.925629878193548e-02, -1.195834070680507e-04,  5.527421185044216e-07, -2.247447680171217e-09,  8.450166915232862e-12, -2.997570899685558e-14,
  1.011110967519929e-16, -3.247726420365634e-19,  9.887386010558782e-22, -2.821244175358963e-24,  7.349364996570346e-27, -1.645347804449645e-29,  3.770380200789143e-02,
 -2.326900301609092e-04,  1.060900114536197e-06, -4.209461806780739e-09,  1.521546071294728e-11, -5.079920826511371e-14,  1.562294598948920e-16, -4.342589178018559e-19,
  1.033664672603960e-21, -1.754949713683272e-24, -3.491371720709530e-28,  2.163306902114649e-29,  6.224069200362336e-02, -3.809039825968281e-04,  1.704452792765419e-06,
 -6.535908424224739e-09,  2.230432992378697e-11, -6.767946800940398e-14,  1.760005760355325e-16, -3.443914035428436e-19,  1.724548502209709e-22,  2.803896035214215e-24,
 -1.933902296877434e-26,  8.747836303980477e-29,  9.281370569346391e-02, -5.619742324062889e-04,  2.454777457790852e-06, -8.994791312268518e-09,  2.828911712897380e-11,
 -7.354851379936344e-14,  1.323617761282953e-16,  2.559308543402156e-20, -1.667544061457326e-21,  9.784629598887373e-24, -3.952104903669980e-26,  1.213737784212826e-28,
  1.293536787110904e-01, -7.730547072220894e-04,  3.276794533013924e-06, -1.131685839784602e-08,  3.166451833864810e-11, -6.219425512718863e-14,  9.576228009462163e-18,
  6.593217733308888e-19, -3.985480721512742e-21,  1.543914830040446e-23, -4.135082407539693e-26,  4.558559326452231e-29,  1.717737312979937e-01, -1.010684950255431e-03,
  4.129525333846578e-06, -1.321011101987649e-08,  3.102316864964380e-11, -2.967644936176448e-14, -1.876720417446911e-16,  1.414342709497095e-18, -5.714172666455380e-21,
  1.444703701297410e-23, -6.564635065752015e-27, -1.663958724527587e-28,  2.199670000293458e-01, -1.270769432817191e-03,  4.966856278628412e-06, -1.437775521662458e-08,
  2.525244972427924e-11,  2.433064215024008e-14, -4.291396176047954e-16,  2.028301131945914e-18, -5.501844097817491e-21,  2.556044347928851e-24,  6.567944066557037e-26,
 -4.217501869118191e-28,  2.738038648194931e-01, -1.548557371655919e-03,  5.738564237638655e-06, -1.453968242043351e-08,  1.374068313686037e-11,  9.548555475116219e-14,
 -6.588946897373670e-16,  2.170730000301264e-18, -2.260393447902042e-21, -1.999502331497491e-23,  1.458576779123722e-25, -5.036444181140067e-28,  3.331286124331379e-01,
 -1.838625641038208e-03,  6.391667795307671e-06, -1.345736493869683e-08, -3.424602462377389e-12,  1.742736577297940e-13, -8.019892334437508e-16,  1.541673643300247e-18,
  4.140319090500556e-21, -4.583793834434852e-23,  1.758766338574405e-25, -1.801505149187643e-28,  3.977554706299942e-01, -2.134868352775198e-03,  6.872177665962960e-06,
 -1.096170240502134e-08, -2.529044471073263e-11,  2.463276429578637e-13, -7.789503906253975e-16,  3.902492112362253e-21,  1.227907728607225e-20, -6.066986703858185e-23,
  9.431723430926618e-26,  5.855895090547972e-28,  4.674639422507842e-01, -2.430497960046768e-03,  7.127324053550310e-06, -6.982807331540404e-09, -4.993611314463679e-11,
  2.938401309781762e-13, -5.276395652579687e-16, -2.283194212871500e-18,  1.903587999473586e-20, -4.798850395091440e-23, -1.172248968656751e-25,  1.438426301896105e-27,
  5.419933678191126e-01, -2.718064379357545e-03,  7.108335630826938e-06, -1.579915617756178e-09, -7.447414371033800e-11,  2.982546799103663e-13, -2.973935954646123e-17,
 -4.779283870031823e-18,  2.023843702796474e-20,  1.550200656334818e-24, -3.872813853040411e-25,  1.648714818724456e-27,  6.210366513258788e-01, -2.989500661294559e-03,
  6.773828276424119e-06,  5.031494573972126e-09, -9.519962945397592e-11,  2.442412364331702e-13,  6.639085760441725e-16, -6.592161481694826e-18,  1.227569980214943e-20,
  7.906944435623743e-23, -5.454100231265362e-25,  5.184953971750721e-28,  7.042331007988051e-01, -3.236206177904888e-03,  6.093823386704412e-06,  1.245970449847912e-08,
 -1.079322233330813e-10,  1.246451897569643e-13,  1.418203390005030e-15, -6.677941162331005e-18, -5.564937205469153e-21,  1.512035995444776e-22, -3.905618229134239e-25,
 -1.884900818068751e-27,  7.911603687513127e-01, -3.449181053929084e-03,  5.054344076457598e-06,  2.012985359555291e-08, -1.085834869811197e-10, -5.437310593578481e-14,
  2.020451411314838e-15, -4.230442388660826e-18, -2.891331209286410e-20,  1.671165741121403e-22,  1.572500213324963e-25, -4.151319250301797e-27,  8.813255354883948e-01,
 -3.619228422377660e-03,  3.662418650012869e-06,  2.729775869211287e-08, -9.395158405986714e-11, -2.693880902200906e-13,  2.219862076921517e-15,  8.067941612071488e-19,
 -4.779572543150359e-20,  8.425841279848060e-23,  8.918300090318222e-25, -3.919279799987036e-27,  9.741554708052668e-01, -3.737243551059035e-03,  1.951138903708898e-06,
  3.309321679199883e-08, -6.268778083148948e-11, -4.789165926848750e-13,  1.804753627443881e-15,  7.296347835895082e-18, -4.943380895429321e-20, -9.278736208449227e-23,
  1.296983240096724e-24,  2.623067708550054e-28,  1.068986749536432e+00, -3.794610091300746e-03, -1.583605060985355e-08,  3.660128614847343e-08, -1.628954610284115e-11,
 -6.280394578905923e-13,  7.078051118168304e-16,  1.284091004204376e-17, -2.498211993784717e-20, -2.837061395952187e-22,  8.226556899379683e-25,  6.476894290643355e-27,
  1.165055597920912e+00, -3.783722207021706e-03, -2.141271151440695e-06,  3.698698275493222e-08,  4.014192742092464e-11, -6.601931487999200e-13, -8.932940270688307e-16,
  1.442331768628188e-17,  2.185976283165208e-20, -3.504458103538616e-22, -5.695388588345068e-25,  9.089373086190289e-27,  1.261488624132231e+00, -3.698645001918047e-03,
 -4.294158899704922e-06,  3.366121042086275e-08,  9.775976495170211e-11, -5.359998292445373e-13, -2.537362811825348e-15,  9.858041020666553e-18,  7.006715927068619e-20,
 -1.846810639461496e-22, -1.998812075244314e-24,  3.133715992956962e-27,  1.357295444776159e+00, -3.535911586693058e-03, -6.313989787080726e-06,  2.647189726689806e-08,
  1.448821516503492e-10, -2.553447461066142e-13, -3.570687509369829e-15, -3.891477258708423e-19,  8.781480257620961e-20,  1.695892578364159e-22, -2.050838001752557e-24,
 -8.484878288824584e-27,  1.451364751667334e+00, -3.295430002284816e-03, -8.021278523878681e-06,  1.588390951115287e-08,  1.692874877998857e-10,  1.260101011393160e-13,
 -3.402617099165591e-15, -1.217565134262513e-17,  5.312967726581273e-20,  4.706681074304182e-22, -1.465918148324352e-25, -1.376801959018715e-26,  1.542465832557308e+00,
 -2.981434275882327e-03, -9.235800804833519e-06,  3.087519483278771e-09,  1.618389961230437e-10,  4.978591531242101e-13, -1.866612055384653e-15, -1.891639990565938e-17,
 -2.167843877131584e-20,  4.306905819152501e-22,  2.243845014765451e-24, -3.835998529920545e-27,  1.629257981381446e+00, -2.603360946907809e-03, -9.802855916758437e-06,
 -1.004264467073139e-08,  1.206616550915274e-10,  7.259922004714154e-13,  5.084481031612381e-16, -1.556004798034596e-17, -8.602270722368428e-20,  1.755978692790164e-23,
  2.525283528395196e-24,  1.176100209197548e-26,  1.710310459655391e+00, -2.176471082849748e-03, -9.625638213501855e-06, -2.121130355432043e-08,  5.419483028075555e-11,
  7.106750051359045e-13,  2.590622171511137e-15, -3.252727488456790e-18, -8.624381295905739e-20, -4.045868843926451e-22,  1.050224330934694e-25,  1.246380105296960e-26,
  1.784135484526660e+00, -1.721983364582957e-03, -8.698499035755914e-06, -2.821380753810548e-08, -1.911639478300872e-11,  4.501409703583351e-13,  3.240861012252394e-15,
  9.740635388686698e-18, -2.052800285513721e-20, -4.016599299302957e-22, -2.131020669176214e-24, -2.881143779707044e-27,  1.849235865543076e+00, -1.266463358401416e-03,
 -7.132216135234471e-06, -2.961770924035413e-08, -7.613450276632830e-11,  6.585302122241775e-14,  2.145673709067559e-15,  1.388723524513182e-17,  4.764336590972315e-20,
 -1.301159356905105e-23, -1.414241373075825e-24, -1.050107708844342e-26,  1.904167183944857e+00, -8.402630340502585e-04, -5.160020359497606e-06, -2.540248065731443e-08,
 -9.866007932649961e-11, -2.484426872681847e-13,  1.999768131938485e-16,  7.319062533414031e-18,  5.398895402482575e-20,  2.541956272396686e-22,  6.750743736222805e-25,
 -1.285909983768771e-27,  1.947611808772195e+00, -4.749527878565153e-04, -3.114418769572556e-06, -1.724780126457778e-08, -8.323851949654876e-11, -3.444849168287507e-13,
 -1.123852904473500e-15, -1.867097185784817e-18,  1.009369437739803e-20,  1.329385592351415e-22,  9.181047944644725e-25,  4.752166732998879e-27,  1.978459128905827e+00,
 -1.999341307986748e-04, -1.371649476388305e-06, -8.201591389112935e-09, -4.480786105685644e-11, -2.272533836307208e-13, -1.071416369780953e-15, -4.644976079645630e-18,
 -1.796336816166912e-20, -5.699333260750851e-23, -1.018630584551809e-25,  4.190175502718639e-28,  1.995887599193084e+00, -3.867680853180653e-05, -2.720780774394285e-07,
 -1.695240024913988e-09, -9.858242356410096e-12, -5.473815017255103e-14, -2.936004591264356e-16, -1.531052629300923e-18, -7.790171594096962e-21, -3.874472298718058e-23,
 -1.884568409615531e-25, -8.959353207106056e-28,  7.521133104434033e-04, -4.641630555242369e-06,  2.147714638238441e-08, -8.830407747567258e-11,  3.401881858797403e-13,
 -1.257471613886326e-15,  4.515434086466095e-18, -1.587252470076499e-20,  5.486331688485797e-23, -1.871454735958491e-25,  6.310515705867746e-28, -2.108709427113538e-30,
  6.767084548187176e-03, -4.168196340956891e-05,  1.920494094712667e-07, -7.838023416069252e-10,  2.985249759692548e-12, -1.085511557751162e-14,  3.811538734391851e-17,
 -1.300776790757608e-19,  4.327989310408082e-22, -1.406808085828842e-24,  4.465134390609159e-27, -1.383873823583323e-29,  1.878664140738908e-02, -1.152670938848200e-04,
  5.265645971958393e-07, -2.116912302791207e-09,  7.874200900751301e-12, -2.765468285579895e-14,  9.244554550783752e-17, -2.947027008873993e-19,  8.922941560012405e-22,
 -2.541388597756719e-24,  6.652361442084101e-27, -1.522569371518274e-29,  3.678970211256093e-02, -2.244008207175060e-04,  1.011814378383359e-06, -3.973942653127310e-09,
  1.423600578798963e-11, -4.719193292147981e-14,  1.445237852166556e-16, -4.021934406111509e-19,  9.704482197597197e-22, -1.751646773743467e-24,  4.729565171218616e-28,
  1.595428139867260e-29,  6.074385901997158e-02, -3.675761184792705e-04,  1.628119173396155e-06, -6.189641621817941e-09,  2.099220322191401e-11, -6.357045798676498e-14,
  1.664490290920705e-16, -3.373998340744913e-19,  2.603590630930895e-22,  2.103002064507696e-24, -1.580843990248261e-26,  7.336447522140924e-29,  9.060441231606696e-02,
 -5.427601787586808e-04,  2.349507734778507e-06, -8.553760461431155e-09,  2.684994190356621e-11, -7.036894691236215e-14,  1.323821614217762e-16, -2.242724563221483e-20,
 -1.342497621066169e-21,  8.307070505415559e-24, -3.444395047666256e-26,  1.094289525623035e-28,  1.263130405481688e-01, -7.473750418360929e-04,  3.143991034782133e-06,
 -1.082015867391700e-08,  3.042435453003261e-11, -6.175680278139908e-14,  2.633304685422888e-17,  5.403642583478805e-19, -3.458927012907466e-21,  1.382883952556814e-23,
 -3.908510651967880e-26,  5.652454261780080e-29,  1.677960717853780e-01, -9.782744412445415e-04,  3.973961882523531e-06, -1.271872017878717e-08,  3.038770134678982e-11,
 -3.372554324510510e-14, -1.505526476864279e-16,  1.239746578268017e-18, -5.200434206553665e-21,  1.405282911645466e-23, -1.279756938173012e-26, -1.185677536692701e-28,
  2.149623090303733e-01, -1.231717812730915e-03,  4.796761748641781e-06, -1.397036376359474e-08,  2.564056685155646e-11,  1.469300811611585e-14, -3.747947679393663e-16,
  1.854186379130094e-18, -5.366823061541543e-21,  4.832480044729162e-24,  4.863651973057633e-26, -3.539175399429401e-28,  2.677003528056757e-01, -1.503342885387319e-03,
  5.565467447562783e-06, -1.430539248999261e-08,  1.549713780051952e-11,  8.039264797332403e-14, -5.992273398809394e-16,  2.087963409869546e-18, -2.880466766766570e-21,
 -1.459599761917005e-23,  1.243104675959611e-25, -4.739494027416070e-28,  3.258753528197029e-01, -1.788138925509274e-03,  6.229962327927263e-06, -1.348530565978644e-08,
 -1.280391285354978e-13,  1.555574132413034e-13, -7.572060009190277e-16,  1.649101856491468e-18,  2.614632309928764e-21, -3.898749469046548e-23,  1.660594163208482e-25,
 -2.607215608730655e-28,  3.893251097459669e-01, -2.080423604341807e-03,  6.738368642337018e-06, -1.132795203843017e-08, -2.055061008837436e-11,  2.276765550495804e-13,
 -7.736629754988615e-16,  3.626617798849225e-19,  1.016849433817214e-20, -5.644570014425234e-23,  1.153734248137145e-25,  3.772273309487124e-28,  4.578554383097283e-01,
 -2.373827682929173e-03,  7.038928147992374e-06, -7.735479281238834e-09, -4.419077344472260e-11,  2.804768362458170e-13, -5.833063973517907e-16, -1.702472592020467e-18,
  1.723853866392172e-20, -5.147838361794009e-23, -5.893157408615459e-26,  1.210394646682148e-27,  5.312346955972334e-01, -2.661293334353051e-03,  7.082423726937503e-06,
 -2.723864130972664e-09, -6.852664891747446e-11,  2.960082262786801e-13, -1.545045918839341e-16, -4.133608781108546e-18,  2.003289390267663e-20, -1.249030930648212e-23,
 -3.148899478003510e-25,  1.629021609497976e-27,  6.091873762662220e-01, -2.935094041079730e-03,  6.825230880967789e-06,  3.548182910766918e-09, -9.017017766417730e-11,
  2.580069458036163e-13,  4.852257679350950e-16, -6.157953557247518e-18,  1.473612952639075e-20,  5.783139037202814e-23, -5.136855395253045e-25,  9.039632313613455e-28,
  6.913866830174786e-01, -3.186886681401240e-03,  6.233066429122807e-06,  1.075451762002318e-08, -1.051141793540059e-10,  1.564230781270815e-13,  1.229523885050014e-15,
 -6.772090702516582e-18, -4.208955722895969e-22,  1.341309845430375e-22, -4.579811198344072e-25, -1.186928567102945e-27,  7.774460021259799e-01, -3.407809668790490e-03,
  5.285450838576663e-06,  1.838641069229823e-08, -1.091961520169608e-10, -7.402657584384456e-15,  1.889956918033188e-15, -5.058544986096715e-18, -2.282675359846036e-20,
  1.698833419172708e-22, -1.541523190677701e-26, -3.672189108722391e-27,  8.669092585334048e-01, -3.588644726228790e-03,  3.980803996390566e-06,  2.575433056239316e-08,
 -9.880562960055266e-11, -2.160101064864552e-13,  2.221542920235546e-15, -6.675981165299780e-19, -4.416328905691735e-20,  1.163305670881450e-22,  7.085621965712988e-25,
 -4.360913019966197e-27,  9.592402048957746e-01, -3.720063728831415e-03,  2.341931198552912e-06,  3.201600525184938e-08, -7.181735931015548e-11, -4.333324138496071e-13,
  1.986474238757541e-15,  5.671028666098130e-18, -5.184164764205919e-20, -4.112578424629459e-23,  1.275266130049071e-24, -1.223066383956540e-27,  1.053810829986675e+00,
 -3.792985296750590e-03,  4.214044003188309e-07,  3.624121057713507e-08, -2.865184489235882e-11, -6.068371215433465e-13,  1.054671579431416e-15,  1.188495252494205e-17,
 -3.453811614101489e-20, -2.454968018560310e-22,  1.077419361724962e-24,  5.052111478929177e-27,  1.149889273847869e+00, -3.799067092831353e-03, -1.694012855827155e-06,
  3.752259641586253e-08,  2.675674450119181e-11, -6.767187206482108e-13, -4.815713313803653e-16,  1.491736990351952e-17,  8.931675470326010e-21, -3.650568625392890e-22,
 -1.578995724539911e-25,  9.516456957103516e-27,  1.246627932273273e+00, -3.731356780091542e-03, -3.881203647709103e-06,  3.513639628911225e-08,  8.645444069016855e-11,
 -5.933375594396452e-13, -2.231055283245034e-15,  1.197870128979574e-17,  6.202010561319423e-20, -2.610677859213790e-22, -1.800854355322633e-24,  5.830628606567308e-27,
  1.343052841541921e+00, -3.585113864345478e-03, -5.982601939659808e-06,  2.874450243215679e-08,  1.389190720427659e-10, -3.408494038559356e-13, -3.541441718064810e-15,
  2.502084927398705e-18,  9.235932563843206e-20,  8.074649783099121e-23, -2.373657025841499e-24, -6.064641211980536e-27,  1.438055963600858e+00, -3.358791594474984e-03,
 -7.814351524860109e-06,  1.860812166351098e-08,  1.709645064232914e-10,  4.046397481478289e-14, -3.717201051689915e-15, -1.020674055365745e-17,  6.981813582239775e-20,
  4.522557840128420e-22, -7.831643510344220e-25, -1.501895783489518e-26,  1.530392620415249e+00, -3.055127721146013e-03, -9.182893819970486e-06,  5.753985518668736e-09,
  1.713049477905690e-10,  4.466411005379860e-13, -2.403531050845308e-15, -1.934510999402463e-17, -4.609395704396951e-21,  5.158866988550536e-22,  1.986002596321108e-24,
 -7.944602332687620e-27,  1.618686976451618e+00, -2.682231914158282e-03, -9.911303249570632e-06, -7.995390134295077e-09,  1.352666339614190e-10,  7.326570265556115e-13,
  3.446838499973265e-17, -1.828217146413060e-17, -8.345057708017252e-20,  1.285810578762239e-22,  3.015206170110499e-24,  1.030597982807430e-26,  1.701448975315945e+00,
 -2.254478488137898e-03, -9.874491262646882e-06, -2.022713684618973e-08,  6.902103387881079e-11,  7.714317616643519e-13,  2.458731237368520e-15, -6.243628135427287e-18,
 -1.005920365785421e-19, -3.884160197916425e-22,  7.282741332152339e-25,  1.585718231155960e-26,  1.777106224430911e+00, -1.792930107165021e-03, -9.038588867901599e-06,
 -2.844332999816282e-08, -9.314119455648845e-12,  5.311063044746812e-13,  3.502109940923481e-15,  8.835723626460580e-18, -3.654649265769001e-20, -4.887456145799320e-22,
 -2.204292759349473e-24, -2.736244442364663e-28,  1.844053616625438e+00, -1.324963327167918e-03, -7.494884663388613e-06, -3.082239154629359e-08, -7.427009737513391e-11,
  1.221867335266533e-13,  2.555706863224992e-15,  1.539247249900737e-17,  4.604016219198800e-20, -7.939025308991246e-23, -1.918630150273295e-24, -1.241150932873904e-26,
  1.900721602513598e+00, -8.827897271174731e-04, -5.474484423393735e-06, -2.702045868686452e-08, -1.035632935077288e-10, -2.409801760247898e-13,  4.305097058446578e-16,
  9.198199667237939e-18,  6.360826095931270e-20,  2.796024329060528e-22,  5.826834345973345e-25, -3.015886273737860e-27,  1.945660823421523e+00, -5.007192065748287e-04,
 -3.329615436676343e-06, -1.863621772631052e-08, -9.040196875422082e-11, -3.720435464989359e-13, -1.170837207576819e-15, -1.460013648421004e-18,  1.559334368167137e-20,
  1.741132323569940e-22,  1.147434820787592e-24,  5.686117621325410e-27,  1.977636804996723e+00, -2.113135454612205e-04, -1.474524764306914e-06, -8.956320247694325e-09,
 -4.962094730755377e-11, -2.545949669509028e-13, -1.209837106439003e-15, -5.253376573758481e-18, -2.008313767720470e-20, -6.059958724325745e-23, -7.573458075526195e-26,
  7.925807269900599e-28,  1.995728405972992e+00, -4.093757187829113e-05, -2.934047574348902e-07, -1.862127961092798e-09, -1.102709314497419e-11, -6.232850693186757e-14,
 -3.401804532410226e-16, -1.804190738744400e-18, -9.330732537602832e-21, -4.713380544026793e-23, -2.326338876320971e-25, -1.120847344584235e-27,  7.338838396142451e-04,
 -4.473961322553638e-06,  2.044934425599452e-08, -8.305652144906584e-11,  3.160874583858704e-13, -1.154242033775678e-15,  4.094603039720215e-18, -1.421999838604902e-20,
  4.855894382458285e-23, -1.636645509318777e-25,  5.452378343184446e-28, -1.800557424318879e-30,  6.603371041104139e-03, -4.018239484115907e-05,  1.829233586549444e-07,
 -7.377266722499175e-10,  2.777008018890937e-12, -9.982532972996511e-15,  3.465973163763383e-17, -1.170051205665692e-19,  3.852271924731485e-22, -1.239813596972966e-24,
  3.898111936746756e-27, -1.198148381990531e-29,  1.833384014931295e-02, -1.111540883807583e-04,  5.018997037197233e-07, -1.995232037230256e-09,  7.342642111876119e-12,
 -2.553186606813176e-14,  8.458022233273512e-17, -2.675630601928808e-19,  8.054357116821673e-22, -2.288330739541707e-24,  6.009458108764868e-27, -1.400055686179552e-29,
  3.590799121367648e-02, -2.164932532703029e-04,  9.654631765827177e-07, -3.753532577263727e-09,  1.332595855234992e-11, -4.385504803538844e-14,  1.336876833333230e-16,
 -3.721431069814114e-19,  9.078857799875328e-22, -1.720085825329375e-24,  1.072487696315427e-27,  1.147417399515671e-29,  5.929914197543341e-02, -3.548426532434872e-04,
  1.555817463288272e-06, -5.863723788265512e-09,  1.975998175337958e-11, -5.968804043123730e-14,  1.571290214171209e-16, -3.279729655035989e-19,  3.254291791432966e-22,
  1.531536684608532e-24, -1.285259800395559e-26,  6.130970871200596e-29,  8.847032380976302e-02, -5.243675000390640e-04,  2.249394318555278e-06, -8.135248093539184e-09,
  2.547425986918145e-11, -6.720389801522075e-14,  1.311958752084260e-16, -6.085899361351991e-20, -1.067113844616773e-21,  7.022156471646136e-24, -2.988638437948291e-26,
  9.781300666203431e-29,  1.233730334648243e-01, -7.227342993723523e-04,  3.017029233997871e-06, -1.034321082655848e-08,  2.919670122449036e-11, -6.095530540847214e-14,
  3.998636606516370e-17,  4.373472674278952e-19, -2.988610618228258e-21,  1.231732052864597e-23, -3.644524753443549e-26,  6.280314677344179e-29,  1.639456023875411e-01,
 -9.470850317792345e-04,  3.824231596361301e-06, -1.223809789479245e-08,  2.967977437597062e-11, -3.694059302740845e-14, -1.180942439926279e-16,  1.081318840117594e-18,
 -4.704893814166999e-21,  1.344855188238799e-23, -1.713596662879913e-26, -8.005798570916777e-29,  2.101111340913097e-01, -1.194007302723913e-03,  4.631587039544006e-06,
 -1.355823524015377e-08,  2.584858199774555e-11,  6.301707315015833e-15, -3.252532266198730e-16,  1.685577684458464e-18, -5.161418538838920e-21,  6.485056878163598e-24,
  3.443959068017242e-26, -2.925153366836395e-28,  2.617749476391904e-01, -1.459501472206780e-03,  5.395341044771196e-06, -1.404533716982872e-08,  1.696585593068956e-11,
  6.670187954518806e-14, -5.421271981375921e-16,  1.988300703574540e-18, -3.321347224546761e-21, -1.002982460321777e-23,  1.042786776176819e-25, -4.355004471426572e-28,
  3.188214518862675e-01, -1.738946326273372e-03,  6.068225880978640e-06, -1.346343664296563e-08,  2.805163383085380e-12,  1.379467703317829e-13, -7.100617892662513e-16,
  1.711571779884609e-18,  1.327722636819996e-21, -3.259151079876500e-23,  1.533689814971419e-25, -3.117234321354224e-28,  3.811103608591191e-01, -2.027065647133264e-03,
  6.600607368855487e-06, -1.162133831722183e-08, -1.618175340502626e-11,  2.092654222487232e-13, -7.592519222078681e-16,  6.564607667622883e-19,  8.223025509822783e-21,
 -5.155241358538984e-23,  1.280265176244306e-25,  2.036094934190988e-28,  4.484721461184548e-01, -2.317899159334079e-03,  6.942042691559346e-06, -8.398431102235454e-09,
 -3.872477662682679e-11,  2.659660603365623e-13, -6.235340256930007e-16, -1.180845717791491e-18,  1.535510792301792e-20, -5.283777082844785e-23, -1.069152947824197e-26,
  9.835036115271327e-28,  5.207026083028647e-01, -2.604782880830901e-03,  7.043353407472298e-06, -3.773168726277924e-09, -6.265256821243439e-11,  2.909831635276722e-13,
 -2.613550241215842e-16, -3.502042541175726e-18,  1.937360903005727e-20, -2.367377153496856e-23, -2.449188617216357e-25,  1.542054601147154e-27,  5.975564393544257e-01,
 -2.880346011546280e-03,  6.859324915197200e-06,  2.147316272085953e-09, -8.490726776028728e-11,  2.676383616325965e-13,  3.196900419346299e-16, -5.656968987623484e-18,
  1.645860323524909e-20,  3.816698794825281e-23, -4.675714679214698e-25,  1.173653463100844e-27,  6.787396426604370e-01, -3.136534276319669e-03,  6.352137935986177e-06,
  9.099257300200411e-09, -1.017059805609506e-10,  1.836590399470256e-13,  1.040416959503463e-15, -6.711926028857094e-18,  4.067253848119574e-21,  1.149602517678150e-22,
 -4.959103083101729e-25, -5.495438650624742e-28,  7.639006861051617e-01, -3.364673211207187e-03,  5.495607898714646e-06,  1.664050276853666e-08, -1.089024909348391e-10,
  3.617973489535073e-14,  1.739008051622007e-15, -5.691573311136092e-18, -1.675945698364525e-20,  1.662052521596437e-22, -1.641043874728725e-25, -3.071054291841675e-27,
  8.526202914709649e-01, -3.555589271079417e-03,  4.280237415654645e-06,  2.414176658649616e-08, -1.025949837626745e-10, -1.630730280067705e-13,  2.183731404703925e-15,
 -2.008726392527199e-18, -3.951208408665593e-20,  1.407717578612355e-22,  5.124363271264970e-25, -4.507076687521799e-27,  9.443998256712709e-01, -3.699811686894208e-03,
  2.718951325920049e-06,  3.080023528057348e-08, -7.999536522649110e-11, -3.839400449612248e-13,  2.121884873347208e-15,  3.998123326510674e-18, -5.242057895165118e-20,
  8.413680848623058e-24,  1.192359204666778e-24, -2.505438711087620e-27,  1.038648373395600e+00, -3.787883189647144e-03,  8.531525960875671e-07,  3.568717320740615e-08,
 -4.050919005730404e-11, -5.776644080003794e-13,  1.370710226054488e-15,  1.064705079847103e-17, -4.255101390127701e-20, -1.984322321584176e-22,  1.263639623420528e-24,
  3.383471411887620e-27,  1.134668761902346e+00, -3.810811865200959e-03, -1.241621330788177e-06,  3.784194380220099e-08,  1.314074085545933e-11, -6.832440659229727e-13,
 -6.186321760963171e-17,  1.499251070006165e-17, -4.223216365988366e-21, -3.630150815481474e-22,  2.584249124622393e-25,  9.302229340843431e-27,  1.231643108247017e+00,
 -3.760697266835913e-03, -3.451667971649790e-06,  3.642194199058062e-08,  7.408052434058054e-11, -6.426429458642012e-13, -1.869375532942577e-15,  1.379961311732160e-17,
  5.139358227424571e-20, -3.272403159567935e-22, -1.490426263932000e-24,  8.208837255405395e-27,  1.328618901659929e+00, -3.631557705709844e-03, -5.624571519603834e-06,
  3.090808349647018e-08,  1.312595476659376e-10, -4.246673144180138e-13, -3.429702781611722e-15,  5.485297795305169e-18,  9.350067372085825e-20, -1.866958520593733e-23,
 -2.574621687495627e-24, -2.975398151924274e-27,  1.424497247507032e+00, -3.420366684938456e-03, -7.574630721663166e-06,  2.134508833628487e-08,  1.708598764885821e-10,
 -5.191105740872605e-14, -3.969314299794312e-15, -7.719410040272122e-18,  8.537469051174426e-20,  4.075615933391812e-22, -1.453307003771421e-24, -1.525799754440940e-26,
  1.518025687181848e+00, -3.128267427838089e-03, -9.097116591584029e-06,  8.563008814603606e-09,  1.796170362574990e-10,  3.824574210673185e-13, -2.944362183332944e-15,
 -1.918088737184527e-17,  1.529668596013067e-20,  5.870694984021683e-22,  1.541698774460849e-24, -1.225489406430674e-26,  1.607798913703262e+00, -2.761868213312081e-03,
 -9.993779123578412e-06, -5.714033332007189e-09,  1.498850446651582e-10,  7.270448314623295e-13, -5.139514978484551e-16, -2.085440372088761e-17, -7.654775302601131e-20,
  2.575443608730202e-22,  3.412816735371526e-24,  7.538746277366409e-27,  1.692271560316664e+00, -2.334425354002072e-03, -1.011007153342473e-05, -1.899623118340113e-08,
  8.502367021328192e-11,  8.279670271077281e-13,  2.236790583671961e-15, -9.679255989978219e-18, -1.138737221154466e-19, -3.443712003253052e-22,  1.496999933311346e-24,
  1.901260289575982e-26,  1.769787722412871e+00, -1.866605794029966e-03, -9.380437436629018e-06, -2.850273062503032e-08,  2.167798256116597e-12,  6.179767285368213e-13,
  3.730371110483224e-15,  7.367736878646154e-18, -5.572222487199508e-20, -5.761415293067483e-22, -2.138182675821506e-24,  3.479303756977208e-27,  1.838631474413716e+00,
 -1.386421872620410e-03, -7.871791445227685e-06, -3.198768109288773e-08, -7.117723575320053e-11,  1.888588527954808e-13,  3.006780480573095e-15,  1.680411705287627e-17,
  4.166426726950443e-20, -1.675828317923011e-22, -2.503432045858521e-24, -1.411366463993908e-26,  1.897100758053410e+00, -9.279111159280468e-04, -5.808828982767869e-06,
 -2.871537500090182e-08, -1.082574844402576e-10, -2.273178861307088e-13,  7.180993861216424e-16,  1.139891540264499e-17,  7.405560055022284e-20,  2.995972420587391e-22,
  3.993934301315530e-25, -5.443669497214997e-27,  1.943603220923184e+00, -5.282758333447453e-04, -3.562179168117028e-06, -2.014371577304623e-08, -9.812683474606887e-11,
 -4.005716976953972e-13, -1.203723396598094e-15, -8.513725170112336e-19,  2.275051163349825e-20,  2.253053649255794e-22,  1.419452768502231e-24,  6.684766008579260e-27,
  1.976767258160437e+00, -2.235535413330149e-04, -1.586937501103634e-06, -9.792619571593959e-09, -5.501550614809754e-11, -2.854708475045913e-13, -1.366260593129923e-15,
 -5.931450312368121e-18, -2.230954023082407e-20, -6.278524528208476e-23, -2.957660675016099e-26,  1.338961810642983e-27,  1.995559815324587e+00, -4.337728915838792e-05,
 -3.168515160837371e-07, -2.048995411477361e-09, -1.235957976471931e-11, -7.113442036787189e-14, -3.951464358236222e-16, -2.131820289023686e-18, -1.120764245932545e-20,
 -5.750451913363658e-23, -2.879756926926197e-25, -1.405858003330645e-27,  7.163089906438724e-04, -4.314269026164471e-06,  1.948226552803661e-08, -7.817859376153963e-11,
  2.939539563868325e-13, -1.060579188534002e-15,  3.717340875410243e-18, -1.275632385438372e-20,  4.304123028123944e-23, -1.433597540937550e-25,  4.718961093579740e-28,
 -1.540372943207784e-30,  6.445513214980239e-03, -3.875367839124939e-05,  1.743307863043639e-07, -6.948476422784902e-10,  2.585417355366962e-12, -9.188660342909789e-15,
  3.154966889794726e-17, -1.053628912705265e-19,  3.432779618055770e-22, -1.093945407592984e-24,  3.406919537299439e-27, -1.038518720682038e-29,  1.789710532271079e-02,
 -1.072327027944425e-04,  4.786453123151468e-07, -1.881727065161903e-09,  6.851711945769519e-12, -2.358900395465532e-14,  7.743723128631424e-17, -2.430619866097590e-19,
  7.272373810820219e-22, -2.059918977046041e-24,  5.419809459678273e-27, -1.280919417723600e-29,  3.505718537363284e-02, -2.089461583050462e-04,  9.216716885020524e-07,
 -3.547163203841349e-09,  1.248011533999774e-11, -4.076835770206882e-14,  1.236651644814393e-16, -3.440723312813161e-19,  8.468464450518416e-22, -1.668186590940896e-24,
  1.496897639253989e-27,  7.959523569989780e-30,  5.790422626874041e-02, -3.426722869740184e-04,  1.487310997204800e-06, -5.556912370949401e-09,  1.860319435250645e-11,
 -5.602591855699092e-14,  1.480991815474801e-16, -3.167712024988734e-19,  3.719319425184700e-22,  1.068244943958728e-24, -1.038664381445407e-26,  5.105583426624755e-29,
  8.640823548868401e-02, -5.067560094420089e-04,  2.154173068235121e-06, -7.738242125781142e-09,  2.416151191034459e-11, -6.407927877482722e-14,  1.290501631318968e-16,
 -9.118437728666361e-20, -8.348272750887913e-22,  5.909482849807277e-24, -2.582758539677548e-26,  8.679188738537411e-29,  1.205295937408859e-01, -6.990866904107117e-04,
  2.895673536717052e-06, -9.885760339342218e-09,  2.798812959908767e-11, -5.985909095777888e-14,  5.095787902681179e-17,  3.485306184927042e-19, -2.570751850984511e-21,
  1.091581374868199e-23, -3.360999858327780e-26,  6.557659253917754e-29,  1.602175311923309e-01, -9.170705919089756e-04,  3.680198827745248e-06, -1.176927600080031e-08,
  2.891498628353864e-11, -3.942810218581914e-14, -8.985330554004518e-17,  9.383700044232455e-19, -4.233845140891823e-21,  1.270218012397711e-23, -1.996052599159328e-26,
 -4.954460324621168e-29,  2.054081897822771e-01, -1.157598363983422e-03,  4.471372508834279e-06, -1.314405807145750e-08,  2.590028275132499e-11, -9.564550915945700e-16,
 -2.803325151623637e-16,  1.524389382463963e-18, -4.906110294632728e-21,  7.621769046198899e-24,  2.279274070166556e-26, -2.380459838931028e-28,  2.560222064043419e-01,
 -1.417008208432910e-03,  5.228467505388572e-06, -1.376389939952509e-08,  1.817422907679994e-11,  5.434658006999711e-14, -4.879914973500955e-16,  1.877008706557900e-18,
 -3.611845019952100e-21, -6.229424911843332e-24,  8.605656468585952e-26, -3.922634512848462e-28,  3.119617363202341e-01, -1.691045797435318e-03,  5.907022027215116e-06,
 -1.339739209909044e-08,  5.397586169080279e-12,  1.214841340838821e-13, -6.617110619006101e-16,  1.736442772775418e-18,  2.614587233563671e-22, -2.674060665815629e-23,
  1.389790068511129e-25, -3.388854110060767e-28,  3.731068189642879e-01, -1.974822702174389e-03,  6.459732787136934e-06, -1.184774720579666e-08, -1.217703004344848e-11,
  1.912920022749804e-13, -7.374589720004140e-16,  8.909066275992937e-19,  6.461075897862514e-21, -4.629573765079630e-23,  1.337884067514284e-25,  6.367765981813145e-29,
  4.393109695393838e-01, -2.262776076699755e-03,  6.837716815207866e-06, -8.976296312211400e-09, -3.355750225066550e-11,  2.506582451065156e-13, -6.500046927570895e-16,
 -7.199185937536354e-19,  1.345509042515588e-20, -5.246441924938166e-23,  2.779106003369975e-26,  7.683242601222920e-28,  5.103958601947965e-01, -2.548633767248768e-03,
  6.992251593048508e-06, -4.729425408262309e-09, -5.690321430356179e-11,  2.836031597883181e-13, -3.508736829974248e-16, -2.897483347108671e-18,  1.836103392265696e-20,
 -3.215030999386927e-23, -1.798904688484067e-25,  1.407451576705250e-27,  5.861449356379679e-01, -2.825391026564719e-03,  6.877119459908095e-06,  8.319862329957519e-10,
 -7.949029241911299e-11,  2.734708384678263e-13,  1.688497913570470e-16, -5.111814683856861e-18,  1.750892619358532e-20,  2.055232739512753e-23, -4.119729511323068e-25,
  1.337074450271325e-27,  6.662957926293631e-01, -3.085307784847921e-03,  6.451690685292828e-06,  7.502640176016627e-09, -9.779823060549985e-11,  2.063922332012598e-13,
  8.548998070338573e-16, -6.519422269028957e-18,  7.844492540570284e-21,  9.480942606758847e-23, -5.076126227059586e-25,  1.946576345942377e-30,  7.505311459370961e-01,
 -3.319939155909231e-03,  5.684870366482040e-06,  1.490606413388894e-08, -1.077747327181016e-10,  7.594843432998096e-14,  1.573024758290920e-15, -6.133661400038907e-18,
 -1.092503461302765e-20,  1.571318361340893e-22, -2.847052615459041e-25, -2.404437251308938e-27,  8.384682132594630e-01, -3.520216702269209e-03,  4.559991033828986e-06,
  2.247698111527193e-08, -1.053376226240054e-10, -1.114764675846461e-13,  2.110573469488333e-15, -3.188459760200956e-18, -3.412301517664799e-20,  1.573202251599742e-22,
  3.158617178788014e-25, -4.387717174442891e-27,  9.296463914980128e-01, -3.676603989169842e-03,  3.080630252441179e-06,  2.946168062626210e-08, -8.715682328024824e-11,
 -3.318603881057171e-13,  2.210457724171796e-15,  2.334480970771473e-18, -5.128869707707378e-20,  5.358430030106180e-23,  1.058804618535642e-24, -3.516327407620774e-27,
  1.023513186605773e+00, -3.779356869009731e-03,  1.277134593811440e-06,  3.494848577801426e-08, -5.171018216331973e-11, -5.413500632094195e-13,  1.648761964034706e-15,
  9.181136884346921e-18, -4.875359606509009e-20, -1.454284543148283e-22,  1.373612970365465e-24,  1.609528250982688e-27,  1.119408528165003e+00, -3.818925886611376e-03,
 -7.867073074453688e-07,  3.794293823587284e-08, -5.051144631260418e-13, -6.797185550837303e-13,  3.540892501253865e-16,  1.465105551310734e-17, -1.700880658679530e-20,
 -3.446931448339057e-22,  6.516422157815014e-25,  8.475711049144598e-27,  1.216547887699644e+00, -3.786543199480262e-03, -3.007924611320581e-06,  3.750210441547444e-08,
  6.081122562941903e-11, -6.826967279792062e-13, -1.461810828127541e-15,  1.524495380729365e-17,  3.863231105993104e-20, -3.790444664217667e-22, -1.086288775419048e-24,
  1.005872332411011e-26,  1.314005076223499e+00, -3.675035661528726e-03, -5.241368211267326e-06,  3.293587544423308e-08,  1.219572554654521e-10, -5.048003595520546e-13,
 -3.234470075364280e-15,  8.446493950540965e-18,  9.095251451827311e-20, -1.232545456807915e-22, -2.628806469290198e-24,  5.651015845811853e-28,  1.410696274365830e+00,
 -3.479892805459755e-03, -7.302138328222794e-06,  2.406529683984858e-08,  1.688531637333106e-10, -1.494464838441089e-13, -4.145091747075322e-15, -4.765187561362854e-18,
  9.884029369024818e-20,  3.361913191872170e-22, -2.108305795307825e-24, -1.430933936181946e-26,  1.505367784100565e+00, -3.200583924824797e-03, -8.976877761399862e-06,
  1.149405378095386e-08,  1.865164056966802e-10,  3.054231896281032e-13, -3.471318516144089e-15, -1.834246898035122e-17,  3.739990715437949e-20,  6.367109849878800e-22,
  9.102867103524669e-25, -1.637874711932267e-26,  1.596591165123648e+00, -2.842050851420027e-03, -1.004748143481142e-05, -3.200419031816527e-09,  1.642539044556679e-10,
  7.074356429821813e-13, -1.130583085189251e-15, -2.312865599023073e-17, -6.474906808684968e-20,  3.995637806576575e-22,  3.657694984712257e-24,  3.357306655762050e-27,
  1.682770688374164e+00, -2.416193341956069e-03, -1.032930839876545e-05, -1.750056065773458e-08,  1.020957128987255e-10,  8.779750031704079e-13,  1.912984364924883e-15,
 -1.350833099009355e-17, -1.249842835589902e-19, -2.669645746911161e-22,  2.391441673359506e-24,  2.149062394562983e-26,  1.762169048141314e+00, -1.943015863690907e-03,
 -9.721838291392569e-06, -2.836423890781028e-08,  1.543820713671732e-11,  7.097599571801574e-13,  3.908470552424082e-15,  5.236641738645616e-18, -7.795350273047783e-20,
 -6.572255621599459e-22, -1.879534198458375e-24,  8.488693584476248e-27,  1.832957380275831e+00, -1.450950659738946e-03, -8.262338842027348e-06, -3.309221599945561e-08,
 -6.663956729267717e-11,  2.668121296664959e-13,  3.494909444539875e-15,  1.802027997567987e-17,  3.367544072277445e-20, -2.805387411758563e-22, -3.153023227108297e-24,
 -1.529585826326966e-26,  1.893293947939398e+00, -9.757898707066775e-04, -6.163952889451173e-06, -3.048281574807914e-08, -1.126042189677478e-10, -2.059756167588210e-13,
  1.072086359111877e-15,  1.394382488009053e-17,  8.506286793485668e-20,  3.098831470841236e-22,  9.098946906667731e-26, -8.729289434068193e-27,  1.941431553304379e+00,
 -5.577674746466461e-04, -3.813593413742854e-06, -2.177941278099125e-08, -1.064286347895773e-10, -4.296569536172251e-13, -1.216068698822516e-15,  1.797103975832558e-20,
  3.195710187605901e-20,  2.882628069621596e-22,  1.735694204137697e-24,  7.681786901092354e-27,  1.975846887043033e+00, -2.367344970759326e-04, -1.709924764238303e-06,
 -1.072038255495669e-08, -6.106670397293972e-11, -3.203368339168695e-13, -1.542676570215129e-15, -6.681620712945952e-18, -2.457501539048413e-20, -6.257863015234232e-23,
  4.562746844479704e-26,  2.125771784317437e-27,  1.995381075927069e+00, -4.601392644831158e-05, -3.426746557580650e-07, -2.258666515279317e-09, -1.388215615005806e-11,
 -8.137674869741341e-14, -4.601862219439672e-16, -2.525937503358973e-18, -1.350095771564943e-20, -7.036098015270030e-23, -3.574806999478829e-25, -1.767755853084531e-27,
  6.993578000064054e-04, -4.162085100143400e-06,  1.857165737728705e-08, -7.364029441694506e-11,  2.736063876661675e-13, -9.754981369288776e-16,  3.378695641158241e-18,
 -1.145806514651566e-20,  3.820432923850407e-23, -1.257719855932382e-25,  4.090945706656702e-28, -1.320280675349394e-30,  6.293235960292219e-03, -3.739169525848888e-05,
  1.662348807251741e-07, -6.549109906586362e-10,  2.408983370123175e-12, -8.465664398038785e-15,  2.874755850195148e-17, -9.498267603490247e-20,  3.062426285838636e-22,
 -9.663884178793256e-25,  2.980926533320945e-27, -9.012149918108012e-30,  1.747569240987076e-02, -1.034920347399366e-04,  4.567071040217296e-07, -1.775775204014748e-09,
  6.397978842802903e-12, -2.180961659306827e-14,  7.094644174797416e-17, -2.209361448462463e-19,  6.568498275720132e-22, -1.854059565848616e-24,  4.881443590781059e-27,
 -1.167221213655748e-29,  3.423588261498989e-02, -2.017397149756950e-04,  8.802774275552384e-07, -3.353846257441847e-09,  1.169366306133286e-11, -3.791299492249478e-14,
  1.144015842856485e-16, -3.179219317305715e-19,  7.879460020449949e-22, -1.602163238445327e-24,  1.784333112737623e-27,  5.219733337471853e-30,  5.655691880437248e-02,
 -3.310355546408937e-04,  1.422377595695276e-06, -5.268035277983353e-09,  1.751750843920520e-11, -5.257659564488317e-14,  1.394014477020604e-16, -3.043300235875656e-19,
  4.034273268229558e-22,  6.950444933828688e-25, -8.336653272052102e-27,  4.236481997372500e-29,  8.441509926458360e-02, -4.898875848986385e-04,  2.063591918155765e-06,
 -7.361743258343778e-09,  2.291067677536283e-11, -6.101554191991859e-14,  1.261536008702345e-16, -1.146870927346535e-19, -6.397895608013659e-22,  4.949676153414859e-24,
 -2.223753073840974e-26,  7.652570562276286e-29,  1.177788370660920e-01, -6.763882963803062e-04,  2.779691990005852e-06, -9.447458115906983e-09,  2.680392160362970e-11,
 -5.852793744494320e-14,  5.962229877751286e-17,  2.723002588056339e-19, -2.201284105770634e-21,  9.629338626602291e-24, -3.071241421722141e-26,  6.577265996669633e-29,
  1.566072485643976e-01, -8.881861223074844e-04,  3.541716976088584e-06, -1.131305322212218e-08,  2.810691032017388e-11, -4.128418186238418e-14, -6.540808491978289e-17,
  8.100455107467683e-19, -3.791395021609901e-21,  1.186760239387428e-23, -2.159547212609127e-26, -2.578915516959416e-29,  2.008483492789578e-01, -1.122451257581294e-03,
  4.316128462627295e-06, -1.273015793753099e-08,  2.581724057276721e-11, -7.189721787323275e-15, -2.398051606799092e-16,  1.371940340987368e-18, -4.617707360434787e-21,
  8.338475553604663e-24,  1.338838335303161e-26, -1.905636958140714e-28,  2.504367900770558e-01, -1.375836113610380e-03,  5.065079294306178e-06, -1.346503499067401e-08,
  1.914823148095527e-11,  4.325221434275297e-14, -4.370825288880526e-16,  1.758472903054180e-18, -3.778183048078845e-21, -3.119151237727232e-24,  6.978514899907866e-26,
 -3.472600243765316e-28,  3.052910495902943e-01, -1.644431048762946e-03,  5.746848919944416e-06, -1.329243959323244e-08,  7.672397697015098e-12,  1.061866069375363e-13,
 -6.131107716783935e-16,  1.730450369028721e-18, -6.047677039073652e-22, -2.148337315226519e-23,  1.238207038440195e-25, -3.474671135556359e-28,  3.653099791509496e-01,
 -1.923716559335505e-03,  6.316513987621818e-06, -1.201292573022311e-08, -8.526045230524655e-12,  1.739141918663504e-13, -7.098621918151067e-16,  1.072030951242536e-18,
  4.891117261992972e-21, -4.092233102639100e-23,  1.340902186086446e-25, -4.507814521159520e-29,  4.303685741123724e-01, -2.208513956578546e-03,  6.726942411399266e-06,
 -9.473964635677012e-09, -2.870172717408817e-11,  2.348631575049078e-13, -6.644165753287629e-16, -3.192981133694601e-19,  1.159398534818175e-20, -5.073597698325143e-23,
  5.720093320186523e-26,  5.720362351602341e-28,  5.003128204285600e-01, -2.492937816626210e-03,  6.930221403046560e-06, -5.594984274541904e-09, -5.132159386246408e-11,
  2.742739143397861e-13, -4.239606841441802e-16, -2.329719231670266e-18,  1.708860306297432e-20, -3.815419250253714e-23, -1.215043730058109e-25,  1.242831930729679e-27,
  5.749534386992974e-01, -2.770355340036590e-03,  6.879653300397129e-06, -3.959304491806313e-10, -7.399161559247463e-11,  2.758695488310676e-13,  3.365220857785551e-17,
 -4.542754519109482e-18,  1.796662566107807e-20,  5.277125042968866e-24, -3.512712786281820e-25,  1.408168323561898e-27,  6.540583216094293e-01, -3.033360413102874e-03,
  6.532473398968266e-06,  5.971944517434887e-09, -9.347983656647151e-11,  2.247506821714222e-13,  6.763555289273506e-16, -6.217698335960527e-18,  1.089346261782312e-20,
  7.464697417421439e-23, -4.972240603940330e-25,  4.530249092749895e-28,  7.373434388833311e-01, -3.273773888150520e-03,  5.853453371055713e-06,  1.319581234710888e-08,
 -1.058923315225593e-10,  1.116057567240659e-13,  1.397221411471181e-15, -6.395147399768369e-18, -5.496942810622728e-21,  1.438286923938026e-22, -3.754870591746662e-25,
 -1.723443500808298e-27,  8.244619739067760e-01, -3.482686682461331e-03,  4.819537647899769e-06,  2.077646260003553e-08, -1.070684609663392e-10, -6.201210460213578e-14,
  2.006876123756586e-15, -4.187714121817425e-18, -2.827783963916076e-20,  1.661792144845206e-22,  1.295664296369609e-25, -4.048272938574482e-27,  9.149914706035401e-01,
 -3.650568978740104e-03,  3.425593726786488e-06,  2.801697514180981e-08, -9.325917646575229e-11, -2.782084101400965e-13,  2.253192306849786e-15,  7.319643894893624e-19,
 -4.863673982690596e-20,  9.261272118827087e-23,  8.875137770688253e-25, -4.216772557216876e-27,  1.008418828444687e+00, -3.767477138574377e-03,  1.691202150045632e-06,
  3.403674101339098e-08, -6.212158798286295e-11, -4.988756626335807e-13,  1.883281379486840e-15,  7.547966638417522e-18, -5.298769149996304e-20, -8.958701769459508e-23,
  1.405757596019906e-24, -1.323816381987202e-28,  1.104123119413442e+00, -3.823399450911642e-03, -3.318872800538078e-07,  3.782670139462230e-08, -1.398164135484257e-11,
 -6.663704306093087e-13,  7.548733683238897e-16,  1.391396946878325e-17, -2.886195428736583e-20, -3.115330725786541e-22,  9.964805867454296e-25,  7.121150142153349e-27,
  1.201356460236554e+00, -3.808791004058825e-03, -2.552517832960012e-06,  3.836409382872887e-08,  4.684169946102810e-11, -7.125310753980543e-13, -1.019750887424040e-15,
  1.625536238543948e-17,  2.431494033161260e-20, -4.132489265838658e-22, -6.154857962434193e-25,  1.121712197442714e-26,  1.299223620598500e+00, -3.715353307099989e-03,
 -4.834776406225590e-06,  3.480229199319045e-08,  1.111058117919783e-10, -5.792655582059833e-13, -2.958032659693800e-15,  1.126579918355250e-17,  8.463851810780717e-20,
 -2.268196428934765e-22, -2.522403499176054e-24,  4.273194334032506e-27,  1.396661762388944e+00, -3.537109112251188e-03, -6.997261114145392e-06,  2.673759202536337e-08,
  1.648604969587088e-10, -2.501618110574523e-13, -4.232540100528143e-15, -1.426127939266749e-18,  1.092783869963234e-19,  2.398252959384054e-22, -2.693916026217832e-24,
 -1.210259641805081e-26,  1.492422764101448e+00, -3.271796065894030e-03, -8.820857095296580e-06,  1.452248546930064e-08,  1.917509419297395e-10,  2.161051083935921e-13,
 -3.964664998360844e-15, -1.677337483578421e-17,  6.079322268105112e-20,  6.576216037088702e-22,  1.098338927433654e-25, -1.985987504156399e-26,  1.585062023260946e+00,
 -2.922538581335796e-03, -1.006965656779531e-05, -4.608653549406054e-10,  1.780776716482885e-10,  6.723105940403632e-13, -1.804828044550512e-15, -2.494204139557666e-17,
 -4.770948107961769e-20,  5.472861009168386e-22,  3.687953966636652e-24, -2.195188212103099e-27,  1.672939357013162e+00, -2.499638715966903e-03, -1.052892676545861e-05,
 -1.572419555640417e-08,  1.200813214782191e-10,  9.188877116736886e-13,  1.477455816846492e-15, -1.764125744688644e-17, -1.326407259682568e-19, -1.519144089263835e-22,
  3.370379504217150e-24,  2.275992093600333e-26,  1.754239286984349e+00, -2.022146742123665e-03, -1.006024201606344e-05, -2.799852485830272e-08,  3.058176452444918e-11,
  8.050185214621803e-13,  4.016517734691924e-15,  2.349891655065568e-18, -1.028610468946108e-19, -7.231813734802368e-22, -1.372631653200564e-24,  1.475016776072060e-26,
  1.827018840190431e+00, -1.518655486781966e-03, -8.665651500239024e-06, -3.411102815793460e-08, -6.042308998582347e-11,  3.568563058929464e-13,  4.012864383543613e-15,
  1.891063519770050e-17,  2.114211920189313e-20, -4.202748377905537e-22, -3.835551849509530e-24, -1.553015219067149e-26,  1.889289804875820e+00, -1.026595600644000e-03,
 -6.540687722546706e-06, -3.231590293846846e-08, -1.164331725573286e-10, -1.752425184567407e-13,  1.502299025090463e-15,  1.684421097334773e-17,  9.618094267260569e-20,
  3.046546581519362e-22, -3.836803057242519e-25, -1.302399788131737e-26,  1.939137768933206e+00, -5.893512457301080e-04, -4.085452220568180e-06, -2.355259942606588e-08,
 -1.153129498886214e-10, -4.587109227225856e-13, -1.199589206382976e-15,  1.220714902254140e-18,  4.366822340645747e-20,  3.647230663168879e-22,  2.093739914134788e-24,
  8.560430098850635e-27,  1.974871751401001e+00, -2.509455839998866e-04, -1.844649874764224e-06, -1.175078059647623e-08, -6.785930497375617e-11, -3.596970235896786e-13,
 -1.741106576115778e-15, -7.503513764426905e-18, -2.676975485030223e-20, -5.858137841281596e-23,  1.623681304902745e-25,  3.244361653612021e-27,  1.995191360269241e+00,
 -4.886764334799844e-05, -3.711670612990362e-07, -2.494426332521821e-09, -1.562612725317665e-11, -9.332119554750615e-14, -5.373622882272475e-16, -3.001415449511689e-18,
 -1.631123161393080e-20, -8.634333539571814e-23, -4.449866955754875e-25, -2.228096401270506e-27,  6.830011126068562e-04, -4.016973608984173e-06,  1.771361020816086e-08,
 -6.941437274493045e-11,  2.548820216010953e-13, -8.981252780909360e-16,  3.074326554088506e-18, -1.030492322923309e-20,  3.395760988990602e-23, -1.105129144837538e-25,
  3.552167316870972e-28, -1.133777129382910e-30,  6.146280072500414e-03, -3.609260932543275e-05,  1.586017429083750e-07, -6.176851609399736e-10,  2.246359665080078e-12,
 -7.806561141778969e-15,  2.622016986201702e-17, -8.571729267277686e-20,  2.735066557972305e-22, -8.547213054037972e-25,  2.611033628270844e-27, -7.830316937216870e-30,
  1.706889903952187e-02, -9.992190742714065e-05,  4.359979072274598e-07, -1.676806628381626e-09,  5.978324592110215e-12, -2.017882171744592e-14,  6.504472719575437e-17,
 -2.009481892328013e-19,  5.934974735902365e-22, -1.668753331395658e-24,  4.391659724197279e-27, -1.060254378850563e-29,  3.344275771720422e-02, -1.948553561726201e-04,
  8.411293166276010e-07, -3.172667524015990e-09,  1.096215299697753e-11, -3.527138224745758e-14,  1.058441997098247e-16, -2.936163219743931e-19,  7.316020722121091e-22,
 -1.526860950318397e-24,  1.965352268822340e-27,  3.099325489932231e-30,  5.525514087948893e-02, -3.199047135560719e-04,  1.360808733595778e-06, -4.995988489473707e-09,
  1.649875028252556e-11, -4.933173608802581e-14,  1.310642656595324e-16, -2.910808529811790e-19,  4.228751011276159e-22,  3.966069552828074e-25, -6.638689355708903e-27,
  3.502091779130939e-29,  8.248801557995615e-02, -4.737260732061428e-04,  1.977410683562263e-06, -7.004771543743323e-09,  2.172037141129915e-11, -5.802854517304316e-14,
  1.226813375481943e-16, -1.324746038705774e-19, -4.768267091069981e-22,  4.124680057656787e-24, -1.908094942476896e-26,  6.709698913868304e-29,  1.151170511216613e-01,
 -6.545970362281892e-04,  2.668857299241915e-06, -9.027879639650785e-09,  2.564824997464441e-11, -5.701315725739031e-14,  6.631098700485218e-17,  2.071742072760230e-19,
 -1.876046582072625e-21,  8.458349633671058e-24, -2.784909413115071e-26,  6.412607216114887e-29,  1.531103224644077e-01, -8.603878312426226e-04,  3.408631097458130e-06,
 -1.087002594826316e-08,  2.726729672549112e-11, -4.259512153829422e-14, -4.436232786955512e-17,  6.953880214356526e-19, -3.379930899978977e-21,  1.098679618851200e-23,
 -2.231296370909144e-26, -7.666970939313390e-30,  1.964266447089620e-01, -1.088526268068212e-03,  4.165839299290092e-06, -1.231853238573439e-08,  2.561891935265225e-11,
 -1.250049064459837e-14, -2.034137905693942e-16,  1.229064380552411e-18, -4.309788957958523e-21,  8.718783740207064e-24,  5.923753627470528e-27, -1.498157764229747e-28,
  2.450134709836978e-01, -1.335956530494007e-03,  4.905363850012300e-06, -1.315229639457841e-08,  1.991229319825617e-11,  3.333933341539531e-14, -3.895511226867611e-16,
  1.636284061123994e-18, -3.843789138098407e-21, -6.201272407153336e-25,  5.549072515081794e-26, -3.027067769219592e-28,  2.988042679051076e-01, -1.599092051320727e-03,
  5.588143733283676e-06, -1.315347444369497e-08,  9.652893699673918e-12,  9.205051171366550e-14, -5.650387233058722e-16,  1.699649395933765e-18, -1.292697924352614e-21,
 -1.683560753859897e-23,  1.086070294340263e-25, -3.421134164299144e-28,  3.577152612220644e-01, -1.873763128566363e-03,  6.171652192040087e-06, -1.212243133665035e-08,
 -5.215611189877000e-12,  1.572540635864907e-13, -6.778682262454543e-16,  1.206005161168276e-18,  3.513742666057791e-21, -3.562411381926243e-23,  1.302313210117922e-25,
 -1.260532660208003e-28,  4.216414187854254e-01, -2.155160623108696e-03,  6.610651666614057e-06, -9.896482871384851e-09, -2.416443860222635e-11,  2.188501286481624e-13,
 -6.684339824095210e-16,  2.297312826500273e-20,  9.814257495084201e-21, -4.799727634413772e-23,  7.847301948635087e-26,  3.989200858354923e-28,  4.904515083231984e-01,
 -2.437778150921646e-03,  6.858333890754252e-06, -6.372819878552343e-09, -4.594283609072997e-11,  2.633765645410894e-13, -4.817497023005149e-16, -1.805694911130074e-18,
  1.564027365628160e-20, -4.197291506796155e-23, -7.074176313217071e-26,  1.063159649898320e-27,  5.639820338414084e-01, -2.715356824617555e-03,  6.867981040609858e-06,
 -1.535655365233486e-09, -6.847611489125618e-11,  2.752158852288487e-13, -8.548594025114574e-17, -3.967373188279436e-18,  1.791865989597873e-20, -7.531045611519915e-24,
 -2.891749920889786e-25,  1.403259479643323e-27,  6.420298179601911e-01, -2.980839052029604e-03,  6.595313701281022e-06,  4.513050755786154e-09, -8.883638571836345e-11,
  2.389358058949998e-13,  5.075171279041914e-16, -5.829903761085620e-18,  1.322856584285529e-20,  5.526605971832633e-23, -4.693044746637679e-25,  7.986808895943311e-28,
  7.243429610419481e-01, -3.226341483729080e-03,  6.001716849977706e-06,  1.152115276135785e-08, -1.033394702568500e-10,  1.429751013528057e-13,  1.216451586711833e-15,
 -6.491239576522343e-18, -6.059513524437983e-22,  1.274879933803811e-22, -4.367901861574727e-25, -1.070730305427266e-27,  8.106098775730609e-01, -3.443162311156011e-03,
  5.058544062698859e-06,  1.905602061869762e-08, -1.078370554205074e-10, -1.535084717762454e-14,  1.877856170943634e-15, -4.996225831330655e-18, -2.224378502399151e-20,
  1.679379644833413e-22, -3.794420046154355e-26, -3.543284317434666e-27,  9.004460971333388e-01, -3.621845184380853e-03,  3.752670458994879e-06,  2.648325698147844e-08,
 -9.828181340752123e-11, -2.240584087086650e-13,  2.252445974689146e-15, -7.645861848930768e-19, -4.470965630725493e-20,  1.242675712948183e-22,  6.924602663934994e-25,
 -4.597154199853638e-27,  9.933785410831876e-01, -3.752331396870522e-03,  2.093358254766977e-06,  3.296549967367721e-08, -7.163099638526115e-11, -4.513349890719874e-13,
  2.070478278077783e-15,  5.811570322603617e-18, -5.520649677670385e-20, -3.395528824347480e-23,  1.364258050168781e-24, -1.719486956961285e-27,  1.088827079547112e+00,
 -3.824243676329795e-03,  1.202546403387000e-07,  3.749749067236958e-08, -2.709690577382986e-11, -6.436928140097216e-13,  1.129906595202906e-15,  1.281922060850119e-17,
 -3.928860424676836e-20, -2.658995947436107e-22,  1.272399496799510e-24,  5.367094542640332e-27,  1.186083388155483e+00, -3.827358020188936e-03, -2.088126055549320e-06,
  3.899838244824610e-08,  3.238360042597571e-11, -7.314692641822691e-13, -5.559723790459535e-16,  1.679163410319983e-17,  9.115407235223465e-21, -4.278295418048843e-22,
 -1.108518664031830e-25,  1.158655088865269e-26,  1.284287537394683e+00, -3.752331692542940e-03, -4.406877248297126e-06,  3.648355787123227e-08,  9.883767082704022e-11,
 -6.461752114670904e-13, -2.606036160787686e-15,  1.382454278398285e-17,  7.471195756958149e-20, -3.228867591180102e-22, -2.255022666867079e-24,  7.828146466476978e-27,
  1.382403464578996e+00, -3.591759370834191e-03, -6.660766406952391e-06,  2.932980848178683e-08,  1.588402899143508e-10, -3.518195926217119e-13, -4.222371076380193e-15,
  2.187134640831114e-18,  1.158523709568436e-19,  1.223384135672014e-22, -3.155611163335287e-24, -8.698466341437298e-27,  1.479195623855422e+00, -3.341613392982289e-03,
 -8.628053722790106e-06,  1.761975198689992e-08,  1.950847113862160e-10,  1.155589849772464e-13, -4.403529180282378e-15, -1.445011214579376e-17,  8.432871069256313e-20,
  6.437462974277764e-22, -8.208448927700973e-25, -2.222062878975183e-26,  1.573210789113175e+00, -3.003068512857533e-03, -1.005765604991314e-05,  2.493353281773078e-09,
  1.910333455925249e-10,  6.204608936707329e-13, -2.521415797699784e-15, -2.612533815703601e-17, -2.539229405950337e-20,  6.909731571653915e-22,  3.447601201674956e-24,
 -8.888037017127071e-27,  1.662771192249572e+00, -2.584590821000549e-03, -1.070547707838953e-05, -1.365412240554326e-08,  1.387711580467154e-10,  9.479354854531833e-13,
  9.234522694164201e-16, -2.194528268434651e-17, -1.354414004452332e-19,  2.926071435014891e-24,  4.367921174302812e-24,  2.223964054773404e-26,  1.745987621655329e+00,
 -2.103963031466524e-03, -1.039274014263648e-05, -2.737516075564193e-08,  4.764940314376752e-11,  9.018081640890400e-13,  4.032251503920957e-15, -1.367417786899602e-18,
 -1.297085465599534e-19, -7.630155184821483e-22, -5.656330094976604e-25,  2.208113954619533e-26,  1.820802952937754e+00, -1.589633885898640e-03, -9.080531484469566e-06,
 -3.501528659863161e-08, -5.227965527721617e-11,  4.595804028718497e-13,  4.549340517439885e-15,  1.931416978726317e-17,  3.087930598190115e-21, -5.871214156715714e-22,
 -4.497655182465104e-24, -1.426721891512706e-26,  1.885076270416570e+00, -1.080504188407521e-03, -6.939765003229907e-06, -3.420474676186172e-08, -1.195374285364795e-10,
 -1.331698979250510e-13,  2.018646741506242e-15,  2.009331052608649e-17,  1.067205519656912e-19,  2.763362602636438e-22, -1.071669341878818e-24, -1.843811642958261e-26,
  1.936713161505054e+00, -6.231974607232047e-04, -4.379461234201244e-06, -2.547255001296698e-08, -1.247714314525162e-10, -4.869202706598794e-13, -1.143752375492587e-15,
  2.845091369456928e-18,  5.839837866517296e-20,  4.562043406128355e-22,  2.484506547353482e-24,  9.130091308185682e-27,  1.973837534809852e+00, -2.662858400495194e-04,
 -1.992418689096389e-06, -1.289642460224806e-08, -7.548863734853150e-11, -4.041034579460814e-13, -1.963504179426693e-15, -8.392331344774016e-18, -2.872357080796917e-20,
 -4.880660105707880e-23,  3.378057014618531e-25,  4.816931703181720e-27,  1.994989755253105e+00, -5.196110915601554e-05, -4.026642280230381e-07, -2.760106152929525e-09,
 -1.762864279882106e-11, -1.072883473365439e-13, -6.292022920120943e-16, -3.576745207297085e-18, -1.976506966694314e-20, -1.062658941382046e-22, -5.554081735407376e-25,
 -2.814503138461729e-27,  6.672114565490006e-04, -3.878528628883736e-06,  1.690452636973276e-08, -6.547604746183854e-11,  2.376346021960658e-13, -8.276846847009179e-16,
  2.800422617467313e-18, -9.279287517171176e-21,  3.022332324430136e-23, -9.725349348372766e-26,  3.089067070272746e-28, -9.754838841574396e-31,  6.004401166245715e-03,
 -3.485284490787794e-05,  1.514001277409614e-07, -5.829590635724201e-10,  2.096331869406815e-12, -7.205116802481900e-15,  2.393813079807698e-17, -7.743789707702670e-20,
  2.445364489270684e-22, -7.568599865971617e-25,  2.289443033351972e-27, -6.812460355530412e-30,  1.667606219494624e-02, -9.651281491328755e-05,  4.164370984386714e-07,
 -1.584299103173746e-09,  5.589914001864014e-12, -1.868317508900460e-14,  5.967526999266273e-17, -1.828844629125116e-19,  5.364746464013819e-22, -1.502118755262868e-24,
  3.947315782170525e-27, -9.607629051281014e-30,  3.267655737874373e-02, -1.882756807046123e-04,  8.040868334763536e-07, -3.002781224664870e-09,  1.028147549678959e-11,
 -3.282718130653900e-14,  9.794254661505261e-17, -2.710691195347534e-19,  6.780782851508059e-22, -1.446030510989321e-24,  2.064326266955601e-27,  1.471589675569231e-30,
  5.399692150791836e-02, -3.092536373622314e-04,  1.302408738913820e-06, -4.739733398352579e-09,  1.554291876538309e-11, -4.628245632954109e-14,  1.231052477535216e-16,
 -2.773687560010862e-19,  4.327270205655524e-22,  1.599782485695475e-25, -5.237809592502945e-27,  2.883096987842353e-29,  8.062422572106615e-02, -4.582371960011342e-04,
  1.895400796542112e-06, -6.666371482398205e-09,  2.058893522900613e-11, -5.513029666720760e-14,  1.187797355058805e-16, -1.454989289852504e-19, -3.413886495794196e-22,
  3.417903885894331e-24, -1.632023600815540e-26,  5.853244062194368e-29,  1.125406883100765e-01, -6.336726258218679e-04,  2.562947632080416e-06, -8.626541421911367e-09,
  2.452433744431210e-11, -5.535859301227034e-14,  7.131567145861013e-17,  1.518032046705196e-19, -1.590924335779842e-21,  7.400034093719821e-24, -2.508797205073607e-26,
  6.121002304170359e-29,  1.497224934998714e-01, -8.336331920921974e-04,  3.280780163967132e-06, -1.044061586374798e-08,  2.640626284030535e-11, -4.343802956731499e-14,
 -2.634744240371475e-17,  5.933859731996745e-19, -3.000513394676882e-21,  1.009180525415309e-23, -2.233846450082911e-26,  5.818424919154502e-30,  1.921382666675291e-01,
 -1.055783895549445e-03,  4.020467248679067e-06, -1.191088358213492e-08,  2.532279844237211e-11, -1.698474883397999e-14, -1.708833327797201e-16,  1.096206632837766e-18,
 -3.993139152905903e-21,  8.834477512167041e-24,  1.118694956473465e-28, -1.153535096401406e-28,  2.397471388178644e-01, -1.297339466325268e-03,  4.749468273881275e-06,
 -1.282885805747994e-08,  2.048922682284604e-11,  2.452599283096359e-14, -3.454576355605188e-16,  1.513328715790392e-18, -3.829254253798430e-21,  1.345830187203777e-24,
  4.311717567944627e-26, -2.601558287895660e-28,  2.924963142207473e-01, -1.555015507430932e-03,  5.431287128362433e-06, -1.298502078344012e-08,  1.136212301763251e-11,
  7.905545938736168e-14, -5.181129749298129e-16,  1.649394976612169e-18, -1.824176057482593e-21, -1.278847958745944e-23,  9.386132567782183e-26, -3.267939999464812e-28,
  3.503180321432687e-01, -1.824972973039291e-03,  6.025783273581109e-06, -1.218159271074763e-08, -2.230422306493832e-12,  1.414020002388022e-13, -6.427116232317359e-16,
  1.298918841841519e-18,  2.323534107680302e-21, -3.054417640947336e-23,  1.233506674997615e-25, -1.830793948688878e-28,  4.131257857392602e-01, -2.102756686688079e-03,
  6.489715705761778e-06, -1.024896866939711e-08, -1.994763136677532e-11,  2.028493462732799e-13, -6.636492042922875e-16,  3.100203277850351e-19,  8.146669505943720e-21,
 -4.455271793493781e-23,  9.267684975105487e-26,  2.509049664070082e-28,  4.808096276079702e-01, -2.383229475431479e-03,  6.777621289009049e-06, -7.066409398065759e-09,
 -4.079473374779752e-11,  2.512629999189713e-13, -5.255328541555302e-16, -1.329840406539487e-18,  1.408909754212305e-20, -4.392090423553119e-23, -2.798928442358724e-26,
  8.804777518795816e-28,  5.532303517853494e-01, -2.660504895832343e-03,  6.843160650187491e-06, -2.587386743167700e-09, -6.300097829495348e-11,  2.718956517941230e-13,
 -1.886008085840264e-16, -3.400426443980514e-18,  1.745408576977653e-20, -1.787827866994355e-23, -2.286540881699041e-25,  1.339343455997647e-27,  6.302122961338904e-01,
 -2.927883712269855e-03,  6.641101709178815e-06,  3.130505497769815e-09, -8.394883316091824e-11,  2.492069144262796e-13,  3.504799116506912e-16, -5.378305843295470e-18,
  1.488944387353013e-20,  3.727545746163673e-23, -4.284571494910435e-25,  1.041631893276792e-27,  7.115344588010147e-01, -3.177802614611468e-03,  6.130149426998822e-06,
  9.892121723421761e-09, -1.002027357544927e-10,  1.699908099383446e-13,  1.035090856127474e-15, -6.440650265583305e-18,  3.659416972736491e-21,  1.092536520247802e-22,
 -4.706135991903385e-25, -4.788678575343180e-28,  7.969195718705605e-01, -3.401808609009658e-03,  5.276861620018622e-06,  1.733057138108657e-08, -1.077051103715390e-10,
  2.796410397328570e-14,  1.728901708104498e-15, -5.611882241476226e-18, -1.626133336210277e-20,  1.634766351146366e-22, -1.806509843782810e-25, -2.930263352632129e-27,
  8.860207336854408e-01, -3.590579678560850e-03,  4.060896097696413e-06,  2.487782567836021e-08, -1.022249459578564e-10, -1.704139614862524e-13,  2.211715977628768e-15,
 -2.118769943150693e-18, -3.978663554866632e-20,  1.478768710596417e-22,  4.874493527896600e-25, -4.674011804062846e-27,  9.784051862173927e-01, -3.734022338707106e-03,
  2.481778682306198e-06,  3.174994176077150e-08, -8.014863587229305e-11, -3.998912065366154e-13,  2.208360078019796e-15,  4.035763107260755e-18, -5.546865892302163e-20,
  1.868806598895688e-23,  1.258182189726995e-24, -3.054008970372996e-27,  1.073534867042942e+00, -3.821490098258567e-03,  5.672034879816317e-07,  3.696254210122884e-08,
 -3.967128092356127e-11, -6.124183480766473e-13,  1.469876969479574e-15,  1.141907774942439e-17, -4.789316730133669e-20, -2.108562647284933e-22,  1.465206999100044e-24,
  3.370708068291379e-27,  1.170743520899379e+00, -3.842183413684564e-03, -1.617521320857619e-06,  3.939892025181847e-08,  1.765897512351285e-11, -7.391518881840486e-13,
 -8.403867497767181e-17,  1.683703555263587e-17, -6.243955924477237e-21, -4.221392297354153e-22,  3.921535745247638e-25,  1.114620620136665e-26,  1.269210509970675e+00,
 -3.785809619497046e-03, -3.960023249987015e-06,  3.795831062606384e-08,  8.532142041192839e-11, -7.038162196668596e-13, -2.187345398437296e-15,  1.601266534967703e-17,
  6.155616556837510e-20, -4.052474471833610e-22, -1.840544024753884e-24,  1.090838078470628e-26,  1.367932144143319e+00, -3.643595037127398e-03, -6.293809998434356e-06,
  3.180948441555397e-08,  1.507976685149781e-10, -4.519995177601140e-13, -4.108745014978970e-15,  5.939839991964122e-18,  1.179033804926491e-19, -1.030826512895642e-23,
 -3.444640505464160e-24, -4.298941391292519e-27,  1.465692535621389e+00, -3.409738873944526e-03, -8.397831260307884e-06,  2.075372279727883e-08,  1.963079370527093e-10,
  5.345118788501825e-15, -4.766925480017299e-15, -1.138906890138226e-17,  1.066734232725120e-19,  5.909958866531816e-22, -1.822564450009135e-24, -2.302383837343989e-26,
  1.561037856631584e+00, -3.083357198730634e-03, -1.000899843851347e-05,  5.645622566431459e-09,  2.027777978090387e-10,  5.511008971768769e-13, -3.260376767696472e-15,
 -2.651416808734905e-17,  1.851307525273980e-21,  8.189117162495270e-22,  2.895428605740682e-24, -1.627778579806788e-26,  1.652260558815348e+00, -2.670850842135684e-03,
 -1.085537557002537e-05, -1.128112773427672e-08,  1.578991982249567e-10,  9.622363185084952e-13,  2.485737677005640e-16, -2.624212349914118e-17, -1.319609846721176e-19,
  1.965569950285232e-22,  5.292780582447397e-24,  1.937052178843073e-26,  1.737403425322469e+00, -2.188404594876622e-03, -1.071605555997813e-05, -2.646324472545041e-08,
  6.664767337584682e-11,  9.976282342365239e-13,  3.931705490080214e-15, -5.959916253872807e-18, -1.573291398070039e-19, -7.638886926973056e-22,  5.801353166573915e-25,
  3.005513709075016e-26,  1.814296448623901e+00, -1.663972353580368e-03, -9.505410728766627e-06, -3.577211206932506e-08, -4.195243074359896e-11,  5.752445013200553e-13,
  5.088088722641176e-15,  1.903889791771634e-17, -2.143083549046965e-20, -7.787575775880675e-22, -5.059359724776524e-24, -1.085161042499799e-26,  1.880640571715624e+00,
 -1.137696834796474e-03, -7.361776383249622e-06, -3.613582214114340e-08, -1.216687474581915e-10, -7.757626730788613e-14,  2.630497065856387e-15,  2.365756867896580e-17,
  1.156848541573222e-19,  2.153957827793119e-22, -2.023091956752920e-24, -2.499028439218715e-26,  1.934148315468572e+00, -6.594905204848764e-04, -4.697436006774776e-06,
 -2.754826052694541e-08, -1.347767264633838e-10, -5.131873279752890e-13, -1.035317047406543e-15,  4.996583125864229e-18,  7.670791076538736e-20,  5.636654766547956e-22,
  2.888349348673186e-24,  9.095618594914415e-27,  1.972739502803452e+00, -2.828653821289345e-04, -2.154697918475754e-06, -1.417154154597165e-08, -8.406152461897997e-11,
 -4.541527653869232e-13, -2.211600595596703e-15, -9.336541238884048e-18, -3.018099803060568e-20, -3.046255215872816e-23,  5.953085905077014e-25,  7.004949310602847e-27,
  1.994775251429433e+00, -5.531987164970730e-05, -4.375514158621927e-07, -3.060186436347353e-09, -1.993391530172026e-11, -1.236661535721780e-13, -7.388130520583939e-16,
 -4.274978717414858e-18, -2.402224304001703e-20, -1.311659826584211e-22, -6.950372364802578e-25, -3.562258330333610e-27,  6.519629278981421e-04, -3.746371866378517e-06,
  1.614109204236638e-08, -6.180275803837817e-11,  2.217325158956525e-13, -7.634862467625101e-16,  2.553632808174439e-18, -8.365855883351036e-21,  2.693464418301802e-23,
 -8.571446340988511e-26,  2.690242328406742e-28, -8.409491361539871e-31,  5.867368674572692e-03, -3.366906647130346e-05,  1.446012105984207e-07, -5.505400786442958e-10,
  1.957803520915429e-12, -6.655761111449229e-15,  2.187544857778441e-17, -7.003157766515878e-20,  2.188681031838667e-22, -6.710095933442545e-25,  2.009461618131779e-27,
 -5.935493253592476e-30,  1.629655563184864e-02, -9.325587192748356e-05,  3.979500574429974e-07, -1.497773677394650e-09,  5.230167600428170e-12, -1.731052679355196e-14,
  5.478692875881964e-17, -1.665528316227618e-19,  4.851410781418926e-22, -1.352405319231477e-24,  3.545031555702043e-27, -8.691095662980139e-30,  3.193609571721857e-02,
 -1.819843720544314e-04,  7.690192212515310e-07, -2.843404785719848e-09,  9.647835766978295e-12, -3.056523500915882e-14,  9.064867865901900e-17, -2.501874885573604e-19,
  6.275195124527858e-22, -1.362552116891736e-24,  2.100583671609484e-27,  2.332138807129155e-31,  5.278039115558248e-02, -2.990577162995185e-04,  1.246994024763428e-06,
 -4.498293974220741e-09,  1.464619393022659e-11, -4.341955760909002e-14,  1.155333756971345e-16, -2.634673954334518e-19,  4.350060628701530e-22, -2.576150511938515e-26,
 -4.087088194605673e-27,  2.362351627304317e-29,  7.882110450250276e-02, -4.433884580682812e-04,  1.817344988430029e-06, -6.345615883372172e-09,  1.951450052718816e-11,
 -5.232959580579757e-14,  1.145704512933343e-16, -1.545757485096961e-19, -2.294953339174493e-22,  2.814272054901276e-24, -1.391752748591278e-26,  5.081939656163587e-29,
  1.100463586589305e-01, -6.135765316678013e-04,  2.461747239684439e-06, -8.242915057295963e-09,  2.343459692344867e-11, -5.360152444333933e-14,  7.489212543708523e-17,
  1.049675722445773e-19, -1.341946891987433e-21,  6.449325174252591e-24, -2.247479464509879e-26,  5.746410877173480e-29,  1.464396697800276e-01, -8.078809840601804e-04,
  3.157999009418227e-06, -1.002509464202699e-08,  2.553246999068966e-11, -4.388151081026536e-14, -1.102347396936859e-17,  5.030106630074523e-19, -2.653201670072089e-21,
  9.206492877913092e-24, -2.185649425599552e-26,  1.553173224291534e-29,  1.879785630223134e-01, -1.024185019384552e-03,  3.879955730495867e-06, -1.150864901886495e-08,
  2.494450428507332e-11, -2.073176891812769e-14, -1.419307098996551e-16,  9.735063124547470e-19, -3.676159302399890e-21,  8.746294471911740e-24, -4.311794225083704e-27,
 -8.661690090589396e-29,  2.346328053651456e-01, -1.259953897827972e-03,  4.597503709675218e-06, -1.249754258775895e-08,  2.090019774692064e-11,  1.672969756987138e-14,
 -3.047904067802841e-16,  1.391878967999517e-18, -3.752410104253648e-21,  2.853459372313436e-24,  3.255225148016981e-26, -2.206273908949401e-28,  2.863621704395454e-01,
 -1.512185285051875e-03,  5.276607673471829e-06, -1.279123798260777e-08,  1.282259011595547e-11,  6.716794830116505e-14, -4.728113527408912e-16,  1.584352019140340e-18,
 -2.220391796619790e-21, -9.315518394822901e-24,  7.994720514295205e-26, -3.048035458394369e-28,  3.431136264025468e-01, -1.777351820427676e-03,  5.879480685140608e-06,
 -1.219548073938356e-08,  4.463520900451331e-13,  1.264207775313725e-13, -6.054595632587981e-16,  1.356614241121588e-18,  1.310701251025125e-21, -2.578347304959841e-23,
  1.144153983956176e-25, -2.200876478313781e-28,  4.048178082617387e-01, -2.051336034568537e-03,  6.364944195731280e-06, -1.053653681176531e-08, -1.604907107340397e-11,
  1.870539346270844e-13, -6.515548318613659e-16,  5.457861394774929e-19,  6.611810854673384e-21, -4.066279398297640e-23,  1.009251482334824e-25,  1.281119239435489e-28,
  4.713845994324267e-01, -2.329358411529843e-03,  6.689071663095340e-06, -7.679620115157313e-09, -3.589836063736221e-11,  2.382528643269196e-13, -5.566952869727508e-16,
 -9.044311900264473e-19,  1.249664864826501e-20, -4.431831805209886e-23,  6.831967161136796e-27,  7.039262719381692e-28,  5.426976024813305e-01, -2.605900529933180e-03,
  6.806242484097259e-06, -3.552176271834369e-09, -5.761571818271363e-11,  2.662891480874017e-13, -2.761020014690385e-16, -2.853845199618188e-18,  1.665978175864396e-20,
 -2.587461989804443e-23, -1.719408900820081e-25,  1.232771826506406e-27,  6.186072250970696e-01, -2.874627086901590e-03,  6.670774506622933e-06,  1.827604081220450e-09,
 -7.889249459902877e-11,  2.558662857234630e-13,  2.067365061831878e-16, -4.883587884981822e-18,  1.593438568159602e-20,  2.110403755493959e-23, -3.790322306857306e-25,
  1.190335067773264e-27,  6.989220444081395e-01, -3.128313585644844e-03,  6.239351824343673e-06,  8.317365207752778e-09, -9.656902181189934e-11,  1.926856679239194e-13,
  8.569572537439457e-16, -6.264283687547207e-18,  7.250063788188928e-21,  9.016405505139617e-23, -4.801582019840125e-25,  3.005428850329323e-29,  7.833980430592674e-01,
 -3.358791087529841e-03,  5.474514396813401e-06,  1.561396394569224e-08, -1.067439006482300e-10,  6.751873354737718e-14,  1.565357316575722e-15, -6.039717626460590e-18,
 -1.053555458360271e-20,  1.538658742334899e-22, -2.950318925929349e-25, -2.264432591918750e-27,  8.717252404510923e-01, -3.556926419734012e-03,  4.349513218894139e-06,
  2.321782169202002e-08, -1.051079409241322e-10, -1.181835096098781e-13,  2.135390824440878e-15, -3.303402433406031e-18, -3.416135400457158e-20,  1.632997289336237e-22,
  2.850784371731999e-25, -4.484698832024825e-27,  9.635111867623797e-01, -3.712666501422376e-03,  2.854829210623958e-06,  3.040649551852290e-08, -8.760833319126270e-11,
 -3.457341609008946e-13,  2.296680255523547e-15,  2.280960835754103e-18, -5.392537213790626e-20,  6.600418758493382e-23,  1.100222542607474e-24, -4.069700166588790e-27,
  1.058260774614186e+00, -3.815189976818601e-03,  1.006547852222981e-06,  3.623183689840819e-08, -5.154190224121318e-11, -5.734842753821802e-13,  1.767095999431428e-15,
  9.776608211265854e-18, -5.439885100011958e-20, -1.498915647742152e-22,  1.567925462063890e-24,  1.299711376575355e-27,  1.155351906521303e+00, -3.853228756267435e-03,
 -1.143526774852355e-06,  3.956324966904231e-08,  2.893778669774899e-12, -7.355480609358683e-13,  3.823434690319645e-16,  1.639804653148775e-17, -2.104306200453562e-20,
 -3.969444221914429e-22,  8.588823348527482e-25,  9.953121647434760e-27,  1.254006827282871e+00, -3.815645686719910e-03, -3.496805998391472e-06,  3.920814672684749e-08,
  7.075754123377222e-11, -7.507236306307173e-13, -1.713702444684807e-15,  1.773581580413776e-17,  4.576464612983867e-20, -4.685231212423719e-22, -1.306306062151946e-24,
  1.322995411800727e-26,  1.353259537512678e+00, -3.692378366433796e-03, -5.897935111347745e-06,  3.414463358926383e-08,  1.407872493491359e-10, -5.481885744742696e-13,
 -3.889855881607875e-15,  9.679934358478799e-18,  1.150197390739960e-19, -1.504216172923892e-22, -3.524114853138612e-24,  7.620876005153941e-28,  1.451920867449844e+00,
 -3.475871982343903e-03, -8.129957911506108e-06,  2.388918770055004e-08,  1.952470218507700e-10, -1.124829818851971e-13, -5.034943002662147e-15, -7.651149793287586e-18,
  1.263942120006405e-19,  4.980060509320930e-22, -2.819067728234427e-24, -2.194221968925560e-26,  1.548544791863720e+00, -3.163102231994538e-03, -9.921435032985943e-06,
  8.973740005589037e-09,  2.129573441782378e-10,  4.639777909057500e-13, -3.997361539823886e-15, -2.596241392183763e-17,  3.322407063948243e-20,  9.181935403689804e-22,
  2.014424333183400e-24, -2.371147709516085e-26,  1.641402674634690e+00, -2.758190928814933e-03, -1.097495535692526e-05, -8.600716922999550e-09,  1.771416322705594e-10,
  9.589156034217802e-13, -5.439598764594572e-16, -3.030921366536939e-17, -1.208815717285990e-19,  4.238623801536108e-22,  6.031314519276227e-24,  1.371393870275333e-26,
  1.728476366480922e+00, -2.275383597556170e-03, -1.102654145825523e-05, -2.523220178692678e-08,  8.752728309082625e-11,  1.089392548764579e-12,  3.690257824420903e-15,
 -1.142724154322009e-17, -1.840711931287936e-19, -7.118747785067592e-22,  2.078154848878322e-24,  3.794606192045281e-26,  1.807485739055848e+00, -1.741743193480064e-03,
 -9.938301862360712e-06, -3.634449746284623e-08, -2.918373478437861e-11,  7.036508839927041e-13,  5.607078786308465e-15,  1.786464707337940e-17, -5.320959765237714e-20,
 -9.890646872239316e-22, -5.410322393449457e-24, -4.569625720207755e-27,  1.875969202785035e+00, -1.198358753705890e-03, -7.807125904129934e-06, -3.809127130318331e-08,
 -1.225331080318358e-10, -6.070527287456149e-15,  3.345777090629677e-15,  2.746565505517079e-17,  1.216979463445878e-19,  1.103226394506758e-22, -3.285549596431126e-24,
 -3.253326305574867e-26,  1.931433047949298e+00, -6.984297728726250e-04, -5.041296633129960e-06, -2.978809537038356e-08, -1.452761008162979e-10, -5.360591432200162e-13,
 -8.578335647154100e-16,  7.798976793929792e-18,  9.917405739036178e-20,  6.869807945716490e-22,  3.269647850618343e-24,  8.019120935417996e-27,  1.971572455857185e+00,
 -3.008067737038239e-04, -2.333135653630435e-06, -1.559216516808133e-08, -9.369710701862953e-11, -5.104782252239918e-13, -2.486673210093432e-15, -1.031463319670506e-17,
 -3.076740830590336e-20,  3.329481833902353e-25,  9.663837739649989e-25,  1.001844022645839e-26,  1.994546730635422e+00, -5.897278839088920e-05, -4.762721644637007e-07,
 -3.399921396376894e-09, -2.259471732386386e-11, -1.429254869172534e-13, -8.700243976284096e-16, -5.124929865994982e-18, -2.928479508457690e-20, -1.623663228290858e-22,
 -8.719210526068847e-25, -4.516189386451664e-27,  6.372310845377332e-04, -3.620150490434234e-06,  1.542025193958124e-08, -5.837394357283498e-11,  2.070571805935051e-13,
 -7.049153699754733e-16,  2.331006075730812e-18, -7.551312185346197e-21,  2.403402496465449e-23, -7.565849432369697e-26,  2.346075238945125e-28, -7.264886722926348e-31,
  5.734964925698969e-03, -3.253816012241453e-05,  1.381783766042604e-07, -5.202522712449748e-10,  1.829783572196967e-12, -6.153511306841817e-15,  2.000909352037608e-17,
 -6.339928371385174e-20,  1.960977448052271e-22, -5.956237553762074e-25,  1.765331607101579e-27, -5.179902139053702e-30,  1.592978748852762e-02, -9.014276785445881e-05,
  3.804676716185725e-07, -1.416790792507949e-09,  4.896737064558089e-12, -1.604989201081963e-14,  5.033366431989725e-17, -1.517806677307290e-19,  4.389170550076947e-22,
 -1.218000085841795e-24,  3.181326357054976e-27, -7.854076651799962e-30,  3.122025008224654e-02, -1.759661232056477e-04,  7.358047594905777e-07, -2.693813986708424e-09,
  9.057730861313604e-12, -2.847150535093518e-14,  8.391729923228528e-17, -2.308754756087846e-19,  5.799798135210585e-22, -1.278617884694347e-24,  2.089337039476830e-27,
 -7.002754886305312e-31,  5.160377586278218e-02, -2.892937634786911e-04,  1.194392356009804e-06, -4.270753824964172e-09,  1.380494136596559e-11, -4.073371059147330e-14,
  1.083508183402252e-16, -2.495916407526955e-19,  4.313741137235344e-22, -1.698000061695599e-25, -3.146696328096837e-27,  1.924709589505576e-29,  7.707615331315079e-02,
 -4.291490583568067e-04,  1.743036932238304e-06, -6.041608695726767e-09,  1.849505103637976e-11, -4.963258240282870e-14,  1.101540059561056e-16, -1.604017741924510e-19,
 -1.376823889285850e-22,  2.300203593766902e-24, -1.183615408604644e-26,  4.391797398905320e-29,  1.076308229188225e-01, -5.942719202979279e-04,  2.365046922165876e-06,
 -7.876439176423086e-09,  2.238075442099703e-11, -5.177348836028614e-14,  7.726372027586083e-17,  6.557145056569194e-20, -1.125354769136739e-21,  5.599679156978904e-24,
 -2.003845731234588e-26,  5.321832672532361e-29,  1.432579216371853e-01, -7.830913184660150e-04,  3.040119995149961e-06, -9.623605918597814e-09,  2.465328666357809e-11,
 -4.398635633219192e-14,  1.920821207751206e-18,  4.232438874540076e-19, -2.337319845735837e-21,  8.348064281069502e-24, -2.101637233028731e-26,  2.220922436892385e-29,
  1.839430371148212e-01, -9.936910364579971e-04,  3.744232356953285e-06, -1.111303007863968e-08,  2.449794597827362e-11, -2.382401125644939e-14, -1.162723958794359e-16,
  8.608667826700364e-19, -3.365248557622476e-21,  8.504902123652301e-24, -7.585868486339501e-27, -6.299779595407748e-29,  2.296656080759804e-01, -1.223768042429241e-03,
  4.449549407392255e-06, -1.216084711101636e-08,  2.116472909117527e-11,  9.868933869574530e-15, -2.674817475600001e-16,  1.273678406830563e-18, -3.628488262137491e-21,
  3.972240440306690e-24,  2.364829342504545e-26, -1.847292824094304e-28,  2.803968879415507e-01, -1.470582817178847e-03,  5.124386160878594e-06, -1.257593128020372e-08,
  1.405602493637103e-11,  5.634450073030195e-14, -4.294903967982835e-16,  1.508525143666134e-18, -2.501353275899430e-21, -6.378417248411618e-24,  6.709746641820423e-26,
 -2.788027024214605e-28,  3.360973643736257e-01, -1.730901049519716e-03,  5.733258681790788e-06, -1.216888831124924e-08,  2.832555114956859e-12,  1.123494833345195e-13,
 -5.670205250285098e-16,  1.384569295757320e-18,  4.624742763055581e-22, -2.140770539469985e-23,  1.042220144813483e-25, -2.408716463848721e-28,  3.967134966588915e-01,
 -2.000926321287491e-03,  6.237085761791497e-06, -1.076423733792510e-08, -1.246300977359306e-11,  1.716225866004387e-13, -6.335251862035450e-16,  7.347306121434768e-19,
  5.221691858829583e-21, -3.654380071663168e-23,  1.043054619396585e-25,  2.935260885459284e-29,  4.621735939682871e-01, -2.276223866956181e-03,  6.593624852891697e-06,
 -8.216607173769538e-09, -3.126873417652307e-11,  2.246320055673967e-13, -5.766600001531283e-16, -5.299554322583165e-19,  1.091312151844058e-20, -4.347492696411193e-23,
  3.414287595072987e-26,  5.399571947277870e-28,  5.323826086820486e-01, -2.551636363706949e-03,  6.758259772822466e-06, -4.431807632329224e-09, -5.236236470107819e-11,
  2.587631442714288e-13, -3.486949783688600e-16, -2.336859493173279e-18,  1.561722721455047e-20, -3.170542466361354e-23, -1.205799742185621e-25,  1.098334027081883e-27,
  6.072155582594473e-01, -2.821194234169592e-03,  6.685301696600802e-06,  6.064869106100628e-10, -7.373632771237839e-11,  2.592452950371983e-13,  7.722860472364248e-17,
 -4.364353690027629e-18,  1.643408876418084e-20,  7.015356224528031e-24, -3.249177737318852e-25,  1.257025795313115e-27,  6.865092151269300e-01, -3.078025504445728e-03,
  6.330020211341106e-06,  6.804148910678779e-09, -9.252369837355839e-11,  2.111769258252090e-13,  6.852669327816398e-16, -5.984043532867902e-18,  1.015176099117573e-20,
  7.111309325833660e-23, -4.693758603890646e-25,  4.438246825585029e-28,  7.700516167627610e-01, -3.314274420824754e-03,  5.651685565519203e-06,  1.391884763982672e-08,
 -1.050317137817067e-10,  1.030248996146120e-13,  1.392340707801543e-15, -6.290689276270815e-18, -5.231010805759879e-21,  1.402702256535846e-22, -3.798680936683881e-25,
 -1.594712767225403e-27,  8.575688509624061e-01, -3.521044609614392e-03,  4.617967644519354e-06,  2.151993622480236e-08, -1.069672245357435e-10, -6.816209925892994e-14,
  2.028488532294888e-15, -4.300684257206429e-18, -2.812392982426751e-20,  1.708615823078652e-22,  9.596258501998737e-26, -4.080841531606673e-27,  9.487084746078931e-01,
 -3.688392691383907e-03,  3.211078324445533e-06,  2.895245783037861e-08, -9.396763729199898e-11, -2.900399357703351e-13,  2.336804266221225e-15,  6.014970495226021e-19,
 -5.080227876086936e-20,  1.062102787525841e-22,  9.052424168970486e-25, -4.734183235506749e-27,  1.043018852170203e+00, -3.805413341504865e-03,  1.436011082639564e-06,
  3.531780274642190e-08, -6.256634754232229e-11, -5.279902884085209e-13,  2.015745901079299e-15,  7.961687843461241e-18, -5.865769971026549e-20, -8.662640104170498e-23,
  1.580857765499178e-24, -6.854872473623169e-28,  1.139923701517002e+00, -3.860478261399283e-03, -6.689733998865093e-07,  3.949251558771181e-08, -1.168867770051554e-11,
 -7.209511119732868e-13,  8.299653104409810e-16,  1.550348687687253e-17, -3.461356188023245e-20, -3.543259924936704e-22,  1.258765213433567e-24,  8.133490089452240e-27,
  1.238691301108361e+00, -3.841720052381690e-03, -3.020017761917353e-06,  4.021808855702684e-08,  5.537279275891123e-11, -7.857436869818821e-13, -1.199197843935641e-15,
  1.892149886925540e-17,  2.810200698742135e-20, -5.086595536491308e-22, -6.906591038551431e-25,  1.458142056419482e-26,  1.338398305000130e+00, -3.737885476494311e-03,
 -5.475061897901070e-06,  3.630454659695875e-08,  1.289139912629494e-10, -6.378827192802277e-13, -3.568296088640879e-15,  1.324687560728707e-17,  1.070894385764398e-19,
 -2.891596044287020e-22, -3.374221561136919e-24,  6.048878789504286e-27,  1.437889190467457e+00, -3.539712071394066e-03, -7.824639630149597e-06,  2.698851279528706e-08,
  1.917740524541322e-10, -2.354196172072043e-13, -5.190021271898148e-15, -3.343291985061870e-18,  1.420667653993911e-19,  3.667034043932926e-22, -3.723348000947685e-24,
 -1.882437862298792e-26,  1.535734404640742e+00, -3.241984378176879e-03, -9.793017576658192e-06,  1.244983679497584e-08,  2.212194028273801e-10,  3.594689270695716e-13,
 -4.704357039192641e-15, -2.435697746521447e-17,  6.745921995275526e-20,  9.758585321371543e-22,  8.202407028722586e-25, -3.036747408528310e-26,  1.630193727915698e+00,
 -2.846353772079168e-03, -1.106052858359837e-05, -5.614029844463232e-09,  1.961184596176558e-10,  9.352553536468793e-13, -1.444140718838986e-15, -3.388567230791239e-17,
 -1.011553602910728e-19,  6.748560239085924e-22,  6.455399611809449e-24,  5.070845872710590e-27,  1.719196525612314e+00, -2.364781580936213e-03, -1.132019100051205e-05,
 -2.365277141271375e-08,  1.101713409087625e-10,  1.173430558997016e-12,  3.284112431913089e-15, -1.770812185261763e-17, -2.077805944841798e-19, -5.932429793712918e-22,
  3.902793203347028e-24,  4.470121128535952e-26,  1.800356981534735e+00, -1.823000964351727e-03, -1.037674892115702e-05, -3.669137527344506e-08, -1.372564063148251e-11,
  8.439964898467764e-13,  6.077798861153713e-15,  1.555022899433652e-17, -9.273649094224567e-20, -1.206884179263672e-21, -5.409142857010210e-24,  5.256765310652537e-27,
  1.871047911791575e+00, -1.262677450518218e-03, -8.275973478545749e-06, -4.004813999498717e-08, -1.217869536398116e-10,  8.389933376303682e-14,  4.169735431097735e-15,
  3.139522952814327e-17,  1.229374582812423e-19, -5.209799553687489e-23, -4.894714045634122e-24, -4.065321173440180e-26,  1.928556347347471e+00, -7.402303112964691e-04,
 -5.413057486721179e-06, -3.219932006155634e-08, -1.561835219808135e-10, -5.536443085715137e-13, -5.911305159100110e-16,  1.139414250468671e-17,  1.263387770298951e-19,
  8.241627833245005e-22,  3.569570255710152e-24,  5.275859286857063e-27,  1.970330676557530e+00, -3.202465659636734e-04, -2.529584250374218e-06, -1.717633821225616e-08,
 -1.045274405722997e-10, -5.737350536223634e-13, -2.789206434019605e-15, -1.129061045456507e-17, -2.994335517910720e-20,  4.892351653562934e-23,  1.493015464789889e-24,
  1.412496585546408e-26,  1.994302951760817e+00, -6.295253256453409e-05, -5.193384579395132e-07, -3.785490229373378e-09, -2.567422736031839e-11, -1.656395943105761e-13,
 -1.027571086994310e-15, -6.162705989379542e-18, -3.580868599336078e-20, -2.015542469251884e-22, -1.096327975276701e-24, -5.732795738823381e-27,  6.229928483090738e-04,
 -3.499535156729703e-06,  1.473918651533978e-08, -5.517084586715351e-11,  1.935016269752805e-13, -6.514240114831320e-16,  2.129939673527669e-18, -6.824052226263573e-21,
  2.147180649959883e-23, -6.688368251789591e-26,  2.048423857535471e-28, -6.290596551893950e-31,  5.606984290577564e-03, -3.145721670423428e-05,  1.321070301542241e-07,
 -4.919347950938515e-10,  1.711375321267947e-12, -5.693905468633548e-15,  1.831863649138893e-17, -5.745404057878634e-20,  1.758732220053323e-22, -5.293701884796937e-25,
  1.552083781119122e-27, -4.529290857092622e-30,  1.557519807246704e-02, -8.716572450353767e-05,  3.639258846668497e-07, -1.340946764006625e-09,  4.587483098922655e-12,
 -1.489133490139339e-14,  4.627401990073137e-17, -1.384129923309859e-19,  3.972784154318181e-22, -1.097429851364811e-24,  2.852704549308663e-27, -7.096280124356841e-30,
  3.052795715770701e-02, -1.702065670747923e-04,  7.043300911700223e-07, -2.553338466367761e-09,  8.507927940804795e-12, -2.653300907917479e-14,  7.770581157301945e-17,
 -2.130365495591784e-19,  5.354444317198217e-22, -1.195881109240757e-24,  2.042423465716482e-27, -1.398439515406802e-30,  5.046539172988208e-02, -2.799399268791344e-04,
  1.144442151481237e-06, -4.056253215465733e-09,  1.301571331121307e-11, -3.821560037080326e-14,  1.015544251066041e-16, -2.359081784370101e-19,  4.231894217393813e-22,
 -2.798596878130812e-25, -2.383070286590834e-27,  1.556797711254551e-29,  7.538699351218069e-02, -4.154898039783281e-04,  1.672280856383352e-06, -5.753486986538792e-09,
  1.752847029860557e-11, -4.704320577692565e-14,  1.056128931463543e-16, -1.635704011903669e-19, -6.294843261223593e-23,  1.863543230090080e-24, -1.004163586971766e-26,
  3.776967784481474e-29,  1.052909858702917e-01, -5.757236044741809e-04,  2.272644361867354e-06, -7.526529558572357e-09,  2.136395640272429e-11, -4.990101550020334e-14,
  7.862479064532951e-17,  3.263531807444029e-20, -9.376416194578991e-22,  4.843659213729410e-24, -1.779537242926239e-26,  4.871305233612331e-29,  1.401734762679514e-01,
 -7.592256527185252e-04,  2.926974427415884e-06, -9.236184763518020e-09,  2.377493792873857e-11, -4.380622648728951e-14,  1.276856525340010e-17,  3.530978899544850e-19,
 -2.051672687069587e-21,  7.528363561187874e-24, -1.993771818886753e-26,  2.646601304539237e-29,  1.800273454546901e-01, -9.642639767625849e-04,  3.613211605715200e-06,
 -1.072501842386889e-08,  2.399545112671137e-11, -2.633718557159052e-14, -9.363017593474055e-17,  7.580140287703345e-19, -3.065147367977904e-21,  8.151961401059064e-24,
 -9.922036204627087e-27, -4.388582193146806e-29,  2.248408126166523e-01, -1.188749598231198e-03,  4.305656472272753e-06, -1.182096932122054e-08,  2.130073362583070e-11,
  3.864345536206357e-15, -2.334216047380409e-16,  1.160022045337155e-18, -3.470330872951284e-21,  4.765309993419185e-24,  1.623802663809704e-26, -1.527612288258766e-28,
  2.745955965865626e-01, -1.430187467278858e-03,  4.974859775955539e-06, -1.234256562069107e-08,  1.508321101068773e-11,  4.653435652454732e-14, -3.884032625868445e-16,
  1.425302353358381e-18, -2.685548605979258e-21, -3.931726323859391e-24,  5.544060406089053e-26, -2.508842472942665e-28,  3.292645687858220e-01, -1.685618150216390e-03,
  5.587575738979640e-06, -1.210631770449598e-08,  4.946605782795021e-12,  9.920719446713214e-14, -5.281556395005483e-16,  1.387821291021116e-18, -2.357479599497965e-22,
 -1.745397667346517e-23,  9.340605477241883e-26, -2.489352356435599e-28,  3.888087622153114e-01, -1.951549452988879e-03,  6.106829079591068e-06, -1.093700467823622e-08,
 -9.180845187674859e-12,  1.566825464862566e-13, -6.108054378339416e-16,  8.815818139434486e-19,  3.981303936027416e-21, -3.236986556183115e-23,  1.038322914234773e-25,
 -4.744030289318247e-29,  4.531735604727507e-01, -2.223877433840127e-03,  6.492169577521015e-06, -8.681722117974018e-09, -2.691549655858249e-11,  2.106521267602718e-13,
 -5.868428250315705e-16, -2.054697453486015e-19,  9.377923814460575e-21, -4.167870794282206e-23,  5.459508354312722e-26,  3.926689698171029e-28,  5.222838389737681e-01,
 -2.497796864594455e-03,  6.700220546640135e-06, -5.228679307437906e-09, -4.727580134226187e-11,  2.496646662573190e-13, -4.073082180155088e-16, -1.856209474317241e-18,
  1.440026807034559e-20, -3.560541142828509e-23, -7.551040004376752e-26,  9.486987086330177e-28,  5.960377644482754e-01, -2.767702371001012e-03,  6.685672169229012e-06,
 -5.317548568631750e-10, -6.854247750811582e-11,  2.596919307402291e-13, -3.759011484542605e-17, -3.836821851885968e-18,  1.646607567550365e-20, -4.871074544861038e-24,
 -2.694133321246429e-25,  1.255949221498646e-27,  6.742988754489158e-01, -3.027083583538781e-03,  6.402929840560428e-06,  5.358395354283275e-09, -8.814906831820632e-11,
  2.256516393669521e-13,  5.226209838656482e-16, -5.621805309719122e-18,  1.237950990677388e-20,  5.282847260501753e-23, -4.425614565735391e-25,  7.588058305525901e-28,
  7.568859637697100e-01, -3.268421232144780e-03,  5.808702406030631e-06,  1.225657964657040e-08, -1.026513996521405e-10,  1.343130475857649e-13,  1.214595411198965e-15,
 -6.380344346808372e-18, -4.699594430109262e-22,  1.238624178563005e-22, -4.359041127031540e-25, -9.611119970602745e-28,  8.435601543307946e-01, -3.483097093236001e-03,
  4.865901490897015e-06,  1.980015714622989e-08, -1.078538846180011e-10, -2.101939902812248e-14,  1.896397847523304e-15, -5.101835009925218e-18, -2.194569532670067e-20,
  1.712643547031595e-22, -7.174337754057495e-26, -3.521546340556438e-27,  9.340084448424882e-01, -3.661340327057954e-03,  3.549305377327296e-06,  2.740561890562309e-08,
 -9.920717231194261e-11, -2.339344588105134e-13,  2.331508999962118e-15, -9.564252120547641e-19, -4.637824600788205e-20,  1.381368235576534e-22,  6.888068828215485e-25,
 -5.047394379404672e-27,  1.027822834072897e+00, -3.792247801465603e-03,  1.853478584994139e-06,  3.423496321885270e-08, -7.262542402652642e-11, -4.771518131865297e-13,
  2.212012197089654e-15,  6.046857256920785e-18, -6.065024132254286e-20, -2.453409102341860e-23,  1.510914760728532e-24, -2.447162146707768e-27,  1.124474080404692e+00,
 -3.863938675261626e-03, -1.966572503199893e-07,  3.919137203532871e-08, -2.587404191159118e-11, -6.959593578044465e-13,  1.246711606360146e-15,  1.420214091530795e-17,
 -4.638253383465632e-20, -2.974597054161974e-22,  1.568007771564892e-24,  5.865718285572054e-27,  1.223279176866196e+00, -3.863935868415696e-03, -2.532608071262457e-06,
  4.097695223982444e-08,  3.941347827262465e-11, -8.080822741474456e-13, -6.595897309574203e-16,  1.952370929963296e-17,  9.449200836864424e-21, -5.232951471486821e-22,
 -3.916721865983100e-26,  1.484958205931194e-26,  1.323361969436698e+00, -3.779909287993640e-03, -5.027467309592005e-06,  3.826058910883574e-08,  1.153319468554480e-10,
 -7.186941751315649e-13, -3.151154687720348e-15,  1.648174455004391e-17,  9.432824126082822e-20, -4.172909746040799e-22, -2.995706496030337e-24,  1.107179637134565e-26,
  1.423607272188690e+00, -3.600961979206468e-03, -7.482544531564707e-06,  3.001244026803492e-08,  1.858151752568113e-10, -3.605786287511008e-13, -5.218216870719035e-15,
  1.383780094769175e-18,  1.523998064004615e-19,  2.025644290817678e-22, -4.446565619656521e-24, -1.374459978879949e-26,  1.522610810651445e+00, -3.319670249540894e-03,
 -9.622165716257616e-06,  1.604050071458067e-08,  2.272258930912469e-10,  2.386569670181141e-13, -5.350819815299525e-15, -2.163256870405930e-17,  1.028437098399630e-19,
  9.803285112224164e-22, -6.330449394100414e-25, -3.533772619238663e-26,  1.618630994870121e+00, -2.935052722233343e-03, -1.110845929773863e-05, -2.328705660813538e-09,
  2.143983315957373e-10,  8.888688502580768e-13, -2.434247904408178e-15, -3.668384150975556e-17, -7.218753538968625e-20,  9.343495751884877e-22,  6.435687870068532e-24,
 -6.396219989658339e-27,  1.709554523313244e+00, -2.456446664818644e-03, -1.159265996617004e-05, -2.169818092619629e-08,  1.343840145435623e-10,  1.245529434370579e-12,
  2.692226238010587e-15, -2.466473895666355e-17, -2.258393925146068e-19, -3.963069889848611e-22,  5.975254672638180e-24,  4.896655848257748e-26,  1.792896157636519e+00,
 -1.907778540033953e-03, -1.081777998681542e-05, -3.676787915901854e-08,  4.646320003485154e-12,  9.947115807636552e-13,  6.464833644048100e-15,  1.184641012238805e-17,
 -1.399893041862125e-19, -1.414846807550622e-21, -4.888044045660713e-24,  1.911831304076413e-26,  1.865861696203496e+00, -1.330840510748521e-03, -8.768168883683108e-06,
 -4.197756318057708e-08, -1.190347411862233e-10,  1.949631498335665e-13,  5.103305511316516e-15,  3.525779075194059e-17,  1.170849353972620e-19, -2.860380001396423e-22,
 -6.859910691304499e-24, -4.854398514954585e-26,  1.925506308944586e+00, -7.851236664454141e-04, -5.814810530792974e-06, -3.478749328463514e-08, -1.673699565858755e-10,
 -5.635177579973166e-13, -2.108356531077946e-16,  1.593963646966324e-17,  1.586229069334522e-19,  9.702557767216290e-22,  3.696851377861686e-24,  9.313165752011889e-30,
  1.969007870225236e+00, -3.413370319135951e-04, -2.746125688286210e-06, -1.894432140465256e-08, -1.166977093665590e-10, -6.445758571341630e-13, -3.118403727855410e-15,
 -1.220778779473704e-17, -2.694378858089947e-20,  1.225860590348555e-22,  2.230348251832689e-24,  1.965572085765031e-26,  1.994042534315796e+00, -6.729618792771119e-05,
 -5.673428952169049e-07, -4.224181242389297e-09, -2.924831211063385e-11, -1.925084735927770e-13, -1.217323280323955e-15, -7.433661419627147e-18, -4.391864771492300e-20,
 -2.508814657769954e-22, -1.381309550937290e-24, -7.282435170787947e-27,  6.092264147036295e-04, -3.384218205202675e-06,  1.409529140393550e-08, -5.217633383210719e-11,
  1.809692473425742e-13, -6.025228684068347e-16,  1.948134574553832e-18, -6.173950637314385e-21,  1.920504275357599e-23, -5.921818052561440e-26,  1.790362458713724e-28,
 -5.461626695694880e-31,  5.483232395148444e-03, -3.042351634128824e-05,  1.263644225768157e-07, -4.654404630688000e-10,  1.601766592413790e-12, -5.272943982946220e-15,
  1.678593282714130e-17, -5.211941207887062e-20,  1.578869335954151e-22, -4.711017857053082e-25,  1.365408318953809e-27, -3.970035464667971e-30,  1.523225780889076e-02,
 -8.431745732470642e-05,  3.482652855175052e-07, -1.269870598992370e-09,  4.300455517254066e-12, -1.382586436287821e-14,  4.257065109192179e-17, -1.263107780702291e-19,
  3.597515214525745e-22, -9.893607699628894e-25,  2.555697478562709e-27, -6.416918935492494e-30,  2.985820933183246e-02, -1.646922121171973e-04,  6.744896016405297e-07,
 -2.421357566167276e-09,  7.995443826727065e-12, -2.473775293424092e-14,  7.197430685035013e-17, -1.965755181726313e-19,  4.938469101551284e-22, -1.115579208494313e-24,
  1.968882949848590e-27, -1.919405218246629e-30,  4.936363974406504e-02, -2.709756067859882e-04,  1.096991821972730e-06, -3.853986090015583e-09,  1.227524719284223e-11,
 -3.585603899814534e-14,  9.513694668233249e-17, -2.225444312472395e-19,  4.115550182084252e-22, -3.624334928102045e-25, -1.768190046706545e-27,  1.246741424429880e-29,
  7.375136016273420e-02, -4.023830273773592e-04,  1.604891139023628e-06, -5.480422215990857e-09,  1.661258137658232e-11, -4.456362432178226e-14,  1.010142721540094e-16,
 -1.645857209766705e-19, -2.705505786753649e-24,  1.493459274441377e-24, -8.502367971040754e-27,  3.230301733308774e-29,  1.030238898505367e-01, -5.578979871840445e-04,
  2.184344345126508e-06, -7.192587640176795e-09,  2.038486320288366e-11, -4.800628925980648e-14,  7.914377441758450e-17,  5.287465331788493e-21, -7.755782975691113e-22,
  4.173360847643654e-24, -1.575304714741546e-26,  4.411499075216554e-29,  1.371827123398184e-01, -7.362467938458615e-04,  2.818393754990130e-06, -8.862774871515275e-09,
  2.290264138182566e-11, -4.338831390073970e-14,  2.177581638708020e-17,  2.916291110774394e-19, -1.794718483494491e-21,  6.754957618749767e-24, -1.871559040311434e-26,
  2.880486697322460e-29,  1.762272949924480e-01, -9.358665988292306e-04,  3.486797189145554e-06, -1.034542022894991e-08,  2.344789920783748e-11, -2.834043231310434e-14,
 -7.373541729415867e-17,  6.645447563192289e-19, -2.779242388686116e-21,  7.721196033539589e-24, -1.150569967371744e-26, -2.870135507112546e-29,  2.201538145184160e-01,
 -1.154865955230714e-03,  4.165851304976907e-06, -1.147983284997850e-08,  2.132456611582685e-11, -1.360391607583900e-15, -2.024690857079347e-16,  1.051829001775243e-18,
 -3.288630128598308e-21,  5.288920311243108e-24,  1.014610325712753e-26, -1.248039653706931e-28,  2.689535123200195e-01, -1.390976862079292e-03,  4.828226085475223e-06,
 -1.209428183269205e-08,  1.592386325540944e-11,  3.768175286111352e-14, -3.497162721279286e-16,  1.337507031884768e-18, -2.789758005799214e-21, -1.926547958274732e-24,
  4.502406976177026e-26, -2.226530437713082e-28,  3.226105794093858e-01, -1.641497155691688e-03,  5.442838082547126e-06, -1.201197438627504e-08,  6.807133120135355e-12,
  8.699635926904352e-14, -4.894917024978518e-16,  1.370923515187300e-18, -7.994809284503506e-22, -1.393694609314088e-23,  8.245690683812029e-26, -2.474089047143873e-28,
  3.810994392383545e-01, -1.903222060741198e-03,  5.974804516278409e-06, -1.105961684593471e-08, -6.191718198082952e-12,  1.423327756481784e-13, -5.845070228293304e-16,
  9.911348839157212e-19,  2.890076772067210e-21, -2.827653323731706e-23,  1.004164361076056e-25, -1.048620400362713e-28,  4.443812557200740e-01, -2.172363805684481e-03,
  6.385541572100814e-06, -9.079432329256149e-09, -2.284359287788023e-11,  1.965314011584517e-13, -5.886170442537356e-16,  7.106977554596378e-20,  7.920603090776406e-21,
 -3.918857264994690e-23,  6.897591271080147e-26,  2.641965787289899e-28,  5.123994400064801e-01, -2.444458559890459e-03,  6.633100930169830e-06, -5.945693661876408e-09,
 -4.238420785577049e-11,  2.393164507626001e-13, -4.530271562226044e-16, -1.416413621016103e-18,  1.307375234440894e-20, -3.783640310866288e-23, -3.716569345575865e-26,
  7.941542753042844e-28,  5.850738595051040e-01, -2.714260767197922e-03,  6.672882173768865e-06, -1.586968263695363e-09, -6.336605566461964e-11,  2.575599034440663e-13,
 -1.376848927751624e-16, -3.314685632865486e-18,  1.610994925926363e-20, -1.455493599671224e-23, -2.151751618585809e-25,  1.201884754682776e-27,  6.622933618384776e-01,
 -2.975626571228102e-03,  6.458919267637348e-06,  3.984743328347536e-09, -8.352311838325749e-11,  2.363520175386181e-13,  3.710184047756464e-16, -5.198578663472205e-18,
  1.397139821385615e-20,  3.586505467179251e-23, -4.040123429900438e-25,  9.782207339710913e-28,  7.439061104433008e-01, -3.221391004109826e-03,  5.946020438558920e-06,
  1.063717045228345e-08, -9.968809816559939e-11,  1.613218403725336e-13,  1.036381151241444e-15, -6.327475755592015e-18,  3.666626710054034e-21,  1.057531348027878e-22,
 -4.654234964362214e-25, -3.934759589682050e-28,  8.297070837555712e-01, -3.443248826152305e-03,  5.093143405322513e-06,  1.807355486682819e-08, -1.078310941188220e-10,
  2.270624695063285e-14,  1.744636028815224e-15, -5.706294800120655e-18, -1.586747677839060e-20,  1.654833650661562e-22, -2.125333381608443e-25, -2.867150579448981e-27,
  9.194219167077841e-01, -3.631657734567816e-03,  3.868504335194321e-06,  2.578390286123443e-08, -1.033293150607253e-10, -1.784625311094676e-13,  2.284734623932584e-15,
 -2.356080653899568e-18, -4.096311479730643e-20,  1.612284053414821e-22,  4.658542760300082e-25, -5.036910871293030e-27,  1.012686071561160e+00, -3.775797154927320e-03,
  2.257020674034550e-06,  3.299955022224046e-08, -8.162499848505641e-11, -4.222514924920804e-13,  2.354101919513966e-15,  4.103344199752618e-18, -6.047569053443071e-20,
  3.330036062957657e-23,  1.370354088235316e-24, -3.881438809325575e-27,  1.109018146415689e+00, -3.863638831783406e-03,  2.707016009085354e-07,  3.866779164397355e-08,
 -3.946271499746230e-11, -6.614435293615961e-13,  1.622071339317094e-15,  1.255912955141149e-17, -5.590652506365560e-20, -2.303055911182908e-22,  1.771408476978553e-24,
  3.358016213679127e-27,  1.207786039421230e+00, -3.882220351760805e-03, -2.037636562034055e-06,  4.147760088097342e-08,  2.313791380953121e-11, -8.173356792522466e-13,
 -1.115194944852630e-16,  1.952563303610254e-17, -9.261516314652007e-21, -5.119582724207343e-22,  6.000442508544465e-25,  1.403207116729620e-26,  1.308164843427097e+00,
 -3.818262266212061e-03, -4.557755578929111e-06,  3.998696294192850e-08,  1.002408677965602e-10, -7.884576130586614e-13, -2.649824133247529e-15,  1.923779543421498e-17,
  7.727847100641546e-20, -5.260480837222634e-22, -2.410964051987605e-24,  1.534675393628440e-26,  1.409086055079687e+00, -3.659331788780766e-03, -7.104816955141164e-06,
  3.292100909887697e-08,  1.773572411286414e-10, -4.847943222958522e-13, -5.110350688004828e-15,  6.341850738224335e-18,  1.563617306023980e-19,  1.448146694249805e-23,
 -4.908571607245578e-24, -7.024311402808817e-27,  1.509179481754571e+00, -3.395815509361114e-03, -9.407731655903981e-06,  1.970712381357088e-08,  2.306678324503678e-10,
  1.033729897138522e-13, -5.905204972635982e-15, -1.778488830893422e-17,  1.372962614934393e-19,  9.229874596186234e-22, -2.251639532111278e-24, -3.774720467151247e-26,
  1.606712955732932e+00, -3.023972529434535e-03, -1.111524611927881e-05,  1.240358890425045e-09,  2.315070794126220e-10,  8.178929383215885e-13, -3.488328879564280e-15,
 -3.840675469116405e-17, -3.402029822107417e-20,  1.182253686733919e-21,  5.859842248619503e-24, -2.006359349253025e-26,  1.699541659159502e+00, -2.550190989993186e-03,
 -1.183930452777954e-05, -1.934549097331181e-08,  1.598805278168392e-10,  1.301027447987140e-12,  1.898646133649578e-15, -3.206949803010762e-17, -2.352806664582939e-19,
 -1.137930299260664e-22,  8.152244206216725e-24,  4.918855850876680e-26,  1.785089168484996e+00, -1.996082807076609e-03, -1.125786438801876e-05, -3.652585098790053e-08,
  2.611615875066566e-11,  1.153293414211558e-12,  6.725902696737041e-15,  6.516004127752004e-18, -1.941954148503278e-19, -1.588540883813177e-21, -3.665595417950595e-24,
  3.710474440760606e-26,  1.860394807901458e+00, -1.403032821024186e-03, -9.283175809805474e-06, -4.384392709522746e-08, -1.138285797257642e-10,  3.297009649946520e-13,
  6.141027282223374e-15,  3.878248978826340e-17,  1.013148847999381e-19, -6.051864081790969e-22, -9.143793461224827e-24, -5.486706594606843e-26,  1.922270068060189e+00,
 -8.333583325340533e-04, -6.248700337945240e-06, -3.755568787293833e-08, -1.786516561955782e-10, -5.626152228251897e-13,  3.119910880532044e-16,  2.160284440206914e-17,
  1.961933931959493e-19,  1.115823175031902e-21,  3.516766623407191e-24, -8.903349460438984e-27,  1.967597098180501e+00, -3.642481133825821e-04, -2.985099439086055e-06,
 -2.091880120250338e-08, -1.303658145052591e-10, -7.236120547027866e-13, -3.471496035124562e-15, -1.298035154905576e-17, -2.069830221236702e-20,  2.311134757769689e-22,
  3.249489784393400e-24,  2.700377599413617e-26,  1.993763939409415e+00, -7.204595061935013e-05, -6.209733061377555e-07, -4.724616717865520e-09, -3.340835631917254e-11,
 -2.243894950665080e-13, -1.446578938795898e-15, -8.994888377443630e-18, -5.402705782749686e-20, -3.130881761334000e-22, -1.743352852124954e-24, -9.251143443964018e-27,
  5.959111694490865e-04, -3.273912013976836e-06,  1.348615885187916e-08, -4.937474671744354e-11,  1.693726904734110e-13, -5.577745621548011e-16,  1.783556915423400e-18,
 -5.592162478869961e-21,  1.719650074159741e-23, -5.251578739013948e-26,  1.565959215198686e-28, -4.757696145235417e-31,  5.363525391756903e-03, -2.943451429747465e-05,
  1.209294960421789e-07, -4.406344658734102e-10,  1.500221015244689e-12, -4.887038100563043e-15,  1.539484624918530e-17, -4.732817668258259e-20,  1.418696086755211e-22,
 -4.198326055348375e-25,  1.201538231830717e-27, -3.491059629269690e-30,  1.490046533810972e-02, -8.159113976594894e-05,  3.334307335770418e-07, -1.203221116374603e-09,
  4.033875299321654e-12, -1.284534051477555e-14,  3.918990108839771e-17, -1.153494124268824e-19,  3.259082641107775e-22, -8.925971021424010e-25,  2.286865519000873e-27,
 -5.815614451709340e-30,  2.921005131524780e-02, -1.594103827073084e-04,  6.461848455194154e-07, -2.297296490654152e-09,  7.517525841917005e-12, -2.307466976294178e-14,
  6.668550561580885e-17, -1.813999636377992e-19,  4.550821617806256e-22, -1.038636509743720e-24,  1.875389649325199e-27, -2.313114023637149e-30,  4.829700092597183e-02,
 -2.623813783808799e-04,  1.051899143771061e-06, -3.663197134599183e-09,  1.158046218759910e-11, -3.364605154208237e-14,  8.908802641853099e-17, -2.095960585563815e-19,
  3.973591379232625e-22, -4.229943517580768e-25, -1.278989591493832e-27,  9.838379769181909e-30,  7.216709609035502e-02, -3.898025067980969e-04,  1.540691890655838e-06,
 -5.221620937664501e-09,  1.574517918696910e-11, -4.219454497654666e-14,  9.641229019532840e-17, -1.638750117348081e-19,  4.526637894942869e-23,  1.180318232387535e-24,
 -7.190118577999053e-27,  2.743642633963534e-29,  1.008267085070894e-01, -5.407630042459724e-04,  2.099958890484126e-06, -6.874007630113838e-09,  1.944372999507037e-11,
 -4.610773200933596e-14,  7.896610514267030e-17, -1.724508219371483e-20, -6.362240309168743e-22,  3.580707065373830e-24, -1.391304884626105e-26,  3.952903308679857e-29,
  1.342821546015373e-01, -7.141188932337507e-04,  2.714210573109444e-06, -8.503243681586296e-09,  2.204073010975758e-11, -4.277397703509440e-14,  2.917293981197913e-17,
  2.379469922070999e-19, -1.564706511488931e-21,  6.032022297056017e-24, -1.742524004180473e-26,  2.962461273298272e-29,  1.725388400466696e-01, -9.084624673299287e-04,
  3.364884145436380e-06, -9.974878312861478e-09,  2.286485038859324e-11, -2.989659142527265e-14, -5.633212405893177e-17,  5.799653405172129e-19, -2.509833694120955e-21,
  7.239409135840149e-24, -1.249788647738591e-26, -1.691949320687885e-29,  2.156001400348821e-01, -1.122084380219975e-03,  4.030138742886525e-06, -1.113911167272475e-08,
  2.125109054929044e-11, -5.877948333162280e-15, -1.744620578935348e-16,  9.497072878693690e-19, -3.092179805698195e-21,  5.592286004449782e-24,  5.197031088783051e-27,
 -1.007948005053651e-28,  2.634659435102724e-01, -1.352927193256710e-03,  4.684646821463575e-06, -1.183391441929253e-08,  1.659654751008385e-11,  2.972782480469094e-14,
 -3.135239437549613e-16,  1.247453996746424e-18, -2.828983085412715e-21, -3.133741007762053e-25,  3.583385723353859e-26, -1.953122462735076e-28,  3.161307660690211e-01,
 -1.598529046109588e-03,  5.299403260198268e-06, -1.188976614258692e-08,  8.432674724659028e-12,  7.570585642216417e-14, -4.515350226281829e-16,  1.337927833456726e-18,
 -1.244447595346933e-21, -1.085433419475621e-23,  7.173505499538016e-26, -2.390203439577609e-28,  3.735813052382051e-01, -1.855955958925482e-03,  5.841586206062707e-06,
 -1.113666367831273e-08, -3.483046358154798e-12,  1.286471658254483e-13, -5.556080536349018e-16,  1.068095439402745e-18,  1.943187821666378e-21, -2.436529318429501e-23,
  9.484798683896359e-26, -1.457663357318821e-28,  4.357932707412667e-01, -2.121721205570381e-03,  6.274522626692881e-06, -9.414251172378781e-09, -1.905392919951451e-11,
  1.824558284361956e-13, -5.832868308041006e-16,  3.025096559279118e-19,  6.561971086580977e-21, -3.623055052886918e-23,  7.813073842242203e-26,  1.551074698827006e-28,
  5.027272677082247e-01, -2.391690314389995e-03,  6.557839722712303e-06, -6.586153752796014e-09, -3.770957883470821e-11,  2.280138915193116e-13, -4.870361302031565e-16,
 -1.020068588769391e-18,  1.169289288667853e-20, -3.866922356802777e-23, -5.579955395490489e-27,  6.425779520963148e-28,  5.743234381234339e-01, -2.660970729679415e-03,
  6.647924737502677e-06, -2.559825625400133e-09, -5.825512087692331e-11,  2.531994442108112e-13, -2.233688557179924e-16, -2.809110059981960e-18,  1.544356720542886e-20,
 -2.212926108899552e-23, -1.642190529113340e-25,  1.109004693939621e-27,  6.504944695067767e-01, -2.923786305539072e-03,  6.498875394719814e-06,  2.686624997676421e-09,
 -7.871855823093308e-11,  2.435613410401159e-13,  2.318897549810061e-16, -4.733867632935442e-18,  1.498244355586962e-20,  2.061024910809639e-23, -3.577674007396194e-25,
  1.110285854789317e-27,  7.311164532325891e-01, -3.173339117890868e-03,  6.064207112730739e-06,  9.069263861865662e-09, -9.622719761731114e-11,  1.840856033113503e-13,
  8.614010462547815e-16, -6.152847810789944e-18,  7.135826576373818e-21,  8.693849594967971e-23, -4.717962936612001e-25,  8.858165362541900e-29,  8.160169109922654e-01,
 -3.401665429313317e-03,  5.299696483390102e-06,  1.635411007949270e-08, -1.069714718146088e-10,  6.260825988459993e-14,  1.578633673259483e-15, -6.120611036171386e-18,
 -1.009165749137510e-20,  1.546619027882587e-22, -3.234862730375116e-25, -2.174086085856806e-27,  9.049591014036318e-01, -3.599500430151333e-03,  4.167883353182583e-06,
  2.410503408431172e-08, -1.063563152905485e-10, -1.245631848470878e-13,  2.201308605363542e-15, -3.570866270268899e-18, -3.487631972230432e-20,  1.754961827266937e-22,
  2.496225848682087e-25, -4.751225678596073e-27,  9.976214710732008e-01, -3.756179834824259e-03,  2.644910631891870e-06,  3.162909490394534e-08, -8.949686160902865e-11,
 -3.645915255963522e-13,  2.442156056219275e-15,  2.197527474294179e-18, -5.833449929072967e-20,  8.436217487512908e-23,  1.175138001978587e-24, -4.924366840698019e-27,
  1.093570844605136e+00, -3.859628889909186e-03,  7.304972966247589e-07,  3.793278825294237e-08, -5.227487984633929e-11, -6.185032733208941e-13,  1.947533380636667e-15,
  1.065138400056796e-17, -6.289334741241068e-20, -1.572451635511202e-22,  1.863133783798185e-24,  8.239884718921752e-28,  1.192227715373811e+00, -3.896525468277599e-03,
 -1.538223518365214e-06,  4.171707343709966e-08,  6.808475034457726e-12, -8.135018588003874e-13,  4.283182458902643e-16,  1.894019010013392e-17, -2.711528736466111e-20,
 -4.760717989507492e-22,  1.181167101567679e-24,  1.223494804126313e-26,  1.292821946167447e+00, -3.852778891082247e-03, -4.068819963185042e-06,  4.146139617879231e-08,
  8.388075667394614e-11, -8.453281840781468e-13, -2.079516818980874e-15,  2.139047332805566e-17,  5.677696267529730e-20, -6.079695895173392e-22, -1.662423434050068e-24,
  1.845702163221039e-26,  1.394337619929503e+00, -3.714542654656787e-03, -6.693079911742169e-06,  3.567456450752394e-08,  1.664521729920331e-10, -6.047473585604197e-13,
 -4.862923455734026e-15,  1.131540170209249e-17,  1.532947094106147e-19, -1.858007273561431e-22, -5.048587461784819e-24,  7.832213655257585e-28,  1.495447282471648e+00,
 -3.470068572719782e-03, -9.149059215912730e-06,  2.340648843010825e-08,  2.312804004793565e-10, -4.380118860866845e-14, -6.336820689489365e-15, -1.288040355540282e-17,
  1.685018750752411e-19,  7.997001259018023e-22, -3.906576686970069e-24, -3.689648082420016e-26,  1.594439406442888e+00, -3.112770779414729e-03, -1.107761306156586e-05,
  5.070418923919149e-09,  2.469401695779667e-10,  7.211862545954426e-13, -4.572249484869098e-15, -3.877117189303592e-17,  1.250801244920048e-20,  1.394682744998083e-21,
  4.654089077675010e-24, -3.480060062607839e-26,  1.689150060089492e+00, -2.645788530209522e-03, -1.205523606189019e-05, -1.657708293560720e-08,  1.862796137688925e-10,
  1.334967397642512e-12,  8.951515422548414e-16, -3.959691445961035e-17, -2.329954845021114e-19,  2.544551873124772e-22,  1.022114833730393e-23,  4.381056832941512e-26,
  1.776921947873701e+00, -2.087890049190880e-03, -1.169287772718104e-05, -3.591464621169801e-08,  5.080716521287154e-11,  1.316148478451084e-12,  6.812572596094233e-15,
 -6.379920255993040e-19, -2.535733617651959e-19, -1.696394213453996e-21, -1.570054167230692e-24,  5.863927877064845e-26,  1.854630770684294e+00, -1.479433142345825e-03,
 -9.819985912203315e-06, -4.560404879994409e-08, -1.056709568166694e-10,  4.904601179234198e-13,  7.268519795162344e-15,  4.160059154530827e-17,  7.235177356820726e-20,
 -1.020374063044486e-21, -1.163597713434536e-23, -5.762279578263284e-26,  1.918833731567289e+00, -8.852000529633950e-04, -6.716888565897058e-06, -4.050350706401013e-08,
 -1.897762601098662e-10, -5.471213811279805e-13,  1.010992294086558e-15,  2.854991725058995e-17,  2.387678192615661e-19,  1.244970549878097e-21,  2.839179824529970e-24,
 -2.285431485637484e-26,  1.966090702758660e+00, -3.891696007739755e-04, -3.249132759916846e-06, -2.312508380593070e-08, -1.457010048118593e-10, -8.113555577021409e-13,
 -3.842774861133505e-15, -1.348201062806067e-17, -9.728440502540891e-21,  3.875037955695238e-22,  4.639907406001732e-24,  3.660544058728970e-26,  1.993465447668709e+00,
 -7.724995951116596e-05, -6.810303591119864e-07, -5.297028361501578e-09, -3.826478124267557e-11, -2.623359501353128e-13, -1.724435132618657e-15, -1.091838849213384e-17,
 -6.665776782261959e-20, -3.916545803262942e-22, -2.203089732184812e-24, -1.174120157427544e-26,  5.830276113941087e-04, -3.168347494599313e-06,  1.290956092927047e-08,
 -4.675175398220255e-11,  1.586328839750057e-13, -5.167876848875857e-16,  1.634404570246702e-18, -5.070954467582247e-21,  1.541380396118974e-23, -4.665237230856488e-26,
  1.370079938184127e-28, -4.162776521850000e-31,  5.247689284737129e-03, -2.848782802345581e-05,  1.157827420425792e-07, -4.173932223564998e-10,  1.406070269210101e-12,
 -4.532964698419513e-15,  1.413100718248021e-17, -4.302118979629499e-20,  1.275848688422156e-22, -3.747183655279380e-25,  1.057139589630282e-27, -3.083756739240225e-30,
  1.457934574965605e-02, -7.898037049510498e-05,  3.193710168724373e-07, -1.140684339735066e-09,  3.786118419657530e-12, -1.194239087931709e-14,  3.610141672500224e-17,
 -1.054173201602201e-19,  2.953611056068810e-22, -8.060806992331800e-25,  2.042758378893473e-27, -5.293417718014030e-30,  2.858257698860323e-02, -1.543491639246689e-04,
  6.193240178616600e-07, -2.180622764205473e-09,  7.071633912723041e-12, -2.153355647546811e-14,  6.180466438116486e-17, -1.674213160093973e-19,  4.190161153673762e-22,
 -9.657526365374156e-25,  1.766540197683281e-27, -2.624626165005174e-30,  4.726403177617601e-02, -2.541389192045037e-04,  1.009030667049503e-06, -3.483178906745263e-09,
  1.092845428415612e-11, -3.157694073637277e-14,  8.339499873056510e-17, -1.971332796126311e-19,  3.813084869261533e-22, -4.661841491774132e-25, -8.969264974831976e-28,
  7.581533976064021e-30,  7.063214625283228e-02, -3.777233901157544e-04,  1.479516531197074e-06, -4.976325032904305e-09,  1.492405657406208e-11, -3.993551099800524e-14,
  9.185007462771214e-17, -1.617998501824593e-19,  8.285983956998806e-23,  9.155412807260063e-25, -6.080457536069974e-27,  2.307845859733097e-29,  9.869674078260737e-02,
 -5.242880662095159e-04,  2.019307298907026e-06, -6.570182419588135e-09,  1.854047671023675e-11, -4.422052506834065e-14,  7.821684679831289e-17, -3.564585072156988e-20,
 -5.169289848678700e-22,  3.057634101045127e-24, -1.227354421608237e-26,  3.500569384050814e-29,  1.314684685294981e-01, -6.928074340254516e-04,  2.614259457372545e-06,
 -8.157395628657534e-09,  2.119276333129730e-11, -4.199933836615477e-14,  3.516616806221990e-17,  1.912188548023222e-19, -1.359785934599949e-21,  5.361045241069262e-24,
 -1.612653815635911e-26,  2.922622027152002e-29,  1.689580789525464e-01, -8.820160149794552e-04,  3.247360676321774e-06, -9.613892257321644e-09,  2.225466831715021e-11,
 -3.106253227757805e-14, -4.117901580669959e-17,  5.037227936256255e-19, -2.258367003685721e-21,  6.727404242825228e-24, -1.303808454559991e-26, -8.088985681443347e-30,
  2.111754463082326e-01, -1.090372177708989e-03,  3.898504915357678e-06, -1.080025335174963e-08,  2.109375763214266e-11, -9.756930147620211e-15, -1.492250472720656e-16,
  8.540105144371721e-19, -2.888127385984291e-21,  5.717684676836824e-24,  1.220022002133649e-27, -8.059268157752972e-29,  2.581282961382669e-01, -1.316013489727873e-03,
  4.544251445037896e-06, -1.156401035070501e-08,  1.711863460777480e-11,  2.261216415334457e-14, -2.798624350359252e-16,  1.157006324911979e-18, -2.816465098103018e-21,
  9.557829245792109e-25,  2.781023520404745e-26, -1.697518287754768e-28,  3.098205400996387e-01, -1.556702123804932e-03,  5.157583696439678e-06, -1.174330655995371e-08,
  9.841433150084807e-12,  6.531371794391801e-14, -4.146854693101015e-16,  1.292386844299116e-18, -1.586057173899881e-21, -8.191725574329304e-24,  6.148965570808088e-26,
 -2.261073698658914e-28,  3.662500993098124e-01, -1.809758585634608e-03,  5.707694457779076e-06, -1.117252310185359e-08, -1.040993564764764e-12,  1.156776945437340e-13,
 -5.249575531179599e-16,  1.116962170175531e-18,  1.132699218289537e-21, -2.070857375774482e-23,  8.778941988175363e-26, -1.730750029251469e-28,  4.274060558406504e-01,
 -2.071981818874622e-03,  6.159840401327664e-06, -9.690678421481161e-09, -1.554399778281799e-11,  1.685811325194173e-13, -5.720685078674316e-16,  4.922387559677359e-19,
  5.315313674658479e-21, -3.299673541817758e-23,  8.290221549505474e-26,  6.476673369176428e-29,  4.932649173097517e-01, -2.339553646584109e-03,  6.475334165299622e-06,
 -7.153668853459842e-09, -3.326829013407725e-11,  2.160232763377240e-13, -5.105689120195852e-16, -6.681598430108674e-19,  1.030320560031417e-20, -3.836981445373231e-23,
  1.950836932656619e-26,  4.995614197254776e-28,  5.637857055886731e-01, -2.607925665960240e-03,  6.611780435843402e-06, -3.451712669229673e-09, -5.325082625155385e-11,
  2.469497955260341e-13, -2.952334783190548e-16, -2.328836664454554e-18,  1.454013365825283e-20, -2.775561224522321e-23, -1.179660653416224e-25,  9.900612326235131e-28,
  6.389034807368130e-01, -2.871687383871211e-03,  6.523719522315418e-06,  1.466356180895805e-09, -7.380213173148834e-11,  2.475908813761585e-13,  1.061460075530643e-16,
 -4.245222951400922e-18,  1.547879934614974e-20,  7.298201768394964e-24, -3.074278617717538e-25,  1.166389015066008e-27,  7.185207767653872e-01, -3.124416023302296e-03,
  6.163925444305971e-06,  7.560147588359726e-09, -9.235255880584141e-11,  2.027204367344567e-13,  6.927627818750601e-16, -5.878052063004797e-18,  9.927971040899640e-21,
  6.826540727703665e-23, -4.590447197711411e-25,  4.748297482111108e-28,  8.024962463960257e-01, -3.358511848155700e-03,  5.485724372002156e-06,  1.465458353058466e-08,
 -1.053544831820418e-10,  9.840750228236385e-14,  1.403553703478816e-15, -6.357131047615137e-18, -4.777939619340154e-21,  1.400124607801588e-22, -4.040074369187327e-25,
 -1.491176339169560e-27,  8.906295767320940e-01, -3.565029421471866e-03,  4.446860544369071e-06,  2.238623724830655e-08, -1.083279904245194e-10, -7.305180553888112e-14,
  2.086660952403022e-15, -4.584296789695394e-18, -2.842791824320318e-20,  1.814336889574113e-22,  5.089584178430158e-26, -4.252112702262657e-27,  9.826414390439616e-01,
 -3.733527229760680e-03,  3.015637805396169e-06,  3.014201221009296e-08, -9.619866777534812e-11, -3.054492287413998e-13,  2.478071695951757e-15,  3.880509138893033e-19,
 -5.450559109597686e-20,  1.268192177477422e-22,  9.431384404692074e-25, -5.552847706024961e-27,  1.078146878602496e+00, -3.851979279606246e-03,  1.180272648493641e-06,
  3.700006648285491e-08, -6.415457563331238e-11, -5.684157449107213e-13,  2.216847647741552e-15,  8.562634910181594e-18, -6.721051239110682e-20, -8.270891868141698e-23,
  1.846439929154395e-24, -1.540291855834455e-27,  1.176620173411838e+00, -3.906828217001114e-03, -1.037499637537256e-06,  4.169658561442892e-08, -9.316382073164684e-12,
 -7.969718506309525e-13,  9.439903267869044e-16,  1.780841360057935e-17, -4.328007212276689e-20, -4.187689364592571e-22,  1.665162295221031e-24,  9.656051605795244e-27,
  1.277348911045046e+00, -3.883317789696748e-03, -3.563796792152374e-06,  4.266573115399580e-08,  6.652459623641610e-11, -8.878647254900493e-13, -1.458519927940818e-15,
  2.284593819174888e-17,  3.389447890209677e-20, -6.576257633905534e-22, -8.083498975849612e-25,  2.010727478323517e-26,  1.379375133953714e+00, -3.766330599702984e-03,
 -6.249425085146859e-06,  3.823481604840440e-08,  1.532186210054123e-10, -7.171088024612761e-13, -4.478698509312619e-15,  1.607504726838149e-17,  1.430010872142752e-19,
 -3.846505974769802e-22, -4.834348978605668e-24,  8.947148020357627e-27,  1.481422490782017e+00, -3.542074747559967e-03, -8.846034419755853e-06,  2.709159210350740e-08,
  2.288575846547002e-10, -1.995779525940307e-13, -6.617888304279616e-15, -7.060992629929791e-18,  1.940962082593310e-19,  6.120215311911852e-22, -5.444629810229147e-24,
 -3.240429074750599e-26,  1.581811563087342e+00, -3.201080080432847e-03, -1.099260611368908e-05,  9.130521542865542e-09,  2.601790568186862e-10,  5.985179805355377e-13,
 -5.644453140642351e-15, -3.753490161043429e-17,  6.565936968336293e-20,  1.545939283471427e-21,  2.805034498692675e-24, -4.900801019237850e-26,  1.678372836547206e+00,
 -2.742973415829047e-03, -1.223539442078317e-05, -1.338223903763639e-08,  2.130996845541939e-10,  1.342315335276289e-12, -3.159833592947122e-16, -4.682369992902685e-17,
 -2.160383618395072e-19,  6.987807064342898e-22,  1.190602318982568e-23,  3.156617418751787e-26,  1.768380594340288e+00, -2.183141096315426e-03, -1.211807861744938e-05,
 -3.488228751310556e-08,  7.875872585011689e-11,  1.478462204445895e-12,  6.671871888640846e-15, -9.736127956031950e-18, -3.150898725619568e-19, -1.700731928859625e-21,
  1.525050117538009e-24,  8.219567212069375e-26,  1.848552412917829e+00, -1.560209957424107e-03, -1.037702341132026e-05, -4.720643206296383e-08, -9.402176357912558e-11,
  6.791067398968960e-13,  8.459558598433661e-15,  4.323334230272770e-17,  2.663277870847287e-20, -1.536043229730843e-21, -1.412207786346752e-23, -5.408038893025836e-26,
  1.915182308913841e+00, -9.409317706174292e-04, -7.221505220110247e-06, -4.362586044667885e-08, -2.004066578613340e-10, -5.123592676387423e-13,  1.924239054845697e-15,
  3.692722155589199e-17,  2.853392739615364e-19,  1.332904559037705e-21,  1.407772625125054e-24, -4.344102673035962e-26,  1.964480223108105e+00, -4.163135640049102e-04,
 -3.541173140429811e-06, -2.559125655391412e-08, -1.628810813133072e-10, -9.081330357365379e-13, -4.222257724062256e-15, -1.353094799479269e-17,  7.981259514281106e-21,
  6.087206401295683e-22,  6.510362700440324e-24,  4.888915938637007e-26,  1.993145133532312e+00, -8.296328166022865e-05, -7.484488390152088e-07, -5.953595729384412e-09,
 -4.395143086494428e-11, -3.076456683651467e-13, -2.062259685832803e-15, -1.329509958651928e-17, -8.247589656586440e-20, -4.909805637651237e-22, -2.785973934299611e-24,
 -1.486872410048516e-26,  5.705572811538170e-04, -3.067272715118128e-06,  1.236343433266414e-08, -4.429422989686053e-11,  1.486781680521999e-13, -4.792115944866616e-16,
  1.499078084695531e-18, -4.603561701703874e-21,  1.382869085632822e-23, -4.152305118918480e-26,  1.198205692418629e-28, -3.664932947428594e-31,  5.135559305626376e-03,
 -2.758122528306370e-05,  1.109060729533897e-07, -3.956033469859017e-10,  1.318707177361143e-12, -4.207826478231415e-15,  1.298160059291170e-17, -3.914640967018863e-20,
  1.148244139299389e-22, -3.350413124890704e-25,  9.292010008031625e-28, -2.742114392449751e-30,  1.426844894225199e-02, -7.647914323571113e-05,  3.060385399817097e-07,
 -1.081971136009646e-09,  3.555701263545765e-12, -1.111033533251111e-14,  3.327780086246338e-17, -9.641474451217462e-20,  2.677580999303084e-22, -7.288930522008399e-25,
  1.819824197500653e-27, -4.854159623775261e-30,  2.797492646286449e-02, -1.494973504052337e-04,  5.938214661722140e-07, -2.070842964353711e-09,  6.655423887129275e-12,
 -2.010501457312690e-14,  5.729945599713827e-17, -1.545556669536552e-19,  3.854923512093069e-22, -8.974823747817495e-25,  1.644987943218780e-27, -2.897907881558434e-30,
  4.626336000255888e-02, -2.462309412157110e-04,  9.682611581908747e-07, -3.313269053741558e-09,  1.031649023008265e-11, -2.964033447652458e-14,  7.804352434872222e-17,
 -1.852062381218046e-19,  3.639549717297280e-22, -4.959893483452618e-25, -6.077546436040196e-28,  5.599901800357472e-30,  6.914455240794380e-02, -3.661221220558161e-04,
  1.421207366575846e-06, -4.743811571551797e-09,  1.414702508171373e-11, -3.778514551125892e-14,  8.736143142279980e-17, -1.586660101345284e-19,  1.116752455435973e-22,
  6.914428772829645e-25, -5.153244557488708e-27,  1.912474500950955e-29,  9.663140513244559e-02, -5.084440001190966e-04,  1.942216139472168e-06, -6.280508453175013e-09,
  1.767474816644534e-11, -4.235706857154812e-14,  7.700306823448378e-17, -5.051819890870629e-20, -4.153319042113461e-22,  2.596180656482162e-24, -1.083162272438804e-26,
  3.054326494966944e-29,  1.287384550368868e-01, -6.722792124574010e-04,  2.518377648852960e-06, -7.824983718630348e-09,  2.036162545772523e-11, -4.109584384269795e-14,
  3.993925274505308e-17,  1.506716659793769e-19, -1.178092534047765e-21,  4.741355850702530e-24, -1.486822692393275e-26,  2.781429200993724e-29,  1.654812504907703e-01,
 -8.564925906681467e-04,  3.134109754936237e-06, -9.262836615497172e-09,  2.162463588319725e-11, -3.188952388652500e-14, -2.805083832520660e-17,  4.352288082015884e-19,
 -2.025634986889956e-21,  6.200776824304980e-24, -1.324787819238647e-26, -1.850510353649763e-30,  2.068755209356934e-01, -1.059696829100095e-03,  3.770919827736408e-06,
 -1.046450098319281e-08,  2.086468874814262e-11, -1.306163685406474e-14, -1.265756613097424e-16,  7.648866191072269e-19, -2.682219731883003e-21,  5.700696398888688e-24,
 -1.948872703626698e-27, -6.403736762883639e-29,  2.529360779536389e-01, -1.280209862342354e-03,  4.407140481297200e-06, -1.128684835937940e-08,  1.750628252440498e-11,
  1.627407461495980e-14, -2.487214134650546e-16,  1.067630480875603e-18, -2.763769515369235e-21,  1.925810571324208e-24,  2.085954536749919e-26, -1.466392191070372e-28,
  3.036753643579109e-01, -1.516002360254187e-03,  5.017650184086952e-06, -1.157592198751992e-08,  1.105108339341501e-11,  5.578951748247405e-14, -3.792502519366899e-16,
  1.237370083301345e-18, -1.839044354167870e-21, -5.926690561368287e-24,  5.187476226548743e-26, -2.106655486516712e-28,  3.591015387933816e-01, -1.764633422795797e-03,
  5.573598404245342e-06, -1.117134441383029e-08,  1.149122115345713e-12,  1.034574434036965e-13, -4.932824939708819e-16,  1.141942898751724e-18,  4.485117363568028e-22,
 -1.735486739720239e-23,  7.977540862779314e-26, -1.896624225509278e-28,  4.192159438828795e-01, -2.023172224774250e-03,  6.042168897219138e-06, -9.913150364062438e-09,
 -1.230846041822165e-11,  1.550350261174227e-13, -5.560785521071462e-16,  6.439668710149159e-19,  4.187598712887536e-21, -2.964635692290802e-23,  8.408439418868062e-26,
 -8.355147949910860e-30,  4.840097520436303e-01, -2.288103074340669e-03,  6.386436786122372e-06, -7.652069260133212e-09, -2.907168937964383e-11,  2.035811072048522e-13,
 -5.248678979211595e-16, -3.603670600621180e-19,  8.940874364685718e-21, -3.718936145245672e-23,  3.856043260752741e-26,  3.686247626444309e-28,  5.534595091249325e-01,
 -2.555211216150155e-03,  6.565409485964315e-06, -4.264620143155324e-09, -4.838770048114353e-11,  2.391333262956731e-13, -3.540831490311958e-16, -1.880367409807955e-18,
  1.346614368775247e-20, -3.164171535534385e-23, -7.731750594016820e-26,  8.558613652769364e-28,  6.275211943138015e-01, -2.819446939734975e-03,  6.534394542184895e-06,
  3.252356233679947e-10, -6.883417723082400e-11,  2.487681223891329e-13, -5.762573399041251e-18, -3.747970360587899e-18,  1.553258142708111e-20, -3.970408620398386e-24,
 -2.560547616038978e-25,  1.159444502353656e-27,  7.061222750004305e-01, -3.074766538830551e-03,  6.245917940155044e-06,  6.115789994675651e-09, -8.814502371345096e-11,
  2.174097627471192e-13,  5.329695062649771e-16, -5.524533439854854e-18,  1.206089762644357e-20,  5.041333141766796e-23, -4.314611450308283e-25,  7.629374067841283e-28,
  7.891510440974014e-01, -3.313951128420852e-03,  5.651536055564005e-06,  1.298642646187207e-08, -1.030639681630356e-10,  1.299440610052185e-13,  1.224148341514112e-15,
 -6.432613683859821e-18, -4.244004067029061e-23,  1.227311304389373e-22, -4.554402044198010e-25, -8.574583176467603e-28,  8.764422684465992e-01, -3.528409556526858e-03,
  4.705056380602260e-06,  2.064397670395602e-08, -1.092991307197844e-10, -2.460902136236935e-14,  1.946547588102476e-15, -5.389446711342018e-18, -2.190311235479062e-20,
  1.799092340169923e-22, -1.224131881207929e-25, -3.607133946272549e-27,  9.677578335967759e-01, -3.707981920053531e-03,  3.367915752375576e-06,  2.855719325939537e-08,
 -1.017130348333007e-10, -2.460377482735837e-13,  2.465254073351750e-15, -1.276283237325110e-18, -4.932083769338202e-20,  1.595631904314351e-22,  6.924030590104980e-25,
 -5.781098497304382e-27,  1.062760632101167e+00, -3.840779390095652e-03,  1.617749028738626e-06,  3.588561463644487e-08, -7.497269290160498e-11, -5.125796348346727e-13,
  2.426144167503210e-15,  6.378342063281488e-18, -6.888068978589404e-20, -1.083402750413996e-23,  1.732473393876997e-24, -3.574832759545223e-27,  1.160979424326603e+00,
 -3.913130514617915e-03, -5.385565407748857e-07,  4.142140551528596e-08, -2.498973811772382e-11, -7.685024072743721e-13,  1.421066265337579e-15,  1.619587415687825e-17,
 -5.706243976480740e-20, -3.445492246673189e-22,  2.023218963708791e-24,  6.557180112601340e-27,  1.261761885485077e+00, -3.909763475071596e-03, -3.046013209611207e-06,
  4.358638384408677e-08,  4.846961145004007e-11, -9.150924614108662e-13, -8.072424181600873e-16,  2.354726932218012e-17,  9.852573142127781e-21, -6.721326639738318e-22,
  8.339039602419040e-26,  2.016080095707345e-26,  1.364212783951597e+00, -3.814450180900890e-03, -5.776390074626101e-06,  4.056589851397689e-08,  1.378406288392520e-10,
 -8.186933665416600e-13, -3.966875359236833e-15,  2.039311254100668e-17,  1.257891049572365e-19, -5.678229092566156e-22, -4.268094036248988e-24,  1.664666805679770e-26,
  1.467114801612448e+00, -3.611480736940843e-03, -8.499124814531133e-06,  3.071269691112658e-08,  2.232654260499835e-10, -3.600591248402504e-13, -6.725643965152758e-15,
 -5.420883295123571e-19,  2.118841814658605e-19,  3.678508125381746e-22, -6.704971874818359e-24, -2.432123742012868e-26,  1.568832156033239e+00, -3.288511035431715e-03,
 -1.085769245064711e-05,  1.338143656654297e-08,  2.707110662505607e-10,  4.507288921889515e-13, -6.657519521999615e-15, -3.452612988450316e-17,  1.227789753343540e-19,
  1.611307178794265e-21,  3.775168711604078e-25, -6.076193435058299e-26,  1.667204244037132e+00, -2.841438920181645e-03, -1.237464037720574e-05, -9.758745159200424e-09,
  2.397600325828544e-10,  1.318244368898099e-12, -1.719380781505440e-15, -5.324010294525063e-17, -1.820221185316912e-19,  1.197539513711155e-21,  1.288823926094565e-23,
  1.184548753560747e-26,  1.759451522920024e+00, -2.281736349441493e-03, -1.252810156705511e-05, -3.337700773121452e-08,  1.099010113057440e-10,  1.634120456426193e-12,
  6.249022637400423e-15, -2.077936260630194e-17, -3.742835288767353e-19, -1.560498402699635e-21,  5.653645146403417e-24,  1.050637393037626e-25,  1.842141918374065e+00,
 -1.645516521413736e-03, -1.095204161450595e-05, -4.859067931690950e-08, -7.831101516378437e-11,  8.967037483905302e-13,  9.672907172930699e-15,  4.308732191768970e-17,
 -3.937962454635961e-20, -2.145450127514773e-21, -1.625228744852770e-23, -4.084140504429106e-26,  1.911299644222286e+00, -1.000853124951919e-03, -7.764583607273241e-06,
 -4.691146456653034e-08, -2.101027532419683e-10, -4.526935716789644e-13,  3.093300532210294e-15,  4.683250366976371e-17,  3.338065417169227e-19,  1.343148679349574e-21,
 -1.105456273426415e-24, -7.227983945589882e-26,  1.962756300734271e+00, -4.459170498666957e-04, -3.864522355617012e-06, -2.834828898230029e-08, -1.820875301002638e-10,
 -1.013962605219563e-12, -4.593870336593779e-15, -1.287020548124145e-17,  3.513960278956888e-20,  9.164312649574658e-22,  8.986433249714844e-24,  6.416615783704015e-26,
  1.992800835234299e+00, -8.924908550035856e-05, -8.243234414775958e-07, -6.708863268658236e-09, -5.063105336305516e-11, -3.619224209110322e-13, -2.474289926626582e-15,
 -1.623998428070783e-17, -1.023245407166365e-19, -6.165888104431235e-22, -3.522730886112111e-24, -1.875502790407006e-26,  5.584826950290085e-04, -2.970451638945577e-06,
  1.184586661286817e-08, -4.199014120895907e-11,  1.394435267121703e-13, -4.447318615576329e-16,  1.376155303832708e-18, -4.184066629326458e-21,  1.241636186457417e-23,
 -3.704008967360740e-26,  1.046248987248434e-28, -3.256573420912258e-31,  5.026979333894396e-03, -2.671261325947616e-05,  1.062827053467904e-07, -3.751607217215256e-10,
  1.237579547342731e-12, -3.909016946662661e-15,  1.193517901837234e-17, -3.565806951427803e-20,  1.034036708072838e-22, -3.001997044826164e-25,  8.149112677947800e-28,
 -2.463152517722447e-30,  1.396734809961635e-02, -7.408181898990966e-05,  2.933890389483306e-07, -1.026815075948546e-09,  3.341267463234049e-12, -1.034311900651097e-14,
  3.069429665214580e-17, -8.825268975658929e-20,  2.427777584857075e-22, -6.602623330500586e-25,  1.614245866886849e-27, -4.506485404598818e-30,  2.738628333663206e-02,
 -1.448443989442332e-04,  5.695972400556614e-07, -1.967499712670001e-09,  6.266732011882825e-12, -1.878039379903771e-14,  5.313982979322472e-17, -1.427244164596330e-19,
  3.543359156475848e-22, -8.343137878440159e-25,  1.511387612680069e-27, -3.180814710830122e-30,  4.529368051073434e-02, -2.386411271802028e-04,  9.294730748821055e-07,
 -3.152847634519509e-09,  9.742000669652204e-12, -2.782821978199110e-14,  7.301808639448440e-17, -1.738496113914953e-19,  3.457162080552680e-22, -5.159127970914141e-25,
 -4.015775095625933e-28,  3.791205994988760e-30,  6.770244806556573e-02, -3.549763747885854e-04,  1.365615168834602e-06, -4.523392377173970e-09,  1.341193124005504e-11,
 -3.574135750147600e-14,  8.297228131180093e-17, -1.547323342583092e-19,  1.330496341323334e-22,  5.010459544506615e-25, -4.393344985385134e-27,  1.545037459124920e-29,
  9.462823397459677e-02, -4.932029916104384e-04,  1.868519182076982e-06, -6.004389708358316e-09,  1.684596555017692e-11, -4.052738745553902e-14,  7.541595916919918e-17,
 -6.239448958859875e-20, -3.293562093389192e-22,  2.188484167356823e-24, -9.585674195714957e-27,  2.608275110914403e-29,  1.260890452676189e-01, -6.525023142434474e-04,
  2.426405609458905e-06, -7.505719605803730e-09,  1.954961436318961e-11, -4.009078240831712e-14,  4.365512949835303e-17,  1.155913011604839e-19, -1.017819424219632e-21,
  4.170484446113218e-24, -1.369226615812133e-26,  2.549051395924047e-29,  1.621047301482726e-01, -8.318584955749190e-04,  3.025010526032185e-06, -8.921977329276880e-09,
  2.098106331009094e-11, -3.242362921917674e-14, -1.673908724590610e-17,  3.738777847883229e-19, -1.811952894010003e-21,  5.670543265290901e-24, -1.323547568287010e-26,
  2.039937346428175e-30,  2.026962810190195e-01, -1.030026112220643e-03,  3.647339690203460e-06, -1.013291377013323e-08,  2.057476329217920e-11, -1.585196076978358e-14,
 -1.063297561997327e-16,  6.823188817760352e-19, -2.479039227365096e-21,  5.570476814386164e-24, -4.467223803505263e-27, -5.100974045720346e-29,  2.478849017039270e-01,
 -1.245489722825221e-03,  4.273388621737261e-06, -1.100445833485680e-08,  1.777444090589966e-11,  1.065356025480183e-14, -2.200544294048093e-16,  9.804479115282756e-19,
 -2.680919954864027e-21,  2.637306991660269e-24,  1.486189671682224e-26, -1.265163745142470e-28,  2.976907619012101e-01, -1.476413715497162e-03,  4.879835275264184e-06,
 -1.139066121502201e-08,  1.207862488401332e-11,  4.709643452834944e-14, -3.454571051464964e-16,  1.175489518162811e-18, -2.017245823373242e-21, -4.032309384387861e-24,
  4.296273698712161e-26, -1.944287440345651e-28,  3.521313342978841e-01, -1.720580394402192e-03,  5.439718815048598e-06, -1.113703761611775e-08,  3.102479122282189e-12,
  9.200342249937008e-14, -4.611967887466461e-16,  1.146898222604046e-18, -1.208648595748210e-22, -1.433378322980646e-23,  7.121610568574639e-26, -1.983135563621795e-28,
  4.112191718650556e-01, -1.975313821741564e-03,  5.922129472271248e-06, -1.008599886241588e-08, -9.339684074027566e-12,  1.419196931056596e-13, -5.363272631884371e-16,
  7.615410372341158e-19,  3.180615357802481e-21, -2.630843807284520e-23,  8.238871495858738e-26, -6.645357270275146e-29,  4.749589304164102e-01, -2.237386481893810e-03,
  6.291953211301073e-06, -8.085330605562732e-09, -2.512669096480571e-11,  1.908942988461112e-13, -5.311516371623942e-16, -9.535288564931297e-20,  7.633404634006427e-21,
 -3.535806291364794e-23,  5.215110197237018e-26,  2.514548515550971e-28,  5.433433685954396e-01, -2.502905443086343e-03,  6.509745110515370e-06, -5.001040781791680e-09,
 -4.369403146738358e-11,  2.300511487529907e-13, -4.008756901157867e-16, -1.468202133737684e-18,  1.228007404091440e-20, -3.402248401727347e-23, -4.274784253246165e-26,
  7.149640435624058e-28,  6.163479556513786e-01, -2.767174517078103e-03,  6.531853356206086e-06, -7.363504996946135e-10, -6.386840873446448e-11,  2.474264681135341e-13,
 -1.037821537559736e-16, -3.255092414457475e-18,  1.521746442167181e-20, -1.320585063443553e-23, -2.061335592617176e-25,  1.102490070314116e-27,  6.939235749255637e-01,
 -3.024529278115713e-03,  6.310991097750472e-06,  4.740898380931837e-09, -8.368121333689845e-11,  2.283899594294578e-13,  3.839353412442402e-16, -5.112807917699261e-18,
  1.357380704017199e-20,  3.388990732863502e-23, -3.933003175120248e-25,  9.566213700803019e-28,  7.759866118255559e-01, -3.268143317323417e-03,  5.797569798825470e-06,
  1.135972912025452e-08, -1.001858644408248e-10,  1.571660647276217e-13,  1.044654922015797e-15, -6.366858131786219e-18,  4.040430576911350e-21,  1.039290054609277e-22,
 -4.806142748241628e-25, -3.014427073154031e-28,  8.624054380650846e-01, -3.489807945138616e-03,  4.942283221309535e-06,  1.889373881086504e-08, -1.093367470682714e-10,
  2.022400825903828e-14,  1.786795680061587e-15, -5.987961600994289e-18, -1.555086684792234e-20,  1.720479710114433e-22, -2.653696745189188e-25, -2.883129911855109e-27,
  9.529819233906429e-01, -3.679695867868408e-03,  3.700685607692900e-06,  2.689361806457017e-08, -1.060459219597461e-10, -1.874733393283865e-13,  2.408321192619925e-15,
 -2.757793489442297e-18, -4.313925403257714e-20,  1.821856329120248e-22,  4.396536866858807e-25, -5.653850768382297e-27,  1.047426096041471e+00, -3.826136039219150e-03,
  2.040851126456831e-06,  3.460725874116952e-08, -8.462883197465444e-11, -4.524580148542936e-13,  2.573913983632369e-15,  4.180955820846700e-18, -6.806588788976181e-20,
  5.481541058264365e-23,  1.538388120601261e-24, -5.168018448557550e-27,  1.145321422270241e+00, -3.915458692022622e-03, -4.439948641407388e-08,  4.090061272192456e-08,
 -3.998311105936371e-11, -7.291722307288630e-13,  1.847236409912415e-15,  1.418754127934212e-17, -6.794880284629653e-20, -2.588229234760809e-22,  2.238828245274563e-24,
  3.229809836145192e-27,  1.246077424709839e+00, -3.932027647254606e-03, -2.518930278168690e-06,  4.421465471455724e-08,  3.002751871895675e-11, -9.265410622045881e-13,
 -1.471279521678275e-16,  2.347776420939429e-17, -1.407323182097306e-20, -6.513906174469209e-22,  9.427118260056324e-25,  1.865369854540158e-26,  1.348865695244106e+00,
 -3.858677922743247e-03, -5.276923136178708e-06,  4.263538690389527e-08,  1.205632294272765e-10, -9.066114642832516e-13, -3.342813760080559e-15,  2.405990334377708e-17,
  1.024694765049151e-19, -7.218871057007751e-22, -3.388187297487558e-24,  2.307904755781018e-26,  1.452535311773242e+00, -3.677939402048147e-03, -8.109404999452779e-06,
  3.421857279002414e-08,  2.144528642639184e-10, -5.208802114454339e-13, -6.644287798881727e-15,  6.396412679485745e-18,  2.200690536373556e-19,  8.133360013276503e-23,
 -7.539670092385336e-24, -1.318610675260901e-26,  1.555505510584794e+00, -3.374656005563283e-03, -1.067085846714956e-05,  1.777592882899168e-08,  2.780520560392027e-10,
  2.798451830369732e-13, -7.560536083559968e-15, -2.967156367382907e-17,  1.803897653206112e-19,  1.570400050856306e-21, -2.476269095348572e-24, -6.806488600824997e-26,
  1.655639847133880e+00, -2.940837261635777e-03, -1.246786698957270e-05, -5.714425753577111e-09,  2.655883004438579e-10,  1.258475773093507e-12, -3.284455336440009e-15,
 -5.827494534084094e-17, -1.295721472388737e-19,  1.716084729719779e-21,  1.284385116447215e-23, -1.492341831526825e-26,  1.750121636786735e+00, -2.383530829552413e-03,
 -1.291697084791648e-05, -3.134920636832967e-08,  1.440288498124705e-10,  1.775711607268550e-12,  5.491441369767273e-15, -3.360223524035274e-17, -4.252226340749789e-19,
 -1.236040993593358e-21,  1.070237012694172e-23,  1.232629495198917e-25,  1.835380898562210e+00, -1.735485060571793e-03, -1.154201382839523e-05, -4.968716281805680e-08,
 -5.795877579513831e-11,  1.143112531850616e-12,  1.084918591402328e-14,  4.046279584054925e-17, -1.286909538319365e-19, -2.824727331379729e-21, -1.751750217973933e-23,
 -1.413821996939288e-26,  1.907168351562618e+00, -1.065279351642300e-03, -8.347975486314599e-06, -5.034103779653271e-08, -2.183015902996344e-10, -3.614673851751854e-13,
  4.561325188475446e-15,  5.827259291343309e-17,  3.805025408248971e-19,  1.224755300333243e-21, -5.093420377034975e-24, -1.106200012806345e-25,  1.960908573703804e+00,
 -4.782450551309769e-04, -4.222871174495361e-06, -3.143003371010092e-08, -2.034977051728195e-10, -1.128379710697885e-12, -4.933005728265883e-15, -1.114267079618857e-17,
  7.532846949262527e-20,  1.337523656108916e-21,  1.220122405646935e-23,  8.242195173788271e-26,  1.992430119648634e+00, -9.618004199540004e-05, -9.099401410752365e-07,
 -7.580255717891850e-09, -5.850216659823619e-11, -4.271535433261446e-13, -2.978391483712790e-15, -1.989841288244729e-17, -1.272690030502733e-19, -7.753352950237678e-22,
 -4.449188765116109e-24, -2.350585000358886e-26,  5.467872837578209e-04, -2.877662968709567e-06,  1.135508367985109e-08, -3.982844641295383e-11,  1.308699042023285e-13,
 -4.130662869953320e-16,  1.264369106628196e-18, -3.807297848249321e-21,  1.115488830968453e-23, -3.313157989738048e-26,  9.103460751230821e-29, -2.935339182741795e-31,
  4.921801359449415e-03, -2.588002855195697e-05,  1.018970538740697e-07, -3.559696610655784e-10,  1.162184669707504e-12, -3.634189619997122e-15,  1.098149688118762e-17,
 -3.251598378456012e-20,  9.315772688497815e-23, -2.697027079931919e-25,  7.115071046895656e-28, -2.247896144293504e-30,  1.367563827297577e-02, -7.178310044282535e-05,
  2.813813206493701e-07, -9.749704948634383e-10,  3.141576002622707e-12, -9.635252433176112e-15,  2.832849906100239e-17, -8.085203356169573e-20,  2.201235198943355e-22,
 -5.995791046840239e-25,  1.421661619990570e-27, -4.267225662915873e-30,  2.681587213606603e-02, -1.403803845615401e-04,  5.465766755216726e-07, -1.870168905185815e-09,
  5.903560501634220e-12, -1.755173935159979e-14,  4.929785489005538e-17, -1.318548433705141e-19,  3.253542254097535e-22, -7.767535408257958e-25,  1.364072147888601e-27,
 -3.532569940514275e-30,  4.435375164072126e-02, -2.313540711318318e-04,  8.925560726669830e-07, -3.001334556163727e-09,  9.202572711369433e-12, -2.613296633279607e-14,
  6.830236565181035e-17, -1.630866632891853e-19,  3.268897152323504e-22, -5.291555083384400e-25, -2.733254567765530e-28,  2.035797863264252e-30,  6.630405371072459e-02,
 -3.442649818579153e-04,  1.312598762882907e-06, -4.314413362872846e-09,  1.271666905744996e-11, -3.380151622086860e-14,  7.870185943228636e-17, -1.502187932465403e-19,
  1.480783605692467e-22,  3.378598655943296e-25, -3.791830459630124e-27,  1.189480465635900e-29,  9.268486836988545e-02, -4.785385277229318e-04,  1.798057287078187e-06,
 -5.741240913653003e-09,  1.605337026501246e-11, -3.873948972990473e-14,  7.353269097012497e-17, -7.174515769747594e-20, -2.572080183443947e-22,  1.826674589432763e-24,
 -8.538216960641782e-27,  2.149151814402105e-29,  1.235172954928886e-01, -6.334460869766905e-04,  2.338187464502169e-06, -7.199282338935288e-09,  1.875851966126220e-11,
 -3.900776605700905e-14,  4.645753232204779e-17,  8.531971638296193e-20, -8.772780687866511e-22,  3.644338231057775e-24, -1.263874916794779e-26,  2.223298018967402e-29,
  1.588250262557061e-01, -8.080810088377759e-04,  2.919939519304184e-06, -8.591486480942333e-09,  2.032938822495186e-11, -3.270611142205547e-14, -7.052302442477600e-18,
  3.190595645660882e-19, -1.617315080342475e-21,  5.143564824947350e-24, -1.310153501729536e-26,  3.673504335186634e-30,  1.986337717715792e-01, -1.001328203188570e-03,
  3.527709008172307e-06, -9.806386188424154e-09,  2.023370688771021e-11, -1.818339602198678e-14, -8.830556003650579e-17,  6.061595319721633e-19, -2.282231081431742e-21,
  5.349956032093002e-24, -6.489565253999092e-27, -4.150486853676433e-29,  2.429704875361828e-01, -1.211825978828723e-03,  4.143047594971892e-06, -1.071864050108173e-08,
  1.793687298912912e-11,  5.692081806420226e-15, -1.937879104324375e-16,  8.962817212465782e-19, -2.576570439948375e-21,  3.125610225374484e-24,  9.674256766245902e-27,
 -1.099145987014871e-28,  2.918623234423269e-01, -1.437918430932513e-03,  4.744336543366159e-06, -1.119030720559670e-08,  1.294027165396417e-11,  3.919301144022162e-14,
 -3.134666784935766e-16,  1.108930261091226e-18, -2.133494951600486e-21, -2.480241658162572e-24,  3.475328031981972e-26, -1.789900874677590e-28,  3.453352031773282e-01,
 -1.677596241820958e-03,  5.306431005615784e-06, -1.107326789848234e-08,  4.834457296337470e-12,  8.131916275795494e-14, -4.292115399458011e-16,  1.135306924848577e-18,
 -5.877207566028074e-22, -1.166095417521211e-23,  6.240055170150143e-26, -2.017624147298023e-28,  4.034119008060217e-01, -1.928423243091894e-03,  5.800292298085545e-06,
 -1.021341858165120e-08, -6.628225771947630e-12,  1.293143651410303e-13, -5.137170824800864e-16,  8.487965199714547e-19,  2.291995389802574e-21, -2.308564021472922e-23,
  7.841790243374557e-26, -1.122642322384498e-28,  4.661094319833210e-01, -2.187445500875535e-03,  6.192640827036976e-06, -8.457507620997008e-09, -2.143635992503808e-11,
  1.781410621199596e-13, -5.305901241330308e-16,  1.289721682053446e-19,  6.400442005134987e-21, -3.308213077741332e-23,  6.089293821499861e-26,  1.481039695426740e-28,
  5.334355063439186e-01, -2.451079070720977e-03,  6.445688098272705e-06, -5.663873036358716e-09, -3.919232389104103e-11,  2.199800789757743e-13, -4.366700151127864e-16,
 -1.095107696325763e-18,  1.103168734949165e-20, -3.514497998190308e-23, -1.440761262648465e-26,  5.735124616447411e-28,  6.053836872432108e-01, -2.714972032200476e-03,
  6.517048563762722e-06, -1.718822141134630e-09, -5.895188731851566e-11,  2.438965178720183e-13, -1.881895906101777e-16, -2.777238071568301e-18,  1.460510006308640e-20,
 -2.050656675042926e-23, -1.595950844577862e-25,  1.007523645509978e-27,  6.819267623068564e-01, -2.973836197334032e-03,  6.360000710118212e-06,  3.438994235249161e-09,
 -7.903260745234549e-11,  2.359366078881961e-13,  2.470200386351465e-16, -4.661877094264001e-18,  1.452116340176970e-20,  1.903718939800983e-23, -3.485573846835212e-25,
  1.063625008025730e-27,  7.630076248668286e-01, -3.221244495047140e-03,  5.924376682619352e-06,  9.783203782908259e-09, -9.680617630617360e-11,  1.801164526808932e-13,
  8.687289105999893e-16, -6.181428846496713e-18,  7.433948874444049e-21,  8.458192583558187e-23, -4.833895367367830e-25,  1.583797693404731e-28,  8.485266768141578e-01,
 -3.449392473909066e-03,  5.158532496555930e-06,  1.714985873611556e-08, -1.085172832516220e-10,  6.104456140559382e-14,  1.613081111799941e-15, -6.388773389293758e-18,
 -9.576784780274281e-21,  1.591149971453704e-22, -3.758697483193915e-25, -2.141274512162755e-27,  9.383243537320641e-01, -3.648828598528186e-03,  4.013114977984293e-06,
  2.516999904780320e-08, -1.092244264020765e-10, -1.307500712330884e-13,  2.312783986295692e-15, -4.030397298842675e-18, -3.632306007660810e-20,  1.949004907079310e-22,
  1.991291230938195e-25, -5.237751351759568e-27,  1.032156802277773e+00, -3.808171766580483e-03,  2.447726211558726e-06,  3.318419593306806e-08, -9.305203327596532e-11,
 -3.895231677836774e-13,  2.660865876537408e-15,  2.045830458669411e-18, -6.504303038665691e-20,  1.114440128969762e-22,  1.285073723623090e-24, -6.261989716591217e-27,
  1.129661968762668e+00, -3.913862625949253e-03,  4.420963948183403e-07,  4.014675472510786e-08, -5.409234568408973e-11, -6.803252316442037e-13,  2.212770299208975e-15,
  1.188160070149845e-17, -7.562912693653453e-20, -1.674033338866151e-22,  2.308304790683889e-24, -4.030849856500831e-29,  1.230312381223684e+00, -3.950050027052469e-03,
 -1.986083310466742e-06,  4.454687890739728e-08,  1.151428046072341e-11, -9.222558617854246e-13,  5.004802860119729e-16,  2.266105950686224e-17, -3.665345252895834e-20,
 -5.980223185802254e-22,  1.704764009113891e-24,  1.578404609530445e-26,  1.333349837517533e+00, -3.898815421269483e-03, -4.754336265713859e-06,  4.441521711153333e-08,
  1.016851025085204e-10, -9.784092344957206e-13, -2.627311521188520e-15,  2.689904073380498e-17,  7.430054113282362e-20, -8.356235343951869e-22, -2.265873401375772e-24,
  2.756976913941824e-26,  1.437696485532177e+00, -3.741114667038571e-03, -7.678566296532298e-06,  3.755788885780853e-08,  2.024592545009749e-10, -6.773975537814837e-13,
 -6.366577591204298e-15,  1.342635301876862e-17,  2.174628276275930e-19, -2.280830345528498e-22, -7.834991627192228e-24, -4.012833825264613e-30,  1.541837611048120e+00,
 -3.459093638598060e-03, -1.043070230382747e-05,  2.225940793912511e-08,  2.817707257689064e-10,  8.912636913691338e-14, -8.302196769823330e-15, -2.301957420785890e-17,
  2.344111146745166e-19,  1.410626762318150e-21, -5.520641307490833e-24, -6.917871895274201e-26,  1.643676682388591e+00, -3.040780367699436e-03, -1.251012843577693e-05,
 -1.268502193925795e-09,  2.898352126196292e-10,  1.159660517617523e-12, -4.964217839990933e-15, -6.133545987672465e-17, -5.878642152278280e-20,  2.207566362691031e-21,
  1.149645107568443e-23, -4.696962494003592e-26,  1.740378518317412e+00, -2.488329438491406e-03, -1.327814033098653e-05, -2.875381812662667e-08,  1.807767085984030e-10,
  1.894640349172184e-12,  4.354041186449645e-15, -4.782786967526426e-17, -4.606750032605033e-19, -6.960891248905847e-22,  1.635753018618650e-23,  1.317271863450698e-25,
  1.828250490026991e+00, -1.830220088481784e-03, -1.214302251381397e-05, -5.041708230451546e-08, -3.240377229226599e-11,  1.416524331929020e-12,  1.190823524795527e-14,
  3.458185495548090e-17, -2.430410836211766e-19, -3.526348837839346e-21, -1.724588259776415e-23,  2.951691316632900e-26,  1.902769756129362e+00, -1.134539411309991e-03,
 -8.973242617494856e-06, -5.388517003987178e-08, -2.242967799256920e-10, -2.310010080615020e-13,  6.369711943018188e-15,  7.110449904710544e-17,  4.196320777531519e-19,
  9.102080025170323e-22, -1.098405448442594e-23, -1.586620696769654e-25,  1.958925558404273e+00, -5.135937749550742e-04, -4.620333203071596e-06, -3.487307095942169e-08,
 -2.272728829516347e-10, -1.250195356681980e-12, -5.203300311966367e-15, -7.860107293232860e-18,  1.331918912509264e-19,  1.904026565385265e-21,  1.627363424266271e-23,
  1.029469615960553e-25,  1.992030240985139e+00, -1.038400034693862e-04, -1.006814458022385e-06, -8.588716828151157e-09, -6.780767350637234e-11, -5.058080809697536e-13,
 -3.597016735875008e-15, -2.445407940954909e-17, -1.586482060304238e-19, -9.755890080842073e-22, -5.604743820458402e-24, -2.916774644682323e-26,  5.354553356994687e-04,
 -2.788699085410707e-06,  1.088943845332596e-08, -3.779900534797615e-11,  1.229035959718421e-13, -3.839614220166678e-16,  1.162587715228765e-18, -3.468747228718858e-21,
  1.002465278223476e-23, -2.974105469854338e-26,  7.865878119539553e-29, -2.706117052953539e-31,  4.819884983520678e-03, -2.508162798291100e-05,  9.773463465880489e-08,
 -3.379421604222243e-10,  1.092064393869205e-12, -3.381230986803423e-15,  1.011136242142420e-17, -2.968498293089083e-20,  8.393732521242178e-23, -2.431724867798173e-25,
  6.160587669569792e-28, -2.103325312689867e-30,  1.339293506193112e-02, -6.957800836205988e-05,  2.699770243310350e-07, -9.262107344906514e-10,  2.955490451755767e-12,
 -8.981758333392741e-15,  2.616008867059066e-17, -7.414282785134423e-20,  1.995174116659981e-22, -5.464268161924385e-25,  1.236686380806951e-27, -4.167365919889367e-30,
  2.626295592410358e-02, -1.360959597634987e-04,  5.246900111741968e-07, -1.778457165472273e-09,  5.564064124913918e-12, -1.641174304983565e-14,  4.574754745839951e-17,
 -1.218806993305887e-19,  2.983345775053464e-22, -7.254329605405600e-25,  1.198302971890018e-27, -4.036237885543394e-30,  4.344239163406743e-02, -2.243552226604880e-04,
  8.574065415332125e-07, -2.858187132655281e-09,  8.695942105876661e-12, -2.454734231632135e-14,  6.387950769802426e-17, -1.529329525272681e-19,  3.076600764029351e-22,
 -5.388302520888110e-25, -2.239303605326293e-28,  1.761046651026457e-31,  6.494767228437746e-02, -3.339678753808892e-04,  1.262024622309889e-06, -4.116253693639966e-09,
  1.205918929431933e-11, -3.196259944149469e-14,  7.456369774112390e-17, -1.453139908470200e-19,  1.576277000825988e-22,  1.955936563803626e-25, -3.348109238329314e-27,
  8.233328213831951e-30,  9.079905292891831e-02, -4.644253407379614e-04,  1.730678260293794e-06, -5.490490120132011e-09,  1.529606104093258e-11, -3.699968313367128e-14,
  7.141802368033407e-17, -7.898779961025015e-20, -1.973802463328198e-22,  1.502635707268937e-24, -7.699835797903055e-27,  1.652728512960710e-29,  1.210203821245566e-01,
 -6.150811093900043e-04,  2.253571347518713e-06, -6.905325929611962e-09,  1.798969176028819e-11, -3.786717231109998e-14,  4.847250206864239e-17,  5.925022935023113e-20,
 -7.549567778527157e-22,  3.157155960014119e-24, -1.175223856702634e-26,  1.784968872731414e-29,  1.556387760405760e-01, -7.851284041992067e-04,  2.818771695030811e-06,
 -8.271455508986293e-09,  1.967426755953354e-11, -3.277384339102078e-14,  1.183925915112180e-18,  2.701673488063073e-19, -1.441540925303713e-21,  4.622698145208216e-24,
 -1.294722981931251e-26,  2.920627244165751e-30,  1.946841647500011e-01, -9.735717624507952e-04,  3.411962451143320e-06, -9.485665747607866e-09,  1.985017850072275e-11,
 -2.010713632405753e-14, -7.232695596197674e-17,  5.361561645495977e-19, -2.094726720730199e-21,  5.055831659007685e-24, -8.174588982361194e-27, -3.573871518909915e-29,
  2.381886646628582e-01, -1.179191206931668e-03,  4.016148809893249e-06, -1.043098413326532e-08,  1.800619059293109e-11,  1.333112146480939e-15, -1.698289311001164e-16,
  8.156972889193540e-19, -2.458211686600706e-21,  3.419840103891068e-24,  5.127695989752684e-27, -9.751092652298155e-29,  2.861857136842681e-01, -1.400497296608030e-03,
  4.611319694791329e-06, -1.097739032059755e-08,  1.365137474662623e-11,  3.203462371895473e-14, -2.833840351696090e-16,  1.039482941586438e-18, -2.199621906080439e-21,
 -1.243557546762419e-24,  2.717585386892867e-26, -1.659871281171111e-28,  3.387088815526539e-01, -1.635674875640440e-03,  5.174067785821375e-06, -1.098345444246248e-08,
  6.360392090014404e-12,  7.139705263037968e-14, -3.977460202069346e-16,  1.110247493660397e-18, -9.647298979963580e-22, -9.342869845341699e-24,  5.349621345616860e-26,
 -2.028358757324692e-28,  3.957902339990858e-01, -1.882512759430225e-03,  5.677178165388463e-06, -1.029944156262840e-08, -4.163265846264329e-12,  1.172778921186903e-13,
 -4.890446487219941e-16,  9.094380769181987e-19,  1.516078315881426e-21, -2.005907982999150e-23,  7.264244101544891e-26, -1.490800891718873e-28,  4.574580815822517e-01,
 -2.138315899027954e-03,  6.089208181247289e-06, -8.772677069103782e-09, -1.800047279969825e-11,  1.654722944351838e-13, -5.242871287443791e-16,  3.152121765734686e-19,
  5.254645878503039e-21, -3.054368555370527e-23,  6.536666799793258e-26,  5.707153912963133e-29,  5.237338760025242e-01, -2.399795761531283e-03,  6.374102474309815e-06,
 -6.256332546428193e-09, -3.489980563083710e-11,  2.091707611460076e-13, -4.625815585237067e-16, -7.624015386058396e-19,  9.761802047010170e-21, -3.525762198268601e-23,
  7.767217868603741e-27,  4.350864210548554e-28,  5.946279191100264e-01, -2.662933813065570e-03,  6.490923423701347e-06, -2.623299792906065e-09, -5.412515134689876e-11,
  2.384989036771175e-13, -2.595284451277655e-16, -2.322834041695738e-18,  1.376232847987345e-20, -2.603820465471885e-23, -1.178836084030607e-25,  8.845057848006907e-28,
  6.701334090191119e-01, -2.922812256299101e-03,  6.393838153224837e-06,  2.212501058206402e-09, -7.426488990685722e-11,  2.403517459719987e-13,  1.230773408460136e-16,
 -4.188832821929898e-18,  1.496695726230680e-20,  6.044964999737156e-24, -3.008363932058296e-25,  1.093634194071881e-27,  7.502181436333484e-01, -3.173405938237755e-03,
  6.032604121907435e-06,  8.264198088083746e-09, -9.300922141419514e-11,  1.989185481811214e-13,  6.994105764479965e-16, -5.898534575933651e-18,  1.013357080759159e-20,
  6.549770342248807e-23, -4.682456379494574e-25,  5.119992000831300e-28,  8.348129052962708e-01, -3.407330431268831e-03,  5.353960077723538e-06,  1.542539141426418e-08,
 -1.069238991974786e-10,  9.758243530775614e-14,  1.430744495306839e-15, -6.606653490765920e-18, -4.140037963045446e-21,  1.424081422838719e-22, -4.543169994190071e-25,
 -1.434036446691537e-27,  9.237951199177625e-01, -3.615545407140001e-03,  4.304592785430823e-06,  2.340446343535550e-08, -1.112941517403383e-10, -7.672228608733025e-14,
  2.184723330563083e-15, -5.079376019600451e-18, -2.921727026862276e-20,  1.984281524863192e-22, -1.818204854362774e-26, -4.612477890646310e-27,  1.016965764345636e+00,
 -3.787022995088952e-03,  2.836757764908092e-06,  3.163652475862683e-08, -1.002004474229191e-10, -3.252061351406561e-13,  2.689680529863441e-15,  3.801385245400929e-20,
 -6.017416484305195e-20,  1.571271062770502e-22,  9.947912410839216e-25, -6.851645484370825e-27,  1.114016620843990e+00, -3.908414538488329e-03,  9.182252154998672e-07,
  3.917541873721354e-08, -6.714227264479847e-11, -6.235049340410833e-13,  2.510794043539746e-15,  9.382806447303937e-18, -8.000235712402943e-20, -7.600862239875579e-23,
  2.239817734880927e-24, -3.004779103294265e-27,  1.214483791925221e+00, -3.963798707992706e-03, -1.451021384320707e-06,  4.458441218205655e-08, -6.760093798936086e-12,
 -9.027821474281423e-13,  1.115434094972590e-15,  2.115814357386018e-17, -5.679723663574733e-20, -5.170292528312680e-22,  2.316395686146600e-24,  1.187842624490087e-26,
  1.317681919068584e+00, -3.934692030776845e-03, -4.212248027847745e-06,  4.588246781084699e-08,  8.154863856763974e-11, -1.032186324411700e-12, -1.845484846397399e-15,
  2.878027051273983e-17,  4.288662546827629e-20, -9.011966733204466e-22, -9.975028554946047e-25,  2.966499063821296e-26,  1.422612100522578e+00, -3.800686432718718e-03,
 -7.208909133567873e-06,  4.068069315181780e-08,  1.874177996594872e-10, -8.249075607517347e-13, -5.894880786188218e-15,  2.019354527377614e-17,  2.036477528627843e-19,
 -5.374036361156100e-22, -7.529881297383346e-24,  1.385984789001894e-26,  1.527836145260586e+00, -3.541394099698344e-03, -1.013651622475512e-05,  2.677097039421078e-08,
  2.815130913048286e-10, -1.169680466321688e-13, -8.834432387587456e-15, -1.475440504153590e-17,  2.804958575602826e-19,  1.130196131708612e-21, -8.455807323937382e-24,
 -6.298558829886806e-26,  1.631313416020808e+00, -3.140841730397125e-03, -1.249678347715788e-05,  3.547346783466135e-09,  3.116971260795802e-10,  1.019774497701741e-12,
 -6.695393274366032e-15, -6.186095585580476e-17,  2.837415831607131e-20,  2.616066141764871e-21,  8.679687458235929e-24, -8.106414175617652e-26,  1.730210638286653e+00,
 -2.595882658787017e-03, -1.360456404717760e-05, -2.555305620445407e-08,  2.195973218532277e-10,  1.981383013282034e-12,  2.805677118219642e-15, -6.283281909901511e-17,
 -4.725642729256857e-19,  7.341448082564453e-23,  2.206837604605722e-23,  1.248788684531072e-25,  1.820731480139249e+00, -1.929790846800526e-03, -1.275015219905402e-05,
 -5.069305856968080e-08, -1.141934344547546e-12,  1.712940665133921e-12,  1.274763052919451e-14,  2.464375915506491e-17, -3.819408959447052e-19, -4.173154907290094e-21,
 -1.463754378890732e-23,  9.223627783928020e-26,  1.898083844808638e+00, -1.208973142820527e-03, -9.641520787779417e-06, -5.750186800599434e-08, -2.272188458322890e-10,
 -5.269253021188271e-14,  8.552870835363223e-15,  8.495760540013893e-17,  4.426638126800546e-19,  3.152282046520717e-22, -1.917213290977209e-23, -2.144851007804908e-25,
  1.956794517785695e+00, -5.522941109225127e-04, -5.061475540759592e-06, -3.871631875361574e-08, -2.535406339435800e-10, -1.377165884889949e-12, -5.352459909414735e-15,
 -2.366382738146682e-18,  2.146020965286402e-19,  2.651769294530861e-21,  2.126527071439890e-23,  1.237185817072463e-25,  1.991598092105820e+00, -1.123260217299279e-04,
 -1.116738285632648e-06, -9.759502962180134e-09, -7.884568936241287e-11, -6.009607883503571e-13, -4.358408806986756e-15, -3.013865016889861e-17, -1.981309151870013e-19,
 -1.227301395087288e-21, -7.028078285866710e-24, -3.564274448741786e-26,  5.244719440864051e-04, -2.703365074195958e-06,  1.044740054190917e-08, -3.589249800833957e-11,
  1.154957046842573e-13, -3.571895349429016e-16,  1.069797074573391e-18, -3.164504949825401e-21,  9.007781437098555e-24, -2.682840764271107e-26,  6.706207383778857e-29,
 -2.585146124650858e-31,  4.721096954822346e-03, -2.431568014301454e-05,  9.378197725424993e-08, -3.209972191039762e-10,  1.026800710473380e-12, -3.148236848890638e-15,
  9.316503638858266e-18, -2.713447935386049e-20,  7.560460528624236e-23, -2.203570432738060e-25,  5.251333365356601e-28, -2.046185582664093e-30,  1.311887338604021e-02,
 -6.746185982336104e-05,  2.591404032423716e-07, -8.803265489296889e-10,  2.781969203099748e-12, -8.378124584387371e-15,  2.417058201769911e-17, -6.806382433792869e-20,
  1.806921950699821e-22, -5.006379528797833e-25,  1.052070913597060e-27, -4.263099442101820e-30,  2.572683406667657e-02, -1.319823167565649e-04,  5.038720337074416e-07,
 -1.691999504761398e-09,  5.246537723934712e-12, -1.535369885685291e-14,  4.246467960993861e-17, -1.127429505053342e-19,  2.730371474460648e-22, -6.812575007573257e-25,
  1.004777858448325e-27, -4.821098127783995e-30,  4.255847531658982e-02, -2.176308347922579e-04,  8.239271710342129e-07, -2.722897770990552e-09,  8.219985162728007e-12,
 -2.306452509052280e-14,  5.973228817851831e-17, -1.433999459190267e-19,  2.880973097213047e-22, -5.482443146714170e-25, -2.627292863914323e-28, -2.020508383730996e-30,
  6.363168490899321e-02, -3.240660264384904e-04,  1.213766476044834e-06, -3.928324822839826e-09,  1.143750599085908e-11, -3.022132061646361e-14,  7.056640124730402e-17,
 -1.401824500434534e-19,  1.623352355539432e-22,  6.775268367976774e-26, -3.073812914148906e-27,  4.123044635464351e-30,  8.896863094117967e-02, -4.508393532910223e-04,
  1.666236680506817e-06, -5.251580727860694e-09,  1.457302507544542e-11, -3.531285630105770e-14,  6.912565517717152e-17, -8.449656515753597e-20, -1.486685951049433e-22,
  1.207568121210284e-24, -7.095424673879855e-27,  1.076553905624407e-29,  1.185955968564625e-01, -5.973791582031546e-04,  2.172409660612337e-06, -6.623485884613322e-09,
  1.724410241940627e-11, -3.668655229585963e-14,  4.980973597586574e-17,  3.682084885871490e-20, -6.495859990645604e-22,  2.701156092222148e-24, -1.109110988662766e-26,
  1.188313229699372e-29,  1.525427416295487e-01, -7.629699588964320e-04,  2.721381339679019e-06, -7.961907018990423e-09,  1.901966127348780e-11, -3.265971535053204e-14,
  8.127108012189944e-18,  2.266009666514892e-19, -1.284421992141315e-21,  4.106548390979229e-24, -1.288649372386202e-26, -6.979174117323148e-31,  1.908437557702516e-01,
 -9.467260066997880e-04,  3.300026516712157e-06, -9.171369377695545e-09,  1.943185486594049e-11, -2.167024348188808e-14, -5.822612624383824e-17,  4.719709370807140e-19,
 -1.918973900199127e-21,  4.698162389386759e-24, -9.698451387214815e-27, -3.432803532978896e-29,  2.335353723765783e-01, -1.147557805381629e-03,  3.892705777923745e-06,
 -1.014288563577525e-08,  1.799389844201263e-11, -2.477481836243309e-15, -1.480719432555894e-16,  7.390356959821222e-19, -2.332415713769385e-21,  3.541670655901316e-24,
  1.016022911302133e-27, -9.037382982201348e-29,  2.806566766346485e-01, -1.364129894270811e-03,  4.480921515450864e-06, -1.075420256531825e-08,  1.422637134399397e-11,
  2.557468509520584e-14, -2.552692596285239e-16,  9.685744459211060e-19, -2.226556165143207e-21, -2.996643394654535e-25,  2.008163234359955e-26, -1.574051436880931e-28,
  3.322481349734168e-01, -1.594807703934437e-03,  5.042922400848287e-06, -1.087077279845559e-08,  7.695372843794319e-12,  6.222040639153862e-14, -3.671390097626050e-16,
  1.074390157800471e-18, -1.264710008660797e-21, -7.381897179296693e-24,  4.453885783271337e-26, -2.047634549447148e-28,  3.883502336856169e-01, -1.837590665547869e-03,
  5.553260554675359e-06, -1.034791831952200e-08, -1.932990541047861e-12,  1.058512263586437e-13, -4.630058181459661e-16,  9.469459437158874e-19,  8.445854412667070e-22,
 -1.729415840738853e-23,  6.537185412557627e-26, -1.809881649067373e-28,  4.490015720074320e-01, -2.090027971113525e-03,  5.982315017148949e-06, -9.034889407372743e-09,
 -1.481604696726087e-11,  1.530133175668251e-13, -5.132687899542303e-16,  4.662757396498020e-19,  4.202517196124760e-21, -2.790341845162747e-23,  6.605066893420071e-26,
 -2.484676401086589e-29,  5.142361901273896e-01, -2.349112424459106e-03,  6.295812182834434e-06, -6.781871959081039e-09, -3.082896164625452e-11,  1.978467657179262e-13,
 -4.797456959091997e-16, -4.702372464643301e-19,  8.502370229754734e-21, -3.460392724657517e-23,  2.393692574899805e-26,  3.004085182291557e-28,  5.840798189527535e-01,
 -2.611146705893766e-03,  6.454404066394353e-06, -3.451502044415663e-09, -4.942247488540169e-11,  2.315386165044252e-13, -3.185492532148910e-16, -1.898273903491852e-18,
  1.274908493504238e-20, -3.001623343619475e-23, -8.206800683590750e-26,  7.403613774602085e-28,  6.585446015194715e-01, -2.871575184889218e-03,  6.413417781911320e-06,
  1.062840689684965e-09, -6.943753643757933e-11,  2.419523952139330e-13,  1.251191982330698e-17, -3.708636918774236e-18,  1.497952046384246e-20, -5.032522038172970e-24,
 -2.533121708971030e-25,  1.056096998555810e-27,  7.376216343156219e-01, -3.124773414256910e-03,  6.122979702473418e-06,  6.808734076400143e-09, -8.887617163397396e-11,
  2.137611880497726e-13,  5.391204290028266e-16, -5.540099499554054e-18,  1.216052050090123e-20,  4.729814130480445e-23, -4.399592393063941e-25,  7.554500510329357e-28,
  8.212703784138515e-01, -3.363787255026314e-03,  5.528870355873037e-06,  1.373202480231209e-08, -1.046439134357279e-10,  1.296901060741181e-13,  1.244648510315336e-15,
 -6.660726729308669e-18,  6.461025858012492e-22,  1.231657654757010e-22, -5.032108704427436e-25, -8.042398649024360e-28,  9.094035476452986e-01, -3.580015620977328e-03,
  4.574720563134394e-06,  2.161428014894550e-08, -1.123163019398495e-10, -2.609466024591744e-14,  2.030482120393239e-15, -5.900558682375240e-18, -2.213391777433567e-20,
  1.938563831169489e-22, -2.049377875668205e-25, -3.862989987983636e-27,  1.001865425765404e+00, -3.762838105843187e-03,  3.206573535936742e-06,  2.998478847836546e-08,
 -1.060600619858562e-10, -2.608531329967043e-13,  2.664688577640113e-15, -1.789968830924363e-18, -5.387467666294133e-20,  1.908205910565754e-22,  6.889661656260867e-25,
 -6.978820509155477e-27,  1.098400604620483e+00, -3.899207505396920e-03,  1.381483905988131e-06,  3.800473975420024e-08, -7.899000413497245e-11, -5.603844599687108e-13,
  2.737381760500526e-15,  6.795936109099695e-18, -8.116492588502039e-20,  1.017171337717051e-23,  2.051181026876126e-24, -5.476896827680188e-27,  1.198608764774480e+00,
 -3.973270027822688e-03, -9.172479907613339e-07,  4.433345758048439e-08, -2.450117789776477e-11, -8.691245069421079e-13,  1.679751826974669e-15,  1.906165066706404e-17,
 -7.362833719693172e-20, -4.152244498351467e-22,  2.740752789017277e-24,  7.341802958095005e-27,  1.301879271272736e+00, -3.966167058502915e-03, -3.654518028610753e-06,
  4.701996609588046e-08,  6.052794282716440e-11, -1.066682901155511e-12, -1.025341419381747e-15,  2.962841198731226e-17,  1.004066540919246e-20, -9.149452206979379e-22,
  3.065958151986800e-25,  2.918911576587195e-26,  1.407297174231882e+00, -3.856355357668010e-03, -6.703317489318227e-06,  4.353991105408829e-08,  1.695543984668708e-10,
 -9.588831986941636e-13, -5.241542118231033e-15,  2.634402887726994e-17,  1.790627502191934e-19, -8.224602834673973e-22, -6.628100176972230e-24,  2.685846657030159e-26,
  1.513510526967529e+00, -3.621124904615008e-03, -9.788354177673670e-06,  3.124482311130589e-08,  2.770253961272602e-10, -3.329025006665365e-13, -9.116272802205589e-15,
 -5.198045044137369e-18,  3.144577603645441e-19,  7.400369206887569e-22, -1.095238028348488e-23, -4.930168215499675e-26,  1.618550491822261e+00, -3.240559453528980e-03,
 -1.242364922403202e-05,  8.688347993674829e-09,  3.303463286662969e-10,  8.384916118181799e-13, -8.400195821334131e-15, -5.938668226185359e-17,  1.278537877276832e-19,
  2.882253898575891e-21,  4.398654321543859e-24, -1.127018478811751e-25,  1.719607580916714e+00, -2.705882955013126e-03, -1.388880152298600e-05, -2.171944798815064e-08,
  2.597470418977896e-10,  2.025907437469837e-12,  8.363219099732834e-16, -7.773182581294653e-17, -4.527632888425805e-19,  1.059650941433970e-21,  2.704556096167265e-23,
  9.765675086031311e-26,  1.812804464775976e+00, -2.034222929085159e-03, -1.335739356349505e-05, -5.042042815723209e-08,  3.622446154388403e-11,  2.025640367622648e-12,
  1.324320797931258e-14,  9.914179322991474e-18, -5.415316902868604e-19, -4.654867781927310e-21, -8.857788228485212e-24,  1.731997922337343e-25,  1.893089230501462e+00,
 -1.288927205813146e-03, -1.035335258337172e-05, -6.113380972764893e-08, -2.260190273890742e-10,  1.827275155951465e-13,  1.113053597529684e-14,  9.913691991833286e-17,
  4.377769046263510e-19, -6.576176535989999e-22, -2.989419960045511e-23, -2.725330990667280e-25,  1.954501315116498e+00, -5.947154002904138e-04, -5.551342830296518e-06,
 -4.300030242341792e-08, -2.823695019351897e-10, -1.505549678441890e-12, -5.306991754201220e-15,  6.203451930979931e-18,  3.267388605611628e-19,  3.616676657497046e-21,
  2.710265893531960e-23,  1.404213136827411e-25,  1.991130146954721e+00, -1.217507820482194e-04, -1.241837367572791e-06, -1.112317143524528e-08, -9.198316092898022e-11,
 -7.164484705020656e-13, -5.298101001639710e-15, -3.724320999491608e-17, -2.477703063121750e-19, -1.541810415697359e-21, -8.747630389182790e-24, -4.252805122245174e-26,
  5.138229580142232e-04, -2.621477828945409e-06,  1.002754684625957e-08, -3.410035159492550e-11,  1.086016528021391e-13, -3.325459811387867e-16,  9.850847892520211e-19,
 -2.891213581250907e-21,  8.087509218639306e-24, -2.437286939049377e-26,  5.569889810066068e-29, -2.608109135310018e-31,  4.625310738177996e-03, -2.358055760935770e-05,
  9.002654431561492e-08, -3.050602304056735e-10,  9.660117756776684e-13, -2.933491749748605e-15,  8.589444389860333e-18, -2.483818003013271e-20,  6.802809090680894e-23,
 -2.011607699347332e-25,  4.342200958502533e-28, -2.110368469898823e-30,  1.285310634012142e-02, -6.543024810929361e-05,  2.488381244903875e-07, -8.371246595976335e-10,
  2.620056589478367e-12, -7.820263049974455e-15,  2.234309134460888e-17, -6.256229134309383e-20,  1.633807444325547e-22, -4.623959958874817e-25,  8.571807880124613e-28,
 -4.656744475569500e-30,  2.520684014457572e-02, -1.280311523879920e-04,  4.840617503108259e-07, -1.610457174891089e-09,  4.949404576222827e-12, -1.437146326990012e-14,
  3.942656347958235e-17, -1.043908431664781e-19,  2.491812529494307e-22, -6.456403752039580e-25,  7.667747729723156e-28, -6.104347102133839e-30,  4.170093098280903e-02,
 -2.111679152397560e-04,  7.920265423950614e-07, -2.594991788156933e-09,  7.772710485297201e-12, -2.167810911065350e-14,  5.584317449729073e-17, -1.344988688307325e-19,
  2.681428653834380e-22, -5.613190832541520e-25, -4.121353044548749e-28, -4.931096126708636e-30,  6.235454684635326e-02, -3.145413885651499e-04,  1.167704927125794e-06,
 -3.750069443652938e-09,  1.084970062125116e-11, -2.857423987292717e-14,  6.671421797807967e-17, -1.349721545233333e-19,  1.625922449589030e-22, -5.297994703070912e-26,
 -3.000022863861668e-27, -1.000084661564523e-30,  8.719153972077583e-02, -4.377576249530248e-04,  1.604593705461217e-06, -5.023973057391106e-09,  1.388316385352915e-11,
 -3.368273077739039e-14,  6.669929744161262e-17, -8.861236845472696e-20, -1.102086923556737e-22,  9.312213287295180e-25, -6.774992488152120e-27,  3.457439091568627e-30,
  1.162403419420414e-01, -5.803131731848581e-04,  2.094559261959554e-06, -6.353384832978609e-09,  1.652239745055558e-11, -3.548100891724679e-14,  5.056371870044752e-17,
  1.750523058374648e-20, -5.602242191956241e-22,  2.265703976451252e-24, -1.074293281795677e-26,  3.421455147515321e-30,  1.495338060286636e-01, -7.415759559315829e-04,
  2.627642827547102e-06, -7.662805319925565e-09,  1.836890796681436e-11, -3.239303826332433e-14,  1.391802852890614e-17,  1.877651842905402e-19, -1.145888518932466e-21,
  3.588589476839123e-24, -1.306628766563784e-26, -8.259598744326182e-30,  1.871089625614575e-01, -9.207607682419514e-04,  3.191821005919780e-06, -8.863998495369114e-09,
  1.898551094749274e-11, -2.291587375746350e-14, -4.584576494797705e-17,  4.131920493484632e-19, -1.757193253284423e-21,  4.279234554979043e-24, -1.127888956529004e-26,
 -3.861822160559993e-29,  2.290066604913440e-01, -1.116898128314299e-03,  3.772716322812793e-06, -9.855565858218673e-09,  1.791044458401184e-11, -5.791208596809742e-15,
 -1.284046873672038e-16,  6.664385084240177e-19, -2.205135827440303e-21,  3.503387057663356e-24, -2.929936321180618e-27, -9.039030138057736e-29,  2.752710399939267e-01,
 -1.328794817541264e-03,  4.353252642196566e-06, -1.052281246941167e-08,  1.467875551735928e-11,  1.976560789154033e-14, -2.291472668801698e-16,  8.972935990389748e-19,
 -2.224543896312675e-21,  3.661217307729608e-25,  1.321764502255360e-26, -1.561076704114712e-28,  3.259487678132162e-01, -1.554983937165511e-03,  4.913251425475212e-06,
 -1.073816017431110e-08,  8.854079692620794e-12,  5.376525836273457e-14, -3.376602772957669e-16,  1.029993600400288e-18, -1.500574591840658e-21, -5.782052616253992e-24,
  3.540298055486136e-26, -2.117799420534520e-28,  3.810879362154790e-01, -1.793661649946997e-03,  5.428967898570475e-06, -1.036250466887080e-08,  7.507367004843649e-14,
  9.505975695559281e-14, -4.362030482919192e-16,  9.644997843138261e-19,  2.670600346300388e-22, -1.484784453532622e-23,  5.670811394307513e-26, -2.134790796351196e-28,
  4.407364851234846e-01, -2.042606927377725e-03,  5.872572837255175e-06, -9.248128629904787e-09, -1.187783294808030e-11,  1.408658215313384e-13, -4.984777385940307e-16,
  5.851903114790513e-19,  3.245077014201126e-21, -2.530631544341238e-23,  6.323526044738675e-26, -1.031416037715221e-28,  5.049399465552290e-01, -2.299079545685386e-03,
  6.211598680494672e-06, -7.244109389493721e-09, -2.698807776324874e-11,  1.862044700106075e-13, -4.892890977084140e-16, -2.178849622712211e-19,  7.276691666600091e-21,
 -3.342134181487019e-23,  3.421894271093761e-26,  1.666390038523928e-28,  5.737382217623535e-01, -2.559690239220360e-03,  6.408392906797590e-06, -4.205648107327803e-09,
 -4.487222572092942e-11,  2.233006955024148e-13, -3.661559418095134e-16, -1.508165140729556e-18,  1.161684124066456e-20, -3.269394687391042e-23, -5.300216723965198e-26,
  5.776737371030218e-28,  6.471609700611007e-01, -2.820235345588428e-03,  6.419665513991541e-06, -9.465529067018330e-12, -6.460361788161824e-11,  2.410605101384999e-13,
 -8.465974734818204e-17, -3.234057068633943e-18,  1.462694675446470e-20, -1.426031388115173e-23, -2.087941240587944e-25,  9.577114922816588e-28,  7.252209921029892e-01,
 -3.075486602494274e-03,  6.196295616379121e-06,  5.421568201721470e-09, -8.448389042035521e-11,  2.248840309152078e-13,  3.896777097499811e-16, -5.127047614471086e-18,
  1.355493591565612e-20,  3.041155052041622e-23, -4.034088438034792e-25,  8.874148456932960e-28,  8.079046950428609e-01, -3.318925410774113e-03,  5.683699517630361e-06,
  1.208003230897679e-08, -1.017664732508544e-10,  1.573299590126609e-13,  1.059076139945789e-15, -6.573052128012760e-18,  4.710717218052404e-21,  1.024911842006534e-22,
 -5.267433584069128e-25, -2.864257290237929e-28,  8.951582802152598e-01, -3.542410943805317e-03,  4.823300757443535e-06,  1.981563438965469e-08, -1.123646484094080e-10,
  2.058067057778281e-14,  1.856386495662314e-15, -6.499083480152983e-18, -1.534149387252997e-20,  1.824915946800043e-22, -3.575472283228742e-25, -3.074232067006046e-27,
  9.868676161410346e-01, -3.735775470065660e-03,  3.556048269486335e-06,  2.824954527688224e-08, -1.106426382661944e-10, -1.976903247041978e-13,  2.591500770040918e-15,
 -3.399325084995773e-18, -4.658266648704479e-20,  2.122885723814649e-22,  3.863019155585448e-25, -6.723982546923245e-27,  1.082828735276020e+00, -3.886353720215429e-03,
  1.829599615683858e-06,  3.665486714710212e-08, -8.952682188081529e-11, -4.926964634153105e-13,  2.891471120178049e-15,  4.219844588321617e-18, -7.938547956787671e-20,
  8.680313106572398e-23,  1.766764915014890e-24, -7.347203980877699e-27,  1.182704366906936e+00, -3.978487976062812e-03, -3.881646558465299e-07,  4.380474571699607e-08,
 -4.143872755127901e-11, -8.226850299874078e-13,  2.178399456908772e-15,  1.648808167156897e-17, -8.653791680545695e-20, -3.005285807029622e-22,  2.959449930999305e-24,
  2.598711589833278e-27,  1.285959725363554e+00, -3.993131409401792e-03, -3.085175323287019e-06,  4.781668919895965e-08,  3.901545909837414e-11, -1.081329930337281e-12,
 -1.961681076173886e-16,  2.942754563678276e-17, -2.237310969745276e-20, -8.776893819861458e-22,  1.534793080983913e-24,  2.625646307075215e-26,  1.391767871887543e+00,
 -3.907847363673218e-03, -6.165215625097840e-06,  4.609278722325619e-08,  1.491817364045139e-10, -1.075210251612475e-12, -4.428490765975528e-15,  3.155164663866486e-17,
  1.449975953680443e-19, -1.060602206487970e-21, -5.201468036580470e-24,  3.748280330900426e-26,  1.498871893901909e+00, -3.697857219025763e-03, -9.387080170434876e-06,
  3.561204868625983e-08,  2.681736211917951e-10, -5.522810173230118e-13, -9.117561726043965e-15,  5.202392002855208e-18,  3.327402169822025e-19,  2.640930630996625e-22,
 -1.269717088364411e-23, -2.906354603773469e-26,  1.605390264375311e+00, -3.339440551844124e-03, -1.228715940056278e-05,  1.409653824911295e-08,  3.449682247107912e-10,
  6.174921463967876e-13, -9.989962118964525e-15, -5.361140399703506e-17,  2.335147401183956e-19,  2.951235471927859e-21, -1.124560071206103e-24, -1.366443129206542e-25,
  1.708560281401335e+00, -2.817962166832174e-03, -1.412316064301973e-05, -1.723902849971174e-08,  3.002813282774945e-10,  2.018266985251654e-12, -1.535738735514393e-15,
 -9.139345089997093e-17, -3.942243980978176e-19,  2.214232249127459e-21,  3.031411959907468e-23,  4.694469514182640e-26,  1.804450040921381e+00, -2.143489213602768e-03,
 -1.395756812241124e-05, -4.949940802126068e-08,  7.992733933408722e-11,  2.344693458929014e-12,  1.325261330098635e-14, -1.014791546066080e-17, -7.134038213927450e-19,
 -4.829816149719394e-21,  7.934222334112054e-25,  2.667910324681653e-25,  1.887763135566850e+00, -1.374749549678729e-03, -1.110848586466348e-05, -6.470539164684839e-08,
 -2.194602495332119e-10,  4.847226608059574e-13,  1.409714881567916e-14,  1.125117996641372e-16,  3.895447096412019e-19, -2.108858105097822e-21, -4.302837022935973e-23,
 -3.217451033407642e-25,  1.952030252503888e+00, -6.412692949648626e-04, -6.095469795034966e-06, -4.776594079045165e-08, -3.137334592667956e-10, -1.629523544608013e-12,
 -4.965780011413799e-15,  1.896379620509908e-17,  4.779678675144767e-19,  4.826955717337254e-21,  3.344607771801191e-23,  1.449809267294073e-25,  1.990622392251553e+00,
 -1.322455483527405e-04, -1.384642052469915e-06, -1.271681384464795e-08, -1.076729992384393e-10, -8.570663445427105e-13, -6.460759507354993e-15, -4.613125248587002e-17,
 -3.100426192955329e-19, -1.931088639666194e-21, -1.076236564855963e-23, -4.882324686852969e-26,  };
  constexpr double w[12672] = {  9.370289772471747e-02, -3.744403548723544e-04,  1.585024452783533e-06, -6.989568145749841e-09,  3.160113307873448e-11,
 -1.447321545240400e-13,  6.661212428630931e-16, -3.066099222979898e-18,  1.407621437810248e-20, -6.436665222204380e-23,  2.929808787440554e-25, -1.327207616938276e-27,
  9.309843472265703e-02, -5.688254005423968e-04,  4.027150661491769e-06, -2.818399525289786e-08,  1.898744514837169e-10, -1.234779557666069e-12,  7.797421895589683e-15,
 -4.804646439213860e-17,  2.899225570083475e-19, -1.717834821704989e-21,  1.001525547723247e-23, -5.754790130690257e-26,  9.190595955338177e-02, -9.485075303785982e-04,
  9.984281277060435e-06, -9.505357213704011e-08,  8.386567394174123e-10, -6.989310245929006e-12,  5.566807010007826e-14, -4.270589373133435e-16,  3.173279671556812e-18,
 -2.293484122458893e-20,  1.617603479519765e-22, -1.116226589425150e-24,  9.015740665302831e-02, -1.495938571795808e-03,  2.144924239733667e-05, -2.645204138328994e-07,
  2.947704035587656e-09, -3.045968817049596e-11,  2.964790442410952e-13, -2.747086743928842e-15,  2.441414053956853e-17, -2.092924533673510e-19,  1.738215260902625e-21,
 -1.403357304712375e-23,  8.789835030108062e-02, -2.186301363384668e-03,  4.105061134797263e-05, -6.390775933870247e-07,  8.783694968878843e-09, -1.100584515598466e-10,
  1.282007039343861e-12, -1.406585736940137e-14,  1.467226322377441e-16, -1.465188399990684e-18,  1.408228839308608e-20, -1.308085287163107e-22,  8.518545372493298e-02,
 -2.989144901590687e-03,  7.167691490973841e-05, -1.380227487046183e-06,  2.297086236123622e-08, -3.431856994111397e-10,  4.709994408232324e-12, -6.030075117605163e-14,
  7.280614915341858e-16, -8.357366718112542e-18,  9.177569378971114e-20, -9.687980693980828e-22,  8.208343716730790e-02, -3.870304982357893e-03,  1.160603014286129e-04,
 -2.716554957945064e-06,  5.392020332703691e-08, -9.474840682730868e-10,  1.512920865680501e-11, -2.233706464334866e-13,  3.087065592305389e-15, -4.030332653092540e-17,
  5.005626753612443e-19, -5.946360968222066e-21,  7.866181957143047e-02, -4.793933891812574e-03,  1.763740122741749e-04, -4.941404996626363e-06,  1.154461007935159e-07,
 -2.358169327500881e-09,  4.334219111231625e-11, -7.306172329142668e-13,  1.144983316825677e-14, -1.685034454631627e-16,  2.346812753621582e-18, -3.111687245583223e-20,
  7.499168732143857e-02, -5.724466499373007e-03,  2.538930338816400e-04, -8.397068448945359e-06,  2.282168423144120e-07, -5.362835980023977e-09,  1.123838258381494e-10,
 -2.144059434674069e-12,  3.778826538301664e-14, -6.220049033554598e-16,  9.642439979458061e-18, -1.416881090726551e-19,  7.114271536949496e-02, -6.628373248602803e-03,
  3.487556204611486e-04, -1.344512740695680e-05,  4.205544157273158e-07, -1.126180753699020e-08,  2.667846961733710e-10, -5.714838398601037e-12,  1.124383669747921e-13,
 -2.055600041652124e-15,  3.523423104786682e-17, -5.701307164485407e-19,  6.718061754710830e-02, -7.475587887240879e-03,  4.598474320182800e-04, -2.042552597811823e-05,
  7.280706191210231e-07, -2.202440351358260e-08,  5.851450616347066e-10, -1.397170266435786e-11,  3.047858315707163e-13, -6.149246788361507e-15,  1.158348304461324e-16,
 -2.052052130346402e-18,  6.316514245798104e-02, -8.240542706456971e-03,  5.848127809753759e-04, -2.960936515707714e-05,  1.191736069194738e-06, -4.039418896013448e-08,
  1.194757449743288e-09, -3.158320403035850e-11,  7.590748308590522e-13, -1.680064078297892e-14,  3.458444924580316e-16, -6.671591452812850e-18,  5.914866808356836e-02,
 -8.902789771053833e-03,  7.201817131992846e-04, -4.115188023673341e-05,  1.854221148787631e-06, -6.988588786082051e-08,  2.285270414425820e-09, -6.645480221778266e-11,
  1.749234242858780e-12, -4.223457722221613e-14,  9.450508481651116e-16, -1.975174869543768e-17,  5.517539005096588e-02, -9.447227281679441e-03,  8.615895028892883e-04,
 -5.505230706910225e-05,  2.754678114962377e-06, -1.146193373649772e-07,  4.116624992330296e-09, -1.308907600882800e-10,  3.752036411387624e-12, -9.830046327088863e-14,
  2.378960387351875e-15, -5.361119780460269e-17,  5.128105126689655e-02, -9.863981719297442e-03,  1.004057817307475e-03, -7.112641855587762e-05,  3.922478900042104e-06,
 -1.789550048969522e-07,  7.015390151658342e-09, -2.424872731941013e-10,  7.529024847010572e-12, -2.129553190971764e-13,  5.547209916543377e-15, -1.341743655115853e-16,
  4.749312757469761e-02, -1.014801673948815e-02,  1.142304525400351e-03, -8.899568615928072e-05,  5.370704234984014e-06, -2.669300462969478e-07,  1.135387872627184e-08,
 -4.242770083982579e-10,  1.419523589841031e-11, -4.313544911590600e-13,  1.203833003433330e-14, -3.111526252167173e-16,  4.383136597017516e-02, -1.029854881703374e-02,
  1.271051271888769e-03, -1.080947043012738e-04,  7.090331916983781e-06, -3.815377046421849e-07,  1.750850837182186e-08, -7.035856501685313e-10,  2.523999599149559e-11,
 -8.201238965450471e-13,  2.441282813336374e-14, -6.714105997267979e-16,  4.030856737009694e-02, -1.031834882750588e-02,  1.385303350748740e-03, -1.276961522912154e-04,
  9.046060977264555e-06, -5.239365755311914e-07,  2.579776989438533e-08, -1.109156083625308e-09,  4.245751965572655e-11, -1.468473776670318e-12,  4.642293867705654e-14,
 -1.352919411324963e-15,  3.693151223437410e-02, -1.021300048260916e-02,  1.480583690141763e-03, -1.469505412560178e-04,  1.117453631958430e-05, -6.927093814723993e-07,
  3.640527316114743e-08, -1.666382349463139e-09,  6.774907084616723e-11, -2.483235891090488e-12,  8.302063481458307e-14, -2.553578746277664e-15,  3.370194112450335e-02,
 -9.990173562910874e-03,  1.553110555727070e-03, -1.649365610117158e-04,  1.338543998009871e-05, -8.833046537710415e-07,  4.929854448923508e-08, -2.390953575801040e-09,
  1.027787921028489e-10, -3.975165744212848e-12,  1.399733585303558e-13, -4.526157112894171e-15,  3.061752015634494e-02, -9.658954839521498e-03,  1.599915794908114e-03,
 -1.807171155125558e-04,  1.556554701305798e-05, -1.087784412550909e-06,  6.415819044213292e-08, -3.281751137742901e-09,  1.485020921284813e-10, -6.035348566338972e-12,
  2.229340566753969e-13, -7.549467205399371e-15,  2.767274034970859e-02, -9.229264607261365e-03,  1.618906342615094e-03, -1.933960916293254e-04,  1.758546985833168e-05,
 -1.294967036371753e-06,  8.033348821651957e-08, -4.314330431409060e-09,  2.046324088445358e-10, -8.703327490114766e-12,  3.359248349642033e-13, -1.186876437692718e-14,
  2.485971787622153e-02, -8.711373401879254e-03,  1.608875923445599e-03, -2.021714203507262e-04,  1.930849227645420e-05, -1.491002420908419e-06,  9.683866218397568e-08,
 -5.436594196877817e-09,  2.691567965896007e-10, -1.193213788956490e-11,  4.793906887322015e-13, -1.760653818315728e-14,  2.216887772921743e-02, -8.115522634694545e-03,
  1.569476369485364e-03, -2.063808825379802e-04,  2.060066388048054e-05, -1.660355160259566e-06,  1.123990278098739e-07, -6.568199431890974e-09,  3.380374936144677e-10,
 -1.555874438780709e-11,  6.482189160503723e-13, -2.465760431092494e-14,  1.958951567308638e-02, -7.451644880686107e-03,  1.501158914410464e-03, -2.055381914355453e-04,
  2.134120974756091e-05, -1.787111221867721e-06,  1.255485598607426e-07, -7.604780926183091e-09,  4.052315179894141e-10, -1.929010688369859e-11,  8.303192340203955e-13,
 -3.259614873414807e-14,  1.711024234008439e-02, -6.729174309611639e-03,  1.405095544429078e-03, -1.993579809719753e-04,  2.143230729305060e-05, -1.856474133916543e-06,
  1.347716162190719e-07, -8.427267782187886e-09,  4.631165991145696e-10, -2.271408752053590e-11,  1.006421107165668e-12, -4.063131063701124e-14,  1.471931930563889e-02,
 -5.956934895813060e-03,  1.283089356716375e-03, -1.877693140193049e-04,  2.080737934897601e-05, -1.856285399543759e-06,  1.386731826924799e-07, -8.915559810026670e-09,
  5.033333939822954e-10, -2.534017189913121e-11,  1.151592888784667e-12, -4.764594983920849e-14,  1.240490043612516e-02, -5.143093104105338e-03,  1.137481255223916e-03,
 -1.709181195816540e-04,  1.943722314049908e-05, -1.778394681807614e-06,  1.361557167504541e-07, -8.964831534915656e-09,  5.179563922506310e-10, -2.666807351431352e-11,
  1.238610212011522e-12, -5.233705976698213e-14,  1.015519357895253e-02, -4.295162295081702e-03,  9.710585220605228e-04, -1.491595432148757e-04,  1.733351109055943e-05,
 -1.619718715492952e-06,  1.265777066254498e-07, -8.501974012152364e-09,  5.008128655280439e-10, -2.627433684374362e-11,  1.242773565215448e-12, -5.344775264848198e-14,
  7.958559472605249e-03, -3.420048134135370e-03,  7.869691803333546e-04, -1.230415747925127e-04,  1.454943579173001e-05, -1.382861385313694e-06,  1.098700815115925e-07,
 -7.499362219406783e-09,  4.487064591920236e-10, -2.390034535867828e-11,  1.147249264159947e-12, -5.004771974665583e-14,  5.803574700006971e-03, -2.524130761117506e-03,
  5.886455505252741e-04, -9.328166079184094e-05,  1.117752073366623e-05, -1.076217446424880e-06,  8.659166360063628e-08, -5.983362433002418e-09,  3.622904412392697e-10,
 -1.952197360935016e-11,  9.476694876154895e-13, -4.179340414561057e-14,  3.679182452764934e-03, -1.613424665078352e-03,  3.797492760747047e-04, -6.073968042704554e-05,
  7.345024654533708e-06, -7.135583271061751e-07,  5.791449189910786e-08, -4.035850401737124e-09,  2.463893558365315e-10, -1.338326787053255e-11,  6.547399390881453e-13,
 -2.909284621800115e-14,  1.577101359847000e-03, -6.947622647706885e-04,  1.643629741727131e-04, -2.642504525176687e-05,  3.211733578858075e-06, -3.135664269938244e-07,
  2.557326502086333e-08, -1.790506857415297e-09,  1.098115107824487e-10, -5.991240617871007e-12,  2.943722339841723e-13, -1.313494830867940e-14,  9.222997734102185e-02,
 -3.620872775036702e-04,  1.504090556675031e-06, -6.506266839283727e-09,  2.885965942971500e-11, -1.297266174080972e-13,  5.862437444352501e-16, -2.650583105245212e-18,
  1.195662182301682e-20, -5.373557477053578e-23,  2.404382929787754e-25, -1.070868534744115e-27,  9.088549606525675e-02, -5.379111941736939e-04,  3.706387441676938e-06,
 -2.533384016696968e-08,  1.669464574807007e-10, -1.062791179745764e-12,  6.573233127767126e-15, -3.968578787543011e-17,  2.347208471136510e-19, -1.363576071420825e-21,
  7.796606096400306e-24, -4.394648458153606e-26,  8.826476246886665e-02, -8.729779085019746e-04,  8.919761023397497e-06, -8.268463129250284e-08,  7.113185217801229e-10,
 -5.786014310740917e-12,  4.501630247043902e-14, -3.375657115387120e-16,  2.453163064846921e-18, -1.734869601608327e-20,  1.197774632231458e-22, -8.093687986508848e-25,
  8.449781058293018e-02, -1.336283747622530e-03,  1.853905813277571e-05, -2.218687393509911e-07,  2.403863214319526e-09, -2.418544113698196e-11,  2.294545680625070e-13,
 -2.074088179343722e-15,  1.799543693294820e-17, -1.506983426720385e-19,  1.223279229552673e-21, -9.657503324746670e-24,  7.976455002845574e-02, -1.886340087833791e-03,
  3.415734737175531e-05, -5.146010388330542e-07,  6.860854703128027e-09, -8.353097430461746e-11,  9.466796337072476e-13, -1.011630158091269e-14,  1.028665014116611e-16,
 -1.002108759714080e-18,  9.402011968190903e-21, -8.530228376131838e-23,  7.427898754042819e-02, -2.476216835656249e-03,  5.711131848656624e-05, -1.061991593787421e-06,
  1.711329727098477e-08, -2.480288049167858e-10,  3.307121287701994e-12, -4.118384013145561e-14,  4.841490917379072e-16, -5.415742302137094e-18,  5.799855857889362e-20,
 -5.974651907478902e-22,  6.827167997575326e-02, -3.058872712219023e-03,  8.807118597609922e-05, -1.987642230588096e-06,  3.814739465596710e-08, -6.494869490597378e-10,
  1.006456042782936e-11, -1.443945401985750e-13,  1.941297651557866e-15, -2.467844105722778e-17,  2.986922773536724e-19, -3.460400081929249e-21,  6.197255072517870e-02,
 -3.591976854278620e-03,  1.267693072201762e-04, -3.421332765349247e-06,  7.722015142849730e-08, -1.527059538809228e-09,  2.721764548772289e-11, -4.455408781347990e-13,
  6.788308779644155e-15, -9.722412770690592e-17,  1.318960070612890e-18, -1.704839506580667e-20,  5.559590750002349e-02, -4.041598126839257e-03,  1.719218838271643e-04,
 -5.475298360149633e-06,  1.436967041782175e-07, -3.267688434403192e-09,  6.638055215583145e-11, -1.229369980961008e-12,  2.105901359759623e-14, -3.372623850015683e-16,
  5.091647131697347e-18, -7.292349135515974e-20,  4.932895674772237e-02, -4.384404519168666e-03,  2.213486403095768e-04, -8.218138192412671e-06,  2.482282927357016e-07,
 -6.432327222710181e-09,  1.477043729817736e-10, -3.071366064418758e-12,  5.873170274049857e-14, -1.044709216343789e-15,  1.743957883120779e-17, -2.750666386506792e-19,
  4.332445285090684e-02, -4.608306269916271e-03,  2.722506028676860e-04, -1.165279103643022e-05,  4.012611398151443e-07, -1.174977710489591e-08,  3.026811074255325e-10,
 -7.017510808708791e-12,  1.488244858369120e-13, -2.922252440171771e-15,  5.362544020774989e-17, -9.262750877959558e-19,  3.769748402322330e-02, -4.711729422493378e-03,
  3.215769663499456e-04, -1.570430550756948e-05,  6.110842416589353e-07, -2.006308491462958e-08,  5.757209206928725e-10, -1.478564488450712e-11,  3.456560238662810e-13,
 -7.449471307248508e-15,  1.494643136741020e-16, -2.812724699551577e-18,  3.252588686149836e-02, -4.701878138844711e-03,  3.664033349723154e-04, -2.022067135515152e-05,
  8.818068956595477e-07, -3.222377824958208e-08,  1.023192754460115e-09, -2.893022859835238e-11,  7.412845715755038e-13, -1.744089480319541e-14,  3.806515127625391e-16,
 -7.766554457832606e-18,  2.785345634983297e-02, -4.592417941577610e-03,  4.042537413171124e-04, -2.498669017462614e-05,  1.211732227309869e-06, -4.894431137054624e-08,
  1.708865466717810e-09, -5.288572660347722e-11,  1.477207107744385e-12, -3.774927989975230e-14,  8.918937243760932e-16, -1.963914404598006e-17,  2.369498744920252e-02,
 -4.400996542121464e-03,  4.333215636531121e-04, -2.974783405631309e-05,  1.592529575063616e-06, -7.063394849843694e-08,  2.695439389380181e-09, -9.079850430494324e-11,
  2.750386340398659e-12, -7.596607732537914e-14,  1.934004553901716e-15, -4.575703535545758e-17,  2.004221938663903e-02, -4.146939206259250e-03,  4.525717317545117e-04,
 -3.423910849824431e-05,  2.009427454285415e-06, -9.725238644066382e-08,  4.032955870904114e-09, -1.470852334602296e-10,  4.807546827720153e-12, -1.428436836186472e-13,
  3.901144381007392e-15, -9.874926132643609e-17,  1.686990340466919e-02, -3.849343364522054e-03,  4.617312245995393e-04, -3.821346144060267e-05,  2.442411367968296e-06,
 -1.282150835124842e-07,  5.745971698129917e-09, -2.257179757902921e-10,  7.922452299147441e-12, -2.520729648048179e-13,  7.353085700264705e-15, -1.983165084908818e-16,
  1.414142268272066e-02, -3.525681572361463e-03,  4.611921376714619e-04, -4.146512871532444e-05,  2.868191440248435e-06, -1.623743033495953e-07,  7.822093177127796e-09,
 -3.293179519533559e-10,  1.235405717196229e-11, -4.190614684170247e-13,  1.300175622796543e-14, -3.721261384658271e-16,  1.181361041892212e-02, -3.190923997096721e-03,
  4.518598771280190e-04, -4.384500269786564e-05,  3.262563104562209e-06, -1.980834619517866e-07,  1.020450344408201e-08, -4.582158650042790e-10,  1.828860212003547e-11,
 -6.585203590860950e-13,  2.164135292897401e-14, -6.547276749852035e-16,  9.840604062741860e-03, -2.857122327936293e-03,  4.349792025700818e-04, -4.526706580107344e-05,
  3.602746738776482e-06, -2.333345859546511e-07,  1.279043949193294e-08, -6.096793830089146e-10,  2.577451122193047e-11, -9.809771507891282e-13,  3.401026167874867e-14,
 -1.083415453692191e-15,  8.176721741596929e-03, -2.533358355996244e-03,  4.119652892845226e-04, -4.570663787213163e-05,  3.869351259539848e-06, -2.659445731128199e-07,
  1.543637973117207e-08, -7.775004678294618e-10,  3.466342349082816e-11, -1.388715950680049e-12,  5.059120536647171e-14, -1.690502233862811e-15,  6.778445983359543e-03,
 -2.225948187518798e-03,  3.842585618347785e-04, -4.519233948700854e-05,  4.047729592665418e-06, -2.937587615952072e-07,  1.796934333812555e-08, -9.520759136287461e-10,
  4.457213285660583e-11, -1.871985683112887e-12,  7.137966652289855e-14, -2.492526945155174e-15,  5.605654311600398e-03, -1.938799740512696e-03,  3.532132476367670e-04,
 -4.379418440961337e-05,  4.128638784617334e-06, -3.148408363545804e-07,  2.020255333437653e-08, -1.121019784336726e-09,  5.487779924110070e-11, -2.406480473451816e-12,
  9.567226284427486e-14, -3.478271588219030e-15,  4.622255642915985e-03, -1.673838918665168e-03,  3.200221067309069e-04, -4.161016921481424e-05,  4.108247455293017e-06,
 -3.276248693083923e-07,  2.195304442702863e-08, -1.270242709564540e-09,  6.475295009312762e-11, -2.952999827351033e-12,  1.219378092004583e-13, -4.598656153890267e-15,
  3.796386562100746e-03, -1.431441916912179e-03,  2.856744428811863e-04, -3.875330565422303e-05,  3.987624940488128e-06, -3.310155392689689e-07,  2.305869945048948e-08,
 -1.385347040961231e-09,  7.323901346181124e-11, -3.459834542804214e-12,  1.478279471955167e-13, -5.762092523716957e-15,  3.100302484309762e-03, -1.210832692908370e-03,
  2.509414127792699e-04, -3.534044054900283e-05,  3.771891913681769e-06, -3.244333259838022e-07,  2.339260149508390e-08, -1.453137485565067e-09,  7.934942617374813e-11,
 -3.867877729250294e-12,  1.703602227775998e-13, -6.838327410360207e-15,  2.510073302760130e-03, -1.010422944443030e-03,  2.163814903336681e-04, -3.148359490014582e-05,
  3.469216097335171e-06, -3.078103727569206e-07,  2.287330751825794e-08, -1.463040397611431e-09,  8.218759494139220e-11, -4.117866913757931e-12,  1.862691368918486e-13,
 -7.672139283959913e-15,  2.005166808019162e-03, -8.280858246517932e-04,  1.823591717395613e-04, -2.728403769914422e-05,  3.089810713441920e-06, -2.815484649826948e-07,
  2.147046360721657e-08, -1.408255884006216e-09,  8.106230855046321e-11, -4.158672511925745e-12,  1.924794471096743e-13, -8.105822562032069e-15,  1.567979227425982e-03,
 -6.613641164108137e-04,  1.490710685361271e-04, -2.282894185155165e-05,  2.645051479141087e-06, -2.464529270211442e-07,  1.920590405624969e-08, -1.286521913333771e-09,
  7.558384961712027e-11, -3.955275602178182e-12,  1.866219518840232e-13, -8.006853418923761e-15,  1.183352381268266e-03, -5.076193913325065e-04,  1.165749805922074e-04,
 -1.819025711735791e-05,  2.146782601913335e-06, -2.036557400710567e-07,  1.615089001638359e-08, -1.100433111909128e-09,  6.572748651145601e-11, -3.495077751958606e-12,
  1.674944284475597e-13, -7.295246681648068e-15,  8.381026437186453e-04, -3.641321749032586e-04,  8.481914988997930e-05, -1.342537186426364e-05,  1.606843886525995e-06,
 -1.545389487401736e-07,  1.242042571128819e-08, -8.573166132936450e-10,  5.185627683679220e-11, -2.791447492363678e-12,  1.353743432692460e-13, -5.964502184668894e-15,
  5.205887844827891e-04, -2.281700720413673e-04,  5.367161603646998e-05, -8.579368914790076e-06,  1.036846448657000e-06, -1.006686173872924e-07,  8.165844051947641e-09,
 -5.687273105611788e-10,  3.470181306884589e-11, -1.883907284507032e-12,  9.211686061960301e-14, -4.091059143712697e-15,  2.206229419162902e-04, -9.716649830814656e-05,
  2.298046305569004e-05, -3.693539248707561e-06,  4.487859689631110e-07, -4.380297717779267e-08,  3.571383390302954e-09, -2.499796009008051e-10,  1.532698929959895e-11,
 -8.360038590020561e-13,  4.106511149838210e-14, -1.831857090963842e-15,  9.080521003187858e-02, -3.503591963711877e-04,  1.428702671511825e-06, -6.064528563309431e-09,
  2.640003015253099e-11, -1.165058516279578e-13,  5.171058861156321e-16, -2.297155017843819e-18,  1.018448432233355e-20, -4.499704753148278e-23,  1.979707420503281e-25,
 -8.671179693241320e-28,  8.879129016131630e-02, -5.094322711016666e-04,  3.417733545975558e-06, -2.282453503921412e-08,  1.471824040019596e-10, -9.175625548690715e-13,
  5.560214525524295e-15, -3.290353607316614e-17,  1.908093575247574e-19, -1.087165633714598e-21,  6.098230371170379e-24, -3.372923622782957e-26,  8.490954499209763e-02,
 -8.054036326737966e-04,  7.992194993321615e-06, -7.217365708702056e-08,  6.056800600407237e-10, -4.810720165143350e-12,  3.657579875000386e-14, -2.681980357324134e-16,
  1.906912111230858e-18, -1.320011161146195e-20,  8.924133484809331e-23, -5.907068288763583e-25,  7.943331544884560e-02, -1.198002042674568e-03,  1.609235968742134e-05,
 -1.869960253937411e-07,  1.970835649232192e-09, -1.931504830554668e-11,  1.786892821259779e-13, -1.576365046505523e-15,  1.335749786187609e-17, -1.093112145070447e-19,
  8.675649535070276e-22, -6.699816788135389e-24,  7.272907427892523e-02, -1.636035405421996e-03,  2.858939737063394e-05, -4.170478671246957e-07,  5.396284370231208e-09,
 -6.386868500976518e-11,  7.045618560476597e-13, -7.335957104669546e-15,  7.274392215964413e-17, -6.915764987211702e-19,  6.336115169260357e-21, -5.616735255027618e-23,
  6.521329745250885e-02, -2.065997879411689e-03,  4.585956597988835e-05, -8.239136928839069e-07,  1.286136309831233e-08, -1.809103087968472e-10,  2.344479912929633e-12,
 -2.840958847214827e-14,  3.252983301715347e-16, -3.547213217831976e-18,  3.705859548858827e-20, -3.726564053333076e-22,  5.730771397880503e-02, -2.440242259272305e-03,
  6.749200703089355e-05, -1.469335742418124e-06,  2.727873694511329e-08, -4.501796098221991e-10,  6.772517527592780e-12, -9.445003009697982e-14,  1.235680107546699e-15,
 -1.530012966573950e-17,  1.805159663513221e-19, -2.040074749094472e-21,  4.939979001309337e-02, -2.723152428809880e-03,  9.222294662164113e-05, -2.398486098828501e-06,
  5.231506266937603e-08, -1.001894573840285e-09,  1.732238421242161e-11, -2.754400686096798e-13,  4.081153781682700e-15, -5.689947805652380e-17,  7.520682961538998e-19,
 -9.478522720780956e-21,  4.181341719489853e-02, -2.894409385180672e-03,  1.181079359629574e-04, -3.622885602253430e-06,  9.183666027520785e-08, -2.021428653448749e-09,
  3.981500742615834e-11, -7.159610370203582e-13,  1.192248527010478e-14, -1.858108244951677e-16,  2.732339762556335e-18, -3.814848790334332e-20,  3.479218380945796e-02,
 -2.949224780600370e-03,  1.428678869080808e-04, -5.108871958291508e-06,  1.490308636608823e-07, -3.737493003199087e-09,  8.320209042292042e-11, -1.679661883905386e-12,
  3.122084095338490e-14, -5.403984188529853e-16,  8.786447508255770e-18, -1.350976931634338e-19,  2.849503103309999e-02, -2.896084006625513e-03,  1.643001689891502e-04,
 -6.776119525157425e-06,  2.254102569108957e-07, -6.389330819798064e-09,  1.595947392244090e-10, -3.592864421737594e-12,  7.407817136677301e-14, -1.415666345312956e-15,
  2.530809096908794e-17, -4.262413387830624e-19,  2.300210961066077e-02, -2.752941228290872e-03,  1.806429350243591e-04, -8.507394756859217e-06,  3.200027779576419e-07,
 -1.017571173014558e-08,  2.832675561137389e-10, -7.067172584483154e-12,  1.606927501469370e-13, -3.372020129560145e-15,  6.593744418493153e-17, -1.210417857007318e-18,
  1.832755252037244e-02, -2.542898341096263e-03,  1.908122148621378e-04, -1.016702856331757e-05,  4.290104326216097e-07, -1.519680762496067e-08,  4.684721264076518e-10,
 -1.287682308784105e-11,  3.211318196307287e-13, -7.361465777088482e-15,  1.566862246172433e-16, -3.120465638261824e-18,  1.443567281607962e-02, -2.290234393940095e-03,
  1.944796560195208e-04, -1.162303321073657e-05,  5.460844272138472e-07, -2.140538425001994e-08,  7.263128224043236e-10, -2.187257808059588e-11,  5.951657353841447e-13,
 -1.483131954374375e-14,  3.420244954585586e-16, -7.357175928094047e-18,  1.125757469534820e-02, -2.017342940754453e-03,  1.920050617042231e-04, -1.276721284506833e-05,
  6.631715811578398e-07, -2.858320202707987e-08,  1.061370410056916e-09, -3.483148573278893e-11,  1.028976702140161e-12, -2.774397047828671e-14,  6.901206904666557e-16,
 -1.596623950195443e-17,  8.706024984795042e-03, -1.742799415114254e-03,  1.842687741236079e-04, -1.352890351383974e-05,  7.717159419863251e-07, -3.635184627457577e-08,
  1.469002161072978e-09, -5.226587772112514e-11,  1.668225879470082e-12, -4.844713271580114e-14,  1.294302057241062e-15, -3.207420302444359e-17,  6.687378709647049e-03,
 -1.480506110729942e-03,  1.724598838094169e-04, -1.388033443172700e-05,  8.639133332320106e-07, -4.421702702961627e-08,  1.934166737748163e-09, -7.423577199684306e-11,
  2.548131260622053e-12, -7.935403821710909e-14,  2.267410065499874e-15, -5.994581741552946e-17,  5.110174213161375e-03, -1.239690869303577e-03,  1.578701867407286e-04,
 -1.383403029627848e-05,  9.337348705016603e-07, -5.163576947453233e-08,  2.432228233810583e-09, -1.002165307417628e-10,  3.682470377735281e-12, -1.224470722937269e-13,
  3.726701941666588e-15, -1.047042220512305e-16,  3.890601695476230e-03, -1.025468560150490e-03,  1.417278193963752e-04, -1.343441225758984e-05,  9.775345562112345e-07,
 -5.809033794292011e-08,  2.931636696305281e-09, -1.290634779638931e-10,  5.054236107959395e-12, -1.786856843856158e-13,  5.769440361235436e-15, -1.715985781475131e-16,
  2.955385200319781e-03, -8.396874165491124e-04,  1.250860522887752e-04, -1.274648462850880e-05,  9.941878468002730e-07, -6.315263827641281e-08,  3.397874630245127e-09,
 -1.590902697851590e-10,  6.610634640329120e-12, -2.474536114007766e-13,  8.442703625443049e-15, -2.648210162508198e-16,  2.242741728846221e-03, -6.818414833834246e-04,
  1.087672577819293e-04, -1.184431268807419e-05,  9.848248251051323e-07, -6.652737856574783e-08,  3.797773865633520e-09, -1.882474102193026e-10,  8.264165390338737e-12,
 -3.261967139559808e-13,  1.171400021764787e-14, -3.860402521093584e-16,  1.702057574821756e-03, -5.499051698492252e-04,  9.335216624846043e-05, -1.080124337269345e-05,
  9.522933710078801e-07, -6.806912424672405e-08,  4.103311135752973e-09, -2.143623406051081e-10,  9.899988974030942e-12, -4.103704183654299e-13,  1.545065442626882e-14,
 -5.329749727529590e-16,  1.292816869151908e-03, -4.410149613202795e-04,  7.920030963475520e-05, -9.682880976118214e-06,  9.005075125881683e-07, -6.777501206915550e-08,
  4.294235486589532e-09, -2.353907401341308e-10,  1.138821905488787e-11, -4.937440518177024e-13,  1.941487093615575e-14, -6.984093122594682e-16,  9.831827988486367e-04,
 -3.519759318639115e-04,  6.648768043085290e-05, -8.542999583409939e-06,  8.338147542685063e-07, -6.575948722676547e-08,  4.359246217140907e-09, -2.496319655326192e-10,
  1.259868525179782e-11, -5.690228673298574e-13,  2.327806737775784e-14, -8.700114229334029e-16,  7.485020350661332e-04, -2.796042847072820e-04,  5.525028837962211e-05,
 -7.422005804711129e-06,  7.564725315777460e-07, -6.221933979048934e-08,  4.295796011144831e-09, -2.558763722477077e-10,  1.341539103468425e-11, -6.286759631373521e-13,
  2.665354676346754e-14, -1.031155424610969e-15,  5.698951500533665e-04, -2.209342212733832e-04,  4.542586429493366e-05, -6.347284687506827e-06,  6.722762566103569e-07,
 -5.739687065181677e-08,  4.108847456115359e-09, -2.534720831621287e-10,  1.374831215518421e-11, -6.658204463743304e-13,  2.914232686135141e-14, -1.162713896654786e-15,
  4.330158101181171e-04, -1.733225808968077e-04,  3.688934261262506e-05, -5.334713237852131e-06,  5.843421251878146e-07, -5.154708799573310e-08,  3.809026403392111e-09,
 -2.423171356355248e-10,  1.354109150110810e-11, -6.750153095913822e-13,  3.038419698509570e-14, -1.245555046713647e-15,  3.270076651983569e-04, -1.344825823554436e-04,
  2.948039447747006e-05, -4.390723845174785e-06,  4.950224236877621e-07, -4.491238118130361e-08,  3.410606501761704e-09, -2.227955395860819e-10,  1.277423658495426e-11,
 -6.528546487329472e-13,  3.010542899524480e-14, -1.263313841717233e-15,  2.436551146361508e-04, -1.024723929956938e-04,  2.302303754080378e-05, -3.514463113157746e-06,
  4.059194440417876e-07, -3.770587555479215e-08,  2.929667974907451e-09, -1.956811682803134e-10,  1.146431348576395e-11, -5.983027498212479e-13,  2.815587325778371e-14,
 -1.204949192790519e-15,  1.767067180225605e-04, -7.565769940649032e-05,  1.733832108272726e-05, -2.699761921516583e-06,  3.179631441637409e-07, -3.010304228791725e-08,
  2.382648552644566e-09, -1.620324923760420e-10,  9.660181600192126e-12, -5.127659928349501e-13,  2.453072890048635e-14, -1.066651808608436e-15,  1.213428471705267e-04,
 -5.266146313963865e-05,  1.225149581836650e-05, -1.936779546940085e-06,  2.315235456517779e-07, -2.224024737533061e-08,  1.785385912461797e-09, -1.230962758123179e-10,
  7.437501431026699e-12, -3.999364451558750e-13,  1.937523805722007e-14, -8.528021468934510e-16,  7.375965664118152e-05, -3.230992627736628e-05,  7.595300559896435e-06,
 -1.213321955801024e-06,  1.465409956035561e-07, -1.421897522909372e-08,  1.152685945519918e-09, -8.023357926011550e-11,  4.892748265369649e-12, -2.654698601766488e-13,
  1.297346680525027e-14, -5.758649480722113e-16,  3.088289586850412e-05, -1.359779630704173e-05,  3.214992990530986e-06, -5.165721130728288e-07,  6.274731703478085e-08,
 -6.122500420357922e-09,  4.990373048026084e-10, -3.492003318620000e-11,  2.140438350163935e-12, -1.167164851306153e-13,  5.731617634085302e-15, -2.556104656896792e-16,
  8.942618149449036e-02, -3.392136643758507e-04,  1.358387963840540e-06, -5.660115936054414e-09,  2.418899275431306e-11, -1.048317712827412e-13,  4.571151498312910e-16,
 -1.995713036519539e-18,  8.698399369120284e-21, -3.779077489640104e-23,  1.635258565718180e-25, -7.045579673158317e-28,  8.680656488573064e-02, -4.831472958970987e-04,
  3.157385704366177e-06, -2.060947733974908e-08,  1.300943974626730e-10, -7.945175771665469e-13,  4.718833934532217e-15, -2.737952010291529e-17,  1.557268521603749e-19,
 -8.704901862116948e-22,  4.791663149112538e-24, -2.601371512999210e-26,  8.181054369927551e-02, -7.447726779066424e-04,  7.181229125374291e-06, -6.320723109146204e-08,
  5.176694342086851e-10, -4.016535799683977e-12,  2.985374393142882e-14, -2.141389421520397e-16,  1.490159787305247e-18, -1.010033231102896e-20,  6.688807144824971e-23,
 -4.338394675970775e-25,  7.488529324889610e-02, -1.077730823246210e-03,  1.402557544706492e-05, -1.583342342446703e-07,  1.624079938160019e-09, -1.551127368015660e-11,
  1.399882367938907e-13, -1.205727383060743e-15,  9.981912708128183e-18, -7.985514628181370e-20,  6.198834498005334e-22, -4.684212979302275e-24,  6.661261867567775e-02,
 -1.425962174563132e-03,  2.406350896119943e-05, -3.400729423681781e-07,  4.272635387291485e-09, -4.918240838731208e-11,  5.283241467471448e-13, -5.362039106261613e-15,
  5.187060121787490e-17, -4.814187274551918e-19,  4.308549819483876e-21, -3.732973875885256e-23,  5.762504124862218e-02, -1.735427301063366e-03,  3.709710364971684e-05,
 -6.442710442160315e-07,  9.747012467415265e-09, -1.331206410749952e-10,  1.677415509537632e-12, -1.978639705744086e-14,  2.207520072897533e-16, -2.347387451708279e-18,
  2.393147514036724e-20, -2.349887262508285e-22,  4.852458760981460e-02, -1.964045557282744e-03,  5.220794882470362e-05, -1.096898162879295e-06,  1.970743736338841e-08,
 -3.153693251276699e-10,  4.607700784935171e-12, -6.248601959567029e-14,  7.957765439087186e-16, -9.600135063973825e-18,  1.104430729138781e-19, -1.217914104335781e-21,
  3.981871387041536e-02, -2.087654634515149e-03,  6.786870410874766e-05, -1.701538875056880e-06,  3.587877796425182e-08, -6.656514409440967e-10,  1.116758346025033e-11,
 -1.725395431531226e-13,  2.486830746180463e-15, -3.375959696386085e-17,  4.348544427573492e-19, -5.345135956808798e-21,  3.188176875583943e-02, -2.101231036627581e-03,
  8.226674844303754e-05, -2.431121519314775e-06,  5.953897440016354e-08, -1.268820367824017e-09,  2.423705213291785e-11, -4.232732098136672e-13,  6.853493690550736e-15,
 -1.039625180985376e-16,  1.489342485419529e-18, -2.027430999917665e-20,  2.494343461980510e-02, -2.016019116806941e-03,  9.371382629933862e-05, -3.228049265687076e-06,
  9.095519357638972e-08, -2.207925225004272e-09,  4.765750434812483e-11, -9.341792472622845e-13,  1.688080595781122e-14, -2.843570867553419e-16,  4.503735418824309e-18,
 -6.751292528117275e-20,  1.909978315393976e-02, -1.854136642052015e-03,  1.010002426260451e-04, -4.013662693407737e-06,  1.289850988483476e-07, -3.539310951279771e-09,
  8.572565846416833e-11, -1.874043176056694e-12,  3.756716138208338e-14, -6.987567158806179e-16,  1.216991055055021e-17, -1.998598759437622e-19,  1.433921962167587e-02,
 -1.642475239776593e-03,  1.035935420069692e-04, -4.704185019322608e-06,  1.710302852539715e-07, -5.267049528436561e-09,  1.422305855779846e-10, -3.447006237343640e-12,
  7.622911644265380e-14, -1.557433478019448e-15,  2.967996896343562e-17, -5.314487208402967e-19,  1.057489307422564e-02, -1.407390895219109e-03,  1.016510697646035e-04,
 -5.227917642970918e-06,  2.134036100962936e-07, -7.326341519850552e-09,  2.192292832829080e-10, -5.857205801083986e-12,  1.421502041382207e-13, -3.174457030767913e-15,
  6.588544302684922e-17, -1.280597073432318e-18,  7.676514366823256e-03, -1.171046590110700e-03,  9.587988386569406e-05, -5.538441575910153e-06,  2.520130300761076e-07,
 -9.583530047026201e-09,  3.159409545496328e-10, -9.255970024940209e-12,  2.452990621488059e-13, -5.959618506846651e-15,  1.341154651888984e-16, -2.817668981158640e-18,
  5.496953938332626e-03, -9.496109301423606e-04,  8.731393147924880e-05, -5.620594151871222e-06,  2.831498628782919e-07, -1.185462599916274e-08,  4.281804053971631e-10,
 -1.368491485965933e-11,  3.941463639797035e-13, -1.037117835764044e-14,  2.519876805695933e-16, -5.699209562050752e-18,  3.891537648780532e-03, -7.530310787811846e-04,
  7.708236027034899e-05, -5.488813140983035e-06,  3.041480496601619e-07, -1.393746670206345e-08,  5.486029393096801e-10, -1.903368853957144e-11,  5.930225119393244e-13,
 -1.682667483619908e-14,  4.395901038506284e-16, -1.066099945541132e-17,  2.729984938177818e-03, -5.858587874774978e-04,  6.622321941339967e-05, -5.179784433073238e-06,
  3.137501153085720e-07, -1.564800066093723e-08,  6.677555529531711e-10, -2.502892207986555e-11,  8.397816375269074e-13, -2.558614286058632e-14,  7.158181509329349e-16,
 -1.854374670217923e-17,  1.902181791364087e-03, -4.485856873967879e-04,  5.556800498293262e-05, -4.742450456837713e-06,  3.121312505527508e-07, -1.685055489218000e-08,
  7.756501354363386e-10, -3.126141009260197e-11,  1.124584069839602e-12, -3.663791952937751e-14,  1.093345080453537e-15, -3.014079093793913e-17,  1.319493550822696e-03,
 -3.390570170028325e-04,  4.569683985781586e-05, -4.228296158525385e-06,  3.006407964990993e-07, -1.747502839270404e-08,  8.634162898742249e-10, -3.724578349861641e-11,
  1.430318831382320e-12, -4.962333015118516e-14,  1.573410218090926e-15, -4.598519622233865e-17,  9.133029606036781e-04, -2.536957500421431e-04,  3.694805253534160e-05,
 -3.683877851873766e-06,  2.813831001303725e-07, -1.751889924828920e-08,  9.246074299679200e-10, -4.249657845279238e-11,  1.734671665059183e-12, -6.382853832765146e-14,
  2.141975438253120e-15, -6.612349415424782e-17,  6.321462361790388e-04, -1.884196481520715e-04,  2.946028391799045e-05, -3.146381425020717e-06,  2.567683790674449e-07,
 -1.703650525016961e-08,  9.558917597353867e-10, -4.660072539535782e-11,  2.013324990341518e-12, -7.825218849757567e-14,  2.768598049069317e-15, -8.994087544764486e-17,
  4.384111339389320e-04, -1.392415848178743e-04,  2.322721595080319e-05, -2.642033006613028e-06,  2.291329553436839e-07, -1.612075479047004e-08,  9.570741425061245e-10,
 -4.926976729460950e-11,  2.243464852188336e-12, -9.173432092512867e-14,  3.408634715326628e-15, -1.160975863233730e-16,  3.051808466081300e-04, -1.026035448428511e-04,
  1.815075606657173e-05, -2.186633279017293e-06,  2.004803366246371e-07, -1.488288865088954e-08,  9.305778313629167e-10, -5.036314428704871e-11,  2.406763160104664e-12,
 -1.031147830899570e-13,  4.008416712158321e-15, -1.426085609891697e-16,  2.135139114643468e-04, -7.551645204704251e-05,  1.408486830209807e-05, -1.787331030929740e-06,
  1.723504224547191e-07, -1.343470206280333e-08,  8.806142773897342e-10, -4.988287662741044e-11,  2.491257198685040e-12, -1.113839423472262e-13,  4.512210039376632e-15,
 -1.670583416342250e-16,  1.502540357633407e-04, -5.557552851955708e-05,  1.086737729024765e-05, -1.444864407257435e-06,  1.457947030774040e-07, -1.187568488625669e-08,
  8.122782615545402e-10, -4.794675185390138e-11,  2.491925486941304e-12, -1.157952013371639e-13,  4.869387286577873e-15, -1.869066231448090e-16,  1.063504137479269e-04,
 -4.090689340126773e-05,  8.340362445482748e-06, -1.155732148320884e-06,  1.214226587342586e-07, -1.028567250253547e-08,  7.307508305168216e-10, -4.475018692299081e-11,
  2.410109360878292e-12, -1.159231989857370e-13,  5.040369342975275e-15, -1.998192476004590e-16,  7.561556230063673e-05, -3.008429259667892e-05,  6.361363852296935e-06,
 -9.139998307734385e-07,  9.948484694929557e-08, -8.722294472558341e-09,  6.407116931364349e-10, -4.052652663234356e-11,  2.252153063719616e-12, -1.116674110138267e-13,
  5.000412434226329e-15, -2.039601183978622e-16,  5.383168069680647e-05, -2.203995235788448e-05,  4.808029922842663e-06, -7.126370919494978e-07,  7.996564838849561e-08,
 -7.221874131548482e-09,  5.459873747353462e-10, -3.551292922713233e-11,  2.027704030718664e-12, -1.032130189530305e-13,  4.740977639355245e-15, -1.981975741084674e-16,
  3.812083328544811e-05, -1.598235638292324e-05,  3.578568962742644e-06, -5.444033689314078e-07,  6.266831829638763e-08, -5.802344666082879e-09,  4.494088948327778e-10,
 -2.992566270813396e-11,  1.748059851873627e-12, -9.096695024821262e-14,  4.268994644827533e-15, -1.822051570578293e-16,  2.650737799800913e-05, -1.132630861190817e-05,
  2.589822125594360e-06, -4.023599671801727e-07,  4.728368390912142e-08, -4.466990647594670e-09,  3.528268160196257e-10, -2.394571478110121e-11,  1.424826221455701e-12,
 -7.548713121897033e-14,  3.604679583988640e-15, -1.564617279995625e-16,  1.761631281962506e-05, -7.636241906257105e-06,  1.774202646556453e-06, -2.801039228653824e-07,
  3.344020274207961e-08, -3.208202244840747e-09,  2.572275800630049e-10, -1.771368280941524e-11,  1.069017064728434e-12, -5.741917917756947e-14,  2.778662927195393e-15,
 -1.221729919311145e-16,  1.046540997172508e-05, -4.581547651077147e-06,  1.076287657560156e-06, -1.718161804013028e-07,  2.073746567090853e-08, -2.010848583067221e-09,
  1.629083404904839e-10, -1.133226397066532e-11,  6.906349101736695e-13, -3.745008948649095e-14,  1.829120665618257e-15, -8.114520360020371e-17,  4.325866876452009e-06,
 -1.904159695480001e-06,  4.500685167861065e-07, -7.229212757911688e-08,  8.778441388244520e-09, -8.562785430963338e-10,  6.977268171517803e-11, -4.880851094197436e-12,
  2.990849341423318e-13, -1.630411815207569e-14,  8.004201209267933e-16, -3.568599337911819e-17,  8.809063995885361e-02, -3.286118223877222e-04,  1.292721407213137e-06,
 -5.289287506207643e-09,  2.219769606841644e-11, -9.450132724847188e-14,  4.049362054575145e-16, -1.737927500248419e-18,  7.448570721741802e-21, -3.182934276568637e-23,
  1.354930323284737e-25, -5.743885895154395e-28,  8.492297596599876e-02, -4.588432484412926e-04,  2.922055900607312e-06, -1.864918731357729e-08,  1.152772613046478e-10,
 -6.899296599810837e-13,  4.017513230574528e-15, -2.286279787288455e-17,  1.275803284674336e-19, -6.998750808012269e-22,  3.781689537638574e-24, -2.015770403078156e-26,
  7.894173994672735e-02, -6.902218478651754e-04,  6.469908460698279e-06, -5.553018237741914e-08,  4.440444363993128e-10, -3.366926611170387e-12,  2.447425832958411e-14,
 -1.717903730033621e-16,  1.170439658748829e-18, -7.770575420068415e-21,  5.042331245250032e-23, -3.205697265160251e-25,  7.078733975084198e-02, -9.727069587892352e-04,
  1.227180030874734e-05, -1.346590759177370e-07,  1.344892914081339e-09, -1.252308047956227e-11,  1.102995100949774e-13, -9.278929682396388e-16,  7.507896313591531e-18,
 -5.873668573031793e-20,  4.461006283594215e-22, -3.299635950543201e-24,  6.126948805241217e-02, -1.248685968985032e-03,  2.036244612246125e-05, -2.789388929530649e-07,
  3.404529400942844e-09, -3.813160954818216e-11,  3.990394028825042e-13, -3.949180626343594e-15,  3.728296871387799e-17, -3.379273452951096e-19,  2.955308421212903e-21,
 -2.503394698221021e-23,  5.123141400911169e-02, -1.467113307050376e-03,  3.022030792516015e-05, -5.076057416294736e-07,  7.446120423590633e-09, -9.878460531598371e-11,
  1.210797918276804e-12, -1.390816083454429e-14,  1.512459379716269e-16, -1.568864081909545e-18,  1.561322245647486e-20, -1.497479293207996e-22,  4.142734976432806e-02,
 -1.594115736898955e-03,  4.074689491127426e-05, -8.265767218158835e-07,  1.437780031851053e-08, -2.231935440238713e-10,  3.168165543520909e-12, -4.179304908608414e-14,
  5.182732109795652e-16, -6.093632764348144e-18,  6.837620437574059e-20, -7.359547560733501e-22,  3.243723109350718e-02, -1.617544562896394e-03,  5.049831440506149e-05,
 -1.220914209922479e-06,  2.489676109827314e-08, -4.476237816975913e-10,  7.289379468551149e-12, -1.094611703180109e-13,  1.535118140079733e-15, -2.029708994618855e-17,
  2.548512247616909e-19, -3.055873515851550e-21,  2.462890385260929e-02, -1.545337888780718e-03,  5.806396163674845e-05, -1.653528341087013e-06,  3.913424803853202e-08,
 -8.076552492629158e-10,  1.496598553097078e-11, -2.538909026933519e-13,  3.998054059237698e-15, -5.904248555236763e-17,  8.241790786642015e-19, -1.094111420619684e-20,
  1.816440936242753e-02, -1.399507429703779e-03,  6.243111041346792e-05, -2.071793987496619e-06,  5.639520519046596e-08, -1.325334320275130e-09,  2.774198650858812e-11,
 -5.281007062847765e-13,  9.278657341967788e-15, -1.521312876343882e-16,  2.347436696888890e-18, -3.431152578647009e-20,  1.303745717755917e-02, -1.208439638915842e-03,
  6.320156651802011e-05, -2.420069299232458e-06,  7.513711926370407e-08, -1.995997253248652e-09,  4.688263451119519e-11, -9.953098450278901e-13,  1.939975164684485e-14,
 -3.512274354000339e-16,  5.959886476993432e-18, -9.544223886836152e-20,  9.125758506463116e-03, -9.999533443930102e-04,  6.060773193153395e-05, -2.653407201190181e-06,
  9.323810900539843e-08, -2.780686318996088e-09,  7.283801125561253e-11, -1.714736519463995e-12,  3.688041412971063e-14, -7.336191876003066e-16,  1.362472030074752e-17,
 -2.379632873544267e-19,  6.243731711664107e-03, -7.965988126538169e-04,  5.536071996401078e-05, -2.747505628509660e-06,  1.084744669318407e-07, -3.608658458282326e-09,
  1.048042093546239e-10, -2.721355114921914e-12,  6.426524023111683e-14, -1.397954603027382e-15,  2.828928626262375e-17, -5.365810863747207e-19,  4.185958478137280e-03,
 -6.135759720037279e-04,  4.841400212887136e-05, -2.701987344684720e-06,  1.190363501631354e-07, -4.390414551371502e-09,  1.405925559637050e-10, -4.006116104723879e-12,
  1.033820765953378e-13, -2.448301568702549e-15,  5.375614097789945e-17, -1.102855013975293e-18,  2.757229870575194e-03, -4.588188812035738e-04,  4.073109769108388e-05,
 -2.537048455549312e-06,  1.239041261777411e-07, -5.037127646876125e-09,  1.769125955455209e-10, -5.504900558998346e-12,  1.545327017430731e-13, -3.967150849089835e-15,
  9.412612377380475e-17, -2.080619509579449e-18,  1.789362329870501e-03, -3.344087609394035e-04,  3.311761321862492e-05, -2.285816712869740e-06,  1.229805434641936e-07,
 -5.479787431539577e-09,  2.100059638414214e-10, -7.102213129874266e-12,  2.159195983953720e-13, -5.983839950039186e-15,  1.528147936118906e-16, -3.625805667672775e-18,
  1.147488808841547e-03, -2.384841598341546e-04,  2.613880828413223e-05, -1.985584399970921e-06,  1.169779726517858e-07, -5.681968736636345e-09,  2.364251546926593e-10,
 -8.650073540648020e-12,  2.835747465275637e-13, -8.449185545699624e-15,  2.313531971268894e-16, -5.870418944381222e-18,  7.293662448772157e-04, -1.670478878279341e-04,
  2.011220573219288e-05, -1.670523447963256e-06,  1.071422842428829e-07, -5.643188661825433e-09,  2.537051542274711e-10, -9.996541206731528e-12,  3.518838981748005e-13,
 -1.122694604065700e-14,  3.283532166263194e-16, -8.877845084195246e-18,  4.609353037512214e-04, -1.153581111680707e-04,  1.514871742317957e-05, -1.367222957934320e-06,
  9.492630116328473e-08, -5.393519471238866e-09,  2.607392440339887e-10, -1.101483570795903e-11,  4.145735997342843e-13, -1.410747516431982e-14,  4.390392765609879e-16,
 -1.260289474225368e-17,  2.905281985280986e-04, -7.882628771924773e-05,  1.121416880353636e-05, -1.093135879562528e-06,  8.170860514190040e-08, -4.982750855957568e-09,
  2.577976179353097e-10, -1.162453242887314e-11,  4.658601981595799e-13, -1.684088745095080e-14,  5.555864753011043e-16, -1.687128090803251e-17,  1.832009296075870e-04,
 -5.348686052189663e-05,  8.190134398663527e-06, -8.572188592297352e-07,  6.861020173789325e-08, -4.468174545168494e-09,  2.462518156098881e-10, -1.180004643597957e-11,
  5.014243742314061e-13, -1.918010795908064e-14,  6.682265533581584e-16, -2.138808410804628e-17,  1.159154537428724e-04, -3.616048876203262e-05,  5.922528218219922e-06,
 -6.617817913028553e-07,  5.641710594243647e-08, -3.904259506454259e-09,  2.281402051858688e-10, -1.156640559417216e-11,  5.189707538218252e-13, -2.092141768486554e-14,
  7.668177150617957e-16, -2.577518527281751e-17,  7.379289321415790e-05, -2.443278146266409e-05,  4.254427882255816e-06, -5.046851381226904e-07,  4.558696355977608e-08,
 -3.335920909682216e-09,  2.057172376419366e-10, -1.098601633638721e-11,  5.182974846048215e-13, -2.193223766204233e-14,  8.424392155148914e-16, -2.962797867579367e-17,
  4.737787650970193e-05, -1.654362002297210e-05,  3.044618035446240e-06, -3.813199779501790e-07,  3.630616932451181e-08, -2.795576212331145e-09,  1.810898730634332e-10,
 -1.014164679189291e-11,  5.009558564354886e-13, -2.216125544530922e-14,  8.886091318920882e-16, -3.257609685440429e-17,  3.073363285131541e-05, -1.124923016912264e-05,
  2.175497785573222e-06, -2.861085259880586e-07,  2.856627040487931e-08, -2.303198114882343e-09,  1.559882054580185e-10, -9.120316476772503e-12,  4.696705920915539e-13,
 -2.163187116648793e-14,  9.018918125257729e-16, -3.433322514374766e-17,  2.016320350702966e-05, -7.691207748453240e-06,  1.554229328157011e-06, -2.134841746380115e-07,
  2.223772924694732e-08, -1.868203083098589e-09,  1.316685654776976e-10, -8.001060977203351e-12,  4.277048024158348e-13, -2.042408645173956e-14,  8.818712953837821e-16,
 -3.472630877055144e-17,  1.337500445823230e-05, -5.287268483336796e-06,  1.110277175333450e-06, -1.584318403833543e-07,  1.712946873949621e-08, -1.492097548467424e-09,
  1.089181948625011e-10, -6.847615175060567e-12,  3.783105395511034e-13, -1.865146174180650e-14,  8.306348919377927e-16, -3.370170529902814e-17,  8.950066484512795e-06,
 -3.647002705699997e-06,  7.914931955765963e-07, -1.167118420995655e-07,  1.303073387372552e-08, -1.171111265716198e-09,  8.812122685392575e-11, -5.705592944423751e-12,
  3.243399032289185e-13, -1.643898373512447e-14,  7.519932564770017e-16, -3.131215583521293e-17,  6.007319671561994e-06, -2.510243007002188e-06,  5.600157373598138e-07,
 -8.488505162373523e-08,  9.736713692083145e-09, -8.983905966582742e-10,  6.935001984615488e-11, -4.602969199714296e-12,  2.680311372198259e-13, -1.390564917451510e-14,
  6.506605857000904e-16, -2.769205458296180e-17,  3.995572931481445e-06, -1.703583630556478e-06,  3.886054521338663e-07, -6.023058282015557e-08,  7.061511032924857e-09,
 -6.655987380594419e-10,  5.245648454481359e-11, -3.552506654998584e-12,  2.109441286464047e-13, -1.115334515009669e-14,  5.315607878504898e-16, -2.302911039933108e-17,
  2.564918011436927e-06, -1.110428476043929e-06,  2.576349605535425e-07, -4.061712987600573e-08,  4.842373035236030e-09, -4.639436402622239e-10,  3.714935905261850e-11,
 -2.554991240325111e-12,  1.540026718878863e-13, -8.261894051390094e-15,  3.993494101384851e-16, -1.753894052971047e-17,  1.487106460029313e-06, -6.506110664675381e-07,
  1.527311675595551e-07, -2.436413246731860e-08,  2.938559546429010e-09, -2.847453344097244e-10,  2.305293711715638e-11, -1.602554536200726e-12,  9.760348715703714e-14,
 -5.289293917989988e-15,  2.581798962234120e-16, -1.144684724447524e-17,  6.063568924216284e-07, -2.668289735922384e-07,  6.304725039114439e-08, -1.012357893856335e-08,
  1.228900981362541e-09, -1.198320172961592e-10,  9.761215270609264e-12, -6.826171543950397e-13,  4.181594271688098e-14, -2.278835282406637e-15,  1.118418663165131e-16,
 -4.984915961964784e-18,  8.679648256472590e-02, -3.185180394486017e-04,  1.231320231466428e-06, -4.948732618358000e-09,  2.040104743153462e-11, -8.534089048722512e-14,
  3.594461156983721e-16, -1.516908391690573e-18,  6.394476997146867e-21, -2.688263849964564e-23,  1.126034140750754e-25, -4.697875890525887e-28,  8.313298145385307e-02,
 -4.363316225170053e-04,  2.708893310972313e-06, -1.691011068324604e-08,  1.023933075520277e-10, -6.007521902920416e-13,  3.430921672901566e-15, -1.915580992913881e-17,
  1.049068195407502e-19, -5.649439527722233e-22,  2.997358506471749e-24, -1.569116437907287e-26,  7.628031481416411e-02, -6.410121670508794e-04,  5.844051453497987e-06,
 -4.893382769902595e-08,  3.822109304941180e-10, -2.833278883187260e-12,  2.014905392815147e-14, -1.384488745309462e-16,  9.238458548011445e-19, -6.009614122839096e-21,
  3.822319111967764e-23, -2.382657751834897e-25,  6.708311909938755e-02, -8.806485236711286e-04,  1.077717877667607e-05, -1.150090205816965e-07,  1.118931168993714e-09,
 -1.016235308879961e-11,  8.738716393258528e-14, -7.182937665735458e-16,  5.682427720733068e-18, -4.348867265304773e-20,  3.232652279148999e-22, -2.341190145206535e-24,
  5.658057892424006e-02, -1.098304191534624e-03,  1.731843572360283e-05, -2.300824397542416e-07,  2.729361776361585e-09, -2.975724878700629e-11,  3.034872387228311e-13,
 -2.929948939634446e-15,  2.700434559456802e-17, -2.391156407383635e-19,  2.044101259678043e-21, -1.693437347308921e-23,  4.581058118235553e-02, -1.247831088804408e-03,
  2.478344368668401e-05, -4.028176658723810e-07,  5.732095864339847e-09, -7.389986806974942e-11,  8.814269952997484e-13, -9.863224663883274e-15,  1.045833271812017e-16,
 -1.058597732295215e-18,  1.028724299819252e-20, -9.640281905925371e-23,  3.564512265514120e-02, -1.304219758910371e-03,  3.207330640369464e-05, -6.284781712254720e-07,
  1.058839187454859e-08, -1.595112429784578e-10,  2.200593756579894e-12, -2.824780226026091e-14,  3.412149122763351e-16, -3.911210202945729e-18,  4.281881627271140e-20,
 -4.499552723376796e-22,  2.669097164467756e-02, -1.266013439263447e-03,  3.797016713416174e-05, -8.856306924509160e-07,  1.747153851999514e-08, -3.045174656995999e-10,
  4.814989718299593e-12, -7.029706759022903e-14,  9.595497229145224e-16, -1.235997668048269e-17,  1.513169285115900e-19, -1.770411919853790e-21,  1.926446278780548e-02,
 -1.150662909302374e-03,  4.150264442061455e-05, -1.139269601335572e-06,  2.606429563677829e-08, -5.210798085941124e-10,  9.369065192653978e-12, -1.544349883048647e-13,
  2.365691312992685e-15, -3.401886524207075e-17,  4.628122350040985e-19, -5.992617859409574e-21,  1.342708915982129e-02, -9.859673557632443e-04,  4.221357030437589e-05,
 -1.349831512227578e-06,  3.550293248549433e-08, -8.078957543866117e-10,  1.640256389244945e-11, -3.032820546387950e-13,  5.181933852474802e-15, -8.270937932323077e-17,
  1.243538475807633e-18, -1.772537874570725e-20,  9.056299612443010e-03, -8.012322538662663e-04,  4.023142384851429e-05, -1.484448222225063e-06,  4.453000425532292e-08,
 -1.145309766346766e-09,  2.609006285052214e-11, -5.379456979667742e-13,  1.019584161603409e-14, -1.796905515488373e-16,  2.970950630119847e-18, -4.639719981252969e-20,
  5.924929786189323e-03, -6.207761122233610e-04,  3.615067633839348e-05, -1.525730749692121e-06,  5.181437309302382e-08, -1.496460479703711e-09,  3.802326611937005e-11,
 -8.695188927776696e-13,  1.818853689724503e-14, -3.522568132814553e-16,  6.375566902024913e-18, -1.086134243124999e-19,  3.769699672111943e-03, -4.607990267846323e-04,
  3.080329570358247e-05, -1.474888314909015e-06,  5.631107859590239e-08, -1.815053066951237e-09,  5.115604889989395e-11, -1.290852630580390e-12,  2.965947122072572e-14,
 -6.284042645032132e-16,  1.239771772918764e-17, -2.294617563213672e-19,  2.339137422634377e-03, -3.292290437803214e-04,  2.502380243546438e-05, -1.348865929961072e-06,
  5.751814015079277e-08, -2.057078451549615e-09,  6.397239280800294e-11, -1.772620396090014e-12,  4.453564404051164e-14, -1.027900507120989e-15,  2.201641217465163e-17,
 -4.410089943225718e-19,  1.419934306166685e-03, -2.274286643054346e-04,  1.948186164210375e-05, -1.173648303274659e-06,  5.554546881285095e-08, -2.191909161794956e-09,
  7.483429481577391e-11, -2.266432859762117e-12,  6.199452086027459e-14, -1.552349610723774e-15,  3.595805709996073e-17, -7.766482833814404e-19,  8.460207853304306e-04,
 -1.525728234917413e-04,  1.460859222173665e-05, -9.768013006033403e-07,  5.100078741903142e-08, -2.208725944500797e-09,  8.238134380264523e-11, -2.714727573230713e-12,
  8.050497653882606e-14, -2.178348417226888e-15,  5.436395343836417e-17, -1.261556921644710e-18,  4.965026870831079e-04, -9.984207286072263e-05,  1.060289087233310e-05,
 -7.817128082995329e-07,  4.476682002600651e-08, -2.116622072499191e-09,  8.583502705135950e-11, -3.064053945122729e-12,  9.810324974729258e-14, -2.857358498799563e-15,
  7.654579504417895e-17, -1.901750403694788e-18,  2.880692942283285e-04, -6.401467898683433e-05,  7.484918121511702e-06, -6.046231141011732e-07,  3.776474277390534e-08,
 -1.939453838723758e-09,  8.511343632340005e-11, -3.276968997622097e-12,  1.128175777193926e-13, -3.523396980128538e-15,  1.009491763982930e-16, -2.675803164977368e-18,
  1.658738873618691e-04, -4.039310046740759e-05,  5.163950989122625e-06, -4.542547728468713e-07,  3.077578599673261e-08, -1.708168766871343e-09,  8.074868439118392e-11,
 -3.338689983461881e-12,  1.230935026604102e-13, -4.106354119755902e-15,  1.253711322662945e-16, -3.533077500035924e-18,  9.516529364057723e-05, -2.519576466765006e-05,
  3.498384424978773e-06, -3.331400883317169e-07,  2.435041115756767e-08, -1.453471795231185e-09,  7.367158161376281e-11, -3.257141662799826e-12,  1.280817159413458e-13,
 -4.546463704321873e-15,  1.473749084783314e-16, -4.400078895389393e-18,  5.461698319972991e-05, -1.560462293475526e-05,  2.338084222154798e-06, -2.396321048786590e-07,
  1.879707166590662e-08, -1.200702752783458e-09,  6.495680149960724e-11, -3.057616865300919e-12,  1.277181219230998e-13, -4.805297349534671e-15,  1.647676943458491e-16,
 -5.193387845970030e-18,  3.147988404044924e-05, -9.637182031153407e-06,  1.548497340772970e-06, -1.698443984703812e-07,  1.422266946149430e-08, -9.674855055968361e-10,
  5.560733217176031e-11, -2.774764490849042e-12,  1.226097364771207e-13, -4.870449859610040e-15,  1.759921479464023e-16, -5.835127928074225e-18,  1.829081649902149e-05,
 -5.959289021270827e-06,  1.020618832168618e-06, -1.191310902207441e-07,  1.059428088359614e-08, -7.637025199539250e-10,  4.641958152888244e-11, -2.444702207405339e-12,
  1.137996440351106e-13, -4.753677075548212e-15,  1.803298803689567e-16, -6.266282213797969e-18,  1.075057274892217e-05, -3.703511002072249e-06,  6.720502389975127e-07,
 -8.301807620937084e-08,  7.799586663622381e-09, -5.928928041820500e-10,  3.793284681537341e-11, -2.099139806508649e-12,  1.025014796519370e-13, -4.484353070973988e-15,
  1.778930648678841e-16, -6.454440771926900e-18,  6.410749084453815e-06, -2.320593372636449e-06,  4.435681342470927e-07, -5.766922318174894e-08,  5.694148666528559e-09,
 -4.541851358104982e-10,  3.044276959708661e-11, -1.762190164386453e-12,  8.987522590860015e-14, -4.101010795572266e-15,  1.694498086645256e-16, -6.394876618134137e-18,
  3.886790651049677e-06, -1.469530405853541e-06,  2.941726341604156e-07, -4.003224611243825e-08,  4.132426443355240e-09, -3.441415600491882e-10,  2.405045095878920e-11,
 -1.449585559583248e-12,  7.688086690994463e-14, -3.643446707775558e-15,  1.561648640588604e-16, -6.106043016735266e-18,  2.398012396074530e-06, -9.414937390058778e-07,
  1.962549009534346e-07, -2.780131186185129e-08,  2.984578045581422e-09, -2.581955379811791e-10,  1.872247993667332e-11, -1.169530105538692e-12,  6.421322705770970e-14,
 -3.146910239939658e-15,  1.393364946737877e-16, -5.621858082779946e-18,  1.503739699556987e-06, -6.096527981943069e-07,  1.315842746200648e-07, -1.929732292537899e-08,
  2.143057528257744e-09, -1.916087220951575e-10,  1.434571036112216e-11, -9.243545449428562e-13,  5.230035026589745e-14, -2.638842431227240e-15,  1.201855035163558e-16,
 -4.983314217138131e-18,  9.539434677688318e-07, -3.972067964186123e-07,  8.826991888785873e-08, -1.332786900299138e-08,  1.522988579920648e-09, -1.400075086262626e-10,
  1.076922214684064e-11, -7.123234628899307e-13,  4.134040425181845e-14, -2.137856040062781e-15,  9.972067864151644e-17, -4.231331741485627e-18,  6.053728079312099e-07,
 -2.575173753665296e-07,  5.859317931399401e-08, -9.058381932638865e-09,  1.059374078402213e-09, -9.961202951540776e-11,  7.832088058252830e-12, -5.292052096760301e-13,
  3.135441906655522e-14, -1.654280030795545e-15,  7.867901171335811e-17, -3.401857235700058e-18,  3.746011488215043e-07, -1.619580005039993e-07,  3.752041398436229e-08,
 -5.906377430973147e-09,  7.031229577275247e-10, -6.726908119014376e-11,  5.378935713036991e-12, -3.694426316193403e-13,  2.223904012612538e-14, -1.191556994024843e-15,
  5.752443949900875e-17, -2.523390858155228e-18,  2.116480271307342e-07, -9.253378735378238e-08,  2.170592043880379e-08, -3.459957067240328e-09,  4.169925328548950e-10,
 -4.037676333915172e-11,  3.266556096609266e-12, -2.269205006182209e-13,  1.381119884376350e-14, -7.479572961913351e-16,  3.648566951926705e-17, -1.616645838700098e-18,
  8.505435825208716e-08, -3.741709615239667e-08,  8.838018132432690e-09, -1.418639605221053e-09,  1.721492512486813e-10, -1.678082983969716e-11,  1.366467389946055e-12,
 -9.552786380071016e-14,  5.849987890905910e-15, -3.187050402075307e-16,  1.563673248828295e-17, -6.967357108895974e-19,  8.554174309368559e-02, -3.088995944206206e-04,
  1.173839095431444e-06, -4.635515720319932e-09,  1.877717215671581e-11, -7.720160661742278e-14,  3.196978889531234e-16, -1.326939070284143e-18,  5.503035260252937e-21,
 -2.276577456961488e-23,  9.385360229213579e-26, -3.854447116943330e-28,  8.142975023901430e-02, -4.154451953174028e-04,  2.515419253704905e-06, -1.536363996229204e-08,
  9.116012323296619e-11, -5.244850764358224e-13,  2.938657250357738e-15, -1.610234468382774e-17,  8.657044219084083e-20, -4.577843277145195e-22,  2.385524075325999e-24,
 -1.226818819969412e-26,  7.380619329675044e-02, -5.965087599686079e-04,  5.291749453942069e-06, -4.324676345807364e-08,  3.300835771138656e-10, -2.393069623961616e-12,
  1.665583517088133e-14, -1.120715987220475e-16,  7.326700897954508e-19, -4.671284631419846e-21,  2.913079239828833e-23, -1.780984270690923e-25,  6.372462937669511e-02,
 -7.996619161101269e-04,  9.498132059181698e-06, -9.862463167895745e-08,  9.351283004141325e-10, -8.287222327548278e-12,  6.960199611070767e-14, -5.591982647052951e-16,
  4.326743358318846e-18, -3.240410702675356e-20,  2.358209193643736e-22, -1.672782358624683e-24,  5.244796238371687e-02, -9.701010680088104e-04,  1.480103512660012e-05,
 -1.908042966949323e-07,  2.200881462686797e-09, -2.336779401387272e-11,  2.323571207331135e-13, -2.189109835811563e-15,  1.970454022166260e-17, -1.705099647059082e-19,
  1.425280299869964e-21, -1.155160912110104e-23,  4.118723968232738e-02, -1.067444957575808e-03,  2.045462101943294e-05, -3.218662488864044e-07,  4.445085930531970e-09,
 -5.571405678993548e-11,  6.469024547329747e-13, -7.054505365272785e-15,  7.296109131817498e-17, -7.208926630204458e-19,  6.842839579723950e-21, -6.267294248541882e-23,
  3.089742042066086e-02, -1.075145281370543e-03,  2.545138709609119e-05, -4.819644041491774e-07,  7.868108181454519e-09, -1.150735978124252e-10,  1.543502124875968e-12,
 -1.928640835750541e-14,  2.269997377079959e-16, -2.537513689644942e-18,  2.711152324788367e-20, -2.782261300400295e-22,  2.217327906307351e-02, -1.000435277009702e-03,
  2.883753450104479e-05, -6.491418109443662e-07,  1.239368116230467e-08, -2.094806576929531e-10,  3.217179946660094e-12, -4.567972187459893e-14,  6.070554487551766e-16,
 -7.620011076144728e-18,  9.098182736887535e-20, -1.038928485253500e-21,  1.524832519312638e-02, -8.669565939019486e-04,  3.002556789168133e-05, -7.947260301290589e-07,
  1.758085183497439e-08, -3.405736269595872e-10,  5.943372778807686e-12, -9.521396672506671e-14,  1.419149300098460e-15, -1.987621488813156e-17,  2.635961280764363e-19,
 -3.329731585322479e-21,  1.006822283741619e-02, -7.044960253255436e-04,  2.895279884836267e-05, -8.922412398120941e-07,  2.268009247956316e-08, -4.998414722342854e-10,
  9.845064657856606e-12, -1.768441993546988e-13,  2.938933064014989e-15, -4.567246005354313e-17,  6.691996594859145e-19, -9.303475491207268e-21,  6.397309987757334e-03,
 -5.400650272476497e-04,  2.603467710083116e-05, -9.257234326170655e-07,  2.683323513070763e-08, -6.682761918211017e-10,  1.476579739046728e-11, -2.957227050731331e-13,
  5.450812432715762e-15, -9.352239756071675e-17,  1.506765631404655e-18, -2.294941180950766e-20,  3.921539274608298e-03, -3.927015191253504e-04,  2.196896826312657e-05,
 -8.937811176477688e-07,  2.933459807620119e-08, -8.204552840231743e-10,  2.022204121320029e-11, -4.492152319353327e-13,  9.139098206190812e-15, -1.723299368267412e-16,
  3.039696846099437e-18, -5.051065421963084e-20,  2.325730765566443e-03, -2.722301847185764e-04,  1.749919176390531e-05, -8.082090539947333e-07,  2.983643944660786e-08,
 -9.317001810938148e-10,  2.548138917033350e-11, -6.248060678228392e-13,  1.396689279295569e-14, -2.882091054435405e-16,  5.543166542106108e-18, -1.001048858749147e-19,
  1.338645830557580e-03, -1.807974111736910e-04,  1.323171763886631e-05, -6.886511722076518e-07,  2.841627133842111e-08, -9.852407580931496e-10,  2.975016959132435e-11,
 -8.014980801769292e-13,  1.960188716366482e-14, -4.408609219687527e-16,  9.210188132496089e-18, -1.801028065153726e-19,  7.503541727060315e-04, -1.155910002350879e-04,
  9.549372636674894e-06, -5.561611920404271e-07,  2.549812498062000e-08, -9.763870556972469e-10,  3.239511196587308e-11, -9.546852933039012e-13,  2.543927745127778e-14,
 -6.211823604846221e-16,  1.404447616902439e-17, -2.963377772262658e-19,  4.111328163346716e-04, -7.148752596685793e-05,  6.613500415421335e-06, -4.281659010491055e-07,
  2.168486158511227e-08, -9.123874564467681e-10,  3.310713089392167e-11, -1.062679956123905e-12,  3.072945131035925e-14, -8.115988049042481e-16,  1.978767164692171e-17,
 -4.489761879244412e-19,  2.210852250404587e-04, -4.297722779397480e-05,  4.418918654818249e-06, -3.159998326093440e-07,  1.758117091288719e-08, -8.087396605928509e-10,
  3.194886559343364e-11, -1.112259081193504e-12,  3.476612220104305e-14, -9.894750970401270e-16,  2.592377848839360e-17, -6.304000047152594e-19,  1.171826096475368e-04,
 -2.524168295528982e-05,  2.863964919723377e-06, -2.248358241172879e-07,  1.366741881960186e-08, -6.840025341294155e-10,  2.928585099530142e-11, -1.101205307942558e-12,
  3.706145547380740e-14, -1.132492273418775e-15,  3.177257118191052e-17, -8.252979315909675e-19,  6.149805264577274e-05, -1.455747841578948e-05,  1.810261669248774e-06,
 -1.550901912590792e-07,  1.024606670910788e-08, -5.551860233765129e-10,  2.564816612685973e-11, -1.037347417263602e-12,  3.744468836921519e-14, -1.223962362181272e-15,
  3.664284387476364e-17, -1.013292861967683e-18,  3.210767371713661e-05, -8.287020390635632e-06,  1.122032147094621e-06, -1.042976241981195e-07,  7.449448978488638e-09,
 -4.349408179715572e-10,  2.158403193010848e-11, -9.350837374388165e-13,  3.606004643766034e-14, -1.256194791722392e-15,  3.998963212744781e-17, -1.173307120872140e-18,
  1.675786445652597e-05, -4.680962967450433e-06,  6.856903222906822e-07, -6.876225313990854e-08,  5.282278646889958e-09, -3.307266196134830e-10,  1.755151680345293e-11,
 -8.110719356303063e-13,  3.328299356581142e-14, -1.231034493790603e-15,  4.152120665378478e-17, -1.288124541483032e-18,  8.786685464081324e-06, -2.637371339554958e-06,
  4.153865359198797e-07, -4.468737980145257e-08,  3.673070809680248e-09, -2.454301325093951e-10,  1.386616795454556e-11, -6.805803558931193e-13,  2.959901647241725e-14,
 -1.157907581636695e-15,  4.122766199825411e-17, -1.347629679463863e-18,  4.650850364108372e-06, -1.489812054458020e-06,  2.507577920033179e-07, -2.877875015535721e-08,
  2.517893413574131e-09, -1.786807094183966e-10,  1.069798481397823e-11, -5.552914173570657e-13,  2.548962936129230e-14, -1.050509845700265e-15,  3.933632853138913e-17,
 -1.349888445270966e-18,  2.496577812070876e-06, -8.478636355138763e-07,  1.515937337474541e-07, -1.845712412747908e-08,  1.709955227222119e-09, -1.282423911250515e-10,
  8.098964415795275e-12, -4.426104501662280e-13,  2.135375526139670e-14, -9.234113313344749e-16,  3.622291530303314e-17, -1.300138649153602e-18,  1.364806374393362e-06,
 -4.882666103996822e-07,  9.218505983880127e-08, -1.184090733595636e-08,  1.155510254798489e-09, -9.112949796348544e-11,  6.041814698725798e-12, -3.460698288303464e-13,
  1.747197684987534e-14, -7.894776164699024e-16,  3.231358527251321e-17, -1.208428192085713e-18,  7.623971960961285e-07, -2.855494905836461e-07,  5.659338654146291e-08,
 -7.625997999715279e-09,  7.797202187118251e-10, -6.433626626394742e-11,  4.456218506833880e-12, -2.662856999883807e-13,  1.400600497855354e-14, -6.584551732182909e-16,
  2.800496988591262e-17, -1.086855249338860e-18,  4.361115342545393e-07, -1.699805810463146e-07,  3.515657589633722e-08, -4.941878532436621e-09,  5.265513137341814e-10,
 -4.522116059973155e-11,  3.256103904069973e-12, -2.020194891640178e-13,  1.101932988572042e-14, -5.366138424045542e-16,  2.361474260005429e-17, -9.471858252399325e-19,
  2.554710090763692e-07, -1.030159063655183e-07,  2.210453846727456e-08, -3.222915230194359e-09,  3.558959499256402e-10, -3.164587956923997e-11,  2.356756662903258e-12,
 -1.510774221861601e-13,  8.505687200818871e-15, -4.271053967832320e-16,  1.936246672070382e-17, -7.992565228025918e-19,  1.527190004643260e-07, -6.334915097438893e-08,
  1.401961867610221e-08, -2.108098760889838e-09,  2.399247926084482e-10, -2.196996267586695e-11,  1.683510081713779e-12, -1.109470826419645e-13,  6.416132727504640e-15,
 -3.306649702422579e-16,  1.537288607268437e-17, -6.502178377571254e-19,  9.222340621390002e-08, -3.913409137381761e-08,  8.880074170558792e-09, -1.369122290754197e-09,
  1.596938088131467e-10, -1.497716924477877e-11,  1.174651082408106e-12, -7.917775527918925e-14,  4.680145993246428e-15, -2.463679079498656e-16,  1.169177109287707e-17,
 -5.044487320582583e-19,  5.488928960909595e-08, -2.369724421564892e-08,  5.481143544044239e-09, -8.614525952497683e-10,  1.023908755450044e-10, -9.780991448199883e-12,
  7.809444948536020e-13, -5.356073711457801e-14,  3.219662602817856e-15, -1.722751154108894e-16,  8.305993653290918e-18, -3.638934380040155e-19,  3.017266108922997e-08,
 -1.318221519395825e-08,  3.089711991545569e-09, -4.921074155818992e-10,  5.926143964862426e-11, -5.733738064348206e-12,  4.635188719388925e-13, -3.217590232971143e-14,
  1.956936766109871e-15, -1.059056626574439e-16,  5.162618086455263e-18, -2.286002965708706e-19,  1.193965658743486e-08, -5.250832813825697e-09,  1.239818069158708e-09,
 -1.989379878543618e-10,  2.413206251389336e-11, -2.351519822666685e-12,  1.914181321607362e-13, -1.337720289942444e-14,  8.189258211262991e-16, -4.460009391955038e-17,
  2.187524609656718e-18, -9.744023434536367e-20,  8.432458090139439e-02, -2.997263937201747e-04,  1.119965878982981e-06, -4.347028620728805e-09,  1.730695773886717e-11,
 -6.995554200851453e-14,  2.848907263232377e-16, -1.163262365622716e-18,  4.747149034814893e-21, -1.932969032334099e-23,  7.844720794508074e-26, -3.172105052143643e-28,
  7.980708251404592e-02, -3.960352735122919e-04,  2.339472793016040e-06, -1.398531144488729e-08,  8.134073485245758e-11, -4.590692460404313e-13,  2.524223061487061e-15,
 -1.357836349613947e-17,  7.168530100972547e-20, -3.723337607794169e-22,  1.906176373937198e-24, -9.632865529658431e-27,  7.150166162201348e-02, -5.561643277177220e-04,
  4.802964439490551e-06, -3.832761932598656e-08,  2.859784675548788e-10, -2.028484010778328e-12,  1.382230444037924e-14, -9.110639566182374e-17,  5.837188288188300e-19,
 -3.648771264236543e-21,  2.231661102218197e-23, -1.338552177853351e-25,  6.067079954674110e-02, -7.281685193021868e-04,  8.399219330818870e-06, -8.490282872089213e-08,
  7.848965814785009e-10, -6.790035727717151e-12,  5.571964615030301e-14, -4.377214374198165e-16,  3.313638465599504e-18, -2.429310484274330e-20,  1.731416611507559e-22,
 -1.203289357377309e-24,  4.879067421605488e-02, -8.602864024976878e-04,  1.270817291078962e-05, -1.590456740368814e-07,  1.784671917545596e-09, -1.846081412780587e-11,
  1.790399252012113e-13, -1.646697341502498e-15,  1.448070819234767e-17, -1.224975370312464e-19,  1.001550002532761e-21, -7.943708253557133e-24,  3.722187373440614e-02,
 -9.181280259618287e-04,  1.698474281041448e-05, -2.588782641788586e-07,  3.471329976306673e-09, -4.231710085281905e-11,  4.785089526521522e-13, -5.087115968274404e-15,
  5.133664426078834e-17, -4.952902126725636e-19,  4.593657595711438e-21, -4.113244694039017e-23,  2.697023836809108e-02, -8.926910410122510e-04,  2.035325546279117e-05,
 -3.726435729807757e-07,  5.897244606935034e-09, -8.376642651428958e-11,  1.092809708760291e-12, -1.329652756346410e-14,  1.525402650787853e-16, -1.663417820661650e-18,
  1.734985825417480e-20, -1.739281576225108e-22,  1.858797498354829e-02, -7.978158904808946e-04,  2.211185852614141e-05, -4.805630092991738e-07,  8.882943434899916e-09,
 -1.456520219785866e-10,  2.173402506411847e-12, -3.002131991430428e-14,  3.885408602395188e-16, -4.754021980893657e-18,  5.537363232070202e-20, -6.172848237857851e-22,
  1.220663561787314e-02, -6.605883807766779e-04,  2.197467192673300e-05, -5.609959410786049e-07,  1.200380270775774e-08, -2.253878526799167e-10,  3.818592145469440e-12,
 -5.947072167812767e-14,  8.626866451652903e-16, -1.177073695701179e-17,  1.522034857749721e-19, -1.876043260598909e-21,  7.653476382924795e-03, -5.102162248357899e-04,
  2.013070414113876e-05, -5.980065812606533e-07,  1.469408572885196e-08, -3.137049949640026e-10,  5.995550308290574e-12, -1.046466915782113e-13,  1.691843501507779e-15,
 -2.560376960498445e-17,  3.656574912508781e-19, -4.958893736106068e-21,  4.592356572187965e-03, -3.698270429621911e-04,  1.711637684120102e-05, -5.865580468643122e-07,
  1.643083799115312e-08, -3.962889831083449e-10,  8.494118308728588e-12, -1.652590913043777e-13,  2.962688363315594e-15, -4.949274473596852e-17,  7.771002538595402e-19,
 -1.154447847482906e-20,  2.644122142692113e-03, -2.529670758746714e-04,  1.359323487988049e-05, -5.330787811278642e-07,  1.690916982278776e-08, -4.580054688648431e-10,
  1.095075851288428e-11, -2.363155213314885e-13,  4.676162321426944e-15, -8.585385972349546e-17,  1.475893037367914e-18, -2.392261914680813e-20,  1.465203144227449e-03,
 -1.641417049622951e-04,  1.014338689864693e-05, -4.518191298257031e-07,  1.612619475952086e-08, -4.878238751592801e-10,  1.294567725843215e-11, -3.084388066576075e-13,
  6.707692705736731e-15, -1.348018595323808e-16,  2.527414346033354e-18, -4.453326960154529e-20,  7.840403894319358e-04, -1.015485095408626e-04,  7.153127982416953e-06,
 -3.593557525383043e-07,  1.434594592850907e-08, -4.821201284045415e-10,  1.413317560538097e-11, -3.701533534390030e-13,  8.810977262640672e-15, -1.930788951282145e-16,
  3.933885627136185e-18, -7.508865746732326e-20,  4.066442315204878e-04, -6.020513928404172e-05,  4.794321348988780e-06, -2.698345466742264e-07,  1.198003066065553e-08,
 -4.450275385847464e-10,  1.434539165653286e-11, -4.112727333474256e-13,  1.067366754812041e-14, -2.541068584499806e-16,  5.606562697137766e-18, -1.155442232655487e-19,
  2.052571777245353e-04, -3.438271177310273e-05,  3.071436064864280e-06, -1.924348109357057e-07,  9.449566853239709e-09, -3.861211487262877e-10,  1.362598855651900e-11,
 -4.258839285790852e-13,  1.200513821410028e-14, -3.093930621652646e-16,  7.367395204447336e-18, -1.634030640108507e-19,  1.012797788081892e-04, -1.901506488081612e-05,
  1.891613539528541e-06, -1.311256879511725e-07,  7.083841861519607e-09, -3.168800020788037e-10,  1.218920937871793e-11, -4.136821621731508e-13,  1.261866151430971e-14,
 -3.508091315833645e-16,  8.985663316206276e-18, -2.138004715191580e-19,  4.908837878537230e-05, -1.023982072441370e-05,  1.126526335726432e-06, -8.588964998676794e-08,
  5.078246490003546e-09, -2.475253087098231e-10,  1.033418047460540e-11, -3.793258632339808e-13,  1.247436170665488e-14, -3.727960323089204e-16,  1.023729441831202e-17,
 -2.604826313058237e-19,  2.349126424297800e-05, -5.400059871360827e-06,  6.526318319269722e-07, -5.441410064210836e-08,  3.503097239411795e-09, -1.851916951691817e-10,
  8.356024453923418e-12, -3.304136015295603e-13,  1.167097512642352e-14, -3.736191791342178e-16,  1.096295491798450e-17, -2.973510477889677e-19,  1.116040512517545e-05,
 -2.805291994342744e-06,  3.700601237182281e-07, -3.355119901274932e-08,  2.339986136859307e-09, -1.335466751769151e-10,  6.484426985566097e-12, -2.751148293070460e-13,
  1.039853329293920e-14, -3.553169762960653e-16,  1.110264877811668e-17, -3.199684999196435e-19,  5.293988210492438e-06, -1.444326324851173e-06,  2.066621859653161e-07,
 -2.026139424748772e-08,  1.523146040433920e-09, -9.340898124022542e-11,  4.859658049330608e-12, -2.203270850377901e-13,  8.877068715665489e-15, -3.225930431032453e-16,
  1.069722573045095e-17, -3.264724980335455e-19,  2.522156973262721e-06, -7.415492247423453e-07,  1.143841307759675e-07, -1.205983268483351e-08,  9.722430467267250e-10,
 -6.376808382893740e-11,  3.539037194473607e-12, -1.707515167858703e-13,  7.304706453482801e-15, -2.812583494243908e-16,  9.862236556289880e-18, -3.176557666891896e-19,
  1.214017988945858e-06, -3.820162100862084e-07,  6.313928903378807e-08, -7.119293243103104e-09,  6.123580825112280e-10, -4.274994573599951e-11,  2.519564609051783e-12,
 -1.288164907768594e-13,  5.827568494959675e-15, -2.368259866495534e-16,  8.748769923234703e-18, -2.963405691413556e-19,  5.938370697659892e-07, -1.986564800268884e-07,
  3.496977457676188e-08, -4.193466464761743e-09,  3.828411789966017e-10, -2.830913613774823e-11,  1.763666106614349e-12, -9.513079980376104e-14,  4.532062692878333e-15,
 -1.936143004139110e-16,  7.506439991744308e-18, -2.664010195123942e-19,  2.968025871911930e-07, -1.048690975615873e-07,  1.954319932561204e-08, -2.478430960371138e-09,
  2.388911224853457e-10, -1.861701061590030e-11,  1.220202049905588e-12, -6.912315566108949e-14,  3.452799484263506e-15, -1.544202556987657e-16,  6.258095326250742e-18,
 -2.318081376337943e-19,  1.522961696678924e-07, -5.647376347417711e-08,  1.107477537327817e-08, -1.476870344596262e-09,  1.494843679337249e-10, -1.221443283368030e-11,
  8.380970487693879e-13, -4.962860456200826e-14,  2.587589029428798e-15, -1.206252847685143e-16,  5.088696330533830e-18, -1.959441160178952e-19,  8.051207945261745e-08,
 -3.113810281042658e-08,  6.386924172759988e-09, -8.904566113749389e-10,  9.412298560628576e-11, -8.021284224958585e-12,  5.732746589767883e-13, -3.531287466636697e-14,
  1.912844411117076e-15, -9.252861151216404e-17,  4.045644590153581e-18, -1.612622461886944e-19,  4.391500924808887e-08, -1.760637599045840e-08,  3.754371566424324e-09,
 -5.440233497557578e-10,  5.971366668376517e-11, -5.278757016863085e-12,  3.909106847066523e-13, -2.492265454002303e-14,  1.395781456966882e-15, -6.973243721883886e-17,
  3.145775042010392e-18, -1.292402707967545e-19,  2.466101046508113e-08, -1.018822586798034e-08,  2.244773148424604e-09, -3.360589372064532e-10,  3.808320413473273e-11,
 -3.472780484829063e-12,  2.650402422461576e-13, -1.739876141843743e-14,  1.002395447219010e-15, -5.147215908543853e-17,  2.384576262293981e-18, -1.005174110746991e-19,
  1.413146937432918e-08, -5.980774256566702e-09,  1.353191572758091e-09, -2.080309214970170e-10,  2.419603904193767e-11, -2.263036000398776e-12,  1.770162918704384e-13,
 -1.190110897331296e-14,  7.017139840367656e-16, -3.684995048184597e-17,  1.744694895905285e-18, -7.510665864972878e-20,  8.070892341324121e-09, -3.479093739148674e-09,
  8.033432122682272e-10, -1.260439450359297e-10,  1.495639861061668e-11, -1.426405623623830e-12,  1.137091459087190e-13, -7.786777482470834e-15,  4.673887129489489e-16,
 -2.497279672714062e-17,  1.202354477834474e-18, -5.260559827042266e-20,  4.309078164201140e-09, -1.881170961116741e-09,  4.405427545370384e-10, -7.010644863697205e-11,
  8.435369867979780e-12, -8.154776397414480e-13,  6.587083329426501e-14, -4.568961212756972e-15,  2.776731868976028e-16, -1.501605957012515e-17,  7.314681783034920e-19,
 -3.236685196282157e-20,  1.677370441271681e-09, -7.374316501416654e-10,  1.740561465056250e-10, -2.791801469982022e-11,  3.385305705227139e-12, -3.297548299341085e-13,
  2.683289614522107e-14, -1.874540383233861e-15,  1.147155167111439e-16, -6.245462101468549e-18,  3.062217256491661e-19, -1.363574988605787e-20,  8.314327091505788e-02,
 -2.909707205421846e-04,  1.069418006664979e-06, -4.080949459575459e-09,  1.597366845692256e-11, -6.349247702804888e-14,  2.543456553270512e-16, -1.021908143721275e-18,
  4.104556045839432e-21, -1.645380941755647e-23,  6.574989472984695e-26, -2.618303270323478e-28,  7.825934044206054e-02, -3.779693384610372e-04,  2.179165100529120e-06,
 -1.275414393581045e-08,  7.273565668783050e-11, -4.028028876436562e-13,  2.174229134693801e-15, -1.148497253784765e-17,  5.955746285057361e-20, -3.039258169574404e-22,
  1.529047711812476e-24, -7.594895540691693e-27,  6.935104473619401e-02, -5.195055221364462e-04,  4.369204244711942e-06, -3.405932785640186e-08,  2.485299261393844e-10,
 -1.725365212454668e-12,  1.151424896317494e-14, -7.436768764023350e-17,  4.671071463205382e-19, -2.863553496885922e-21,  1.718221888310392e-23, -1.011366652138524e-25,
  5.788634872731472e-02, -6.648464772090467e-04,  7.451478505451978e-06, -7.336219215030090e-08,  6.615344920752142e-10, -5.588619246169686e-12,  4.482544381847603e-14,
 -3.444382233847104e-16,  2.551970354390604e-18, -1.832025527629346e-20,  1.279146066807654e-22, -8.712225169020237e-25,  4.554142204012272e-02, -7.657963985915473e-04,
  1.095948477900288e-05, -1.332259696539041e-07,  1.454944786555869e-09, -1.466859833131445e-11,  1.388082061413622e-13, -1.246776448315918e-15,  1.071497273836906e-17,
 -8.863902835928141e-20,  7.090897278565967e-22, -5.505426242467739e-24,  3.380269578350031e-02, -7.937925340410323e-04,  1.418541853031402e-05, -2.095290338126346e-07,
  2.729186345413537e-09, -3.237181349734236e-11,  3.566217323717669e-13, -3.697427286747799e-15,  3.641954134504730e-17, -3.432101805300419e-19,  3.111185921702129e-21,
 -2.724343507019105e-23,  2.369891299535944e-02, -7.462664954329471e-04,  1.639667481888801e-05, -2.903825873084935e-07,  4.456666071325767e-09, -6.150593043089989e-11,
  7.807173012357784e-13, -9.253085038054650e-15,  1.035013554302991e-16, -1.101362054823906e-18,  1.121761083642763e-20, -1.098815255452902e-22,  1.571711911187301e-02,
 -6.417761869826425e-04,  1.711019090045344e-05, -3.591685319822133e-07,  6.430072941316425e-09, -1.023166351063437e-10,  1.483908542744277e-12, -1.994685942333109e-14,
  2.514848228666332e-16, -3.000230831477648e-18,  3.409996062019732e-20, -3.711902215264515e-22,  9.877436514111160e-03, -5.087666137475977e-04,  1.626103742840269e-05,
 -4.005323797832204e-07,  8.292229601902477e-09, -1.509575393879864e-10,  2.483718829263310e-12, -3.761417372215489e-14,  5.311705381784433e-16, -7.062091540684593e-18,
  8.905693831014145e-20, -1.071337352360981e-21,  5.894326558567956e-03, -3.743086876592495e-04,  1.418105823875449e-05, -4.061719770363521e-07,  9.649918463613945e-09,
 -1.996157767406579e-10,  3.702717805354856e-12, -6.281062869109745e-14,  9.880760250332410e-16, -1.456447124943658e-17,  2.027735114579787e-19, -2.682959528661326e-21,
  3.347929275279826e-03, -2.571191189421359e-04,  1.142549230948610e-05, -3.773942293995457e-07,  1.021792831869879e-08, -2.386982380572622e-10,  4.963922257612326e-12,
 -9.383244623221847e-14,  1.636350295761794e-15, -2.661877702333000e-17,  4.073619635543937e-19, -5.903325259661734e-21,  1.814911470856172e-03, -1.658231271595230e-04,
  8.558055040049094e-06, -3.235116046513325e-07,  9.917882788988819e-09, -2.601745478003257e-10,  6.034879585743574e-12, -1.265209707725920e-13,  2.435200599644596e-15,
 -4.353541011201030e-17,  7.294338453665813e-19, -1.153349671817869e-20,  9.419293998918919e-04, -1.009404057366435e-04,  5.995305387870149e-06, -2.575218911826005e-07,
  8.885731199602801e-09, -2.603790105963294e-10,  6.704535464671121e-12, -1.552117666880209e-13,  3.283745857763838e-15, -6.426857237368562e-17,  1.174629116315826e-18,
 -2.019341703892057e-20,  4.696600045210217e-04, -5.829897404846711e-05,  3.951160286305039e-06, -1.915535632193215e-07,  7.396897017157593e-09, -2.409129698655187e-10,
  6.855287326670974e-12, -1.745204517262449e-13,  4.042867994785534e-15, -8.631050389073826e-17,  1.714859195645770e-18, -3.194773771633757e-20,  2.258662445494708e-04,
 -3.211591873087544e-05,  2.464031146034952e-06, -1.339678016588937e-07,  5.758141332061340e-09, -2.074503059750562e-10,  6.495432045019562e-12, -1.811221724395946e-13,
  4.577309333075575e-15, -1.062237537340753e-16,  2.286754175379180e-18, -4.602216184858955e-20,  1.052232846029387e-04, -1.696663736363695e-05,  1.462642966907586e-06,
 -8.864052755396643e-08,  4.218576302662530e-09, -1.673437760271020e-10,  5.741354335479512e-12, -1.746824603991885e-13,  4.798735168612929e-15, -1.206456285856799e-16,
  2.805142196184130e-18, -6.080123831525091e-20,  4.771463135324404e-05, -8.644446914897873e-06,  8.314329498172749e-07, -5.583589360705531e-08,  2.927474140683318e-09,
 -1.272873934600913e-10,  4.765610796361949e-12, -1.576094521003123e-13,  4.689937959765296e-15, -1.273163667586924e-16,  3.187181281500295e-18, -7.417693087607946e-20,
  2.117169926746814e-05, -4.272827494996874e-06,  4.554357188047959e-07, -3.370054046737397e-08,  1.936878166271064e-09, -9.189822734871950e-11,  3.739406781735013e-12,
 -1.339253157999740e-13,  4.301598354295599e-15, -1.256731605753420e-16,  3.376612303829044e-18, -8.412883545674346e-20,  9.244976241265339e-06, -2.061745842913111e-06,
  2.419666550243358e-07, -1.961902828930032e-08,  1.229973271396723e-09, -6.339960223740193e-11,  2.792401986536054e-12, -1.078934382988501e-13,  3.727427884745371e-15,
 -1.168068684295246e-16,  3.357737638841650e-18, -8.928847753038869e-20,  3.997328860707301e-06, -9.775494522728221e-07,  1.255275619498138e-07, -1.109171676089313e-08,
  7.548249102227362e-10, -4.208139040273989e-11,  1.997995083697897e-12, -8.296736131242846e-14,  3.071903650327540e-15, -1.029050242951688e-16,  3.154640906273071e-18,
 -8.925623942922431e-20,  1.722594090362670e-06, -4.585605143801833e-07,  6.403344770767599e-08, -6.132636305655228e-09,  4.508099540107645e-10, -2.706047653813984e-11,
  1.379236518854097e-12, -6.131255169908748e-14,  2.424013275796832e-15, -8.649991962487992e-17,  2.818493864274176e-18, -8.457827195585977e-20,  7.449275999905004e-07,
 -2.143302599520413e-07,  3.234961954307440e-08, -3.339891679010364e-09,  2.638909079764738e-10, -1.697748087874877e-11,  9.249467896104659e-13, -4.384066743526982e-14,
  1.843716869614935e-15, -6.983192560514536e-17,  2.410136049547961e-18, -7.645307951977870e-20,  3.255483962136566e-07, -1.005390099771848e-07,  1.630335533299196e-08,
 -1.804629296223988e-09,  1.524879642767127e-10, -1.046526921461427e-11,  6.067611961010198e-13, -3.053638627264008e-14,  1.360652836184918e-15, -5.449382125812168e-17,
  1.984963509664270e-18, -6.633009708124616e-20,  1.447931594943477e-07, -4.767352054852281e-08,  8.255744471916671e-09, -9.743341626369546e-10,  8.759322809562552e-11,
 -6.381883150936385e-12,  3.919719236917436e-13, -2.085502194061707e-14,  9.805244781847541e-16, -4.136022380636095e-17,  1.584020158562272e-18, -5.555727133585886e-20,
  6.598895914899003e-08, -2.301051400355968e-08,  4.229672145368455e-09, -5.292335503099941e-10,  5.035273590041398e-11, -3.875166505708054e-12,  2.509409162474113e-13,
 -1.405131411797596e-14,  6.940706970637549e-16, -3.070800715160577e-17,  1.231605538332192e-18, -4.516558425680340e-20,  3.100876794055285e-08, -1.137702714005188e-08,
  2.206223044851385e-09, -2.909864936631192e-10,  2.913998592005087e-11, -2.356628123113510e-12,  1.601022369350172e-13, -9.390246162256614e-15,  4.851010495701866e-16,
 -2.241355028610011e-17,  9.374559456189966e-19, -3.580029271792780e-20,  1.510029336903396e-08, -5.791953951763981e-09,  1.177582848659342e-09, -1.627533335519942e-10,
  1.705840400552426e-11, -1.441897965879448e-12,  1.022410834858235e-13, -6.250135730148655e-15,  3.360834330126311e-16, -1.614236669018835e-17,  7.009875808017236e-19,
 -2.775852252354389e-20,  7.643329677403520e-09, -3.045534384284853e-09,  6.451243407477721e-10, -9.286751553798450e-11,  1.012828919355134e-11, -8.898134363001158e-13,
  6.549998487590060e-14, -4.151878287661572e-15,  2.312288699041795e-16, -1.148995263290411e-17,  5.156450720053398e-19, -2.107870612865222e-20,  4.018921764796588e-09,
 -1.653157961233519e-09,  3.625238324016514e-10, -5.401822588116467e-11,  6.093535059671272e-12, -5.532035065520661e-13,  4.203921166746018e-14, -2.748269376891039e-15,
  1.577029521671975e-16, -8.066635224594761e-18,  3.723127026595642e-19, -1.563772875089933e-20,  2.178845497983078e-09, -9.195424530382732e-10,  2.074088942095724e-10,
 -3.178728830219750e-11,  3.686020766947014e-12, -3.437407751064627e-13,  2.681138511712111e-14, -1.797629908703282e-15,  1.057108242810961e-16, -5.537084813772748e-18,
  2.615085174803269e-19, -1.123066484092992e-20,  1.191162249670242e-09, -5.126294940655366e-10,  1.181544004158528e-10, -1.850468159913363e-11,  2.191863756062190e-12,
 -2.086783780615936e-13,  1.660734441841704e-14, -1.135417702871505e-15,  6.804427716286681e-17, -3.630093907879743e-18,  1.745185573872778e-19, -7.624679559818797e-21,
  6.165584053787585e-10, -2.689465758187858e-10,  6.292637078538025e-11, -1.000477696517817e-11,  1.202721043097287e-12, -1.161698271116026e-13,  9.375728071795945e-15,
 -6.497856903664624e-16,  3.945823309498492e-17, -2.132164308727786e-18,  1.037841013115719e-19, -4.588987640109280e-21,  2.358435139430410e-10, -1.036492784829837e-10,
  2.445479614742663e-11, -3.920910802940583e-12,  4.752580249316311e-13, -4.627585993896581e-14,  3.764139863971814e-15, -2.628640231651543e-16,  1.608051611766569e-17,
 -8.751594059753643e-19,  4.289499351117864e-20, -1.909419155530267e-21,  8.199619457814337e-02, -2.826070116260916e-04,  1.021939228689133e-06, -3.835207362229640e-09,
  1.476261863369981e-11, -5.771723007604280e-14,  2.274855129375906e-16, -8.995538416169060e-19,  3.556910560037356e-21, -1.404028157566365e-23,  5.525465743470292e-26,
 -2.167420292458835e-28,  7.678138756072064e-02, -3.611290268349509e-04,  2.032841040685082e-06, -1.165209228385826e-08,  6.517643760498040e-11, -3.542746827792846e-13,
  1.877767322576999e-15, -9.743014197188396e-18,  4.964107069846908e-20, -2.489525411787971e-22,  1.231132128090302e-24, -6.012061208777320e-27,  6.734043350324273e-02,
 -4.861216641779488e-04,  3.983259214620918e-06, -3.034457165874305e-08,  2.166257174193338e-10, -1.472412438506296e-12,  9.626617780258457e-15, -6.094525289611468e-17,
  3.753888881603912e-19, -2.257581627767603e-21,  1.329331315446563e-23, -7.680772694004636e-26,  5.534085423691396e-02, -6.085842275782320e-04,  6.631131788632095e-06,
 -6.361648748058876e-08,  5.597842558370075e-10, -4.619887782350010e-12,  3.623193611913803e-14, -2.724104875803055e-16,  1.975998729984648e-18, -1.389492991048275e-20,
  9.507050588889951e-23, -6.347773764385151e-25,  4.264399374418756e-02, -6.841407984293887e-04,  9.491322061832509e-06, -1.121240310673154e-07,  1.192247506682321e-09,
 -1.172013681855266e-11,  1.082555062414225e-13, -9.499200767807894e-16,  7.981091655630834e-18, -6.458507134518073e-20,  5.056766963569595e-22, -3.844413863851988e-24,
  3.083955487536995e-02, -6.896705902085634e-04,  1.191312221022630e-05, -1.706094761187771e-07,  2.159588638658100e-09, -2.493414690651355e-11,  2.677108304797734e-13,
 -2.707835484246149e-15,  2.604245743071520e-17, -2.397947379723017e-19,  2.125222969431124e-21, -1.820441096155466e-23,  2.095572066529521e-02, -6.279065342110790e-04,
  1.330240210180252e-05, -2.279806201972227e-07,  3.394722953714326e-09, -4.553724936720193e-11,  5.626056243413313e-13, -6.497472088516536e-15,  7.088547675084312e-17,
 -7.362770259433032e-19,  7.325094296377471e-21, -7.013063774957813e-23,  1.339875947634698e-02, -5.205295995813397e-04,  1.335571248236135e-05, -2.708977348870761e-07,
  4.698946954592877e-09, -7.258672799033455e-11,  1.023531207612113e-12, -1.339316355597036e-14,  1.645431336615723e-16, -1.914533209811710e-18,  2.123903800866677e-20,
 -2.258119065118652e-22,  8.075012388563185e-03, -3.958584427031667e-04,  1.216066082010612e-05, -2.890974582234105e-07,  5.792874733638868e-09, -1.022783746182069e-10,
  1.634681137844141e-12, -2.407968096053125e-14,  3.311145657521035e-16, -4.290743253595693e-18,  5.278135585801114e-20, -6.198315672481076e-22,  4.596461391176375e-03,
 -2.780064729836112e-04,  1.011578895316805e-05, -2.794228358185408e-07,  6.420396833870534e-09, -1.287157737404031e-10,  2.317807066509895e-12, -3.822101374966272e-14,
  5.851576249519842e-16, -8.402789449517048e-18,  1.140686859425273e-19, -1.472778420598830e-21,  2.477072087850390e-03, -1.813756327615898e-04,  7.738902247357627e-06,
 -2.464232978670916e-07,  6.449687982488379e-09, -1.459591938141454e-10,  2.945422564093820e-12, -5.410342841548374e-14,  9.179419660481241e-16, -1.454266671719124e-17,
  2.169452547652293e-19, -3.067172223314722e-21,  1.267305847902103e-03, -1.105393128958069e-04,  5.478862145390459e-06, -1.996467276874517e-07,  5.915838348548248e-09,
 -1.503117593480896e-10,  3.382692824933592e-12, -6.890294137991762e-14,  1.290086887162459e-15, -2.245931673489333e-17,  3.667901130589395e-19, -5.657710222216378e-21,
  6.174748583990807e-04, -6.326762433414096e-05,  3.610965675714958e-06, -1.495566134409428e-07,  4.988569607264063e-09, -1.415993293564960e-10,  3.537702841636413e-12,
 -7.957711812803729e-14,  1.637849714682415e-15, -3.121833009806159e-17,  5.562021667555053e-19, -9.329117587016462e-21,  2.875464599548649e-04, -3.418771172705769e-05,
  2.228595543331280e-06, -1.042410214533156e-07,  3.892991497662964e-09, -1.228639077488888e-10,  3.393326288406561e-12, -8.396251840156812e-14,  1.892750575650669e-15,
 -3.936377123545368e-17,  7.626166837018154e-19, -1.386577065085595e-20,  1.285010674608011e-04, -1.753569609278331e-05,  1.295636515017753e-06, -6.802579815550256e-08,
  2.829818551191722e-09, -9.885372635190377e-11,  3.005851317944920e-12, -8.150748515805988e-14,  2.005474692025315e-15, -4.535941961978502e-17,  9.526119518524551e-19,
 -1.871951073711427e-20,  5.535944800461391e-05, -8.585654086435600e-06,  7.138536690939699e-07, -4.182708126393093e-08,  1.928547088363943e-09, -7.424387760276601e-11,
  2.475684680234173e-12, -7.330309171267505e-14,  1.961957871077881e-15, -4.810722959308495e-17,  1.091924827137241e-18, -2.312407019695249e-20,  2.310836627357450e-05,
 -4.036310977319059e-06,  3.750917094693486e-07, -2.438997149222109e-08,  1.240447880277484e-09, -5.240215807324796e-11,  1.908814233830015e-12, -6.149523653960665e-14,
  1.784499328428862e-15, -4.728820231894067e-17,  1.156604399819782e-18, -2.632217960277302e-20,  9.399069392100943e-06, -1.833496609701858e-06,  1.892012208738900e-07,
 -1.357877294346241e-08,  7.581716798091566e-10, -3.499810212716078e-11,  1.387301115822907e-12, -4.845742213891494e-14,  1.519520506940137e-15, -4.338168422931501e-17,
  1.140001226252917e-18, -2.780233225862229e-20,  3.748250805324850e-06, -8.101466831227743e-07,  9.225161326317800e-08, -7.268722592552726e-09,  4.434748883618750e-10,
 -2.227517868327343e-11,  9.571608887326054e-13, -3.611900667782742e-14,  1.219840188530728e-15, -3.740228335043139e-17,  1.052845743325572e-18, -2.743699440049739e-20,
  1.475478471475379e-06, -3.506951470126383e-07,  4.379801194326392e-08, -3.768744029420077e-09,  2.500780139532385e-10, -1.360995994277944e-11,  6.314808243792686e-13,
 -2.565034091762733e-14,  9.298208615589980e-16, -3.052031446026098e-17,  9.174684056553239e-19, -2.547316701152509e-20,  5.775101489500644e-07, -1.498516472326932e-07,
  2.040297586294995e-08, -1.907257478420907e-09,  1.369940523595227e-10, -8.043293460113629e-12,  4.013640216389221e-13, -1.748353411985884e-14,  6.778675452669250e-16,
 -2.373993707961245e-17,  7.596893572544347e-19, -2.240390851374000e-20,  2.265029929714157e-07, -6.371074829807434e-08,  9.400814347565103e-09, -9.496315170593370e-10,
  7.348021737163288e-11, -4.633683144686386e-12,  2.476493697315642e-13, -1.152393164883321e-14,  4.761383146362272e-16, -1.772961786272104e-17,  6.019567042100461e-19,
 -1.879584902917909e-20,  8.974233525359238e-08, -2.717494874577429e-08,  4.319703669784100e-09, -4.690117420535000e-10,  3.890257373032662e-11, -2.622805664471968e-12,
  1.494916323395621e-13, -7.401030568248777e-15,  3.246169939388188e-16, -1.280493367219798e-17,  4.596526902702614e-19, -1.514509437008892e-20,  3.621879738322032e-08,
 -1.172679864154375e-08,  1.996125477670259e-09, -2.316716487671407e-10,  2.049437067108957e-11, -1.470222809916662e-12,  8.896550526109581e-14, -4.666151033832002e-15,
  2.163830786425719e-16, -9.007127355687327e-18,  3.405743648620345e-19, -1.179905762224488e-20,  1.501269509339110e-08, -5.162413910794421e-09,  9.352722091048803e-10,
 -1.153791958818220e-10,  1.082833525459649e-11, -8.224467526420301e-13,  5.258766068979656e-14, -2.908918914479040e-15,  1.420096685482838e-16, -6.212299475585894e-18,
  2.464541442730024e-19, -8.943610485526963e-21,  6.440932914103024e-09, -2.336638631538820e-09,  4.477728392664463e-10, -5.837442207906141e-11,  5.780175583327591e-12,
 -4.624008841728084e-13,  3.108666367555393e-14, -1.804972137875246e-15,  9.234281798905751e-17, -4.226802850205929e-18,  1.751976414917747e-19, -6.632643370067705e-21,
  2.879579536132833e-09, -1.094816414397928e-09,  2.205130506363445e-10, -3.019663122159988e-11,  3.136687144436472e-12, -2.628476875339885e-13,  1.848271900779455e-14,
 -1.120808711844897e-15,  5.980215798573340e-17, -2.850922406584756e-18,  1.229114318226876e-19, -4.833470650218061e-21,  1.347916405635975e-09, -5.335614881201069e-10,
  1.122242921267566e-10, -1.604215221825145e-11,  1.737695581232193e-12, -1.516603280236579e-13,  1.109299098351226e-14, -6.988500571186714e-16,  3.869081396246307e-17,
 -1.911619065691310e-18,  8.531755805840451e-20, -3.469165145619536e-21,  6.613605525551853e-10, -2.707867274773727e-10,  5.908233209542398e-11, -8.759614693847362e-12,
  9.833155623795353e-13, -8.884923845495756e-14,  6.721053765578793e-15, -4.374459960590582e-16,  2.499504195011569e-17, -1.273267467912138e-18,  5.853425186655007e-20,
 -2.449145084066201e-21,  3.381707076978511e-10, -1.422882391269277e-10,  3.198779853627879e-11, -4.886248817675596e-12,  5.647790329653157e-13, -5.250398052573469e-14,
  4.082862079848672e-15, -2.729442238323638e-16,  1.600531437023309e-17, -8.360624057281329e-19,  3.938186643001905e-20, -1.686982177880981e-21,  1.764996361283553e-10,
 -7.582532741123178e-11,  1.744284310426929e-11, -2.726502314279802e-12,  3.223386792279593e-13, -3.063189652478048e-14,  2.433429123895520e-15, -1.660813772176182e-16,
  9.936374323187780e-18, -5.292354155406001e-19,  2.540330486493698e-20, -1.108183482994756e-21,  8.839645155208200e-11, -3.852578513260665e-11,  9.005332115903615e-12,
 -1.430389045995774e-12,  1.717902893137470e-13, -1.657768959838127e-14,  1.336729585434128e-15, -9.256093671258456e-17,  5.615976942365270e-18, -3.032139909424275e-19,
  1.474724098650007e-20, -6.515674068523417e-22,  3.318896735638701e-11, -1.458069638121528e-11,  3.438729413729779e-12, -5.511127543309524e-13,  6.677348726687952e-14,
 -6.499097504952123e-15,  5.284350367971901e-16, -3.688823028655000e-17,  2.255750329516368e-18, -1.227202182180236e-19,  6.012802545580515e-21, -2.675573271804570e-22,
  8.088183163909571e-02, -2.746116581622266e-04,  9.772967964032575e-07, -3.607951917982943e-09,  1.366089491093725e-11, -5.254741830195381e-14,  2.038184518889223e-16,
 -7.934113018881047e-19,  3.089050029765117e-21, -1.200945023861157e-23,  4.655490123070909e-26, -1.799214458285174e-28,  7.536853568829706e-02, -3.454083939848760e-04,
  1.899046735801395e-06, -1.066359424969654e-08,  5.852040469933621e-11, -3.123103714247036e-13,  1.625919674422094e-15, -8.288886157838772e-18,  4.150499416567710e-20,
 -2.046122771407339e-22,  9.948630558329732e-25, -4.777566897755460e-27,  6.545745313941712e-02, -4.556553670002289e-04,  3.638987765664779e-06, -2.710214976507824e-08,
  1.893563425335002e-10, -1.260565394798108e-12,  8.076802002135119e-15, -5.013681043815554e-17,  3.029256068549230e-19, -1.787703263419045e-21,  1.033288036390997e-23,
 -5.862088454196463e-26,  5.300798665263654e-02, -5.584432309960361e-04,  5.918570356285058e-06, -5.535434545686602e-08,  4.754993953720131e-10, -3.835143279474086e-12,
  2.941942318990941e-14, -2.164993821282192e-16,  1.537999830028790e-18, -1.059674448678097e-20,  7.107069142901328e-23, -4.653249049294311e-25,  4.005120571594938e-02,
 -6.132848244512765e-04,  8.252987913808983e-06, -9.479067789751542e-08,  9.818121902933528e-10, -9.414334744195344e-12,  8.490976668295872e-14, -7.281306042962409e-16,
  5.982747310564578e-18, -4.737435523695847e-20,  3.631448231786497e-22, -2.704148263174926e-24,  2.825929817247585e-02, -6.020032125681577e-04,  1.005773671007244e-05,
 -1.397206075441672e-07,  1.719469779763337e-09, -1.933217668765096e-11,  2.023691769537993e-13, -1.997639526542848e-15,  1.876486406881762e-17, -1.688774841004784e-19,
  1.463746974866060e-21, -1.226871346417752e-23,  1.864082440268025e-02, -5.315717621461216e-04,  1.086469136697119e-05, -1.802749144362065e-07,  2.605494736933356e-09,
 -3.398415279107223e-11,  4.088190984983557e-13, -4.602211349092902e-15,  4.898599014107724e-17, -4.968068829978709e-19,  4.829326475043927e-21, -4.520335615562800e-23,
  1.151141338162939e-02, -4.255111301018102e-04,  1.051213044190241e-05, -2.061113354215408e-07,  3.465308821697797e-09, -5.198536440650286e-11,  7.129418332913793e-13,
 -9.084230991614990e-15,  1.087861205697421e-16, -1.234864098558888e-18,  1.337456529369802e-20, -1.389219487754897e-22,  6.666213436885234e-03, -3.110168428751883e-04,
  9.186430237211510e-06, -2.108537704129033e-07,  4.090649299352710e-09, -7.006886881698903e-11,  1.088190707060706e-12, -1.559598469830237e-14,  2.088815031354509e-16,
 -2.638864817297512e-18,  3.167238688392380e-20, -3.631658050715716e-22,  3.627282176430107e-03, -2.089237844757423e-04,  7.303001228950921e-06, -1.945976794980871e-07,
  4.325524434290712e-09, -8.406563834563693e-11,  1.469906597597325e-12, -2.356825096228482e-14,  3.512417402905674e-16, -4.914645239809697e-18,  6.506471987462816e-20,
 -8.199049061212214e-22,  1.858876581121967e-03, -1.297376567671541e-04,  5.315825110130781e-06, -1.632019322689969e-07,  4.129999407394211e-09, -9.055834065990517e-11,
  1.773627058542585e-12, -3.166376562836176e-14,  5.227454710109923e-16, -8.066815010379603e-18,  1.173231727961297e-19, -1.618457193991747e-21,  8.996401958344807e-04,
 -7.488511253593543e-05,  3.564495321367805e-06, -1.252128536517192e-07,  3.586449749042744e-09, -8.827029634736956e-11,  1.927497263410406e-12, -3.814989470777822e-14,
  6.949039389424727e-16, -1.178177876736898e-17,  1.875624256646401e-19, -2.822603629561029e-21,  4.124789892152544e-04, -4.039035537365110e-05,  2.214836981625070e-06,
 -8.844518544582128e-08,  2.851853448912047e-09, -7.841263289603838e-11,  1.900858918266736e-12, -4.154665043654341e-14,  8.319009658486059e-16, -1.544265738126364e-17,
  2.682088318426751e-19, -4.389197991033515e-21,  1.798114221660010e-04, -2.046514842853938e-05,  1.282753258812630e-06, -5.787758782385982e-08,  2.090181106479175e-09,
 -6.391642749849960e-11,  1.713228961947123e-12, -4.119885589877413e-14,  9.037147479374809e-16, -1.830791886041909e-17,  3.458350779554732e-19, -6.136323324399526e-21,
  7.483499572629978e-05, -9.794306235836217e-06,  6.965991741761349e-07, -3.530817600398075e-08,  1.421208078798721e-09, -4.812901088001629e-11,  1.420971883432034e-12,
 -3.746391888795135e-14,  8.973264458052867e-16, -1.977788235666004e-17,  4.051553285938006e-19, -7.772752668618523e-21,  2.987414870228219e-05, -4.452845840965819e-06,
  3.568866294289658e-07, -2.020914635121818e-08,  9.024143317120844e-10, -3.370465808756217e-11,  1.092032482215228e-12, -3.145906407809822e-14,  8.201661851250225e-16,
 -1.960933168125172e-17,  4.344031528404702e-19, -8.986492542260130e-21,  1.149958603075858e-05, -1.934870415458273e-06,  1.736139209219597e-07, -1.092480262311811e-08,
  5.387270666923011e-10, -2.210247092072341e-11,  7.830260682783099e-13, -2.456519287660971e-14,  6.949391626080828e-16, -1.797097601830503e-17,  4.293272523254080e-19,
 -9.551692282110088e-21,  4.293742545691390e-06, -8.088338486514987e-07,  8.074425206336551e-08, -5.616945473116522e-09,  3.045139604090546e-10, -1.366906308326231e-11,
  5.275898504436196e-13, -1.796514221664239e-14,  5.497718086011513e-16, -1.533222717498681e-17,  3.939198713830194e-19, -9.400388171714357e-21,  1.565382840429011e-06,
 -3.275890655334849e-07,  3.616368710723087e-08, -2.766993399423202e-09,  1.641851137279881e-10, -8.031451064351662e-12,  3.365087331152724e-13, -1.239546588099606e-14,
  4.090512309077686e-16, -1.226632588501035e-17,  3.379746301828551e-19, -8.627827230128095e-21,  5.613052578239681e-07, -1.295320343694702e-07,  1.571971035922668e-08,
 -1.316225635507504e-09,  8.510073266161132e-11, -4.518243111737314e-12,  2.047431787375102e-13, -8.130488722292095e-15,  2.884009665126692e-16, -9.271012545078085e-18,
  2.731545108292281e-19, -7.438795450852325e-21,  1.995406780329332e-07, -5.041623968384670e-08,  6.686947161277096e-09, -6.096229305223197e-10,  4.275350617171657e-11,
 -2.453524103970281e-12,  1.197877161177247e-13, -5.109947254082033e-15,  1.941823914835007e-16, -6.670510522304204e-18,  2.095281099998601e-19, -6.069565266637830e-21,
  7.093428546950182e-08, -1.948590053285225e-08,  2.808278578910052e-09, -2.773255519190696e-10,  2.099856104011830e-11, -1.296989720457939e-12,  6.795452639456544e-14,
 -3.102453871115259e-15,  1.258601951436822e-16, -4.604785189166958e-18,  1.537140258425314e-19, -4.721976556113438e-21,  2.544788599239047e-08, -7.548326131370655e-09,
  1.175130972900113e-09, -1.250463719487874e-10,  1.017357688074359e-11, -6.733122331321514e-13,  3.770086089020902e-14, -1.834927711183909e-15,  7.917330224522285e-17,
 -3.074222800122717e-18,  1.086903690560612e-19, -3.529263388335881e-21,  9.301797220161681e-09, -2.958926593786863e-09,  4.946509039393002e-10, -5.641150634803823e-11,
  4.906822550138567e-12, -3.463459318610074e-13,  2.063425883893496e-14, -1.066180191561625e-15,  4.873586767923314e-17, -2.000781230250376e-18,  7.465067864872220e-20,
 -2.553262915210641e-21,  3.497916338547606e-09, -1.185191866127870e-09,  2.114637490661747e-10, -2.570099608213984e-11,  2.377586640421535e-12, -1.781031310216282e-13,
  1.123745534083853e-14, -6.137015521501089e-16,  2.959339611781130e-17, -1.279319762344236e-18,  5.017651413604053e-20, -1.800951074326853e-21,  1.366068364389680e-09,
 -4.896749801036526e-10,  9.266524289114586e-11, -1.193257285036117e-11,  1.167562076326058e-12, -9.233639764706831e-14,  6.139455531524362e-15, -3.527015654660505e-16,
  1.786046637730322e-17, -8.095016609605371e-19,  3.323572991888920e-20, -1.246782151125967e-21,  5.588116586493964e-10, -2.104736576398173e-10,  4.197221600142548e-11,
 -5.691490239518740e-12,  5.856097638049776e-13, -4.862444387619601e-14,  3.389021307981954e-15, -2.037692692919649e-16,  1.078346103842240e-17, -5.100235965396613e-19,
  2.182147769477707e-20, -8.518495170650514e-22,  2.410370350593907e-10, -9.474333406963028e-11,  1.977742768868719e-11, -2.806101466824301e-12,  3.017615789590182e-13,
 -2.615272038573097e-14,  1.900007903541297e-15, -1.189208358513044e-16,  6.542607891361974e-18, -3.213004272823245e-19,  1.425637003451015e-20, -5.764366579595375e-22,
  1.099671111802038e-10, -4.480149850306615e-11,  9.722537982978167e-12, -1.433781794860638e-12,  1.601134996590916e-13, -1.439454811442161e-14,  1.083591966990969e-15,
 -7.019577742476154e-17,  3.992735719170776e-18, -2.025050891455675e-19,  9.270276425719661e-21, -3.863064176054718e-22,  5.285753473684432e-11, -2.216830453248025e-11,
  4.965989695049916e-12, -7.558963543446524e-13,  8.706979668194122e-14, -8.067316274916651e-15,  6.253127088629582e-16, -4.167252681501339e-17,  2.436296426784812e-18,
 -1.268936030257028e-19,  5.960406978458155e-21, -2.546323904625062e-22,  2.626377879317470e-11, -1.126187691069306e-11,  2.585300693944099e-12, -4.032719064615185e-13,
  4.757978286423254e-14, -4.512601531226452e-15,  3.578010378316502e-16, -2.437476828088295e-17,  1.455695577239196e-18, -7.739986927966927e-20,  3.708984737326724e-21,
 -1.615384231961330e-22,  1.270054032616750e-11, -5.530172595183596e-12,  1.291341230809100e-12, -2.049028198691220e-13,  2.458401777969237e-14, -2.370007449300234e-15,
  1.909205341464034e-16, -1.320785540717945e-17,  8.006401190298443e-19, -4.318972528323951e-20,  2.098807057495644e-21, -9.265388658293979e-23,  4.674731667762822e-12,
 -2.052936248608278e-12,  4.839587745575733e-13, -7.752853299500056e-14,  9.389395851427456e-15, -9.134867087407810e-16,  7.424376363576235e-17, -5.180589406228909e-18,
  3.166716457184079e-19, -1.722125708975672e-20,  8.434512241000985e-22, -3.751787991852886e-23,  7.979875269345249e-02, -2.669628279016748e-04,  9.352789787666126e-07,
 -3.397526764382192e-09,  1.265711959507229e-11, -4.791157865486351e-14,  1.829243101933940e-16, -7.011346591586646e-19,  2.688407052405759e-21, -1.029627241920184e-23,
  3.932349007475514e-26, -1.497639182471702e-28,  7.401649828981965e-02, -3.307124163904394e-04,  1.776502097400309e-06, -9.775193529274336e-09,  5.264636653021452e-11,
 -2.759298243997560e-13,  1.411370204382219e-15, -7.071295452213189e-18,  3.480737047905698e-20, -1.687203417642573e-22,  8.067676876570348e-25, -3.810840841016992e-27,
  6.369106598234575e-02, -4.277947130633885e-04,  3.331141062292673e-06, -2.426406492772495e-08,  1.659751755591770e-10, -1.082529470273497e-12,  6.799547734328329e-15,
 -4.139792003950599e-17,  2.454260707065377e-19, -1.421669055476649e-21,  8.068225323436103e-24, -4.495545313946005e-26,  5.086487913219243e-02, -5.136279309099456e-04,
  5.297553825641165e-06, -4.832358047497733e-08,  4.053934854719496e-10, -3.196593329033537e-12,  2.399280640925360e-14, -1.728761097052073e-16,  1.203112867320712e-18,
 -8.124537146132439e-21,  5.342816493754210e-23, -3.431206374583803e-25,  3.772326914879780e-02, -5.515574440982174e-04,  7.203880901902147e-06, -8.048381590702546e-08,
  8.123579049301444e-10, -7.600999713382863e-12,  6.696470725234511e-14, -5.613839871167159e-16,  4.512404843021256e-18, -3.497499964224242e-20,  2.625540249321336e-22,
 -1.915518950297944e-24,  2.600221392828882e-02, -5.278079724032255e-04,  8.534204915942806e-06, -1.150562148651989e-07,  1.377192433182005e-09, -1.508390777884307e-11,
  1.540028033693624e-13, -1.484114376988238e-15,  1.362090207414927e-17, -1.198492983360047e-19,  1.016219911129075e-21, -8.336899903313714e-24,  1.667560804049300e-02,
 -4.526471302047550e-04,  8.930704721544960e-06, -1.435321884832517e-07,  2.014340333996206e-09, -2.555698727438166e-11,  2.994590471440343e-13, -3.287108196703327e-15,
  3.414678342034910e-17, -3.382423908416214e-19,  3.213500518181932e-21, -2.941511554759243e-23,  9.963132103912533e-03, -3.504382467144791e-04,  8.339944848175302e-06,
 -1.581342731378119e-07,  2.577975773953055e-09, -3.757135220011625e-11,  5.013087111274367e-13, -6.221981513334462e-15,  7.264944489676623e-17, -8.047537155851809e-19,
  8.511932682681784e-21, -8.639900929035985e-23,  5.554545229741682e-03, -2.466316964736752e-04,  7.006863127828287e-06, -1.553313288060213e-07,  2.918626598926765e-09,
 -4.851698049761017e-11,  7.323780425916790e-13, -1.021542622941680e-14,  1.332967267815475e-16, -1.642136366291429e-18,  1.923499846426797e-20, -2.153997961677148e-22,
  2.895152599550480e-03, -1.587802752303318e-04,  5.333242696935383e-06, -1.371264820647532e-07,  2.949466923009528e-09, -5.558384937289474e-11,  9.439638611301582e-13,
 -1.472005808185731e-14,  2.135966185176229e-16, -2.912783719636140e-18,  3.761483112949994e-20, -4.627067898060381e-22,  1.413997504683362e-03, -9.404538077852679e-05,
  3.700856483962850e-06, -1.095690417171650e-07,  2.681427771041978e-09, -5.697916552406160e-11,  1.083305063729662e-12, -1.879981038561746e-14,  3.020602623238030e-16,
 -4.541080378840738e-18,  6.439956824939883e-20, -8.669456543765642e-22,  6.488343684809122e-04, -5.152332921514165e-05,  2.355230067688024e-06, -7.976198256769952e-08,
  2.208613342983058e-09, -5.266153547368471e-11,  1.115921882530306e-12, -2.146386797952595e-14,  3.803974773245574e-16, -6.281703364794184e-18,  9.749188259654264e-20,
 -1.431503152265660e-21,  2.805892270398797e-04, -2.624617208484225e-05,  1.382586129660227e-06, -5.323015489897696e-08,  1.659188158663318e-09, -4.419158917654128e-11,
  1.039495955129249e-12, -2.207726754625934e-14,  4.300785121724044e-16, -7.775512106641039e-18,  1.316505285482039e-19, -2.102090315226637e-21,  1.147668897798254e-04,
 -1.249708873946810e-05,  7.529859841832394e-07, -3.276764494672030e-08,  1.144202587239036e-09, -3.389909247753384e-11,  8.817978980886145e-13, -2.060769682625036e-14,
  4.398422624237711e-16, -8.679463022569067e-18,  1.598554824950191e-19, -2.767908545810953e-21,  4.458248660606023e-05, -5.592414159469974e-06,  3.827236962252941e-07,
 -1.872226677215480e-08,  7.290300516101097e-10, -2.392950648273560e-11,  6.858851905826311e-13, -1.758000307955200e-14,  4.098458144424230e-16, -8.801944380934134e-18,
  1.758593045800193e-19, -3.293412677721475e-21,  1.652610816839640e-05, -2.365610487044276e-06,  1.826703381952330e-07, -9.992697474825130e-09,  4.320011463800747e-10,
 -1.564953097845094e-11,  4.925502435756804e-13, -1.380213704976929e-14,  3.504292203336637e-16, -8.168002502058326e-18,  1.765679930436753e-19, -3.567431965587015e-21,
  5.877351814837129e-06, -9.517786380184315e-07,  8.240917047155460e-08, -5.015784734583731e-09,  2.397143548639938e-10, -9.547770056151774e-12,  3.288583589744419e-13,
 -1.004341966838816e-14,  2.769055511961146e-16, -6.985923913379632e-18,  1.629708268471618e-19, -3.543605185215281e-21,  2.017712684090378e-06, -3.666963096783776e-07,
  3.538762790571321e-08, -2.384660836176042e-09,  1.254590220977822e-10, -5.473694190587866e-12,  2.056270460261957e-13, -6.823130362438619e-15,  2.036932450515657e-16,
 -5.547111210512312e-18,  1.392916597698367e-19, -3.251492428426547e-21,  6.732932440153549e-07, -1.362872895380652e-07,  1.457402445719699e-08, -1.082086577912642e-09,
  6.240678896178442e-11, -2.971356312097277e-12,  1.213304194517020e-13, -4.360552161535581e-15,  1.405420640848785e-16, -4.120003058341356e-18,  1.110687238060483e-19,
 -2.776410796338282e-21,  2.200768415792358e-07, -4.925876461959298e-08,  5.803810896900823e-09, -4.725055982936324e-10,  2.974617283446669e-11, -1.539730904461531e-12,
  6.810264495613419e-14, -2.642438280254811e-15,  9.167104111594624e-17, -2.884619282241690e-18,  8.326147562195956e-20, -2.223027119804026e-21,  7.107115265477280e-08,
 -1.746671384706276e-08,  2.254733219411588e-09, -2.003031998156564e-10,  1.370532247680737e-11, -7.682314174504014e-13,  3.667328482024503e-14, -1.531097690403813e-15,
  5.699338768554053e-17, -1.919337140939796e-18,  5.914736888653350e-20, -1.682140348710796e-21,  2.288996233017175e-08, -6.134512388350726e-09,  8.627003886037613e-10,
 -8.321451912539725e-11,  6.160860047550982e-12, -3.724445236739081e-13,  1.911686862823138e-14, -8.557499248305228e-16,  3.406554102007282e-17, -1.223880403725344e-18,
  4.014588925631950e-20, -1.212649540742993e-21,  7.427543935143633e-09, -2.155919704383027e-09,  3.284096519725815e-10, -3.422032448288456e-11,  2.728657847038315e-12,
 -1.771428753113337e-13,  9.737297884844160e-15, -4.655983467733203e-16,  1.975057800533676e-17, -7.544457854748106e-19,  2.625669891424586e-20, -8.397460682625592e-22,
  2.454601898226172e-09, -7.664059727165523e-10,  1.257167909595093e-10, -1.407619467848258e-11,  1.202959562048478e-12, -8.348419909627104e-14,  4.893545138700638e-15,
 -2.489350887548897e-16,  1.120955323714486e-17, -4.535973760433061e-19,  1.669046255939505e-20, -5.632777916342166e-22,  8.354186493585491e-10, -2.786737191415906e-10,
  4.892682656044636e-11, -5.853932770032474e-12,  5.334182558335902e-13, -3.938142653532876e-14,  2.450324162181135e-15, -1.320334985558109e-16,  6.285156757593879e-18,
 -2.683523830118001e-19,  1.039993873419578e-20, -3.690061870395739e-22,  2.961112274254249e-10, -1.047993761329321e-10,  1.957001224799589e-11, -2.487463589847413e-12,
  2.403488016555868e-13, -1.877920097276019e-14,  1.234173624633322e-15, -7.011137044072182e-17,  3.512302775770578e-18, -1.575466380903891e-19,  6.404040216218311e-21,
 -2.379371174747247e-22,  1.104542629152356e-10, -4.118746387585808e-11,  8.126971489224257e-12, -1.090616181130105e-12,  1.110901193804811e-13, -9.134796063214527e-15,
  6.307418151965985e-16, -3.758379601440358e-17,  1.971742139186164e-18, -9.248066282186431e-20,  3.925054292542079e-21, -1.520402405637519e-22,  4.374137703606386e-11,
 -1.706430114358795e-11,  3.533541125123526e-12, -4.973823175873897e-13,  5.307602236907362e-14, -4.565760920530466e-15,  3.293288475110826e-16, -2.047030050818189e-17,
  1.118713636735682e-18, -5.458665361784212e-20,  2.407088063083617e-21, -9.674863650995693e-23,  1.848699969717570e-11, -7.491717011279881e-12,  1.616450127882840e-12,
 -2.370188676769133e-13,  2.632159590305038e-14, -2.353670495822779e-15,  1.762617542233677e-16, -1.136130716380401e-17,  6.431182708109717e-19, -3.246641038840065e-20,
  1.479588988346113e-21, -6.139092110053719e-23,  8.324240654110959e-12, -3.479039733167467e-12,  7.763908566237442e-13, -1.177318391918285e-13,  1.351130473127143e-14,
 -1.247403128342393e-15,  9.635518805211514e-17, -6.399995302428664e-18,  3.729602397323625e-19, -1.936527426763643e-20,  9.068979918756589e-22, -3.863165675502603e-23,
  3.925887040145796e-12, -1.680021390411506e-12,  3.848113249476111e-13, -5.989208587397016e-14,  7.050994241729783e-15, -6.673272677128721e-16,  5.280397828363234e-17,
 -3.590111849834003e-18,  2.139977431067736e-19, -1.135737245389426e-20,  5.432735920916010e-22, -2.362072722834941e-23,  1.828930046492433e-12, -7.955841527938936e-13,
  1.855720957355839e-13, -2.941321339288225e-14,  3.525162860266991e-15, -3.394844123999258e-16,  2.731992920742875e-17, -1.888118369080580e-18,  1.143450219566694e-19,
 -6.162487616653564e-21,  2.991962541243444e-22, -1.319678928031372e-23,  6.590713513038126e-13, -2.893189766084465e-13,  6.817317561580555e-14, -1.091611249979876e-14,
  1.321439625903657e-15, -1.285045556591168e-16,  1.043967023209420e-17, -7.281495032299787e-19,  4.449070119682949e-20, -2.418508787854768e-21,  1.184048588667447e-22,
 -5.264764631397605e-24,  7.874561239970367e-02, -2.596403059280102e-04,  8.956928742792765e-07, -3.202446674332391e-09,  1.174124850910981e-11, -4.374758712791770e-14,
  1.644433146736061e-16, -6.207451338120827e-19,  2.344536306996031e-21, -8.847480944328981e-24,  3.329638045184259e-26, -1.249931041170955e-28,  7.272134942101476e-02,
 -3.169556968704146e-04,  1.664077495539567e-06, -8.975225134004009e-09,  4.745108864302168e-11, -2.443124288059296e-13,  1.228097095440212e-15, -6.048727796914228e-18,
  2.927608254939966e-20, -1.395662219579838e-22,  6.564684481100755e-25, -3.050819937477080e-27,  6.203140295348659e-02, -4.022667041666760e-04,  3.055219112166898e-06,
 -2.177317895003883e-08,  1.458669807849456e-10, -9.324077207137388e-13,  5.743085427504794e-15, -3.430455091806585e-17,  1.996083550480638e-19, -1.135253400284683e-21,
  6.327618333928678e-24, -3.463612812489555e-26,  4.889160518922559e-02, -4.734614285588966e-04,  4.754575912855812e-06, -4.231902385321972e-08,  3.468491978033380e-10,
 -2.674758098894139e-12,  1.965007809981891e-14, -1.386715691871368e-16,  9.457195814406631e-19, -6.261196460874015e-21,  4.038356025813216e-23, -2.544544428840956e-25,
  3.562648209351495e-02, -4.975796702816151e-04,  6.311313741822952e-06, -6.861999243945042e-08,  6.752158637714607e-10, -6.167249723919059e-12,  5.309177805101059e-14,
 -4.352597395373914e-16,  3.423661875025041e-18, -2.598238947535145e-20,  1.910691880882747e-22, -1.366145417744128e-24,  2.401928522081991e-02, -4.647041245910457e-04,
  7.276399362091222e-06, -9.524703260704093e-08,  1.109347576116506e-09, -1.184097271318661e-11,  1.179531773834471e-13, -1.110098556714920e-15,  9.957483778673289e-18,
 -8.568704174587043e-20,  7.109711230988728e-22, -5.710498187937686e-24,  1.499772765595652e-02, -3.875795933272280e-04,  7.386011980840358e-06, -1.150305741770577e-07,
  1.568209028044748e-09, -1.936138692632784e-11,  2.210504298403231e-13, -2.366757900398243e-15,  2.400251781566478e-17, -2.322882276898940e-19,  2.157507336909742e-21,
 -1.931835615231585e-23,  8.683719692505382e-03, -2.906610610016982e-04,  6.666988507423012e-06, -1.222991986647410e-07,  1.934003442748625e-09, -2.739242025900088e-11,
  3.557135472525213e-13, -4.301803291555892e-15,  4.898936897563093e-17, -5.297122452075002e-19,  5.473007497649044e-21, -5.430081551529545e-23,  4.669353863971158e-03,
 -1.973068197850251e-04,  5.393901417060705e-06, -1.155302290801329e-07,  2.103166339105727e-09, -3.394003009999958e-11,  4.981360127754616e-13, -6.764056036081049e-15,
  8.601288763048207e-17, -1.033562672144979e-18,  1.181800066935349e-20, -1.292782409399085e-22,  2.335972262552635e-03, -1.219712832917754e-04,  3.937823736168289e-06,
 -9.772488373608161e-08,  2.034571571397987e-09, -3.718970707362363e-11,  6.135899698230385e-13, -9.307990242272094e-15,  1.315369516300662e-16, -1.748576477390900e-18,
  2.203042001952363e-20, -2.645957922642126e-22,  1.089628485477132e-03, -6.904674009512932e-05,  2.609969069665008e-06, -7.453133098204596e-08,  1.764262857993478e-09,
 -3.633929784570321e-11,  6.708115750162203e-13, -1.131852836735471e-14,  1.770199616380526e-16, -2.593085111465612e-18,  3.586354955861896e-20, -4.712158048409707e-22,
  4.751161776230026e-04, -3.598083496153243e-05,  1.579566104318631e-06, -5.157687558836867e-08,  1.380835006894067e-09, -3.190056446199583e-11,  6.560825288369821e-13,
 -1.226490596972322e-14,  2.115175071207301e-16, -3.402443716040629e-18,  5.148560971682573e-20, -7.376898021897128e-22,  1.942389374631785e-04, -1.734853624058427e-05,
  8.778172253387771e-07, -3.258348039456101e-08,  9.818231330794525e-10, -2.533282166941880e-11,  5.782433623192772e-13, -1.193424569034808e-14,  2.261981487981495e-16,
 -3.983130997320666e-18,  6.574796561393582e-20, -1.024346624957966e-21,  7.471575719706994e-05, -7.779750173882494e-06,  4.504945660360658e-07, -1.890527151746901e-08,
  6.382521427667435e-10, -1.831951387900945e-11,  4.624446586674154e-13, -1.050270562503083e-14,  2.181132552835621e-16, -4.192362617126973e-18,  7.528188132351821e-20,
 -1.272011421077510e-21,  2.715193146026976e-05, -3.262293571304958e-06,  2.147466618917848e-07, -1.013613463598239e-08,  3.817542157039605e-10, -1.214359775159332e-11,
  3.378706474278424e-13, -8.418029567034281e-15,  1.909998465341579e-16, -3.996494124665274e-18,  7.787026015061214e-20, -1.423446733984986e-21,  9.366032073695655e-06,
 -1.286577878309295e-06,  9.567104832482767e-08, -5.053972421903787e-09,  2.114709456429562e-10, -7.428322627413917e-12,  2.270637368473595e-13, -6.187887515177640e-15,
  1.529727159594258e-16, -3.475428943669698e-18,  7.329900377588083e-20, -1.446165578390672e-21,  3.083508091281856e-06, -4.801978233858174e-07,  4.009631260031708e-08,
 -2.359353489201550e-09,  1.092375945142985e-10, -4.222427014130596e-12,  1.413521978333360e-13, -4.201239908555049e-15,  1.128581767158174e-16, -2.777034005927787e-18,
  6.324559320865263e-20, -1.343714445381052e-21,  9.749591234017990e-07, -1.707879533663360e-07,  1.592162362138547e-08, -1.038708617337058e-09,  5.300491588408171e-11,
 -2.246698994375141e-12,  8.211216076943845e-14, -2.654083580772959e-15,  7.726696243141359e-17, -2.054022528994900e-18,  5.039409103895525e-20, -1.150331590375245e-21,
  2.981810471939196e-07, -5.832340709465524e-08,  6.036724059292047e-09, -4.346445736320919e-10,  2.434927485563188e-11, -1.127806859036000e-12,  4.485852025034130e-14,
 -1.572244073305091e-15,  4.947037155400304e-17, -1.417135531878261e-18,  3.736451986064039e-20, -9.142440402916080e-22,  8.892827988176127e-08, -1.928535281722149e-08,
  2.204152266011194e-09, -1.743459529721550e-10,  1.067971570090044e-11, -5.386159774957798e-13,  2.323948870149500e-14, -8.805755851600878e-16,  2.986211391089671e-17,
 -9.193772484957315e-19,  2.598511739000117e-20, -6.798939155356509e-22,  2.609852417645686e-08, -6.232294823894937e-09,  7.822721925056472e-10, -6.766316550131290e-11,
  4.513562051069863e-12, -2.469488062227396e-13,  1.151918939536730e-14, -4.703951922013148e-16,  1.714218956292830e-17, -5.656360521840178e-19,  1.709226758744305e-20,
 -4.770074150272730e-22,  7.613829036783410e-09, -1.988582270384586e-09,  2.726285658024735e-10, -2.566409357964384e-11,  1.856381097274410e-12, -1.097594355444213e-13,
  5.515341023174843e-15, -2.419164640078338e-16,  9.443963404954746e-18, -3.329884716850803e-19,  1.072727991482200e-20, -3.184480541193416e-22,  2.232687915110319e-09,
 -6.335057146569430e-10,  9.433422205469571e-11, -9.617051463957310e-12,  7.509620785746578e-13, -4.778553978498464e-14,  2.576816273241902e-15, -1.209682404309148e-16,
  5.041657489667056e-18, -1.893441359384952e-19,  6.482927412510822e-21, -2.041060009130758e-22,  6.660423502938518e-10, -2.039208928705479e-10,  3.279188592725447e-11,
 -3.601719626428660e-12,  3.021772031050772e-13, -2.060310964820886e-14,  1.187369037953235e-15, -5.942631339561883e-17,  2.634448563265183e-18, -1.050125794973196e-19,
  3.808491750502209e-21, -1.267538348896783e-22,  2.047022921531204e-10, -6.716388077724652e-11,  1.159355580587073e-11, -1.364433914676594e-12,  1.223702559583386e-13,
 -8.897668056941699e-15,  5.455686368613003e-16, -2.898692282836763e-17,  1.361329314005783e-18, -5.737265583011718e-20,  2.195802073708491e-21, -7.697812465172443e-23,
  6.566031697868550e-11, -2.292616450480931e-11,  4.221345831096874e-12, -5.292315685308623e-13,  5.046245040415999e-14, -3.892779895018035e-15,  2.527145400703893e-16,
 -1.418795217616155e-17,  7.027428122157272e-19, -3.117973891624058e-20,  1.254157443223919e-21, -4.612860667631265e-23,  2.225780509419603e-11, -8.211585013224504e-12,
  1.602144335353072e-12, -2.126412740716827e-13,  2.142937152529340e-14, -1.744055484075960e-15,  1.192364154795912e-16, -7.037474183140677e-18,  3.658316184340296e-19,
 -1.700770352193057e-20,  7.157237293317000e-22, -2.749828010822945e-23,  8.062217748199780e-12, -3.119991732835366e-12,  6.405335348425957e-13, -8.940113239518343e-14,
  9.461999311692177e-15, -8.075216226236394e-16,  5.780337213227580e-17, -3.566589011560706e-18,  1.935404533422216e-19, -9.379436053910798e-21,  4.108922850754683e-22,
 -1.641105185731322e-23,  3.144495467268785e-12, -1.267018206620147e-12,  2.716951205469773e-13, -3.959575737648449e-14,  4.371176533259087e-15, -3.886319034471334e-16,
  2.894316456353058e-17, -1.855660533126838e-18,  1.045027780492508e-19, -5.249515508973922e-21,  2.380958354849249e-22, -9.833770366988102e-24,  1.321509365462367e-12,
 -5.502521591177660e-13,  1.222956016802493e-13, -1.846989112264142e-14,  2.111315105022628e-15, -1.941791656446803e-16,  1.494403280798962e-17, -9.890670631818878e-19,
  5.744033998335678e-20, -2.972621417991253e-21,  1.387672285370401e-22, -5.893005282573655e-24,  5.896888085588375e-13, -2.518014802458819e-13,  5.753786885786004e-14,
 -8.933895651188975e-15,  1.049328399193895e-15, -9.908771169346730e-17,  7.823468444172959e-18, -5.307919908332205e-19,  3.157479432600773e-20, -1.672455079480728e-21,
  7.984903325779950e-23, -3.465365968130845e-24,  2.640131534618473e-13, -1.147248183515901e-13,  2.672856252123428e-14, -4.231517042281082e-15,  5.065629180227486e-16,
 -4.872903613813589e-17,  3.917198030265742e-18, -2.704378751823108e-19,  1.636108365623866e-20, -8.808889639061539e-22,  4.272724908990616e-23, -1.882845938277454e-24,
  9.301267463653300e-14, -4.081343243673984e-14,  9.612430748672438e-15, -1.538433764646957e-15,  1.861450211558897e-16, -1.809337553655785e-17,  1.469227474484960e-18,
 -1.024302892245663e-19,  6.255860975903154e-21, -3.399224660358373e-22,  1.663490633002894e-23, -7.393551827534178e-25,  7.772114329872200e-02, -2.526253518864505e-04,
  8.583624794575225e-07, -3.021377638693151e-09,  1.090439791056125e-11, -4.000132546921950e-14,  1.480666928386229e-16, -5.505694480829734e-19,  2.048732773321613e-21,
 -7.619327616177441e-24,  2.825979082287318e-26, -1.045905248972356e-28,  7.147948750073413e-02, -3.040613422452255e-04,  1.560773886839469e-06, -8.253552002742375e-09,
  4.284639290554228e-11, -2.167690763702080e-13,  1.071127737219880e-15, -5.187466540902332e-18,  2.469372496715852e-20, -1.158053719364266e-22,  5.359384951894853e-25,
 -2.451022373262469e-27,  6.046961908476407e-02, -3.788317582147436e-04,  2.807352202527334e-06, -1.958131757003759e-08,  1.285229403158231e-10, -8.054143033509795e-13,
  4.866170303980681e-15, -2.852497076402965e-17,  1.629505363850540e-19, -9.101670627728999e-22,  4.983656666094924e-24, -2.680590469468604e-26,  4.707074447566070e-02,
 -4.373656968892881e-04,  4.278359346565276e-06, -3.717303547293128e-08,  2.977723761678337e-10, -2.246527794749240e-12,  1.615917303544805e-14, -1.117238717933859e-16,
  7.468840525161149e-19, -4.849249335674584e-21,  3.068433847650034e-23, -1.897433034947474e-25,  3.373217677910094e-02, -4.502082053996610e-04,  5.548837621367919e-06,
 -5.873799841219088e-08,  5.636862238569299e-10, -5.027728672941502e-12,  4.230756216916246e-14, -3.393033545670792e-16,  2.612520538892484e-18, -1.941848828840281e-20,
  1.399269382209070e-22, -9.807654784755502e-25,  2.227005579574324e-02, -4.107800936558599e-04,  6.232588137932716e-06, -7.924817109228910e-08,  8.984938485065356e-10,
 -9.349748879443797e-12,  9.090409210268265e-14, -8.357823536559833e-16,  7.329392243962908e-18, -6.170210338969328e-20,  5.011250843630446e-22, -3.941784197123686e-24,
  1.355740877257343e-02, -3.336140746015141e-04,  6.144290349184670e-06, -9.276986532157198e-08,  1.229083399244010e-09, -1.477178421021118e-11,  1.643869639969441e-13,
 -1.717350554072147e-15,  1.700843604219579e-17, -1.608626889838692e-19,  1.461091384948365e-21, -1.280081442945329e-23,  7.619143851236085e-03, -2.427082795328726e-04,
  5.368381300035362e-06, -9.531205816426650e-08,  1.462615691233605e-09, -2.013977333897966e-11,  2.546196665827516e-13, -3.001274404142219e-15,  3.334524252465728e-17,
 -3.520479108762911e-19,  3.554059314721647e-21, -3.447585147009015e-23,  3.958393261816234e-03, -1.591766652450095e-04,  4.188982966818244e-06, -8.671961159274256e-08,
  1.530050066159654e-09, -2.397784030542340e-11,  3.422738212793499e-13, -4.525815158608284e-15,  5.610028451441089e-17, -6.577092167628982e-19,  7.342964123924151e-21,
 -7.848407219086877e-23,  1.904378015668378e-03, -9.465782196987796e-05,  2.938267566750487e-06, -7.040271457263864e-08,  1.419160298674312e-09, -2.516799881673689e-11,
  4.035237834572763e-13, -5.956347415749021e-15,  8.199405549685504e-17, -1.062771409560457e-18,  1.306644511134784e-20, -1.532561560201081e-22,  8.501478601654391e-04,
 -5.131465629233191e-05,  1.863542980245188e-06, -5.133992565365973e-08,  1.175776440172441e-09, -2.348001837780220e-11,  4.209253992561004e-13, -6.906690897697235e-15,
  1.051667323911372e-16, -1.501346659246050e-18,  2.025371530175938e-20, -2.597758666850404e-22,  3.530187207931614e-04, -2.548786800224671e-05,  1.074631865041472e-06,
 -3.383639701438240e-08,  8.759863915589178e-10, -1.961114174025404e-11,  3.915148913289555e-13, -7.114571401517503e-15,  1.194107325088380e-16, -1.871326059028914e-18,
  2.761222080352283e-20, -3.861025438122922e-22,  1.367453247749192e-04, -1.165706630393476e-05,  5.665149361770573e-07, -2.027396536490416e-08,  5.906028727700076e-10,
 -1.476327113061167e-11,  3.270292717614028e-13, -6.559428763743232e-15,  1.209717449685747e-16, -2.074933484988672e-18,  3.339290688459726e-20, -5.076685468419398e-22,
  4.958063737912011e-05, -4.934014330468398e-06,  2.745234393767410e-07, -1.110872930260053e-08,  3.625805509738895e-10, -1.008215442706904e-11,  2.469793796033225e-13,
 -5.451083076436038e-15,  1.101483087319227e-16, -2.062226333598936e-18,  3.610481060276167e-20, -5.953067442248043e-22,  1.689378983584178e-05, -1.942966153861363e-06,
  1.229814533555857e-07, -5.599686677489523e-09,  2.039539110115642e-10, -6.286641681155327e-12,  1.697713794392799e-13, -4.111307117211556e-15,  9.077995810264557e-17,
 -1.850515267297312e-18,  3.516093116911797e-20, -6.273189779686054e-22,  5.434783257079089e-06, -7.159040798592377e-07,  5.124113979429041e-08, -2.613138514558448e-09,
  1.057986829047544e-10, -3.602858998431595e-12,  1.069369717109646e-13, -2.833645718963470e-15,  6.819691650904663e-17, -1.509983357556456e-18,  3.106649862317742e-20,
 -5.984490273185014e-22,  1.659730048186853e-06, -2.483566074233943e-07,  1.998726709114272e-08, -1.136502573982305e-09,  5.095770091889757e-11, -1.910909724814365e-12,
  6.215663315235677e-14, -1.797417485394480e-15,  4.703297806433465e-17, -1.128509487850463e-18,  2.508537637597055e-20, -5.206492721305234e-22,  4.842074548068425e-07,
 -8.168266612605496e-08,  7.351008449549170e-09, -4.640233573572249e-10,  2.295616542096692e-11, -9.449138651585870e-13,  3.358530200522152e-14, -1.057072642630089e-15,
  3.000028388910457e-17, -7.782532155775557e-19,  1.865009657697853e-20, -4.161835913924390e-22,  1.359335544256110e-07, -2.566684110548322e-08,  2.569360713245880e-09,
 -1.792751598245230e-10,  9.749911919956897e-12, -4.390840039557412e-13,  1.700375580267431e-14, -5.809383251230042e-16,  1.783752561035956e-17, -4.991197036731705e-19,
  1.286600122265383e-20, -3.080355749952031e-22,  3.702991823828855e-08, -7.772571440050635e-09,  8.609700466999306e-10, -6.611635221763452e-11,  3.938122582296938e-12,
 -1.933970097810782e-13,  8.135440734180112e-15, -3.008796237858951e-16,  9.969178273583529e-18, -3.001559402658994e-19,  8.303485282385346e-21, -2.128178764533403e-22,
  9.881999302371772e-09, -2.290450152259575e-09,  2.792900553496656e-10, -2.350150380433584e-11,  1.527236390812588e-12, -8.150469923611826e-14,  3.712618800749905e-15,
 -1.482013911007123e-16,  5.284397428766420e-18, -1.707579160815047e-19,  5.057122054222604e-21, -1.384262846889303e-22,  2.611378159445757e-09, -6.639582764347567e-10,
  8.865419012591483e-11, -8.137537696371901e-12,  5.746305655196230e-13, -3.320467400429513e-14,  1.632329214644454e-15, -7.011073653710412e-17,  2.682440930907652e-18,
 -9.276969235791252e-20,  2.933503163288867e-21, -8.553867735621854e-23,  6.915628894336505e-10, -1.916119015639183e-10,  2.786476546942528e-11, -2.776816274249368e-12,
  2.121671795236607e-13, -1.322296753497364e-14,  6.990001854196594e-16, -3.219492092374110e-17,  1.317485711905181e-18, -4.861738893072014e-20,  1.636693842917780e-21,
 -5.069782339084563e-23,  1.859700184955597e-10, -5.577498685035821e-11,  8.784199589377405e-12, -9.456172435424300e-13,  7.782112198789806e-14, -5.208986755578542e-15,
  2.949350704682334e-16, -1.451289308727157e-17,  6.329845074134289e-19, -2.483975415402806e-20,  8.873982243203562e-22, -2.910969442829123e-23,  5.150411793038390e-11,
 -1.660602245872452e-11,  2.815702333079608e-12, -3.256812862311193e-13,  2.872612244651419e-14, -2.055568268615050e-15,  1.241200767928604e-16, -6.498287190368531e-18,
  3.008955036335949e-19, -1.250978161969623e-20,  4.725554847563960e-22, -1.635917539684736e-23,  1.490835209887960e-11, -5.131198192195777e-12,  9.308327973535279e-13,
 -1.150166927295358e-13,  1.081445913870450e-14, -8.231026853239561e-16,  5.274883121246747e-17, -2.924901976301418e-18,  1.431548823338185e-19, -6.279111496328202e-21,
  2.497932753050048e-22, -9.090505531834413e-24,  4.576999292397271e-12, -1.669475038564796e-12,  3.218542177148831e-13, -4.221971022022664e-14,  4.206856988913333e-15,
 -3.386667818697380e-16,  2.291220913810727e-17, -1.338739367561153e-18,  6.892061595744885e-20, -3.174399447742520e-21,  1.323916338633495e-22, -5.042798163343453e-24,
  1.510615682800914e-12, -5.795757039626944e-13,  1.179003733471077e-13, -1.630783251726895e-14,  1.710953052502231e-15, -1.447928131647723e-16,  1.028064260096012e-17,
 -6.294009934168666e-19,  3.389856048305894e-20, -1.630960998679882e-21,  7.095265897161293e-23, -2.814937153037060e-24,  5.415490354619716e-13, -2.168724671775181e-13,
  4.619891974640785e-14, -6.688993365963285e-15,  7.337608321197138e-16, -6.483850907431130e-17,  4.800376556645177e-18, -3.060252010257284e-19,  1.713986480143845e-20,
 -8.564608995013822e-22,  3.864852702114843e-23, -1.588472331112477e-24,  2.116029474863019e-13, -8.775413072307358e-14,  1.941846414819433e-14, -2.919990721341899e-15,
  3.323789854114582e-16, -3.044433313317311e-17,  2.333764867053432e-18, -1.538728523086227e-19,  8.903485909388265e-21, -4.591421480486977e-22,  2.136064323220616e-23,
 -9.041508474617344e-25,  8.903513242068123e-14, -3.793011051071516e-14,  8.645009070552293e-15, -1.338883430702971e-15,  1.568665382668491e-16, -1.477708933889837e-17,
  1.164001570623818e-18, -7.879498685974213e-20,  4.677015783873942e-21, -2.472121632645165e-22,  1.177887668462425e-23, -5.101936147653638e-25,  3.821021387047177e-14,
 -1.658523240575468e-14,  3.859188294733400e-15, -6.101998229065350e-16,  7.295851947584300e-17, -7.009895793336039e-18,  5.628542220360489e-19, -3.881505923256249e-20,
  2.345700577655653e-21, -1.261608092769020e-22,  6.113156888706816e-24, -2.691212133692535e-25,  1.314039996431822e-14, -5.763365015341076e-15,  1.356715298507920e-15,
 -2.170273309549326e-16,  2.624639397310201e-17, -2.549907452599128e-18,  2.069593392718365e-19, -1.442182757912996e-20,  8.803992426777632e-22, -4.781650260677634e-23,
  2.338989442737671e-24, -1.039144651225724e-25,  7.672415017482219e-02, -2.459005717543014e-04,  8.231269805440225e-07, -2.853119516541553e-09,  1.013869595485993e-11,
 -3.662555382434527e-14,  1.335288496132153e-16, -4.891892524903714e-19,  1.793722660471822e-21, -6.575782566615984e-24,  2.404010737553700e-26, -8.774094155669390e-29,
  7.028760327373980e-02, -2.919599880809958e-04,  1.465705842204696e-06, -7.601343844031170e-09,  3.875676251305296e-11, -1.927194162071998e-13,  9.363430449616754e-16,
 -4.460035725746398e-18,  2.088597770441111e-20, -9.637686569977730e-23,  4.389440501751694e-25, -1.975914523945687e-27,  5.899776929610665e-02, -3.572790699081233e-04,
  2.584202857928414e-06, -1.764773265892065e-08,  1.135207620639214e-10, -6.976503323492823e-13,  4.135808643197943e-15, -2.379852848094743e-17,  1.335057882045033e-19,
 -7.325355716173917e-22,  3.941341659873203e-24, -2.083654421145564e-26,  4.538702029574237e-02, -4.048454166449886e-04,  3.859451823464844e-06, -3.274806734745929e-08,
  2.564799349201674e-10, -1.893699353531982e-12,  1.334086338680038e-14, -9.039527475942823e-17,  5.925307219007392e-19, -3.773804617210412e-21,  2.343329060360223e-23,
 -1.422460035474724e-25,  3.201586808424851e-02, -4.084909047917047e-04,  4.894947489994820e-06, -5.047135447387838e-08,  4.725621412713771e-10, -4.117515539526475e-12,
  3.387962372963464e-14, -2.658865745336711e-16,  2.004607001050013e-18, -1.459750906964613e-20,  1.031003925234728e-22, -7.085957024850087e-25,  2.072096117923087e-02,
 -3.644923895700446e-04,  5.362057991632811e-06, -6.625719521858691e-08,  7.315490386786782e-10, -7.424292555247414e-12,  7.047755735699259e-14, -6.332289171608846e-16,
  5.430715589583401e-18, -4.473876309221608e-20,  3.557642621001540e-22, -2.741267457325975e-24,  1.231465463581206e-02, -2.885995319859337e-04,  5.139946814591327e-06,
 -7.526896325641296e-08,  9.695021677487121e-10, -1.134699769773962e-11,  1.231247998925899e-13, -1.255474176164864e-15,  1.214645292739975e-17, -1.123021253157033e-19,
  9.977644155805089e-22, -8.555513899178244e-24,  6.727484956054451e-03, -2.039669653089606e-04,  4.352757815564668e-06, -7.482709050993107e-08,  1.114698865991340e-09,
 -1.492755145622210e-11,  1.837970490324116e-13, -2.112284027648317e-15,  2.290266722373546e-17, -2.361595618161962e-19,  2.330134710294473e-21, -2.210504808877251e-23,
  3.382662533955891e-03, -1.294449158236729e-04,  3.280743310643031e-06, -6.566863755309222e-08,  1.123336867628943e-09, -1.710109067810816e-11,  2.374925423337914e-13,
 -3.058888075143961e-15,  3.697116389972009e-17, -4.230000045476605e-19,  4.612272659981866e-21, -4.817869749415104e-23,  1.567906910644623e-03, -7.418009816646733e-05,
  2.214624969010461e-06, -5.124862456692219e-08,  1.000531478100965e-09, -1.722031746058969e-11,  2.683770467426310e-13, -3.855684934895135e-15,  5.171542385194613e-17,
 -6.537293675609476e-19,  7.844933641601407e-21, -8.987503238614150e-23,  6.712126572706258e-04, -3.858324195408085e-05,  1.346455107732687e-06, -3.579491757064390e-08,
  7.933059351492206e-10, -1.536303240011065e-11,  2.675248284450815e-13, -4.269698858250221e-15,  6.330957481233039e-17, -8.809734092479358e-19,  1.159449076301032e-20,
 -1.451932837764644e-22,  2.659906732960463e-04, -1.830349113119038e-05,  7.412322360347845e-07, -2.250855273223137e-08,  5.635840023002534e-10, -1.222886696616628e-11,
  2.370219945361294e-13, -4.187479746081497e-15,  6.841090167283980e-17, -1.044611071368522e-18,  1.503216072868308e-20, -2.051588109229372e-22,  9.784082986553192e-05,
 -7.957403628405628e-06,  3.714094001471508e-07, -1.281537374181740e-08,  3.609459082519437e-10, -8.741884443204580e-12,  1.879433946039251e-13, -3.663888215076170e-15,
  6.575414548227548e-17, -1.098664337018187e-18,  1.724018143115180e-20, -2.557766037112104e-22,  3.351407096234226e-05, -3.185887692405934e-06,  1.702891589046141e-07,
 -6.644042429360253e-09,  2.096494034557933e-10, -5.647687115988102e-12,  1.342597187052875e-13, -2.879765026840227e-15,  5.662072054850983e-17, -1.032581461518188e-18,
  1.762616607651497e-20, -2.836055889109726e-22,  1.073137267800564e-05, -1.180714220840980e-06,  7.183844663077893e-08, -3.154841391704304e-09,  1.111085200189253e-10,
 -3.318307106895443e-12,  8.697071196561584e-14, -2.046995954893497e-15,  4.398357010310962e-17, -8.734281106200738e-19,  1.618259513903950e-20, -2.817815158268913e-22,
  3.226830243432741e-06, -4.073166570225543e-07,  2.804968616308699e-08, -1.380479063406627e-09,  5.406855117338016e-11, -1.784654506102828e-12,  5.142633752500863e-14,
 -1.324833577095693e-15,  3.103618939473147e-17, -6.696264504667207e-19,  1.343783827190443e-20, -2.527124577688599e-22,  9.160367945463990e-07, -1.316021014964150e-07,
  1.020220907681916e-08, -5.603449194345663e-10,  2.432226469550393e-11, -8.845961072682907e-13,  2.795015660140906e-14, -7.861903191045216e-16,  2.003466722377000e-17,
 -4.686493223418492e-19,  1.016582202433587e-20, -2.060776018033466e-22,  2.470544604092008e-07, -4.009842638205955e-08,  3.481309512284172e-09, -2.125145506853713e-10,
  1.018794986326620e-11, -4.070701516880119e-13,  1.406576518534415e-14, -4.309459359318744e-16,  1.191927255962168e-17, -3.016492580770350e-19,  7.058736557261835e-21,
 -1.539482365580585e-22,  6.376793024579460e-08, -1.161192806484602e-08,  1.123358514708912e-09, -7.590953762650631e-11,  4.005552257020063e-12, -1.753032236383520e-13,
  6.606565398919914e-15, -2.199315072128012e-16,  6.587180332956868e-18, -1.799745890848342e-19,  4.534050698986617e-21, -1.061817716401822e-22,  1.588714889444393e-08,
 -3.224237444119071e-09,  3.458508215164583e-10, -2.576561374762411e-11,  1.491315295223352e-12, -7.127115770223737e-14,  2.921411141940634e-15, -1.054037461536997e-16,
  3.410584538866296e-18, -1.003772883176854e-19,  2.716724441600327e-21, -6.817834699706830e-23,  3.858337199602089e-09, -8.670521881619590e-10,  1.026133193332472e-10,
 -8.393372510103796e-12,  5.309729480982799e-13, -2.762145050705757e-14,  1.227884094295648e-15, -4.788598662264224e-17,  1.669761282795632e-18, -5.281166827292071e-20,
  1.532141277791324e-21, -4.111490083682212e-23,  9.237621154886750e-10, -2.283904422524760e-10,  2.967195144418451e-11, -2.653392359310398e-12,  1.827710543089003e-13,
 -1.031421245500279e-14,  4.957091702515296e-16, -2.083580011585508e-17,  7.808201777746956e-19, -2.647159101161302e-20,  8.211914515375641e-22, -2.350832639639261e-23,
  2.208347416001434e-10, -5.968242976609965e-11,  8.467675885004023e-12, -8.241080508300727e-13,  6.156163997292217e-14, -3.754902750640683e-15,  1.944444712225308e-16,
 -8.780788481731575e-18,  3.525903652200480e-19, -1.277671814768549e-20,  4.226687913961618e-22, -1.287416580790123e-23,  5.346927492901743e-11, -1.569189092708162e-11,
  2.418085325865003e-12, -2.548959702439710e-13,  2.055946015478301e-14, -1.349933284735821e-15,  7.503890137395608e-17, -3.627833989451331e-18,  1.555712957963774e-19,
 -6.006415499273822e-21,  2.112458037639239e-22, -6.826086171099767e-24,  1.331783800123292e-11, -4.215390316141336e-12,  7.014455494114573e-13, -7.966949423982025e-14,
  6.905310308442658e-15, -4.859149349860403e-16,  2.887313621346571e-17, -1.488533559641535e-18,  6.791255621172627e-20, -2.783614691097221e-21,  1.037223451248714e-22,
 -3.543825488024511e-24,  3.469381978058852e-12, -1.176026771192615e-12,  2.100060713885482e-13, -2.555435342051394e-14,  2.367554460182458e-15, -1.776623392946942e-16,
  1.123176662079080e-17, -6.147186040319644e-19,  2.971147404061083e-20, -1.287596700537873e-21,  5.063196553518352e-23, -1.822181422742304e-24,  9.614056705835902e-13,
 -3.464431410378684e-13,  6.594638610290176e-14, -8.543733672627682e-15,  8.411581605802804e-16, -6.693893993442132e-17,  4.478738061732990e-18, -2.589142224264878e-19,
  1.319349873859706e-20, -6.017193551561081e-22,  2.485857635520350e-23, -9.382797392256141e-25,  2.880006627750447e-13, -1.094820130328575e-13,  2.205446989718960e-14,
 -3.021344736973266e-15,  3.140501954499007e-16, -2.633981922775965e-17,  1.854124870863473e-18, -1.125752525156978e-19,  6.014943130492176e-21, -2.871839931753043e-22,
  1.240157934413423e-23, -4.885341975609942e-25,  9.450803206258826e-14, -3.759869183281847e-14,  7.952872228714511e-15, -1.143449294234644e-15,  1.245848392105584e-16,
 -1.093708073470197e-17,  8.046488063582314e-19, -5.098632964108988e-20,  2.839021486117086e-21, -1.410680528878973e-22,  6.331473581312023e-24, -2.588776282298502e-25,
  3.419441209908449e-14, -1.411958669755658e-14,  3.109757499304000e-15, -4.654453026739328e-16,  5.274144401451856e-17, -4.809744778344174e-18,  3.671450571085685e-19,
 -2.410875124005303e-20,  1.389536761599124e-21, -7.138666163519171e-23,  3.309057316135793e-24, -1.395765319636027e-25,  1.351808106200650e-14, -5.744434943809222e-15,
  1.305662479657131e-15, -2.016584388934591e-16,  2.356361328144337e-17, -2.213986473721122e-18,  1.739611961900087e-19, -1.174757638377716e-20,  6.956753203734492e-22,
 -3.668864074805009e-23,  1.744312427079391e-24, -7.539624313986248e-26,  5.545453989690673e-15, -2.404107653676885e-15,  5.586576274395509e-16, -8.821434047570265e-17,
  1.053350135042604e-17, -1.010773571377092e-18,  8.105892505540354e-20, -5.583222002624884e-21,  3.370185376026851e-22, -1.810583732299868e-23,  8.763718698352760e-25,
 -3.854038755876600e-26,  1.858473641914491e-15, -8.147413080368121e-16,  1.916915326145393e-16, -3.064763155696582e-17,  3.704445216474737e-18, -3.597107160076120e-19,
  2.918060996501187e-20, -2.032427894862626e-21,  1.240124128671136e-22, -6.732231100467383e-24,  3.291623292098430e-25, -1.461719063700424e-26,  7.575350490366944e-02,
 -2.394498024836855e-04,  7.898392398676628e-07, -2.696590891382645e-09,  9.437154937510359e-12, -3.357895520501997e-14,  1.206008308785499e-16, -4.353994788441980e-19,
  1.573412434945969e-21, -5.687093116165365e-24,  2.049591481497678e-26, -7.378985838869628e-29,  6.914265141888806e-02, -2.805889492147022e-04,  1.378087012745100e-06,
 -7.010890899766362e-09,  3.511735829970210e-11, -1.716733202421029e-13,  8.203205809207801e-16, -3.843971766104044e-18,  1.771257856844363e-20, -8.044045811245746e-23,
  3.606247906682978e-25, -1.598219534244059e-27,  5.760870127120693e-02, -3.374226870455682e-04,  2.382884480816482e-06, -1.593784960296253e-08,  1.005087698066400e-10,
 -6.059277955437708e-13,  3.525502934143263e-15, -1.991956227055546e-17,  1.097645420039387e-19, -5.917841092269399e-22,  3.129487294902950e-24, -1.626512743652415e-26,
  4.382699583588531e-02, -3.754747162681529e-04,  3.489901337329698e-06, -2.893080736124115e-08,  2.216133017137711e-10, -1.601868207990236e-12,  1.105604784792323e-14,
 -7.343866107065034e-17,  4.721397523178013e-19, -2.950559400575979e-21,  1.798389928450731e-23, -1.071909441641838e-25,  3.045656136118944e-02, -3.716313966374999e-04,
  4.332076133811521e-06, -4.352739044964395e-08,  3.977754099733400e-10, -3.386952354327516e-12,  2.725920205441531e-14, -2.094085733585398e-16,  1.546386016700310e-18,
 -1.103532154768690e-20,  7.641543955825524e-23, -5.151197434330164e-25,  1.934401575580673e-02, -3.245880060651830e-04,  4.632582360049642e-06, -5.565408785135156e-08,
  5.986371519081547e-10, -5.927354160817775e-12,  5.495627751330339e-14, -4.826886908589569e-16,  4.049650718361776e-18, -3.265620522406662e-20,  2.543297045386619e-22,
 -1.920191192760800e-24,  1.123712601041419e-02, -2.508454237267866e-04,  4.322791669918287e-06, -6.142310065395572e-08,  7.694768384125563e-10, -8.773397660070590e-12,
  9.285628442800001e-14, -9.244513182898644e-16,  8.739653411002297e-18, -7.901432747142940e-20,  6.868842471788450e-22, -5.765989751023933e-24,  5.975974337108585e-03,
 -1.724546319018082e-04,  3.552716429877993e-06, -5.915935916633175e-08,  8.558653373499680e-10, -1.115059027929951e-11,  1.337534129894022e-13, -1.499182032901936e-15,
  1.586798373125566e-17, -1.598505394694301e-19,  1.541904459355756e-21, -1.430861935073892e-23,  2.912783407124866e-03, -1.060696333307863e-04,  2.590202300638321e-06,
 -5.014861578869312e-08,  8.320112403705779e-10, -1.230826157789690e-11,  1.663491926882980e-13, -2.087622400169070e-15,  2.460949332295093e-17, -2.748537503443568e-19,
  2.927661187156895e-21, -2.989460046074327e-23,  1.303077973710003e-03, -5.867495850102774e-05,  1.685367948628724e-06, -3.767900841621388e-08,  7.126724173524417e-10,
 -1.190753309116531e-11,  1.804391638480529e-13, -2.523750087996655e-15,  3.299048551947779e-17, -4.068071961668900e-19,  4.765951726760349e-21, -5.334325221921850e-23,
  5.359790268591232e-04, -2.933524954960985e-05,  9.839619815574604e-07, -2.524813044105379e-08,  5.416370750393707e-10, -1.017451677877832e-11,  1.721405241946716e-13,
 -2.672889203234676e-15,  3.860183966087019e-17, -5.236946813859431e-19,  6.725324560755889e-21, -8.224037709954322e-23,  2.031199921646666e-04, -1.331751002472100e-05,
  5.180646900835687e-07, -1.517457247461940e-08,  3.675395613601391e-10, -7.730956367593715e-12,  1.455024023755124e-13, -2.499608900877365e-15,  3.975511764145979e-17,
 -5.915779635734265e-19,  8.303403206558697e-21, -1.106243389294420e-22,  7.110269535599011e-05, -5.514941778303788e-06,  2.472140094675066e-07, -8.224890336142786e-09,
  2.239943904312065e-10, -5.256823687899430e-12,  1.097013447167617e-13, -2.078789402268787e-15,  3.630781141345883e-17, -5.910261984077857e-19,  9.043792596761009e-21,
 -1.309482510112312e-22,  2.306066995088538e-05, -2.093033399267649e-06,  1.074597189257629e-07, -4.042335579281882e-09,  1.233150096693913e-10, -3.218340446001186e-12,
  7.424892785600983e-14, -1.547774667077712e-15,  2.961191343775334e-17, -5.260440040074092e-19,  8.755384356324854e-21, -1.374757777156932e-22,  6.955001424845952e-06,
 -7.316108264794699e-07,  4.277695942296947e-08, -1.811582955552943e-09,  6.168596056620893e-11, -1.784878652642203e-12,  4.539983158522010e-14, -1.038507225610287e-15,
  2.171358693927034e-17, -4.200378107117519e-19,  7.588378776737632e-21, -1.289541395850481e-22,  1.959109251240277e-06, -2.368078146430331e-07,  1.568371375054877e-08,
 -7.447130409026249e-10,  2.821049808297163e-11, -9.023812623642776e-13,  2.524125127762028e-14, -6.321066237588404e-16,  1.441237661873395e-17, -3.029771811168531e-19,
  5.929780551355156e-21, -1.088564984076324e-22,  5.181030920370439e-07, -7.140560428637175e-08,  5.329536654740920e-09, -2.826334249786880e-10,  1.187251912435275e-11,
 -4.186751154050275e-13,  1.284709530657899e-14, -3.514283684234010e-16,  8.719781997163931e-18, -1.988168226524357e-19,  4.207740847181986e-21, -8.329629186120752e-23,
  1.294355665233032e-07, -2.019472107420245e-08,  1.690336233866762e-09, -9.973568757951182e-11,  4.631278332513314e-12, -1.795602281078464e-13,  6.029694247973143e-15,
 -1.797731455687233e-16,  4.844329892726075e-18, -1.195709820009288e-19,  2.731512958359024e-21, -5.820861761547157e-23,  3.077128289123126e-08, -5.398585156716393e-09,
  5.043482954988560e-10, -3.298543054096963e-11,  1.687877263461588e-12, -7.175329103146478e-14,  2.630438343781452e-15, -8.528894604139685e-17,  2.490864428410478e-18,
 -6.642782978939076e-20,  1.634992465587391e-21, -3.744085441377498e-23,  7.021487849793173e-09, -1.376334024824459e-09,  1.428427834744595e-10, -1.031640348645055e-11,
  5.798694137155900e-13, -2.695315920710152e-14,  1.075989711302470e-15, -3.785397953090143e-17,  1.195617035018428e-18, -3.438193056504949e-20,  9.100360766592615e-22,
 -2.235330660764435e-23,  1.553376252504452e-09, -3.380740728231642e-10,  3.879669822814031e-11, -3.082270510310553e-12,  1.896787882425784e-13, -9.611806932772080e-15,
  4.167402821648867e-16, -1.586900980567282e-17,  5.408382354424151e-19, -1.673455923792703e-20,  4.753586644235063e-22, -1.249994389271876e-23,  3.371041138645248e-10,
 -8.095368496576261e-11,  1.022329153589769e-11, -8.898770103781581e-13,  5.974522312949147e-14, -3.290292785265495e-15,  1.544951124196801e-16, -6.350823972712240e-18,
  2.329740765343323e-19, -7.738285576199294e-21,  2.353747993064497e-22, -6.611740598301130e-24,  7.273177295751964e-11, -1.915133578688674e-11,  2.648286775168205e-12,
 -2.514882235950866e-13,  1.835167577119649e-14, -1.094626004004844e-15,  5.548776987838556e-17, -2.455093900216255e-18,  9.667293717376699e-20, -3.437896672812080e-21,
  1.116933465786282e-22, -3.343514008942316e-24,  1.584053412754209e-11, -4.543980592461792e-12,  6.844321201493797e-13, -7.058288844899698e-14,  5.574988165147703e-15,
 -3.587927104009096e-16,  1.956566193036337e-17, -9.287169389191648e-19,  3.913086258463944e-20, -1.485465821808037e-21,  5.140147627834923e-23, -1.635213652870831e-24,
  3.542112741714560e-12, -1.099504204397922e-12,  1.793773057514833e-13, -1.998787173159629e-14,  1.700981665901499e-15, -1.176133645457341e-16,  6.872138828810478e-18,
 -3.486263451146469e-19,  1.566166939804990e-20, -6.324820620377791e-22,  2.323328682869703e-23, -7.829845145113361e-25,  8.283045900193450e-13, -2.762642855501989e-13,
  4.851895069296777e-14, -5.809274196779250e-15,  5.299120139649253e-16, -3.917608551195025e-17,  2.441526064479427e-18, -1.318042898290022e-19,  6.287170949784940e-21,
 -2.690375687151573e-22,  1.045131571020347e-23, -3.717574178017505e-25,  2.064906087431723e-13, -7.345171146904561e-14,  1.379420088037161e-14, -1.763709377274439e-15,
  1.714491715996499e-16, -1.347816016641314e-17,  8.912779343860171e-19, -5.094740347038758e-20,  2.568193009256539e-21, -1.159166633238373e-22,  4.741166626119944e-24,
 -1.772436690454510e-25,  5.592349881258559e-14, -2.105002857669280e-14,  4.196324165262635e-15, -5.690111430840158e-16,  5.856195418542587e-17, -4.865040489902194e-18,
  3.393364466249768e-19, -2.042245238342554e-20,  1.081978925859021e-21, -5.124029039382447e-23,  2.195468189569729e-24, -8.583794735550951e-26,  1.672657597107274e-14,
 -6.607460686837018e-15,  1.387040272956775e-15, -1.979395681014174e-16,  2.141074137911296e-17, -1.866516020342209e-18,  1.364001510130004e-19, -8.587211704217195e-21,
  4.751871446867424e-22, -2.347065753286337e-23,  1.047370247439858e-24, -4.258810572495019e-26,  5.580153739998343e-15, -2.293446358794558e-15,  5.025706790694609e-16,
 -7.484548294399469e-17,  8.439897129545609e-18, -7.660686723451986e-19,  5.821276243917923e-20, -3.805952238024423e-21,  2.184427880405967e-22, -1.117717346781303e-23,
  5.160974973223961e-25, -2.168797654421969e-26,  2.064711755112666e-15, -8.750162998797332e-16,  1.982945185178290e-16, -3.053619052397122e-17,  3.557887057702980e-18,
 -3.333629388281161e-19,  2.612334616359004e-20, -1.759545442397305e-21,  1.039382127726742e-22, -5.468345424634491e-24,  2.593832661354266e-25, -1.118663630291663e-26,
  8.072051218996200e-16, -3.494913617313590e-16,  8.109671607613336e-17, -1.278710601017489e-17,  1.524737450283534e-18, -1.461110297224688e-19,  1.170187501253769e-20,
 -8.049775348723834e-22,  4.853056001934377e-23, -2.604117821099110e-24,  1.259007081964975e-25, -5.530590424534296e-27,  2.631553622747674e-16, -1.153080613944205e-16,
  2.711443640988324e-17, -4.332614385338953e-18,  5.234013794529131e-19, -5.079587220356247e-20,  4.118491336596323e-21, -2.867036646534027e-22,  1.748489853209475e-23,
 -9.487292718551963e-25,  4.636433871446748e-26, -2.057947501330428e-27,  7.480814173850256e-02, -2.332580080598405e-04,  7.583644522681666e-07, -2.550815826743317e-09,
  8.793561168074695e-12, -3.082532370111470e-14,  1.090848480744208e-16, -3.881739522985426e-19,  1.382684415687377e-21, -4.928626928537479e-24,  1.751168291173737e-26,
 -6.221035777074170e-29,  6.804182533609543e-02, -2.698914781252811e-04,  1.297217651699124e-06, -6.475446675790742e-09,  3.187237071616783e-11, -1.532157316650931e-13,
  7.202083431766513e-16, -3.320850779980850e-18,  1.506028586270135e-20, -6.732828010954544e-23,  2.971767448587769e-25, -1.296914367869300e-27,  5.629596281574595e-02,
 -3.190981816501061e-04,  2.200893605370483e-06, -1.442224321479399e-08,  8.919312781636789e-11, -5.276306442137351e-13,  3.013891441484175e-15, -1.672513748587360e-17,
  9.055122517577622e-20, -4.798160667322409e-22,  2.494495853350074e-24, -1.274884039434089e-26,  4.237881865411600e-02, -3.488862500281057e-04,  3.162994154694474e-06,
 -2.562754599118824e-08,  1.920712543816211e-10, -1.359584595159546e-12,  9.196254409626926e-15, -5.989959756453424e-17,  3.778072407786534e-19, -2.317312764018576e-21,
  1.386759805709690e-23, -8.118032835716273e-26,  2.903618714872133e-02, -3.389608341293179e-04,  3.845808427271969e-06, -3.767124773755114e-08,  3.361310473196009e-10,
 -2.797848088646000e-12,  2.203278230469961e-14, -1.657322646089491e-16,  1.199079012231562e-18, -8.387908387488733e-21,  5.696143241832138e-23, -3.767117462014991e-25,
  1.811577389677467e-02, -2.900444798751788e-04,  4.018510603467685e-06, -4.695695209632270e-08,  4.922561506787436e-10, -4.756963325226988e-12,  4.309159886963223e-14,
 -3.701004843382257e-16,  3.038466824585896e-18, -2.399098508952397e-20,  1.830422514428719e-22, -1.354475335935762e-24,  1.029851966409825e-02, -2.190146918803596e-04,
  3.654163273040951e-06, -5.040239437125157e-08,  6.143505640771249e-10, -6.826310231568848e-12,  7.049450195671866e-14, -6.854511631872826e-16,  6.334111726435428e-18,
 -5.601373688966350e-20,  4.765716871520398e-22, -3.917453610741187e-24,  5.338810813337078e-03, -1.466556369584469e-04,  2.918136124814438e-06, -4.708849781538292e-08,
  6.618296402494375e-10, -8.391775199243293e-12,  9.809829396223729e-14, -1.072707934806903e-15,  1.108689097061382e-17, -1.091429383694082e-19,  1.029488588605148e-21,
 -9.347616051518007e-24,  2.526433304633066e-03, -8.754623322429008e-05,  2.060820506982983e-06, -3.860722124840758e-08,  6.214589426265848e-10, -8.936728240407054e-12,
  1.175806818879779e-13, -1.438176993929694e-15,  1.653996022286475e-17, -1.803719077270215e-19,  1.877329032125764e-21, -1.874332023682613e-23,  1.092732015675314e-03,
 -4.682344231884675e-05,  1.294478767924943e-06, -2.796820346541757e-08,  5.126668414630274e-10, -8.318001535713201e-12,  1.225901854331150e-13, -1.669730569971816e-15,
  2.127755731756776e-17, -2.560040531540811e-19,  2.928701711462896e-21, -3.203150411238104e-23,  4.326518556979662e-04, -2.254226241986446e-05,  7.269295815707387e-07,
 -1.800852947064142e-08,  3.740520574935707e-10, -6.817376010969830e-12,  1.120918514209342e-13, -1.693698963394170e-15,  2.382935519279120e-17, -3.152448813209448e-19,
  3.951055737135720e-21, -4.718901988116476e-23,  1.571127822574353e-04, -9.812028028403193e-06,  3.667064874932160e-07, -1.036259859107070e-08,  2.428389827106021e-10,
 -4.952614797939872e-12,  9.052922666226835e-14, -1.512542620282980e-15,  2.342350843372753e-17, -3.397279345382507e-19,  4.651781501191373e-21, -6.050649639330789e-23,
  5.244980130878355e-05, -3.878248410777430e-06,  1.669637704913335e-07, -5.356678668739360e-09,  1.410749057704867e-10, -3.208592672730993e-12,  6.500178509258466e-14,
 -1.197460984364091e-15,  2.035688600367550e-17, -3.228729370507843e-19,  4.818239018368311e-21, -6.809418136924501e-23,  1.614228942829781e-05, -1.398174955431391e-06,
  6.894338720183641e-08, -2.500420172129176e-09,  7.374466585414385e-11, -1.864687513973361e-12,  4.175143455986651e-14, -8.459023879511045e-16,  1.574867534349097e-17,
 -2.725396365436366e-19,  4.423072085446245e-21, -6.777793989145498e-23,  4.595850503385327e-06, -4.619448509606414e-07,  2.594959924096474e-08, -1.059621134741599e-09,
  3.488233347859337e-11, -9.778281200490240e-13,  2.413713228413267e-14, -5.365923661421879e-16,  1.091714449812957e-17, -2.057218828965898e-19,  3.623889592328212e-21,
 -6.010027563588582e-23,  1.215480686947148e-06, -1.405953224716666e-07,  8.951974814102746e-09, -4.100061860754649e-10,  1.501901735822501e-11, -4.655111202247463e-13,
  1.263833587791011e-14, -3.076303605103637e-16,  6.826102576334682e-18, -1.398040930076761e-19,  2.668360854184214e-21, -4.781270931795580e-23,  3.001124293927324e-07,
 -3.964850466935259e-08,  2.847697947765574e-09, -1.457614046089247e-10,  5.923892187728787e-12, -2.025021085075500e-13,  6.033290507971849e-15, -1.604693209550067e-16,
  3.876136668375594e-18, -8.613043643588660e-20,  1.778220086048445e-21, -3.437037850355018e-23,  6.959605040514099e-08, -1.042885805724995e-08,  8.410548892519039e-10,
 -4.794284743028804e-11,  2.155520717835238e-12, -8.106577769006330e-14,  2.644717443163397e-15, -7.671074494780108e-17,  2.013413786290486e-18, -4.845708955643778e-20,
  1.080401756702593e-21, -2.249091113591820e-23,  1.526781264728641e-08, -2.578236041993471e-09,  2.324308188210402e-10, -1.470416047421770e-11,  7.292725451498946e-13,
 -3.010012113872773e-14,  1.072945513343395e-15, -3.387130693738559e-17,  9.642334881578524e-19, -2.509151195678038e-20,  6.031791303579627e-22, -1.350241456569386e-23,
  3.195870947049525e-09, -6.044251449885822e-10,  6.064426812511039e-11, -4.243006877356549e-12,  2.314631167397150e-13, -1.045820106674164e-14,  4.064023842325184e-16,
 -1.393468332719113e-17,  4.294332905655766e-19, -1.206108018400322e-20,  3.120774042305044e-22, -7.500055677172671e-24,  6.448271810635302e-10, -1.357646323545120e-10,
  1.509374107691363e-11, -1.163781987878622e-12,  6.961850313791883e-14, -3.434347657496059e-15,  1.451434487597727e-16, -5.393566112468281e-18,  1.795728624515742e-19,
 -5.433087757786358e-21,  1.510393692454422e-22, -3.890181658473128e-24,  1.269244005670599e-10, -2.957148846720822e-11,  3.626500512346186e-12, -3.069969520650995e-13,
  2.007400188878175e-14, -1.078091946662473e-15,  4.942378170615736e-17, -1.985696827860175e-18,  7.126438872932618e-20, -2.317804714299410e-21,  6.908974815342300e-23,
 -1.903394890626672e-24,  2.471537278156764e-11, -6.333350426464842e-12,  8.527166787835042e-13, -7.893891356988423e-14,  5.622332719926291e-15, -3.276959621924151e-16,
  1.624887148295648e-17, -7.039347688793434e-19,  2.716384615337032e-20, -9.474469038241422e-22,  3.021290110316290e-23, -8.883537824294466e-25,  4.838436667092303e-12,
 -1.355103205046878e-12,  1.993043976064475e-13, -2.008884869368878e-14,  1.552452174911187e-15, -9.785120273506367e-17,  5.230768953584967e-18, -2.435977674522416e-19,
  1.007793090150569e-20, -3.759196034864828e-22,  1.279041062119570e-23, -4.003566791480988e-25,  9.698002773621311e-13, -2.949018201012403e-13,  4.712232706432450e-14,
 -5.146633557782235e-15,  4.296578226400969e-16, -2.916812077962325e-17,  1.674615515379980e-18, -8.353635991654044e-20,  3.692707929776160e-21, -1.468338830277984e-22,
  5.313998609470164e-24, -1.765437320501609e-25,  2.030782503650059e-13, -6.657928383732770e-14,  1.148919748854528e-14, -1.352369246864699e-15,  1.213572085501904e-16,
 -8.832177552823166e-18,  5.422231352921074e-19, -2.885264916903081e-20,  1.357389488055567e-21, -5.731832504446042e-23,  2.198400932472025e-24, -7.724524755527980e-26,
  4.539548804599451e-14, -1.592641445317543e-14,  2.948384094196563e-15, -3.717435957163883e-16,  3.565372787888395e-17, -2.766859311139216e-18,  1.807111106980137e-19,
 -1.020768330710273e-20,  5.087132630680079e-22, -2.271051791296277e-23,  9.191509137116145e-25, -3.401545881377451e-26,  1.107124269394014e-14, -4.123428782229565e-15,
  8.128890519056230e-16, -1.090281077279951e-16,  1.110328862845016e-17, -9.130963474154591e-19,  6.307090451254705e-20, -3.760478469577735e-21,  1.974473543871726e-22,
 -9.270306034994341e-24,  3.939167659463822e-25, -1.527905945522850e-26,  3.004957657022559e-15, -1.178033548325747e-15,  2.452885822007953e-16, -3.472497412105982e-17,
  3.727116014434953e-18, -3.224991738395764e-19,  2.339872282509979e-20, -1.462956536426810e-21,  8.041974505558730e-23, -3.946876974964137e-24,  1.750512345334392e-25,
 -7.076153026052262e-27,  9.202193747564507e-16, -3.763142889179545e-16,  8.201564772445254e-17, -1.214869307552070e-17,  1.362806689162912e-18, -1.230771743318469e-19,
  9.307266203123108e-21, -6.056774235044656e-22,  3.460726300547638e-23, -1.763141885719814e-24,  8.107439903312978e-26, -3.393438317305643e-27,  3.173843339639252e-16,
 -1.341137503118176e-16,  3.029555992053389e-17, -4.650547543955249e-18,  5.401809761940307e-19, -5.046226720775294e-20,  3.942999211304257e-21, -2.648454646790903e-22,
  1.560292187078121e-23, -8.187816880530801e-25,  3.874152815765116e-26, -1.666859919855058e-27,  1.178726963555550e-16, -5.096343553605302e-17,  1.180739375645152e-17,
 -1.858886300442131e-18,  2.213200282653692e-19, -2.117742431312096e-20,  1.693677078735287e-21, -1.163494936077979e-22,  7.005219684944559e-24, -3.754155993196949e-25,
  1.812774929569305e-26, -7.953728568991488e-28,  3.730825085653773e-17, -1.633893606577169e-17,  3.839798458791971e-18, -6.131962192427001e-19,  7.403368308451613e-20,
 -7.180806575335665e-21,  5.818876525965932e-22, -4.048521439226870e-23,  2.467712420805064e-24, -1.338282721848771e-25,  6.536865346060277e-27, -2.900052595153196e-28,
  7.388705299159240e-02, -2.273111857010548e-04,  7.285789503950078e-07, -2.414912260721690e-09,  8.202379840152947e-12, -2.833287325016218e-14,  9.880968001977049e-17,
 -3.466369240441547e-19,  1.217229800756610e-21, -4.279940774637570e-24,  1.499274702818823e-26, -5.257714466287568e-29,  6.698253471151946e-02, -2.598161160066730e-04,
  1.222473874871110e-06, -5.989094772354331e-09,  2.897364662855671e-11, -1.369942395608961e-13,  6.336228813893281e-16, -2.875515575767809e-18,  1.283737146402888e-20,
 -5.650761571926866e-23,  2.456116287948858e-25, -1.055732587874812e-27,  5.505372152036448e-02, -3.021598171828386e-04,  2.036053300209525e-06, -1.307579748862587e-08,
  7.932754318137617e-11, -4.606047608847014e-13,  2.583688974753859e-15, -1.408566013232725e-17,  7.494653089339352e-20, -3.904048846297356e-22,  1.995824814316771e-24,
 -1.003257705426659e-26,  4.103200499254295e-02, -3.247621670094407e-04,  2.873042461344898e-06, -2.276049415701970e-08,  1.669575580113724e-10, -1.157708024657103e-12,
  7.676506684031043e-15, -4.904409211914730e-17,  3.035643242021711e-19, -1.827924952361286e-21,  1.074288731239570e-23, -6.178049500324365e-26,  2.773913742559297e-02,
 -3.099152325533436e-04,  3.424264390957349e-06, -3.271357911538426e-08,  2.851073516861730e-10, -2.320675544554697e-12,  1.788702793308699e-14, -1.317839053118778e-16,
  9.344249139227668e-19, -6.409259033834222e-21,  4.269532871805806e-23, -2.770893850743236e-25,  1.701650335143828e-02, -2.600233173109582e-04,  3.499317019345401e-06,
 -3.978911180474283e-08,  4.066730515196402e-10, -3.836881875544528e-12,  3.396961707907877e-14, -2.853840889971624e-16,  2.293385122557232e-18, -1.773528065856723e-20,
  1.325959087295643e-22, -9.619100515014369e-25,  9.477319872379085e-03, -1.920434068372405e-04,  3.104087711188289e-06, -4.157920620912338e-08,  4.932993553872445e-10,
 -5.343589217240927e-12,  5.386080503148817e-14, -5.116568603910083e-16,  4.622914770888331e-18, -3.999856231056425e-20,  3.331585158623075e-22, -2.682400589891483e-24,
  4.795538031523790e-03, -1.254027505269769e-04,  2.411459328948552e-06, -3.772352219366841e-08,  5.152975850540681e-10, -6.361120909360986e-12,  7.249104001667601e-14,
 -7.735862356735227e-16,  7.809518986465439e-18, -7.514904320076556e-20,  6.933393422552061e-22, -6.161307036481446e-24,  2.206509258910004e-03, -7.275643049536693e-05,
  1.651757353093501e-06, -2.995311694709961e-08,  4.679673603800565e-10, -6.543729886588435e-12,  8.384013791627307e-14, -9.997721177639843e-16,  1.122056842856991e-17,
 -1.195084394723128e-19,  1.215711193543522e-21, -1.187061778887726e-23,  9.242057363475479e-04, -3.768231899139853e-05,  1.003063959298657e-06, -2.095116987782004e-08,
  3.723057431601229e-10, -5.867697646933740e-12,  8.413110355454353e-14, -1.116193826028382e-15,  1.386942670178768e-17, -1.628595182789498e-19,  1.819732476145997e-21,
 -1.945250892660748e-23,  3.528761106739439e-04, -1.749897998229425e-05,  5.426696357357200e-07, -1.298300704212661e-08,  2.611697671498152e-10, -4.619576015876244e-12,
  7.383373132243550e-14, -1.085885082163128e-15,  1.488695125266982e-17, -1.920872308151906e-19,  2.350065252656857e-21, -2.741858566608782e-23,  1.230286273611158e-04,
 -7.316555435143173e-06,  2.627455482682193e-07, -7.164551757752908e-09,  1.624773306133005e-10, -3.213563187959790e-12,  5.706188178706728e-14, -9.273962763074087e-16,
  1.398659908436443e-17, -1.977545435823461e-19,  2.641975254620978e-21, -3.355564258056918e-23,  3.924949373481105e-05, -2.765664473275482e-06,  1.143554776490342e-07,
 -3.538293716673747e-09,  9.012690744516331e-11, -1.986828412152706e-12,  3.908007904734441e-14, -6.999858964475117e-16,  1.158396050030600e-17, -1.790380029788493e-19,
  2.605947320984382e-21, -3.595068612844158e-23,  1.148763432908158e-05, -9.491062730598719e-07,  4.494372892559834e-08, -1.571545261670453e-09,  4.481261570348887e-11,
 -1.097904470733070e-12,  2.385993847582686e-14, -4.698748319034988e-16,  8.513395226058710e-18, -1.435319512620470e-19,  2.271496892169696e-21, -3.397154889702227e-23,
  3.094398506553505e-06, -2.970264397227861e-07,  1.602701699555295e-08, -6.309583542851708e-10,  2.007994122606182e-11, -5.453132669639360e-13,  1.306306351979009e-14,
 -2.822335676959416e-16,  5.587508673940704e-18, -1.025667919660055e-19,  1.761720271761214e-21, -2.851374207460070e-23,  7.701240179972697e-07, -8.518807615875798e-08,
  5.212823405954790e-09, -2.302409166904517e-10,  8.154509157001534e-12, -2.448761954627139e-13,  6.452172259497803e-15, -1.526410694292381e-16,  3.295969083944120e-18,
 -6.576195078017187e-20,  1.223962295809060e-21, -2.140536636847164e-23,  1.779288962710553e-07, -2.251553345098217e-08,  1.555449531995341e-09, -7.681995291545659e-11,
  3.019751768868936e-12, -1.000435114773710e-13,  2.893546139180443e-15, -7.481738436897712e-17,  1.759065753756966e-18, -3.808797927510163e-20,  7.669919086901168e-22,
 -1.447285816035151e-23,  3.838346633055544e-08, -5.519345294056922e-09,  4.286187116300492e-10, -2.359368443384058e-11,  1.026693478188243e-12, -3.744241006871783e-14,
  1.186422538689590e-15, -3.346972640922878e-17,  8.554479052068831e-19, -2.007024925691361e-20,  4.366550920035439e-22, -8.877867355639196e-24,  7.785728820775495e-09,
 -1.264268071012045e-09,  1.099066321551788e-10, -6.721680214320139e-12,  3.229597026282549e-13, -1.293658462857027e-14,  4.482146357763626e-16, -1.377138086970497e-17,
  3.820134059512004e-19, -9.696923753407568e-21,  2.276039788404231e-22, -4.979179079273651e-24,  1.497584619076133e-09, -2.729915031696599e-10,  2.645794104189243e-11,
 -1.792085015023734e-12,  9.482349084962414e-14, -4.162530430716417e-15,  1.573796625731336e-16, -5.256950143441990e-18,  1.580047078149068e-19, -4.332539307342537e-21,
  1.095479892344860e-22, -2.574959119482493e-24,  2.759586244827006e-10, -5.614498199044305e-11,  6.041640919334869e-12, -4.517413718042239e-13,  2.625112774353712e-14,
 -1.259881038210154e-15,  5.187120660728459e-17, -1.880042660358177e-18,  6.111706703042622e-20, -1.807267982185908e-21,  4.914816372981335e-23, -1.239348697238555e-24,
  4.931059532261828e-11, -1.113314824210869e-11,  1.324545328808618e-12, -1.089545883089801e-13,  6.933222075295858e-15, -3.628603770044919e-16,  1.623061798375894e-17,
 -6.369539916808603e-19,  2.235116019985211e-20, -7.114350156181890e-22,  2.077155070294725e-23, -5.609562416560260e-25,  8.668345039292611e-12, -2.159128755941929e-12,
  2.827527810567227e-13, -2.549327781401983e-14,  1.770732686852512e-15, -1.007709690955171e-16,  4.884219499104133e-18, -2.070377901834764e-19,  7.824458478937110e-21,
 -2.675050783269866e-22,  8.368041912841945e-24, -2.415447031255057e-25,  1.524596705656641e-12, -4.164014126549531e-13,  5.973793161117306e-14, -5.879517973159901e-15,
  4.441617424349976e-16, -2.739570985540276e-17,  1.434494492408502e-18, -6.549590360693897e-20,  2.658766350248221e-21, -9.738798234844773e-23,  3.256164100946853e-24,
 -1.002258072259124e-25,  2.735491304038648e-13, -8.139569635270168e-14,  1.272561859606816e-14, -1.360998154836581e-15,  1.113622484696065e-16, -7.416391536682946e-18,
  4.180548085295601e-19, -2.049122023205380e-20,  8.906930252960382e-22, -3.484939061548688e-23,  1.241799658474526e-24, -4.064544587648006e-26,  5.117878253794168e-14,
 -1.647613647237587e-14,  2.790893876110636e-15, -3.226605852866732e-16,  2.845983321073580e-17, -2.037371474820284e-18,  1.231179995697289e-19, -6.452946699300377e-21,
  2.992097511979499e-22, -1.245996304619458e-23,  4.715412360638902e-25, -1.635714253738579e-26,  1.022595142262565e-14, -3.535219041792949e-15,  6.445683209455588e-16,
 -8.007448419796796e-17,  7.571235967933187e-18, -5.795802513187424e-19,  3.736132417862037e-20, -2.084058897747610e-21,  1.026178608123171e-22, -4.528487033176581e-24,
  1.812534451699319e-25, -6.636582605393459e-27,  2.236956708795607e-15, -8.237501203553107e-16,  1.604714725394532e-16, -2.127398496297995e-17,  2.142324512301124e-18,
 -1.742870340871536e-19,  1.191465640287041e-20, -7.033662539626630e-22,  3.658044699066111e-23, -1.701827019855846e-24,  7.168118487143520e-26, -2.756971399087170e-27,
  5.484933314082399e-16, -2.132707095064747e-16,  4.402094513832867e-17, -6.178712301459115e-18,  6.576967608115895e-19, -5.645648483364403e-20,  4.064863005547637e-21,
 -2.522818038050796e-22,  1.377034184763586e-23, -6.712495839295538e-25,  2.957733318104527e-26, -1.188147149030245e-27,  1.534651659659301e-16, -6.241842520221711e-17,
  1.352430877097717e-17, -1.991757777392947e-18,  2.221806707964665e-19, -1.995731917891956e-20,  1.501373444661047e-21, -9.721591512502304e-23,  5.528114655224920e-24,
 -2.803442989566286e-25,  1.283394280679284e-26, -5.348925690378588e-28,  4.912481171063020e-17, -2.069270954737007e-17,  4.658271988609698e-18, -7.126300102587105e-19,
  8.250013931034857e-20, -7.682217508676861e-21,  5.984139601054966e-22, -4.007494429339226e-23,  2.354183905670305e-24, -1.231979570850571e-25,  5.813771715283559e-27,
 -2.495008970312909e-28,  1.727138491634086e-17, -7.456216827937462e-18,  1.724611990117243e-18, -2.710627347814057e-19,  3.222066230169959e-20, -3.078258522693978e-21,
  2.458121639504433e-22, -1.686167233463634e-23,  1.013779178524870e-24, -5.425512056910022e-26,  2.616373027634523e-27, -1.146502954643682e-28,  5.296216337556836e-18,
 -2.318153772439211e-18,  5.444468100493028e-19, -8.689064211884764e-20,  1.048415203870581e-20, -1.016279971043586e-21,  8.230417384672057e-23, -5.723060078078448e-24,
  3.486439074600428e-25, -1.889720072375544e-26,  9.225447569054739e-28, -4.090710792268559e-29,  7.298928507263237e-02, -2.215962810840126e-04,  7.003691405767550e-07,
 -2.288081817755434e-09,  7.658672683979787e-12, -2.607364777229530e-14,  8.962680178975883e-17, -3.100394473787540e-19,  1.073411863588922e-21, -3.724028984721592e-24,
  1.286130245831407e-26, -4.454618887443560e-29,  6.596238551623211e-02, -2.503161237206833e-04,  1.153298395065439e-06, -5.546635823574139e-09,  2.637954182779472e-11,
 -1.227088577660702e-13,  5.585667787325307e-16, -2.495459156664813e-18,  1.096929543606811e-20, -4.755210612471682e-23,  2.035734430754302e-25, -8.620403442291307e-28,
  5.387669490933629e-02, -2.864781308455985e-04,  1.886465733840151e-06, -1.187701380987389e-08,  7.070493447273323e-11, -4.030704568341819e-13,  2.220858713538533e-15,
 -1.189765981795390e-17,  6.222863465515504e-20, -3.187416030696601e-22,  1.602668617619251e-24, -7.925602305554066e-27,  3.977725707717590e-02, -3.028266155037030e-04,
  2.615211565460807e-06, -2.026484424973654e-08,  1.455399524988693e-10, -9.889109559926705e-13,  6.429938071170498e-15, -4.030502002804542e-17,  2.448810846706208e-19,
 -1.447992128835041e-21,  8.359522917246862e-24, -4.723846584438298e-26,  2.655188350779039e-02, -2.840172019023757e-04,  3.057612368922926e-06, -2.850104130309334e-08,
  2.427044405209182e-10, -1.932489363424990e-12,  1.458323281997053e-14, -1.052668748270040e-16,  7.317057936281212e-19, -4.922364058867588e-21,  3.217388535700132e-23,
 -2.049567425482292e-25,  1.602952400211649e-02, -2.338336006302901e-04,  3.058492356217700e-06, -3.385452256939934e-08,  3.374813533105876e-10, -3.109762536605781e-12,
  2.691716112650072e-14, -2.212650282576898e-16,  1.740997326168607e-18, -1.319005466789959e-20,  9.665901252497858e-23, -6.876091455796456e-25,  8.755830893840886e-03,
 -1.690800185860135e-04,  2.649182093273525e-06, -3.447574271271182e-08,  3.982747908667688e-10, -4.207374105647007e-12,  4.140608855092183e-14, -3.844050668781989e-16,
  3.396887411261723e-18, -2.876405845462467e-20,  2.346091336439837e-22, -1.850653574772671e-24,  4.329829248954349e-03, -1.077907333823340e-04,  2.004334527388628e-06,
 -3.040889858052750e-08,  4.038545163665356e-10, -4.855342444174303e-12,  5.395787970131340e-14, -5.621035620701724e-16,  5.544271493111548e-18, -5.216459436991157e-20,
  4.708773991246931e-22, -4.096287444809803e-24,  1.939802643980695e-03, -6.086211479368414e-05,  1.333255741682338e-06, -2.341214409405398e-08,  3.551408785614136e-10,
 -4.830579874929859e-12,  6.028798193249426e-14, -7.010999060082667e-16,  7.680786443988745e-18, -7.991944903887171e-20,  7.947905096886679e-22, -7.591629909948321e-24,
  7.880652389774805e-04, -3.057045176872729e-05,  7.838469570264451e-07, -1.583319128356378e-08,  2.728496348965659e-10, -4.178394079986564e-12,  5.830101484851565e-14,
 -7.536501220977357e-16,  9.133637124985705e-18, -1.046967953496053e-19,  1.142861820225024e-21, -1.194324320966043e-23,  2.906679576868751e-04, -1.371621294979056e-05,
  4.091827212056431e-07, -9.456588779302842e-09,  1.842888351184876e-10, -3.164387576595038e-12,  4.917558016392865e-14, -7.041261254377009e-16,  9.408434050748598e-18,
 -1.184297125212863e-19,  1.414643036864432e-21, -1.612622892624441e-23,  9.747833937273082e-05, -5.518737296384298e-06,  1.904667251741158e-07, -5.012672396036361e-09,
  1.100334935806325e-10, -2.111022174190811e-12,  3.642077062409254e-14, -5.759123856591347e-16,  8.460353952122318e-18, -1.166315749652759e-19,  1.520569861999214e-21,
 -1.886108181810817e-23,  2.977862036909337e-05, -1.998863392768495e-06,  7.938535650548774e-08, -2.369175350288107e-09,  5.837559144102188e-11, -1.247520279223972e-12,
  2.382842969061796e-14, -4.150428218841226e-16,  6.687151452862941e-18, -1.007294254364914e-19,  1.430197728025950e-21, -1.926235615497275e-23,  8.306109307268972e-06,
 -6.542884099578783e-07,  2.975235318190184e-08, -1.003069643764070e-09,  2.765614355864438e-11, -6.565724765550267e-13,  1.385054836835857e-14, -2.651452027514221e-16,
  4.675625831665667e-18, -7.680370380721118e-20,  1.185356508510256e-21, -1.730303601325592e-23,  2.121514813482137e-06, -1.943647682144328e-07,  1.007190975633166e-08,
 -3.822579046547786e-10,  1.176024009776913e-11, -3.094059076611382e-13,  7.193015008338102e-15, -1.510390848811185e-16,  2.909741782917185e-18, -5.203197662450200e-20,
  8.714557904669949e-22, -1.376530641056743e-23,  4.979801721435507e-07, -5.264300709404606e-08,  3.094891577556144e-09, -1.317990752037024e-10,  4.512726963103968e-12,
 -1.312835708176218e-13,  3.356915816228737e-15, -7.718061968258558e-17,  1.621687553426807e-18, -3.151982194158228e-20,  5.720405935936161e-22, -9.763781687832309e-24,
  1.079017981876370e-07, -1.306859648036517e-08,  8.679975870543594e-10, -4.134989333810984e-11,  1.571826007096994e-12, -5.045878379973268e-14,  1.416532189227456e-15,
 -3.560181367643400e-17,  8.146453710779704e-19, -1.718583470859660e-20,  3.375185274745614e-22, -6.216947526068212e-24,  2.170105092363662e-08, -2.991875262518845e-09,
  2.236033592940029e-10, -1.188075996511838e-11,  5.002157882484856e-13, -1.768446843040771e-14,  5.441148617965143e-16, -1.492584416490283e-17,  3.714087612750925e-19,
 -8.492959807324658e-21,  1.802683840874601e-22, -3.578967865790336e-24,  4.078501566814094e-09, -6.362395860042915e-10,  5.329940634400043e-11, -3.149546669894897e-12,
  1.465350390812498e-13, -5.694205727835940e-15,  1.916910856410501e-16, -5.730454751162601e-18,  1.548494020783118e-19, -3.833114564585437e-21,  8.782258559916005e-23,
 -1.877083527997950e-24,  7.222374288401368e-10, -1.267621186179980e-10,  1.185797679780357e-11, -7.770450536247931e-13,  3.985717005122755e-14, -1.699008202222761e-15,
  6.247124624657476e-17, -2.032014946146031e-18,  5.954288415089189e-20, -1.593394455622056e-21,  3.935662676890910e-23, -9.044837902535048e-25,  1.217299662757870e-10,
 -2.390572811433787e-11,  2.487656701456355e-12, -1.802412004347785e-13,  1.016776068763632e-14, -4.744670734006949e-16,  1.901980031773076e-17, -6.720275174750029e-19,
  2.132077922637001e-20, -6.159137816315332e-22,  1.637790983594406e-23, -4.041771844791218e-25,  1.976784012628357e-11, -4.319914304267038e-12,  4.981183345304172e-13,
 -3.978067692494548e-14,  2.461609400117849e-15, -1.254595448215932e-16,  5.471868632237412e-18, -2.096258974904526e-19,  7.188286602977235e-21, -2.238003847228258e-22,
  6.396939132639333e-24, -1.692651602396453e-25,  3.138661217988066e-12, -7.589916362739158e-13,  9.657618425959117e-14, -8.472639197684894e-15,  5.734335461655287e-16,
 -3.183891933852879e-17,  1.507352527341334e-18, -6.247752926598386e-20,  2.311004230452711e-21, -7.739870348864683e-23,  2.373742579914554e-24, -6.722834942603584e-26,
  4.958402827464075e-13, -1.319055112999227e-13,  1.843860460173541e-14, -1.770317184376166e-15,  1.306171287126246e-16, -7.877297921455133e-18,  4.037169595144339e-19,
 -1.805871190665027e-20,  7.188290156352287e-22, -2.583882619465883e-23,  8.484362820152888e-25, -2.566549249381258e-26,  7.955145135957857e-14, -2.313533165555771e-14,
  3.535221899319981e-15, -3.698715680110613e-16,  2.963588369345121e-17, -1.934523900987463e-18,  1.069804802051884e-19, -5.148604937292558e-21,  2.199048219325344e-22,
 -8.460532589299017e-24,  2.966466534150396e-25, -9.560188018107308e-27,  1.327036133020062e-14, -4.190476303006389e-15,  6.960552171954657e-16, -7.896408346138503e-17,
  6.839847176645473e-18, -4.812366579466547e-19,  2.860299742632055e-20, -1.475559189404940e-21,  6.738606215591260e-23, -2.765511655582715e-24,  1.032034888167719e-25,
 -3.532193495910005e-27,  2.362872838327137e-15, -8.041534924485911e-16,  1.442686875130425e-16, -1.764335170238488e-17,  1.643259729646453e-18, -1.239881594783921e-19,
  7.882818848953689e-21, -4.339241378199465e-22,  2.109642208876054e-23, -9.196964398566839e-25,  3.638258267609804e-26, -1.317271866772968e-27,  4.617994959721091e-16,
 -1.680022101971701e-16,  3.231455139189630e-17, -4.231178904209799e-18,  4.210248473464129e-19, -3.386151660627139e-20,  2.289533067425520e-21, -1.337419875597426e-22,
  6.885619856184413e-24, -3.172445681517002e-25,  1.323841621291263e-26, -5.046402096991134e-28,  1.018212779644105e-16, -3.924340555670553e-17,  8.024657400721183e-18,
 -1.116023693695141e-18,  1.177458003555027e-19, -1.002135967066845e-20,  7.156495022114008e-22, -4.406825996192653e-23,  2.387304747212904e-24, -1.155317458081269e-25,
  5.055392708149004e-27, -2.017295861908371e-28,  2.590267050409198e-17, -1.047374214316576e-17,  2.255086638767481e-18, -3.300520047618647e-19,  3.659611065308030e-20,
 -3.268212038888853e-21,  2.444972805119542e-22, -1.574692186092114e-23,  8.908416715007529e-25, -4.495402127738853e-26,  2.048209159356420e-27, -8.497735189253710e-29,
  7.660052011047965e-18, -3.215616083945905e-18,  7.211966255881847e-19, -1.099234285837826e-19,  1.268014469506751e-20, -1.176667526084588e-21,  9.135291657903352e-23,
 -6.098208734485858e-24,  3.571345029549294e-25, -1.863409506070122e-26,  8.768498937129410e-28, -3.752770032918220e-29,  2.540022985315760e-18, -1.094770445781014e-18,
  2.527652634776866e-19, -3.965704848962219e-20,  4.705749486472221e-21, -4.488145767124106e-22,  3.578142876738735e-23, -2.450598898247206e-24,  1.471148338174788e-25,
 -7.861741212681322e-27,  3.785864615692192e-28, -1.656728017606781e-29,  7.528852205271135e-19, -3.293425814846034e-19,  7.729886627951660e-20, -1.232823175282476e-20,
  1.486536577370213e-21, -1.440046461147991e-22,  1.165501501030396e-23, -8.099426549182056e-25,  4.931171783313090e-26, -2.671250140394055e-27,  1.303347750300796e-28,
 -5.776099198951631e-30,  7.211393484994508e-02, -2.161011116146826e-04,  6.736305534173984e-07, -2.169600848401770e-09,  7.158026538377776e-12, -2.402301674524233e-14,
  8.140711763142900e-17, -2.777397278604137e-19,  9.481535242025981e-22, -3.246715576921794e-24,  1.105319445771980e-26, -3.783873976589320e-29,  6.497916214100394e-02,
 -2.413489817447160e-04,  1.089192509500839e-06, -5.143491263364961e-09,  2.405395947880345e-11, -1.101035917484360e-13,  4.933616042126164e-16, -2.170331375505995e-18,
  9.395296357802389e-21, -4.011938816872122e-23,  1.691981420360405e-25, -7.059890103090730e-28,  5.276008955062182e-02, -2.719378642939017e-04,  1.750472296212501e-06,
 -1.080743948058755e-08,  6.315066702955766e-11, -3.535526192433729e-13,  1.913962052101091e-15, -1.007821689770782e-17,  5.182853834485315e-20, -2.610966601639346e-22,
  1.291517685717009e-24, -6.284654640763367e-27,  3.860630784398184e-02, -2.828394991494915e-04,  2.385378737365529e-06, -1.808641449123895e-08,  1.272178867657776e-10,
 -8.472953944586226e-13,  5.403705306673167e-15, -3.324218784182998e-17,  1.983031281075947e-19, -1.151731885303241e-21,  6.533163871172160e-24, -3.628461925173624e-26,
  2.546265989452886e-02, -2.608611559494322e-04,  2.737683028153725e-06, -2.490890856918167e-08,  2.073288941435838e-10, -1.615370872489946e-12,  1.193859842669452e-14,
 -8.445580605232122e-17,  5.756465408303071e-19, -3.799100863720908e-21,  2.437123477259910e-23, -1.524267374084922e-25,  1.514067616948938e-02, -2.109033927492592e-04,
  2.682692055470040e-06, -2.891928149309958e-08,  2.812751587155939e-10, -2.532213742446309e-12,  2.143531869623505e-14, -1.724597624496719e-16,  1.329029540740033e-18,
 -9.867072827632979e-21,  7.089257078246073e-23, -4.946562171948541e-25,  8.119422503238617e-03, -1.494391284748802e-04,  2.271096100372091e-06, -2.872598257219985e-08,
  3.232525838642837e-10, -3.331400725503987e-12,  3.202092710267844e-14, -2.906096418900796e-16,  2.512362533384344e-18, -2.082624674287807e-20,  1.663825631804508e-22,
 -1.286188168406378e-24,  3.928570486701805e-03, -9.311278403183259e-05,  1.675207370856465e-06, -2.465873158429292e-08,  3.185194024228577e-10, -3.730785500556116e-12,
  4.044450848166911e-14, -4.114239213964128e-16,  3.966016265172519e-18, -3.649520883922495e-20,  3.223960354506608e-22, -2.746217396702792e-24,  1.716034252611067e-03,
 -5.123011639879370e-05,  1.083452906290743e-06, -1.843037409177767e-08,  2.715413093730990e-10, -3.593918377089229e-12,  4.370588515787579e-14, -4.958112388267179e-16,
  5.303640322511501e-18, -5.392591464643424e-20,  5.244135827919908e-22, -4.901153904062038e-24,  6.772186428932902e-04, -2.499134477947170e-05,  6.175124849740870e-07,
 -1.206673789978301e-08,  2.017217011498948e-10, -3.002559827781222e-12,  4.078147437659381e-14, -5.137908477615331e-16,  6.074741468995788e-18, -6.799213268812533e-20,
  7.252463874867675e-22, -7.410884091409591e-24,  2.416962411499150e-04, -1.085096509017870e-05,  3.114976607302888e-07, -6.956282551593453e-09,  1.313666913022444e-10,
 -2.190319933560754e-12,  3.310458459305238e-14, -4.616026132310210e-16,  6.012863298525841e-18, -7.385345761808715e-20,  8.614937526281158e-22, -9.597194072344094e-24,
  7.810827502645145e-05, -4.208608002045494e-06,  1.396246821509867e-07, -3.547385512315974e-09,  7.539091804886564e-11, -1.403334509642077e-12,  2.352939472047739e-14,
 -3.620739793737354e-16,  5.182043489373709e-18, -6.966640207085110e-20,  8.864993318677845e-22, -1.074074316065608e-23,  2.289342369172712e-05, -1.463335140800332e-06,
  5.582676175098701e-08, -1.607252364583422e-09,  3.831475857665048e-11, -7.939050331529771e-13,  1.472797910896205e-14, -2.495027562736879e-16,  3.914457666574203e-18,
 -5.747481828650783e-20,  7.961531806450346e-22, -1.046978655555851e-23,  6.098198094176334e-06, -4.577865056939247e-07,  1.998944396983394e-08, -6.498116083165799e-10,
  1.732509587494241e-11, -3.986021212499004e-13,  8.163020738941851e-15, -1.519211922480083e-16,  2.607681593724217e-18, -4.173842323617701e-20,  6.282693302738487e-22,
 -8.952122398831627e-24,  1.480119470965684e-06, -1.293548823106853e-07,  6.436456193322237e-09, -2.354879296476285e-10,  7.003711579969752e-12, -1.785177311652911e-13,
  4.027760286813971e-15, -8.220059758066941e-17,  1.541040220931842e-18, -2.684569499192623e-20,  4.384404602807938e-22, -6.759094774874694e-24,  3.284113117355418e-07,
 -3.315714129244978e-08,  1.872276805315264e-09, -7.686468318888982e-11,  2.544041071303667e-12, -7.169543534509923e-14,  1.778990763420470e-15, -3.974931902157853e-17,
  8.126881045543827e-19, -1.538702046168913e-20,  2.722930185921812e-22, -4.535788134630185e-24,  6.688853844139667e-08, -7.748060819774203e-09,  4.945619916366041e-10,
 -2.271935774111322e-11,  8.349723728413199e-13, -2.596871535444809e-14,  7.075074681212467e-16, -1.728224408588876e-17,  3.848291613099341e-19, -7.909035923014342e-21,
  1.514725074043974e-22, -2.723261628973443e-24,  1.256995933201042e-08, -1.660155370111604e-09,  1.193444487016910e-10, -6.118411893716632e-12,  2.491635830020751e-13,
 -8.537236376790727e-15,  2.549998119058691e-16, -6.800402764375723e-18,  1.647166923384487e-19, -3.670414864457133e-21,  7.599357684956024e-23, -1.473031722500394e-24,
  2.193584741594147e-09, -3.284311837946126e-10,  2.649579041086353e-11, -1.511996963273935e-12,  6.808978600124656e-14, -2.565864736274211e-15,  8.390002386344844e-17,
 -2.439578420458513e-18,  6.419981159611646e-20, -1.549348941268990e-21,  3.464208827706249e-23, -7.232307381579800e-25,  3.583273899808938e-10, -6.049093075902815e-11,
  5.457433897999179e-12, -3.457659204084420e-13,  1.718344727997942e-14, -7.109504991084531e-16,  2.541149087334524e-17, -8.045740987060972e-19,  2.297604175995747e-20,
 -5.998439127817664e-22,  1.446843723683085e-23, -3.250001510494777e-25,  5.533484524712668e-11, -1.047739712749561e-11,  1.053422481075461e-12, -7.390457168956194e-14,
  4.044574346844787e-15, -1.833999989076189e-16,  7.154364115731053e-18, -2.463076990982543e-19,  7.622811146340416e-21, -2.150304907911868e-22,  5.588728753923341e-24,
 -1.349216895582068e-25,  8.176823584739299e-12, -1.727516756037440e-12,  1.928697290107821e-13, -1.494161912792431e-14,  8.984120373693366e-16, -4.455990914787523e-17,
  1.893828119693988e-18, -7.078367317321490e-20,  2.370635013903931e-21, -7.215663333666886e-23,  2.018144955369267e-24, -5.229732186288262e-26,  1.173484658714457e-12,
 -2.751596960414814e-13,  3.398342265964551e-14, -2.898298946135157e-15,  1.909771958144724e-16, -1.033753920980960e-17,  4.777084070219382e-19, -1.934814460962395e-20,
  7.000329640326844e-22, -2.295362879043381e-23,  6.897898651859548e-25, -1.915795775184103e-26,  1.665187099662578e-13, -4.309307605368916e-14,  5.863070620463501e-15,
 -5.485961682752048e-16,  3.949678858085688e-17, -2.327100460795291e-18,  1.166443558800225e-19, -5.108044080081488e-21,  1.992374633358540e-22, -7.023614764194819e-24,
  2.263534105769834e-25, -6.725447308278846e-27,  2.386873081864779e-14, -6.776251086413372e-15,  1.010917438421766e-15, -1.033638843223243e-16,  8.102509924558319e-18,
 -5.179684411874362e-19,  2.807850374756026e-20, -1.325808674312959e-21,  5.560334053488270e-23, -2.102160361155428e-24,  7.247925607312976e-26, -2.298482585086213e-27,
  3.543621602337486e-15, -1.096339638977944e-15,  1.783834099923655e-16, -1.983785755347511e-17,  1.685943899324454e-18, -1.164815721693267e-19,  6.803961962486263e-21,
 -3.452121378611093e-22,  1.551614477078027e-23, -6.271310997970840e-25,  2.306282290923721e-26, -7.783190029121151e-28,  5.606532760417183e-16, -1.876427760063644e-16,
  3.309159135139505e-17, -3.980242692016150e-18,  3.648476693494887e-19, -2.711190862757887e-20,  1.698720628976174e-21, -9.221151649465550e-23,  4.423492986223686e-24,
 -1.903815852446672e-25,  7.439129060349265e-27, -2.661784634980240e-28,  9.751604430176601e-17, -3.501736082977044e-17,  6.644702654959790e-18, -8.586155079170543e-19,
  8.435731863807392e-20, -6.702348099979110e-21,  4.479150579731009e-22, -2.587363395073930e-23,  1.317877985498854e-24, -6.009789779250080e-26,  2.483211902167609e-27,
 -9.376715382689651e-29,  1.924406399648970e-17, -7.346798318833397e-18,  1.487274791532026e-18, -2.048145406162965e-19,  2.140455354316180e-20, -1.805194710837579e-21,
  1.277899315970156e-22, -7.803287864986959e-24,  4.193382939272456e-25, -2.013747049998415e-26,  8.746615080141576e-28, -3.465540665329201e-29,  4.428577116675297e-18,
 -1.779380797719167e-18,  3.805175440477781e-19, -5.532025306888391e-20,  6.094272559972032e-21, -5.408649543700100e-22,  4.022090629622206e-23, -2.575594627951330e-24,
  1.449062446338652e-25, -7.273710673635481e-27,  3.297267767989208e-28, -1.361344033364040e-29,  1.203993430350674e-18, -5.035570031360121e-19,  1.124834745873931e-19,
 -1.707633462862030e-20,  1.962228047171836e-21, -1.814095010932160e-22,  1.403367172685943e-23, -9.335862672670360e-25,  5.449364845216712e-26, -2.834265509503497e-27,
  1.329625607168895e-28, -5.673912311188853e-30,  3.750312505045321e-19, -1.613577112264094e-19,  3.718294318382496e-20, -5.822517667609299e-21,  6.896120001224601e-22,
 -6.565304819192684e-23,  5.224985408804940e-24, -3.572452482300809e-25,  2.141135527761455e-26, -1.142419463595344e-27,  5.493077735751411e-29, -2.400330658155008e-30,
  1.071842999656892e-19, -4.685721026640670e-20,  1.098994813320207e-20, -1.751521841938090e-21,  2.110510680353171e-22, -2.043114159321900e-23,  1.652497446292884e-24,
 -1.147629926991067e-25,  6.982727390765059e-27, -3.780283974357378e-28,  1.843369564250753e-29, -8.164635460521752e-31,  7.126014630406968e-02, -2.108142968830339e-04,
  6.482669953778378e-07, -2.058812535338481e-09,  6.696491269657926e-12, -2.215924297417307e-14,  7.403819682774874e-17, -2.491867445188857e-19,  8.388446522368327e-22,
 -2.836161789989129e-24,  9.515332943973586e-27, -3.222878519480994e-29,  6.403081141005687e-02, -2.328759498502267e-04,  1.029709155019609e-06, -4.775621209830252e-09,
  2.196554219885221e-11, -9.895946048941255e-14,  4.365932648189243e-16, -1.891542833258150e-18,  8.065694012860032e-21, -3.393366544908208e-23,  1.410058369999540e-25,
 -5.798737950316060e-28,  5.169954784598265e-02, -2.584361876857512e-04,  1.626619972053607e-06, -9.851194101375619e-09,  5.651704111405006e-11, -3.108247404637117e-13,
  1.653646182076673e-15, -8.560641283811456e-18,  4.329599766507823e-20, -2.145659264754755e-22,  1.044354141363324e-24, -5.001650191467550e-27,  3.751178854918201e-02,
 -2.645912575101696e-04,  2.180017456214954e-06, -1.617975317272707e-08,  1.114970245098826e-10, -7.280953604564543e-13,  4.555872961908497e-15, -2.751241265466736e-17,
  1.611839471339960e-19, -9.197282216620353e-22,  5.127321443670369e-24, -2.799450407258538e-26,  2.446120162193878e-02, -2.401012839412852e-04,  2.457661872908217e-06,
 -2.183530579500330e-08,  1.777054394569814e-10, -1.355260080702225e-12,  9.812433881293828e-15, -6.804762413781813e-17,  4.549224836016844e-19, -2.946195027176155e-21,
  1.855378999506740e-23, -1.139579913006670e-25,  1.433789096031161e-02, -1.907571501528843e-04,  2.361078087818084e-06, -2.479764087174132e-08,  2.354077337316610e-10,
 -2.071216458517253e-12,  1.715211860512064e-14, -1.351068517741018e-16,  1.020015873605583e-18, -7.423034899014033e-21,  5.230238549870394e-23, -3.580423035166986e-25,
  7.555938130870132e-03, -1.325660876814236e-04,  1.955345905100331e-06, -2.404782165892453e-08,  2.636946593085298e-10, -2.652108050854513e-12,  2.490523836350820e-14,
 -2.210285272321021e-16,  1.869925481535861e-18, -1.517854563074060e-20,  1.188067925366285e-22, -9.002476316469326e-25,  3.581163848965073e-03, -8.081345350075328e-05,
  1.407578860551580e-06, -2.011028064660420e-08,  2.527465365839764e-10, -2.885145130522174e-12,  3.052036608786480e-14, -3.032622518928021e-16,  2.857874063626271e-18,
 -2.572712098994301e-20,  2.224733799638734e-22, -1.856060307855309e-24,  1.527145834171398e-03, -4.337840645677140e-05,  8.861568965539265e-07, -1.460814432707016e-08,
  2.091198522352831e-10, -2.694050590582909e-12,  3.193394660868704e-14, -3.534947974046079e-16,  3.693109624896180e-18, -3.670333764300836e-20,  3.491128036737984e-22,
 -3.193262604030971e-24,  5.862882428678616e-04, -2.057982118012836e-05,  4.902550121039287e-07, -9.270944419125840e-09,  1.503973893286117e-10, -2.176548146861141e-12,
  2.878534625151382e-14, -3.535447989377159e-16,  4.079118298712159e-18, -4.459079392081832e-20,  4.648790015635170e-22, -4.645969215966816e-24,  2.027940497565344e-04,
 -8.660222782087515e-06,  2.393165653015994e-07, -5.165730865035063e-09,  9.456122618814761e-11, -1.531403710690182e-12,  2.251680579510869e-14, -3.058265334639282e-16,
  3.884520049005602e-18, -4.656614509022475e-20,  5.305650861934370e-22, -5.777287494383892e-24,  6.326460622062746e-05, -3.243328287234622e-06,  1.034581045615004e-07,
 -2.538119280585877e-09,  5.223792964350697e-11, -9.436414154793525e-13,  1.537975827434831e-14, -2.303614872889985e-16,  3.212732632003770e-18, -4.212849934043136e-20,
  5.233297491923594e-22, -6.194439803039624e-24,  1.782442595542668e-05, -1.084540343309992e-06,  3.975025743865185e-08, -1.104178846176631e-09,  2.547127506443136e-11,
 -5.118243029720297e-13,  9.223624672303073e-15, -1.520002827133909e-16,  2.322526334962476e-18, -3.324493200237139e-20,  4.493531408081879e-22, -5.770544800820806e-24,
  4.543430644893250e-06, -3.248927515229343e-07,  1.362273804977655e-08, -4.270346967061781e-10,  1.101103704737683e-11, -2.455380906393091e-13,  4.882154983060501e-15,
 -8.834515783909551e-17,  1.476216211131071e-18, -2.302600197979752e-20,  3.380776004633831e-22, -4.702677313595538e-24,  1.050156522994051e-06, -8.750238194694750e-08,
  4.180229283587203e-09, -1.474318306056909e-10,  4.238996431793408e-12, -1.046834663118406e-13,  2.292372934800048e-15, -4.547322139700090e-17,  8.296488445837650e-19,
 -1.408069933690319e-20,  2.242558626666255e-22, -3.374267673425913e-24,  2.207476196345241e-07, -2.127204261635409e-08,  1.153404384729036e-09, -4.564292185344310e-11,
  1.460199764383012e-12, -3.986208476880984e-14,  9.598109708968932e-16, -2.084130896616604e-17,  4.146209784129509e-19, -7.647037048296798e-21,  1.319504772303624e-22,
 -2.145102919410266e-24,  4.235786712905212e-08, -4.689185730623482e-09,  2.875403236649294e-10, -1.273469643315527e-11,  4.524144712717081e-13, -1.363026298164527e-14,
  3.603541409841814e-16, -8.554257748754100e-18,  1.853470952217776e-19, -3.710748397990042e-21,  6.929836294436414e-23, -1.215969736877747e-24,  7.454795479004302e-09,
 -9.424100548113935e-10,  6.513161766846583e-11, -3.220636684031501e-12,  1.268229942590363e-13, -4.210444177640865e-15,  1.220639121482600e-16, -3.164103055129329e-18,
  7.458848655818646e-20, -1.619395201263541e-21,  3.270030528372347e-23, -6.187595394232486e-25,  1.210657962887511e-09, -1.738099838159589e-10,  1.349469344838346e-11,
 -7.433183618987786e-13,  3.238703076025993e-14, -1.183137869876498e-15,  3.756578457195876e-17, -1.062164873628663e-18,  2.721444476857905e-20, -6.401545230202630e-22,
  1.396502434805027e-23, -2.847181876294341e-25,  1.828092328461871e-10, -2.965242267678555e-11,  2.578146448468637e-12, -1.578322597286247e-13,  7.595713100614566e-15,
 -3.048891809160114e-16,  1.058919484360566e-17, -3.262321265537566e-19,  9.075948173060987e-21, -2.310911703657177e-22,  5.441532271150436e-24, -1.194354582988727e-25,
  2.591308088636297e-11, -4.725373579869381e-12,  4.586364693754389e-13, -3.113348912754565e-14,  1.651911021824703e-15, -7.274709192050002e-17,  2.760184028671688e-18,
 -9.254793429317425e-20,  2.792765319438989e-21, -7.689669070552401e-23,  1.952649636943060e-24, -4.609831240913859e-26,  3.489570537455552e-12, -7.118864646049806e-13,
  7.688036848273071e-14, -5.772734969503690e-15,  3.370318684204597e-16, -1.625681544537038e-17,  6.728707514650337e-19, -2.452235244308182e-20,  8.017059139283627e-22,
 -2.384437084793820e-23,  6.522598101879000e-25, -1.654559964350394e-26,  4.530979435826871e-13, -1.028893172358416e-13,  1.232095769685606e-14, -1.020579297781423e-15,
  6.541825564710993e-17, -3.449583377357113e-18,  1.554885475561943e-19, -6.149782595816100e-21,  2.175083362375837e-22, -6.978434215260667e-24,  2.053765345540407e-25,
 -5.590742249262370e-27,  5.776829603416560e-14, -1.452455473374862e-14,  1.921282420515784e-15, -1.750220664395860e-16,  1.228486416923370e-17, -7.065450400174582e-19,
  3.461011408551433e-20, -1.482731054426289e-21,  5.663201581042408e-23, -1.956662167116150e-24,  6.185256123427245e-26, -1.804028639832714e-27,  7.393790231652466e-15,
 -2.046499506351177e-15,  2.977365082226247e-16, -2.972062892021465e-17,  2.277103576173060e-18, -1.424342254823906e-19,  7.562598115530316e-21, -3.500800904521689e-22,
  1.440618215576591e-23, -5.348342139635079e-25,  1.812138269817016e-26, -5.651331721680741e-28,  9.753910145044726e-16, -2.953056666609930e-16,  4.701417362714627e-17,
 -5.120117030493342e-18,  4.265289967542750e-19, -2.891219767355681e-20,  1.658358449242434e-21, -8.268824095566654e-23,  3.655162672683223e-24, -1.453944978935223e-25,
  5.265626781947039e-27, -1.751123903005834e-28,  1.367539660203459e-16, -4.496166845456247e-17,  7.786296664862690e-18, -9.202073444575951e-19,  8.294155305110479e-20,
 -6.064952409743846e-21,  3.742001839869756e-22, -2.001575717686806e-23,  9.467362048873906e-25, -4.019945034370926e-26,  1.550556623921668e-27, -5.479528810491056e-29,
  2.108787661397776e-17, -7.467598119025982e-18,  1.396645665890598e-18, -1.779489558409841e-19,  1.724826541261265e-20, -1.352770178070199e-21,  8.929118187740934e-23,
 -5.097017842174956e-24,  2.566829652809749e-25, -1.157841367127098e-26,  4.734394789883685e-28, -1.769918770613802e-29,  3.707043308421122e-18, -1.400820142328209e-18,
  2.805351599962448e-19, -3.822721224930421e-20,  3.954585005378291e-21, -3.302789676393275e-22,  2.316289262393276e-23, -1.401791956658236e-24,  7.468657973679788e-26,
 -3.557205581972268e-27,  1.532906688452166e-28, -6.027867787650384e-30,  7.676525434494543e-19, -3.063305341996997e-19,  6.502895256453920e-20, -9.386015574478145e-21,
  1.026809278015192e-21, -9.052012759027179e-23,  6.688284676951621e-24, -4.256590270763941e-25,  2.380690857090145e-26, -1.188251678229151e-27,  5.357262066087696e-29,
 -2.200357054689716e-30,  1.908737926223757e-19, -7.951082734783048e-20,  1.768367836688635e-20, -2.673053341245605e-21,  3.058787142898477e-22, -2.816522906893911e-23,
  2.170431732829388e-24, -1.438525668250573e-25,  8.366847194861387e-27, -4.336815926934741e-28,  2.027837822534830e-29, -8.626201007039795e-31,  5.560982488028450e-20,
 -2.388071900570664e-20,  5.491526021646956e-21, -8.581387021231522e-22,  1.014315512025430e-22, -9.637713787569279e-24,  7.655711258949818e-25, -5.224905632641266e-26,
  3.126057902544589e-27, -1.665127813272646e-28,  7.993443750433858e-30, -3.487491999218012e-31,  1.528317089771391e-20, -6.676776536443695e-21,  1.564805246898164e-21,
 -2.492028146653482e-22,  3.000566356048167e-23, -2.902647680537553e-24,  2.346048027120071e-25, -1.628174356536757e-26,  9.900007171825089e-28, -5.356171168477306e-29,
  2.610177271572190e-30, -1.155394826688355e-31,  7.042710744653247e-02, -2.057251955424399e-04,  6.241897893995821e-07, -1.955119926960043e-09,  6.270525707212458e-12,
 -2.046311151703356e-14,  6.742192916842876e-17, -2.239065726396656e-19,  7.432653625357761e-22, -2.482466844626266e-24,  8.203596364181925e-27, -2.753325980690232e-29,
  6.311542825093058e-02, -2.248616786075452e-04,  9.744468755083087e-07, -4.439454227558779e-09,  2.008699143308639e-11, -8.908870602680214e-14,  3.870673288180862e-16,
 -1.651945832375949e-18,  6.939748258641698e-21, -2.877207544693326e-23,  1.178176711249729e-25, -4.776463784114117e-28,  5.069110142085943e-02, -2.458811714283999e-04,
  1.513632903363988e-06, -8.994575816701361e-09,  5.067878569886653e-11, -2.738639086105098e-13,  1.432238684931881e-15, -7.291108229503331e-18,  3.627341390469516e-20,
 -1.768791425137248e-22,  8.473119132616894e-25, -3.994691495575623e-27,  3.648711554003788e-02, -2.478984881887448e-04,  1.996102142326586e-06, -1.450660699045316e-08,
  9.796901600853781e-11, -6.274449749277191e-13,  3.853027098207560e-15, -2.284699515511852e-17,  1.314868118339831e-19, -7.372900794192119e-22,  4.040435420823123e-24,
 -2.169150969539991e-26,  2.353852521678224e-02, -2.214417277212446e-04,  2.211843200172069e-06, -1.919668438742546e-08,  1.528089935790201e-10, -1.141073783392662e-12,
  8.095927982456750e-15, -5.505313613841153e-17,  3.610925784417287e-19, -2.295360675607557e-21,  1.419390527600940e-23, -8.563357064043410e-26,  1.361084140982066e-02,
 -1.729977903716257e-04,  2.084807626198829e-06, -2.134136828810491e-08,  1.978115551577954e-10, -1.701506348122549e-12,  1.378863008439812e-14, -1.063671456488920e-16,
  7.869347504150188e-19, -5.614973525263232e-21,  3.880827493415918e-23, -2.607066206220941e-25,  7.055227877718579e-03, -1.180097211141143e-04,  1.690436070862015e-06,
 -2.022255666766884e-08,  2.161613789551282e-10, -2.122360192327347e-12,  1.947813634580427e-14, -1.690887855248834e-16,  1.400283724042534e-18, -1.113306622939408e-20,
  8.539862539874646e-23, -6.344562140440567e-25,  3.278994497333892e-03, -7.045350949607661e-05,  1.188736418894330e-06, -1.649087224630539e-08,  2.017307109959886e-10,
 -2.245016504664503e-12,  2.318149380711465e-14, -2.250595165991788e-16,  2.073975274063803e-18, -1.826980635948285e-20,  1.546906080037508e-22, -1.264305333611157e-24,
  1.366775724394810e-03, -3.693730180808564e-05,  7.292828369972388e-07, -1.165477267169855e-08,  1.621654275640061e-10, -2.034186771558567e-12,  2.350970002748870e-14,
 -2.540139667190634e-16,  2.592610374957230e-18, -2.519145599331029e-20,  2.344252927780408e-22, -2.099035764635776e-24,  5.111621253927972e-04, -1.706495850374955e-05,
  3.921182993364638e-07, -7.178415987245998e-09,  1.130434435067530e-10, -1.591105001859111e-12,  2.049565545877523e-14, -2.454734527028276e-16,  2.764522476618311e-18,
 -2.952257731825849e-20,  3.008974185049552e-22, -2.941733489846310e-24,  1.716230945257382e-04, -6.970075151925944e-06,  1.854826697958939e-07, -3.871091173364125e-09,
  6.871008784190142e-11, -1.081125630717311e-12,  1.546846661256402e-14, -2.046984769181778e-16,  2.535889812297834e-18, -2.967600110270666e-20,  3.303347016107255e-22,
 -3.516584314156786e-24,  5.177204578630687e-05, -2.524598594207632e-06,  7.745214969094704e-08, -1.835240488215076e-09,  3.658836282423511e-11, -6.415805387605887e-13,
  1.016692607040856e-14, -1.482590815388181e-16,  2.015297038746063e-18, -2.578139954354045e-20,  3.127032699915469e-22, -3.616655551630054e-24,  1.404719673434733e-05,
 -8.133171282046390e-07,  2.864289151364412e-08, -7.678117107638430e-10,  1.714284799317289e-11, -3.341242635113105e-13,  5.850311703440165e-15, -9.380211980460430e-17,
  1.396127224979220e-18, -1.948589887492749e-20,  2.570358933505785e-22, -3.223845219774144e-24,  3.433152429022854e-06, -2.337491837500633e-07,  9.411861783732232e-09,
 -2.845318439164275e-10,  7.096273045848517e-12, -1.533941011918540e-13,  2.961717405492928e-15, -5.211677724179711e-17,  8.478755490625050e-19, -1.288964649030677e-20,
  1.846192151009318e-22, -2.507268632831392e-24,  7.572659157114188e-07, -6.012591556556628e-08,  2.757517985497305e-09, -9.375236249531582e-11,  2.606084513618388e-12,
 -6.235849698376997e-14,  1.325442435447016e-15, -2.555783093767006e-17,  4.538317190463510e-19, -7.504555787282173e-21,  1.165620235719192e-22, -1.711894530313822e-24,
  1.511350506990261e-07, -1.389183811000924e-08,  7.231301235284467e-10, -2.758043452363894e-11,  8.528329039157893e-13, -2.255208812324739e-14,  5.269349184151971e-16,
 -1.111945626855295e-17,  2.152519150279797e-19, -3.867277513514949e-21,  6.506737295162240e-23, -1.032343766426667e-24,  2.738374975815156e-08, -2.895097218556915e-09,
  1.704853251684026e-10, -7.277795387844043e-12,  2.498952618386229e-13, -7.292395035208081e-15,  1.870703195418724e-16, -4.315308464902868e-18,  9.097555029237537e-20,
 -1.774173880057551e-21,  3.230615735554641e-23, -5.532300168051880e-25,  4.523896311431742e-09, -5.469495617031779e-10,  3.632372158474923e-11, -1.731849000276159e-12,
  6.592765980618839e-14, -2.120343929256516e-15,  5.965228926994537e-17, -1.502768855258434e-18,  3.447231613297202e-20, -7.291179619656897e-22,  1.435751731101667e-23,
 -2.651741351984138e-25,  6.852537992472088e-10, -9.424641262628902e-11,  7.037940939750673e-12, -3.740226555168813e-13,  1.576159813442877e-14, -5.580100088185064e-16,
  1.719924005340934e-17, -4.727682211346762e-19,  1.179085676677628e-20, -2.702760425352925e-22,  5.751458248703745e-24, -1.144898043208377e-25,  9.585709739409644e-11,
 -1.492420835111350e-11,  1.249596609806617e-12, -7.387558284078130e-14,  3.441182106797379e-15, -1.339498234637103e-16,  4.518862703502122e-18, -1.354162845558953e-19,
  3.669044991647847e-21, -9.108391212403389e-23,  2.093194119628555e-24, -4.487992725658291e-26,  1.249705843832170e-11, -2.192296608971835e-12,  2.052318897065278e-13,
 -1.347068941446435e-14,  6.925384162088620e-16, -2.960349720637617e-17,  1.091957479931101e-18, -3.564203378479151e-20,  1.048286796336345e-21, -2.816251837163617e-23,
  6.984418018272016e-25, -1.611862901223968e-26,  1.536208278895725e-12, -3.022496828568889e-13,  3.154392855496679e-14, -2.293823047687626e-15,  1.299419311702750e-16,
 -6.091577802812973e-18,  2.453975208588182e-19, -8.715691207378550e-21,  2.780063209181196e-22, -8.075617749202170e-24,  2.159587338889174e-25, -5.360160776865038e-27,
  1.806826104948109e-13, -3.968380979521402e-14,  4.602792330372078e-15, -3.699570887396338e-16,  2.304950844556176e-17, -1.183145500524800e-18,  5.198264648183913e-20,
 -2.006447742076392e-21,  6.933002384121603e-23, -2.175241564592885e-24,  6.266065163434301e-26, -1.671004331709648e-27,  2.070923236927022e-14, -5.052175217057939e-15,
  6.490075801654016e-16, -5.750322373321689e-17,  3.931392448004903e-18, -2.205325648305824e-19,  1.054915484105738e-20, -4.418091068915262e-22,  1.651297806395738e-23,
 -5.588139248726269e-25,  1.731658725315407e-26, -4.955067933134981e-28,  2.366063649732150e-15, -6.376587804704966e-16,  9.036498704359113e-17, -8.797201859080490e-18,
  6.581542093047684e-19, -4.024602326653863e-20,  2.091259886922410e-21, -9.483285177240405e-23,  3.826362932207008e-24, -1.394001353581644e-25,  4.638484349283931e-27,
 -1.421665709809542e-28,  2.769863516766782e-16, -8.195979211341318e-17,  1.275283031940366e-17, -1.358659913533062e-18,  1.108349900531517e-19, -7.364353052294912e-21,
  4.144353378023406e-22, -2.029166701262371e-23,  8.814950256732627e-25, -3.448412726143995e-26,  1.229068936983949e-27, -4.025184542904673e-29,  3.432817824599308e-17,
 -1.107431229880963e-17,  1.881203089415617e-18, -2.182298404894215e-19,  1.932305959149021e-20, -1.389169384559716e-21,  8.433102009570304e-23, -4.441420614583346e-24,
  2.069836541240230e-25, -8.664748636024809e-27,  3.296904618207319e-28, -1.149988390918060e-29,  4.675681270174404e-18, -1.631172701915449e-18,  3.003983205442677e-19,
 -3.770479320881110e-20,  3.602472453497559e-21, -2.786790037158826e-22,  1.815413886318496e-23, -1.023336661619180e-24,  5.091770931712471e-26, -2.270442360447738e-27,
  9.181688344898867e-29, -3.396349384524184e-30,  7.286811269242700e-19, -2.723323234251773e-19,  5.391005886298871e-20, -7.263424536620256e-21,  7.432611378450831e-22,
 -6.143133215861394e-23,  4.265440219875787e-24, -2.556832685089745e-25,  1.349849337485323e-26, -6.372978527139059e-28,  2.723312976875598e-29, -1.062308548993881e-30,
  1.350425636041981e-19, -5.348959741988020e-20,  1.126527751996595e-20, -1.613379992656829e-21,  1.751795867227334e-22, -1.533229445132031e-23,  1.125058237901203e-24,
 -7.112893519381581e-26,  3.953048539663911e-27, -1.961086994624848e-28,  8.790211774513185e-30, -3.590266476649065e-31,  3.054151676785903e-20, -1.266704452885754e-20,
  2.803943137426498e-21, -4.218707380797586e-22,  4.805747772134180e-23, -4.405944246556762e-24,  3.381124100094799e-25, -2.232006805920916e-26,  1.293223457632494e-27,
 -6.678583455976916e-29,  3.111808105071761e-30, -1.319260886007240e-31,  8.283966686849993e-21, -3.550076910422369e-21,  8.145162746489105e-22, -1.269954205043380e-22,
  1.497803089464722e-23, -1.420166864093003e-24,  1.125818434833747e-25, -7.668529630412614e-27,  4.579455871308486e-28, -2.434886730120136e-29,  1.166834376102737e-30,
 -5.082332368063779e-32,  2.182830544778884e-21, -9.529315965341502e-22,  2.231555970697631e-22, -3.551009298028741e-23,  4.272280382619496e-24, -4.129685858377469e-25,
  3.335300787769555e-26, -2.313043423778292e-27,  1.405440204482668e-28, -7.598612099090921e-30,  3.700509112921459e-31, -1.636977538331849e-32,  6.961404747945929e-02,
 -2.008238479438658e-04,  6.013170941704612e-07, -1.857979779564190e-09,  5.876950467554669e-12, -1.891761054767802e-14,  6.147253106919099e-17, -2.014909465093395e-19,
  6.595222715868007e-22, -2.177344624935487e-24,  7.081115489100396e-27, -2.360449841788851e-29,  6.223124282689590e-02, -2.172738659566160e-04,  9.230445704718841e-07,
 -4.131827108794481e-09,  1.839449260221919e-11, -8.032997534963144e-14,  3.437723925655703e-16, -1.445576595822607e-18,  5.983953660400408e-21, -2.445398923199141e-23,
  9.869147433031205e-26, -3.945432250677725e-28,  4.973113020054381e-02, -2.341904676854722e-04,  1.410388272451650e-06, -8.225732956319214e-09,  4.552936231269411e-11,
 -2.418144859476686e-13,  1.243425593231003e-15, -6.226028852930142e-18,  3.047574556384573e-20, -1.462547983095264e-22,  6.896771831204077e-25, -3.201461641893848e-27,
  3.552639312197424e-02, -2.326002627329933e-04,  1.831029471112792e-06, -1.303467883584840e-08,  8.629538309871208e-11, -5.421969131601382e-13,  3.268439140758095e-15,
 -1.903467864291325e-17,  1.076373959726346e-19, -5.932502826652090e-22,  3.196571148343791e-24, -1.687792787359409e-26,  2.268674532436506e-02, -2.046285272775664e-04,
  1.995432361858098e-06, -1.692425676078865e-08,  1.318121179102991e-10, -9.640362649507716e-13,  6.704527707357503e-15, -4.471768847665759e-17,  2.878323443038958e-19,
 -1.796333730899386e-21,  1.090990986853779e-23, -6.466847752685084e-26,  1.295065791744248e-02, -1.572923845966486e-04,  1.846633716422483e-06, -1.843160775909766e-08,
  1.668634096733626e-10, -1.403649626151095e-12,  1.113452133917519e-14, -8.414093185392995e-17,  6.101785921460301e-19, -4.269841968223250e-21,  2.895557363049177e-23,
 -1.909315407756708e-25,  6.608778007397034e-03, -1.054011879785376e-04,  1.467194212205964e-06, -1.707967589527682e-08,  1.780301131550039e-10, -1.706983369601710e-12,
  1.531512740618774e-14, -1.300840392805650e-16,  1.054800271553292e-18, -8.216291622576752e-21,  6.177972445166578e-23, -4.501231243969238e-25,  3.015020136386125e-03,
 -6.168353540586486e-05,  1.008822762305909e-06, -1.359416986937120e-08,  1.619198312379796e-10, -1.757348733435689e-12,  1.771801521177374e-14, -1.681224058821268e-16,
  1.515421930901417e-18, -1.306653604744971e-20,  1.083534085993881e-22, -8.677781876305004e-25,  1.229867711876100e-03, -3.162126334989506e-05,  6.037439640965484e-07,
 -9.357198743363370e-09,  1.265930332560062e-10, -1.546705255693601e-12,  1.743438941014310e-14, -1.839173399595040e-16,  1.834387799648294e-18, -1.743098648210602e-20,
  1.587343033004574e-22, -1.391663670580318e-24,  4.486710500643072e-04, -1.424408401316548e-05,  3.158599442137212e-07, -5.599740223418637e-09,  8.563134654987074e-11,
 -1.172596689551763e-12,  1.471633099820612e-14, -1.719223578056287e-16,  1.890406593316511e-18, -1.972658970368701e-20,  1.966018362529200e-22, -1.880692102495259e-24,
  1.464406858355673e-04, -5.654858334269723e-06,  1.449725866695414e-07, -2.926334545706730e-09,  5.037926227659791e-11, -7.703942798162336e-13,  1.072894860191471e-14,
 -1.383679482341253e-16,  1.672285742142755e-18, -1.910853565126551e-20,  2.078505520996611e-22, -2.163660219325641e-24,  4.278627228070821e-05, -1.984016484205806e-06,
  5.855768533256856e-08, -1.340512409617450e-09,  2.589487658229095e-11, -4.408804602843781e-13,  6.794557771945660e-15, -9.648597453760371e-17,  1.278584677795230e-18,
 -1.596070857961219e-20,  1.890553198683442e-22, -2.136935003806268e-24,  1.119983150074935e-05, -6.168285000256354e-07,  2.087681595178807e-08, -5.401670434823501e-10,
  1.167527246998673e-11, -2.207694467508088e-13,  3.756546960852446e-15, -5.861350007845934e-17,  8.499354012951778e-19, -1.156877532931191e-20,  1.489507756948507e-22,
 -1.824909501025761e-24,  2.629567479466565e-06, -1.703919559605293e-07,  6.588758130759251e-09, -1.921184741299957e-10,  4.635197725358788e-12, -9.714088527796533e-14,
  1.821571463917373e-15, -3.117507023327078e-17,  4.938679021401522e-19, -7.318432990887607e-21,  1.022696161165017e-22, -1.356178175955342e-24,  5.546459346977777e-07,
 -4.194168412908477e-08,  1.846515682935961e-09, -6.052068663542646e-11,  1.626583905832608e-12, -3.771502131282319e-14,  7.781771167987142e-16, -1.458729934123138e-17,
  2.521257817077499e-19, -4.062420000283951e-21,  6.154094952478665e-23, -8.822675867464334e-25,  1.053290048755425e-07, -9.228976314979300e-09,  4.611194639200176e-10,
 -1.694965991802823e-11,  5.065722966363297e-13, -1.297609860250740e-14,  2.942179095158931e-16, -6.033863969966222e-18,  1.136604264627902e-19, -1.989283124381364e-21,
  3.263669609819444e-23, -5.053600803944657e-25,  1.806113300529072e-08, -1.822259168046200e-09,  1.030194387188151e-10, -4.238154688192464e-12,  1.406358797603703e-13,
 -3.974835781177501e-15,  9.893241359600858e-17, -2.217583619852055e-18,  4.548678857342988e-20, -8.640460084438271e-22,  1.534045955550271e-23, -2.563679431849851e-25,
  2.807283847034334e-09, -3.243366560411816e-10,  2.068883477866728e-11, -9.508143572981737e-13,  3.498315117369872e-14, -1.089758636503094e-15,  2.974738656670959e-17,
 -7.282151706250700e-19,  1.625340246502435e-20, -3.348654843651248e-22,  6.429676185187735e-24, -1.158986064455867e-25,  3.975432782165121e-10, -5.233086781082483e-11,
  3.756471252704174e-12, -1.925258506776858e-13,  7.844256315655224e-15, -2.690599293950479e-16,  8.048594925318674e-18, -2.150319415165574e-19,  5.219170874065821e-21,
 -1.165622442924474e-22,  2.419152110839840e-24, -4.701011563769793e-26,  5.163367934468647e-11, -7.708332046646426e-12,  6.211015266315151e-13, -3.544031732006035e-14,
  1.597131066678218e-15, -6.026503499267830e-17,  1.974088527010615e-18, -5.752386295607512e-20,  1.517465619624768e-21, -3.671844607167278e-23,  8.233179197528675e-25,
 -1.723973955731680e-26,  6.204305364520366e-12, -1.045854550124194e-12,  9.435565386621339e-14, -5.984181313202568e-15,  2.979225788012316e-16, -1.235526486798608e-17,
  4.428494059841701e-19, -1.406559651513651e-20,  4.030469114312661e-22, -1.056099867735155e-23,  2.557135188480750e-25, -5.766907824155183e-27,  6.974638985913009e-13,
 -1.321866110457064e-13,  1.331894283812599e-14, -9.372278132068667e-16,  5.147927225972409e-17, -2.344005507138105e-18,  9.185379000595549e-20, -3.177624342467925e-21,
  9.884230341836940e-23, -2.802941528896584e-24,  7.324521342253195e-26, -1.778073483687887e-27,  7.441298552863746e-14, -1.578721153426938e-14,  1.771698379399935e-15,
 -1.380552257211850e-16,  8.353550883526408e-18, -4.170994207673790e-19,  1.785078956507779e-20, -6.719933492248245e-22,  2.267163638063282e-23, -6.952394122904903e-25,
  1.959249763166445e-26, -5.115878091272054e-28,  7.673603216249489e-15, -1.813989700447952e-15,  2.260458989805482e-16, -1.946012648976507e-17,  1.294748972992365e-18,
 -7.078015819598220e-20,  3.303757458990461e-21, -1.351683744179379e-22,  4.940467095684388e-24, -1.636533577661200e-25,  4.968373333903829e-27, -1.393978655809883e-28,
  7.826118530613734e-16, -2.050881463785753e-16,  2.827679269758192e-17, -2.681832682024970e-18,  1.957278913831977e-19, -1.169026882650432e-20,  5.939885802390502e-22,
 -2.636614965668806e-23,  1.042325202975424e-24, -3.723811235991102e-26,  1.216066038636591e-27, -3.660748255853596e-29,  8.121771037444429e-17, -2.345702578286967e-17,
  3.562963551988845e-18, -3.709349551661607e-19,  2.960245724035449e-20, -1.926231357870990e-21,  1.062625142329981e-22, -5.104866534450748e-24,  2.177678418747829e-25,
 -8.372153718360060e-27,  2.934614448459257e-28, -9.458446559282714e-30,  8.877628670964945e-18, -2.806704444274601e-18,  4.671444053131682e-19, -5.313678041401292e-20,
  4.617498505672034e-21, -3.260716803194551e-22,  1.945936630769415e-23, -1.008276784633721e-24,  4.626161417967246e-26, -1.907905416165397e-27,  7.156381160447766e-29,
 -2.462238288535578e-30,  1.064253344572071e-18, -3.653784852315102e-19,  6.618901037168710e-20, -8.176279563880432e-21,  7.693459098739261e-22, -5.865192676130827e-23,
  3.767858660293821e-24, -2.095784860364821e-25,  1.029575868276179e-26, -4.535214657369213e-28,  1.812716033780348e-29, -6.630675586363811e-31,  1.463380924025188e-19,
 -5.404441862846972e-20,  1.056610074823917e-20, -1.406433814676193e-21,  1.422518673310137e-22, -1.162682951122906e-23,  7.987328043907561e-25, -4.739236472884558e-26,
  2.477714318297074e-27, -1.158908056780512e-28,  4.908119465955132e-30, -1.898227824094561e-31,  2.413444022756372e-20, -9.482821219822924e-21,  1.980108116352876e-21,
 -2.812146862017481e-22,  3.028803138843466e-23, -2.630417320872876e-24,  1.915867745133312e-25, -1.202674304950355e-26,  6.638606839792584e-28, -3.271974635444249e-29,
  1.457468807259049e-30, -5.917415290122341e-32,  4.936006361969522e-21, -2.037504760331144e-21,  4.487097258831082e-22, -6.717100720576632e-23,  7.614516904663264e-24,
 -6.948349667708381e-25,  5.308213944361485e-26, -3.489062684855374e-27,  2.013218499198503e-28, -1.035572077395609e-29,  4.806825260296766e-31, -2.030473158361407e-32,
  1.240199511199489e-21, -5.302940666367068e-22,  1.213701331915168e-22, -1.887742303630986e-23,  2.221174424284629e-24, -2.101246439335053e-25,  1.662084655614968e-26,
 -1.129746536113507e-27,  6.732908433033790e-29, -3.572907990578916e-30,  1.708989231359834e-31, -7.430424845412733e-33,  3.123197898759414e-22, -1.362409816455267e-22,
  3.187738277662241e-23, -5.068210302322638e-24,  6.092528763931509e-25, -5.884361467269666e-26,  4.748670053043916e-27, -3.290680432111177e-28,  1.997971696319579e-29,
 -1.079433981216992e-30,  5.253123639443428e-32, -2.322219034987295e-33,  6.882023417421003e-02, -1.961009239327189e-04,  5.795732929577035e-07, -1.766897105787111e-09,
  5.512906707357188e-12, -1.750765644942081e-14,  5.611484503598002e-17, -1.815876883581882e-19,  5.859952324593559e-22, -1.913862947748509e-24,  6.116846342427834e-27,
 -2.032459807311441e-29,  6.137660896342788e-02, -2.100829530479761e-04,  8.751769140796079e-07, -3.849933126768583e-09,  1.686722837458675e-11, -7.254430070277330e-14,
  3.058499557261277e-16, -1.267446360865323e-18,  5.170676695429282e-21, -2.083258535753642e-23,  8.287176407312307e-26, -3.268011720238565e-28,  4.881632639805574e-02,
 -2.232901700113559e-04,  1.315895793115800e-06, -7.534389399746982e-09,  4.097792366059941e-11, -2.139586983727482e-13,  1.081994811143712e-15, -5.329987081405731e-18,
  2.567498960558309e-20, -1.212897315678935e-22,  5.631394295235668e-25, -2.574348587857158e-27,  3.462432999166973e-02, -2.185550165251676e-04,  1.682553158976562e-06,
 -1.173661661975611e-08,  7.619463046611597e-11, -4.697796952295275e-13,  2.780646897100546e-15, -1.590869847344741e-17,  8.841361538683805e-20, -4.790822888438614e-22,
  2.538687775725049e-24, -1.318585778115125e-26,  2.189892064251652e-02, -1.894429903855683e-04,  1.804386180306139e-06, -1.496117369638791e-08,  1.140441955302484e-10,
 -8.171688157523164e-13,  5.572229298795740e-15, -3.646278128861073e-17,  2.303791851098019e-19, -1.411920173988002e-21,  8.424204152256993e-24, -4.907121265236697e-26,
  1.234969509312786e-02, -1.433606882277441e-04,  1.640591837174556e-06, -1.597262079816520e-08,  1.412826987909195e-10, -1.162620489917560e-12,  9.030330270053833e-15,
 -6.686655926775490e-17,  4.754355790663553e-19, -3.263635673256520e-21,  2.172056103666035e-23, -1.406161938963605e-25,  6.209415406543436e-03, -9.443750527930749e-05,
  1.278263848529234e-06, -1.448551361677683e-08,  1.472896572172853e-10, -1.379571558096632e-12,  1.210404679489109e-14, -1.006222782324463e-16,  7.991037968228640e-19,
 -6.099972151220336e-21,  4.497171500347919e-23, -3.214122066096235e-25,  2.783452837390731e-03, -5.422395989431142e-05,  8.601478709497233e-07, -1.126303129980765e-08,
  1.306704576394957e-10, -1.383532219374692e-12,  1.362433838599111e-14, -1.263880957183751e-16,  1.114640505961220e-18, -9.409600779944599e-21,  7.643867973990170e-23,
 -6.000127533110814e-25,  1.112377102934016e-03, -2.720823539213050e-05,  5.026588156029290e-07, -7.558087181331573e-09,  9.945802813824510e-11, -1.183981794021631e-12,
  1.302026213859052e-14, -1.341422456812195e-16,  1.307797228302290e-18, -1.215618915779987e-20,  1.083552390569181e-22, -9.303848012163282e-25,  3.963535731225116e-04,
 -1.196436558803372e-05,  2.561677254552429e-07, -4.399585672714552e-09,  6.535414113965545e-11, -8.709406225697451e-13,  1.065259758284601e-14, -1.214223968834814e-16,
  1.303894577337241e-18, -1.329870525867153e-20,  1.296338042747069e-22, -1.213642024853361e-24,  1.259363212463423e-04, -4.622924768045122e-06,  1.142264861262075e-07,
 -2.230754967144683e-09,  3.726125523176636e-11, -5.539267113901694e-13,  7.510859759672278e-15, -9.442610324483449e-17,  1.113609479338514e-18, -1.242775133928404e-20,
  1.321255317458832e-22, -1.345197784702032e-24,  3.569437780152878e-05, -1.573473010216646e-06,  4.469284025169064e-08, -9.887168422768972e-10,  1.851094864460890e-11,
 -3.060899527812644e-13,  4.588806291283445e-15, -6.347116005597787e-17,  8.201360621174030e-19, -9.992060964290073e-21,  1.156082569355479e-22, -1.277322085432209e-24,
  9.029571703849546e-06, -4.728726221852404e-07,  1.538439586342009e-08, -3.842945187468087e-10,  8.042908079379714e-12, -1.475803815556715e-13,  2.440899904546673e-15,
 -3.706994642419906e-17,  5.238046599396337e-19, -6.954331920390094e-21,  8.741117532782321e-23, -1.046293222552223e-24,  2.040421814047130e-06, -1.257763786948364e-07,
  4.671156889114381e-09, -1.313900423489614e-10,  3.067142687164189e-12, -6.233002423964538e-14,  1.135332846153485e-15, -1.890085249129705e-17,  2.916082283965789e-19,
 -4.212772749552670e-21,  5.744444603213527e-23, -7.439082852033954e-25,  4.123804410945493e-07, -2.968348329541941e-08,  1.254471178023465e-09, -3.963905095913558e-11,
  1.030156591857744e-12, -2.314827116842206e-14,  4.636919821577997e-16, -8.450971472962440e-18,  1.421889803683830e-19, -2.232615462357802e-21,  3.298989074520077e-23,
 -4.617112975283675e-25,  7.467418129922931e-08, -6.233305519259504e-09,  2.988921981808117e-10, -1.058783370823099e-11,  3.058507520795355e-13, -7.589386099164039e-15,
  1.669957548389140e-16, -3.328529258608540e-18,  6.101507428604484e-20, -1.040335053270593e-21,  1.664380992105076e-23, -2.515344209319893e-25,  1.214528715544045e-08,
 -1.168579674940194e-09,  6.340583871334546e-11, -2.513429136140214e-12,  8.059538343442762e-14, -2.206082452230463e-15,  5.327352575386092e-17, -1.160318283518059e-18,
  2.315617380222902e-20, -4.284412233164267e-22,  7.416479988317653e-24, -1.209539263227995e-25,  1.780226427090457e-09, -1.963846342176380e-10,  1.202718081197697e-11,
 -5.326569562844327e-13,  1.893798297432348e-14, -5.713130673975854e-16,  1.512997036251898e-17, -3.598733130842474e-19,  7.814474194508212e-21, -1.568146420825985e-22,
  2.935662143141919e-24, -5.164123810325248e-26,  2.362393435836002e-10, -2.973642299892455e-11,  2.050754819591173e-12, -1.013233496984035e-13,  3.990254555861770e-15,
 -1.325697185669463e-16,  3.847911060922582e-18, -9.990050967130153e-20,  2.359339812794219e-21, -5.132970054660607e-23,  1.038819144342166e-24, -1.970337617094276e-26,
  2.855521178300136e-11, -4.083479891995659e-12,  3.164171356370502e-13, -1.741699199044251e-14,  7.590458334727501e-16, -2.775400066963326e-17,  8.824733832371899e-19,
 -2.499748168364063e-20,  6.418577546389409e-22, -1.513460794780897e-23,  3.310285700728679e-25, -6.767817561273288e-27,  3.169448305353287e-12, -5.128153161672047e-13,
  4.455082861129280e-14, -2.728362862265006e-15,  1.314641054962843e-16, -5.286849227352885e-18,  1.840581876397218e-19, -5.686319910180137e-21,  1.586899176667723e-22,
 -4.054217021332439e-24,  9.580836893282855e-26, -2.110803856399953e-27,  3.264858679840970e-13, -5.953202980326415e-14,  5.785733605429039e-15, -3.936656020234736e-16,
  2.095175901490622e-17, -9.260464374900033e-19,  3.528040862469318e-20, -1.188216736112442e-21,  3.602639460769021e-23, -9.968991527433037e-25,  2.544517688495000e-26,
 -6.039014609296845e-28,  3.164887964309775e-14, -6.477526914043856e-15,  7.026098092298631e-16, -5.302992896293060e-17,  3.113895404271290e-18, -1.511315878071334e-19,
  6.296333014118191e-21, -2.310314426364330e-22,  7.606205483695189e-24, -2.278524087177754e-25,  6.278523673226278e-27, -1.604449481001675e-28,  2.939528889594325e-15,
 -6.724231477123898e-16,  8.118932327451474e-17, -6.784544127638109e-18,  4.388920631671491e-19, -2.336305188786132e-20,  1.063290368571665e-21, -4.246834838499251e-23,
  1.516966348941272e-24, -4.915632477522735e-26,  1.461194799482101e-27, -4.017553513703329e-29,  2.676937552683149e-16, -6.811798806411970e-17,  9.126533038059194e-18,
 -8.423597138831489e-19,  5.991463449397265e-20, -3.492143786951955e-21,  1.733618896147746e-22, -7.526675926854351e-24,  2.913213773714509e-25, -1.019917681103186e-26,
  3.266686956059895e-28, -9.652534699900385e-30,  2.460935841707881e-17, -6.928013442082407e-18,  1.026000481430675e-18, -1.042636727027022e-19,  8.131744359322169e-21,
 -5.176990567085093e-22,  2.797154999105023e-23, -1.317365700481354e-24,  5.514244768761536e-26, -2.081877204412320e-27,  7.171726864157758e-29, -2.273340018457422e-30,
  2.367782107875296e-18, -7.326833945608353e-19,  1.193408381449653e-19, -1.329603518585923e-20,  1.132770876675326e-21, -7.849906772004275e-23,  4.601285727122584e-24,
 -2.343612149215910e-25,  1.057823529360384e-26, -4.294805279163385e-28,  1.586941717688103e-29, -5.382165833084534e-31,  2.489862025049528e-19, -8.402728149737638e-20,
  1.495666892829331e-20, -1.816490088110679e-21,  1.681696673443054e-22, -1.262346910692282e-23,  7.990409240529269e-25, -4.382164430664475e-26,  2.123924963466735e-27,
 -9.235734066602372e-29,  3.646144870671171e-30, -1.318030998998563e-31,  3.006369709127859e-20, -1.096128808856616e-20,  2.114552407473654e-21, -2.778288560135457e-22,
  2.775228453127173e-23, -2.241414671198350e-24,  1.522346915130464e-25, -8.934942152365622e-27,  4.622891786728159e-28, -2.140850814158081e-29,  8.980732858100882e-31,
 -3.441806321181245e-32,  4.386835171279044e-21, -1.708661673480087e-21,  3.534956866217275e-22, -4.975063819717026e-23,  5.311835655688463e-24, -4.574780421899838e-25,
  3.305526945174193e-26, -2.059228232434399e-27,  1.128389632632231e-28, -5.522739606555962e-30,  2.443631908097232e-31, -9.858013432060715e-33,  8.063974263793354e-22,
 -3.311510417154070e-22,  7.252263483211199e-23, -1.079718106907132e-23,  1.217511718872504e-24, -1.105366918310738e-25,  8.403488839469378e-27, -5.497892900119242e-28,
  3.158209115838249e-29, -1.617613803830489e-30,  7.477825606367147e-32, -3.146408201934918e-33,  1.866774175073301e-22, -7.962626116021187e-23,  1.817573841125768e-23,
 -2.819522552586177e-24,  3.309046334733201e-25, -3.122663259143182e-26,  2.464171895248868e-27, -1.671127502834827e-28,  9.937601874472598e-30, -5.262462001442241e-31,
  2.512065239546656e-32, -1.090100272397832e-33,  4.477188957031804e-23, -1.951444523125920e-23,  4.561773969836737e-24, -7.246159882725315e-25,  8.702841172693624e-26,
 -8.398147729330026e-27,  6.771550160703603e-28, -4.688620231835842e-29,  2.844480870055645e-30, -1.535588558206229e-31,  7.467442285488401e-33, -3.298707283596297e-34,
  6.804497144944584e-02, -1.915476752841740e-04,  5.588884440745794e-07, -1.681420341134730e-09,  5.175819987237758e-12, -1.621985668988812e-14,  5.128288459121962e-17,
 -1.638927021668221e-19,  5.212924836086944e-22, -1.686235471661888e-24,  5.284352636591873e-27, -1.760151998731174e-29,  6.054999372177311e-02, -2.032618543740511e-04,
  8.305503509761239e-07, -3.591277470906690e-09,  1.548696555163628e-11, -6.561173735459513e-14,  2.725695783210523e-16, -1.113371591688355e-18,  4.477063121625652e-21,
 -1.778819424601016e-23,  6.975073864789581e-26, -2.714391970163492e-28,  4.794366275510301e-02, -2.131138246582507e-04,  1.229280223862931e-06, -6.911614213033924e-09,
  3.694680327945696e-11, -1.896927422632950e-13,  9.436309066955435e-16, -4.574114991005538e-18,  2.168814593067677e-20, -1.008747935711584e-22,  4.612278280739920e-25,
 -2.076830370429646e-27,  3.377616713933445e-02, -2.056379151483494e-04,  1.548729734515163e-06, -1.058918721638009e-08,  6.743189800131902e-11, -4.080850513336699e-13,
  2.372353271521051e-15, -1.333689594037332e-17,  7.286289579383856e-20, -3.882474683948642e-22,  2.023742201177798e-24, -1.034205703950195e-26,  2.116892402345861e-02,
 -1.756962138125628e-04,  1.635283630739795e-06, -1.326028010899902e-08,  9.895957082753802e-11, -6.948984972984311e-13,  4.647280305962295e-15, -2.984287669635073e-17,
  1.851290804853119e-19, -1.114456331560751e-21,  6.533803522330118e-24, -3.740978143015108e-26,  1.180133990575821e-02, -1.309659041521926e-04,  1.461752673476540e-06,
 -1.388694831866873e-08,  1.200543600662127e-10, -9.667434052054463e-13,  7.354527876618086e-15, -5.337618323124692e-17,  3.721995197820370e-19, -2.506964234567089e-21,
  1.637834273580948e-23, -1.041243070244588e-25,  5.851070626151578e-03, -8.486863531454078e-05,  1.117715604810356e-06, -1.233473529309669e-08,  1.223891016593238e-10,
 -1.120185109774930e-12,  9.613932290172396e-15, -7.824324193301887e-17,  6.087440049117501e-19, -4.555004149709117e-21,  3.293424297874039e-23, -2.309455270389248e-25,
  2.579510916677353e-03, -4.784985330062047e-05,  7.366771558320054e-07, -9.377037507075189e-09,  1.060025813584767e-10, -1.095277072416008e-12,  1.053783190609787e-14,
 -9.559744475249138e-17,  8.251122853326491e-19, -6.821352076867820e-21,  5.429737605324512e-23, -4.178391773243027e-25,  1.011048238585647e-03, -2.352439582471019e-05,
  4.207800144974443e-07, -6.140414250321412e-09,  7.862184761806601e-11, -9.122146276989922e-13,  9.789913381837576e-15, -9.853218442299103e-17,  9.392386916250870e-19,
 -8.542202144196721e-21,  7.454718408859302e-23, -6.270375459647645e-25,  3.522838835670124e-04, -1.010966656428577e-05,  2.091139047625745e-07, -3.480455375280422e-09,
  5.023917854850492e-11, -6.517703366476447e-13,  7.771515285875138e-15, -8.645292110253098e-17,  9.068961641529135e-19, -9.042778213407622e-21,  8.623549421929228e-23,
 -7.903101224370117e-25,  1.091159818716652e-04, -3.806836578707310e-06,  9.069834858098416e-08, -1.714240443272136e-09,  2.779034996728058e-11, -4.017460390645881e-13,
  5.305219464692392e-15, -6.503449435308443e-17,  7.486139326579277e-19, -8.161346212168393e-21,  8.482475689486937e-23, -8.448406068956732e-25,  3.004696908031155e-05,
 -1.258782896053009e-06,  3.442112169539850e-08, -7.360871072698758e-10,  1.336053478792112e-11, -2.146222917623975e-13,  3.130736117136783e-15, -4.218919627926597e-17,
  5.316837070744264e-19, -6.323565284421482e-21,  7.147937764101887e-23, -7.721196843921424e-25,  7.357841957564999e-06, -3.662611873440109e-07,  1.145699987323586e-08,
 -2.763594884889864e-10,  5.601930193027620e-12, -9.976946720164667e-14,  1.604304384577827e-15, -2.371991801893078e-17,  3.266675488892263e-19, -4.231146794482209e-21,
  5.192812807394196e-23, -6.073645165068920e-25,  1.603133151655778e-06, -9.396552797303282e-08,  3.352130303396842e-09, -9.097070510509665e-11,  2.055062892013151e-12,
 -4.050399855736849e-14,  7.167757663641604e-16, -1.160948280076096e-17,  1.744684416867940e-19, -2.457608947687354e-21,  3.270446611813103e-23, -4.136551929863607e-25,
  3.110591725260548e-07, -2.130180760634206e-08,  8.641789076106007e-10, -2.632768643799132e-11,  6.616827710786995e-13, -1.441109083130775e-14,  2.802913453701780e-16,
 -4.967305579480068e-18,  8.136700853895410e-20, -1.245160148669336e-21,  1.794837777568835e-23, -2.452508680883604e-25,  5.382240448245028e-08, -4.277456236845331e-09,
  1.968183512717789e-10, -6.718881172543735e-12,  1.876014610550987e-13, -4.509739898440746e-15,  9.630561016614841e-17, -1.865724567706886e-18,  3.328367132963504e-20,
 -5.528949732954810e-22,  8.626145717307386e-24, -1.272429688321055e-25,  8.321477171069125e-09, -7.630068322418760e-10,  3.972394177669254e-11, -1.517111581838495e-12,
  4.700674631243398e-14, -1.246088083543750e-15,  2.919471529930507e-17, -6.178645731572228e-19,  1.199686923559295e-20, -2.162051751925182e-22,  3.649035640173752e-24,
 -5.807593601503821e-26,  1.152911068026524e-09, -1.213389592659388e-10,  7.131917615945515e-12, -3.043070926498489e-13,  1.045325513609481e-14, -3.053581016246176e-16,
  7.844725729137615e-18, -1.812822583758290e-19,  3.829482348323832e-21, -7.484433535737003e-23,  1.366002528045313e-24, -2.344855313703205e-26,  1.437077119654447e-10,
 -1.728162895954728e-11,  1.144424891551761e-12, -5.448967054778919e-14,  2.073553683026465e-15, -6.671284607190402e-17,  1.878528882194980e-18, -4.738574132302831e-20,
  1.088750386125047e-21, -2.307099130570980e-23,  4.552439180511910e-25, -8.426745217240702e-27,  1.620428524014523e-11, -2.217439550270196e-12,  1.651293896157774e-13,
 -8.764025290528631e-15,  3.692154073675401e-16, -1.307753273007342e-17,  4.035059052919284e-19, -1.110818996095156e-20,  2.775568353096837e-22, -6.376056399800488e-24,
  1.360076220530080e-25, -2.714411313352071e-27,  1.665212364874190e-12, -2.583206607809620e-13,  2.159280378268437e-14, -1.276130295720949e-15,  5.948140424765807e-17,
 -2.318550033805494e-18,  7.837078549993978e-20, -2.354208766310249e-21,  6.396401182534678e-23, -1.592804896887593e-24,  3.672609526043521e-26, -7.902192950570258e-28,
  1.575184343978213e-13, -2.759985672818913e-14,  2.584878420972471e-15, -1.699320207854298e-16,  8.757762815554531e-18, -3.755287485664126e-19,  1.390214924521574e-20,
 -4.556110223232466e-22,  1.345897445734887e-23, -3.632626337917657e-25,  9.052995855009827e-27, -2.099804205833304e-28,  1.389905290626258e-14, -2.740684452156239e-15,
  2.870330861826316e-16, -2.096524120190810e-17,  1.193747453479018e-18, -5.627895399990771e-20,  2.280966876147601e-21, -8.153138574587901e-23,  2.617966533961535e-24,
 -7.657034882896319e-26,  2.062060411750150e-27, -5.154729811005122e-29,  1.164259213709890e-15, -2.573603584990719e-16,  3.007421179021022e-17, -2.437006435243234e-18,
  1.531461721912247e-19, -7.931859964148798e-21,  3.517243168596485e-22, -1.370454515248333e-23,  4.780946539286430e-25, -1.514609871301456e-26,  4.405744871286860e-28,
 -1.186442213090140e-29,  9.472896106320782e-17, -2.337308812484205e-17,  3.039364927763572e-18, -2.727053871705391e-19,  1.888504059450643e-20, -1.073186466478933e-21,
  5.200972287093962e-23, -2.206883132500457e-24,  8.356913378394339e-26, -2.865164084253477e-27,  8.994616417618031e-29, -2.607167858164073e-30,  7.711308215694571e-18,
 -2.113030269747172e-18,  3.047174316466844e-19, -3.019170471438952e-20,  2.298833443812479e-21, -1.430532100464959e-22,  7.563400151324778e-24, -3.489234686864137e-25,
  1.431988590594545e-26, -5.305331030538196e-28,  1.794860975745309e-29, -5.591820881966612e-31,  6.519848868519711e-19, -1.971963216668791e-19,  3.139426343828590e-20,
 -3.421981699080766e-21,  2.855285011752589e-22, -1.939831639455949e-23,  1.115788771920862e-24, -5.581779396786608e-26,  2.476491906016712e-27, -9.890787711018613e-29,
  3.597625881442215e-30, -1.201915891105829e-31,  5.994929564504740e-20, -1.986310761021025e-20,  3.470021640855193e-21, -4.138971380677782e-22,  3.766359397650841e-23,
 -2.781108329003760e-24,  1.733031029329376e-25, -9.363461303208854e-27,  4.473928561482656e-28, -1.919091761453003e-29,  7.478030075795875e-31, -2.669663710613809e-32,
  6.326606306802761e-21, -2.274974813311118e-21,  4.326100016805771e-22, -5.605375562171932e-23,  5.524956620732344e-24, -4.405710403340944e-25,  2.956129278281982e-26,
 -1.714972356635634e-27,  8.775266842123538e-29, -4.020927725099403e-30,  1.669721730562436e-31, -6.337347325395540e-33,  8.119571734377348e-22, -3.132684550602444e-22,
  6.416414501036417e-23, -8.942494772106804e-24,  9.458482119965019e-25, -8.073094909743657e-26,  5.783318693713371e-27, -3.573338299006620e-28,  1.942764516366715e-29,
 -9.437492660115086e-31,  4.145911313269980e-32, -1.661101083629072e-33,  1.332876100470352e-22, -5.442731719076877e-23,  1.184766906063229e-23, -1.753419639660289e-24,
  1.965879828297011e-25, -1.775010471651598e-26,  1.342354758885931e-27, -8.738092747039128e-29,  4.995386536527102e-30, -2.546838164531181e-31,  1.172157239915703e-32,
 -4.911289679388034e-34,  2.826432839625789e-23, -1.202392302302379e-23,  2.736654517407062e-24, -4.233078894570086e-25,  4.954225603944394e-26, -4.662681576075525e-27,
  3.669997619844431e-28, -2.482756531675365e-29,  1.472922287169346e-30, -7.782209261092817e-32,  3.706811816383400e-33, -1.605211522215562e-34,  6.431270214971064e-24,
 -2.800679947217457e-24,  6.540557890734563e-25, -1.037917232424436e-25,  1.245370903561809e-26, -1.200648056277512e-27,  9.672245494162044e-29, -6.691195836216306e-30,
  4.055957385746798e-31, -2.187805622315481e-32,  1.063066954103380e-33, -4.692445917625884e-35,  6.728759713101670e-02, -1.871558923122399e-04,  5.391977860301489e-07,
 -1.601137052577431e-09,  4.863368546178324e-12, -1.504230508314668e-14,  4.691858434111472e-17, -1.481432919452466e-19,  4.642124490054955e-22, -1.489659389199674e-24,
  4.560721315525063e-27, -1.536696226145777e-29,  5.974996799115966e-02, -1.967857179023121e-04,  7.888995893294028e-07, -3.353638784758087e-09,  1.423770360131284e-11,
 -5.942854428679276e-14,  2.433083363006457e-16, -9.798356058964007e-19,  3.884159031344506e-21, -1.522302664907192e-23,  5.883771274846992e-26, -2.260906972447636e-28,
  4.711036447461330e-02, -2.036015713682141e-04,  1.149766419431741e-06, -6.349627881010070e-09,  3.336943727776255e-11, -1.685073112866214e-13,  8.247504297032239e-16,
 -3.934808764350351e-18,  1.836784771618629e-20, -8.413017068489521e-23,  3.788853582014263e-25, -1.680783466702338e-27,  3.297761547688267e-02, -1.937386175847205e-04,
  1.427873298954435e-06, -9.572599295066025e-09,  5.981062250370393e-11, -3.553786749728848e-13,  2.029568006316866e-15, -1.121413858739254e-17,  6.023975695701077e-20,
 -3.157104446903701e-22,  1.619110479723126e-24, -8.142647206370465e-27,  2.049133258084284e-02, -1.632245394457440e-04,  1.485220637053296e-06, -1.178232319989970e-08,
  8.611257321085531e-11, -5.927568942351379e-13,  3.888927956324839e-15, -2.451328277874900e-17,  1.493417663825765e-19, -8.832644432290316e-22,  5.089512813585273e-24,
 -2.864894448234017e-26,  1.129985316289771e-02, -1.199072110681623e-04,  1.306026194720963e-06, -1.211165215082207e-08,  1.023701390373929e-10, -8.069023436006228e-13,
  6.014024561524286e-15, -4.279181293266188e-17,  2.927150823748524e-19, -1.935016956505957e-21,  1.241254424421197e-23, -7.751002585485165e-26,  5.528586945526867e-03,
 -7.648731271033224e-05,  9.807474781392266e-07, -1.054390984454809e-08,  1.021260523711325e-10, -9.136821419961031e-13,  7.672890944983538e-15, -6.115148379651165e-17,
  4.662166891276901e-19, -3.420423274071441e-21,  2.425997381565955e-23, -1.669517266562578e-25,  2.399224300372383e-03, -4.237928100678282e-05,  6.336482189724735e-07,
 -7.843358378797506e-09,  8.642381323292841e-11, -8.717190051685263e-13,  8.196629096581489e-15, -7.273726170551357e-17,  6.145790954655068e-19, -4.976985338974605e-21,
  3.882812247617353e-23, -2.929950972545496e-25,  9.232449258280392e-04, -2.043281849719341e-05,  3.540796083247349e-07, -5.016533352152580e-09,  6.252008084145010e-11,
 -7.072320664331044e-13,  7.409371214219396e-15, -7.287129101392974e-17,  6.793491579585775e-19, -6.046909170957026e-21,  5.167830586931157e-23, -4.259119911649151e-25,
  3.149445891001143e-04, -8.591080837461675e-06,  1.717719451125605e-07, -2.771545380408147e-09,  3.888861345101389e-11, -4.913013934232625e-13,  5.712563095272985e-15,
 -6.203768193929969e-17,  6.358882373363281e-19, -6.200256130153820e-21,  5.785898583589675e-23, -5.191803649275431e-25,  9.521944634726581e-05, -3.156542951709901e-06,
  7.255101213218071e-08, -1.327529890770900e-09,  2.089410151108751e-11, -2.938151225787011e-13,  3.779742416476388e-15, -4.519133290991376e-17,  5.078676699616610e-19,
 -5.410044316460264e-21,  5.498257215876256e-23, -5.358235600941143e-25,  2.551136430215602e-05, -1.015413602812564e-06,  2.674124159375251e-08, -5.529452017832708e-10,
  9.732890911140864e-12, -1.519297735956277e-13,  2.156989941425140e-15, -2.832611781103554e-17,  3.482425469211556e-19, -4.044124062897032e-21,  4.467016905269308e-23,
 -4.718438803837268e-25,  6.057072938269595e-06, -2.864858173608585e-07,  8.618830531568569e-09, -2.008059405203072e-10,  3.943332955668095e-12, -6.818243259524975e-14,
  1.066176172587431e-15, -1.534984688597260e-17,  2.060778360709924e-19, -2.604554589611306e-21,  3.121694586161943e-23, -3.568389608508155e-25,  1.274706356459027e-06,
 -7.101210183454208e-08,  2.433786120505211e-09, -6.373579988115136e-11,  1.393622603441039e-12, -2.664482119611173e-14,  4.581843952547708e-16, -7.221376315438456e-18,
  1.057265958819368e-19, -1.452373293743665e-21,  1.886484313099803e-23, -2.330810654270586e-25,  2.379058354112092e-07, -1.549187279117405e-08,  6.033233134869990e-10,
 -1.772351769249662e-11,  4.308263451992060e-13, -9.095832107463862e-15,  1.717980973865763e-16, -2.960895240193688e-18,  4.722536412474441e-20, -7.044247141664927e-22,
  9.906446464034463e-24, -1.321739374719126e-25,  3.941496946804147e-08, -2.980507168727254e-09,  1.315880946762023e-10, -4.329044195298399e-12,  1.168403789540634e-13,
 -2.721191317047862e-15,  5.640219227632151e-17, -1.062127699039291e-18,  1.844141009462385e-20, -2.984790501034640e-22,  4.541647544977965e-24, -6.539295508966514e-26,
  5.805565249880217e-09, -5.069238603831261e-10,  2.531777493868322e-11, -9.314925404589563e-13,  2.788738397795915e-14, -7.159327800712904e-16,  1.627416235389129e-17,
 -3.346716740838158e-19,  6.322478703414033e-21, -1.109859119302069e-22,  1.826387909888977e-24, -2.836699182177373e-26,  7.620150445225155e-10, -7.645241393077155e-11,
  4.311166187905374e-12, -1.771880027396273e-13,  5.879907583993486e-15, -1.663053284116293e-16,  4.144277616173550e-18, -9.303961016735935e-20,  1.911903462370126e-21,
 -3.639126063559321e-23,  6.475057846029676e-25, -1.084582996875663e-26,  8.943095475496882e-11, -1.026519873890542e-11,  6.524331313087381e-13, -2.992627093498539e-14,
  1.100168579147021e-15, -3.427052756666995e-17,  9.360242295648696e-19, -2.293732159368781e-20,  5.126552935247850e-22, -1.057964211453581e-23,  2.035194007739732e-25,
 -3.676105949376128e-27,  9.429846168925233e-12, -1.233570508758457e-12,  8.822826173818382e-14, -4.512894265652733e-15,  1.837199123419497e-16, -6.301729963050593e-18,
  1.886331182043359e-19, -5.045540443597081e-21,  1.226558235204798e-22, -2.744529388561766e-24,  5.708365073370574e-26, -1.111916791366470e-27,  8.993415382215907e-13,
 -1.336102361074084e-13,  1.073772723521466e-14, -6.120420333196210e-16,  2.758270843346266e-17, -1.041682666720035e-18,  3.417360231293797e-20, -9.978124060352893e-22,
  2.638614412465814e-23, -6.402417237886916e-25,  1.439959366419086e-26, -3.025065324465548e-28,  7.829843757963383e-14, -1.316692869341193e-14,  1.187275362349635e-15,
 -7.535918739024460e-17,  3.758463587478983e-18, -1.562650972679383e-19,  5.618574103981985e-21, -1.790992329821306e-22,  5.152557466612961e-24, -1.355936920779311e-25,
  3.298121748514206e-27, -7.473502779155752e-29,  6.301454091208377e-15, -1.195531814923587e-15,  1.207684814444451e-16, -8.529190037990473e-18,  4.705701079582293e-19,
 -2.153524084077107e-20,  8.485923156985297e-22, -2.953137962652362e-23,  9.243532418594756e-25, -2.638343986973502e-26,  6.940743562389435e-28, -1.696495048091125e-29,
  4.767969783346576e-16, -1.017044882917852e-16,  1.148921120711416e-17, -9.019129167409686e-19,  5.501069177201733e-20, -2.769940846975344e-21,  1.195883776251317e-22,
 -4.542646263424343e-24,  1.546765929604299e-25, -4.787825585109681e-27,  1.362082495097027e-28, -3.590643787515285e-30,  3.469195653842399e-17, -8.287738503712231e-18,
  1.044688494200480e-18, -9.102130590446577e-20,  6.130989384451334e-21, -3.393889984188812e-22,  1.604341826942706e-23, -6.648193200972529e-25,  2.461246597398075e-26,
 -8.257998371325008e-28,  2.539330702585885e-29, -7.215925470506700e-31,  2.500509554835595e-18, -6.659402984441860e-19,  9.339371277757213e-20, -9.011745930486996e-21,
  6.691747391096242e-22, -4.066347207807102e-23,  2.101905320621688e-24, -9.490394155168836e-26,  3.815752296244679e-27, -1.386222940595909e-28,  4.602503880527231e-30,
 -1.408336821760693e-31,  1.855334930980252e-19, -5.477119733009038e-20,  8.511795201213340e-21, -9.066317234803190e-22,  7.400887221379081e-23, -4.924412983413982e-24,
  2.776958071324536e-25, -1.363212431062391e-26,  5.940273961863947e-28, -2.331986477547767e-29,  8.343695356669081e-31, -2.743938432064578e-32,  1.487383151035198e-20,
 -4.832151074015019e-21,  8.274973562625796e-22, -9.682752125959428e-23,  8.651431568505742e-24, -6.278058569052787e-25,  3.847825947610051e-26, -2.046367669485927e-27,
  9.631363711035161e-29, -4.072280981182606e-30,  1.565108894326948e-31, -5.514348872979099e-33,  1.365660399574718e-21, -4.837940073901951e-22,  9.059047681970337e-23,
 -1.156397576365426e-23,  1.123645250316175e-24, -8.838950968756661e-26,  5.854211448087869e-27, -3.354462705754579e-28,  1.696257781377569e-29, -7.685161007186197e-31,
  3.157047835216964e-32, -1.185949745369677e-33,  1.532276842877742e-22, -5.851170704773076e-23,  1.185517613579208e-23, -1.634878758065738e-24,  1.711765875354302e-25,
 -1.446952674347359e-26,  1.027008834614161e-27, -6.289802740102595e-29,  3.390956658567147e-30, -1.634035212983311e-31,  7.123305441778118e-33, -2.833133195238165e-34,
  2.231057445571272e-23, -9.054448466091972e-24,  1.957999362020273e-24, -2.879100327449460e-25,  3.207917582734628e-26, -2.879232347211291e-27,  2.165043732389384e-28,
 -1.401682987792530e-29,  7.971521139273297e-31, -4.044009558413053e-32,  1.852378966952457e-33, -7.726217997228279e-35,  4.306785042196054e-24, -1.826821452910072e-24,
  4.144705722104890e-25, -6.391049246559013e-26,  7.457240972676662e-27, -6.998030711528727e-28,  5.492821693688350e-29, -3.705990051895060e-30,  2.193002655347315e-31,
 -1.155840777498191e-32,  5.492571452925032e-34, -2.373188339225088e-35,  9.258458075382972e-25, -4.028022000625808e-25,  9.396906611018783e-26, -1.489619102622366e-26,
  1.785516672155462e-27, -1.719676169100276e-28,  1.384005537179085e-29, -9.565498749547280e-31,  5.793007541454570e-32, -3.122045934606874e-33,  1.515735840258057e-34,
 -6.685094053215947e-36,  6.654748087780929e-02, -1.829178642399686e-04,  5.204412912602338e-07, -1.525670123564726e-09,  4.573455385179797e-12, -1.396440493818623e-14,
  4.297072083721299e-17, -1.341126171414513e-19,  4.137106178801735e-22, -1.320195204288162e-24,  3.925527581290203e-27, -1.357632211932850e-29,  5.897519798715674e-02,
 -1.906317115093515e-04,  7.499845234601836e-07, -3.135035901828853e-09,  1.310537494510674e-11, -5.390481446799976e-14,  2.175337847339509e-16, -8.638755131539697e-19,
  3.376201340564397e-21, -1.305698927160460e-23,  4.973504052200592e-26, -1.888746997723681e-28,  4.631388436488827e-02, -1.946993949891797e-04,  1.076666520206761e-06,
 -5.841638879092521e-09,  3.018863876138243e-11, -1.499716759822426e-13,  7.223693131591438e-16, -3.392710292157703e-18,  1.559504009336921e-20, -7.035558793573802e-23,
  3.121456555032467e-25, -1.364470088541959e-27,  3.222480173791251e-02, -1.827593709655756e-04,  1.318517667590716e-06, -8.669946336202551e-09,  5.316579442900027e-11,
 -3.102292380752960e-13,  1.740936129981881e-15, -9.456484249576606e-18,  4.995851558406923e-20, -2.575775527884981e-22,  1.299959588439309e-24, -6.434819224109653e-27,
  1.986133441616828e-02, -1.518857724068839e-04,  1.351724157918613e-06, -1.049451598336974e-08,  7.513785305740572e-11, -5.071471013099672e-13,  3.264947397811129e-15,
 -2.020615390420312e-17,  1.209241009545258e-19, -7.028137613729473e-22,  3.981119949397689e-24, -2.203636243687711e-26,  1.084023800708268e-02, -1.100136936244973e-04,
  1.170005680959049e-06, -1.059538114030178e-08,  8.758361531423624e-11, -6.759464440760622e-13,  4.937164268345371e-15, -3.444996710929771e-17,  2.312267006211767e-19,
 -1.500540616126998e-21,  9.453187478071730e-24, -5.799426319304306e-26,  5.237565781074608e-03, -6.912098883558372e-05,  8.634525203983472e-07, -9.046629925538501e-09,
  8.556346492563675e-11, -7.485012384399048e-13,  6.152259608707813e-15, -4.802890268026595e-17,  3.589126644177060e-19, -2.582411368738487e-21,  1.797174313252830e-23,
 -1.214024796696156e-25,  2.239280975899100e-03, -3.766432803355874e-05,  5.472820922977642e-07, -6.590018499943667e-09,  7.080247583763730e-11, -6.973727388530487e-13,
  6.410381244807585e-15, -5.566123367450600e-17,  4.605132952667175e-19, -3.654016966475735e-21,  2.794642210586243e-23, -2.068345929174084e-25,  8.468203345326497e-04,
 -1.782498526328879e-05,  2.994458653911314e-07, -4.120359351008864e-09,  5.000030780563831e-11, -5.516231226589805e-13,  5.643242980168064e-15, -5.425015333760329e-17,
  4.947558189169894e-19, -4.311084727968382e-21,  3.608929747154151e-23, -2.914997549595904e-25,  2.831319856618100e-04, -7.340062906099786e-06,  1.419450587830568e-07,
 -2.221038329097564e-09,  3.030396232798089e-11, -3.729364843417036e-13,  4.229773421276417e-15, -4.485508452497323e-17,  4.493626352934508e-19, -4.285653332573007e-21,
  3.914323064936332e-23, -3.439827151413012e-25,  8.366067087624783e-05, -2.634589680116073e-06,  5.844743411297508e-08, -1.035705247987445e-09,  1.583122247272375e-11,
 -2.166149951839681e-13,  2.715409281759336e-15, -3.167347564298727e-17,  3.476008227086414e-19, -3.618927546120341e-21,  3.597200995762853e-23, -3.430823042541006e-25,
  2.183900037382320e-05, -8.255916050861548e-07,  2.094840836358086e-08, -4.189636147210839e-10,  7.153708361789479e-12, -1.085434756335571e-13,  1.500226400739795e-15,
 -1.920381040062099e-17,  2.303701692675925e-19, -2.612754683364977e-21,  2.820699112313586e-23, -2.914071241733458e-25,  5.035157862326318e-06, -2.261965509992570e-07,
  6.546853063470231e-09, -1.473652632528068e-10,  2.804265762083875e-12, -4.708530103677892e-14,  7.161627675161974e-16, -1.004228073635889e-17,  1.314575344419209e-19,
 -1.621526620492492e-21,  1.898344170175725e-23, -2.121137738495015e-25,  1.025240865602072e-06, -5.425899968604837e-08,  1.786921541872364e-09, -4.516597777976417e-11,
  9.561006394792371e-13, -1.773603264218057e-14,  2.964237542729375e-16, -4.547006234977787e-18,  6.486768518372540e-20, -8.691494146230857e-22,  1.102096766698956e-23,
 -1.330336148733685e-25,  1.843934157023520e-07, -1.141132898998972e-08,  4.266526286901100e-10, -1.208699532735738e-11,  2.842181711310132e-13, -5.817726905911385e-15,
  1.067233807791104e-16, -1.789050345272436e-18,  2.778825666420533e-20, -4.040743008816321e-22,  5.544758427906462e-24, -7.224441648423792e-26,  2.930930242484921e-08,
 -2.107520055788516e-09,  8.927350271508392e-11, -2.830467878915054e-12,  7.385082789338198e-14, -1.666531119442144e-15,  3.352974497150078e-17, -6.138165115848395e-19,
  1.037363280129576e-20, -1.636055181597785e-22,  2.428060325357771e-24, -3.412803029120970e-26,  4.121591003685855e-09, -3.424725752312267e-10,  1.640547038256553e-11,
 -5.814396631084425e-13,  1.681963866617976e-14, -4.181827429236470e-16,  9.223116361953796e-18, -1.843086159444722e-19,  3.387852962909327e-21, -5.792997866077347e-23,
  9.295149981410600e-25, -1.408937284724414e-26,  5.136817780831377e-10, -4.909038869113912e-11,  2.654973858764472e-12, -1.050894671492481e-13,  3.368590136541126e-15,
 -9.224302428470762e-17,  2.229621885762232e-18, -4.862696930366115e-20,  9.720229191738659e-22, -1.801809579022484e-23,  3.125349169905330e-25, -5.108115740706721e-27,
  5.689729196999370e-11, -6.228072826901287e-12,  3.797440923760362e-13, -1.677530608666897e-14,  5.956510346257438e-16, -1.796182980033410e-17,  4.757917368577746e-19,
 -1.132525943861337e-20,  2.461998096717616e-22, -4.947645732291776e-24,  9.277905828379157e-26, -1.635155303846135e-27,  5.623912773087104e-12, -7.025817530367057e-13,
  4.823397941751388e-14, -2.376760276439238e-15,  9.346933969754168e-17, -3.103938116318750e-18,  9.011645902728265e-20, -2.341530686253184e-21,  5.536933422250513e-23,
 -1.206565434512228e-24,  2.446547256571746e-26, -4.650405604857585e-28,  4.990077733662245e-13, -7.091880771440695e-14,  5.475653610521715e-15, -3.008464214724797e-16,
  1.310305074471936e-17, -4.792539300804208e-19,  1.525421232760701e-20, -4.327932315765471e-22,  1.113574304956221e-23, -2.632155069937993e-25,  5.772989394823681e-27,
 -1.183832224307479e-28,  4.008097885107712e-14, -6.460867054756186e-15,  5.604135632142333e-16, -3.431932623774514e-17,  1.655439408687414e-18, -6.670269649312584e-20,
  2.328267659697032e-21, -7.215609489039649e-23,  2.020895013202485e-24, -5.183328574648849e-26,  1.230099257271324e-27, -2.722223008077428e-29,  2.948551558299397e-15,
 -5.375198372657131e-16,  5.231950584134218e-17, -3.569756058196401e-18,  1.906970534890198e-19, -8.466067759715808e-21,  3.241562015676620e-22, -1.097702810189019e-23,
  3.347625603898330e-25, -9.320151747135230e-27,  2.394074601599833e-28, -5.719278604296617e-30,  2.018901155941835e-16, -4.149680588709032e-17,  4.526516539893176e-18,
 -3.438956422197455e-19,  2.034087617250765e-20, -9.949762058783925e-22,  4.179423442329397e-23, -1.546717521203438e-24,  5.137225720267532e-26, -1.552816489781068e-27,
  4.318129382509575e-29, -1.113732882473853e-30,  1.315198621698074e-17, -3.037535262087540e-18,  3.706908406433225e-19, -3.132844182945532e-20,  2.050527033001309e-21,
 -1.104733004207851e-22,  5.089695226026117e-24, -2.058169102658089e-25,  7.444045335818604e-27, -2.442609128627740e-28,  7.352486405204619e-30, -2.047062335330533e-31,
  8.395885006616753e-19, -2.169899822112575e-19,  2.955546188765982e-20, -2.774072867586248e-21,  2.006759835493524e-22, -1.189624717678301e-23,  6.006402486329199e-25,
 -2.652018965781417e-26,  1.043794070326397e-27, -3.715549050117370e-29,  1.209815758247683e-30, -3.633532948091001e-32,  5.461544781271226e-20, -1.571325054030868e-20,
  2.380509549290970e-21, -2.474763951151587e-22,  1.974166856332097e-23, -1.285179228257072e-24,  7.098389140776820e-26, -3.416400676033199e-27,  1.460915488977743e-28,
 -5.632815274723800e-30,  1.980974140338057e-31, -6.408298562511181e-33,  3.807520312974832e-21, -1.211197846144044e-21,  2.030600996556115e-22, -2.328170368370346e-23,
  2.040272957082265e-24, -1.453533086962251e-25,  8.753946561815875e-27, -4.578501571473315e-28,  2.120874277031407e-29, -8.832111670689784e-31,  3.345504280833362e-32,
 -1.162474567149342e-33,  3.028154127483963e-22, -1.055590253257929e-22,  1.944132412921242e-23, -2.442335450074185e-24,  2.337193146092358e-25, -1.811957820022848e-26,
  1.183583491607496e-27, -6.692989160435577e-29,  3.342113122395809e-30, -1.496107017581873e-31,  6.075800704384952e-33, -2.257504903299661e-34,  2.952252815708335e-23,
 -1.114782554775074e-23,  2.232312835025886e-24, -3.043508542446738e-25,  3.151971933340393e-26, -2.636682669823827e-27,  1.852910420015972e-28, -1.124074630720692e-29,
  6.005486800193374e-31, -2.869023136954122e-32,  1.240420696118556e-33, -4.894803039197415e-35,  3.785840066653934e-24, -1.526113221637027e-24,  3.276525116749761e-25,
 -4.784113309886094e-26,  5.294549955322492e-27, -4.721407863634197e-28,  3.528395933137621e-29, -2.270902671453278e-30,  1.284234567139863e-31, -6.480073289355603e-33,
  2.953018973844965e-34, -1.225675764268923e-35,  6.608156308508312e-25, -2.794076016966968e-25,  6.317310618044842e-26, -9.707993321671632e-27,  1.129028338233621e-27,
 -1.056159041407463e-28,  8.264829969847346e-30, -5.560121196508301e-31,  3.281066911034752e-32, -1.724731939144512e-33,  8.175156709587812e-35, -3.523698571180578e-36,
  1.335990374092765e-25, -5.806442493869406e-26,  1.353036323285208e-26, -2.142433723660540e-27,  2.565165516100152e-28, -2.467925849821795e-29,  1.984141214032990e-30,
 -1.369957149028679e-31,  8.288634110273259e-33, -4.462847382065572e-34,  2.164730880639365e-35, -9.539153049380167e-37,  6.582402225925338e-02, -1.788263429640320e-04,
  5.025632630705466e-07, -1.454674358761737e-09,  4.304183640926055e-12, -1.297671635979192e-14,  3.939397444213146e-17, -1.216051466814592e-19,  3.688700008146727e-22,
 -1.174688645721129e-24,  3.359742088931766e-27, -1.221155230002960e-29,  5.822443755747767e-02, -1.847788325153016e-04,  7.135875283638627e-07, -2.933699018850087e-09,
  1.207758879452541e-11, -4.896247845500974e-14,  1.947897902377169e-16, -7.629896233400079e-19,  2.940042858378335e-21, -1.122435964329348e-23,  4.211900792523601e-26,
 -1.582976238526901e-28,  4.555188078411249e-02, -1.863584721773477e-04,  1.009368947087957e-06, -5.381705470682330e-09,  2.735516102361036e-11, -1.337206284317641e-13,
  6.339957624875175e-16, -2.931896705557196e-18,  1.327323870824581e-20, -5.899182596964776e-23,  2.578868428902772e-25, -1.111027031302621e-27,  3.151422143282537e-02,
 -1.726133831862558e-04,  1.219384591847827e-06, -7.866747004656885e-09,  4.735848556245565e-11, -2.714517221717980e-13,  1.497210443771940e-15, -7.996669167494967e-18,
  4.155729064191317e-20, -2.108259217151084e-22,  1.047308153042293e-24, -5.103536458650189e-27,  1.927464920018141e-02, -1.415560225417459e-04,  1.232681766765520e-06,
 -9.369381163971722e-09,  6.573483532862606e-11, -4.351626946643314e-13,  2.749754070222114e-15, -1.671246932260003e-17,  9.827007715131467e-20, -5.613845566522650e-22,
  3.126811714909612e-24, -1.702249495978856e-26,  1.041813040279930e-02, -1.011393909084265e-04,  1.050843003028633e-06, -9.296070199681565e-09,  7.517559180537829e-11,
 -5.682409980447017e-13,  4.068526599303595e-15, -2.784675780705911e-17,  1.834406026411647e-19, -1.168895474632920e-21,  7.233687518485817e-24, -4.360821718136624e-26,
  4.974240941555993e-03, -6.262542142518631e-05,  7.626378348264190e-07, -7.789787077458134e-09,  7.196741301520241e-11, -6.157680787185742e-13,  4.955199001982620e-15,
 -3.790223501943856e-17,  2.776942328636032e-19, -1.959985180434504e-21,  1.338668980167477e-23, -8.878579819967388e-26,  2.096905191794041e-03, -3.358414212184018e-05,
  4.745643404309908e-07, -5.560900807633600e-09,  5.827538990372009e-11, -5.606747998756256e-13,  5.039842037330181e-15, -4.283039514570767e-17,  3.470746331740558e-19,
 -2.698970656059240e-21,  2.024100856819414e-23, -1.469637053015321e-25,  7.800165319273115e-04, -1.561438860232580e-05,  2.544600110339262e-07, -3.401741354947419e-09,
  4.020785615558823e-11, -4.327583360413894e-13,  4.324407685591090e-15, -4.064582709599710e-17,  3.627211015661424e-19, -3.094791167349015e-21,  2.538300123657122e-23,
 -2.009781646043631e-25,  2.558849881111960e-04, -6.303402634028117e-06,  1.179724075231779e-07, -1.790728656611247e-09,  2.376647678487930e-11, -2.850007794648369e-13,
  3.153945921484751e-15, -3.266913863217778e-17,  3.199596420358704e-19, -2.985470237214322e-21,  2.669511793649151e-23, -2.297949614751093e-25,  7.398442985263865e-05,
 -2.212725626693338e-06,  4.740649985490827e-08, -8.138035615890783e-10,  1.208480442378348e-11, -1.609416719562216e-13,  1.966512611222743e-15, -2.238410865753550e-17,
  2.399513122568294e-19, -2.442157948477920e-21,  2.374742783658862e-23, -2.217070948784578e-25,  1.884251172736219e-05, -6.763219096009849e-07,  1.654183351672657e-08,
 -3.200838163567027e-10,  5.303301771779750e-12, -7.823720782520223e-14,  1.053003740545076e-15, -1.314198325906415e-17,  1.538672871402718e-19, -1.704689427547323e-21,
  1.799119710037060e-23, -1.818247386632347e-25,  4.224911129313880e-06, -1.801984433234125e-07,  5.019386147837513e-09, -1.091844760774067e-10,  2.013908425660451e-12,
 -3.284536836777471e-14,  4.860440204419116e-16, -6.639585847519243e-18,  8.476442508212118e-20, -1.020650420541813e-21,  1.167361369362580e-23, -1.275234814554579e-25,
  8.336975172410492e-07, -4.189618134929685e-08,  1.326152912609771e-09, -3.235900615314502e-11,  6.633088691757052e-13, -1.194122588266440e-14,  1.940106099722699e-16,
 -2.897058443661257e-18,  4.027915495199341e-20, -5.264965185831914e-22,  6.518442121295050e-24, -7.688501886890599e-26,  1.447544551488752e-07, -8.508992948725074e-09,
  3.054621965802408e-10, -8.346555815913420e-12,  1.898870631042354e-13, -3.769056114123429e-15,  6.716483978965890e-17, -1.095300030909015e-18,  1.657008095339689e-20,
 -2.349242473446496e-22,  3.145909640263563e-24, -4.003287278396844e-26,  2.211782713221188e-08, -1.511382624360579e-09,  6.142480491094967e-11, -1.877009139292501e-12,
  4.734820252466960e-14, -1.035386740179331e-15,  2.022318727022146e-17, -3.599438746438910e-19,  5.921739317327633e-21, -9.101404863214117e-23,  1.317570373970151e-24,
 -1.808000788181399e-26,  2.975708298383449e-09, -2.351283684720214e-10,  1.080152470982349e-11, -3.687643353722895e-13,  1.030750089870620e-14, -2.482027408382128e-16,
  5.311613012922161e-18, -1.031493438256138e-19,  1.844930870473502e-21, -3.073125607925104e-23,  4.808200728117273e-25, -7.112987679268069e-27,  3.529429585673828e-10,
 -3.210202153915965e-11,  1.664694582724704e-12, -6.345008228773274e-14,  1.964457106763683e-15, -5.207878654331637e-17,  1.220968792970391e-18, -2.586857501908524e-20,
  5.030021939693425e-22, -9.080314061103710e-24,  1.535432296387716e-25, -2.448679248276541e-27,  3.698321201940006e-11, -3.857065621414772e-12,  2.255176794177335e-13,
 -9.592030897692238e-15,  3.289045158178326e-16, -9.599930245652876e-18,  2.465972814348896e-19, -5.701064737404151e-21,  1.205361396670339e-22, -2.358635843962655e-24,
  4.311193078649346e-26, -7.413142724466970e-28,  3.435209902667845e-12, -4.094229128207903e-13,  2.696472745530170e-14, -1.279513114139576e-15,  4.859410477181709e-17,
 -1.561939482973134e-18,  4.397438897284411e-20, -1.109744959113958e-21,  2.552172305398041e-23, -5.415348970185435e-25,  1.070346106908248e-26, -1.985071820713145e-28,
  2.842907661201786e-13, -3.860726946033307e-14,  2.861785210546098e-15, -1.514807628911612e-16,  6.373441264423290e-18, -2.256874884586392e-19,  6.967306108755453e-21,
 -1.920285834301458e-22,  4.806219940797111e-24, -1.106405868662954e-25,  2.365845502074686e-27, -4.734607700707642e-29,  2.111912062500214e-14, -3.259213776439196e-15,
  2.717119801113897e-16, -1.604327592232918e-17,  7.480419528624872e-19, -2.919610723375103e-20,  9.889013962753452e-22, -2.978484170350647e-23,  8.118013733087746e-25,
 -2.028686152881538e-26,  4.695802477978399e-28, -1.014575869106598e-29,  1.423462471145755e-15, -2.490070665719038e-16,  2.333035600894821e-17, -1.536603852189460e-18,
  7.942422386141080e-20, -3.418500630236585e-21,  1.271130641653581e-22, -4.186440320304302e-24,  1.243336772977707e-25, -3.374999753565338e-27,  8.461450174825408e-29,
 -1.974829844135887e-30,  8.837877257742448e-17, -1.747874531583716e-17,  1.838920872504340e-18, -1.350816702982617e-19,  7.741688209773749e-21, -3.675975489843062e-22,
  1.501290850808423e-23, -5.409539434652426e-25,  1.751557280524522e-26, -5.167173810830144e-28,  1.403818818112444e-29, -3.540751652088529e-31,  5.162386144179706e-18,
 -1.150899610581612e-18,  1.358061535080361e-19, -1.112098247688708e-20,  7.066236672574545e-22, -3.701892668989831e-23,  1.660902663264094e-24, -6.549256169226147e-26,
  2.312561494771776e-27, -7.416142357072055e-29,  2.183854143236680e-30, -5.953700288962681e-32,  2.920614657385387e-19, -7.313566382636791e-20,  9.661760784812932e-21,
 -8.810620513495060e-22,  6.202453990654540e-23, -3.583445348286011e-24,  1.765658826174608e-25, -7.617160385364794e-27,  2.932443294824617e-28, -1.022042335230322e-29,
  3.261319231332331e-31, -9.607465697129653e-33,  1.664614737107990e-20, -4.660224990629112e-21,  6.872946133036607e-22, -6.964942710277011e-23,  5.423369018687709e-24,
 -3.450656119116912e-25,  1.864899494917377e-26, -8.791917940425989e-28,  3.686225817836564e-29, -1.394803695485726e-30,  4.817879265904035e-32, -1.531980957193054e-33,
  1.006903352398075e-21, -3.131696433155193e-22,  5.133177039751958e-23, -5.759659194321422e-24,  4.944917966532353e-25, -3.454900330158528e-26,  2.042561637539820e-27,
 -1.049651104878946e-28,  4.781313007238829e-30, -1.959481488973585e-31,  7.309579216712680e-33, -2.503041647799789e-34,  6.907385951069838e-23, -2.366346114699510e-23,
  4.281434676358498e-24, -5.287278818202259e-25,  4.977733550585791e-26, -3.799626210538419e-27,  2.445547958178042e-28, -1.363609818510573e-29,  6.718488013111090e-31,
 -2.969352786800656e-32,  1.191247240668232e-33, -4.374926531470117e-35,  5.815777205373317e-24, -2.169438188772579e-24,  4.289313730492592e-25, -5.776289310759866e-26,
  5.911947473754333e-27, -4.890127133083691e-28,  3.399881053897351e-29, -2.041609033139620e-30,  1.080194590814445e-31, -5.112810379454007e-33,  2.191038262347433e-34,
 -8.573379316445436e-36,  6.519806409814670e-25, -2.608878018107698e-25,  5.557395059909387e-26, -8.052489111409130e-27,  8.846297910912307e-28, -7.833411009701376e-29,
  5.814936041823801e-30, -3.718691223587890e-31,  2.090204500489721e-32, -1.048573540562279e-33,  4.751979334267505e-35, -1.961946322733497e-36,  1.021625872084348e-25,
 -4.304570238710507e-26,  9.695671482746760e-27, -1.484418829010939e-27,  1.720167548624312e-28, -1.603610486915941e-29,  1.250755271898939e-30, -8.387931044128553e-32,
  4.934901056359623e-33, -2.586636047390579e-34,  1.222685393992483e-35, -5.256261875429001e-37,  1.932728863067338e-26, -8.390633377675301e-27,  1.952813575924293e-27,
 -3.088358479051056e-28,  3.693329187309921e-29, -3.549224471363146e-30,  2.850295036959906e-31, -1.965880454972937e-32,  1.188180698496248e-33, -6.391118227772455e-35,
  3.097057236046326e-36, -1.363487980846901e-37,  6.511664897156981e-02, -1.748745098872527e-04,  4.855119710557861e-07, -1.387833459557120e-09,  4.053834798046291e-12,
 -1.207082464173899e-14,  3.614810560719230e-17, -1.104530221870252e-19,  3.288735693034635e-22, -1.050739993709942e-24,  2.844419720011978e-27, -1.128862735372581e-29,
  5.749652120845387e-02, -1.792077375451529e-04,  6.795110768215680e-07, -2.748044665867856e-09,  1.114341171502858e-11, -4.453361887825821e-14,  1.746847153987519e-16,
 -6.750614767255944e-19,  2.564684275067586e-21, -9.671146494354674e-24,  3.572448421181440e-26, -1.331799294082274e-28,  4.482219803194755e-02, -1.785345998787328e-04,
  9.473289250421004e-07, -4.964618536982164e-09,  2.482649787128773e-11, -1.194437448152823e-13,  5.575434611695946e-16, -2.539233245804606e-18,  1.132401136862773e-20,
 -4.959087255781919e-23,  2.136432652959046e-25, -9.073267057018866e-28,  3.084269783797687e-02, -1.632234290891523e-04,  1.129357006794631e-06, -7.150564660583347e-09,
  4.227139306195129e-11, -2.380620155530049e-13,  1.290835581206126e-15, -6.780605779552755e-18,  3.467049587633782e-20, -1.730995681998731e-22,  8.465890822675109e-25,
 -4.061823076520951e-27,  1.872746034383715e-02, -1.321270577444012e-04,  1.126283724731903e-06, -8.383817091157372e-09,  5.765537879036729e-11, -3.744464878521004e-13,
  2.322955687197149e-15, -1.386843710045504e-17,  8.014209024261001e-20, -4.500925232576634e-22,  2.465567674595405e-24, -1.320393570589717e-26,  1.002970759642145e-02,
 -9.315924101992302e-05,  9.461484671733080e-07, -8.179127578077999e-09,  6.472733190614323e-11, -4.793265237289765e-13,  3.365050133144079e-15, -2.259764502921881e-17,
  1.461373043799242e-19, -9.145540110690795e-22,  5.560904067749846e-24, -3.294916872784624e-26,  4.735375889663640e-03, -5.687954909781893e-05,  6.756828411994871e-07,
 -6.730713346033223e-09,  6.076026269021799e-11, -5.086359940430591e-13,  4.008430813048443e-15, -3.004880841084486e-17,  2.159007884162705e-19, -1.495174948481246e-21,
  1.002462656285555e-23, -6.529282522829857e-26,  1.969760329871215e-03, -3.003951119572368e-05,  4.130781489423658e-07, -4.712016846503134e-09,  4.818044119618701e-11,
 -4.529390715166186e-13,  3.982518470359324e-15, -3.313417686805627e-17,  2.630509598737867e-19, -2.005245454614248e-21,  1.474963781277747e-23, -1.050840408974081e-25,
  7.213864218372861e-04, -1.373167854813127e-05,  2.172307115429784e-07, -2.822382566532000e-09,  3.250472842904297e-11, -3.414142946531961e-13,  3.333377515189614e-15,
 -3.064147106443209e-17,  2.676367846746347e-19, -2.236524629170815e-21,  1.797656969938105e-23, -1.395583559801321e-25,  2.324314277749978e-04, -5.439521812371222e-06,
  9.858966485031354e-08, -1.452243805355035e-09,  1.875489793787577e-11, -2.192183359681606e-13,  2.367756810045184e-15, -2.396224597232444e-17,  2.294926890442326e-19,
 -2.095508740979395e-21,  1.834799349930552e-23, -1.547467951480651e-25,  6.583452007875042e-05, -1.869478101043493e-06,  3.870253656182235e-08, -6.438314918746546e-10,
  9.291328772374813e-12, -1.204738904568461e-13,  1.435243094004347e-15, -1.594653730709250e-17,  1.670154412061741e-19, -1.662116721862410e-21,  1.581466109568984e-23,
 -1.445589483423493e-25,  1.637945726159593e-05, -5.580193489482687e-07,  1.316243677679073e-08, -2.464916064155522e-10,  3.964124251796144e-12, -5.687654101641249e-14,
  7.456414072532184e-16, -9.075511144214149e-18,  1.037304910078814e-19, -1.122870462398796e-21,  1.158760357554358e-23, -1.145839340956317e-25,  3.576841862345163e-06,
 -1.447825259319557e-07,  3.882722427571128e-09, -8.164149841292655e-11,  1.460043964932417e-12, -2.313568576544665e-14,  3.331704074644670e-16, -4.434838887402965e-18,
  5.522878559580758e-20, -6.492976757864372e-22,  7.256626934046953e-24, -7.751595523503658e-26,  6.851046497076298e-07, -3.267640434936858e-08,  9.943912755583663e-10,
 -2.342883798575565e-11,  4.651608493841497e-13, -8.128598966032407e-15,  1.284124051972784e-16, -1.867014270615622e-18,  2.530321293883218e-20, -3.227155228369046e-22,
  3.901814190675052e-24, -4.497713052769397e-26,  1.150375621954169e-07, -6.419488432323466e-09,  2.213027137580934e-10, -5.833270288490736e-12,  1.284207705688247e-13,
 -2.472227883463743e-15,  4.280347015873188e-17, -6.791609641096181e-19,  1.000893025080579e-20, -1.383760153823502e-22,  1.808585159869126e-24, -2.248107791972822e-26,
  1.692874440851666e-08, -1.098619941983621e-09,  4.283967676066319e-11, -1.261805646358202e-12,  3.077670846421214e-14, -6.522573525862825e-16,  1.236952962933926e-17,
 -2.140773273218665e-19,  3.428943462571501e-21, -5.136432568304469e-23,  7.254004011393660e-25, -9.718948371200428e-27,  2.183505084781211e-09, -1.639499164138867e-10,
  7.222074874729475e-12, -2.375042732266180e-13,  6.414869323482012e-15, -1.496142062057373e-16,  3.106936914108138e-18, -5.863767026452286e-20,  1.020601941120527e-21,
 -1.656180799749206e-23,  2.526893667014669e-25, -3.648512741882734e-27,  2.470094483281986e-10, -2.136565422224027e-11,  1.062065057166476e-12, -3.897626661434528e-14,
  1.165501389899436e-15, -2.991288351012220e-17,  6.802194237718231e-19, -1.400048775691844e-20,  2.648158883329320e-22, -4.655636295116623e-24,  7.674562975281672e-26,
 -1.194255277176278e-27,  2.454363646762304e-11, -2.436623134716745e-12,  1.365624172471729e-13, -5.591316498567972e-15,  1.851176314830317e-16, -5.229263319010595e-18,
  1.302506732592337e-19, -2.924526276818902e-21,  6.013308591012606e-23, -1.145688586242676e-24,  2.041107679238410e-26, -3.424081162583468e-28,  2.147653425799058e-12,
 -2.439521519286671e-13,  1.540515143604390e-14, -7.036842980264557e-16,  2.580231458064281e-17, -8.025758462228217e-19,  2.190738812308733e-20, -5.368774168771888e-22,
  1.200656721955277e-23, -2.480354209382748e-25,  4.778071615044489e-27, -8.645038290784557e-29,  1.661974662979307e-13, -2.154245859971010e-14,  1.532008932963219e-15,
 -7.808721054195097e-17,  3.172614563750745e-18, -1.087303638013798e-19,  3.254764547169261e-21, -8.712070284018030e-23,  2.120593606484434e-24, -4.753269936693382e-26,
  9.907345443666020e-28, -1.934535206161018e-29,  1.144816860453263e-14, -1.689347690167356e-15,  1.352481738851814e-16, -7.694715556168549e-18,  3.466221276032967e-19,
 -1.309871758551585e-20,  4.303502608041949e-22, -1.259241923641293e-23,  3.338887568138881e-25, -8.127000989982976e-27,  1.834252435883397e-28, -3.868125127613067e-30,
  7.087354983308843e-16, -1.188064252139837e-16,  1.070439342411480e-17, -6.800250393918929e-19,  3.398687013731540e-20, -1.417373638610416e-21,  5.115548430142242e-23,
 -1.637803836441530e-24,  4.734815735727214e-26, -1.252576349456057e-27,  3.063785690554428e-29, -6.983270389097416e-31,  3.999023566188386e-17, -7.598720778057893e-18,
  7.702012564071033e-19, -5.465112263509321e-20,  3.032356120205636e-21, -1.396676089330200e-22,  5.542303846361951e-24, -1.943224717387224e-25,  6.130386509258223e-27,
 -1.764098342423197e-28,  4.679983621316245e-30, -1.153768924945563e-31,  2.098216927615537e-18, -4.508319902596450e-19,  5.137330835662557e-20, -4.071802023466291e-21,
  2.509193130217026e-22, -1.277141081873194e-23,  5.575738642291800e-25, -2.142355243662136e-26,  7.380227908096166e-28, -2.311614225506564e-29,  6.655213998452376e-31,
 -1.775579871485732e-32,  1.053050133001995e-19, -2.550819677835604e-20,  3.263916109420989e-21, -2.888256991169591e-22,  1.976529134653638e-23, -1.111824055345817e-24,
  5.341342024138015e-26, -2.249548601655276e-27,  8.464242878089616e-29, -2.886265346762287e-30,  9.019529185268116e-32, -2.604444477320180e-33,  5.257591407174793e-21,
 -1.429929817529222e-21,  2.050033211319403e-22, -2.022503332634401e-23,  1.535452935041252e-24, -9.537999641001359e-26,  5.038934181010491e-27, -2.324797671696926e-28,
  9.548816670159100e-30, -3.542886612759405e-31,  1.201031905952188e-32, -3.751177118156847e-34,  2.754199646134818e-22, -8.362425530358494e-23,  1.338200291522806e-23,
 -1.467544983714530e-24,  1.232899378478352e-25, -8.438548339037617e-27,  4.892436829175164e-28, -2.467921688013015e-29,  1.104474267570090e-30, -4.450694335446869e-32,
  1.633755358186445e-33, -5.509202384109728e-35,  1.623308820168135e-23, -5.457803684705602e-24,  9.688271092805399e-25, -1.174709723873413e-25,  1.086816182555598e-26,
 -8.159636043679835e-28,  5.169757962619950e-29, -2.839769478186698e-30,  1.379351503431268e-31, -6.014027493539274e-33,  2.381637363568435e-34, -8.639270478774077e-36,
  1.173171527307362e-24, -4.318521373503303e-25,  8.421519379402215e-26, -1.119076775053999e-26,  1.130863570757774e-27, -9.241343600960077e-29,  6.351423492680693e-30,
 -3.772379324473656e-31,  1.975187771530273e-32, -9.256427735703589e-34,  3.929263704996547e-35, -1.523656379833678e-36,  1.140937292088722e-25, -4.528617099686802e-26,
  9.564412534900182e-27, -1.374318741558566e-27,  1.497751333890762e-28, -1.316164851068816e-29,  9.699362366977579e-31, -6.159962740049572e-32,  3.439610729746966e-33,
 -1.714693816654574e-34,  7.724245752998111e-36, -3.170938365887609e-37,  1.592539044604029e-26, -6.684305642534046e-27,  1.499336584748228e-27, -2.286154281255496e-28,
  2.638841979730284e-29, -2.450801733839690e-30,  1.904677941763652e-31, -1.272960449363186e-32,  7.464780832972280e-34, -3.900467811911332e-35,  1.838228840819602e-36,
 -7.879995571798369e-38,  2.803695148667521e-27, -1.215711783243588e-27,  2.825655660603887e-28, -4.462847857242102e-29,  5.330200614977859e-30, -5.115859901792335e-31,
  4.103494066841550e-32, -2.826954853789852e-33,  1.706712627145743e-34, -9.170405219124902e-36,  4.439269525564332e-37, -1.952457016669169e-38,  6.442481518107690e-02,
 -1.710559455283419e-04,  4.692393208044862e-07, -1.324857328159015e-09,  3.820849343556222e-12, -1.123922730638343e-14,  3.319722072243411e-17, -1.005132963412698e-19,
  2.929767582237715e-22, -9.467344726489739e-25,  2.358898693885061e-27, -1.087313828448943e-29,  5.679035777575864e-02, -1.739005903089698e-04,  6.475756368687255e-07,
 -2.576653932341501e-09,  1.029317922842617e-11, -4.055904458392173e-14,  1.568815341574368e-16, -5.982974426832613e-19,  2.240890843479558e-21, -8.353006090424677e-24,
  3.033231317291929e-26, -1.126046912579863e-28,  4.412284888404164e-02, -1.711876943088280e-04,  8.900603042638910e-07, -4.585801990905977e-09,  2.256587925642978e-11,
 -1.068765289921242e-13,  4.912610235139186e-16, -2.203854889303252e-18,  9.683409955160386e-21, -4.179269000735245e-23,  1.774609414933211e-25, -7.431156699877978e-28,
  3.020734615934908e-02, -1.545206535494622e-04,  1.047456445056940e-06, -6.510691411838946e-09,  3.780519918860792e-11, -2.092404093176755e-13,  1.115618835050925e-15,
 -5.764653614774451e-18,  2.900773343717785e-20, -1.425552608508981e-22,  6.865796264946000e-25, -3.243636103984292e-27,  1.821635689564684e-02, -1.235040790174203e-04,
  1.030975164884460e-06, -7.518340333423334e-09,  5.069394133581665e-11, -3.230798708822898e-13,  1.968236603774892e-15, -1.154518971737853e-17,  6.558240271242858e-20,
 -3.621728054343257e-22,  1.951666273716980e-24, -1.028310893047571e-26,  9.671611323499665e-03, -8.596574667036864e-05,  8.539100528209230e-07, -7.216000483543316e-09,
  5.589976929572074e-11, -4.056586509947286e-13,  2.793126424654947e-15, -1.840778656040586e-17,  1.168909481470775e-19, -7.186071983680553e-22,  4.294161502948005e-24,
 -2.501217110215723e-26,  4.518179438263300e-03, -5.178137434998006e-05,  6.004277489659669e-07, -5.834976538111839e-09,  5.148524885461977e-11, -4.217964584742484e-13,
  3.256216693284723e-15, -2.392910153848457e-17,  1.686498261129520e-19, -1.146240487422470e-21,  7.545831151848738e-24, -4.827502410974359e-26,  1.855871056461930e-03,
 -2.694861395970418e-05,  3.608763290328126e-07, -4.008705975010183e-09,  4.000696286606724e-11, -3.676033639545147e-13,  3.162518266759200e-15, -2.576616471908773e-17,
  2.004548011372735e-19, -1.498304755992787e-21,  1.081170625061845e-23, -7.560000816449861e-26,  6.697327294642965e-04, -1.212095802289246e-05,  1.862705643087905e-07,
 -2.352861676257100e-09,  2.641166133807239e-11, -2.708107098565170e-13,  2.584137520829341e-15, -2.323773148288038e-17,  1.987103715094583e-19, -1.626758119929780e-21,
  1.281676642728555e-23, -9.758126881285331e-26,  2.121471911576693e-04, -4.715725091092715e-06,  8.282793747298844e-08, -1.184366853384805e-09,  1.488845688031884e-11,
 -1.696785935470614e-13,  1.789223422826055e-15, -1.769616928532397e-17,  1.657735711697246e-19, -1.481644069322090e-21,  1.270641302350121e-23, -1.050208715126768e-25,
  5.893025795447804e-05, -1.588406151570337e-06,  3.179468581204905e-08, -5.127161101966818e-10,  7.193044085293613e-12, -9.083337788745540e-14,  1.055370929984234e-15,
 -1.144877460799984e-17,  1.171830313777489e-19, -1.140582106814537e-21,  1.062130756290781e-23, -9.507751518621034e-26,  1.434066120052386e-05, -4.635537484218740e-07,
  1.055048368900535e-08, -1.912736479004689e-10,  2.986755033369886e-12, -4.168981063587601e-14,  5.325062659812665e-16, -6.322463390162133e-18,  7.056278563768200e-20,
 -7.464857663637000e-22,  7.534038962771639e-24, -7.290939695345534e-26,  3.054148172876513e-06, -1.172749460193095e-07,  3.029219150380370e-09, -6.158693535567323e-11,
  1.068180192207877e-12, -1.644974351464639e-14,  2.305872424349715e-16, -2.991546766041840e-18,  3.634926316173284e-20, -4.173309785898819e-22,  4.558489238890876e-24,
 -4.762452994791530e-26,  5.686923033427212e-07, -2.573068418191226e-08,  7.530333178210640e-10, -1.713564591875613e-11,  3.296044065699607e-13, -5.592268139166195e-15,
  8.591954689963460e-17, -1.216561669575225e-18,  1.607513106107774e-20, -2.000830132818469e-22,  2.362833953586112e-24, -2.662312166636022e-26,  9.250190315899557e-08,
 -4.897558047985812e-09,  1.621647774396188e-10, -4.124147568138560e-12,  8.787789789315148e-14, -1.641098201663885e-15,  2.761142836272695e-17, -4.263477813318059e-19,
  6.121769149448775e-21, -8.254493172124681e-23,  1.053160484077058e-24, -1.278917584313604e-26,  1.313443403834751e-08, -8.089938533260203e-10,  3.026925640237859e-11,
 -8.594446311960030e-13,  2.027221852808684e-14, -4.164468600925586e-16,  7.669098809317808e-18, -1.290789136368065e-19,  2.013160326496961e-21, -2.939522291293396e-23,
  4.050376757714846e-25, -5.299095367142961e-27,  1.627401847822767e-09, -1.160322940607917e-10,  4.900849804239725e-12, -1.552514530515786e-13,  4.052226084386051e-15,
 -9.154770867536166e-17,  1.844957128403665e-18, -3.384341576009087e-20,  5.732684051236972e-22, -9.063512948277687e-24,  1.348610041190322e-25, -1.900665272311954e-27,
  1.759718115663633e-10, -1.446328100320380e-11,  6.890420827608006e-13, -2.434515021216455e-14,  7.031046627423479e-16, -1.747018458582762e-17,  3.853416347278374e-19,
 -7.705118979401288e-21,  1.417742522166478e-22, -2.427445596301325e-24,  3.901044076295592e-26, -5.923478568833321e-28,  1.661904688045347e-11, -1.569123866935811e-12,
  8.426915794353980e-14, -3.320637140399465e-15,  1.061401386331594e-16, -2.901576405956338e-18,  7.007600213057881e-20, -1.528039345907647e-21,  3.055439772573031e-23,
 -5.667899218887652e-25,  9.841704129105976e-27, -1.610672437395958e-28,  1.373353204976302e-12, -1.485264068230548e-13,  8.988506896079232e-15, -3.951161760378121e-16,
  1.398456992993627e-17, -4.208690318259769e-19,  1.113672112268849e-20, -2.650014812835642e-22,  5.762347548018114e-24, -1.158848115521435e-25,  2.175517021549294e-27,
 -3.839686650561885e-29,  9.963584245980643e-14, -1.231293818800287e-14,  8.395460766110711e-16, -4.118731214911246e-17,  1.615358735533797e-18, -5.356446888622214e-20,
  1.554348781098975e-21, -4.039748438279736e-23,  9.560926761005187e-25, -2.086297129127514e-26,  4.237940734806715e-28, -8.072713375304559e-30,  6.380762819382379e-15,
 -8.992091673957836e-16,  6.907802960786589e-17, -3.784561211752156e-18,  1.646256941550137e-19, -6.020920419386713e-21,  1.918059753066926e-22, -5.450669756374626e-24,
  1.405553914281459e-25, -3.331306666962708e-27,  7.329236162602375e-29, -1.508179216499743e-30,  3.637732582776008e-16, -5.835559729050024e-17,  5.051242380762219e-18,
 -3.092807517915192e-19,  1.493680970980419e-20, -6.032272669428459e-22,  2.112160860131647e-23, -6.570753990678894e-25,  1.848296027465066e-26, -4.763407334197694e-28,
  1.136299408928873e-29, -2.528445231674146e-31,  1.869922886514771e-17, -3.408695829570217e-18,  3.324877285775988e-19, -2.276838364438252e-20,  1.222114810701679e-21,
 -5.456353060490035e-23,  2.102446787145839e-24, -7.168737903861509e-26,  2.202285200402330e-27, -6.178656473801566e-29,  1.599816141609766e-30, -3.853319996845576e-32,
  8.830774808138329e-19, -1.825777253277408e-19,  2.006596283576796e-20, -1.537685741833217e-21,  9.181387123482584e-23, -4.536442161304542e-24,  1.925695242883373e-25,
 -7.204583962111645e-27,  2.419779697664097e-28, -7.397943257345039e-30,  2.081143030800256e-31, -5.430631049622144e-33,  3.936866085032058e-20, -9.209383539719273e-21,
  1.139768474277025e-21, -9.775384172587818e-23,  6.495948348500040e-24, -3.554232539305790e-25,  1.663328436321417e-26, -6.833126870468434e-28,  2.510901895885907e-29,
 -8.370819614478255e-31,  2.559983297915928e-32, -7.240978728079181e-34,  1.722160518268417e-21, -4.542540547535417e-22,  6.321426874397878e-23, -6.063567341063068e-24,
  4.482877044986505e-25, -2.715784577071695e-26,  1.401101679712472e-27, -6.320185232350411e-29,  2.540863399416713e-30, -9.236528388986597e-32,  3.070599341559873e-33,
 -9.413077193446643e-35,  7.801646902073716e-23, -2.308636063619530e-23,  3.601501979492574e-24, -3.855057800276366e-25,  3.165248926595099e-26, -2.119922942938390e-27,
  1.204035008322908e-28, -5.956014369605634e-30,  2.616390817592715e-31, -1.035802503337324e-32,  3.738428123906430e-34, -1.240453198148062e-35,  3.936421542333951e-24,
 -1.296972945894411e-24,  2.255676228523077e-25, -2.681941084654551e-26,  2.435508419390227e-27, -1.796533784773579e-28,  1.119326729331048e-29, -6.051391181281850e-31,
  2.895139612725725e-32, -1.244213628164519e-33,  4.859937057187671e-35, -1.739959092626813e-36,  2.427235182844564e-25, -8.806560653371086e-26,  1.691906310876731e-26,
 -2.216080309868861e-27,  2.208857761951094e-28, -1.781642351647117e-29,  1.209394592808277e-30, -7.098898632489754e-32,  3.675468278906799e-33, -1.704158341142001e-34,
  7.160744832723478e-36, -2.749969502389283e-37,  2.031532165946569e-26, -7.992221810629159e-27,  1.672193279711878e-27, -2.380973542129347e-28,  2.572269548362649e-29,
 -2.241696091457138e-30,  1.638986287827188e-31, -1.033103234394454e-32,  5.727523286128512e-34, -2.835861798146457e-35,  1.269215548560713e-36, -5.178283543988780e-38,
  2.505019818692045e-27, -1.046971370536345e-27,  2.337726440519181e-28, -3.548593220831707e-29,  4.078451938533176e-30, -3.772282060665025e-31,  2.920209751426204e-32,
 -1.944390672835740e-33,  1.136155027718632e-34, -5.916445450701982e-36,  2.779297659071940e-37, -1.187736632514440e-38,  4.079272196543884e-28, -1.766495398159913e-28,
  4.099909315940231e-29, -6.466137030071361e-30,  7.712081900595618e-31, -7.392014889574932e-32,  5.921553156209955e-33, -4.074361136205207e-34,  2.456859663897498e-35,
 -1.318582725474018e-36,  6.375995016108996e-38, -2.801267820235228e-39,  6.374799998397078e-02, -1.673646016496895e-04,  4.537005541690605e-07, -1.265479664079100e-09,
  3.603809510054794e-12, -1.047523793691954e-14,  3.050910270107108e-17, -9.166608414138573e-20,  2.604773787669906e-22, -8.619621934336820e-25,  1.878013794470944e-27,
 -1.111112080701663e-29,  5.610492467195476e-02, -1.688409252063676e-04,  6.176178133651563e-07, -2.418253491785877e-09,  9.518333694770749e-12, -3.698708236012571e-14,
  1.410895333072092e-16, -5.311754776958175e-19,  1.960875481275936e-21, -7.233624067088025e-24,  2.575848477876331e-26, -9.588851221114427e-29,  4.345199900695902e-02,
 -1.642813508431482e-04,  8.371284855109837e-07, -4.241227931136847e-09,  2.054142821703576e-11, -9.579308720864382e-14,  4.336744816105603e-16, -1.916749815283045e-18,
  8.299143160825469e-21, -3.530707198238436e-23,  1.477861284290664e-25, -6.103612337680729e-28,  2.960554214518610e-02, -1.464435410214967e-04,  9.728239154045822e-07,
 -5.937884974647749e-09,  3.387558793080720e-11, -1.843021480677746e-13,  9.664687223168028e-16, -4.913484490285308e-18,  2.433753612870443e-20, -1.177455035342946e-22,
  5.586017714876177e-25, -2.598606173649802e-27,  1.773828362773109e-02, -1.156038442176727e-04,  9.454164899991463e-07, -6.756469263702733e-09,  4.467971258742979e-11,
 -2.794957599221951e-13,  1.672494634961923e-15, -9.640939555379352e-18,  5.384682195485628e-20, -2.924519883400723e-22,  1.550697060683768e-24, -8.039448422210717e-27,
  9.340883162981034e-03, -7.946622331171496e-05,  7.724280271644880e-07, -6.383035254682188e-09,  4.841728493116216e-11, -3.444087251092469e-13,  2.326410892899334e-15,
 -1.505008107732463e-17,  9.386494022606335e-20, -5.669785025137568e-22,  3.330467655371553e-24, -1.907335290094180e-26,  4.320236285107861e-03, -4.724464187640257e-05,
  5.350853859376280e-07, -5.074671185225236e-09,  4.377953768525915e-11, -3.511137423870693e-13,  2.655945970422527e-15, -1.913820137482786e-17,  1.323426013186315e-19,
 -8.829557695153120e-22,  5.708536987299246e-24, -3.587942583922076e-26,  1.753560618556205e-03, -2.424367245157999e-05,  3.163826258519585e-07, -3.423520046872334e-09,
  3.335900728531773e-11, -2.996825212754742e-13,  2.523320000077958e-15, -2.013726487562332e-17,  1.535603017154507e-19, -1.125694078601120e-21,  7.970662139904076e-24,
 -5.471251531778213e-26,  6.240600345861089e-04, -1.073693768457491e-05,  1.604033492250095e-07, -1.970444048844085e-09,  2.156643308843692e-11, -2.159315226354184e-13,
  2.014358895314760e-15, -1.772489329027747e-17,  1.484264212745981e-19, -1.190671721497798e-21,  9.197501383055006e-24, -6.868965375101862e-26,  1.945249211680164e-04,
 -4.106145087844343e-06,  6.993996123838634e-08, -9.711252523290292e-10,  1.188706464024997e-11, -1.321296967670476e-13,  1.360628881553438e-15, -1.315512386882550e-17,
  1.205690409722586e-19, -1.055058205940498e-21,  8.864104600055952e-24, -7.181273954391945e-26,  5.304897263376664e-05, -1.356832167761040e-06,  2.627685212034710e-08,
 -4.108863691072754e-10,  5.605738705588650e-12, -6.896272926784603e-14,  7.816708112676126e-16, -8.281433824500005e-18,  8.285813301191005e-20, -7.889624361111375e-22,
  7.192141417478298e-24, -6.306165053024558e-26,  1.264178585568914e-05, -3.875777549854273e-07,  8.516508364613385e-09, -1.495174469680884e-10,  2.267641385725252e-12,
 -3.080174997573613e-14,  3.834304018667630e-16, -4.442011271193617e-18,  4.842032911421106e-20, -5.007200220112913e-22,  4.943531912712077e-24, -4.682819216204071e-26,
  2.629214803203286e-06, -9.573000314630555e-08,  2.382765906325880e-09, -4.685360645401626e-11,  7.883660939474852e-13, -1.180208890390229e-14,  1.610788110747452e-16,
 -2.037288815448150e-18,  2.415812051602181e-20, -2.709242191344369e-22,  2.892847217792874e-24, -2.956459811324252e-26,  4.766320033515035e-07, -2.044710211193196e-08,
  5.756903154168319e-10, -1.265531436426429e-11,  2.358949468809801e-13, -3.886892018366122e-15,  5.809251231474581e-17, -8.012334330421849e-19,  1.032432523879443e-20,
 -1.254335314355390e-22,  1.447081234328829e-24, -1.594023715874965e-26,  7.522360043375261e-08, -3.776575316161485e-09,  1.201345878740697e-10, -2.948364696455577e-12,
  6.081944893130039e-14, -1.102020659339335e-15,  1.802166751288487e-17, -2.708533474176256e-19,  3.789861489052332e-21, -4.984835796107138e-23,  6.209411990119669e-25,
 -7.367728042244656e-27,  1.032447389965917e-08, -6.031527368336516e-10,  2.165652555714640e-11, -5.928294985116093e-13,  1.352496024300595e-14, -2.693557664232520e-16,
  4.817600844158651e-18, -7.886817267810788e-20,  1.197902410327448e-21, -1.705204947417566e-23,  2.292734311255232e-25, -2.929389982203950e-27,  1.231277656025999e-09,
 -8.330034240341095e-11,  3.373419381215878e-12, -1.029460650214089e-13,  2.596862207705187e-15, -5.683513854009274e-17,  1.111685441426016e-18, -1.982256012213737e-20,
  3.268075834440438e-22, -5.034540900369437e-24,  7.306335189096680e-26, -1.005183767306659e-27,  1.275318204552707e-10, -9.951887159177361e-12,  4.543154055791056e-13,
 -1.545328668584469e-14,  4.310500848480897e-16, -1.036936992062871e-17,  2.218596825527471e-19, -4.309953799824958e-21,  7.714881498353032e-23, -1.286527255625296e-24,
  2.015700274910153e-26, -2.986696748571823e-28,  1.147410107645380e-11, -1.029372692992590e-12,  5.295648603171984e-14, -2.008044494366031e-15,  6.196114313470606e-17,
 -1.639134164781935e-18,  3.838248780887178e-20, -8.127928070250533e-22,  1.580498812651687e-23, -2.854515691477276e-25,  4.830853220474639e-27, -7.712815531557358e-29,
  8.976667216846937e-13, -9.233665332031740e-14,  5.352811697813756e-15, -2.263718163961115e-16,  7.732257503211989e-18, -2.251187515308145e-19,  5.774006265028443e-21,
 -1.333924945704971e-22,  2.820013774103876e-24, -5.520449510387062e-26,  1.009887051946885e-27, -1.738564974082155e-29,  6.121407392227404e-14, -7.204116964696462e-15,
  4.706673893669477e-16, -2.221526303685602e-17,  8.407905987851334e-19, -2.696862307772201e-20,  7.584703323475147e-22, -1.913658570767029e-23,  4.402941548959106e-25,
 -9.351653072152216e-27,  1.851026207501261e-28, -3.439190219385738e-30,  3.654470212645639e-15, -4.912173675282993e-16,  3.618123233193350e-17, -1.907772065614567e-18,
  8.009956934903527e-20, -2.834148254112570e-21,  8.751504877751398e-23, -2.414573358424785e-24,  6.053724128777906e-26, -1.396739567355556e-27,  2.994798654235720e-29,
 -6.011896858517151e-31,  1.923849052182862e-16, -2.949307899941335e-17,  2.450309587641770e-18, -1.444944238351161e-19,  6.739273196550700e-21, -2.634269610853526e-22,
  8.944238964262310e-24, -2.702509041521238e-25,  7.393824682651207e-27, -1.855672689324403e-28,  4.315652785213930e-30, -9.371801021970875e-32,  9.032703949785783e-18,
 -1.577271937330828e-18,  1.478893327408806e-19, -9.764870005148810e-21,  5.066574319112826e-22, -2.191236167649727e-23,  8.193659572551674e-25, -2.715442846318795e-26,
  8.119224828834696e-28, -2.219786175505072e-29,  5.607163047378511e-31, -1.318891600701054e-32,  3.848283011214907e-19, -7.643553554611694e-20,  8.091825770911541e-21,
 -5.988966888768373e-22,  3.461667332895291e-23, -1.658965442997264e-24,  6.842162228584624e-26, -2.490850145342560e-27,  8.151248783825381e-29, -2.431009207121794e-30,
  6.678416163169429e-32, -1.703551964724769e-33,  1.526509669575795e-20, -3.442566035005507e-21,  4.115127122304569e-22, -3.416597163845592e-23,  2.202303269808133e-24,
 -1.170926090256242e-25,  5.333271164883058e-27, -2.135376089425744e-28,  7.657173744798716e-30, -2.493922800607465e-31,  7.458934451573650e-33, -2.065301745637104e-34,
  5.854341709956987e-22, -1.494975040095620e-22,  2.016340974870250e-23, -1.877944333642775e-24,  1.350429704059802e-25, -7.969910115323589e-27,  4.011282586538798e-28,
 -1.767464073804352e-29,  6.948785708689920e-31, -2.472853131638681e-32,  8.055483090034115e-34, -2.422002488817597e-35,  2.291192309932493e-23, -6.596465001393793e-24,
  1.001632336884996e-24, -1.045029696631254e-25,  8.375222188457584e-27, -5.482454280422295e-28,  3.047104363107691e-29, -1.476651579262713e-30,  6.361196270794262e-32,
 -2.471899141440108e-33,  8.764608487221064e-35, -2.859365903017950e-36,  9.864656099281512e-25, -3.180074158336215e-25,  5.410821996338280e-26, -6.299980972504723e-27,
  5.608621464009548e-28, -4.060080660535352e-29,  2.484933795689968e-30, -1.320887669129694e-31,  6.218661525637687e-33, -2.631939193496187e-34,  1.013158118384590e-35,
 -3.577278878829582e-37,  5.159291739849149e-26, -1.842656200786876e-26,  3.483264910411755e-27, -4.491895255273394e-28,  4.411372184270481e-29, -3.508462452919255e-30,
  2.349999013346818e-31, -1.362032561809578e-32,  6.967546168013762e-34, -3.193764603237626e-35,  1.327439689740826e-36, -5.045216610375021e-38,  3.685957656023068e-27,
 -1.435986265849355e-27,  2.973784567897015e-28, -4.192289645295986e-29,  4.486221846719498e-30, -3.874457020577257e-31,  2.808509892940027e-32, -1.755891606292249e-33,
  9.659397727638116e-35, -4.747472030894603e-36,  2.109898172892131e-37, -8.550914393405081e-39,  3.979510866076405e-28, -1.655456974271308e-28,  3.677833193242866e-29,
 -5.555437761763666e-30,  6.354878778900199e-31, -5.851399810319289e-32,  4.510310639420695e-33, -2.990902501880108e-34,  1.740875223116014e-35, -9.031970035406529e-37,
  4.227891598191595e-38, -1.800740191026611e-39,  5.954405875717820e-29, -2.574817032149147e-29,  5.966583051820058e-30, -9.395506744767281e-31,  1.118898877036306e-31,
 -1.070901560872730e-32,  8.566710376461763e-34, -5.886450149262522e-35,  3.544971038805203e-36, -1.900202930976487e-37,  9.177441784658637e-39, -4.027453442543088e-40,
  6.308570597297512e-02, -1.637947756721796e-04,  4.388539767820713e-07, -1.209455822196010e-09,  3.401423785226717e-12, -9.772905568058107e-15,  2.805457903000269e-17,
 -8.381377060195387e-20,  2.306788162429824e-22, -7.968839441887733e-25,  1.367379695606177e-27, -1.228904168712134e-29,  5.543926265127148e-02, -1.640135249299396e-04,
  5.894887024698198e-07, -2.271699037332876e-09,  8.811284478597984e-12, -3.377255170486597e-14,  1.270573149734655e-16, -4.724031735635843e-19,  1.718032571310489e-21,
 -6.283512359271556e-24,  2.184400752296682e-26, -8.258019123355953e-29,  4.280795302649119e-02, -1.577824566511337e-04,  7.881442872588098e-07, -3.927344184293220e-09,
  1.872545141492494e-11, -8.600005281353784e-14,  3.835402609458604e-16, -1.670423702416865e-18,  7.128328623778737e-21, -2.989943220628228e-23,  1.233790192874985e-25,
 -5.027552889372997e-28,  2.903489453341123e-02, -1.389370261944381e-04,  9.047036709917252e-07, -5.424148877989940e-09,  3.041079242356688e-11, -1.626735928555342e-13,
  8.391866320280815e-16, -4.198406301940219e-18,  2.047479833269253e-20, -9.752930530623944e-23,  4.559226719604578e-25, -2.088132180923343e-27,  1.729049803724618e-02,
 -1.083530810465563e-04,  8.684504660479578e-07, -6.084220650087254e-09,  3.947029696388795e-11, -2.424098508992560e-13,  1.425170459885780e-15, -8.074981032936108e-18,
  4.435479676409631e-20, -2.369568262211350e-22,  1.236652753486331e-24, -6.308671833726416e-27,  9.034909933520489e-03, -7.358051976436991e-05,  7.002618031705276e-07,
 -5.660567855110365e-09,  4.205499279650145e-11, -2.933102550759644e-13,  1.944165854977110e-15, -1.234882688728478e-17,  7.566237416995975e-20, -4.491378046246985e-22,
  2.594042319000098e-24, -1.460852998966337e-26,  4.139449543759197e-03, -4.319614703409745e-05,  4.781711730907569e-07, -4.427087374748497e-09,  3.735363851524036e-11,
 -2.933507921195170e-13,  2.174884445698949e-15, -1.537066234849951e-17,  1.043124500388654e-19, -6.833111710305757e-22,  4.339701872840418e-24, -2.680192280442721e-26,
  1.661400098349782e-03, -2.186830180969415e-05,  2.783152172621057e-07, -2.934616900008182e-09,  2.792800083193924e-11, -2.453690444879418e-13,  2.022592217652433e-15,
 -1.581461871367731e-17,  1.182379284559117e-19, -8.502668159782236e-22,  5.908928578418448e-24, -3.982491388302660e-26,  5.835368529917069e-04, -9.542738085806191e-06,
  1.386939531884702e-07, -1.657463007419450e-09,  1.769366323048800e-11, -1.730429702580235e-13,  1.578586952910647e-15, -1.359558628722602e-17,  1.115155576998126e-19,
 -8.767925309465446e-22,  6.641961700507039e-24, -4.866805952649188e-26,  1.791498883208744e-04, -3.590196029756271e-06,  5.934583386881839e-08, -8.004165291377454e-10,
  9.543298523534503e-12, -1.034915411693726e-13,  1.041044657892569e-15, -9.841932447342589e-18,  8.827454063672683e-20, -7.564690185639700e-22,  6.227701820272211e-24,
 -4.946543928421423e-26,  4.801286852444774e-05, -1.164913707252598e-06,  2.184194984648873e-08, -3.312830542151368e-10,  4.396746728650404e-12, -5.270996202551767e-14,
  5.830077462259746e-16, -6.033899877993883e-18,  5.902822254819795e-20, -5.499741626584807e-22,  4.908986731291855e-24, -4.216950261180841e-26,  1.121718854158317e-05,
 -3.260494951594209e-07,  6.921174626567335e-09, -1.177028101224871e-10,  1.734394066671776e-12, -2.293223322210845e-14,  2.782869053273787e-16, -3.146507166503212e-18,
  3.350738212157290e-20, -3.387881774717335e-22,  3.272659001811197e-24, -3.035109842046686e-26,  2.281138861003348e-06, -7.871907822903381e-08,  1.889047344564409e-09,
 -3.593596781018578e-11,  5.867786012137209e-13, -8.541643048025077e-15,  1.135369275153706e-16, -1.400266921468170e-18,  1.620809035660462e-20, -1.775866555293555e-22,
  1.854020097425547e-24, -1.853881387724328e-26,  4.031762072184555e-07, -1.639032248458431e-08,  4.441331579921571e-10, -9.434151150178830e-12,  1.704586996815298e-13,
 -2.728357930013781e-15,  3.967677645551993e-17, -5.331748374392567e-19,  6.701106303649173e-21, -7.948433450158177e-23,  8.959815138746803e-25, -9.650601206372812e-27,
  6.183670090647511e-08, -2.942011489530898e-09,  8.993517341861982e-11, -2.130428204323156e-12,  4.255430622776291e-14, -7.483044852228610e-16,  1.189667620737727e-17,
 -1.740665248026656e-19,  2.373898072742024e-21, -3.046354717796686e-23,  3.705509850001143e-25, -4.296692571350164e-27,  8.218013332707953e-09, -4.550495997493133e-10,
  1.568166389377609e-11, -4.139244889184880e-13,  9.135387365121885e-15, -1.764111030117102e-16,  3.064961413284823e-18, -4.881209455468062e-20,  7.221234622202580e-22,
 -1.002275795963625e-23,  1.315173144060844e-25, -1.641268865994154e-27,  9.451212092982441e-10, -6.062588059919671e-11,  2.354081186115478e-12, -6.920966646214512e-14,
  1.687470196414928e-15, -3.578258819273761e-17,  6.793867366538299e-19, -1.177707770038485e-20,  1.890030786312485e-22, -2.837353159448535e-24,  4.016497985259517e-26,
 -5.394626120802006e-28,  9.396575305508891e-11, -6.955942970687248e-12,  3.042490015754235e-13, -9.962789336786162e-15,  2.684125780264407e-16, -6.251720029877381e-18,
  1.297573081782420e-19, -2.449156053952027e-21,  4.265212466844552e-23, -6.927801340098318e-25,  1.058286976232148e-26, -1.530244613505674e-28,  8.072178249445498e-12,
 -6.874544426051549e-13,  3.386961250999587e-14, -1.235696187778992e-15,  3.680628817775164e-17, -9.422117511984181e-19,  2.139185545353399e-20, -4.399245691415570e-22,
  8.318989240704128e-24, -1.462856345519375e-25,  2.412896068609529e-27, -3.758208155633862e-29,  5.993336193980142e-13, -5.857572963579916e-14,  3.251383170633238e-15,
 -1.322528774888219e-16,  4.358925229559463e-18, -1.227559655498690e-19,  3.051580987990490e-21, -6.844003757513954e-23,  1.406599640286240e-24, -2.680177796215010e-26,
  4.777481457137723e-28, -8.021887002132200e-30,  3.851585821921551e-14, -4.311782567643561e-15,  2.697680088955516e-16, -1.224561897907574e-17,  4.471223402451503e-19,
 -1.386959570683638e-20,  3.779814925334499e-22, -9.256461188143012e-24,  2.070099658661226e-25, -4.279029408969817e-27,  8.251956925253632e-29, -1.495282074122353e-30,
  2.149400072360001e-15, -2.752199344110171e-16,  1.942217257569568e-17, -9.850944308988895e-19,  3.990456372138608e-20, -1.365500283680117e-21,  4.085849447161305e-23,
 -1.094190275372036e-24,  2.666563956579384e-26, -5.987832989556152e-28,  1.250933183193784e-29, -2.449262031728621e-31,  1.047778590430585e-16, -1.532894802984127e-17,
  1.221241967535217e-18, -6.931161756585593e-20,  3.120175908624741e-21, -1.179885191689983e-22,  3.883056615051075e-24, -1.139105535804480e-25,  3.030088610176154e-27,
 -7.403327986740633e-29,  1.678043020823300e-30, -3.555183702675380e-32,  4.505760517681288e-18, -7.525229852624099e-19,  6.775171736201973e-20, -4.309698385512656e-21,
  2.159963324249162e-22, -9.043341144638924e-24,  3.279713018316927e-25, -1.055885728869208e-26,  3.071308537320001e-28, -8.178968813204804e-30,  2.014649129987054e-31,
 -4.625804973326628e-33,  1.736160935835601e-19, -3.307349901800386e-20,  3.368392718932734e-21, -2.405323204561602e-22,  1.344650284201599e-23, -6.245396871294260e-25,
  2.500842418034516e-26, -8.852889128104146e-28,  2.820997844581293e-29, -8.202387463418682e-31,  2.199299276774750e-32, -5.481155800250633e-34,  6.140101765120135e-21,
 -1.332586868331728e-21,  1.536366112628750e-22, -1.233312067155382e-23,  7.703155012559793e-25, -3.976075279483039e-26,  1.761049070846807e-27, -6.866586169177154e-29,
  2.400998356025441e-30, -7.634405922073986e-32,  2.231531027023119e-33, -6.044768929250006e-35,  2.066643267084526e-22, -5.099843436818394e-23,  6.656248629687111e-24,
 -6.011279081502126e-25,  4.199444801799554e-26, -2.411790050766659e-27,  1.183005210054082e-28, -5.086917893852357e-30,  1.954069618001397e-31, -6.801963073421911e-33,
  2.169546505588681e-34, -6.393022953297013e-36,  6.983880161049302e-24, -1.952700722340943e-24,  2.881407592840394e-25, -2.926001935992905e-26,  2.285955643532466e-27,
 -1.460814369692568e-28,  7.936372279704062e-30, -3.763930138253153e-31,  1.588545220300463e-32, -6.053652551995314e-34,  2.106877585189329e-35, -6.752622288183878e-37,
  2.558640257224106e-25, -8.056658907462082e-26,  1.339015846170927e-26, -1.524576157671479e-27,  1.328854255036859e-28, -9.429030662220688e-30,  5.662677127380411e-31,
 -2.956474764207031e-32,  1.368356678820424e-33, -5.698159706184752e-35,  2.159868933906901e-36, -7.514788845760333e-38,  1.128651120108920e-26, -3.962420774547067e-27,
  7.360169413926223e-28, -9.332968571888798e-29,  9.020295708985904e-30, -7.066192634418086e-31,  4.665553193740872e-32, -2.667547298484856e-33,  1.347079907139030e-34,
 -6.099352689016925e-36,  2.505659259711678e-37, -9.418133527753090e-39,  6.825338350748353e-28, -2.630586432269328e-28,  5.386729005632540e-29, -7.511697460342326e-30,
  7.955347365184164e-31, -6.803123736631664e-32,  4.885539944566821e-33, -3.027481644472819e-34,  1.651491641155440e-35, -8.052189836014008e-37,  3.551478774394907e-38,
 -1.428971937232966e-39,  6.390920084939879e-29, -2.644831289210855e-29,  5.843342029914089e-30, -8.778803650622740e-31,  9.990127222278013e-32, -9.153283097121407e-33,
  7.022346091808665e-34, -4.635937441645284e-35,  2.686940221729123e-36, -1.388410394865261e-37,  6.474239605428017e-39, -2.747445528461814e-40,  8.722153707606089e-30,
 -3.765746843878720e-30,  8.711348367958876e-31, -1.369440272437970e-31,  1.628170915071065e-32, -1.555864581135794e-33,  1.242729940404246e-34, -8.526745699143181e-36,
  5.127850678922456e-37, -2.744984938000199e-38,  1.324043181754696e-39, -5.803300780498078e-41,  };
  int offset = -33;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 33;
    if (std::isnan(t)) {
      fill_n(rr+offset, 33, 0.5);
      fill_n(ww+offset, 33, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 33; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=33; ++j) {
        const int boxof = it*396+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
