!
! File:       sorttest.f90
! Copyright:  (c) 2002 Lawrence Livermore National Security, LLC
! Revision:   @(#) $Revision: 6171 $
! Date:       $Date: 2007-10-08 16:39:28 -0700 (Mon, 08 Oct 2007) $
! Description:Exercise the FORTRAN interface for sorting
!
!
#include "sort_SortingAlgorithm_fAbbrev.h"
#include "sort_MergeSort_fAbbrev.h"
#include "sort_QuickSort_fAbbrev.h"
#include "sort_HeapSort_fAbbrev.h"
#include "sort_SortTest_fAbbrev.h"
#include "synch_RegOut_fAbbrev.h"
#include "synch_ResultType_fAbbrev.h"
#include "sidl_BaseInterface_fAbbrev.h"

subroutine starttest(number)
  use sidl
  use synch_RegOut
  use sidl_BaseInterface
  implicit none
  integer (kind=sidl_int) :: number
  type(synch_RegOut_t) :: tracker
  type(sidl_BaseInterface_t) :: throwaway_exception
  call getInstance(tracker, throwaway_exception)
  call startPart(tracker, number, throwaway_exception)
  call deleteRef(tracker, throwaway_exception)
end subroutine starttest

subroutine reporttest(test, number)
  use sidl
  use synch_RegOut
  use synch_ResultType
  use sidl_BaseInterface
  implicit none
  integer (kind=sidl_int) :: number
  logical                        :: test
  type(synch_RegOut_t) :: tracker
  type(sidl_BaseInterface_t) :: throwaway_exception
  call getInstance(tracker, throwaway_exception)
  if (test) then
     call endPart(tracker, number, PASS, throwaway_exception)
  else
     call endPart(tracker, number, FAIL, throwaway_exception)
  endif
  number = number + 1
  call deleteRef(tracker, throwaway_exception)
end subroutine reporttest

subroutine testsort(test)
  use sidl
  use sort_SortingAlgorithm
  use sort_QuickSort
  use sort_HeapSort
  use sort_MergeSort
  use sort_SortTest
  use sidl_BaseInterface
  use sort_SortingAlgorithm_array
  implicit none
  type(sort_SortingAlgorithm_1d) :: algs
  type(sort_SortingAlgorithm_t) :: alg
  type(sidl_BaseInterface_t) :: throwaway_exception
  type(sort_MergeSort_t) :: merge
  type(sort_HeapSort_t) :: heap
  type(sort_QuickSort_t) :: quick
  integer (kind=sidl_int)  :: test
  logical                         :: retval

  call create1d(3_sidl_int, algs)
  call starttest(test)
  call new(merge, throwaway_exception)
  call reporttest(not_null(merge), test)
  call starttest(test)
  call new(quick, throwaway_exception)
  call reporttest(not_null(quick), test)
  call starttest(test)
  call new(heap, throwaway_exception)
  call reporttest(not_null(heap), test)

  call cast(merge, alg, throwaway_exception)
  call set(algs, 0_sidl_int, alg)
  call deleteRef(alg, throwaway_exception)
  call cast(heap, alg, throwaway_exception)
  call set(algs, 1_sidl_int, alg)
  call deleteRef(alg, throwaway_exception)
  call cast(quick, alg, throwaway_exception)
  call set(algs, 2_sidl_int, alg)
  call deleteRef(alg, throwaway_exception)
  ! remove extraneous references
  call deleteRef(merge, throwaway_exception)
  call deleteRef(quick, throwaway_exception)
  call deleteRef(heap, throwaway_exception)

  call starttest(test)
  call stressTest(algs, retval, throwaway_exception)
  call reporttest(retval, test)
  call deleteRef(algs)
end subroutine testsort

program sorttest
  use sidl
  use synch_RegOut
  use sidl_BaseInterface
  implicit none
  integer (kind=sidl_int) :: test
  type(synch_RegOut_t) :: tracker
  type(sidl_BaseInterface_t) :: throwaway_exception
  test = 1
  call getInstance(tracker, throwaway_exception)
  call setExpectations(tracker, 4_sidl_int, throwaway_exception)
  call writeComment(tracker, 'Sort tests', throwaway_exception)
  call testsort(test)
  call close(tracker, throwaway_exception)
  call deleteRef(tracker, throwaway_exception)
end program sorttest
