/*************************************************************************
 * var.h Operations with variables in script language [part of AVInfo 1.x]
 *
 * Copyright (c) 2003 George Shuklin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *   
 * You should have received a copy of the GNU General Public License along
 * with this program (see the file COPYING); if not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307  USA  or visit http://www.gnu.org/copyleft/gpl.html
 *
 *************************************************************************/

#ifndef _H_VAR_H
#define _H_VAR_H

#define MAX_BLOCK 65536

enum{ t_UNKNOWN=0, t_NUMBER=0,t_STRING=1 };


int SetNumericVar(  char* var_name,  int value );

int SetIdxNumericVar( char* name,  int class_number,  int value);

int SetStringVar( char* var_name, char* value );

int SetIdxStringVar( char* name,  int class_number,  char* value );

int CatStringVar(  char* var_name,  char* add_value );

int GetNumericVar(  char* var_name );

int GetIdxNumericVar(  char* var_name,  int class_number );

char* GetStringVar(  char* var_name );

 char* GetROStringVar(  char* var_name );

int GetVarType(  char* var_name );

int DelVar(const char* name );

#define IncNumVar( var_name)\
	SetNumericVar(var_name, GetNumericVar(var_name)+1)

#define DecNumVar( var_name)\
	SetNumericVar(var_name, GetNumericVar(var_name)-1)


void ClearVar( );

void Init();

int IncStreamCounter( int T );

typedef struct vart_s{
	int type;
	char* string;
	int number;
}var_t;

typedef struct var_item_s{
	char* name;
	var_t content;
	int type;
	struct var_item_s *Next;
}var_item_t;

extern var_item_t *Var_root;


int SetVar( char* var_name, const var_t value);

var_t GetVar( char* var_name);

void PrintVarList();

var_item_t* MakeSnap();


void AddAudioVideo(unsigned int video[MAX_STREAMS][VIDEO_INFO_SIZE], unsigned int audio[MAX_STREAMS][AUDIO_INFO_SIZE]);
#endif
