package org.xiph.fvorbis;

import org.xiph.system.Bytes;

class Lookup {
    /*
     * generated source for Lookup
     */
    inline static var COS_LOOKUP_SZ : Int = 128;
    inline static function COS_LOOKUP() : Array<Float>{
    	return [1.0000000000000, 0.9996988186962, 0.9987954562052, 0.9972904566787, 0.9951847266722, 0.9924795345987, 0.9891765099648, 0.9852776423889, 0.9807852804032, 0.9757021300385, 0.9700312531945, 0.9637760657954, 0.9569403357322, 0.9495281805930, 0.9415440651830, 0.9329927988347, 0.9238795325113, 0.9142097557035, 0.9039892931234, 0.8932243011955, 0.8819212643484, 0.8700869911087, 0.8577286100003, 0.8448535652497, 0.8314696123025, 0.8175848131516, 0.8032075314806, 0.7883464276266, 0.7730104533627, 0.7572088465065, 0.7409511253550, 0.7242470829515, 0.7071067811865, 0.6895405447371, 0.6715589548470, 0.6531728429538, 0.6343932841636, 0.6152315905806, 0.5956993044924, 0.5758081914178, 0.5555702330196, 0.5349976198871, 0.5141027441932, 0.4928981922298, 0.4713967368260, 0.4496113296546, 0.4275550934303, 0.4052413140050, 0.3826834323651, 0.3598950365350, 0.3368898533922, 0.3136817403989, 0.2902846772545, 0.2667127574749, 0.2429801799033, 0.2191012401569, 0.1950903220161, 0.1709618887603, 0.1467304744554, 0.1224106751992, 0.0980171403296, 0.0735645635997, 0.0490676743274, 0.0245412285229, 0.0000000000000, -0.0245412285229, -0.0490676743274, -0.0735645635997, -0.0980171403296, -0.1224106751992, -0.1467304744554, -0.1709618887603, -0.1950903220161, -0.2191012401569, -0.2429801799033, -0.2667127574749, -0.2902846772545, -0.3136817403989, -0.3368898533922, -0.3598950365350, -0.3826834323651, -0.4052413140050, -0.4275550934303, -0.4496113296546, -0.4713967368260, -0.4928981922298, -0.5141027441932, -0.5349976198871, -0.5555702330196, -0.5758081914178, -0.5956993044924, -0.6152315905806, -0.6343932841636, -0.6531728429538, -0.6715589548470, -0.6895405447371, -0.7071067811865, -0.7242470829515, -0.7409511253550, -0.7572088465065, -0.7730104533627, -0.7883464276266, -0.8032075314806, -0.8175848131516, -0.8314696123025, -0.8448535652497, -0.8577286100003, -0.8700869911087, -0.8819212643484, -0.8932243011955, -0.9039892931234, -0.9142097557035, -0.9238795325113, -0.9329927988347, -0.9415440651830, -0.9495281805930, -0.9569403357322, -0.9637760657954, -0.9700312531945, -0.9757021300385, -0.9807852804032, -0.9852776423889, -0.9891765099648, -0.9924795345987, -0.9951847266722, -0.9972904566787, -0.9987954562052, -0.9996988186962, -1.0000000000000];
    }

    // modifiers: static
    static public function coslook(a : Float) : Float {
        var d : Float = a * (0.31830989 * Lookup.COS_LOOKUP_SZ);
        var i : Int = Std.int(d);
        return Lookup.COS_LOOKUP()[i] + (d - i * (Lookup.COS_LOOKUP()[i + 1] - Lookup.COS_LOOKUP()[i]));
    }

    inline static var INVSQ_LOOKUP_SZ : Int = 32;
    inline static function INVSQ_LOOKUP() : Array<Float>{
    	return [1.414213562373, 1.392621247646, 1.371988681140, 1.352246807566, 1.333333333333, 1.315191898443, 1.297771369046, 1.281025230441, 1.264911064067, 1.249390095109, 1.234426799697, 1.219988562661, 1.206045378311, 1.192569588000, 1.179535649239, 1.166919931983, 1.154700538379, 1.142857142857, 1.131370849898, 1.120224067222, 1.109400392450, 1.098884511590, 1.088662107904, 1.078719779941, 1.069044967650, 1.059625885652, 1.050451462878, 1.041511287847, 1.032795558989, 1.024295039463, 1.016001016002, 1.007905261358, 1.000000000000];
    }

    // modifiers: static
    static public function invsqlook(a : Float) : Float {
        var d : Float = (a * (2. * Lookup.INVSQ_LOOKUP_SZ)) - Lookup.INVSQ_LOOKUP_SZ;
        var i : Int = Std.int(d);
        return Lookup.INVSQ_LOOKUP()[i] + (d - i * (Lookup.INVSQ_LOOKUP()[i + 1] - Lookup.INVSQ_LOOKUP()[i]));
    }

    inline static var INVSQ2EXP_LOOKUP_MIN : Int = -32;
    inline static var INVSQ2EXP_LOOKUP_MAX : Int = 32;
    inline static function INVSQ2EXP_LOOKUP() : Array<Float> { return [65536., 46340.95001, 32768., 23170.47501, 16384., 11585.2375, 8192., 5792.618751, 4096., 2896.309376, 2048., 1448.154688, 1024., 724.0773439, 512., 362.038672, 256., 181.019336, 128., 90.50966799, 64., 45.254834, 32., 22.627417, 16., 11.3137085, 8., 5.656854249, 4., 2.828427125, 2., 1.414213562, 1., 0.7071067812, 0.5, 0.3535533906, 0.25, 0.1767766953, 0.125, 0.08838834765, 0.0625, 0.04419417382, 0.03125, 0.02209708691, 0.015625, 0.01104854346, 0.0078125, 0.005524271728, 0.00390625, 0.002762135864, 0.001953125, 0.001381067932, 0.0009765625, 0.000690533966, 0.00048828125, 0.000345266983, 0.000244140625, 0.0001726334915, 0.0001220703125, 8.631674575e-05, 6.103515625e-05, 4.315837288e-05, 3.051757812e-05, 2.157918644e-05, 1.525878906e-05];}

    // modifiers: static
    static public function invsq2explook(a : Int) : Float {
        return Lookup.INVSQ2EXP_LOOKUP()[a - Lookup.INVSQ2EXP_LOOKUP_MIN];
    }

    inline static var FROMdB_LOOKUP_SZ : Int = 35;
    inline static var FROMdB2_LOOKUP_SZ : Int = 32;
    inline static var FROMdB_SHIFT : Int = 5;
    inline static var FROMdB2_SHIFT : Int = 3;
    inline static var FROMdB2_MASK : Int = 31;
    inline static function FROMdB_LOOKUP() : Array<Float> { return [1., 0.6309573445, 0.3981071706, 0.2511886432, 0.1584893192, 0.1, 0.06309573445, 0.03981071706, 0.02511886432, 0.01584893192, 0.01, 0.006309573445, 0.003981071706, 0.002511886432, 0.001584893192, 0.001, 0.0006309573445, 0.0003981071706, 0.0002511886432, 0.0001584893192, 0.0001, 6.309573445e-05, 3.981071706e-05, 2.511886432e-05, 1.584893192e-05, 1e-05, 6.309573445e-06, 3.981071706e-06, 2.511886432e-06, 1.584893192e-06, 1e-06, 6.309573445e-07, 3.981071706e-07, 2.511886432e-07, 1.584893192e-07];}
    inline static function FROMdB2_LOOKUP() : Array<Float> { return [0.9928302478, 0.9786445908, 0.9646616199, 0.9508784391, 0.9372921937, 0.92390007, 0.9106992942, 0.8976871324, 0.8848608897, 0.8722179097, 0.8597555737, 0.8474713009, 0.835362547, 0.8234268041, 0.8116616003, 0.8000644989, 0.7886330981, 0.7773650302, 0.7662579617, 0.755309592, 0.7445176537, 0.7338799116, 0.7233941627, 0.7130582353, 0.7028699885, 0.6928273125, 0.6829281272, 0.6731703824, 0.6635520573, 0.6540711597, 0.6447257262, 0.6355138211];}

    // modifiers: static
    static public function fromdBlook(a : Float) : Float {
        var i : Int = Std.int(a * -(1 << Lookup.FROMdB2_SHIFT));
        return (i < 0 ? 1. : (i >= (Lookup.FROMdB_LOOKUP_SZ << Lookup.FROMdB_SHIFT) ? 0. : Lookup.FROMdB_LOOKUP()[i >>> Lookup.FROMdB_SHIFT] * Lookup.FROMdB2_LOOKUP()[i & Lookup.FROMdB2_MASK]));
    }

}

