# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2016-01-25 17:58
from __future__ import unicode_literals

import autoradio.playlists.models
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Configure',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sezione', models.CharField(default=b'playlist', editable=False, max_length=50, unique=True)),
                ('active', models.BooleanField(default=True, help_text='activate/deactivate the intere playlist class', verbose_name='Activate Playlist')),
                ('emission_starttime', models.TimeField(blank=True, help_text='The start time from wich the playlist will be active', null=True, verbose_name='Programmed start time')),
                ('emission_endtime', models.TimeField(blank=True, help_text='The end time the playlist will be active', null=True, verbose_name='Programmed start time')),
            ],
        ),
        migrations.CreateModel(
            name='Giorno',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(choices=[('luned\xec', 'luned\xec'), ('marted\xec', 'marted\xec'), ('mercoled\xec', 'mercoled\xec'), ('gioved\xec', 'gioved\xec'), ('venerd\xec', 'venerd\xec'), ('sabato', 'sabato'), ('domenica', 'domenica')], help_text='weekday name', max_length=20, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='PeriodicSchedule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('shuffle', models.BooleanField(default=True, help_text="Every time the playlist will be scheduled it's order will be randomly changed", verbose_name='Shuffle Playlist on start')),
                ('length', models.FloatField(blank=True, default=None, help_text='If this time is set the playlist will be truncated', null=True, verbose_name='Max time length (seconds)')),
                ('start_date', models.DateField(blank=True, help_text='The playlist will be scheduled starting from this date', null=True, verbose_name='Programmed start date')),
                ('end_date', models.DateField(blank=True, help_text='The playlist will be scheduled ending this date', null=True, verbose_name='Programmed end date')),
                ('time', models.TimeField(blank=True, help_text='This is the time when the playlist will be on air', null=True, verbose_name='Programmed time')),
                ('emission_done', models.DateTimeField(editable=False, null=True, verbose_name='Emission done')),
                ('giorni', models.ManyToManyField(blank=True, help_text='The playlist will be scheduled those weekdays', to='playlists.Giorno', verbose_name='Programmed days')),
            ],
        ),
        migrations.CreateModel(
            name='Playlist',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('playlist', models.CharField(max_length=200, verbose_name='Playlist name')),
                ('file', autoradio.playlists.models.DeletingFileField(help_text='The playlist file to upload, format should be extm3u, m3u, pls', max_length=255, upload_to=b'playlist', verbose_name='File')),
                ('rec_date', models.DateTimeField(help_text='When the playlist was done (for reference only)', verbose_name='Generation date')),
                ('active', models.BooleanField(default=True, help_text='Activate the playlist for emission', verbose_name='Active')),
            ],
        ),
        migrations.CreateModel(
            name='Schedule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('shuffle', models.BooleanField(default=True, help_text="Every time the playlist will be scheduled it's order will be randomly changed", verbose_name='Shuffle Playlist on start')),
                ('length', models.FloatField(blank=True, default=None, help_text='If this time is set the playlist will be truncated', null=True, verbose_name='Max time length (seconds)')),
                ('emission_date', models.DateTimeField(help_text='This is the date and time when the playlist will be on air', verbose_name='Programmed date')),
                ('emission_done', models.DateTimeField(editable=False, null=True, verbose_name='Emission done')),
                ('playlist', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='playlists.Playlist', verbose_name='refer to playlist:')),
            ],
        ),
        migrations.AddField(
            model_name='periodicschedule',
            name='playlist',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='playlists.Playlist', verbose_name='refer to playlist:'),
        ),
    ]
