///////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) Crossbar.io Technologies GmbH and contributors
//
// Boost Software License - Version 1.0 - August 17th, 2003
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
//
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//
///////////////////////////////////////////////////////////////////////////////

#include "wamp_tcp_transport.hpp"

#include <boost/system/error_code.hpp>

namespace autobahn {

inline wamp_tcp_transport::wamp_tcp_transport(
        boost::asio::io_service& io_service,
        const boost::asio::ip::tcp::endpoint& remote_endpoint,
        bool debug_enabled)
    : wamp_rawsocket_transport<boost::asio::ip::tcp::socket>(
            io_service, remote_endpoint, debug_enabled)
{
}

inline wamp_tcp_transport::~wamp_tcp_transport()
{
}

inline boost::future<void> wamp_tcp_transport::connect()
{
    return wamp_rawsocket_transport<boost::asio::ip::tcp::socket>::connect().then(
        [&](boost::future<void> connected) {
            // Check the originating future for exceptions.
            connected.get();

            // Disable naggle for improved performance.
            boost::asio::ip::tcp::no_delay option(true);
            socket().set_option(option);
        }
    );
}

} // namespace autobahn
