
# BUILDING THE NEWICK PARSER FROM SCRATCH
   (not needed unless you run into compiler errors related to 'parse.cc' or 'lex.cc')  

   To parse phylogenetic trees in Newick format, AUGUSTUS-cgp uses a scanner and 
   parser class, generated by Flexc++ and Bisonc++, respectively.  
   These classes are part of the AUGUSTUS package and can be used in most applications 
   without the need for changing them.  
   However, if you have trouble compiling the Augustus source code and the compiler 
   error is related to these classes (parse.cc' and 'lex.cc'), it is recommended 
   to rebuild the scanner and parser class from scratch.  
   The following will give you a step-by-step instruction, how to do this:

   a) installation of Flexc++ and Bisonc++  
   b) creation of a scanner class with Flexc++  
   c) creation of a parser  class with Bisonc++  
   d) recompilation of AUGUSTUS-cgp  

a) installation of Flexc++ and Bisonc++

- Flexc++ (lexical scanner generator, tested with V0.94.0) 

   download source code from http://flexcpp.sourceforge.net/ and follow the installation 
   instructions.  
   (Flexc++ has several dependencies including the bobcat library. I recommend to 
   use bobcat-3.10.00, if you do not want to install the latest g++ compiler)

- Bisonc++ (parser generator, tested with V2.09.03)

   download source code from http://bisoncpp.sourceforge.net/ and follow the installation 
   instructions or, alternatively, install bisonc++ via package manager:
  
    sudo apt-get install bisonc++
  
b) creation of a scanner class with Flexc++:

   Switch to the directory src/scanner/ in your AUGUSTUS folder and compile the 
   file 'lexer' with Flexc++:
  
    flexc++ lexer
  
   The following files are generated: lex.cc scanner.h scanner.ih scannerbase.h  
   Add the include directive '#include "../parser/parserbase.h"' to scanner.ih
  
    echo '#include "../parser/parserbase.h"' >> scanner.ih
  
c) creation of a parser class with Bisonc++

   Switch to the directory src/parser/ in your AUGUSTUS folder and compile 
   the file 'grammar' with Bisonc++
  
    bisonc++ grammar

   The following files are generated: parse.cc parser.h  parser.ih  parserbase.h  
   Edit the 'public' part of parser.h such that it looks as follows

    class Parser: public ParserBase
    {
    public:
        Parser(std::list<Treenode*> *tree, std::vector<std::string> *species, std::istream &in):d_scanner(in), ptree(tree), pspecies(species) {}
        Scanner d_scanner;
        std::list<Treenode*> *ptree;
        std::vector<std::string> *pspecies;

        int parse();

    private:
    ... // more code
    };

d) recompilation of AUGUSTUS-cgp

   Switch to your AUGUSTUS folder and type

    make clean all
