#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/io.h>
#include <string.h>
#include <pci/pci.h>
#include  "athcool.h"

extern struct pci_filter	filter;
extern struct pci_access	*pacc;
extern struct device	*scan_devices( void );

#define B8(y)  ( ((0x##y##L & 0x00000001L) >> 0) \
               | ((0x##y##L & 0x00000010L) >> 3) \
               | ((0x##y##L & 0x00000100L) >> 6) \
               | ((0x##y##L & 0x00001000L) >> 9) \
               | ((0x##y##L & 0x00010000L) >> 12) \
               | ((0x##y##L & 0x00100000L) >> 15) \
               | ((0x##y##L & 0x01000000L) >> 18) \
               | ((0x##y##L & 0x10000000L) >> 21) )

#define B16(h,l)            (B8(h)<<8 | B8(l))
#define B32(hh, hl, lh, ll) (B16(hh, hl)<<16 | B16(lh, ll))

#define TESTBIN32 B32(00000110,00000000,00000000,00000000) /* bit 25 and 26 */

int	main ( int argc, char *argv[] )
{
  struct device *d = NULL;
  int regval_cur;

  /*  printf("0x%08x\n", TESTBIN32);
   
  return 0; */

  
  if ( iopl( 3 ) < 0 ) {
    printf( "%s : must run as root. exit\n", argv[0] );
    exit (1);
  }

  /* init pciutil, and scan devices */
  pacc = pci_alloc();
  pci_filter_init( pacc, &filter );
  pci_init( pacc );

  d = scan_devices();

  regval_cur = pci_read_long( d->dev, 0x60 );

  printf( "reg values in 0x%02X to 0x%02X : 0x%08x\n", 
	  0x60, 0x63, regval_cur);
  /* clean up, exit */
  pci_cleanup( pacc );

  return 0;
}
