subroutine uttr24(vk24, ndim)
! ======================================================================
! COPYRIGHT (C) 1991 - 2012  EDF R&D                  WWW.CODE-ASTER.ORG
! THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
! THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
! (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
! ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
!    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
! ======================================================================
    implicit none
!
!     ARGUMENTS:
!     ----------
    integer :: ndim
    character(len=24) :: vk24(ndim)
! ----------------------------------------------------------------------
!     BUT : TRIER DANS L'ORDRE ALPHABETIQUE UN VECTEUR DE K24
!
!     IN:
!         NDIM : DIMENSION DU TABLEAU A TRIER
!     VAR:
!         VK24 : TABLEAU A TRIER
!
! ----------------------------------------------------------------------
    character(len=24) :: ct
    integer :: i, j
!-----------------------------------------------------------------------
!
! DEB-------------------------------------------------------------------
!
    do 1, i=1,ndim
    do 2, j=i+1,ndim
    if (vk24(j) .lt. vk24(i)) then
!              -- ON PERMUTE I ET J
        ct =vk24(i)
        vk24(i)=vk24(j)
        vk24(j)=ct
    endif
 2  continue
    1 end do
!
end subroutine
