subroutine nrsmtt(troisk, j, epsthe, m)
! ======================================================================
! COPYRIGHT (C) 1991 - 2012  EDF R&D                  WWW.CODE-ASTER.ORG
! THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
! THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
! (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
! ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
!   1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
! ======================================================================
!
    implicit none
!
!
!     BUTS  : CALCUL DU TERME EN THERMIQUE EN J
!             DE L'ENERGIE ELASTIQUE DE SIMO-MIEHE
!     IN  TROISK : 3*MODULE DE COMPRESSIBILITE =E/ ((1.D0-2.D0*NU))
!     IN  J : VARIATION DE VOLUME EN GRANDES DEFORMATIONS = DET (F)
!     IN  EPSTHE : DEFORMATION THERMIQUE =3*alpha*(T-T0)
!     OUT M : VALEUR DU TERME THERMIQUE DE L'ENERGIE ELASTIQUE DE SM
!             M=-3K/2*EPSTHE*(J-1/J)
!
    real(kind=8) :: troisk, j, epsthe, m
!
    m=-troisk/2.d0*epsthe*(j-1/j)
!
end subroutine
