/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.ant.taskdefs;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;

public abstract class ConditionalTask
extends Task {
    public static final String TRUE = "true";
    private List ifs;
    static final String[] falses = new String[]{"false", "no"};
    static final String[] trues = new String[]{"true", "yes"};

    protected List ifs() {
        return this.ifs != null ? this.ifs : (this.ifs = new Vector());
    }

    public If createIf() {
        If i = new If();
        this.ifs().add(i);
        return i;
    }

    public If createIf(String name, String equals, boolean strict) {
        If i = this.createIf();
        i.setName(name);
        i.setEquals(equals);
        i.setStrict(strict);
        return i;
    }

    public If createIf(String name, String equals) {
        return this.createIf(name, equals, false);
    }

    public If createIf(String name) {
        return this.createIf(name, TRUE, false);
    }

    public If createIf(String name, boolean strict) {
        return this.createIf(name, TRUE, strict);
    }

    public void setIfs(String ifs) {
        StringTokenizer tok = new StringTokenizer(ifs, ",;: ", false);
        while (tok.hasMoreTokens()) {
            boolean strict;
            String equals;
            String name;
            String next = tok.nextToken();
            int iequals = next.lastIndexOf("=");
            If i = this.createIf();
            if (iequals != -1) {
                name = next.substring(0, iequals);
                equals = next.substring(iequals + 1);
                strict = true;
            } else {
                name = next.substring(0);
                equals = TRUE;
                strict = false;
            }
            i.setName(name);
            i.setEquals(equals);
            i.setStrict(strict);
        }
    }

    public void setIf(String ifStr) {
        this.setIfs(ifStr);
    }

    protected boolean checkIfs() {
        return this.getFalses().size() == 0;
    }

    protected List getFalses() {
        Iterator iter = this.ifs().iterator();
        Vector<String> result = new Vector<String>();
        while (iter.hasNext()) {
            If next = (If)iter.next();
            String name = next.getName();
            String prop = ((ProjectComponent)this).project.getProperty(name);
            if (prop == null) {
                prop = ((ProjectComponent)this).project.getUserProperty(name);
            }
            if (next.isOk(prop)) continue;
            result.add(name);
        }
        return result;
    }

    public abstract void execute() throws BuildException;

    public class If {
        private String name;
        private String equals;
        private boolean strict = false;

        public If() {
            this(null, null);
        }

        public If(String name) {
            this(name, ConditionalTask.TRUE);
        }

        public If(String name, String equals) {
            this.setName(name);
            this.setEquals(equals);
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setEquals(String equals) {
            this.equals = equals;
        }

        public String getEquals() {
            return this.equals;
        }

        public void setStrict(boolean strict) {
            this.strict = strict;
        }

        public boolean isStrict() {
            return this.strict;
        }

        public boolean isOk(String prop) {
            return this.isOk(prop, this.isStrict());
        }

        public boolean isOk(String prop, boolean isStrict) {
            if (isStrict) {
                return prop != null && prop.equals(this.getEquals());
            }
            if (this.isOk(prop, true)) {
                return true;
            }
            if (prop == null || this.isFalse(this.getEquals())) {
                return true;
            }
            return this.isTrue(this.getEquals()) && this.isTrue(prop) || this.isFalse(this.getEquals()) && this.isFalse(prop);
        }

        private boolean isFalse(String prop) {
            return this.isOneOf(prop, falses) || this.isOneOf(prop, this.complement(trues));
        }

        private boolean isTrue(String prop) {
            return this.isOneOf(prop, trues) || this.isOneOf(prop, this.complement(falses));
        }

        private boolean isOneOf(String prop, String[] strings) {
            for (int i = 0; i < strings.length; ++i) {
                if (!strings[i].equals(prop)) continue;
                return true;
            }
            return false;
        }

        private String[] complement(String[] strings) {
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = "!" + strings[i];
            }
            return strings;
        }
    }
}

