/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.build;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.aspectj.internal.tools.build.Module;

public class Result {
    public static final boolean NORMAL = true;
    public static final boolean ASSEMBLE = true;
    static final Kind RELEASE = new Kind("RELEASE", true, false);
    static final Kind RELEASE_ALL = new Kind("RELEASE_ALL", true, true);
    static final Kind TEST = new Kind("TEST", false, false);
    static final Kind TEST_ALL = new Kind("TEST_ALL", false, true);
    private static final Kind[] KINDS = new Kind[]{RELEASE, TEST, RELEASE_ALL, TEST_ALL};
    private static final HashMap nameToResult = new HashMap();
    private final File outputFile;
    private final List requiredResults;
    private final List libJars;
    private final List classpathVariables;
    transient String toLongString;
    private final List exportedLibJars;
    private final List srcDirs;
    private boolean requiredDone;
    private boolean outOfDate;
    private boolean outOfDateSet;
    private final Kind kind;
    private final Module module;
    private final String name;

    public static boolean isTestingJar(String name) {
        name = name.toLowerCase();
        return "junit.jar".equals(name);
    }

    public static boolean isTestingDir(String name) {
        return "testsrc".equals(name = name.toLowerCase()) || "java5-testsrc".equals(name);
    }

    public static boolean isTestingModule(Module module) {
        String name = module.name.toLowerCase();
        return name.startsWith("testing") || "tests".equals(name);
    }

    public static synchronized Result getResult(String name) {
        if (null == name) {
            throw new IllegalArgumentException("null name");
        }
        return (Result)nameToResult.get(name);
    }

    public static Result[] getResults(String[] names) {
        if (null == names) {
            return new Result[0];
        }
        Result[] results = new Result[names.length];
        for (int i = 0; i < results.length; ++i) {
            String name = names[i];
            if (null == name) {
                String m = "no name at " + i + ": " + Arrays.asList(names);
                throw new IllegalArgumentException(m);
            }
            Result r = Result.getResult(name);
            if (null == r) {
                String m = "no result [" + i + "]: " + name + ": " + Arrays.asList(names);
                throw new IllegalArgumentException(m);
            }
            results[i] = r;
        }
        return results;
    }

    public static Kind[] KINDS() {
        Kind[] result = new Kind[KINDS.length];
        System.arraycopy(KINDS, 0, result, 0, result.length);
        return result;
    }

    public static void iaxUnlessNormal(Result result) {
        if (null == result || !result.getKind().normal) {
            throw new IllegalArgumentException("not normal: " + result);
        }
    }

    public static void iaxUnlessAssembly(Result result) {
        if (null == result || !result.getKind().assemble) {
            throw new IllegalArgumentException("not assembly: " + result);
        }
    }

    public static Kind kind(boolean normal, boolean assemble) {
        return normal ? (assemble ? RELEASE_ALL : RELEASE) : (assemble ? TEST_ALL : TEST);
    }

    Result(Kind kind, Module module, File jarDir) {
        this.kind = kind;
        this.module = module;
        this.libJars = new ArrayList();
        this.exportedLibJars = new ArrayList();
        this.srcDirs = new ArrayList();
        this.classpathVariables = new ArrayList();
        this.requiredResults = new ArrayList();
        String name = module.name;
        if (!kind.normal) {
            name = name + "-test";
        }
        if (kind.assemble) {
            name = name + "-all";
        }
        this.name = name;
        this.outputFile = new File(jarDir, name + ".jar");
        nameToResult.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void clearOutOfDate() {
        this.outOfDateSet = false;
        this.outOfDate = false;
    }

    public boolean outOfDate() {
        if (!this.outOfDateSet) {
            this.outOfDate = Module.outOfDate(this);
            this.outOfDateSet = true;
        }
        return this.outOfDate;
    }

    public List findJarRequirements() {
        ArrayList result = new ArrayList();
        Module.doFindJarRequirements(this, result);
        return result;
    }

    public List getClasspathVariables() {
        return this.safeList(this.classpathVariables);
    }

    public Result[] getRequired() {
        return this.safeResults(this.requiredResults);
    }

    public List getExportedLibJars() {
        return this.safeList(this.exportedLibJars);
    }

    public List getLibJars() {
        this.requiredDone();
        return this.safeList(this.libJars);
    }

    public List getSrcDirs() {
        return this.safeList(this.srcDirs);
    }

    public Module getModule() {
        return this.module;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String toLongString() {
        if (null == this.toLongString) {
            this.toLongString = this.name + "[outputFile=" + this.outputFile + ", requiredResults=" + this.requiredResults + ", srcDirs=" + this.srcDirs + ", libJars=" + this.libJars + "]";
        }
        return this.toLongString;
    }

    public String toString() {
        return this.name;
    }

    private List safeList(List l) {
        this.requiredDone();
        return Collections.unmodifiableList(l);
    }

    private Result[] safeResults(List list) {
        this.requiredDone();
        if (null == list) {
            return new Result[0];
        }
        return list.toArray(new Result[0]);
    }

    private void initSrcDirs() {
        this.srcDirs.addAll(this.getModule().srcDirs(this));
        if (this.getKind().normal) {
            ListIterator iter = this.srcDirs.listIterator();
            while (iter.hasNext()) {
                File srcDir = (File)iter.next();
                if (!Result.isTestingDir(srcDir.getName())) continue;
                iter.remove();
            }
        }
    }

    private void initLibJars() {
        this.libJars.addAll(this.getModule().libJars(this));
        if (this.getKind().normal && !Result.isTestingModule(this.getModule())) {
            ListIterator iter = this.libJars.listIterator();
            while (iter.hasNext()) {
                File libJar = (File)iter.next();
                if (!Result.isTestingJar(libJar.getName())) continue;
                iter.remove();
            }
        }
    }

    private void assertKind(Kind kind) {
        if (kind != this.getKind()) {
            throw new IllegalArgumentException("expected " + this.getKind() + " got " + kind);
        }
    }

    private void initRequiredResults() {
        Module module = this.getModule();
        Kind kind = this.getKind();
        if (kind.assemble) {
            if (kind.normal) {
                this.assertKind(RELEASE_ALL);
                this.requiredResults.add(module.getResult(RELEASE));
            } else {
                this.assertKind(TEST_ALL);
                this.requiredResults.add(module.getResult(TEST));
                this.requiredResults.add(module.getResult(RELEASE));
            }
        } else if (!kind.normal) {
            this.assertKind(TEST);
            this.requiredResults.add(module.getResult(RELEASE));
        } else {
            this.assertKind(RELEASE);
        }
        List modules = module.requiredModules(this);
        boolean adoptTests = !kind.normal || Result.isTestingModule(module);
        Iterator iter = modules.iterator();
        while (iter.hasNext()) {
            Module required = (Module)iter.next();
            if (adoptTests) {
                this.requiredResults.add(required.getResult(TEST));
                this.requiredResults.add(required.getResult(RELEASE));
                continue;
            }
            if (Result.isTestingModule(required)) continue;
            this.requiredResults.add(required.getResult(RELEASE));
        }
    }

    private void initClasspathVariables() {
        this.classpathVariables.addAll(this.getModule().classpathVariables(this));
    }

    private void initExportedLibJars() {
        this.exportedLibJars.addAll(this.getModule().exportedLibJars(this));
    }

    private synchronized void requiredDone() {
        if (!this.requiredDone) {
            this.initSrcDirs();
            this.initLibJars();
            this.initRequiredResults();
            this.initClasspathVariables();
            this.initExportedLibJars();
            this.requiredDone = true;
        }
    }

    public static class Kind {
        final String name;
        final boolean normal;
        final boolean assemble;

        private Kind(String name, boolean normal, boolean assemble) {
            this.name = name;
            this.normal = normal;
            this.assemble = assemble;
        }

        public final boolean isAssembly() {
            return this.assemble;
        }

        public final boolean isNormal() {
            return this.normal;
        }

        public final String toString() {
            return this.name;
        }
    }
}

