/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.aspectj.internal.tools.ant.taskdefs.HeaderInfo;

class Header {
    Header() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replaceHeader(File file, HeaderInfo info) {
        BufferedReader input = null;
        PrintWriter output = null;
        OutputStreamWriter outWriter = null;
        int lineNum = 0;
        boolean result = false;
        File inFile = new File(file.getPath() + ".tmp");
        try {
            String line;
            File outFile = new File(file.getPath());
            if (!file.renameTo(inFile) || !inFile.canRead()) {
                throw new Error("unable to rename " + file + " to " + inFile);
            }
            outWriter = new FileWriter(outFile);
            input = new BufferedReader(new FileReader(inFile));
            output = new PrintWriter((Writer)outWriter, true);
            info.writeHeader(output);
            while (null != (line = input.readLine())) {
                if (++lineNum <= info.lastLine) continue;
                output.println(line);
            }
        }
        catch (IOException e) {
            System.err.println("writing line " + lineNum + " of " + file);
            e.printStackTrace(System.err);
            result = false;
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    result = false;
                }
            }
            if (null != outWriter) {
                try {
                    outWriter.close();
                }
                catch (IOException e) {
                    result = false;
                }
            }
            result = inFile.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HeaderInfo checkFile(File file) {
        ArrayList years = new ArrayList();
        int endLine = 0;
        BufferedReader input = null;
        int lineNum = 0;
        try {
            String line;
            input = new BufferedReader(new FileReader(file));
            while (null != (line = input.readLine())) {
                ++lineNum;
                String ll = line.trim();
                if (!ll.startsWith("package ")) {
                    if (ll.startsWith("import ")) {
                    } else {
                        if (!Header.checkLine(line, years)) continue;
                        endLine = lineNum;
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            System.err.println("reading line " + lineNum + " of " + file);
            e.printStackTrace(System.err);
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        return new HeaderInfo(file, endLine, years, endLine > 0);
    }

    private static boolean checkLine(String line, ArrayList years) {
        int loc;
        if (null == line || 0 == line.length()) {
            return false;
        }
        int start = 0;
        while (-1 != (loc = line.indexOf("199", start)) || -1 != (loc = line.indexOf("200", start))) {
            char c = line.charAt(loc + 3);
            if (c <= '9' && c >= '0') {
                years.add(line.substring(loc, loc + 4));
            }
            start = loc + 4;
        }
        return -1 != line.indexOf("*/");
    }
}

