/*
 * Decompiled with CFR 0.152.
 */
package $installer$.org.aspectj;

import $installer$.org.aspectj.InstallContext;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;

class LaunchScriptMaker {
    static final String toolsPackage = "org.aspectj.tools";
    InstallContext context;

    public LaunchScriptMaker(InstallContext context) {
        this.context = context;
    }

    public void writeAJLaunchScript(String name, boolean isJava5) throws IOException {
        if (!this.context.onUnix()) {
            if (this.context.onOS2()) {
                name = name + ".cmd";
            } else if (this.context.onWindows()) {
                name = name + ".bat";
            }
        }
        File destDir = new File(this.context.getOutputDir(), "bin");
        destDir.mkdirs();
        File file = new File(destDir, name);
        PrintStream ps = this.getPrintStream(file);
        this.writeAJLaunchScriptContent(ps, isJava5);
        ps.close();
        if (this.context.onUnix()) {
            this.makeExecutable(file);
        }
    }

    private void writeAJLaunchScriptContent(PrintStream ps, boolean isJava5) {
        if (this.context.onUnix()) {
            this.writeUnixHeader(ps);
            if (isJava5) {
                this.writeAJ5UnixLaunchLine(ps);
            } else {
                this.writeAJUnixLaunchLine(ps);
            }
        } else {
            this.writeWindowsHeader(ps);
            if (isJava5) {
                this.writeAJ5WindowsLaunchLine(ps);
            } else {
                this.writeAJWindowsLaunchLine(ps);
            }
        }
    }

    private void writeAJWindowsLaunchLine(PrintStream ps) {
        ps.println("\"%JAVA_HOME%\\bin\\java\" -classpath \"%ASPECTJ_HOME%\\lib\\aspectjweaver.jar\" \"-Djava.system.class.loader=org.aspectj.weaver.loadtime.WeavingURLClassLoader\" \"-Daj.class.path=%ASPECTPATH%;%CLASSPATH%\" \"-Daj.aspect.path=%ASPECTPATH%\" " + this.makeScriptArgs(false));
    }

    private void writeAJ5WindowsLaunchLine(PrintStream ps) {
        ps.println("\"%JAVA_HOME%\\bin\\java\" -classpath \"%ASPECTJ_HOME%\\lib\\aspectjweaver.jar;%CLASSPATH%\" \"-javaagent:%ASPECTJ_HOME%\\lib\\aspectjweaver.jar\" " + this.makeScriptArgs(false));
    }

    private void writeAJUnixLaunchLine(PrintStream ps) {
        ps.println("\"$JAVA_HOME/bin/java\" -classpath \"$ASPECTJ_HOME/lib/aspectjweaver.jar\" \"-Djava.system.class.loader=org.aspectj.weaver.loadtime.WeavingURLClassLoader\" \"-Daj.class.path=$ASPECTPATH:$CLASSPATH\" \"-Daj.aspect.path=$ASPECTPATH\" " + this.makeScriptArgs(true));
    }

    private void writeAJ5UnixLaunchLine(PrintStream ps) {
        ps.println("\"$JAVA_HOME/bin/java\" -classpath \"$ASPECTJ_HOME/lib/aspectjweaver.jar:$CLASSPATH\" \"-javaagent:$ASPECTJ_HOME/lib/aspectjweaver.jar\" " + this.makeScriptArgs(true));
    }

    private void writeWindowsHeader(PrintStream ps) {
        ps.println("@echo off");
        ps.println("REM This file generated by AspectJ installer");
        ps.println("REM Created on " + new Date() + " by " + System.getProperty("user.name"));
        ps.println("");
        ps.println("if \"%JAVA_HOME%\" == \"\" set JAVA_HOME=" + this.context.javaPath.getAbsolutePath());
        ps.println("if \"%ASPECTJ_HOME%\" == \"\" set ASPECTJ_HOME=" + this.context.getOutputDir().getAbsolutePath());
        ps.println("");
        ps.println("if exist \"%JAVA_HOME%\\bin\\java.exe\" goto haveJava");
        ps.println("if exist \"%JAVA_HOME%\\bin\\java.bat\" goto haveJava");
        ps.println("if exist \"%JAVA_HOME%\\bin\\java\" goto haveJava");
        ps.println("echo java does not exist as %JAVA_HOME%\\bin\\java");
        ps.println("echo please fix the JAVA_HOME environment variable");
        ps.println(":haveJava");
    }

    private void writeWindowsLaunchLine(String className, PrintStream ps) {
        ps.println("\"%JAVA_HOME%\\bin\\java\" -classpath \"%ASPECTJ_HOME%\\lib\\aspectjtools.jar;%JAVA_HOME%\\lib\\tools.jar;%CLASSPATH%\" -Xmx64M " + className + " " + this.makeScriptArgs(false));
    }

    private void writeUnixHeader(PrintStream ps) {
        File binsh = new File(File.separator + "bin", "sh");
        if (binsh.canRead()) {
            ps.println("#!" + binsh.getPath());
        }
        ps.println("# This file generated by AspectJ installer");
        ps.println("# Created on " + new Date() + " by " + System.getProperty("user.name"));
        ps.println("");
        ps.println("if [ \"$JAVA_HOME\" = \"\" ] ; then JAVA_HOME=" + this.quote(true, false, this.context.javaPath.getAbsolutePath()));
        ps.println("fi");
        ps.println("if [ \"$ASPECTJ_HOME\" = \"\" ] ; then ASPECTJ_HOME=" + this.quote(true, false, this.context.getOutputDir()));
        ps.println("fi");
        ps.println("");
    }

    private void writeUnixLaunchLine(String className, PrintStream ps) {
        String sep = File.pathSeparator;
        ps.println("\"$JAVA_HOME/bin/java\" -classpath \"$ASPECTJ_HOME/lib/aspectjtools.jar" + sep + "$JAVA_HOME/lib/tools.jar" + sep + "$CLASSPATH\"" + " -Xmx64M " + className + " " + this.makeScriptArgs(true));
    }

    private void makeExecutable(File file) {
        try {
            Runtime curRuntime = Runtime.getRuntime();
            curRuntime.exec("chmod 777 " + this.quote(true, false, file));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String makeScriptArgs(boolean unixStyle) {
        if (unixStyle) {
            return "\"$@\"";
        }
        if (this.context.onWindowsPro()) {
            return "%*";
        }
        return "%1 %2 %3 %4 %5 %6 %7 %8 %9";
    }

    private String quote(boolean unixStyle, boolean forceQuotes, File file) {
        return this.quote(unixStyle, forceQuotes, file.getAbsolutePath());
    }

    private String quote(boolean unixStyle, boolean forceQuotes, String s) {
        if (this.context.onWindows() && unixStyle) {
            s = s.replace('\\', '/');
        }
        if (!forceQuotes && s.indexOf(32) == -1) {
            return s;
        }
        return "\"" + s + "\"";
    }

    private File makeScriptFile(String name, boolean unixStyle) throws IOException {
        if (!unixStyle) {
            if (this.context.onOS2()) {
                name = name + ".cmd";
            } else if (this.context.onWindows()) {
                name = name + ".bat";
            }
        }
        File bindir = new File(this.context.getOutputDir(), "bin");
        bindir.mkdirs();
        File file = new File(bindir, name);
        return file;
    }

    private PrintStream getPrintStream(File file) throws IOException {
        return new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    String makeClassPathVar(boolean unixStyle) {
        if (unixStyle) {
            return "$CLASSPATH";
        }
        return "%CLASSPATH%";
    }

    public String makeClassPath(boolean unixStyle) throws IOException {
        return this.context.toolsJarPath.getAbsolutePath() + File.pathSeparator + new File(new File(this.context.getOutputDir(), "lib"), "aspectjtools.jar").getAbsolutePath() + File.pathSeparator + this.makeClassPathVar(unixStyle);
    }

    public void writeScript(String className, PrintStream ps, boolean unixStyle) throws IOException {
        if (unixStyle) {
            this.writeUnixHeader(ps);
            this.writeUnixLaunchLine(className, ps);
        } else {
            this.writeWindowsHeader(ps);
            this.writeWindowsLaunchLine(className, ps);
        }
    }

    public void writeScript(String className, boolean unixStyle) throws IOException {
        File file = this.makeScriptFile(className, unixStyle);
        if (!this.checkExistingFile(file)) {
            return;
        }
        PrintStream ps = this.getPrintStream(file);
        this.writeScript("org.aspectj.tools." + className + ".Main", ps, unixStyle);
        ps.close();
        if (this.context.onUnix()) {
            this.makeExecutable(file);
        }
    }

    public boolean checkExistingFile(File file) {
        if (!file.exists()) {
            return true;
        }
        return this.context.shouldOverwrite(file);
    }

    public void writeScript(String className) throws IOException {
        this.writeScript(className, true);
        if (this.context.onWindows()) {
            this.writeScript(className, false);
        }
    }
}

