// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __smart_ptr_h__
#define __smart_ptr_h__

#include "Puma/RefCnt.h"

namespace Puma {


class SmartPtr {
  RefCnt *_data;

public:
  SmartPtr () : _data ((RefCnt*)0) {}
  ~SmartPtr () { clear (); }
  inline SmartPtr (const SmartPtr &copy);
  SmartPtr (RefCnt *rc) : _data (rc) {}
  inline SmartPtr &operator = (const SmartPtr &copy);

  inline void data (RefCnt *d);
  inline void clear ();
  RefCnt *data () const { return _data; }
  bool is_defined () const { return _data != (RefCnt*)0; }
};

inline SmartPtr::SmartPtr (const SmartPtr &copy) {
  _data = copy._data;
  if (is_defined ())
    _data->ref ();
}


inline SmartPtr &SmartPtr::operator = (const SmartPtr &copy) {
  data (copy._data);
  return *this;
}


inline void SmartPtr::data (RefCnt *d) {
  clear ();
  _data = d;
  if (is_defined ())
    _data->ref ();
}


inline void SmartPtr::clear () {
  if (is_defined ()) {
    _data->deref ();
    if (_data->counter () == 0)
      delete _data;
    _data = (RefCnt*)0;
  }
}

} // namespace Puma

#endif /* __smart_ptr_h__ */
