# Aseprite
*Copyright (C) 2001-2014 David Capello*

> THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY<br/>
> See the [license section](#license) for more information.

## Introduction

**Aseprite** is an open source program to create animated sprites.
Its main features are:

* Sprites are composed by **layers** &amp; **frames** (as separated concepts).
* Supported color modes: **RGBA**, **Indexed** (palettes up to 256
  colors), and Grayscale.
* Load/save sequence of **PNG** files and **GIF** animations (also
  FLC, FLI, JPG, BMP, PCX, TGA).
* Export/import animations to/from **Sprite Sheets**.
* **Tiled** drawing mode, useful to draw **patterns** and textures.
* **Undo/Redo** for every operation.
* Mini-editor with **real-time animation preview**.
* **Multiple editors** support.
* Pixel art specific tools like filled **Contour** &amp; **Polygon**.
* **Onion skinning**

## Issues

There are a list of
[Known Issues](https://github.com/aseprite/aseprite/issues) (things
to be fixed or that aren't yet implemented).

If you found a bug or you have a new idea/feature for the program,
[you can report them](https://github.com/aseprite/aseprite/issues/new).

## Support

You can ask for help in:

* [Aseprite mailing list](http://groups.google.com/group/aseprite-discuss) ([subscribe](mailto:aseprite-discuss+subscribe@googlegroups.com))
* [Twitter](http://twitter.com/aseprite/)
* [Website](http://www.aseprite.org/) (IRC, G+, Facebook, deviantArt, etc.)

## License

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the [GNU General Public License](docs/licenses/GPL.txt)
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
USA

## Authors

* David Capello [davidcapello@gmail.com](mailto:davidcapello@gmail.com) <br />
  Programmer, designer, and maintainer. <br />
  http://dacap.com.ar/
* Ilija Melentijevic <br />
  New GUI skin (from Aseprite 0.8). A lot of good ideas. <br />
  http://ilkke.blogspot.com/ <br />
  http://www.pixeljoint.com/p/9270.htm
* Contributors <br />
  http://code.google.com/p/aseprite/people/list

Thanks to all the people who have contributed ideas, patches, bugs
report, feature requests, donations, and help me developing Aseprite.

## Credits

Aseprite uses libraries or parts of the original source code
of the following projects created by third-parties:

* [Allegro 4](http://alleg.sourceforge.net/) - [allegro4 license](https://github.com/dacap/aseprite/tree/master/docs/licenses/allegro4-LICENSE.txt)
* [curl](http://curl.haxx.se/) - [curl license](https://github.com/dacap/aseprite/tree/master/docs/licenses/curl-LICENSE.txt)
* [FreeType](http://www.freetype.org/) - [FTL license](https://github.com/dacap/aseprite/tree/master/docs/licenses/FTL.txt)
* [giflib](http://sourceforge.net/projects/giflib/) - [giflib license](https://github.com/dacap/aseprite/tree/master/docs/licenses/giflib-LICENSE.txt)
* [GIMP](http://www.gimp.org/) - [GPL license](https://github.com/dacap/aseprite/tree/master/docs/licenses/GPL.txt)
* [GTK+](http://www.gtk.org/) - [LGPL license](https://github.com/dacap/aseprite/tree/master/docs/licenses/LGPL-2.1.txt)
* [Google Test](http://code.google.com/p/googletest/) - [gtest license](https://github.com/dacap/aseprite/tree/master/docs/licenses/gtest-LICENSE.txt)
* [mongoose](https://github.com/valenok/mongoose) - [MIT license](https://github.com/valenok/mongoose/blob/master/LICENSE)
* [libart](http://www.levien.com/libart/) - [LGPL license](https://github.com/dacap/aseprite/tree/master/docs/licenses/LGPL-2.0.txt)
* [libjpeg](http://www.ijg.org/) - [libjpeg license](https://github.com/dacap/aseprite/tree/master/docs/licenses/libjpeg-LICENSE.txt)
* [libpng](http://www.libpng.org/pub/png/) - [libpng license](https://github.com/dacap/aseprite/tree/master/docs/licenses/libpng-LICENSE.txt)
* [loadpng](http://tjaden.strangesoft.net/loadpng/) - [zlib license](https://github.com/dacap/aseprite/tree/master/docs/licenses/ZLIB.txt)
* [tinyxml](http://www.sourceforge.net/projects/tinyxml) - [zlib license](https://github.com/dacap/aseprite/tree/master/docs/licenses/ZLIB.txt)
* [XFree86](http://www.x.org/) - [XFree86 license](https://github.com/dacap/aseprite/tree/master/docs/licenses/XFree86-LICENSE.txt)
* [zlib](http://www.gzip.org/zlib/) - [ZLIB license](https://github.com/dacap/aseprite/tree/master/docs/licenses/ZLIB.txt)

Other parts of code by:

* Gary Oberbrunner <br />
  Code to quantize RGB images with ordered dither method.
