/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 21:26:48 GMT 2018
 */

package uk.ac.sanger.artemis.components.database;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.table.DefaultTableModel;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.gmod.schema.organism.Organism;
import org.gmod.schema.organism.OrganismProp;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.ArtemisMain;
import uk.ac.sanger.artemis.components.database.DatabaseTreeNode;
import uk.ac.sanger.artemis.components.filetree.RemoteFileNode;
import uk.ac.sanger.artemis.io.KeyVector;
import uk.ac.sanger.artemis.util.DatabaseDocument;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class DatabaseTreeNode_ESTest extends DatabaseTreeNode_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn((String) null, (String) null, (String) null).when(organism0).toString();
      doReturn((String) null).when(organism0).getCommonName();
      doReturn((String) null).when(organism0).getGenus();
      doReturn((String) null).when(organism0).getSpecies();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode((String) null, true, organism0, (String) null, databaseDocument0);
      databaseTreeNode0.isLeaf();
      assertEquals("null.null", databaseTreeNode0.getOrganismCommonName());
      assertFalse(databaseTreeNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode(" is not a sub-class of SequenceFormat");
      databaseTreeNode0.getUserName();
      assertFalse(databaseTreeNode0.isExplored());
      assertTrue(databaseTreeNode0.isDirectory());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn((String) null, (String) null, (String) null).when(organism0).toString();
      doReturn((String) null).when(organism0).getCommonName();
      doReturn((String) null).when(organism0).getGenus();
      doReturn((String) null).when(organism0).getSpecies();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("b`|*W'8fOEv!h.7", true, organism0, "", databaseDocument0);
      String string0 = databaseTreeNode0.getUserName();
      assertEquals("null.null", databaseTreeNode0.getOrganismCommonName());
      assertEquals("", string0);
      assertFalse(databaseTreeNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("-4").when(organism0).toString();
      doReturn("KYXY9!G\"}k|Yre").when(organism0).getCommonName();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("", false, organism0, "(SELECT feature_id FROM feature WHERE uniquename='", databaseDocument0);
      String string0 = databaseTreeNode0.getOrganismCommonName();
      assertEquals("(SELECT feature_id FROM feature WHERE uniquename='", databaseTreeNode0.getUserName());
      assertFalse(databaseTreeNode0.isExplored());
      assertEquals("KYXY9!G\"}k|Yre", string0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Organism organism0 = new Organism();
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("E^8A$%Y/%T", true, organism0, ":featureId=", (DatabaseDocument) null);
      databaseTreeNode0.getOrganism();
      assertEquals("null.null", databaseTreeNode0.getOrganismCommonName());
      assertFalse(databaseTreeNode0.isExplored());
      assertEquals(":featureId=", databaseTreeNode0.getUserName());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("QiNcDj-;{ay/ *");
      // Undeclared exception!
      try { 
        databaseTreeNode0.isDataFlavorSupported((DataFlavor) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.database.DatabaseTreeNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("RZ)r");
      // Undeclared exception!
      try { 
        databaseTreeNode0.getTransferData((DataFlavor) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.database.DatabaseTreeNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("");
      databaseTreeNode0.setUserObject(databaseTreeNode0);
      // Undeclared exception!
      try { 
        databaseTreeNode0.getTransferData(databaseTreeNode0.DATABASETREENODE);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.components.database.DatabaseTreeNode cannot be cast to java.lang.String
         //
         verifyException("uk.ac.sanger.artemis.components.database.DatabaseTreeNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode(" is not a sub-class of SequenceFormat");
      // Undeclared exception!
      try { 
        databaseTreeNode0.explore();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.database.DatabaseTreeNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = null;
      try {
        databaseTreeNode0 = new DatabaseTreeNode("", true, (Organism) null, "", (DatabaseDocument) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.database.DatabaseTreeNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode(" is not a sub-class of SequenceFormat");
      databaseTreeNode0.getOrganism();
      assertFalse(databaseTreeNode0.isExplored());
      assertFalse(databaseTreeNode0.isLeaf());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("", "", "", "").when(organism0).toString();
      doReturn("").when(organism0).getCommonName();
      doReturn("[aC!vXUM3{M3C)~o e").when(organism0).getGenus();
      doReturn("[aC!vXUM3{M3C)~o e").when(organism0).getSpecies();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("", false, organism0, "", databaseDocument0);
      databaseTreeNode0.getOrganism();
      assertFalse(databaseTreeNode0.isExplored());
      assertEquals("[aC!vXUM3{M3C)~o e.[aC!vXUM3{M3C)~o e", databaseTreeNode0.getOrganismCommonName());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("genedb_products");
      databaseTreeNode0.getFeatureType();
      assertFalse(databaseTreeNode0.isExplored());
      assertTrue(databaseTreeNode0.isDirectory());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode(" is not a sub-class of SequenceFormat");
      databaseTreeNode0.getFeatureId();
      assertFalse(databaseTreeNode0.isExplored());
      assertFalse(databaseTreeNode0.isLeaf());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("bf@L=Mv:Y\"TN_:D#z").when(organism0).toString();
      doReturn("bf@L=Mv:Y\"TN_:D#z").when(organism0).getCommonName();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode(".qP2:B\"vIH", false, organism0, ".qP2:B\"vIH", databaseDocument0);
      databaseTreeNode0.getUserName();
      assertEquals("bf@L=Mv:Y\"TN_:D#z", databaseTreeNode0.getOrganismCommonName());
      assertFalse(databaseTreeNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("Start_range", "Start_range").when(organism0).toString();
      doReturn("i9!", "H").when(organism0).getCommonName();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("Start_range", true, organism0, "Start_range", databaseDocument0);
      Object object0 = databaseTreeNode0.getTransferData(databaseTreeNode0.STRING_DATA_FLAVOUR);
      assertEquals("H:featureId=null", object0);
      assertFalse(databaseTreeNode0.isExplored());
      assertEquals("i9!", databaseTreeNode0.getOrganismCommonName());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("^FD", "", (String) null, "", "^6vS").when(organism0).toString();
      doReturn("", (String) null).when(organism0).getCommonName();
      doReturn("G3@v", "^FD").when(organism0).getGenus();
      doReturn("G3@v", "^FD").when(organism0).getSpecies();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("", true, organism0, "", databaseDocument0);
      Object object0 = databaseTreeNode0.getTransferData(databaseTreeNode0.STRING_DATA_FLAVOUR);
      assertEquals("^FD.^FD:featureId=null", object0);
      assertFalse(databaseTreeNode0.isExplored());
      assertEquals("G3@v.G3@v", databaseTreeNode0.getOrganismCommonName());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("@(Ke43?").when(organism0).toString();
      doReturn(".Nzy,s/$").when(organism0).getCommonName();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("@(Ke43?", true, organism0, "", databaseDocument0);
      DataFlavor dataFlavor0 = RemoteFileNode.REMOTEFILENODE;
      try { 
        databaseTreeNode0.getTransferData(dataFlavor0);
        fail("Expecting exception: UnsupportedFlavorException");
      
      } catch(UnsupportedFlavorException e) {
         //
         // Remote file
         //
         verifyException("uk.ac.sanger.artemis.components.database.DatabaseTreeNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("@(Ke43?").when(organism0).toString();
      doReturn(".Nzy,s/$").when(organism0).getCommonName();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("@(Ke43?", true, organism0, "", databaseDocument0);
      DataFlavor dataFlavor0 = RemoteFileNode.REMOTEFILENODE;
      boolean boolean0 = databaseTreeNode0.isDataFlavorSupported(dataFlavor0);
      assertFalse(databaseTreeNode0.isExplored());
      assertFalse(boolean0);
      assertEquals(".Nzy,s/$", databaseTreeNode0.getOrganismCommonName());
      assertEquals("", databaseTreeNode0.getUserName());
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("bf@L=Mv:Y\"TN_:D#z").when(organism0).toString();
      doReturn("bf@L=Mv:Y\"TN_:D#z").when(organism0).getCommonName();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode(".qP2:B\"vIH", false, organism0, ".qP2:B\"vIH", databaseDocument0);
      boolean boolean0 = databaseTreeNode0.isDataFlavorSupported(databaseTreeNode0.STRING_DATA_FLAVOUR);
      assertEquals("bf@L=Mv:Y\"TN_:D#z", databaseTreeNode0.getOrganismCommonName());
      assertFalse(databaseTreeNode0.isExplored());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("h6(6BS").when(organism0).toString();
      doReturn("Q7j]Q").when(organism0).getCommonName();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("h6(6BS", true, organism0, "h6(6BS", databaseDocument0);
      boolean boolean0 = databaseTreeNode0.isDataFlavorSupported(databaseTreeNode0.DATABASETREENODE);
      assertFalse(databaseTreeNode0.isExplored());
      assertEquals("Q7j]Q", databaseTreeNode0.getOrganismCommonName());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("bf@L=Mv:Y\"TN_:D#z", ".qP2:B\"vIH").when(organism0).toString();
      doReturn("bf@L=Mv:Y\"TN_:D#z").when(organism0).getCommonName();
      doReturn(57).when(organism0).getOrganismId();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      doReturn((List) null).when(databaseDocument0).getResidueFeatures(anyInt());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode(".qP2:B\"vIH", false, organism0, ".qP2:B\"vIH", databaseDocument0);
      // Undeclared exception!
      try { 
        databaseTreeNode0.explore();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.database.DatabaseTreeNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("", "unfetched").when(organism0).toString();
      doReturn("KYXY9!G\"}k|Yre").when(organism0).getCommonName();
      doReturn(650).when(organism0).getOrganismId();
      KeyVector keyVector0 = new KeyVector();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      doReturn(keyVector0).when(databaseDocument0).getResidueFeatures(anyInt());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("", false, organism0, "(SELECT feature_id FROM feature WHERE uniquename='", databaseDocument0);
      Stack<ArtemisMain> stack0 = new Stack<ArtemisMain>();
      DefaultTableModel defaultTableModel0 = new DefaultTableModel(stack0, 650);
      keyVector0.add((Object) defaultTableModel0);
      // Undeclared exception!
      try { 
        databaseTreeNode0.explore();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // javax.swing.table.DefaultTableModel cannot be cast to org.gmod.schema.sequence.Feature
         //
         verifyException("uk.ac.sanger.artemis.components.database.DatabaseTreeNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("h6(6BS").when(organism0).toString();
      doReturn("Q7j]Q").when(organism0).getCommonName();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("h6(6BS", true, organism0, "h6(6BS", databaseDocument0);
      assertFalse(databaseTreeNode0.isDirectory());
      
      databaseTreeNode0.explore();
      assertFalse(databaseTreeNode0.isExplored());
      assertEquals("Q7j]Q", databaseTreeNode0.getOrganismCommonName());
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode(" is not a sub-class of SequenceFormat");
      boolean boolean0 = databaseTreeNode0.isDirectory();
      assertTrue(boolean0);
      assertFalse(databaseTreeNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("h6(6BS").when(organism0).toString();
      doReturn("Q7j]Q").when(organism0).getCommonName();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("h6(6BS", true, organism0, "h6(6BS", databaseDocument0);
      boolean boolean0 = databaseTreeNode0.isDirectory();
      assertFalse(databaseTreeNode0.isExplored());
      assertEquals("Q7j]Q", databaseTreeNode0.getOrganismCommonName());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("bf@L=Mv:Y\"TN_:D#z").when(organism0).toString();
      doReturn("bf@L=Mv:Y\"TN_:D#z").when(organism0).getCommonName();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode(".qP2:B\"vIH", false, organism0, ".qP2:B\"vIH", databaseDocument0);
      boolean boolean0 = databaseTreeNode0.getAllowsChildren();
      assertTrue(boolean0);
      assertEquals("bf@L=Mv:Y\"TN_:D#z", databaseTreeNode0.getOrganismCommonName());
      assertFalse(databaseTreeNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("h6(6BS").when(organism0).toString();
      doReturn("Q7j]Q").when(organism0).getCommonName();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("h6(6BS", true, organism0, "h6(6BS", databaseDocument0);
      boolean boolean0 = databaseTreeNode0.getAllowsChildren();
      assertEquals("Q7j]Q", databaseTreeNode0.getOrganismCommonName());
      assertFalse(databaseTreeNode0.isExplored());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      // Undeclared exception!
      try { 
        DatabaseTreeNode.setOrganismProps((Set<OrganismProp>) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.database.DatabaseTreeNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("h6(6BS", "ACCESSION   ", "Q7j]Q").when(organism0).toString();
      doReturn("Q7j]Q", "void setPropertyValues(Object, Object[])").when(organism0).getCommonName();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("h6(6BS", true, organism0, "h6(6BS", databaseDocument0);
      DatabaseTreeNode databaseTreeNode1 = (DatabaseTreeNode)databaseTreeNode0.getTransferData(databaseTreeNode0.DATABASETREENODE);
      assertFalse(databaseTreeNode1.isExplored());
      assertFalse(databaseTreeNode0.isExplored());
      assertEquals("void setPropertyValues(Object, Object[])", databaseTreeNode1.getOrganismCommonName());
      assertFalse(databaseTreeNode1.isLeaf());
      assertFalse(databaseTreeNode0.isDirectory());
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode(" is not a sub-class of SequenceFormat");
      databaseTreeNode0.getOrganismCommonName();
      assertFalse(databaseTreeNode0.isExplored());
      assertTrue(databaseTreeNode0.isDirectory());
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode(" is not a sub-class of SequenceFormat");
      boolean boolean0 = databaseTreeNode0.isExplored();
      assertFalse(boolean0);
      assertTrue(databaseTreeNode0.isDirectory());
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("bf@L=Mv:Y\"TN_:D#z").when(organism0).toString();
      doReturn("bf@L=Mv:Y\"TN_:D#z").when(organism0).getCommonName();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode(".qP2:B\"vIH", false, organism0, ".qP2:B\"vIH", databaseDocument0);
      DatabaseDocument databaseDocument1 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      databaseTreeNode0.setDbDoc(databaseDocument1);
      assertEquals("bf@L=Mv:Y\"TN_:D#z", databaseTreeNode0.getOrganismCommonName());
      assertTrue(databaseTreeNode0.isDirectory());
      assertFalse(databaseTreeNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("bf@L=Mv:Y\"TN_:D#z").when(organism0).toString();
      doReturn("bf@L=Mv:Y\"TN_:D#z").when(organism0).getCommonName();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode(".qP2:B\"vIH", false, organism0, ".qP2:B\"vIH", databaseDocument0);
      boolean boolean0 = databaseTreeNode0.isLeaf();
      assertFalse(boolean0);
      assertFalse(databaseTreeNode0.isExplored());
      assertEquals("bf@L=Mv:Y\"TN_:D#z", databaseTreeNode0.getOrganismCommonName());
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode(" is not a sub-class of SequenceFormat");
      DatabaseTreeNode databaseTreeNode1 = (DatabaseTreeNode)databaseTreeNode0.getTransferData(databaseTreeNode0.DATABASETREENODE);
      assertFalse(databaseTreeNode1.isExplored());
      assertFalse(databaseTreeNode0.isLeaf());
      assertFalse(databaseTreeNode1.isLeaf());
      assertFalse(databaseTreeNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("-4", "unfetched", "", (String) null).when(organism0).toString();
      doReturn("KYXY9!G\"}k|Yre", "").when(organism0).getCommonName();
      doReturn("traatinTable").when(organism0).getGenus();
      doReturn(".b&w").when(organism0).getSpecies();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("", false, organism0, "(SELECT feature_id FROM feature WHERE uniquename='", databaseDocument0);
      Object object0 = databaseTreeNode0.getTransferData(databaseTreeNode0.STRING_DATA_FLAVOUR);
      assertEquals("traatinTable..b&w:featureId=null", object0);
      assertEquals("KYXY9!G\"}k|Yre", databaseTreeNode0.getOrganismCommonName());
      assertFalse(databaseTreeNode0.isExplored());
      assertEquals("(SELECT feature_id FROM feature WHERE uniquename='", databaseTreeNode0.getUserName());
      assertFalse(databaseTreeNode0.isLeaf());
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("-4").when(organism0).toString();
      doReturn("KYXY9!G\"}k|Yre").when(organism0).getCommonName();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("", false, organism0, "(SELECT feature_id FROM feature WHERE uniquename='", databaseDocument0);
      databaseTreeNode0.getTransferDataFlavors();
      assertEquals("KYXY9!G\"}k|Yre", databaseTreeNode0.getOrganismCommonName());
      assertFalse(databaseTreeNode0.isExplored());
      assertEquals("(SELECT feature_id FROM feature WHERE uniquename='", databaseTreeNode0.getUserName());
      assertFalse(databaseTreeNode0.isLeaf());
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      Organism organism0 = mock(Organism.class, new ViolatedAssumptionAnswer());
      doReturn("-4", (String) null).when(organism0).toString();
      doReturn("KYXY9!G\"}k|Yre").when(organism0).getCommonName();
      doReturn(0).when(organism0).getOrganismId();
      KeyVector keyVector0 = new KeyVector();
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      doReturn((List) null).when(databaseDocument0).getResidueFeatures(anyInt());
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("", false, organism0, "(SELECT feature_id FROM feature WHERE uniquename='", databaseDocument0);
      assertFalse(databaseTreeNode0.isExplored());
      
      // Undeclared exception!
      try { 
        databaseTreeNode0.explore();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.database.DatabaseTreeNode", e);
      }
  }
}
