/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 22:13:32 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.InputStream;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Logger;
import uk.ac.sanger.artemis.ProcessMonitor;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class ProcessMonitor_ESTest extends ProcessMonitor_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      InputStream inputStream0 = mock(InputStream.class, new ViolatedAssumptionAnswer());
      Process process0 = mock(Process.class, new ViolatedAssumptionAnswer());
      doReturn(inputStream0).when(process0).getErrorStream();
      doReturn((InputStream) null).when(process0).getInputStream();
      Logger logger0 = mock(Logger.class, new ViolatedAssumptionAnswer());
      ProcessMonitor processMonitor0 = new ProcessMonitor(process0, "cannot read the errer stream from ", logger0);
      // Undeclared exception!
      try { 
        processMonitor0.run();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.Reader", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      InputStream inputStream0 = mock(InputStream.class, new ViolatedAssumptionAnswer());
      InputStream inputStream1 = mock(InputStream.class, new ViolatedAssumptionAnswer());
      InputStream inputStream2 = mock(InputStream.class, new ViolatedAssumptionAnswer());
      InputStream inputStream3 = mock(InputStream.class, new ViolatedAssumptionAnswer());
      Process process0 = mock(Process.class, new ViolatedAssumptionAnswer());
      doReturn(inputStream0, inputStream2, inputStream2, inputStream3).when(process0).getErrorStream();
      doReturn(inputStream1, inputStream2, inputStream2, inputStream3).when(process0).getInputStream();
      doReturn(128, 128, 128, 0).when(process0).waitFor();
      Logger logger0 = mock(Logger.class, new ViolatedAssumptionAnswer());
      ProcessMonitor processMonitor0 = new ProcessMonitor(process0, "cannot read the errer stream from ", logger0);
      processMonitor0.run();
      processMonitor0.run();
      processMonitor0.run();
      processMonitor0.run();
      assertFalse(processMonitor0.isInterrupted());
  }
}
