/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:33:33 GMT 2018
 */

package uk.ac.sanger.artemis.sequence;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerChangeEvent;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class Marker_ESTest extends Marker_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("RMZ<>;");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      Marker marker1 = feature0.getFirstCodingBaseMarker();
      boolean boolean0 = marker0.equals(marker1);
      assertNotSame(marker1, marker0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("RMZ<>;");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      Strand strand0 = new Strand(bases0, 0);
      MarkerChangeEvent markerChangeEvent0 = new MarkerChangeEvent(marker0, strand0, 0);
      marker0.fireEvent(markerChangeEvent0);
      assertEquals(0, Marker.LISTENER_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("DELETE FROM feature WHERE uniquename='", (String) null);
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = new Strand(bases0, 2);
      Marker marker0 = new Marker(strand0, 1);
      Marker marker1 = marker0.moveBy(2);
      assertEquals(3, marker1.getPosition());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("DELETE FROM feature WHERE uniquename='", (String) null);
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = new Strand(bases0, 2);
      Marker marker0 = strand0.makeMarkerFromRawPosition(1);
      try { 
        marker0.setRawPosition(1500);
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // position: -1461
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("MZ<>;");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      try { 
        marker0.setPosition((-2));
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // position: -2
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      // Undeclared exception!
      try { 
        Marker.getRawLowest((Marker) null, (Marker) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Marker", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("RMZ<>;");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      // Undeclared exception!
      try { 
        marker0.equals((Marker) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Marker", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Marker marker0 = null;
      try {
        marker0 = new Marker((Strand) null, (-6516));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("RMZ<>;");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      marker0.addMarkerChangeListener(feature0);
      assertEquals(0, Marker.LISTENER_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("RMZ<>;");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      int int0 = marker0.getRawPosition();
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("RMZ<>;");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      int int0 = marker0.getPosition();
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("RMZ<>;");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      Strand strand0 = marker0.getStrand();
      assertEquals(0, strand0.getTCount());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("RMZ<>;");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      Marker marker1 = Marker.getRawLowest(marker0, marker0);
      assertSame(marker0, marker1);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("RMZ<>;");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getPositionInSequence(5);
      marker0.removeMarkerChangeListener(feature0);
      assertEquals(5, marker0.getPosition());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("RMZ<>;");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      marker0.removeMarkerChangeListener(feature0);
      assertEquals(1, marker0.getPosition());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("RMZ<>;");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      Marker marker1 = feature0.getLastBaseMarker();
      boolean boolean0 = marker0.equals(marker1);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("RMZ<>;");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      try { 
        marker0.moveBy((-5));
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // position: -4
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("RMZ<>;");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      marker0.finalize();
      assertEquals(0, Marker.LISTENER_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("RMZ<>;");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      marker0.setPosition(1);
      assertEquals(1, marker0.getPosition());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("RMZ<>;");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      marker0.setRawPosition(1);
  }
}
